C***** NCF_RDPTGRP
c
      subroutine ncf_rdptgrp(igroup,numcls,emscls,izcel)
      use chmstry
      use filunit
      use tracer
      implicit none
c
c     Copyright 1996 - 2018
c     Ramboll
c
c----CAMx v7Beta6 190902
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'camx.prm'
      include 'camx.inc'
      include 'flags.inc'
      include 'netcdf.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer igroup
      integer numcls
      real    emscls(MXTRCLS,*)
      integer izcel(*)
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer istrln
      integer ncf_get_tstep
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*200 action, fname
      character*10  this_var
      integer       this_tstep, ierr, ispc, idxfile, iounit, idxbase
      integer       this_time_tflag, this_time_etflag, num_ptsfiles
      integer       idxpt, this_varid, data_start(2), data_count(2)
      integer       icls
c
      real,    allocatable, dimension(:) ::  emispts
      integer, allocatable, dimension(:) ::  sa_region
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c   --- skip if filename not supplied ---
c
      num_ptsfiles = num_iortpt(igroup)
      if( igroup .EQ. 0 ) num_ptsfiles = npoint_files
      do idxfile=1,num_ptsfiles
         if( .NOT. ltptfl(igroup,idxfile) ) cycle
         write(action,'(2A,I3,A,I3)') 'Reading the SA NetCDF point source',
     &            ' emissions file for Group: ',igroup,' File: ',idxfile
c
c   --- set the unit number for file ---
c
         if( igroup .EQ. 0 ) then
             iounit = iptem(idxfile)
             write(fname,'(A,I3)') 'PTSOURCE -- UNIT ',iptem(idxfile)
             if( .NOT. is_netcdf_iptem(idxfile) ) cycle
         else
             if( .NOT. is_netcdf_iortpt(igroup,idxfile) ) cycle
             iounit = iortpt(igroup,idxfile)
             fname = tptfil(igroup,idxfile)
         endif
c
c  ---- allocate the temporary array ---
c
         allocate( emispts(nptsrc_safile(igroup,idxfile)) )
         allocate( sa_region(nptsrc_safile(igroup,idxfile)) )
c
c  ---- get the region override flag ---
c
         sa_region = 0
         this_var = 'saoverride'
         ierr = nf_inq_varid(iounit, this_var, this_varid)
         if( ierr .NE. NF_NOERR ) cycle
         ierr = nf_get_var_int(iounit,this_varid,sa_region)
         if( ierr .NE. NF_NOERR ) goto 7001
         do idxpt=1,nptsrc_safile(igroup,idxfile)
            idxbase = idx_point_in_list(igroup,idxfile,idxpt)
            if( sa_region(idxpt) .GT. 0 ) izcel(idxbase) = -sa_region(idxpt)
         enddo
c
c  ---- get the index for timestep containing this time ----
c
         this_tstep = ncf_get_tstep(iounit,action,date,time,
     &               this_time_tflag,this_time_etflag,le1day,.TRUE.)
c
c   --- set the indexes for what to read ---
c
         data_start(1) = 1
         data_count(1) = nptsrc_safile(igroup,idxfile)
         data_start(2) = this_tstep
         data_count(2) = 1
c
c   --- read the emissions for this hour ---
c
         do ispc=1,nspec
             if( lemmap(ispc) .LE. 0 ) cycle
             if( .NOT. lusespc(ispc) ) cycle
c
c  --- load data into temporary arrray ---
c
             this_var = emspcname(lemmap(ispc))
             ierr = nf_inq_varid(iounit, this_var, this_varid)
             if( ierr .NE. NF_NOERR) cycle
             ierr = nf_get_vara_real(iounit,this_varid,data_start,
     &                                               data_count,emispts)
             if( ierr .NE. NF_NOERR) goto 7001
c
c   --- loop over points in this file and get index to regular model ---
c
              do idxpt=1,nptsrc_safile(igroup,idxfile)
                emispts(idxpt) = emispts(idxpt)/(60.*dtems)
                idxbase = idx_point_in_list(igroup,idxfile,idxpt)
c
c   --- load into the tracer emissions array ---
c
                do icls=1,ntrcls
c
c   --- if this is the NOx emissions tracer and this is a 
c       PiG source, skip it (PiG treated elsewhere) ---
c
                   if( lpigsa(idxbase) ) cycle
                   emscls(icls,idxbase) = emscls(icls,idxbase) + 
     &                              emispts(idxpt) * trspmap(ispc,icls)
                enddo
              enddo
c
c   --- next species ---
c
         enddo
c
c   --- next file ---
c
         deallocate( emispts )
         deallocate( sa_region )
      enddo
c
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(iout,'(//,a)') 'ERROR in NCF_RDPTGRP: '
      write(iout,'(A)') action(:istrln(action))
      write(iout,'(2A)') 'Cannot find variable id for: ',
     &                                      this_var(:istrln(this_var))
      call camxerr()
c
 7001 continue
      write(iout,'(//,a)') 'ERROR in NCF_RDPTGRP: '
      write(iout,'(A)') action(:istrln(action))
      write(iout,'(2A)') 'Cannot read data for variable: ',
     &                                      this_var(:istrln(this_var))
      call camxerr()
c
 9999 continue
c
      return
      end
