#!/bin/csh -f

set label = masked
set gzip_output = N

foreach sector (onroad_can)

#set indir = /work/EMIS/em_v7.2/regionalhaze/2028fg_16j/premerged/$sector
set indir = /work/EMIS/em_v7.2/2016platform/2028ff_16j/premerged/$sector
set outdir = /work/EMIS/em_v7.2/regionalhaze/2028fg_secsa_16j/premerged/$sector
if (! -e $outdir) mkdir -p $outdir

set dimon = (31 29 31 30 31 30 31 31 30 31 30 31)

set mon = 1
while ($mon <= 12)
    if ($mon < 10) then
        set MM = 0${mon}
    else
        set MM = $mon
    endif
    set day = 1
    while ($day <= $dimon[$mon])
        if ($day < 10) then
            set DD = 0${day}
        else
            set DD = $day
        endif
        set gday = 2016${MM}${DD}
        set infile = $indir/emis_mole_${sector}_${gday}_36US3_cmaq_cb6_2028ff_16j.ncf
        set outfile = $outdir/emis_mole_${sector}_${label}_${gday}_36US3_cmaq_cb6_2028fg_secsa_16j.ncf
        set tmp = $outdir/masking_temp_file_$$.ncf
        if (-e $infile) then
	    ln -s $infile $tmp
	else if (-e $infile.gz) then
	    zcat ${infile}.gz > $tmp
	else
	    echo "skipping day $gday"
	    @ day++
	    continue
	endif
        /usr/local/apps/anaconda/4.4.0/anaconda3/bin/python -u /work/EMIS/users/bte/WO146.7_haze2016fg/ptfire_othna/mask_grid.py $tmp $outfile
        if ($gzip_output == Y) then
	    gzip -v $outfile
	endif
        @ day++
	rm $tmp
    end
    @ mon++
end

end # foreach sector
