      subroutine hddmjac5(njac,nrxn,H2O,M,O2,CH4,H2,flg,jac,y,rk)
      implicit none
c
c----CAMx v7Beta2 190506
c
c     HDDMJAC5 computes a full Jacobian for HDDM
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        none
c
c     Called by:
c        HDDMCHEM
c
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
      integer njac, nrxn, i, j
      real H2O, M, O2, CH4, H2, N2, flg
      real jac(njac+1,njac+1), y(njac+1), rk(nrxn)
c
c --- Entry point
c
      N2  = M - O2
c

          JAC(lNO2 ,lNO2 )= +         rk(  1)*flg
     &                      +         rk(  5)    *y(lO3P)
     &                      +         rk(  6)    *y(lO3P)
     &                      +         rk(  8)    *y(lO3)
     &                      +         rk( 11)    *y(lNO3)
     &                      +         rk( 15)    *y(lNO3)
     &                      +(-1.000)*rk( 15)    *y(lNO3)
     &                      +         rk( 25)    *y(lOH)
     &                      +         rk( 32)    *y(lHO2)
          JAC(lNO2 ,lNO2 )=JAC(lNO2 ,lNO2 )
     &                      +         rk( 63)    *y(lMCO3)
     &                      +         rk( 73)    *y(lRCO3)
     &                      +         rk( 84)    *y(lBZC3)
     &                      +         rk( 96)    *y(lMAC3)
     &                      +         rk(109)    *y(lTBUO)
     &                      +         rk(111)    *y(lBZO)
          JAC(lNO2 ,lNO  )= +(-1.000)*rk(  4)    *y(lO3P)
     &                      +(-1.000)*rk(  7)    *y(lO3)
     &                      +(-2.000)*rk(  9)    *y(lNO3)
     &                      +(-4.000)*rk( 10)    *y(lNO)*O2
     &                      +(-1.000)*rk( 31)    *y(lHO2)
     &                      +(-1.000)*rk( 46)    *y(lMEO2)
     &                      +(-1.000)*rk( 52)    *y(lRO2C)
     &                      +(-1.000)*rk( 66)    *y(lMCO3)
     &                      +(-1.000)*rk( 76)    *y(lRCO3)
          JAC(lNO2 ,lNO  )=JAC(lNO2 ,lNO  )
     &                      +(-1.000)*rk( 87)    *y(lBZC3)
     &                      +(-1.000)*rk( 99)    *y(lMAC3)
     &                      +(-1.000)*rk(134)    *y(lXNO2)
          JAC(lNO2 ,lO3P )= +(-1.000)*rk(  4)    *y(lNO)
     &                      +         rk(  5)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO2)
          JAC(lNO2 ,lO3  )= +(-1.000)*rk(  7)    *y(lNO)
     &                      +         rk(  8)    *y(lNO2)
          JAC(lNO2 ,lNO3 )= +(-2.000)*rk(  9)    *y(lNO)
     &                      +         rk( 11)    *y(lNO2)
     &                      +         rk( 15)    *y(lNO2)
     &                      +(-1.000)*rk( 15)    *y(lNO2)
     &                      +(-1.000)*rk( 17)*flg
     &                      +(-1.000)*rk( 26)    *y(lOH)
     &                      +(-0.800)*rk( 39)    *y(lHO2)
     &                      +(-4.000)*rk( 40)    *y(lNO3)
     &                      +(-1.000)*rk( 49)    *y(lMEO2)
          JAC(lNO2 ,lNO3 )=JAC(lNO2 ,lNO3 )
     &                      +(-1.000)*rk( 54)    *y(lRO2C)
     &                      +(-1.000)*rk( 59)    *y(lRO2X)
     &                      +(-1.000)*rk( 68)    *y(lMCO3)
     &                      +(-1.000)*rk( 78)    *y(lRCO3)
     &                      +(-1.000)*rk( 89)    *y(lBZC3)
     &                      +(-1.000)*rk(101)    *y(lMAC3)
     &                      +(-1.000)*rk(136)    *y(lXNO2)
          JAC(lNO2 ,lN2O5)= +(-1.000)*rk( 12)*flg
          JAC(lNO2 ,lHNO3)= +(-1.000)*rk( 28)*flg
          JAC(lNO2 ,lOH  )= +(-1.000)*rk( 24)    *y(lHONO)
     &                      +         rk( 25)    *y(lNO2)
     &                      +(-1.000)*rk( 26)    *y(lNO3)
     &                      +(-1.000)*rk( 35)    *y(lPNA)
     &                      +(-0.019)*rk(269)    *y(lRNO3)
          JAC(lNO2 ,lHONO)= +(-1.000)*rk( 24)    *y(lOH)
          JAC(lNO2 ,lHO2 )= +(-1.000)*rk( 31)    *y(lNO)
     &                      +         rk( 32)    *y(lNO2)
     &                      +(-0.800)*rk( 39)    *y(lNO3)
          JAC(lNO2 ,lPNA )= +(-1.000)*rk( 33)*flg
     &                      +(-0.610)*rk( 34)*flg
     &                      +(-1.000)*rk( 35)    *y(lOH)
          JAC(lNO2 ,lMEO2)= +(-1.000)*rk( 46)    *y(lNO)
     &                      +(-1.000)*rk( 49)    *y(lNO3)
     &                      +(-0.500)*rk(137)    *y(lXNO2)
          JAC(lNO2 ,lRO2C)= +(-1.000)*rk( 52)    *y(lNO)
     &                      +(-1.000)*rk( 54)    *y(lNO3)
     &                      +(-0.500)*rk(138)    *y(lXNO2)
          JAC(lNO2 ,lRO2X)= +(-1.000)*rk( 59)    *y(lNO3)
     &                      +(-0.500)*rk(139)    *y(lXNO2)
          JAC(lNO2 ,lMCO3)= +         rk( 63)    *y(lNO2)
     &                      +(-1.000)*rk( 66)    *y(lNO)
     &                      +(-1.000)*rk( 68)    *y(lNO3)
     &                      +(-1.000)*rk(140)    *y(lXNO2)
          JAC(lNO2 ,lPAN )= +(-1.000)*rk( 64)*flg
     &                      +(-0.600)*rk( 65)*flg
          JAC(lNO2 ,lRCO3)= +         rk( 73)    *y(lNO2)
     &                      +(-1.000)*rk( 76)    *y(lNO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +(-1.000)*rk(141)    *y(lXNO2)
          JAC(lNO2 ,lPAN2)= +(-1.000)*rk( 74)*flg
     &                      +(-0.600)*rk( 75)*flg
          JAC(lNO2 ,lBZC3)= +         rk( 84)    *y(lNO2)
     &                      +(-1.000)*rk( 87)    *y(lNO)
     &                      +(-1.000)*rk( 89)    *y(lNO3)
     &                      +(-1.000)*rk(142)    *y(lXNO2)
          JAC(lNO2 ,lPBZN)= +(-1.000)*rk( 85)*flg
     &                      +(-0.600)*rk( 86)*flg
          JAC(lNO2 ,lBZO )= +         rk(111)    *y(lNO2)
          JAC(lNO2 ,lMAC3)= +         rk( 96)    *y(lNO2)
     &                      +(-1.000)*rk( 99)    *y(lNO)
     &                      +(-1.000)*rk(101)    *y(lNO3)
     &                      +(-1.000)*rk(143)    *y(lXNO2)
          JAC(lNO2 ,lMPAN)= +(-1.000)*rk( 97)*flg
     &                      +(-0.600)*rk( 98)*flg
          JAC(lNO2 ,lTBUO)= +         rk(109)    *y(lNO2)
          JAC(lNO2 ,lRNO3)= +(-0.019)*rk(269)    *y(lOH)
     &                      +(-1.000)*rk(270)*flg
          JAC(lNO2 ,lXNO2)= +(-1.000)*rk(134)    *y(lNO)
     &                      +(-1.000)*rk(136)    *y(lNO3)
     &                      +(-0.500)*rk(137)    *y(lMEO2)
     &                      +(-0.500)*rk(138)    *y(lRO2C)
     &                      +(-0.500)*rk(139)    *y(lRO2X)
     &                      +(-1.000)*rk(140)    *y(lMCO3)
     &                      +(-1.000)*rk(141)    *y(lRCO3)
     &                      +(-1.000)*rk(142)    *y(lBZC3)
     &                      +(-1.000)*rk(143)    *y(lMAC3)
          JAC(lNO  ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +(-1.000)*rk(  5)    *y(lO3P)
     &                      +(-1.000)*rk( 15)    *y(lNO3)
          JAC(lNO  ,lNO  )= +         rk(  4)    *y(lO3P)
     &                      +         rk(  7)    *y(lO3)
     &                      +         rk(  9)    *y(lNO3)
     &                      +( 4.000)*rk( 10)    *y(lNO)*O2
     &                      +         rk( 22)    *y(lOH)
     &                      +         rk( 31)    *y(lHO2)
     &                      +         rk( 46)    *y(lMEO2)
     &                      +         rk( 52)    *y(lRO2C)
     &                      +         rk( 57)    *y(lRO2X)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk( 66)    *y(lMCO3)
     &                      +         rk( 76)    *y(lRCO3)
     &                      +         rk( 87)    *y(lBZC3)
     &                      +         rk( 99)    *y(lMAC3)
     &                      +         rk(114)    *y(lXHO2)
     &                      +(-1.000)*rk(114)    *y(lXHO2)
     &                      +         rk(124)    *y(lXOH)
     &                      +(-1.000)*rk(124)    *y(lXOH)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(134)    *y(lXNO2)
     &                      +(-1.000)*rk(134)    *y(lXNO2)
     &                      +         rk(144)    *y(lXMEO)
     &                      +(-1.000)*rk(144)    *y(lXMEO)
     &                      +         rk(154)    *y(lXMC3)
     &                      +(-1.000)*rk(154)    *y(lXMC3)
     &                      +         rk(164)    *y(lXRC3)
     &                      +(-1.000)*rk(164)    *y(lXRC3)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(174)    *y(lXMA3)
     &                      +(-1.000)*rk(174)    *y(lXMA3)
     &                      +         rk(184)    *y(lXTBU)
     &                      +(-1.000)*rk(184)    *y(lXTBU)
     &                      +         rk(194)    *y(lXCO)
     &                      +(-1.000)*rk(194)    *y(lXCO)
     &                      +         rk(283)    *y(lXHCH)
     &                      +(-1.000)*rk(283)    *y(lXHCH)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(293)    *y(lXCCH)
     &                      +(-1.000)*rk(293)    *y(lXCCH)
     &                      +         rk(303)    *y(lXRCH)
     &                      +(-1.000)*rk(303)    *y(lXRCH)
     &                      +         rk(313)    *y(lXACE)
     &                      +(-1.000)*rk(313)    *y(lXACE)
     &                      +         rk(323)    *y(lXMEK)
     &                      +(-1.000)*rk(323)    *y(lXMEK)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(333)    *y(lXPD2)
     &                      +(-1.000)*rk(333)    *y(lXPD2)
     &                      +         rk(343)    *y(lXGLY)
     &                      +(-1.000)*rk(343)    *y(lXGLY)
     &                      +         rk(353)    *y(lXMGL)
     &                      +(-1.000)*rk(353)    *y(lXMGL)
     &                      +         rk(363)    *y(lXBAC)
     &                      +(-1.000)*rk(363)    *y(lXBAC)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(373)    *y(lXBAL)
     &                      +(-1.000)*rk(373)    *y(lXBAL)
     &                      +         rk(383)    *y(lXAF1)
     &                      +(-1.000)*rk(383)    *y(lXAF1)
     &                      +         rk(393)    *y(lXAF2)
     &                      +(-1.000)*rk(393)    *y(lXAF2)
     &                      +         rk(403)    *y(lXAF3)
     &                      +(-1.000)*rk(403)    *y(lXAF3)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(413)    *y(lXMAC)
     &                      +(-1.000)*rk(413)    *y(lXMAC)
     &                      +         rk(423)    *y(lXMVK)
     &                      +(-1.000)*rk(423)    *y(lXMVK)
     &                      +         rk(433)    *y(lXIPR)
     &                      +(-1.000)*rk(433)    *y(lXIPR)
     &                      +         rk(443)    *y(lXRN3)
     &                      +(-1.000)*rk(443)    *y(lXRN3)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(453)    *y(lYRPX)
     &                      +(-1.000)*rk(453)    *y(lYRPX)
     &                      +         rk(463)    *y(lY6PX)
     &                      +(-1.000)*rk(463)    *y(lY6PX)
     &                      +         rk(473)    *y(lYAPX)
     &                      +(-1.000)*rk(473)    *y(lYAPX)
     &                      +         rk(483)    *y(lZRN3)
     &                      +(-1.000)*rk(483)    *y(lZRN3)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(493)    *y(lXGLD)
     &                      +(-1.000)*rk(493)    *y(lXGLD)
     &                      +         rk(503)    *y(lXACR)
     &                      +(-1.000)*rk(503)    *y(lXACR)
          JAC(lNO  ,lO3P )= +         rk(  4)    *y(lNO)
     &                      +(-1.000)*rk(  5)    *y(lNO2)
          JAC(lNO  ,lO3  )= +         rk(  7)    *y(lNO)
          JAC(lNO  ,lNO3 )= +         rk(  9)    *y(lNO)
     &                      +(-1.000)*rk( 15)    *y(lNO2)
     &                      +(-1.000)*rk( 16)*flg
          JAC(lNO  ,lOH  )= +         rk( 22)    *y(lNO)
          JAC(lNO  ,lHONO)= +(-1.000)*rk( 23)*flg
          JAC(lNO  ,lHO2 )= +         rk( 31)    *y(lNO)
          JAC(lNO  ,lMEO2)= +         rk( 46)    *y(lNO)
          JAC(lNO  ,lRO2C)= +         rk( 52)    *y(lNO)
          JAC(lNO  ,lRO2X)= +         rk( 57)    *y(lNO)
          JAC(lNO  ,lMCO3)= +         rk( 66)    *y(lNO)
          JAC(lNO  ,lRCO3)= +         rk( 76)    *y(lNO)
          JAC(lNO  ,lXHO2)= +         rk(114)    *y(lNO)
     &                      +(-1.000)*rk(114)    *y(lNO)
          JAC(lNO  ,lYRPX)= +         rk(453)    *y(lNO)
     &                      +(-1.000)*rk(453)    *y(lNO)
          JAC(lNO  ,lXCCH)= +         rk(293)    *y(lNO)
     &                      +(-1.000)*rk(293)    *y(lNO)
          JAC(lNO  ,lBZC3)= +         rk( 87)    *y(lNO)
          JAC(lNO  ,lMAC3)= +         rk( 99)    *y(lNO)
          JAC(lNO  ,lXOH )= +         rk(124)    *y(lNO)
     &                      +(-1.000)*rk(124)    *y(lNO)
          JAC(lNO  ,lXNO2)= +         rk(134)    *y(lNO)
     &                      +(-1.000)*rk(134)    *y(lNO)
          JAC(lNO  ,lXMEO)= +         rk(144)    *y(lNO)
     &                      +(-1.000)*rk(144)    *y(lNO)
          JAC(lNO  ,lXMC3)= +         rk(154)    *y(lNO)
     &                      +(-1.000)*rk(154)    *y(lNO)
          JAC(lNO  ,lXRC3)= +         rk(164)    *y(lNO)
     &                      +(-1.000)*rk(164)    *y(lNO)
          JAC(lNO  ,lXMA3)= +         rk(174)    *y(lNO)
     &                      +(-1.000)*rk(174)    *y(lNO)
          JAC(lNO  ,lXTBU)= +         rk(184)    *y(lNO)
     &                      +(-1.000)*rk(184)    *y(lNO)
          JAC(lNO  ,lXCO )= +         rk(194)    *y(lNO)
     &                      +(-1.000)*rk(194)    *y(lNO)
          JAC(lNO  ,lXHCH)= +         rk(283)    *y(lNO)
     &                      +(-1.000)*rk(283)    *y(lNO)
          JAC(lNO  ,lZRN3)= +         rk(483)    *y(lNO)
     &                      +(-1.000)*rk(483)    *y(lNO)
          JAC(lNO  ,lXRCH)= +         rk(303)    *y(lNO)
     &                      +(-1.000)*rk(303)    *y(lNO)
          JAC(lNO  ,lXMGL)= +         rk(353)    *y(lNO)
     &                      +(-1.000)*rk(353)    *y(lNO)
          JAC(lNO  ,lXBAC)= +         rk(363)    *y(lNO)
     &                      +(-1.000)*rk(363)    *y(lNO)
          JAC(lNO  ,lXPD2)= +         rk(333)    *y(lNO)
     &                      +(-1.000)*rk(333)    *y(lNO)
          JAC(lNO  ,lY6PX)= +         rk(463)    *y(lNO)
     &                      +(-1.000)*rk(463)    *y(lNO)
          JAC(lNO  ,lXGLY)= +         rk(343)    *y(lNO)
     &                      +(-1.000)*rk(343)    *y(lNO)
          JAC(lNO  ,lXMEK)= +         rk(323)    *y(lNO)
     &                      +(-1.000)*rk(323)    *y(lNO)
          JAC(lNO  ,lXAF1)= +         rk(383)    *y(lNO)
     &                      +(-1.000)*rk(383)    *y(lNO)
          JAC(lNO  ,lXAF2)= +         rk(393)    *y(lNO)
     &                      +(-1.000)*rk(393)    *y(lNO)
          JAC(lNO  ,lXIPR)= +         rk(433)    *y(lNO)
     &                      +(-1.000)*rk(433)    *y(lNO)
          JAC(lNO  ,lXGLD)= +         rk(493)    *y(lNO)
     &                      +(-1.000)*rk(493)    *y(lNO)
          JAC(lNO  ,lXRN3)= +         rk(443)    *y(lNO)
     &                      +(-1.000)*rk(443)    *y(lNO)
          JAC(lNO  ,lXACE)= +         rk(313)    *y(lNO)
     &                      +(-1.000)*rk(313)    *y(lNO)
          JAC(lNO  ,lXBAL)= +         rk(373)    *y(lNO)
     &                      +(-1.000)*rk(373)    *y(lNO)
          JAC(lNO  ,lXAF3)= +         rk(403)    *y(lNO)
     &                      +(-1.000)*rk(403)    *y(lNO)
          JAC(lNO  ,lXMAC)= +         rk(413)    *y(lNO)
     &                      +(-1.000)*rk(413)    *y(lNO)
          JAC(lNO  ,lXMVK)= +         rk(423)    *y(lNO)
     &                      +(-1.000)*rk(423)    *y(lNO)
          JAC(lNO  ,lYAPX)= +         rk(473)    *y(lNO)
     &                      +(-1.000)*rk(473)    *y(lNO)
          JAC(lNO  ,lXACR)= +         rk(503)    *y(lNO)
     &                      +(-1.000)*rk(503)    *y(lNO)
          JAC(lO3P ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +         rk(  5)    *y(lO3P)
     &                      +         rk(  6)    *y(lO3P)
          JAC(lO3P ,lNO  )= +         rk(  4)    *y(lO3P)
          JAC(lO3P ,lO3P )= +         rk(  2)*flg*O2*M
     &                      +         rk(  3)    *y(lO3)
     &                      +         rk(  4)    *y(lNO)
     &                      +         rk(  5)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO2)
     &                      +         rk(257)    *y(lMACR)
     &                      +         rk(261)    *y(lMVK)
     &                      +         rk(277)    *y(lACRO)
     &                      +         rk(517)    *y(lETHE)
          JAC(lO3P ,lO3P )=JAC(lO3P ,lO3P )
     &                      +         rk(521)    *y(lPRPE)
     &                      +         rk(525)    *y(lBD13)
     &                      +         rk(529)    *y(lISOP)
     &                      +         rk(533)    *y(lAPIN)
     &                      +         rk(551)    *y(lOLE1)
     &                      +         rk(555)    *y(lOLE2)
     &                      +         rk(561)    *y(lTERP)
     &                      +         rk(565)    *y(lSESQ)
          JAC(lO3P ,lO3  )= +         rk(  3)    *y(lO3P)
     &                      +(-1.000)*rk( 19)*flg
          JAC(lO3P ,lNO3 )= +(-1.000)*rk( 17)*flg
          JAC(lO3P ,lO1D )= +(-1.000)*rk( 21)*flg*M
          JAC(lO3P ,lMACR)= +         rk(257)    *y(lO3P)
          JAC(lO3P ,lMVK )= +         rk(261)    *y(lO3P)
          JAC(lO3P ,lACRO)= +         rk(277)    *y(lO3P)
          JAC(lO3P ,lETHE)= +         rk(517)    *y(lO3P)
          JAC(lO3P ,lPRPE)= +         rk(521)    *y(lO3P)
          JAC(lO3P ,lBD13)= +         rk(525)    *y(lO3P)
          JAC(lO3P ,lISOP)= +         rk(529)    *y(lO3P)
          JAC(lO3P ,lAPIN)= +         rk(533)    *y(lO3P)
          JAC(lO3P ,lOLE1)= +         rk(551)    *y(lO3P)
          JAC(lO3P ,lOLE2)= +         rk(555)    *y(lO3P)
          JAC(lO3P ,lTERP)= +         rk(561)    *y(lO3P)
          JAC(lO3P ,lSESQ)= +         rk(565)    *y(lO3P)
          JAC(lO3  ,lNO2 )= +         rk(  8)    *y(lO3)
          JAC(lO3  ,lNO  )= +         rk(  7)    *y(lO3)
          JAC(lO3  ,lO3P )= +(-1.000)*rk(  2)*flg*O2*M
     &                      +         rk(  3)    *y(lO3)
          JAC(lO3  ,lO3  )= +         rk(  3)    *y(lO3P)
     &                      +         rk(  7)    *y(lNO)
     &                      +         rk(  8)    *y(lNO2)
     &                      +         rk( 18)*flg
     &                      +         rk( 19)*flg
     &                      +         rk( 30)    *y(lOH)
     &                      +         rk( 36)    *y(lHO2)
     &                      +         rk(247)    *y(lAFG1)
     &                      +         rk(250)    *y(lAFG2)
          JAC(lO3  ,lO3  )=JAC(lO3  ,lO3  )
     &                      +         rk(253)    *y(lAFG3)
     &                      +         rk(255)    *y(lMACR)
     &                      +         rk(260)    *y(lMVK)
     &                      +         rk(264)    *y(lIPRD)
     &                      +         rk(275)    *y(lACRO)
     &                      +         rk(515)    *y(lETHE)
     &                      +         rk(519)    *y(lPRPE)
     &                      +         rk(523)    *y(lBD13)
          JAC(lO3  ,lO3  )=JAC(lO3  ,lO3  )
     &                      +         rk(527)    *y(lISOP)
     &                      +         rk(531)    *y(lAPIN)
     &                      +         rk(535)    *y(lACYE)
     &                      +         rk(549)    *y(lOLE1)
     &                      +         rk(553)    *y(lOLE2)
     &                      +         rk(559)    *y(lTERP)
     &                      +         rk(563)    *y(lSESQ)
          JAC(lO3  ,lOH  )= +         rk( 30)    *y(lO3)
          JAC(lO3  ,lHO2 )= +         rk( 36)    *y(lO3)
     &                      +(-0.300)*rk( 67)    *y(lMCO3)
     &                      +(-0.250)*rk( 77)    *y(lRCO3)
     &                      +(-0.250)*rk( 88)    *y(lBZC3)
     &                      +(-0.250)*rk(100)    *y(lMAC3)
          JAC(lO3  ,lMCO3)= +(-0.300)*rk( 67)    *y(lHO2)
          JAC(lO3  ,lRCO3)= +(-0.250)*rk( 77)    *y(lHO2)
          JAC(lO3  ,lBZC3)= +(-0.250)*rk( 88)    *y(lHO2)
          JAC(lO3  ,lMAC3)= +(-0.250)*rk(100)    *y(lHO2)
          JAC(lO3  ,lIPRD)= +         rk(264)    *y(lO3)
          JAC(lO3  ,lAFG1)= +         rk(247)    *y(lO3)
          JAC(lO3  ,lAFG2)= +         rk(250)    *y(lO3)
          JAC(lO3  ,lAFG3)= +         rk(253)    *y(lO3)
          JAC(lO3  ,lMACR)= +         rk(255)    *y(lO3)
          JAC(lO3  ,lMVK )= +         rk(260)    *y(lO3)
          JAC(lO3  ,lACRO)= +         rk(275)    *y(lO3)
          JAC(lO3  ,lETHE)= +         rk(515)    *y(lO3)
          JAC(lO3  ,lPRPE)= +         rk(519)    *y(lO3)
          JAC(lO3  ,lBD13)= +         rk(523)    *y(lO3)
          JAC(lO3  ,lISOP)= +         rk(527)    *y(lO3)
          JAC(lO3  ,lAPIN)= +         rk(531)    *y(lO3)
          JAC(lO3  ,lACYE)= +         rk(535)    *y(lO3)
          JAC(lO3  ,lOLE1)= +         rk(549)    *y(lO3)
          JAC(lO3  ,lOLE2)= +         rk(553)    *y(lO3)
          JAC(lO3  ,lTERP)= +         rk(559)    *y(lO3)
          JAC(lO3  ,lSESQ)= +         rk(563)    *y(lO3)
          JAC(lNO3 ,lNO2 )= +(-1.000)*rk(  6)    *y(lO3P)
     &                      +(-1.000)*rk(  8)    *y(lO3)
     &                      +         rk( 11)    *y(lNO3)
     &                      +         rk( 15)    *y(lNO3)
          JAC(lNO3 ,lNO  )= +         rk(  9)    *y(lNO3)
          JAC(lNO3 ,lO3P )= +(-1.000)*rk(  6)    *y(lNO2)
          JAC(lNO3 ,lO3  )= +(-1.000)*rk(  8)    *y(lNO2)
          JAC(lNO3 ,lNO3 )= +         rk(  9)    *y(lNO)
     &                      +         rk( 11)    *y(lNO2)
     &                      +         rk( 15)    *y(lNO2)
     &                      +         rk( 16)*flg
     &                      +         rk( 17)*flg
     &                      +         rk( 26)    *y(lOH)
     &                      +         rk( 39)    *y(lHO2)
     &                      +( 4.000)*rk( 40)    *y(lNO3)
     &                      +         rk( 49)    *y(lMEO2)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk( 54)    *y(lRO2C)
     &                      +         rk( 59)    *y(lRO2X)
     &                      +         rk( 68)    *y(lMCO3)
     &                      +         rk( 78)    *y(lRCO3)
     &                      +         rk( 89)    *y(lBZC3)
     &                      +         rk(101)    *y(lMAC3)
     &                      +         rk(116)    *y(lXHO2)
     &                      +(-1.000)*rk(116)    *y(lXHO2)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(126)    *y(lXOH)
     &                      +(-1.000)*rk(126)    *y(lXOH)
     &                      +         rk(136)    *y(lXNO2)
     &                      +(-1.000)*rk(136)    *y(lXNO2)
     &                      +         rk(146)    *y(lXMEO)
     &                      +(-1.000)*rk(146)    *y(lXMEO)
     &                      +         rk(156)    *y(lXMC3)
     &                      +(-1.000)*rk(156)    *y(lXMC3)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(166)    *y(lXRC3)
     &                      +(-1.000)*rk(166)    *y(lXRC3)
     &                      +         rk(176)    *y(lXMA3)
     &                      +(-1.000)*rk(176)    *y(lXMA3)
     &                      +         rk(186)    *y(lXTBU)
     &                      +(-1.000)*rk(186)    *y(lXTBU)
     &                      +         rk(196)    *y(lXCO)
     &                      +(-1.000)*rk(196)    *y(lXCO)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(207)    *y(lHCHO)
     &                      +         rk(210)    *y(lCCHO)
     &                      +         rk(213)    *y(lRCHO)
     &                      +         rk(233)    *y(lGLY)
     &                      +         rk(236)    *y(lMGLY)
     &                      +         rk(239)    *y(lCRES)
     &                      +         rk(245)    *y(lBALD)
     &                      +         rk(256)    *y(lMACR)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(265)    *y(lIPRD)
     &                      +         rk(273)    *y(lGLYD)
     &                      +         rk(276)    *y(lACRO)
     &                      +         rk(285)    *y(lXHCH)
     &                      +(-1.000)*rk(285)    *y(lXHCH)
     &                      +         rk(295)    *y(lXCCH)
     &                      +(-1.000)*rk(295)    *y(lXCCH)
     &                      +         rk(305)    *y(lXRCH)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(305)    *y(lXRCH)
     &                      +         rk(315)    *y(lXACE)
     &                      +(-1.000)*rk(315)    *y(lXACE)
     &                      +         rk(325)    *y(lXMEK)
     &                      +(-1.000)*rk(325)    *y(lXMEK)
     &                      +         rk(335)    *y(lXPD2)
     &                      +(-1.000)*rk(335)    *y(lXPD2)
     &                      +         rk(345)    *y(lXGLY)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(345)    *y(lXGLY)
     &                      +         rk(355)    *y(lXMGL)
     &                      +(-1.000)*rk(355)    *y(lXMGL)
     &                      +         rk(365)    *y(lXBAC)
     &                      +(-1.000)*rk(365)    *y(lXBAC)
     &                      +         rk(375)    *y(lXBAL)
     &                      +(-1.000)*rk(375)    *y(lXBAL)
     &                      +         rk(385)    *y(lXAF1)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(385)    *y(lXAF1)
     &                      +         rk(395)    *y(lXAF2)
     &                      +(-1.000)*rk(395)    *y(lXAF2)
     &                      +         rk(405)    *y(lXAF3)
     &                      +(-1.000)*rk(405)    *y(lXAF3)
     &                      +         rk(415)    *y(lXMAC)
     &                      +(-1.000)*rk(415)    *y(lXMAC)
     &                      +         rk(425)    *y(lXMVK)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(425)    *y(lXMVK)
     &                      +         rk(435)    *y(lXIPR)
     &                      +(-1.000)*rk(435)    *y(lXIPR)
     &                      +         rk(445)    *y(lXRN3)
     &                      +(-1.000)*rk(445)    *y(lXRN3)
     &                      +         rk(455)    *y(lYRPX)
     &                      +(-1.000)*rk(455)    *y(lYRPX)
     &                      +         rk(465)    *y(lY6PX)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(465)    *y(lY6PX)
     &                      +         rk(475)    *y(lYAPX)
     &                      +(-1.000)*rk(475)    *y(lYAPX)
     &                      +         rk(485)    *y(lZRN3)
     &                      +(-1.000)*rk(485)    *y(lZRN3)
     &                      +         rk(495)    *y(lXGLD)
     &                      +(-1.000)*rk(495)    *y(lXGLD)
     &                      +         rk(505)    *y(lXACR)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +(-1.000)*rk(505)    *y(lXACR)
     &                      +         rk(516)    *y(lETHE)
     &                      +         rk(520)    *y(lPRPE)
     &                      +         rk(524)    *y(lBD13)
     &                      +         rk(528)    *y(lISOP)
     &                      +         rk(532)    *y(lAPIN)
     &                      +         rk(550)    *y(lOLE1)
     &                      +         rk(554)    *y(lOLE2)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(560)    *y(lTERP)
     &                      +         rk(564)    *y(lSESQ)
          JAC(lNO3 ,lN2O5)= +(-1.000)*rk( 12)*flg
          JAC(lNO3 ,lHNO3)= +(-1.000)*rk( 27)    *y(lOH)
          JAC(lNO3 ,lOH  )= +         rk( 26)    *y(lNO3)
     &                      +(-1.000)*rk( 27)    *y(lHNO3)
          JAC(lNO3 ,lHO2 )= +         rk( 39)    *y(lNO3)
          JAC(lNO3 ,lPNA )= +(-0.390)*rk( 34)*flg
          JAC(lNO3 ,lMEO2)= +         rk( 49)    *y(lNO3)
          JAC(lNO3 ,lHCHO)= +         rk(207)    *y(lNO3)
          JAC(lNO3 ,lRO2C)= +         rk( 54)    *y(lNO3)
          JAC(lNO3 ,lRO2X)= +         rk( 59)    *y(lNO3)
          JAC(lNO3 ,lMCO3)= +         rk( 68)    *y(lNO3)
          JAC(lNO3 ,lPAN )= +(-0.400)*rk( 65)*flg
          JAC(lNO3 ,lRCO3)= +         rk( 78)    *y(lNO3)
          JAC(lNO3 ,lPAN2)= +(-0.400)*rk( 75)*flg
          JAC(lNO3 ,lXHO2)= +         rk(116)    *y(lNO3)
     &                      +(-1.000)*rk(116)    *y(lNO3)
          JAC(lNO3 ,lYRPX)= +         rk(455)    *y(lNO3)
     &                      +(-1.000)*rk(455)    *y(lNO3)
          JAC(lNO3 ,lXCCH)= +         rk(295)    *y(lNO3)
     &                      +(-1.000)*rk(295)    *y(lNO3)
          JAC(lNO3 ,lBZC3)= +         rk( 89)    *y(lNO3)
          JAC(lNO3 ,lPBZN)= +(-0.400)*rk( 86)*flg
          JAC(lNO3 ,lMAC3)= +         rk(101)    *y(lNO3)
          JAC(lNO3 ,lMPAN)= +(-0.400)*rk( 98)*flg
          JAC(lNO3 ,lCRES)= +         rk(239)    *y(lNO3)
          JAC(lNO3 ,lXOH )= +         rk(126)    *y(lNO3)
     &                      +(-1.000)*rk(126)    *y(lNO3)
          JAC(lNO3 ,lXNO2)= +         rk(136)    *y(lNO3)
     &                      +(-1.000)*rk(136)    *y(lNO3)
          JAC(lNO3 ,lXMEO)= +         rk(146)    *y(lNO3)
     &                      +(-1.000)*rk(146)    *y(lNO3)
          JAC(lNO3 ,lXMC3)= +         rk(156)    *y(lNO3)
     &                      +(-1.000)*rk(156)    *y(lNO3)
          JAC(lNO3 ,lXRC3)= +         rk(166)    *y(lNO3)
     &                      +(-1.000)*rk(166)    *y(lNO3)
          JAC(lNO3 ,lXMA3)= +         rk(176)    *y(lNO3)
     &                      +(-1.000)*rk(176)    *y(lNO3)
          JAC(lNO3 ,lXTBU)= +         rk(186)    *y(lNO3)
     &                      +(-1.000)*rk(186)    *y(lNO3)
          JAC(lNO3 ,lXCO )= +         rk(196)    *y(lNO3)
     &                      +(-1.000)*rk(196)    *y(lNO3)
          JAC(lNO3 ,lCCHO)= +         rk(210)    *y(lNO3)
          JAC(lNO3 ,lRCHO)= +         rk(213)    *y(lNO3)
          JAC(lNO3 ,lXHCH)= +         rk(285)    *y(lNO3)
     &                      +(-1.000)*rk(285)    *y(lNO3)
          JAC(lNO3 ,lZRN3)= +         rk(485)    *y(lNO3)
     &                      +(-1.000)*rk(485)    *y(lNO3)
          JAC(lNO3 ,lXRCH)= +         rk(305)    *y(lNO3)
     &                      +(-1.000)*rk(305)    *y(lNO3)
          JAC(lNO3 ,lXMGL)= +         rk(355)    *y(lNO3)
     &                      +(-1.000)*rk(355)    *y(lNO3)
          JAC(lNO3 ,lXBAC)= +         rk(365)    *y(lNO3)
     &                      +(-1.000)*rk(365)    *y(lNO3)
          JAC(lNO3 ,lXPD2)= +         rk(335)    *y(lNO3)
     &                      +(-1.000)*rk(335)    *y(lNO3)
          JAC(lNO3 ,lY6PX)= +         rk(465)    *y(lNO3)
     &                      +(-1.000)*rk(465)    *y(lNO3)
          JAC(lNO3 ,lMGLY)= +         rk(236)    *y(lNO3)
          JAC(lNO3 ,lIPRD)= +         rk(265)    *y(lNO3)
          JAC(lNO3 ,lXGLY)= +         rk(345)    *y(lNO3)
     &                      +(-1.000)*rk(345)    *y(lNO3)
          JAC(lNO3 ,lXMEK)= +         rk(325)    *y(lNO3)
     &                      +(-1.000)*rk(325)    *y(lNO3)
          JAC(lNO3 ,lXAF1)= +         rk(385)    *y(lNO3)
     &                      +(-1.000)*rk(385)    *y(lNO3)
          JAC(lNO3 ,lXAF2)= +         rk(395)    *y(lNO3)
     &                      +(-1.000)*rk(395)    *y(lNO3)
          JAC(lNO3 ,lGLY )= +         rk(233)    *y(lNO3)
          JAC(lNO3 ,lBALD)= +         rk(245)    *y(lNO3)
          JAC(lNO3 ,lXIPR)= +         rk(435)    *y(lNO3)
     &                      +(-1.000)*rk(435)    *y(lNO3)
          JAC(lNO3 ,lMACR)= +         rk(256)    *y(lNO3)
          JAC(lNO3 ,lXGLD)= +         rk(495)    *y(lNO3)
     &                      +(-1.000)*rk(495)    *y(lNO3)
          JAC(lNO3 ,lXRN3)= +         rk(445)    *y(lNO3)
     &                      +(-1.000)*rk(445)    *y(lNO3)
          JAC(lNO3 ,lGLYD)= +         rk(273)    *y(lNO3)
          JAC(lNO3 ,lXACE)= +         rk(315)    *y(lNO3)
     &                      +(-1.000)*rk(315)    *y(lNO3)
          JAC(lNO3 ,lACRO)= +         rk(276)    *y(lNO3)
          JAC(lNO3 ,lXBAL)= +         rk(375)    *y(lNO3)
     &                      +(-1.000)*rk(375)    *y(lNO3)
          JAC(lNO3 ,lXAF3)= +         rk(405)    *y(lNO3)
     &                      +(-1.000)*rk(405)    *y(lNO3)
          JAC(lNO3 ,lXMAC)= +         rk(415)    *y(lNO3)
     &                      +(-1.000)*rk(415)    *y(lNO3)
          JAC(lNO3 ,lXMVK)= +         rk(425)    *y(lNO3)
     &                      +(-1.000)*rk(425)    *y(lNO3)
          JAC(lNO3 ,lYAPX)= +         rk(475)    *y(lNO3)
     &                      +(-1.000)*rk(475)    *y(lNO3)
          JAC(lNO3 ,lXACR)= +         rk(505)    *y(lNO3)
     &                      +(-1.000)*rk(505)    *y(lNO3)
          JAC(lNO3 ,lETHE)= +         rk(516)    *y(lNO3)
          JAC(lNO3 ,lPRPE)= +         rk(520)    *y(lNO3)
          JAC(lNO3 ,lBD13)= +         rk(524)    *y(lNO3)
          JAC(lNO3 ,lISOP)= +         rk(528)    *y(lNO3)
          JAC(lNO3 ,lAPIN)= +         rk(532)    *y(lNO3)
          JAC(lNO3 ,lOLE1)= +         rk(550)    *y(lNO3)
          JAC(lNO3 ,lOLE2)= +         rk(554)    *y(lNO3)
          JAC(lNO3 ,lTERP)= +         rk(560)    *y(lNO3)
          JAC(lNO3 ,lSESQ)= +         rk(564)    *y(lNO3)
          JAC(lN2O5,lNO2 )= +(-1.000)*rk( 11)    *y(lNO3)
          JAC(lN2O5,lNO3 )= +(-1.000)*rk( 11)    *y(lNO2)
          JAC(lN2O5,lN2O5)= +         rk( 12)*flg
     &                      +         rk( 13)*flg*H2O
     &                      +         rk( 14)*flg*H2O*H2O
          JAC(lHNO3,lNO2 )= +(-1.000)*rk( 25)    *y(lOH)
          JAC(lHNO3,lNO3 )= +(-0.200)*rk( 39)    *y(lHO2)
     &                      +(-1.000)*rk(207)    *y(lHCHO)
     &                      +(-1.000)*rk(210)    *y(lCCHO)
     &                      +(-1.000)*rk(213)    *y(lRCHO)
     &                      +(-1.000)*rk(233)    *y(lGLY)
     &                      +(-1.000)*rk(236)    *y(lMGLY)
     &                      +(-1.000)*rk(239)    *y(lCRES)
     &                      +(-1.000)*rk(245)    *y(lBALD)
     &                      +(-0.500)*rk(256)    *y(lMACR)
          JAC(lHNO3,lNO3 )=JAC(lHNO3,lNO3 )
     &                      +(-0.150)*rk(265)    *y(lIPRD)
     &                      +(-1.000)*rk(273)    *y(lGLYD)
     &                      +(-0.967)*rk(276)    *y(lACRO)
          JAC(lHNO3,lN2O5)= +(-2.000)*rk( 13)*flg*H2O
     &                      +(-2.000)*rk( 14)*flg*H2O*H2O
          JAC(lHNO3,lHNO3)= +         rk( 27)    *y(lOH)
     &                      +         rk( 28)*flg
          JAC(lHNO3,lOH  )= +(-1.000)*rk( 25)    *y(lNO2)
     &                      +         rk( 27)    *y(lHNO3)
          JAC(lHNO3,lHO2 )= +(-0.200)*rk( 39)    *y(lNO3)
          JAC(lHNO3,lHCHO)= +(-1.000)*rk(207)    *y(lNO3)
          JAC(lHNO3,lCRES)= +(-1.000)*rk(239)    *y(lNO3)
          JAC(lHNO3,lCCHO)= +(-1.000)*rk(210)    *y(lNO3)
          JAC(lHNO3,lRCHO)= +(-1.000)*rk(213)    *y(lNO3)
          JAC(lHNO3,lMGLY)= +(-1.000)*rk(236)    *y(lNO3)
          JAC(lHNO3,lIPRD)= +(-0.150)*rk(265)    *y(lNO3)
          JAC(lHNO3,lGLY )= +(-1.000)*rk(233)    *y(lNO3)
          JAC(lHNO3,lBALD)= +(-1.000)*rk(245)    *y(lNO3)
          JAC(lHNO3,lMACR)= +(-0.500)*rk(256)    *y(lNO3)
          JAC(lHNO3,lGLYD)= +(-1.000)*rk(273)    *y(lNO3)
          JAC(lHNO3,lACRO)= +(-0.967)*rk(276)    *y(lNO3)
          JAC(lO1D ,lO3  )= +(-1.000)*rk( 18)*flg
          JAC(lO1D ,lO1D )= +         rk( 20)*flg*H2O
     &                      +         rk( 21)*flg*M
          JAC(lOH  ,lNO2 )= +         rk( 25)    *y(lOH)
          JAC(lOH  ,lNO  )= +         rk( 22)    *y(lOH)
     &                      +(-1.000)*rk( 31)    *y(lHO2)
     &                      +(-1.000)*rk(124)    *y(lXOH)
          JAC(lOH  ,lO3  )= +         rk( 30)    *y(lOH)
     &                      +(-1.000)*rk( 36)    *y(lHO2)
     &                      +(-0.826)*rk(247)    *y(lAFG1)
     &                      +(-0.826)*rk(250)    *y(lAFG2)
     &                      +(-0.471)*rk(253)    *y(lAFG3)
     &                      +(-0.208)*rk(255)    *y(lMACR)
     &                      +(-0.164)*rk(260)    *y(lMVK)
     &                      +(-0.285)*rk(264)    *y(lIPRD)
     &                      +(-0.330)*rk(275)    *y(lACRO)
          JAC(lOH  ,lO3  )=JAC(lOH  ,lO3  )
     &                      +(-0.160)*rk(515)    *y(lETHE)
     &                      +(-0.350)*rk(519)    *y(lPRPE)
     &                      +(-0.080)*rk(523)    *y(lBD13)
     &                      +(-0.266)*rk(527)    *y(lISOP)
     &                      +(-0.728)*rk(531)    *y(lAPIN)
     &                      +(-0.500)*rk(535)    *y(lACYE)
     &                      +(-0.128)*rk(549)    *y(lOLE1)
     &                      +(-0.443)*rk(553)    *y(lOLE2)
          JAC(lOH  ,lO3  )=JAC(lOH  ,lO3  )
     &                      +(-0.499)*rk(559)    *y(lTERP)
     &                      +(-0.499)*rk(563)    *y(lSESQ)
          JAC(lOH  ,lNO3 )= +         rk( 26)    *y(lOH)
     &                      +(-0.800)*rk( 39)    *y(lHO2)
     &                      +(-1.000)*rk(126)    *y(lXOH)
          JAC(lOH  ,lHNO3)= +         rk( 27)    *y(lOH)
     &                      +(-1.000)*rk( 28)*flg
          JAC(lOH  ,lO1D )= +(-2.000)*rk( 20)*flg*H2O
          JAC(lOH  ,lOH  )= +         rk( 22)    *y(lNO)
     &                      +         rk( 24)    *y(lHONO)
     &                      +         rk( 25)    *y(lNO2)
     &                      +         rk( 26)    *y(lNO3)
     &                      +         rk( 27)    *y(lHNO3)
     &                      +         rk( 29)    *y(lCO)
     &                      +         rk( 30)    *y(lO3)
     &                      +         rk( 35)    *y(lPNA)
     &                      +         rk( 42)    *y(lH2O2)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk( 43)    *y(lHO2)
     &                      +         rk( 44)    *y(lSO2)
     &                      +         rk( 45)*flg*H2
     &                      +         rk(206)    *y(lHCHO)
     &                      +         rk(208)    *y(lCCHO)
     &                      +         rk(211)    *y(lRCHO)
     &                      +         rk(214)    *y(lACET)
     &                      +         rk(216)    *y(lMEK)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(218)    *y(lMEOH)
     &                      +         rk(219)    *y(lFACD)
     &                      +         rk(220)    *y(lAACD)
     &                      +         rk(221)    *y(lPACD)
     &                      +         rk(222)    *y(lCOOH)
     &                      +(-0.300)*rk(222)    *y(lCOOH)
     &                      +         rk(224)    *y(lROOH)
     &                      +(-0.744)*rk(224)    *y(lROOH)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(226)    *y(lR6PX)
     &                      +(-0.840)*rk(226)    *y(lR6PX)
     &                      +         rk(228)    *y(lRAPX)
     &                      +(-0.139)*rk(228)    *y(lRAPX)
     &                      +         rk(232)    *y(lGLY)
     &                      +         rk(235)    *y(lMGLY)
     &                      +         rk(238)    *y(lCRES)
     &                      +         rk(240)    *y(lNPHE)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(243)    *y(lBALD)
     &                      +         rk(246)    *y(lAFG1)
     &                      +         rk(249)    *y(lAFG2)
     &                      +         rk(252)    *y(lAFG3)
     &                      +         rk(254)    *y(lMACR)
     &                      +         rk(259)    *y(lMVK)
     &                      +         rk(263)    *y(lIPRD)
     &                      +         rk(267)    *y(lPRD2)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(269)    *y(lRNO3)
     &                      +         rk(271)    *y(lGLYD)
     &                      +         rk(274)    *y(lACRO)
     &                      +         rk(279)    *y(lCO3H)
     &                      +         rk(281)    *y(lRO3H)
     &                      +         rk(513)*flg*CH4
     &                      +         rk(514)    *y(lETHE)
     &                      +         rk(518)    *y(lPRPE)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(522)    *y(lBD13)
     &                      +         rk(526)    *y(lISOP)
     &                      +         rk(530)    *y(lAPIN)
     &                      +         rk(534)    *y(lACYE)
     &                      +(-0.700)*rk(534)    *y(lACYE)
     &                      +         rk(536)    *y(lBENZ)
     &                      +(-0.116)*rk(536)    *y(lBENZ)
     &                      +         rk(537)    *y(lTOLU)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +(-0.312)*rk(537)    *y(lTOLU)
     &                      +         rk(538)    *y(lMXYL)
     &                      +(-0.239)*rk(538)    *y(lMXYL)
     &                      +         rk(539)    *y(lOXYL)
     &                      +(-0.198)*rk(539)    *y(lOXYL)
     &                      +         rk(540)    *y(lPXYL)
     &                      +(-0.278)*rk(540)    *y(lPXYL)
     &                      +         rk(541)    *y(lB124)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +(-0.230)*rk(541)    *y(lB124)
     &                      +         rk(542)    *y(lETOH)
     &                      +         rk(543)    *y(lALK1)
     &                      +         rk(544)    *y(lALK2)
     &                      +         rk(545)    *y(lALK3)
     &                      +         rk(546)    *y(lALK4)
     &                      +         rk(547)    *y(lALK5)
     &                      +         rk(548)    *y(lOLE1)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(552)    *y(lOLE2)
     &                      +         rk(556)    *y(lARO1)
     &                      +(-0.202)*rk(556)    *y(lARO1)
     &                      +         rk(557)    *y(lARO2)
     &                      +(-0.178)*rk(557)    *y(lARO2)
     &                      +         rk(558)    *y(lTERP)
     &                      +         rk(562)    *y(lSESQ)
          JAC(lOH  ,lHONO)= +(-1.000)*rk( 23)*flg
     &                      +         rk( 24)    *y(lOH)
          JAC(lOH  ,lHO2 )= +(-1.000)*rk( 31)    *y(lNO)
     &                      +(-1.000)*rk( 36)    *y(lO3)
     &                      +(-0.800)*rk( 39)    *y(lNO3)
     &                      +         rk( 43)    *y(lOH)
          JAC(lOH  ,lCO  )= +         rk( 29)    *y(lOH)
          JAC(lOH  ,lPNA )= +(-0.390)*rk( 34)*flg
     &                      +         rk( 35)    *y(lOH)
          JAC(lOH  ,lH2O2)= +(-2.000)*rk( 41)*flg
     &                      +         rk( 42)    *y(lOH)
          JAC(lOH  ,lSO2 )= +         rk( 44)    *y(lOH)
          JAC(lOH  ,lMEO2)= +(-0.500)*rk(127)    *y(lXOH)
          JAC(lOH  ,lHCHO)= +         rk(206)    *y(lOH)
          JAC(lOH  ,lCOOH)= +         rk(222)    *y(lOH)
     &                      +(-0.300)*rk(222)    *y(lOH)
     &                      +(-1.000)*rk(223)*flg
          JAC(lOH  ,lMEOH)= +         rk(218)    *y(lOH)
          JAC(lOH  ,lRO2C)= +(-0.500)*rk(128)    *y(lXOH)
          JAC(lOH  ,lRO2X)= +(-0.500)*rk(129)    *y(lXOH)
          JAC(lOH  ,lMCO3)= +(-1.000)*rk(130)    *y(lXOH)
          JAC(lOH  ,lCO3H)= +         rk(279)    *y(lOH)
     &                      +(-1.000)*rk(280)*flg
          JAC(lOH  ,lAACD)= +         rk(220)    *y(lOH)
          JAC(lOH  ,lRCO3)= +(-1.000)*rk(131)    *y(lXOH)
          JAC(lOH  ,lRO3H)= +         rk(281)    *y(lOH)
     &                      +(-1.000)*rk(282)*flg
          JAC(lOH  ,lPACD)= +         rk(221)    *y(lOH)
          JAC(lOH  ,lBZC3)= +(-1.000)*rk(132)    *y(lXOH)
          JAC(lOH  ,lMAC3)= +(-1.000)*rk(133)    *y(lXOH)
          JAC(lOH  ,lRNO3)= +         rk(269)    *y(lOH)
          JAC(lOH  ,lACET)= +         rk(214)    *y(lOH)
          JAC(lOH  ,lNPHE)= +         rk(240)    *y(lOH)
          JAC(lOH  ,lCRES)= +         rk(238)    *y(lOH)
          JAC(lOH  ,lXOH )= +(-1.000)*rk(124)    *y(lNO)
     &                      +(-1.000)*rk(126)    *y(lNO3)
     &                      +(-0.500)*rk(127)    *y(lMEO2)
     &                      +(-0.500)*rk(128)    *y(lRO2C)
     &                      +(-0.500)*rk(129)    *y(lRO2X)
     &                      +(-1.000)*rk(130)    *y(lMCO3)
     &                      +(-1.000)*rk(131)    *y(lRCO3)
     &                      +(-1.000)*rk(132)    *y(lBZC3)
     &                      +(-1.000)*rk(133)    *y(lMAC3)
          JAC(lOH  ,lCCHO)= +         rk(208)    *y(lOH)
          JAC(lOH  ,lRCHO)= +         rk(211)    *y(lOH)
          JAC(lOH  ,lMEK )= +         rk(216)    *y(lOH)
          JAC(lOH  ,lFACD)= +         rk(219)    *y(lOH)
          JAC(lOH  ,lROOH)= +         rk(224)    *y(lOH)
     &                      +(-0.744)*rk(224)    *y(lOH)
     &                      +(-1.000)*rk(225)*flg
          JAC(lOH  ,lR6PX)= +         rk(226)    *y(lOH)
     &                      +(-0.840)*rk(226)    *y(lOH)
     &                      +(-1.000)*rk(227)*flg
          JAC(lOH  ,lPRD2)= +         rk(267)    *y(lOH)
          JAC(lOH  ,lRAPX)= +         rk(228)    *y(lOH)
     &                      +(-0.139)*rk(228)    *y(lOH)
     &                      +(-1.000)*rk(229)*flg
          JAC(lOH  ,lMGLY)= +         rk(235)    *y(lOH)
          JAC(lOH  ,lIPRD)= +         rk(263)    *y(lOH)
     &                      +(-0.285)*rk(264)    *y(lO3)
          JAC(lOH  ,lGLY )= +         rk(232)    *y(lOH)
          JAC(lOH  ,lAFG1)= +         rk(246)    *y(lOH)
     &                      +(-0.826)*rk(247)    *y(lO3)
          JAC(lOH  ,lAFG2)= +         rk(249)    *y(lOH)
     &                      +(-0.826)*rk(250)    *y(lO3)
          JAC(lOH  ,lBALD)= +         rk(243)    *y(lOH)
          JAC(lOH  ,lAFG3)= +         rk(252)    *y(lOH)
     &                      +(-0.471)*rk(253)    *y(lO3)
          JAC(lOH  ,lMACR)= +         rk(254)    *y(lOH)
     &                      +(-0.208)*rk(255)    *y(lO3)
     &                      +(-0.330)*rk(258)*flg
          JAC(lOH  ,lMVK )= +         rk(259)    *y(lOH)
     &                      +(-0.164)*rk(260)    *y(lO3)
          JAC(lOH  ,lGLYD)= +         rk(271)    *y(lOH)
          JAC(lOH  ,lACRO)= +         rk(274)    *y(lOH)
     &                      +(-0.330)*rk(275)    *y(lO3)
     &                      +(-0.178)*rk(278)*flg
          JAC(lOH  ,lETHE)= +         rk(514)    *y(lOH)
     &                      +(-0.160)*rk(515)    *y(lO3)
          JAC(lOH  ,lPRPE)= +         rk(518)    *y(lOH)
     &                      +(-0.350)*rk(519)    *y(lO3)
          JAC(lOH  ,lBD13)= +         rk(522)    *y(lOH)
     &                      +(-0.080)*rk(523)    *y(lO3)
          JAC(lOH  ,lISOP)= +         rk(526)    *y(lOH)
     &                      +(-0.266)*rk(527)    *y(lO3)
          JAC(lOH  ,lAPIN)= +         rk(530)    *y(lOH)
     &                      +(-0.728)*rk(531)    *y(lO3)
          JAC(lOH  ,lACYE)= +         rk(534)    *y(lOH)
     &                      +(-0.700)*rk(534)    *y(lOH)
     &                      +(-0.500)*rk(535)    *y(lO3)
          JAC(lOH  ,lBENZ)= +         rk(536)    *y(lOH)
     &                      +(-0.116)*rk(536)    *y(lOH)
          JAC(lOH  ,lTOLU)= +         rk(537)    *y(lOH)
     &                      +(-0.312)*rk(537)    *y(lOH)
          JAC(lOH  ,lMXYL)= +         rk(538)    *y(lOH)
     &                      +(-0.239)*rk(538)    *y(lOH)
          JAC(lOH  ,lOXYL)= +         rk(539)    *y(lOH)
     &                      +(-0.198)*rk(539)    *y(lOH)
          JAC(lOH  ,lPXYL)= +         rk(540)    *y(lOH)
     &                      +(-0.278)*rk(540)    *y(lOH)
          JAC(lOH  ,lB124)= +         rk(541)    *y(lOH)
     &                      +(-0.230)*rk(541)    *y(lOH)
          JAC(lOH  ,lETOH)= +         rk(542)    *y(lOH)
          JAC(lOH  ,lALK1)= +         rk(543)    *y(lOH)
          JAC(lOH  ,lALK2)= +         rk(544)    *y(lOH)
          JAC(lOH  ,lALK3)= +         rk(545)    *y(lOH)
          JAC(lOH  ,lALK4)= +         rk(546)    *y(lOH)
          JAC(lOH  ,lALK5)= +         rk(547)    *y(lOH)
          JAC(lOH  ,lOLE1)= +         rk(548)    *y(lOH)
     &                      +(-0.128)*rk(549)    *y(lO3)
          JAC(lOH  ,lOLE2)= +         rk(552)    *y(lOH)
     &                      +(-0.443)*rk(553)    *y(lO3)
          JAC(lOH  ,lARO1)= +         rk(556)    *y(lOH)
     &                      +(-0.202)*rk(556)    *y(lOH)
          JAC(lOH  ,lARO2)= +         rk(557)    *y(lOH)
     &                      +(-0.178)*rk(557)    *y(lOH)
          JAC(lOH  ,lTERP)= +         rk(558)    *y(lOH)
     &                      +(-0.499)*rk(559)    *y(lO3)
          JAC(lOH  ,lSESQ)= +         rk(562)    *y(lOH)
     &                      +(-0.499)*rk(563)    *y(lO3)
          JAC(lHONO,lNO  )= +(-1.000)*rk( 22)    *y(lOH)
          JAC(lHONO,lOH  )= +(-1.000)*rk( 22)    *y(lNO)
     &                      +         rk( 24)    *y(lHONO)
          JAC(lHONO,lHONO)= +         rk( 23)*flg
     &                      +         rk( 24)    *y(lOH)
          JAC(lHONO,lNPHE)= +(-1.000)*rk(241)*flg
          JAC(lHO2 ,lNO2 )= +         rk( 32)    *y(lHO2)
          JAC(lHO2 ,lNO  )= +         rk( 31)    *y(lHO2)
     &                      +(-1.000)*rk( 46)    *y(lMEO2)
     &                      +(-1.000)*rk(114)    *y(lXHO2)
          JAC(lHO2 ,lO3P )= +(-0.800)*rk(517)    *y(lETHE)
     &                      +(-0.250)*rk(525)    *y(lBD13)
          JAC(lHO2 ,lO3  )= +(-1.000)*rk( 30)    *y(lOH)
     &                      +         rk( 36)    *y(lHO2)
     &                      +(-0.522)*rk(247)    *y(lAFG1)
     &                      +(-0.522)*rk(250)    *y(lAFG2)
     &                      +(-0.554)*rk(253)    *y(lAFG3)
     &                      +(-0.108)*rk(255)    *y(lMACR)
     &                      +(-0.064)*rk(260)    *y(lMVK)
     &                      +(-0.400)*rk(264)    *y(lIPRD)
     &                      +(-0.830)*rk(275)    *y(lACRO)
          JAC(lHO2 ,lO3  )=JAC(lHO2 ,lO3  )
     &                      +(-0.160)*rk(515)    *y(lETHE)
     &                      +(-0.165)*rk(519)    *y(lPRPE)
     &                      +(-0.080)*rk(523)    *y(lBD13)
     &                      +(-0.066)*rk(527)    *y(lISOP)
     &                      +(-0.009)*rk(531)    *y(lAPIN)
     &                      +(-1.500)*rk(535)    *y(lACYE)
     &                      +(-0.095)*rk(549)    *y(lOLE1)
     &                      +(-0.094)*rk(553)    *y(lOLE2)
          JAC(lHO2 ,lO3  )=JAC(lHO2 ,lO3  )
     &                      +(-0.078)*rk(559)    *y(lTERP)
     &                      +(-0.078)*rk(563)    *y(lSESQ)
          JAC(lHO2 ,lNO3 )= +(-1.000)*rk( 26)    *y(lOH)
     &                      +         rk( 39)    *y(lHO2)
     &                      +(-1.000)*rk( 49)    *y(lMEO2)
     &                      +(-1.000)*rk(116)    *y(lXHO2)
     &                      +(-1.000)*rk(207)    *y(lHCHO)
     &                      +(-0.630)*rk(233)    *y(lGLY)
     &                      +(-1.000)*rk(485)    *y(lZRN3)
          JAC(lHO2 ,lOH  )= +(-1.000)*rk( 26)    *y(lNO3)
     &                      +(-1.000)*rk( 29)    *y(lCO)
     &                      +(-1.000)*rk( 30)    *y(lO3)
     &                      +(-1.000)*rk( 42)    *y(lH2O2)
     &                      +         rk( 43)    *y(lHO2)
     &                      +(-1.000)*rk( 44)    *y(lSO2)
     &                      +(-1.000)*rk( 45)*flg*H2
     &                      +(-1.000)*rk(206)    *y(lHCHO)
     &                      +(-1.000)*rk(218)    *y(lMEOH)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-1.000)*rk(219)    *y(lFACD)
     &                      +(-0.148)*rk(228)    *y(lRAPX)
     &                      +(-0.630)*rk(232)    *y(lGLY)
     &                      +(-0.472)*rk(267)    *y(lPRD2)
     &                      +(-0.189)*rk(269)    *y(lRNO3)
     &                      +(-0.300)*rk(534)    *y(lACYE)
     &                      +(-0.570)*rk(536)    *y(lBENZ)
     &                      +(-0.181)*rk(537)    *y(lTOLU)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-0.159)*rk(538)    *y(lMXYL)
     &                      +(-0.161)*rk(539)    *y(lOXYL)
     &                      +(-0.159)*rk(540)    *y(lPXYL)
     &                      +(-0.022)*rk(541)    *y(lB124)
     &                      +(-0.950)*rk(542)    *y(lETOH)
     &                      +(-0.123)*rk(556)    *y(lARO1)
     &                      +(-0.077)*rk(557)    *y(lARO2)
          JAC(lHO2 ,lHO2 )= +         rk( 31)    *y(lNO)
     &                      +         rk( 32)    *y(lNO2)
     &                      +         rk( 36)    *y(lO3)
     &                      +( 4.000)*rk( 37)    *y(lHO2)
     &                      +( 4.000)*rk( 38)    *y(lHO2)*H2O
     &                      +         rk( 39)    *y(lNO3)
     &                      +         rk( 43)    *y(lOH)
     &                      +         rk( 47)    *y(lMEO2)
     &                      +         rk( 48)    *y(lMEO2)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +         rk( 53)    *y(lRO2C)
     &                      +         rk( 58)    *y(lRO2X)
     &                      +         rk( 67)    *y(lMCO3)
     &                      +         rk( 77)    *y(lRCO3)
     &                      +         rk( 88)    *y(lBZC3)
     &                      +         rk(100)    *y(lMAC3)
     &                      +         rk(112)    *y(lBZO)
     &                      +         rk(115)    *y(lXHO2)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(115)    *y(lXHO2)
     &                      +         rk(125)    *y(lXOH)
     &                      +(-1.000)*rk(125)    *y(lXOH)
     &                      +         rk(135)    *y(lXNO2)
     &                      +(-1.000)*rk(135)    *y(lXNO2)
     &                      +         rk(145)    *y(lXMEO)
     &                      +(-1.000)*rk(145)    *y(lXMEO)
     &                      +         rk(155)    *y(lXMC3)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(155)    *y(lXMC3)
     &                      +         rk(165)    *y(lXRC3)
     &                      +(-1.000)*rk(165)    *y(lXRC3)
     &                      +         rk(175)    *y(lXMA3)
     &                      +(-1.000)*rk(175)    *y(lXMA3)
     &                      +         rk(185)    *y(lXTBU)
     &                      +(-1.000)*rk(185)    *y(lXTBU)
     &                      +         rk(195)    *y(lXCO)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(195)    *y(lXCO)
     &                      +         rk(284)    *y(lXHCH)
     &                      +(-1.000)*rk(284)    *y(lXHCH)
     &                      +         rk(294)    *y(lXCCH)
     &                      +(-1.000)*rk(294)    *y(lXCCH)
     &                      +         rk(304)    *y(lXRCH)
     &                      +(-1.000)*rk(304)    *y(lXRCH)
     &                      +         rk(314)    *y(lXACE)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(314)    *y(lXACE)
     &                      +         rk(324)    *y(lXMEK)
     &                      +(-1.000)*rk(324)    *y(lXMEK)
     &                      +         rk(334)    *y(lXPD2)
     &                      +(-1.000)*rk(334)    *y(lXPD2)
     &                      +         rk(344)    *y(lXGLY)
     &                      +(-1.000)*rk(344)    *y(lXGLY)
     &                      +         rk(354)    *y(lXMGL)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(354)    *y(lXMGL)
     &                      +         rk(364)    *y(lXBAC)
     &                      +(-1.000)*rk(364)    *y(lXBAC)
     &                      +         rk(374)    *y(lXBAL)
     &                      +(-1.000)*rk(374)    *y(lXBAL)
     &                      +         rk(384)    *y(lXAF1)
     &                      +(-1.000)*rk(384)    *y(lXAF1)
     &                      +         rk(394)    *y(lXAF2)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(394)    *y(lXAF2)
     &                      +         rk(404)    *y(lXAF3)
     &                      +(-1.000)*rk(404)    *y(lXAF3)
     &                      +         rk(414)    *y(lXMAC)
     &                      +(-1.000)*rk(414)    *y(lXMAC)
     &                      +         rk(424)    *y(lXMVK)
     &                      +(-1.000)*rk(424)    *y(lXMVK)
     &                      +         rk(434)    *y(lXIPR)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(434)    *y(lXIPR)
     &                      +         rk(444)    *y(lXRN3)
     &                      +(-1.000)*rk(444)    *y(lXRN3)
     &                      +         rk(454)    *y(lYRPX)
     &                      +(-1.000)*rk(454)    *y(lYRPX)
     &                      +         rk(464)    *y(lY6PX)
     &                      +(-1.000)*rk(464)    *y(lY6PX)
     &                      +         rk(474)    *y(lYAPX)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +(-1.000)*rk(474)    *y(lYAPX)
     &                      +         rk(484)    *y(lZRN3)
     &                      +(-1.000)*rk(484)    *y(lZRN3)
     &                      +         rk(494)    *y(lXGLD)
     &                      +(-1.000)*rk(494)    *y(lXGLD)
     &                      +         rk(504)    *y(lXACR)
     &                      +(-1.000)*rk(504)    *y(lXACR)
          JAC(lHO2 ,lCO  )= +(-1.000)*rk( 29)    *y(lOH)
          JAC(lHO2 ,lPNA )= +(-1.000)*rk( 33)*flg
     &                      +(-0.610)*rk( 34)*flg
          JAC(lHO2 ,lH2O2)= +(-1.000)*rk( 42)    *y(lOH)
          JAC(lHO2 ,lSO2 )= +(-1.000)*rk( 44)    *y(lOH)
          JAC(lHO2 ,lMEO2)= +(-1.000)*rk( 46)    *y(lNO)
     &                      +         rk( 47)    *y(lHO2)
     &                      +         rk( 48)    *y(lHO2)
     &                      +(-1.000)*rk( 49)    *y(lNO3)
     &                      +(-4.000)*rk( 51)    *y(lMEO2)
     &                      +(-0.500)*rk( 55)    *y(lRO2C)
     &                      +(-0.500)*rk( 60)    *y(lRO2X)
     &                      +(-0.900)*rk( 69)    *y(lMCO3)
     &                      +(-1.000)*rk( 79)    *y(lRCO3)
          JAC(lHO2 ,lMEO2)=JAC(lHO2 ,lMEO2)
     &                      +(-1.000)*rk( 90)    *y(lBZC3)
     &                      +(-1.000)*rk(102)    *y(lMAC3)
     &                      +(-0.500)*rk(117)    *y(lXHO2)
     &                      +(-0.500)*rk(486)    *y(lZRN3)
          JAC(lHO2 ,lHCHO)= +(-2.000)*rk(204)*flg
     &                      +(-1.000)*rk(206)    *y(lOH)
     &                      +(-1.000)*rk(207)    *y(lNO3)
          JAC(lHO2 ,lCOOH)= +(-1.000)*rk(223)*flg
          JAC(lHO2 ,lMEOH)= +(-1.000)*rk(218)    *y(lOH)
          JAC(lHO2 ,lRO2C)= +         rk( 53)    *y(lHO2)
     &                      +(-0.500)*rk( 55)    *y(lMEO2)
     &                      +(-0.500)*rk(118)    *y(lXHO2)
     &                      +(-0.500)*rk(487)    *y(lZRN3)
          JAC(lHO2 ,lRO2X)= +         rk( 58)    *y(lHO2)
     &                      +(-0.500)*rk( 60)    *y(lMEO2)
     &                      +(-0.500)*rk(119)    *y(lXHO2)
     &                      +(-0.500)*rk(488)    *y(lZRN3)
          JAC(lHO2 ,lMCO3)= +         rk( 67)    *y(lHO2)
     &                      +(-0.900)*rk( 69)    *y(lMEO2)
     &                      +(-1.000)*rk(120)    *y(lXHO2)
     &                      +(-1.000)*rk(489)    *y(lZRN3)
          JAC(lHO2 ,lRCO3)= +         rk( 77)    *y(lHO2)
     &                      +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk(121)    *y(lXHO2)
     &                      +(-1.000)*rk(490)    *y(lZRN3)
          JAC(lHO2 ,lXHO2)= +(-1.000)*rk(114)    *y(lNO)
     &                      +         rk(115)    *y(lHO2)
     &                      +(-1.000)*rk(115)    *y(lHO2)
     &                      +(-1.000)*rk(116)    *y(lNO3)
     &                      +(-0.500)*rk(117)    *y(lMEO2)
     &                      +(-0.500)*rk(118)    *y(lRO2C)
     &                      +(-0.500)*rk(119)    *y(lRO2X)
     &                      +(-1.000)*rk(120)    *y(lMCO3)
     &                      +(-1.000)*rk(121)    *y(lRCO3)
          JAC(lHO2 ,lXHO2)=JAC(lHO2 ,lXHO2)
     &                      +(-1.000)*rk(122)    *y(lBZC3)
     &                      +(-1.000)*rk(123)    *y(lMAC3)
          JAC(lHO2 ,lYRPX)= +         rk(454)    *y(lHO2)
     &                      +(-1.000)*rk(454)    *y(lHO2)
          JAC(lHO2 ,lXCCH)= +         rk(294)    *y(lHO2)
     &                      +(-1.000)*rk(294)    *y(lHO2)
          JAC(lHO2 ,lBZC3)= +         rk( 88)    *y(lHO2)
     &                      +(-1.000)*rk( 90)    *y(lMEO2)
     &                      +(-1.000)*rk(122)    *y(lXHO2)
     &                      +(-1.000)*rk(491)    *y(lZRN3)
          JAC(lHO2 ,lBZO )= +         rk(112)    *y(lHO2)
          JAC(lHO2 ,lMAC3)= +         rk(100)    *y(lHO2)
     &                      +(-1.000)*rk(102)    *y(lMEO2)
     &                      +(-1.000)*rk(123)    *y(lXHO2)
     &                      +(-1.000)*rk(492)    *y(lZRN3)
          JAC(lHO2 ,lRNO3)= +(-0.189)*rk(269)    *y(lOH)
     &                      +(-0.344)*rk(270)*flg
          JAC(lHO2 ,lXOH )= +         rk(125)    *y(lHO2)
     &                      +(-1.000)*rk(125)    *y(lHO2)
          JAC(lHO2 ,lXNO2)= +         rk(135)    *y(lHO2)
     &                      +(-1.000)*rk(135)    *y(lHO2)
          JAC(lHO2 ,lXMEO)= +         rk(145)    *y(lHO2)
     &                      +(-1.000)*rk(145)    *y(lHO2)
          JAC(lHO2 ,lXMC3)= +         rk(155)    *y(lHO2)
     &                      +(-1.000)*rk(155)    *y(lHO2)
          JAC(lHO2 ,lXRC3)= +         rk(165)    *y(lHO2)
     &                      +(-1.000)*rk(165)    *y(lHO2)
          JAC(lHO2 ,lXMA3)= +         rk(175)    *y(lHO2)
     &                      +(-1.000)*rk(175)    *y(lHO2)
          JAC(lHO2 ,lXTBU)= +         rk(185)    *y(lHO2)
     &                      +(-1.000)*rk(185)    *y(lHO2)
          JAC(lHO2 ,lXCO )= +         rk(195)    *y(lHO2)
     &                      +(-1.000)*rk(195)    *y(lHO2)
          JAC(lHO2 ,lCCHO)= +(-1.000)*rk(209)*flg
          JAC(lHO2 ,lRCHO)= +(-1.000)*rk(212)*flg
          JAC(lHO2 ,lXHCH)= +         rk(284)    *y(lHO2)
     &                      +(-1.000)*rk(284)    *y(lHO2)
          JAC(lHO2 ,lZRN3)= +         rk(484)    *y(lHO2)
     &                      +(-1.000)*rk(484)    *y(lHO2)
     &                      +(-1.000)*rk(485)    *y(lNO3)
     &                      +(-0.500)*rk(486)    *y(lMEO2)
     &                      +(-0.500)*rk(487)    *y(lRO2C)
     &                      +(-0.500)*rk(488)    *y(lRO2X)
     &                      +(-1.000)*rk(489)    *y(lMCO3)
     &                      +(-1.000)*rk(490)    *y(lRCO3)
     &                      +(-1.000)*rk(491)    *y(lBZC3)
          JAC(lHO2 ,lZRN3)=JAC(lHO2 ,lZRN3)
     &                      +(-1.000)*rk(492)    *y(lMAC3)
          JAC(lHO2 ,lXRCH)= +         rk(304)    *y(lHO2)
     &                      +(-1.000)*rk(304)    *y(lHO2)
          JAC(lHO2 ,lFACD)= +(-1.000)*rk(219)    *y(lOH)
          JAC(lHO2 ,lXMGL)= +         rk(354)    *y(lHO2)
     &                      +(-1.000)*rk(354)    *y(lHO2)
          JAC(lHO2 ,lXBAC)= +         rk(364)    *y(lHO2)
     &                      +(-1.000)*rk(364)    *y(lHO2)
          JAC(lHO2 ,lROOH)= +(-1.000)*rk(225)*flg
          JAC(lHO2 ,lXPD2)= +         rk(334)    *y(lHO2)
     &                      +(-1.000)*rk(334)    *y(lHO2)
          JAC(lHO2 ,lR6PX)= +(-0.142)*rk(227)*flg
          JAC(lHO2 ,lPRD2)= +(-0.472)*rk(267)    *y(lOH)
          JAC(lHO2 ,lY6PX)= +         rk(464)    *y(lHO2)
     &                      +(-1.000)*rk(464)    *y(lHO2)
          JAC(lHO2 ,lRAPX)= +(-0.148)*rk(228)    *y(lOH)
     &                      +(-1.000)*rk(229)*flg
          JAC(lHO2 ,lMGLY)= +(-1.000)*rk(234)*flg
          JAC(lHO2 ,lIPRD)= +(-0.400)*rk(264)    *y(lO3)
     &                      +(-1.233)*rk(266)*flg
          JAC(lHO2 ,lXGLY)= +         rk(344)    *y(lHO2)
     &                      +(-1.000)*rk(344)    *y(lHO2)
          JAC(lHO2 ,lXMEK)= +         rk(324)    *y(lHO2)
     &                      +(-1.000)*rk(324)    *y(lHO2)
          JAC(lHO2 ,lXAF1)= +         rk(384)    *y(lHO2)
     &                      +(-1.000)*rk(384)    *y(lHO2)
          JAC(lHO2 ,lXAF2)= +         rk(394)    *y(lHO2)
     &                      +(-1.000)*rk(394)    *y(lHO2)
          JAC(lHO2 ,lGLY )= +(-2.000)*rk(230)*flg
     &                      +(-0.630)*rk(232)    *y(lOH)
     &                      +(-0.630)*rk(233)    *y(lNO3)
          JAC(lHO2 ,lAFG1)= +(-0.522)*rk(247)    *y(lO3)
     &                      +(-1.023)*rk(248)*flg
          JAC(lHO2 ,lAFG2)= +(-0.522)*rk(250)    *y(lO3)
          JAC(lHO2 ,lAFG3)= +(-0.554)*rk(253)    *y(lO3)
          JAC(lHO2 ,lXIPR)= +         rk(434)    *y(lHO2)
     &                      +(-1.000)*rk(434)    *y(lHO2)
          JAC(lHO2 ,lMACR)= +(-0.108)*rk(255)    *y(lO3)
     &                      +(-0.670)*rk(258)*flg
          JAC(lHO2 ,lMVK )= +(-0.064)*rk(260)    *y(lO3)
          JAC(lHO2 ,lXGLD)= +         rk(494)    *y(lHO2)
     &                      +(-1.000)*rk(494)    *y(lHO2)
          JAC(lHO2 ,lXRN3)= +         rk(444)    *y(lHO2)
     &                      +(-1.000)*rk(444)    *y(lHO2)
          JAC(lHO2 ,lGLYD)= +(-2.000)*rk(272)*flg
          JAC(lHO2 ,lXACE)= +         rk(314)    *y(lHO2)
     &                      +(-1.000)*rk(314)    *y(lHO2)
          JAC(lHO2 ,lACRO)= +(-0.830)*rk(275)    *y(lO3)
     &                      +(-1.066)*rk(278)*flg
          JAC(lHO2 ,lXBAL)= +         rk(374)    *y(lHO2)
     &                      +(-1.000)*rk(374)    *y(lHO2)
          JAC(lHO2 ,lXAF3)= +         rk(404)    *y(lHO2)
     &                      +(-1.000)*rk(404)    *y(lHO2)
          JAC(lHO2 ,lXMAC)= +         rk(414)    *y(lHO2)
     &                      +(-1.000)*rk(414)    *y(lHO2)
          JAC(lHO2 ,lXMVK)= +         rk(424)    *y(lHO2)
     &                      +(-1.000)*rk(424)    *y(lHO2)
          JAC(lHO2 ,lYAPX)= +         rk(474)    *y(lHO2)
     &                      +(-1.000)*rk(474)    *y(lHO2)
          JAC(lHO2 ,lXACR)= +         rk(504)    *y(lHO2)
     &                      +(-1.000)*rk(504)    *y(lHO2)
          JAC(lHO2 ,lETHE)= +(-0.160)*rk(515)    *y(lO3)
     &                      +(-0.800)*rk(517)    *y(lO3P)
          JAC(lHO2 ,lPRPE)= +(-0.165)*rk(519)    *y(lO3)
          JAC(lHO2 ,lBD13)= +(-0.080)*rk(523)    *y(lO3)
     &                      +(-0.250)*rk(525)    *y(lO3P)
          JAC(lHO2 ,lISOP)= +(-0.066)*rk(527)    *y(lO3)
          JAC(lHO2 ,lAPIN)= +(-0.009)*rk(531)    *y(lO3)
          JAC(lHO2 ,lACYE)= +(-0.300)*rk(534)    *y(lOH)
     &                      +(-1.500)*rk(535)    *y(lO3)
          JAC(lHO2 ,lBENZ)= +(-0.570)*rk(536)    *y(lOH)
          JAC(lHO2 ,lTOLU)= +(-0.181)*rk(537)    *y(lOH)
          JAC(lHO2 ,lMXYL)= +(-0.159)*rk(538)    *y(lOH)
          JAC(lHO2 ,lOXYL)= +(-0.161)*rk(539)    *y(lOH)
          JAC(lHO2 ,lPXYL)= +(-0.159)*rk(540)    *y(lOH)
          JAC(lHO2 ,lB124)= +(-0.022)*rk(541)    *y(lOH)
          JAC(lHO2 ,lETOH)= +(-0.950)*rk(542)    *y(lOH)
          JAC(lHO2 ,lOLE1)= +(-0.095)*rk(549)    *y(lO3)
          JAC(lHO2 ,lOLE2)= +(-0.094)*rk(553)    *y(lO3)
          JAC(lHO2 ,lARO1)= +(-0.123)*rk(556)    *y(lOH)
          JAC(lHO2 ,lARO2)= +(-0.077)*rk(557)    *y(lOH)
          JAC(lHO2 ,lTERP)= +(-0.078)*rk(559)    *y(lO3)
          JAC(lHO2 ,lSESQ)= +(-0.078)*rk(563)    *y(lO3)
          JAC(lCO  ,lNO  )= +(-1.000)*rk(194)    *y(lXCO)
          JAC(lCO  ,lO3P )= +(-0.510)*rk(517)    *y(lETHE)
          JAC(lCO  ,lO3  )= +(-0.522)*rk(247)    *y(lAFG1)
     &                      +(-0.522)*rk(250)    *y(lAFG2)
     &                      +(-0.580)*rk(253)    *y(lAFG3)
     &                      +(-0.450)*rk(255)    *y(lMACR)
     &                      +(-0.475)*rk(260)    *y(lMVK)
     &                      +(-0.498)*rk(264)    *y(lIPRD)
     &                      +(-1.005)*rk(275)    *y(lACRO)
     &                      +(-0.510)*rk(515)    *y(lETHE)
     &                      +(-0.525)*rk(519)    *y(lPRPE)
          JAC(lCO  ,lO3  )=JAC(lCO  ,lO3  )
     &                      +(-0.255)*rk(523)    *y(lBD13)
     &                      +(-0.275)*rk(527)    *y(lISOP)
     &                      +(-0.029)*rk(531)    *y(lAPIN)
     &                      +(-1.500)*rk(535)    *y(lACYE)
     &                      +(-0.303)*rk(549)    *y(lOLE1)
     &                      +(-0.299)*rk(553)    *y(lOLE2)
     &                      +(-0.249)*rk(559)    *y(lTERP)
     &                      +(-0.249)*rk(563)    *y(lSESQ)
          JAC(lCO  ,lNO3 )= +(-1.000)*rk(196)    *y(lXCO)
     &                      +(-1.000)*rk(207)    *y(lHCHO)
     &                      +(-1.260)*rk(233)    *y(lGLY)
     &                      +(-1.000)*rk(236)    *y(lMGLY)
          JAC(lCO  ,lOH  )= +         rk( 29)    *y(lCO)
     &                      +(-1.000)*rk(206)    *y(lHCHO)
     &                      +(-1.260)*rk(232)    *y(lGLY)
     &                      +(-1.000)*rk(235)    *y(lMGLY)
     &                      +(-0.300)*rk(534)    *y(lACYE)
          JAC(lCO  ,lCO  )= +         rk( 29)    *y(lOH)
          JAC(lCO  ,lMEO2)= +(-0.500)*rk(197)    *y(lXCO)
          JAC(lCO  ,lHCHO)= +(-1.000)*rk(204)*flg
     &                      +(-1.000)*rk(205)*flg
     &                      +(-1.000)*rk(206)    *y(lOH)
     &                      +(-1.000)*rk(207)    *y(lNO3)
          JAC(lCO  ,lRO2C)= +(-0.500)*rk(198)    *y(lXCO)
          JAC(lCO  ,lRO2X)= +(-0.500)*rk(199)    *y(lXCO)
          JAC(lCO  ,lMCO3)= +(-1.000)*rk(200)    *y(lXCO)
          JAC(lCO  ,lRCO3)= +(-1.000)*rk(201)    *y(lXCO)
          JAC(lCO  ,lBZC3)= +(-1.000)*rk(202)    *y(lXCO)
          JAC(lCO  ,lMAC3)= +(-1.000)*rk(203)    *y(lXCO)
          JAC(lCO  ,lACET)= +(-0.380)*rk(215)*flg
          JAC(lCO  ,lXCO )= +(-1.000)*rk(194)    *y(lNO)
     &                      +(-1.000)*rk(196)    *y(lNO3)
     &                      +(-0.500)*rk(197)    *y(lMEO2)
     &                      +(-0.500)*rk(198)    *y(lRO2C)
     &                      +(-0.500)*rk(199)    *y(lRO2X)
     &                      +(-1.000)*rk(200)    *y(lMCO3)
     &                      +(-1.000)*rk(201)    *y(lRCO3)
     &                      +(-1.000)*rk(202)    *y(lBZC3)
     &                      +(-1.000)*rk(203)    *y(lMAC3)
          JAC(lCO  ,lCCHO)= +(-1.000)*rk(209)*flg
          JAC(lCO  ,lRCHO)= +(-1.000)*rk(212)*flg
          JAC(lCO  ,lMGLY)= +(-1.000)*rk(234)*flg
     &                      +(-1.000)*rk(235)    *y(lOH)
     &                      +(-1.000)*rk(236)    *y(lNO3)
          JAC(lCO  ,lIPRD)= +(-0.498)*rk(264)    *y(lO3)
     &                      +(-1.233)*rk(266)*flg
          JAC(lCO  ,lGLY )= +(-2.000)*rk(230)*flg
     &                      +(-1.000)*rk(231)*flg
     &                      +(-1.260)*rk(232)    *y(lOH)
     &                      +(-1.260)*rk(233)    *y(lNO3)
          JAC(lCO  ,lAFG1)= +(-0.522)*rk(247)    *y(lO3)
     &                      +(-0.695)*rk(248)*flg
          JAC(lCO  ,lAFG2)= +(-0.522)*rk(250)    *y(lO3)
          JAC(lCO  ,lAFG3)= +(-0.580)*rk(253)    *y(lO3)
          JAC(lCO  ,lMACR)= +(-0.450)*rk(255)    *y(lO3)
     &                      +(-0.670)*rk(258)*flg
          JAC(lCO  ,lMVK )= +(-0.475)*rk(260)    *y(lO3)
     &                      +(-0.600)*rk(262)*flg
          JAC(lCO  ,lGLYD)= +(-1.000)*rk(272)*flg
          JAC(lCO  ,lACRO)= +(-1.005)*rk(275)    *y(lO3)
     &                      +(-1.188)*rk(278)*flg
          JAC(lCO  ,lETHE)= +(-0.510)*rk(515)    *y(lO3)
     &                      +(-0.510)*rk(517)    *y(lO3P)
          JAC(lCO  ,lPRPE)= +(-0.525)*rk(519)    *y(lO3)
          JAC(lCO  ,lBD13)= +(-0.255)*rk(523)    *y(lO3)
          JAC(lCO  ,lISOP)= +(-0.275)*rk(527)    *y(lO3)
          JAC(lCO  ,lAPIN)= +(-0.029)*rk(531)    *y(lO3)
          JAC(lCO  ,lACYE)= +(-0.300)*rk(534)    *y(lOH)
     &                      +(-1.500)*rk(535)    *y(lO3)
          JAC(lCO  ,lOLE1)= +(-0.303)*rk(549)    *y(lO3)
          JAC(lCO  ,lOLE2)= +(-0.299)*rk(553)    *y(lO3)
          JAC(lCO  ,lTERP)= +(-0.249)*rk(559)    *y(lO3)
          JAC(lCO  ,lSESQ)= +(-0.249)*rk(563)    *y(lO3)
          JAC(lPNA ,lNO2 )= +(-1.000)*rk( 32)    *y(lHO2)
          JAC(lPNA ,lOH  )= +         rk( 35)    *y(lPNA)
          JAC(lPNA ,lHO2 )= +(-1.000)*rk( 32)    *y(lNO2)
          JAC(lPNA ,lPNA )= +         rk( 33)*flg
     &                      +         rk( 34)*flg
     &                      +         rk( 35)    *y(lOH)
          JAC(lH2O2,lOH  )= +         rk( 42)    *y(lH2O2)
          JAC(lH2O2,lHO2 )= +(-2.000)*rk( 37)    *y(lHO2)
     &                      +(-2.000)*rk( 38)    *y(lHO2)*H2O
          JAC(lH2O2,lH2O2)= +         rk( 41)*flg
     &                      +         rk( 42)    *y(lOH)
          JAC(lSO2 ,lOH  )= +         rk( 44)    *y(lSO2)
          JAC(lSO2 ,lSO2 )= +         rk( 44)    *y(lOH)
          JAC(lSULF,lOH  )= +(-1.000)*rk( 44)    *y(lSO2)
          JAC(lSULF,lSO2 )= +(-1.000)*rk( 44)    *y(lOH)
          JAC(lMEO2,lNO  )= +         rk( 46)    *y(lMEO2)
     &                      +(-1.000)*rk( 66)    *y(lMCO3)
     &                      +(-1.000)*rk(144)    *y(lXMEO)
          JAC(lMEO2,lO3P )= +(-0.510)*rk(517)    *y(lETHE)
     &                      +(-0.250)*rk(529)    *y(lISOP)
          JAC(lMEO2,lO3  )= +(-0.355)*rk(519)    *y(lPRPE)
     &                      +(-0.307)*rk(553)    *y(lOLE2)
          JAC(lMEO2,lNO3 )= +         rk( 49)    *y(lMEO2)
     &                      +(-1.000)*rk( 68)    *y(lMCO3)
     &                      +(-1.000)*rk(146)    *y(lXMEO)
          JAC(lMEO2,lOH  )= +(-0.509)*rk(220)    *y(lAACD)
     &                      +(-0.700)*rk(222)    *y(lCOOH)
     &                      +(-1.000)*rk(513)*flg*CH4
          JAC(lMEO2,lHO2 )= +         rk( 47)    *y(lMEO2)
     &                      +         rk( 48)    *y(lMEO2)
          JAC(lMEO2,lMEO2)= +         rk( 46)    *y(lNO)
     &                      +         rk( 47)    *y(lHO2)
     &                      +         rk( 48)    *y(lHO2)
     &                      +         rk( 49)    *y(lNO3)
     &                      +( 4.000)*rk( 50)    *y(lMEO2)
     &                      +( 4.000)*rk( 51)    *y(lMEO2)
     &                      +         rk( 55)    *y(lRO2C)
     &                      +         rk( 60)    *y(lRO2X)
     &                      +         rk( 69)    *y(lMCO3)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +(-0.900)*rk( 69)    *y(lMCO3)
     &                      +         rk( 79)    *y(lRCO3)
     &                      +         rk( 90)    *y(lBZC3)
     &                      +         rk(102)    *y(lMAC3)
     &                      +         rk(117)    *y(lXHO2)
     &                      +(-1.000)*rk(117)    *y(lXHO2)
     &                      +         rk(127)    *y(lXOH)
     &                      +(-1.000)*rk(127)    *y(lXOH)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(137)    *y(lXNO2)
     &                      +(-1.000)*rk(137)    *y(lXNO2)
     &                      +         rk(147)    *y(lXMEO)
     &                      +(-1.500)*rk(147)    *y(lXMEO)
     &                      +         rk(157)    *y(lXMC3)
     &                      +(-1.000)*rk(157)    *y(lXMC3)
     &                      +         rk(167)    *y(lXRC3)
     &                      +(-1.000)*rk(167)    *y(lXRC3)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(177)    *y(lXMA3)
     &                      +(-1.000)*rk(177)    *y(lXMA3)
     &                      +         rk(187)    *y(lXTBU)
     &                      +(-1.000)*rk(187)    *y(lXTBU)
     &                      +         rk(197)    *y(lXCO)
     &                      +(-1.000)*rk(197)    *y(lXCO)
     &                      +         rk(286)    *y(lXHCH)
     &                      +(-1.000)*rk(286)    *y(lXHCH)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(296)    *y(lXCCH)
     &                      +(-1.000)*rk(296)    *y(lXCCH)
     &                      +         rk(306)    *y(lXRCH)
     &                      +(-1.000)*rk(306)    *y(lXRCH)
     &                      +         rk(316)    *y(lXACE)
     &                      +(-1.000)*rk(316)    *y(lXACE)
     &                      +         rk(326)    *y(lXMEK)
     &                      +(-1.000)*rk(326)    *y(lXMEK)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(336)    *y(lXPD2)
     &                      +(-1.000)*rk(336)    *y(lXPD2)
     &                      +         rk(346)    *y(lXGLY)
     &                      +(-1.000)*rk(346)    *y(lXGLY)
     &                      +         rk(356)    *y(lXMGL)
     &                      +(-1.000)*rk(356)    *y(lXMGL)
     &                      +         rk(366)    *y(lXBAC)
     &                      +(-1.000)*rk(366)    *y(lXBAC)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(376)    *y(lXBAL)
     &                      +(-1.000)*rk(376)    *y(lXBAL)
     &                      +         rk(386)    *y(lXAF1)
     &                      +(-1.000)*rk(386)    *y(lXAF1)
     &                      +         rk(396)    *y(lXAF2)
     &                      +(-1.000)*rk(396)    *y(lXAF2)
     &                      +         rk(406)    *y(lXAF3)
     &                      +(-1.000)*rk(406)    *y(lXAF3)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(416)    *y(lXMAC)
     &                      +(-1.000)*rk(416)    *y(lXMAC)
     &                      +         rk(426)    *y(lXMVK)
     &                      +(-1.000)*rk(426)    *y(lXMVK)
     &                      +         rk(436)    *y(lXIPR)
     &                      +(-1.000)*rk(436)    *y(lXIPR)
     &                      +         rk(446)    *y(lXRN3)
     &                      +(-1.000)*rk(446)    *y(lXRN3)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(456)    *y(lYRPX)
     &                      +(-1.000)*rk(456)    *y(lYRPX)
     &                      +         rk(466)    *y(lY6PX)
     &                      +(-1.000)*rk(466)    *y(lY6PX)
     &                      +         rk(476)    *y(lYAPX)
     &                      +(-1.000)*rk(476)    *y(lYAPX)
     &                      +         rk(486)    *y(lZRN3)
     &                      +(-1.000)*rk(486)    *y(lZRN3)
          JAC(lMEO2,lMEO2)=JAC(lMEO2,lMEO2)
     &                      +         rk(496)    *y(lXGLD)
     &                      +(-1.000)*rk(496)    *y(lXGLD)
     &                      +         rk(506)    *y(lXACR)
     &                      +(-1.000)*rk(506)    *y(lXACR)
          JAC(lMEO2,lCOOH)= +(-0.700)*rk(222)    *y(lOH)
          JAC(lMEO2,lRO2C)= +         rk( 55)    *y(lMEO2)
     &                      +(-1.000)*rk( 70)    *y(lMCO3)
     &                      +(-0.500)*rk(148)    *y(lXMEO)
          JAC(lMEO2,lRO2X)= +         rk( 60)    *y(lMEO2)
     &                      +(-1.000)*rk( 71)    *y(lMCO3)
     &                      +(-0.500)*rk(149)    *y(lXMEO)
          JAC(lMEO2,lMCO3)= +(-1.000)*rk( 66)    *y(lNO)
     &                      +(-1.000)*rk( 68)    *y(lNO3)
     &                      +         rk( 69)    *y(lMEO2)
     &                      +(-0.900)*rk( 69)    *y(lMEO2)
     &                      +(-1.000)*rk( 70)    *y(lRO2C)
     &                      +(-1.000)*rk( 71)    *y(lRO2X)
     &                      +(-4.000)*rk( 72)    *y(lMCO3)
     &                      +(-1.000)*rk( 82)    *y(lRCO3)
     &                      +(-1.000)*rk( 93)    *y(lBZC3)
          JAC(lMEO2,lMCO3)=JAC(lMEO2,lMCO3)
     &                      +(-1.000)*rk(105)    *y(lMAC3)
     &                      +(-1.000)*rk(150)    *y(lXMEO)
          JAC(lMEO2,lPAN )= +(-0.400)*rk( 65)*flg
          JAC(lMEO2,lCO3H)= +(-1.000)*rk(280)*flg
          JAC(lMEO2,lAACD)= +(-0.509)*rk(220)    *y(lOH)
          JAC(lMEO2,lRCO3)= +         rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk( 82)    *y(lMCO3)
     &                      +(-1.000)*rk(151)    *y(lXMEO)
          JAC(lMEO2,lXHO2)= +         rk(117)    *y(lMEO2)
     &                      +(-1.000)*rk(117)    *y(lMEO2)
          JAC(lMEO2,lYRPX)= +         rk(456)    *y(lMEO2)
     &                      +(-1.000)*rk(456)    *y(lMEO2)
          JAC(lMEO2,lXCCH)= +         rk(296)    *y(lMEO2)
     &                      +(-1.000)*rk(296)    *y(lMEO2)
          JAC(lMEO2,lBZC3)= +         rk( 90)    *y(lMEO2)
     &                      +(-1.000)*rk( 93)    *y(lMCO3)
     &                      +(-1.000)*rk(152)    *y(lXMEO)
          JAC(lMEO2,lMAC3)= +         rk(102)    *y(lMEO2)
     &                      +(-1.000)*rk(105)    *y(lMCO3)
     &                      +(-1.000)*rk(153)    *y(lXMEO)
          JAC(lMEO2,lTBUO)= +(-1.000)*rk(110)*flg
          JAC(lMEO2,lACET)= +(-1.380)*rk(215)*flg
          JAC(lMEO2,lXOH )= +         rk(127)    *y(lMEO2)
     &                      +(-1.000)*rk(127)    *y(lMEO2)
          JAC(lMEO2,lXNO2)= +         rk(137)    *y(lMEO2)
     &                      +(-1.000)*rk(137)    *y(lMEO2)
          JAC(lMEO2,lXMEO)= +(-1.000)*rk(144)    *y(lNO)
     &                      +(-1.000)*rk(146)    *y(lNO3)
     &                      +         rk(147)    *y(lMEO2)
     &                      +(-1.500)*rk(147)    *y(lMEO2)
     &                      +(-0.500)*rk(148)    *y(lRO2C)
     &                      +(-0.500)*rk(149)    *y(lRO2X)
     &                      +(-1.000)*rk(150)    *y(lMCO3)
     &                      +(-1.000)*rk(151)    *y(lRCO3)
     &                      +(-1.000)*rk(152)    *y(lBZC3)
          JAC(lMEO2,lXMEO)=JAC(lMEO2,lXMEO)
     &                      +(-1.000)*rk(153)    *y(lMAC3)
          JAC(lMEO2,lXMC3)= +         rk(157)    *y(lMEO2)
     &                      +(-1.000)*rk(157)    *y(lMEO2)
          JAC(lMEO2,lXRC3)= +         rk(167)    *y(lMEO2)
     &                      +(-1.000)*rk(167)    *y(lMEO2)
          JAC(lMEO2,lXMA3)= +         rk(177)    *y(lMEO2)
     &                      +(-1.000)*rk(177)    *y(lMEO2)
          JAC(lMEO2,lXTBU)= +         rk(187)    *y(lMEO2)
     &                      +(-1.000)*rk(187)    *y(lMEO2)
          JAC(lMEO2,lXCO )= +         rk(197)    *y(lMEO2)
     &                      +(-1.000)*rk(197)    *y(lMEO2)
          JAC(lMEO2,lCCHO)= +(-1.000)*rk(209)*flg
          JAC(lMEO2,lXHCH)= +         rk(286)    *y(lMEO2)
     &                      +(-1.000)*rk(286)    *y(lMEO2)
          JAC(lMEO2,lZRN3)= +         rk(486)    *y(lMEO2)
     &                      +(-1.000)*rk(486)    *y(lMEO2)
          JAC(lMEO2,lXRCH)= +         rk(306)    *y(lMEO2)
     &                      +(-1.000)*rk(306)    *y(lMEO2)
          JAC(lMEO2,lXMGL)= +         rk(356)    *y(lMEO2)
     &                      +(-1.000)*rk(356)    *y(lMEO2)
          JAC(lMEO2,lXBAC)= +         rk(366)    *y(lMEO2)
     &                      +(-1.000)*rk(366)    *y(lMEO2)
          JAC(lMEO2,lXPD2)= +         rk(336)    *y(lMEO2)
     &                      +(-1.000)*rk(336)    *y(lMEO2)
          JAC(lMEO2,lY6PX)= +         rk(466)    *y(lMEO2)
     &                      +(-1.000)*rk(466)    *y(lMEO2)
          JAC(lMEO2,lXGLY)= +         rk(346)    *y(lMEO2)
     &                      +(-1.000)*rk(346)    *y(lMEO2)
          JAC(lMEO2,lXMEK)= +         rk(326)    *y(lMEO2)
     &                      +(-1.000)*rk(326)    *y(lMEO2)
          JAC(lMEO2,lXAF1)= +         rk(386)    *y(lMEO2)
     &                      +(-1.000)*rk(386)    *y(lMEO2)
          JAC(lMEO2,lXAF2)= +         rk(396)    *y(lMEO2)
     &                      +(-1.000)*rk(396)    *y(lMEO2)
          JAC(lMEO2,lAFG1)= +(-0.173)*rk(248)*flg
          JAC(lMEO2,lXIPR)= +         rk(436)    *y(lMEO2)
     &                      +(-1.000)*rk(436)    *y(lMEO2)
          JAC(lMEO2,lMVK )= +(-0.400)*rk(262)*flg
          JAC(lMEO2,lXGLD)= +         rk(496)    *y(lMEO2)
     &                      +(-1.000)*rk(496)    *y(lMEO2)
          JAC(lMEO2,lXRN3)= +         rk(446)    *y(lMEO2)
     &                      +(-1.000)*rk(446)    *y(lMEO2)
          JAC(lMEO2,lXACE)= +         rk(316)    *y(lMEO2)
     &                      +(-1.000)*rk(316)    *y(lMEO2)
          JAC(lMEO2,lACRO)= +(-0.234)*rk(278)*flg
          JAC(lMEO2,lXBAL)= +         rk(376)    *y(lMEO2)
     &                      +(-1.000)*rk(376)    *y(lMEO2)
          JAC(lMEO2,lXAF3)= +         rk(406)    *y(lMEO2)
     &                      +(-1.000)*rk(406)    *y(lMEO2)
          JAC(lMEO2,lXMAC)= +         rk(416)    *y(lMEO2)
     &                      +(-1.000)*rk(416)    *y(lMEO2)
          JAC(lMEO2,lXMVK)= +         rk(426)    *y(lMEO2)
     &                      +(-1.000)*rk(426)    *y(lMEO2)
          JAC(lMEO2,lYAPX)= +         rk(476)    *y(lMEO2)
     &                      +(-1.000)*rk(476)    *y(lMEO2)
          JAC(lMEO2,lXACR)= +         rk(506)    *y(lMEO2)
     &                      +(-1.000)*rk(506)    *y(lMEO2)
          JAC(lMEO2,lETHE)= +(-0.510)*rk(517)    *y(lO3P)
          JAC(lMEO2,lPRPE)= +(-0.355)*rk(519)    *y(lO3)
          JAC(lMEO2,lISOP)= +(-0.250)*rk(529)    *y(lO3P)
          JAC(lMEO2,lOLE2)= +(-0.307)*rk(553)    *y(lO3)
          JAC(lHCHO,lNO  )= +(-1.000)*rk( 46)    *y(lMEO2)
     &                      +(-1.000)*rk( 99)    *y(lMAC3)
     &                      +(-1.000)*rk(283)    *y(lXHCH)
          JAC(lHCHO,lO3  )= +(-0.100)*rk(255)    *y(lMACR)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.124)*rk(264)    *y(lIPRD)
     &                      +(-0.500)*rk(275)    *y(lACRO)
     &                      +(-1.000)*rk(515)    *y(lETHE)
     &                      +(-0.500)*rk(519)    *y(lPRPE)
     &                      +(-0.500)*rk(523)    *y(lBD13)
     &                      +(-0.400)*rk(527)    *y(lISOP)
     &                      +(-0.500)*rk(549)    *y(lOLE1)
          JAC(lHCHO,lO3  )=JAC(lHCHO,lO3  )
     &                      +(-0.131)*rk(553)    *y(lOLE2)
     &                      +(-0.127)*rk(559)    *y(lTERP)
     &                      +(-0.127)*rk(563)    *y(lSESQ)
          JAC(lHCHO,lNO3 )= +(-1.000)*rk( 49)    *y(lMEO2)
     &                      +(-1.000)*rk(101)    *y(lMAC3)
     &                      +         rk(207)    *y(lHCHO)
     &                      +(-1.000)*rk(285)    *y(lXHCH)
          JAC(lHCHO,lOH  )= +         rk(206)    *y(lHCHO)
     &                      +(-1.000)*rk(218)    *y(lMEOH)
     &                      +(-0.300)*rk(222)    *y(lCOOH)
     &                      +(-0.002)*rk(267)    *y(lPRD2)
          JAC(lHCHO,lHO2 )= +(-1.000)*rk( 48)    *y(lMEO2)
          JAC(lHCHO,lMEO2)= +(-1.000)*rk( 46)    *y(lNO)
     &                      +(-1.000)*rk( 48)    *y(lHO2)
     &                      +(-1.000)*rk( 49)    *y(lNO3)
     &                      +(-2.000)*rk( 50)    *y(lMEO2)
     &                      +(-4.000)*rk( 51)    *y(lMEO2)
     &                      +(-0.750)*rk( 55)    *y(lRO2C)
     &                      +(-0.750)*rk( 60)    *y(lRO2X)
     &                      +(-1.000)*rk( 69)    *y(lMCO3)
     &                      +(-1.000)*rk( 79)    *y(lRCO3)
          JAC(lHCHO,lMEO2)=JAC(lHCHO,lMEO2)
     &                      +(-1.000)*rk( 90)    *y(lBZC3)
     &                      +(-2.000)*rk(102)    *y(lMAC3)
     &                      +(-0.500)*rk(286)    *y(lXHCH)
          JAC(lHCHO,lHCHO)= +         rk(204)*flg
     &                      +         rk(205)*flg
     &                      +         rk(206)    *y(lOH)
     &                      +         rk(207)    *y(lNO3)
          JAC(lHCHO,lCOOH)= +(-0.300)*rk(222)    *y(lOH)
     &                      +(-1.000)*rk(223)*flg
          JAC(lHCHO,lMEOH)= +(-1.000)*rk(218)    *y(lOH)
          JAC(lHCHO,lRO2C)= +(-0.750)*rk( 55)    *y(lMEO2)
     &                      +(-1.000)*rk(103)    *y(lMAC3)
     &                      +(-0.500)*rk(287)    *y(lXHCH)
          JAC(lHCHO,lRO2X)= +(-0.750)*rk( 60)    *y(lMEO2)
     &                      +(-1.000)*rk(104)    *y(lMAC3)
     &                      +(-0.500)*rk(288)    *y(lXHCH)
          JAC(lHCHO,lMCO3)= +(-1.000)*rk( 69)    *y(lMEO2)
     &                      +(-1.000)*rk(105)    *y(lMAC3)
     &                      +(-1.000)*rk(289)    *y(lXHCH)
          JAC(lHCHO,lRCO3)= +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
     &                      +(-1.000)*rk(290)    *y(lXHCH)
          JAC(lHCHO,lBZC3)= +(-1.000)*rk( 90)    *y(lMEO2)
     &                      +(-1.000)*rk(107)    *y(lMAC3)
     &                      +(-1.000)*rk(291)    *y(lXHCH)
          JAC(lHCHO,lMAC3)= +(-1.000)*rk( 99)    *y(lNO)
     &                      +(-1.000)*rk(101)    *y(lNO3)
     &                      +(-2.000)*rk(102)    *y(lMEO2)
     &                      +(-1.000)*rk(103)    *y(lRO2C)
     &                      +(-1.000)*rk(104)    *y(lRO2X)
     &                      +(-1.000)*rk(105)    *y(lMCO3)
     &                      +(-1.000)*rk(106)    *y(lRCO3)
     &                      +(-1.000)*rk(107)    *y(lBZC3)
     &                      +(-4.000)*rk(108)    *y(lMAC3)
          JAC(lHCHO,lMAC3)=JAC(lHCHO,lMAC3)
     &                      +(-1.000)*rk(292)    *y(lXHCH)
          JAC(lHCHO,lMPAN)= +(-0.400)*rk( 98)*flg
          JAC(lHCHO,lRNO3)= +(-0.074)*rk(270)*flg
          JAC(lHCHO,lXHCH)= +(-1.000)*rk(283)    *y(lNO)
     &                      +(-1.000)*rk(285)    *y(lNO3)
     &                      +(-0.500)*rk(286)    *y(lMEO2)
     &                      +(-0.500)*rk(287)    *y(lRO2C)
     &                      +(-0.500)*rk(288)    *y(lRO2X)
     &                      +(-1.000)*rk(289)    *y(lMCO3)
     &                      +(-1.000)*rk(290)    *y(lRCO3)
     &                      +(-1.000)*rk(291)    *y(lBZC3)
     &                      +(-1.000)*rk(292)    *y(lMAC3)
          JAC(lHCHO,lPRD2)= +(-0.002)*rk(267)    *y(lOH)
          JAC(lHCHO,lIPRD)= +(-0.124)*rk(264)    *y(lO3)
     &                      +(-0.300)*rk(266)*flg
          JAC(lHCHO,lGLY )= +(-1.000)*rk(231)*flg
          JAC(lHCHO,lMACR)= +(-0.100)*rk(255)    *y(lO3)
     &                      +(-0.340)*rk(258)*flg
          JAC(lHCHO,lMVK )= +(-0.050)*rk(260)    *y(lO3)
          JAC(lHCHO,lGLYD)= +(-1.000)*rk(272)*flg
          JAC(lHCHO,lACRO)= +(-0.500)*rk(275)    *y(lO3)
     &                      +(-0.340)*rk(278)*flg
          JAC(lHCHO,lETHE)= +(-1.000)*rk(515)    *y(lO3)
          JAC(lHCHO,lPRPE)= +(-0.500)*rk(519)    *y(lO3)
          JAC(lHCHO,lBD13)= +(-0.500)*rk(523)    *y(lO3)
          JAC(lHCHO,lISOP)= +(-0.400)*rk(527)    *y(lO3)
          JAC(lHCHO,lOLE1)= +(-0.500)*rk(549)    *y(lO3)
          JAC(lHCHO,lOLE2)= +(-0.131)*rk(553)    *y(lO3)
          JAC(lHCHO,lTERP)= +(-0.127)*rk(559)    *y(lO3)
          JAC(lHCHO,lSESQ)= +(-0.127)*rk(563)    *y(lO3)
          JAC(lCOOH,lOH  )= +         rk(222)    *y(lCOOH)
          JAC(lCOOH,lHO2 )= +(-1.000)*rk( 47)    *y(lMEO2)
          JAC(lCOOH,lMEO2)= +(-1.000)*rk( 47)    *y(lHO2)
          JAC(lCOOH,lCOOH)= +         rk(222)    *y(lOH)
     &                      +         rk(223)*flg
          JAC(lMEOH,lOH  )= +         rk(218)    *y(lMEOH)
          JAC(lMEOH,lMEO2)= +(-2.000)*rk( 50)    *y(lMEO2)
     &                      +(-0.250)*rk( 55)    *y(lRO2C)
     &                      +(-0.250)*rk( 60)    *y(lRO2X)
          JAC(lMEOH,lMEOH)= +         rk(218)    *y(lOH)
          JAC(lMEOH,lRO2C)= +(-0.250)*rk( 55)    *y(lMEO2)
          JAC(lMEOH,lRO2X)= +(-0.250)*rk( 60)    *y(lMEO2)
          JAC(lRO2C,lNO  )= +         rk( 52)    *y(lRO2C)
     &                      +(-1.000)*rk( 76)    *y(lRCO3)
     &                      +(-1.000)*rk( 87)    *y(lBZC3)
          JAC(lRO2C,lO3P )= +(-0.290)*rk(517)    *y(lETHE)
     &                      +(-0.235)*rk(525)    *y(lBD13)
     &                      +(-0.240)*rk(529)    *y(lISOP)
          JAC(lRO2C,lO3  )= +(-0.652)*rk(247)    *y(lAFG1)
     &                      +(-0.652)*rk(250)    *y(lAFG2)
     &                      +(-0.258)*rk(253)    *y(lAFG3)
     &                      +(-0.100)*rk(255)    *y(lMACR)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.048)*rk(264)    *y(lIPRD)
     &                      +(-0.192)*rk(527)    *y(lISOP)
     &                      +(-1.511)*rk(531)    *y(lAPIN)
     &                      +(-0.090)*rk(549)    *y(lOLE1)
          JAC(lRO2C,lO3  )=JAC(lRO2C,lO3  )
     &                      +(-0.212)*rk(553)    *y(lOLE2)
     &                      +(-0.490)*rk(559)    *y(lTERP)
     &                      +(-0.490)*rk(563)    *y(lSESQ)
          JAC(lRO2C,lNO3 )= +         rk( 54)    *y(lRO2C)
     &                      +(-1.000)*rk( 78)    *y(lRCO3)
     &                      +(-1.000)*rk( 89)    *y(lBZC3)
     &                      +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.799)*rk(265)    *y(lIPRD)
     &                      +(-0.031)*rk(276)    *y(lACRO)
     &                      +(-1.000)*rk(516)    *y(lETHE)
     &                      +(-0.949)*rk(520)    *y(lPRPE)
     &                      +(-1.055)*rk(524)    *y(lBD13)
          JAC(lRO2C,lNO3 )=JAC(lRO2C,lNO3 )
     &                      +(-0.936)*rk(528)    *y(lISOP)
     &                      +(-1.050)*rk(532)    *y(lAPIN)
     &                      +(-1.463)*rk(550)    *y(lOLE1)
     &                      +(-1.193)*rk(554)    *y(lOLE2)
     &                      +(-1.786)*rk(560)    *y(lTERP)
     &                      +(-1.786)*rk(564)    *y(lSESQ)
          JAC(lRO2C,lOH  )= +(-0.035)*rk(211)    *y(lRCHO)
     &                      +(-1.000)*rk(214)    *y(lACET)
     &                      +(-0.967)*rk(216)    *y(lMEK)
     &                      +(-0.491)*rk(220)    *y(lAACD)
     &                      +(-1.000)*rk(221)    *y(lPACD)
     &                      +(-0.251)*rk(224)    *y(lROOH)
     &                      +(-0.222)*rk(226)    *y(lR6PX)
     &                      +(-0.589)*rk(228)    *y(lRAPX)
     &                      +(-0.800)*rk(238)    *y(lCRES)
          JAC(lRO2C,lOH  )=JAC(lRO2C,lOH  )
     &                      +(-0.723)*rk(246)    *y(lAFG1)
     &                      +(-0.723)*rk(249)    *y(lAFG2)
     &                      +(-0.733)*rk(252)    *y(lAFG3)
     &                      +(-0.500)*rk(254)    *y(lMACR)
     &                      +(-0.975)*rk(259)    *y(lMVK)
     &                      +(-0.670)*rk(263)    *y(lIPRD)
     &                      +(-0.473)*rk(267)    *y(lPRD2)
     &                      +(-0.976)*rk(269)    *y(lRNO3)
          JAC(lRO2C,lOH  )=JAC(lRO2C,lOH  )
     &                      +(-0.250)*rk(274)    *y(lACRO)
     &                      +(-0.020)*rk(279)    *y(lCO3H)
     &                      +(-0.194)*rk(281)    *y(lRO3H)
     &                      +(-1.000)*rk(514)    *y(lETHE)
     &                      +(-0.984)*rk(518)    *y(lPRPE)
     &                      +(-1.189)*rk(522)    *y(lBD13)
     &                      +(-0.986)*rk(526)    *y(lISOP)
     &                      +(-1.042)*rk(530)    *y(lAPIN)
          JAC(lRO2C,lOH  )=JAC(lRO2C,lOH  )
     &                      +(-0.290)*rk(536)    *y(lBENZ)
     &                      +(-0.454)*rk(537)    *y(lTOLU)
     &                      +(-0.520)*rk(538)    *y(lMXYL)
     &                      +(-0.554)*rk(539)    *y(lOXYL)
     &                      +(-0.487)*rk(540)    *y(lPXYL)
     &                      +(-0.627)*rk(541)    *y(lB124)
     &                      +(-0.050)*rk(542)    *y(lETOH)
     &                      +(-1.000)*rk(543)    *y(lALK1)
          JAC(lRO2C,lOH  )=JAC(lRO2C,lOH  )
     &                      +(-0.965)*rk(544)    *y(lALK2)
     &                      +(-1.253)*rk(545)    *y(lALK3)
     &                      +(-1.763)*rk(546)    *y(lALK4)
     &                      +(-1.605)*rk(547)    *y(lALK5)
     &                      +(-1.202)*rk(548)    *y(lOLE1)
     &                      +(-0.953)*rk(552)    *y(lOLE2)
     &                      +(-0.566)*rk(556)    *y(lARO1)
     &                      +(-0.617)*rk(557)    *y(lARO2)
          JAC(lRO2C,lOH  )=JAC(lRO2C,lOH  )
     &                      +(-1.211)*rk(558)    *y(lTERP)
     &                      +(-1.211)*rk(562)    *y(lSESQ)
          JAC(lRO2C,lHO2 )= +         rk( 53)    *y(lRO2C)
          JAC(lRO2C,lMEO2)= +         rk( 55)    *y(lRO2C)
     &                      +(-1.000)*rk( 79)    *y(lRCO3)
     &                      +(-1.000)*rk( 90)    *y(lBZC3)
          JAC(lRO2C,lRO2C)= +         rk( 52)    *y(lNO)
     &                      +         rk( 53)    *y(lHO2)
     &                      +         rk( 54)    *y(lNO3)
     &                      +         rk( 55)    *y(lMEO2)
     &                      +( 4.000)*rk( 56)    *y(lRO2C)
     &                      +         rk( 61)    *y(lRO2X)
     &                      +         rk( 70)    *y(lMCO3)
     &                      +         rk( 80)    *y(lRCO3)
     &                      +(-1.000)*rk( 80)    *y(lRCO3)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +         rk( 91)    *y(lBZC3)
     &                      +(-1.000)*rk( 91)    *y(lBZC3)
     &                      +         rk(103)    *y(lMAC3)
     &                      +         rk(118)    *y(lXHO2)
     &                      +(-1.000)*rk(118)    *y(lXHO2)
     &                      +         rk(128)    *y(lXOH)
     &                      +(-1.000)*rk(128)    *y(lXOH)
     &                      +         rk(138)    *y(lXNO2)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(138)    *y(lXNO2)
     &                      +         rk(148)    *y(lXMEO)
     &                      +(-1.000)*rk(148)    *y(lXMEO)
     &                      +         rk(158)    *y(lXMC3)
     &                      +(-1.000)*rk(158)    *y(lXMC3)
     &                      +         rk(168)    *y(lXRC3)
     &                      +(-1.000)*rk(168)    *y(lXRC3)
     &                      +         rk(178)    *y(lXMA3)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(178)    *y(lXMA3)
     &                      +         rk(188)    *y(lXTBU)
     &                      +(-1.000)*rk(188)    *y(lXTBU)
     &                      +         rk(198)    *y(lXCO)
     &                      +(-1.000)*rk(198)    *y(lXCO)
     &                      +         rk(287)    *y(lXHCH)
     &                      +(-1.000)*rk(287)    *y(lXHCH)
     &                      +         rk(297)    *y(lXCCH)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(297)    *y(lXCCH)
     &                      +         rk(307)    *y(lXRCH)
     &                      +(-1.000)*rk(307)    *y(lXRCH)
     &                      +         rk(317)    *y(lXACE)
     &                      +(-1.000)*rk(317)    *y(lXACE)
     &                      +         rk(327)    *y(lXMEK)
     &                      +(-1.000)*rk(327)    *y(lXMEK)
     &                      +         rk(337)    *y(lXPD2)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(337)    *y(lXPD2)
     &                      +         rk(347)    *y(lXGLY)
     &                      +(-1.000)*rk(347)    *y(lXGLY)
     &                      +         rk(357)    *y(lXMGL)
     &                      +(-1.000)*rk(357)    *y(lXMGL)
     &                      +         rk(367)    *y(lXBAC)
     &                      +(-1.000)*rk(367)    *y(lXBAC)
     &                      +         rk(377)    *y(lXBAL)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(377)    *y(lXBAL)
     &                      +         rk(387)    *y(lXAF1)
     &                      +(-1.000)*rk(387)    *y(lXAF1)
     &                      +         rk(397)    *y(lXAF2)
     &                      +(-1.000)*rk(397)    *y(lXAF2)
     &                      +         rk(407)    *y(lXAF3)
     &                      +(-1.000)*rk(407)    *y(lXAF3)
     &                      +         rk(417)    *y(lXMAC)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(417)    *y(lXMAC)
     &                      +         rk(427)    *y(lXMVK)
     &                      +(-1.000)*rk(427)    *y(lXMVK)
     &                      +         rk(437)    *y(lXIPR)
     &                      +(-1.000)*rk(437)    *y(lXIPR)
     &                      +         rk(447)    *y(lXRN3)
     &                      +(-1.000)*rk(447)    *y(lXRN3)
     &                      +         rk(457)    *y(lYRPX)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(457)    *y(lYRPX)
     &                      +         rk(467)    *y(lY6PX)
     &                      +(-1.000)*rk(467)    *y(lY6PX)
     &                      +         rk(477)    *y(lYAPX)
     &                      +(-1.000)*rk(477)    *y(lYAPX)
     &                      +         rk(487)    *y(lZRN3)
     &                      +(-1.000)*rk(487)    *y(lZRN3)
     &                      +         rk(497)    *y(lXGLD)
          JAC(lRO2C,lRO2C)=JAC(lRO2C,lRO2C)
     &                      +(-1.000)*rk(497)    *y(lXGLD)
     &                      +         rk(507)    *y(lXACR)
     &                      +(-1.000)*rk(507)    *y(lXACR)
          JAC(lRO2C,lRO2X)= +         rk( 61)    *y(lRO2C)
     &                      +(-1.000)*rk( 81)    *y(lRCO3)
     &                      +(-1.000)*rk( 92)    *y(lBZC3)
          JAC(lRO2C,lMCO3)= +         rk( 70)    *y(lRO2C)
     &                      +(-1.000)*rk( 82)    *y(lRCO3)
     &                      +(-1.000)*rk( 93)    *y(lBZC3)
          JAC(lRO2C,lCO3H)= +(-0.020)*rk(279)    *y(lOH)
          JAC(lRO2C,lAACD)= +(-0.491)*rk(220)    *y(lOH)
          JAC(lRO2C,lRCO3)= +(-1.000)*rk( 76)    *y(lNO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +         rk( 80)    *y(lRO2C)
     &                      +(-1.000)*rk( 80)    *y(lRO2C)
     &                      +(-1.000)*rk( 81)    *y(lRO2X)
     &                      +(-1.000)*rk( 82)    *y(lMCO3)
     &                      +(-4.000)*rk( 83)    *y(lRCO3)
     &                      +(-2.000)*rk( 94)    *y(lBZC3)
          JAC(lRO2C,lRCO3)=JAC(lRO2C,lRCO3)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
          JAC(lRO2C,lPAN2)= +(-0.400)*rk( 75)*flg
          JAC(lRO2C,lXHO2)= +         rk(118)    *y(lRO2C)
     &                      +(-1.000)*rk(118)    *y(lRO2C)
          JAC(lRO2C,lYRPX)= +         rk(457)    *y(lRO2C)
     &                      +(-1.000)*rk(457)    *y(lRO2C)
          JAC(lRO2C,lXCCH)= +         rk(297)    *y(lRO2C)
     &                      +(-1.000)*rk(297)    *y(lRO2C)
          JAC(lRO2C,lRO3H)= +(-0.194)*rk(281)    *y(lOH)
          JAC(lRO2C,lPACD)= +(-1.000)*rk(221)    *y(lOH)
          JAC(lRO2C,lBZC3)= +(-1.000)*rk( 87)    *y(lNO)
     &                      +(-1.000)*rk( 89)    *y(lNO3)
     &                      +(-1.000)*rk( 90)    *y(lMEO2)
     &                      +         rk( 91)    *y(lRO2C)
     &                      +(-1.000)*rk( 91)    *y(lRO2C)
     &                      +(-1.000)*rk( 92)    *y(lRO2X)
     &                      +(-1.000)*rk( 93)    *y(lMCO3)
     &                      +(-2.000)*rk( 94)    *y(lRCO3)
     &                      +(-4.000)*rk( 95)    *y(lBZC3)
          JAC(lRO2C,lBZC3)=JAC(lRO2C,lBZC3)
     &                      +(-1.000)*rk(107)    *y(lMAC3)
          JAC(lRO2C,lPBZN)= +(-0.400)*rk( 86)*flg
          JAC(lRO2C,lBZO )= +(-1.000)*rk(113)*flg
          JAC(lRO2C,lMAC3)= +         rk(103)    *y(lRO2C)
     &                      +(-1.000)*rk(106)    *y(lRCO3)
     &                      +(-1.000)*rk(107)    *y(lBZC3)
          JAC(lRO2C,lRNO3)= +(-0.976)*rk(269)    *y(lOH)
     &                      +(-0.721)*rk(270)*flg
          JAC(lRO2C,lACET)= +(-1.000)*rk(214)    *y(lOH)
          JAC(lRO2C,lCRES)= +(-0.800)*rk(238)    *y(lOH)
          JAC(lRO2C,lXOH )= +         rk(128)    *y(lRO2C)
     &                      +(-1.000)*rk(128)    *y(lRO2C)
          JAC(lRO2C,lXNO2)= +         rk(138)    *y(lRO2C)
     &                      +(-1.000)*rk(138)    *y(lRO2C)
          JAC(lRO2C,lXMEO)= +         rk(148)    *y(lRO2C)
     &                      +(-1.000)*rk(148)    *y(lRO2C)
          JAC(lRO2C,lXMC3)= +         rk(158)    *y(lRO2C)
     &                      +(-1.000)*rk(158)    *y(lRO2C)
          JAC(lRO2C,lXRC3)= +         rk(168)    *y(lRO2C)
     &                      +(-1.000)*rk(168)    *y(lRO2C)
          JAC(lRO2C,lXMA3)= +         rk(178)    *y(lRO2C)
     &                      +(-1.000)*rk(178)    *y(lRO2C)
          JAC(lRO2C,lXTBU)= +         rk(188)    *y(lRO2C)
     &                      +(-1.000)*rk(188)    *y(lRO2C)
          JAC(lRO2C,lXCO )= +         rk(198)    *y(lRO2C)
     &                      +(-1.000)*rk(198)    *y(lRO2C)
          JAC(lRO2C,lRCHO)= +(-0.035)*rk(211)    *y(lOH)
     &                      +(-1.000)*rk(212)*flg
          JAC(lRO2C,lXHCH)= +         rk(287)    *y(lRO2C)
     &                      +(-1.000)*rk(287)    *y(lRO2C)
          JAC(lRO2C,lMEK )= +(-0.967)*rk(216)    *y(lOH)
     &                      +(-1.000)*rk(217)*flg
          JAC(lRO2C,lZRN3)= +         rk(487)    *y(lRO2C)
     &                      +(-1.000)*rk(487)    *y(lRO2C)
          JAC(lRO2C,lXRCH)= +         rk(307)    *y(lRO2C)
     &                      +(-1.000)*rk(307)    *y(lRO2C)
          JAC(lRO2C,lXMGL)= +         rk(357)    *y(lRO2C)
     &                      +(-1.000)*rk(357)    *y(lRO2C)
          JAC(lRO2C,lXBAC)= +         rk(367)    *y(lRO2C)
     &                      +(-1.000)*rk(367)    *y(lRO2C)
          JAC(lRO2C,lROOH)= +(-0.251)*rk(224)    *y(lOH)
          JAC(lRO2C,lXPD2)= +         rk(337)    *y(lRO2C)
     &                      +(-1.000)*rk(337)    *y(lRO2C)
          JAC(lRO2C,lR6PX)= +(-0.222)*rk(226)    *y(lOH)
     &                      +(-0.782)*rk(227)*flg
          JAC(lRO2C,lPRD2)= +(-0.473)*rk(267)    *y(lOH)
     &                      +(-1.590)*rk(268)*flg
          JAC(lRO2C,lY6PX)= +         rk(467)    *y(lRO2C)
     &                      +(-1.000)*rk(467)    *y(lRO2C)
          JAC(lRO2C,lRAPX)= +(-0.589)*rk(228)    *y(lOH)
          JAC(lRO2C,lIPRD)= +(-0.670)*rk(263)    *y(lOH)
     &                      +(-0.048)*rk(264)    *y(lO3)
     &                      +(-0.799)*rk(265)    *y(lNO3)
          JAC(lRO2C,lXGLY)= +         rk(347)    *y(lRO2C)
     &                      +(-1.000)*rk(347)    *y(lRO2C)
          JAC(lRO2C,lXMEK)= +         rk(327)    *y(lRO2C)
     &                      +(-1.000)*rk(327)    *y(lRO2C)
          JAC(lRO2C,lXAF1)= +         rk(387)    *y(lRO2C)
     &                      +(-1.000)*rk(387)    *y(lRO2C)
          JAC(lRO2C,lXAF2)= +         rk(397)    *y(lRO2C)
     &                      +(-1.000)*rk(397)    *y(lRO2C)
          JAC(lRO2C,lAFG1)= +(-0.723)*rk(246)    *y(lOH)
     &                      +(-0.652)*rk(247)    *y(lO3)
          JAC(lRO2C,lAFG2)= +(-0.723)*rk(249)    *y(lOH)
     &                      +(-0.652)*rk(250)    *y(lO3)
          JAC(lRO2C,lAFG3)= +(-0.733)*rk(252)    *y(lOH)
     &                      +(-0.258)*rk(253)    *y(lO3)
          JAC(lRO2C,lXIPR)= +         rk(437)    *y(lRO2C)
     &                      +(-1.000)*rk(437)    *y(lRO2C)
          JAC(lRO2C,lMACR)= +(-0.500)*rk(254)    *y(lOH)
     &                      +(-0.100)*rk(255)    *y(lO3)
     &                      +(-0.500)*rk(256)    *y(lNO3)
     &                      +(-0.330)*rk(258)*flg
          JAC(lRO2C,lMVK )= +(-0.975)*rk(259)    *y(lOH)
     &                      +(-0.050)*rk(260)    *y(lO3)
          JAC(lRO2C,lXGLD)= +         rk(497)    *y(lRO2C)
     &                      +(-1.000)*rk(497)    *y(lRO2C)
          JAC(lRO2C,lXRN3)= +         rk(447)    *y(lRO2C)
     &                      +(-1.000)*rk(447)    *y(lRO2C)
          JAC(lRO2C,lXACE)= +         rk(317)    *y(lRO2C)
     &                      +(-1.000)*rk(317)    *y(lRO2C)
          JAC(lRO2C,lACRO)= +(-0.250)*rk(274)    *y(lOH)
     &                      +(-0.031)*rk(276)    *y(lNO3)
          JAC(lRO2C,lXBAL)= +         rk(377)    *y(lRO2C)
     &                      +(-1.000)*rk(377)    *y(lRO2C)
          JAC(lRO2C,lXAF3)= +         rk(407)    *y(lRO2C)
     &                      +(-1.000)*rk(407)    *y(lRO2C)
          JAC(lRO2C,lXMAC)= +         rk(417)    *y(lRO2C)
     &                      +(-1.000)*rk(417)    *y(lRO2C)
          JAC(lRO2C,lXMVK)= +         rk(427)    *y(lRO2C)
     &                      +(-1.000)*rk(427)    *y(lRO2C)
          JAC(lRO2C,lYAPX)= +         rk(477)    *y(lRO2C)
     &                      +(-1.000)*rk(477)    *y(lRO2C)
          JAC(lRO2C,lXACR)= +         rk(507)    *y(lRO2C)
     &                      +(-1.000)*rk(507)    *y(lRO2C)
          JAC(lRO2C,lETHE)= +(-1.000)*rk(514)    *y(lOH)
     &                      +(-1.000)*rk(516)    *y(lNO3)
     &                      +(-0.290)*rk(517)    *y(lO3P)
          JAC(lRO2C,lPRPE)= +(-0.984)*rk(518)    *y(lOH)
     &                      +(-0.949)*rk(520)    *y(lNO3)
          JAC(lRO2C,lBD13)= +(-1.189)*rk(522)    *y(lOH)
     &                      +(-1.055)*rk(524)    *y(lNO3)
     &                      +(-0.235)*rk(525)    *y(lO3P)
          JAC(lRO2C,lISOP)= +(-0.986)*rk(526)    *y(lOH)
     &                      +(-0.192)*rk(527)    *y(lO3)
     &                      +(-0.936)*rk(528)    *y(lNO3)
     &                      +(-0.240)*rk(529)    *y(lO3P)
          JAC(lRO2C,lAPIN)= +(-1.042)*rk(530)    *y(lOH)
     &                      +(-1.511)*rk(531)    *y(lO3)
     &                      +(-1.050)*rk(532)    *y(lNO3)
          JAC(lRO2C,lBENZ)= +(-0.290)*rk(536)    *y(lOH)
          JAC(lRO2C,lTOLU)= +(-0.454)*rk(537)    *y(lOH)
          JAC(lRO2C,lMXYL)= +(-0.520)*rk(538)    *y(lOH)
          JAC(lRO2C,lOXYL)= +(-0.554)*rk(539)    *y(lOH)
          JAC(lRO2C,lPXYL)= +(-0.487)*rk(540)    *y(lOH)
          JAC(lRO2C,lB124)= +(-0.627)*rk(541)    *y(lOH)
          JAC(lRO2C,lETOH)= +(-0.050)*rk(542)    *y(lOH)
          JAC(lRO2C,lALK1)= +(-1.000)*rk(543)    *y(lOH)
          JAC(lRO2C,lALK2)= +(-0.965)*rk(544)    *y(lOH)
          JAC(lRO2C,lALK3)= +(-1.253)*rk(545)    *y(lOH)
          JAC(lRO2C,lALK4)= +(-1.763)*rk(546)    *y(lOH)
          JAC(lRO2C,lALK5)= +(-1.605)*rk(547)    *y(lOH)
          JAC(lRO2C,lOLE1)= +(-1.202)*rk(548)    *y(lOH)
     &                      +(-0.090)*rk(549)    *y(lO3)
     &                      +(-1.463)*rk(550)    *y(lNO3)
          JAC(lRO2C,lOLE2)= +(-0.953)*rk(552)    *y(lOH)
     &                      +(-0.212)*rk(553)    *y(lO3)
     &                      +(-1.193)*rk(554)    *y(lNO3)
          JAC(lRO2C,lARO1)= +(-0.566)*rk(556)    *y(lOH)
          JAC(lRO2C,lARO2)= +(-0.617)*rk(557)    *y(lOH)
          JAC(lRO2C,lTERP)= +(-1.211)*rk(558)    *y(lOH)
     &                      +(-0.490)*rk(559)    *y(lO3)
     &                      +(-1.786)*rk(560)    *y(lNO3)
          JAC(lRO2C,lSESQ)= +(-1.211)*rk(562)    *y(lOH)
     &                      +(-0.490)*rk(563)    *y(lO3)
     &                      +(-1.786)*rk(564)    *y(lNO3)
          JAC(lRO2X,lNO  )= +         rk( 57)    *y(lRO2X)
          JAC(lRO2X,lO3P )= +(-0.015)*rk(525)    *y(lBD13)
     &                      +(-0.010)*rk(529)    *y(lISOP)
          JAC(lRO2X,lO3  )= +(-0.007)*rk(253)    *y(lAFG3)
     &                      +(-0.008)*rk(527)    *y(lISOP)
     &                      +(-0.337)*rk(531)    *y(lAPIN)
     &                      +(-0.005)*rk(549)    *y(lOLE1)
     &                      +(-0.003)*rk(553)    *y(lOLE2)
     &                      +(-0.121)*rk(559)    *y(lTERP)
     &                      +(-0.121)*rk(563)    *y(lSESQ)
          JAC(lRO2X,lNO3 )= +         rk( 59)    *y(lRO2X)
     &                      +(-0.051)*rk(265)    *y(lIPRD)
     &                      +(-0.002)*rk(276)    *y(lACRO)
     &                      +(-0.051)*rk(520)    *y(lPRPE)
     &                      +(-0.065)*rk(524)    *y(lBD13)
     &                      +(-0.064)*rk(528)    *y(lISOP)
     &                      +(-0.293)*rk(532)    *y(lAPIN)
     &                      +(-0.228)*rk(550)    *y(lOLE1)
     &                      +(-0.140)*rk(554)    *y(lOLE2)
          JAC(lRO2X,lNO3 )=JAC(lRO2X,lNO3 )
     &                      +(-0.460)*rk(560)    *y(lTERP)
     &                      +(-0.460)*rk(564)    *y(lSESQ)
          JAC(lRO2X,lOH  )= +(-0.039)*rk(216)    *y(lMEK)
     &                      +(-0.004)*rk(224)    *y(lROOH)
     &                      +(-0.029)*rk(226)    *y(lR6PX)
     &                      +(-0.124)*rk(228)    *y(lRAPX)
     &                      +(-0.060)*rk(246)    *y(lAFG1)
     &                      +(-0.060)*rk(249)    *y(lAFG2)
     &                      +(-0.117)*rk(252)    *y(lAFG3)
     &                      +(-0.025)*rk(259)    *y(lMVK)
     &                      +(-0.041)*rk(263)    *y(lIPRD)
          JAC(lRO2X,lOH  )=JAC(lRO2X,lOH  )
     &                      +(-0.071)*rk(267)    *y(lPRD2)
     &                      +(-0.175)*rk(269)    *y(lRNO3)
     &                      +(-0.016)*rk(518)    *y(lPRPE)
     &                      +(-0.049)*rk(522)    *y(lBD13)
     &                      +(-0.093)*rk(526)    *y(lISOP)
     &                      +(-0.197)*rk(530)    *y(lAPIN)
     &                      +(-0.024)*rk(536)    *y(lBENZ)
     &                      +(-0.054)*rk(537)    *y(lTOLU)
          JAC(lRO2X,lOH  )=JAC(lRO2X,lOH  )
     &                      +(-0.082)*rk(538)    *y(lMXYL)
     &                      +(-0.087)*rk(539)    *y(lOXYL)
     &                      +(-0.076)*rk(540)    *y(lPXYL)
     &                      +(-0.121)*rk(541)    *y(lB124)
     &                      +(-0.035)*rk(544)    *y(lALK2)
     &                      +(-0.070)*rk(545)    *y(lALK3)
     &                      +(-0.149)*rk(546)    *y(lALK4)
     &                      +(-0.353)*rk(547)    *y(lALK5)
          JAC(lRO2X,lOH  )=JAC(lRO2X,lOH  )
     &                      +(-0.128)*rk(548)    *y(lOLE1)
     &                      +(-0.088)*rk(552)    *y(lOLE2)
     &                      +(-0.110)*rk(556)    *y(lARO1)
     &                      +(-0.128)*rk(557)    *y(lARO2)
     &                      +(-0.201)*rk(558)    *y(lTERP)
     &                      +(-0.201)*rk(562)    *y(lSESQ)
          JAC(lRO2X,lHO2 )= +         rk( 58)    *y(lRO2X)
          JAC(lRO2X,lMEO2)= +         rk( 60)    *y(lRO2X)
          JAC(lRO2X,lRO2C)= +         rk( 61)    *y(lRO2X)
          JAC(lRO2X,lRO2X)= +         rk( 57)    *y(lNO)
     &                      +         rk( 58)    *y(lHO2)
     &                      +         rk( 59)    *y(lNO3)
     &                      +         rk( 60)    *y(lMEO2)
     &                      +         rk( 61)    *y(lRO2C)
     &                      +( 4.000)*rk( 62)    *y(lRO2X)
     &                      +         rk( 71)    *y(lMCO3)
     &                      +         rk( 81)    *y(lRCO3)
     &                      +         rk( 92)    *y(lBZC3)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +         rk(104)    *y(lMAC3)
     &                      +         rk(119)    *y(lXHO2)
     &                      +(-1.000)*rk(119)    *y(lXHO2)
     &                      +         rk(129)    *y(lXOH)
     &                      +(-1.000)*rk(129)    *y(lXOH)
     &                      +         rk(139)    *y(lXNO2)
     &                      +(-1.000)*rk(139)    *y(lXNO2)
     &                      +         rk(149)    *y(lXMEO)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(149)    *y(lXMEO)
     &                      +         rk(159)    *y(lXMC3)
     &                      +(-1.000)*rk(159)    *y(lXMC3)
     &                      +         rk(169)    *y(lXRC3)
     &                      +(-1.000)*rk(169)    *y(lXRC3)
     &                      +         rk(179)    *y(lXMA3)
     &                      +(-1.000)*rk(179)    *y(lXMA3)
     &                      +         rk(189)    *y(lXTBU)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(189)    *y(lXTBU)
     &                      +         rk(199)    *y(lXCO)
     &                      +(-1.000)*rk(199)    *y(lXCO)
     &                      +         rk(288)    *y(lXHCH)
     &                      +(-1.000)*rk(288)    *y(lXHCH)
     &                      +         rk(298)    *y(lXCCH)
     &                      +(-1.000)*rk(298)    *y(lXCCH)
     &                      +         rk(308)    *y(lXRCH)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(308)    *y(lXRCH)
     &                      +         rk(318)    *y(lXACE)
     &                      +(-1.000)*rk(318)    *y(lXACE)
     &                      +         rk(328)    *y(lXMEK)
     &                      +(-1.000)*rk(328)    *y(lXMEK)
     &                      +         rk(338)    *y(lXPD2)
     &                      +(-1.000)*rk(338)    *y(lXPD2)
     &                      +         rk(348)    *y(lXGLY)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(348)    *y(lXGLY)
     &                      +         rk(358)    *y(lXMGL)
     &                      +(-1.000)*rk(358)    *y(lXMGL)
     &                      +         rk(368)    *y(lXBAC)
     &                      +(-1.000)*rk(368)    *y(lXBAC)
     &                      +         rk(378)    *y(lXBAL)
     &                      +(-1.000)*rk(378)    *y(lXBAL)
     &                      +         rk(388)    *y(lXAF1)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(388)    *y(lXAF1)
     &                      +         rk(398)    *y(lXAF2)
     &                      +(-1.000)*rk(398)    *y(lXAF2)
     &                      +         rk(408)    *y(lXAF3)
     &                      +(-1.000)*rk(408)    *y(lXAF3)
     &                      +         rk(418)    *y(lXMAC)
     &                      +(-1.000)*rk(418)    *y(lXMAC)
     &                      +         rk(428)    *y(lXMVK)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(428)    *y(lXMVK)
     &                      +         rk(438)    *y(lXIPR)
     &                      +(-1.000)*rk(438)    *y(lXIPR)
     &                      +         rk(448)    *y(lXRN3)
     &                      +(-1.000)*rk(448)    *y(lXRN3)
     &                      +         rk(458)    *y(lYRPX)
     &                      +(-1.000)*rk(458)    *y(lYRPX)
     &                      +         rk(468)    *y(lY6PX)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(468)    *y(lY6PX)
     &                      +         rk(478)    *y(lYAPX)
     &                      +(-1.000)*rk(478)    *y(lYAPX)
     &                      +         rk(488)    *y(lZRN3)
     &                      +(-1.000)*rk(488)    *y(lZRN3)
     &                      +         rk(498)    *y(lXGLD)
     &                      +(-1.000)*rk(498)    *y(lXGLD)
     &                      +         rk(508)    *y(lXACR)
          JAC(lRO2X,lRO2X)=JAC(lRO2X,lRO2X)
     &                      +(-1.000)*rk(508)    *y(lXACR)
          JAC(lRO2X,lMCO3)= +         rk( 71)    *y(lRO2X)
          JAC(lRO2X,lRCO3)= +         rk( 81)    *y(lRO2X)
          JAC(lRO2X,lXHO2)= +         rk(119)    *y(lRO2X)
     &                      +(-1.000)*rk(119)    *y(lRO2X)
          JAC(lRO2X,lYRPX)= +         rk(458)    *y(lRO2X)
     &                      +(-1.000)*rk(458)    *y(lRO2X)
          JAC(lRO2X,lXCCH)= +         rk(298)    *y(lRO2X)
     &                      +(-1.000)*rk(298)    *y(lRO2X)
          JAC(lRO2X,lBZC3)= +         rk( 92)    *y(lRO2X)
          JAC(lRO2X,lMAC3)= +         rk(104)    *y(lRO2X)
          JAC(lRO2X,lRNO3)= +(-0.175)*rk(269)    *y(lOH)
     &                      +(-0.102)*rk(270)*flg
          JAC(lRO2X,lXOH )= +         rk(129)    *y(lRO2X)
     &                      +(-1.000)*rk(129)    *y(lRO2X)
          JAC(lRO2X,lXNO2)= +         rk(139)    *y(lRO2X)
     &                      +(-1.000)*rk(139)    *y(lRO2X)
          JAC(lRO2X,lXMEO)= +         rk(149)    *y(lRO2X)
     &                      +(-1.000)*rk(149)    *y(lRO2X)
          JAC(lRO2X,lXMC3)= +         rk(159)    *y(lRO2X)
     &                      +(-1.000)*rk(159)    *y(lRO2X)
          JAC(lRO2X,lXRC3)= +         rk(169)    *y(lRO2X)
     &                      +(-1.000)*rk(169)    *y(lRO2X)
          JAC(lRO2X,lXMA3)= +         rk(179)    *y(lRO2X)
     &                      +(-1.000)*rk(179)    *y(lRO2X)
          JAC(lRO2X,lXTBU)= +         rk(189)    *y(lRO2X)
     &                      +(-1.000)*rk(189)    *y(lRO2X)
          JAC(lRO2X,lXCO )= +         rk(199)    *y(lRO2X)
     &                      +(-1.000)*rk(199)    *y(lRO2X)
          JAC(lRO2X,lXHCH)= +         rk(288)    *y(lRO2X)
     &                      +(-1.000)*rk(288)    *y(lRO2X)
          JAC(lRO2X,lMEK )= +(-0.039)*rk(216)    *y(lOH)
          JAC(lRO2X,lZRN3)= +         rk(488)    *y(lRO2X)
     &                      +(-1.000)*rk(488)    *y(lRO2X)
          JAC(lRO2X,lXRCH)= +         rk(308)    *y(lRO2X)
     &                      +(-1.000)*rk(308)    *y(lRO2X)
          JAC(lRO2X,lXMGL)= +         rk(358)    *y(lRO2X)
     &                      +(-1.000)*rk(358)    *y(lRO2X)
          JAC(lRO2X,lXBAC)= +         rk(368)    *y(lRO2X)
     &                      +(-1.000)*rk(368)    *y(lRO2X)
          JAC(lRO2X,lROOH)= +(-0.004)*rk(224)    *y(lOH)
          JAC(lRO2X,lXPD2)= +         rk(338)    *y(lRO2X)
     &                      +(-1.000)*rk(338)    *y(lRO2X)
          JAC(lRO2X,lR6PX)= +(-0.029)*rk(226)    *y(lOH)
     &                      +(-0.077)*rk(227)*flg
          JAC(lRO2X,lPRD2)= +(-0.071)*rk(267)    *y(lOH)
     &                      +(-0.087)*rk(268)*flg
          JAC(lRO2X,lY6PX)= +         rk(468)    *y(lRO2X)
     &                      +(-1.000)*rk(468)    *y(lRO2X)
          JAC(lRO2X,lRAPX)= +(-0.124)*rk(228)    *y(lOH)
          JAC(lRO2X,lIPRD)= +(-0.041)*rk(263)    *y(lOH)
     &                      +(-0.051)*rk(265)    *y(lNO3)
          JAC(lRO2X,lXGLY)= +         rk(348)    *y(lRO2X)
     &                      +(-1.000)*rk(348)    *y(lRO2X)
          JAC(lRO2X,lXMEK)= +         rk(328)    *y(lRO2X)
     &                      +(-1.000)*rk(328)    *y(lRO2X)
          JAC(lRO2X,lXAF1)= +         rk(388)    *y(lRO2X)
     &                      +(-1.000)*rk(388)    *y(lRO2X)
          JAC(lRO2X,lXAF2)= +         rk(398)    *y(lRO2X)
     &                      +(-1.000)*rk(398)    *y(lRO2X)
          JAC(lRO2X,lAFG1)= +(-0.060)*rk(246)    *y(lOH)
          JAC(lRO2X,lAFG2)= +(-0.060)*rk(249)    *y(lOH)
          JAC(lRO2X,lAFG3)= +(-0.117)*rk(252)    *y(lOH)
     &                      +(-0.007)*rk(253)    *y(lO3)
          JAC(lRO2X,lXIPR)= +         rk(438)    *y(lRO2X)
     &                      +(-1.000)*rk(438)    *y(lRO2X)
          JAC(lRO2X,lMVK )= +(-0.025)*rk(259)    *y(lOH)
          JAC(lRO2X,lXGLD)= +         rk(498)    *y(lRO2X)
     &                      +(-1.000)*rk(498)    *y(lRO2X)
          JAC(lRO2X,lXRN3)= +         rk(448)    *y(lRO2X)
     &                      +(-1.000)*rk(448)    *y(lRO2X)
          JAC(lRO2X,lXACE)= +         rk(318)    *y(lRO2X)
     &                      +(-1.000)*rk(318)    *y(lRO2X)
          JAC(lRO2X,lACRO)= +(-0.002)*rk(276)    *y(lNO3)
          JAC(lRO2X,lXBAL)= +         rk(378)    *y(lRO2X)
     &                      +(-1.000)*rk(378)    *y(lRO2X)
          JAC(lRO2X,lXAF3)= +         rk(408)    *y(lRO2X)
     &                      +(-1.000)*rk(408)    *y(lRO2X)
          JAC(lRO2X,lXMAC)= +         rk(418)    *y(lRO2X)
     &                      +(-1.000)*rk(418)    *y(lRO2X)
          JAC(lRO2X,lXMVK)= +         rk(428)    *y(lRO2X)
     &                      +(-1.000)*rk(428)    *y(lRO2X)
          JAC(lRO2X,lYAPX)= +         rk(478)    *y(lRO2X)
     &                      +(-1.000)*rk(478)    *y(lRO2X)
          JAC(lRO2X,lXACR)= +         rk(508)    *y(lRO2X)
     &                      +(-1.000)*rk(508)    *y(lRO2X)
          JAC(lRO2X,lPRPE)= +(-0.016)*rk(518)    *y(lOH)
     &                      +(-0.051)*rk(520)    *y(lNO3)
          JAC(lRO2X,lBD13)= +(-0.049)*rk(522)    *y(lOH)
     &                      +(-0.065)*rk(524)    *y(lNO3)
     &                      +(-0.015)*rk(525)    *y(lO3P)
          JAC(lRO2X,lISOP)= +(-0.093)*rk(526)    *y(lOH)
     &                      +(-0.008)*rk(527)    *y(lO3)
     &                      +(-0.064)*rk(528)    *y(lNO3)
     &                      +(-0.010)*rk(529)    *y(lO3P)
          JAC(lRO2X,lAPIN)= +(-0.197)*rk(530)    *y(lOH)
     &                      +(-0.337)*rk(531)    *y(lO3)
     &                      +(-0.293)*rk(532)    *y(lNO3)
          JAC(lRO2X,lBENZ)= +(-0.024)*rk(536)    *y(lOH)
          JAC(lRO2X,lTOLU)= +(-0.054)*rk(537)    *y(lOH)
          JAC(lRO2X,lMXYL)= +(-0.082)*rk(538)    *y(lOH)
          JAC(lRO2X,lOXYL)= +(-0.087)*rk(539)    *y(lOH)
          JAC(lRO2X,lPXYL)= +(-0.076)*rk(540)    *y(lOH)
          JAC(lRO2X,lB124)= +(-0.121)*rk(541)    *y(lOH)
          JAC(lRO2X,lALK2)= +(-0.035)*rk(544)    *y(lOH)
          JAC(lRO2X,lALK3)= +(-0.070)*rk(545)    *y(lOH)
          JAC(lRO2X,lALK4)= +(-0.149)*rk(546)    *y(lOH)
          JAC(lRO2X,lALK5)= +(-0.353)*rk(547)    *y(lOH)
          JAC(lRO2X,lOLE1)= +(-0.128)*rk(548)    *y(lOH)
     &                      +(-0.005)*rk(549)    *y(lO3)
     &                      +(-0.228)*rk(550)    *y(lNO3)
          JAC(lRO2X,lOLE2)= +(-0.088)*rk(552)    *y(lOH)
     &                      +(-0.003)*rk(553)    *y(lO3)
     &                      +(-0.140)*rk(554)    *y(lNO3)
          JAC(lRO2X,lARO1)= +(-0.110)*rk(556)    *y(lOH)
          JAC(lRO2X,lARO2)= +(-0.128)*rk(557)    *y(lOH)
          JAC(lRO2X,lTERP)= +(-0.201)*rk(558)    *y(lOH)
     &                      +(-0.121)*rk(559)    *y(lO3)
     &                      +(-0.460)*rk(560)    *y(lNO3)
          JAC(lRO2X,lSESQ)= +(-0.201)*rk(562)    *y(lOH)
     &                      +(-0.121)*rk(563)    *y(lO3)
     &                      +(-0.460)*rk(564)    *y(lNO3)
          JAC(lXN  ,lNO  )= +(-1.000)*rk( 57)    *y(lRO2X)
     &                      +         rk(483)    *y(lZRN3)
          JAC(lXN  ,lNO3 )= +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.278)*rk(265)    *y(lIPRD)
     &                      +(-0.002)*rk(276)    *y(lACRO)
     &                      +(-1.000)*rk(516)    *y(lETHE)
     &                      +(-1.000)*rk(520)    *y(lPRPE)
     &                      +(-0.525)*rk(524)    *y(lBD13)
     &                      +(-0.813)*rk(528)    *y(lISOP)
     &                      +(-0.301)*rk(532)    *y(lAPIN)
     &                      +(-0.226)*rk(550)    *y(lOLE1)
          JAC(lXN  ,lNO3 )=JAC(lXN  ,lNO3 )
     &                      +(-0.254)*rk(554)    *y(lOLE2)
     &                      +(-0.485)*rk(560)    *y(lTERP)
     &                      +(-0.485)*rk(564)    *y(lSESQ)
          JAC(lXN  ,lOH  )= +(-1.000)*rk(240)    *y(lNPHE)
     &                      +(-0.174)*rk(269)    *y(lRNO3)
          JAC(lXN  ,lHO2 )= +(-1.000)*rk(135)    *y(lXNO2)
     &                      +(-1.000)*rk(444)    *y(lXRN3)
          JAC(lXN  ,lMEO2)= +(-0.500)*rk(137)    *y(lXNO2)
     &                      +(-0.500)*rk(446)    *y(lXRN3)
          JAC(lXN  ,lRO2C)= +(-0.500)*rk(138)    *y(lXNO2)
     &                      +(-0.500)*rk(447)    *y(lXRN3)
          JAC(lXN  ,lRO2X)= +(-1.000)*rk( 57)    *y(lNO)
     &                      +(-0.500)*rk(139)    *y(lXNO2)
     &                      +(-0.500)*rk(448)    *y(lXRN3)
          JAC(lXN  ,lRNO3)= +(-0.174)*rk(269)    *y(lOH)
          JAC(lXN  ,lNPHE)= +(-1.000)*rk(240)    *y(lOH)
     &                      +(-1.000)*rk(242)*flg
          JAC(lXN  ,lXNO2)= +(-1.000)*rk(135)    *y(lHO2)
     &                      +(-0.500)*rk(137)    *y(lMEO2)
     &                      +(-0.500)*rk(138)    *y(lRO2C)
     &                      +(-0.500)*rk(139)    *y(lRO2X)
          JAC(lXN  ,lZRN3)= +         rk(483)    *y(lNO)
          JAC(lXN  ,lIPRD)= +(-0.278)*rk(265)    *y(lNO3)
          JAC(lXN  ,lMACR)= +(-0.500)*rk(256)    *y(lNO3)
          JAC(lXN  ,lXRN3)= +(-1.000)*rk(444)    *y(lHO2)
     &                      +(-0.500)*rk(446)    *y(lMEO2)
     &                      +(-0.500)*rk(447)    *y(lRO2C)
     &                      +(-0.500)*rk(448)    *y(lRO2X)
          JAC(lXN  ,lACRO)= +(-0.002)*rk(276)    *y(lNO3)
          JAC(lXN  ,lETHE)= +(-1.000)*rk(516)    *y(lNO3)
          JAC(lXN  ,lPRPE)= +(-1.000)*rk(520)    *y(lNO3)
          JAC(lXN  ,lBD13)= +(-0.525)*rk(524)    *y(lNO3)
          JAC(lXN  ,lISOP)= +(-0.813)*rk(528)    *y(lNO3)
          JAC(lXN  ,lAPIN)= +(-0.301)*rk(532)    *y(lNO3)
          JAC(lXN  ,lOLE1)= +(-0.226)*rk(550)    *y(lNO3)
          JAC(lXN  ,lOLE2)= +(-0.254)*rk(554)    *y(lNO3)
          JAC(lXN  ,lTERP)= +(-0.485)*rk(560)    *y(lNO3)
          JAC(lXN  ,lSESQ)= +(-0.485)*rk(564)    *y(lNO3)
          JAC(lMCO3,lNO2 )= +         rk( 63)    *y(lMCO3)
          JAC(lMCO3,lNO  )= +         rk( 66)    *y(lMCO3)
     &                      +(-1.000)*rk( 99)    *y(lMAC3)
     &                      +(-1.000)*rk(154)    *y(lXMC3)
          JAC(lMCO3,lO3  )= +(-0.013)*rk(253)    *y(lAFG3)
          JAC(lMCO3,lNO3 )= +         rk( 68)    *y(lMCO3)
     &                      +(-1.000)*rk(101)    *y(lMAC3)
     &                      +(-1.000)*rk(156)    *y(lXMC3)
     &                      +(-1.000)*rk(210)    *y(lCCHO)
     &                      +(-1.000)*rk(236)    *y(lMGLY)
     &                      +(-1.000)*rk(273)    *y(lGLYD)
          JAC(lMCO3,lOH  )= +(-1.000)*rk(208)    *y(lCCHO)
     &                      +(-1.000)*rk(235)    *y(lMGLY)
     &                      +(-1.000)*rk(271)    *y(lGLYD)
     &                      +(-0.980)*rk(279)    *y(lCO3H)
          JAC(lMCO3,lHO2 )= +         rk( 67)    *y(lMCO3)
          JAC(lMCO3,lMEO2)= +         rk( 69)    *y(lMCO3)
     &                      +(-1.000)*rk(102)    *y(lMAC3)
     &                      +(-0.500)*rk(157)    *y(lXMC3)
          JAC(lMCO3,lRO2C)= +         rk( 70)    *y(lMCO3)
     &                      +(-1.000)*rk(103)    *y(lMAC3)
     &                      +(-0.500)*rk(158)    *y(lXMC3)
          JAC(lMCO3,lRO2X)= +         rk( 71)    *y(lMCO3)
     &                      +(-1.000)*rk(104)    *y(lMAC3)
     &                      +(-0.500)*rk(159)    *y(lXMC3)
          JAC(lMCO3,lMCO3)= +         rk( 63)    *y(lNO2)
     &                      +         rk( 66)    *y(lNO)
     &                      +         rk( 67)    *y(lHO2)
     &                      +         rk( 68)    *y(lNO3)
     &                      +         rk( 69)    *y(lMEO2)
     &                      +         rk( 70)    *y(lRO2C)
     &                      +         rk( 71)    *y(lRO2X)
     &                      +( 4.000)*rk( 72)    *y(lMCO3)
     &                      +         rk( 82)    *y(lRCO3)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +         rk( 93)    *y(lBZC3)
     &                      +         rk(105)    *y(lMAC3)
     &                      +(-1.000)*rk(105)    *y(lMAC3)
     &                      +         rk(120)    *y(lXHO2)
     &                      +(-1.000)*rk(120)    *y(lXHO2)
     &                      +         rk(130)    *y(lXOH)
     &                      +(-1.000)*rk(130)    *y(lXOH)
     &                      +         rk(140)    *y(lXNO2)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(140)    *y(lXNO2)
     &                      +         rk(150)    *y(lXMEO)
     &                      +(-1.000)*rk(150)    *y(lXMEO)
     &                      +         rk(160)    *y(lXMC3)
     &                      +(-2.000)*rk(160)    *y(lXMC3)
     &                      +         rk(170)    *y(lXRC3)
     &                      +(-1.000)*rk(170)    *y(lXRC3)
     &                      +         rk(180)    *y(lXMA3)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(180)    *y(lXMA3)
     &                      +         rk(190)    *y(lXTBU)
     &                      +(-1.000)*rk(190)    *y(lXTBU)
     &                      +         rk(200)    *y(lXCO)
     &                      +(-1.000)*rk(200)    *y(lXCO)
     &                      +         rk(289)    *y(lXHCH)
     &                      +(-1.000)*rk(289)    *y(lXHCH)
     &                      +         rk(299)    *y(lXCCH)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(299)    *y(lXCCH)
     &                      +         rk(309)    *y(lXRCH)
     &                      +(-1.000)*rk(309)    *y(lXRCH)
     &                      +         rk(319)    *y(lXACE)
     &                      +(-1.000)*rk(319)    *y(lXACE)
     &                      +         rk(329)    *y(lXMEK)
     &                      +(-1.000)*rk(329)    *y(lXMEK)
     &                      +         rk(339)    *y(lXPD2)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(339)    *y(lXPD2)
     &                      +         rk(349)    *y(lXGLY)
     &                      +(-1.000)*rk(349)    *y(lXGLY)
     &                      +         rk(359)    *y(lXMGL)
     &                      +(-1.000)*rk(359)    *y(lXMGL)
     &                      +         rk(369)    *y(lXBAC)
     &                      +(-1.000)*rk(369)    *y(lXBAC)
     &                      +         rk(379)    *y(lXBAL)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(379)    *y(lXBAL)
     &                      +         rk(389)    *y(lXAF1)
     &                      +(-1.000)*rk(389)    *y(lXAF1)
     &                      +         rk(399)    *y(lXAF2)
     &                      +(-1.000)*rk(399)    *y(lXAF2)
     &                      +         rk(409)    *y(lXAF3)
     &                      +(-1.000)*rk(409)    *y(lXAF3)
     &                      +         rk(419)    *y(lXMAC)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(419)    *y(lXMAC)
     &                      +         rk(429)    *y(lXMVK)
     &                      +(-1.000)*rk(429)    *y(lXMVK)
     &                      +         rk(439)    *y(lXIPR)
     &                      +(-1.000)*rk(439)    *y(lXIPR)
     &                      +         rk(449)    *y(lXRN3)
     &                      +(-1.000)*rk(449)    *y(lXRN3)
     &                      +         rk(459)    *y(lYRPX)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(459)    *y(lYRPX)
     &                      +         rk(469)    *y(lY6PX)
     &                      +(-1.000)*rk(469)    *y(lY6PX)
     &                      +         rk(479)    *y(lYAPX)
     &                      +(-1.000)*rk(479)    *y(lYAPX)
     &                      +         rk(489)    *y(lZRN3)
     &                      +(-1.000)*rk(489)    *y(lZRN3)
     &                      +         rk(499)    *y(lXGLD)
          JAC(lMCO3,lMCO3)=JAC(lMCO3,lMCO3)
     &                      +(-1.000)*rk(499)    *y(lXGLD)
     &                      +         rk(509)    *y(lXACR)
     &                      +(-1.000)*rk(509)    *y(lXACR)
          JAC(lMCO3,lPAN )= +(-1.000)*rk( 64)*flg
     &                      +(-0.600)*rk( 65)*flg
          JAC(lMCO3,lCO3H)= +(-0.980)*rk(279)    *y(lOH)
          JAC(lMCO3,lRCO3)= +         rk( 82)    *y(lMCO3)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
     &                      +(-1.000)*rk(161)    *y(lXMC3)
          JAC(lMCO3,lXHO2)= +         rk(120)    *y(lMCO3)
     &                      +(-1.000)*rk(120)    *y(lMCO3)
          JAC(lMCO3,lYRPX)= +         rk(459)    *y(lMCO3)
     &                      +(-1.000)*rk(459)    *y(lMCO3)
          JAC(lMCO3,lXCCH)= +         rk(299)    *y(lMCO3)
     &                      +(-1.000)*rk(299)    *y(lMCO3)
          JAC(lMCO3,lBZC3)= +         rk( 93)    *y(lMCO3)
     &                      +(-1.000)*rk(107)    *y(lMAC3)
     &                      +(-1.000)*rk(162)    *y(lXMC3)
          JAC(lMCO3,lMAC3)= +(-1.000)*rk( 99)    *y(lNO)
     &                      +(-1.000)*rk(101)    *y(lNO3)
     &                      +(-1.000)*rk(102)    *y(lMEO2)
     &                      +(-1.000)*rk(103)    *y(lRO2C)
     &                      +(-1.000)*rk(104)    *y(lRO2X)
     &                      +         rk(105)    *y(lMCO3)
     &                      +(-1.000)*rk(105)    *y(lMCO3)
     &                      +(-1.000)*rk(106)    *y(lRCO3)
     &                      +(-1.000)*rk(107)    *y(lBZC3)
          JAC(lMCO3,lMAC3)=JAC(lMCO3,lMAC3)
     &                      +(-4.000)*rk(108)    *y(lMAC3)
     &                      +(-1.000)*rk(163)    *y(lXMC3)
          JAC(lMCO3,lMPAN)= +(-0.400)*rk( 98)*flg
          JAC(lMCO3,lACET)= +(-0.620)*rk(215)*flg
          JAC(lMCO3,lXOH )= +         rk(130)    *y(lMCO3)
     &                      +(-1.000)*rk(130)    *y(lMCO3)
          JAC(lMCO3,lXNO2)= +         rk(140)    *y(lMCO3)
     &                      +(-1.000)*rk(140)    *y(lMCO3)
          JAC(lMCO3,lXMEO)= +         rk(150)    *y(lMCO3)
     &                      +(-1.000)*rk(150)    *y(lMCO3)
          JAC(lMCO3,lXMC3)= +(-1.000)*rk(154)    *y(lNO)
     &                      +(-1.000)*rk(156)    *y(lNO3)
     &                      +(-0.500)*rk(157)    *y(lMEO2)
     &                      +(-0.500)*rk(158)    *y(lRO2C)
     &                      +(-0.500)*rk(159)    *y(lRO2X)
     &                      +         rk(160)    *y(lMCO3)
     &                      +(-2.000)*rk(160)    *y(lMCO3)
     &                      +(-1.000)*rk(161)    *y(lRCO3)
     &                      +(-1.000)*rk(162)    *y(lBZC3)
          JAC(lMCO3,lXMC3)=JAC(lMCO3,lXMC3)
     &                      +(-1.000)*rk(163)    *y(lMAC3)
          JAC(lMCO3,lXRC3)= +         rk(170)    *y(lMCO3)
     &                      +(-1.000)*rk(170)    *y(lMCO3)
          JAC(lMCO3,lXMA3)= +         rk(180)    *y(lMCO3)
     &                      +(-1.000)*rk(180)    *y(lMCO3)
          JAC(lMCO3,lXTBU)= +         rk(190)    *y(lMCO3)
     &                      +(-1.000)*rk(190)    *y(lMCO3)
          JAC(lMCO3,lXCO )= +         rk(200)    *y(lMCO3)
     &                      +(-1.000)*rk(200)    *y(lMCO3)
          JAC(lMCO3,lCCHO)= +(-1.000)*rk(208)    *y(lOH)
     &                      +(-1.000)*rk(210)    *y(lNO3)
          JAC(lMCO3,lXHCH)= +         rk(289)    *y(lMCO3)
     &                      +(-1.000)*rk(289)    *y(lMCO3)
          JAC(lMCO3,lMEK )= +(-1.000)*rk(217)*flg
          JAC(lMCO3,lZRN3)= +         rk(489)    *y(lMCO3)
     &                      +(-1.000)*rk(489)    *y(lMCO3)
          JAC(lMCO3,lXRCH)= +         rk(309)    *y(lMCO3)
     &                      +(-1.000)*rk(309)    *y(lMCO3)
          JAC(lMCO3,lXMGL)= +         rk(359)    *y(lMCO3)
     &                      +(-1.000)*rk(359)    *y(lMCO3)
          JAC(lMCO3,lXBAC)= +         rk(369)    *y(lMCO3)
     &                      +(-1.000)*rk(369)    *y(lMCO3)
          JAC(lMCO3,lXPD2)= +         rk(339)    *y(lMCO3)
     &                      +(-1.000)*rk(339)    *y(lMCO3)
          JAC(lMCO3,lPRD2)= +(-0.400)*rk(268)*flg
          JAC(lMCO3,lY6PX)= +         rk(469)    *y(lMCO3)
     &                      +(-1.000)*rk(469)    *y(lMCO3)
          JAC(lMCO3,lMGLY)= +(-1.000)*rk(234)*flg
     &                      +(-1.000)*rk(235)    *y(lOH)
     &                      +(-1.000)*rk(236)    *y(lNO3)
          JAC(lMCO3,lIPRD)= +(-0.467)*rk(266)*flg
          JAC(lMCO3,lXGLY)= +         rk(349)    *y(lMCO3)
     &                      +(-1.000)*rk(349)    *y(lMCO3)
          JAC(lMCO3,lXMEK)= +         rk(329)    *y(lMCO3)
     &                      +(-1.000)*rk(329)    *y(lMCO3)
          JAC(lMCO3,lXAF1)= +         rk(389)    *y(lMCO3)
     &                      +(-1.000)*rk(389)    *y(lMCO3)
          JAC(lMCO3,lXAF2)= +         rk(399)    *y(lMCO3)
     &                      +(-1.000)*rk(399)    *y(lMCO3)
          JAC(lMCO3,lAFG1)= +(-0.305)*rk(248)*flg
          JAC(lMCO3,lBACL)= +(-2.000)*rk(237)*flg
          JAC(lMCO3,lAFG3)= +(-0.013)*rk(253)    *y(lO3)
          JAC(lMCO3,lXIPR)= +         rk(439)    *y(lMCO3)
     &                      +(-1.000)*rk(439)    *y(lMCO3)
          JAC(lMCO3,lMACR)= +(-0.340)*rk(258)*flg
          JAC(lMCO3,lXGLD)= +         rk(499)    *y(lMCO3)
     &                      +(-1.000)*rk(499)    *y(lMCO3)
          JAC(lMCO3,lXRN3)= +         rk(449)    *y(lMCO3)
     &                      +(-1.000)*rk(449)    *y(lMCO3)
          JAC(lMCO3,lGLYD)= +(-1.000)*rk(271)    *y(lOH)
     &                      +(-1.000)*rk(273)    *y(lNO3)
          JAC(lMCO3,lXACE)= +         rk(319)    *y(lMCO3)
     &                      +(-1.000)*rk(319)    *y(lMCO3)
          JAC(lMCO3,lXBAL)= +         rk(379)    *y(lMCO3)
     &                      +(-1.000)*rk(379)    *y(lMCO3)
          JAC(lMCO3,lXAF3)= +         rk(409)    *y(lMCO3)
     &                      +(-1.000)*rk(409)    *y(lMCO3)
          JAC(lMCO3,lXMAC)= +         rk(419)    *y(lMCO3)
     &                      +(-1.000)*rk(419)    *y(lMCO3)
          JAC(lMCO3,lXMVK)= +         rk(429)    *y(lMCO3)
     &                      +(-1.000)*rk(429)    *y(lMCO3)
          JAC(lMCO3,lYAPX)= +         rk(479)    *y(lMCO3)
     &                      +(-1.000)*rk(479)    *y(lMCO3)
          JAC(lMCO3,lXACR)= +         rk(509)    *y(lMCO3)
     &                      +(-1.000)*rk(509)    *y(lMCO3)
          JAC(lPAN ,lNO2 )= +(-1.000)*rk( 63)    *y(lMCO3)
          JAC(lPAN ,lMCO3)= +(-1.000)*rk( 63)    *y(lNO2)
          JAC(lPAN ,lPAN )= +         rk( 64)*flg
     &                      +         rk( 65)*flg
          JAC(lCO3H,lOH  )= +         rk(279)    *y(lCO3H)
          JAC(lCO3H,lHO2 )= +(-0.700)*rk( 67)    *y(lMCO3)
          JAC(lCO3H,lMCO3)= +(-0.700)*rk( 67)    *y(lHO2)
          JAC(lCO3H,lCO3H)= +         rk(279)    *y(lOH)
     &                      +         rk(280)*flg
          JAC(lAACD,lO3  )= +(-0.075)*rk(519)    *y(lPRPE)
     &                      +(-0.065)*rk(553)    *y(lOLE2)
          JAC(lAACD,lOH  )= +         rk(220)    *y(lAACD)
          JAC(lAACD,lHO2 )= +(-0.300)*rk( 67)    *y(lMCO3)
          JAC(lAACD,lMEO2)= +(-0.100)*rk( 69)    *y(lMCO3)
          JAC(lAACD,lMCO3)= +(-0.300)*rk( 67)    *y(lHO2)
     &                      +(-0.100)*rk( 69)    *y(lMEO2)
          JAC(lAACD,lAACD)= +         rk(220)    *y(lOH)
          JAC(lAACD,lACRO)= +(-0.050)*rk(278)*flg
          JAC(lAACD,lPRPE)= +(-0.075)*rk(519)    *y(lO3)
          JAC(lAACD,lOLE2)= +(-0.065)*rk(553)    *y(lO3)
          JAC(lRCO3,lNO2 )= +         rk( 73)    *y(lRCO3)
          JAC(lRCO3,lNO  )= +         rk( 76)    *y(lRCO3)
     &                      +(-1.000)*rk(164)    *y(lXRC3)
          JAC(lRCO3,lNO3 )= +         rk( 78)    *y(lRCO3)
     &                      +(-1.000)*rk(166)    *y(lXRC3)
     &                      +(-1.000)*rk(213)    *y(lRCHO)
     &                      +(-0.370)*rk(233)    *y(lGLY)
          JAC(lRCO3,lOH  )= +(-0.965)*rk(211)    *y(lRCHO)
     &                      +(-0.370)*rk(232)    *y(lGLY)
     &                      +(-0.806)*rk(281)    *y(lRO3H)
          JAC(lRCO3,lHO2 )= +         rk( 77)    *y(lRCO3)
          JAC(lRCO3,lMEO2)= +         rk( 79)    *y(lRCO3)
     &                      +(-0.500)*rk(167)    *y(lXRC3)
          JAC(lRCO3,lRO2C)= +         rk( 80)    *y(lRCO3)
     &                      +(-0.500)*rk(168)    *y(lXRC3)
          JAC(lRCO3,lRO2X)= +         rk( 81)    *y(lRCO3)
     &                      +(-0.500)*rk(169)    *y(lXRC3)
          JAC(lRCO3,lMCO3)= +         rk( 82)    *y(lRCO3)
     &                      +(-1.000)*rk(170)    *y(lXRC3)
          JAC(lRCO3,lRCO3)= +         rk( 73)    *y(lNO2)
     &                      +         rk( 76)    *y(lNO)
     &                      +         rk( 77)    *y(lHO2)
     &                      +         rk( 78)    *y(lNO3)
     &                      +         rk( 79)    *y(lMEO2)
     &                      +         rk( 80)    *y(lRO2C)
     &                      +         rk( 81)    *y(lRO2X)
     &                      +         rk( 82)    *y(lMCO3)
     &                      +( 4.000)*rk( 83)    *y(lRCO3)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk( 94)    *y(lBZC3)
     &                      +         rk(106)    *y(lMAC3)
     &                      +         rk(121)    *y(lXHO2)
     &                      +(-1.000)*rk(121)    *y(lXHO2)
     &                      +         rk(131)    *y(lXOH)
     &                      +(-1.000)*rk(131)    *y(lXOH)
     &                      +         rk(141)    *y(lXNO2)
     &                      +(-1.000)*rk(141)    *y(lXNO2)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(151)    *y(lXMEO)
     &                      +(-1.000)*rk(151)    *y(lXMEO)
     &                      +         rk(161)    *y(lXMC3)
     &                      +(-1.000)*rk(161)    *y(lXMC3)
     &                      +         rk(171)    *y(lXRC3)
     &                      +(-2.000)*rk(171)    *y(lXRC3)
     &                      +         rk(181)    *y(lXMA3)
     &                      +(-1.000)*rk(181)    *y(lXMA3)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(191)    *y(lXTBU)
     &                      +(-1.000)*rk(191)    *y(lXTBU)
     &                      +         rk(201)    *y(lXCO)
     &                      +(-1.000)*rk(201)    *y(lXCO)
     &                      +         rk(290)    *y(lXHCH)
     &                      +(-1.000)*rk(290)    *y(lXHCH)
     &                      +         rk(300)    *y(lXCCH)
     &                      +(-1.000)*rk(300)    *y(lXCCH)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(310)    *y(lXRCH)
     &                      +(-1.000)*rk(310)    *y(lXRCH)
     &                      +         rk(320)    *y(lXACE)
     &                      +(-1.000)*rk(320)    *y(lXACE)
     &                      +         rk(330)    *y(lXMEK)
     &                      +(-1.000)*rk(330)    *y(lXMEK)
     &                      +         rk(340)    *y(lXPD2)
     &                      +(-1.000)*rk(340)    *y(lXPD2)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(350)    *y(lXGLY)
     &                      +(-1.000)*rk(350)    *y(lXGLY)
     &                      +         rk(360)    *y(lXMGL)
     &                      +(-1.000)*rk(360)    *y(lXMGL)
     &                      +         rk(370)    *y(lXBAC)
     &                      +(-1.000)*rk(370)    *y(lXBAC)
     &                      +         rk(380)    *y(lXBAL)
     &                      +(-1.000)*rk(380)    *y(lXBAL)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(390)    *y(lXAF1)
     &                      +(-1.000)*rk(390)    *y(lXAF1)
     &                      +         rk(400)    *y(lXAF2)
     &                      +(-1.000)*rk(400)    *y(lXAF2)
     &                      +         rk(410)    *y(lXAF3)
     &                      +(-1.000)*rk(410)    *y(lXAF3)
     &                      +         rk(420)    *y(lXMAC)
     &                      +(-1.000)*rk(420)    *y(lXMAC)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(430)    *y(lXMVK)
     &                      +(-1.000)*rk(430)    *y(lXMVK)
     &                      +         rk(440)    *y(lXIPR)
     &                      +(-1.000)*rk(440)    *y(lXIPR)
     &                      +         rk(450)    *y(lXRN3)
     &                      +(-1.000)*rk(450)    *y(lXRN3)
     &                      +         rk(460)    *y(lYRPX)
     &                      +(-1.000)*rk(460)    *y(lYRPX)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(470)    *y(lY6PX)
     &                      +(-1.000)*rk(470)    *y(lY6PX)
     &                      +         rk(480)    *y(lYAPX)
     &                      +(-1.000)*rk(480)    *y(lYAPX)
     &                      +         rk(490)    *y(lZRN3)
     &                      +(-1.000)*rk(490)    *y(lZRN3)
     &                      +         rk(500)    *y(lXGLD)
     &                      +(-1.000)*rk(500)    *y(lXGLD)
          JAC(lRCO3,lRCO3)=JAC(lRCO3,lRCO3)
     &                      +         rk(510)    *y(lXACR)
     &                      +(-1.000)*rk(510)    *y(lXACR)
          JAC(lRCO3,lPAN2)= +(-1.000)*rk( 74)*flg
     &                      +(-0.600)*rk( 75)*flg
          JAC(lRCO3,lXHO2)= +         rk(121)    *y(lRCO3)
     &                      +(-1.000)*rk(121)    *y(lRCO3)
          JAC(lRCO3,lYRPX)= +         rk(460)    *y(lRCO3)
     &                      +(-1.000)*rk(460)    *y(lRCO3)
          JAC(lRCO3,lXCCH)= +         rk(300)    *y(lRCO3)
     &                      +(-1.000)*rk(300)    *y(lRCO3)
          JAC(lRCO3,lRO3H)= +(-0.806)*rk(281)    *y(lOH)
          JAC(lRCO3,lBZC3)= +         rk( 94)    *y(lRCO3)
     &                      +(-1.000)*rk(172)    *y(lXRC3)
          JAC(lRCO3,lMAC3)= +         rk(106)    *y(lRCO3)
     &                      +(-1.000)*rk(173)    *y(lXRC3)
          JAC(lRCO3,lXOH )= +         rk(131)    *y(lRCO3)
     &                      +(-1.000)*rk(131)    *y(lRCO3)
          JAC(lRCO3,lXNO2)= +         rk(141)    *y(lRCO3)
     &                      +(-1.000)*rk(141)    *y(lRCO3)
          JAC(lRCO3,lXMEO)= +         rk(151)    *y(lRCO3)
     &                      +(-1.000)*rk(151)    *y(lRCO3)
          JAC(lRCO3,lXMC3)= +         rk(161)    *y(lRCO3)
     &                      +(-1.000)*rk(161)    *y(lRCO3)
          JAC(lRCO3,lXRC3)= +(-1.000)*rk(164)    *y(lNO)
     &                      +(-1.000)*rk(166)    *y(lNO3)
     &                      +(-0.500)*rk(167)    *y(lMEO2)
     &                      +(-0.500)*rk(168)    *y(lRO2C)
     &                      +(-0.500)*rk(169)    *y(lRO2X)
     &                      +(-1.000)*rk(170)    *y(lMCO3)
     &                      +         rk(171)    *y(lRCO3)
     &                      +(-2.000)*rk(171)    *y(lRCO3)
     &                      +(-1.000)*rk(172)    *y(lBZC3)
          JAC(lRCO3,lXRC3)=JAC(lRCO3,lXRC3)
     &                      +(-1.000)*rk(173)    *y(lMAC3)
          JAC(lRCO3,lXMA3)= +         rk(181)    *y(lRCO3)
     &                      +(-1.000)*rk(181)    *y(lRCO3)
          JAC(lRCO3,lXTBU)= +         rk(191)    *y(lRCO3)
     &                      +(-1.000)*rk(191)    *y(lRCO3)
          JAC(lRCO3,lXCO )= +         rk(201)    *y(lRCO3)
     &                      +(-1.000)*rk(201)    *y(lRCO3)
          JAC(lRCO3,lRCHO)= +(-0.965)*rk(211)    *y(lOH)
     &                      +(-1.000)*rk(213)    *y(lNO3)
          JAC(lRCO3,lXHCH)= +         rk(290)    *y(lRCO3)
     &                      +(-1.000)*rk(290)    *y(lRCO3)
          JAC(lRCO3,lZRN3)= +         rk(490)    *y(lRCO3)
     &                      +(-1.000)*rk(490)    *y(lRCO3)
          JAC(lRCO3,lXRCH)= +         rk(310)    *y(lRCO3)
     &                      +(-1.000)*rk(310)    *y(lRCO3)
          JAC(lRCO3,lXMGL)= +         rk(360)    *y(lRCO3)
     &                      +(-1.000)*rk(360)    *y(lRCO3)
          JAC(lRCO3,lXBAC)= +         rk(370)    *y(lRCO3)
     &                      +(-1.000)*rk(370)    *y(lRCO3)
          JAC(lRCO3,lXPD2)= +         rk(340)    *y(lRCO3)
     &                      +(-1.000)*rk(340)    *y(lRCO3)
          JAC(lRCO3,lPRD2)= +(-0.600)*rk(268)*flg
          JAC(lRCO3,lY6PX)= +         rk(470)    *y(lRCO3)
     &                      +(-1.000)*rk(470)    *y(lRCO3)
          JAC(lRCO3,lIPRD)= +(-0.300)*rk(266)*flg
          JAC(lRCO3,lXGLY)= +         rk(350)    *y(lRCO3)
     &                      +(-1.000)*rk(350)    *y(lRCO3)
          JAC(lRCO3,lXMEK)= +         rk(330)    *y(lRCO3)
     &                      +(-1.000)*rk(330)    *y(lRCO3)
          JAC(lRCO3,lXAF1)= +         rk(390)    *y(lRCO3)
     &                      +(-1.000)*rk(390)    *y(lRCO3)
          JAC(lRCO3,lXAF2)= +         rk(400)    *y(lRCO3)
     &                      +(-1.000)*rk(400)    *y(lRCO3)
          JAC(lRCO3,lGLY )= +(-0.370)*rk(232)    *y(lOH)
     &                      +(-0.370)*rk(233)    *y(lNO3)
          JAC(lRCO3,lXIPR)= +         rk(440)    *y(lRCO3)
     &                      +(-1.000)*rk(440)    *y(lRCO3)
          JAC(lRCO3,lXGLD)= +         rk(500)    *y(lRCO3)
     &                      +(-1.000)*rk(500)    *y(lRCO3)
          JAC(lRCO3,lXRN3)= +         rk(450)    *y(lRCO3)
     &                      +(-1.000)*rk(450)    *y(lRCO3)
          JAC(lRCO3,lXACE)= +         rk(320)    *y(lRCO3)
     &                      +(-1.000)*rk(320)    *y(lRCO3)
          JAC(lRCO3,lXBAL)= +         rk(380)    *y(lRCO3)
     &                      +(-1.000)*rk(380)    *y(lRCO3)
          JAC(lRCO3,lXAF3)= +         rk(410)    *y(lRCO3)
     &                      +(-1.000)*rk(410)    *y(lRCO3)
          JAC(lRCO3,lXMAC)= +         rk(420)    *y(lRCO3)
     &                      +(-1.000)*rk(420)    *y(lRCO3)
          JAC(lRCO3,lXMVK)= +         rk(430)    *y(lRCO3)
     &                      +(-1.000)*rk(430)    *y(lRCO3)
          JAC(lRCO3,lYAPX)= +         rk(480)    *y(lRCO3)
     &                      +(-1.000)*rk(480)    *y(lRCO3)
          JAC(lRCO3,lXACR)= +         rk(510)    *y(lRCO3)
     &                      +(-1.000)*rk(510)    *y(lRCO3)
          JAC(lPAN2,lNO2 )= +(-1.000)*rk( 73)    *y(lRCO3)
          JAC(lPAN2,lRCO3)= +(-1.000)*rk( 73)    *y(lNO2)
          JAC(lPAN2,lPAN2)= +         rk( 74)*flg
     &                      +         rk( 75)*flg
          JAC(lXHO2,lNO  )= +(-1.000)*rk( 76)    *y(lRCO3)
     &                      +         rk(114)    *y(lXHO2)
          JAC(lXHO2,lO3P )= +(-0.290)*rk(517)    *y(lETHE)
     &                      +(-0.117)*rk(525)    *y(lBD13)
          JAC(lXHO2,lO3  )= +(-0.095)*rk(253)    *y(lAFG3)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.102)*rk(531)    *y(lAPIN)
     &                      +(-0.057)*rk(549)    *y(lOLE1)
     &                      +(-0.041)*rk(553)    *y(lOLE2)
     &                      +(-0.046)*rk(559)    *y(lTERP)
     &                      +(-0.046)*rk(563)    *y(lSESQ)
          JAC(lXHO2,lNO3 )= +(-1.000)*rk( 78)    *y(lRCO3)
     &                      +         rk(116)    *y(lXHO2)
     &                      +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.799)*rk(265)    *y(lIPRD)
     &                      +(-0.031)*rk(276)    *y(lACRO)
     &                      +(-1.000)*rk(516)    *y(lETHE)
     &                      +(-0.949)*rk(520)    *y(lPRPE)
     &                      +(-0.815)*rk(524)    *y(lBD13)
     &                      +(-0.749)*rk(528)    *y(lISOP)
          JAC(lXHO2,lNO3 )=JAC(lXHO2,lNO3 )
     &                      +(-0.056)*rk(532)    *y(lAPIN)
     &                      +(-0.772)*rk(550)    *y(lOLE1)
     &                      +(-0.400)*rk(554)    *y(lOLE2)
     &                      +(-0.227)*rk(560)    *y(lTERP)
     &                      +(-0.227)*rk(564)    *y(lSESQ)
          JAC(lXHO2,lOH  )= +(-0.035)*rk(211)    *y(lRCHO)
     &                      +(-0.376)*rk(216)    *y(lMEK)
     &                      +(-0.491)*rk(220)    *y(lAACD)
     &                      +(-1.000)*rk(221)    *y(lPACD)
     &                      +(-0.239)*rk(224)    *y(lROOH)
     &                      +(-0.090)*rk(226)    *y(lR6PX)
     &                      +(-0.565)*rk(228)    *y(lRAPX)
     &                      +(-0.800)*rk(238)    *y(lCRES)
     &                      +(-0.521)*rk(246)    *y(lAFG1)
          JAC(lXHO2,lOH  )=JAC(lXHO2,lOH  )
     &                      +(-0.521)*rk(249)    *y(lAFG2)
     &                      +(-0.561)*rk(252)    *y(lAFG3)
     &                      +(-0.500)*rk(254)    *y(lMACR)
     &                      +(-0.300)*rk(259)    *y(lMVK)
     &                      +(-0.670)*rk(263)    *y(lIPRD)
     &                      +(-0.379)*rk(267)    *y(lPRD2)
     &                      +(-0.305)*rk(269)    *y(lRNO3)
     &                      +(-0.250)*rk(274)    *y(lACRO)
          JAC(lXHO2,lOH  )=JAC(lXHO2,lOH  )
     &                      +(-0.084)*rk(281)    *y(lRO3H)
     &                      +(-1.000)*rk(514)    *y(lETHE)
     &                      +(-0.984)*rk(518)    *y(lPRPE)
     &                      +(-0.951)*rk(522)    *y(lBD13)
     &                      +(-0.907)*rk(526)    *y(lISOP)
     &                      +(-0.799)*rk(530)    *y(lAPIN)
     &                      +(-0.290)*rk(536)    *y(lBENZ)
     &                      +(-0.454)*rk(537)    *y(lTOLU)
          JAC(lXHO2,lOH  )=JAC(lXHO2,lOH  )
     &                      +(-0.520)*rk(538)    *y(lMXYL)
     &                      +(-0.554)*rk(539)    *y(lOXYL)
     &                      +(-0.487)*rk(540)    *y(lPXYL)
     &                      +(-0.627)*rk(541)    *y(lB124)
     &                      +(-0.050)*rk(542)    *y(lETOH)
     &                      +(-1.000)*rk(543)    *y(lALK1)
     &                      +(-0.965)*rk(544)    *y(lALK2)
     &                      +(-0.695)*rk(545)    *y(lALK3)
          JAC(lXHO2,lOH  )=JAC(lXHO2,lOH  )
     &                      +(-0.830)*rk(546)    *y(lALK4)
     &                      +(-0.647)*rk(547)    *y(lALK5)
     &                      +(-0.871)*rk(548)    *y(lOLE1)
     &                      +(-0.912)*rk(552)    *y(lOLE2)
     &                      +(-0.566)*rk(556)    *y(lARO1)
     &                      +(-0.617)*rk(557)    *y(lARO2)
     &                      +(-0.734)*rk(558)    *y(lTERP)
     &                      +(-0.734)*rk(562)    *y(lSESQ)
          JAC(lXHO2,lHO2 )= +         rk(115)    *y(lXHO2)
          JAC(lXHO2,lMEO2)= +(-1.000)*rk( 79)    *y(lRCO3)
     &                      +         rk(117)    *y(lXHO2)
          JAC(lXHO2,lRO2C)= +(-1.000)*rk( 80)    *y(lRCO3)
     &                      +         rk(118)    *y(lXHO2)
          JAC(lXHO2,lRO2X)= +(-1.000)*rk( 81)    *y(lRCO3)
     &                      +         rk(119)    *y(lXHO2)
          JAC(lXHO2,lMCO3)= +(-1.000)*rk( 82)    *y(lRCO3)
     &                      +         rk(120)    *y(lXHO2)
          JAC(lXHO2,lAACD)= +(-0.491)*rk(220)    *y(lOH)
          JAC(lXHO2,lRCO3)= +(-1.000)*rk( 76)    *y(lNO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk( 80)    *y(lRO2C)
     &                      +(-1.000)*rk( 81)    *y(lRO2X)
     &                      +(-1.000)*rk( 82)    *y(lMCO3)
     &                      +(-4.000)*rk( 83)    *y(lRCO3)
     &                      +(-1.000)*rk( 94)    *y(lBZC3)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
          JAC(lXHO2,lRCO3)=JAC(lXHO2,lRCO3)
     &                      +         rk(121)    *y(lXHO2)
          JAC(lXHO2,lPAN2)= +(-0.400)*rk( 75)*flg
          JAC(lXHO2,lXHO2)= +         rk(114)    *y(lNO)
     &                      +         rk(115)    *y(lHO2)
     &                      +         rk(116)    *y(lNO3)
     &                      +         rk(117)    *y(lMEO2)
     &                      +         rk(118)    *y(lRO2C)
     &                      +         rk(119)    *y(lRO2X)
     &                      +         rk(120)    *y(lMCO3)
     &                      +         rk(121)    *y(lRCO3)
     &                      +         rk(122)    *y(lBZC3)
          JAC(lXHO2,lXHO2)=JAC(lXHO2,lXHO2)
     &                      +         rk(123)    *y(lMAC3)
          JAC(lXHO2,lRO3H)= +(-0.084)*rk(281)    *y(lOH)
     &                      +(-1.000)*rk(282)*flg
          JAC(lXHO2,lPACD)= +(-1.000)*rk(221)    *y(lOH)
          JAC(lXHO2,lBZC3)= +(-1.000)*rk( 94)    *y(lRCO3)
     &                      +         rk(122)    *y(lXHO2)
          JAC(lXHO2,lBZO )= +(-1.000)*rk(113)*flg
          JAC(lXHO2,lMAC3)= +(-1.000)*rk(106)    *y(lRCO3)
     &                      +         rk(123)    *y(lXHO2)
          JAC(lXHO2,lRNO3)= +(-0.305)*rk(269)    *y(lOH)
     &                      +(-0.554)*rk(270)*flg
          JAC(lXHO2,lCRES)= +(-0.800)*rk(238)    *y(lOH)
          JAC(lXHO2,lRCHO)= +(-0.035)*rk(211)    *y(lOH)
     &                      +(-1.000)*rk(212)*flg
          JAC(lXHO2,lMEK )= +(-0.376)*rk(216)    *y(lOH)
     &                      +(-1.000)*rk(217)*flg
          JAC(lXHO2,lROOH)= +(-0.239)*rk(224)    *y(lOH)
          JAC(lXHO2,lR6PX)= +(-0.090)*rk(226)    *y(lOH)
     &                      +(-0.782)*rk(227)*flg
          JAC(lXHO2,lPRD2)= +(-0.379)*rk(267)    *y(lOH)
     &                      +(-0.913)*rk(268)*flg
          JAC(lXHO2,lRAPX)= +(-0.565)*rk(228)    *y(lOH)
          JAC(lXHO2,lIPRD)= +(-0.670)*rk(263)    *y(lOH)
     &                      +(-0.799)*rk(265)    *y(lNO3)
          JAC(lXHO2,lAFG1)= +(-0.521)*rk(246)    *y(lOH)
          JAC(lXHO2,lAFG2)= +(-0.521)*rk(249)    *y(lOH)
          JAC(lXHO2,lAFG3)= +(-0.561)*rk(252)    *y(lOH)
     &                      +(-0.095)*rk(253)    *y(lO3)
          JAC(lXHO2,lMACR)= +(-0.500)*rk(254)    *y(lOH)
     &                      +(-0.500)*rk(256)    *y(lNO3)
          JAC(lXHO2,lMVK )= +(-0.300)*rk(259)    *y(lOH)
     &                      +(-0.050)*rk(260)    *y(lO3)
          JAC(lXHO2,lACRO)= +(-0.250)*rk(274)    *y(lOH)
     &                      +(-0.031)*rk(276)    *y(lNO3)
          JAC(lXHO2,lETHE)= +(-1.000)*rk(514)    *y(lOH)
     &                      +(-1.000)*rk(516)    *y(lNO3)
     &                      +(-0.290)*rk(517)    *y(lO3P)
          JAC(lXHO2,lPRPE)= +(-0.984)*rk(518)    *y(lOH)
     &                      +(-0.949)*rk(520)    *y(lNO3)
          JAC(lXHO2,lBD13)= +(-0.951)*rk(522)    *y(lOH)
     &                      +(-0.815)*rk(524)    *y(lNO3)
     &                      +(-0.117)*rk(525)    *y(lO3P)
          JAC(lXHO2,lISOP)= +(-0.907)*rk(526)    *y(lOH)
     &                      +(-0.749)*rk(528)    *y(lNO3)
          JAC(lXHO2,lAPIN)= +(-0.799)*rk(530)    *y(lOH)
     &                      +(-0.102)*rk(531)    *y(lO3)
     &                      +(-0.056)*rk(532)    *y(lNO3)
          JAC(lXHO2,lBENZ)= +(-0.290)*rk(536)    *y(lOH)
          JAC(lXHO2,lTOLU)= +(-0.454)*rk(537)    *y(lOH)
          JAC(lXHO2,lMXYL)= +(-0.520)*rk(538)    *y(lOH)
          JAC(lXHO2,lOXYL)= +(-0.554)*rk(539)    *y(lOH)
          JAC(lXHO2,lPXYL)= +(-0.487)*rk(540)    *y(lOH)
          JAC(lXHO2,lB124)= +(-0.627)*rk(541)    *y(lOH)
          JAC(lXHO2,lETOH)= +(-0.050)*rk(542)    *y(lOH)
          JAC(lXHO2,lALK1)= +(-1.000)*rk(543)    *y(lOH)
          JAC(lXHO2,lALK2)= +(-0.965)*rk(544)    *y(lOH)
          JAC(lXHO2,lALK3)= +(-0.695)*rk(545)    *y(lOH)
          JAC(lXHO2,lALK4)= +(-0.830)*rk(546)    *y(lOH)
          JAC(lXHO2,lALK5)= +(-0.647)*rk(547)    *y(lOH)
          JAC(lXHO2,lOLE1)= +(-0.871)*rk(548)    *y(lOH)
     &                      +(-0.057)*rk(549)    *y(lO3)
     &                      +(-0.772)*rk(550)    *y(lNO3)
          JAC(lXHO2,lOLE2)= +(-0.912)*rk(552)    *y(lOH)
     &                      +(-0.041)*rk(553)    *y(lO3)
     &                      +(-0.400)*rk(554)    *y(lNO3)
          JAC(lXHO2,lARO1)= +(-0.566)*rk(556)    *y(lOH)
          JAC(lXHO2,lARO2)= +(-0.617)*rk(557)    *y(lOH)
          JAC(lXHO2,lTERP)= +(-0.734)*rk(558)    *y(lOH)
     &                      +(-0.046)*rk(559)    *y(lO3)
     &                      +(-0.227)*rk(560)    *y(lNO3)
          JAC(lXHO2,lSESQ)= +(-0.734)*rk(562)    *y(lOH)
     &                      +(-0.046)*rk(563)    *y(lO3)
     &                      +(-0.227)*rk(564)    *y(lNO3)
          JAC(lYRPX,lNO  )= +(-1.000)*rk( 76)    *y(lRCO3)
     &                      +         rk(453)    *y(lYRPX)
          JAC(lYRPX,lO3P )= +(-0.290)*rk(517)    *y(lETHE)
     &                      +(-0.250)*rk(525)    *y(lBD13)
          JAC(lYRPX,lO3  )= +(-0.100)*rk(255)    *y(lMACR)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.011)*rk(549)    *y(lOLE1)
     &                      +(-0.073)*rk(553)    *y(lOLE2)
          JAC(lYRPX,lNO3 )= +(-1.000)*rk( 78)    *y(lRCO3)
     &                      +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.033)*rk(276)    *y(lACRO)
     &                      +         rk(455)    *y(lYRPX)
     &                      +(-1.000)*rk(516)    *y(lETHE)
     &                      +(-1.000)*rk(520)    *y(lPRPE)
     &                      +(-1.000)*rk(524)    *y(lBD13)
     &                      +(-0.169)*rk(550)    *y(lOLE1)
     &                      +(-0.319)*rk(554)    *y(lOLE2)
          JAC(lYRPX,lOH  )= +(-0.035)*rk(211)    *y(lRCHO)
     &                      +(-1.000)*rk(214)    *y(lACET)
     &                      +(-1.000)*rk(216)    *y(lMEK)
     &                      +(-0.491)*rk(220)    *y(lAACD)
     &                      +(-1.000)*rk(221)    *y(lPACD)
     &                      +(-0.256)*rk(224)    *y(lROOH)
     &                      +(-0.160)*rk(226)    *y(lR6PX)
     &                      +(-0.500)*rk(254)    *y(lMACR)
     &                      +(-1.000)*rk(259)    *y(lMVK)
          JAC(lYRPX,lOH  )=JAC(lYRPX,lOH  )
     &                      +(-0.157)*rk(269)    *y(lRNO3)
     &                      +(-0.250)*rk(274)    *y(lACRO)
     &                      +(-0.020)*rk(279)    *y(lCO3H)
     &                      +(-0.194)*rk(281)    *y(lRO3H)
     &                      +(-1.000)*rk(514)    *y(lETHE)
     &                      +(-1.000)*rk(518)    *y(lPRPE)
     &                      +(-1.000)*rk(522)    *y(lBD13)
     &                      +(-0.050)*rk(542)    *y(lETOH)
          JAC(lYRPX,lOH  )=JAC(lYRPX,lOH  )
     &                      +(-1.000)*rk(543)    *y(lALK1)
     &                      +(-1.000)*rk(544)    *y(lALK2)
     &                      +(-0.983)*rk(545)    *y(lALK3)
     &                      +(-0.169)*rk(548)    *y(lOLE1)
     &                      +(-0.319)*rk(552)    *y(lOLE2)
          JAC(lYRPX,lHO2 )= +         rk(454)    *y(lYRPX)
          JAC(lYRPX,lMEO2)= +(-1.000)*rk( 79)    *y(lRCO3)
     &                      +         rk(456)    *y(lYRPX)
          JAC(lYRPX,lRO2C)= +(-1.000)*rk( 80)    *y(lRCO3)
     &                      +         rk(457)    *y(lYRPX)
          JAC(lYRPX,lRO2X)= +(-1.000)*rk( 81)    *y(lRCO3)
     &                      +         rk(458)    *y(lYRPX)
          JAC(lYRPX,lMCO3)= +(-1.000)*rk( 82)    *y(lRCO3)
     &                      +         rk(459)    *y(lYRPX)
          JAC(lYRPX,lCO3H)= +(-0.020)*rk(279)    *y(lOH)
          JAC(lYRPX,lAACD)= +(-0.491)*rk(220)    *y(lOH)
          JAC(lYRPX,lRCO3)= +(-1.000)*rk( 76)    *y(lNO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk( 80)    *y(lRO2C)
     &                      +(-1.000)*rk( 81)    *y(lRO2X)
     &                      +(-1.000)*rk( 82)    *y(lMCO3)
     &                      +(-4.000)*rk( 83)    *y(lRCO3)
     &                      +(-1.000)*rk( 94)    *y(lBZC3)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
          JAC(lYRPX,lRCO3)=JAC(lYRPX,lRCO3)
     &                      +         rk(460)    *y(lYRPX)
          JAC(lYRPX,lPAN2)= +(-0.400)*rk( 75)*flg
          JAC(lYRPX,lYRPX)= +         rk(453)    *y(lNO)
     &                      +         rk(454)    *y(lHO2)
     &                      +         rk(455)    *y(lNO3)
     &                      +         rk(456)    *y(lMEO2)
     &                      +         rk(457)    *y(lRO2C)
     &                      +         rk(458)    *y(lRO2X)
     &                      +         rk(459)    *y(lMCO3)
     &                      +         rk(460)    *y(lRCO3)
     &                      +         rk(461)    *y(lBZC3)
          JAC(lYRPX,lYRPX)=JAC(lYRPX,lYRPX)
     &                      +         rk(462)    *y(lMAC3)
          JAC(lYRPX,lRO3H)= +(-0.194)*rk(281)    *y(lOH)
     &                      +(-1.000)*rk(282)*flg
          JAC(lYRPX,lPACD)= +(-1.000)*rk(221)    *y(lOH)
          JAC(lYRPX,lBZC3)= +(-1.000)*rk( 94)    *y(lRCO3)
     &                      +         rk(461)    *y(lYRPX)
          JAC(lYRPX,lMAC3)= +(-1.000)*rk(106)    *y(lRCO3)
     &                      +         rk(462)    *y(lYRPX)
          JAC(lYRPX,lRNO3)= +(-0.157)*rk(269)    *y(lOH)
     &                      +(-0.066)*rk(270)*flg
          JAC(lYRPX,lACET)= +(-1.000)*rk(214)    *y(lOH)
          JAC(lYRPX,lRCHO)= +(-0.035)*rk(211)    *y(lOH)
     &                      +(-1.000)*rk(212)*flg
          JAC(lYRPX,lMEK )= +(-1.000)*rk(216)    *y(lOH)
     &                      +(-1.000)*rk(217)*flg
          JAC(lYRPX,lROOH)= +(-0.256)*rk(224)    *y(lOH)
          JAC(lYRPX,lR6PX)= +(-0.160)*rk(226)    *y(lOH)
          JAC(lYRPX,lMACR)= +(-0.500)*rk(254)    *y(lOH)
     &                      +(-0.100)*rk(255)    *y(lO3)
     &                      +(-0.500)*rk(256)    *y(lNO3)
     &                      +(-0.330)*rk(258)*flg
          JAC(lYRPX,lMVK )= +(-1.000)*rk(259)    *y(lOH)
     &                      +(-0.050)*rk(260)    *y(lO3)
          JAC(lYRPX,lACRO)= +(-0.250)*rk(274)    *y(lOH)
     &                      +(-0.033)*rk(276)    *y(lNO3)
          JAC(lYRPX,lETHE)= +(-1.000)*rk(514)    *y(lOH)
     &                      +(-1.000)*rk(516)    *y(lNO3)
     &                      +(-0.290)*rk(517)    *y(lO3P)
          JAC(lYRPX,lPRPE)= +(-1.000)*rk(518)    *y(lOH)
     &                      +(-1.000)*rk(520)    *y(lNO3)
          JAC(lYRPX,lBD13)= +(-1.000)*rk(522)    *y(lOH)
     &                      +(-1.000)*rk(524)    *y(lNO3)
     &                      +(-0.250)*rk(525)    *y(lO3P)
          JAC(lYRPX,lETOH)= +(-0.050)*rk(542)    *y(lOH)
          JAC(lYRPX,lALK1)= +(-1.000)*rk(543)    *y(lOH)
          JAC(lYRPX,lALK2)= +(-1.000)*rk(544)    *y(lOH)
          JAC(lYRPX,lALK3)= +(-0.983)*rk(545)    *y(lOH)
          JAC(lYRPX,lOLE1)= +(-0.169)*rk(548)    *y(lOH)
     &                      +(-0.011)*rk(549)    *y(lO3)
     &                      +(-0.169)*rk(550)    *y(lNO3)
          JAC(lYRPX,lOLE2)= +(-0.319)*rk(552)    *y(lOH)
     &                      +(-0.073)*rk(553)    *y(lO3)
     &                      +(-0.319)*rk(554)    *y(lNO3)
          JAC(lXCCH,lNO  )= +(-1.000)*rk( 76)    *y(lRCO3)
     &                      +         rk(293)    *y(lXCCH)
          JAC(lXCCH,lO3  )= +(-0.011)*rk(549)    *y(lOLE1)
     &                      +(-0.071)*rk(553)    *y(lOLE2)
          JAC(lXCCH,lNO3 )= +(-1.000)*rk( 78)    *y(lRCO3)
     &                      +         rk(295)    *y(lXCCH)
     &                      +(-0.013)*rk(550)    *y(lOLE1)
     &                      +(-0.579)*rk(554)    *y(lOLE2)
     &                      +(-0.002)*rk(564)    *y(lSESQ)
          JAC(lXCCH,lOH  )= +(-0.035)*rk(211)    *y(lRCHO)
     &                      +(-0.504)*rk(216)    *y(lMEK)
     &                      +(-0.142)*rk(221)    *y(lPACD)
     &                      +(-0.012)*rk(224)    *y(lROOH)
     &                      +(-0.020)*rk(226)    *y(lR6PX)
     &                      +(-0.083)*rk(267)    *y(lPRD2)
     &                      +(-0.429)*rk(269)    *y(lRNO3)
     &                      +(-0.167)*rk(274)    *y(lACRO)
     &                      +(-0.110)*rk(281)    *y(lRO3H)
          JAC(lXCCH,lOH  )=JAC(lXCCH,lOH  )
     &                      +(-0.984)*rk(518)    *y(lPRPE)
     &                      +(-1.000)*rk(543)    *y(lALK1)
     &                      +(-0.445)*rk(545)    *y(lALK3)
     &                      +(-0.438)*rk(546)    *y(lALK4)
     &                      +(-0.106)*rk(547)    *y(lALK5)
     &                      +(-0.010)*rk(548)    *y(lOLE1)
     &                      +(-0.835)*rk(552)    *y(lOLE2)
          JAC(lXCCH,lHO2 )= +         rk(294)    *y(lXCCH)
          JAC(lXCCH,lMEO2)= +(-1.000)*rk( 79)    *y(lRCO3)
     &                      +         rk(296)    *y(lXCCH)
          JAC(lXCCH,lRO2C)= +(-1.000)*rk( 80)    *y(lRCO3)
     &                      +         rk(297)    *y(lXCCH)
          JAC(lXCCH,lRO2X)= +(-1.000)*rk( 81)    *y(lRCO3)
     &                      +         rk(298)    *y(lXCCH)
          JAC(lXCCH,lMCO3)= +(-1.000)*rk( 82)    *y(lRCO3)
     &                      +         rk(299)    *y(lXCCH)
          JAC(lXCCH,lRCO3)= +(-1.000)*rk( 76)    *y(lNO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +(-1.000)*rk( 79)    *y(lMEO2)
     &                      +(-1.000)*rk( 80)    *y(lRO2C)
     &                      +(-1.000)*rk( 81)    *y(lRO2X)
     &                      +(-1.000)*rk( 82)    *y(lMCO3)
     &                      +(-4.000)*rk( 83)    *y(lRCO3)
     &                      +(-1.000)*rk( 94)    *y(lBZC3)
     &                      +(-1.000)*rk(106)    *y(lMAC3)
          JAC(lXCCH,lRCO3)=JAC(lXCCH,lRCO3)
     &                      +         rk(300)    *y(lXCCH)
          JAC(lXCCH,lPAN2)= +(-0.400)*rk( 75)*flg
          JAC(lXCCH,lXCCH)= +         rk(293)    *y(lNO)
     &                      +         rk(294)    *y(lHO2)
     &                      +         rk(295)    *y(lNO3)
     &                      +         rk(296)    *y(lMEO2)
     &                      +         rk(297)    *y(lRO2C)
     &                      +         rk(298)    *y(lRO2X)
     &                      +         rk(299)    *y(lMCO3)
     &                      +         rk(300)    *y(lRCO3)
     &                      +         rk(301)    *y(lBZC3)
          JAC(lXCCH,lXCCH)=JAC(lXCCH,lXCCH)
     &                      +         rk(302)    *y(lMAC3)
          JAC(lXCCH,lRO3H)= +(-0.110)*rk(281)    *y(lOH)
     &                      +(-1.000)*rk(282)*flg
          JAC(lXCCH,lPACD)= +(-0.142)*rk(221)    *y(lOH)
          JAC(lXCCH,lBZC3)= +(-1.000)*rk( 94)    *y(lRCO3)
     &                      +         rk(301)    *y(lXCCH)
          JAC(lXCCH,lMAC3)= +(-1.000)*rk(106)    *y(lRCO3)
     &                      +         rk(302)    *y(lXCCH)
          JAC(lXCCH,lRNO3)= +(-0.429)*rk(269)    *y(lOH)
     &                      +(-0.230)*rk(270)*flg
          JAC(lXCCH,lRCHO)= +(-0.035)*rk(211)    *y(lOH)
     &                      +(-1.000)*rk(212)*flg
          JAC(lXCCH,lMEK )= +(-0.504)*rk(216)    *y(lOH)
     &                      +(-1.000)*rk(217)*flg
          JAC(lXCCH,lROOH)= +(-0.012)*rk(224)    *y(lOH)
          JAC(lXCCH,lR6PX)= +(-0.020)*rk(226)    *y(lOH)
     &                      +(-0.026)*rk(227)*flg
          JAC(lXCCH,lPRD2)= +(-0.083)*rk(267)    *y(lOH)
     &                      +(-0.163)*rk(268)*flg
          JAC(lXCCH,lACRO)= +(-0.167)*rk(274)    *y(lOH)
          JAC(lXCCH,lPRPE)= +(-0.984)*rk(518)    *y(lOH)
          JAC(lXCCH,lALK1)= +(-1.000)*rk(543)    *y(lOH)
          JAC(lXCCH,lALK3)= +(-0.445)*rk(545)    *y(lOH)
          JAC(lXCCH,lALK4)= +(-0.438)*rk(546)    *y(lOH)
          JAC(lXCCH,lALK5)= +(-0.106)*rk(547)    *y(lOH)
          JAC(lXCCH,lOLE1)= +(-0.010)*rk(548)    *y(lOH)
     &                      +(-0.011)*rk(549)    *y(lO3)
     &                      +(-0.013)*rk(550)    *y(lNO3)
          JAC(lXCCH,lOLE2)= +(-0.835)*rk(552)    *y(lOH)
     &                      +(-0.071)*rk(553)    *y(lO3)
     &                      +(-0.579)*rk(554)    *y(lNO3)
          JAC(lXCCH,lSESQ)= +(-0.002)*rk(564)    *y(lNO3)
          JAC(lRO3H,lOH  )= +         rk(281)    *y(lRO3H)
          JAC(lRO3H,lHO2 )= +(-0.750)*rk( 77)    *y(lRCO3)
     &                      +(-0.750)*rk( 88)    *y(lBZC3)
     &                      +(-0.750)*rk(100)    *y(lMAC3)
          JAC(lRO3H,lRCO3)= +(-0.750)*rk( 77)    *y(lHO2)
          JAC(lRO3H,lRO3H)= +         rk(281)    *y(lOH)
     &                      +         rk(282)*flg
          JAC(lRO3H,lBZC3)= +(-0.750)*rk( 88)    *y(lHO2)
          JAC(lRO3H,lMAC3)= +(-0.750)*rk(100)    *y(lHO2)
          JAC(lPACD,lO3  )= +(-0.372)*rk(264)    *y(lIPRD)
     &                      +(-0.159)*rk(549)    *y(lOLE1)
     &                      +(-0.235)*rk(553)    *y(lOLE2)
     &                      +(-0.068)*rk(559)    *y(lTERP)
     &                      +(-0.068)*rk(563)    *y(lSESQ)
          JAC(lPACD,lOH  )= +         rk(221)    *y(lPACD)
          JAC(lPACD,lHO2 )= +(-0.250)*rk( 77)    *y(lRCO3)
     &                      +(-0.250)*rk( 88)    *y(lBZC3)
     &                      +(-0.250)*rk(100)    *y(lMAC3)
          JAC(lPACD,lRCO3)= +(-0.250)*rk( 77)    *y(lHO2)
          JAC(lPACD,lPACD)= +         rk(221)    *y(lOH)
          JAC(lPACD,lBZC3)= +(-0.250)*rk( 88)    *y(lHO2)
          JAC(lPACD,lMAC3)= +(-0.250)*rk(100)    *y(lHO2)
          JAC(lPACD,lIPRD)= +(-0.372)*rk(264)    *y(lO3)
          JAC(lPACD,lOLE1)= +(-0.159)*rk(549)    *y(lO3)
          JAC(lPACD,lOLE2)= +(-0.235)*rk(553)    *y(lO3)
          JAC(lPACD,lTERP)= +(-0.068)*rk(559)    *y(lO3)
          JAC(lPACD,lSESQ)= +(-0.068)*rk(563)    *y(lO3)
          JAC(lBZC3,lNO2 )= +         rk( 84)    *y(lBZC3)
          JAC(lBZC3,lNO  )= +         rk( 87)    *y(lBZC3)
          JAC(lBZC3,lNO3 )= +         rk( 89)    *y(lBZC3)
     &                      +(-1.000)*rk(245)    *y(lBALD)
          JAC(lBZC3,lOH  )= +(-1.000)*rk(243)    *y(lBALD)
          JAC(lBZC3,lHO2 )= +         rk( 88)    *y(lBZC3)
          JAC(lBZC3,lMEO2)= +         rk( 90)    *y(lBZC3)
          JAC(lBZC3,lRO2C)= +         rk( 91)    *y(lBZC3)
          JAC(lBZC3,lRO2X)= +         rk( 92)    *y(lBZC3)
          JAC(lBZC3,lMCO3)= +         rk( 93)    *y(lBZC3)
          JAC(lBZC3,lRCO3)= +         rk( 94)    *y(lBZC3)
          JAC(lBZC3,lXHO2)= +         rk(122)    *y(lBZC3)
     &                      +(-1.000)*rk(122)    *y(lBZC3)
          JAC(lBZC3,lYRPX)= +         rk(461)    *y(lBZC3)
     &                      +(-1.000)*rk(461)    *y(lBZC3)
          JAC(lBZC3,lXCCH)= +         rk(301)    *y(lBZC3)
     &                      +(-1.000)*rk(301)    *y(lBZC3)
          JAC(lBZC3,lBZC3)= +         rk( 84)    *y(lNO2)
     &                      +         rk( 87)    *y(lNO)
     &                      +         rk( 88)    *y(lHO2)
     &                      +         rk( 89)    *y(lNO3)
     &                      +         rk( 90)    *y(lMEO2)
     &                      +         rk( 91)    *y(lRO2C)
     &                      +         rk( 92)    *y(lRO2X)
     &                      +         rk( 93)    *y(lMCO3)
     &                      +         rk( 94)    *y(lRCO3)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +( 4.000)*rk( 95)    *y(lBZC3)
     &                      +         rk(107)    *y(lMAC3)
     &                      +         rk(122)    *y(lXHO2)
     &                      +(-1.000)*rk(122)    *y(lXHO2)
     &                      +         rk(132)    *y(lXOH)
     &                      +(-1.000)*rk(132)    *y(lXOH)
     &                      +         rk(142)    *y(lXNO2)
     &                      +(-1.000)*rk(142)    *y(lXNO2)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(152)    *y(lXMEO)
     &                      +(-1.000)*rk(152)    *y(lXMEO)
     &                      +         rk(162)    *y(lXMC3)
     &                      +(-1.000)*rk(162)    *y(lXMC3)
     &                      +         rk(172)    *y(lXRC3)
     &                      +(-1.000)*rk(172)    *y(lXRC3)
     &                      +         rk(182)    *y(lXMA3)
     &                      +(-1.000)*rk(182)    *y(lXMA3)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(192)    *y(lXTBU)
     &                      +(-1.000)*rk(192)    *y(lXTBU)
     &                      +         rk(202)    *y(lXCO)
     &                      +(-1.000)*rk(202)    *y(lXCO)
     &                      +         rk(291)    *y(lXHCH)
     &                      +(-1.000)*rk(291)    *y(lXHCH)
     &                      +         rk(301)    *y(lXCCH)
     &                      +(-1.000)*rk(301)    *y(lXCCH)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(311)    *y(lXRCH)
     &                      +(-1.000)*rk(311)    *y(lXRCH)
     &                      +         rk(321)    *y(lXACE)
     &                      +(-1.000)*rk(321)    *y(lXACE)
     &                      +         rk(331)    *y(lXMEK)
     &                      +(-1.000)*rk(331)    *y(lXMEK)
     &                      +         rk(341)    *y(lXPD2)
     &                      +(-1.000)*rk(341)    *y(lXPD2)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(351)    *y(lXGLY)
     &                      +(-1.000)*rk(351)    *y(lXGLY)
     &                      +         rk(361)    *y(lXMGL)
     &                      +(-1.000)*rk(361)    *y(lXMGL)
     &                      +         rk(371)    *y(lXBAC)
     &                      +(-1.000)*rk(371)    *y(lXBAC)
     &                      +         rk(381)    *y(lXBAL)
     &                      +(-1.000)*rk(381)    *y(lXBAL)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(391)    *y(lXAF1)
     &                      +(-1.000)*rk(391)    *y(lXAF1)
     &                      +         rk(401)    *y(lXAF2)
     &                      +(-1.000)*rk(401)    *y(lXAF2)
     &                      +         rk(411)    *y(lXAF3)
     &                      +(-1.000)*rk(411)    *y(lXAF3)
     &                      +         rk(421)    *y(lXMAC)
     &                      +(-1.000)*rk(421)    *y(lXMAC)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(431)    *y(lXMVK)
     &                      +(-1.000)*rk(431)    *y(lXMVK)
     &                      +         rk(441)    *y(lXIPR)
     &                      +(-1.000)*rk(441)    *y(lXIPR)
     &                      +         rk(451)    *y(lXRN3)
     &                      +(-1.000)*rk(451)    *y(lXRN3)
     &                      +         rk(461)    *y(lYRPX)
     &                      +(-1.000)*rk(461)    *y(lYRPX)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(471)    *y(lY6PX)
     &                      +(-1.000)*rk(471)    *y(lY6PX)
     &                      +         rk(481)    *y(lYAPX)
     &                      +(-1.000)*rk(481)    *y(lYAPX)
     &                      +         rk(491)    *y(lZRN3)
     &                      +(-1.000)*rk(491)    *y(lZRN3)
     &                      +         rk(501)    *y(lXGLD)
     &                      +(-1.000)*rk(501)    *y(lXGLD)
          JAC(lBZC3,lBZC3)=JAC(lBZC3,lBZC3)
     &                      +         rk(511)    *y(lXACR)
     &                      +(-1.000)*rk(511)    *y(lXACR)
          JAC(lBZC3,lPBZN)= +(-1.000)*rk( 85)*flg
     &                      +(-0.600)*rk( 86)*flg
          JAC(lBZC3,lMAC3)= +         rk(107)    *y(lBZC3)
          JAC(lBZC3,lXOH )= +         rk(132)    *y(lBZC3)
     &                      +(-1.000)*rk(132)    *y(lBZC3)
          JAC(lBZC3,lXNO2)= +         rk(142)    *y(lBZC3)
     &                      +(-1.000)*rk(142)    *y(lBZC3)
          JAC(lBZC3,lXMEO)= +         rk(152)    *y(lBZC3)
     &                      +(-1.000)*rk(152)    *y(lBZC3)
          JAC(lBZC3,lXMC3)= +         rk(162)    *y(lBZC3)
     &                      +(-1.000)*rk(162)    *y(lBZC3)
          JAC(lBZC3,lXRC3)= +         rk(172)    *y(lBZC3)
     &                      +(-1.000)*rk(172)    *y(lBZC3)
          JAC(lBZC3,lXMA3)= +         rk(182)    *y(lBZC3)
     &                      +(-1.000)*rk(182)    *y(lBZC3)
          JAC(lBZC3,lXTBU)= +         rk(192)    *y(lBZC3)
     &                      +(-1.000)*rk(192)    *y(lBZC3)
          JAC(lBZC3,lXCO )= +         rk(202)    *y(lBZC3)
     &                      +(-1.000)*rk(202)    *y(lBZC3)
          JAC(lBZC3,lXHCH)= +         rk(291)    *y(lBZC3)
     &                      +(-1.000)*rk(291)    *y(lBZC3)
          JAC(lBZC3,lZRN3)= +         rk(491)    *y(lBZC3)
     &                      +(-1.000)*rk(491)    *y(lBZC3)
          JAC(lBZC3,lXRCH)= +         rk(311)    *y(lBZC3)
     &                      +(-1.000)*rk(311)    *y(lBZC3)
          JAC(lBZC3,lXMGL)= +         rk(361)    *y(lBZC3)
     &                      +(-1.000)*rk(361)    *y(lBZC3)
          JAC(lBZC3,lXBAC)= +         rk(371)    *y(lBZC3)
     &                      +(-1.000)*rk(371)    *y(lBZC3)
          JAC(lBZC3,lXPD2)= +         rk(341)    *y(lBZC3)
     &                      +(-1.000)*rk(341)    *y(lBZC3)
          JAC(lBZC3,lY6PX)= +         rk(471)    *y(lBZC3)
     &                      +(-1.000)*rk(471)    *y(lBZC3)
          JAC(lBZC3,lXGLY)= +         rk(351)    *y(lBZC3)
     &                      +(-1.000)*rk(351)    *y(lBZC3)
          JAC(lBZC3,lXMEK)= +         rk(331)    *y(lBZC3)
     &                      +(-1.000)*rk(331)    *y(lBZC3)
          JAC(lBZC3,lXAF1)= +         rk(391)    *y(lBZC3)
     &                      +(-1.000)*rk(391)    *y(lBZC3)
          JAC(lBZC3,lXAF2)= +         rk(401)    *y(lBZC3)
     &                      +(-1.000)*rk(401)    *y(lBZC3)
          JAC(lBZC3,lBALD)= +(-1.000)*rk(243)    *y(lOH)
     &                      +(-1.000)*rk(245)    *y(lNO3)
          JAC(lBZC3,lXIPR)= +         rk(441)    *y(lBZC3)
     &                      +(-1.000)*rk(441)    *y(lBZC3)
          JAC(lBZC3,lXGLD)= +         rk(501)    *y(lBZC3)
     &                      +(-1.000)*rk(501)    *y(lBZC3)
          JAC(lBZC3,lXRN3)= +         rk(451)    *y(lBZC3)
     &                      +(-1.000)*rk(451)    *y(lBZC3)
          JAC(lBZC3,lXACE)= +         rk(321)    *y(lBZC3)
     &                      +(-1.000)*rk(321)    *y(lBZC3)
          JAC(lBZC3,lXBAL)= +         rk(381)    *y(lBZC3)
     &                      +(-1.000)*rk(381)    *y(lBZC3)
          JAC(lBZC3,lXAF3)= +         rk(411)    *y(lBZC3)
     &                      +(-1.000)*rk(411)    *y(lBZC3)
          JAC(lBZC3,lXMAC)= +         rk(421)    *y(lBZC3)
     &                      +(-1.000)*rk(421)    *y(lBZC3)
          JAC(lBZC3,lXMVK)= +         rk(431)    *y(lBZC3)
     &                      +(-1.000)*rk(431)    *y(lBZC3)
          JAC(lBZC3,lYAPX)= +         rk(481)    *y(lBZC3)
     &                      +(-1.000)*rk(481)    *y(lBZC3)
          JAC(lBZC3,lXACR)= +         rk(511)    *y(lBZC3)
     &                      +(-1.000)*rk(511)    *y(lBZC3)
          JAC(lPBZN,lNO2 )= +(-1.000)*rk( 84)    *y(lBZC3)
          JAC(lPBZN,lBZC3)= +(-1.000)*rk( 84)    *y(lNO2)
          JAC(lPBZN,lPBZN)= +         rk( 85)*flg
     &                      +         rk( 86)*flg
          JAC(lBZO ,lNO2 )= +         rk(111)    *y(lBZO)
          JAC(lBZO ,lNO  )= +(-1.000)*rk( 87)    *y(lBZC3)
          JAC(lBZO ,lNO3 )= +(-1.000)*rk( 89)    *y(lBZC3)
     &                      +(-1.000)*rk(239)    *y(lCRES)
          JAC(lBZO ,lOH  )= +(-0.200)*rk(238)    *y(lCRES)
     &                      +(-1.000)*rk(240)    *y(lNPHE)
          JAC(lBZO ,lHO2 )= +         rk(112)    *y(lBZO)
          JAC(lBZO ,lMEO2)= +(-1.000)*rk( 90)    *y(lBZC3)
          JAC(lBZO ,lRO2C)= +(-1.000)*rk( 91)    *y(lBZC3)
          JAC(lBZO ,lRO2X)= +(-1.000)*rk( 92)    *y(lBZC3)
          JAC(lBZO ,lMCO3)= +(-1.000)*rk( 93)    *y(lBZC3)
          JAC(lBZO ,lRCO3)= +(-1.000)*rk( 94)    *y(lBZC3)
          JAC(lBZO ,lBZC3)= +(-1.000)*rk( 87)    *y(lNO)
     &                      +(-1.000)*rk( 89)    *y(lNO3)
     &                      +(-1.000)*rk( 90)    *y(lMEO2)
     &                      +(-1.000)*rk( 91)    *y(lRO2C)
     &                      +(-1.000)*rk( 92)    *y(lRO2X)
     &                      +(-1.000)*rk( 93)    *y(lMCO3)
     &                      +(-1.000)*rk( 94)    *y(lRCO3)
     &                      +(-4.000)*rk( 95)    *y(lBZC3)
     &                      +(-1.000)*rk(107)    *y(lMAC3)
          JAC(lBZO ,lPBZN)= +(-0.400)*rk( 86)*flg
          JAC(lBZO ,lBZO )= +         rk(111)    *y(lNO2)
     &                      +         rk(112)    *y(lHO2)
     &                      +         rk(113)*flg
          JAC(lBZO ,lMAC3)= +(-1.000)*rk(107)    *y(lBZC3)
          JAC(lBZO ,lNPHE)= +(-1.000)*rk(240)    *y(lOH)
          JAC(lBZO ,lCRES)= +(-0.200)*rk(238)    *y(lOH)
     &                      +(-1.000)*rk(239)    *y(lNO3)
          JAC(lMAC3,lNO2 )= +         rk( 96)    *y(lMAC3)
          JAC(lMAC3,lNO  )= +         rk( 99)    *y(lMAC3)
     &                      +(-1.000)*rk(174)    *y(lXMA3)
          JAC(lMAC3,lNO3 )= +         rk(101)    *y(lMAC3)
     &                      +(-1.000)*rk(176)    *y(lXMA3)
     &                      +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.150)*rk(265)    *y(lIPRD)
     &                      +(-0.967)*rk(276)    *y(lACRO)
          JAC(lMAC3,lOH  )= +(-0.217)*rk(246)    *y(lAFG1)
     &                      +(-0.217)*rk(249)    *y(lAFG2)
     &                      +(-0.206)*rk(252)    *y(lAFG3)
     &                      +(-0.500)*rk(254)    *y(lMACR)
     &                      +(-0.289)*rk(263)    *y(lIPRD)
     &                      +(-0.750)*rk(274)    *y(lACRO)
          JAC(lMAC3,lHO2 )= +         rk(100)    *y(lMAC3)
          JAC(lMAC3,lMEO2)= +         rk(102)    *y(lMAC3)
     &                      +(-0.500)*rk(177)    *y(lXMA3)
          JAC(lMAC3,lRO2C)= +         rk(103)    *y(lMAC3)
     &                      +(-0.500)*rk(178)    *y(lXMA3)
          JAC(lMAC3,lRO2X)= +         rk(104)    *y(lMAC3)
     &                      +(-0.500)*rk(179)    *y(lXMA3)
          JAC(lMAC3,lMCO3)= +         rk(105)    *y(lMAC3)
     &                      +(-1.000)*rk(180)    *y(lXMA3)
          JAC(lMAC3,lRCO3)= +         rk(106)    *y(lMAC3)
     &                      +(-1.000)*rk(181)    *y(lXMA3)
          JAC(lMAC3,lXHO2)= +         rk(123)    *y(lMAC3)
     &                      +(-1.000)*rk(123)    *y(lMAC3)
          JAC(lMAC3,lYRPX)= +         rk(462)    *y(lMAC3)
     &                      +(-1.000)*rk(462)    *y(lMAC3)
          JAC(lMAC3,lXCCH)= +         rk(302)    *y(lMAC3)
     &                      +(-1.000)*rk(302)    *y(lMAC3)
          JAC(lMAC3,lBZC3)= +         rk(107)    *y(lMAC3)
     &                      +(-1.000)*rk(182)    *y(lXMA3)
          JAC(lMAC3,lMAC3)= +         rk( 96)    *y(lNO2)
     &                      +         rk( 99)    *y(lNO)
     &                      +         rk(100)    *y(lHO2)
     &                      +         rk(101)    *y(lNO3)
     &                      +         rk(102)    *y(lMEO2)
     &                      +         rk(103)    *y(lRO2C)
     &                      +         rk(104)    *y(lRO2X)
     &                      +         rk(105)    *y(lMCO3)
     &                      +         rk(106)    *y(lRCO3)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(107)    *y(lBZC3)
     &                      +( 4.000)*rk(108)    *y(lMAC3)
     &                      +         rk(123)    *y(lXHO2)
     &                      +(-1.000)*rk(123)    *y(lXHO2)
     &                      +         rk(133)    *y(lXOH)
     &                      +(-1.000)*rk(133)    *y(lXOH)
     &                      +         rk(143)    *y(lXNO2)
     &                      +(-1.000)*rk(143)    *y(lXNO2)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(153)    *y(lXMEO)
     &                      +(-1.000)*rk(153)    *y(lXMEO)
     &                      +         rk(163)    *y(lXMC3)
     &                      +(-1.000)*rk(163)    *y(lXMC3)
     &                      +         rk(173)    *y(lXRC3)
     &                      +(-1.000)*rk(173)    *y(lXRC3)
     &                      +         rk(183)    *y(lXMA3)
     &                      +(-2.000)*rk(183)    *y(lXMA3)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(193)    *y(lXTBU)
     &                      +(-1.000)*rk(193)    *y(lXTBU)
     &                      +         rk(203)    *y(lXCO)
     &                      +(-1.000)*rk(203)    *y(lXCO)
     &                      +         rk(292)    *y(lXHCH)
     &                      +(-1.000)*rk(292)    *y(lXHCH)
     &                      +         rk(302)    *y(lXCCH)
     &                      +(-1.000)*rk(302)    *y(lXCCH)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(312)    *y(lXRCH)
     &                      +(-1.000)*rk(312)    *y(lXRCH)
     &                      +         rk(322)    *y(lXACE)
     &                      +(-1.000)*rk(322)    *y(lXACE)
     &                      +         rk(332)    *y(lXMEK)
     &                      +(-1.000)*rk(332)    *y(lXMEK)
     &                      +         rk(342)    *y(lXPD2)
     &                      +(-1.000)*rk(342)    *y(lXPD2)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(352)    *y(lXGLY)
     &                      +(-1.000)*rk(352)    *y(lXGLY)
     &                      +         rk(362)    *y(lXMGL)
     &                      +(-1.000)*rk(362)    *y(lXMGL)
     &                      +         rk(372)    *y(lXBAC)
     &                      +(-1.000)*rk(372)    *y(lXBAC)
     &                      +         rk(382)    *y(lXBAL)
     &                      +(-1.000)*rk(382)    *y(lXBAL)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(392)    *y(lXAF1)
     &                      +(-1.000)*rk(392)    *y(lXAF1)
     &                      +         rk(402)    *y(lXAF2)
     &                      +(-1.000)*rk(402)    *y(lXAF2)
     &                      +         rk(412)    *y(lXAF3)
     &                      +(-1.000)*rk(412)    *y(lXAF3)
     &                      +         rk(422)    *y(lXMAC)
     &                      +(-1.000)*rk(422)    *y(lXMAC)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(432)    *y(lXMVK)
     &                      +(-1.000)*rk(432)    *y(lXMVK)
     &                      +         rk(442)    *y(lXIPR)
     &                      +(-1.000)*rk(442)    *y(lXIPR)
     &                      +         rk(452)    *y(lXRN3)
     &                      +(-1.000)*rk(452)    *y(lXRN3)
     &                      +         rk(462)    *y(lYRPX)
     &                      +(-1.000)*rk(462)    *y(lYRPX)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(472)    *y(lY6PX)
     &                      +(-1.000)*rk(472)    *y(lY6PX)
     &                      +         rk(482)    *y(lYAPX)
     &                      +(-1.000)*rk(482)    *y(lYAPX)
     &                      +         rk(492)    *y(lZRN3)
     &                      +(-1.000)*rk(492)    *y(lZRN3)
     &                      +         rk(502)    *y(lXGLD)
     &                      +(-1.000)*rk(502)    *y(lXGLD)
          JAC(lMAC3,lMAC3)=JAC(lMAC3,lMAC3)
     &                      +         rk(512)    *y(lXACR)
     &                      +(-1.000)*rk(512)    *y(lXACR)
          JAC(lMAC3,lMPAN)= +(-1.000)*rk( 97)*flg
     &                      +(-0.600)*rk( 98)*flg
          JAC(lMAC3,lXOH )= +         rk(133)    *y(lMAC3)
     &                      +(-1.000)*rk(133)    *y(lMAC3)
          JAC(lMAC3,lXNO2)= +         rk(143)    *y(lMAC3)
     &                      +(-1.000)*rk(143)    *y(lMAC3)
          JAC(lMAC3,lXMEO)= +         rk(153)    *y(lMAC3)
     &                      +(-1.000)*rk(153)    *y(lMAC3)
          JAC(lMAC3,lXMC3)= +         rk(163)    *y(lMAC3)
     &                      +(-1.000)*rk(163)    *y(lMAC3)
          JAC(lMAC3,lXRC3)= +         rk(173)    *y(lMAC3)
     &                      +(-1.000)*rk(173)    *y(lMAC3)
          JAC(lMAC3,lXMA3)= +(-1.000)*rk(174)    *y(lNO)
     &                      +(-1.000)*rk(176)    *y(lNO3)
     &                      +(-0.500)*rk(177)    *y(lMEO2)
     &                      +(-0.500)*rk(178)    *y(lRO2C)
     &                      +(-0.500)*rk(179)    *y(lRO2X)
     &                      +(-1.000)*rk(180)    *y(lMCO3)
     &                      +(-1.000)*rk(181)    *y(lRCO3)
     &                      +(-1.000)*rk(182)    *y(lBZC3)
     &                      +         rk(183)    *y(lMAC3)
          JAC(lMAC3,lXMA3)=JAC(lMAC3,lXMA3)
     &                      +(-2.000)*rk(183)    *y(lMAC3)
          JAC(lMAC3,lXTBU)= +         rk(193)    *y(lMAC3)
     &                      +(-1.000)*rk(193)    *y(lMAC3)
          JAC(lMAC3,lXCO )= +         rk(203)    *y(lMAC3)
     &                      +(-1.000)*rk(203)    *y(lMAC3)
          JAC(lMAC3,lXHCH)= +         rk(292)    *y(lMAC3)
     &                      +(-1.000)*rk(292)    *y(lMAC3)
          JAC(lMAC3,lZRN3)= +         rk(492)    *y(lMAC3)
     &                      +(-1.000)*rk(492)    *y(lMAC3)
          JAC(lMAC3,lXRCH)= +         rk(312)    *y(lMAC3)
     &                      +(-1.000)*rk(312)    *y(lMAC3)
          JAC(lMAC3,lXMGL)= +         rk(362)    *y(lMAC3)
     &                      +(-1.000)*rk(362)    *y(lMAC3)
          JAC(lMAC3,lXBAC)= +         rk(372)    *y(lMAC3)
     &                      +(-1.000)*rk(372)    *y(lMAC3)
          JAC(lMAC3,lXPD2)= +         rk(342)    *y(lMAC3)
     &                      +(-1.000)*rk(342)    *y(lMAC3)
          JAC(lMAC3,lY6PX)= +         rk(472)    *y(lMAC3)
     &                      +(-1.000)*rk(472)    *y(lMAC3)
          JAC(lMAC3,lIPRD)= +(-0.289)*rk(263)    *y(lOH)
     &                      +(-0.150)*rk(265)    *y(lNO3)
          JAC(lMAC3,lXGLY)= +         rk(352)    *y(lMAC3)
     &                      +(-1.000)*rk(352)    *y(lMAC3)
          JAC(lMAC3,lXMEK)= +         rk(332)    *y(lMAC3)
     &                      +(-1.000)*rk(332)    *y(lMAC3)
          JAC(lMAC3,lXAF1)= +         rk(392)    *y(lMAC3)
     &                      +(-1.000)*rk(392)    *y(lMAC3)
          JAC(lMAC3,lXAF2)= +         rk(402)    *y(lMAC3)
     &                      +(-1.000)*rk(402)    *y(lMAC3)
          JAC(lMAC3,lAFG1)= +(-0.217)*rk(246)    *y(lOH)
     &                      +(-0.500)*rk(248)*flg
          JAC(lMAC3,lAFG2)= +(-0.217)*rk(249)    *y(lOH)
          JAC(lMAC3,lAFG3)= +(-0.206)*rk(252)    *y(lOH)
          JAC(lMAC3,lXIPR)= +         rk(442)    *y(lMAC3)
     &                      +(-1.000)*rk(442)    *y(lMAC3)
          JAC(lMAC3,lMACR)= +(-0.500)*rk(254)    *y(lOH)
     &                      +(-0.500)*rk(256)    *y(lNO3)
     &                      +(-0.330)*rk(258)*flg
          JAC(lMAC3,lMVK )= +(-0.400)*rk(262)*flg
          JAC(lMAC3,lXGLD)= +         rk(502)    *y(lMAC3)
     &                      +(-1.000)*rk(502)    *y(lMAC3)
          JAC(lMAC3,lXRN3)= +         rk(452)    *y(lMAC3)
     &                      +(-1.000)*rk(452)    *y(lMAC3)
          JAC(lMAC3,lXACE)= +         rk(322)    *y(lMAC3)
     &                      +(-1.000)*rk(322)    *y(lMAC3)
          JAC(lMAC3,lACRO)= +(-0.750)*rk(274)    *y(lOH)
     &                      +(-0.967)*rk(276)    *y(lNO3)
     &                      +(-0.330)*rk(278)*flg
          JAC(lMAC3,lXBAL)= +         rk(382)    *y(lMAC3)
     &                      +(-1.000)*rk(382)    *y(lMAC3)
          JAC(lMAC3,lXAF3)= +         rk(412)    *y(lMAC3)
     &                      +(-1.000)*rk(412)    *y(lMAC3)
          JAC(lMAC3,lXMAC)= +         rk(422)    *y(lMAC3)
     &                      +(-1.000)*rk(422)    *y(lMAC3)
          JAC(lMAC3,lXMVK)= +         rk(432)    *y(lMAC3)
     &                      +(-1.000)*rk(432)    *y(lMAC3)
          JAC(lMAC3,lYAPX)= +         rk(482)    *y(lMAC3)
     &                      +(-1.000)*rk(482)    *y(lMAC3)
          JAC(lMAC3,lXACR)= +         rk(512)    *y(lMAC3)
     &                      +(-1.000)*rk(512)    *y(lMAC3)
          JAC(lMPAN,lNO2 )= +(-1.000)*rk( 96)    *y(lMAC3)
          JAC(lMPAN,lMAC3)= +(-1.000)*rk( 96)    *y(lNO2)
          JAC(lMPAN,lMPAN)= +         rk( 97)*flg
     &                      +         rk( 98)*flg
          JAC(lTBUO,lNO2 )= +         rk(109)    *y(lTBUO)
          JAC(lTBUO,lNO  )= +(-1.000)*rk(184)    *y(lXTBU)
          JAC(lTBUO,lNO3 )= +(-1.000)*rk(186)    *y(lXTBU)
          JAC(lTBUO,lMEO2)= +(-0.500)*rk(187)    *y(lXTBU)
          JAC(lTBUO,lRO2C)= +(-0.500)*rk(188)    *y(lXTBU)
          JAC(lTBUO,lRO2X)= +(-0.500)*rk(189)    *y(lXTBU)
          JAC(lTBUO,lMCO3)= +(-1.000)*rk(190)    *y(lXTBU)
          JAC(lTBUO,lRCO3)= +(-1.000)*rk(191)    *y(lXTBU)
          JAC(lTBUO,lBZC3)= +(-1.000)*rk(192)    *y(lXTBU)
          JAC(lTBUO,lMAC3)= +(-1.000)*rk(193)    *y(lXTBU)
          JAC(lTBUO,lTBUO)= +         rk(109)    *y(lNO2)
     &                      +         rk(110)*flg
          JAC(lTBUO,lXTBU)= +(-1.000)*rk(184)    *y(lNO)
     &                      +(-1.000)*rk(186)    *y(lNO3)
     &                      +(-0.500)*rk(187)    *y(lMEO2)
     &                      +(-0.500)*rk(188)    *y(lRO2C)
     &                      +(-0.500)*rk(189)    *y(lRO2X)
     &                      +(-1.000)*rk(190)    *y(lMCO3)
     &                      +(-1.000)*rk(191)    *y(lRCO3)
     &                      +(-1.000)*rk(192)    *y(lBZC3)
     &                      +(-1.000)*rk(193)    *y(lMAC3)
          JAC(lRNO3,lNO2 )= +(-1.000)*rk(109)    *y(lTBUO)
          JAC(lRNO3,lNO  )= +(-1.000)*rk(443)    *y(lXRN3)
     &                      +(-1.000)*rk(483)    *y(lZRN3)
          JAC(lRNO3,lNO3 )= +(-1.000)*rk(445)    *y(lXRN3)
          JAC(lRNO3,lOH  )= +         rk(269)    *y(lRNO3)
     &                      +(-0.189)*rk(269)    *y(lRNO3)
          JAC(lRNO3,lMEO2)= +(-0.500)*rk(446)    *y(lXRN3)
          JAC(lRNO3,lRO2C)= +(-0.500)*rk(447)    *y(lXRN3)
          JAC(lRNO3,lRO2X)= +(-0.500)*rk(448)    *y(lXRN3)
          JAC(lRNO3,lMCO3)= +(-1.000)*rk(449)    *y(lXRN3)
          JAC(lRNO3,lRCO3)= +(-1.000)*rk(450)    *y(lXRN3)
          JAC(lRNO3,lBZC3)= +(-1.000)*rk(451)    *y(lXRN3)
          JAC(lRNO3,lMAC3)= +(-1.000)*rk(452)    *y(lXRN3)
          JAC(lRNO3,lTBUO)= +(-1.000)*rk(109)    *y(lNO2)
          JAC(lRNO3,lRNO3)= +         rk(269)    *y(lOH)
     &                      +(-0.189)*rk(269)    *y(lOH)
     &                      +         rk(270)*flg
          JAC(lRNO3,lZRN3)= +(-1.000)*rk(483)    *y(lNO)
          JAC(lRNO3,lXRN3)= +(-1.000)*rk(443)    *y(lNO)
     &                      +(-1.000)*rk(445)    *y(lNO3)
     &                      +(-0.500)*rk(446)    *y(lMEO2)
     &                      +(-0.500)*rk(447)    *y(lRO2C)
     &                      +(-0.500)*rk(448)    *y(lRO2X)
     &                      +(-1.000)*rk(449)    *y(lMCO3)
     &                      +(-1.000)*rk(450)    *y(lRCO3)
     &                      +(-1.000)*rk(451)    *y(lBZC3)
     &                      +(-1.000)*rk(452)    *y(lMAC3)
          JAC(lACET,lNO  )= +(-1.000)*rk(313)    *y(lXACE)
          JAC(lACET,lO3  )= +(-0.051)*rk(553)    *y(lOLE2)
          JAC(lACET,lNO3 )= +(-1.000)*rk(315)    *y(lXACE)
          JAC(lACET,lOH  )= +         rk(214)    *y(lACET)
          JAC(lACET,lMEO2)= +(-0.500)*rk(316)    *y(lXACE)
          JAC(lACET,lRO2C)= +(-0.500)*rk(317)    *y(lXACE)
          JAC(lACET,lRO2X)= +(-0.500)*rk(318)    *y(lXACE)
          JAC(lACET,lMCO3)= +(-1.000)*rk(319)    *y(lXACE)
          JAC(lACET,lRCO3)= +(-1.000)*rk(320)    *y(lXACE)
          JAC(lACET,lBZC3)= +(-1.000)*rk(321)    *y(lXACE)
          JAC(lACET,lMAC3)= +(-1.000)*rk(322)    *y(lXACE)
          JAC(lACET,lTBUO)= +(-1.000)*rk(110)*flg
          JAC(lACET,lACET)= +         rk(214)    *y(lOH)
     &                      +         rk(215)*flg
          JAC(lACET,lXACE)= +(-1.000)*rk(313)    *y(lNO)
     &                      +(-1.000)*rk(315)    *y(lNO3)
     &                      +(-0.500)*rk(316)    *y(lMEO2)
     &                      +(-0.500)*rk(317)    *y(lRO2C)
     &                      +(-0.500)*rk(318)    *y(lRO2X)
     &                      +(-1.000)*rk(319)    *y(lMCO3)
     &                      +(-1.000)*rk(320)    *y(lRCO3)
     &                      +(-1.000)*rk(321)    *y(lBZC3)
     &                      +(-1.000)*rk(322)    *y(lMAC3)
          JAC(lACET,lOLE2)= +(-0.051)*rk(553)    *y(lO3)
          JAC(lNPHE,lNO2 )= +(-1.000)*rk(111)    *y(lBZO)
          JAC(lNPHE,lOH  )= +         rk(240)    *y(lNPHE)
          JAC(lNPHE,lBZO )= +(-1.000)*rk(111)    *y(lNO2)
          JAC(lNPHE,lNPHE)= +         rk(240)    *y(lOH)
     &                      +         rk(241)*flg
     &                      +         rk(242)*flg
          JAC(lCRES,lNO3 )= +         rk(239)    *y(lCRES)
          JAC(lCRES,lOH  )= +         rk(238)    *y(lCRES)
     &                      +(-0.570)*rk(536)    *y(lBENZ)
     &                      +(-0.181)*rk(537)    *y(lTOLU)
     &                      +(-0.159)*rk(538)    *y(lMXYL)
     &                      +(-0.161)*rk(539)    *y(lOXYL)
     &                      +(-0.159)*rk(540)    *y(lPXYL)
     &                      +(-0.022)*rk(541)    *y(lB124)
     &                      +(-0.123)*rk(556)    *y(lARO1)
     &                      +(-0.077)*rk(557)    *y(lARO2)
          JAC(lCRES,lHO2 )= +(-1.000)*rk(112)    *y(lBZO)
          JAC(lCRES,lBZO )= +(-1.000)*rk(112)    *y(lHO2)
     &                      +(-1.000)*rk(113)*flg
          JAC(lCRES,lCRES)= +         rk(238)    *y(lOH)
     &                      +         rk(239)    *y(lNO3)
          JAC(lCRES,lBENZ)= +(-0.570)*rk(536)    *y(lOH)
          JAC(lCRES,lTOLU)= +(-0.181)*rk(537)    *y(lOH)
          JAC(lCRES,lMXYL)= +(-0.159)*rk(538)    *y(lOH)
          JAC(lCRES,lOXYL)= +(-0.161)*rk(539)    *y(lOH)
          JAC(lCRES,lPXYL)= +(-0.159)*rk(540)    *y(lOH)
          JAC(lCRES,lB124)= +(-0.022)*rk(541)    *y(lOH)
          JAC(lCRES,lARO1)= +(-0.123)*rk(556)    *y(lOH)
          JAC(lCRES,lARO2)= +(-0.077)*rk(557)    *y(lOH)
          JAC(lXOH ,lNO  )= +         rk(124)    *y(lXOH)
          JAC(lXOH ,lNO3 )= +         rk(126)    *y(lXOH)
          JAC(lXOH ,lOH  )= +(-0.012)*rk(224)    *y(lROOH)
     &                      +(-0.041)*rk(226)    *y(lR6PX)
     &                      +(-0.024)*rk(228)    *y(lRAPX)
     &                      +(-0.020)*rk(279)    *y(lCO3H)
     &                      +(-0.110)*rk(281)    *y(lRO3H)
          JAC(lXOH ,lHO2 )= +         rk(125)    *y(lXOH)
          JAC(lXOH ,lMEO2)= +         rk(127)    *y(lXOH)
          JAC(lXOH ,lRO2C)= +         rk(128)    *y(lXOH)
          JAC(lXOH ,lRO2X)= +         rk(129)    *y(lXOH)
          JAC(lXOH ,lMCO3)= +         rk(130)    *y(lXOH)
          JAC(lXOH ,lCO3H)= +(-0.020)*rk(279)    *y(lOH)
          JAC(lXOH ,lRCO3)= +         rk(131)    *y(lXOH)
          JAC(lXOH ,lRO3H)= +(-0.110)*rk(281)    *y(lOH)
          JAC(lXOH ,lBZC3)= +         rk(132)    *y(lXOH)
          JAC(lXOH ,lMAC3)= +         rk(133)    *y(lXOH)
          JAC(lXOH ,lXOH )= +         rk(124)    *y(lNO)
     &                      +         rk(125)    *y(lHO2)
     &                      +         rk(126)    *y(lNO3)
     &                      +         rk(127)    *y(lMEO2)
     &                      +         rk(128)    *y(lRO2C)
     &                      +         rk(129)    *y(lRO2X)
     &                      +         rk(130)    *y(lMCO3)
     &                      +         rk(131)    *y(lRCO3)
     &                      +         rk(132)    *y(lBZC3)
          JAC(lXOH ,lXOH )=JAC(lXOH ,lXOH )
     &                      +         rk(133)    *y(lMAC3)
          JAC(lXOH ,lROOH)= +(-0.012)*rk(224)    *y(lOH)
          JAC(lXOH ,lR6PX)= +(-0.041)*rk(226)    *y(lOH)
          JAC(lXOH ,lRAPX)= +(-0.024)*rk(228)    *y(lOH)
          JAC(lXNO2,lNO  )= +         rk(134)    *y(lXNO2)
          JAC(lXNO2,lNO3 )= +         rk(136)    *y(lXNO2)
     &                      +(-0.120)*rk(524)    *y(lBD13)
     &                      +(-0.187)*rk(528)    *y(lISOP)
     &                      +(-0.643)*rk(532)    *y(lAPIN)
     &                      +(-0.426)*rk(554)    *y(lOLE2)
     &                      +(-0.287)*rk(560)    *y(lTERP)
     &                      +(-0.287)*rk(564)    *y(lSESQ)
          JAC(lXNO2,lOH  )= +(-0.313)*rk(269)    *y(lRNO3)
          JAC(lXNO2,lHO2 )= +         rk(135)    *y(lXNO2)
          JAC(lXNO2,lMEO2)= +         rk(137)    *y(lXNO2)
          JAC(lXNO2,lRO2C)= +         rk(138)    *y(lXNO2)
          JAC(lXNO2,lRO2X)= +         rk(139)    *y(lXNO2)
          JAC(lXNO2,lMCO3)= +         rk(140)    *y(lXNO2)
          JAC(lXNO2,lRCO3)= +         rk(141)    *y(lXNO2)
          JAC(lXNO2,lBZC3)= +         rk(142)    *y(lXNO2)
          JAC(lXNO2,lMAC3)= +         rk(143)    *y(lXNO2)
          JAC(lXNO2,lRNO3)= +(-0.313)*rk(269)    *y(lOH)
          JAC(lXNO2,lXNO2)= +         rk(134)    *y(lNO)
     &                      +         rk(135)    *y(lHO2)
     &                      +         rk(136)    *y(lNO3)
     &                      +         rk(137)    *y(lMEO2)
     &                      +         rk(138)    *y(lRO2C)
     &                      +         rk(139)    *y(lRO2X)
     &                      +         rk(140)    *y(lMCO3)
     &                      +         rk(141)    *y(lRCO3)
     &                      +         rk(142)    *y(lBZC3)
          JAC(lXNO2,lXNO2)=JAC(lXNO2,lXNO2)
     &                      +         rk(143)    *y(lMAC3)
          JAC(lXNO2,lBD13)= +(-0.120)*rk(524)    *y(lNO3)
          JAC(lXNO2,lISOP)= +(-0.187)*rk(528)    *y(lNO3)
          JAC(lXNO2,lAPIN)= +(-0.643)*rk(532)    *y(lNO3)
          JAC(lXNO2,lOLE2)= +(-0.426)*rk(554)    *y(lNO3)
          JAC(lXNO2,lTERP)= +(-0.287)*rk(560)    *y(lNO3)
          JAC(lXNO2,lSESQ)= +(-0.287)*rk(564)    *y(lNO3)
          JAC(lXMEO,lNO  )= +         rk(144)    *y(lXMEO)
          JAC(lXMEO,lNO3 )= +         rk(146)    *y(lXMEO)
     &                      +(-0.035)*rk(554)    *y(lOLE2)
          JAC(lXMEO,lOH  )= +(-0.010)*rk(546)    *y(lALK4)
     &                      +(-0.001)*rk(548)    *y(lOLE1)
          JAC(lXMEO,lHO2 )= +         rk(145)    *y(lXMEO)
          JAC(lXMEO,lMEO2)= +         rk(147)    *y(lXMEO)
          JAC(lXMEO,lRO2C)= +         rk(148)    *y(lXMEO)
          JAC(lXMEO,lRO2X)= +         rk(149)    *y(lXMEO)
          JAC(lXMEO,lMCO3)= +         rk(150)    *y(lXMEO)
          JAC(lXMEO,lRCO3)= +         rk(151)    *y(lXMEO)
          JAC(lXMEO,lBZC3)= +         rk(152)    *y(lXMEO)
          JAC(lXMEO,lMAC3)= +         rk(153)    *y(lXMEO)
          JAC(lXMEO,lXMEO)= +         rk(144)    *y(lNO)
     &                      +         rk(145)    *y(lHO2)
     &                      +         rk(146)    *y(lNO3)
     &                      +         rk(147)    *y(lMEO2)
     &                      +         rk(148)    *y(lRO2C)
     &                      +         rk(149)    *y(lRO2X)
     &                      +         rk(150)    *y(lMCO3)
     &                      +         rk(151)    *y(lRCO3)
     &                      +         rk(152)    *y(lBZC3)
          JAC(lXMEO,lXMEO)=JAC(lXMEO,lXMEO)
     &                      +         rk(153)    *y(lMAC3)
          JAC(lXMEO,lALK4)= +(-0.010)*rk(546)    *y(lOH)
          JAC(lXMEO,lOLE1)= +(-0.001)*rk(548)    *y(lOH)
          JAC(lXMEO,lOLE2)= +(-0.035)*rk(554)    *y(lNO3)
          JAC(lXMC3,lNO  )= +         rk(154)    *y(lXMC3)
          JAC(lXMC3,lO3  )= +(-0.001)*rk(531)    *y(lAPIN)
     &                      +(-0.156)*rk(553)    *y(lOLE2)
     &                      +(-0.202)*rk(559)    *y(lTERP)
     &                      +(-0.202)*rk(563)    *y(lSESQ)
          JAC(lXMC3,lNO3 )= +         rk(156)    *y(lXMC3)
          JAC(lXMC3,lOH  )= +(-1.000)*rk(214)    *y(lACET)
     &                      +(-0.510)*rk(216)    *y(lMEK)
     &                      +(-0.201)*rk(246)    *y(lAFG1)
     &                      +(-0.201)*rk(249)    *y(lAFG2)
     &                      +(-0.117)*rk(252)    *y(lAFG3)
     &                      +(-0.675)*rk(259)    *y(lMVK)
     &                      +(-0.029)*rk(267)    *y(lPRD2)
     &                      +(-0.011)*rk(546)    *y(lALK4)
          JAC(lXMC3,lHO2 )= +         rk(155)    *y(lXMC3)
          JAC(lXMC3,lMEO2)= +         rk(157)    *y(lXMC3)
          JAC(lXMC3,lRO2C)= +         rk(158)    *y(lXMC3)
          JAC(lXMC3,lRO2X)= +         rk(159)    *y(lXMC3)
          JAC(lXMC3,lMCO3)= +         rk(160)    *y(lXMC3)
          JAC(lXMC3,lRCO3)= +         rk(161)    *y(lXMC3)
          JAC(lXMC3,lBZC3)= +         rk(162)    *y(lXMC3)
          JAC(lXMC3,lMAC3)= +         rk(163)    *y(lXMC3)
          JAC(lXMC3,lACET)= +(-1.000)*rk(214)    *y(lOH)
          JAC(lXMC3,lXMC3)= +         rk(154)    *y(lNO)
     &                      +         rk(155)    *y(lHO2)
     &                      +         rk(156)    *y(lNO3)
     &                      +         rk(157)    *y(lMEO2)
     &                      +         rk(158)    *y(lRO2C)
     &                      +         rk(159)    *y(lRO2X)
     &                      +         rk(160)    *y(lMCO3)
     &                      +         rk(161)    *y(lRCO3)
     &                      +         rk(162)    *y(lBZC3)
          JAC(lXMC3,lXMC3)=JAC(lXMC3,lXMC3)
     &                      +         rk(163)    *y(lMAC3)
          JAC(lXMC3,lMEK )= +(-0.510)*rk(216)    *y(lOH)
          JAC(lXMC3,lPRD2)= +(-0.029)*rk(267)    *y(lOH)
          JAC(lXMC3,lAFG1)= +(-0.201)*rk(246)    *y(lOH)
          JAC(lXMC3,lAFG2)= +(-0.201)*rk(249)    *y(lOH)
          JAC(lXMC3,lAFG3)= +(-0.117)*rk(252)    *y(lOH)
          JAC(lXMC3,lMACR)= +(-0.330)*rk(258)*flg
          JAC(lXMC3,lMVK )= +(-0.675)*rk(259)    *y(lOH)
          JAC(lXMC3,lAPIN)= +(-0.001)*rk(531)    *y(lO3)
          JAC(lXMC3,lALK4)= +(-0.011)*rk(546)    *y(lOH)
          JAC(lXMC3,lOLE2)= +(-0.156)*rk(553)    *y(lO3)
          JAC(lXMC3,lTERP)= +(-0.202)*rk(559)    *y(lO3)
          JAC(lXMC3,lSESQ)= +(-0.202)*rk(563)    *y(lO3)
          JAC(lXRC3,lNO  )= +         rk(164)    *y(lXRC3)
          JAC(lXRC3,lO3  )= +(-0.652)*rk(247)    *y(lAFG1)
     &                      +(-0.652)*rk(250)    *y(lAFG2)
     &                      +(-0.163)*rk(253)    *y(lAFG3)
     &                      +(-0.100)*rk(255)    *y(lMACR)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.048)*rk(264)    *y(lIPRD)
     &                      +(-0.297)*rk(531)    *y(lAPIN)
     &                      +(-0.008)*rk(553)    *y(lOLE2)
     &                      +(-0.059)*rk(559)    *y(lTERP)
          JAC(lXRC3,lO3  )=JAC(lXRC3,lO3  )
     &                      +(-0.059)*rk(563)    *y(lSESQ)
          JAC(lXRC3,lNO3 )= +         rk(166)    *y(lXRC3)
     &                      +(-0.007)*rk(532)    *y(lAPIN)
     &                      +(-0.026)*rk(560)    *y(lTERP)
     &                      +(-0.026)*rk(564)    *y(lSESQ)
          JAC(lXRC3,lOH  )= +(-0.074)*rk(216)    *y(lMEK)
     &                      +(-0.049)*rk(267)    *y(lPRD2)
     &                      +(-0.004)*rk(530)    *y(lAPIN)
     &                      +(-0.064)*rk(558)    *y(lTERP)
     &                      +(-0.064)*rk(562)    *y(lSESQ)
          JAC(lXRC3,lHO2 )= +         rk(165)    *y(lXRC3)
          JAC(lXRC3,lMEO2)= +         rk(167)    *y(lXRC3)
          JAC(lXRC3,lRO2C)= +         rk(168)    *y(lXRC3)
          JAC(lXRC3,lRO2X)= +         rk(169)    *y(lXRC3)
          JAC(lXRC3,lMCO3)= +         rk(170)    *y(lXRC3)
          JAC(lXRC3,lRCO3)= +         rk(171)    *y(lXRC3)
          JAC(lXRC3,lBZC3)= +         rk(172)    *y(lXRC3)
          JAC(lXRC3,lMAC3)= +         rk(173)    *y(lXRC3)
          JAC(lXRC3,lXRC3)= +         rk(164)    *y(lNO)
     &                      +         rk(165)    *y(lHO2)
     &                      +         rk(166)    *y(lNO3)
     &                      +         rk(167)    *y(lMEO2)
     &                      +         rk(168)    *y(lRO2C)
     &                      +         rk(169)    *y(lRO2X)
     &                      +         rk(170)    *y(lMCO3)
     &                      +         rk(171)    *y(lRCO3)
     &                      +         rk(172)    *y(lBZC3)
          JAC(lXRC3,lXRC3)=JAC(lXRC3,lXRC3)
     &                      +         rk(173)    *y(lMAC3)
          JAC(lXRC3,lMEK )= +(-0.074)*rk(216)    *y(lOH)
          JAC(lXRC3,lPRD2)= +(-0.049)*rk(267)    *y(lOH)
          JAC(lXRC3,lIPRD)= +(-0.048)*rk(264)    *y(lO3)
          JAC(lXRC3,lAFG1)= +(-0.652)*rk(247)    *y(lO3)
          JAC(lXRC3,lAFG2)= +(-0.652)*rk(250)    *y(lO3)
          JAC(lXRC3,lAFG3)= +(-0.163)*rk(253)    *y(lO3)
          JAC(lXRC3,lMACR)= +(-0.100)*rk(255)    *y(lO3)
          JAC(lXRC3,lMVK )= +(-0.050)*rk(260)    *y(lO3)
          JAC(lXRC3,lAPIN)= +(-0.004)*rk(530)    *y(lOH)
     &                      +(-0.297)*rk(531)    *y(lO3)
     &                      +(-0.007)*rk(532)    *y(lNO3)
          JAC(lXRC3,lOLE2)= +(-0.008)*rk(553)    *y(lO3)
          JAC(lXRC3,lTERP)= +(-0.064)*rk(558)    *y(lOH)
     &                      +(-0.059)*rk(559)    *y(lO3)
     &                      +(-0.026)*rk(560)    *y(lNO3)
          JAC(lXRC3,lSESQ)= +(-0.064)*rk(562)    *y(lOH)
     &                      +(-0.059)*rk(563)    *y(lO3)
     &                      +(-0.026)*rk(564)    *y(lNO3)
          JAC(lXMA3,lNO  )= +         rk(174)    *y(lXMA3)
          JAC(lXMA3,lO3P )= +(-0.118)*rk(525)    *y(lBD13)
     &                      +(-0.240)*rk(529)    *y(lISOP)
          JAC(lXMA3,lO3  )= +(-0.192)*rk(527)    *y(lISOP)
          JAC(lXMA3,lNO3 )= +         rk(176)    *y(lXMA3)
          JAC(lXMA3,lHO2 )= +         rk(175)    *y(lXMA3)
          JAC(lXMA3,lMEO2)= +         rk(177)    *y(lXMA3)
          JAC(lXMA3,lRO2C)= +         rk(178)    *y(lXMA3)
          JAC(lXMA3,lRO2X)= +         rk(179)    *y(lXMA3)
          JAC(lXMA3,lMCO3)= +         rk(180)    *y(lXMA3)
          JAC(lXMA3,lRCO3)= +         rk(181)    *y(lXMA3)
          JAC(lXMA3,lBZC3)= +         rk(182)    *y(lXMA3)
          JAC(lXMA3,lMAC3)= +         rk(183)    *y(lXMA3)
          JAC(lXMA3,lXMA3)= +         rk(174)    *y(lNO)
     &                      +         rk(175)    *y(lHO2)
     &                      +         rk(176)    *y(lNO3)
     &                      +         rk(177)    *y(lMEO2)
     &                      +         rk(178)    *y(lRO2C)
     &                      +         rk(179)    *y(lRO2X)
     &                      +         rk(180)    *y(lMCO3)
     &                      +         rk(181)    *y(lRCO3)
     &                      +         rk(182)    *y(lBZC3)
          JAC(lXMA3,lXMA3)=JAC(lXMA3,lXMA3)
     &                      +         rk(183)    *y(lMAC3)
          JAC(lXMA3,lBD13)= +(-0.118)*rk(525)    *y(lO3P)
          JAC(lXMA3,lISOP)= +(-0.192)*rk(527)    *y(lO3)
     &                      +(-0.240)*rk(529)    *y(lO3P)
          JAC(lXTBU,lNO  )= +         rk(184)    *y(lXTBU)
          JAC(lXTBU,lNO3 )= +         rk(186)    *y(lXTBU)
          JAC(lXTBU,lOH  )= +(-0.236)*rk(545)    *y(lALK3)
          JAC(lXTBU,lHO2 )= +         rk(185)    *y(lXTBU)
          JAC(lXTBU,lMEO2)= +         rk(187)    *y(lXTBU)
          JAC(lXTBU,lRO2C)= +         rk(188)    *y(lXTBU)
          JAC(lXTBU,lRO2X)= +         rk(189)    *y(lXTBU)
          JAC(lXTBU,lMCO3)= +         rk(190)    *y(lXTBU)
          JAC(lXTBU,lRCO3)= +         rk(191)    *y(lXTBU)
          JAC(lXTBU,lBZC3)= +         rk(192)    *y(lXTBU)
          JAC(lXTBU,lMAC3)= +         rk(193)    *y(lXTBU)
          JAC(lXTBU,lXTBU)= +         rk(184)    *y(lNO)
     &                      +         rk(185)    *y(lHO2)
     &                      +         rk(186)    *y(lNO3)
     &                      +         rk(187)    *y(lMEO2)
     &                      +         rk(188)    *y(lRO2C)
     &                      +         rk(189)    *y(lRO2X)
     &                      +         rk(190)    *y(lMCO3)
     &                      +         rk(191)    *y(lRCO3)
     &                      +         rk(192)    *y(lBZC3)
          JAC(lXTBU,lXTBU)=JAC(lXTBU,lXTBU)
     &                      +         rk(193)    *y(lMAC3)
          JAC(lXTBU,lALK3)= +(-0.236)*rk(545)    *y(lOH)
          JAC(lXCO ,lNO  )= +         rk(194)    *y(lXCO)
          JAC(lXCO ,lO3P )= +(-0.278)*rk(517)    *y(lETHE)
     &                      +(-0.115)*rk(525)    *y(lBD13)
          JAC(lXCO ,lO3  )= +(-0.051)*rk(531)    *y(lAPIN)
          JAC(lXCO ,lNO3 )= +         rk(196)    *y(lXCO)
     &                      +(-0.500)*rk(256)    *y(lMACR)
     &                      +(-0.572)*rk(265)    *y(lIPRD)
     &                      +(-0.031)*rk(276)    *y(lACRO)
     &                      +(-0.005)*rk(532)    *y(lAPIN)
     &                      +(-0.012)*rk(560)    *y(lTERP)
     &                      +(-0.012)*rk(564)    *y(lSESQ)
          JAC(lXCO ,lOH  )= +(-0.035)*rk(211)    *y(lRCHO)
     &                      +(-0.334)*rk(246)    *y(lAFG1)
     &                      +(-0.334)*rk(249)    *y(lAFG2)
     &                      +(-0.114)*rk(252)    *y(lAFG3)
     &                      +(-0.416)*rk(254)    *y(lMACR)
     &                      +(-0.336)*rk(263)    *y(lIPRD)
     &                      +(-0.167)*rk(274)    *y(lACRO)
     &                      +(-0.002)*rk(530)    *y(lAPIN)
     &                      +(-0.002)*rk(546)    *y(lALK4)
          JAC(lXCO ,lOH  )=JAC(lXCO ,lOH  )
     &                      +(-0.001)*rk(558)    *y(lTERP)
     &                      +(-0.001)*rk(562)    *y(lSESQ)
          JAC(lXCO ,lHO2 )= +         rk(195)    *y(lXCO)
          JAC(lXCO ,lMEO2)= +         rk(197)    *y(lXCO)
          JAC(lXCO ,lRO2C)= +         rk(198)    *y(lXCO)
          JAC(lXCO ,lRO2X)= +         rk(199)    *y(lXCO)
          JAC(lXCO ,lMCO3)= +         rk(200)    *y(lXCO)
          JAC(lXCO ,lRCO3)= +         rk(201)    *y(lXCO)
          JAC(lXCO ,lBZC3)= +         rk(202)    *y(lXCO)
          JAC(lXCO ,lMAC3)= +         rk(203)    *y(lXCO)
          JAC(lXCO ,lXCO )= +         rk(194)    *y(lNO)
     &                      +         rk(195)    *y(lHO2)
     &                      +         rk(196)    *y(lNO3)
     &                      +         rk(197)    *y(lMEO2)
     &                      +         rk(198)    *y(lRO2C)
     &                      +         rk(199)    *y(lRO2X)
     &                      +         rk(200)    *y(lMCO3)
     &                      +         rk(201)    *y(lRCO3)
     &                      +         rk(202)    *y(lBZC3)
          JAC(lXCO ,lXCO )=JAC(lXCO ,lXCO )
     &                      +         rk(203)    *y(lMAC3)
          JAC(lXCO ,lRCHO)= +(-0.035)*rk(211)    *y(lOH)
          JAC(lXCO ,lIPRD)= +(-0.336)*rk(263)    *y(lOH)
     &                      +(-0.572)*rk(265)    *y(lNO3)
          JAC(lXCO ,lAFG1)= +(-0.334)*rk(246)    *y(lOH)
          JAC(lXCO ,lAFG2)= +(-0.334)*rk(249)    *y(lOH)
          JAC(lXCO ,lAFG3)= +(-0.114)*rk(252)    *y(lOH)
          JAC(lXCO ,lMACR)= +(-0.416)*rk(254)    *y(lOH)
     &                      +(-0.500)*rk(256)    *y(lNO3)
          JAC(lXCO ,lACRO)= +(-0.167)*rk(274)    *y(lOH)
     &                      +(-0.031)*rk(276)    *y(lNO3)
          JAC(lXCO ,lETHE)= +(-0.278)*rk(517)    *y(lO3P)
          JAC(lXCO ,lBD13)= +(-0.115)*rk(525)    *y(lO3P)
          JAC(lXCO ,lAPIN)= +(-0.002)*rk(530)    *y(lOH)
     &                      +(-0.051)*rk(531)    *y(lO3)
     &                      +(-0.005)*rk(532)    *y(lNO3)
          JAC(lXCO ,lALK4)= +(-0.002)*rk(546)    *y(lOH)
          JAC(lXCO ,lTERP)= +(-0.001)*rk(558)    *y(lOH)
     &                      +(-0.012)*rk(560)    *y(lNO3)
          JAC(lXCO ,lSESQ)= +(-0.001)*rk(562)    *y(lOH)
     &                      +(-0.012)*rk(564)    *y(lNO3)
          JAC(lCCHO,lNO  )= +(-1.000)*rk(293)    *y(lXCCH)
          JAC(lCCHO,lO3P )= +(-0.100)*rk(517)    *y(lETHE)
          JAC(lCCHO,lO3  )= +(-0.500)*rk(519)    *y(lPRPE)
     &                      +(-0.453)*rk(553)    *y(lOLE2)
          JAC(lCCHO,lNO3 )= +         rk(210)    *y(lCCHO)
     &                      +(-1.000)*rk(295)    *y(lXCCH)
          JAC(lCCHO,lOH  )= +         rk(208)    *y(lCCHO)
     &                      +(-0.001)*rk(267)    *y(lPRD2)
     &                      +(-0.950)*rk(542)    *y(lETOH)
          JAC(lCCHO,lMEO2)= +(-0.500)*rk(296)    *y(lXCCH)
          JAC(lCCHO,lRO2C)= +(-0.500)*rk(297)    *y(lXCCH)
          JAC(lCCHO,lRO2X)= +(-0.500)*rk(298)    *y(lXCCH)
          JAC(lCCHO,lMCO3)= +(-1.000)*rk(299)    *y(lXCCH)
          JAC(lCCHO,lRCO3)= +(-1.000)*rk(300)    *y(lXCCH)
          JAC(lCCHO,lXCCH)= +(-1.000)*rk(293)    *y(lNO)
     &                      +(-1.000)*rk(295)    *y(lNO3)
     &                      +(-0.500)*rk(296)    *y(lMEO2)
     &                      +(-0.500)*rk(297)    *y(lRO2C)
     &                      +(-0.500)*rk(298)    *y(lRO2X)
     &                      +(-1.000)*rk(299)    *y(lMCO3)
     &                      +(-1.000)*rk(300)    *y(lRCO3)
     &                      +(-1.000)*rk(301)    *y(lBZC3)
     &                      +(-1.000)*rk(302)    *y(lMAC3)
          JAC(lCCHO,lBZC3)= +(-1.000)*rk(301)    *y(lXCCH)
          JAC(lCCHO,lMAC3)= +(-1.000)*rk(302)    *y(lXCCH)
          JAC(lCCHO,lRNO3)= +(-0.214)*rk(270)*flg
          JAC(lCCHO,lCCHO)= +         rk(208)    *y(lOH)
     &                      +         rk(209)*flg
     &                      +         rk(210)    *y(lNO3)
          JAC(lCCHO,lPRD2)= +(-0.001)*rk(267)    *y(lOH)
          JAC(lCCHO,lETHE)= +(-0.100)*rk(517)    *y(lO3P)
          JAC(lCCHO,lPRPE)= +(-0.500)*rk(519)    *y(lO3)
          JAC(lCCHO,lETOH)= +(-0.950)*rk(542)    *y(lOH)
          JAC(lCCHO,lOLE2)= +(-0.453)*rk(553)    *y(lO3)
          JAC(lRCHO,lNO  )= +(-1.000)*rk(303)    *y(lXRCH)
          JAC(lRCHO,lO3P )= +(-1.000)*rk(257)    *y(lMACR)
     &                      +(-0.450)*rk(261)    *y(lMVK)
     &                      +(-1.000)*rk(277)    *y(lACRO)
     &                      +(-0.450)*rk(521)    *y(lPRPE)
     &                      +(-0.450)*rk(551)    *y(lOLE1)
     &                      +(-0.079)*rk(555)    *y(lOLE2)
     &                      +(-0.237)*rk(561)    *y(lTERP)
     &                      +(-0.237)*rk(565)    *y(lSESQ)
          JAC(lRCHO,lO3  )= +(-0.500)*rk(549)    *y(lOLE1)
     &                      +(-0.333)*rk(553)    *y(lOLE2)
          JAC(lRCHO,lNO3 )= +         rk(213)    *y(lRCHO)
     &                      +(-1.000)*rk(305)    *y(lXRCH)
          JAC(lRCHO,lOH  )= +         rk(211)    *y(lRCHO)
     &                      +(-0.744)*rk(224)    *y(lROOH)
     &                      +(-0.143)*rk(267)    *y(lPRD2)
     &                      +(-0.001)*rk(269)    *y(lRNO3)
          JAC(lRCHO,lMEO2)= +(-0.500)*rk(306)    *y(lXRCH)
          JAC(lRCHO,lRO2C)= +(-0.500)*rk(307)    *y(lXRCH)
          JAC(lRCHO,lRO2X)= +(-0.500)*rk(308)    *y(lXRCH)
          JAC(lRCHO,lMCO3)= +(-1.000)*rk(309)    *y(lXRCH)
          JAC(lRCHO,lRCO3)= +(-1.000)*rk(310)    *y(lXRCH)
          JAC(lRCHO,lBZC3)= +(-1.000)*rk(311)    *y(lXRCH)
          JAC(lRCHO,lMAC3)= +(-1.000)*rk(312)    *y(lXRCH)
          JAC(lRCHO,lRNO3)= +(-0.001)*rk(269)    *y(lOH)
     &                      +(-0.074)*rk(270)*flg
          JAC(lRCHO,lRCHO)= +         rk(211)    *y(lOH)
     &                      +         rk(212)*flg
     &                      +         rk(213)    *y(lNO3)
          JAC(lRCHO,lXRCH)= +(-1.000)*rk(303)    *y(lNO)
     &                      +(-1.000)*rk(305)    *y(lNO3)
     &                      +(-0.500)*rk(306)    *y(lMEO2)
     &                      +(-0.500)*rk(307)    *y(lRO2C)
     &                      +(-0.500)*rk(308)    *y(lRO2X)
     &                      +(-1.000)*rk(309)    *y(lMCO3)
     &                      +(-1.000)*rk(310)    *y(lRCO3)
     &                      +(-1.000)*rk(311)    *y(lBZC3)
     &                      +(-1.000)*rk(312)    *y(lMAC3)
          JAC(lRCHO,lROOH)= +(-0.744)*rk(224)    *y(lOH)
     &                      +(-1.000)*rk(225)*flg
          JAC(lRCHO,lR6PX)= +(-0.085)*rk(227)*flg
          JAC(lRCHO,lPRD2)= +(-0.143)*rk(267)    *y(lOH)
          JAC(lRCHO,lMACR)= +(-1.000)*rk(257)    *y(lO3P)
          JAC(lRCHO,lMVK )= +(-0.450)*rk(261)    *y(lO3P)
          JAC(lRCHO,lACRO)= +(-1.000)*rk(277)    *y(lO3P)
          JAC(lRCHO,lPRPE)= +(-0.450)*rk(521)    *y(lO3P)
          JAC(lRCHO,lOLE1)= +(-0.500)*rk(549)    *y(lO3)
     &                      +(-0.450)*rk(551)    *y(lO3P)
          JAC(lRCHO,lOLE2)= +(-0.333)*rk(553)    *y(lO3)
     &                      +(-0.079)*rk(555)    *y(lO3P)
          JAC(lRCHO,lTERP)= +(-0.237)*rk(561)    *y(lO3P)
          JAC(lRCHO,lSESQ)= +(-0.237)*rk(565)    *y(lO3P)
          JAC(lXHCH,lNO  )= +         rk(283)    *y(lXHCH)
          JAC(lXHCH,lO3P )= +(-0.278)*rk(517)    *y(lETHE)
     &                      +(-0.240)*rk(529)    *y(lISOP)
          JAC(lXHCH,lO3  )= +(-0.652)*rk(247)    *y(lAFG1)
     &                      +(-0.652)*rk(250)    *y(lAFG2)
     &                      +(-0.163)*rk(253)    *y(lAFG3)
     &                      +(-0.100)*rk(255)    *y(lMACR)
     &                      +(-0.050)*rk(260)    *y(lMVK)
     &                      +(-0.001)*rk(264)    *y(lIPRD)
     &                      +(-0.192)*rk(527)    *y(lISOP)
     &                      +(-0.344)*rk(531)    *y(lAPIN)
     &                      +(-0.114)*rk(553)    *y(lOLE2)
          JAC(lXHCH,lO3  )=JAC(lXHCH,lO3  )
     &                      +(-0.033)*rk(559)    *y(lTERP)
     &                      +(-0.033)*rk(563)    *y(lSESQ)
          JAC(lXHCH,lNO3 )= +(-0.227)*rk(265)    *y(lIPRD)
     &                      +         rk(285)    *y(lXHCH)
     &                      +(-0.115)*rk(524)    *y(lBD13)
     &                      +(-0.007)*rk(532)    *y(lAPIN)
     &                      +(-0.072)*rk(554)    *y(lOLE2)
     &                      +(-0.023)*rk(560)    *y(lTERP)
     &                      +(-0.023)*rk(564)    *y(lSESQ)
          JAC(lXHCH,lOH  )= +(-1.000)*rk(214)    *y(lACET)
     &                      +(-0.088)*rk(216)    *y(lMEK)
     &                      +(-0.012)*rk(224)    *y(lROOH)
     &                      +(-0.084)*rk(254)    *y(lMACR)
     &                      +(-0.300)*rk(259)    *y(lMVK)
     &                      +(-0.055)*rk(263)    *y(lIPRD)
     &                      +(-0.211)*rk(267)    *y(lPRD2)
     &                      +(-0.011)*rk(269)    *y(lRNO3)
     &                      +(-0.083)*rk(274)    *y(lACRO)
          JAC(lXHCH,lOH  )=JAC(lXHCH,lOH  )
     &                      +(-0.020)*rk(279)    *y(lCO3H)
     &                      +(-1.610)*rk(514)    *y(lETHE)
     &                      +(-0.984)*rk(518)    *y(lPRPE)
     &                      +(-0.708)*rk(522)    *y(lBD13)
     &                      +(-0.624)*rk(526)    *y(lISOP)
     &                      +(-0.022)*rk(530)    *y(lAPIN)
     &                      +(-0.081)*rk(542)    *y(lETOH)
     &                      +(-0.026)*rk(545)    *y(lALK3)
          JAC(lXHCH,lOH  )=JAC(lXHCH,lOH  )
     &                      +(-0.029)*rk(546)    *y(lALK4)
     &                      +(-0.040)*rk(547)    *y(lALK5)
     &                      +(-0.582)*rk(548)    *y(lOLE1)
     &                      +(-0.179)*rk(552)    *y(lOLE2)
     &                      +(-0.411)*rk(558)    *y(lTERP)
     &                      +(-0.411)*rk(562)    *y(lSESQ)
          JAC(lXHCH,lHO2 )= +         rk(284)    *y(lXHCH)
          JAC(lXHCH,lMEO2)= +         rk(286)    *y(lXHCH)
          JAC(lXHCH,lRO2C)= +         rk(287)    *y(lXHCH)
          JAC(lXHCH,lRO2X)= +         rk(288)    *y(lXHCH)
          JAC(lXHCH,lMCO3)= +         rk(289)    *y(lXHCH)
          JAC(lXHCH,lCO3H)= +(-0.020)*rk(279)    *y(lOH)
          JAC(lXHCH,lRCO3)= +         rk(290)    *y(lXHCH)
          JAC(lXHCH,lBZC3)= +         rk(291)    *y(lXHCH)
          JAC(lXHCH,lMAC3)= +         rk(292)    *y(lXHCH)
          JAC(lXHCH,lRNO3)= +(-0.011)*rk(269)    *y(lOH)
     &                      +(-0.061)*rk(270)*flg
          JAC(lXHCH,lACET)= +(-1.000)*rk(214)    *y(lOH)
          JAC(lXHCH,lXHCH)= +         rk(283)    *y(lNO)
     &                      +         rk(284)    *y(lHO2)
     &                      +         rk(285)    *y(lNO3)
     &                      +         rk(286)    *y(lMEO2)
     &                      +         rk(287)    *y(lRO2C)
     &                      +         rk(288)    *y(lRO2X)
     &                      +         rk(289)    *y(lMCO3)
     &                      +         rk(290)    *y(lRCO3)
     &                      +         rk(291)    *y(lBZC3)
          JAC(lXHCH,lXHCH)=JAC(lXHCH,lXHCH)
     &                      +         rk(292)    *y(lMAC3)
          JAC(lXHCH,lMEK )= +(-0.088)*rk(216)    *y(lOH)
          JAC(lXHCH,lROOH)= +(-0.012)*rk(224)    *y(lOH)
          JAC(lXHCH,lPRD2)= +(-0.211)*rk(267)    *y(lOH)
     &                      +(-0.303)*rk(268)*flg
          JAC(lXHCH,lIPRD)= +(-0.055)*rk(263)    *y(lOH)
     &                      +(-0.001)*rk(264)    *y(lO3)
     &                      +(-0.227)*rk(265)    *y(lNO3)
          JAC(lXHCH,lAFG1)= +(-0.652)*rk(247)    *y(lO3)
          JAC(lXHCH,lAFG2)= +(-0.652)*rk(250)    *y(lO3)
          JAC(lXHCH,lAFG3)= +(-0.163)*rk(253)    *y(lO3)
          JAC(lXHCH,lMACR)= +(-0.084)*rk(254)    *y(lOH)
     &                      +(-0.100)*rk(255)    *y(lO3)
     &                      +(-0.330)*rk(258)*flg
          JAC(lXHCH,lMVK )= +(-0.300)*rk(259)    *y(lOH)
     &                      +(-0.050)*rk(260)    *y(lO3)
          JAC(lXHCH,lACRO)= +(-0.083)*rk(274)    *y(lOH)
          JAC(lXHCH,lETHE)= +(-1.610)*rk(514)    *y(lOH)
     &                      +(-0.278)*rk(517)    *y(lO3P)
          JAC(lXHCH,lPRPE)= +(-0.984)*rk(518)    *y(lOH)
          JAC(lXHCH,lBD13)= +(-0.708)*rk(522)    *y(lOH)
     &                      +(-0.115)*rk(524)    *y(lNO3)
          JAC(lXHCH,lISOP)= +(-0.624)*rk(526)    *y(lOH)
     &                      +(-0.192)*rk(527)    *y(lO3)
     &                      +(-0.240)*rk(529)    *y(lO3P)
          JAC(lXHCH,lAPIN)= +(-0.022)*rk(530)    *y(lOH)
     &                      +(-0.344)*rk(531)    *y(lO3)
     &                      +(-0.007)*rk(532)    *y(lNO3)
          JAC(lXHCH,lETOH)= +(-0.081)*rk(542)    *y(lOH)
          JAC(lXHCH,lALK3)= +(-0.026)*rk(545)    *y(lOH)
          JAC(lXHCH,lALK4)= +(-0.029)*rk(546)    *y(lOH)
          JAC(lXHCH,lALK5)= +(-0.040)*rk(547)    *y(lOH)
          JAC(lXHCH,lOLE1)= +(-0.582)*rk(548)    *y(lOH)
          JAC(lXHCH,lOLE2)= +(-0.179)*rk(552)    *y(lOH)
     &                      +(-0.114)*rk(553)    *y(lO3)
     &                      +(-0.072)*rk(554)    *y(lNO3)
          JAC(lXHCH,lTERP)= +(-0.411)*rk(558)    *y(lOH)
     &                      +(-0.033)*rk(559)    *y(lO3)
     &                      +(-0.023)*rk(560)    *y(lNO3)
          JAC(lXHCH,lSESQ)= +(-0.411)*rk(562)    *y(lOH)
     &                      +(-0.033)*rk(563)    *y(lO3)
     &                      +(-0.023)*rk(564)    *y(lNO3)
          JAC(lMEK ,lNO  )= +(-1.000)*rk(323)    *y(lXMEK)
          JAC(lMEK ,lO3P )= +(-0.550)*rk(261)    *y(lMVK)
     &                      +(-0.550)*rk(521)    *y(lPRPE)
     &                      +(-0.390)*rk(551)    *y(lOLE1)
     &                      +(-0.751)*rk(555)    *y(lOLE2)
          JAC(lMEK ,lO3  )= +(-0.210)*rk(264)    *y(lIPRD)
     &                      +(-0.008)*rk(531)    *y(lAPIN)
     &                      +(-0.009)*rk(549)    *y(lOLE1)
     &                      +(-0.033)*rk(553)    *y(lOLE2)
     &                      +(-0.002)*rk(559)    *y(lTERP)
     &                      +(-0.002)*rk(563)    *y(lSESQ)
          JAC(lMEK ,lNO3 )= +(-1.000)*rk(325)    *y(lXMEK)
          JAC(lMEK ,lOH  )= +         rk(216)    *y(lMEK)
     &                      +(-0.010)*rk(269)    *y(lRNO3)
          JAC(lMEK ,lMEO2)= +(-0.500)*rk(326)    *y(lXMEK)
     &                      +(-0.500)*rk(456)    *y(lYRPX)
          JAC(lMEK ,lRO2C)= +(-0.500)*rk(327)    *y(lXMEK)
     &                      +(-0.500)*rk(457)    *y(lYRPX)
          JAC(lMEK ,lRO2X)= +(-0.500)*rk(328)    *y(lXMEK)
     &                      +(-0.500)*rk(458)    *y(lYRPX)
          JAC(lMEK ,lMCO3)= +(-1.000)*rk(329)    *y(lXMEK)
          JAC(lMEK ,lRCO3)= +(-1.000)*rk(330)    *y(lXMEK)
          JAC(lMEK ,lYRPX)= +(-0.500)*rk(456)    *y(lMEO2)
     &                      +(-0.500)*rk(457)    *y(lRO2C)
     &                      +(-0.500)*rk(458)    *y(lRO2X)
          JAC(lMEK ,lBZC3)= +(-1.000)*rk(331)    *y(lXMEK)
          JAC(lMEK ,lMAC3)= +(-1.000)*rk(332)    *y(lXMEK)
          JAC(lMEK ,lRNO3)= +(-0.010)*rk(269)    *y(lOH)
     &                      +(-0.124)*rk(270)*flg
          JAC(lMEK ,lMEK )= +         rk(216)    *y(lOH)
     &                      +         rk(217)*flg
          JAC(lMEK ,lIPRD)= +(-0.210)*rk(264)    *y(lO3)
     &                      +(-0.233)*rk(266)*flg
          JAC(lMEK ,lXMEK)= +(-1.000)*rk(323)    *y(lNO)
     &                      +(-1.000)*rk(325)    *y(lNO3)
     &                      +(-0.500)*rk(326)    *y(lMEO2)
     &                      +(-0.500)*rk(327)    *y(lRO2C)
     &                      +(-0.500)*rk(328)    *y(lRO2X)
     &                      +(-1.000)*rk(329)    *y(lMCO3)
     &                      +(-1.000)*rk(330)    *y(lRCO3)
     &                      +(-1.000)*rk(331)    *y(lBZC3)
     &                      +(-1.000)*rk(332)    *y(lMAC3)
          JAC(lMEK ,lMVK )= +(-0.550)*rk(261)    *y(lO3P)
          JAC(lMEK ,lPRPE)= +(-0.550)*rk(521)    *y(lO3P)
          JAC(lMEK ,lAPIN)= +(-0.008)*rk(531)    *y(lO3)
          JAC(lMEK ,lOLE1)= +(-0.009)*rk(549)    *y(lO3)
     &                      +(-0.390)*rk(551)    *y(lO3P)
          JAC(lMEK ,lOLE2)= +(-0.033)*rk(553)    *y(lO3)
     &                      +(-0.751)*rk(555)    *y(lO3P)
          JAC(lMEK ,lTERP)= +(-0.002)*rk(559)    *y(lO3)
          JAC(lMEK ,lSESQ)= +(-0.002)*rk(563)    *y(lO3)
          JAC(lZRN3,lNO  )= +         rk(483)    *y(lZRN3)
          JAC(lZRN3,lO3P )= +(-0.015)*rk(525)    *y(lBD13)
     &                      +(-0.010)*rk(529)    *y(lISOP)
          JAC(lZRN3,lO3  )= +(-0.007)*rk(253)    *y(lAFG3)
     &                      +(-0.008)*rk(527)    *y(lISOP)
     &                      +(-0.337)*rk(531)    *y(lAPIN)
     &                      +(-0.005)*rk(549)    *y(lOLE1)
     &                      +(-0.003)*rk(553)    *y(lOLE2)
     &                      +(-0.121)*rk(559)    *y(lTERP)
     &                      +(-0.121)*rk(563)    *y(lSESQ)
          JAC(lZRN3,lNO3 )= +(-0.051)*rk(265)    *y(lIPRD)
     &                      +(-0.002)*rk(276)    *y(lACRO)
     &                      +         rk(485)    *y(lZRN3)
     &                      +(-0.051)*rk(520)    *y(lPRPE)
     &                      +(-0.065)*rk(524)    *y(lBD13)
     &                      +(-0.064)*rk(528)    *y(lISOP)
     &                      +(-0.293)*rk(532)    *y(lAPIN)
     &                      +(-0.228)*rk(550)    *y(lOLE1)
     &                      +(-0.140)*rk(554)    *y(lOLE2)
          JAC(lZRN3,lNO3 )=JAC(lZRN3,lNO3 )
     &                      +(-0.460)*rk(560)    *y(lTERP)
     &                      +(-0.460)*rk(564)    *y(lSESQ)
          JAC(lZRN3,lOH  )= +(-0.039)*rk(216)    *y(lMEK)
     &                      +(-0.004)*rk(224)    *y(lROOH)
     &                      +(-0.029)*rk(226)    *y(lR6PX)
     &                      +(-0.124)*rk(228)    *y(lRAPX)
     &                      +(-0.060)*rk(246)    *y(lAFG1)
     &                      +(-0.060)*rk(249)    *y(lAFG2)
     &                      +(-0.117)*rk(252)    *y(lAFG3)
     &                      +(-0.025)*rk(259)    *y(lMVK)
     &                      +(-0.041)*rk(263)    *y(lIPRD)
          JAC(lZRN3,lOH  )=JAC(lZRN3,lOH  )
     &                      +(-0.071)*rk(267)    *y(lPRD2)
     &                      +(-0.175)*rk(269)    *y(lRNO3)
     &                      +(-0.016)*rk(518)    *y(lPRPE)
     &                      +(-0.049)*rk(522)    *y(lBD13)
     &                      +(-0.093)*rk(526)    *y(lISOP)
     &                      +(-0.197)*rk(530)    *y(lAPIN)
     &                      +(-0.024)*rk(536)    *y(lBENZ)
     &                      +(-0.054)*rk(537)    *y(lTOLU)
          JAC(lZRN3,lOH  )=JAC(lZRN3,lOH  )
     &                      +(-0.082)*rk(538)    *y(lMXYL)
     &                      +(-0.087)*rk(539)    *y(lOXYL)
     &                      +(-0.076)*rk(540)    *y(lPXYL)
     &                      +(-0.121)*rk(541)    *y(lB124)
     &                      +(-0.035)*rk(544)    *y(lALK2)
     &                      +(-0.070)*rk(545)    *y(lALK3)
     &                      +(-0.149)*rk(546)    *y(lALK4)
     &                      +(-0.353)*rk(547)    *y(lALK5)
          JAC(lZRN3,lOH  )=JAC(lZRN3,lOH  )
     &                      +(-0.128)*rk(548)    *y(lOLE1)
     &                      +(-0.088)*rk(552)    *y(lOLE2)
     &                      +(-0.110)*rk(556)    *y(lARO1)
     &                      +(-0.128)*rk(557)    *y(lARO2)
     &                      +(-0.201)*rk(558)    *y(lTERP)
     &                      +(-0.201)*rk(562)    *y(lSESQ)
          JAC(lZRN3,lHO2 )= +         rk(484)    *y(lZRN3)
          JAC(lZRN3,lMEO2)= +         rk(486)    *y(lZRN3)
          JAC(lZRN3,lRO2C)= +         rk(487)    *y(lZRN3)
          JAC(lZRN3,lRO2X)= +         rk(488)    *y(lZRN3)
          JAC(lZRN3,lMCO3)= +         rk(489)    *y(lZRN3)
          JAC(lZRN3,lRCO3)= +         rk(490)    *y(lZRN3)
          JAC(lZRN3,lBZC3)= +         rk(491)    *y(lZRN3)
          JAC(lZRN3,lMAC3)= +         rk(492)    *y(lZRN3)
          JAC(lZRN3,lRNO3)= +(-0.175)*rk(269)    *y(lOH)
     &                      +(-0.102)*rk(270)*flg
          JAC(lZRN3,lMEK )= +(-0.039)*rk(216)    *y(lOH)
          JAC(lZRN3,lZRN3)= +         rk(483)    *y(lNO)
     &                      +         rk(484)    *y(lHO2)
     &                      +         rk(485)    *y(lNO3)
     &                      +         rk(486)    *y(lMEO2)
     &                      +         rk(487)    *y(lRO2C)
     &                      +         rk(488)    *y(lRO2X)
     &                      +         rk(489)    *y(lMCO3)
     &                      +         rk(490)    *y(lRCO3)
     &                      +         rk(491)    *y(lBZC3)
          JAC(lZRN3,lZRN3)=JAC(lZRN3,lZRN3)
     &                      +         rk(492)    *y(lMAC3)
          JAC(lZRN3,lROOH)= +(-0.004)*rk(224)    *y(lOH)
          JAC(lZRN3,lR6PX)= +(-0.029)*rk(226)    *y(lOH)
     &                      +(-0.077)*rk(227)*flg
          JAC(lZRN3,lPRD2)= +(-0.071)*rk(267)    *y(lOH)
     &                      +(-0.087)*rk(268)*flg
          JAC(lZRN3,lRAPX)= +(-0.124)*rk(228)    *y(lOH)
          JAC(lZRN3,lIPRD)= +(-0.041)*rk(263)    *y(lOH)
     &                      +(-0.051)*rk(265)    *y(lNO3)
          JAC(lZRN3,lAFG1)= +(-0.060)*rk(246)    *y(lOH)
          JAC(lZRN3,lAFG2)= +(-0.060)*rk(249)    *y(lOH)
          JAC(lZRN3,lAFG3)= +(-0.117)*rk(252)    *y(lOH)
     &                      +(-0.007)*rk(253)    *y(lO3)
          JAC(lZRN3,lMVK )= +(-0.025)*rk(259)    *y(lOH)
          JAC(lZRN3,lACRO)= +(-0.002)*rk(276)    *y(lNO3)
          JAC(lZRN3,lPRPE)= +(-0.016)*rk(518)    *y(lOH)
     &                      +(-0.051)*rk(520)    *y(lNO3)
          JAC(lZRN3,lBD13)= +(-0.049)*rk(522)    *y(lOH)
     &                      +(-0.065)*rk(524)    *y(lNO3)
     &                      +(-0.015)*rk(525)    *y(lO3P)
          JAC(lZRN3,lISOP)= +(-0.093)*rk(526)    *y(lOH)
     &                      +(-0.008)*rk(527)    *y(lO3)
     &                      +(-0.064)*rk(528)    *y(lNO3)
     &                      +(-0.010)*rk(529)    *y(lO3P)
          JAC(lZRN3,lAPIN)= +(-0.197)*rk(530)    *y(lOH)
     &                      +(-0.337)*rk(531)    *y(lO3)
     &                      +(-0.293)*rk(532)    *y(lNO3)
          JAC(lZRN3,lBENZ)= +(-0.024)*rk(536)    *y(lOH)
          JAC(lZRN3,lTOLU)= +(-0.054)*rk(537)    *y(lOH)
          JAC(lZRN3,lMXYL)= +(-0.082)*rk(538)    *y(lOH)
          JAC(lZRN3,lOXYL)= +(-0.087)*rk(539)    *y(lOH)
          JAC(lZRN3,lPXYL)= +(-0.076)*rk(540)    *y(lOH)
          JAC(lZRN3,lB124)= +(-0.121)*rk(541)    *y(lOH)
          JAC(lZRN3,lALK2)= +(-0.035)*rk(544)    *y(lOH)
          JAC(lZRN3,lALK3)= +(-0.070)*rk(545)    *y(lOH)
          JAC(lZRN3,lALK4)= +(-0.149)*rk(546)    *y(lOH)
          JAC(lZRN3,lALK5)= +(-0.353)*rk(547)    *y(lOH)
          JAC(lZRN3,lOLE1)= +(-0.128)*rk(548)    *y(lOH)
     &                      +(-0.005)*rk(549)    *y(lO3)
     &                      +(-0.228)*rk(550)    *y(lNO3)
          JAC(lZRN3,lOLE2)= +(-0.088)*rk(552)    *y(lOH)
     &                      +(-0.003)*rk(553)    *y(lO3)
     &                      +(-0.140)*rk(554)    *y(lNO3)
          JAC(lZRN3,lARO1)= +(-0.110)*rk(556)    *y(lOH)
          JAC(lZRN3,lARO2)= +(-0.128)*rk(557)    *y(lOH)
          JAC(lZRN3,lTERP)= +(-0.201)*rk(558)    *y(lOH)
     &                      +(-0.121)*rk(559)    *y(lO3)
     &                      +(-0.460)*rk(560)    *y(lNO3)
          JAC(lZRN3,lSESQ)= +(-0.201)*rk(562)    *y(lOH)
     &                      +(-0.121)*rk(563)    *y(lO3)
     &                      +(-0.460)*rk(564)    *y(lNO3)
          JAC(lXRCH,lNO  )= +         rk(303)    *y(lXRCH)
          JAC(lXRCH,lO3  )= +(-0.240)*rk(531)    *y(lAPIN)
     &                      +(-0.044)*rk(549)    *y(lOLE1)
     &                      +(-0.019)*rk(553)    *y(lOLE2)
     &                      +(-0.208)*rk(559)    *y(lTERP)
     &                      +(-0.208)*rk(563)    *y(lSESQ)
          JAC(lXRCH,lNO3 )= +(-0.218)*rk(265)    *y(lIPRD)
     &                      +         rk(305)    *y(lXRCH)
     &                      +(-1.000)*rk(516)    *y(lETHE)
     &                      +(-0.684)*rk(532)    *y(lAPIN)
     &                      +(-0.003)*rk(550)    *y(lOLE1)
     &                      +(-0.163)*rk(554)    *y(lOLE2)
     &                      +(-0.403)*rk(560)    *y(lTERP)
     &                      +(-0.403)*rk(564)    *y(lSESQ)
          JAC(lXRCH,lOH  )= +(-0.376)*rk(216)    *y(lMEK)
     &                      +(-0.400)*rk(221)    *y(lPACD)
     &                      +(-0.205)*rk(224)    *y(lROOH)
     &                      +(-0.075)*rk(226)    *y(lR6PX)
     &                      +(-0.448)*rk(228)    *y(lRAPX)
     &                      +(-0.407)*rk(246)    *y(lAFG1)
     &                      +(-0.407)*rk(249)    *y(lAFG2)
     &                      +(-0.013)*rk(263)    *y(lIPRD)
     &                      +(-0.402)*rk(267)    *y(lPRD2)
          JAC(lXRCH,lOH  )=JAC(lXRCH,lOH  )
     &                      +(-0.036)*rk(269)    *y(lRNO3)
     &                      +(-0.084)*rk(281)    *y(lRO3H)
     &                      +(-0.776)*rk(530)    *y(lAPIN)
     &                      +(-0.261)*rk(544)    *y(lALK2)
     &                      +(-0.122)*rk(545)    *y(lALK3)
     &                      +(-0.236)*rk(546)    *y(lALK4)
     &                      +(-0.209)*rk(547)    *y(lALK5)
     &                      +(-0.666)*rk(548)    *y(lOLE1)
          JAC(lXRCH,lOH  )=JAC(lXRCH,lOH  )
     &                      +(-0.510)*rk(552)    *y(lOLE2)
     &                      +(-0.385)*rk(558)    *y(lTERP)
     &                      +(-0.385)*rk(562)    *y(lSESQ)
          JAC(lXRCH,lHO2 )= +         rk(304)    *y(lXRCH)
          JAC(lXRCH,lMEO2)= +         rk(306)    *y(lXRCH)
          JAC(lXRCH,lRO2C)= +         rk(307)    *y(lXRCH)
          JAC(lXRCH,lRO2X)= +         rk(308)    *y(lXRCH)
          JAC(lXRCH,lMCO3)= +         rk(309)    *y(lXRCH)
          JAC(lXRCH,lRCO3)= +         rk(310)    *y(lXRCH)
          JAC(lXRCH,lRO3H)= +(-0.084)*rk(281)    *y(lOH)
          JAC(lXRCH,lPACD)= +(-0.400)*rk(221)    *y(lOH)
          JAC(lXRCH,lBZC3)= +         rk(311)    *y(lXRCH)
          JAC(lXRCH,lMAC3)= +         rk(312)    *y(lXRCH)
          JAC(lXRCH,lRNO3)= +(-0.036)*rk(269)    *y(lOH)
     &                      +(-0.063)*rk(270)*flg
          JAC(lXRCH,lMEK )= +(-0.376)*rk(216)    *y(lOH)
          JAC(lXRCH,lXRCH)= +         rk(303)    *y(lNO)
     &                      +         rk(304)    *y(lHO2)
     &                      +         rk(305)    *y(lNO3)
     &                      +         rk(306)    *y(lMEO2)
     &                      +         rk(307)    *y(lRO2C)
     &                      +         rk(308)    *y(lRO2X)
     &                      +         rk(309)    *y(lMCO3)
     &                      +         rk(310)    *y(lRCO3)
     &                      +         rk(311)    *y(lBZC3)
          JAC(lXRCH,lXRCH)=JAC(lXRCH,lXRCH)
     &                      +         rk(312)    *y(lMAC3)
          JAC(lXRCH,lROOH)= +(-0.205)*rk(224)    *y(lOH)
          JAC(lXRCH,lR6PX)= +(-0.075)*rk(226)    *y(lOH)
     &                      +(-0.058)*rk(227)*flg
          JAC(lXRCH,lPRD2)= +(-0.402)*rk(267)    *y(lOH)
     &                      +(-0.780)*rk(268)*flg
          JAC(lXRCH,lRAPX)= +(-0.448)*rk(228)    *y(lOH)
          JAC(lXRCH,lIPRD)= +(-0.013)*rk(263)    *y(lOH)
     &                      +(-0.218)*rk(265)    *y(lNO3)
          JAC(lXRCH,lAFG1)= +(-0.407)*rk(246)    *y(lOH)
          JAC(lXRCH,lAFG2)= +(-0.407)*rk(249)    *y(lOH)
          JAC(lXRCH,lETHE)= +(-1.000)*rk(516)    *y(lNO3)
          JAC(lXRCH,lAPIN)= +(-0.776)*rk(530)    *y(lOH)
     &                      +(-0.240)*rk(531)    *y(lO3)
     &                      +(-0.684)*rk(532)    *y(lNO3)
          JAC(lXRCH,lALK2)= +(-0.261)*rk(544)    *y(lOH)
          JAC(lXRCH,lALK3)= +(-0.122)*rk(545)    *y(lOH)
          JAC(lXRCH,lALK4)= +(-0.236)*rk(546)    *y(lOH)
          JAC(lXRCH,lALK5)= +(-0.209)*rk(547)    *y(lOH)
          JAC(lXRCH,lOLE1)= +(-0.666)*rk(548)    *y(lOH)
     &                      +(-0.044)*rk(549)    *y(lO3)
     &                      +(-0.003)*rk(550)    *y(lNO3)
          JAC(lXRCH,lOLE2)= +(-0.510)*rk(552)    *y(lOH)
     &                      +(-0.019)*rk(553)    *y(lO3)
     &                      +(-0.163)*rk(554)    *y(lNO3)
          JAC(lXRCH,lTERP)= +(-0.385)*rk(558)    *y(lOH)
     &                      +(-0.208)*rk(559)    *y(lO3)
     &                      +(-0.403)*rk(560)    *y(lNO3)
          JAC(lXRCH,lSESQ)= +(-0.385)*rk(562)    *y(lOH)
     &                      +(-0.208)*rk(563)    *y(lO3)
     &                      +(-0.403)*rk(564)    *y(lNO3)
          JAC(lFACD,lO3  )= +(-0.333)*rk(255)    *y(lMACR)
     &                      +(-0.351)*rk(260)    *y(lMVK)
     &                      +(-0.100)*rk(264)    *y(lIPRD)
     &                      +(-0.185)*rk(275)    *y(lACRO)
     &                      +(-0.370)*rk(515)    *y(lETHE)
     &                      +(-0.185)*rk(519)    *y(lPRPE)
     &                      +(-0.185)*rk(523)    *y(lBD13)
     &                      +(-0.204)*rk(527)    *y(lISOP)
     &                      +(-0.185)*rk(549)    *y(lOLE1)
          JAC(lFACD,lO3  )=JAC(lFACD,lO3  )
     &                      +(-0.024)*rk(553)    *y(lOLE2)
     &                      +(-0.172)*rk(559)    *y(lTERP)
     &                      +(-0.172)*rk(563)    *y(lSESQ)
          JAC(lFACD,lOH  )= +         rk(219)    *y(lFACD)
     &                      +(-0.300)*rk(534)    *y(lACYE)
          JAC(lFACD,lFACD)= +         rk(219)    *y(lOH)
          JAC(lFACD,lIPRD)= +(-0.100)*rk(264)    *y(lO3)
          JAC(lFACD,lMACR)= +(-0.333)*rk(255)    *y(lO3)
          JAC(lFACD,lMVK )= +(-0.351)*rk(260)    *y(lO3)
          JAC(lFACD,lACRO)= +(-0.185)*rk(275)    *y(lO3)
          JAC(lFACD,lETHE)= +(-0.370)*rk(515)    *y(lO3)
          JAC(lFACD,lPRPE)= +(-0.185)*rk(519)    *y(lO3)
          JAC(lFACD,lBD13)= +(-0.185)*rk(523)    *y(lO3)
          JAC(lFACD,lISOP)= +(-0.204)*rk(527)    *y(lO3)
          JAC(lFACD,lACYE)= +(-0.300)*rk(534)    *y(lOH)
          JAC(lFACD,lOLE1)= +(-0.185)*rk(549)    *y(lO3)
          JAC(lFACD,lOLE2)= +(-0.024)*rk(553)    *y(lO3)
          JAC(lFACD,lTERP)= +(-0.172)*rk(559)    *y(lO3)
          JAC(lFACD,lSESQ)= +(-0.172)*rk(563)    *y(lO3)
          JAC(lXMGL,lNO  )= +         rk(353)    *y(lXMGL)
          JAC(lXMGL,lO3  )= +(-0.095)*rk(253)    *y(lAFG3)
     &                      +(-0.003)*rk(559)    *y(lTERP)
     &                      +(-0.003)*rk(563)    *y(lSESQ)
          JAC(lXMGL,lNO3 )= +(-0.008)*rk(265)    *y(lIPRD)
     &                      +         rk(355)    *y(lXMGL)
     &                      +(-0.002)*rk(532)    *y(lAPIN)
          JAC(lXMGL,lOH  )= +(-0.491)*rk(220)    *y(lAACD)
     &                      +(-0.252)*rk(228)    *y(lRAPX)
     &                      +(-0.250)*rk(238)    *y(lCRES)
     &                      +(-0.267)*rk(246)    *y(lAFG1)
     &                      +(-0.267)*rk(249)    *y(lAFG2)
     &                      +(-0.153)*rk(252)    *y(lAFG3)
     &                      +(-0.084)*rk(254)    *y(lMACR)
     &                      +(-0.300)*rk(259)    *y(lMVK)
     &                      +(-0.174)*rk(263)    *y(lIPRD)
          JAC(lXMGL,lOH  )=JAC(lXMGL,lOH  )
     &                      +(-0.020)*rk(530)    *y(lAPIN)
     &                      +(-0.151)*rk(537)    *y(lTOLU)
     &                      +(-0.380)*rk(538)    *y(lMXYL)
     &                      +(-0.238)*rk(539)    *y(lOXYL)
     &                      +(-0.112)*rk(540)    *y(lPXYL)
     &                      +(-0.405)*rk(541)    *y(lB124)
     &                      +(-0.100)*rk(556)    *y(lARO1)
     &                      +(-0.312)*rk(557)    *y(lARO2)
          JAC(lXMGL,lOH  )=JAC(lXMGL,lOH  )
     &                      +(-0.003)*rk(558)    *y(lTERP)
     &                      +(-0.003)*rk(562)    *y(lSESQ)
          JAC(lXMGL,lHO2 )= +         rk(354)    *y(lXMGL)
          JAC(lXMGL,lMEO2)= +         rk(356)    *y(lXMGL)
          JAC(lXMGL,lRO2C)= +         rk(357)    *y(lXMGL)
          JAC(lXMGL,lRO2X)= +         rk(358)    *y(lXMGL)
          JAC(lXMGL,lMCO3)= +         rk(359)    *y(lXMGL)
          JAC(lXMGL,lAACD)= +(-0.491)*rk(220)    *y(lOH)
          JAC(lXMGL,lRCO3)= +         rk(360)    *y(lXMGL)
          JAC(lXMGL,lBZC3)= +         rk(361)    *y(lXMGL)
          JAC(lXMGL,lMAC3)= +         rk(362)    *y(lXMGL)
          JAC(lXMGL,lCRES)= +(-0.250)*rk(238)    *y(lOH)
          JAC(lXMGL,lXMGL)= +         rk(353)    *y(lNO)
     &                      +         rk(354)    *y(lHO2)
     &                      +         rk(355)    *y(lNO3)
     &                      +         rk(356)    *y(lMEO2)
     &                      +         rk(357)    *y(lRO2C)
     &                      +         rk(358)    *y(lRO2X)
     &                      +         rk(359)    *y(lMCO3)
     &                      +         rk(360)    *y(lRCO3)
     &                      +         rk(361)    *y(lBZC3)
          JAC(lXMGL,lXMGL)=JAC(lXMGL,lXMGL)
     &                      +         rk(362)    *y(lMAC3)
          JAC(lXMGL,lRAPX)= +(-0.252)*rk(228)    *y(lOH)
          JAC(lXMGL,lIPRD)= +(-0.174)*rk(263)    *y(lOH)
     &                      +(-0.008)*rk(265)    *y(lNO3)
          JAC(lXMGL,lAFG1)= +(-0.267)*rk(246)    *y(lOH)
          JAC(lXMGL,lAFG2)= +(-0.267)*rk(249)    *y(lOH)
          JAC(lXMGL,lAFG3)= +(-0.153)*rk(252)    *y(lOH)
     &                      +(-0.095)*rk(253)    *y(lO3)
          JAC(lXMGL,lMACR)= +(-0.084)*rk(254)    *y(lOH)
          JAC(lXMGL,lMVK )= +(-0.300)*rk(259)    *y(lOH)
          JAC(lXMGL,lAPIN)= +(-0.020)*rk(530)    *y(lOH)
     &                      +(-0.002)*rk(532)    *y(lNO3)
          JAC(lXMGL,lTOLU)= +(-0.151)*rk(537)    *y(lOH)
          JAC(lXMGL,lMXYL)= +(-0.380)*rk(538)    *y(lOH)
          JAC(lXMGL,lOXYL)= +(-0.238)*rk(539)    *y(lOH)
          JAC(lXMGL,lPXYL)= +(-0.112)*rk(540)    *y(lOH)
          JAC(lXMGL,lB124)= +(-0.405)*rk(541)    *y(lOH)
          JAC(lXMGL,lARO1)= +(-0.100)*rk(556)    *y(lOH)
          JAC(lXMGL,lARO2)= +(-0.312)*rk(557)    *y(lOH)
          JAC(lXMGL,lTERP)= +(-0.003)*rk(558)    *y(lOH)
     &                      +(-0.003)*rk(559)    *y(lO3)
          JAC(lXMGL,lSESQ)= +(-0.003)*rk(562)    *y(lOH)
     &                      +(-0.003)*rk(563)    *y(lO3)
          JAC(lXBAC,lNO  )= +         rk(363)    *y(lXBAC)
          JAC(lXBAC,lO3  )= +(-0.081)*rk(531)    *y(lAPIN)
     &                      +(-0.039)*rk(559)    *y(lTERP)
     &                      +(-0.039)*rk(563)    *y(lSESQ)
          JAC(lXBAC,lNO3 )= +         rk(365)    *y(lXBAC)
          JAC(lXBAC,lOH  )= +(-0.457)*rk(221)    *y(lPACD)
     &                      +(-0.019)*rk(252)    *y(lAFG3)
     &                      +(-0.023)*rk(530)    *y(lAPIN)
     &                      +(-0.185)*rk(539)    *y(lOXYL)
     &                      +(-0.112)*rk(541)    *y(lB124)
     &                      +(-0.134)*rk(557)    *y(lARO2)
     &                      +(-0.009)*rk(558)    *y(lTERP)
     &                      +(-0.009)*rk(562)    *y(lSESQ)
          JAC(lXBAC,lHO2 )= +         rk(364)    *y(lXBAC)
          JAC(lXBAC,lMEO2)= +         rk(366)    *y(lXBAC)
          JAC(lXBAC,lRO2C)= +         rk(367)    *y(lXBAC)
          JAC(lXBAC,lRO2X)= +         rk(368)    *y(lXBAC)
          JAC(lXBAC,lMCO3)= +         rk(369)    *y(lXBAC)
          JAC(lXBAC,lRCO3)= +         rk(370)    *y(lXBAC)
          JAC(lXBAC,lPACD)= +(-0.457)*rk(221)    *y(lOH)
          JAC(lXBAC,lBZC3)= +         rk(371)    *y(lXBAC)
          JAC(lXBAC,lMAC3)= +         rk(372)    *y(lXBAC)
          JAC(lXBAC,lXBAC)= +         rk(363)    *y(lNO)
     &                      +         rk(364)    *y(lHO2)
     &                      +         rk(365)    *y(lNO3)
     &                      +         rk(366)    *y(lMEO2)
     &                      +         rk(367)    *y(lRO2C)
     &                      +         rk(368)    *y(lRO2X)
     &                      +         rk(369)    *y(lMCO3)
     &                      +         rk(370)    *y(lRCO3)
     &                      +         rk(371)    *y(lBZC3)
          JAC(lXBAC,lXBAC)=JAC(lXBAC,lXBAC)
     &                      +         rk(372)    *y(lMAC3)
          JAC(lXBAC,lAFG3)= +(-0.019)*rk(252)    *y(lOH)
          JAC(lXBAC,lAPIN)= +(-0.023)*rk(530)    *y(lOH)
     &                      +(-0.081)*rk(531)    *y(lO3)
          JAC(lXBAC,lOXYL)= +(-0.185)*rk(539)    *y(lOH)
          JAC(lXBAC,lB124)= +(-0.112)*rk(541)    *y(lOH)
          JAC(lXBAC,lARO2)= +(-0.134)*rk(557)    *y(lOH)
          JAC(lXBAC,lTERP)= +(-0.009)*rk(558)    *y(lOH)
     &                      +(-0.039)*rk(559)    *y(lO3)
          JAC(lXBAC,lSESQ)= +(-0.009)*rk(562)    *y(lOH)
     &                      +(-0.039)*rk(563)    *y(lO3)
          JAC(lROOH,lOH  )= +         rk(224)    *y(lROOH)
          JAC(lROOH,lHO2 )= +(-1.000)*rk(454)    *y(lYRPX)
          JAC(lROOH,lYRPX)= +(-1.000)*rk(454)    *y(lHO2)
          JAC(lROOH,lROOH)= +         rk(224)    *y(lOH)
     &                      +         rk(225)*flg
          JAC(lXPD2,lNO  )= +         rk(333)    *y(lXPD2)
          JAC(lXPD2,lNO3 )= +         rk(335)    *y(lXPD2)
          JAC(lXPD2,lOH  )= +(-0.034)*rk(224)    *y(lROOH)
     &                      +(-0.084)*rk(226)    *y(lR6PX)
     &                      +(-0.332)*rk(263)    *y(lIPRD)
     &                      +(-0.007)*rk(267)    *y(lPRD2)
     &                      +(-0.031)*rk(269)    *y(lRNO3)
     &                      +(-0.146)*rk(546)    *y(lALK4)
     &                      +(-0.407)*rk(547)    *y(lALK5)
     &                      +(-0.168)*rk(548)    *y(lOLE1)
     &                      +(-0.023)*rk(552)    *y(lOLE2)
          JAC(lXPD2,lOH  )=JAC(lXPD2,lOH  )
     &                      +(-0.309)*rk(556)    *y(lARO1)
     &                      +(-0.057)*rk(557)    *y(lARO2)
     &                      +(-0.409)*rk(558)    *y(lTERP)
     &                      +(-0.409)*rk(562)    *y(lSESQ)
          JAC(lXPD2,lHO2 )= +         rk(334)    *y(lXPD2)
          JAC(lXPD2,lMEO2)= +         rk(336)    *y(lXPD2)
          JAC(lXPD2,lRO2C)= +         rk(337)    *y(lXPD2)
          JAC(lXPD2,lRO2X)= +         rk(338)    *y(lXPD2)
          JAC(lXPD2,lMCO3)= +         rk(339)    *y(lXPD2)
          JAC(lXPD2,lRCO3)= +         rk(340)    *y(lXPD2)
          JAC(lXPD2,lBZC3)= +         rk(341)    *y(lXPD2)
          JAC(lXPD2,lMAC3)= +         rk(342)    *y(lXPD2)
          JAC(lXPD2,lRNO3)= +(-0.031)*rk(269)    *y(lOH)
     &                      +(-0.261)*rk(270)*flg
          JAC(lXPD2,lROOH)= +(-0.034)*rk(224)    *y(lOH)
          JAC(lXPD2,lXPD2)= +         rk(333)    *y(lNO)
     &                      +         rk(334)    *y(lHO2)
     &                      +         rk(335)    *y(lNO3)
     &                      +         rk(336)    *y(lMEO2)
     &                      +         rk(337)    *y(lRO2C)
     &                      +         rk(338)    *y(lRO2X)
     &                      +         rk(339)    *y(lMCO3)
     &                      +         rk(340)    *y(lRCO3)
     &                      +         rk(341)    *y(lBZC3)
          JAC(lXPD2,lXPD2)=JAC(lXPD2,lXPD2)
     &                      +         rk(342)    *y(lMAC3)
          JAC(lXPD2,lR6PX)= +(-0.084)*rk(226)    *y(lOH)
     &                      +(-0.698)*rk(227)*flg
          JAC(lXPD2,lPRD2)= +(-0.007)*rk(267)    *y(lOH)
          JAC(lXPD2,lIPRD)= +(-0.332)*rk(263)    *y(lOH)
          JAC(lXPD2,lALK4)= +(-0.146)*rk(546)    *y(lOH)
          JAC(lXPD2,lALK5)= +(-0.407)*rk(547)    *y(lOH)
          JAC(lXPD2,lOLE1)= +(-0.168)*rk(548)    *y(lOH)
          JAC(lXPD2,lOLE2)= +(-0.023)*rk(552)    *y(lOH)
          JAC(lXPD2,lARO1)= +(-0.309)*rk(556)    *y(lOH)
          JAC(lXPD2,lARO2)= +(-0.057)*rk(557)    *y(lOH)
          JAC(lXPD2,lTERP)= +(-0.409)*rk(558)    *y(lOH)
          JAC(lXPD2,lSESQ)= +(-0.409)*rk(562)    *y(lOH)
          JAC(lR6PX,lOH  )= +         rk(226)    *y(lR6PX)
          JAC(lR6PX,lHO2 )= +(-1.000)*rk(464)    *y(lY6PX)
          JAC(lR6PX,lR6PX)= +         rk(226)    *y(lOH)
     &                      +         rk(227)*flg
          JAC(lR6PX,lY6PX)= +(-1.000)*rk(464)    *y(lHO2)
          JAC(lPRD2,lNO  )= +(-1.000)*rk(333)    *y(lXPD2)
          JAC(lPRD2,lO3P )= +(-0.750)*rk(525)    *y(lBD13)
     &                      +(-0.750)*rk(529)    *y(lISOP)
     &                      +(-1.000)*rk(533)    *y(lAPIN)
     &                      +(-0.160)*rk(551)    *y(lOLE1)
     &                      +(-0.170)*rk(555)    *y(lOLE2)
     &                      +(-0.763)*rk(561)    *y(lTERP)
     &                      +(-0.763)*rk(565)    *y(lSESQ)
          JAC(lPRD2,lO3  )= +(-0.125)*rk(523)    *y(lBD13)
     &                      +(-0.100)*rk(527)    *y(lISOP)
     &                      +(-0.255)*rk(531)    *y(lAPIN)
     &                      +(-0.268)*rk(549)    *y(lOLE1)
     &                      +(-0.037)*rk(553)    *y(lOLE2)
     &                      +(-0.502)*rk(559)    *y(lTERP)
     &                      +(-0.502)*rk(563)    *y(lSESQ)
          JAC(lPRD2,lNO3 )= +(-1.000)*rk(335)    *y(lXPD2)
     &                      +(-1.000)*rk(485)    *y(lZRN3)
          JAC(lPRD2,lOH  )= +(-0.840)*rk(226)    *y(lR6PX)
     &                      +(-0.074)*rk(228)    *y(lRAPX)
     &                      +         rk(267)    *y(lPRD2)
     &                      +(-0.329)*rk(267)    *y(lPRD2)
     &                      +(-0.008)*rk(269)    *y(lRNO3)
          JAC(lPRD2,lMEO2)= +(-0.500)*rk(336)    *y(lXPD2)
     &                      +(-0.500)*rk(466)    *y(lY6PX)
     &                      +(-0.500)*rk(476)    *y(lYAPX)
     &                      +(-0.500)*rk(486)    *y(lZRN3)
          JAC(lPRD2,lRO2C)= +(-0.500)*rk(337)    *y(lXPD2)
     &                      +(-0.500)*rk(467)    *y(lY6PX)
     &                      +(-0.500)*rk(477)    *y(lYAPX)
     &                      +(-0.500)*rk(487)    *y(lZRN3)
          JAC(lPRD2,lRO2X)= +(-0.500)*rk(338)    *y(lXPD2)
     &                      +(-0.500)*rk(468)    *y(lY6PX)
     &                      +(-0.500)*rk(478)    *y(lYAPX)
     &                      +(-0.500)*rk(488)    *y(lZRN3)
          JAC(lPRD2,lMCO3)= +(-1.000)*rk(339)    *y(lXPD2)
     &                      +(-1.000)*rk(489)    *y(lZRN3)
          JAC(lPRD2,lRCO3)= +(-1.000)*rk(340)    *y(lXPD2)
     &                      +(-1.000)*rk(490)    *y(lZRN3)
          JAC(lPRD2,lBZC3)= +(-1.000)*rk(341)    *y(lXPD2)
     &                      +(-1.000)*rk(491)    *y(lZRN3)
          JAC(lPRD2,lMAC3)= +(-1.000)*rk(342)    *y(lXPD2)
     &                      +(-1.000)*rk(492)    *y(lZRN3)
          JAC(lPRD2,lRNO3)= +(-0.008)*rk(269)    *y(lOH)
     &                      +(-0.190)*rk(270)*flg
          JAC(lPRD2,lZRN3)= +(-1.000)*rk(485)    *y(lNO3)
     &                      +(-0.500)*rk(486)    *y(lMEO2)
     &                      +(-0.500)*rk(487)    *y(lRO2C)
     &                      +(-0.500)*rk(488)    *y(lRO2X)
     &                      +(-1.000)*rk(489)    *y(lMCO3)
     &                      +(-1.000)*rk(490)    *y(lRCO3)
     &                      +(-1.000)*rk(491)    *y(lBZC3)
     &                      +(-1.000)*rk(492)    *y(lMAC3)
          JAC(lPRD2,lXPD2)= +(-1.000)*rk(333)    *y(lNO)
     &                      +(-1.000)*rk(335)    *y(lNO3)
     &                      +(-0.500)*rk(336)    *y(lMEO2)
     &                      +(-0.500)*rk(337)    *y(lRO2C)
     &                      +(-0.500)*rk(338)    *y(lRO2X)
     &                      +(-1.000)*rk(339)    *y(lMCO3)
     &                      +(-1.000)*rk(340)    *y(lRCO3)
     &                      +(-1.000)*rk(341)    *y(lBZC3)
     &                      +(-1.000)*rk(342)    *y(lMAC3)
          JAC(lPRD2,lR6PX)= +(-0.840)*rk(226)    *y(lOH)
     &                      +(-0.142)*rk(227)*flg
          JAC(lPRD2,lPRD2)= +         rk(267)    *y(lOH)
     &                      +(-0.329)*rk(267)    *y(lOH)
     &                      +         rk(268)*flg
          JAC(lPRD2,lY6PX)= +(-0.500)*rk(466)    *y(lMEO2)
     &                      +(-0.500)*rk(467)    *y(lRO2C)
     &                      +(-0.500)*rk(468)    *y(lRO2X)
          JAC(lPRD2,lRAPX)= +(-0.074)*rk(228)    *y(lOH)
          JAC(lPRD2,lAFG2)= +(-1.000)*rk(251)*flg
          JAC(lPRD2,lMVK )= +(-0.600)*rk(262)*flg
          JAC(lPRD2,lYAPX)= +(-0.500)*rk(476)    *y(lMEO2)
     &                      +(-0.500)*rk(477)    *y(lRO2C)
     &                      +(-0.500)*rk(478)    *y(lRO2X)
          JAC(lPRD2,lBD13)= +(-0.125)*rk(523)    *y(lO3)
     &                      +(-0.750)*rk(525)    *y(lO3P)
          JAC(lPRD2,lISOP)= +(-0.100)*rk(527)    *y(lO3)
     &                      +(-0.750)*rk(529)    *y(lO3P)
          JAC(lPRD2,lAPIN)= +(-0.255)*rk(531)    *y(lO3)
     &                      +(-1.000)*rk(533)    *y(lO3P)
          JAC(lPRD2,lOLE1)= +(-0.268)*rk(549)    *y(lO3)
     &                      +(-0.160)*rk(551)    *y(lO3P)
          JAC(lPRD2,lOLE2)= +(-0.037)*rk(553)    *y(lO3)
     &                      +(-0.170)*rk(555)    *y(lO3P)
          JAC(lPRD2,lTERP)= +(-0.502)*rk(559)    *y(lO3)
     &                      +(-0.763)*rk(561)    *y(lO3P)
          JAC(lPRD2,lSESQ)= +(-0.502)*rk(563)    *y(lO3)
     &                      +(-0.763)*rk(565)    *y(lO3P)
          JAC(lY6PX,lNO  )= +         rk(463)    *y(lY6PX)
          JAC(lY6PX,lO3P )= +(-0.250)*rk(529)    *y(lISOP)
          JAC(lY6PX,lO3  )= +(-0.652)*rk(247)    *y(lAFG1)
     &                      +(-0.652)*rk(250)    *y(lAFG2)
     &                      +(-0.264)*rk(253)    *y(lAFG3)
     &                      +(-0.048)*rk(264)    *y(lIPRD)
     &                      +(-0.200)*rk(527)    *y(lISOP)
     &                      +(-0.737)*rk(531)    *y(lAPIN)
     &                      +(-0.052)*rk(549)    *y(lOLE1)
     &                      +(-0.136)*rk(553)    *y(lOLE2)
     &                      +(-0.428)*rk(559)    *y(lTERP)
          JAC(lY6PX,lO3  )=JAC(lY6PX,lO3  )
     &                      +(-0.428)*rk(563)    *y(lSESQ)
          JAC(lY6PX,lNO3 )= +(-0.850)*rk(265)    *y(lIPRD)
     &                      +         rk(465)    *y(lY6PX)
     &                      +(-1.000)*rk(528)    *y(lISOP)
     &                      +(-1.000)*rk(532)    *y(lAPIN)
     &                      +(-0.831)*rk(550)    *y(lOLE1)
     &                      +(-0.681)*rk(554)    *y(lOLE2)
     &                      +(-1.000)*rk(560)    *y(lTERP)
     &                      +(-1.000)*rk(564)    *y(lSESQ)
          JAC(lY6PX,lOH  )= +(-0.713)*rk(228)    *y(lRAPX)
     &                      +(-0.800)*rk(238)    *y(lCRES)
     &                      +(-0.783)*rk(246)    *y(lAFG1)
     &                      +(-0.783)*rk(249)    *y(lAFG2)
     &                      +(-0.794)*rk(252)    *y(lAFG3)
     &                      +(-0.711)*rk(263)    *y(lIPRD)
     &                      +(-0.528)*rk(267)    *y(lPRD2)
     &                      +(-0.636)*rk(269)    *y(lRNO3)
     &                      +(-1.000)*rk(526)    *y(lISOP)
          JAC(lY6PX,lOH  )=JAC(lY6PX,lOH  )
     &                      +(-1.000)*rk(530)    *y(lAPIN)
     &                      +(-0.073)*rk(537)    *y(lTOLU)
     &                      +(-0.047)*rk(538)    *y(lMXYL)
     &                      +(-0.055)*rk(539)    *y(lOXYL)
     &                      +(-0.102)*rk(540)    *y(lPXYL)
     &                      +(-0.043)*rk(541)    *y(lB124)
     &                      +(-0.017)*rk(545)    *y(lALK3)
     &                      +(-1.000)*rk(546)    *y(lALK4)
          JAC(lY6PX,lOH  )=JAC(lY6PX,lOH  )
     &                      +(-1.000)*rk(547)    *y(lALK5)
     &                      +(-0.831)*rk(548)    *y(lOLE1)
     &                      +(-0.681)*rk(552)    *y(lOLE2)
     &                      +(-0.369)*rk(556)    *y(lARO1)
     &                      +(-0.101)*rk(557)    *y(lARO2)
     &                      +(-1.000)*rk(558)    *y(lTERP)
     &                      +(-1.000)*rk(562)    *y(lSESQ)
          JAC(lY6PX,lHO2 )= +         rk(464)    *y(lY6PX)
          JAC(lY6PX,lMEO2)= +         rk(466)    *y(lY6PX)
          JAC(lY6PX,lRO2C)= +         rk(467)    *y(lY6PX)
          JAC(lY6PX,lRO2X)= +         rk(468)    *y(lY6PX)
          JAC(lY6PX,lMCO3)= +         rk(469)    *y(lY6PX)
          JAC(lY6PX,lRCO3)= +         rk(470)    *y(lY6PX)
          JAC(lY6PX,lBZC3)= +         rk(471)    *y(lY6PX)
          JAC(lY6PX,lMAC3)= +         rk(472)    *y(lY6PX)
          JAC(lY6PX,lRNO3)= +(-0.636)*rk(269)    *y(lOH)
     &                      +(-0.591)*rk(270)*flg
          JAC(lY6PX,lCRES)= +(-0.800)*rk(238)    *y(lOH)
          JAC(lY6PX,lR6PX)= +(-0.858)*rk(227)*flg
          JAC(lY6PX,lPRD2)= +(-0.528)*rk(267)    *y(lOH)
     &                      +(-1.000)*rk(268)*flg
          JAC(lY6PX,lY6PX)= +         rk(463)    *y(lNO)
     &                      +         rk(464)    *y(lHO2)
     &                      +         rk(465)    *y(lNO3)
     &                      +         rk(466)    *y(lMEO2)
     &                      +         rk(467)    *y(lRO2C)
     &                      +         rk(468)    *y(lRO2X)
     &                      +         rk(469)    *y(lMCO3)
     &                      +         rk(470)    *y(lRCO3)
     &                      +         rk(471)    *y(lBZC3)
          JAC(lY6PX,lY6PX)=JAC(lY6PX,lY6PX)
     &                      +         rk(472)    *y(lMAC3)
          JAC(lY6PX,lRAPX)= +(-0.713)*rk(228)    *y(lOH)
          JAC(lY6PX,lIPRD)= +(-0.711)*rk(263)    *y(lOH)
     &                      +(-0.048)*rk(264)    *y(lO3)
     &                      +(-0.850)*rk(265)    *y(lNO3)
          JAC(lY6PX,lAFG1)= +(-0.783)*rk(246)    *y(lOH)
     &                      +(-0.652)*rk(247)    *y(lO3)
          JAC(lY6PX,lAFG2)= +(-0.783)*rk(249)    *y(lOH)
     &                      +(-0.652)*rk(250)    *y(lO3)
          JAC(lY6PX,lAFG3)= +(-0.794)*rk(252)    *y(lOH)
     &                      +(-0.264)*rk(253)    *y(lO3)
          JAC(lY6PX,lISOP)= +(-1.000)*rk(526)    *y(lOH)
     &                      +(-0.200)*rk(527)    *y(lO3)
     &                      +(-1.000)*rk(528)    *y(lNO3)
     &                      +(-0.250)*rk(529)    *y(lO3P)
          JAC(lY6PX,lAPIN)= +(-1.000)*rk(530)    *y(lOH)
     &                      +(-0.737)*rk(531)    *y(lO3)
     &                      +(-1.000)*rk(532)    *y(lNO3)
          JAC(lY6PX,lTOLU)= +(-0.073)*rk(537)    *y(lOH)
          JAC(lY6PX,lMXYL)= +(-0.047)*rk(538)    *y(lOH)
          JAC(lY6PX,lOXYL)= +(-0.055)*rk(539)    *y(lOH)
          JAC(lY6PX,lPXYL)= +(-0.102)*rk(540)    *y(lOH)
          JAC(lY6PX,lB124)= +(-0.043)*rk(541)    *y(lOH)
          JAC(lY6PX,lALK3)= +(-0.017)*rk(545)    *y(lOH)
          JAC(lY6PX,lALK4)= +(-1.000)*rk(546)    *y(lOH)
          JAC(lY6PX,lALK5)= +(-1.000)*rk(547)    *y(lOH)
          JAC(lY6PX,lOLE1)= +(-0.831)*rk(548)    *y(lOH)
     &                      +(-0.052)*rk(549)    *y(lO3)
     &                      +(-0.831)*rk(550)    *y(lNO3)
          JAC(lY6PX,lOLE2)= +(-0.681)*rk(552)    *y(lOH)
     &                      +(-0.136)*rk(553)    *y(lO3)
     &                      +(-0.681)*rk(554)    *y(lNO3)
          JAC(lY6PX,lARO1)= +(-0.369)*rk(556)    *y(lOH)
          JAC(lY6PX,lARO2)= +(-0.101)*rk(557)    *y(lOH)
          JAC(lY6PX,lTERP)= +(-1.000)*rk(558)    *y(lOH)
     &                      +(-0.428)*rk(559)    *y(lO3)
     &                      +(-1.000)*rk(560)    *y(lNO3)
          JAC(lY6PX,lSESQ)= +(-1.000)*rk(562)    *y(lOH)
     &                      +(-0.428)*rk(563)    *y(lO3)
     &                      +(-1.000)*rk(564)    *y(lNO3)
          JAC(lRAPX,lOH  )= +         rk(228)    *y(lRAPX)
          JAC(lRAPX,lHO2 )= +(-1.000)*rk(474)    *y(lYAPX)
          JAC(lRAPX,lRAPX)= +         rk(228)    *y(lOH)
     &                      +         rk(229)*flg
          JAC(lRAPX,lYAPX)= +(-1.000)*rk(474)    *y(lHO2)
          JAC(lMGLY,lNO  )= +(-1.000)*rk(353)    *y(lXMGL)
          JAC(lMGLY,lO3  )= +(-0.568)*rk(247)    *y(lAFG1)
     &                      +(-0.568)*rk(250)    *y(lAFG2)
     &                      +(-0.184)*rk(253)    *y(lAFG3)
     &                      +(-0.900)*rk(255)    *y(lMACR)
     &                      +(-0.950)*rk(260)    *y(lMVK)
     &                      +(-0.742)*rk(264)    *y(lIPRD)
          JAC(lMGLY,lNO3 )= +         rk(236)    *y(lMGLY)
     &                      +(-1.000)*rk(355)    *y(lXMGL)
          JAC(lMGLY,lOH  )= +(-0.147)*rk(228)    *y(lRAPX)
     &                      +         rk(235)    *y(lMGLY)
          JAC(lMGLY,lMEO2)= +(-0.500)*rk(356)    *y(lXMGL)
          JAC(lMGLY,lRO2C)= +(-0.500)*rk(357)    *y(lXMGL)
          JAC(lMGLY,lRO2X)= +(-0.500)*rk(358)    *y(lXMGL)
          JAC(lMGLY,lMCO3)= +(-1.000)*rk(359)    *y(lXMGL)
          JAC(lMGLY,lRCO3)= +(-1.000)*rk(360)    *y(lXMGL)
          JAC(lMGLY,lBZC3)= +(-1.000)*rk(361)    *y(lXMGL)
          JAC(lMGLY,lMAC3)= +(-1.000)*rk(362)    *y(lXMGL)
          JAC(lMGLY,lXMGL)= +(-1.000)*rk(353)    *y(lNO)
     &                      +(-1.000)*rk(355)    *y(lNO3)
     &                      +(-0.500)*rk(356)    *y(lMEO2)
     &                      +(-0.500)*rk(357)    *y(lRO2C)
     &                      +(-0.500)*rk(358)    *y(lRO2X)
     &                      +(-1.000)*rk(359)    *y(lMCO3)
     &                      +(-1.000)*rk(360)    *y(lRCO3)
     &                      +(-1.000)*rk(361)    *y(lBZC3)
     &                      +(-1.000)*rk(362)    *y(lMAC3)
          JAC(lMGLY,lRAPX)= +(-0.147)*rk(228)    *y(lOH)
     &                      +(-0.500)*rk(229)*flg
          JAC(lMGLY,lMGLY)= +         rk(234)*flg
     &                      +         rk(235)    *y(lOH)
     &                      +         rk(236)    *y(lNO3)
          JAC(lMGLY,lIPRD)= +(-0.742)*rk(264)    *y(lO3)
          JAC(lMGLY,lAFG1)= +(-0.568)*rk(247)    *y(lO3)
     &                      +(-0.305)*rk(248)*flg
          JAC(lMGLY,lAFG2)= +(-0.568)*rk(250)    *y(lO3)
          JAC(lMGLY,lAFG3)= +(-0.184)*rk(253)    *y(lO3)
          JAC(lMGLY,lMACR)= +(-0.900)*rk(255)    *y(lO3)
          JAC(lMGLY,lMVK )= +(-0.950)*rk(260)    *y(lO3)
          JAC(lIPRD,lNO  )= +(-1.000)*rk(433)    *y(lXIPR)
          JAC(lIPRD,lO3  )= +(-0.003)*rk(253)    *y(lAFG3)
     &                      +         rk(264)    *y(lIPRD)
     &                      +(-0.150)*rk(527)    *y(lISOP)
          JAC(lIPRD,lNO3 )= +         rk(265)    *y(lIPRD)
     &                      +(-1.000)*rk(435)    *y(lXIPR)
          JAC(lIPRD,lOH  )= +(-0.139)*rk(228)    *y(lRAPX)
     &                      +         rk(263)    *y(lIPRD)
          JAC(lIPRD,lMEO2)= +(-0.500)*rk(436)    *y(lXIPR)
          JAC(lIPRD,lRO2C)= +(-0.500)*rk(437)    *y(lXIPR)
          JAC(lIPRD,lRO2X)= +(-0.500)*rk(438)    *y(lXIPR)
          JAC(lIPRD,lMCO3)= +(-1.000)*rk(439)    *y(lXIPR)
          JAC(lIPRD,lRCO3)= +(-1.000)*rk(440)    *y(lXIPR)
          JAC(lIPRD,lBZC3)= +(-1.000)*rk(441)    *y(lXIPR)
          JAC(lIPRD,lMAC3)= +(-1.000)*rk(442)    *y(lXIPR)
          JAC(lIPRD,lRAPX)= +(-0.139)*rk(228)    *y(lOH)
          JAC(lIPRD,lIPRD)= +         rk(263)    *y(lOH)
     &                      +         rk(264)    *y(lO3)
     &                      +         rk(265)    *y(lNO3)
     &                      +         rk(266)*flg
          JAC(lIPRD,lAFG3)= +(-0.003)*rk(253)    *y(lO3)
          JAC(lIPRD,lXIPR)= +(-1.000)*rk(433)    *y(lNO)
     &                      +(-1.000)*rk(435)    *y(lNO3)
     &                      +(-0.500)*rk(436)    *y(lMEO2)
     &                      +(-0.500)*rk(437)    *y(lRO2C)
     &                      +(-0.500)*rk(438)    *y(lRO2X)
     &                      +(-1.000)*rk(439)    *y(lMCO3)
     &                      +(-1.000)*rk(440)    *y(lRCO3)
     &                      +(-1.000)*rk(441)    *y(lBZC3)
     &                      +(-1.000)*rk(442)    *y(lMAC3)
          JAC(lIPRD,lISOP)= +(-0.150)*rk(527)    *y(lO3)
          JAC(lXGLY,lNO  )= +         rk(343)    *y(lXGLY)
          JAC(lXGLY,lO3P )= +(-0.012)*rk(517)    *y(lETHE)
          JAC(lXGLY,lO3  )= +(-0.002)*rk(531)    *y(lAPIN)
          JAC(lXGLY,lNO3 )= +         rk(345)    *y(lXGLY)
          JAC(lXGLY,lOH  )= +(-0.026)*rk(228)    *y(lRAPX)
     &                      +(-0.107)*rk(246)    *y(lAFG1)
     &                      +(-0.107)*rk(249)    *y(lAFG2)
     &                      +(-0.274)*rk(252)    *y(lAFG3)
     &                      +(-0.150)*rk(263)    *y(lIPRD)
     &                      +(-0.083)*rk(274)    *y(lACRO)
     &                      +(-0.290)*rk(536)    *y(lBENZ)
     &                      +(-0.238)*rk(537)    *y(lTOLU)
     &                      +(-0.100)*rk(538)    *y(lMXYL)
          JAC(lXGLY,lOH  )=JAC(lXGLY,lOH  )
     &                      +(-0.084)*rk(539)    *y(lOXYL)
     &                      +(-0.286)*rk(540)    *y(lPXYL)
     &                      +(-0.074)*rk(541)    *y(lB124)
     &                      +(-0.158)*rk(556)    *y(lARO1)
     &                      +(-0.088)*rk(557)    *y(lARO2)
          JAC(lXGLY,lHO2 )= +         rk(344)    *y(lXGLY)
          JAC(lXGLY,lMEO2)= +         rk(346)    *y(lXGLY)
          JAC(lXGLY,lRO2C)= +         rk(347)    *y(lXGLY)
          JAC(lXGLY,lRO2X)= +         rk(348)    *y(lXGLY)
          JAC(lXGLY,lMCO3)= +         rk(349)    *y(lXGLY)
          JAC(lXGLY,lRCO3)= +         rk(350)    *y(lXGLY)
          JAC(lXGLY,lBZC3)= +         rk(351)    *y(lXGLY)
          JAC(lXGLY,lMAC3)= +         rk(352)    *y(lXGLY)
          JAC(lXGLY,lRAPX)= +(-0.026)*rk(228)    *y(lOH)
          JAC(lXGLY,lIPRD)= +(-0.150)*rk(263)    *y(lOH)
          JAC(lXGLY,lXGLY)= +         rk(343)    *y(lNO)
     &                      +         rk(344)    *y(lHO2)
     &                      +         rk(345)    *y(lNO3)
     &                      +         rk(346)    *y(lMEO2)
     &                      +         rk(347)    *y(lRO2C)
     &                      +         rk(348)    *y(lRO2X)
     &                      +         rk(349)    *y(lMCO3)
     &                      +         rk(350)    *y(lRCO3)
     &                      +         rk(351)    *y(lBZC3)
          JAC(lXGLY,lXGLY)=JAC(lXGLY,lXGLY)
     &                      +         rk(352)    *y(lMAC3)
          JAC(lXGLY,lAFG1)= +(-0.107)*rk(246)    *y(lOH)
          JAC(lXGLY,lAFG2)= +(-0.107)*rk(249)    *y(lOH)
          JAC(lXGLY,lAFG3)= +(-0.274)*rk(252)    *y(lOH)
          JAC(lXGLY,lACRO)= +(-0.083)*rk(274)    *y(lOH)
          JAC(lXGLY,lETHE)= +(-0.012)*rk(517)    *y(lO3P)
          JAC(lXGLY,lAPIN)= +(-0.002)*rk(531)    *y(lO3)
          JAC(lXGLY,lBENZ)= +(-0.290)*rk(536)    *y(lOH)
          JAC(lXGLY,lTOLU)= +(-0.238)*rk(537)    *y(lOH)
          JAC(lXGLY,lMXYL)= +(-0.100)*rk(538)    *y(lOH)
          JAC(lXGLY,lOXYL)= +(-0.084)*rk(539)    *y(lOH)
          JAC(lXGLY,lPXYL)= +(-0.286)*rk(540)    *y(lOH)
          JAC(lXGLY,lB124)= +(-0.074)*rk(541)    *y(lOH)
          JAC(lXGLY,lARO1)= +(-0.158)*rk(556)    *y(lOH)
          JAC(lXGLY,lARO2)= +(-0.088)*rk(557)    *y(lOH)
          JAC(lXMEK,lNO  )= +         rk(323)    *y(lXMEK)
          JAC(lXMEK,lO3  )= +(-0.001)*rk(553)    *y(lOLE2)
          JAC(lXMEK,lNO3 )= +         rk(325)    *y(lXMEK)
     &                      +(-0.002)*rk(554)    *y(lOLE2)
          JAC(lXMEK,lOH  )= +(-0.030)*rk(228)    *y(lRAPX)
     &                      +(-0.129)*rk(246)    *y(lAFG1)
     &                      +(-0.129)*rk(249)    *y(lAFG2)
     &                      +(-0.416)*rk(254)    *y(lMACR)
     &                      +(-0.150)*rk(263)    *y(lIPRD)
     &                      +(-0.115)*rk(267)    *y(lPRD2)
     &                      +(-0.170)*rk(269)    *y(lRNO3)
     &                      +(-0.332)*rk(545)    *y(lALK3)
     &                      +(-0.106)*rk(546)    *y(lALK4)
          JAC(lXMEK,lOH  )=JAC(lXMEK,lOH  )
     &                      +(-0.086)*rk(547)    *y(lALK5)
     &                      +(-0.080)*rk(552)    *y(lOLE2)
     &                      +(-0.007)*rk(558)    *y(lTERP)
     &                      +(-0.007)*rk(562)    *y(lSESQ)
          JAC(lXMEK,lHO2 )= +         rk(324)    *y(lXMEK)
          JAC(lXMEK,lMEO2)= +         rk(326)    *y(lXMEK)
          JAC(lXMEK,lRO2C)= +         rk(327)    *y(lXMEK)
          JAC(lXMEK,lRO2X)= +         rk(328)    *y(lXMEK)
          JAC(lXMEK,lMCO3)= +         rk(329)    *y(lXMEK)
          JAC(lXMEK,lRCO3)= +         rk(330)    *y(lXMEK)
          JAC(lXMEK,lBZC3)= +         rk(331)    *y(lXMEK)
          JAC(lXMEK,lMAC3)= +         rk(332)    *y(lXMEK)
          JAC(lXMEK,lRNO3)= +(-0.170)*rk(269)    *y(lOH)
     &                      +(-0.083)*rk(270)*flg
          JAC(lXMEK,lPRD2)= +(-0.115)*rk(267)    *y(lOH)
          JAC(lXMEK,lRAPX)= +(-0.030)*rk(228)    *y(lOH)
          JAC(lXMEK,lIPRD)= +(-0.150)*rk(263)    *y(lOH)
          JAC(lXMEK,lXMEK)= +         rk(323)    *y(lNO)
     &                      +         rk(324)    *y(lHO2)
     &                      +         rk(325)    *y(lNO3)
     &                      +         rk(326)    *y(lMEO2)
     &                      +         rk(327)    *y(lRO2C)
     &                      +         rk(328)    *y(lRO2X)
     &                      +         rk(329)    *y(lMCO3)
     &                      +         rk(330)    *y(lRCO3)
     &                      +         rk(331)    *y(lBZC3)
          JAC(lXMEK,lXMEK)=JAC(lXMEK,lXMEK)
     &                      +         rk(332)    *y(lMAC3)
          JAC(lXMEK,lAFG1)= +(-0.129)*rk(246)    *y(lOH)
          JAC(lXMEK,lAFG2)= +(-0.129)*rk(249)    *y(lOH)
          JAC(lXMEK,lMACR)= +(-0.416)*rk(254)    *y(lOH)
          JAC(lXMEK,lALK3)= +(-0.332)*rk(545)    *y(lOH)
          JAC(lXMEK,lALK4)= +(-0.106)*rk(546)    *y(lOH)
          JAC(lXMEK,lALK5)= +(-0.086)*rk(547)    *y(lOH)
          JAC(lXMEK,lOLE2)= +(-0.080)*rk(552)    *y(lOH)
     &                      +(-0.001)*rk(553)    *y(lO3)
     &                      +(-0.002)*rk(554)    *y(lNO3)
          JAC(lXMEK,lTERP)= +(-0.007)*rk(558)    *y(lOH)
          JAC(lXMEK,lSESQ)= +(-0.007)*rk(562)    *y(lOH)
          JAC(lXAF1,lNO  )= +         rk(383)    *y(lXAF1)
          JAC(lXAF1,lO3P )= +(-0.001)*rk(525)    *y(lBD13)
          JAC(lXAF1,lNO3 )= +         rk(385)    *y(lXAF1)
          JAC(lXAF1,lOH  )= +(-0.073)*rk(228)    *y(lRAPX)
     &                      +(-0.195)*rk(252)    *y(lAFG3)
     &                      +(-0.029)*rk(536)    *y(lBENZ)
     &                      +(-0.195)*rk(537)    *y(lTOLU)
     &                      +(-0.336)*rk(538)    *y(lMXYL)
     &                      +(-0.253)*rk(539)    *y(lOXYL)
     &                      +(-0.045)*rk(540)    *y(lPXYL)
     &                      +(-0.088)*rk(541)    *y(lB124)
     &                      +(-0.072)*rk(556)    *y(lARO1)
          JAC(lXAF1,lOH  )=JAC(lXAF1,lOH  )
     &                      +(-0.221)*rk(557)    *y(lARO2)
          JAC(lXAF1,lHO2 )= +         rk(384)    *y(lXAF1)
          JAC(lXAF1,lMEO2)= +         rk(386)    *y(lXAF1)
          JAC(lXAF1,lRO2C)= +         rk(387)    *y(lXAF1)
          JAC(lXAF1,lRO2X)= +         rk(388)    *y(lXAF1)
          JAC(lXAF1,lMCO3)= +         rk(389)    *y(lXAF1)
          JAC(lXAF1,lRCO3)= +         rk(390)    *y(lXAF1)
          JAC(lXAF1,lBZC3)= +         rk(391)    *y(lXAF1)
          JAC(lXAF1,lMAC3)= +         rk(392)    *y(lXAF1)
          JAC(lXAF1,lRAPX)= +(-0.073)*rk(228)    *y(lOH)
          JAC(lXAF1,lXAF1)= +         rk(383)    *y(lNO)
     &                      +         rk(384)    *y(lHO2)
     &                      +         rk(385)    *y(lNO3)
     &                      +         rk(386)    *y(lMEO2)
     &                      +         rk(387)    *y(lRO2C)
     &                      +         rk(388)    *y(lRO2X)
     &                      +         rk(389)    *y(lMCO3)
     &                      +         rk(390)    *y(lRCO3)
     &                      +         rk(391)    *y(lBZC3)
          JAC(lXAF1,lXAF1)=JAC(lXAF1,lXAF1)
     &                      +         rk(392)    *y(lMAC3)
          JAC(lXAF1,lAFG3)= +(-0.195)*rk(252)    *y(lOH)
          JAC(lXAF1,lBD13)= +(-0.001)*rk(525)    *y(lO3P)
          JAC(lXAF1,lBENZ)= +(-0.029)*rk(536)    *y(lOH)
          JAC(lXAF1,lTOLU)= +(-0.195)*rk(537)    *y(lOH)
          JAC(lXAF1,lMXYL)= +(-0.336)*rk(538)    *y(lOH)
          JAC(lXAF1,lOXYL)= +(-0.253)*rk(539)    *y(lOH)
          JAC(lXAF1,lPXYL)= +(-0.045)*rk(540)    *y(lOH)
          JAC(lXAF1,lB124)= +(-0.088)*rk(541)    *y(lOH)
          JAC(lXAF1,lARO1)= +(-0.072)*rk(556)    *y(lOH)
          JAC(lXAF1,lARO2)= +(-0.221)*rk(557)    *y(lOH)
          JAC(lXAF2,lNO  )= +         rk(393)    *y(lXAF2)
          JAC(lXAF2,lO3P )= +(-0.001)*rk(525)    *y(lBD13)
          JAC(lXAF2,lNO3 )= +         rk(395)    *y(lXAF2)
          JAC(lXAF2,lOH  )= +(-0.073)*rk(228)    *y(lRAPX)
     &                      +(-0.195)*rk(252)    *y(lAFG3)
     &                      +(-0.261)*rk(536)    *y(lBENZ)
     &                      +(-0.195)*rk(537)    *y(lTOLU)
     &                      +(-0.144)*rk(538)    *y(lMXYL)
     &                      +(-0.253)*rk(539)    *y(lOXYL)
     &                      +(-0.067)*rk(540)    *y(lPXYL)
     &                      +(-0.352)*rk(541)    *y(lB124)
     &                      +(-0.185)*rk(556)    *y(lARO1)
          JAC(lXAF2,lOH  )=JAC(lXAF2,lOH  )
     &                      +(-0.247)*rk(557)    *y(lARO2)
          JAC(lXAF2,lHO2 )= +         rk(394)    *y(lXAF2)
          JAC(lXAF2,lMEO2)= +         rk(396)    *y(lXAF2)
          JAC(lXAF2,lRO2C)= +         rk(397)    *y(lXAF2)
          JAC(lXAF2,lRO2X)= +         rk(398)    *y(lXAF2)
          JAC(lXAF2,lMCO3)= +         rk(399)    *y(lXAF2)
          JAC(lXAF2,lRCO3)= +         rk(400)    *y(lXAF2)
          JAC(lXAF2,lBZC3)= +         rk(401)    *y(lXAF2)
          JAC(lXAF2,lMAC3)= +         rk(402)    *y(lXAF2)
          JAC(lXAF2,lRAPX)= +(-0.073)*rk(228)    *y(lOH)
          JAC(lXAF2,lXAF2)= +         rk(393)    *y(lNO)
     &                      +         rk(394)    *y(lHO2)
     &                      +         rk(395)    *y(lNO3)
     &                      +         rk(396)    *y(lMEO2)
     &                      +         rk(397)    *y(lRO2C)
     &                      +         rk(398)    *y(lRO2X)
     &                      +         rk(399)    *y(lMCO3)
     &                      +         rk(400)    *y(lRCO3)
     &                      +         rk(401)    *y(lBZC3)
          JAC(lXAF2,lXAF2)=JAC(lXAF2,lXAF2)
     &                      +         rk(402)    *y(lMAC3)
          JAC(lXAF2,lAFG3)= +(-0.195)*rk(252)    *y(lOH)
          JAC(lXAF2,lBD13)= +(-0.001)*rk(525)    *y(lO3P)
          JAC(lXAF2,lBENZ)= +(-0.261)*rk(536)    *y(lOH)
          JAC(lXAF2,lTOLU)= +(-0.195)*rk(537)    *y(lOH)
          JAC(lXAF2,lMXYL)= +(-0.144)*rk(538)    *y(lOH)
          JAC(lXAF2,lOXYL)= +(-0.253)*rk(539)    *y(lOH)
          JAC(lXAF2,lPXYL)= +(-0.067)*rk(540)    *y(lOH)
          JAC(lXAF2,lB124)= +(-0.352)*rk(541)    *y(lOH)
          JAC(lXAF2,lARO1)= +(-0.185)*rk(556)    *y(lOH)
          JAC(lXAF2,lARO2)= +(-0.247)*rk(557)    *y(lOH)
          JAC(lGLY ,lNO  )= +(-1.000)*rk(343)    *y(lXGLY)
          JAC(lGLY ,lO3  )= +(-0.432)*rk(247)    *y(lAFG1)
     &                      +(-0.432)*rk(250)    *y(lAFG2)
     &                      +(-0.366)*rk(253)    *y(lAFG3)
     &                      +(-0.023)*rk(264)    *y(lIPRD)
     &                      +(-0.500)*rk(275)    *y(lACRO)
          JAC(lGLY ,lNO3 )= +         rk(233)    *y(lGLY)
     &                      +(-1.000)*rk(345)    *y(lXGLY)
          JAC(lGLY ,lOH  )= +         rk(232)    *y(lGLY)
     &                      +(-0.700)*rk(534)    *y(lACYE)
          JAC(lGLY ,lMEO2)= +(-0.500)*rk(346)    *y(lXGLY)
          JAC(lGLY ,lRO2C)= +(-0.500)*rk(347)    *y(lXGLY)
          JAC(lGLY ,lRO2X)= +(-0.500)*rk(348)    *y(lXGLY)
          JAC(lGLY ,lMCO3)= +(-1.000)*rk(349)    *y(lXGLY)
          JAC(lGLY ,lRCO3)= +(-1.000)*rk(350)    *y(lXGLY)
          JAC(lGLY ,lBZC3)= +(-1.000)*rk(351)    *y(lXGLY)
          JAC(lGLY ,lMAC3)= +(-1.000)*rk(352)    *y(lXGLY)
          JAC(lGLY ,lRAPX)= +(-0.500)*rk(229)*flg
          JAC(lGLY ,lIPRD)= +(-0.023)*rk(264)    *y(lO3)
          JAC(lGLY ,lXGLY)= +(-1.000)*rk(343)    *y(lNO)
     &                      +(-1.000)*rk(345)    *y(lNO3)
     &                      +(-0.500)*rk(346)    *y(lMEO2)
     &                      +(-0.500)*rk(347)    *y(lRO2C)
     &                      +(-0.500)*rk(348)    *y(lRO2X)
     &                      +(-1.000)*rk(349)    *y(lMCO3)
     &                      +(-1.000)*rk(350)    *y(lRCO3)
     &                      +(-1.000)*rk(351)    *y(lBZC3)
     &                      +(-1.000)*rk(352)    *y(lMAC3)
          JAC(lGLY ,lGLY )= +         rk(230)*flg
     &                      +         rk(231)*flg
     &                      +         rk(232)    *y(lOH)
     &                      +         rk(233)    *y(lNO3)
          JAC(lGLY ,lAFG1)= +(-0.432)*rk(247)    *y(lO3)
     &                      +(-0.195)*rk(248)*flg
          JAC(lGLY ,lAFG2)= +(-0.432)*rk(250)    *y(lO3)
          JAC(lGLY ,lAFG3)= +(-0.366)*rk(253)    *y(lO3)
          JAC(lGLY ,lACRO)= +(-0.500)*rk(275)    *y(lO3)
          JAC(lGLY ,lACYE)= +(-0.700)*rk(534)    *y(lOH)
          JAC(lAFG1,lNO  )= +(-1.000)*rk(383)    *y(lXAF1)
          JAC(lAFG1,lO3  )= +         rk(247)    *y(lAFG1)
     &                      +(-0.350)*rk(253)    *y(lAFG3)
          JAC(lAFG1,lNO3 )= +(-1.000)*rk(385)    *y(lXAF1)
          JAC(lAFG1,lOH  )= +         rk(246)    *y(lAFG1)
          JAC(lAFG1,lMEO2)= +(-0.500)*rk(386)    *y(lXAF1)
          JAC(lAFG1,lRO2C)= +(-0.500)*rk(387)    *y(lXAF1)
          JAC(lAFG1,lRO2X)= +(-0.500)*rk(388)    *y(lXAF1)
          JAC(lAFG1,lMCO3)= +(-1.000)*rk(389)    *y(lXAF1)
          JAC(lAFG1,lRCO3)= +(-1.000)*rk(390)    *y(lXAF1)
          JAC(lAFG1,lBZC3)= +(-1.000)*rk(391)    *y(lXAF1)
          JAC(lAFG1,lMAC3)= +(-1.000)*rk(392)    *y(lXAF1)
          JAC(lAFG1,lRAPX)= +(-0.500)*rk(229)*flg
          JAC(lAFG1,lXAF1)= +(-1.000)*rk(383)    *y(lNO)
     &                      +(-1.000)*rk(385)    *y(lNO3)
     &                      +(-0.500)*rk(386)    *y(lMEO2)
     &                      +(-0.500)*rk(387)    *y(lRO2C)
     &                      +(-0.500)*rk(388)    *y(lRO2X)
     &                      +(-1.000)*rk(389)    *y(lMCO3)
     &                      +(-1.000)*rk(390)    *y(lRCO3)
     &                      +(-1.000)*rk(391)    *y(lBZC3)
     &                      +(-1.000)*rk(392)    *y(lMAC3)
          JAC(lAFG1,lAFG1)= +         rk(246)    *y(lOH)
     &                      +         rk(247)    *y(lO3)
     &                      +         rk(248)*flg
          JAC(lAFG1,lAFG3)= +(-0.350)*rk(253)    *y(lO3)
          JAC(lAFG2,lNO  )= +(-1.000)*rk(393)    *y(lXAF2)
          JAC(lAFG2,lO3  )= +         rk(250)    *y(lAFG2)
     &                      +(-0.350)*rk(253)    *y(lAFG3)
          JAC(lAFG2,lNO3 )= +(-1.000)*rk(395)    *y(lXAF2)
          JAC(lAFG2,lOH  )= +         rk(249)    *y(lAFG2)
          JAC(lAFG2,lMEO2)= +(-0.500)*rk(396)    *y(lXAF2)
          JAC(lAFG2,lRO2C)= +(-0.500)*rk(397)    *y(lXAF2)
          JAC(lAFG2,lRO2X)= +(-0.500)*rk(398)    *y(lXAF2)
          JAC(lAFG2,lMCO3)= +(-1.000)*rk(399)    *y(lXAF2)
          JAC(lAFG2,lRCO3)= +(-1.000)*rk(400)    *y(lXAF2)
          JAC(lAFG2,lBZC3)= +(-1.000)*rk(401)    *y(lXAF2)
          JAC(lAFG2,lMAC3)= +(-1.000)*rk(402)    *y(lXAF2)
          JAC(lAFG2,lRAPX)= +(-0.500)*rk(229)*flg
          JAC(lAFG2,lXAF2)= +(-1.000)*rk(393)    *y(lNO)
     &                      +(-1.000)*rk(395)    *y(lNO3)
     &                      +(-0.500)*rk(396)    *y(lMEO2)
     &                      +(-0.500)*rk(397)    *y(lRO2C)
     &                      +(-0.500)*rk(398)    *y(lRO2X)
     &                      +(-1.000)*rk(399)    *y(lMCO3)
     &                      +(-1.000)*rk(400)    *y(lRCO3)
     &                      +(-1.000)*rk(401)    *y(lBZC3)
     &                      +(-1.000)*rk(402)    *y(lMAC3)
          JAC(lAFG2,lAFG2)= +         rk(249)    *y(lOH)
     &                      +         rk(250)    *y(lO3)
     &                      +         rk(251)*flg
          JAC(lAFG2,lAFG3)= +(-0.350)*rk(253)    *y(lO3)
          JAC(lBACL,lNO  )= +(-1.000)*rk(363)    *y(lXBAC)
          JAC(lBACL,lNO3 )= +(-1.000)*rk(365)    *y(lXBAC)
          JAC(lBACL,lMEO2)= +(-0.500)*rk(366)    *y(lXBAC)
          JAC(lBACL,lRO2C)= +(-0.500)*rk(367)    *y(lXBAC)
          JAC(lBACL,lRO2X)= +(-0.500)*rk(368)    *y(lXBAC)
          JAC(lBACL,lMCO3)= +(-1.000)*rk(369)    *y(lXBAC)
          JAC(lBACL,lRCO3)= +(-1.000)*rk(370)    *y(lXBAC)
          JAC(lBACL,lBZC3)= +(-1.000)*rk(371)    *y(lXBAC)
          JAC(lBACL,lMAC3)= +(-1.000)*rk(372)    *y(lXBAC)
          JAC(lBACL,lXBAC)= +(-1.000)*rk(363)    *y(lNO)
     &                      +(-1.000)*rk(365)    *y(lNO3)
     &                      +(-0.500)*rk(366)    *y(lMEO2)
     &                      +(-0.500)*rk(367)    *y(lRO2C)
     &                      +(-0.500)*rk(368)    *y(lRO2X)
     &                      +(-1.000)*rk(369)    *y(lMCO3)
     &                      +(-1.000)*rk(370)    *y(lRCO3)
     &                      +(-1.000)*rk(371)    *y(lBZC3)
     &                      +(-1.000)*rk(372)    *y(lMAC3)
          JAC(lBACL,lBACL)= +         rk(237)*flg
          JAC(lBALD,lNO  )= +(-1.000)*rk(373)    *y(lXBAL)
          JAC(lBALD,lNO3 )= +         rk(245)    *y(lBALD)
     &                      +(-1.000)*rk(375)    *y(lXBAL)
          JAC(lBALD,lOH  )= +         rk(243)    *y(lBALD)
          JAC(lBALD,lMEO2)= +(-0.500)*rk(376)    *y(lXBAL)
          JAC(lBALD,lRO2C)= +(-0.500)*rk(377)    *y(lXBAL)
          JAC(lBALD,lRO2X)= +(-0.500)*rk(378)    *y(lXBAL)
          JAC(lBALD,lMCO3)= +(-1.000)*rk(379)    *y(lXBAL)
          JAC(lBALD,lRCO3)= +(-1.000)*rk(380)    *y(lXBAL)
          JAC(lBALD,lBZC3)= +(-1.000)*rk(381)    *y(lXBAL)
          JAC(lBALD,lMAC3)= +(-1.000)*rk(382)    *y(lXBAL)
          JAC(lBALD,lBALD)= +         rk(243)    *y(lOH)
     &                      +         rk(244)*flg
     &                      +         rk(245)    *y(lNO3)
          JAC(lBALD,lXBAL)= +(-1.000)*rk(373)    *y(lNO)
     &                      +(-1.000)*rk(375)    *y(lNO3)
     &                      +(-0.500)*rk(376)    *y(lMEO2)
     &                      +(-0.500)*rk(377)    *y(lRO2C)
     &                      +(-0.500)*rk(378)    *y(lRO2X)
     &                      +(-1.000)*rk(379)    *y(lMCO3)
     &                      +(-1.000)*rk(380)    *y(lRCO3)
     &                      +(-1.000)*rk(381)    *y(lBZC3)
     &                      +(-1.000)*rk(382)    *y(lMAC3)
          JAC(lAFG3,lNO  )= +(-1.000)*rk(403)    *y(lXAF3)
          JAC(lAFG3,lO3  )= +         rk(253)    *y(lAFG3)
     &                      +(-0.139)*rk(253)    *y(lAFG3)
          JAC(lAFG3,lNO3 )= +(-1.000)*rk(405)    *y(lXAF3)
          JAC(lAFG3,lOH  )= +         rk(252)    *y(lAFG3)
     &                      +(-0.116)*rk(536)    *y(lBENZ)
     &                      +(-0.312)*rk(537)    *y(lTOLU)
     &                      +(-0.239)*rk(538)    *y(lMXYL)
     &                      +(-0.198)*rk(539)    *y(lOXYL)
     &                      +(-0.278)*rk(540)    *y(lPXYL)
     &                      +(-0.230)*rk(541)    *y(lB124)
     &                      +(-0.202)*rk(556)    *y(lARO1)
     &                      +(-0.178)*rk(557)    *y(lARO2)
          JAC(lAFG3,lMEO2)= +(-0.500)*rk(406)    *y(lXAF3)
          JAC(lAFG3,lRO2C)= +(-0.500)*rk(407)    *y(lXAF3)
          JAC(lAFG3,lRO2X)= +(-0.500)*rk(408)    *y(lXAF3)
          JAC(lAFG3,lMCO3)= +(-1.000)*rk(409)    *y(lXAF3)
          JAC(lAFG3,lRCO3)= +(-1.000)*rk(410)    *y(lXAF3)
          JAC(lAFG3,lBZC3)= +(-1.000)*rk(411)    *y(lXAF3)
          JAC(lAFG3,lMAC3)= +(-1.000)*rk(412)    *y(lXAF3)
          JAC(lAFG3,lAFG3)= +         rk(252)    *y(lOH)
     &                      +         rk(253)    *y(lO3)
     &                      +(-0.139)*rk(253)    *y(lO3)
          JAC(lAFG3,lXAF3)= +(-1.000)*rk(403)    *y(lNO)
     &                      +(-1.000)*rk(405)    *y(lNO3)
     &                      +(-0.500)*rk(406)    *y(lMEO2)
     &                      +(-0.500)*rk(407)    *y(lRO2C)
     &                      +(-0.500)*rk(408)    *y(lRO2X)
     &                      +(-1.000)*rk(409)    *y(lMCO3)
     &                      +(-1.000)*rk(410)    *y(lRCO3)
     &                      +(-1.000)*rk(411)    *y(lBZC3)
     &                      +(-1.000)*rk(412)    *y(lMAC3)
          JAC(lAFG3,lBENZ)= +(-0.116)*rk(536)    *y(lOH)
          JAC(lAFG3,lTOLU)= +(-0.312)*rk(537)    *y(lOH)
          JAC(lAFG3,lMXYL)= +(-0.239)*rk(538)    *y(lOH)
          JAC(lAFG3,lOXYL)= +(-0.198)*rk(539)    *y(lOH)
          JAC(lAFG3,lPXYL)= +(-0.278)*rk(540)    *y(lOH)
          JAC(lAFG3,lB124)= +(-0.230)*rk(541)    *y(lOH)
          JAC(lAFG3,lARO1)= +(-0.202)*rk(556)    *y(lOH)
          JAC(lAFG3,lARO2)= +(-0.178)*rk(557)    *y(lOH)
          JAC(lXIPR,lNO  )= +         rk(433)    *y(lXIPR)
          JAC(lXIPR,lO3  )= +(-0.001)*rk(559)    *y(lTERP)
     &                      +(-0.001)*rk(563)    *y(lSESQ)
          JAC(lXIPR,lNO3 )= +         rk(435)    *y(lXIPR)
     &                      +(-0.120)*rk(524)    *y(lBD13)
     &                      +(-0.936)*rk(528)    *y(lISOP)
     &                      +(-0.004)*rk(560)    *y(lTERP)
     &                      +(-0.004)*rk(564)    *y(lSESQ)
          JAC(lXIPR,lOH  )= +(-0.231)*rk(252)    *y(lAFG3)
     &                      +(-0.471)*rk(522)    *y(lBD13)
     &                      +(-0.357)*rk(526)    *y(lISOP)
     &                      +(-0.009)*rk(548)    *y(lOLE1)
     &                      +(-0.012)*rk(552)    *y(lOLE2)
     &                      +(-0.002)*rk(558)    *y(lTERP)
     &                      +(-0.002)*rk(562)    *y(lSESQ)
          JAC(lXIPR,lHO2 )= +         rk(434)    *y(lXIPR)
          JAC(lXIPR,lMEO2)= +         rk(436)    *y(lXIPR)
          JAC(lXIPR,lRO2C)= +         rk(437)    *y(lXIPR)
          JAC(lXIPR,lRO2X)= +         rk(438)    *y(lXIPR)
          JAC(lXIPR,lMCO3)= +         rk(439)    *y(lXIPR)
          JAC(lXIPR,lRCO3)= +         rk(440)    *y(lXIPR)
          JAC(lXIPR,lBZC3)= +         rk(441)    *y(lXIPR)
          JAC(lXIPR,lMAC3)= +         rk(442)    *y(lXIPR)
          JAC(lXIPR,lAFG3)= +(-0.231)*rk(252)    *y(lOH)
          JAC(lXIPR,lXIPR)= +         rk(433)    *y(lNO)
     &                      +         rk(434)    *y(lHO2)
     &                      +         rk(435)    *y(lNO3)
     &                      +         rk(436)    *y(lMEO2)
     &                      +         rk(437)    *y(lRO2C)
     &                      +         rk(438)    *y(lRO2X)
     &                      +         rk(439)    *y(lMCO3)
     &                      +         rk(440)    *y(lRCO3)
     &                      +         rk(441)    *y(lBZC3)
          JAC(lXIPR,lXIPR)=JAC(lXIPR,lXIPR)
     &                      +         rk(442)    *y(lMAC3)
          JAC(lXIPR,lBD13)= +(-0.471)*rk(522)    *y(lOH)
     &                      +(-0.120)*rk(524)    *y(lNO3)
          JAC(lXIPR,lISOP)= +(-0.357)*rk(526)    *y(lOH)
     &                      +(-0.936)*rk(528)    *y(lNO3)
          JAC(lXIPR,lOLE1)= +(-0.009)*rk(548)    *y(lOH)
          JAC(lXIPR,lOLE2)= +(-0.012)*rk(552)    *y(lOH)
          JAC(lXIPR,lTERP)= +(-0.002)*rk(558)    *y(lOH)
     &                      +(-0.001)*rk(559)    *y(lO3)
     &                      +(-0.004)*rk(560)    *y(lNO3)
          JAC(lXIPR,lSESQ)= +(-0.002)*rk(562)    *y(lOH)
     &                      +(-0.001)*rk(563)    *y(lO3)
     &                      +(-0.004)*rk(564)    *y(lNO3)
          JAC(lMACR,lNO  )= +(-1.000)*rk(413)    *y(lXMAC)
          JAC(lMACR,lO3P )= +         rk(257)    *y(lMACR)
          JAC(lMACR,lO3  )= +(-0.003)*rk(253)    *y(lAFG3)
     &                      +         rk(255)    *y(lMACR)
     &                      +(-0.390)*rk(527)    *y(lISOP)
          JAC(lMACR,lNO3 )= +         rk(256)    *y(lMACR)
     &                      +(-1.000)*rk(415)    *y(lXMAC)
          JAC(lMACR,lOH  )= +         rk(254)    *y(lMACR)
          JAC(lMACR,lMEO2)= +(-0.500)*rk(416)    *y(lXMAC)
          JAC(lMACR,lRO2C)= +(-0.500)*rk(417)    *y(lXMAC)
          JAC(lMACR,lRO2X)= +(-0.500)*rk(418)    *y(lXMAC)
          JAC(lMACR,lMCO3)= +(-1.000)*rk(419)    *y(lXMAC)
          JAC(lMACR,lRCO3)= +(-1.000)*rk(420)    *y(lXMAC)
          JAC(lMACR,lBZC3)= +(-1.000)*rk(421)    *y(lXMAC)
          JAC(lMACR,lMAC3)= +(-1.000)*rk(422)    *y(lXMAC)
          JAC(lMACR,lAFG3)= +(-0.003)*rk(253)    *y(lO3)
          JAC(lMACR,lMACR)= +         rk(254)    *y(lOH)
     &                      +         rk(255)    *y(lO3)
     &                      +         rk(256)    *y(lNO3)
     &                      +         rk(257)    *y(lO3P)
     &                      +         rk(258)*flg
          JAC(lMACR,lXMAC)= +(-1.000)*rk(413)    *y(lNO)
     &                      +(-1.000)*rk(415)    *y(lNO3)
     &                      +(-0.500)*rk(416)    *y(lMEO2)
     &                      +(-0.500)*rk(417)    *y(lRO2C)
     &                      +(-0.500)*rk(418)    *y(lRO2X)
     &                      +(-1.000)*rk(419)    *y(lMCO3)
     &                      +(-1.000)*rk(420)    *y(lRCO3)
     &                      +(-1.000)*rk(421)    *y(lBZC3)
     &                      +(-1.000)*rk(422)    *y(lMAC3)
          JAC(lMACR,lISOP)= +(-0.390)*rk(527)    *y(lO3)
          JAC(lMVK ,lNO  )= +(-1.000)*rk(423)    *y(lXMVK)
          JAC(lMVK ,lO3P )= +         rk(261)    *y(lMVK)
          JAC(lMVK ,lO3  )= +(-0.004)*rk(253)    *y(lAFG3)
     &                      +         rk(260)    *y(lMVK)
     &                      +(-0.375)*rk(523)    *y(lBD13)
     &                      +(-0.160)*rk(527)    *y(lISOP)
          JAC(lMVK ,lNO3 )= +(-1.000)*rk(425)    *y(lXMVK)
          JAC(lMVK ,lOH  )= +         rk(259)    *y(lMVK)
          JAC(lMVK ,lMEO2)= +(-0.500)*rk(426)    *y(lXMVK)
          JAC(lMVK ,lRO2C)= +(-0.500)*rk(427)    *y(lXMVK)
          JAC(lMVK ,lRO2X)= +(-0.500)*rk(428)    *y(lXMVK)
          JAC(lMVK ,lMCO3)= +(-1.000)*rk(429)    *y(lXMVK)
          JAC(lMVK ,lRCO3)= +(-1.000)*rk(430)    *y(lXMVK)
          JAC(lMVK ,lBZC3)= +(-1.000)*rk(431)    *y(lXMVK)
          JAC(lMVK ,lMAC3)= +(-1.000)*rk(432)    *y(lXMVK)
          JAC(lMVK ,lAFG3)= +(-0.004)*rk(253)    *y(lO3)
          JAC(lMVK ,lMVK )= +         rk(259)    *y(lOH)
     &                      +         rk(260)    *y(lO3)
     &                      +         rk(261)    *y(lO3P)
     &                      +         rk(262)*flg
          JAC(lMVK ,lXMVK)= +(-1.000)*rk(423)    *y(lNO)
     &                      +(-1.000)*rk(425)    *y(lNO3)
     &                      +(-0.500)*rk(426)    *y(lMEO2)
     &                      +(-0.500)*rk(427)    *y(lRO2C)
     &                      +(-0.500)*rk(428)    *y(lRO2X)
     &                      +(-1.000)*rk(429)    *y(lMCO3)
     &                      +(-1.000)*rk(430)    *y(lRCO3)
     &                      +(-1.000)*rk(431)    *y(lBZC3)
     &                      +(-1.000)*rk(432)    *y(lMAC3)
          JAC(lMVK ,lBD13)= +(-0.375)*rk(523)    *y(lO3)
          JAC(lMVK ,lISOP)= +(-0.160)*rk(527)    *y(lO3)
          JAC(lXGLD,lNO  )= +         rk(493)    *y(lXGLD)
          JAC(lXGLD,lO3  )= +(-0.047)*rk(264)    *y(lIPRD)
          JAC(lXGLD,lNO3 )= +         rk(495)    *y(lXGLD)
     &                      +(-0.002)*rk(560)    *y(lTERP)
          JAC(lXGLD,lOH  )= +(-0.675)*rk(259)    *y(lMVK)
     &                      +(-0.129)*rk(263)    *y(lIPRD)
     &                      +(-0.195)*rk(514)    *y(lETHE)
     &                      +(-0.010)*rk(542)    *y(lETOH)
     &                      +(-0.007)*rk(548)    *y(lOLE1)
          JAC(lXGLD,lHO2 )= +         rk(494)    *y(lXGLD)
          JAC(lXGLD,lMEO2)= +         rk(496)    *y(lXGLD)
          JAC(lXGLD,lRO2C)= +         rk(497)    *y(lXGLD)
          JAC(lXGLD,lRO2X)= +         rk(498)    *y(lXGLD)
          JAC(lXGLD,lMCO3)= +         rk(499)    *y(lXGLD)
          JAC(lXGLD,lRCO3)= +         rk(500)    *y(lXGLD)
          JAC(lXGLD,lBZC3)= +         rk(501)    *y(lXGLD)
          JAC(lXGLD,lMAC3)= +         rk(502)    *y(lXGLD)
          JAC(lXGLD,lIPRD)= +(-0.129)*rk(263)    *y(lOH)
     &                      +(-0.047)*rk(264)    *y(lO3)
          JAC(lXGLD,lMVK )= +(-0.675)*rk(259)    *y(lOH)
          JAC(lXGLD,lXGLD)= +         rk(493)    *y(lNO)
     &                      +         rk(494)    *y(lHO2)
     &                      +         rk(495)    *y(lNO3)
     &                      +         rk(496)    *y(lMEO2)
     &                      +         rk(497)    *y(lRO2C)
     &                      +         rk(498)    *y(lRO2X)
     &                      +         rk(499)    *y(lMCO3)
     &                      +         rk(500)    *y(lRCO3)
     &                      +         rk(501)    *y(lBZC3)
          JAC(lXGLD,lXGLD)=JAC(lXGLD,lXGLD)
     &                      +         rk(502)    *y(lMAC3)
          JAC(lXGLD,lETHE)= +(-0.195)*rk(514)    *y(lOH)
          JAC(lXGLD,lETOH)= +(-0.010)*rk(542)    *y(lOH)
          JAC(lXGLD,lOLE1)= +(-0.007)*rk(548)    *y(lOH)
          JAC(lXGLD,lTERP)= +(-0.002)*rk(560)    *y(lNO3)
          JAC(lXRN3,lNO  )= +         rk(443)    *y(lXRN3)
          JAC(lXRN3,lNO3 )= +(-0.572)*rk(265)    *y(lIPRD)
     &                      +(-0.031)*rk(276)    *y(lACRO)
     &                      +         rk(445)    *y(lXRN3)
     &                      +(-0.355)*rk(524)    *y(lBD13)
     &                      +(-0.056)*rk(532)    *y(lAPIN)
     &                      +(-0.774)*rk(550)    *y(lOLE1)
     &                      +(-0.320)*rk(554)    *y(lOLE2)
     &                      +(-0.228)*rk(560)    *y(lTERP)
     &                      +(-0.228)*rk(564)    *y(lSESQ)
          JAC(lXRN3,lOH  )= +(-0.305)*rk(269)    *y(lRNO3)
          JAC(lXRN3,lHO2 )= +         rk(444)    *y(lXRN3)
          JAC(lXRN3,lMEO2)= +         rk(446)    *y(lXRN3)
          JAC(lXRN3,lRO2C)= +         rk(447)    *y(lXRN3)
          JAC(lXRN3,lRO2X)= +         rk(448)    *y(lXRN3)
          JAC(lXRN3,lMCO3)= +         rk(449)    *y(lXRN3)
          JAC(lXRN3,lRCO3)= +         rk(450)    *y(lXRN3)
          JAC(lXRN3,lBZC3)= +         rk(451)    *y(lXRN3)
          JAC(lXRN3,lMAC3)= +         rk(452)    *y(lXRN3)
          JAC(lXRN3,lRNO3)= +(-0.305)*rk(269)    *y(lOH)
          JAC(lXRN3,lIPRD)= +(-0.572)*rk(265)    *y(lNO3)
          JAC(lXRN3,lXRN3)= +         rk(443)    *y(lNO)
     &                      +         rk(444)    *y(lHO2)
     &                      +         rk(445)    *y(lNO3)
     &                      +         rk(446)    *y(lMEO2)
     &                      +         rk(447)    *y(lRO2C)
     &                      +         rk(448)    *y(lRO2X)
     &                      +         rk(449)    *y(lMCO3)
     &                      +         rk(450)    *y(lRCO3)
     &                      +         rk(451)    *y(lBZC3)
          JAC(lXRN3,lXRN3)=JAC(lXRN3,lXRN3)
     &                      +         rk(452)    *y(lMAC3)
          JAC(lXRN3,lACRO)= +(-0.031)*rk(276)    *y(lNO3)
          JAC(lXRN3,lBD13)= +(-0.355)*rk(524)    *y(lNO3)
          JAC(lXRN3,lAPIN)= +(-0.056)*rk(532)    *y(lNO3)
          JAC(lXRN3,lOLE1)= +(-0.774)*rk(550)    *y(lNO3)
          JAC(lXRN3,lOLE2)= +(-0.320)*rk(554)    *y(lNO3)
          JAC(lXRN3,lTERP)= +(-0.228)*rk(560)    *y(lNO3)
          JAC(lXRN3,lSESQ)= +(-0.228)*rk(564)    *y(lNO3)
          JAC(lGLYD,lNO  )= +(-1.000)*rk(493)    *y(lXGLD)
          JAC(lGLYD,lNO3 )= +         rk(273)    *y(lGLYD)
     &                      +(-1.000)*rk(495)    *y(lXGLD)
          JAC(lGLYD,lOH  )= +         rk(271)    *y(lGLYD)
          JAC(lGLYD,lMEO2)= +(-0.500)*rk(496)    *y(lXGLD)
          JAC(lGLYD,lRO2C)= +(-0.500)*rk(497)    *y(lXGLD)
          JAC(lGLYD,lRO2X)= +(-0.500)*rk(498)    *y(lXGLD)
          JAC(lGLYD,lMCO3)= +(-1.000)*rk(499)    *y(lXGLD)
          JAC(lGLYD,lRCO3)= +(-1.000)*rk(500)    *y(lXGLD)
          JAC(lGLYD,lBZC3)= +(-1.000)*rk(501)    *y(lXGLD)
          JAC(lGLYD,lMAC3)= +(-1.000)*rk(502)    *y(lXGLD)
          JAC(lGLYD,lIPRD)= +(-0.467)*rk(266)*flg
          JAC(lGLYD,lXGLD)= +(-1.000)*rk(493)    *y(lNO)
     &                      +(-1.000)*rk(495)    *y(lNO3)
     &                      +(-0.500)*rk(496)    *y(lMEO2)
     &                      +(-0.500)*rk(497)    *y(lRO2C)
     &                      +(-0.500)*rk(498)    *y(lRO2X)
     &                      +(-1.000)*rk(499)    *y(lMCO3)
     &                      +(-1.000)*rk(500)    *y(lRCO3)
     &                      +(-1.000)*rk(501)    *y(lBZC3)
     &                      +(-1.000)*rk(502)    *y(lMAC3)
          JAC(lGLYD,lGLYD)= +         rk(271)    *y(lOH)
     &                      +         rk(272)*flg
     &                      +         rk(273)    *y(lNO3)
          JAC(lXACE,lNO  )= +         rk(313)    *y(lXACE)
          JAC(lXACE,lO3  )= +(-0.345)*rk(531)    *y(lAPIN)
     &                      +(-0.003)*rk(549)    *y(lOLE1)
     &                      +(-0.057)*rk(559)    *y(lTERP)
     &                      +(-0.057)*rk(563)    *y(lSESQ)
          JAC(lXACE,lNO3 )= +         rk(315)    *y(lXACE)
     &                      +(-0.069)*rk(532)    *y(lAPIN)
     &                      +(-0.034)*rk(550)    *y(lOLE1)
     &                      +(-0.116)*rk(554)    *y(lOLE2)
     &                      +(-0.239)*rk(560)    *y(lTERP)
     &                      +(-0.239)*rk(564)    *y(lSESQ)
          JAC(lXACE,lOH  )= +(-0.004)*rk(269)    *y(lRNO3)
     &                      +(-0.034)*rk(530)    *y(lAPIN)
     &                      +(-0.704)*rk(544)    *y(lALK2)
     &                      +(-0.024)*rk(545)    *y(lALK3)
     &                      +(-0.426)*rk(546)    *y(lALK4)
     &                      +(-0.071)*rk(547)    *y(lALK5)
     &                      +(-0.007)*rk(548)    *y(lOLE1)
     &                      +(-0.144)*rk(552)    *y(lOLE2)
     &                      +(-0.037)*rk(558)    *y(lTERP)
          JAC(lXACE,lOH  )=JAC(lXACE,lOH  )
     &                      +(-0.037)*rk(562)    *y(lSESQ)
          JAC(lXACE,lHO2 )= +         rk(314)    *y(lXACE)
          JAC(lXACE,lMEO2)= +         rk(316)    *y(lXACE)
          JAC(lXACE,lRO2C)= +         rk(317)    *y(lXACE)
          JAC(lXACE,lRO2X)= +         rk(318)    *y(lXACE)
          JAC(lXACE,lMCO3)= +         rk(319)    *y(lXACE)
          JAC(lXACE,lRCO3)= +         rk(320)    *y(lXACE)
          JAC(lXACE,lBZC3)= +         rk(321)    *y(lXACE)
          JAC(lXACE,lMAC3)= +         rk(322)    *y(lXACE)
          JAC(lXACE,lRNO3)= +(-0.004)*rk(269)    *y(lOH)
     &                      +(-0.008)*rk(270)*flg
          JAC(lXACE,lXACE)= +         rk(313)    *y(lNO)
     &                      +         rk(314)    *y(lHO2)
     &                      +         rk(315)    *y(lNO3)
     &                      +         rk(316)    *y(lMEO2)
     &                      +         rk(317)    *y(lRO2C)
     &                      +         rk(318)    *y(lRO2X)
     &                      +         rk(319)    *y(lMCO3)
     &                      +         rk(320)    *y(lRCO3)
     &                      +         rk(321)    *y(lBZC3)
          JAC(lXACE,lXACE)=JAC(lXACE,lXACE)
     &                      +         rk(322)    *y(lMAC3)
          JAC(lXACE,lAPIN)= +(-0.034)*rk(530)    *y(lOH)
     &                      +(-0.345)*rk(531)    *y(lO3)
     &                      +(-0.069)*rk(532)    *y(lNO3)
          JAC(lXACE,lALK2)= +(-0.704)*rk(544)    *y(lOH)
          JAC(lXACE,lALK3)= +(-0.024)*rk(545)    *y(lOH)
          JAC(lXACE,lALK4)= +(-0.426)*rk(546)    *y(lOH)
          JAC(lXACE,lALK5)= +(-0.071)*rk(547)    *y(lOH)
          JAC(lXACE,lOLE1)= +(-0.007)*rk(548)    *y(lOH)
     &                      +(-0.003)*rk(549)    *y(lO3)
     &                      +(-0.034)*rk(550)    *y(lNO3)
          JAC(lXACE,lOLE2)= +(-0.144)*rk(552)    *y(lOH)
     &                      +(-0.116)*rk(554)    *y(lNO3)
          JAC(lXACE,lTERP)= +(-0.037)*rk(558)    *y(lOH)
     &                      +(-0.057)*rk(559)    *y(lO3)
     &                      +(-0.239)*rk(560)    *y(lNO3)
          JAC(lXACE,lSESQ)= +(-0.037)*rk(562)    *y(lOH)
     &                      +(-0.057)*rk(563)    *y(lO3)
     &                      +(-0.239)*rk(564)    *y(lNO3)
          JAC(lACRO,lNO  )= +(-1.000)*rk(503)    *y(lXACR)
          JAC(lACRO,lO3P )= +         rk(277)    *y(lACRO)
          JAC(lACRO,lO3  )= +         rk(275)    *y(lACRO)
     &                      +(-0.500)*rk(523)    *y(lBD13)
          JAC(lACRO,lNO3 )= +         rk(276)    *y(lACRO)
     &                      +(-1.000)*rk(505)    *y(lXACR)
          JAC(lACRO,lOH  )= +         rk(274)    *y(lACRO)
          JAC(lACRO,lMEO2)= +(-0.500)*rk(506)    *y(lXACR)
          JAC(lACRO,lRO2C)= +(-0.500)*rk(507)    *y(lXACR)
          JAC(lACRO,lRO2X)= +(-0.500)*rk(508)    *y(lXACR)
          JAC(lACRO,lMCO3)= +(-1.000)*rk(509)    *y(lXACR)
          JAC(lACRO,lRCO3)= +(-1.000)*rk(510)    *y(lXACR)
          JAC(lACRO,lBZC3)= +(-1.000)*rk(511)    *y(lXACR)
          JAC(lACRO,lMAC3)= +(-1.000)*rk(512)    *y(lXACR)
          JAC(lACRO,lACRO)= +         rk(274)    *y(lOH)
     &                      +         rk(275)    *y(lO3)
     &                      +         rk(276)    *y(lNO3)
     &                      +         rk(277)    *y(lO3P)
     &                      +         rk(278)*flg
          JAC(lACRO,lXACR)= +(-1.000)*rk(503)    *y(lNO)
     &                      +(-1.000)*rk(505)    *y(lNO3)
     &                      +(-0.500)*rk(506)    *y(lMEO2)
     &                      +(-0.500)*rk(507)    *y(lRO2C)
     &                      +(-0.500)*rk(508)    *y(lRO2X)
     &                      +(-1.000)*rk(509)    *y(lMCO3)
     &                      +(-1.000)*rk(510)    *y(lRCO3)
     &                      +(-1.000)*rk(511)    *y(lBZC3)
     &                      +(-1.000)*rk(512)    *y(lMAC3)
          JAC(lACRO,lBD13)= +(-0.500)*rk(523)    *y(lO3)
          JAC(lXBAL,lNO  )= +         rk(373)    *y(lXBAL)
          JAC(lXBAL,lNO3 )= +         rk(375)    *y(lXBAL)
          JAC(lXBAL,lOH  )= +(-0.065)*rk(537)    *y(lTOLU)
     &                      +(-0.041)*rk(538)    *y(lMXYL)
     &                      +(-0.047)*rk(539)    *y(lOXYL)
     &                      +(-0.088)*rk(540)    *y(lPXYL)
     &                      +(-0.036)*rk(541)    *y(lB124)
     &                      +(-0.026)*rk(557)    *y(lARO2)
          JAC(lXBAL,lHO2 )= +         rk(374)    *y(lXBAL)
          JAC(lXBAL,lMEO2)= +         rk(376)    *y(lXBAL)
          JAC(lXBAL,lRO2C)= +         rk(377)    *y(lXBAL)
          JAC(lXBAL,lRO2X)= +         rk(378)    *y(lXBAL)
          JAC(lXBAL,lMCO3)= +         rk(379)    *y(lXBAL)
          JAC(lXBAL,lRCO3)= +         rk(380)    *y(lXBAL)
          JAC(lXBAL,lBZC3)= +         rk(381)    *y(lXBAL)
          JAC(lXBAL,lMAC3)= +         rk(382)    *y(lXBAL)
          JAC(lXBAL,lXBAL)= +         rk(373)    *y(lNO)
     &                      +         rk(374)    *y(lHO2)
     &                      +         rk(375)    *y(lNO3)
     &                      +         rk(376)    *y(lMEO2)
     &                      +         rk(377)    *y(lRO2C)
     &                      +         rk(378)    *y(lRO2X)
     &                      +         rk(379)    *y(lMCO3)
     &                      +         rk(380)    *y(lRCO3)
     &                      +         rk(381)    *y(lBZC3)
          JAC(lXBAL,lXBAL)=JAC(lXBAL,lXBAL)
     &                      +         rk(382)    *y(lMAC3)
          JAC(lXBAL,lTOLU)= +(-0.065)*rk(537)    *y(lOH)
          JAC(lXBAL,lMXYL)= +(-0.041)*rk(538)    *y(lOH)
          JAC(lXBAL,lOXYL)= +(-0.047)*rk(539)    *y(lOH)
          JAC(lXBAL,lPXYL)= +(-0.088)*rk(540)    *y(lOH)
          JAC(lXBAL,lB124)= +(-0.036)*rk(541)    *y(lOH)
          JAC(lXBAL,lARO2)= +(-0.026)*rk(557)    *y(lOH)
          JAC(lXAF3,lNO  )= +         rk(403)    *y(lXAF3)
          JAC(lXAF3,lNO3 )= +         rk(405)    *y(lXAF3)
          JAC(lXAF3,lOH  )= +(-0.286)*rk(540)    *y(lPXYL)
     &                      +(-0.151)*rk(541)    *y(lB124)
     &                      +(-0.068)*rk(557)    *y(lARO2)
          JAC(lXAF3,lHO2 )= +         rk(404)    *y(lXAF3)
          JAC(lXAF3,lMEO2)= +         rk(406)    *y(lXAF3)
          JAC(lXAF3,lRO2C)= +         rk(407)    *y(lXAF3)
          JAC(lXAF3,lRO2X)= +         rk(408)    *y(lXAF3)
          JAC(lXAF3,lMCO3)= +         rk(409)    *y(lXAF3)
          JAC(lXAF3,lRCO3)= +         rk(410)    *y(lXAF3)
          JAC(lXAF3,lBZC3)= +         rk(411)    *y(lXAF3)
          JAC(lXAF3,lMAC3)= +         rk(412)    *y(lXAF3)
          JAC(lXAF3,lXAF3)= +         rk(403)    *y(lNO)
     &                      +         rk(404)    *y(lHO2)
     &                      +         rk(405)    *y(lNO3)
     &                      +         rk(406)    *y(lMEO2)
     &                      +         rk(407)    *y(lRO2C)
     &                      +         rk(408)    *y(lRO2X)
     &                      +         rk(409)    *y(lMCO3)
     &                      +         rk(410)    *y(lRCO3)
     &                      +         rk(411)    *y(lBZC3)
          JAC(lXAF3,lXAF3)=JAC(lXAF3,lXAF3)
     &                      +         rk(412)    *y(lMAC3)
          JAC(lXAF3,lPXYL)= +(-0.286)*rk(540)    *y(lOH)
          JAC(lXAF3,lB124)= +(-0.151)*rk(541)    *y(lOH)
          JAC(lXAF3,lARO2)= +(-0.068)*rk(557)    *y(lOH)
          JAC(lXMAC,lNO  )= +         rk(413)    *y(lXMAC)
          JAC(lXMAC,lO3  )= +(-0.002)*rk(559)    *y(lTERP)
     &                      +(-0.002)*rk(563)    *y(lSESQ)
          JAC(lXMAC,lNO3 )= +         rk(415)    *y(lXMAC)
     &                      +(-0.005)*rk(560)    *y(lTERP)
     &                      +(-0.005)*rk(564)    *y(lSESQ)
          JAC(lXMAC,lOH  )= +(-0.230)*rk(526)    *y(lISOP)
     &                      +(-0.001)*rk(548)    *y(lOLE1)
          JAC(lXMAC,lHO2 )= +         rk(414)    *y(lXMAC)
          JAC(lXMAC,lMEO2)= +         rk(416)    *y(lXMAC)
          JAC(lXMAC,lRO2C)= +         rk(417)    *y(lXMAC)
          JAC(lXMAC,lRO2X)= +         rk(418)    *y(lXMAC)
          JAC(lXMAC,lMCO3)= +         rk(419)    *y(lXMAC)
          JAC(lXMAC,lRCO3)= +         rk(420)    *y(lXMAC)
          JAC(lXMAC,lBZC3)= +         rk(421)    *y(lXMAC)
          JAC(lXMAC,lMAC3)= +         rk(422)    *y(lXMAC)
          JAC(lXMAC,lXMAC)= +         rk(413)    *y(lNO)
     &                      +         rk(414)    *y(lHO2)
     &                      +         rk(415)    *y(lNO3)
     &                      +         rk(416)    *y(lMEO2)
     &                      +         rk(417)    *y(lRO2C)
     &                      +         rk(418)    *y(lRO2X)
     &                      +         rk(419)    *y(lMCO3)
     &                      +         rk(420)    *y(lRCO3)
     &                      +         rk(421)    *y(lBZC3)
          JAC(lXMAC,lXMAC)=JAC(lXMAC,lXMAC)
     &                      +         rk(422)    *y(lMAC3)
          JAC(lXMAC,lISOP)= +(-0.230)*rk(526)    *y(lOH)
          JAC(lXMAC,lOLE1)= +(-0.001)*rk(548)    *y(lOH)
          JAC(lXMAC,lTERP)= +(-0.002)*rk(559)    *y(lO3)
     &                      +(-0.005)*rk(560)    *y(lNO3)
          JAC(lXMAC,lSESQ)= +(-0.002)*rk(563)    *y(lO3)
     &                      +(-0.005)*rk(564)    *y(lNO3)
          JAC(lXMVK,lNO  )= +         rk(423)    *y(lXMVK)
          JAC(lXMVK,lNO3 )= +         rk(425)    *y(lXMVK)
     &                      +(-0.460)*rk(524)    *y(lBD13)
     &                      +(-0.001)*rk(560)    *y(lTERP)
     &                      +(-0.001)*rk(564)    *y(lSESQ)
          JAC(lXMVK,lOH  )= +(-0.320)*rk(526)    *y(lISOP)
     &                      +(-0.012)*rk(548)    *y(lOLE1)
     &                      +(-0.002)*rk(552)    *y(lOLE2)
     &                      +(-0.003)*rk(558)    *y(lTERP)
     &                      +(-0.003)*rk(562)    *y(lSESQ)
          JAC(lXMVK,lHO2 )= +         rk(424)    *y(lXMVK)
          JAC(lXMVK,lMEO2)= +         rk(426)    *y(lXMVK)
          JAC(lXMVK,lRO2C)= +         rk(427)    *y(lXMVK)
          JAC(lXMVK,lRO2X)= +         rk(428)    *y(lXMVK)
          JAC(lXMVK,lMCO3)= +         rk(429)    *y(lXMVK)
          JAC(lXMVK,lRCO3)= +         rk(430)    *y(lXMVK)
          JAC(lXMVK,lBZC3)= +         rk(431)    *y(lXMVK)
          JAC(lXMVK,lMAC3)= +         rk(432)    *y(lXMVK)
          JAC(lXMVK,lXMVK)= +         rk(423)    *y(lNO)
     &                      +         rk(424)    *y(lHO2)
     &                      +         rk(425)    *y(lNO3)
     &                      +         rk(426)    *y(lMEO2)
     &                      +         rk(427)    *y(lRO2C)
     &                      +         rk(428)    *y(lRO2X)
     &                      +         rk(429)    *y(lMCO3)
     &                      +         rk(430)    *y(lRCO3)
     &                      +         rk(431)    *y(lBZC3)
          JAC(lXMVK,lXMVK)=JAC(lXMVK,lXMVK)
     &                      +         rk(432)    *y(lMAC3)
          JAC(lXMVK,lBD13)= +(-0.460)*rk(524)    *y(lNO3)
          JAC(lXMVK,lISOP)= +(-0.320)*rk(526)    *y(lOH)
          JAC(lXMVK,lOLE1)= +(-0.012)*rk(548)    *y(lOH)
          JAC(lXMVK,lOLE2)= +(-0.002)*rk(552)    *y(lOH)
          JAC(lXMVK,lTERP)= +(-0.003)*rk(558)    *y(lOH)
     &                      +(-0.001)*rk(560)    *y(lNO3)
          JAC(lXMVK,lSESQ)= +(-0.003)*rk(562)    *y(lOH)
     &                      +(-0.001)*rk(564)    *y(lNO3)
          JAC(lYAPX,lNO  )= +         rk(473)    *y(lYAPX)
          JAC(lYAPX,lNO3 )= +         rk(475)    *y(lYAPX)
          JAC(lYAPX,lOH  )= +(-0.314)*rk(536)    *y(lBENZ)
     &                      +(-0.435)*rk(537)    *y(lTOLU)
     &                      +(-0.555)*rk(538)    *y(lMXYL)
     &                      +(-0.586)*rk(539)    *y(lOXYL)
     &                      +(-0.461)*rk(540)    *y(lPXYL)
     &                      +(-0.705)*rk(541)    *y(lB124)
          JAC(lYAPX,lHO2 )= +         rk(474)    *y(lYAPX)
          JAC(lYAPX,lMEO2)= +         rk(476)    *y(lYAPX)
          JAC(lYAPX,lRO2C)= +         rk(477)    *y(lYAPX)
          JAC(lYAPX,lRO2X)= +         rk(478)    *y(lYAPX)
          JAC(lYAPX,lMCO3)= +         rk(479)    *y(lYAPX)
          JAC(lYAPX,lRCO3)= +         rk(480)    *y(lYAPX)
          JAC(lYAPX,lBZC3)= +         rk(481)    *y(lYAPX)
          JAC(lYAPX,lMAC3)= +         rk(482)    *y(lYAPX)
          JAC(lYAPX,lYAPX)= +         rk(473)    *y(lNO)
     &                      +         rk(474)    *y(lHO2)
     &                      +         rk(475)    *y(lNO3)
     &                      +         rk(476)    *y(lMEO2)
     &                      +         rk(477)    *y(lRO2C)
     &                      +         rk(478)    *y(lRO2X)
     &                      +         rk(479)    *y(lMCO3)
     &                      +         rk(480)    *y(lRCO3)
     &                      +         rk(481)    *y(lBZC3)
          JAC(lYAPX,lYAPX)=JAC(lYAPX,lYAPX)
     &                      +         rk(482)    *y(lMAC3)
          JAC(lYAPX,lBENZ)= +(-0.314)*rk(536)    *y(lOH)
          JAC(lYAPX,lTOLU)= +(-0.435)*rk(537)    *y(lOH)
          JAC(lYAPX,lMXYL)= +(-0.555)*rk(538)    *y(lOH)
          JAC(lYAPX,lOXYL)= +(-0.586)*rk(539)    *y(lOH)
          JAC(lYAPX,lPXYL)= +(-0.461)*rk(540)    *y(lOH)
          JAC(lYAPX,lB124)= +(-0.705)*rk(541)    *y(lOH)
          JAC(lXACR,lNO  )= +         rk(503)    *y(lXACR)
          JAC(lXACR,lO3P )= +(-0.115)*rk(525)    *y(lBD13)
          JAC(lXACR,lNO3 )= +         rk(505)    *y(lXACR)
          JAC(lXACR,lOH  )= +(-0.480)*rk(522)    *y(lBD13)
     &                      +(-0.036)*rk(548)    *y(lOLE1)
          JAC(lXACR,lHO2 )= +         rk(504)    *y(lXACR)
          JAC(lXACR,lMEO2)= +         rk(506)    *y(lXACR)
          JAC(lXACR,lRO2C)= +         rk(507)    *y(lXACR)
          JAC(lXACR,lRO2X)= +         rk(508)    *y(lXACR)
          JAC(lXACR,lMCO3)= +         rk(509)    *y(lXACR)
          JAC(lXACR,lRCO3)= +         rk(510)    *y(lXACR)
          JAC(lXACR,lBZC3)= +         rk(511)    *y(lXACR)
          JAC(lXACR,lMAC3)= +         rk(512)    *y(lXACR)
          JAC(lXACR,lXACR)= +         rk(503)    *y(lNO)
     &                      +         rk(504)    *y(lHO2)
     &                      +         rk(505)    *y(lNO3)
     &                      +         rk(506)    *y(lMEO2)
     &                      +         rk(507)    *y(lRO2C)
     &                      +         rk(508)    *y(lRO2X)
     &                      +         rk(509)    *y(lMCO3)
     &                      +         rk(510)    *y(lRCO3)
     &                      +         rk(511)    *y(lBZC3)
          JAC(lXACR,lXACR)=JAC(lXACR,lXACR)
     &                      +         rk(512)    *y(lMAC3)
          JAC(lXACR,lBD13)= +(-0.480)*rk(522)    *y(lOH)
     &                      +(-0.115)*rk(525)    *y(lO3P)
          JAC(lXACR,lOLE1)= +(-0.036)*rk(548)    *y(lOH)
          JAC(lETHE,lO3P )= +         rk(517)    *y(lETHE)
          JAC(lETHE,lO3  )= +         rk(515)    *y(lETHE)
          JAC(lETHE,lNO3 )= +         rk(516)    *y(lETHE)
          JAC(lETHE,lOH  )= +         rk(514)    *y(lETHE)
          JAC(lETHE,lETHE)= +         rk(514)    *y(lOH)
     &                      +         rk(515)    *y(lO3)
     &                      +         rk(516)    *y(lNO3)
     &                      +         rk(517)    *y(lO3P)
          JAC(lPRPE,lO3P )= +         rk(521)    *y(lPRPE)
          JAC(lPRPE,lO3  )= +         rk(519)    *y(lPRPE)
          JAC(lPRPE,lNO3 )= +         rk(520)    *y(lPRPE)
          JAC(lPRPE,lOH  )= +         rk(518)    *y(lPRPE)
          JAC(lPRPE,lPRPE)= +         rk(518)    *y(lOH)
     &                      +         rk(519)    *y(lO3)
     &                      +         rk(520)    *y(lNO3)
     &                      +         rk(521)    *y(lO3P)
          JAC(lBD13,lO3P )= +         rk(525)    *y(lBD13)
          JAC(lBD13,lO3  )= +         rk(523)    *y(lBD13)
          JAC(lBD13,lNO3 )= +         rk(524)    *y(lBD13)
          JAC(lBD13,lOH  )= +         rk(522)    *y(lBD13)
          JAC(lBD13,lBD13)= +         rk(522)    *y(lOH)
     &                      +         rk(523)    *y(lO3)
     &                      +         rk(524)    *y(lNO3)
     &                      +         rk(525)    *y(lO3P)
          JAC(lISOP,lO3P )= +         rk(529)    *y(lISOP)
          JAC(lISOP,lO3  )= +         rk(527)    *y(lISOP)
          JAC(lISOP,lNO3 )= +         rk(528)    *y(lISOP)
          JAC(lISOP,lOH  )= +         rk(526)    *y(lISOP)
          JAC(lISOP,lISOP)= +         rk(526)    *y(lOH)
     &                      +         rk(527)    *y(lO3)
     &                      +         rk(528)    *y(lNO3)
     &                      +         rk(529)    *y(lO3P)
          JAC(lAPIN,lO3P )= +         rk(533)    *y(lAPIN)
          JAC(lAPIN,lO3  )= +         rk(531)    *y(lAPIN)
          JAC(lAPIN,lNO3 )= +         rk(532)    *y(lAPIN)
          JAC(lAPIN,lOH  )= +         rk(530)    *y(lAPIN)
          JAC(lAPIN,lAPIN)= +         rk(530)    *y(lOH)
     &                      +         rk(531)    *y(lO3)
     &                      +         rk(532)    *y(lNO3)
     &                      +         rk(533)    *y(lO3P)
          JAC(lACYE,lO3  )= +         rk(535)    *y(lACYE)
          JAC(lACYE,lOH  )= +         rk(534)    *y(lACYE)
          JAC(lACYE,lACYE)= +         rk(534)    *y(lOH)
     &                      +         rk(535)    *y(lO3)
          JAC(lBENZ,lOH  )= +         rk(536)    *y(lBENZ)
          JAC(lBENZ,lBENZ)= +         rk(536)    *y(lOH)
          JAC(lTOLU,lOH  )= +         rk(537)    *y(lTOLU)
          JAC(lTOLU,lTOLU)= +         rk(537)    *y(lOH)
          JAC(lMXYL,lOH  )= +         rk(538)    *y(lMXYL)
          JAC(lMXYL,lMXYL)= +         rk(538)    *y(lOH)
          JAC(lOXYL,lOH  )= +         rk(539)    *y(lOXYL)
          JAC(lOXYL,lOXYL)= +         rk(539)    *y(lOH)
          JAC(lPXYL,lOH  )= +         rk(540)    *y(lPXYL)
          JAC(lPXYL,lPXYL)= +         rk(540)    *y(lOH)
          JAC(lB124,lOH  )= +         rk(541)    *y(lB124)
          JAC(lB124,lB124)= +         rk(541)    *y(lOH)
          JAC(lETOH,lOH  )= +         rk(542)    *y(lETOH)
          JAC(lETOH,lETOH)= +         rk(542)    *y(lOH)
          JAC(lALK1,lOH  )= +         rk(543)    *y(lALK1)
          JAC(lALK1,lALK1)= +         rk(543)    *y(lOH)
          JAC(lALK2,lOH  )= +         rk(544)    *y(lALK2)
          JAC(lALK2,lALK2)= +         rk(544)    *y(lOH)
          JAC(lALK3,lOH  )= +         rk(545)    *y(lALK3)
          JAC(lALK3,lALK3)= +         rk(545)    *y(lOH)
          JAC(lALK4,lOH  )= +         rk(546)    *y(lALK4)
          JAC(lALK4,lALK4)= +         rk(546)    *y(lOH)
          JAC(lALK5,lOH  )= +         rk(547)    *y(lALK5)
          JAC(lALK5,lALK5)= +         rk(547)    *y(lOH)
          JAC(lOLE1,lO3P )= +         rk(551)    *y(lOLE1)
          JAC(lOLE1,lO3  )= +         rk(549)    *y(lOLE1)
          JAC(lOLE1,lNO3 )= +         rk(550)    *y(lOLE1)
          JAC(lOLE1,lOH  )= +         rk(548)    *y(lOLE1)
          JAC(lOLE1,lOLE1)= +         rk(548)    *y(lOH)
     &                      +         rk(549)    *y(lO3)
     &                      +         rk(550)    *y(lNO3)
     &                      +         rk(551)    *y(lO3P)
          JAC(lOLE2,lO3P )= +         rk(555)    *y(lOLE2)
          JAC(lOLE2,lO3  )= +         rk(553)    *y(lOLE2)
          JAC(lOLE2,lNO3 )= +         rk(554)    *y(lOLE2)
          JAC(lOLE2,lOH  )= +         rk(552)    *y(lOLE2)
          JAC(lOLE2,lOLE2)= +         rk(552)    *y(lOH)
     &                      +         rk(553)    *y(lO3)
     &                      +         rk(554)    *y(lNO3)
     &                      +         rk(555)    *y(lO3P)
          JAC(lARO1,lOH  )= +         rk(556)    *y(lARO1)
          JAC(lARO1,lARO1)= +         rk(556)    *y(lOH)
          JAC(lARO2,lOH  )= +         rk(557)    *y(lARO2)
          JAC(lARO2,lARO2)= +         rk(557)    *y(lOH)
          JAC(lTERP,lO3P )= +         rk(561)    *y(lTERP)
          JAC(lTERP,lO3  )= +         rk(559)    *y(lTERP)
          JAC(lTERP,lNO3 )= +         rk(560)    *y(lTERP)
          JAC(lTERP,lOH  )= +         rk(558)    *y(lTERP)
          JAC(lTERP,lTERP)= +         rk(558)    *y(lOH)
     &                      +         rk(559)    *y(lO3)
     &                      +         rk(560)    *y(lNO3)
     &                      +         rk(561)    *y(lO3P)
          JAC(lSESQ,lO3P )= +         rk(565)    *y(lSESQ)
          JAC(lSESQ,lO3  )= +         rk(563)    *y(lSESQ)
          JAC(lSESQ,lNO3 )= +         rk(564)    *y(lSESQ)
          JAC(lSESQ,lOH  )= +         rk(562)    *y(lSESQ)
          JAC(lSESQ,lSESQ)= +         rk(562)    *y(lOH)
     &                      +         rk(563)    *y(lO3)
     &                      +         rk(564)    *y(lNO3)
     &                      +         rk(565)    *y(lO3P)
c
      do j=1,njac
        do i=1,njac
          jac(i,j) = -jac(i,j)
        enddo
      enddo
c
      return
c
      end
