      subroutine lsrxn3(H2O,M,O2,CH4,H2,y,dbrk,r)
      implicit none
c
c----CAMx v7Beta2 190506
c
c     LSRXN3 computes double precision fluxes for each reaction
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        none
c
c     Called by:
c        LSRATE3
c
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
      double precision H2O, M, O2, CH4, H2, N2
      double precision y(*)
      double precision dbrk(*)
      double precision r(*)
c
c --- Entry point
c
      N2  = M - O2
      r(  1) = dbrk(  1)*y(lNO2)
      r(  2) = dbrk(  2)*y(lO)*O2*M
      r(  3) = dbrk(  3)*y(lO3)*y(lNO)
      r(  4) = dbrk(  4)*y(lO)*y(lNO)*M
      r(  5) = dbrk(  5)*y(lO)*y(lNO2)
      r(  6) = dbrk(  6)*y(lO)*y(lNO2)
      r(  7) = dbrk(  7)*y(lO)*y(lO3)
      r(  8) = dbrk(  8)*y(lO3)
      r(  9) = dbrk(  9)*y(lO3)
      r( 10) = dbrk( 10)*y(lO1D)*M
      r( 11) = dbrk( 11)*y(lO1D)*H2O
      r( 12) = dbrk( 12)*y(lO3)*y(lOH)
      r( 13) = dbrk( 13)*y(lO3)*y(lHO2)
      r( 14) = dbrk( 14)*y(lOH)*y(lO)
      r( 15) = dbrk( 15)*y(lHO2)*y(lO)
      r( 16) = dbrk( 16)*y(lOH)*y(lOH)
      r( 17) = dbrk( 17)*y(lOH)*y(lOH)
      r( 18) = dbrk( 18)*y(lOH)*y(lHO2)
      r( 19) = dbrk( 19)*y(lHO2)*y(lHO2)
      r( 20) = dbrk( 20)*y(lHO2)*y(lHO2)*H2O
      r( 21) = dbrk( 21)*y(lH2O2)
      r( 22) = dbrk( 22)*y(lH2O2)*y(lOH)
      r( 23) = dbrk( 23)*y(lH2O2)*y(lO)
      r( 24) = dbrk( 24)*y(lNO)*y(lNO)*O2
      r( 25) = dbrk( 25)*y(lHO2)*y(lNO)
      r( 26) = dbrk( 26)*y(lNO2)*y(lO3)
      r( 27) = dbrk( 27)*y(lNO3)
      r( 28) = dbrk( 28)*y(lNO3)
      r( 29) = dbrk( 29)*y(lNO3)*y(lNO)
      r( 30) = dbrk( 30)*y(lNO3)*y(lNO2)
      r( 31) = dbrk( 31)*y(lNO3)*y(lO)
      r( 32) = dbrk( 32)*y(lNO3)*y(lOH)
      r( 33) = dbrk( 33)*y(lNO3)*y(lHO2)
      r( 34) = dbrk( 34)*y(lNO3)*y(lO3)
      r( 35) = dbrk( 35)*y(lNO3)*y(lNO3)
      r( 36) = dbrk( 36)*y(lNO3)*y(lNO2)
      r( 37) = dbrk( 37)*y(lN2O5)
      r( 38) = dbrk( 38)*y(lN2O5)
      r( 39) = dbrk( 39)*y(lN2O5)*H2O
      r( 40) = dbrk( 40)*y(lNO)*y(lOH)
      r( 41) = dbrk( 41)*y(lNO)*y(lNO2)*H2O
      r( 42) = dbrk( 42)*y(lHONO)*y(lHONO)
      r( 43) = dbrk( 43)*y(lHONO)
      r( 44) = dbrk( 44)*y(lHONO)*y(lOH)
      r( 45) = dbrk( 45)*y(lNO2)*y(lOH)
      r( 46) = dbrk( 46)*y(lHNO3)*y(lOH)
      r( 47) = dbrk( 47)*y(lHNO3)
      r( 48) = dbrk( 48)*y(lHO2)*y(lNO2)
      r( 49) = dbrk( 49)*y(lPNA)
      r( 50) = dbrk( 50)*y(lPNA)
      r( 51) = dbrk( 51)*y(lPNA)*y(lOH)
      r( 52) = dbrk( 52)*y(lSO2)*y(lOH)
      r( 53) = dbrk( 53)*y(lC2O3)*y(lNO)
      r( 54) = dbrk( 54)*y(lC2O3)*y(lNO2)
      r( 55) = dbrk( 55)*y(lPAN)
      r( 56) = dbrk( 56)*y(lPAN)
      r( 57) = dbrk( 57)*y(lC2O3)*y(lHO2)
      r( 58) = dbrk( 58)*y(lC2O3)*y(lRO2)
      r( 59) = dbrk( 59)*y(lC2O3)*y(lC2O3)
      r( 60) = dbrk( 60)*y(lC2O3)*y(lCXO3)
      r( 61) = dbrk( 61)*y(lCXO3)*y(lNO)
      r( 62) = dbrk( 62)*y(lCXO3)*y(lNO2)
      r( 63) = dbrk( 63)*y(lPANX)
      r( 64) = dbrk( 64)*y(lPANX)
      r( 65) = dbrk( 65)*y(lCXO3)*y(lHO2)
      r( 66) = dbrk( 66)*y(lCXO3)*y(lRO2)
      r( 67) = dbrk( 67)*y(lCXO3)*y(lCXO3)
      r( 68) = dbrk( 68)*y(lRO2)*y(lNO)
      r( 69) = dbrk( 69)*y(lRO2)*y(lHO2)
      r( 70) = dbrk( 70)*y(lRO2)*y(lRO2)
      r( 71) = dbrk( 71)*y(lMEO2)*y(lNO)
      r( 72) = dbrk( 72)*y(lMEO2)*y(lHO2)
      r( 73) = dbrk( 73)*y(lMEO2)*y(lC2O3)
      r( 74) = dbrk( 74)*y(lMEO2)*y(lRO2)
      r( 75) = dbrk( 75)*y(lXO2H)*y(lNO)
      r( 76) = dbrk( 76)*y(lXO2H)*y(lHO2)
      r( 77) = dbrk( 77)*y(lXO2H)*y(lC2O3)
      r( 78) = dbrk( 78)*y(lXO2H)*y(lRO2)
      r( 79) = dbrk( 79)*y(lXO2)*y(lNO)
      r( 80) = dbrk( 80)*y(lXO2)*y(lHO2)
      r( 81) = dbrk( 81)*y(lXO2)*y(lC2O3)
      r( 82) = dbrk( 82)*y(lXO2)*y(lRO2)
      r( 83) = dbrk( 83)*y(lXO2N)*y(lNO)
      r( 84) = dbrk( 84)*y(lXO2N)*y(lHO2)
      r( 85) = dbrk( 85)*y(lXO2N)*y(lC2O3)
      r( 86) = dbrk( 86)*y(lXO2N)*y(lRO2)
      r( 87) = dbrk( 87)*y(lMEPX)*y(lOH)
      r( 88) = dbrk( 88)*y(lMEPX)
      r( 89) = dbrk( 89)*y(lROOH)*y(lOH)
      r( 90) = dbrk( 90)*y(lROOH)
      r( 91) = dbrk( 91)*y(lNTR1)*y(lOH)
      r( 92) = dbrk( 92)*y(lNTR1)
      r( 93) = dbrk( 93)*y(lFACD)*y(lOH)
      r( 94) = dbrk( 94)*y(lAACD)*y(lOH)
      r( 95) = dbrk( 95)*y(lPACD)*y(lOH)
      r( 96) = dbrk( 96)*y(lFORM)*y(lOH)
      r( 97) = dbrk( 97)*y(lFORM)
      r( 98) = dbrk( 98)*y(lFORM)
      r( 99) = dbrk( 99)*y(lFORM)*y(lO)
      r(100) = dbrk(100)*y(lFORM)*y(lNO3)
      r(101) = dbrk(101)*y(lFORM)*y(lHO2)
      r(102) = dbrk(102)*y(lHCO3)
      r(103) = dbrk(103)*y(lHCO3)*y(lNO)
      r(104) = dbrk(104)*y(lHCO3)*y(lHO2)
      r(105) = dbrk(105)*y(lALD2)*y(lO)
      r(106) = dbrk(106)*y(lALD2)*y(lOH)
      r(107) = dbrk(107)*y(lALD2)*y(lNO3)
      r(108) = dbrk(108)*y(lALD2)
      r(109) = dbrk(109)*y(lALDX)*y(lO)
      r(110) = dbrk(110)*y(lALDX)*y(lOH)
      r(111) = dbrk(111)*y(lALDX)*y(lNO3)
      r(112) = dbrk(112)*y(lALDX)
      r(113) = dbrk(113)*y(lGLYD)*y(lOH)
      r(114) = dbrk(114)*y(lGLYD)
      r(115) = dbrk(115)*y(lGLYD)*y(lNO3)
      r(116) = dbrk(116)*y(lGLY)*y(lOH)
      r(117) = dbrk(117)*y(lGLY)
      r(118) = dbrk(118)*y(lGLY)*y(lNO3)
      r(119) = dbrk(119)*y(lMGLY)
      r(120) = dbrk(120)*y(lMGLY)*y(lNO3)
      r(121) = dbrk(121)*y(lMGLY)*y(lOH)
      r(122) = dbrk(122)*H2*y(lOH)
      r(123) = dbrk(123)*y(lCO)*y(lOH)
      r(124) = dbrk(124)*CH4*y(lOH)
      r(125) = dbrk(125)*y(lETHA)*y(lOH)
      r(126) = dbrk(126)*y(lMEOH)*y(lOH)
      r(127) = dbrk(127)*y(lETOH)*y(lOH)
      r(128) = dbrk(128)*y(lKET)
      r(129) = dbrk(129)*y(lACET)
      r(130) = dbrk(130)*y(lACET)*y(lOH)
      r(131) = dbrk(131)*y(lPRPA)*y(lOH)
      r(132) = dbrk(132)*y(lPAR)*y(lOH)
      r(133) = dbrk(133)*y(lROR)
      r(134) = dbrk(134)*y(lROR)*O2
      r(135) = dbrk(135)*y(lROR)*y(lNO2)
      r(136) = dbrk(136)*y(lETHY)*y(lOH)
      r(137) = dbrk(137)*y(lETH)*y(lO)
      r(138) = dbrk(138)*y(lETH)*y(lOH)
      r(139) = dbrk(139)*y(lETH)*y(lO3)
      r(140) = dbrk(140)*y(lETH)*y(lNO3)
      r(141) = dbrk(141)*y(lOLE)*y(lO)
      r(142) = dbrk(142)*y(lOLE)*y(lOH)
      r(143) = dbrk(143)*y(lOLE)*y(lO3)
      r(144) = dbrk(144)*y(lOLE)*y(lNO3)
      r(145) = dbrk(145)*y(lIOLE)*y(lO)
      r(146) = dbrk(146)*y(lIOLE)*y(lOH)
      r(147) = dbrk(147)*y(lIOLE)*y(lO3)
      r(148) = dbrk(148)*y(lIOLE)*y(lNO3)
      r(149) = dbrk(149)*y(lISOP)*y(lOH)
      r(150) = dbrk(150)*y(lISOP)*y(lO)
      r(151) = dbrk(151)*y(lISO2)*y(lNO)
      r(152) = dbrk(152)*y(lISO2)*y(lHO2)
      r(153) = dbrk(153)*y(lISO2)*y(lC2O3)
      r(154) = dbrk(154)*y(lISO2)*y(lRO2)
      r(155) = dbrk(155)*y(lISO2)
      r(156) = dbrk(156)*y(lISOP)*y(lO3)
      r(157) = dbrk(157)*y(lISOP)*y(lNO3)
      r(158) = dbrk(158)*y(lISPD)*y(lOH)
      r(159) = dbrk(159)*y(lISPD)*y(lO3)
      r(160) = dbrk(160)*y(lISPD)*y(lNO3)
      r(161) = dbrk(161)*y(lISPD)
      r(162) = dbrk(162)*y(lISPX)*y(lOH)
      r(163) = dbrk(163)*y(lHPLD)
      r(164) = dbrk(164)*y(lHPLD)*y(lNO3)
      r(165) = dbrk(165)*y(lEPOX)*y(lOH)
      r(166) = dbrk(166)*y(lEPX2)*y(lHO2)
      r(167) = dbrk(167)*y(lEPX2)*y(lNO)
      r(168) = dbrk(168)*y(lEPX2)*y(lC2O3)
      r(169) = dbrk(169)*y(lEPX2)*y(lRO2)
      r(170) = dbrk(170)*y(lINTR)*y(lOH)
      r(171) = dbrk(171)*y(lTERP)*y(lO)
      r(172) = dbrk(172)*y(lTERP)*y(lOH)
      r(173) = dbrk(173)*y(lTERP)*y(lO3)
      r(174) = dbrk(174)*y(lTERP)*y(lNO3)
      r(175) = dbrk(175)*y(lBENZ)*y(lOH)
      r(176) = dbrk(176)*y(lBZO2)*y(lNO)
      r(177) = dbrk(177)*y(lBZO2)*y(lC2O3)
      r(178) = dbrk(178)*y(lBZO2)*y(lHO2)
      r(179) = dbrk(179)*y(lBZO2)*y(lRO2)
      r(180) = dbrk(180)*y(lTOL)*y(lOH)
      r(181) = dbrk(181)*y(lTO2)*y(lNO)
      r(182) = dbrk(182)*y(lTO2)*y(lC2O3)
      r(183) = dbrk(183)*y(lTO2)*y(lHO2)
      r(184) = dbrk(184)*y(lTO2)*y(lRO2)
      r(185) = dbrk(185)*y(lXYL)*y(lOH)
      r(186) = dbrk(186)*y(lXLO2)*y(lNO)
      r(187) = dbrk(187)*y(lXLO2)*y(lHO2)
      r(188) = dbrk(188)*y(lXLO2)*y(lC2O3)
      r(189) = dbrk(189)*y(lXLO2)*y(lRO2)
      r(190) = dbrk(190)*y(lCRES)*y(lOH)
      r(191) = dbrk(191)*y(lCRES)*y(lNO3)
      r(192) = dbrk(192)*y(lCRO)*y(lNO2)
      r(193) = dbrk(193)*y(lCRO)*y(lHO2)
      r(194) = dbrk(194)*y(lCRON)*y(lOH)
      r(195) = dbrk(195)*y(lCRON)*y(lNO3)
      r(196) = dbrk(196)*y(lCRON)
      r(197) = dbrk(197)*y(lXOPN)
      r(198) = dbrk(198)*y(lXOPN)*y(lOH)
      r(199) = dbrk(199)*y(lXOPN)*y(lO3)
      r(200) = dbrk(200)*y(lXOPN)*y(lNO3)
      r(201) = dbrk(201)*y(lOPEN)
      r(202) = dbrk(202)*y(lOPEN)*y(lOH)
      r(203) = dbrk(203)*y(lOPEN)*y(lO3)
      r(204) = dbrk(204)*y(lOPEN)*y(lNO3)
      r(205) = dbrk(205)*y(lCAT1)*y(lOH)
      r(206) = dbrk(206)*y(lCAT1)*y(lNO3)
      r(207) = dbrk(207)*y(lOPO3)*y(lNO)
      r(208) = dbrk(208)*y(lOPO3)*y(lNO2)
      r(209) = dbrk(209)*y(lOPAN)
      r(210) = dbrk(210)*y(lOPO3)*y(lHO2)
      r(211) = dbrk(211)*y(lOPO3)*y(lC2O3)
      r(212) = dbrk(212)*y(lOPO3)*y(lRO2)
      r(213) = dbrk(213)*y(lOPAN)*y(lOH)
      r(214) = dbrk(214)*y(lPANX)*y(lOH)
      r(215) = dbrk(215)*y(lNTR2)
      r(216) = dbrk(216)*y(lECH4)*y(lOH)
      r(217) = dbrk(217)*y(lCL2)
      r(218) = dbrk(218)*y(lHOCL)
      r(219) = dbrk(219)*y(lCL)*y(lO3)
      r(220) = dbrk(220)*y(lCLO)*y(lCLO)
      r(221) = dbrk(221)*y(lCLO)*y(lNO)
      r(222) = dbrk(222)*y(lCLO)*y(lHO2)
      r(223) = dbrk(223)*y(lCLO)*y(lNO2)
      r(224) = dbrk(224)*y(lCLN3)
      r(225) = dbrk(225)*y(lCLN3)
      r(226) = dbrk(226)*y(lCLN3)
      r(227) = dbrk(227)*y(lCLN3)*H2O
      r(228) = dbrk(228)*y(lOH)*y(lHCL)
      r(229) = dbrk(229)*y(lOH)*y(lFMCL)
      r(230) = dbrk(230)*y(lFMCL)
      r(231) = dbrk(231)*y(lCLO)*y(lMEO2)
      r(232) = dbrk(232)*y(lCL)*CH4
      r(233) = dbrk(233)*y(lCL)*y(lPAR)
      r(234) = dbrk(234)*y(lCL)*y(lETHA)
      r(235) = dbrk(235)*y(lCL)*y(lPRPA)
      r(236) = dbrk(236)*y(lCL)*y(lISOP)
      r(237) = dbrk(237)*y(lHCL)*y(lN2O5)
      r(238) = dbrk(238)*y(lCLN2)
      r(239) = dbrk(239)*y(lBR2)
      r(240) = dbrk(240)*y(lHOBR)
      r(241) = dbrk(241)*y(lBR2)*y(lOH)
      r(242) = dbrk(242)*y(lHBR)*y(lOH)
      r(243) = dbrk(243)*y(lBR)*y(lO3)
      r(244) = dbrk(244)*y(lBR)*y(lHO2)
      r(245) = dbrk(245)*y(lBR)*y(lNO2)
      r(246) = dbrk(246)*y(lBR)*y(lNO3)
      r(247) = dbrk(247)*y(lBRO)
      r(248) = dbrk(248)*y(lBRO)*y(lHO2)
      r(249) = dbrk(249)*y(lBRO)*y(lOH)
      r(250) = dbrk(250)*y(lBRO)*y(lBRO)
      r(251) = dbrk(251)*y(lBRO)*y(lBRO)
      r(252) = dbrk(252)*y(lBRO)*y(lNO)
      r(253) = dbrk(253)*y(lBRO)*y(lNO2)
      r(254) = dbrk(254)*y(lBRN2)
      r(255) = dbrk(255)*y(lBRN3)
      r(256) = dbrk(256)*y(lBRN3)*H2O
      r(257) = dbrk(257)*y(lFMBR)*y(lOH)
      r(258) = dbrk(258)*y(lFMBR)
      r(259) = dbrk(259)*y(lBRO)*y(lMEO2)
      r(260) = dbrk(260)*y(lBR)*y(lFORM)
      r(261) = dbrk(261)*y(lBR)*y(lALD2)
      r(262) = dbrk(262)*y(lBR)*y(lOLE)
      r(263) = dbrk(263)*y(lBR)*y(lISOP)
      r(264) = dbrk(264)*y(lI2)
      r(265) = dbrk(265)*y(lHOI)
      r(266) = dbrk(266)*y(lI2)*y(lOH)
      r(267) = dbrk(267)*y(lI2)*y(lNO3)
      r(268) = dbrk(268)*y(lHI)*y(lOH)
      r(269) = dbrk(269)*y(lI)*y(lO3)
      r(270) = dbrk(270)*y(lI)*y(lHO2)
      r(271) = dbrk(271)*y(lI)*y(lNO2)
      r(272) = dbrk(272)*y(lIO)
      r(273) = dbrk(273)*y(lIO)*y(lIO)
      r(274) = dbrk(274)*y(lIO)*y(lHO2)
      r(275) = dbrk(275)*y(lIO)*y(lNO)
      r(276) = dbrk(276)*y(lIO)*y(lNO2)
      r(277) = dbrk(277)*y(lHOI)*y(lOH)
      r(278) = dbrk(278)*y(lOIO)
      r(279) = dbrk(279)*y(lOIO)*y(lOH)
      r(280) = dbrk(280)*y(lOIO)*y(lIO)
      r(281) = dbrk(281)*y(lOIO)*y(lOIO)
      r(282) = dbrk(282)*y(lOIO)*y(lNO)
      r(283) = dbrk(283)*y(lI2O2)
      r(284) = dbrk(284)*y(lI2O2)*y(lO3)
      r(285) = dbrk(285)*y(lINO2)
      r(286) = dbrk(286)*y(lINO2)*y(lINO2)
      r(287) = dbrk(287)*y(lINO3)
      r(288) = dbrk(288)*y(lINO3)*H2O
      r(289) = dbrk(289)*y(lCLO)*y(lBRO)
      r(290) = dbrk(290)*y(lCLO)*y(lIO)
      r(291) = dbrk(291)*y(lBRO)*y(lIO)
      r(292) = dbrk(292)*y(lCH3I)
      r(293) = dbrk(293)*y(lMI2)
      r(294) = dbrk(294)*y(lMIB)
      r(295) = dbrk(295)*y(lMIC)
      r(296) = dbrk(296)*y(lMB3)
      r(297) = dbrk(297)*y(lMB3)*y(lOH)
      r(298) = dbrk(298)*y(lMB2)*y(lOH)
      r(299) = dbrk(299)*y(lMBC)*y(lOH)
      r(300) = dbrk(300)*y(lMBC2)*y(lOH)
      r(301) = dbrk(301)*y(lMB2C)*y(lOH)
      r(302) = dbrk(302)*y(lIALK)
      r(303) = dbrk(303)*y(lSSCL)*y(lHNO3)
      r(304) = dbrk(304)*y(lSSBR)*y(lHOBR)
c
      return
      end
