      subroutine ddmrate2(ny,nr,r,gain,loss)
      implicit none
c
c----CAMx v7Beta2 190506
c
c     DDMRATE2 computes species production and loss rates
c     needed only for DDM rate constant sensitivity
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c --- Subroutines Called:
c        none
c
c --- Called by:
c        EBISOLV
c
c --- Argument definitions:
c        ny   - dimension of gain and loss
c        nr   - dimension of r
c        r    - reaction rates (hr-1)
c        gain - species production (ppm/hr)
c        loss - species destruction (ppm/hr)
c
c --- Includes:
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
c --- Arguments:
      integer ny, nr
      real    loss(ny+1), gain(ny+1)
      real    r(nr)
c
c --- Entry Point:
c
c
c-----Calculate the species rates
c
c
c    NO   NO2    O3     O   O1D    OH   HO2  HONO   PNA   PAN
c  C2O3   NO3  N2O5
c
        Loss(lNO   )= +         r(  3)+         r(  4)+( 2.000)*r( 24)
     &                +         r( 25)+         r( 29)+         r( 40)
     &                +         r( 41)+         r( 53)+         r( 61)
     &                +         r( 68)+         r( 71)+         r( 75)
     &                +         r( 79)+         r( 83)+         r(103)
     &                +         r(151)+         r(167)+         r(176)
     &                +         r(181)+         r(186)+         r(207)
c
        Gain(lNO   )= +         r(  1)+         r(  5)+         r( 28)
     &                +         r( 30)+         r( 42)+         r( 43)
     &                +         r( 68)
c
        Loss(lNO2  )= +         r(  1)+         r(  5)+         r(  6)
     &                +         r( 26)+         r( 30)+         r( 36)
     &                +         r( 41)+         r( 45)+         r( 48)
     &                +         r( 54)+         r( 62)+         r(135)
     &                +         r(192)+         r(208)
c
        Gain(lNO2  )= +         r(  3)+         r(  4)+( 2.000)*r( 24)
     &                +         r( 25)+         r( 27)+( 2.000)*r( 29)
     &                +         r( 30)+         r( 31)+         r( 32)
     &                +         r( 33)+         r( 34)+( 2.000)*r( 35)
     &                +         r( 37)+         r( 38)+         r( 42)
     &                +         r( 44)+         r( 47)+         r( 49)
     &                +( 0.590)*r( 50)+         r( 51)+         r( 53)
     &                +         r( 55)+( 0.600)*r( 56)+         r( 61)
     &                +         r( 63)+( 0.600)*r( 64)+         r( 71)
        Gain(lNO2  ) = Gain(lNO2  )
     &                +         r( 75)+         r( 79)+         r( 92)
     &                +         r(103)+( 0.500)*r(140)+( 0.500)*r(144)
     &                +( 0.500)*r(148)+( 0.900)*r(151)+( 0.350)*r(157)
     &                +( 0.142)*r(160)+         r(167)+( 0.444)*r(170)
     &                +( 0.470)*r(174)+( 0.918)*r(176)+( 0.860)*r(181)
     &                +( 0.860)*r(186)+( 0.500)*r(200)+         r(207)
     &                +         r(209)+( 0.500)*r(213)+         r(214)
c
        Loss(lO3   )= +         r(  3)+         r(  7)+         r(  8)
     &                +         r(  9)+         r( 12)+         r( 13)
     &                +         r( 26)+         r( 34)+         r(139)
     &                +         r(143)+         r(147)+         r(156)
     &                +         r(159)+         r(173)+         r(199)
     &                +         r(203)
c
        Gain(lO3   )= +         r(  2)+( 0.150)*r( 57)+( 0.150)*r( 65)
     &                +( 0.150)*r(210)
c
        Loss(lO    )= +         r(  2)+         r(  4)+         r(  5)
     &                +         r(  6)+         r(  7)+         r( 14)
     &                +         r( 15)+         r( 23)+         r( 31)
     &                +         r( 99)+         r(105)+         r(109)
     &                +         r(137)+         r(141)+         r(145)
     &                +         r(150)+         r(171)
c
        Gain(lO    )= +         r(  1)+         r(  8)+         r( 10)
     &                +         r( 16)+         r( 27)
c
        Loss(lO1D  )= +         r( 10)+         r( 11)
c
        Gain(lO1D  )= +         r(  9)
c
        Loss(lOH   )= +         r( 12)+         r( 14)+( 2.000)*r( 16)
     &                +( 2.000)*r( 17)+         r( 18)+         r( 22)
     &                +         r( 32)+         r( 40)+         r( 44)
     &                +         r( 45)+         r( 46)+         r( 51)
     &                +         r( 52)+         r( 87)+         r( 89)
     &                +         r( 91)+         r( 93)+         r( 94)
     &                +         r( 95)+         r( 96)+         r(106)
     &                +         r(110)+         r(113)+         r(116)
     &                +         r(121)+         r(122)+         r(123)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(124)+         r(125)+         r(126)
     &                +         r(127)+         r(130)+         r(131)
     &                +         r(132)+         r(136)+         r(138)
     &                +         r(142)+         r(146)+         r(149)
     &                +         r(158)+         r(162)+         r(165)
     &                +         r(170)+         r(172)+         r(175)
     &                +         r(180)+         r(185)+         r(190)
     &                +         r(194)+         r(198)+         r(202)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(205)+         r(213)+         r(214)
     &                +         r(216)
c
        Gain(lOH   )= +( 2.000)*r( 11)+         r( 13)+         r( 15)
     &                +( 2.000)*r( 21)+         r( 23)+         r( 25)
     &                +         r( 33)+         r( 43)+         r( 47)
     &                +( 0.410)*r( 50)+( 0.440)*r( 57)+( 0.440)*r( 65)
     &                +( 0.400)*r( 87)+         r( 88)+( 0.400)*r( 89)
     &                +         r( 90)+         r( 99)+( 0.200)*r(104)
     &                +         r(105)+         r(109)+( 0.190)*r(114)
     &                +( 0.700)*r(136)+( 0.300)*r(137)+( 0.160)*r(139)
     &                +( 0.100)*r(141)+( 0.334)*r(143)+( 0.500)*r(147)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 0.120)*r(152)+( 0.266)*r(156)+( 0.461)*r(159)
     &                +( 0.933)*r(162)+         r(163)+( 1.125)*r(166)
     &                +( 0.125)*r(167)+( 0.100)*r(168)+( 0.125)*r(169)
     &                +( 0.570)*r(173)+( 0.118)*r(175)+( 0.100)*r(180)
     &                +( 0.244)*r(185)+( 0.500)*r(199)+( 0.500)*r(203)
     &                +( 0.440)*r(210)
c
        Loss(lHO2  )= +         r( 13)+         r( 15)+         r( 18)
     &                +( 2.000)*r( 19)+( 2.000)*r( 20)+         r( 25)
     &                +         r( 33)+         r( 48)+         r( 57)
     &                +         r( 65)+         r( 69)+         r( 72)
     &                +         r( 76)+         r( 80)+         r( 84)
     &                +         r(101)+         r(104)+         r(152)
     &                +         r(166)+         r(178)+         r(183)
     &                +         r(187)+         r(193)+         r(210)
c
        Gain(lHO2  )= +         r( 12)+         r( 14)+         r( 22)
     &                +         r( 23)+         r( 32)+         r( 49)
     &                +( 0.590)*r( 50)+         r( 52)+         r( 69)
     &                +         r( 71)+( 0.900)*r( 73)+( 0.370)*r( 74)
     &                +         r( 75)+( 0.800)*r( 77)+( 0.600)*r( 78)
     &                +( 0.800)*r( 85)+         r( 90)+         r( 93)
     &                +         r( 96)+( 2.000)*r( 97)+         r( 99)
     &                +         r(100)+         r(102)+         r(103)
     &                +( 0.200)*r(104)+         r(108)+         r(112)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.200)*r(113)+( 1.400)*r(114)+         r(116)
     &                +( 2.000)*r(117)+         r(118)+         r(119)
     &                +         r(122)+         r(123)+         r(126)
     &                +( 0.900)*r(127)+         r(134)+( 0.300)*r(136)
     &                +         r(137)+( 0.160)*r(139)+( 0.100)*r(141)
     &                +( 0.080)*r(143)+( 0.250)*r(150)+( 0.818)*r(151)
     &                +( 0.120)*r(152)+( 0.728)*r(153)+( 0.728)*r(154)
     &                +         r(155)+( 0.066)*r(156)+( 0.137)*r(158)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.398)*r(159)+( 0.760)*r(161)+( 0.825)*r(166)
     &                +( 0.825)*r(167)+( 0.660)*r(168)+( 0.825)*r(169)
     &                +( 0.530)*r(175)+( 0.918)*r(176)+         r(177)
     &                +         r(179)+( 0.180)*r(180)+( 0.860)*r(181)
     &                +         r(182)+         r(184)+( 0.155)*r(185)
     &                +( 0.860)*r(186)+         r(188)+         r(189)
     &                +         r(190)+         r(196)+( 0.700)*r(197)
     &                +         r(201)+( 0.560)*r(203)+( 0.200)*r(205)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.800)*r(207)
c
        Loss(lHONO )= +( 2.000)*r( 42)+         r( 43)+         r( 44)
c
        Gain(lHONO )= +         r( 40)+( 2.000)*r( 41)+         r(196)
c
        Loss(lPNA  )= +         r( 49)+         r( 50)+         r( 51)
c
        Gain(lPNA  )= +         r( 48)
c
        Loss(lPAN  )= +         r( 55)+         r( 56)
c
        Gain(lPAN  )= +         r( 54)
c
        Loss(lC2O3 )= +         r( 53)+         r( 54)+         r( 57)
     &                +         r( 58)+( 2.000)*r( 59)+         r( 60)
     &                +         r( 73)+         r( 77)+         r( 81)
     &                +         r( 85)+         r(153)+         r(168)
     &                +         r(177)+         r(182)+         r(188)
     &                +         r(211)
c
        Gain(lC2O3 )= +         r( 55)+( 0.600)*r( 56)+         r( 58)
     &                +         r( 95)+         r(105)+         r(106)
     &                +         r(107)+( 0.800)*r(113)+         r(115)
     &                +         r(119)+         r(120)+         r(121)
     &                +( 0.500)*r(128)+( 0.620)*r(129)+         r(130)
     &                +( 0.269)*r(158)+( 0.143)*r(159)+( 0.208)*r(161)
     &                +( 0.300)*r(197)+( 0.600)*r(199)+( 0.120)*r(203)
c
        Loss(lNO3  )= +         r( 27)+         r( 28)+         r( 29)
     &                +         r( 30)+         r( 31)+         r( 32)
     &                +         r( 33)+         r( 34)+( 2.000)*r( 35)
     &                +         r( 36)+         r(100)+         r(107)
     &                +         r(111)+         r(115)+         r(118)
     &                +         r(120)+         r(140)+         r(144)
     &                +         r(148)+         r(157)+         r(160)
     &                +         r(164)+         r(174)+         r(191)
     &                +         r(195)+         r(200)+         r(204)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(206)
c
        Gain(lNO3  )= +         r(  6)+         r( 26)+         r( 37)
     &                +         r( 38)+         r( 46)+( 0.410)*r( 50)
     &                +( 0.400)*r( 56)+( 0.400)*r( 64)+( 0.185)*r(170)
c
        Loss(lN2O5 )= +         r( 37)+         r( 38)+         r( 39)
c
        Gain(lN2O5 )= +         r( 36)
c
c
      return
      end

