      subroutine ddmrate5(ny,nr,r,gain,loss)
      implicit none
c
c----CAMx v7Beta2 190506
c
c     DDMRATE5 computes species production and loss rates
c     needed only for DDM rate constant sensitivity
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c --- Subroutines Called:
c        none
c
c --- Called by:
c        EBISOLV
c
c --- Argument definitions:
c        ny   - dimension of gain and loss
c        nr   - dimension of r
c        r    - reaction rates (hr-1)
c        gain - species production (ppm/hr)
c        loss - species destruction (ppm/hr)
c
c --- Includes:
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
c --- Arguments:
      integer ny, nr
      real    loss(ny+1), gain(ny+1)
      real    r(nr)
c
c --- Entry Point:
c
c
c-----Calculate the species rates
c
c
c    NO   NO2    O3   O3P   O1D    OH   HO2  HONO   PNA   PAN
c  MCO3   NO3  N2O5
c
        Loss(lNO   )= +         r(  4)+         r(  7)+         r(  9)
     &                +( 2.000)*r( 10)+         r( 22)+         r( 31)
     &                +         r( 46)+         r( 52)+         r( 57)
     &                +         r( 66)+         r( 76)+         r( 87)
     &                +         r( 99)+         r(114)+         r(124)
     &                +         r(134)+         r(144)+         r(154)
     &                +         r(164)+         r(174)+         r(184)
     &                +         r(194)+         r(283)+         r(293)
     &                +         r(303)+         r(313)+         r(323)
        Loss(lNO   ) = Loss(lNO   )
     &                +         r(333)+         r(343)+         r(353)
     &                +         r(363)+         r(373)+         r(383)
     &                +         r(393)+         r(403)+         r(413)
     &                +         r(423)+         r(433)+         r(443)
     &                +         r(453)+         r(463)+         r(473)
     &                +         r(483)+         r(493)+         r(503)
c
        Gain(lNO   )= +         r(  1)+         r(  5)+         r( 15)
     &                +         r( 16)+         r( 23)+         r(114)
     &                +         r(124)+         r(134)+         r(144)
     &                +         r(154)+         r(164)+         r(174)
     &                +         r(184)+         r(194)+         r(283)
     &                +         r(293)+         r(303)+         r(313)
     &                +         r(323)+         r(333)+         r(343)
     &                +         r(353)+         r(363)+         r(373)
     &                +         r(383)+         r(393)+         r(403)
        Gain(lNO   ) = Gain(lNO   )
     &                +         r(413)+         r(423)+         r(433)
     &                +         r(443)+         r(453)+         r(463)
     &                +         r(473)+         r(483)+         r(493)
     &                +         r(503)
c
        Loss(lNO2  )= +         r(  1)+         r(  5)+         r(  6)
     &                +         r(  8)+         r( 11)+         r( 15)
     &                +         r( 25)+         r( 32)+         r( 63)
     &                +         r( 73)+         r( 84)+         r( 96)
     &                +         r(109)+         r(111)
c
        Gain(lNO2  )= +         r(  4)+         r(  7)+( 2.000)*r(  9)
     &                +( 2.000)*r( 10)+         r( 12)+         r( 15)
     &                +         r( 17)+         r( 24)+         r( 26)
     &                +         r( 28)+         r( 31)+         r( 33)
     &                +( 0.610)*r( 34)+         r( 35)+( 0.800)*r( 39)
     &                +( 2.000)*r( 40)+         r( 46)+         r( 49)
     &                +         r( 52)+         r( 54)+         r( 59)
     &                +         r( 64)+( 0.600)*r( 65)+         r( 66)
     &                +         r( 68)+         r( 74)+( 0.600)*r( 75)
        Gain(lNO2  ) = Gain(lNO2  )
     &                +         r( 76)+         r( 78)+         r( 85)
     &                +( 0.600)*r( 86)+         r( 87)+         r( 89)
     &                +         r( 97)+( 0.600)*r( 98)+         r( 99)
     &                +         r(101)+         r(134)+         r(136)
     &                +( 0.500)*r(137)+( 0.500)*r(138)+( 0.500)*r(139)
     &                +         r(140)+         r(141)+         r(142)
     &                +         r(143)+( 0.019)*r(269)+         r(270)
c
        Loss(lO3   )= +         r(  3)+         r(  7)+         r(  8)
     &                +         r( 18)+         r( 19)+         r( 30)
     &                +         r( 36)+         r(247)+         r(250)
     &                +         r(253)+         r(255)+         r(260)
     &                +         r(264)+         r(275)+         r(515)
     &                +         r(519)+         r(523)+         r(527)
     &                +         r(531)+         r(535)+         r(549)
     &                +         r(553)+         r(559)+         r(563)
c
        Gain(lO3   )= +         r(  2)+( 0.300)*r( 67)+( 0.250)*r( 77)
     &                +( 0.250)*r( 88)+( 0.250)*r(100)
c
        Loss(lO3P  )= +         r(  2)+         r(  3)+         r(  4)
     &                +         r(  5)+         r(  6)+         r(257)
     &                +         r(261)+         r(277)+         r(517)
     &                +         r(521)+         r(525)+         r(529)
     &                +         r(533)+         r(551)+         r(555)
     &                +         r(561)+         r(565)
c
        Gain(lO3P  )= +         r(  1)+         r( 17)+         r( 19)
     &                +         r( 21)
c
        Loss(lO1D  )= +         r( 20)+         r( 21)
c
        Gain(lO1D  )= +         r( 18)
c
        Loss(lOH   )= +         r( 22)+         r( 24)+         r( 25)
     &                +         r( 26)+         r( 27)+         r( 29)
     &                +         r( 30)+         r( 35)+         r( 42)
     &                +         r( 43)+         r( 44)+         r( 45)
     &                +         r(206)+         r(208)+         r(211)
     &                +         r(214)+         r(216)+         r(218)
     &                +         r(219)+         r(220)+         r(221)
     &                +         r(222)+         r(224)+         r(226)
     &                +         r(228)+         r(232)+         r(235)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(238)+         r(240)+         r(243)
     &                +         r(246)+         r(249)+         r(252)
     &                +         r(254)+         r(259)+         r(263)
     &                +         r(267)+         r(269)+         r(271)
     &                +         r(274)+         r(279)+         r(281)
     &                +         r(513)+         r(514)+         r(518)
     &                +         r(522)+         r(526)+         r(530)
     &                +         r(534)+         r(536)+         r(537)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(538)+         r(539)+         r(540)
     &                +         r(541)+         r(542)+         r(543)
     &                +         r(544)+         r(545)+         r(546)
     &                +         r(547)+         r(548)+         r(552)
     &                +         r(556)+         r(557)+         r(558)
     &                +         r(562)
c
        Gain(lOH   )= +( 2.000)*r( 20)+         r( 23)+         r( 28)
     &                +         r( 31)+( 0.390)*r( 34)+         r( 36)
     &                +( 0.800)*r( 39)+( 2.000)*r( 41)+         r(124)
     &                +         r(126)+( 0.500)*r(127)+( 0.500)*r(128)
     &                +( 0.500)*r(129)+         r(130)+         r(131)
     &                +         r(132)+         r(133)+( 0.300)*r(222)
     &                +         r(223)+( 0.744)*r(224)+         r(225)
     &                +( 0.840)*r(226)+         r(227)+( 0.139)*r(228)
     &                +         r(229)+( 0.826)*r(247)+( 0.826)*r(250)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 0.471)*r(253)+( 0.208)*r(255)+( 0.330)*r(258)
     &                +( 0.164)*r(260)+( 0.285)*r(264)+( 0.330)*r(275)
     &                +( 0.178)*r(278)+         r(280)+         r(282)
     &                +( 0.160)*r(515)+( 0.350)*r(519)+( 0.080)*r(523)
     &                +( 0.266)*r(527)+( 0.728)*r(531)+( 0.700)*r(534)
     &                +( 0.500)*r(535)+( 0.116)*r(536)+( 0.312)*r(537)
     &                +( 0.239)*r(538)+( 0.198)*r(539)+( 0.278)*r(540)
     &                +( 0.230)*r(541)+( 0.128)*r(549)+( 0.443)*r(553)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 0.202)*r(556)+( 0.178)*r(557)+( 0.499)*r(559)
     &                +( 0.499)*r(563)
c
        Loss(lHO2  )= +         r( 31)+         r( 32)+         r( 36)
     &                +( 2.000)*r( 37)+( 2.000)*r( 38)+         r( 39)
     &                +         r( 43)+         r( 47)+         r( 48)
     &                +         r( 53)+         r( 58)+         r( 67)
     &                +         r( 77)+         r( 88)+         r(100)
     &                +         r(112)+         r(115)+         r(125)
     &                +         r(135)+         r(145)+         r(155)
     &                +         r(165)+         r(175)+         r(185)
     &                +         r(195)+         r(284)+         r(294)
        Loss(lHO2  ) = Loss(lHO2  )
     &                +         r(304)+         r(314)+         r(324)
     &                +         r(334)+         r(344)+         r(354)
     &                +         r(364)+         r(374)+         r(384)
     &                +         r(394)+         r(404)+         r(414)
     &                +         r(424)+         r(434)+         r(444)
     &                +         r(454)+         r(464)+         r(474)
     &                +         r(484)+         r(494)+         r(504)
c
        Gain(lHO2  )= +         r( 26)+         r( 29)+         r( 30)
     &                +         r( 33)+( 0.610)*r( 34)+         r( 42)
     &                +         r( 44)+         r( 45)+         r( 46)
     &                +         r( 49)+( 2.000)*r( 51)+( 0.500)*r( 55)
     &                +( 0.500)*r( 60)+( 0.900)*r( 69)+         r( 79)
     &                +         r( 90)+         r(102)+         r(114)
     &                +         r(115)+         r(116)+( 0.500)*r(117)
     &                +( 0.500)*r(118)+( 0.500)*r(119)+         r(120)
     &                +         r(121)+         r(122)+         r(123)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +         r(125)+         r(135)+         r(145)
     &                +         r(155)+         r(165)+         r(175)
     &                +         r(185)+         r(195)+( 2.000)*r(204)
     &                +         r(206)+         r(207)+         r(209)
     &                +         r(212)+         r(218)+         r(219)
     &                +         r(223)+         r(225)+( 0.142)*r(227)
     &                +( 0.148)*r(228)+         r(229)+( 2.000)*r(230)
     &                +( 0.630)*r(232)+( 0.630)*r(233)+         r(234)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.522)*r(247)+( 1.023)*r(248)+( 0.522)*r(250)
     &                +( 0.554)*r(253)+( 0.108)*r(255)+( 0.670)*r(258)
     &                +( 0.064)*r(260)+( 0.400)*r(264)+( 1.233)*r(266)
     &                +( 0.472)*r(267)+( 0.189)*r(269)+( 0.344)*r(270)
     &                +( 2.000)*r(272)+( 0.830)*r(275)+( 1.066)*r(278)
     &                +         r(284)+         r(294)+         r(304)
     &                +         r(314)+         r(324)+         r(334)
     &                +         r(344)+         r(354)+         r(364)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +         r(374)+         r(384)+         r(394)
     &                +         r(404)+         r(414)+         r(424)
     &                +         r(434)+         r(444)+         r(454)
     &                +         r(464)+         r(474)+         r(484)
     &                +         r(485)+( 0.500)*r(486)+( 0.500)*r(487)
     &                +( 0.500)*r(488)+         r(489)+         r(490)
     &                +         r(491)+         r(492)+         r(494)
     &                +         r(504)+( 0.160)*r(515)+( 0.800)*r(517)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.165)*r(519)+( 0.080)*r(523)+( 0.250)*r(525)
     &                +( 0.066)*r(527)+( 0.009)*r(531)+( 0.300)*r(534)
     &                +( 1.500)*r(535)+( 0.570)*r(536)+( 0.181)*r(537)
     &                +( 0.159)*r(538)+( 0.161)*r(539)+( 0.159)*r(540)
     &                +( 0.022)*r(541)+( 0.950)*r(542)+( 0.095)*r(549)
     &                +( 0.094)*r(553)+( 0.123)*r(556)+( 0.077)*r(557)
     &                +( 0.078)*r(559)+( 0.078)*r(563)
c
        Loss(lHONO )= +         r( 23)+         r( 24)
c
        Gain(lHONO )= +         r( 22)+         r(241)
c
        Loss(lPNA  )= +         r( 33)+         r( 34)+         r( 35)
c
        Gain(lPNA  )= +         r( 32)
c
        Loss(lPAN  )= +         r( 64)+         r( 65)
c
        Gain(lPAN  )= +         r( 63)
c
        Loss(lMCO3 )= +         r( 63)+         r( 66)+         r( 67)
     &                +         r( 68)+         r( 69)+         r( 70)
     &                +         r( 71)+( 2.000)*r( 72)+         r( 82)
     &                +         r( 93)+         r(105)+         r(120)
     &                +         r(130)+         r(140)+         r(150)
     &                +         r(160)+         r(170)+         r(180)
     &                +         r(190)+         r(200)+         r(289)
     &                +         r(299)+         r(309)+         r(319)
     &                +         r(329)+         r(339)+         r(349)
        Loss(lMCO3 ) = Loss(lMCO3 )
     &                +         r(359)+         r(369)+         r(379)
     &                +         r(389)+         r(399)+         r(409)
     &                +         r(419)+         r(429)+         r(439)
     &                +         r(449)+         r(459)+         r(469)
     &                +         r(479)+         r(489)+         r(499)
     &                +         r(509)
c
        Gain(lMCO3 )= +         r( 64)+( 0.600)*r( 65)+( 0.400)*r( 98)
     &                +         r( 99)+         r(101)+         r(102)
     &                +         r(103)+         r(104)+         r(105)
     &                +         r(106)+         r(107)+( 2.000)*r(108)
     &                +         r(120)+         r(130)+         r(140)
     &                +         r(150)+         r(154)+         r(156)
     &                +( 0.500)*r(157)+( 0.500)*r(158)+( 0.500)*r(159)
     &                +( 2.000)*r(160)+         r(161)+         r(162)
     &                +         r(163)+         r(170)+         r(180)
        Gain(lMCO3 ) = Gain(lMCO3 )
     &                +         r(190)+         r(200)+         r(208)
     &                +         r(210)+( 0.620)*r(215)+         r(217)
     &                +         r(234)+         r(235)+         r(236)
     &                +( 2.000)*r(237)+( 0.305)*r(248)+( 0.013)*r(253)
     &                +( 0.340)*r(258)+( 0.467)*r(266)+( 0.400)*r(268)
     &                +         r(271)+         r(273)+( 0.980)*r(279)
     &                +         r(289)+         r(299)+         r(309)
     &                +         r(319)+         r(329)+         r(339)
        Gain(lMCO3 ) = Gain(lMCO3 )
     &                +         r(349)+         r(359)+         r(369)
     &                +         r(379)+         r(389)+         r(399)
     &                +         r(409)+         r(419)+         r(429)
     &                +         r(439)+         r(449)+         r(459)
     &                +         r(469)+         r(479)+         r(489)
     &                +         r(499)+         r(509)
c
        Loss(lNO3  )= +         r(  9)+         r( 11)+         r( 15)
     &                +         r( 16)+         r( 17)+         r( 26)
     &                +         r( 39)+( 2.000)*r( 40)+         r( 49)
     &                +         r( 54)+         r( 59)+         r( 68)
     &                +         r( 78)+         r( 89)+         r(101)
     &                +         r(116)+         r(126)+         r(136)
     &                +         r(146)+         r(156)+         r(166)
     &                +         r(176)+         r(186)+         r(196)
     &                +         r(207)+         r(210)+         r(213)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(233)+         r(236)+         r(239)
     &                +         r(245)+         r(256)+         r(265)
     &                +         r(273)+         r(276)+         r(285)
     &                +         r(295)+         r(305)+         r(315)
     &                +         r(325)+         r(335)+         r(345)
     &                +         r(355)+         r(365)+         r(375)
     &                +         r(385)+         r(395)+         r(405)
     &                +         r(415)+         r(425)+         r(435)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(445)+         r(455)+         r(465)
     &                +         r(475)+         r(485)+         r(495)
     &                +         r(505)+         r(516)+         r(520)
     &                +         r(524)+         r(528)+         r(532)
     &                +         r(550)+         r(554)+         r(560)
     &                +         r(564)
c
        Gain(lNO3  )= +         r(  6)+         r(  8)+         r( 12)
     &                +         r( 27)+( 0.390)*r( 34)+( 0.400)*r( 65)
     &                +( 0.400)*r( 75)+( 0.400)*r( 86)+( 0.400)*r( 98)
     &                +         r(116)+         r(126)+         r(136)
     &                +         r(146)+         r(156)+         r(166)
     &                +         r(176)+         r(186)+         r(196)
     &                +         r(285)+         r(295)+         r(305)
     &                +         r(315)+         r(325)+         r(335)
     &                +         r(345)+         r(355)+         r(365)
        Gain(lNO3  ) = Gain(lNO3  )
     &                +         r(375)+         r(385)+         r(395)
     &                +         r(405)+         r(415)+         r(425)
     &                +         r(435)+         r(445)+         r(455)
     &                +         r(465)+         r(475)+         r(485)
     &                +         r(495)+         r(505)
c
        Loss(lN2O5 )= +         r( 12)+         r( 13)+         r( 14)
c
        Gain(lN2O5 )= +         r( 11)
c
c
      return
      end

