      subroutine ebirate3(ny,nr,r,gain,loss)
      implicit none
c
c----CAMx v7Beta2 190506
c
c     EBIRATE3 computes species production and loss
c     for the EBI solver
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c --- Subroutines Called:
c        none
c
c --- Called by:
c        EBISOLV
c
c --- Argument definitions:
c        ny   - dimension of gain and loss
c        nr   - dimension of r
c        r    - reaction rates (hr-1)
c        gain - species production (ppm/hr)
c        loss - species destruction (ppm/hr)
c
c --- Includes:
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
c --- Arguments:
      integer ny, nr
      real    loss(ny+1), gain(ny+1)
      real    r(nr)
c
c --- Entry Point:
c
c
c-----Calculate the species rates
c
c
c  H2O2  HNO3   SO2  SULF  MEO2   RO2  PACD  AACD  CXO3  ALD2
c  XO2H  PANX  FORM  MEPX  MEOH  ROOH   XO2  XO2N  NTR1  NTR2
c  FACD    CO  HCO3  ALDX  GLYD   GLY  MGLY  ETHA  ETOH   KET
c   PAR  ACET  PRPA   ROR  ETHY   ETH   OLE  IOLE  ISOP  ISO2
c  ISPD  INTR  ISPX  HPLD  OPO3  EPOX  EPX2  TERP  BENZ  CRES
c  BZO2  OPEN   TOL   TO2  XOPN   XYL  XLO2   CRO  CAT1  CRON
c  OPAN  ECH4   CL2  HOCL  CLN3   HCL  FMCL  CLN2   BR2  HOBR
c   HBR  BRN2  BRN3  FMBR    I2   HOI  INO3    HI  INO2  I2O2
c  HIO3  IXOY  CH3I   MI2   MIB   MIC   MB3   MB2   MBC  MBC2
c  MB2C  IALK  SSCL  SSN3  SSBR
c
        Loss(lH2O2 )= +         r( 21)+         r( 22)+         r( 23)
c
        Gain(lH2O2 )= +         r( 17)+         r( 19)+         r( 20)
     &                +( 0.040)*r(143)+( 0.080)*r(147)
c
        Loss(lHNO3 )= +         r( 46)+         r( 47)+         r(303)
c
        Gain(lHNO3 )= +( 2.000)*r( 39)+         r( 45)+         r(100)
     &                +         r(107)+         r(111)+         r(115)
     &                +         r(118)+         r(120)+( 0.717)*r(160)
     &                +         r(164)+         r(191)+         r(195)
     &                +         r(204)+         r(206)+         r(215)
     &                +         r(227)+         r(237)+         r(256)
     &                +         r(288)
c
        Loss(lSO2  )= +         r( 52)
c
        Gain(lSO2  )= 0.0
c
        Loss(lSULF )= 0.0
c
        Gain(lSULF )= +         r( 52)
c
        Loss(lMEO2 )= +         r( 71)+         r( 72)+         r( 73)
     &                +         r( 74)+         r(231)+         r(259)
c
        Gain(lMEO2 )= +         r( 53)+( 0.400)*r( 56)+( 0.440)*r( 57)
     &                +( 2.000)*r( 59)+         r( 60)+( 0.900)*r( 73)
     &                +( 0.800)*r( 77)+( 0.800)*r( 81)+( 0.800)*r( 85)
     &                +( 0.600)*r( 87)+         r( 88)+         r( 94)
     &                +         r(108)+         r(124)+( 0.500)*r(128)
     &                +( 1.380)*r(129)+( 0.800)*r(153)+( 0.115)*r(158)
     &                +( 0.340)*r(161)+( 0.800)*r(168)+         r(177)
     &                +         r(182)+         r(188)+         r(211)
     &                +         r(216)+         r(232)+         r(292)
        Gain(lMEO2 ) = Gain(lMEO2 )
     &                +         r(299)+         r(300)+         r(301)
c
        Loss(lRO2  )= +         r( 58)+         r( 66)+         r( 68)
     &                +         r( 69)+( 2.000)*r( 70)+         r( 74)
     &                +         r( 78)+         r( 82)+         r( 86)
     &                +         r(154)+         r(169)+         r(179)
     &                +         r(184)+         r(189)+         r(212)
c
        Gain(lRO2  )= +         r( 53)+( 0.400)*r( 56)+( 0.440)*r( 57)
     &                +( 2.000)*r( 59)+( 2.000)*r( 60)+         r( 61)
     &                +( 0.400)*r( 64)+( 0.440)*r( 65)+( 0.800)*r( 66)
     &                +( 2.000)*r( 67)+( 0.900)*r( 73)+         r( 74)
     &                +( 0.800)*r( 77)+         r( 78)+( 0.800)*r( 81)
     &                +         r( 82)+( 0.800)*r( 85)+         r( 86)
     &                +( 0.600)*r( 87)+         r( 88)+( 0.600)*r( 89)
     &                +         r( 94)+         r(108)+         r(112)
     &                +( 0.110)*r(114)+( 0.200)*r(116)+( 0.500)*r(118)
        Gain(lRO2  ) = Gain(lRO2  )
     &                +         r(120)+         r(124)+         r(125)
     &                +( 0.100)*r(127)+         r(128)+( 1.380)*r(129)
     &                +         r(130)+         r(131)+         r(132)
     &                +( 0.980)*r(133)+( 0.700)*r(137)+         r(138)
     &                +         r(140)+( 0.210)*r(141)+( 1.195)*r(142)
     &                +( 0.150)*r(143)+         r(144)+( 0.100)*r(145)
     &                +         r(146)+( 0.300)*r(147)+         r(148)
     &                +         r(149)+( 0.250)*r(150)+( 0.082)*r(151)
        Gain(lRO2  ) = Gain(lRO2  )
     &                +( 0.872)*r(153)+( 1.072)*r(154)+( 0.200)*r(156)
     &                +         r(157)+( 0.658)*r(158)+( 0.284)*r(160)
     &                +( 0.840)*r(161)+( 0.067)*r(162)+         r(165)
     &                +( 0.800)*r(168)+         r(169)+         r(170)
     &                +( 1.500)*r(172)+( 0.940)*r(173)+( 1.280)*r(174)
     &                +( 0.352)*r(175)+         r(177)+         r(179)
     &                +( 0.720)*r(180)+         r(182)+         r(184)
     &                +( 0.602)*r(185)+         r(188)+         r(189)
        Gain(lRO2  ) = Gain(lRO2  )
     &                +( 0.020)*r(190)+( 0.700)*r(191)+( 2.000)*r(198)
     &                +( 0.300)*r(199)+         r(200)+( 0.400)*r(202)
     &                +( 0.440)*r(210)+( 2.000)*r(211)+( 1.800)*r(212)
     &                +         r(216)+         r(234)+         r(235)
     &                +         r(236)+         r(262)+         r(263)
     &                +         r(302)
c
        Loss(lPACD )= +         r( 95)
c
        Gain(lPACD )= +( 0.410)*r( 57)+( 0.410)*r( 65)+( 0.410)*r(210)
c
        Loss(lAACD )= +         r( 94)
c
        Gain(lAACD )= +( 0.150)*r( 57)+( 0.150)*r( 65)+( 0.100)*r( 73)
     &                +( 0.200)*r( 77)+( 0.200)*r( 81)+( 0.200)*r( 85)
     &                +( 0.130)*r(143)+( 0.080)*r(147)+( 0.200)*r(153)
     &                +( 0.200)*r(168)+( 0.150)*r(210)+( 0.200)*r(212)
c
        Loss(lCXO3 )= +         r( 60)+         r( 61)+         r( 62)
     &                +         r( 65)+         r( 66)+( 2.000)*r( 67)
c
        Gain(lCXO3 )= +         r( 63)+( 0.600)*r( 64)+         r(109)
     &                +         r(110)+         r(111)+( 0.500)*r(128)
     &                +( 0.250)*r(150)+( 0.200)*r(156)+( 0.717)*r(160)
     &                +( 0.390)*r(173)+( 0.200)*r(207)
c
        Loss(lALD2 )= +         r(105)+         r(106)+         r(107)
     &                +         r(108)+         r(261)
c
        Gain(lALD2 )= +         r( 60)+         r( 61)+( 0.400)*r( 64)
     &                +( 0.440)*r( 65)+( 0.800)*r( 66)+( 2.000)*r( 67)
     &                +         r(112)+( 0.991)*r(125)+( 0.950)*r(127)
     &                +( 0.500)*r(128)+( 0.740)*r(133)+( 0.200)*r(141)
     &                +( 0.488)*r(142)+( 0.295)*r(143)+( 0.250)*r(144)
     &                +( 1.240)*r(145)+( 1.300)*r(146)+( 0.732)*r(147)
     &                +( 0.500)*r(148)+( 0.040)*r(159)+( 0.100)*r(199)
     &                +( 0.020)*r(203)+         r(214)+( 0.991)*r(234)
     &                +         r(262)
c
        Loss(lXO2H )= +         r( 75)+         r( 76)+         r( 77)
     &                +         r( 78)
c
        Gain(lXO2H )= +         r( 60)+         r( 61)+( 0.400)*r( 64)
     &                +( 0.440)*r( 65)+( 0.800)*r( 66)+( 2.000)*r( 67)
     &                +( 0.540)*r( 89)+         r(112)+( 0.110)*r(114)
     &                +( 0.991)*r(125)+( 0.100)*r(127)+( 0.500)*r(128)
     &                +( 0.970)*r(131)+( 0.110)*r(132)+( 0.940)*r(133)
     &                +( 0.700)*r(137)+         r(138)+( 0.500)*r(140)
     &                +( 0.200)*r(141)+( 0.976)*r(142)+( 0.150)*r(143)
     &                +( 0.480)*r(144)+( 0.100)*r(145)+         r(146)
     &                +( 0.300)*r(147)+( 0.480)*r(148)+( 0.082)*r(151)
        Gain(lXO2H ) = Gain(lXO2H )
     &                +( 0.072)*r(153)+( 0.072)*r(154)+( 0.640)*r(157)
     &                +( 0.142)*r(160)+( 0.340)*r(161)+( 0.370)*r(170)
     &                +( 0.750)*r(172)+( 0.070)*r(173)+( 0.280)*r(174)
     &                +( 0.070)*r(180)+( 0.058)*r(185)+( 0.120)*r(191)
     &                +         r(197)+( 2.000)*r(198)+( 0.300)*r(199)
     &                +( 0.450)*r(200)+( 0.400)*r(202)+( 0.440)*r(210)
     &                +( 0.800)*r(212)+( 0.991)*r(234)+( 0.970)*r(235)
     &                +( 0.960)*r(236)+         r(262)+( 0.960)*r(263)
        Gain(lXO2H ) = Gain(lXO2H )
     &                +         r(302)
c
        Loss(lPANX )= +         r( 63)+         r( 64)+         r(214)
c
        Gain(lPANX )= +         r( 62)
c
        Loss(lFORM )= +         r( 96)+         r( 97)+         r( 98)
     &                +         r( 99)+         r(100)+         r(101)
     &                +         r(260)
c
        Gain(lFORM )= +         r( 71)+( 0.100)*r( 72)+         r( 73)
     &                +( 0.685)*r( 74)+( 0.400)*r( 87)+         r(102)
     &                +( 0.740)*r(114)+         r(126)+( 0.078)*r(127)
     &                +         r(130)+         r(137)+( 1.560)*r(138)
     &                +         r(139)+( 1.125)*r(140)+( 0.200)*r(141)
     &                +( 0.781)*r(142)+( 0.555)*r(143)+( 0.500)*r(144)
     &                +( 0.128)*r(147)+( 0.500)*r(150)+( 0.673)*r(151)
     &                +( 0.120)*r(152)+( 0.598)*r(153)+( 0.598)*r(154)
     &                +( 0.600)*r(156)+( 0.350)*r(157)+( 0.231)*r(159)
        Gain(lFORM ) = Gain(lFORM )
     &                +( 0.260)*r(161)+( 0.375)*r(166)+( 0.375)*r(167)
     &                +( 0.300)*r(168)+( 0.375)*r(169)+( 0.592)*r(170)
     &                +( 0.280)*r(172)+( 0.240)*r(173)+         r(196)
     &                +( 0.080)*r(203)+( 0.140)*r(205)+         r(231)
     &                +         r(259)+         r(293)+         r(294)
     &                +         r(295)
c
        Loss(lMEPX )= +         r( 87)+         r( 88)
c
        Gain(lMEPX )= +( 0.900)*r( 72)+( 0.500)*r(104)
c
        Loss(lMEOH )= +         r(126)
c
        Gain(lMEOH )= +( 0.315)*r( 74)+( 0.150)*r(114)
c
        Loss(lROOH )= +         r( 89)+         r( 90)
c
        Gain(lROOH )= +         r( 76)+         r( 80)+         r( 84)
c
        Loss(lXO2  )= +         r( 79)+         r( 80)+         r( 81)
     &                +         r( 82)
c
        Gain(lXO2  )= +( 0.200)*r(116)+( 0.500)*r(118)+         r(120)
     &                +         r(130)+( 0.760)*r(132)+( 0.500)*r(140)
     &                +( 0.195)*r(142)+( 0.480)*r(144)+( 0.480)*r(148)
     &                +( 0.250)*r(150)+( 0.200)*r(156)+( 0.330)*r(157)
     &                +( 0.521)*r(158)+( 0.142)*r(160)+( 0.160)*r(161)
     &                +( 0.630)*r(170)+( 0.500)*r(172)+( 0.690)*r(173)
     &                +( 0.750)*r(174)+( 0.480)*r(191)+( 0.450)*r(200)
     &                +         r(211)
c
        Loss(lXO2N )= +         r( 83)+         r( 84)+         r( 85)
     &                +         r( 86)
c
        Gain(lXO2N )= +( 0.060)*r( 89)+( 0.009)*r(125)+( 0.030)*r(131)
     &                +( 0.130)*r(132)+( 0.040)*r(133)+( 0.010)*r(141)
     &                +( 0.024)*r(142)+( 0.040)*r(144)+( 0.040)*r(148)
     &                +( 0.030)*r(157)+( 0.022)*r(158)+( 0.250)*r(172)
     &                +( 0.180)*r(173)+( 0.250)*r(174)+( 0.020)*r(190)
     &                +( 0.100)*r(191)+( 0.100)*r(200)+( 0.009)*r(234)
     &                +( 0.030)*r(235)+( 0.040)*r(236)+( 0.040)*r(263)
c
        Loss(lNTR1 )= +         r( 91)+         r( 92)
c
        Gain(lNTR1 )= +( 0.500)*r( 83)+         r(135)+( 0.500)*r(140)
     &                +( 0.500)*r(144)+( 0.500)*r(148)
c
        Loss(lNTR2 )= +         r(215)
c
        Gain(lNTR2 )= +( 0.500)*r( 83)+         r( 91)+( 0.650)*r(157)
     &                +( 0.142)*r(160)+( 0.266)*r(170)+( 0.530)*r(174)
     &                +( 0.082)*r(176)+( 0.140)*r(181)+( 0.140)*r(186)
     &                +         r(194)+         r(195)+( 0.500)*r(200)
     &                +( 0.500)*r(213)
c
        Loss(lFACD )= +         r( 93)
c
        Gain(lFACD )= +         r(103)+( 0.500)*r(104)+( 0.300)*r(136)
     &                +( 0.370)*r(139)+( 0.090)*r(143)+( 0.150)*r(159)
     &                +( 0.074)*r(166)+( 0.185)*r(170)
c
        Loss(lCO   )= +         r(123)
c
        Gain(lCO   )= +         r( 96)+         r( 97)+         r( 98)
     &                +         r( 99)+         r(100)+         r(108)
     &                +         r(112)+( 0.890)*r(114)+( 1.800)*r(116)
     &                +( 2.000)*r(117)+( 1.500)*r(118)+         r(119)
     &                +         r(121)+( 0.380)*r(129)+( 0.300)*r(136)
     &                +         r(137)+( 0.510)*r(139)+( 0.200)*r(141)
     &                +( 0.378)*r(143)+( 0.100)*r(145)+( 0.245)*r(147)
     &                +( 0.066)*r(156)+( 0.137)*r(158)+( 0.543)*r(159)
     &                +( 0.251)*r(166)+( 0.251)*r(167)+( 0.200)*r(168)
        Gain(lCO   ) = Gain(lCO   )
     &                +( 0.251)*r(169)+( 0.001)*r(173)+( 0.700)*r(197)
     &                +( 0.500)*r(199)+         r(201)+( 1.980)*r(203)
     &                +( 0.500)*r(207)+         r(213)+         r(229)
     &                +         r(230)+         r(257)+         r(258)
     &                +         r(260)+         r(296)+         r(297)
     &                +         r(298)
c
        Loss(lHCO3 )= +         r(102)+         r(103)+         r(104)
c
        Gain(lHCO3 )= +         r(101)
c
        Loss(lALDX )= +         r(109)+         r(110)+         r(111)
     &                +         r(112)
c
        Gain(lALDX )= +( 0.260)*r(131)+( 0.110)*r(132)+( 0.370)*r(133)
     &                +( 0.300)*r(141)+( 0.488)*r(142)+( 0.270)*r(143)
     &                +( 0.375)*r(144)+( 0.660)*r(145)+( 0.700)*r(146)
     &                +( 0.442)*r(147)+( 0.625)*r(148)+( 0.150)*r(156)
     &                +( 0.029)*r(162)+( 0.078)*r(170)+( 0.150)*r(171)
     &                +( 0.470)*r(172)+( 0.210)*r(173)+( 0.470)*r(174)
     &                +( 0.440)*r(210)+         r(211)+( 0.800)*r(212)
     &                +         r(302)
c
        Loss(lGLYD )= +         r(113)+         r(114)+         r(115)
c
        Gain(lGLYD )= +( 0.011)*r(127)+( 0.220)*r(138)+( 0.269)*r(158)
     &                +( 0.113)*r(160)+( 0.128)*r(161)+( 0.275)*r(166)
     &                +( 0.275)*r(167)+( 0.220)*r(168)+( 0.275)*r(169)
     &                +( 0.331)*r(170)
c
        Loss(lGLY  )= +         r(116)+         r(117)+         r(118)
c
        Gain(lGLY  )= +( 0.200)*r(113)+( 0.110)*r(114)+( 0.700)*r(136)
     &                +( 0.075)*r(143)+( 0.240)*r(147)+( 0.170)*r(159)
     &                +( 0.275)*r(166)+( 0.275)*r(167)+( 0.220)*r(168)
     &                +( 0.275)*r(169)+( 0.918)*r(176)+         r(177)
     &                +         r(179)+( 0.417)*r(181)+( 0.480)*r(182)
     &                +( 0.480)*r(184)+( 0.221)*r(186)+( 0.260)*r(188)
     &                +( 0.260)*r(189)+( 0.025)*r(190)+( 0.240)*r(191)
     &                +( 0.400)*r(197)+( 0.400)*r(198)+( 0.400)*r(202)
     &                +( 1.400)*r(203)+( 0.500)*r(207)+( 0.500)*r(213)
c
        Loss(lMGLY )= +         r(119)+         r(120)+         r(121)
c
        Gain(lMGLY )= +( 0.075)*r(143)+( 0.060)*r(147)+( 0.115)*r(158)
     &                +( 0.531)*r(159)+( 0.113)*r(160)+( 0.275)*r(166)
     &                +( 0.275)*r(167)+( 0.220)*r(168)+( 0.275)*r(169)
     &                +( 0.443)*r(181)+( 0.520)*r(182)+( 0.520)*r(184)
     &                +( 0.675)*r(186)+( 0.770)*r(188)+( 0.770)*r(189)
     &                +( 0.240)*r(191)+         r(198)+( 1.200)*r(199)
     &                +( 0.250)*r(200)+( 0.240)*r(203)
c
        Loss(lETHA )= +         r(125)+         r(234)
c
        Gain(lETHA )= 0.0
c
        Loss(lETOH )= +         r(127)
c
        Gain(lETOH )= 0.0
c
        Loss(lKET  )= +         r(128)
c
        Gain(lKET  )= +( 0.200)*r(133)+         r(134)
c
        Loss(lPAR  )= +         r(132)+         r(233)
c
        Gain(lPAR  )= +(-2.500)*r(128)+( 0.260)*r(131)+(-0.110)*r(132)
     &                +(-2.700)*r(133)+( 0.200)*r(141)+(-0.730)*r(142)
     &                +(-0.790)*r(143)+(-1.000)*r(144)+( 0.100)*r(145)
     &                +( 0.290)*r(147)+         r(148)+( 0.250)*r(150)
     &                +( 0.350)*r(156)+( 0.117)*r(158)+( 0.717)*r(160)
     &                +( 0.240)*r(161)+( 2.175)*r(166)+( 2.175)*r(167)
     &                +( 1.740)*r(168)+( 2.175)*r(169)+( 2.700)*r(170)
     &                +( 5.120)*r(171)+( 1.660)*r(172)+( 7.000)*r(173)
     &                +(-1.000)*r(262)
c
        Loss(lACET )= +         r(129)+         r(130)
c
        Gain(lACET )= +( 0.710)*r(131)+( 0.420)*r(133)+( 0.137)*r(158)
     &                +( 0.170)*r(159)+( 0.170)*r(161)+         r(235)
c
        Loss(lPRPA )= +         r(131)+         r(235)
c
        Gain(lPRPA )= 0.0
c
        Loss(lROR  )= +         r(133)+         r(134)+         r(135)
c
        Gain(lROR  )= +( 0.760)*r(132)+( 0.020)*r(133)
c
        Loss(lETHY )= +         r(136)
c
        Gain(lETHY )= 0.0
c
        Loss(lETH  )= +         r(137)+         r(138)+         r(139)
     &                +         r(140)
c
        Gain(lETH  )= 0.0
c
        Loss(lOLE  )= +         r(141)+         r(142)+         r(143)
     &                +         r(144)+         r(262)
c
        Gain(lOLE  )= +( 0.240)*r(161)+( 0.098)*r(170)
c
        Loss(lIOLE )= +         r(145)+         r(146)+         r(147)
     &                +         r(148)
c
        Gain(lIOLE )= +( 0.029)*r(162)
c
        Loss(lISOP )= +         r(149)+         r(150)+         r(156)
     &                +         r(157)+         r(236)+         r(263)
c
        Gain(lISOP )= 0.0
c
        Loss(lISO2 )= +         r(151)+         r(152)+         r(153)
     &                +         r(154)+         r(155)
c
        Gain(lISO2 )= +         r(149)+( 0.067)*r(162)
c
        Loss(lISPD )= +         r(158)+         r(159)+         r(160)
     &                +         r(161)
c
        Gain(lISPD )= +( 0.750)*r(150)+( 0.900)*r(151)+( 0.120)*r(152)
     &                +         r(153)+         r(154)+( 0.650)*r(156)
     &                +( 0.350)*r(157)+         r(163)+         r(164)
     &                +         r(236)+         r(263)
c
        Loss(lINTR )= +         r(170)
c
        Gain(lINTR )= +( 0.100)*r(151)+( 0.104)*r(170)
c
        Loss(lISPX )= +         r(162)
c
        Gain(lISPX )= +( 0.880)*r(152)
c
        Loss(lHPLD )= +         r(163)+         r(164)
c
        Gain(lHPLD )= +         r(155)
c
        Loss(lOPO3 )= +         r(207)+         r(208)+         r(210)
     &                +         r(211)+         r(212)
c
        Gain(lOPO3 )= +( 0.457)*r(158)+( 0.480)*r(191)+         r(201)
     &                +( 0.600)*r(202)+         r(204)+         r(209)
c
        Loss(lEPOX )= +         r(165)
c
        Gain(lEPOX )= +( 0.904)*r(162)
c
        Loss(lEPX2 )= +         r(166)+         r(167)+         r(168)
     &                +         r(169)
c
        Gain(lEPX2 )= +         r(165)
c
        Loss(lTERP )= +         r(171)+         r(172)+         r(173)
     &                +         r(174)
c
        Gain(lTERP )= 0.0
c
        Loss(lBENZ )= +         r(175)
c
        Gain(lBENZ )= 0.0
c
        Loss(lCRES )= +         r(190)+         r(191)
c
        Gain(lCRES )= +( 0.530)*r(175)+( 0.180)*r(180)+( 0.155)*r(185)
     &                +         r(193)
c
        Loss(lBZO2 )= +         r(176)+         r(177)+         r(178)
     &                +         r(179)
c
        Gain(lBZO2 )= +( 0.352)*r(175)
c
        Loss(lOPEN )= +         r(201)+         r(202)+         r(203)
     &                +         r(204)
c
        Gain(lOPEN )= +( 0.118)*r(175)+( 0.918)*r(176)+         r(177)
     &                +         r(179)+( 0.100)*r(180)+( 0.660)*r(181)
     &                +( 0.770)*r(182)+( 0.770)*r(184)+( 0.300)*r(186)
     &                +( 0.350)*r(188)+( 0.350)*r(189)+( 0.025)*r(190)
     &                +         r(196)+( 0.250)*r(200)
c
        Loss(lTOL  )= +         r(180)
c
        Gain(lTOL  )= 0.0
c
        Loss(lTO2  )= +         r(181)+         r(182)+         r(183)
     &                +         r(184)
c
        Gain(lTO2  )= +( 0.650)*r(180)
c
        Loss(lXOPN )= +         r(197)+         r(198)+         r(199)
     &                +         r(200)
c
        Gain(lXOPN )= +( 0.200)*r(181)+( 0.230)*r(182)+( 0.230)*r(184)
     &                +( 0.244)*r(185)+( 0.560)*r(186)+( 0.650)*r(188)
     &                +( 0.650)*r(189)
c
        Loss(lXYL  )= +         r(185)
c
        Gain(lXYL  )= 0.0
c
        Loss(lXLO2 )= +         r(186)+         r(187)+         r(188)
     &                +         r(189)
c
        Gain(lXLO2 )= +( 0.544)*r(185)
c
        Loss(lCRO  )= +         r(192)+         r(193)
c
        Gain(lCRO  )= +( 0.200)*r(190)+( 0.300)*r(191)+( 0.500)*r(194)
     &                +( 0.500)*r(195)+( 0.500)*r(205)+         r(206)
c
        Loss(lCAT1 )= +         r(205)+         r(206)
c
        Gain(lCAT1 )= +( 0.732)*r(190)
c
        Loss(lCRON )= +         r(194)+         r(195)+         r(196)
c
        Gain(lCRON )= +         r(192)
c
        Loss(lOPAN )= +         r(209)+         r(213)
c
        Gain(lOPAN )= +         r(208)
c
        Loss(lECH4 )= +         r(216)
c
        Gain(lECH4 )= 0.0
c
        Loss(lCL2  )= +         r(217)
c
        Gain(lCL2  )= +( 0.300)*r(220)
c
        Loss(lHOCL )= +         r(218)
c
        Gain(lHOCL )= +         r(222)+         r(227)
c
        Loss(lCLN3 )= +         r(224)+         r(225)+         r(226)
     &                +         r(227)
c
        Gain(lCLN3 )= +         r(223)
c
        Loss(lHCL  )= +         r(228)+         r(237)
c
        Gain(lHCL  )= +         r(232)+         r(233)+         r(234)
     &                +         r(235)+         r(303)
c
        Loss(lFMCL )= +         r(229)+         r(230)
c
        Gain(lFMCL )= +         r(236)
c
        Loss(lCLN2 )= +         r(238)
c
        Gain(lCLN2 )= +         r(237)
c
        Loss(lBR2  )= +         r(239)+         r(241)
c
        Gain(lBR2  )= +         r(251)+         r(304)
c
        Loss(lHOBR )= +         r(240)+         r(304)
c
        Gain(lHOBR )= +         r(241)+         r(248)+         r(256)
     &                +( 0.750)*r(259)
c
        Loss(lHBR  )= +         r(242)
c
        Gain(lHBR  )= +         r(244)+         r(260)+         r(261)
c
        Loss(lBRN2 )= +         r(254)
c
        Gain(lBRN2 )= +         r(245)
c
        Loss(lBRN3 )= +         r(255)+         r(256)
c
        Gain(lBRN3 )= +         r(253)
c
        Loss(lFMBR )= +         r(257)+         r(258)
c
        Gain(lFMBR )= +         r(262)+         r(263)
c
        Loss(lI2   )= +         r(264)+         r(266)+         r(267)
c
        Gain(lI2   )= +         r(286)
c
        Loss(lHOI  )= +         r(265)+         r(277)
c
        Gain(lHOI  )= +         r(266)+         r(274)+         r(288)
c
        Loss(lINO3 )= +         r(287)+         r(288)
c
        Gain(lINO3 )= +         r(267)+         r(276)
c
        Loss(lHI   )= +         r(268)
c
        Gain(lHI   )= +         r(270)
c
        Loss(lINO2 )= +         r(285)+( 2.000)*r(286)
c
        Gain(lINO2 )= +         r(271)
c
        Loss(lI2O2 )= +         r(283)+         r(284)
c
        Gain(lI2O2 )= +( 0.600)*r(273)
c
        Loss(lHIO3 )= 0.0
c
        Gain(lHIO3 )= +         r(279)
c
        Loss(lIXOY )= 0.0
c
        Gain(lIXOY )= +         r(280)+         r(281)+         r(284)
c
        Loss(lCH3I )= +         r(292)
c
        Gain(lCH3I )= 0.0
c
        Loss(lMI2  )= +         r(293)
c
        Gain(lMI2  )= 0.0
c
        Loss(lMIB  )= +         r(294)
c
        Gain(lMIB  )= 0.0
c
        Loss(lMIC  )= +         r(295)
c
        Gain(lMIC  )= 0.0
c
        Loss(lMB3  )= +         r(296)+         r(297)
c
        Gain(lMB3  )= 0.0
c
        Loss(lMB2  )= +         r(298)
c
        Gain(lMB2  )= 0.0
c
        Loss(lMBC  )= +         r(299)
c
        Gain(lMBC  )= 0.0
c
        Loss(lMBC2 )= +         r(300)
c
        Gain(lMBC2 )= 0.0
c
        Loss(lMB2C )= +         r(301)
c
        Gain(lMB2C )= 0.0
c
        Loss(lIALK )= +         r(302)
c
        Gain(lIALK )= 0.0
c
        Loss(lSSCL )= +         r(303)
c
        Gain(lSSCL )= 0.0
c
        Loss(lSSN3 )= 0.0
c
        Gain(lSSN3 )= +         r(303)
c
        Loss(lSSBR )= +         r(304)
c
        Gain(lSSBR )= 0.0
c
c
      return
      end

