c*** DPREPSLO
c
      subroutine dprepslo(y, rr)
      use rtcmcchm
c
c----CAMx v7Beta2 190506
c
c-----------------------------------------------------------------------
c    Description:
c-----------------------------------------------------------------------
c
c     Save concentration and reaction rate values to later advance the
c     slow species in the RTRAC CMC solver
c
c     Copyright 1996 - 2018
c    Ramboll
c
c    Argument descriptions:
c     Inputs:
c      y     D  species concentrations
c     Outputs:
c      rr    D  rate of each reaction
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c    07/06/07   --gyarwood--    Original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      implicit none
      include 'camx.prm'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      real*8    y(MXTRSP+MXSPEC), rr(MXRX)
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer   k, n
      real*8    yh(MXTRSP+MXSPEC)
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
      do k = 1,ngasrtc
         yh(k) = max(0.0D0, y(k))
      enddo
c
c --- calculate reaction rates
c
      do n = 1,nrxnrtc
         rr(n) = rkrtc(n)
         if( nrct(n) .GT. 0) then
            do k = 1,nrct(n)
               rr(n) = rr(n)*yh(idxrct(n,k))
            enddo
         endif
      enddo
c
c --- update any equilibrium species and rr
c
      if( neqmrtc .GT. 0) call deqmcmc(yh,rr,.true.,.true.)
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
      return
      end
