@echo off
rem #### run_aermet_test_suite.bat ####
rem #### User Input ####

rem casedir: path to directory containing default test cases for this run
set casedir=C:\Users\JTHURMAN\OneDrive - Environmental Protection Agency (EPA)\Documents\aermet_overhaul\aermet_test_cases_21DRF\aermet_ustar_testcases_21112

rem outdir: path to output directory where default SFC and PFL files will be moved
set outdir=%casedir%\output_files
mkdir "%outdir%"


rem run test cases
call :run_test_suite

:clean_PIT
rem remove any previous PIT test case output if it exists
if exist PIT_1min_2000.dat del PIT_1min_2000.dat
if exist PIT_1min_2000_summ.dat del PIT_1min_2000_summ.dat
if exist PIT_1min_2000_comp.dat del PIT_1min_2000_comp.dat
if exist aerminute.log del aerminute.log
if exist aermet.inp del aermet.inp
if exist UAEXOUT.DAT del UAEXOUT.DAT
if exist UAQAOUT.DAT del UAQAOUT.DAT
if exist SFEXOUT.DAT del SFEXOUT.DAT
if exist SFQAOUT.DAT del SFQAOUT.DAT
if exist ONSITE.OQA del ONSITE.OQA
if exist PIT1.RPT del PIT1.RPT
if exist PIT1.MSG del PIT1.MSG
if exist PIT_ISHD.MRG del PIT_ISHD.MRG
if exist PIT2_1min.RPT del PIT2_1min.RPT
if exist PIT2_1min.MSG del PIT2_1min.MSG
if exist PIT_2000_1MIN-ASOS_ADJ.SFC del PIT_2000_1MIN-ASOS.SFC
if exist PIT_2000_1MIN-ASOS_ADJ.PFL del PIT_2000_1MIN-ASOS.PFL
if exist PIT3_1MIN_ADJ.RPT del PIT3_1MIN.RPT
if exist PIT3_1MIN_ADJ.MSG del PIT3_1MIN.MSG
if exist PIT_2000_1MIN-ASOS_ADJ.SFC del PIT_2000_1MIN-ASOS_ADJ.SFC
if exist PIT_2000_1MIN-ASOS_ADJ.PFL del PIT_2000_1MIN-ASOS_ADJ.PFL
if exist PIT3_1MIN_ADJ.RPT del PIT3_1MIN_ADJ.RPT
if exist PIT3_1MIN_ADJ.MSG del PIT3_1MIN_ADJ.MSG
if exist bad_records.dat del bad_records.dat
if exist check_records.dat del check_records.dat
if exist good_records.dat del good_records.dat
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat

goto :eof

:clean_PVD
rem remove any previous PVD test case output if it exists
if exist PVD_1min_2005.dat del PVD_1min_2005.dat
if exist PVD_1min_2005_summ.dat del PVD_1min_2005_summ.dat
if exist PVD_1min_2005_comp.dat del PVD_1min_2005_comp.dat
if exist aerminute.log del aerminute.log
if exist aermet.inp del aermet.inp
if exist PVD1.RPT del PVD1.RPT
if exist PVD1.MSG del PVD1.MSG
if exist UAEXOUT.DAT del UAEXOUT.DAT
if exist UAQAOUT.DAT del UAQAOUT.DAT
if exist SFEXOUT.DAT del SFEXOUT.DAT
if exist SFQAOUT.DAT del SFQAOUT.DAT
if exist PVD2_1min.RPT del PVD2_1min.RPT
if exist PVD2_1min.MSG del PVD2_1min.MSG
if exist PVD_ISHD.MRG del PVD_ISHD.MRG
if exist PVD2_No-1min.RPT del PVD2_No-1min.RPT
if exist PVD2_No-1min.MSG del PVD2_No-1min.MSG
if exist PVD3_1MIN_ADJ.RPT del PVD3_1MIN_ADJ.RPT
if exist PVD3_1MIN_ADJ.MSG del PVD3_1MIN_ADJ.MSG
if exist PVD_2005_1MIN-ASOS_ADJ.SFC del PVD_2005_1MIN-ASOS_ADJ.SFC
if exist PVD_2005_1MIN-ASOS_ADJ.PFL del PVD_2005_1MIN-ASOS_ADJ.PFL
if exist PVD3_1MIN_NoADJ.RPT del PVD3_1MIN_NoADJ.RPT
if exist PVD3_1MIN_NoADJ.MSG del PVD3_1MIN_NoADJ.MSG
if exist PVD_2005_1MIN-ASOS_NoADJ.SFC del PVD_2005_1MIN-ASOS_NoADJ.SFC
if exist PVD_2005_1MIN-ASOS_NoADJ.PFL del PVD_2005_1MIN-ASOS_NoADJ.PFL
if exist PVD3_No1MIN_ADJ.RPT del PVD3_No1MIN_ADJ.RPT
if exist PVD3_No1MIN_ADJ.MSG del PVD3_No1MIN_ADJ.MSG
if exist PVD_2005_No1MIN-ASOS_ADJ.SFC del PVD_2005_No1MIN-ASOS_ADJ.SFC
if exist PVD_2005_No1MIN-ASOS_ADJ.PFL del PVD_2005_No1MIN-ASOS_ADJ.PFL
if exist PVD3_No1MIN_NoADJ.RPT del PVD3_No1MIN_NoADJ.RPT
if exist PVD3_No1MIN_NoADJ.MSG del PVD3_No1MIN_NoADJ.MSG
if exist PVD_2005_No1MIN-ASOS_NoADJ.SFC del PVD_2005_No1MIN-ASOS_NoADJ.SFC
if exist PVD_2005_No1MIN-ASOS_NoADJ.PFL del PVD_2005_No1MIN-ASOS_NoADJ.PFL
if exist bad_records.dat del bad_records.dat
if exist check_records.dat del check_records.dat
if exist good_records.dat del good_records.dat
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat 

goto :eof

:clean_anchorage
rem remove any previous anchorage test case output if it exists
if exist aermet.inp del aermet.inp
if exist Anch_1.RPT del Anch_1.RPT
if exist Anch_1.MSG del Anch_1.MSG
if exist UAEXOUT.DAT del UAEXOUT.DAT
if exist UAQAOUT.DAT del UAQAOUT.DAT
if exist SFEXOUT.DAT del SFEXOUT.DAT
if exist SFQAOUT.DAT del SFQAOUT.DAT
if exist Anch_2.RPT del Anch_2.RPT
if exist Anch_2.MSG del Anch_2.MSG
if exist Anch1999.MRG del Anch1999.MRG
if exist Anch_3.RPT del Anch_3.RPT
if exist Anch_3.MSG del Anch_3.MSG
if exist Anch-99.SFC del Anch-99.SFC
if exist Anch-99.PFL del Anch-99.PFL
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat

goto :eof

:clean_cordero
rem remove any previous codero test case output if it exists
if exist aermet.inp del aermet.inp
if exist CORD_ST1.MSG del CORD_ST1.MSG
if exist CORD_ST1.RPT del CORD_ST1.RPT
if exist rapidcity.dsk del rapidcity.dsk
if exist UAQAOUT.DSK del UAQAOUT.DSK
if exist RAPIDSFC.DSK del RAPIDSFC.DSK
if exist SFQAOUT.DSK del SFQAOUT.DSK
if exist OSQAOUT.DSK del OSQAOUT.DSK
if exist CORD_ST2.MSG del CORD_ST2.MSG
if exist CORD_ST2.RPT del CORD_ST2.RPT
if exist CORDERO.MRG del CORDERO.MRG
if exist CORD_ST3.MSG del CORD_ST3.MSG
if exist CORD_ST3.RPT del CORD_ST3.RPT
if exist CORDERO_FULL.SFC del CORDERO_FULL.SFC
if exist CORDERO_FULL.PFL del CORDERO_FULL.PFL
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat

goto :eof

:clean_EX01
rem remove any previous EX01 test case output if it exists
if exist aermet.inp del aermet.inp
if exist EX01_S1.RPT del EX01_S1.RPT
if exist EX01_S1.MSG del EX01_S1.MSG
if exist EX01_UA.IQA del EX01_UA.IQA
if exist EX01_UA.OQA del EX01_UA.OQA
if exist EX01_SF.IQA del EX01_SF.IQA
if exist EX01_SF.OQA del EX01_SF.OQA
if exist EX01_S2.RPT del EX01_S2.RPT
if exist EX01_S2.MSG del EX01_S2.MSG
if exist EX01_MR.MET del EX01_MR.MET
if exist EX01_S3.RPT del EX01_S3.RPT
if exist EX01_S3.MSG del EX01_S3.MSG
if exist EX01_MP.SFC del EX01_MP.SFC
if exist EX01_MP.PFL del EX01_MP.PFL

goto :eof

:clean_EX02
rem remove any previous EX02 test case output if it exists
if exist aermet.inp del aermet.inp
if exist EX02_S1.RPT del EX02_S1.RPT
if exist EX02_S1.MSG del EX02_S1.MSG
if exist EX02_OS.OQA del EX02_OS.OQA
if exist EX02_S2.RPT del EX02_S2.RPT
if exist EX02_S2.MSG del EX02_S2.MSG
if exist EX02_MR.MET del EX02_MR.MET
if exist EX02_S3.RPT del EX02_S3.RPT
if exist EX02_S3.MSG del EX02_S3.MSG
if exist EX02_MP.SFC del EX02_MP.SFC
if exist EX02_MP.PFL del EX02_MP.PFL

goto :eof

:clean_EX03
rem remove any previous EX03 test case output if it exists
if exist aermet.inp del aermet.inp
if exist EX03_S1.RPT del EX03_S1.RPT
if exist EX03_S1.MSG del EX03_S1.MSG
if exist EX03_UA.IQA del EX03_UA.IQA
if exist EX03_UA.OQA del EX03_UA.OQA
if exist EX03_SF.IQA del EX03_SF.IQA
if exist EX03_SF.OQA del EX03_SF.OQA
if exist EX03_S2.RPT del EX03_S2.RPT
if exist EX03_S2.MSG del EX03_S2.MSG
if exist EX03_MR.MET del EX03_MR.MET
if exist EX03_S3.RPT del EX03_S3.RPT
if exist EX03_S3.MSG del EX03_S3.MSG
if exist EX03_MP.SFC del EX03_MP.SFC
if exist EX03_MP.PFL del EX03_MP.PFL

goto :eof

:clean_EX04
rem remove any previous EX04 test case output if it exists
if exist aermet.inp del aermet.inp
if exist HOUSTON1.RPT del HOUSTON1.RPT
if exist HOUSTON1.MSG del HOUSTON1.MSG
if exist UAEXOUT.DAT del UAEXOUT.DAT
if exist UAQAOUT.DAT del UAQAOUT.DAT
if exist SFEXOUT.DAT del SFEXOUT.DAT
if exist SFQAOUT.DAT del SFQAOUT.DAT
if exist HOUSTON2.RPT del HOUSTON2.RPT
if exist HOUSTON2.MSG del HOUSTON2.MSG
if exist HOUSTON.MRG del HOUSTON.MRG
if exist HOUSTON3.RPT del HOUSTON3.RPT
if exist HOUSTON3.MSG del HOUSTON3.MSG
if exist HOUSTON.SFC del HOUSTON.SFC
if exist HOUSTON.PFL del HOUSTON.PFL
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat

goto :eof

:clean_EX05
rem remove any previous EX05 test case output if it exists
if exist aermet.inp del aermet.inp
if exist EX05_S1.RPT del EX05_S1.RPT
if exist EX05_S1.ERR del EX05_S1.ERR
if exist EX05_UA.IQA del EX05_UA.IQA
if exist EX05_UA.OQA del EX05_UA.OQA
if exist EX05_SF.IQA del EX05_SF.IQA
if exist EX05_SF.OQA del EX05_SF.OQA
if exist EX05_OS.OQA del EX05_OS.OQA
if exist EX05_S2.RPT del EX05_S2.RPT
if exist EX05_S2.ERR del EX05_S2.ERR
if exist EX05_MR.MET del EX05_MR.MET
if exist EX05_S3.RPT del EX05_S3.RPT
if exist EX05_S3.ERR del EX05_S3.ERR
if exist EX05_MP4.SFC del EX05_MP4.SFC
if exist EX05_MP4.PFL del EX05_MP4.PFL

goto :eof

:clean_lovett
rem remove any previous lovett test case output if it exists
if exist aermet.inp del aermet.inp
if exist lvtstag1.MSG del lvtstag1.MSG
if exist lvtstag1.RPT del lvtstag1.RPT
if exist ua14735.iqa del ua14735.iqa
if exist ua14735.oqa del ua14735.oqa
if exist sf14735.iqa del sf14735.iqa
if exist sf14735.oqa del sf14735.oqa
if exist lvtoqa.MET del lvtoqa.MET
if exist LVTSTAG2.MSG del LVTSTAG2.MSG
if exist LVTSTAG2.RPT del LVTSTAG2.RPT
if exist MERGE.LVT del MERGE.LVT
if exist LVTSTAG3.MSG del LVTSTAG3.MSG
if exist LVTSTAG3.RPT del LVTSTAG3.RPT
if exist LOVETT.SFC del LOVETT.SFC
if exist LOVETT.PFL del LOVETT.PFL

goto :eof

:clean_martins_creek
rem remove any previous martins creek test case output if it exists
if exist aermet.inp del aermet.inp
if exist mcr_st1.msg del mcr_st1.msg
if exist mcr_st1.rpt del mcr_st1.rpt
if exist alb92-93.iqa del alb92-93.iqa
if exist alb92-93.oqa del alb92-93.oqa
if exist 14737.iqa del 14737.iqa
if exist 14737.oqa del 14737.oqa
if exist mcospfl.oqa del mcospfl.oqa
if exist mcr_st2.msg del mcr_st2.msg
if exist mcr_st2.rpt del mcr_st2.rpt
if exist mc.mrg del mc.mrg
if exist mcr_st3.msg del mcr_st3.msg
if exist mcr_st3.rpt del mcr_st3.rpt
if exist MCR.SFC del MCR.SFC
if exist MCR.PFL del MCR.PFL

goto :eof

:clean_salem
rem remove any previous salem test case output if it exists
if exist aermet.inp del aermet.inp
if exist SALEM_S1.RPT del SALEM_S1.RPT
if exist SALEM_S1.MSG del SALEM_S1.MSG
if exist UPPER.IQA del UPPER.IQA
if exist UPPER.OQA del UPPER.OQA
if exist SALEM.IQA del SALEM.IQA
if exist SALEM.OQA del SALEM.OQA
if exist SALEM_S2.RPT del SALEM_S2.RPT
if exist SALEM_S2.MSG del SALEM_S2.MSG
if exist SALEM.MET del SALEM.MET
if exist SALEM_S3.RPT del SALEM_S3.RPT
if exist SALEM_S3.MSG del SALEM_S3.MSG
if exist salem_86-90.sfc del salem_86-90.sfc
if exist salem_86-90.pfl del salem_86-90.pfl
if exist Discarded_ISHD_Records.dat del Discarded_ISHD_Records.dat

goto :eof

:run_test_suite
rem create user defined output directory if it does not exist

rem run test cases
cd "%casedir%"

cd aermet-aerminute_testcase_PIT
call :clean_PIT
..\aerminute.exe<filename.txt
..\aermet.exe PIT_s1.inp
..\aermet.exe PIT_s2_1MIN.inp
..\aermet.exe PIT_s3_1MIN_ADJ.inp
set fi1=PIT_2000_1MIN-ASOS_ADJ.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=PIT_2000_1MIN-ASOS_ADJ.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd aermet-aerminute_testcase_PVD
call :clean_PVD
..\aerminute.exe<filename.txt
..\aermet.exe PVD_s1.inp
..\aermet.exe PVD_s2_1MIN.inp
..\aermet.exe PVD_s3_1MIN_ADJ.inp 
set fi1=PVD_2005_1MIN-ASOS_ADJ.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=PVD_2005_1MIN-ASOS_ADJ.SFC
move %fi1% "%outdir%\%fi1%"
..\aermet.exe PVD_s3_1MIN_NoADJ.inp
set fi2=PVD_2005_1MIN-ASOS_NOADJ.PFL
move %fi2% "%outdir%\%fi2%"
set fi2=PVD_2005_1MIN-ASOS_NOADJ.SFC
move %fi2% "%outdir%\%fi2%"
..\aermet.exe PVD_s2_No1MIN.inp
..\aermet.exe PVD_s3_No1MIN_ADJ.inp
set fi3=PVD_2005_NO1MIN-ASOS_ADJ.PFL
move %fi3% "%outdir%\%fi3%"
set fi3=PVD_2005_NO1MIN-ASOS_ADJ.SFC
move %fi3% "%outdir%\%fi3%"
..\aermet.exe PVD_s3_No1MIN_NoADJ.inp
set fi4=PVD_2005_NO1MIN-ASOS_NOADJ.PFL
move %fi4% "%outdir%\%fi4%"
set fi4=PVD_2005_NO1MIN-ASOS_NOADJ.SFC
move %fi4% "%outdir%\%fi4%"
cd "%casedir%"

cd anchorage
call :clean_anchorage
..\aermet.exe anch_st1.inp 
..\aermet.exe anch_st2.inp 
..\aermet.exe anch_st3.inp 
set fi1=ANCH-99.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=ANCH-99.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd cordero
call :clean_cordero
..\aermet.exe cord_st1.inp
..\aermet.exe cord_st2.inp 
..\aermet.exe cord_st3.inp
cutmet < cutmet.inp
set fi1=cordero.pfl
move %fi1% "%outdir%\%fi1%"
set fi1=cordero.sfc
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd EX01
call :clean_EX01
..\aermet.exe ex01_s1.inp
..\aermet.exe ex01_s2.inp
..\aermet.exe ex01_s3.inp 
set fi1=EX01_MP.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=EX01_MP.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd "EX02 (aermet2)"
call :clean_EX02
..\aermet.exe ex02_s1.inp
..\aermet.exe ex02_s2.inp
..\aermet.exe ex02_s3.inp
set fi1=EX02_MP.PFL
set fi2=AERMET2.PFL
move %fi1% "%outdir%\%fi2%"
set fi1=EX02_MP.SFC
set fi2=AERMET2.SFC
move %fi1% "%outdir%\%fi2%"
cd "%casedir%"

cd EX03
call :clean_EX03
copy ex03_s1.inp aermet.inp
..\aermet.exe
copy ex03_s2.inp aermet.inp
..\aermet.exe
copy ex03_s3.inp aermet.inp
..\aermet.exe
set fi1=EX03_MP.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=EX03_MP.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd "EX04 (Houston)"
call :clean_EX04
..\aermet.exe ex04_s1.inp
..\aermet.exe ex04_s2.inp 
..\aermet.exe ex04_s3.inp 
set fi1=HOUSTON.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=HOUSTON.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd EX05
call :clean_EX05
..\aermet.exe ex05_s1.inp
..\aermet.exe ex05_s2.inp
..\aermet.exe ex05_s3.inp
set fi1=EX05_MP4.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=EX05_MP4.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd lovett
call :clean_lovett
..\aermet.exe lvtstag1.inp 
..\aermet.exe lvtstag2.inp
..\aermet.exe lvtstag3.inp
set fi1=LOVETT.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=LOVETT.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd martins_creek
call :clean_martins_creek
..\aermet.exe mcr_st1.inp
..\aermet.exe mcr_st2.inp
..\aermet.exe mcr_st3.inp
set fi1=MCR.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=MCR.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

cd salem
call :clean_salem
..\aermet.exe stage1.inp
..\aermet.exe stage2.inp
..\aermet.exe stage3.inp
set fi1=SALEM_86-90.PFL
move %fi1% "%outdir%\%fi1%"
set fi1=SALEM_86-90.SFC
move %fi1% "%outdir%\%fi1%"
cd "%casedir%"

goto :eof


