C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
        SUBROUTINE HEADER
C
C        PURPOSE:     THIS ROUTINE WRITES, IF APPROPRIATE, HEADER(S) TO
C                     OUTPUT FILES.
C
C        LOCAL VARIABLES
C
        INTEGER   NUMBER,ITEST,FILE1,FILE2
        CHARACTER CARD*80,OPATH*2
C
        INCLUDE 'MAIN1.INC'
        INCLUDE 'MAIN2.INC'
        INCLUDE 'UA1.INC'
        INCLUDE 'UA2.INC'
        INCLUDE 'SF1.INC'
        INCLUDE 'SF2.INC'
        INCLUDE 'OS1.INC'
        INCLUDE 'OS2.INC'
        INCLUDE 'WORK1.INC'
C
C        NUMBER  KEEPS TRACK OF HOW MANY HEADER RECORDS,
C                ALLOWING US TO CREATE SPECIAL HEADERS
C                WHEN WE FIRST START TO WRITE A HEADER.
C        ITEST   TEMPORARY STORAGE OF PATHWAY STATUS.
C        FILE1   OUTPUT DEVICE NUMBER TO WHICH WE ARE
C                WRITING THE HEADER.
C        FILE2   OQA-FILE'S DEVICE NUMBER, NEED TO KNOW
C                THIS WHEN FILE1 IS THE IQA-FILE'S
C                DEVICE NUMBER.
C        OPATH   PATHWAY OF LAST WRITTEN HEADER RECORD
C                TO MERGE OUTPUT FILE.  USE THIS TO
C                KEY WHEN TO WRITE A SUB-HEADER RECORD
C                TO THE MERGE OUTPUT FILE.
C
C        INITIALIZE VALUES
C
        PATH  = PATHWD(IRD1)
        LOC   = 'HEADER'
        OPATH = '  '
C
C        CHECK PATHWAYS'S STATUS WORDS
C        IF ANY ARE LT. 0        -       NO HEADER(S)
C          IF  ANY  ARE 4        -       PREP MERGE FILE
C                     ODD        -       PREP IQA FILE
C                                        BLANK ALL OTHERS BEYOND
C                    EVEN        -       PREP OQA FILE
C                                        BLANK ALL OTHERS BEYOND
C
        IF( JBSTAT.LT.0 .OR. UASTAT.LT.0 .OR. SFSTAT.LT.0
     1      .OR. OSSTAT.LT.0 ) THEN
        RETURN
        END IF
C
C
        IF( UASTAT.EQ.4 .AND. SFSTAT.EQ.4 .AND. OSSTAT.EQ.4 ) THEN
         CONTINUE
        ELSE IF(UASTAT.EQ.4 .AND. SFSTAT.EQ.4 .AND. OSSTAT.EQ.0 ) THEN
         CONTINUE
        ELSE IF(UASTAT.EQ.4 .AND. SFSTAT.EQ.0 .AND. OSSTAT.EQ.4 ) THEN
         CONTINUE
        ELSE IF(UASTAT.EQ.0 .AND. SFSTAT.EQ.4 .AND. OSSTAT.EQ.4 ) THEN
         CONTINUE
        ELSE IF(UASTAT.EQ.0 .AND. SFSTAT.EQ.0 .AND. OSSTAT.EQ.4 ) THEN
         CONTINUE
        ELSE IF(UASTAT.EQ.0 .AND. SFSTAT.EQ.4 .AND. OSSTAT.EQ.0 ) THEN
         CONTINUE
        ELSE
         GO TO 25
        END IF
C
C        SEE IF MERGE FILE IS LINKED OK
C
        IF( STATUS(5,4).LE.1 ) THEN
        RETURN
        END IF
C
C        HEADER IS REQUIRED
C
C        INITIALIZE HEADER COUNTER
C
        NUMBER = 0
C
        REWIND DEV40
        REWIND DEV70
10      READ( DEV70,1000,END=20 ) BUF08(1),CARD
1000    FORMAT( A8,A80 )
        BUF02 = BUF08(1)(1:2)
        CALL DEFINE( KOUNT,80,CARD )
        BUF03 = CARD( IC1(2):IC2(2) )
C
        IF( BUF03.EQ.KEYWRD(IRD1,1) .OR. BUF03.EQ.KEYWRD(IRD1,2) ) THEN
        GO TO 10
        END IF
C
        IF( BUF02.EQ.PATHWD(1) ) THEN
        GO TO  10
        END IF
C
        IF( CARD(14:19).EQ.'HEADER' ) THEN
        GO TO 10
        END IF
C
        NUMBER = NUMBER + 1
C
C        SEE IF WE NEED A SUB-HEADER RECORD
C
        IF( NUMBER.GT.0 ) THEN
          IF( BUF02.NE.OPATH ) THEN
          BUF80(10) = BLNK80
          BUF03     = '   '
          WRITE( BUF80(10),1500 ) BUF02
1500      FORMAT( '*T',14X,'HEADER RECORDS FOR ',A2,'-PATHWAY' )
          WRITE( DEV40 ) BUF80(10),BUF03
          NUMBER = NUMBER + 1
          OPATH = BUF02
          END IF
        END IF
C
C        WRITE HEADER TO FILE
C
        BUF03 = '   '
        WRITE( BUF03,2000,IOSTAT=IRD5 ) BUF08(1)(3:3),BUF08(1)(8:8)
2000    FORMAT( '*',2A1 )
        WRITE( DEV40 ) BUF03,CARD
C
C        CHECK WRITE STATUS
C
        IF( IRD5.NE.0 ) THEN
        MESS = BLNK40
        ECODE = 'E21'
        WRITE( MESS,3000 ) IRD5,PATHWD(5)
3000    FORMAT(1X,'IOSTAT= ',I8,' HEADER FOR ',A2,'-PATH')
        CALL ERROR( KOUNT,PATH,ECODE,LOC,MESS )
        RETURN
        END IF
C
        GO TO 10
C
20      RETURN
C
C        WE DO NOT FIT INTO EITHER OF THE SPECIAL CASES
C        LOOP THROUGH PATHWAYS AND PERFORM NECESSARY
C        OPERATIONS.
C
25      DO 50 I=2,3
C
        IF( I.EQ.2 ) THEN
        ITEST = UASTAT
        ELSE
        ITEST = SFSTAT
        END IF
C
C        SEE IF THIS IS A NULL PATHWAY
C
        IF( ITEST.EQ.0 .OR. ITEST.EQ.4 ) THEN
        GO TO 50
        END IF
C
C        INITIALIZE COUNTER
C
        NUMBER = 0
C
C        HEADER IS REQUIRED
C
        IWORK1(10) = MOD( ITEST,2 )
        IF( IWORK1(10).EQ.0 ) THEN
C        HEADER NEEDED FOR OQA-FILE
        IF(I.EQ.2) THEN
        FILE1 = DEV13
        ELSE
        FILE1 = DEV22
        END IF
C
        ELSE
C        HEADER NEEDED FOR IQA-FILE
        IF(I.EQ.2) THEN
        FILE1 = DEV12
        FILE2 = DEV13
        ELSE
        FILE1 = DEV21
        FILE2 = DEV22
        END IF
C
        END IF
C
C        IDENTIFY RECORDS FOR THIS FILE'S HEADERS
C
        REWIND FILE1
        REWIND DEV70
30      READ( DEV70,1000,END=40 ) BUF08(1),CARD
        BUF02 = BUF08(1)(1:2)
        CALL DEFINE( KOUNT,80,CARD )
        BUF03 = CARD( IC1(2):IC2(2) )
C
        IF( BUF03.EQ.KEYWRD(IRD1,1) .OR. BUF03.EQ.KEYWRD(IRD1,2) ) THEN
        GO TO 30
        END IF
C
        IF( CARD(14:19).EQ.'HEADER' ) THEN
        GO TO 30
        END IF
C
        IF( BUF02.NE.PATHWD(I) ) THEN
        GO TO 30
        END IF
C
C        CHECK COUNTER.  IF EQUAL TO ZERO, WRITE SPECIAL
C        HEADER BEFORE WRITING REST OF HEADERS.
C
        IF( NUMBER.EQ.0 ) THEN
        BUF03 = '   '
        BUF80(10) = BLNK80
        WRITE( BUF80(10),1500 ) PATHWD(I)
        WRITE( FILE1,4000 ) BUF80(10),BUF03
4000    FORMAT( A80,A3 )
        NUMBER = NUMBER + 1
        END IF
C
C        WRITE HEADER TO FILE
C
        WRITE( FILE1,5000,IOSTAT=IRD5 ) BUF08(1)(3:3),BUF08(1)(8:8),
     1                                  CARD
5000    FORMAT('*',2A1,A80 )
C
C        CHECK WRITE STATUS
C
        IF( IRD5.NE.0 ) THEN
        MESS = BLNK40
        ECODE = 'E21'
        WRITE( MESS,3000 ) IRD5,PATHWD(I)
        CALL ERROR( KOUNT,PATH,ECODE,LOC,MESS )
        RETURN
        END IF
C
        GO TO 30
C
40      CONTINUE
C
C        IF WE WERE PREPING THE IQA-FILE, MAKE SURE THE OQA-FILE,
C        IF PRESENT, HAS A BLANK LINE IN RECORD POSITION 1
C
        IWORK1(10) = MOD( ITEST,2 )
        IF( IWORK1(10).NE.0 ) THEN
          IF( STATUS(I,5).GT.1 ) THEN
          REWIND FILE2
          BUF03 = '   '
          WRITE(  FILE2,6000 ) BUF03,BLNK80
6000      FORMAT( A3,A80 )
          END IF
        END IF
C
50        CONTINUE
C
C        PROCESS OS-PATHWAY
C
C        SEE IF THIS IS A NULL PATHWAY
C
        IF( OSSTAT.EQ.0 ) THEN
        GO TO 80
        END IF
C
C        HEADER IS REQUIRED
C
C        INITIALIZE COUNTER
C
        NUMBER = 0
C
        REWIND DEV32
        REWIND DEV70
60      READ( DEV70,1000,END=70 ) BUF08(1),CARD
        BUF02 = BUF08(1)(1:2)
        CALL DEFINE( KOUNT,80,CARD )
        BUF03 = CARD( IC1(2):IC2(2) )
C
        IF(BUF03.EQ.KEYWRD(IRD1,1).OR.BUF03.EQ.KEYWRD(IRD1,2)) THEN
        GO TO 60
        END IF
C
        IF( CARD(14:19).EQ.'HEADER' ) THEN
        GO TO 60
        END IF
C
        IF( BUF02.NE.PATHWD(4) ) THEN
        GO TO 60
        END IF
C
C        CHECK COUNTER.  IF EQUAL TO ZERO, WRITE SPECIAL
C        HEADER BEFORE WRITING REST OF HEADERS.
C
        IF( NUMBER.EQ.0 ) THEN
        BUF03 = '   '
        BUF80(10) = BLNK80
        WRITE( BUF80(10),1500 ) PATHWD(4)
        WRITE( DEV32,4000 ) BUF80(10),BUF03
        NUMBER = NUMBER + 1
        END IF
C
C        WRITE HEADER TO FILE
C
        WRITE( DEV32,5000,IOSTAT=IRD5 ) BUF08(1)(3:3),BUF08(1)(8:8),
     1                                  CARD
C
C        CHECK WRITE STATUS
C
        IF( IRD5.NE.0 ) THEN
        MESS = BLNK40
        ECODE = 'E21'
        WRITE( MESS,3000 ) IRD5,PATHWD(4)
        CALL ERROR( KOUNT,PATH,ECODE,LOC,MESS )
        RETURN
        END IF
C
        GO TO 60
C
70      CONTINUE
C
C        MAKE SURE MERGE FILE, IF PRESENT, HAS A BLANK LINE IN
C        RECORD POSITION 1
C
80      IF( STATUS(5,4).GT.1 ) THEN
        REWIND DEV40
        BUF03 = '   '
        WRITE( DEV40 ) BLNK80,BUF03
        END IF
        RETURN
        END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
        SUBROUTINE HDPROC( KOUNT )
C
C        PURPOSE:        THIS ROUTINE READS THE HEADER RECORDS FOR THE
C                        CURRENT PATHWAY, IF ANY, FOR THIS PATHWAY'S
C                        INITIAL INPUT FILE.  IF APPROPRIATE (IE. $ IS
C                        GIVEN IN SECOND COLUMN OF HEADER CARD), WE
C                        PROCESS THIS IMAGE'S INFORMATION.
C
C        1.  FOR PATHWAYS 'JB' AND 'MR', THERE ARE NEVER ANY ACTIONS
C        NEEDED AS THERE ARE NEVER INITIAL INPUT FILES FOR THESE
C        PATHWAYS.
C
C        2.  NEXT WE LOOK AT THE 'EXT' CARD STATUS.  IF THIS CARD IS
C        PRESENT, WHETHER IN ERROR OR NOT, WE AGAIN HAVE TO HEADERS
C        TO PROCESS.
C
C        3.  IF THE 'IAQ' CARD IS PRESENT, WE READ THE IQA-FILE FOR
C        HEADER DATA.  THEN RETURN
C
C       4.  IF THERE IS NO IQA CARD, WE LOOK AT THE STATUS OF THE
C       'OQA' CARD.  IF IT IS PRESENT, WE READ THE OQA-FILE FOR
C        HEADER DATA.  THEN RETURN
C
C        LOCAL VARIABLES
C
        INTEGER   NUMBER,DEVICE
        CHARACTER PREP*3,CARD*80
C
        INCLUDE 'MAIN1.INC'
        INCLUDE 'MAIN2.INC'
        INCLUDE 'UA1.INC'
        INCLUDE 'UA2.INC'
        INCLUDE 'SF1.INC'
        INCLUDE 'SF2.INC'
        INCLUDE 'OS1.INC'
        INCLUDE 'OS2.INC'
        INCLUDE 'WORK1.INC'
C
C        NUMBER = COUNTER KEEPS TRACK OF HEADER COUNT
C        DEVICE = DEVICE NUMBER OF INPUT FILE FOR HEADERS
C        PREP   = IST THREE CHARACTERS FROM HEADER RECORD
C        CARD   = CARD 'IMAGE' AS READ FOR HEADER FILE
C
C        INITIALIZE
C
        PATH = PATHWD(IRD1)

       LOC  = 'HDPROC'
C
C        1.  SKIP OUT IF PATHWD IS 'JB' OR 'MR'
C
        IF( IRD1.EQ.1 .OR. IRD1.EQ.5 ) THEN
        RETURN
        END IF
C
C        2.  SKIP OUT IF 'EXT' CARD WAS PROCESSED, WHETHER IN
C        ERROR OR NOT.
C
        IF( STATUS(IRD1,3).GT.0 ) THEN
          IF( IRD1.EQ.4) THEN
          CONTINUE
          ELSE
          RETURN
          END IF
        END IF
C
C        3.  SEE IF 'IQA' CARD IS PRESENT, AND WITHOUT ERRORS.
C            IF SO, PROCESS HEADERS, IF ANY, FROM IQA-FILE.
C
        IF( STATUS(IRD1,4).GT.1 ) THEN
C
C        PROCESS IQA-FILE
C
C        A. DEFINE DEVICE NUMBER
C
        IF( IRD1.EQ.2 ) DEVICE = DEV12
        IF( IRD1.EQ.3 ) DEVICE = DEV21
        IF( IRD1.EQ.4 ) DEVICE = DEV31
C
C        B.  REWIND DEVICE
C            LOOP ON A READ THAT CHECKS FOR '*' IN FIRST COLUMN
C            IF NOT "*', STOP PROCESSING, OTHERWISE CONTINUE.
C
        REWIND DEVICE
        NUMBER = 0
10      READ( DEVICE,1000,IOSTAT=IRD5,END=100 ) PREP,CARD
C
1000    FORMAT( A3,A80 )
C
        NUMBER = NUMBER + 1
C
C        CHECK READ STATUS
C
        IF( IRD5.NE.0 ) THEN
        MESS = BLNK40
        ECODE = 'E20'
        WRITE( MESS,2000 ) IRD5,PATHWD(IRD1)
2000    FORMAT(1X,'IOSTAT= ',I8,' READING ',A2,'-IQA HEADERS')
        CALL ERROR( NUMBER,PATH,ECODE,LOC,MESS )
        RETURN
        END IF
C
C        LOOK FOR '*'
C
        IF( PREP(1:1).NE.'*' ) THEN
        RETURN
        END IF
C
C        MUST BE A HEADER, WRITE IT TO THE TEMPORARY FILE
C
C        LOGIC TO PROVIDE A 'TRACE' ON THE HISTORY OF THIS
C        CARD IMAGE.  THIRD CHARACTER OF HEADER CARD PREFIX
C        WILL CONTAIN A LETTER (A-Z), DENOTING WHEN IT WAS
C        INTRODUCED TO THE RUN.  BLNK = CURRENT, A = NEXT TO
C        LAST, B = PREV. ONE TO A, ETC.
C
C        THE SUBROUTINE CHAR3 DETERMINES IF THE ASCII (VAX AND PC)
C        POSITIONAL CODE OR EBCDIC (IBM) POSITIONAL CODE IS A VALID
C        VALUE; IF NOT CORRECTIVE ACTION IS TAKEN.
C
        IF( PREP(3:3).EQ.' ') THEN
         PREP(3:3) = 'A'
        ELSE
         IRD5 = ICHAR( PREP(3:3) ) + 1
         CALL CHAR3(IRD5)
         PREP(3:3) = CHAR( IRD5 )
        END IF
C
        CALL WRTCRD( NUMBER,PREP,CARD )
C
C        CHECK TO SEE IF WE SHOULD ACTIVELY PROCESS THIS HEADER
C
        IF( PREP(2:2).EQ.'$' ) THEN
C
C        PROCESS ACTIVELY
C
        CALL DEFINE( NUMBER,80,CARD )
        CALL FDKEY( NUMBER,CARD )
C
        IF( IRD1.EQ.2 ) CALL UACARD( NUMBER,CARD )
        IF( IRD1.EQ.3 ) CALL SFCARD( NUMBER,CARD )
        IF( IRD1.EQ.4 ) CALL OSCARD( NUMBER,CARD )
C
        END IF
C
        GO TO 10
C
         END IF
C
C        4.  SEE IF 'OQA' CARD IS PRESENT, AND WITHOUT ERRORS.
C            IF SO, PROCESS HEADERS, IF ANY, FROM OQA-FILE.
C
        IF( STATUS(IRD1,5).GT.1 ) THEN
C
C        PROCESS OQA-FILE
C
C        A. DEFINE DEVICE NUMBER
C
        IF( IRD1.EQ.2 ) DEVICE = DEV13
        IF( IRD1.EQ.3 ) DEVICE = DEV22
        IF( IRD1.EQ.4 ) DEVICE = DEV32
C
C        B.  REWIND DEVICE
C            LOOP ON A READ THAT CHECKS FOR '*' IN FIRST COLUMN
C            IF NOT "*', STOP PROCESSING, OTHERWISE CONTINUE.
C
        REWIND DEVICE
        NUMBER = 0
 30     READ( DEVICE,1000,IOSTAT=IRD5,END=100 ) PREP,CARD
C
        NUMBER = NUMBER + 1
C
C        CHECK READ STATUS
C
        IF( IRD5.NE.0 ) THEN
        MESS = BLNK40
        ECODE = 'E20'
        WRITE( MESS,2000 ) IRD5,PATHWD(IRD1)
3000    FORMAT(1X,'IOSTAT= ',I8,' READING ',A2,'-OQA HEADERS')
        CALL ERROR( NUMBER,PATH,ECODE,LOC,MESS )
        RETURN
        END IF
C
C        LOOK FOR '*'
C
        IF( PREP(1:1).NE.'*' ) THEN
        RETURN
        END IF
C
C        MUST BE A HEADER, WRITE IT TO THE TEMPORARY FILE
C
C        LOGIC TO PROVIDE A 'TRACE' ON THE HISTORY OF THIS
C        CARD IMAGE.  THIRD CHARACTER OF HEADER CARD PREFIX
C        WILL CONTAIN A LETTER (A-Z), DENOTING WHEN IT WAS
C        INTRODUCED TO THE RUN.  BLNK = CURRENT, A = NEXT TO
C        LAST, B = PREV. ONE TO A, ETC.
C
        IF( PREP(3:3).EQ.' ') THEN
         PREP(3:3) = 'A'
        ELSE
         IRD5 = ICHAR( PREP(3:3) ) + 1
         IF( IRD5.GT.90 ) IRD5 = 90
         IF( IRD5.LT.65 ) THEN
C          PRINT *, ' SUB HDPROC TRACE PROBLEMS'
C          PRINT *, ' DEVICE NUMBER & IRD5: ',DEVICE,IRD5
C          PRINT *, ' PREP & CARD: ',PREP,CARD
         END IF
         PREP(3:3) = CHAR( IRD5 )
        END IF
C
        CALL WRTCRD( NUMBER,PREP,CARD )
C
C        CHECK TO SEE IF WE SHOULD ACTIVELY PROCESS THIS HEADER
C
        IF( PREP(2:2).EQ.'$' ) THEN
C
C        PROCESS ACTIVELY
C
        CALL DEFINE( NUMBER,80,CARD )
        CALL FDKEY( NUMBER,CARD )
C
        IF( IRD1.EQ.2 ) CALL UACARD( NUMBER,CARD )
        IF( IRD1.EQ.3 ) CALL SFCARD( NUMBER,CARD )
        IF( IRD1.EQ.4 ) CALL OSCARD( NUMBER,CARD )
C
        END IF
C
        GO TO 30
C
        END IF
C
100     RETURN
        END
