C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE UAEXT
C
C  PURPOSE
C     THIS SUBROUTINE IS THE MAIN DRIVING ROUTINE TO RETRIEVE
C     SOUNDING DATA AND/OR MIXING HEIGHT DATA FOR A STATION
C      AND TIME PERIOD SPECIFIED BY THE USER.  THE TWO TYPES
C     OF DATA ARE THEN MERGED AND WRITTEN TO A DSIK FILE FOR
C     QA'ING.
C
C  CALLED BY: UAPATH
C
C  VERSION DATE: 06 APRIL 1988
C
C=======================================================================
      SUBROUTINE UAEXT
C
C *** DECLARATIVE STATEMENTS

      INTEGER  UA2YR, UA4YR, CENTURY
      INTEGER  ZI2YR, ZI4YR

      INTEGER ZIWRT,NOLEV,SDGCNT,ZICNT,UASTRT,ZISTRT,NCHLEV,NCHHDR,
     &          NCHREC, ZIGO, UABFST, ZIBFST, ILEV, IVBL, UAARG
      INTEGER NOMIX1, NOMIX2, JULIAN
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA  ZIWRT/1/, NOLEV/0/, ZICNT/0/, SDGCNT/0/
      DATA PATH/'UA'/, LOC/' UAEXT'/
C
C *** VARIABLE DESCRIPTIONS
C
C      UASTRT/    STARTING CHARACTER POSTION IN THE BUFFER TO READ THE
C       ZISTRT     FIRST SOUNDING/MIXING HEIGHTS; PASSED AS AN ARGUMENT
C                  IN GETSDG/GETMIX
C      NCHHDR/    NUMBER OF CHARACTERS PER SOUNDING HEADER/LEVEL
C       NCHLEV
C      NCHREC     NUMBER OF CHARACTERS PER MIXING HEIGHT RECORD
C      ZIGO       CONTROLS BRANCHING IN GETMIX
C
C      ZIWRT       FLAG INDICATING IF THE CURRENT MIXING HEIGHTS HAVE
C                   BEEN WRITTEN (=1) OR NOT (=0)
C      NOLEV       DUMMY VARIABLE FOR NO LEVELS OF SOUNDING DATA
C      NOMIX1/     DUMMY VARIABLES FOR NO MIXING HEIGHT DATA
C       NOMIX2
C      SDGCNT/     COUNTER FOR THE NUMBER OF SDGS/MIXING HTS RETRIEVED
C       ZICNT
C      UABFST/     BUFFER STATUS WORD:  1 = BUFFER NEEDS DATA
C       ZIBFST                          2 = BUFFER HAS DATA
C                                      -1 = E-O-F
C      ILEV,IVBL   LOOP INDICES
C      UAARG       AN INTEGER VARIABLE TO USE FOR WHATEVER PURPOSE
C
C      JULIAN      INTEGER FUNCTION RETURNING JULIAN DAY
C
C *** SUBROUTINES CALLED
C
C      GETSDG, GETMIX  EXTRACTS SOUNDINGS, MIXING HEIGHTS
C      ERROR           WRITES ERROR/WARNING MESSAGES
C      FLWRK1,FLWRK2,  'ZEROES' ARRAYS AND VARIABLES
C      FLIWK1,FLIWK2,
C      FLSDG, FLZI
C
C=======================================================================
C *** INITIALIZATIONS
      ZIGHR  = 12
      NOMIX1 = UAQA(11,2)
      NOMIX2 = UAQA(12,2)
C
C-----------------------------------------------------------------------
C *** WRITE THE HEADERS TO THE OUTPUT FILE
      WRITE(DEV12,1201) IVDATE                                          DTBAUG94
C
C *** WRITE THE STANDARD HEADER TO THE ERROR FILE; IF AUTOMATIC SOUNDING
C      CHECKS ARE TURNED ON, WRITE A HEADER ALSO
C
      MESS = BLNK40
      WRITE(MESS,1200)
      CALL ERROR(0,PATH,'I30',LOC,MESS)
C
      IF(STATUS(2,8) .GE. 2 ) THEN
       IF(STATUS(2,10) .EQ. 0) THEN
         MESS = BLNK40
         WRITE(MESS,1203)
         CALL ERROR(0,PATH,'I36',LOC,MESS)
         WRITE(DEV12,1203)
       ENDIF
      ENDIF
C
C=======================================================================
C *** CLEAR THE WORK BUFFERS OF PREVIOUS VALUES
      CALL FLWRK1
      CALL FLWRK2
      CALL FLIWK1
      CALL FLIWK2
C
C *** COMPUTE THE START AND STOP CHRONOLOGICAL DAYS FOR THE EXTRACTION
C
      UAARG = JULIAN(UAYR1,UAGMO1,UAGDY1)
      CALL CHROND('UA',UAYR1,UAARG,UADAY1)
      UAARG = JULIAN(UAYR2,UAGMO2,UAGDY2)
      CALL CHROND('UA',UAYR2,UAARG,UADAY2)
C
C=======================================================================
C *** CHECK THE STATUS OF EACH BUFFER AND RETRIEVE THE FIRST
C     AVAILABLE SOUNDING AND/OR MIXING HEIGHT REPORT WITHIN THE
C     STATION/DATE WINDOW
C
C-----------------------------------------------------------------------
C-  FIRST THE SOUNDING DATA:
C
C *** IMPORTANT NOTE:
C      THE NUMBER OF CHARACTERS TO SKIP AT THE BEGINNING OF EACH BLOCK
C      OF TD-5600 FORMAT DATA IS DEPENDENT ON WHETHER THE TAPES WERE
C      ORDERED BEFORE OR AFTER THE INTRODUCTION OF THE TD-6200 SERIES
C      FORMATS.  IF DATA ARE ON TAPES ORDERED PRIOR TO THE TD-6200
C      SERIES, THE PARAMETER 'UABSIZ' IN THE MASTER LIST OF COMMON
C      BLOCKS MUST BE SET TO 4; FOR TAPES ORDERED AFTER THE INTRODUC-
C      TION OF THE TD-6200 SERIES, 'UABSIZ' MUST BE SET TO 0 FOR THE
C      EXTRACT PROCESSES TO WORK CORRECTLY FOR VARIABLE BLOCKED DATA.
C      FOR FIXED BLOCK DATA IS 0 AND IS NOT USED BELOW.
C
C-----------------------------------------------------------------------
C
      IF(STATUS(2,8) .GE. 2) THEN
       UABFST = 1
C *** SEE IMPORTANT NOTE ABOVE
C
       IF(INDEX(UAFMT,'5600') .NE. 0) THEN
        UADCD = 5600
        IF(INDEX(UAFMT,'VB') .NE. 0) THEN
         UASKIP  = 4
         UASTRT  = UASKIP + 1 + UABSIZ
         UABLK   = 'VB'
        ELSE
         UASKIP  = 0
         UASTRT  = 1
         UABLK   = 'FB'
        ENDIF
        NCHLEV = 25
        NCHHDR = 25
       ENDIF
C
       CALL GETSDG(UABFST,UASTRT,NCHLEV,NCHHDR,SDGCNT)
        IF(UABFST .EQ. 2) THEN
         CONTINUE
        ELSE
         UADAYC = 0
        ENDIF
      ELSE
        UABFST = -1
      ENDIF
C
C-----------------------------------------------------------------------
C- NOW THE MIXING HEIGHT DATA:
C-  CHECK THE MIXING HEIGHT FORMAT - 9689 FOR THE TDF-9689 FORMAT
C   ZIGO = 1 FOR RETRIEVAL FROM TAPE, ZIGO = 2 FOR RETRIEVAL FROM DISK
C   IN 34 CHAR/REC FORMAT, ZIGO = 3 FOR RETRIEVAL FROM DISK IN THE
C   USER-SPECIFIED FORMAT
C
C-----------------------------------------------------------------------
C
      IF(STATUS(2,9) .GE. 2) THEN
        ZIBFST = 1
C
        IF(INDEX(ZIFRMT,'9689') .NE. 0) THEN
         IF(STATUS(2,9) .GE. 3) THEN
          ZIGO = 1
         ELSE
          ZIGO = 2
         ENDIF
         NCHREC = 34
        ELSE IF(INDEX(ZIFRMT,'(') .NE. 0) THEN
         ZIGO = 3
        ENDIF
C
        CALL GETMIX(ZIGO,ZIBFST,NCHREC,ZICNT)
        IF(ZIBFST .EQ. 2) THEN
         CONTINUE
        ELSE
         ZIDAYC = 0
        ENDIF
      ELSE
        ZIBFST = -1
      ENDIF
C
C=======================================================================
C *** BEGIN THE PROCESS OF CHECKING STATUSES AND MERGING DATA AND
C     WRITING THE DATA TO THE OUTPUT FILE
C
C-----------------------------------------------------------------------
C- BOTH HAVE DATA AVAILABLE
C-----------------------------------------------------------------------
C
    1 CONTINUE
      IF(UABFST.EQ.2 .AND. ZIBFST.EQ.2) THEN
C
C-----------------------------------------------------------------------
C- THE DATA ARE FOR THE SAME DAY
C-----------------------------------------------------------------------
C
       IF( UADAYC .EQ. ZIDAYC ) THEN

        WRITE(DEV12,1210) UAGYR,UAGMO,UAGDY,UAGHR,UALEV(1),MIXC1,MIXC2

            CALL Y2K(PATH, UAGYR, UA2YR, UA4YR, CENTURY)

            WRITE(*, 610 ) UAGMO, UAGDY, UA4YR
  610       FORMAT('+  Stage 1: Extracting upper-air data for ',
     &             'month-day-year ', 2(I2.2,:'-'),I4)

        DO 100 ILEV = 1,UALEV(1)
         WRITE(DEV12,1220) (UAOBS(1,ILEV,IVBL),IVBL=1,UAMV)
  100   CONTINUE
        ZIWRT = 0
        CALL FLSDG(1)
        CALL GETSDG(UABFST,UASTRT,NCHLEV,NCHHDR,SDGCNT)
C
C-----------------------------------------------------------------------
C- THE MIXING HEIGHTS ARE BEFORE THE SOUNDING IN TIME
C-----------------------------------------------------------------------
C
       ELSE IF ( ZIDAYC .LT. UADAYC ) THEN

        CALL Y2K(PATH, ZIGYR, ZI2YR, ZI4YR, CENTURY)

        WRITE( *,610 ) ZIGMO, ZIGDY, ZI4YR

        IF(ZIWRT .EQ. 1) THEN
         WRITE(DEV12,1210) ZIGYR,ZIGMO,ZIGDY,ZIGHR,NOLEV,MIXC1,MIXC2
        ENDIF
        CALL FLZI
        CALL GETMIX(ZIGO,ZIBFST,NCHREC,ZICNT)
        ZIWRT = 1
C
C-----------------------------------------------------------------------
C- MIXING HEIGHTS ARE AFTER THE SOUNDING IN TIME
C-----------------------------------------------------------------------
C
       ELSE IF ( ZIDAYC .GT. UADAYC ) THEN

         CALL Y2K(PATH, UAGYR, UA2YR, UA4YR, CENTURY)

         WRITE(*, 610 ) UAGMO, UAGDY, UA4YR

       WRITE(DEV12,1210) UAGYR,UAGMO,UAGDY,UAGHR,UALEV(1),NOMIX1,NOMIX2
        DO 101 ILEV = 1,UALEV(1)
         WRITE(DEV12,1220) (UAOBS(1,ILEV,IVBL),IVBL=1,UAMV)
  101   CONTINUE
        CALL FLSDG(1)
        CALL GETSDG(UABFST,UASTRT,NCHLEV,NCHHDR,SDGCNT)
       ENDIF
      GO TO 1
      ENDIF
C
C=======================================================================
C- NO SOUNDING TO PROCESS, MIXING HEIGHTS AVAILABLE
C-----------------------------------------------------------------------
C
    2 CONTINUE
      IF(UABFST .EQ. -1 .AND. ZIBFST.EQ.2) THEN

         CALL Y2K(PATH, ZIGYR, ZI2YR, ZI4YR, CENTURY)

         WRITE( *,610 ) ZIGMO, ZIGDY, ZI4YR

         IF(ZIWRT .EQ. 1) THEN
            WRITE(DEV12,1210) ZIGYR,ZIGMO,ZIGDY,ZIGHR,NOLEV,MIXC1,MIXC2
         ENDIF
         CALL FLZI
         CALL GETMIX(ZIGO,ZIBFST,NCHREC,ZICNT)
         ZIWRT = 1
         GO TO 2
      ENDIF
C
C=======================================================================
C- SOUNDING AVAILABLE, NO MIXING HEIGHTS TO PROCESS
C-----------------------------------------------------------------------
C
    3 CONTINUE
      IF( (UABFST.EQ.2) .AND. (ZIBFST.EQ.-1) ) THEN

         CALL Y2K(PATH, ZIGYR, ZI2YR, ZI4YR, CENTURY)

         WRITE( *,610 ) ZIGMO, ZIGDY, ZI4YR

         WRITE(DEV12,1210) UAGYR,UAGMO,UAGDY,UAGHR,UALEV(1),NOMIX1,
     &                     NOMIX2
         DO 102 ILEV = 1,UALEV(1)
            WRITE(DEV12,1220) (UAOBS(1,ILEV,IVBL),IVBL=1,UAMV)
  102    CONTINUE
         CALL FLSDG(1)
         CALL GETSDG(UABFST,UASTRT,NCHLEV,NCHHDR,SDGCNT)
         GO TO 3
      ENDIF
C
C=======================================================================
C- NO MORE DATA FOR BOTH; IF NO DATA EXTRACTED, SET UASTAT TO -1
C-----------------------------------------------------------------------
C
      IF( (UABFST.EQ.-1) .AND. (ZIBFST.EQ.-1) ) THEN
       MESS = BLNK40
       WRITE(MESS,1202) SDGCNT,ZICNT
       CALL ERROR(0,PATH,'I30',LOC,MESS)
       IF( (SDGCNT+ZICNT) .EQ. 0) UASTAT = -1
       RETURN
      ENDIF
C=======================================================================
C- FORMAT STATMENTS
C
 1200 FORMAT(' **** UPPER AIR EXTRACTION ****')
 1201 FORMAT('*  UA *** UPPER AIR EXTRACTION - MPRM DATED ', I5)        DTBAUG94
 1202 FORMAT(I4,' SDGS AND ',I4,' MIXING HTS EXTRACTED')
 1203 FORMAT('*     *** AUTOMATIC SDG. CHECKS ARE ON')
 1210 FORMAT(1X,4I2,I5,2(1X,I5))
 1220 FORMAT(6(1X,I5))
C======================================================================
C- END OF SUBROUTINE
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE GETSDG
C
C  PURPOSE
C     THIS SUBROUTINE WILL RETRIEVE A SOUNDING IN THE STATION/DATE
C     WINDOW AND RETURN IT TO THE CALLING PROGRAM, UAEXT.
C
C  CALLED BY: UAEXT
C
C  VERSION DATE: 30 SEPT 1992
C
C=======================================================================
C
      SUBROUTINE GETSDG(UABFST,UACHR1,NCHLEV,NCHHDR,NSDGS)
C
C *** DECLARATIVE STATEMENTS
      CHARACTER*79 SCSTR1(100), STRNG1
      INTEGER SCANUA, SDGPOS, UACHR1, UABFST, NSDGS
      INTEGER DELCNT, SGNCNT, SDGERR, NCHHDR, NCHLEV, LEVPOS
      INTEGER IOST10, ISTAT, ISTR, NCH, NUMLEV, LVL, ILEV, IVBL, LEVELS
      INTEGER NCALM, NTMP, NDEW, JULIAN, KK, MULT(6), UAARG
      REAL ZSFC
      LOGICAL SCFLAG
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA SCANUA/0/
      DATA SCFLAG /.TRUE./
      DATA SDGERR/0/,  DELCNT/0/, SGNCNT/0/
      DATA NCALM/0/, NTMP/0/, NDEW/0/
      DATA MULT/10, 1, 10, 10, 1, 10/
      DATA PATH /'UA'/, LOC/'GETSDG'/
C
C
C *** VARIABLE DESCRIPTIONS
C
C      THE FOLLOWING VARIABLES ARE CALLING ARGUMENTS FOR THE ROUTINE
C
C      UABFST     BUFFER STATUS: 1 = NEEDS DATA; 2 = HAS DATA; -1 = EOF
C      UACHR1     CHARACTER STARTING POSITION IN BUFFER OF FIRST SDG.
C      NCHLEV/    NUMBER OF CHARACTERS PER SOUNDING LEVEL/HEADER
C       NCHHDR
C      NSDGS      COUNTER FOR NUMBER OF SOUNDINGS RETRIEVED
C
C      SCSTR1(I)   STRING WITH A INFORMATION REGARDING TAPE CONTENTS
C      STRNG1      SAME AS ABOVE, EXCEPT USED AS PASSING ARGUMENT
C      SCANUA      COUNTER FOR THE NUMBER OF SCAN STRINGS WRITTEN
C      SDGPOS      CHARACTER POSITION  OF NEXT SOUNDING
C      LEVPOS      CHARACTER POSITION OF NEXT SOUNDING LEVEL
C      IOST10      I/O STATUS WORD OF TAPE READ OR DECODE
C      ISTAT       STATUS OF HEADER OR LEVEL DECODE: 0 = DATA RETRIEVED
C                                                    1 = DATA ERROR
C                                                   -1 = EOF
C      NUMLEV      NUMBER OF LEVELS EXTRACTED AND RETAINED IN A SOUNDING
C      LEVELS      TOTAL NUMBER OF LEVELS IN A SOUNDING ON TAPE
C      MULT(I)     MULTIPLIER TO MAKE DATA INTEGERS WITH SUFFICIENT
C                   NUMBER OF DECIMAL PLACES RETAINED FOR ACCURACY
C      SDGERR      COUNTER FOR THE NUMBER OF READ OR DECODE ERRORS
C                   (CANNOT EQUAL OR EXCEED MAXERR)
C      UAARG       AN INTEGER VARIABLE TO USE FOR WHATEVER PURPOSE
C
C      THE FOLLOWING VARIABLES ARE COUNTERS USED IN SIMPLE QA ON A SDG
C       SGNCNT     NUMBER OF LEVELS AT WHICH SIGN OF TEMPERATURE WAS
C                   CHANGED
C       NCALM      NUMBER OF OCCURRENCES OF NONZERO WIND DIRECTION WITH
C                   A CORRESPONDING ZERO WIND SPEED (DIRECTION SET TO 0)
C       NDEW       NUMBER OF LEVELS OF MISSING DEW-POINTS
C                   (INTERPOLATED DATA REPLACE MISSING DATA)
C       NTMP       NUMBER OF LEVELS OF MISSING TEMPERATURES
C                   (INTERPOLATED DATA REPLACE MISSING DATA)
C       DELCNT     NUMBER OF MANDATORY LEVELS DELETED
C
C      ISTR,NCH,   LOOP INDICES
C       LVL,ILEV,
C       IVBL,KK
C
C      JULIAN      INTEGER FUNCTION TO CALCULATE THE JULIAN DAY
C
C *** SUBROUTINES CALLED
C
C      FLBUF1      ZEROES BUFFER
C      ATAPE2      READS A BLOCK OF DATA FROM TAPE
C      ERROR       WRITES ERROR/WARNING MESSAGES
C      SCNGEN      WRITES A SCAN RECORD
C      EBCASC      CONVERTS EBCDIC TO ASCII
C                  (MAY NOT BE PRESENT ON THE IBM VERSION)
C      D56HDR      DECODES 5600 FORMAT SOUNDING HEADERS
C      D56LEV      DECODES 5600 FORMAT SOUNDING LEVELS
C      MANDEL      DELETES MANDATORY LEVELS
C      SGNCHK      CHANGES SIGN OF TEMPERATURE
C      CALMS       CHECKS FOR NONZERO WIND DIRECTION AND ZERO SPEED
C                   CHANGES DIRECTION TO ZERO
C      TDPEST      INTERPOLATES TEMPERATURE AND DEW-POINT IF DATA ARE
C                   MISSING
C
C=======================================================================
C- CHECK THE STATUS OF THE BUFFER AND GO TO THE APPROPRIATE STARTING
C-  POINT: START AT 100 IF THERE IS NO DATA IN THE BUFFER, 200 IF
C-  IS DATA IN THE BUFFER.  BEGINNING AT STATEMENT 100 SHOULD OCCUR
C-  ONLY ONCE, THE FIRST TIME THE SUBROUTINE IS CALLED
C
C-----------------------------------------------------------------------
C
      GO TO (100,200) UABFST
  100 CALL FLBUF1
      CALL ATAPE2(*101,DEV10,BUFFR1,NCHB1,ISTAT,IOST10)
C
C-----------------------------------------------------------------------
C- THIS IS THE ALTERNATE RETURN FOR THE CALL TO RETRIEVING A BLOCK OF
C-  DATA.  IT CHECKS THE I/O STATUS RETURNED FROM THE READ.
C
C-----------------------------------------------------------------------
C
  101 IF(ISTAT .EQ. 0) THEN
C
C-    DATA READ FROM TAPE
        UABFST = 2
        SDGPOS = UACHR1
C
      ELSE IF (ISTAT .EQ. -1) THEN
C
C-    AN END-OF-FILE WAS ENCOUNTERED ON THE TAPE
        UABFST = -1
        MESS = BLNK40
        WRITE(MESS,600)
        CALL ERROR(NSDGS,PATH,'I39',LOC,MESS)
        IF(NSDGS .LT. 1) THEN
         IF( SCANUA .LT. 100) THEN
          CALL SCNGEN(SCANUA,SCFLAG,' ',UAGYR,UAGMO,UAGDY,
     &            UAGHR,1200,STRNG1)
          IF(SCFLAG) THEN
           SCSTR1(SCANUA) = STRNG1
          ENDIF
         ENDIF
         MESS = BLNK40
         WRITE(MESS,601) DEV60
         CALL ERROR(NSDGS,PATH,'W38',LOC,MESS)
         WRITE(DEV70,5004)
         WRITE(DEV70,5005) DEV10,TAPE10
         DO 105 ISTR = 1,SCANUA
           WRITE(DEV70,5010) SCSTR1(ISTR)
  105    CONTINUE
         WRITE(DEV70,5004)
        ENDIF
        RETURN
C
      ELSE IF(ISTAT .EQ. 1) THEN
C
C-    AN ERROR READING THE TAPE OCCURRED
        SDGERR =SDGERR + 1
        IF(SDGERR .GT. MAXERR) THEN
         UABFST = -1
         UASTAT = -1
         MESS = BLNK40
         WRITE(MESS,603) IOST10
         CALL ERROR(NSDGS,PATH,'E32',LOC,MESS)
         RETURN
        ELSE
         MESS = BLNK40
         WRITE(MESS,602) SDGERR, IOST10
         CALL ERROR(NSDGS,PATH,'W32',LOC,MESS)
         GO TO 100
        ENDIF
      ENDIF
C
C-----------------------------------------------------------------------
C- THIS IS THE STARTING POSITION FOR ALL CALLS TO THE SUBROUTINE AFTER
C-  THE FIRST CALL
C
C-----------------------------------------------------------------------
C
  200 IF((SDGPOS + NCHHDR) .GT. NCHB1) THEN
        CALL FLBUF1
        CALL ATAPE2(*101,DEV10,BUFFR1,NCHB1,ISTAT,IOST10)
      ENDIF
C
C-----------------------------------------------------------------------
C- POSITION THE FIRST 'NCHHDR' CHARACTERS OF THE SOUNDING IN A WORK
C-  BUFFER.  CONVERT TO 'ASCII' IF REQUIRED.
C   CHECK FOR BLANKS IN THE STATION ID AND NUMBER OF LEVELS
C-  FIELDS. GET MORE DATA IF THEY ARE BLANKS.
C-  DECODE THE HEADER, CHECK FOR NEW STATION
C-  AND/OR YEAR FOR THE SCAN, AND CONVERT FROM GMT TO LST.
C
C-----------------------------------------------------------------------
C
      BUF32 = BLNK32
      DO 25 NCH = 1,NCHHDR
        BUF32(NCH:NCH) = BUFFR1 (SDGPOS + NCH - 1)
   25 CONTINUE
C
      IF(STATUS(2,8) .EQ. 4) CALL EBCASC(NCHHDR,BUF32)
C
      IF(UADCD .EQ. 5600) THEN
       IF(BUF32(5:9) .EQ. '     ') THEN
         IF(BUF32(18:19) .EQ. '  ') THEN
           CALL ATAPE2(*101,DEV10,BUFFR1,NCHB1,ISTAT,IOST10)
         ENDIF
       ENDIF
      ENDIF
C
  500 IF (UADCD .EQ. 5600) THEN
        CALL D56HDR(NCHHDR,ISTAT,IOST10)
      ENDIF
      IF(ISTAT .EQ. 1) GO TO 10001
C
      IF(SCANUA .LT. 100) THEN
       CALL SCNGEN(SCANUA,SCFLAG,BUF08(1),UAGYR,UAGMO,UAGDY,
     &            UAGHR,1200,STRNG1)
       IF(SCFLAG) THEN
         SCSTR1(SCANUA) = STRNG1
         SCFLAG = .FALSE.
       END IF
      ENDIF
C-----------------------------------------------------------------------
C- CONVERT TO LOCAL STANDARD TIME
C   COMPUTE THE JULIAN AND CHRONOLOGICAL DAY
C
      CALL GMTLST(UAGYR,UAGMO,UAGDY,UAGHR,UALST)
      UAARG = JULIAN(UAGYR,UAGMO,UAGDY)
      CALL CHROND('UA',UAGYR,UAARG,UADAYC)
C
C-----------------------------------------------------------------------
C- DETERMINE THE NUMBER OF LEVELS OF DATA (PRESENT OR BLANK) ON THE TAPE
C-  THEN CHECK FOR INCLUSION IN THE STATION/DATE WINDOW
C   THIS DOES NOT CONSIDER FIXED BLOCK DATA WITH MORE THAN 79 LEVELS!
C
      IF(UADCD .EQ. 5600) THEN
       IF(UABLK .EQ. 'FB') THEN
        LEVELS = 79
       ELSE IF(UABLK .EQ. 'VB') THEN
        LEVELS = IRD1
       ELSE
        MESS = BLNK40
        WRITE(MESS,610)
        CALL ERROR (NSDGS,PATH,'E35',LOC,MESS)
        UABFST = -1
        RETURN
       ENDIF
      ENDIF
C
C--- CONVERT TO HOUR=24 IF NECESSARY
      IF(UAGHR .EQ. 0) THEN
       CALL HR0024(UAGYR,UAARG,UAGHR)
       CALL GREG(UAGYR,UAARG,UAGMO,UAGDY)
      ENDIF
C
C--- THE INDEX FUNCTION IS USED TO INSURE A CORRECT MATCH ON STATION
C     IDENTIFIERS - BUF08 IS LEFT JUSTIFIED, UALOC1 IS RIGHT JUSTIFIED.
C     IF THE IDENTIFIER FIELD REQUIRES 8 CHARACTERS THERE IS NO BLANK
C
      IWORK1(10) = INDEX(BUF08(1),' ')
      IF(IWORK1(10) .EQ. 0) THEN
       IWORK1(11) = INDEX(UALOC1,BUF08(1)(1:8))
      ELSE
       IWORK1(11) = INDEX(UALOC1,BUF08(1)(1:IWORK1(10)-1))
      ENDIF
C
C--- IF THERE IS NO STATION MATCH, READ FROM TAPE (A NEW STATION WILL
C     NOT START IN THE MIDDLE OF A BLOCK)
C
      IF(IWORK1(11) .EQ. 0) THEN
        SDGPOS = SDGPOS + NCHHDR + LEVELS*NCHLEV + UASKIP
        GO TO 100
C
C--- IF THE STATIONS MATCH BUT THE DATE IS MORE THAN 15 DAYS BEFORE THE
C     BEGINNING EXTRACT DATE, READ FROM THE TAPE (ON TD-5600 FORMAT
C     TAPES THERE IS NO MORE THAN 4-6 REPORTS PER (VARIABLE) BLOCK)
C
      ELSE IF ( UADAYC .LT. UADAY1-15 ) THEN
        SDGPOS = SDGPOS + NCHHDR + LEVELS*NCHLEV + UASKIP
        GO TO 100
C
C--- IF THE STATIONS MATCH AND THE DATES ARE WITHIN 15 DAYS, START
C     STEPPING THROUGH THE BLOCK OF DATA IN SEARCH OF A MATCH
C
      ELSE IF ( UADAYC .LT. UADAY1 ) THEN
        SDGPOS = SDGPOS + NCHHDR + LEVELS*NCHLEV + UASKIP
        GO TO 200
C
C--- THE STATIONS MATCH AND THE DATA ARE BEYOND THE EXTRACT WINDOW.
C
      ELSE IF ( UADAYC .GT. UADAY2 ) THEN
        UABFST = -1
        RETURN
      ENDIF
C
C-----------------------------------------------------------------------
C- THE HEADER IS O.K.  NOW DECODE EACH LEVEL, CHECKING TO BE SURE NOT TO
C-  EXCEED THE MAXIMUM NUMBER OF LEVELS ALLOWED, CLIPPING THE SOUNDING
C-  TO THE SPECIFIED HEIGHT AND CONVERTING THE DATA TO THE PROPER UNITS
C-  AND INTEGERIZING.  BEFORE PROCEEDING, HOWEVER, FLUSH THE WORK ARRAY.
C
C-  BECAUSE MISSING DATA ARE SET TO -9999.0 IN THE WORK ARRAYS, WE CAN
C-  CHECK AGAINST -9000. RATHER THAN UAQA(X,2) AT THIS POINT
C-----------------------------------------------------------------------
C
      LEVPOS = SDGPOS + NCHHDR
      CALL FLWRK2
      NUMLEV = 0
C
510   BUF40 = BLNK40
      DO 50 NCH = 1,NCHLEV
       BUF40(NCH:NCH) = BUFFR1(LEVPOS + NCH - 1)
   50 CONTINUE
C
      IF(STATUS(2,8) .EQ. 4) CALL EBCASC(NCHLEV,BUF40)
C
      IF(UADCD .EQ. 5600) THEN
        CALL D56LEV(NCHLEV,NUMLEV,ISTAT,IOST10)
      ENDIF
      IF(ISTAT .EQ. 1) GO TO 10002
C
      IF(NUMLEV .EQ. 1) THEN
       IF(WORK2(1,2) .GT. -9000.0) THEN
        ZSFC = WORK2(NUMLEV,2)
       ELSE
        ZSFC = 0.0
        MESS = BLNK40
        WRITE(MESS,607)
        CALL ERROR(NSDGS,PATH,'W33',LOC,MESS)
       ENDIF
      ENDIF
C
      IF(NUMLEV .LT. UAML) THEN
        IF((WORK2(NUMLEV,2) .LE. (UATOP + ZSFC)) .AND.
     &   (NUMLEV.LT.IRD1)) THEN
         LEVPOS = LEVPOS + NCHLEV
         GO TO 510
        ENDIF
      ENDIF
C
      IF(STATUS(2,10) .EQ. 0) THEN
        DO 515 LVL = 1,NUMLEV
         IF(WORK2(LVL,2) .GT. -9000.) THEN
          WORK2(LVL,2) = WORK2(LVL,2) - ZSFC
         ENDIF
  515   CONTINUE
        CALL MANDEL(NUMLEV,DELCNT)
        CALL SGNCHK(NUMLEV,SGNCNT)
        CALL CALMS(NUMLEV,NCALM)
        CALL TDPEST(NUMLEV,NTMP,NDEW)
      ENDIF
C
C-----------------------------------------------------------------------
C- TRANSFER THE DATA FROM THE WORK ARRAY TO THE UPPER AIR ARRAY,
C-  COMPUTE THE POSITION OF THE START OF THE NEXT SOUNDING
C-  AND RETURN TO THE CALLING PROGRAM
C
C-----------------------------------------------------------------------
C
      CALL FLSDG(1)
      UALEV(1) = NUMLEV
      DO 516 ILEV = 1,UALEV(1)
       DO 517 IVBL = 1,UAMV
        IF(WORK2(ILEV,IVBL) .LT. -900.) THEN
         UAOBS(1,ILEV,IVBL) = UAQA(IVBL,2)
        ELSE
         UAOBS(1,ILEV,IVBL) = NINT(WORK2(ILEV,IVBL)*MULT(IVBL))
        ENDIF
  517  CONTINUE
  516 CONTINUE
C
      NSDGS = NSDGS + 1
      UABFST = 2
      SDGPOS = SDGPOS + NCHHDR + LEVELS*NCHLEV + UASKIP
      RETURN
C
C-----------------------------------------------------------------------
C- ERROR READING THE SOUNDING HEADER.  MOVE THROUGH THE BUFFER 'NCHLEV'
C-  CHARACTERS AT A TIME TO TRY AND LOCATE THE BEGINNING OF THE NEXT
C-  SOUNDING IF THE ERROR COUNT HAS NOT EXCEEDED A SPECIFIC NUMBER
C-  DEFINED BY 'MAXERR'
C----------------------------------------------------------------------
C
10001 SDGERR = SDGERR + 1
      IF(SDGERR .GT. MAXERR) THEN
       UABFST = -1
       MESS = BLNK40
       WRITE(MESS,606) IOST10
       CALL ERROR(NSDGS,PATH,'E32',LOC,MESS)
       UASTAT = -1
       RETURN
      ELSE
       MESS = BLNK40
       WRITE(MESS,604) SDGERR,IOST10
       CALL ERROR(NSDGS,PATH,'W32',LOC,MESS)
       MESS = BLNK40
       WRITE(MESS,611)
       CALL ERROR(0,PATH,'   ','      ',MESS)
  520  SDGPOS = SDGPOS + NCHLEV
       IF((SDGPOS+NCHLEV) .GT. NCHB1) THEN
         CALL FLBUF1
         CALL ATAPE2(*101,DEV10,BUFFR1,NCHB1,ISTAT,IOST10)
       ELSE
         BUF32 = BLNK32
         DO 60 NCH = 1,NCHLEV
          BUF32(NCH:NCH) = BUFFR1(SDGPOS + NCH -1)
   60    CONTINUE
C
         IF(STATUS(2,8) .EQ. 4) CALL EBCASC(NCHHDR,BUF32)
C
         IF(BUF32(5+UASKIP:9+UASKIP) .EQ. '     ') THEN
          CALL FLBUF1
          CALL ATAPE2(*101,DEV10,BUFFR1,NCHB1,ISTAT,IOST10)
         ELSE
          IF(BUF32(5+UASKIP:9+UASKIP) .EQ. UALOC1) THEN
             SDGPOS = SDGPOS + 4
             GO TO 500
          ELSE
           GO TO 520
          ENDIF
         ENDIF
       ENDIF
      ENDIF
C
C-----------------------------------------------------------------------
C- THERE WAS AN ERROR DECODING A LEVEL OF DATA.  CHECK FOR MAXIMUM NUM-
C-  BER OF SOUNDING ERROR DECODES/READS.  IF THE MAXIMUM IS NOT
C-  ATTTAINED, THEN RETURN TO THE CALLING PROGRAM WITH THE PARTIAL
C-  SOUNDING OTHERWISE SET THE BUFFER STATUS TO E-O-F, COMPUTE THE
C-  POSITION OF THE NEXT SOUNDING AND RETURN.
C
C-----------------------------------------------------------------------
C
10002 CONTINUE
      IRD4 = NUMLEV
      NSDGS = NSDGS + 1
      SDGERR = SDGERR + 1
      IF(STATUS(2,10) .EQ. 0) THEN
         DO 525 LVL = 1,NUMLEV
          IF(WORK2(LVL,2) .GT. -9000.) THEN
           WORK2(LVL,2) = WORK2(LVL,2) - ZSFC
          ENDIF
  525    CONTINUE
C         IF(NUMLEV .GT. 3) THEN
C          CALL MANDEL(NUMLEV,DELCNT)
C          CALL SGNCHK(NUMLEV,SGNCHK)
C          CALL CALMS(NUMLEV,NCALM)
C          CALL TDPEST(NUMLEV,NTMP,NDEW)
C         ENDIF
      ENDIF
C
       CALL FLSDG(1)
       UALEV(1) = NUMLEV
       DO 526 ILEV = 1,UALEV(1)
        DO 527 IVBL = 1,UAMV
        IF(WORK2(ILEV,IVBL) .LT. -900.) THEN
         UAOBS(1,ILEV,IVBL) = UAQA(IVBL,2)
        ELSE
         UAOBS(1,ILEV,IVBL) = NINT(WORK2(ILEV,IVBL)*MULT(IVBL))
        ENDIF
  527   CONTINUE
  526  CONTINUE
C
      IF(SDGERR .GT. MAXERR) THEN
       MESS = BLNK40
       WRITE(MESS,608) IRD4,IOST10
       CALL ERROR(NSDGS,PATH,'E32',LOC,MESS)
       MESS = BLNK40
       WRITE(MESS,609) UAGYR,UAGMO,UAGDY,UAGHR
       CALL ERROR(NSDGS,'  ','+++','      ',MESS)
       UASTAT = -1
       UABFST = -1
       RETURN
      ELSE
       MESS = BLNK40
       WRITE(MESS,605) SDGERR,IRD4,IOST10
       CALL ERROR(NSDGS,PATH,'W32',LOC,MESS)
       MESS = BLNK40
       WRITE(MESS,609) UAGYR,UAGMO,UAGDY,UAGHR
       CALL ERROR(NSDGS,'  ','+++','      ',MESS)
C
       UABFST = 2
       SDGPOS = SDGPOS + NCHHDR + LEVELS*NCHLEV + UASKIP
       RETURN
      ENDIF
C
C=======================================================================
C- FORMAT STATEMENTS
C
  600 FORMAT(' END-OF-FILE, END-OF-DATA')
  601 FORMAT(' NO OBS. RETRIEVED; SEE UNIT',I3,' FOR SCAN')
  602 FORMAT(' ERROR ',I2,': READING DATA, IOSTAT=',I6)
  603 FORMAT(' MAX ERRORS READING DATA, IOSTAT=',I6)
  604 FORMAT(' ERROR ',I2,': DECODING HDR, IOSTAT=',I6)
  605 FORMAT(' ERROR ',I2,': DECODING LVL',I2,', IOSTAT=',I6)
  606 FORMAT(' MAX ERRORS, HEADER, IOSTAT=',I6)
  607 FORMAT(' SURFACE HT. IS MISSING ')
  608 FORMAT(' MAX ERRORS, LEVEL',I3,', IOSTAT=',I6)
  609 FORMAT('     AT (YR/MO/DAY/HR): ',I2,'/',I2,'/',I2,'/',I2)
  610 FORMAT(' VB OR FB NOT SPECIFIED; UABFST= -1 SET')
  611 FORMAT(' ATTEMPTING TO RECOVER FROM THE ERROR')
 5004 FORMAT('$UASCAN$')
 5005 FORMAT(//,5X,'TAPE CONTENTS FOR UNIT ',I3,', FILE:',A48,
     &        /,26X,'FROM',15X,'TO',
     &        /,9X,' STATION',2X,'YR',2(1X,'MO',1X,'DA',1X,'HR',1X,
     &          'JDAY',4X))
 5010 FORMAT(A79)
C
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE UAHDRS
C
C  PURPOSE
C     THIS SUBROUTINE CONTAINS THE ENTRY POINTS TO DECODE THE UPPER AIR
C     SOUNDING HEADERS.
C
C     ENTRY D56HDR  = DECODES TDF-5600 FIXED OR VARIABLE BLOCK DATA
C     ENTRY D62HDR  = (FOR TDF-6201, NOT CODED)
C
C  CALLED BY: GETSDG
C
C  VERSION DATE: 02 NOVEMBER 1987
C
C=======================================================================
C
      SUBROUTINE UAHDRS
C
      INTEGER ISTAT, IOST10, NCHHDR
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'WORK1.INC'
C
C     IRD1      NUMBER OF LEVELS IN THE SOUNDING ON THE TAPE
C     ISTAT     STATUS OF THE DECODE: 0 = GOOD; 1 = ERROR
C     IOST10    I/O STATUS WORD
C
C=======================================================================
C *** TD5600 FORMAT HEADER
C
      ENTRY D56HDR(NCHHDR,ISTAT,IOST10)
C
      BUF08(1) = BLNK08
      IRD1 = 0
      READ(BUF32,100,ERR=10001,IOSTAT=IOST10) BUF08(1),
     &     UAGYR,UAGMO, UAGDY,UAGHR,IRD1
      ISTAT = 0
C
      RETURN
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF THERE WAS AN ERROR DECODING THE HEADER
C
10001 CONTINUE
      ISTAT = 1
      RETURN
C
C=======================================================================
C
  100 FORMAT(4X,A5,5I2)
C
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE UALEVS
C
C  PURPOSE
C     THIS SUBROUTINE HAS ENTRY POINTS TO DECODE THE UPPER AIR LEVELS
C     CURRENTLY ONLY THE 5600 FORMAT IS DECODED.  FOR FUTURE EXPANSION,
C     THE 6201 FORMAT WILL BE DECODED HERE
C
C     ENTRY D56LEV  = DECODES THE TDF-5600 DATA
C     ENTRY D62LEV  = (DECODES THE TDF-6201 DATA, NOT CODED)
C
C  CALLED BY: GETSDG
C
C  VERSION DATE: 29 MARCH 1988
C
C=======================================================================
C
      SUBROUTINE UALEVS
C-----------------------------------------------------------------------
C
      REAL PRES,Z,TEMP,RH,WSPD,WDIR,DEWPT
      INTEGER I,II,IOST10,ISTAT,NUMLEV,NCHLEV
      REAL AX(3), SX(3)
      CHARACTER*1 IX, IVRPCH(3), LA(10), LN(10), LP(10)
C
      INCLUDE 'WORK1.INC'
C
      DATA LA/'0','1','2','3','4','5','6','7','8','9'/
      DATA LN/']','J','K','L','M','N','O','P','Q','R'/
      DATA LP/'[','A','B','C','D','E','F','G','H','I'/

C *** VARIABLE DESCRIPTIONS
C
C     Z          HEIGHT (M)
C     PRES       PRESSURE (MB)
C     TEMP       TEMPERATURE (DEG. C)
C     RH         RELATIVE HUMIDITY (PERCENT)
C     DEWPT      DEW-POINT (DEG. C)
C     WSPD       WIND SPEED (M/S)
C     WDIR       WIND DIRECTION (DEGREES FROM NORTH)
C     IOST10     I/O STATUS WORD
C     ISTAT      STATUS OF DECODE: 0 = GOOD; 1 = ERROR
C     NUMLEV     NUMBER OF LEVELS RETAINED IN SOUNDING
C     NCHLEV     NUMBER OF CHARACTERS PER LEVEL
C     AX(3)      DECODED OVERPUNCH ADDED TO A NUMBER
C     SX(3)      DECODED OVERPUNCH MULTIPLIED TO A NUMBER
C     IX         REPLACEMENT VARIABLE FOR IVRPCH(I)
C     IVRPCH(3)  OVERPUNCH ARRAY
C     LA(10)     ARRAYS FOR DECODING OVERPUNCHES
C      LN(10)
C      LP(10)
C
C=======================================================================
C *** TD5600 FORMAT
C
      ENTRY D56LEV(NCHLEV,NUMLEV,ISTAT,IOST10)
C
C --- THE LAST COLUMN IN THE FIELDS FOR HEIGHT, TEMPERATURE AND
C      RELATIVE HUMIDITY ARE THE SIGNED FIELDS
C
      READ(BUF40,310,ERR=10001,IOSTAT=IOST10)PRES, Z,
     &     IVRPCH(1), TEMP, IVRPCH(2), RH, IVRPCH(3), WDIR, WSPD
310   FORMAT(F5.1,F4.0,A1,F2.0,A1,F2.0,A1,2F3.0)
      ISTAT = 0
C
C--- DECODE AND PROCESS OVERPUNCHES
      DO 2500 II=1,3
       IX=IVRPCH(II)
C
C--- COMPUTE FIRST OF OVERPUNCH ARRAYS
       DO 1000 I=1,10
         IF (IX.NE.LN(I)) GO TO 1000
         SX(II) = -1.00
         AX(II) = FLOAT(I-1)
         GO TO 2500
 1000  CONTINUE
C
C--- COMPUTE SECOND OF OVERPUNCH ARRAYS
       DO 1100 I=1,10
         IF (IX.NE.LP(I)) GO TO 1100
         SX(II) = 1.00
         AX(II) = FLOAT(I-1)
         GO TO 2500
 1100  CONTINUE
C
C--- COMPUTE THIRD OF OVERPUNCH ARRAYS
       DO 1200 I=1,10
         IF (IX.NE.LA(I)) GO TO 1200
         SX(II) = 1.00
         AX(II) = FLOAT(I-1)
         GO TO 2500
 1200  CONTINUE
C
C--- IF A BLANK OR SPECIAL CHARACTER IS ENCOUNTERED, SET AX = 0.0.
C     THE PREVIOUS VALUE FOR SX WILL BE USED BECAUSE THE SIGN IS UNKNOWN
C
      AX(II) = 0.0
C
 2500 CONTINUE
C
C--- CHECK HEIGHT ADJUSTMENT AND OVERPUNCH
C
      Z    = Z*10.00 + AX(1)
      TEMP = SX(2)*(TEMP + AX(2)/10.00)
      RH   = RH*10.00 + AX(3)
C
      NUMLEV = NUMLEV + 1
C
C ***
C NOTE: THE -9999. VALUES SHOULD BE RETAINED; THEY ARE CONVERTED
C       TO THE UAQA VALUES IN THE CALLING ROUTINE
C ***
C
C- PRESSURE
        IF(PRES .GT. 9000.) THEN
          WORK2(NUMLEV,1) = -9999.0
        ELSE
          WORK2(NUMLEV,1) = PRES
        ENDIF
C
C- CHECK TO BE SURE THIS IS NOT A FICTITIOUS 1000 MB LEVEL THAT IS
C   PRESENT IN THE TD-5600 DATA AFTER THE INTRODUCTION OF THE TD-6201
C   FORMAT
C
        IF( (PRES .EQ. 1000.0) .AND. (NUMLEV .GT. 1) ) THEN
         IF(WORK2(NUMLEV-1,1) .LT. PRES) THEN
          NUMLEV = NUMLEV - 1
          RETURN
         ENDIF
        ENDIF
C
C- HEIGHT
        IF(Z .GT. 90000.0) THEN
         WORK2(NUMLEV,2) = -9999.0
        ELSE
         WORK2(NUMLEV,2) = Z
        ENDIF
C
C
C- TEMPERATURE
        IF(TEMP .LT. -90.0)THEN
          WORK2(NUMLEV,3) = -9999.0
        ELSE
          WORK2(NUMLEV,3) = TEMP
        ENDIF
C
C-  DEW-POINT FROM RELATIVE HUMIDITY
        IF(RH .GT. 900.) THEN
          RH = 10.
        ELSE IF (RH .GT. 99.9) THEN
          RH = 99.9
        ENDIF
C
        CALL P2MDP(WORK2(NUMLEV,3),RH,DEWPT)
        WORK2(NUMLEV,4) = DEWPT
C
C- WIND DIRECTION
        IF(WDIR .GT. 900.) THEN
          WORK2(NUMLEV,5) = -9999.0
        ELSE
          WORK2(NUMLEV,5) = WDIR
        ENDIF
C
C- WIND SPEED
        IF(WSPD .GT. 900.) THEN
          WORK2(NUMLEV,6) = -9999.0
        ELSE
          WORK2(NUMLEV,6) = WSPD
        ENDIF
C
       RETURN
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF THERE IS AN ERROR DECODING A LEVEL
C
10001 CONTINUE
      ISTAT = 1
      RETURN
C
C-----------------------------------------------------------------------
C- END OF SUBROUTINE
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE UAAUTO
C
C  PURPOSE
C     TO DO GENERAL CLEAN UP ON THE UPPER AIR SOUNDINGS
C     THESE ROUTINES ARE CALLED AUTOMATICALLY; THE USER CAN TURN THIS
C     OPTION OFF IS THE SETUP CARDS.
C
C     ENTRY MANDEL  = DELETES MANDATORY LEVELS IF WITHIN 1% OF A
C                     SIGNIFICANT LEVEL (PREVENTS STRONG SHEARS DURING
C                     QA).  THE NWS INTERPOLATES TO THESE LEVELS, SO NO
C                     INFORMATION IS LOST
C     ENTRY SGNCHK  = CHECKS FOR AND CHANGES INCORRECT SIGNS IN TEMPER-
C                     ATURE ABOVE 1000M AND FOR T .LE. -10.0 DEG C.
C                     ALSO CHECKS FOR SUPERADIABATIC LAYERS AND CHANGES
C                     THE SIGN OF THE TEMPERATURE.
C     ENTRY CALM    = CHECKS FOR NONZERO WIND DIRECTION WITH A CORRES-
C                     PONDING ZERO WIND SPEED; CHANGES THE DIRECTION
C                     TO ZERO
C     ENTRY TDPEST  = IF TEMPERATURE OR DEW-POINT IS MISSING AT A LEVEL
C                     ABOVE THE SURFACE, AN ESTIMATE OF THE VALUE(S)
C                     IS(ARE) DETERMINED BY LINEARLY INTERPOLATING
C                     BETWEEN THE LEVELS ABOVE AND BELOW, ASSUMING NO
C                     MISSING DATA
C
C  NOTE: THE WORK ARRAYS STILL USE -9999.0 AS THE MISSING VALUE
C        INDICATORS.  THE MISSING VALUE INDICATORS DEFINED BY UAQA(-,2)
C        WILL BE SUBSTITUTED AFTER THE SOUNDING IS CHECKED OUT
C
C  CALLED BY: GETSDG
C
C  VERSION DATE: 02 JUNE 1988
C
C=======================================================================
C
      SUBROUTINE UAAUTO
C
      REAL PLEV(19), XPCHK1, XPCHK2, E, ES, RH, B, DZ, DTDZ, ZL, ZU,
     &     XLOG,TINVR
      INTEGER IPWRK,IPRES,NACT,NUML1,NUML2,NUML3,NUML4
      INTEGER ISIGN,NCALM,NTMP,NDEW
      INTEGER L, LEV, LEV1
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA PLEV/1000.,950.,900.,850.,800.,750.,700.,650.,600.,
     * 550.,500.,450.,400.,350.,300.,250.,200.,150.,100./
      DATA PATH/'UA'/, LOC/'UAAUTO'/
C
C=======================================================================
      ENTRY MANDEL(NUML1,IPRES)
C
C     NACT     NUMBER OF LEVELS BEFORE ANY DELETIONS
C     NUML1    NUMBER OF LEVELS REMAINING AFTER THE DELETIONS
C     IPRES    NUMBER OF LEVELS DELETED
C
C-----------------------------------------------------------------------
      IPRES = 0
      NACT  = NUML1
C
      DO 30 J=1,NACT-1
 10     IF(NUML1.LE.J) GO TO 30
        XPCHK2 = 100.
C
        IF( (WORK2(J,1).LT.-9000.0) .OR. (WORK2(J+1,1).LT.-9000.0) )THEN
         GO TO 30
        ELSE
         XPCHK1 = WORK2(J,1)-WORK2(J+1,1)
        ENDIF
C
        IF(J.LT.2 .OR. WORK2(J-1,1).LT.-9000.0) THEN
          GO TO 30
        ELSE
          XPCHK2 = WORK2(J-1,1)-WORK2(J,1)
        ENDIF
C
        IF((XPCHK1.LE.(.01*WORK2(J,1))) .OR.
     &      (XPCHK2.LE.(.01*WORK2(J,1)))) THEN
          DO 25 L=1,19
            IWORK1(1) = WORK2(J,1)*10
            IPWRK     = PLEV(L)*10
            IF(IWORK1(1) .EQ. IPWRK) THEN
              NUML1 = NUML1 - 1
              IPRES = IPRES + 1
              DO 20 I = J,NUML1
                WORK2(I,1) = WORK2(I+1,1)
                WORK2(I,2) = WORK2(I+1,2)
                WORK2(I,3) = WORK2(I+1,3)
                WORK2(I,4) = WORK2(I+1,4)
                WORK2(I,5) = WORK2(I+1,5)
                WORK2(I,6) = WORK2(I+1,6)
 20           CONTINUE
              MESS =BLNK40
              WRITE(MESS,40) UAGYR,UAGMO,UAGDY,UAGHR,PLEV(L)
              CALL ERROR(IPRES,PATH,'I37',LOC,MESS)
              GO TO 10
            ENDIF
 25         CONTINUE
        ENDIF
 30   CONTINUE
C
      RETURN
C
 40   FORMAT(' ',3I2,'/',I2,'; ',F6.0,'MB -MAND. LVL DELETED')
C
C=======================================================================
      ENTRY SGNCHK(NUML2,ISIGN)
C
C     THIS ROUTINE CHECKS THE SIGN OF THE TEMPERATURE IN AN UPPER
C     AIR REPORT.  ONLY LEVELS ABOVE 1000M AND TEMPERATURES GREATER
C     THAN 10C ARE CHECKED.  THIS ROUTINE WAS WRITTEN TO CORRECT
C     THE SIGN ERRORS IN TEMPERATURE THAT ROUTINELY OCCUR IN THE
C     TD5600 UPPER AIR FORMAT FOR HEIGHTS ABOVE 1000M.
C
C     THE ROUTINE ALSO CHECKS ANY LEVELS WITH SUPER ADIABATIC
C     LAPSE RATES AND CHANGES THE VALUE IF IT DOES NOT CREATE A
C     SUPER ADIABATIC LEVEL OR INVERSION GREATER THAN THE QA LIMIT.
C
C-----------------------------------------------------------------------
C
C  NUML2     NUMBER OF LEVELS OF DATA IN THE SOUNDING
C  DZ        DIFFERENCE IN HEIGHT BETWEEN TWO LEVELS
C  DTDZ      TEMPERATURE LAPSE RATE
C  E         VAPOR PRESSURE
C  ES        SATURATED VAPOR PRESSURE
C  N         NUMBER OF LEVELS IN SOUNDING
C  ISIGN     COUNTER FOR NUMBER OF TEMP SIGN CHANGES
C  UAQA(9,4) MAXIMUM USER ALLOWABLE TEMPERATURE INVERSION PER 100 M
C  Z         LAPSE RATE FOR LEVEL
C  ZU        LAPSE RATE FOR UPPER LEVEL WITH SIGN CHANGE FOR LOWER TEMP
C  ZL        LAPSE RATE FOR LOWER LEVEL WITH SIGN CHANGE FOR UPPER TEMP
C
C-----------------------------------------------------------------------
C
C- ITERATE THROUGH ALL THE LEVELS OF THE RADIOSONDE REPORT
C
      TINVR = UAQA(9,4)/100.0
C
      DO 50 LEV = 2,NUML2
        IF(WORK2(LEV,2) .GE. 1000.0)THEN
          IF(WORK2(LEV,3) .GT. 10.0)THEN
           IF( (WORK2(LEV-1,3) .LT. 0.0) .AND. (WORK2(LEV-1,3) .GT.
     &        -9000.0) ) THEN
            IF(WORK2(LEV,4) .GT. -9000.0) THEN
C
C- DETERMINE THE RELATIVE HUMIDITY
C
              E  = 6.1078*EXP((17.2964*WORK2(LEV,4))/(237.3 +
     &              WORK2(LEV,4)))
              ES = 6.1078*EXP((17.2964*WORK2(LEV,3))/(237.3 +
     &              WORK2(LEV,3)))
              RH = E/ES
C
C- CHANGE THE SIGN ON TEMPERATURE AND RECOMPUTE THE DEW-POINT
             WORK2(LEV,3) = -WORK2(LEV,3)
              ES = 6.1078*EXP((17.2964*WORK2(LEV,3))/(237.3 +
     &              WORK2(LEV,3)))
              E = RH*ES
              B = ALOG(E/6.1078)
              WORK2(LEV,4) = 237.3*B/(17.2964-B)
C
              ISIGN = ISIGN + 1
              MESS =BLNK40
              WRITE(MESS,55) UAGYR,UAGMO,UAGDY,UAGHR,LEV
              CALL ERROR(ISIGN,PATH,'I37',LOC,MESS)
            ELSE
C
C- WE CAN'T RECOMPUTE DEW-POINT BUT WE CAN CHANGE THE SIGN
             WORK2(LEV-1,3) = -WORK2(LEV-1,3)
            ENDIF
           ENDIF
          ENDIF
        ENDIF
C
C-----------------------------------------------------------------------
C   THIS SECTION CHECKS FOR SUPERADIABATIC LAPSE RATES
C   AND THEN IF THE LOWER TEMPERATURE IS POSITIVE, SEE IF A
C   SIGN CHANGE CAN ELIMINATE SUSPICIOUS DATA WITHOUT EXCEEDING
C   THE QA LIMITS.
C
      IF( (WORK2(LEV,2) .GT. -9000.0) .AND. (WORK2(LEV-1,2) .GT.
     &   -9000.0) .AND. (WORK2(LEV,3) .GT. -9000.0) .AND.
     &    (WORK2(LEV-1,3) .GT. -9000.0) ) THEN
       DZ = WORK2(LEV,2) - WORK2(LEV-1,2)
       DTDZ = (WORK2(LEV,3) - WORK2(LEV-1,3))/DZ
       IF(DTDZ.LT.-.0098 .AND. WORK2(LEV-1,3).GT.0 .AND. LEV.GE.3) THEN
        ZU = (WORK2(LEV,3) + WORK2(LEV-1,3))/DZ
        ZL = (-WORK2(LEV-1,3) - WORK2(LEV-2,3))/DZ
        IF(ZU.GE.-0.0098 .AND. ZL.GE.-0.0098 .AND. ZU.LT.TINVR) THEN
C
         IF(WORK2(LEV-1,4) .GT. -9000.0) THEN
C
C- COMPUTE THE RELATIVE HUMIDITY
C
          E  = 6.1078*EXP((17.2964*WORK2(LEV-1,4))/(237.3 +
     &         WORK2(LEV-1,4)))
          ES = 6.1078*EXP((17.2964*WORK2(LEV-1,3))/(237.3 +
     &         WORK2(LEV-1,3)))
          RH = E/ES
C
C- CHANGE THE SIGN ON TEMPERATURE AND RECOMPUTE THE DEW POINT
C
         WORK2(LEV-1,3) = -WORK2(LEV-1,3)
          ES = 6.1078*EXP((17.2964*WORK2(LEV-1,3))/(237.3 +
     &         WORK2(LEV-1,3)))
          E  = RH*ES
          B  = ALOG(E/6.1078)
          WORK2(LEV-1,4) = 237.3*B/(17.2964-B)
          ISIGN = ISIGN+1
          MESS =BLNK40
          WRITE(MESS,55) UAGYR,UAGMO,UAGDY,UAGHR,LEV
          CALL ERROR(ISIGN,PATH,'I37',LOC,MESS)
         ELSE
C
C- WE CAN'T RECOMPUTE DEW-POINT BUT WE CAN CHANGE THE SIGN
          WORK2(LEV-1,3) = -WORK2(LEV-1,3)
         ENDIF
        ENDIF
       ENDIF
      ENDIF
   50 CONTINUE
C
      RETURN
C
   55 FORMAT(' ',3I2,'/',I2,'; LVL',I3,' -TEMP. SIGN CHANGE')
C
C=======================================================================
      ENTRY CALMS(NUML3,NCALM)
C
C *** CHECK FOR CALM WINDS WITH NON-ZERO DIRECTION VALUES
C
C     NUML3   NUMBER OF LEVELS IN THE SOUNDING
C
C-----------------------------------------------------------------------
      DO 60 LEV = 1,NUML3
       IWORK1(500) = WORK2(LEV,5)
       IWORK1(501) = WORK2(LEV,6)
       IF(IWORK1(501) .EQ. 0) THEN
        IF(IWORK1(500) .NE. 0) THEN
         WORK2(LEV,5) = 0.0
         NCALM = NCALM + 1
         MESS = BLNK40
         WRITE(MESS,65) UAGYR,UAGMO,UAGDY,UAGHR,LEV
         CALL ERROR (NCALM,PATH,'I37',LOC,MESS)
        END IF
       END IF
   60 CONTINUE
      RETURN
C
   65 FORMAT(' ',3I2,'/',I2,'; LVL',I3,' -CALM, DIR''N SET TO 0')
C
C=======================================================================
      ENTRY TDPEST(NUML4,NTMP,NDEW)
C
C     THIS ROUTINE ESTIMATES THE TEMPERATURE AND DEW POINT AT A
C     LEVEL IN THE UPPER AIR REPORT FROM THE LEVEL BELOW IT.
C     THIS ROUTINE IS CALLED FROM THE UPPER AIR QA PROGRAM.
C
C     NUML4      NUMBER OF LEVELS IN THE SOUNDING
C     NDEW       NUMBER OF LEVELS OF MISSING DEWPT VALUES
C     NTMP       NUMBER OF LEVELS OF MISSING TEMP VALUES
C     XLOG       FRACTIONAL POSITION OF A LEVEL BETWEEN TWO LEVELS
C
C-----------------------------------------------------------------------
C
      NTMP = 0
      NDEW = 0
C
      DO 80 LEV = 2,NUML4-1
C
       IF(WORK2(LEV,3) .LT. -9000.0) THEN
        IF( (WORK2(LEV-1,1) .GT. -9000.0) .AND. (WORK2(LEV,1) .GT.
     &     -9000.0) .AND. (WORK2(LEV-1,3) .GT. -9000.0) ) THEN
         DO 70 LEV1 = LEV+1,NUML4
          IF( (WORK2(LEV1,1) .GT. -9000.0) .AND. (WORK2(LEV1,3) .GT.
     &      -9000.0) )THEN
             XLOG = ALOG(WORK2(LEV,1)/WORK2(LEV-1,1))/
     &               ALOG(WORK2(LEV1,1)/WORK2(LEV-1,1))
             WORK2(LEV,3) = WORK2(LEV-1,3) +
     &                      (WORK2(LEV1,3) - WORK2(LEV-1,3))*XLOG
             MESS = BLNK40
             WRITE(MESS,200) UAGYR,UAGMO,UAGDY,UAGHR,LEV
             CALL ERROR(LEV,PATH,'I37',LOC,MESS)
             NTMP = NTMP + 1
             GO TO 80
          ENDIF
   70    CONTINUE
        ENDIF
       END IF
   80 CONTINUE
C
      DO 90 LEV = 2,NUML4-1
C
       IF(WORK2(LEV,4) .LT. -9000.0) THEN
        IF( (WORK2(LEV-1,1) .GT. -9000.0) .AND. (WORK2(LEV,1) .GT.
     &     -9000.0) .AND. (WORK2(LEV-1,4) .GT. -9000.0) ) THEN
         DO 85 LEV1 = LEV+1,NUML4
          IF( (WORK2(LEV1,1) .GT. -9000.0) .AND. (WORK2(LEV1,4) .GT.
     &      -9000.0) )THEN
              XLOG = ALOG(WORK2(LEV,1)/WORK2(LEV-1,1))/
     &                ALOG(WORK2(LEV1,1)/WORK2(LEV-1,1))
              WORK2(LEV,4) = WORK2(LEV-1,4) +
     &                       (WORK2(LEV1,4) - WORK2(LEV-1,4))*XLOG
              MESS = BLNK40
              WRITE(MESS,400) UAGYR,UAGMO,UAGDY,UAGHR,LEV
              CALL ERROR(LEV,PATH,'I37',LOC,MESS)
              NDEW = NDEW + 1
              GO TO 90
          ENDIF
   85    CONTINUE
        ENDIF
       ENDIF
   90 CONTINUE
C
      RETURN
C
  200 FORMAT(' ',3I2,'/',I2,'; LVL',I3,' - TEMP. ESTIMATED')
  400 FORMAT(' ',3I2,'/',I2,'; LVL',I3,' - DEW-POINT ESTIMATED')
C
C-----------------------------------------------------------------------
C- END OF SUBROUTINE
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C  SUBROUTINE GETMIX
C
C  PURPOSE
C     THIS SUBROUTINE WILL RETRIEVE A PAIR OF MIXING HEIGHTS IN THE
C     STATION/DATE WINDOW AND RETURN IT TO THE CALLING PROGRAM, UAEXT.
C
C  CALLED BY: UAEXT
C
C  VERSION DATE: 02 NOVEMBER 1987
C
C=======================================================================
C
      SUBROUTINE GETMIX(IGO,ZIBFST,NCHREC,NZI)
C-----------------------------------------------------------------------
C- DECLARATIVE STATEMENTS, INITIALIZATIONS AND PRELIMINARY INFORMATION
C   WRITTEN TO THE OUTPUT FILE(S)
C
      INTEGER SCANZI, ZIERR, ZIBFST, NZI, IGO, ISTAT, IOST11,
     &        ZIARG, RECPOS, NCHREC, NCH, JULIAN
      CHARACTER*79 SCSTR2(100), STRNG1
      LOGICAL SCFLAG
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA  ZIERR/0/, SCFLAG/.TRUE./
      DATA PATH/'UA'/, LOC/'GETMIX'/
C
C *** VARIABLE DESCRIPTIONS
C
C      IGO     CONTROLS BRANCHING: 1 = DATA ON TAPE
C                                  2 = DATA ON DISK, 34 CHAR/REC
C                                  3 = DATA ON DISK, USER FORMAT
C      ZIBFST  BUFFER STATUS: 1 = NO DATA IN BUFFER
C                             2 = BUFFER HAS DATA
C                            -1 = EOF
C      NCHREC  NUMBER OF CHARACTERS PER RECORD
C      NZI     COUNTER FOR THE NUMBER OF MIXING HT. PAIRS RETRIEVED
C      SCANZI  COUNTER/ARRAY ELEMENT FOR SCAN STRING
C      SCSTR2  STRING ARRAY WITH ALL TAPE/FILE SCAN INFORMATION
C      STRNG1  STRING ARRAY WITH ONE TAPE/FILE SCAN RECORD
C      ZIERR   COUNTER FOR THE NUMBER OF READ ERRORS
C              (CANNOT EQUAL OR EXCEED MAXERR)
C      IOST11  I/O STATUS WORD
C      ISTAT   STATUS OF READ: 0 = GOOD
C                              1 = ERROR
C                             -1 = EOF
C      RECPOS  CHARACTER POSTION OF NEXT MIXING HEIGHT RECORD
C      SCFLAG  LOGICAL INDICATING IF THIS IS THE FIRST SCAN RECORD
C      ZIARG   AN INTEGER VARIABLE TO USE FOR WHATEVER PURPOSE
C      NCH     LOOP INDEX
C
C *** SUBROUTINES CALLED
C
C      ERROR   WRITES ERROR/WARNING MESSAGES
C      ATAPE2  READS THE DATA FROM TAPE
C      EBCASC  CONVERTS EBCDIC TO ASCII
C              (MAY NOT BE PRESENT IN THE IBM VERSION)
C      SCNGEN  WRITES THE SCAN STRING RECORD
C
C=======================================================================
C- PROCESS THE MIXING HEIGHT DATA.  GO TO THE APPROPRIATE SECTION
C-  BASED ON 'IGO'
C
    1 GO TO (100,300,400) IGO
C
C-----------------------------------------------------------------------
C- BEGIN PROCESSING DATA ON TAPE
C
  100 GO TO (101,201) ZIBFST
  101 CALL FLBUF2
      CALL ATAPE2(*102,DEV11,BUFFR2,NCHB2,ISTAT,IOST11)
  102 IF(ISTAT .EQ. 0) THEN
C
C-    DATA RETRIEVED FROM TAPE
       ZIBFST = 2
       RECPOS = 1
       GO TO 201
C
      ELSE IF(ISTAT .EQ. -1) THEN
C
C-    EN END-OF-FILE WAS ENCOUNTERED
       ZIBFST = -1
       MESS = BLNK40
       WRITE(MESS,600)
       CALL ERROR(NZI,PATH,'I39',LOC,MESS)
       IF(NZI .LT. 1) THEN
C
        IF(SCANZI .LT. 100) THEN
         CALL SCNGEN(SCANZI,SCFLAG,' ',ZIGYR,ZIGMO,ZIGDY,
     &            ZIGHR,1250,STRNG1)
         IF(SCFLAG) THEN
          SCSTR2(SCANZI) = STRNG1
         ENDIF
        ENDIF
C
        MESS = BLNK40
        WRITE(MESS,601) DEV60
        CALL ERROR(NZI,PATH,'W38',LOC,MESS)
        WRITE(DEV70,5004)
        WRITE(DEV70,5005) DEV11,UNIT11
        DO 105 I = 1,SCANZI
         WRITE(DEV70,5010) SCSTR2(I)
  105   CONTINUE
        WRITE(DEV70,5004)
       ENDIF
       RETURN
C
      ELSE IF(ISTAT .EQ. 1) THEN
C
C-    AN ERROR READING THE TAPE OCCURRED; WRITE A MESSAGE
C     RETURN IF THIS GREATER THAN THE MAXERR'TH ERROR; TRY AGAIN IF NOT.
C
       ZIERR = ZIERR + 1
       IF(ZIERR .LE. MAXERR) THEN
        MESS = BLNK40
        WRITE(MESS,602) ZIERR,IOST11
        CALL ERROR(NZI,PATH,'W32',LOC,MESS)
        GO TO 101
       ELSE
        MESS = BLNK40
        WRITE(MESS,603) IOST11
        CALL ERROR(NZI,PATH,'E32',LOC,MESS)
        ZIBFST = -1
        UASTAT = -1
        RETURN
       ENDIF
      ENDIF
C
  201 IF((RECPOS + NCHREC - 1) .GT. NCHB2) THEN
       CALL FLBUF2
       CALL ATAPE2(*102,DEV11,BUFFR2,NCHB2,ISTAT,IOST11)
      ENDIF
C
      BUF40 = BLNK40
      DO 20 NCH = 1,NCHREC
       BUF40(NCH:NCH) = BUFFR2(RECPOS + NCH -1)
   20 CONTINUE
C
      IF(STATUS(2,9) .EQ. 4) CALL EBCASC(40,BUF40)
C
      IF(BUF40(1:5) .EQ. '     ') THEN
       CALL FLBUF2
       CALL ATAPE2(*102,DEV11,BUFFR2,NCHB2,ISTAT,IOST11)
      ENDIF
C
      GO TO 500
C
C=======================================================================
C- PROCESSING BEGINS HERE FOR MIXING HEIGHT DATA ON DISK THAT
C   IS 34 CHARACTERS PER RECORD, 1 RECORD PER RECORD
C
  300 BUF40 = BLNK40
      READ(DEV11,1110,END=310,ERR=320,IOSTAT=IOST11) BUF40
       ZIBFST = 2
       GO TO 500
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF AN END OF FILE WAS ENCOUNTERED ON THE
C-  DISK
C
  310 ZIBFST = -1
      MESS = BLNK40
      WRITE(MESS,600)
      CALL ERROR(NZI,PATH,'I39',LOC,MESS)
      IF(NZI .LT. 1) THEN
C
        MESS = BLNK40
        WRITE(MESS,701)
        CALL ERROR(NZI,PATH,'W38',LOC,MESS)
      ENDIF
      RETURN
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF AN ERROR WAS ENCOUNTERED DURING THE READ
C
  320 ZIERR = ZIERR + 1
      IF(ZIERR .LE. MAXERR) THEN
       MESS = BLNK40
       WRITE(MESS,602) ZIERR,IOST11
       CALL ERROR(NZI,PATH,'W32',LOC,MESS)
       GO TO 300
      ELSE
       UASTAT = -1
       ZIBFST = -1
       MESS = BLNK40
       WRITE(MESS,603) IOST11
       CALL ERROR(NZI,PATH,'E32',LOC,MESS)
       RETURN
      ENDIF
C
C=======================================================================
C- PROCESSING CONTINUES HERE FOR THE DECODING OF DATA RETRIEVED FROM
C-  TAPE OR 34-CHARACTER RECORDS ON DISK
C
C   TO CHECK THE STATION ID ON THE TAPE AGAINST THE STATION BEING
C   EXTRACTED, AND BECAUSE 'ZILOC1' IS LEFT JUSTIFIED AND BUF08(5)
C   IS RIGHT JUSTIFIED, IWORK1(15) IS USED TO LOCATE A BLANK IN THE
C   STATION FIELD FROM THE TAPE AND IWORK1(16) IS USED TO DETERMINE
C   IF THERE WAS A MATCH ( .EQ. 0, NO MATCH; .NE. 0, MATCH)
C
  500 CONTINUE
      READ(BUF40,1150,ERR=520,IOSTAT=IOST11) BUF08(5),ZIGYR,ZIGMO,
     &     IWORK1(1100),ZIGDY,IWORK1(1101),MIX1,IWORK1(1102),
     &     IWORK1(1103),IWORK1(1104),MIX2,IWORK1(1105),IWORK1(1106)
C
C--- THE INDEX FUNCTION IS USED TO INSURE A CORRECT MATCH ON STATION
C     IDENTIFIERS - BUF08 IS LEFT JUSTIFIED, ZILOC1 IS RIGHT JUSTIFIED.
C     IF THE IDENTIFIER FIELD REQUIRES 8 CHARACTERS THERE IS NO BLANK
C
      IWORK1(15) = INDEX(BUF08(5),' ')
      IF(IWORK1(15) .EQ. 0) THEN
       IWORK1(16) = INDEX(ZILOC1,BUF08(5)(1:8))
      ELSE
       IWORK1(16) = INDEX(ZILOC1,BUF08(5)(1:IWORK1(15)-1))
      ENDIF
C
      IF(SCANZI .LT. 100) THEN
       CALL SCNGEN(SCANZI,SCFLAG,BUF08(5),ZIGYR,ZIGMO,ZIGDY,
     &            ZIGHR,1250,STRNG1)
       IF(SCFLAG) THEN
         SCSTR2(SCANZI) = STRNG1
         SCFLAG = .FALSE.
       ENDIF
      ENDIF
C-----------------------------------------------------------------------
C- COMPUTE THE JULIAN AND CHRONOLOGICAL DAYS
C-   CHECK FOR INCLUSION IN THE STATION/DATE WINDOW
C
      ZIARG = JULIAN(ZIGYR,ZIGMO,ZIGDY)
      CALL CHROND('UA',ZIGYR,ZIARG,ZIDAYC)
C
C--- THE STATIONS DO NOT MATCH
C
      IF(IWORK1(16) .EQ. 0) THEN
       IF(IGO .EQ. 1) THEN
        RECPOS = RECPOS + NCHREC
       ENDIF
       GO TO 1
C
C--- THE STATIONS MATCH AND THE DATA ARE BEFORE THE EXTRACT WINDOW
      ELSE IF ( ZIDAYC .LT. UADAY1 ) THEN
       IF(IGO .EQ. 1) THEN
        RECPOS = RECPOS + NCHREC
       ENDIF
       GO TO 1
C
C--- THE STATIONS MATCH AND THE DATA ARE BEYOND THE EXTRACT WINDOW.
C
      ELSE IF ( ZIDAYC .GT. UADAY2 ) THEN
       IF(IGO .EQ. 1) THEN
        RECPOS = RECPOS + NCHREC
       ENDIF
       ZIBFST = -1
       IF(NZI .LT. 1) THEN
        MESS = BLNK40
        IF(IGO .EQ. 1) THEN
         WRITE(MESS,601) DEV60
         CALL ERROR(NZI,PATH,'W38',LOC,MESS)
         WRITE(DEV70,5004)
         WRITE(DEV70,5005) DEV11,UNIT11
         DO 516 I = 1,SCANZI
          WRITE(DEV70,5010) SCSTR2(I)
  516    CONTINUE
         WRITE(DEV70,5004)
        ELSE IF(IGO .EQ. 2) THEN
         WRITE(MESS,701)
         CALL ERROR(NZI,PATH,'W38',LOC,MESS)
        ENDIF
        RETURN
       ENDIF
      ENDIF
C
C-----------------------------------------------------------------------
C- THE CORRECT TIME SPAN AND STATION HAVE BEEN LOCATED.  PROCESS THE
C-  MIXING HEIGHTS AS NECESSARY.
C
      IF(MIX1 .LT. 0) THEN
       MIXC1 = UAQA(11,2)
      ELSE
       MIXC1 = MIX1
      ENDIF
C
      IF(MIX2 .LT. 0) THEN
       MIXC2 = UAQA(12,2)
      ELSE
       MIXC2 = MIX2
      ENDIF
C
      NZI = NZI + 1
      RECPOS = RECPOS + NCHREC
      RETURN
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF THERE WAS AN ERROR DECODING THE 34-CHAR
C   PER RECORD DATA
C
  520 ZIERR = ZIERR + 1
      IF(ZIERR .LE. MAXERR) THEN
C
C-    THE TOTAL NUMBER OF MIXING HT. ERRORS IS LESS THAN MAXERR
C
       MESS = BLNK40
       WRITE(MESS,604) ZIERR,IOST11
       CALL ERROR(NZI,PATH,'W32',LOC,MESS)
       IF(IGO. EQ. 2) THEN
        GO TO 300
       ELSE IF(IGO .EQ. 1) THEN
        RECPOS = RECPOS + NCHREC
        GO TO 201
       ENDIF
      ELSE
C
C-    THE TOTAL NUMBER OF MIXING HT. ERRORS IS .GT. MAXERR
C
       ZIBFST = -1
       MESS = BLNK40
       WRITE(MESS,605) IOST11
       CALL ERROR(NZI,PATH,'E32',LOC,MESS)
       RETURN
      ENDIF
C
C=======================================================================
C- PROCESSING BEGINS HERE IF THE MIXING HEIGHT DATA ARE ON DISK AND THE
C-  USER SPECIFIED THE FORMAT.  BECAUSE THERE ARE NO CHANGES TO THE MIX-
C-  ING HEIGHTS DUE TO ADDITIONAL INFORMATION, ALL PROCESSING IS
C-  PERFORMED BELOW.
C
  400 READ(DEV11,ZIFRMT,END=410,ERR=420,IOSTAT=IOST11) BUF08(5),
     &      ZIGYR,ZIGMO,ZIGDY, MIX1, MIX2
C
      IWORK1(15) = INDEX(BUF08(5),' ')
      IF(IWORK1(15) .EQ. 0) THEN
       IWORK1(16) = INDEX(ZILOC1,BUF08(5)(1:8))
      ELSE
       IWORK1(16) = INDEX(ZILOC1,BUF08(5)(1:IWORK1(15)-1))
      ENDIF
C
      ZIBFST = 2
C
C-----------------------------------------------------------------------
C- COMPUTE THE JULIAN DAY AND CHRONOLOGICAL DAY
C   CHECK FOR INCLUSION IN THE STATION/DATE  WINDOW
C
      ZIARG = JULIAN(ZIGYR,ZIGMO,ZIGDY)
      CALL CHROND('UA',ZIGYR,ZIARG,ZIDAYC)
C
C--- THE STATIONS DO NOT MATCH
C
      IF(IWORK1(16) .EQ. 0) THEN
       GO TO 400
C
C--- THE STATIONS MATCH BUT THE DATE IS BEFORE THE EXTRACT WINDOW
C
      ELSE IF ( ZIDAYC .LT. UADAY1 ) THEN
       GO TO 400
C
C--- THE STATIONS MATCH BUT THE DATE IS AFTER THE EXTRACT WINDOW
C
      ELSE IF ( ZIDAYC .GT. UADAY2 ) THEN
       ZIBFST = -1
       IF(NZI .LT. 1) THEN
        MESS = BLNK40
        WRITE(MESS,701)
        CALL ERROR(NZI,PATH,'W38',LOC,MESS)
       ENDIF
       RETURN
      ENDIF
C
      IF(MIX1 .LT. 0) THEN
       MIXC1 = UAQA(11,2)
      ELSE
       MIXC1 = MIX1
      ENDIF
C
      IF(MIX2 .LT. 0) THEN
       MIXC2 = UAQA(12,2)
      ELSE
       MIXC2 = MIX2
      ENDIF
C
      NZI = NZI + 1
      RETURN
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE WHEN THE END-OF-FILE IS ENCOUNTERED
C
  410 ZIBFST = -1
      MESS = BLNK40
      WRITE(MESS,600)
      CALL ERROR(NZI,PATH,'I39',LOC,MESS)
      IF(NZI .LT. 1) THEN
C
       MESS = BLNK40
       WRITE(MESS,701)
       CALL ERROR(NZI,PATH,'W38',LOC,MESS)
      ENDIF
      RETURN
C
C-----------------------------------------------------------------------
C- PROCESSING CONTINUES HERE IF A READ ERROR IS ENCOUNTERED
C
  420 ZIERR = ZIERR + 1
      IF(ZIERR .LE. MAXERR) THEN
       MESS = BLNK40
       WRITE(MESS,602) ZIERR,IOST11
       CALL ERROR(NZI,PATH,'W32',LOC,MESS)
       GO TO 400
      ELSE
       UASTAT = -1
       ZIBFST = -1
       MESS = BLNK40
       WRITE(MESS,603) IOST11
       CALL ERROR(NZI,PATH,'E32',LOC,MESS)
       RETURN
      ENDIF
C
C=======================================================================
C- FORMAT STATEMENTS
C
  600 FORMAT(' END-OF-FILE, END-OF-DATA')
  601 FORMAT(' NO OBS RETRIEVED; SEE UNIT',I3,' FOR SCAN')
  602 FORMAT(' ERROR ',I1,' READING DATA, IOSTAT=',I6)
  603 FORMAT(' MAX. ERRORS (AT READ), IOSTAT=',I6)
  604 FORMAT(' ERROR ',I1,' DECODING DATA, IOSTAT=',I6)
  605 FORMAT(' MAX. ERRORS (AT DECODE), IOSTAT=',I6)
  701 FORMAT(' NO OBS RETRIEVED-CHECK INPUT STN/DATES')
 1110 FORMAT(A34)
 1150 FORMAT(A5,2I2,I1,I2,2(A1,I4,2I3))
 5004 FORMAT('$ZISCAN$')
 5005 FORMAT(//,5X,'TAPE CONTENTS FOR UNIT ',I3,',FILE: ',A48,
     &        /,26X,'FROM',15X,'TO',
     &        /,9X,' STATION',2X,'YR',2(1X,'MO',1X,'DA',1X,'HR',1X,
     &          'JDAY',4X))
 5010 FORMAT(A79)
C=======================================================================
      END
C
C=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
C   SUBROUTINE  UAQASM
C
C   PURPOSE:
C     TO ASSESS THE QUALITY OF THE UPPER AIR DATA BY CHECKING THE
C     UPPER AND LOWER BOUNDS OF PRESSURE, HEIGHT, TEMPERATURE, DEW
C     POINT TEMPERATURE, WIND DIRECTION, WIND SPEED, 'CALM' WINDS,
C     DEW-POINT EXCEEDING TEMPERATURE AND SELECTED VERTICAL GRADIENTS
C
C   CALLED BY: UAPATH
C
C   VERSION DATE: 30 SEPT 1992
C
C=======================================================================
C
      SUBROUTINE UAQASM
C

      INTEGER  UA2YR, UA4YR, CENTURY
      INTEGER COUNTS, COUNTL, COUNTH, QARSLT, IDOM, NUM,
     1  K, IVBL, LEV, UANTD, UAWSWD, UACALM, JULIAN, ISTAT
      REAL DH, DIFWD, TDEST1, ZMIN, DS, DWDDZ, DTDZ, DPEST, DVDZ
      REAL RMISS0, RMISS7, RMISS8, RMISS9
      REAL WSHRL, WSHRU, TINVR,TSUPR, DPDL, DPDU, WDHRL, WDHRU
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA  PATH/'UA'/, LOC/'UAQASM'/
C
C-----------------------------------------------------------------------
C  VARIABLE DEFINITIONS
C    COUNTH          COUNTER FOR UPPER AIR REPORTS
C    COUNTL          COUNTER FOR SOUNDING LEVELS
C    COUNTS          COUNTER FOR UPPER AIR SOUNDINGS
C    UANTD           COUNTER FOR NUMBER OF TIMES DEW-POINT EXCEEDS TEMP.
C    UAWSWD          COUNTER FOR THE NUMBER OF NONZERO WIND DIRECTIONS
C                      WITH CORRESPONDING ZERO WIND SPEEDS
C    UACALM          COUNTER FOR THE NUMBER OF CALM WINDS
C    WSHRL,WSHRU     LOWER AND UPPER BOUNDS FOR WIND SPEED SHEAR
C    WDHRL,WDHRU     LOWER AND UPPER BOUNDS FOR WIND DIRECTIONAL SHEAR
C    TSUPR,TINVR     LOWER AND UPPER BOUNDS FOR TEMPERATURE LAPSE RATES
C    DPDL,DPDU       LOWER AND UPPER BOUNDS FOR DEW POINT DEVIATIONS
C    RMISS7,RMISS8   MISSING VALUE INDICATORS FOR WIND SPEED SHEAR,
C     RMISS9,RMISS0   DIRECTIONAL SHEAR, LAPSE RATE, AND DEW PT. DEV'N.
C    DH              HEIGHT DIFFERENCE
C    DTDZ            OBSERVED LAPSE RATE
C    DIFWD           OBSERVED DIRECTIONAL CHANGE
C    DWDDZ           OBSERVED DIRECTIONAL SHEAR (= DIFWD/DH)
C    DS              SPEED CHANGE
C    DVDZ            SPEED SHEAR (= DS/DH)
C    ZMIN            MINIMUM HEIGHT DIFFERENCE
C    TDEST1          INTERPOLATED DEW POINT DIFFERENCE ESTIMATE
C    DPEST           INTERPOLATED DEW POINT DIFFERENCE ESTIMATE GRADIENT
C                     (= TDEST1/ZMIN)
C    IDOM            SOUNDING LAYER IN INCREMENTS (METERS) OF 'UAINC'
C    IVBL,LEV,K      LOOP COUNTERS
C
C    JULIAN          INTEGER FUNCTION COMPUTING JULIAN DAY
C
C *** SUBROUTINES CALLED
C
C    OTHHDR        READS/WRITES INPUT AND OUTPUT FILE HEADERS
C    HTCALC        RECALCULATES THE SOUNDING HEIGHTS
C    ERROR         WRITE ERROR/VIOLATION MESSAGES
C    INTECK        QA'S INTEGER VALUES
C    REALCK        QA'S REAL VALUES
C
C-----------------------------------------------------------------------
C *** INITIALIZE COUNTERS
      COUNTS = 0
      COUNTH = 0
      UANTD  = 0
      UACALM = 0
      UAWSWD = 0
      UADAYC = 0
      NUM = 2
C
C *** CONVERT VERTICAL GRADIENT LIMITS TO REAL VALUES
      WSHRL = FLOAT(UAQA(7,3))
      WSHRU = FLOAT(UAQA(7,4))
      WDHRL = FLOAT(UAQA(8,3))
      WDHRU = FLOAT(UAQA(8,4))
      TSUPR = FLOAT(UAQA(9,3))
      TINVR = FLOAT(UAQA(9,4))
      DPDU  = FLOAT(UAQA(10,4))
      DPDL  = FLOAT(UAQA(10,3))
C
C *** CONVERT INTEGER MISSING VALUE INDICATORS TO REAL NUMBERS
      RMISS7 = FLOAT(UAQA(7,2))
      RMISS8 = FLOAT(UAQA(8,2))
      RMISS9 = FLOAT(UAQA(9,2))
      RMISS0 = FLOAT(UAQA(10,2))
C
C-----------------------------------------------------------------------
C *** READ THE FILE HEADERS; IF THERE IS A PROBLEM WRITE A MESSAGE AND
C      DO NOT QA THE DATA
      CALL OTHHDR(PATH,LOC,NUM,DEV12,DEV13,DEV60)
      IF(NUM .LT. 0) THEN
       MESS = BLNK40
       WRITE(MESS,135)
       CALL ERROR(0,PATH,'E36',LOC,MESS)
       UASTAT = -1
       RETURN
      ENDIF
      WRITE(DEV13,100) IVDATE                                           DTBAUG94

      WRITE(*,609)
  609 FORMAT( ' ' )

C-----------------------------------------------------------------------
C *** READ THE SOUNDING DATA HEADER AFTER INITIALIZING DATA
20      BUF80(1)=BLNK80
        COUNTH = COUNTH + 1
        READ(DEV12,300,ERR=380,END=390)(BUF01(K),K=1,80)
        UAGYR = 0
        UAGMO = 0
        UAGDY = 0
        UAGHR = 0
        UALEV(1) = 0
        MIX1 = 0
        MIX2 = 0
        UALDY = UADAYC
        READ(BUF80(1),301,ERR=330) UAGYR,
     1       UAGMO,UAGDY,UAGHR,UALEV(1),MIX1,MIX2


        CALL Y2K(PATH, UAGYR, UA2YR, UA4YR, CENTURY)

        WRITE(*, 610 ) UAGMO, UAGDY, UA4YR
  610   FORMAT('+  Stage 1: QA''ing upper-air data for ',
     &             'month-day-year ', 2(I2.2,:'-'),I4)

C *** WRITE SOUNDING DATA HEADER TO THE OUTPUT FILE
        WRITE(DEV13,301)UAGYR,UAGMO,UAGDY,UAGHR,UALEV(1),MIX1,MIX2
        UADAYC = JULIAN(UAGYR,UAGMO,UAGDY)
        IWORK1(1210) = UADAYC*100 + UAGHR
C
C-----------------------------------------------------------------------
C *** CHECK MORNING AND AFTERNOON MIXING HEIGHTS
        IF(UALDY .EQ. UADAYC) THEN
C        THE MIXING HEIGHTS HAVE BEEN SEEN AND AUDITED PREVIOUSLY
C
         QARSLT = 6
         CALL INTECK(2,IWORK1(1210),UAQA(11,1),UAQA(11,2),UAQA(11,3),
     1              UAQA(11,4),MIX1,UAVAR(11),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         IF(QARSLT .EQ. 1 .AND. UASTRA(1) .EQ. 1) THEN
            MESS = BLNK40
            WRITE(MESS,191) UAVAR(11),UAGYR,UAGMO,UAGDY,UAGHR
            CALL ERROR(IWORK1(1210),PATH,'   ',LOC,MESS)
         ENDIF
C
         QARSLT = 6
         CALL INTECK(2,IWORK1(1210),UAQA(12,1),UAQA(12,2),UAQA(12,3),
     1              UAQA(12,4),MIX2,UAVAR(12),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         IF(QARSLT .EQ. 1 .AND. UASTRA(2) .EQ. 1) THEN
            MESS = BLNK40
            WRITE(MESS,191) UAVAR(12),UAGYR,UAGMO,UAGDY,UAGHR
            CALL ERROR(IWORK1(1210),PATH,'   ',LOC,MESS)
         ENDIF
        ELSE
C        THIS IS THE FIRST TIME THE TWO MIXING HEIGHTS HAVE BEEN SEEN
C
         QARSLT = 5
         CALL INTECK(2,IWORK1(1210),UAQA(11,1),UAQA(11,2),UAQA(11,3),
     1              UAQA(11,4),MIX1,UAVAR(11),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD1(1,QARSLT) = UAAUD1(1,QARSLT) + 1
         IF(QARSLT .EQ. 1 .AND. UASTRA(1) .EQ. 1) THEN
            MESS = BLNK40
            WRITE(MESS,191) UAVAR(11),UAGYR,UAGMO,UAGDY,UAGHR
            CALL ERROR(IWORK1(1210),PATH,'   ',LOC,MESS)
         ENDIF
C
         QARSLT = 5
         CALL INTECK(2,IWORK1(1210),UAQA(12,1),UAQA(12,2),UAQA(12,3),
     1              UAQA(12,4),MIX2,UAVAR(12),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD1(2,QARSLT) = UAAUD1(2,QARSLT) + 1
         IF(QARSLT .EQ. 1 .AND. UASTRA(2) .EQ. 1) THEN
            MESS = BLNK40
            WRITE(MESS,191) UAVAR(12),UAGYR,UAGMO,UAGDY,UAGHR
            CALL ERROR(IWORK1(1210),PATH,'   ',LOC,MESS)
         ENDIF
        ENDIF
C
C-----------------------------------------------------------------------
C *** READ VARIABLES AT VERTICAL LEVELS IF THERE ARE DATA
C
      IF( UALEV(1) .GT. 0 ) THEN
         COUNTL = 0
         COUNTS = COUNTS + 1
         CALL FLSDG(1)
         DO 15 I=1,UALEV(1)
           READ(DEV12,302,ERR=340,END=350)(UAOBS(1,I,IVBL),IVBL=1,UAMV)
           COUNTL=COUNTL+1
15       CONTINUE
C
C ***  RECOMPUTE THE HEIGHTS
         CALL HTCALC(ISTAT)
         IF(ISTAT .EQ. -1) THEN
          MESS = BLNK40
          WRITE(MESS,174) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(COUNTH,PATH,'+++','      ',MESS)
         ENDIF
C
C ***  WRITE THE LEVELS TO THE OUTPUT FILE
         DO 37 J=1,UALEV(1)
           WRITE(DEV13,302) (UAOBS(1,J,IVBL),IVBL=1,UAMV)
37       CONTINUE
C
        IF( ISTAT .EQ. -1) GO TO 20
C=======================================================================
C ***  CHECK VARIABLES FOR LIMIT VIOLATIONS
C      IWORK1(1210) IS RECOMPUTED BECAUSE HTCALC FLUSHED THE WORK ARRAY
C
       IWORK1(1210) = UADAYC*100 + UAGHR
       DO 16 LEV = 1,UALEV(1)
C
C ***    DETERMINE THE LAYER BASED ON HEIGHT ABOVE GROUND LEVEL
C         1=SURFACE, 2-9=LAYER IN INCREMENTS OF UAINC, 10= ABOVE
C           8*UAINC METERS ABOVE GROUND LEVEL
C
         IF(LEV .EQ. 1) THEN
          IDOM = 1
         ELSE IF((UAOBS(1,LEV,2) - UAOBS(1,1,2)) .GT. (8*UAINC)) THEN
          IDOM = 10
         ELSE IF((UAOBS(1,LEV,2) - UAOBS(1,1,2)) .GT. 0) THEN
          IDOM = (UAOBS(1,LEV,2) - UAOBS(1,1,2))/UAINC + 2
         ELSE
          MESS = BLNK40
          WRITE(MESS,184) LEV,UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(0,PATH,'Q35',LOC,MESS)
          STOP
         ENDIF
C
        DO 17 IVBL = 1,UAMV
         QARSLT = 5
         CALL INTECK(2,IWORK1(1210),UAQA(IVBL,1),UAQA(IVBL,2),
     1               UAQA(IVBL,3),UAQA(IVBL,4),UAOBS(1,LEV,IVBL),
     2               UAVAR(IVBL),QARSLT)
C
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD2(IVBL,IDOM,QARSLT) = UAAUD2(IVBL,IDOM,QARSLT) + 1
         IF(QARSLT .EQ. 1 .AND. UAVTRA(IVBL) .EQ. 1) THEN
            MESS = BLNK40
            WRITE(MESS,192) UAVAR(IVBL),UAGYR,UAGMO,UAGDY,UAGHR,LEV
            CALL ERROR(IWORK1(1210),PATH,'   ',LOC,MESS)
         ENDIF
   17   CONTINUE
C
C-----------------------------------------------------------------------
C ***   CHECK FOR CALM WINDS WITH NON-ZERO DIRECTION VALUES
C
        IF(UAOBS(1,LEV,6) .EQ. 0) THEN
         IF(UAOBS(1,LEV,5) .EQ. 0) THEN
          UACALM = UACALM + 1
          MESS = BLNK40
          WRITE(MESS,155) LEV,UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR (IWORK1(1210),PATH,'CLM',LOC,MESS)
         ELSE IF(UAOBS(1,LEV,5) .GT. 0) THEN
          UAWSWD = UAWSWD + 1
          MESS = BLNK40
          WRITE(MESS,155) LEV,UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR (IWORK1(1210),PATH,'WDS',LOC,MESS)
         END IF
        END IF
C
C-----------------------------------------------------------------------
C ***   COMPARE THE DEW-POINT TO THE TEMPERATURE
C
        IF((UAOBS(1,LEV,4) .NE. UAQA(4,2)) .AND. (UAOBS(1,LEV,3) .NE.
     &     UAQA(3,2))) THEN
         IF(UAOBS(1,LEV,4) .GT. UAOBS(1,LEV,3)) THEN
          UANTD = UANTD + 1
          MESS=BLNK40
          WRITE(MESS,154)LEV,UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'TDT',LOC,MESS)
         ENDIF
        ENDIF
C
C=======================================================================
C ***   THE FOLLOWING TESTS ARE NOT POSSIBLE AT THE FIRST LEVEL
C
       DVDZ  = 0.0
       DWDDZ = 0.0
       DTDZ  = 0.0
       DPEST = 0.0
C
       IF( LEV .GT. 1) THEN
        IF((UAOBS(1,LEV,2) .NE. UAQA(2,2)) .AND. (UAOBS(1,LEV-1,2) .NE.
     &       UAQA(2,2)) ) THEN
         DH = UAOBS(1,LEV,2) - UAOBS(1,LEV-1,2)
C
C-----------------------------------------------------------------------
C ***    CHECK FOR VERTICAL WIND SPEED SHEAR OUT OF RANGE
C        IF THE SPEEDS ARE NOT MISSING, COMPUTE THE SHEAR, ELSE SET THE
C        SHEAR TO MISSING
C
         IF((UAOBS(1,LEV,6) .NE. UAQA(6,2)) .AND. (UAOBS(1,LEV-1,6) .NE.
     &       UAQA(6,2)) ) THEN
           DS = (UAOBS(1,LEV,6)-UAOBS(1,LEV-1,6))/10.
           DVDZ = (ABS(DS/DH)) * 100.0
         ELSE
           DVDZ = RMISS7
         ENDIF
C
         QARSLT = 5
         CALL REALCK(2,IWORK1(1210),UAQA(7,1),RMISS7,WSHRL,WSHRU,DVDZ,
     &               UAVAR(7),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD2(7,IDOM,QARSLT) = UAAUD2(7,IDOM,QARSLT) + 1
C
C-----------------------------------------------------------------------
C ***    CHECK FOR WIND DIRECTIONAL SHEAR OUT OF RANGE
C
         IF((UAOBS(1,LEV,5) .NE. UAQA(5,2)) .AND. (UAOBS(1,LEV-1,5)
     &      .NE. UAQA(5,2))) THEN
C           CONDITION THE DIRECTIONS TO LIE BETWEEN 0 AND 360
            IWD1=MOD(UAOBS(1,LEV,5),360)
            IF(IWD1 .LT. 0) IWD1=IWD1+360
            IWD2=MOD(UAOBS(1,LEV-1,5),360)
            IF(IWD2 .LT. 0) IWD2=IWD2+360
C           COMPUTE THE ABSOLUTE DIFFERENCE
            DIFWD = ABS(IWD1-IWD2)
C           IF GREATER THAN 180, TAKE COMPLEMENTARY DIFFERENCE
            IF(DIFWD .GT. 180.0) DIFWD=360.0-DIFWD
            DWDDZ = (DIFWD/DH) * 100.0
         ELSE
            DWDDZ = RMISS8
         ENDIF
C
         QARSLT = 5
         CALL REALCK(2,IWORK1(1210),UAQA(8,1),RMISS8,WDHRL,WDHRU,DWDDZ,
     &               UAVAR(8),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD2(8,IDOM,QARSLT) = UAAUD2(8,IDOM,QARSLT) + 1
C
C-----------------------------------------------------------------------
C ***    CHECK FOR TEMPERATURE LAPSE RATE OUT OF RANGE
C
         IF((UAOBS(1,LEV,3) .NE. UAQA(3,2)) .AND. (UAOBS(1,LEV-1,3)
     &      .NE. UAQA(3,2))) THEN
           DTDZ = (((UAOBS(1,LEV,3) - UAOBS(1,LEV-1,3))/10.0)/DH) *100.0
         ELSE
           DTDZ = RMISS9
         ENDIF
C
         QARSLT = 5
         CALL REALCK(2,IWORK1(1210),UAQA(9,1),RMISS9,TSUPR,TINVR,DTDZ,
     &               UAVAR(9),QARSLT)
         IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
          MESS = BLNK40
          WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
         ENDIF
         UAAUD2(9,IDOM,QARSLT) = UAAUD2(9,IDOM,QARSLT) + 1
C
C-----------------------------------------------------------------------
C ***    CHECK DEW POINT FOR ERRATIC VALUES; OMIT THE UPPER LEVEL
C
         IF(LEV .LT. UALEV(1)) THEN
          IF((UAOBS(1,LEV,4) .NE. UAQA(4,2)) .AND. (UAOBS(1,LEV-1,4)
     &       .NE. UAQA(4,2))) THEN
           TDEST1 = UAOBS(1,LEV-1,4) +
     1              FLOAT(UAOBS(1,LEV,2) - UAOBS(1,LEV-1,2)) /
     1              FLOAT(UAOBS(1,LEV+1,2) - UAOBS(1,LEV-1,2)) *
     1              (UAOBS(1,LEV+1,4) - UAOBS(1,LEV-1,4))
           ZMIN = MIN0( (UAOBS(1,LEV,2) - UAOBS(1,LEV-1,2)),
     1                    (UAOBS(1,LEV+1,2) - UAOBS(1,LEV,2)) )
           DPEST = ABS(TDEST1 - FLOAT(UAOBS(1,LEV,4))) / ZMIN
          ELSE
           DPEST = RMISS0
          ENDIF
C
          QARSLT = 5
          CALL REALCK(2,IWORK1(1210),UAQA(10,1),RMISS0,DPDL,DPDU,DPEST,
     &                UAVAR(10),QARSLT)
          IF((QARSLT .EQ. 2) .OR. (QARSLT .EQ. 3)) THEN
           MESS = BLNK40
           WRITE(MESS,190) UAGYR,UAGMO,UAGDY,UAGHR
           CALL ERROR(IWORK1(1210),PATH,'   ','      ',MESS)
          ENDIF
          UAAUD2(10,IDOM,QARSLT) = UAAUD2(10,IDOM,QARSLT) + 1
         END IF
C
        ELSE
          MESS=BLNK40
          WRITE(MESS,164) UAGYR,UAGMO,UAGDY,UAGHR
          CALL ERROR(LEV,PATH,'Q34',LOC,MESS)
        ENDIF
C
       ENDIF
C
C ***   END OF LOOP FOR SOUNDING LEVELS
C
  16   CONTINUE
C
      ENDIF
      GO TO 20
C
C=======================================================================
C- PROCESSING CONTINUES HERE IF THERE WAS AN ERROR OR END-OF-FILE
C   READING THE DATA
C
330   MESS=BLNK40
      WRITE(MESS,430) COUNTH
      CALL ERROR(COUNTH,PATH,'E32',LOC,MESS)
430   FORMAT(' ERROR IN DECODING UA HEADER # ',I3)
      RETURN
C
340   MESS=BLNK40
      WRITE(MESS,440) COUNTL,UAGYR,UAGMO,UAGDY,UAGHR
      CALL ERROR(COUNTL,PATH,'E32',LOC,MESS)
440   FORMAT(' ERROR READING LEVEL ',I3,' ON ',I2,3('/',I2.2))
      RETURN
C
350   MESS=BLNK40
      WRITE(MESS,450) COUNTL,UAGYR,UAGMO,UAGDY,UAGHR
      CALL ERROR(COUNTL,PATH,'E32',LOC,MESS)
450   FORMAT(' EOF READ AT LEVEL ',I3,' ON ',I2,3('/',I2.2))
      RETURN
C
380   MESS=BLNK40
      WRITE(MESS,480) COUNTH
      CALL ERROR(COUNTH,PATH,'E32',LOC,MESS)
480   FORMAT(' ERROR READING UA HEADER #',I3)
      RETURN
C
390   MESS=BLNK40
      WRITE(MESS,490) COUNTH-1
      CALL ERROR(COUNTH,PATH,'I39',LOC,MESS)
490   FORMAT(' EOF AFTER UA REPORT # ',I3,' (NORMAL)')
      IF(COUNTS .GT. 0) THEN
       WRITE(DEV70,601)
       WRITE(DEV70,600) COUNTH-1,UACALM,UAWSWD,UANTD
       WRITE(DEV70,601)
      ENDIF
C
      RETURN
C
C-----------------------------------------------------------------------
C
  100 FORMAT('*  UA     UPPER AIR DATA QA  -  MPRM DATED ', I5)         DTBAUG94
  135 FORMAT(' ERROR PROCESSING HEADERS, NO QA')
  154 FORMAT(' LEV ',I2,' TD > T ON ',I2,3('/',I2))
  155 FORMAT(' LEV ',I2,' CALM WINDS ON ',I2,3('/',I2))
  164 FORMAT(' HT MISSING, NO GRADIENTS ON ',I2,3('/',I2))
  174 FORMAT(' ERROR RECOMPUTING HTS. ON ',I2,3('/',I2))
  184 FORMAT(' NO HGT RANGE FOR LVL',I3,' ON ',I2,3('/',I2))
  190 FORMAT(' ON  ',I2,3('/',I2.2))
  191 FORMAT(1X,A4,' MISSING ON  ',I2,3('/',I2.2))
  192 FORMAT(1X,A4,' MISSING ON  ',I2,3('/',I2.2),' LEVEL:',I2)
  300 FORMAT(80A1)
  301 FORMAT(1X,I2,I2,I2,I2,I5,1X,I5,1X,I5)
  302 FORMAT(6(1X,I5))
  600 FORMAT('     THE FOLLOWING CHECKS WERE ALSO PERFORMED FOR THE',
     &      ' UPPER AIR QA',/'       OF ',I5,' REPORTS, THERE WERE',/,
     &      10X,I5,' CALM WIND CONDITIONS (WS=0, WD=0)'/
     &      10X,I5,' ZERO WIND SPEEDS WITH NONZERO WIND DIRECTIONS'/
     &      10X,I5,' DEW-POINT GREATER THAN DRY BULB TEMPERATURES'/
     &       5X,'THE TIMES OF THESE OCCURRENCES CAN BE FOUND IN THE',
     &          ' MESSAGE FILE'/5X,' WITH QUALIFIERS CLM, WDS, TDT ',
     &            '(RESP.)'//)
  601 FORMAT('$UAUA$')
C
C-----------------------------------------------------------------------
      END
C
C=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
C      SUBROUTINE HTCALC                              31 OCTOBER 1986
C
C      PURPOSE:
C       THIS ROUTINE RECOMPUTES THE HEIGHTS IN AN UPPER AIR REPORT.
C       IT IS CALLED FROM THE UPPER AIR QA PROGRAM.
C
C*****************  VARIABLE DESCRIPTIONS  ***********************
C  CLR       CONSTANT USED IN CALCULATION OF VIRTUAL TEMP
C  E         VAPOR PRESSURE USED IN CALCULATION OF VIRT TEMP
C  H         ARRAY CONTAINING HEIGHTS FOR THE SOUNDING
C  I         LOOP COUNTER
C  N         NUMBER OF LEVELS IN SOUNDING
C  P         ARRAY CONTAINING PRESSURE VALUES FOR SOUNDING
C  Q         SPECIFIC HUMIDITY USED IN CALCULATING VIRTUAL TEMP
C  RDG       CONSTANT USED IN HEIGHT CALCULATION (R DIVIDED BY GRAVITY)
C  T         ARRAY OF TEMPERATURES FOR THE SOUNDING
C  TD        ARRAY OF DEW POINTS FOR THE SOUNDING
C  TO        CONSTANT USED IN CALCULATION OF VIRTUAL TEMP
C  TV1       VIRTUAL TEMPERATURE FOR LEVEL BELOW TV2
C  TV2       VIRTUAL TEMPERATURE FOR LEVEL ABOVE TV1
C  WD        ARRAY CONTAINING WIND DIRECTIONS FOR THE SOUNDING
C  WS        ARRAY CONTAINING WIND SPEEDS FOR THE SOUNDING
C
C*****************  VARIABLE DECLARATIONS  ***********************
      SUBROUTINE HTCALC(ISTAT)
C
      INTEGER ISTAT, I
      REAL CLR, T0, RDG, E, Q, TV1, TV2
C
      PARAMETER (CLR=2500./0.461, T0=1./302.16, RDG=287.0406/9.80616)
C
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'WORK1.INC'
C
      DATA LOC/'HTCALC'/, PATH/'UA'/
C
C*****************  BEGIN SUBROUTINE EXECUTION  ******************
C
      ISTAT = 0
      CALL FLIWK1
C
C *** CHECK FOR MISSING SURFACE HEIGHT
C
      IF(UAOBS(1,1,2) .EQ. UAQA(2,2)) THEN
       MESS = BLNK40
       WRITE(MESS,5000) UAGYR,UAGMO,UAGDY,UAGHR
       CALL ERROR(0,PATH,'Q36',LOC,MESS)
       ISTAT = -1
       RETURN
      ELSE
       IWORK1(1) = UAOBS(1,1,2)
      END IF
C
C-----------------------------------------------------------------------
C *** CHECK FOR MISSING SURFACE TEMPERATURE AND DEW POINT
C      REMEMBER: THESE ARE INTEGERS AND SOME HAVE BEEN MULTIPLIED BY 10
C
      IF(UAOBS(1,1,3) .EQ. UAQA(3,2)) THEN
       MESS = BLNK40
       WRITE(MESS,5010) UAGYR,UAGMO,UAGDY,UAGHR
       CALL ERROR(0,PATH,'Q36',LOC,MESS)
       ISTAT = -1
       RETURN
      ELSE IF( UAOBS(1,1,4) .EQ. UAQA(4,2) ) THEN
       MESS = BLNK40
       WRITE(MESS,5020) UAGYR,UAGMO,UAGDY,UAGHR
       CALL ERROR(0,PATH,'Q36',LOC,MESS)
       ISTAT = -1
       RETURN
      END IF
C
C-----------------------------------------------------------------------
C *** CALCULATE THE VIRTUAL TEMPERATURE FOR THE SURFACE
C
      E   = EXP(CLR*(T0-1.0/((UAOBS(1,1,4)/10.0) + 273.15))) * 40.0
      Q   = (0.62197*E)/((UAOBS(1,1,1)/10.0) - 0.37803*E)
      TV1 = ((UAOBS(1,1,3)/10.0) + 273.15) * (1.+0.6078*Q)
C
C-----------------------------------------------------------------------
C *** LOOP THROUGH THE SOUNDING LEVELS ALOFT
C
      DO 1 I=2,UALEV(1)
C
C- CHECK FOR MISSING TEMPERATURE AND DEW POINT
C
       IF(UAOBS(1,I,3) .EQ. UAQA(3,2)) THEN
        MESS = BLNK40
        WRITE(MESS,5030) I,UAGYR,UAGMO,UAGDY,UAGHR
        CALL ERROR(I,PATH,'Q36',LOC,MESS)
        ISTAT = -1
        RETURN
       ELSE IF( UAOBS(1,I,4) .EQ. UAQA(4,2) ) THEN
        MESS = BLNK40
        WRITE(MESS,5040) I,UAGYR,UAGMO,UAGDY,UAGHR
        CALL ERROR(I,PATH,'Q36',LOC,MESS)
        ISTAT = -1
        RETURN
       END IF
C
       IF( (UAOBS(1,I,1) .EQ. UAQA(1,2)) .OR. (UAOBS(1,I-1,1) .EQ.
     &      UAQA(1,2)) ) THEN
        MESS = BLNK40
        WRITE(MESS,5050) I-1,I,UAGYR,UAGMO,UAGDY,UAGHR
        CALL ERROR(0,PATH,'Q36',LOC,MESS)
        GO TO 1
       ENDIF
C
C- CALCULATE THE VIRTUAL TEMPERATURE
C
C     (EQUATIONS FOR "Q" AND "TV2" WERE DERIVED FROM INFORMATION
C      IN THE SMITHSONIAN MET. TABLES, SIXTH ED., PP. 295 AND 347.)
C     (EQUATION FOR "E" OBTAINED FROM HESS', "INTRODUCTION TO
C      THEORETICAL METEOROLOGY" (1959), P. 49.)
C
      E   = EXP(CLR*(T0-1./((UAOBS(1,I,4)/10.0) + 273.15))) * 40.0
      Q   = (0.62197*E)/((UAOBS(1,I,1)/10.0) - 0.37803*E)
      TV2 = ((UAOBS(1,I,3)/10.0) + 273.15) * (1.+0.6078*Q)
C
C- CALCULATE THE HEIGHT FOR THE CURRENT LEVEL; RETAIN IN WORK ARRAY
C   IN CASE THERE ARE PROBLEMS AT A LEVEL (SEE ABOVE)
C
      IWORK1(I) = IWORK1(I-1) + 0.5*RDG*(TV2+TV1) * ALOG
     &                 ((UAOBS(1,I-1,1)/10.0)/(UAOBS(1,I,1)/10.0))
C
C- SAVE THE VIRTUAL TEMPERATURE FOR THE NEXT CALCULATION
C
      TV1 = TV2
C
    1 CONTINUE
C
C- SUCCESSFUL AT ALL LEVELS; SWAP HEIGHTS FROM WORK ARRAY BACK TO UAOBS
C   ARRAY AND RETURN
C
      DO 5 I = 2,UALEV(1)
       UAOBS(1,I,2) = IWORK1(I)
    5 CONTINUE
      RETURN
C
C-----------------------------------------------------------------------
C *** FORMAT STATEMENTS
C
 5000 FORMAT(' SFC HEIGHT MISSING ON ',3I2,'/',I2)
 5010 FORMAT(' SFC TEMPERATURE MISSING ON ',3I2,'/',I2)
 5020 FORMAT(' SFC DEW POINT MISSING ON ',3I2,'/',I2)
 5030 FORMAT(' TEMP MISSING, LVL',I3,' ON ',3I2,'/',I2)
 5040 FORMAT(' DEWP MISSING, LVL',I3,' ON ',3I2,'/',I2)
 5050 FORMAT(' PRES MISSING, LVL',I3,' OR',I3,' ON ',3I2,'/',I2)
C
C-----------------------------------------------------------------------
      END
