10 REM*****************************DSP1****************************************
20 REM  THIS SUB-PROGRAM DEFINES THE CHEMICAL PROPERTIES AND THE METEOROLOGICAL
30 REM    CONDITIONS.
40 DIM TW(4),CONCI(3),CONCP(3),B(40)
50 COMMON CONCON,IUNIT,QSS,QPIPE,TTSP,TW(),WWIDTH,U,HINV,STB,WAT,WD,OPTN,ZO,UU
60 COMMON HTCONV,ISTAT,IUNCO,STBV,TAK,H,SIGTH,MFLAG,ZOO,PRES,TNU,TA,MW,CLOUD
70 COMMON SR,A,VISCK,CMTC,TMSP,TB,NU,RENL,EOK,DVAP,DLIQ,SIG,HF,PYN,NO
80 COMMON AMW,HS,TS,VF,AT,IUCON,Z,CONCI(),CONCP(),NNNN,T,CMIN,SVE,TC,VP,AA3
90 COMMON SN$,DTE$,ZT$,LA,LO,ZW,DFT,HET,CHM$,DW,PI,EGA,SCR
100 COMMON COL1,COL4,COL5
110 CLS
120 IF PYN>0 THEN 170
130 PRINT "SORRY--YOU MUST START AT THE BEGINNING OF THE PROGRAM."
140 PRINT "PLEASE ENTER <AFTOX>"
150 FOR I=1 TO 15000: NEXT I
160 END
170 IF MFLAG=1 THEN 620: 'SUBSEQUENT MODEL RUN WITH NEW TIME AND MET CONDITIONS
180 REM ************* READ STATION DATA FROM FILE ******************************
190 OPEN "I",#1,"SD.DAT"
200 IF EOF(1) THEN 340
210 INPUT#1,N,SN$,IUNIT,OPTN,WAT,LA,LO,ZOO,ZW,DFT,HET
220 COLOR COL1: PRINT
230 PRINT N;SN$;TAB(22);"LAT =";LA;TAB(35);"LON =";LO;TAB(52);"ROUGHNESS LENGTH(CM) =";ZOO
240 IF OPTN=2 THEN PRINT TAB(9);"SD(";WAT;")";
250 PRINT TAB(22);"GMT-LST =";DFT;
260 IF IUNIT=1 THEN PRINT TAB(35);"WND HGT(m) =";ZW;TAB(54);"ELEV MSL(m) =";HET
270 IF IUNIT=2 THEN PRINT TAB(35);"WND HGT(ft) =";ZW;TAB(54);"ELEV MSL(ft) =";HET
280 IF N<>7 AND N<>14 THEN 200
290 COLOR COL4: PRINT
300 INPUT "ENTER STATION NUMBER OR PRESS <ENTER> FOR MORE";NUM
310 IF NUM=0 THEN 200
320 CLOSE #1
330 GOTO 380
340 PRINT STRING$(79,"-")
350 CLOSE #1
360 IF N=1 THEN 540
370 COLOR COL4: INPUT "ENTER STATION NUMBER ",NUM
380 IF NUM<= N AND NUM>0 THEN 410
390 COLOR COL5: PRINT CHR$(7): PRINT "STATION NUMBER IS INCORRECT--TRY AGAIN" 
400 GOTO 370
410 CLS
420 OPEN "I",#1,"SD.DAT"
430 INPUT#1,N,SN$,IUNIT,OPTN,WAT,LA,LO,ZOO,ZW,DFT,HET
440 IF NUM=N THEN 460
450 GOTO 430
460 CLOSE #1
470 COLOR COL1:PRINT
480 PRINT N;SN$;TAB(22);"LAT =";LA;TAB(35);"LON =";LO;TAB(52);"ROUGHNESS LENGTH(CM) =";ZOO
490 IF OPTN=2 THEN PRINT TAB(9);"SD(";WAT")";
500 PRINT TAB(22);"GMT-LST =";DFT;
510 IF IUNIT=1 THEN PRINT TAB(35);"WND HGT(m) =";ZW;TAB(54);"ELEV MSL(m) =";HET
520 IF IUNIT=2 THEN PRINT TAB(35);"WND HGT(ft) =";ZW;TAB(54);"ELEV MSL(ft) =";HET
530 PRINT STRING$(79,"-")
540 IF PYN=1 THEN 560
550 PRINT #3, "": PRINT #3, SN$: GOTO 570
560 LPRINT: LPRINT SN$
570 IF IUNIT=1 THEN 610
580 HET=HET*.3048
590 ZW=ZW*.3048
600 REM**********TIME AND DATE************************************************
610 ZT$=LEFT$(TIME$,2)+MID$(TIME$,4,2): DTE$=DATE$
620 LOCATE 5,1: COLOR COL1
630 PRINT "THE CURRENT DATE AND TIME ARE ";: COLOR COL4
640 PRINT "<";DTE$;">";: COLOR COL1: PRINT " AND ";: COLOR COL4:PRINT "<";ZT$;">"
650 INPUT "ARE SPILL DATE AND TIME (LOCAL STANDARD) DIFFERENT(Y/N)? <N>",YN$
660 IF YN$="Y" OR YN$="y" THEN 700
670 IF YN$="N" OR YN$="n" OR YN$="" THEN 720
680 IF YN$="999" THEN CLS: GOTO 190
690 PRINT CHR$(7): GOTO 650
700 COLOR COL4: INPUT "ENTER DATE (MM-DD-YYYY) ",DTE$
710 IF DTE$="999" THEN 540
720 DD$=MID$(DTE$,3,3): DD=ABS(VAL(DD$))
730 IF DD<32 THEN 760 
740 PRINT: COLOR COL5: PRINT "TRY AGAIN-INVALID DAY OF MONTH"
750 PRINT CHR$(7): GOTO 700
760 MM$=LEFT$(DTE$,2): MM=VAL(MM$)
770 IF MM<13 THEN 800 
780 PRINT: COLOR COL5: PRINT "TRY AGAIN-INVALID MONTH"
790 PRINT CHR$(7): GOTO 700
800 XDATE=INT(30.4*(MM-1))+DD
810 IF YN$="N" OR YN$="n" OR YN$="" THEN 950
820 INPUT "ENTER LOCAL STANDARD TIME (EX.1025) ",ZT$
830 IF ZT$="999" THEN 700
840 IF ZT$ <= "2359" THEN 870
850 IF ZT$ = "2400" THEN ZT$ ="0000": GOTO 870
860 PRINT CHR$(7): COLOR COL5: PRINT "INVALID TIME - TRY AGAIN": GOTO 820
870 LOCATE 5,1: COLOR COL1
880 PRINT "THE SPILL DATE AND TIME ARE <";DTE$;"> AND <";ZT$;">     "
890 PRINT STRING$(61," ")
900 PRINT STRING$(61," ")
910 PRINT STRING$(61," ")
920 PRINT STRING$(55," ")
930 LOCATE 7,1: COLOR COL4: INPUT "IS THIS CORRECT(Y/N)? <Y>",YY$
940 IF YY$="N" OR YY$="n" THEN 700
950 ZU=VAL(RIGHT$(ZT$,2))
960 HO=VAL(LEFT$(ZT$,2))+ZU/60
970 HO=HO+DFT
980 IF HO>23 THEN HO=HO-24
990 IF PYN=1 THEN 1010
1000 PRINT #3, "": PRINT #3,"DATE: ";DTE$: PRINT #3,"TIME: ";ZT$;" LST" :GOTO 1030
1010 LPRINT: LPRINT "DATE: ";DTE$: LPRINT "TIME: ";ZT$;" LST"
1020 '***********************************************************************
1030 PRES=1013-.1148*HET:    '  STD ATMOS LINEAR BEST FIT APPROXIMATION
1040 MWA=28.966:             '  MOL WT DRY AIR (SMITHSONIAN TABLES, P289)
1050 RCONS=2870400!:         '  GAS CONSTANT FOR DRY AIR (ERG/MOL/K)
1060 RAD=PI/180
1070 CT1=0
1080 IF MFLAG=1 AND NU=0 THEN 3400       'SECOND OR SUBSEQUENT
1090 IF MFLAG=1 THEN 1790:               ' MODEL RUN FOR THIS SPILL
1100 REM*********************TYPE OF SPILL***********************************
1110 CLS
1120 PRINT
1130 PRINT " 1  ";:COLOR COL1 : PRINT "-----CONTINUOUS RELEASE"
1140 COLOR COL4
1150 PRINT " 2  ";:COLOR COL1 : PRINT "-----INSTANTANEOUS RELEASE"
1160 COLOR COL4
1170 PRINT " 3  ";:COLOR COL1 : PRINT "-----CONTINUOUS BUOYANT PLUME(STACK)"
1180 LOCATE 7,4: PRINT "(If unknown, enter <2>)"
1190 LOCATE 6,1
1200 COLOR COL4: INPUT "ENTER TYPE OF SPILL ",ISTAT
1210 IF ISTAT=999 THEN CLS: GOTO 610
1220 IF ISTAT>0 AND ISTAT<4 THEN 1250
1230 PRINT CHR$(7)
1240 GOTO 1110
1250 IF PYN=1 THEN 1310
1260 PRINT #3,"  "
1270 IF ISTAT=1 THEN PRINT #3, "CONTINUOUS RELEASE"
1280 IF ISTAT=2 THEN PRINT #3, "INSTANTANEOUS RELEASE"
1290 IF ISTAT=3 THEN PRINT #3, "CONTINUOUS BUOYANT PLUME"
1300 GOTO 1350
1310 LPRINT
1320 IF ISTAT=1 THEN LPRINT "CONTINUOUS RELEASE"
1330 IF ISTAT=2 THEN LPRINT "INSTANTANEOUS RELEASE"
1340 IF ISTAT=3 THEN LPRINT "CONTINUOUS BUOYANT PLUME"
1350 CLS
1360 IF ISTAT=3 THEN 3400 : 'CONTINUOUS BUOYANT PLUME
1370 REM**************DISPLAY CHEMICAL LIST***********************************
1380 CLS
1390 COLOR COL1
1400 N=0: NU=0
1410 OPEN "I",#2,"CH.DAT"
1420 IF EOF(2) AND NU=0 THEN 1680
1430 IF EOF(2) AND NU>0 THEN 1750
1440 INPUT #2,NN,CHM$,TW(1),TW(2),TW(3),TW(4)
1450 FOR I=1 TO 12
1460 INPUT #2,B(I)
1470 NEXT I
1480 N=N+1
1490 IF NU>0 THEN 1430
1500 IF N<20 THEN PRINT NN;CHM$: GOTO 1420
1510 IF N>19 THEN LOCATE N-19,40: PRINT NN;CHM$
1520 IF N<38 THEN 1420
1530 COLOR COL4: LOCATE 23,1
1540 INPUT "(-ENTER CHEM NO. or press <ENTER> to continue list-)",NU
1550 NU$=STR$(NU)
1560 IF NU=999 THEN CLOSE #2: GOTO 1100
1570 IF NU=0 THEN 1640
1580 IF NU>0 AND NU=<NN THEN 1750
1590 IF NU>NN OR NU<0 THEN PRINT CHR$(7)
1600 COLOR COL5
1610 PRINT "CHEMICAL NO. IS OUT OF RANGE--PLEASE ENTER ANOTHER NUMBER, OR"
1620 PRINT TAB(31): INPUT "PRESS <ENTER> TO CONTINUE LIST";NU
1630 GOTO 1550
1640 CLS
1650 COLOR COL1
1660 N=0
1670 GOTO 1420
1680 PRINT
1690 COLOR COL4
1700 LOCATE 20,1
1710 PRINT "ENTER CHEMICAL NO.-----------------------------|"
1720 PRINT "TO REPEAT LIST, PRESS <R>----------------------|"
1730 PRINT: PRINT "TO ENTER CHEMICAL NOT ON LIST, PRESS <ENTER>---|"
1740 INPUT "                                               ",NU$
1750 CLOSE #2
1760 IF NU$="R" OR NU$="r" THEN 1380
1770 TNU=NN
1780 NU = VAL(NU$)
1790 CLS
1800 IF NU<=TNU AND NU>0 THEN 2530: 'KNOWN CHEMISTRY ON FILE
1810 IF NU=999 THEN CLOSE #2: GOTO 1100
1820 IF NU=0 THEN 1860 
1830 COLOR COL5: PRINT "CHEMICAL NO. INCORRECT - TRY AGAIN": GOTO 1680 
1840 IF MFLAG=1 THEN 3400: 'SUBSEQUENT MODEL RUN WITH TIME & MET UPDATE
1850 REM************CHEMICALS NOT ON LIST*************************************
1860 PRINT "INPUT CHEMICAL NAME: ";
1870 COLOR COL1: INPUT "(if unknown, press <ENTER>) ",CHM$
1880 IF CHM$="999" THEN CLOSE #2: GOTO 1100
1890 IF CHM$="" THEN CHM$="UNKNOWN"
1900 IUNCO=0
1910 VP=0
1920 TC=0
1930 TB=999
1940 IF CHM$<>"UNKNOWN" THEN 2020
1950 IF PYN=1 THEN 1950
1960 PRINT #3, "CHEMICAL IS UNKNOWN": GOTO 1980
1970 LPRINT "CHEMICAL IS UNKNOWN"
1980 IUNCO=1
1990 CLS
2000 PRINT "IF LIQUID, MODEL WILL ASSUME EVAP. RATE = SPILL RATE (WORST CASE)"
2010 GOTO 3400
2020 COLOR COL1: LOCATE 4,1
2030 PRINT "  If no, concentrations will be in mg/m3, and if liquid,"
2040 PRINT "  model will assume evap. rate = spill rate (worst case)"
2050 LOCATE 3,1: COLOR COL4
2060 INPUT "DO YOU KNOW THE MOLECULAR WEIGHT(Y/N)? ",YN$
2070 IF YN$="Y" OR YN$="y" THEN 2120
2080 IF YN$="N" OR YN$="n" THEN IUNCO=1: GOTO 2310
2090 IF YN$="999" THEN 1860
2100 PRINT CHR$(7)
2110 GOTO 2050
2120 LOCATE 7,1
2130 INPUT "MOLECULAR WEIGHT? ",MW
2140 IF MW=999 THEN 2050
2150 INPUT "IS CHEMICAL A LIQUID OR VAPOR AFTER RELEASE (L/V)? ",LV$
2160 IF LV$="V" OR LV$="v" THEN TB=0: GOTO 2310
2170 IF LV$="L" OR LV$="l" THEN 2200
2180 IF LV$="999" THEN 2120
2190 PRINT CHR$(7): GOTO 2150
2200 INPUT "DO YOU KNOW VAPOR PRESSURE OF LIQUID (Y/N)? ",YN$
2210 IF YN$="Y" OR YN$="y" THEN 2290
2220 IF YN$="N" OR YN$="n" THEN 2250
2230 IF YN$="999" THEN 2150
2240 PRINT CHR$(7): GOTO 2200
2250 CLS
2260 COLOR COL1: PRINT
2270 PRINT "MODEL ASSUMES EVAPORATION RATE = SPILL RATE (WORST CASE)"
2280 GOTO 2320
2290 INPUT "VAPOR PRESSURE (mm Hg.)? ",VP
2300 IF VP=999 THEN 2200
2310 CLS
2320 PRINT: COLOR COL1
2330 PRINT "CHEMICAL IS ";CHM$
2340 IF IUNCO=0 THEN 2370
2350 PRINT "MOLECULAR WEIGHT IS UNKNOWN"
2360 GOTO 2390
2370 PRINT "MOLECULAR WEIGHT = ";MW
2380 IF VP>0 THEN PRINT "VAPOR PRESSURE = ";VP;"mm Hg."
2390 PRINT: COLOR COL4: INPUT "ARE THESE DATA CORRECT (Y/N)? <Y> ",YN$
2400 IF YN$="" OR YN$="Y" OR YN$="y" THEN 2420
2410 IF YN$="N" OR YN$="n" OR YN$="999" THEN 1790 ELSE PRINT CHR$(7): GOTO 2390
2420 IF PYN=1 THEN 2470
2430 PRINT #3,"CHEMICAL = ";CHM$ 
2440 IF IUNCO=0 THEN PRINT #3, "MOLECULAR WEIGHT = ";MW
2450 IF VP>0 THEN PRINT #3, "VAPOR PRESSURE = ";VP;"mm Hg."
2460 GOTO 2500
2470 LPRINT "CHEMICAL = ";CHM$
2480 IF IUNCO=0 THEN LPRINT "MOLECULAR WEIGHT = ";MW
2490 IF VP>0 THEN LPRINT "VAPOR PRESSURE = ";VP;"mm Hg."
2500 VP=VP/760
2510 CLS
2520 GOTO 3400
2530 CLS
2540 REM *************** RETRIEVE KNOWN CHEMICAL DATA FROM FILE ****************
2550 OPEN "I",#2,"CH.DAT"
2560 FOR J=1 TO NU
2570 INPUT #2,NN,CHM$,TW(1),TW(2),TW(3),TW(4)
2580 FOR I=1 TO 12
2590 INPUT #2,B(I)
2600 NEXT I
2610 NEXT J
2620 CLOSE #2
2630 CLS
2640 PRINT: COLOR COL1: PRINT "CHEMICAL = ";CHM$
2650 IF PYN=1 THEN 2690
2660 PRINT #3,"  "
2670 PRINT #3, CHM$
2680 GOTO 2710
2690 LPRINT
2700 LPRINT CHM$
2710 IF MFLAG=1 THEN 3280
2720 IF TW(1)=0 AND TW(2)=0 AND TW(3)=0 AND TW(4)=0 THEN 3240:'EXPOSURE LIMITS UNKNOWN
2730 IF TW(3)=0 AND TW(4)=0 THEN 2960
2740 IF TW(1)=0 AND TW(2)=0 THEN 3100
2750 IF PYN=1 THEN GOTO 2820
2760 IF TW(4)=0 THEN PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM ":GOTO 2790
2770 IF TW(3)=0 THEN PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4);"MG M-3":GOTO 2790
2780 PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM (";TW(4); "MG M-3)"
2790 IF TW(2)=0 THEN PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM":GOTO 2880
2800 IF TW(1)=0 THEN PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG M-3":GOTO 2880
2810 PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM (";TW(2);"MG M-3)":GOTO 2880
2820 IF TW(4)=0 THEN LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM":GOTO 2850
2830 IF TW(3)=0 THEN LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4);"MG M-3":GOTO 2860
2840 LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM (";TW(4); "MG M-3)"
2850 IF TW(2)=0 THEN LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM":GOTO 2880
2860 IF TW(1)=0 THEN LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG M-3":GOTO 2880
2870 LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM (";TW(2); "MG M-3)"
2880 PRINT:PRINT "THRESHOLD LIMIT VALUES"
2890 IF TW(4)=0 THEN PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM":GOTO 2920
2900 IF TW(3)=0 THEN PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4);"MG M-3":GOTO 2920
2910 PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM (";TW(4);"MG M-3)"
2920 IF TW(2)=0 THEN PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM":GOTO 3280
2930 IF TW(1)=0 THEN PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG M-3":GOTO 3280
2940 PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM (";TW(2);"MG M-3)"
2950 GOTO 3280
2960 IF PYN=1 THEN 3010
2970 PRINT #3, " SHORT TERM EXPOSURE LIMIT(STEL) IS NOT AVAILABLE"
2980 IF TW(2)=0 THEN PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(1)"PPM":GOTO 3050
2990 IF TW(1)=0 THEN PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(2)"MG M-3":GOTO 3050
3000 PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS";TW(1)"PPM (";TW(2);"MG M-3)":GOTO 3080
3010 LPRINT "SHORT TERM EXPOSURE LIMIT(STEL) IS NOT AVAILABLE"
3020 IF TW(2)=0 THEN LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM":GOTO 3050
3030 IF TW(1)=0 THEN LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG M-3":GOTO 3050
3040 LPRINT " TIME WEIGHTED AVERAGE (TWA) IS";TW(1)"PPM (";TW(2);"MG M-3)"
3050 PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS NOT AVAILABLE"
3060 IF TW(2)=0 THEN PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM":GOTO 3280
3070 IF TW(1)=0 THEN PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG M-3":GOTO 3280
3080 PRINT "  TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM (";TW(2);"MG M-3)"
3090 GOTO 3280
3100 IF PYN=1 THEN 3150
3110 PRINT #3, " TIME WEIGHTED AVERAGE (TWA) IS NOT AVAILABLE"
3120 IF TW(4)=0 THEN PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3)"PPM":GOTO 3190
3130 IF TW(3)=0 THEN PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4)"MG M-3":GOTO 3190
3140 PRINT #3, " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3)"PPM (";TW(4);"MG M-3)":GOTO 3190
3150 LPRINT " TIME WEIGHTED AVERAGE (TWA) IS NOT AVAILABLE"
3160 IF TW(4)=0 THEN LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3)"PPM":GOTO 3190
3170 IF TW(3)=0 THEN LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4)"MG M-3":GOTO 3190
3180 LPRINT " SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3)"PPM (";TW(4);"MG M-3)"
3190 COLOR COL1:PRINT "  TIME WEIGHTED AVERAGE (TWA) IS NOT AVAILABLE"
3200 IF TW(4)=0 THEN PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3)"PPM":GOTO 3280
3210 IF TW(3)=0 THEN PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4)"MG M-3":GOTO 3280
3220 COLOR COL1:PRINT "  SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM (";TW(4);"MG M-3)"
3230 GOTO 3280
3240 IF PYN=1 THEN 3260
3250 PRINT #3, " NO EXPOSURE LIMITS AVAILABLE AT THIS TIME" :GOTO 3270
3260 LPRINT " NO EXPOSURE LIMITS AVAILABLE AT THIS TIME"
3270 COLOR COL1:PRINT "  NO EXPOSURE LIMITS AVAILABLE AT THIS TIME"
3280 MW=B(1):       ' MOLECULAR WEIGHT
3290 TB=B(2):       ' BOILING TEMP (K)
3300 TC=B(3):       ' CRITICAL TEMP (K)
3310 PC=B(4):       ' CRITICAL PRESSURE(ATM)
3320 VC=B(5):       ' CRITICAL VOLUME(CM3/G-MOLE)
3330 AR=B(6):       ' VAPOR PRESSURE CONSTANT, A
3340 BR=B(7):       ' VAPOR PRESSURE CONSTANT, B
3350 CR=B(8):       ' VAPOR PRESSURE CONSTANT, C
3360 AD=B(9):       ' LIQUID DENSITY CONSTANT
3370 BD=B(10):      ' LIQUID DENSITY CONSTANT
3380 SIG=B(11):     ' EFFECTIVE DIAMETER OF MOLECULE(A)
3390 EOK=B(12):     ' ENERGY OF MOLECULAR INTERACTION(J)
3400 GOSUB 8610: 'CALCULATE SOLAR ELEVATION ANGLE
3410 CT1=0
3420 GOSUB 4810: 'INPUT ATMOSPHERIC CONDITIONS
3430 CT1=1
3440 GOSUB 6990: 'CALCULATE RADIATION AND HEAT FLUX
3450 GOSUB 4030: 'COMPUTE AIR PROPERTIES
3460 GOSUB 7230: 'COMPUTE FRICTION VELOCITY AND MONIN-OBUKHOV LENGTH
3470 GOSUB 7640: 'COMPUTE 10 M WIND SPEED
3480 GOSUB 7800: 'CALCULATE STABILITY PARAMETER
3490 IF ISTAT<3 THEN 3530 : 'IF CONTINUOUS BUOYANT PLUME,
3500 ZO=3:                  'SFC ROUGHNESS=3
3510 FOR I=1 TO 15000: NEXT I
3520 CHAIN "DSPHP" 'END OF THIS MODULE FOR CONTINUOUS BUOYANT PLUME
3530 IF IUNCO=1 THEN 3560
3540 CONCON=RCONS*MWA*TAK/(PRES*MW*1000000!)
3550 IF CHM$="NITROGEN TETROXIDE" THEN CONCON=CONCON*2: 'N204 CHANGES TO NO2
3560 IF MFLAG=1 THEN 3760: 'NEW TIME AND MET CONDITIONS FOR THIS SPILL
3570 '***********INPUT ROUGHNESS LENGTH AT SPILL SITE**************************
3580 COLOR COL1 :PRINT "ROUGHNESS LENGTH AT WIND SITE IS";ZOO;"CM"
3590 COLOR COL4
3600 PRINT "ROUGHNESS LENGTH AT SPILL SITE? <";ZOO;">"
3610 COLOR COL1
3620 PRINT: PRINT " For help, press <H>"
3630 LOCATE 6,40
3640 INPUT "",ZO$
3650 IF ZO$="H" OR ZO$="h" THEN GOSUB 3850
3660 ZO=VAL(ZO$)
3670 IF ZO=0 THEN ZO=ZOO
3680 IF ZO=999 THEN 3420
3690 IF PYN=1 THEN 3710
3700 PRINT #3, "SPILL SITE ROUGHNESS LENGTH IS";ZO;"CM": PRINT #3, " ": GOTO 3730
3710 LPRINT "SPILL SITE ROUGHNESS LENGTH IS";ZO;"CM"
3720 LPRINT
3730 IF ZO<.5 THEN ZO=.5
3740 IF ZO>100 THEN ZO=100
3750 '************************************************************************
3760 IF NU=0 OR TAK>TB THEN 3800: ' GAS RELEASE, EXIT MODULE
3770 IF B(6)=0 THEN 3790
3780 GOSUB 4150:                    'COMPUTE VAPOR PRESSURE
3790 GOSUB 4460:                    'COMPUTE LIQUID DENSITY
3800 GOSUB 4690:                    'COMPUTE VAPOR DENSITY
3810 IF MFLAG=1 AND TAK>TB THEN CHAIN "DSP3"
3820 CHAIN "DSP2"
3830 END
3840 '
3850 'SUBROUTINE ROUGHNESS
3860 '------------------------------------------------------------------------
3870 'This subroutine displays the surface roughness for different terrain types
3880 '------------------------------------------------------------------------
3890 CLS
3900 COLOR COL1: PRINT: PRINT
3910 PRINT "           TERRAIN DESCRIPTION                           ROUGHNESS LENGTH(CM)":PRINT
3920 PRINT "SNOW, NO VEGETATION, MUD FLATS, NO OBSTACLES                     0.5 CM "
3930 PRINT "RUNWAY, OPEN FLAT TERRAIN, GRASS, FEW ISOLATED OBSTACLES         3"
3940 PRINT "LOW CROPS, OCCASIONAL LARGE OBSTACLES                           10"
3950 PRINT "HIGH CROPS, SCATTERED OBSTACLES                                 25"
3960 PRINT "PARKLAND, BUSHES, NUMEROUS OBSTACLES                            50"
3970 PRINT "REGULAR LARGE OBSTACLE COVERAGE(SUBURB, FOREST)                100"
3980 PRINT
3990 COLOR COL4: INPUT "ROUGHNESS LENGTH? ",ZO$
4000 CLS
4010 RETURN
4020 '
4030 ' SUBROUTINE AIR
4040 '--------------------------------------------------------------------------
4050 'This subroutine determines properties of air.
4060 '--------------------------------------------------------------------------
4070 REM      DENSITY(G/CM3)
4080 RHO=.34838*PRES/TAK*.001               
4090 REM      DYNAMIC VISCOSITY(G/CM-SEC)
4100 MU=1.458E-05*TAK*SQR(TAK)/(TAK+110.4)  
4110 REM      KINEMATIC VISCOSITY(CM2/SEC)
4120 VISCK=MU/RHO                           
4130 RETURN
4140 '
4150 ' SUBROUTINE VAPOR PRESSURE
4160 '-------------------------------------------------------------------------
4170 'This subroutine calculates the vapor pressure (VP) in atm at ambient temp.
4180 '-------------------------------------------------------------------------
4190 IF B(7)=0 THEN VP=B(6): GOTO 4440
4200 IF B(8)=0 AND B(7)<>0 THEN 4280
4210 REM*******************ANTOINE EQUATION**********************************
4220 XX=TA+CR
4230 VV=AR-BR/XX
4240 VPH=10^VV
4250 VP=VPH/760
4260 GOTO 4440
4270 REM******************FROST-KALKWARF EQUATION***************************
4280 TR=TAK/TC
4290 DR=.421875
4300 AA=AR*(1-1/TR)-BR*LOG(TR)-DR
4310 BB=DR/(TR*TR)
4320 PROLD=EXP(AA)
4330 FOR J=1 TO 50
4340    PR=EXP(AA+BB*PROLD)
4350    IF ABS(1-PR/PROLD)<.0001 THEN 4430
4360    PROLD=PR
4370 NEXT J
4380 COLOR COL5: PRINT "WARNING:  ESTIMATED VAPOR PRESSURE IS";PR*PC;"ATM"
4390 COLOR COL4
4400 IF PYN=1 THEN 4420
4410 PRINT #3, "ESTIMATED VAPOR PRESSURE IS";PR*PC;"ATM" :GOTO 4430
4420 LPRINT "ESTIMATED VAPOR PRESSURE IS";PR*PC;"ATM"
4430 VP=PR*PC
4440 RETURN
4450 '
4460 'SUBROUTINE LIQUID DENSITY
4470 '------------------------------------------------------------------------
4480 'This subroutine calculates the liquid density (DLIQ) in g/cm3
4490 '------------------------------------------------------------------------
4500 IF CHM$<>"DIMETHYLHYDRAZINE(UDMH)" THEN 4550
4510 CD=4.8648E-07
4520 DLIQ=AD-BD*TAK-CD*TAK*TAK
4530 GOTO 4670 
4540 REM*****************CONSTANT LIQUID DENSITY***************************
4550 IF B(9)=0 OR TC=0 THEN DLIQ=1: GOTO 4670
4560 IF B(10)=0 THEN DLIQ=B(9): GOTO 4670
4570 REM*****************GUGGENHEIM EQUATION FOR LIQUID DENSITY************
4580 IF TC<>0 AND VC<>0 THEN 4640
4590 PRINT "SORRY, CRITICAL TEMP AND VOL MUST BE IN CHEM DATA FILE TO COMPUTE"
4600 PRINT "       LIQUID DENSITY.  WILL ASSUME LIQUID DENSITY = 1 G/CM3"
4610 DLIQ=1
4620 FOR I=1 TO 30000: NEXT I
4630 GOTO 4670
4640 TR=TAK/TC
4650 TAU=1-TR
4660 DLIQ=(1+AD*TAU^(1/3)+BD*TAU)/VC*MW       
4670 RETURN
4680 '
4690 'SUBROUTINE VAPOR DENSITY
4700 '------------------------------------------------------------------------
4710 'This subroutine calculates the vapor density (DVAP) in g/cm3
4720 '------------------------------------------------------------------------
4730 IF TC=0 OR PC=0 OR VP=0 THEN DVAP=RHO: GOTO 4790
4740 R=82.06
4750 PP=VP*MW/(R*TAK)
4760 QQ=1-6*TC*TC/(TAK*TAK)
4770 RR=1+9*VP*TC*QQ/(128*PC*TAK)
4780 DVAP=PP*RR
4790 RETURN
4800 '
4810 'SUBROUTINE ATMOS
4820 '------------------------------------------------------------------------
4830 'This subroutine inputs wind, temperature, cloud cover, and snow cover
4840 '------------------------------------------------------------------------
4850 IF CT1=1 THEN 6440: 'CORRECT INVERSION HEIGHT
4860 '----------------------TEMPERATURE--------------------------------
4870 PRINT:COLOR COL4
4880 IF IUNIT=1 THEN 4930
4890 INPUT "AMBIENT TEMPERATURE(F)? ",TA
4900 IF TA=999 THEN 1350
4910 TA=(TA-32)/1.8
4920 GOTO 4950
4930 INPUT "AMBIENT TEMPERATURE(C)? ",TA
4940 IF TA=999 THEN 1350
4950 TAK=TA+273.16
4960 IF TAK<323 AND TAK>233 THEN 5000
4970 PRINT CHR$(7): COLOR COL5
4980 PRINT "TEMP IS UNREASONABLE-- PLEASE ENTER NEW TEMP":GOTO 4870
4990 '---------------WIND DIRECTION AND SPEED---------------------------
5000 INPUT "WIND DIRECTION? ",WD
5010 IF WD=999 THEN 4880
5020 IF WD<0 OR WD>360 THEN PRINT CHR$(7): GOTO 5000
5030 IF IUNIT=1 THEN 5140
5040 INPUT "WIND SPEED(KNOTS)? ",UU
5050 IF UU>=1 THEN 5100
5060 COLOR COL1: PRINT "WIND IS ASSUMED TO BE 1 KNOTS"
5070 PRINT CHR$(7)
5080 FOR I=1 TO 15000:NEXT I
5090 UU=1
5100 IF UU=999 THEN 5000
5110 UIN=UU
5120 UU=UU*.51479
5130 GOTO 5220
5140 INPUT "WIND SPEED(M/S)? ",UU
5150 IF UU>=.5 THEN 5200
5160 COLOR COL1: PRINT "WIND IS ASSUMED TO BE 0.5 M/S"
5170 PRINT CHR$(7)
5180 FOR I=1 TO 15000: NEXT I
5190 UU=.5
5200 IF UU=999 THEN 5000
5210 UIN=UU
5220 CLS: COLOR COL1: PRINT " ***** INPUT WEATHER DATA *****"
5230 '------------------PRINT (metric)-----------------------------------
5240 IF IUNIT=2 THEN 5400
5250 PRINT: PRINT "TEMPERATURE =";TA;"C"
5260 PRINT "WIND DIRECTION =";WD,"WIND SPEED =";UIN;"M/S"
5270 PRINT: COLOR COL4: INPUT "ARE THESE VALUES CORRECT (Y/N)? <Y> ",YN$
5280 IF YN$="" OR YN$="Y" OR YN$="y" THEN 5320 
5290 IF YN$="N" OR YN$="n" THEN 4810 
5300 IF YN$="999" THEN 5030 
5310 PRINT CHR$(7): GOTO 5220
5320 IF PYN=1 THEN 5360
5330 PRINT #3," ":PRINT #3, "TEMPERATURE =";TA;"C"
5340 PRINT #3, "WIND DIRECTION =";WD 
5350 PRINT #3, "WIND SPEED =";UIN;"M/S": GOTO 5540
5360 LPRINT: LPRINT "TEMPERATURE =";TA;"C"
5370 LPRINT "WIND DIRECTION =";WD
5380 LPRINT "WIND SPEED =";UIN;"M/S": GOTO 5540
5390 '-------------------PRINT (English)----------------------------------
5400 PRINT: PRINT "   TEMPERATURE =";1.8*TA+32;"F"
5410 PRINT "WIND DIRECTION =";WD,"WIND SPEED =";UIN;"KNOTS"
5420 PRINT: COLOR COL4: INPUT "ARE THESE DATA CORRECT (Y/N)? <Y> ",YN$
5430 IF YN$="" OR YN$="Y" OR YN$="y" THEN 5470 
5440 IF YN$="N" OR YN$="n" THEN 4810 
5450 IF YN$="999" THEN 5030 
5460 PRINT CHR$(7): GOTO 5400
5470 IF PYN=1 THEN 5510
5480 PRINT #3," ": PRINT #3, "TEMPERATURE =";1.8*TA+32;" F" 
5490 PRINT #3, "WIND DIRECTION =";WD 
5500 PRINT #3, "WIND SPEED =";UIN;"KNOTS": GOTO 5540
5510 LPRINT: LPRINT "TEMPERATURE =";1.8*TA+32;" F"
5520 LPRINT "WIND DIRECTION =";WD
5530 LPRINT "WIND SPEED =";UIN;"KNOTS"
5540 IF OPTN=1 THEN 5820:    'NO STANDARD DEVIATION OF WIND DIRECTION
5550 '---------STANDARD DEVIATION OF WIND DIRECTION--------------------
5560 CLS
5570 LOCATE 3,2: COLOR COL1
5580 PRINT "(If SD not available, press <ENTER>)"
5590 COLOR COL4: LOCATE 2,1
5600 INPUT "STANDARD DEVIATION OF WIND DIRECTION (deg)";SIGTH
5610 IF SIGTH=999 THEN 5220
5620 IF SIGTH=0 THEN OPTN=1: GOTO 5820 
5630 IF SIGTH>0 THEN 5660
5640 COLOR COL5: PRINT "CANNOT USE ZERO OR NEGATIVE VALUE"
5650 PRINT CHR$(7): COLOR COL4: GOTO 5560
5660 IF Y$="Y" OR Y$="y" OR Y$="" THEN 5680
5670 COLOR COL1: PRINT "S.D. AVERAGING TIME CAN ONLY BE CHANGED IN <SD.DAT> FILE."
5680 PRINT: PRINT: COLOR COL1
5690 PRINT "STANDARD DEVIATION OF WIND DIRECTION =";SIGTH;"DEG"
5700 PRINT "STANDARD DEVIATION AVERAGING TIME =";WAT;;"MIN": PRINT
5710 COLOR COL4: INPUT "ARE THESE VALUES CORRECT (Y/N)? <Y> ",Y$
5720 IF Y$="" OR Y$="Y" OR Y$="y" THEN 5760
5730 IF Y$="N" OR Y$="n" OR Y$="999" THEN 5560
5740 PRINT CHR$(7)
5750 GOTO 5680
5760 IF PYN=1 THEN 5790
5770 PRINT #3, "STANDARD DEVIATION OF WIND DIRECTION =";SIGTH;"DEG" 
5780 PRINT #3, "STANDARD DEVIATION AVERAGING TIME =";WAT;"MIN": GOTO 5820
5790 LPRINT "STANDARD DEVIATION OF WIND DIRECTION =";SIGTH;"DEG"
5800 LPRINT "STANDARD DEVIATION AVERAGING TIME =";WAT;"MIN"
5810 '--------------------CLOUD COVER-----------------------------
5820 CLS
5830 CC=0
5840 RT=0
5850 COLOR COL4: PRINT
5860 INPUT "CLOUD COVER IN EIGHTHS";CLOUD
5870 IF CLOUD=999 AND OPTN=2 THEN 5560
5880 IF CLOUD=999 AND OPTN=1 THEN 5030
5890 IF CLOUD<9 AND CLOUD>=0 THEN 5920
5900 PRINT CHR$(7)
5910 GOTO 5820
5920 IF DAY$="Y" THEN 5970
5930 IF PYN=1 THEN 5950
5940 PRINT #3,"NIGHTTIME SPILL" :GOTO 5960
5950 LPRINT "NIGHTTIME SPILL"
5960 GOTO 6110
5970 IF PYN=1 THEN 5990
5980 PRINT #3, "SUN ELEVATION ANGLE IS"; INT(SOLAL);"DEGREES" :GOTO 6000
5990 LPRINT "SUN ELEVATION ANGLE IS";INT(SOLAL);"DEGREES"
6000 IF CLOUD=0 THEN 6110
6010 PRINT: PRINT " 1 ";: COLOR COL1: PRINT " HIGH--Ci, Cc, Cs"
6020 COLOR COL4: PRINT " 2 ";: COLOR COL1: PRINT " MIDDLE--Ac, As, Sc, Cu"
6030 COLOR COL4: PRINT " 3 ";: COLOR COL1: PRINT " LOW--St, Ns, Fog"
6040 PRINT
6050 COLOR COL4: INPUT "ENTER PREDOMINANT CLOUD CATEGORY ",CC
6060 IF CC=1 THEN RT=.61
6070 IF CC=2 THEN RT=.26
6080 IF CC=3 THEN RT=.17
6090 IF CC=999 THEN 5820
6100 IF CC<1 OR CC>3 THEN PRINT CHR$(7): GOTO 6050
6110 ALB=.23
6120 '------------------------GROUND COVER-------------------------------
6130 CLS
6140 PRINT
6150 IF TA>=20 THEN 6290
6160 INPUT "IS THE GROUND SNOW COVERED (Y/N)? <N> ",YN$
6170 IF YN$="N" OR YN$="n" OR YN$="" THEN 6290
6180 IF YN$="Y" OR YN$="y" THEN 6210
6190 IF YN$="999" THEN 5820
6200 PRINT CHR$(7): GOTO 6160
6210 IF PYN=1 THEN 6230
6220 PRINT #3, "THERE IS SNOW COVER": GOTO 6240
6230 LPRINT "THERE IS A SNOW COVER"
6240 ALB=.75
6250 ALPHA=1!
6260 C3=0
6270 DW=2
6280 GOTO 6430
6290 INPUT "IS THE GROUND WET (Y/N)? <N> ",YN$
6300 IF YN$="N" OR YN$="n" OR YN$="" THEN 6350
6310 IF YN$="Y" OR YN$="y" THEN 6390
6320 IF YN$="999" AND TA>=20 THEN 5820
6330 IF YN$="999" AND TA<20 THEN 6110
6340 PRINT CHR$(7): GOTO 6290 
6350 DW=1 
6360 ALPHA=.45
6370 C3=.25
6380 GOTO 6430
6390 DW=2 
6400 ALPHA=1!
6410 C3=.12
6420 '---------------------INVERSION HEIGHT---------------------------------
6430 PRINT
6440 IF IUNIT=1 THEN INPUT "IS THERE AN INVERSION LAYER BELOW 500 M (Y/N)? <N>",YN$
6450 IF IUNIT=2 THEN INPUT "IS THERE AN INVERSION LAYER BELOW 2000 FT (Y/N)? <N>",YN$
6460 IF YN$="N" OR YN$="n" OR YN$="" THEN HINV=10000: GOTO 6590
6470 IF YN$="Y" OR YN$="y" THEN 6510
6480 IF YN$="999" THEN 6110
6490 PRINT CHR$(7)
6500 GOTO 6430
6510 IF IUNIT=1 THEN 6560
6520 INPUT "HEIGHT OF INVERSION BASE IN FT? ",HIFT
6530 IF HIFT=999 THEN 6430 
6540 HINV=HIFT*.3048
6550 GOTO 6590
6560 INPUT "HEIGHT OF INVERSION BASE IN M? ",HINV
6570 IF HINV=999 THEN 6430 
6580 '--------------------PRINT TO SCREEN----------------------
6590 CLS: COLOR COL1
6600 PRINT "CLOUD COVER IS";CLOUD;"EIGHTHS"
6610 IF CC=1 THEN PRINT "CLOUD TYPE IS HIGH (Ci Cc, Cs)"
6620 IF CC=2 THEN PRINT "CLOUD TYPE IS MIDDLE (Ac, As, Sc, Cu)" 
6630 IF CC=3 THEN PRINT "CLOUD TYPE IS LOW (St, Ns, fog)"
6640 IF ALB=.75 THEN PRINT "GROUND IS SNOW COVERED"
6650 IF ALB=.23 THEN PRINT "GROUND IS NOT SNOW COVERED"
6660 IF DW=1 THEN PRINT "GROUND IS DRY" 
6670 IF DW=2 THEN PRINT "GROUND IS WET"
6680 IF HINV=10000 THEN PRINT "THERE IS NO INVERSION" : GOTO 6710
6690 IF IUNIT=1 THEN PRINT "THE INVERSION HEIGHT IS";HINV;"M" 
6700 IF IUNIT=2 THEN PRINT "THE INVERSION HEIGHT IS";HIFT;"FT"
6710 PRINT: COLOR COL4: INPUT "ARE THESE DATA CORRECT (Y/N)? <Y> ",YN$
6720 IF YN$="" OR YN$="Y" OR YN$="y" THEN 6760 
6730 IF YN$="N" OR YN$="n" OR YN$="999" THEN 5820 
6740 PRINT CHR$(7): GOTO 6590
6750 '-----------------PRINT TO FILE OR PRINTER----------------------
6760 CLS
6770 IF PYN=1 THEN 6880
6780 PRINT #3, "CLOUD COVER IS";CLOUD;"EIGHTHS"
6790 IF CC=1 THEN PRINT #3, "CLOUD TYPE IS HIGH (Ci, Cc, Cs)" 
6800 IF CC=2 THEN PRINT #3, "CLOUD TYPE IS MIDDLE (Ac, As, Sc, Cu)" 
6810 IF CC=3 THEN PRINT #3, "CLOUD TYPE IS LOW (St, Ns, FOG)"
6820 IF DW=1 THEN PRINT #3, "GROUND IS DRY" 
6830 IF DW=2 THEN PRINT #3, "GROUND IS WET"
6840 IF HINV=10000 THEN PRINT #3, "THERE IS NO INVERSION" :GOTO 6970
6850 IF IUNIT=1 THEN PRINT #3, "THE INVERSION HEIGHT IS";HINV;"M"
6860 IF IUNIT=2 THEN PRINT #3, "THE INVERSION HEIGHT IS";HIFT;"FT"  
6870 GOTO 6970
6880 LPRINT "CLOUD COVER IS";INT(CLOUD);"EIGHTHS"
6890 IF CC=1 THEN LPRINT "CLOUD TYPE IS HIGH (Ci Cc, Cs)" 
6900 IF CC=2 THEN LPRINT "CLOUD TYPE IS MIDDLE (Ac, As, Sc, Cu)" 
6910 IF CC=3 THEN LPRINT "CLOUD TYPE IS LOW (St, Ns, fog)"
6920 IF DW=1 THEN LPRINT "GROUND IS DRY"
6930 IF DW=2 THEN LPRINT "GROUND IS WET"
6940 IF HINV=10000 THEN LPRINT "THERE IS NO INVERSION": GOTO 6970
6950 IF IUNIT=1 THEN LPRINT "THE INVERSION HEIGHT IS";HINV;"M" 
6960 IF IUNIT=2 THEN LPRINT "THE INVERSION HEIGHT IS";HIFT;"FT"
6970 RETURN
6980 '
6990 'SUBROUTINE HEAT FLUX
7000 '-------------------------------------------------------------------------
7010 'This subroutine calculates:  Incoming solar radiation (SR)
7020 '                             Net radiation at the surface (Q)
7030 '                             Sensible heat flux (HF)
7040 '-------------------------------------------------------------------------
7050 '*********COMPUTE INCOMING SOLAR RADIATION (SR)**************************
7060 IF DAY$="Y" THEN 7100
7070 SR=0
7080 HF=-40*(1-CLOUD/8)
7090 GOTO 7210
7100 SOLAR=SOLAL*RAD
7110 SR=990*SIN(SOLAR)-30                  
7120 SR=SR*(1-(1-RT)*(CLOUD/8)^3.4)   
7130 '********COMPUTE NET RADIATION AT SURFACE (Q)****************************
7140 Q=((1-ALB)*SR+5.31E-13*TAK^6-5.67E-08*TAK^4+60*CLOUD/8)/(1+C3) 
7150 '********COMPUTE SENSIBLE HEAT FLUX (HF)*********************************
7160 GS=119.56-.7843*TAK+.0012887*TAK*TAK   
7170 IF ALB=.23 THEN G=.1*Q ELSE G=0:   'SOIL HEAT FLUX 
7180 HF=((1-ALPHA)+GS)/(1+GS)*(Q-G)-20*ALPHA
7190 IF TA>0 AND ALB=.75 THEN 7210
7200 IF HF<0 THEN HF=0
7210 RETURN
7220 '
7230 'SUBROUTINE MOL_FRIC
7240 '------------------------------------------------------------------------
7250 ' This subroutine calculates the friction velocity (US) and Monin-Obuklov
7260 ' length (L)
7270 '------------------------------------------------------------------------
7280 IF ABS(HF)>1 THEN 7340
7290 '*****COMPUTE FRICTION VELOCITY (US) FOR NEUTRAL CONDITIONS**************
7300 US=.4*UU/LOG(100*ZW/ZOO) 
7310 EUS=US
7320 GOTO 7390
7330 '******ESTIMATE FRICTION VELOCITY (EUS)**********************************
7340 EU1=UU*(10/ZW)^.2
7350 EUS=(EU1+.8*HF/(HF+100))/12
7360 IF EUS<0 THEN EUS=UU/12
7370 EF=EUS/UU
7380 '******COMPUTE MONIN-OBUKHOV LENGTH (L)**********************************
7390 LL=-.0112*HF/(PRES*EUS^3)
7400 IF LL=0 THEN LL=1E-15
7410 L=1/LL
7420 IF HF<-1 THEN 7490
7430 IF HF<1 THEN 7620
7440 '*******COMPUTE FRICTION VELOCITY FOR UNSTABLE CONDITIONS****************
7450 X=(1-15*ZW/L)^.25
7460 XO=(1-15*ZOO/(100*L))^.25
7470 KUU=2*(ATN(X)-ATN(XO))+LOG((X-1)/(XO-1))-LOG((X+1)/(XO+1))
7480 GOTO 7530
7490 '********COMPUTE FRICTION VELOCITY FOR STABLE CONDITIONS*****************
7500 ALPHA=ZW/ABS(L)
7510 IF ZW/ABS(L)>1 THEN ALPHA=1
7520 KUU=LOG(100*ZW/ZOO)+5.2*ALPHA
7530 US=.4*UU/KUU
7540 UV=US/UU
7550 DUV=UV-EF
7560 IF ABS(DUV)<.001 THEN 7610
7570 DX=.001
7580 IF DUV<0 THEN DX=-.001
7590 EUS=EUS+DX
7600 GOTO 7370
7610 US=(US+EUS)/2
7620 RETURN
7630 '
7640 'SUBROUTINE U10
7650 '-----------------------------------------------------------------------
7660 'This subroutine calculates the wind speed at the 10 m level.  This wind 
7670 'is used in the diffusion model
7680 '-----------------------------------------------------------------------
7690 IF ABS(HF)>1 THEN 7720
7700 U=US/.4*LOG(1000/ZOO)        
7710 GOTO 7780
7720 IF HF>1 THEN 7760
7730 IF L>10 THEN ALPHA=10/L ELSE ALPHA=1
7740 U=US/.4*(LOG(1000/ZOO)+5.2*ALPHA)
7750 GOTO 7780
7760 X=(1-150/L)^.25
7770 U=US/.4*(2*(ATN(X)-ATN(XO))+LOG((X-1)/(XO-1))-LOG((X+1)/(XO+1)))
7780 RETURN
7790 '
7800 'SUBROUTINE STABPAR
7810 '------------------------------------------------------------------------
7820 'This subroutine calculates the stability parameter (STB)
7830 '------------------------------------------------------------------------
7840 IF OPTN=2 THEN 8090: 'SIGMA THETA IS KNOWN; USE MITCHELL'S METHOD
7850 '********************OPTION 1********************************************
7860 'DEFINE STABILITY PARAMETER (STB) FROM GOLDER'S CHART RELATING
7870 '1/L AND ZO TO PASQUILL CLASSES (EQUATIONS DEVELOPED BY KUNKEL AT GL(AFSC)
7880 'IF LL>.08 THEN LL=.08
7890 'IF LL<-.12 THEN LL=-.12
7900 AA=3.5+21.67*LL
7910 B=.48
7920 IF ABS(LL)<.015 THEN B=43.63*ABS(LL)^1.08
7930 IF LL<0 THEN B=-B
7940 ZTEMP=ZOO
7950 IF ZOO >40 THEN ZTEMP=40
7960 IF ZOO<.1 THEN ZTEMP=.1
7970 STB=AA+B*LOG(ZTEMP)/LOG(10)  
7980 IF STB<.5 THEN STB=.5
7990 IF STB>6 THEN STB=6
8000 IF HINV>=50 THEN 8040 
8010 STBV=6
8020 HINV=10000
8030 GOTO 8360
8040 STBV=STB
8050 GOTO 8360
8060 '*********************OPTION 2********************************************
8070 'COMPUTE STABILITY (STB) USING MITCHELL'S METHOD
8080 '(REF: MITCHELL,1982, ATMOS. ENVIRON., 16, 765-773)
8090 SIGTH10=SIGTH*(10/ZW)^-.2: 'ADJUST TO 10M HEIGHT 
8100 SIG60=SIGTH10*(60/WAT)^.2: 'ADJUST TO 60 MIN TIME
8110 IF SIG60<27.35 THEN 8140
8120 STB=.5
8130 GOTO 8160
8140 STB=6.46-.341*SIG60+.0045*SIG60*SIG60   
8150 IF STB>6 THEN STB=6
8160 IF DAY$="N" THEN 8200
8170 IF STB>3.5 THEN STB=3.5
8180 STBV=STB
8190 GOTO 8340
8200 '*******NIGHTTIME********
8210 IF SIG60>12.5 THEN 8240
8220 STBV=STB
8230 GOTO 8340
8240 IF SIG60>17.5 THEN 8280
8250 STBV=9.600001/U
8260 IF STBV>5 THEN STBV=5
8270 GOTO 8320
8280 IF SIG60>22.5 THEN 8310
8290 STBV=12/U
8300 GOTO 8320
8310 STBV=14.44/U
8320 IF STBV>6 THEN STBV=6
8330 IF STBV<3.5 THEN STBV=3.5
8340 IF HINV<50 THEN STBV=6: HINV=10000
8350 '**************************
8360 IF STBV<3! THEN ST$="UNSTABLE"
8370 IF STBV>=3! AND STBV<4! THEN ST$="NEAR NEUTRAL"
8380 IF STBV>=4! THEN ST$="STABLE"
8390 PRINT
8400 COLOR COL1
8410 IF DAY$="N" THEN 8430
8420 PRINT "SUN ELEVATION ANGLE IS";INT(SOLAL);"DEGREES"
8430 IF STB<STBV THEN 8500
8440 PRINT "ATMOSPHERIC STABILITY CONDITIONS ARE ";ST$
8450 IF U<2 AND STB=6 THEN PRINT "    (meandering of plume may be occurring)"
8460 IF PYN=1 THEN 8480
8470 PRINT #3,"ATMOSPHERIC STABILITY PARAMETER IS";INT(100*STB)/100: GOTO 8490
8480 LPRINT "ATMOSPHERIC STABILITY PARAMETER IS";INT(100*STB)/100
8490 GOTO 8580
8500 PRINT "ATMOSPHERIC STABILITY CONDITIONS ARE ";ST$;
8510 PRINT "    (meandering of plume may be occurring)"
8520 IF PYN=1 THEN 8560
8530 PRINT #3,"HORIZONTAL STABILITY PARAMETER IS";INT(100*STB)/100
8540 PRINT #3,"VERTICAL STABILITY PARAMETER IS";INT(100*STBV)/100
8550 GOTO 8580
8560 LPRINT "HORIZONTAL STABILITY PARAMETER IS";INT(100*STB)/100
8570 LPRINT "VERTICAL STABILITY PARAMETER IS";INT(100*STBV)/100
8580 PRINT
8590 RETURN
8600 '
8610 'SUBROUTINE SOLAR ANGLE
8620 '-------------------------------------------------------------------------
8630 'This subroutine computes the solar angle (SOLAL) based on time,
8640 'date and location.
8650 '-------------------------------------------------------------------------
8660 'CALCULATE ANGULAR FRACTION OF A YEAR FOR A GIVEN JULIAN DATE (A1)
8670 A1=(XDATE-1)*360/365.242
8680 'CALCULATE SIN & COS OF SOLAR DECLINATION ANGLE (A4,D3)
8690 A2=279.9348+A1
8700 A1=A1*RAD
8710 A2=A2+1.914827*SIN(A1)-.079525*COS(A1)
8720 A2=A2+.019938*SIN(2*A1)-.00162*COS(2*A1) 
8730 A3=23.4438
8740 A4=SIN(A3*RAD)*SIN(A2*RAD)
8750 D3=SQR(1-A4*A4+1E-09)
8760 'CALCULATE THE TIME OF MERIDIAN PASSAGE-TRUE SOLAR NOON (A5)
8770 A5=12+.12357*SIN(A1)-.004289*COS(A1)
8780 A5=A5+.153809*SIN(2*A1)+.060783*COS(2*A1)
8790 'CALCULATE SOLAR HOUR ANGLE (A6)
8800 A6=15*(HO-A5)-LO     
8810 'CALCULATE SIN OF SOLAR ALTITUDE (A7)
8820 A7=SIN(LA*RAD)*A4+COS(LA*RAD)*D3*COS(A6*RAD)
8830 SOLAL=ATN(A7/SQR(-A7*A7+1))
8840 SOLAL=SOLAL/RAD
8850 IF SOLAL<0 THEN SOLAL=0
8860 COLOR COL1: PRINT
8870 IF SOLAL=0 THEN PRINT "NIGHTTIME RELEASE": DAY$="N"
8880 IF SOLAL>0 THEN PRINT "DAYTIME RELEASE": DAY$="Y"
8890 RETURN
