10 REM*********************************DSP3************************************
20 REM THIS SUB-PROGRAM COMPUTES 1) THE HAZARD AREA, 2) THE MAX CONCENTRATION,
30 REM   AND 3) THE CONCENTRATION AT A GIVEN POINT AND TIME.
40 DIM XS(500),YS(500),YSM(500),SFAK(14),SEXP(14)
50 DIM XS1(500),YS1(500),XS2(500),YS2(500),XS3(500),YS3(500)
60 DIM TW(4),CONCI(3),CONCP(3),B(40)
70 COMMON CONCON,IUNIT,QSS,QPIPE,TTSP,TW(),WWIDTH,U,HINV,STB,WAT,WD,OPTN,ZO,UU
80 COMMON HTCONV,ISTAT,IUNCO,STBV,TAK,H,SIGTH,MFLAG,ZOO,PRES,TNU,TA,MW,CLOUD
90 COMMON SR,A,VISCK,CMTC,TMSP,TB,NU,RENL,EOK,DVAP,DLIQ,SIG,HF,PYN,NO
100 COMMON AMW,HS,TS,VF,AT,IUCON,Z,CONCI(),CONCP(),NNNN,T,CMIN,SVE,TC,VP,AA3
110 COMMON SN$,DTE$,ZT$,LA,LO,ZW,DFT,HET,CHM$,DW,PI,EGA,SCR
120 COMMON COL1,COL4,COL5
130 IF PYN>0 THEN 170
140 PRINT "SORRY--YOU CAN NOT START IN THE MIDDLE OF THE PROGRAM."
150 PRINT "PLEASE ENTER <AFTOX>"
160 END
170 RAD=PI/180
180 XXX=0
190 CXX=0
200 IF MFLAG=1 THEN OPT=1: GOTO 2400
210 '---------------------------------------------------------------------------
220 PRINT
230 COLOR COL1
240 AT=INT(TTSP)
250 IF AT>15 THEN AT=15
260 IF AT<1 THEN AT=1
270 PRINT "DEFAULT CONCENTRATION AVERAGING TIME IS";AT;"MIN"
280 COLOR COL4:INPUT "PRESS <ENTER> TO CONTINUE OR INPUT NEW TIME";AT$
290 IF AT$<>"" THEN AT=VAL(AT$)
300 IF AT<>999 THEN 340
310 COLOR COL1: PRINT "AT THIS POINT IN THE PROGRAM YOU CAN NOT BACK UP"
320 PRINT CHR$(7)
330 GOTO 220
340 IF AT=>1 THEN 380
350 AT=1
360 PRINT "AVERAGING TIME CAN NOT BE LESS THAN 1 MIN"
370 PRINT "AVERAGING TIME SET AT 1 MIN": PRINT CHR$(7): GOTO 510
380 IF AT<=TTSP OR AT=1 THEN 510
390 AT=TTSP
400 PRINT CHR$(7)
410 COLOR COL1: PRINT
420 PRINT "CONC AVERAGING TIME SHOULD NOT BE GREATER THAN THE RELEASE TIME"
430 PRINT "AVERAGING TIME HAS BEEN CHANGED TO RELEASE TIME (or 1 min,";
440 PRINT " whichever is greater)":PRINT
450 COLOR COL4
460 INPUT "PRESS <ENTER> TO CONTINUE OR <999 ENTER> TO ENTER NEW TIME",N$
470 IF N$="999" THEN 220
480 IF N$<>"" THEN 390
490 COLOR COL1: PRINT
500 PRINT "CONCENTRATION AVERAGING TIME IS";INT(100*AT)/100;"MIN"
510 IF PYN=1 THEN 530
520 PRINT #3,"CONCENTRATION AVERAGING TIME IS";INT(100*AT)/100;"MIN": GOTO 540
530 LPRINT "CONCENTRATION AVERAGING TIME IS";INT(100*AT)/100;"MIN"
540 IF NFLAG=1 THEN 2400
550 '---------------------------------------------------------------------------
560 CLS
570 CC1=0
580 COLOR COL4: PRINT "1";
590 COLOR COL1
600 IF EGA=2 THEN PRINT "  HAZARD DISTANCE FOR GIVEN CONCENTRATION": GOTO 620
610 PRINT "  TOXIC CORRIDOR PLOT"
620 COLOR COL4: PRINT "2";
630 COLOR COL1: PRINT "  CONCENTRATION AT SPECIFIED LOCATION AND TIME"
640 COLOR COL4: PRINT "3";
650 COLOR COL1: PRINT "  MAXIMUM CONCENTRATION AT GIVEN HEIGHT AND TIME"
660 PRINT
670 COLOR COL4: INPUT "CHOOSE ONE OF THE ABOVE OPTIONS ",OPT
680 IF OPT=999 THEN 220
690 IF OPT>3 OR OPT<1 THEN PRINT CHR$(7): GOTO 560
700 '---------------------------------------------------------------------------
710 CLS
720 IF TTSP=10000 THEN T=10000: GOTO 900
730 COLOR COL1
740 IF TTSP>.25 THEN 800
750 IF TB=999 THEN 770
760 PRINT "THIS IS AN INSTANTANEOUS GAS RELEASE."
770 PRINT "DEFAULT ELAPSED TIME SINCE START OF SPILL IS 10 MIN"
780 DET=10
790 GOTO 820
800 DET=INT(TTSP)
810 PRINT "DEFAULT ELAPSED TIME SINCE START OF SPILL IS";DET;"MIN"
820 COLOR COL4
830 INPUT "PRESS <ENTER> TO CONTINUE OR INPUT ELAPSED TIME IN MIN? ",T
840 IF T=999 THEN 560
850 IF T=0 THEN T=DET
860 IF T<0 THEN PRINT CHR$(7): GOTO 710
870 IF PYN=1 THEN 890
880 PRINT #3,"ELAPSED TIME SINCE START OF SPILL IS";T;"MIN": GOTO 900
890 LPRINT "ELAPSED TIME SINCE START OF SPILL IS";T;"MIN"
900 IF OPT=1 THEN 940
910 IF OPT=2 THEN GOSUB 6650  'CONPOINT
920 IF OPT=3 THEN GOSUB 7740  'MAXCONC
930 GOTO 14480   'CLOSE INPUT FILE AND END
940 IF NUM=8 THEN 970
950 IF NFLAG=1 THEN 2400
960 '
970 '------------------CONCENTRATION CONTOUR PLOT-------------------------------
980 '
990 CLS
1000 IF ISTAT=3 OR NU=0 THEN 1470
1010 COLOR COL1
1020 IF TW(1)=0 AND TW(2)=0 AND TW(3)=0 AND TW(4)=0 THEN 1160
1030 IF TW(3)=0 AND TW(4)=0 THEN 1090
1040 IF TW(3)<>0 AND TW(4)<>0 THEN 1080
1050 IF TW(4)=0 THEN PRINT "THE SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM"
1060 IF TW(3)=0 THEN PRINT "THE SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(4);"MG/M3"
1070 GOTO 1090
1080 PRINT "THE SHORT TERM EXPOSURE LIMIT (STEL) IS";TW(3);"PPM (";TW(4);"MG/M3)"
1090 IF TW(1)=0 AND TW(2)=0 THEN 1180
1100 IF TW(1)<>0 AND TW(2)<>0 THEN 1140
1110 IF TW(2)=0 THEN PRINT "THE TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM"
1120 IF TW(1)=0 THEN PRINT "THE TIME WEIGHTED AVERAGE (TWA) IS";TW(2);"MG/M3"
1130 GOTO 1180
1140 PRINT "THE TIME WEIGHTED AVERAGE (TWA) IS";TW(1);"PPM (";TW(2);"MG/M3)"
1150 GOTO 1180
1160 PRINT "NO EXPOSURE LIMITS AVAILABLE"
1170 GOTO 1470
1180 PRINT: COLOR COL4
1190 IF TW(3)=0 AND TW(4)=0 THEN 1320
1200 INPUT "DO YOU WISH TO PLOT STEL(Y/N)? <Y>",Y$
1210 IF Y$="N" OR Y$="n" THEN 1470 
1220 IF Y$="999" AND TTSP=10000 THEN 560
1230 IF Y$="999" AND TTSP<>10000 THEN 710
1240 IF TW(3)=0 THEN 1290
1250 IUCON=2
1260 CONCP(1)=TW(3)
1270 CONCI(1)=CONCP(1)/CONCON
1280 GOTO 1430
1290 IUCON=1
1300 CONCI(1)=TW(4)
1310 GOTO 1430
1320 INPUT "DO YOU WISH TO PLOT TWA(Y/N)? <Y>",Y$
1330 IF Y$="N" OR Y$="n" THEN 1470
1340 IF Y$="999" AND TTSP=10000 THEN 560
1350 IF Y$="999" AND TTSP<>10000 THEN 710
1360 IF TW(1)=0 THEN 1410
1370 IUCON=2
1380 CONCP(1)=TW(1)
1390 CONCI(1)=CONCP(1)/CONCON
1400 GOTO 1430
1410 IUCON=1
1420 CONCI(1)=TW(2) 
1430 NNNN=1
1440 CMIN=CONCI(1)
1450 CMAX=CMIN
1460 GOTO 1920
1470 '----------------ENTER CONCENTRATION UNITS--------------------------------
1480 IF IUNCO=1 THEN 1590
1490 PRINT
1500 COLOR COL4: PRINT "1";: COLOR COL1: PRINT "=MILLIGRAMS/CU M"
1510 COLOR COL4: PRINT "2";: COLOR COL1: PRINT "=PARTS PER MILLION"
1520 PRINT
1530 COLOR COL4: INPUT "ENTER CODE NUMBER OF THE CONC. UNITS YOU WISH ",IUCON
1540 IF IUCON=999 AND TTSP=10000 THEN 560
1550 IF IUCON=999 THEN 710
1560 IF IUCON=1 OR IUCON=2 THEN 1600
1570 PRINT CHR$(7)
1580 GOTO 1530
1590 IUCON=1
1600 '----------------------ENTER CONTOURS--------------------------------------EDIT 810
1610 PRINT
1620 COLOR COL4: INPUT "ENTER NO. OF CONTOURS (MAX OF 3) ",NNNN
1630 IF NNNN=999 AND IUNCO=1 THEN 970
1640 IF NNNN=999 THEN 1490
1650 IF NNNN=1 OR NNNN=2 OR NNNN=3 THEN 1680
1660 IF EGA=1 THEN COLOR COL5
1670 PRINT "PLEASE ENTER 1,2, OR 3";: PRINT CHR$(7): GOTO 1620
1680 CMIN=100000!
1690 CMAX=0
1700 FOR M=1 TO NNNN
1710    IF IUCON=1 THEN 1760
1720    COLOR COL4: INPUT "  ENTER CONC. OF INTEREST IN PPM ",CONCP(M)
1730    IF CONCP(M)=999 THEN 1600
1740    CONCI(M)=CONCP(M)/CONCON
1750    GOTO 1780
1760    COLOR COL4: INPUT "  ENTER CONC. OF INTEREST IN MG/M3 ",CONCI(M)
1770    IF CONCI(M)=999 THEN 1600
1780    IF CONCI(M)=0 THEN PRINT CHR$(7): COLOR COL1
1790    IF CONCI(M)=0 THEN PRINT "CONC. CAN NOT BE ZERO--TRY AGAIN": GOTO 1710
1800    IF CONCI(M)<CMIN THEN CMIN=CONCI(M)
1810    IF CONCI(M)>CMAX THEN CMAX=CONCI(M)
1820 NEXT M
1830 IF NNNN=1 THEN 1920
1840 IF NNNN=3 THEN 1880
1850 CONCI(1)=CMIN
1860 CONCI(2)=CMAX
1870 GOTO 1920
1880 FOR I=1 TO 3
1890 IF CONCI(I)>CMIN AND CONCI(I)<CMAX THEN CONCI(2)=CONCI(I)
1900 NEXT I
1910 CONCI(1)=CMIN: CONCI(3)=CMAX
1920 IF NUM=8 THEN 1950
1930 IF NFLAG=1 THEN 2400
1940 '----------------------ENTER HEIGHT OF INTEREST---------------------------
1950 PRINT
1960 IF IUNIT=1 THEN 2090
1970 COLOR COL1
1980 IF ISTAT=3 THEN PRINT "PLUME CENTERLINE HEIGHT IS";INT(H*3.28);"FT"
1990 PRINT "DEFAULT HEIGHT OF INTEREST IS 6 FT"
2000 COLOR COL4: INPUT "PRESS <ENTER> TO CONTINUE OR INPUT NEW HEIGHT(FT) ",Z$
2010 IF Z$="" THEN Z$="6"
2020 Z=VAL(Z$)
2030 IF Z=999 THEN 990
2040 IF PYN=1 THEN 2060
2050 PRINT #3, "HEIGHT OF INTEREST IS";Z;"FT": GOTO 2070
2060 LPRINT "HEIGHT OF INTEREST IS";Z;"FT"
2070 Z=Z*.3048
2080 GOTO 2190
2090 COLOR COL1
2100 IF ISTAT=3 THEN PRINT "PLUME CENTERLINE HEIGHT IS";INT(H);"M" 
2110 PRINT "DEFAULT HEIGHT OF INTEREST IS 2 M"
2120 COLOR COL4: INPUT "PRESS <ENTER> TO CONTINUE OR INPUT NEW HEIGHT(M) ",Z$
2130 IF Z$="" THEN Z$="2"
2140 Z=VAL(Z$)
2150 IF Z=999 THEN 990
2160 IF PYN=1 THEN 2180
2170 PRINT #3, "HEIGHT OF INTEREST IS";Z;"M": PRINT #3," ": GOTO 2190
2180 LPRINT "HEIGHT OF INTEREST IS";Z;"M"
2190 COLOR COL1
2200 IF H>HINV AND Z>=HINV THEN 2310
2210 IF Z=<HINV AND NFLAG=1 THEN 2400
2220 IF H=<HINV THEN 2270
2230 PRINT
2240 PRINT "PLUME IS ABOVE INVERSION--HEIGHT OF INTEREST IS BELOW INVERSION--";
2250 PRINT "          MODEL ASSUMES NO POLLUTANT BELOW INVERSION"
2260 GOTO 3900
2270 IF Z=<HINV THEN 2400
2280 PRINT
2290 PRINT "LEVEL OF INTEREST IS ABOVE INVERSION-NO POLLUTANT AT THAT LEVEL"
2300 GOTO 3900
2310 PRINT
2320 PRINT "BEWARE--PLUME IS ABOVE INVERSION AND THEREFORE STABILITY AND WINDS";
2330 PRINT " MAY BE               DIFFERENT THAN INPUT VALUES"
2340 PRINT CHR$(7)
2350 FOR I=1 TO 15000
2360 NEXT I
2370 INV=HINV
2380 HINV=10000
2390 CT4=1
2400 '--------------------DETERMINE SCALE---------------------------------------
2410 M=1
2420 TTEMP=T
2430 IF T>TTSP THEN X=.06*U*T: GOTO 2580
2440 X=.5: Y=0
2450 T=TTSP
2460 ZTEMP=Z
2470 Z=H
2480 GOSUB 12220: 'PUFF
2490 IF CONC*1000<CONCI(1) THEN 2570
2500 DX=1
2510 IF X=.5 THEN DX=.5
2520 IF X>5 THEN DX=2
2530 IF X=>10 THEN DX=5
2540 X=X+DX
2550 IF X>100 THEN 2570
2560 GOTO 2480
2570 Z=ZTEMP
2580 SCALE=2*X
2590 IF SCALE>=200 THEN SCALE=199
2600 IF IUNIT=2 THEN SCALE=.5*SCALE
2610 IF SCALE<.5 THEN SCALE=.5: GOTO 2640
2620 SCALE=INT(SCALE+1)
2630 '---------------------INITIALIZE DATA--------------------------------------
2640 IF SCALE>1 THEN DX=.1 ELSE DX=.01
2650 T=TTEMP
2660 DY=10
2670 X0=.1
2680 Y0=0
2690 J=0
2700 IND=0
2710 CT=0
2720 X=X0
2730 Y=Y0
2740 CONCMX=0
2750 CONCMI=0
2760 XSMAX=0
2770 YSMAX=0
2780 FLG=0
2790 '--------------------------------------------------------------------------
2800 IF T<=TTSP THEN 2820
2810 IF SCALE<>.1 THEN X=.7*(T-TTSP)*U*.06
2820 GOSUB 12220:    'PUFF
2830 CONC=CONC*1000
2840 IF CONC>= CONCI(M) THEN 3100
2850 IF X=.02 AND CONC<CONCI(M) AND CONC<CONCMX THEN 3040
2860 IF X>.2 AND CONC<CONCI(M) AND CONC<CONCMX THEN 3000
2870 IF CONC<CONCMX THEN 2930
2880 X=X+DX
2890 FLG=0
2900 IF X>100 THEN 3040
2910 CONCMX=CONC
2920 GOTO 2820
2930 IF DX=.01 THEN 3000
2940 IF CONCI(M)<>CMIN THEN 2960
2950 SCALE=.1
2960 DX=.01
2970 DY=2
2980 X0=.01
2990 GOTO 2690
3000 IF FLG=5 THEN 3040
3010 FLG=FLG+1
3020 X=X+DX
3030 GOTO 2820
3040 XXMX=X-DX-FLG*DX
3050 GOSUB 4140:    ' NOCONC
3060 GOSUB 4550:    ' SAVEXY
3070 PRINT: INPUT "DO YOU WISH TO CHANGE ANYTHING(Y/N) <N>";YN$
3080 IF YN$="Y" OR YN$="y" THEN GOSUB 5860:    'CHANGE INPUT
3090 IF ASP=0 THEN 14320 ELSE 14050
3100 IF M>1 THEN 3150
3110 IF PYN=1 THEN 3130
3120 PRINT #3, "----------------------------------------------------": GOTO 3140
3130 LPRINT "----------------------------------------------------"
3140 GOSUB 9170:    'PLOT SETUP
3150 IF X=X0 THEN 3300
3160 IF X>100 THEN 4030
3170 J=J+1
3180 XP=X-DX
3190 IF XP<0 THEN XP=0
3200 XS(J)=XP
3210 YS(J)=Y
3220 YSM(J)=-YS(J)
3230 X=XS(J)+DX
3240 Y=YS(J)
3250 IND=0
3260 CONCMI=0
3270 GOSUB 12220      'PUFF
3280 CONC=CONC*1000
3290 IF CONC=0 AND J=0 THEN 3330
3300 IF CONC>CONCI(M) THEN 3450
3310 IF IND=0 THEN 3590
3320 IF CONC>0 THEN 3360
3330 X=X+DX
3340 Y=Y0
3350 GOTO 3270
3360 IF X>100 THEN 4030
3370 J=J+1
3380 YS(J)=Y
3390 XS(J)=X
3400 GOSUB 9820:       'PLOT ROUTINE
3410 X=XS(J)+DX
3420 Y=YS(J)
3430 IND=0
3440 GOTO 3270
3450 IF CONCMI>0 THEN 3500
3460 Y=Y+DY
3470 CONCMX=CONC
3480 IND=IND+1
3490 GOTO 3270
3500 XP=Y+DY
3510 IF X>100 THEN 4030
3520 J=J+1
3530 YS(J)=XP
3540 XS(J)=X
3550 GOSUB 9820:       'PLOT ROUTINE
3560 X=XS(J)+DX
3570 Y=YS(J)
3580 GOTO 3270
3590 Y=Y-DY
3600 IF Y<=0 THEN 3630
3610 CONCMI=CONC
3620 GOTO 3270
3630 X=X-DX
3640 Y=0
3650 IND=0
3660 GOSUB 12220:       'PUFF
3670 CONC=CONC*1000
3680 IF CONC<CONCI(M) THEN 3720
3690 CONCMX=CONC
3700 X=X+DX
3710 GOTO 3660
3720 J=J+1
3730 XS(J)=X-(CONCI(M)-CONC)/(CONCMX-CONC)*DX
3740 YS(J)=0
3750 GOSUB 9930         'PLOT ROUTINE
3760 GOSUB 4550         'SAVE CONTOURS
3770 IF PRT=1 THEN 3840
3780 IF M=1 THEN 3800
3790 IF XMX>XMAX THEN XMX=XMAX
3800 XMAX=XMX
3810 GOSUB 5070         'PRINT OUTPUT
3820 IF M>1 THEN 3840
3830 GOSUB 10480:        '90% HAZARD AREA
3840 IF M=NNNN AND PRT=1 THEN 14240
3850 IF M<NNNN THEN 3970
3860 IF NS=1 THEN 3900
3870 IF PYN=1 THEN 3890
3880 PRINT #3, "----------------------------------------------------":GOTO 3900
3890 LPRINT "----------------------------------------------------"
3900 IF EGA=1 THEN COLOR COL4
3910 LOCATE 22,5: PRINT "DO YOU WISH TO"
3920 PRINT CHR$(7)
3930 LOCATE 23,5: INPUT "CHANGE ANYTHING(Y/N)? <N>",YN$
3940 IF YN$="N" OR YN$="n" OR YN$="" THEN 14050
3950 NS=0
3960 GOSUB 5870:     'CHANGE INPUT
3970 M=M+1
3980 CC2=0
3990 CC3=0
4000 IF NS=1 THEN GOSUB 5860
4010 GOTO 2640
4020 '------------------------------------------------------------------------
4030 IF PYN=1 THEN 4070
4040 IF IUNIT=1 THEN PRINT #3,"PLUME EXTENDS BEYOND";INT(X);"KM-PLOT DISCONTINUED"
4050 IF IUNIT=2 THEN PRINT #3,"PLUME EXTENDS BEYOND";INT(X*.62137);"MI-PLOT DISCONTINUED"
4060 GOTO 4090
4070 IF IUNIT=1 THEN LPRINT "PLUME EXTENDS BEYOND";INT(X);"KM-PLOT DISCONTINUED"
4080 IF IUNIT=2 THEN LPRINT "PLUME EXTENDS BEYOND";INT(X*.62137);"MI-PLOT DISCOTINUED"
4090 IF EGA=2 THEN LOCATE 8,1  
4100 IF IUNIT=1 THEN PRINT "PLUME EXTENDS BEYOND";INT(X);"KM-PLOT DISCONTINUED":XMX=X-DX
4110 IF IUNIT=2 THEN PRINT "PLUME EXTENDS BEYOND";INT(X*.62137);"MI-PLOT DISCONTINUED":XMX=(X-DX)*.62137
4120 XMX=100
4130 PRINT CHR$(7):GOTO 3760
4140 '=======================================================================
4150 'SUBROUTINE NOCONC
4160 'This subroutine notifies the user that the concentration of interest does
4170 'not exist at the stated height.
4180 '-------------------------------------------------------------------------
4190 PRINT CHR$(7)
4200 PRINT
4210 IF EGA=1 THEN COLOR COL5
4220 XMX=0
4230 IF CONCMX>0 THEN 4280 
4240 PRINT "NO POLLUTANTS AT THIS LEVEL"
4250 IF U*T*60<10000 OR TTSP=10000 THEN 4270
4260 PRINT "    (There may be concentrations beyond 100 km)"
4270 GOTO 4460
4280 LOCATE 20,1
4290 IF EGA=2 THEN 4310
4300 PRINT "NO PLOT - ";
4310 PRINT "GIVEN CONC IS TOO HIGH."
4320 IF X<.2 THEN 4400
4330 IF IUCON=1 THEN 4370
4340 PRINT "MAX CONC IS";INT(CONCON*CONCMX*100)/100;"PPM AT X =";
4350 PRINT INT(XXMX*100)/100;"KM(";INT(XXMX*.62137*10)/10;"MI) "
4360 GOTO 4460
4370 PRINT "MAX CONC IS";INT(CONCMX*100)/100;"MG/M3 AT X =";INT(XXMX*100)/100;
4380 PRINT "KM(";INT(XXMX*.62137*10)/10;"MI) "
4390 GOTO 4460
4400 IF IUCON=1 THEN 4440
4410 PRINT "MAX CONC IS";INT(CONCON*CONCMX*100)/100;"PPM AT X =";
4420 PRINT INT(XXMX*1000);"M(";INT(XXMX*3280.8);"FT) "
4430 GOTO 4460
4440 PRINT "MAX CONC IS";INT(CONCMX*100)/100;"MG/M3 AT X =";INT(XXMX*1000);
4450 PRINT "M(";INT(XXMX*3280.8);"FT) "
4460 IF PYN=1 THEN 4500
4470 IF IUCON=2 THEN PRINT #3, CONCP(M);"PPM IS TOO HIGH"
4480 IF IUCON=1 THEN PRINT #3, CONCI(M);"MG/M3 IS TOO HIGH"
4490 GOTO 4520
4500 IF IUCON=2 THEN LPRINT CONCP(M);"PPM IS TOO HIGH"
4510 IF IUCON=1 THEN LPRINT CONCI(M);"MG/M3 IS TOO HIGH"
4520 COLOR COL4
4530 RETURN
4540 '=========================================================================
4550 'SUBROUTINE SAVEXY
4560 'This subroutine saves the X and Y positions for each contour
4570 '------------------------------------------------------------------------
4580 IF M>1 OR NFLAG=1 OR MFLAG>0 THEN 4600
4590 OPEN "O",#1,"CONCXY.DAT"
4600 PRINT #1," "
4610 PRINT #1," "
4620 IF IUCON=1 THEN PRINT #1,"CONC (mg/m3) =";CONCI(M);
4630 IF IUCON=2 THEN PRINT #1,"CONC (ppm) =";CONCP(M);
4640 IF TTSP<>10000 THEN PRINT #1,":  TIME SINCE RELEASE (min) =";T
4650 IF TTSP=10000 THEN PRINT #1,":  CONTINUOUS RELEASE"
4660 PRINT #1," "
4670 IF IUNIT=1 THEN PRINT #1,"DIST (m)   CONTOUR HALF",
4680 IF IUNIT=2 THEN PRINT #1,"DIST (ft)   CONTOUR HALF",
4690 IF IUCON=1 THEN PRINT #1,"PEAK CONC (mg/m3)"
4700 IF IUCON=2 THEN PRINT #1,"PEAK CONC (ppm)"
4710 IF IUNIT=1 THEN PRINT #1,"             WIDTH (m)"
4720 IF IUNIT=2 THEN PRINT #1,"             WIDTH (ft)"
4730 ON M GOTO 4740,4880,4970
4740 FOR I=1 TO J
4750    XS1(I)=XS(I)
4760    YS1(I)=YS(I)
4770    IF IUNIT=1 THEN PRINT #1,XS1(I)*1000,YS1(I),
4780    IF IUNIT=2 THEN PRINT #1,XS1(I)*3280.8,YS1(I)*3.2808,
4790    X=XS(I)
4800    Y=0
4810    GOSUB 12220
4820    IF IUCON=1 THEN PRINT #1,CONC*1000
4830    IF IUCON=2 THEN PRINT #1,CONC*1000*CONCON
4840 NEXT I
4850 J1=J
4860 IMIN1=IMIN
4870 GOTO 5050
4880 FOR I=1 TO J
4890    XS2(I)=XS(I)
4900    YS2(I)=YS(I)
4910    IF IUNIT=1 THEN PRINT #1,XS2(I)*1000,YS2(I)
4920    IF IUNIT=2 THEN PRINT #1,XS2(I)*3280.8,YS2(I)*3.2808
4930 NEXT I
4940 J2=J
4950 IMIN2=IMIN
4960 GOTO 5050
4970 FOR I=1 TO J
4980    XS3(I)=XS(I)
4990    YS3(I)=YS(I)
5000    IF IUNIT=1 THEN PRINT #1,XS3(I)*1000,YS3(I)
5010    IF IUNIT=2 THEN PRINT #1,XS3(I)*3280.8,YS3(I)*3.2808
5020 NEXT I
5030 J3=J
5040 IMIN3=IMIN
5050 RETURN
5060 '=======================================================================
5070 'SUBROUTINE PRINT OUTPUT
5080 'This subroutine prints the hazard distances to screen and to either
5090 'printer or file (AFT.DAT)
5100 '-----------------------------------------------------------------------
5110 IF EGA=0 THEN 5130
5120 IF PRT=0 THEN COLOR COL1 ELSE COLOR COL4
5130 IF M>1 THEN 5180
5140 IF EGA=2 THEN YY=9: XX=2: GOTO 5170
5150 YY=20-NNNN
5160 XX=57
5170 LOCATE YY,XX: PRINT "  CONC     MAX DIST"
5180 CONCP(M)=CONCI(M)*CONCON
5190 IF CONCP(M) >1 THEN CONCP(M) = INT((CONCP(M)+.05)*10)/10
5200 IF TTSP=10000 THEN 5260
5210 IF NS=1 THEN 5260
5220 IF PYN=1 THEN 5250
5230 PRINT #3,"AT";T;"MIN, ";
5240 GOTO 5260
5250 LPRINT "AT";T;"MIN, ";
5260 IF EGA=2 THEN XP=2
5270 IF IUNIT=2 THEN 5570
5280 IF IUCON=1 THEN 5430
5290 IF EGA=2 THEN 5320
5300 XP=59
5310 IF CONCP(M)>=10 OR CONCP(M)<1 THEN XP=58
5320 LOCATE YY+M,XP
5330 IF XMX<1 THEN PRINT CONCP(M);"PPM   ";INT(1000*XMX);"M": GOTO 5360
5340 IF XMX=>10 THEN PRINT CONCP(M);"PPM   ";INT(10*XMX)/10;"KM": GOTO 5360
5350 PRINT CONCP(M);"PPM   ";INT(100*XMX)/100;"KM"
5360 IF NS=1 THEN 5850
5370 IF PYN=1 THEN 5400
5380 IF XMX<1 THEN PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(1000*XMX);"M" :GOTO 5850
5390 PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(100*XMX)/100;"KM" :GOTO 5850 
5400 IF XMX<1 THEN LPRINT "THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(1000*XMX);"M":GOTO 5850
5410 LPRINT "THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(100*XMX)/100;"KM"
5420 GOTO 5850
5430 IF EGA=2 THEN 5460
5440 XP=57
5450 IF CONCI(M)>=10 THEN XP=56
5460 LOCATE YY+M,XP
5470 IF XMX<1 THEN PRINT CONCI(M);"MG/M3  ";INT(1000*XMX);"M":GOTO 5500
5480 IF XMX=>10 THEN PRINT CONCI(M);"MG/M3  ";INT(10*XMX)/10;"KM":GOTO 5500
5490 PRINT CONCI(M);"MG/M3  ";INT(100*XMX)/100;"KM":GOTO 5500
5500 IF NS=1 THEN 5850
5510 IF PYN=1 THEN 5540
5520 IF XMX<1 THEN PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(1000*XMX);"M" :GOTO 5850
5530 PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(100*XMX)/100;"KM" :GOTO 5850
5540 IF XMX<1 THEN LPRINT "THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(1000*XMX);"M":GOTO 5850
5550 LPRINT "THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(100*XMX)/100;"KM"
5560 GOTO 5850
5570 IF IUCON=1 THEN 5720
5580 IF EGA=2 THEN 5620
5590 XP=59
5600 IF CONCP(M)>=10 OR CONCP(M)<1 THEN XP=58
5610 LOCATE YY+M,XP
5620 IF XMX<1 THEN PRINT CONCP(M);"PPM   ";INT(XMX*5280);"FT":GOTO 5650
5630 IF XMX=>10 THEN PRINT CONCP(M);"PPM   ";INT(10*XMX)/10;"MI":GOTO 5650
5640 PRINT CONCP(M);"PPM   ";INT(100*XMX)/100;"MI"
5650 IF NS=1 THEN 5850
5660 IF PYN=1 THEN 5690
5670 IF XMX<1 THEN PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(XMX*5280);"FT" :GOTO 5850
5680 PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(100*XMX)/100;"MI" :GOTO 5850
5690 IF XMX<1 THEN LPRINT "THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(XMX*5280);"FT":GOTO 5850
5700 LPRINT "THE MAXIMUM DISTANCE FOR";CONCP(M);"PPM IS";INT(100*XMX)/100;"MI"
5710 GOTO 5850
5720 IF EGA=2 THEN 5760
5730 XP=57
5740 IF CONCI(M)>=10 THEN XP=56
5750 LOCATE YY+M,XP
5760 IF XMX<1 THEN PRINT CONCI(M);"MG/M3  ";INT(5280*XMX);"FT":GOTO 5790
5770 IF XMX=>10 THEN PRINT CONCI(M);"MG/M3  ";INT(10*XMX)/10;"MI":GOTO 5790
5780 PRINT CONCI(M);"MG/M3  ";INT(100*XMX)/100;"MI"
5790 IF NS=1 THEN 5850
5800 IF PYN=1 THEN 5830
5810 IF XMX<1 THEN PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(5280*XMX);"FT" :GOTO 5850
5820 PRINT #3,"THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(100*XMX)/100;"MI" :GOTO 5850
5830 IF XMX<1 THEN LPRINT "THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(5280*XMX);"FT":GOTO 5850
5840 LPRINT "THE MAXIMUM DISTANCE FOR";CONCI(M);"MG/M3 IS";INT(100*XMX)/100;"MI"
5850 RETURN
5860 '=========================================================================
5870 'SUBROUTINE CHANGE INPUT 
5880 'This subroutine allows you to change input data when running the
5890 'contour plot option
5900 '-------------------------------------------------------------------------
5910 IF NS=1 THEN 6280
5920 IF EGA=0 THEN SCREEN 0
5930 IF SCR=1 THEN COLOR 15,1
5940 CLS
5950 NFLAG=1
5960 CC1=0
5970 CC2=0
5980 CC3=0
5990 PRT=0
6000 NS=0
6010 C1=0
6020 P1=0: P2=0: P3=0: P4=0
6030 IF CT4=1 THEN HINV=INV
6040 COLOR COL4
6050 PRINT "  1  ";:  COLOR COL1: PRINT "TIME AND METEOR. CONDITIONS "
6060 COLOR COL4: PRINT "  2  ";: COLOR COL1: PRINT "SOURCE CONDITIONS"
6070 COLOR COL4: PRINT "  3  ";: COLOR COL1: PRINT "CONCENTRATION AVERAGING TIME"
6080 COLOR COL4: PRINT "  4  ";: COLOR COL1: PRINT "ELAPSED TIME SINCE START OF SPILL"
6090 COLOR COL4: PRINT "  5  ";: COLOR COL1: PRINT "CONCENTRATION CONTOURS"
6100 COLOR COL4: PRINT "  6  ";: COLOR COL1: PRINT "HEIGHT OF INTEREST"
6110 COLOR COL4: PRINT "  7  ";: COLOR COL1: PRINT "SCALE"
6120 COLOR COL4: PRINT "  8  ";: COLOR COL1: PRINT "OPTION"
6130 COLOR COL4: PRINT "  9  ";: COLOR COL1: PRINT "NO CHANGE"
6140 PRINT
6150 IF PYN=1 THEN LPRINT:LPRINT
6160 COLOR COL4: INPUT "ENTER THE CHANGE CODE NUMBER ",NUM
6170 IF NUM>9 THEN 6190
6180 ON NUM GOTO 6530,6550,6200,710,990,1950,6220,560,6260
6190 PRINT CHR$(7): CLS: GOTO 6040
6200 IF IFLAG=1 THEN STB=6
6210 GOTO 220
6220 IF EGA<>2 THEN 6250 
6230 COLOR COL1: PRINT: PRINT "DOES NOT APPLY, ENTER ANOTHER NUMBER."
6240 GOTO 6140
6250 PRINT: INPUT "NEW SCALE (distance to outer circle of plot)? ",SCALE
6260 GOSUB 9170      'PLOT SETUP
6270 M=1: NS=1
6280 CT=0
6290 ON M GOTO 6300,6370,6450
6300 FOR I=1 TO J1
6310    XS(I)=XS1(I)
6320    YS(I)=YS1(I)
6330    IF I>=IMIN1 THEN GOSUB 9950:     'PLOT ROUTINE
6340    IF IUNIT=1 THEN XMX=XS(I) ELSE XMX=XS(I)*.62137
6350 NEXT I
6360 GOTO 3810
6370 FOR I=1 TO J2
6380    XS(I)=XS2(I)
6390    YS(I)=YS2(I)
6400    IF I>=IMIN2 THEN GOSUB 9950:     'PLOT ROUTINE
6410    IF IUNIT=1 THEN XMX=XS(I) ELSE XMX=XS(I)*.62137
6420 NEXT I
6430 IF J2=0 THEN XMX=0
6440 GOTO 3810
6450 FOR I=1 TO J3
6460    XS(I)=XS3(I)
6470    YS(I)=YS3(I)
6480    IF I>=IMIN3 THEN GOSUB 9950:     'PLOT ROUTINE
6490    IF IUNIT=1 THEN XMX=XS(I) ELSE XMX=XS(I)*.62137
6500 NEXT I
6510 IF J3=0 THEN XMX=0
6520 GOTO 3810
6530 MFLAG=1
6540 GOTO 6570
6550 MFLAG=2
6560 CLS
6570 IF PYN=1 THEN 6590
6580 PRINT #3," " : GOTO 6600
6590 LPRINT
6600 IF NUM=1 THEN CHAIN "DSP1"
6610 IF NUM=2 AND ISTAT<3 THEN CHAIN "DSP2"
6620 IF NUM=2 AND ISTAT=3 THEN CHAIN "DSPHP"
6630 RETURN
6640 '=========================================================================
6650 'SUBROUTINE CONPOINT
6660 'This subroutine calculates the concentration at a given point and time
6670 '-------------------------------------------------------------------------
6680 IF DDD$="T" OR DDD$="t" THEN 7060
6690 COLOR COL4
6700 IF IUNIT=1 THEN 6900
6710 INPUT "HEIGHT ABOVE GROUND(FT)? ",Z
6720 IF Z=999 THEN 820
6730 IF PYN=1 THEN 6750
6740 PRINT #3,"HEIGHT ABOVE GROUND IS";Z;"FT": GOTO 6760
6750 LPRINT "HEIGHT ABOVE GROUND IS";Z;"FT"
6760 Z=Z*.3048
6770 INPUT "DOWNWIND DISTANCE X(FT)? ",X
6780 IF X=999 THEN 6710
6790 IF PYN=1 THEN 6810
6800 PRINT #3,"DOWNWIND DISTANCE IS";X;"FT": GOTO 6820
6810 LPRINT "DOWNWIND DISTANCE IS";X;"FT"
6820 X=X*.0003048
6830 INPUT "CROSSWIND DISTANCE Y(FT)? ",Y
6840 IF Y=999 THEN 6770
6850 IF PYN=1 THEN 6870
6860 PRINT #3,"CROSSWIND DISTANCE IS";Y;"FT": GOTO 6880
6870 LPRINT "CROSSWIND DISTANCE IS";Y;"FT"
6880 Y=Y*.3048
6890 GOTO 7060
6900 INPUT "HEIGHT ABOVE GROUND(M) ",Z
6910 IF Z=999 THEN 820
6920 IF PYN=1 THEN 6940
6930 PRINT #3,"HEIGHT ABOVE GROUND IS";Z;"M": GOTO 6950
6940 LPRINT "HEIGHT ABOVE GROUND IS";Z;"M"
6950 INPUT "DOWNWIND DISTANCE X(M)? ",X
6960 IF X=999 THEN 6900
6970 IF PYN=1 THEN 6990
6980 PRINT #3,"DOWNWIND DISTANCE IS";X;"M": GOTO 7000
6990 LPRINT "DOWNWIND DISTANCE IS";X;"M"
7000 X=X*.001
7010 INPUT "CROSSWIND DISTANCE Y(M)? ",Y
7020 IF Y=999 THEN 6950
7030 IF PYN=1 THEN 7050
7040 PRINT #3, "CROSSWIND DISTANCE IS";Y;"M": GOTO 7060
7050 LPRINT "CROSSWIND DISTANCE IS";Y;"M"
7060 IF Z<=HINV AND H<=HINV THEN 7130
7070 IF Z=>HINV AND H>HINV THEN 7130
7080 CLS: COLOR COL1: PRINT
7090 PRINT "MODEL ASSUMES PLUME DOES NOT PENETRATE INVERSION."
7100 CONC=0
7110 CONCEN=0
7120 GOTO 7380
7130 GOSUB 12220      'PUFF
7140 CONC=CONC*1000
7150 CONCEN=CONC*CONCON
7160 IF CONC>=1 THEN 7220
7170 IF CONC>=.1 THEN 7200
7180 CONC=INT(1000*CONC)/1000
7190 GOTO 7230
7200 CONC=INT(100*CONC)/100
7210 GOTO 7230
7220 CONC=INT(10*CONC)/10
7230 IF CONCEN>=1 THEN 7290
7240 IF CONCEN>=.1 THEN 7270
7250 CONCEN=INT(1000*CONCEN)/1000
7260 GOTO 7300
7270 CONCEN=INT(100*CONCEN)/100
7280 GOTO 7300
7290 CONCEN=INT(10*CONCEN)/10
7300 CLS
7310 COLOR COL1: PRINT
7320 IF PYN=1 THEN 7340
7330 PRINT #3, "-------------------------------------------------": GOTO 7350
7340 LPRINT "-------------------------------------------------"
7350 IF IUNIT=1 THEN PRINT "AT X =";X*1000;"M,  Y =";Y;"M,  Z =";Z;"M";
7360 IF IUNIT=2 THEN PRINT "AT X =";X/.0003048;"FT,  Y =";Y/.3048;"FT,  Z =";Z/.3048;"FT";
7370 IF TTSP<10000 THEN PRINT ", and T =";T;"MIN" ELSE PRINT
7380 IF IUNCO=1 THEN 7440
7390 PRINT "THE CONCENTRATION IS";CONCEN;"PPM(";CONC;"MG M-3)"
7400 IF PYN=1 THEN 7420
7410 PRINT #3,"THE CONCENTRATION IS";CONCEN;"PPM(";CONC;"MG M-3)": GOTO 7480
7420 LPRINT "THE CONCENTRATION IS";CONCEN;"PPM(";CONC;"MG M-3)"
7430 GOTO 7480
7440 IF PYN=1 THEN 7460
7450 PRINT #3,"THE CONCENTRATION IS";CONC;"MG M-3" :PRINT #3," ": GOTO 7470
7460 LPRINT "THE CONCENTRATION IS";CONC;"MG M-3":LPRINT
7470 PRINT "THE CONCENTRATION IS";CONC;"MG M-3"
7480 IF PYN=1 THEN 7500
7490 PRINT #3, "-------------------------------------------------": GOTO 7510
7500 LPRINT "-------------------------------------------------"
7510 XXX=0
7520 CC1=0
7530 PRINT STRING$(79,"-")
7540 LOCATE 16,1: COLOR COL4: PRINT "WOULD YOU LIKE TO"
7550 PRINT "         CHANGE TIME? (T) (instant. or finite cont. release only)"
7560 PRINT "         CHANGE LOCATION? (L)"
7570 PRINT "         CHANGE LOCATION AND TIME? (LT) (instant. or finite cont. release only)"
7580 PRINT "         CHOOSE ANOTHER OPTION? (O)"
7590 PRINT "         RUN ANOTHER CASE? (C)"
7600 PRINT "         QUIT? (Q)"
7610 COLOR COL4: INPUT "ENTER CHOICE ",DDD$
7620 CLS
7630 PRINT
7640 IF PYN=1 THEN LPRINT
7650 IF DDD$="T" OR DDD$="t" THEN 710
7660 IF DDD$="L" OR DDD$="l" THEN 6690
7670 IF DDD$="LT" OR DDD$="lt" THEN 820
7680 IF DDD$="O" OR DDD$="o" THEN 570
7690 IF DDD$="C" OR DDD$="c" THEN 14390
7700 IF DDD$="Q" OR DDD$="q" THEN 14480
7710 PRINT CHR$(7): GOTO 7540
7720 RETURN
7730 '=========================================================================
7740 'SUBROUTINE MAXCONC
7750 'This subroutine calculates the maximum concentration at a given height
7760 'and time
7770 '-------------------------------------------------------------------------
7780 IF DDD$="T" OR DDD$="t" THEN 7980
7790 COLOR COL4
7800 IF IUNIT=1 THEN 7880
7810 INPUT "HEIGHT ABOVE GROUND(FT)? ",Z
7820 IF Z=999 THEN 820
7830 IF PYN=1 THEN 7850
7840 PRINT #3,"HEIGHT ABOVE GROUND IS";Z;"FT" :GOTO 7860
7850 LPRINT "HEIGHT ABOVE GROUND IS";Z;"FT"
7860 Z=Z*.3048
7870 GOTO 7930
7880 INPUT "HEIGHT ABOVE GROUND(M) ",Z
7890 IF Z=999 THEN 820
7900 IF PYN=1 THEN 7920
7910 PRINT #3,"HEIGHT ABOVE GROUND IS";Z;"M" :GOTO 7930
7920 LPRINT "HEIGHT ABOVE GROUND IS";Z;"M"
7930 IF Z<=HINV AND H<=HINV THEN 7980
7940 IF Z=>HINV AND H>HINV THEN 7980
7950 COLOR COL1: PRINT
7960 PRINT "MODEL ASSUMES PLUME DOES NOT PENETRATE INVERSION."
7970 GOTO 8910
7980 COLOR COL1
7990 IF T=<TTSP THEN 8020
8000 CLS
8010 LOCATE 12,34: PRINT "PLEASE STANDBY "
8020 PRINT
8030 XSMX=1.2*U*T*.06
8040 IF PYN=1 THEN 8060
8050 PRINT #3, "-------------------------------------------------":GOTO 8070
8060 LPRINT "-------------------------------------------------"
8070 Y=0
8080 IF T>TTSP THEN X=U*(T-TTSP)*.06 ELSE X=.03
8090 GOSUB 12220        'PUFF
8100 CONC=CONC*1000
8110 CONCMX=CONC
8120 IF Z=H AND T<=TTSP THEN 8350
8130 DX=.1
8140 XMX=X
8150 X=X+DX
8160 GOSUB 12220        'PUFF
8170 CONC=CONC*1000
8180 IF X>XSMX THEN 8890
8190 IF CONC<CONCMX THEN 8230
8200 CONCMX=CONC
8210 XMX=X
8220 GOTO 8150
8230 X=XMX+DX
8240 XMINO=XMX-DX
8250 DX=.01
8260 X=X-DX
8270 IF X<.03 THEN 8350
8280 IF X<XMINO THEN 8590
8290 GOSUB 12220          'PUFF
8300 CONC=CONC*1000
8310 IF CONC<CONCMX THEN 8260
8320 CONCMX=CONC
8330 XMX=X
8340 GOTO 8260
8350 CLS
8360 IF T=10000 THEN PRINT "STEADY STATE": GOTO 8380
8370 PRINT "AT TIME =";T;"MIN"
8380 IF IUNIT=1 THEN PRINT "HEIGHT =";Z;"M"
8390 IF IUNIT=2 THEN PRINT "HEIGHT =";Z/.3048;"FT"
8400 PRINT
8410 PRINT "THE MAXIMUM CONCENTRATION IS WITHIN 30 M (100 FT) OF THE SOURCE"
8420 IF PYN=1 THEN 8440
8430 PRINT #3,"THE MAXIMUM CONCENTRATION IS WITHIN 30 M(100 FT) OF THE SOURCE" :GOTO 8450
8440 LPRINT "THE MAXIMUM CONCENTRATION IS WITHIN 30 M (100 FT) OF THE SOURCE"
8450 CONCEN=CONCMX*CONCON
8460 CONCMX=INT(100*CONCMX)/100
8470 CONCEN=INT(100*CONCEN)/100
8480 IF IUNCO=1 THEN 8540
8490 PRINT "AT 30M THE CONCENTRATION IS";CONCEN;"PPM (";CONCMX;"MG M-3)"
8500 IF PYN=1 THEN 8520
8510 PRINT #3,"AT 30M THE CONCENTRATION IS";CONCEN;"PPM (";CONCMX;"MG M-3)" :GOTO 8950
8520 LPRINT "AT 30M THE CONCENTRATION IS";CONCEN;"PPM (";CONCMX;"MG M-3)"
8530 GOTO 8950
8540 COLOR COL1:PRINT "AT 30 M THE CONCENTRATION IS";CONCMX;"MG M-3"
8550 IF PYN=1 THEN 8570
8560 PRINT #3, "AT 30 M THE CONCENTRATION IS";CONCMX;"MG M-3" :GOTO 8950
8570 LPRINT "AT 30 M THE CONCENTRATION IS";CONCMX;"MG M-3"
8580 GOTO 8950
8590 X=1000*XMX
8600 XENG=X/.3048
8610 CONCEN=CONCMX*CONCON
8620 IF CONCEN<.1 THEN 8640
8630 CONCEN=INT(100*CONCEN)/100
8640 IF CONCMX<.1 THEN 8660
8650 CONCMX=INT(100*CONCMX)/100
8660 CLS
8670 IF T=10000 THEN PRINT "STEADY STATE": GOTO 8690
8680 PRINT "AT TIME =";T;"MIN"
8690 IF IUNIT=1 THEN PRINT "HEIGHT =";Z;"M"
8700 IF IUNIT=2 THEN PRINT "HEIGHT =";Z/.3048;"FT"
8710 PRINT
8720 IF IUNCO=1 THEN 8810
8730 PRINT "THE MAXIMUM CONCENTRATION IS";CONCEN;"PPM(";CONCMX;"MG M-3)"
8740 PRINT "IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)"
8750 IF PYN=1 THEN 8780
8760 PRINT #3,"THE MAXIMUM CONCENTRATION IS";CONCEN;"PPM(";CONCMX;"MG M-3)" 
8770 PRINT #3,"IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)" :GOTO 8950
8780 LPRINT "THE MAXIMUM CONCENTRATION IS";CONCEN;"PPM(";CONCMX;"MG M-3)"
8790 LPRINT "IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)"
8800 GOTO 8950
8810 PRINT "THE MAXIMUM CONCENTRATION IS";CONCMX;"MG M-3"
8820 PRINT "IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)"
8830 IF PYN=1 THEN 8860
8840 PRINT #3, "THE MAXIMUM CONCENTRATION IS";CONCMX;"MG M-3"
8850 PRINT #3,"IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)" :GOTO 8950
8860 LPRINT "THE MAXIMUM CONCENTRATION IS";CONCMX;"MG M-3"
8870 LPRINT "IT OCCURS AT X =";INT(X);"M(";INT(XENG);"FT)"
8880 GOTO 8950
8890 CLS
8900 PRINT CHR$(7)
8910 PRINT "CONCENTRATIONS AT THIS HEIGHT ARE NEGLIGIBLE"
8920 IF PYN=1 THEN 8940
8930 PRINT #3,"CONCENTRATIONS AT THIS HEIGHT ARE NEGLIGIBLE" :PRINT #3," " :GOTO 8950
8940 LPRINT "CONCENTRATIONS AT THIS HEIGHT ARE NEGLIGIBLE" :LPRINT
8950 PRINT STRING$(79,"-")
8960 LOCATE 16,1: COLOR COL4: PRINT "WOULD YOU LIKE TO"
8970 PRINT "            CHANGE TIME? (T) (instant. or finite cont. release only)"
8980 PRINT "            CHANGE HEIGHT? (H)"
8990 PRINT "            CHOOSE ANOTHER OPTION? (O)"
9000 PRINT "            RUN ANOTHER CASE? (C)"
9010 PRINT "            QUIT? (Q)"
9020 COLOR COL4: INPUT "ENTER CHOICE ",DDD$
9030 CLS
9040 PRINT
9050 IF PYN=1 THEN LPRINT
9060 IF DDD$="T" OR DDD$="t" THEN 710
9070 IF DDD$="H" OR DDD$="h" THEN 7790
9080 IF DDD$="O" OR DDD$="o" THEN 570
9090 IF DDD$="C" OR DDD$="c" THEN 14390
9100 IF DDD$="Q" OR DDD$="q" THEN 14480
9110 PRINT CHR$(7): GOTO 8960
9120 RETURN
9130 '=========================================================================
9140 'SUBROUTINE PLOT SETUP
9150 'This subroutine draws the map for the plume plot.
9160 '-------------------------------------------------------------------------
9170 CLS
9180 IF EGA=2 THEN KY=1
9190 IF EGA=1 THEN SCREEN 9: KY=1
9200 IF EGA=0 THEN SCREEN 2: KY=.57
9210 IF EGA=1 AND SCR=1 AND PRT=0 THEN COLOR 15,1
9220 JJ=316
9230 KK=160*KY
9240 RRAD=166
9250 ASP=.45
9260 IF EGA=2 THEN ASP=1
9270 IF EGA=1 THEN ASP=.72
9280 IF PRT=1 THEN ASP= .45
9290 IF EGA=2 THEN 9680
9300 IF EGA=1 THEN COLOR COL4
9310 CIRCLE(JJ,KK),83,,,,ASP
9320 CIRCLE(JJ,KK),166,,,,ASP
9330 '---------------------TICK MARKS------------------------------
9340 FOR THETA=0 TO 350 STEP 10
9350     THETAR=THETA*RAD
9360     X1=(RRAD-5)*COS(THETAR)+JJ
9370     Y1=((RRAD-5)*SIN(THETAR))*ASP+KK
9380     X2=(RRAD+5)*COS(THETAR)+JJ
9390     Y2=((RRAD+5)*SIN(THETAR))*ASP+KK
9400     LINE(X1,Y1)-(X2,Y2)
9410 NEXT THETA
9420 IF RRAD=166 THEN RRAD=RRAD/2:GOTO 9340
9430 IF PRT=1 AND EGA=1 THEN 9580
9440 'SETUP FOR SCREEN PLOT
9450 LINE(141,KK)-(491,KK)
9460 IF EGA=1 THEN COLOR COL1
9470 IF IUNIT=1 THEN LOCATE 6,23: PRINT SCALE;"km":LOCATE 9,31:PRINT SCALE/2;"km"
9480 IF IUNIT=2 THEN LOCATE 6,23: PRINT SCALE;"mi":LOCATE 9,31:PRINT SCALE/2;"mi"
9490 IF EGA=1 THEN LINE(JJ,30)-(JJ,300): GOTO 9510
9500 LINE(JJ,16)-(JJ,171)
9510 LOCATE 2,40: PRINT "N"
9520 LOCATE 22,40: PRINT "S"
9530 LINE(141,KK)-(491,KK)
9540 LOCATE 12,17: PRINT "W"
9550 LOCATE 12,63: PRINT "E"
9560 IF PRT=1 THEN 9730
9570 GOTO 9680
9580 'SETUP FOR PRINTER PLOT
9590 IF IUNIT=1 THEN LOCATE 8,22:PRINT SCALE;"km":LOCATE 10,31:PRINT SCALE/2;"km"
9600 IF IUNIT=2 THEN LOCATE 8,22:PRINT SCALE;"mi":LOCATE 10,31:PRINT SCALE/2;"mi"
9610 LINE(JJ,56)-(JJ,264)
9620 LOCATE 5,40: PRINT "N"
9630 LOCATE 19,40: PRINT "S"
9640 LINE(130,KK)-(500,KK)
9650 LOCATE 12,17: PRINT "W"
9660 LOCATE 12,63: PRINT "E"
9670 GOTO 9730
9680 LOCATE 2,4: PRINT CHM$
9690 PRINT: PRINT "   ";SN$
9700 PRINT "   DATE: ";DTE$
9710 PRINT "   TIME: ";ZT$;" LST"
9720 IF EGA=2 THEN LOCATE 9,2: PRINT "PLEASE WAIT"
9730 ANGMAT=450-(WD+180+360*(WD+180>360))
9740 IF ANGMAT>360 THEN ANGMAT=ANGMAT-360
9750 ANGMAT=ANGMAT*PI/180
9760 CSA=COS(ANGMAT)
9770 SNA=SIN(ANGMAT)
9780 IF IUNIT=1 THEN F=6.1*SCALE
9790 IF IUNIT=2 THEN F=32.21*.3048*SCALE
9800 RETURN
9810 '=========================================================================
9820 'SUBROUTINE PLOT 
9830 'This subroutine plots the concentration contours 
9840 '--------------------------------------------------------------------------
9850 ' ADJUST DX
9860 IF CC3=0 THEN 9940
9870 FAK=1+5*(YS(J)-YS(J-1))/YS(J-1)
9880 DX=DX*FAK
9890 IF DX<.1 THEN DX=.1
9900 IF X<.1 THEN DX=.01
9910 DXB=.1*(1-(J>10)-(J>20)*2)
9920 IF DX>DXB THEN DX=DXB
9930 '
9940 I=J
9950 'IF EGA=1 AND PRT=0 THEN COLOR COL5
9960 XS(I)=XS(I)*1000
9970 IF CC3>0 THEN 10030
9980 IMIN=I
9990 IF I=1 THEN XS(I-1)=XS(I)/1000
10000 PPX1=JJ+1000*XS(I-1)*CSA/F
10010 PPY1=KK-1000*XS(I-1)*SNA/F*ASP
10020 PPX2=PPX1:PPY2=PPY1
10030 XHELP=XS(I)*CSA-YS(I)*SNA
10040 YHELP=XS(I)*SNA+YS(I)*CSA
10050 YSM(I)=-YS(I)
10060 XHELPM=XS(I)*CSA-YSM(I)*SNA
10070 YHELPM=XS(I)*SNA+YSM(I)*CSA
10080 IF YS(I)<YSMAX THEN 10110
10090 YSMAX=3*YS(I)
10100 XSMAX=XS(I)
10110 PX1=JJ+XHELP/F
10120 PY1=KK-YHELP/F*ASP
10130 PY2=KK-YHELPM/F*ASP
10140 PX2=JJ+XHELPM/F
10150 IF I>1 THEN 10280
10160 XWID=-WWIDTH/2*SNA:YWID=WWIDTH/2*CSA
10170 XWIDM=WWIDTH/2*SNA:YWIDM=-WWIDTH/2*CSA
10180 WX1=JJ+XWID/F
10190 WY1=KK-YWID/F*ASP
10200 WX2=JJ+XWIDM/F
10210 WY2=KK-YWIDM/F*ASP
10220 IF EGA=2 THEN 10270
10230 IF EGA=0 THEN 10250
10240 IF PRT=0 THEN COLOR COL5 ELSE COLOR COL4
10250 LINE(WX1,WY1)-(PX1,PY1)
10260 LINE(WX2,WY2)-(PX2,PY2)
10270 GOTO 10400
10280 IF EGA=2 THEN 10330
10290 IF EGA=0 THEN 10310
10300 IF PRT=0 THEN COLOR COL5 ELSE COLOR COL4
10310 LINE (PPX1,PPY1)-(PX1,PY1)
10320 LINE (PPX2,PPY2)-(PX2,PY2)
10330 IF YS(I)>0 THEN 10400
10340 XMX=XS(I)
10350 IF CONCI(M)<>CMIN THEN 10360
10360 IF IUNIT=1 THEN 10390
10370 XMX=XS(I)/1609
10380 GOTO 10400
10390 XMX=XMX/1000
10400 XS(I)=XS(I)/1000
10410 CC3=CC3+1
10420 PPX1=PX1
10430 PPX2=PX2
10440 PPY1=PY1
10450 PPY2=PY2
10460 RETURN
10470 '=========================================================================
10480 'SUBROUTINE HAZARD90
10490 '  This subroutine calculates the width and length of the 90 % hazard area
10500 '-------------------------------------------------------------------------
10510 IF NS=1 AND TTSP=10000 THEN 11180
10520 IF NS=1 THEN 11160
10530 'COMPUTE TOXIC CORRIDOR WIDTH(SAN)
10540 IF UU>1.8 THEN 10570
10550 SAN=360
10560 GOTO 10700
10570 IF OPTN=2 THEN 10640
10580 IF STB>=3.5 THEN 10610
10590 SAN=(165-30*STB)
10600 GOTO 10700
10610 SAN=90
10620 IF UU>5.15 THEN SAN=45
10630 GOTO 10700
10640 TSP=TTSP
10650 IF TTSP>60 THEN TSP=60
10660 SIGX=SIGTH*(TSP/WAT)^.2
10670 SAN=6*SIGX
10680 IF SAN<30 THEN SAN=30
10690 IF SAN>180 THEN SAN=180.5
10700 SAN=SAN*RAD
10710 '-------------------------
10720 IF TTSP=10000 THEN 11180
10730 'DETERMINE 90% HAZARD DISTANCE FOR INSTANT. AND FINITE CONT. RELEASES
10740 TTEMP=T
10750 X2=0
10760 Y=0
10770 CON=0
10780 IF TTSP>.25 THEN 10870 
10790 '-----------INSTANTANEOUS RELEASE------------
10800 X=.06*U*T
10810 CON=CONC
10820 GOSUB 12220:    'PUFF
10830 IF CONC*1000>CMIN THEN T=T+1: GOTO 10800
10840 IF CONC*1000=<CMIN AND CON*1000>CMIN THEN T=T-1
10850 GOTO 11120
10860 '----------FINITE CONTINUOUS RELEASE----------------
10870 LOCATE 22,5: PRINT "PLEASE WAIT"
10880 IF SCALE>.1 THEN X=.1 ELSE X=.01
10890 T=TTSP
10900 IF T<90 THEN CFMAX=5: GOTO 10940
10910 IF T<150 THEN CFMAX=4: GOTO 10940
10920 IF T<210 THEN CFMAX=3: GOTO 10940
10930 CFMAX=2 
10940 IF T<1 THEN T=1
10950 DELT=1
10960 GOTO 11050
10970 CON=0
10980 T=T+DELT
10990 GOTO 11060
11000 DX=.02*X
11010 IF DX<.01 THEN DX=.01
11020 IF DX>.1 THEN DX=.1
11030 X=X+DX
11040 CON=CONC
11050 CFLAG=0
11060 GOSUB 12220:   'PUFF
11070 IF CONC*1000>CMIN THEN 11000
11080 IF CONC*1000=<CMIN AND CON*1000>CMIN THEN 10970 
11090 IF CONC*1000<CMIN AND T=TTSP THEN 11000
11100 CFLAG=CFLAG+1
11110 IF CFLAG<CFMAX THEN 10970
11120 TMAX=T-DELT*CFLAG
11130 T=TTEMP
11140 XMM=X
11150 IF XMM<XMX THEN XMM=XMX
11160 XM=2.1*XMM*1000/F
11170 GOTO 11220
11180 XM=2.1*XMX*1000/F
11190 IF IUNIT=2 THEN XM=XM*1.609
11200 '-------DRAW 90% CONTOUR--------------
11210 IF EGA=0 THEN 11230
11220 IF PRT=0 THEN COLOR COL5 ELSE COLOR COL4
11230 IF SAN<6.28 THEN 11270
11240 A1=0
11250 A2=2*PI
11260 GOTO 11660
11270 XMA=F*XM*COS(SAN/2)
11280 YT=XMA*TAN(SAN/2)
11290 YTM=-YT
11300 XHELP=XMA*CSA-YT*SNA
11310 YHELP=XMA*SNA+YT*CSA
11320 XHELPM=XMA*CSA-YTM*SNA
11330 YHELPM=XMA*SNA+YTM*CSA
11340 PX91=JJ+XHELP/F
11350 PY91=KK-YHELP/F*ASP
11360 PY92=KK-YHELPM/F*ASP
11370 PX92=JJ+XHELPM/F
11380 XHELP=XSMAX*CSA-YSMAX*SNA
11390 YHELP=XSMAX*SNA+YSMAX*CSA
11400 XHELPM=XSMAX*CSA+YSMAX*SNA
11410 YHELPM=XSMAX*SNA-YSMAX*CSA
11420 QX91=JJ+XHELP/F
11430 QY91=KK-YHELP/F*ASP
11440 QY92=KK-YHELPM/F*ASP
11450 QX92=JJ+XHELPM/F
11460 IF WX91<>0 THEN 11510
11470 WX91=JJ
11480 WX92=JJ
11490 WY91=KK
11500 WY92=KK
11510 IF SAN > 1.6 THEN 11530
11520 IF YSMAX/XSMAX>.4 THEN 11570
11530 IF EGA=2 THEN 11560
11540 LINE(WX91,WY91)-(PX91,PY91)
11550 LINE(WX92,WY92)-(PX92,PY92)
11560 GOTO 11620
11570 IF EGA=2 THEN 11620
11580 LINE(WX91,WY91)-(QX91,QY91)
11590 LINE(QX91,QY91)-(PX91,PY91)
11600 LINE(WX92,WY92)-(QX92,QY92)
11610 LINE(QX92,QY92)-(PX92,PY92)
11620 A1=ANGMAT-SAN/2
11630 IF A1<0 THEN A1=A1+2*PI
11640 A2=ANGMAT+SAN/2
11650 IF A2>2*PI THEN A2=A2-2*PI
11660 IF EGA=2 THEN 11720
11670 IF PRT=1 THEN CIRCLE(JJ,KK),XM,COL4,A1,A2,ASP: GOTO 11700
11680 IF EGA=1 THEN CIRCLE(JJ,KK),XM,COL5,A1,A2,ASP
11690 IF EGA=0 THEN CIRCLE(JJ,KK),XM,,A1,A2,ASP
11700 '------PRINT 90% HAZARD DISTANCE AND ANGLE--------------
11710 IF EGA=1 THEN COLOR COL1
11720 IF PRT=1 THEN 12010
11730 IF EGA=2 THEN LOCATE 14,1: GOTO 11750
11740 LOCATE 22,44
11750 IF IUNIT=2 THEN 11870
11760 IF XM*F>1000 THEN 11820
11770 PRINT "TOXIC CORRIDOR LENGTH =";INT(XM*F);"M"
11780 IF NS=1 THEN 12010
11790 IF PYN=2 THEN PRINT #3, "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(XM*F);"M ";: GOTO 11980
11800 LPRINT "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(XM*F);"M ";
11810 GOTO 12000
11820 PRINT "TOXIC CORRIDOR LENGTH =";INT(XM*F/10)/100;"KM"
11830 IF NS=1 THEN 12010
11840 IF PYN=2 THEN PRINT #3, "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(XM*F/10)/100;"KM ";: GOTO 11980
11850 LPRINT "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(XM*F/10)/100;"KM";
11860 GOTO 12000
11870 IF XM*F>1609 THEN 11930
11880 PRINT "TOXIC CORRIDOR LENGTH =";INT(3.2808*XM*F);"FT"
11890 IF NS=1 THEN 12010
11900 IF PYN=2 THEN PRINT #3, "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(3.2808*XM*F);"FT ";: GOTO 11980
11910 LPRINT "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(3.2808*XM*F);"FT ";
11920 GOTO 12000
11930 PRINT "TOXIC CORRIDOR LENGTH =";INT(.062137*XM*F)/100;"MI"
11940 IF NS=1 THEN 12010
11950 IF PYN=2 THEN PRINT #3, "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(.062137*XM*F)/100;"MI ";: GOTO 11980
11960 LPRINT "MAXIMUM TOXIC CORRIDOR LENGTH =";INT(.062137*XM*F)/100;"MI ";
11970 GOTO 12000
11980 IF TTSP<>10000 THEN PRINT #3," AT";INT(TMAX+.5);"MIN" ELSE PRINT #3,""
11990 GOTO 12010
12000 IF TTSP<>10000 THEN LPRINT " AT";INT(TMAX+.5);"MIN" ELSE LPRINT ""
12010 WD1=WD+180: IF WD1>360 THEN WD1=WD1-360
12020 IF PRT=1 THEN 12160
12030 IF EGA=2 THEN 12050
12040 LOCATE 23,45
12050 SAND=INT(SAN/2/RAD)
12060 IF SAND=180 THEN PRINT "DIRECTION & WIDTH";WD1;" (CIRCLE)": GOTO 12080
12070 PRINT "DIRECTION & WIDTH ";WD1;"+/-";SAND;"DEG"
12080 IF NS=1 THEN 12130
12090 IF PYN=1 THEN 12120
12100 PRINT #3, " DIRECTION & WIDTH ";WD1;"+/-";SAND; "DEG": PRINT #3, ""
12110 GOTO 12130
12120 LPRINT " DIRECTION & WIDTH ";WD1;"+/-";SAND;"DEG": LPRINT
12130 IF TTSP=10000 THEN 12160
12140 LOCATE 19,1: PRINT "ELAPSED TIME IS";T;"MIN"
12150 PRINT "MAX DIST OCCURS AT";INT(TMAX);"MIN"
12160 RETURN
12170 '=========================================================================
12180 'SUBROUTINE PUFF
12190 '  This subroutine calculates the concentration at a point in space at a 
12200 '  time
12210 '-------------------------------------------------------------------------
12220 CONC=0
12230 XTEMP=0
12240 X1=X
12250 IF CC1=1 THEN 12430
12260 '------CALCULATE VIRTUAL DISTANCE------
12270 XX1=WWIDTH/10000
12280 XX2=WWIDTH/1000
12290 X=XX1
12300 XY=XX1
12310 GOSUB 13460        'SIGMA
12320 SY1=SY
12330 X=XX2
12340 XY=XX2
12350 GOSUB 13460        'SIGMA
12360 SY2=SY
12370 BB=LOG(SY1/SY2)/LOG(XX1/XX2)
12380 AA=LOG(SY1)-BB*LOG(XX1)
12390 HHW=WWIDTH/4.3
12400 DXXV=EXP((LOG(HHW)-AA)/BB)
12410 '
12420 X=X1
12430 IF IND>0 THEN 12490
12440 XY=X+DXXV
12450 IF XY=XTEMP THEN 12490
12460 GOSUB 13460         'SIGMA
12470 XTEMP=XY
12480 SX=SY
12490 IF OPT>1 AND T<=TTSP AND SZ<.47*HINV THEN 12510
12500 IF T>TTSP OR HINV<>10000 THEN 12580
12510 P=QSS/60/(2*PI*SY*SZ*U)
12520 EY=EXP(-.5*(Y/SY)^2)
12530 EZ1=EXP(-.5*((Z-H)/SZ)^2)
12540 EZ2=EXP(-.5*((Z+H)/SZ)^2)
12550 CONC=P*EY*(EZ1+EZ2)
12560 IF 1000*X+SY>T*U*60 THEN CONC=0:Y=0
12570 GOTO 12840
12580 TT=TTSP
12590 TSEC=T*60:  'TIME SINCE RELEASE OF PUFF (SEC)
12600 IF TTSP=10000 THEN TT=T
12610 IF OPT>1 THEN NP=20: GOTO 12660
12620 NP=4: 'NO. OF PUFFS PER MINUTE
12630 IF X<.3 THEN NP=20
12640 IF X=>3 THEN NP=3
12650 IF U>4 THEN NP=INT(NP*U/4)
12660 IF TTSP=.25 THEN NP=4
12670 TPUFF=INT(TT*NP+.5)
12680 PD=60/NP:  'TIME BETWEEN PUFFS (SEC)
12690 MP=QSS/NP: 'MASS PER PUFF
12700 TRAVT2=(1000*X+4*SX)/U
12710 TRAVT1=(1000*X-4*SX)/U
12720 IF TRAVT1<0 THEN TRAVT1=0
12730 IF TSEC=600000! THEN TSEC=TRAVT2
12740 K1=1
12750 IF TSEC=<TRAVT2 THEN 12780 
12760 K1=INT((TSEC-TRAVT2)/PD)
12770 TSEC=TRAVT2
12780 FOR K=K1 TO TPUFF
12790    GOSUB 12900       'KERNAL
12800    CONC=CONC+RATE
12810    TSEC=TSEC-PD
12820    IF TSEC<TRAVT1 THEN 12840
12830 NEXT K
12840 CC1=1
12850 RETURN
12860 '=========================================================================
12870 'SUBROUTINE KERNAL
12880 'This subroutine calculate the kernal for the Gaussian puff model
12890 '-------------------------------------------------------------------------
12900 KPRT=0
12910 R=Y/SY
12920 E=-.5*R*R
12930 YFAC=EXP(E)
12940 R=(X*1000-U*TSEC)/SX
12950 E=-.5*R*R
12960 XFAC=EXP(E)
12970 IF X=XXX THEN 13370
12980 XXX=X
12990 PREEXP=.0634936*MP/(SX*SY*SZ)
13000 IF PREEXP<1E-30 THEN 13430
13010 RMINUS=Z-H
13020 W=RMINUS/SZ
13030 E=-.5*W*W
13040 Z1=0
13050 IF E>-80 THEN Z1=EXP(E)
13060 RPLUS=Z+H
13070 W=RPLUS/SZ
13080 E=-.5*W*W
13090 Z2=0
13100 IF E>-80 THEN Z2=EXP(E)
13110 ZTERM=Z1+Z2
13120 SUM=0
13130 IF HINV=10000 THEN 13370
13140 '----------------INVERSION TERMS-----------------
13150 HINC=2*HINV
13160 DELTA=HINC
13170 FOR N=1 TO 200
13180    S=0
13190    RMMH=(RMINUS-DELTA)/SZ
13200    R=-.5*RMMH*RMMH
13210    IF R>-80 THEN S=EXP(R)
13220    RPMH=(RPLUS-DELTA)/SZ
13230    R=-.5*RPMH*RPMH
13240    IF R>-80 THEN S=S+EXP(R)
13250    RMPH=(RMINUS+DELTA)/SZ
13260    R=-.5*RMPH*RMPH
13270    IF R>-80 THEN S=S+EXP(R)
13280    RPPH=(RPLUS+DELTA)/SZ
13290    R=-.5*RPPH*RPPH
13300    IF R>-80 THEN S=S+EXP(R)
13310    SUM=SUM+S
13320    IF S<.01 THEN 13370
13330    DELTA=DELTA+HINC
13340 NEXT N
13350 KPRT=1
13360 '-------------------------------------------
13370 RATE=PREEXP*XFAC*YFAC*(ZTERM+SUM)
13380 IF RATE<1E-35 THEN RATE=0
13390 IF KPRT=0 THEN 13440
13400 RATE=PREEXP*2.5066283# *SZ/HINV*XFAC*YFAC
13410 IF RATE<1E-35 THEN RATE=0
13420 GOTO 13440
13430 RATE=0
13440 RETURN
13450 '=========================================================================
13460 'SUBROUTINE SIGMAYZ
13470 'This subroutine calculates horizontal and vertical diffusion coefficients,
13480 'SIGMA Y and SIGMA Z
13490 '-------------------------------------------------------------------------
13500 IF NUM=3 THEN 13620
13510 IF CXX=1 THEN 13670
13520 DATA .0414,.0414,.1036,.1173,.0975,.1050,.0617,1.928E-4,1.928E-4,.0534,.4422,.6097,.8788,.9990
13530 DATA 1.3155,1.3155,1.0026,.9112,.8414,.7692,.7884,2.1234,2.1234,1.1029,.7382,.5808,.4771,.4052
13540 FOR I=1 TO 14
13550   READ SFAK(I)
13560 NEXT I
13570 FOR I=1 TO 14
13580   READ SEXP(I)
13590 NEXT I
13600 IF AT<=1 THEN STB=STBV: 'ASSUME NO MEANDER
13610 IF OPTN=2 THEN 13640
13620 IF AT>1 AND STBV=6 THEN IFLAG=1: STB=3.5: 'ASSUME MEANDER
13630 '-----COMPUTE SIGMA Y (SY)--------
13640 AAA=.479-.1232*STB+.00904*STB*STB
13650 B1=.9
13660 CXX=1
13670 XY=XY*1000
13680 X=X*1000
13690 SY=AAA*XY^B1
13700 REM CORRECT SY FOR ROUGHNESS LENGTH
13710 SY=SY*(ZO/3)^.2
13720 REM  CORRECT SY FOR AVERAGING TIME
13730 SY=SY*(AT/10)^.2
13740 '------COMPUTE SIGMA Z (SZ)-------
13750 IVAR=2
13760 INDEX=INT(STBV+.4999)+IVAR
13770 INDEX1=INDEX-1
13780 IF INDEX=8 THEN INDEX=INDEX-1
13790 ON INDEX GOTO 13800,13800,13800,13810,13820,13830,13830
13800 IF X>745 THEN 13840 ELSE 13850
13810 IF X>2000 THEN 13840 ELSE 13850
13820 IF X>1100 THEN 13840 ELSE 13850
13830 IF X>1400 THEN 13840 ELSE 13850
13840 INDEX=INDEX+7
13850 ON INDEX1 GOTO 13860,13860,13860,13870,13880,13890,13890
13860 IF X>745 THEN 13900 ELSE 13910
13870 IF X>2000 THEN 13900 ELSE 13910
13880 IF X>1100 THEN 13900 ELSE 13910
13890 IF X>1400 THEN 13900 ELSE 13910
13900 INDEX1=INDEX1+7
13910 IF STBV>4.5 THEN DS=1.5 ELSE DS=1
13920 S1=SFAK(INDEX1)*X^SEXP(INDEX1)
13930 S2=SFAK(INDEX)*X^SEXP(INDEX)
13940 IF INDEX>7 THEN INDEX=INDEX-7
13950 SZ=S1-(S1-S2)*(STBV-INDEX+2.5)/DS 
13960 REM  CORRECT FOR ROUGHNESS LENGTH
13970 IF OPTN=2 THEN 14000
13980 SZ=SZ*(ZO/3)^.2
13990 GOTO 14010
14000 SZ=SZ*(ZO/ZOO)^.2
14010 X=X/1000
14020 XY=XY/1000
14030 RETURN
14040 '-------------------------------------------------------------------------
14050 LOCATE 22,1: PRINT STRING$(23," ")
14060 PRINT STRING$(41," ")
14070 IF EGA=1 THEN COLOR COL4
14080 IF PYN<>1 THEN 14320
14090 IF EGA=2 THEN 14300
14100 IF J1=0 THEN 14320
14110 LOCATE 22,1
14120 PRINT "DO YOU WANT A PRINTOUT"
14130 INPUT "    OF THE PLUME PLOT(Y/N)? <N> ",YN$
14140 LOCATE 22,1: PRINT STRING$(23," ")
14150 LOCATE 23,1: PRINT STRING$(35," ")
14160 IF YN$="999" THEN 3900
14170 IF YN$="Y" OR YN$="y" THEN 14190
14180 GOTO 14320
14190 CC=0
14200 CC3=0
14210 PRT=1
14220 IF EGA=1 AND SCR=1 THEN COLOR 15,0
14230 GOTO 6260
14240 LOCATE 23,1: INPUT "PRESS <ENTER> <Print Scrn> <ENTER>" ,NN$
14250 IF NN$="999" THEN 3900
14260 LOCATE 23,1: PRINT STRING$(36," ")
14270 LOCATE 23,1: INPUT " ",NN$
14280 LOCATE 23,1: PRINT STRING$(44," ")
14290 IF EGA=1 THEN COLOR COL4
14300 LOCATE 23,1: INPUT "DO YOU WISH TO CHANGE ANYTHING(Y/N)? <N>",YN$
14310 IF YN$="Y" OR YN$="y" THEN NS=0: GOSUB 5870
14320 LOCATE 22,1: PRINT STRING$(25," ")
14330 LOCATE 23,1: INPUT "DO YOU WISH TO RUN ANOTHER CASE(Y/N)? <N> ",NY$
14340 LOCATE 23,1: PRINT STRING$(44," ")
14350 IF NY$="999" THEN 3900
14360 IF NY$= "N" OR NY$="n" OR NY$="" THEN 14480
14370 IF NY$= "Y" OR NY$ ="y" THEN 14390
14380 PRINT CHR$(7): GOTO 14280
14390 IF PYN<>2 THEN 14430
14400 LOCATE 23,1: PRINT STRING$(79," ")
14410 LOCATE 23,1: INPUT "DO YOU WISH TO SAVE THE OUTPUT FROM THIS CASE(Y/N)? <Y>",NY$
14420 IF NY$="Y" OR NY$= "y" OR NY$="" THEN 14450
14430 CLOSE #3
14440 AA3=0
14450 CLOSE #1
14460 IF EGA=0 THEN SCREEN 0
14470 CHAIN "AFTOX" 
14480 CLOSE
14490 END
