      Subroutine SYMBQ(xp,yp,ht,mlab,ang,nch)
CC
CC---------------------------------------------------------------------
CC--- Author organization- H. E. Cramer Co., Inc.                   ---
CC--- Subroutine code - SYMBQ Version 01.1                          ---
CC--- Subroutine description - plots alpha-numeric labels at any    ---
CC---                          angle.                               ---
CC---------------------------------------------------------------------
CC
CC        plots labels at any angle.
CC
CC       xp    - start x coordinate for label (inches)
CC       yp    - start y coordinate for label (inches)
CC       ht    - height of characters in label (inches)
CC       mlab  - array containing label to be plotted.
CC       ang   - angle to rotate the label (degrees). 0 = no rotation,
CC               90 = rotate 90 degrees counter clockwise relative to
CC               xp,yp, -90 = rotate 90 degrees clockwise relative to
CC               xp,yp.
CC       nch   - number of characters to plot.
CC
CC**********************************************************************
CC
      character*1 mlab
CC
      integer*2 ix,iy,ip,in,io,ic,ix1,ix2,ix3,ix4,ix5,ix6,ix7,iy1,iy2,
     *          iy3,iy4,iy5,iy6,iy7,ip1,ip2,ip3,ip4,ip5,ip6,ip7,i,j,k,
     *          l,m,n,n1
CC
      dimension ix(581),iy(581),ip(581),in(95),io(95),ic(95),n1(2),
     *          ix1(86),ix2(109),ix3(80),ix4(67),ix5(66),ix6(103),
     *          ix7(70),iy1(86),iy2(109),iy3(80),iy4(67),iy5(66),
     *          iy6(103),iy7(70),ip1(86),ip2(109),ip3(80),ip4(67),
     *          ip5(66),ip6(103),ip7(70),mlab(80)
CC
      include 'OCNTRL.INC'
      include 'OWNTRL.INC'
      include 'OCDSPM.INC'
CC
      equivalence (ix(1),ix1(1)),(ix(87),ix2(1)),(ix(196),ix3(1)),
     *            (ix(276),ix4(1)),(ix(343),ix5(1)),(ix(409),ix6(1)),
     *            (ix(512),ix7(1))
      equivalence (iy(1),iy1(1)),(iy(87),iy2(1)),(iy(196),iy3(1)),
     *            (iy(276),iy4(1)),(iy(343),iy5(1)),(iy(409),iy6(1)),
     *            (iy(512),iy7(1))
      equivalence (ip(1),ip1(1)),(ip(87),ip2(1)),(ip(196),ip3(1)),
     *            (ip(276),ip4(1)),(ip(343),ip5(1)),(ip(409),ip6(1)),
     *            (ip(512),ip7(1))
CC
CC    blnk,!,",#,$,%,&,',(,),*,+,,,-,.,/,0,1,2,3,4,5,6,7,8,9,:,;,<,=,>,
CC    ?,@,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,[,\,],^,_,
CC    `,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,{,|,},~
      data ix1/ 0,                                                      blnk
     *          7, 7, 6, 6, 8, 8, 6,                                    !
     *          5, 5, 9, 9,                                             "
     *          4, 4,10,10, 0,14, 0,14,                                 #
     *          7, 7, 0, 3,11,14,14,11, 3, 0, 0, 3,11,14,               $
     *          0, 0, 5, 5, 0, 9, 9,14,14, 9,                           %
     *         13, 5, 4, 5, 7, 9,10, 9, 7, 3, 1, 3, 7,13,               &
     *          9,14,                                                   '
     *          6, 4, 2, 1, 0, 0, 1, 2, 4, 6,                           (
     *          0,                                                      )
     *          3,11, 4,11, 0,14,                                       *
     *          7, 7,                                                   +
     *          2, 0, 0, 2, 2,                                          ,
     *          0,14/                                                   -
      data ix2/ 0, 0, 2, 2, 0,                                          .
     *          0,14,                                                   /
     *          9,11,14,14,14,14,11, 3, 0, 0, 3,11,14,14,               0
     *          0,14, 7, 7, 2,                                          1
     *          0, 3,11,14,14,11, 0, 0,14,                              2
     *          0, 3,11,14,14, 8,14,14,11, 3, 0,                        3
     *          0, 0,14,10,10,                                          4
     *          0, 3,11,14,14,11, 0, 0,14,                              5
     *          0, 3,11,14,14,11, 3, 0, 0, 5,11,13,                     6
     *          0,14, 0,14,                                             7
     *          3,11,14,14,11, 3, 0, 0, 3, 0, 0, 3,11,14,14,11,         8
     *          0, 3,11,14,14,11, 3, 0, 0, 3,14,                        9
     *          0, 0, 2, 2, 0,                                          :
     *          0/                                                      ;
      data ix3/14, 0,14,                                                <
     *          0,14, 0,14,                                             =
     *          0,                                                      >
     *          0, 3,11,14,14,11, 5, 5, 5, 5,                           ?
     *         14,11, 3, 0, 0, 3,11,14,14, 4, 4,10,10,                  @
     *          3,11, 0, 7,14,                                          A
     *         11,14,14,11, 0,11, 0, 0,11,                              B
     *         14,14,11, 3, 0, 0, 3,11,14,14,                           C
     *          0,11,14,14,11, 0,                                       D
     *          0,14,                                                   E
     *         14, 0, 0,11,                                             F
     *         10,14,14,                                                G
     *          0,14,14,14,                                             H
     *          0,14, 0,14, 7, 7/                                       I
      data ix4/ 0,14, 9, 9, 0, 0, 0,                                    J
     *         14, 0,14,                                                K
     *          0, 0,                                                   L
     *          0, 7,14,14,14,                                          M
     *          0,14,14,14,                                             N
     *         14,14,                                                   O
     *         11,14,14,11,11, 0, 0,11,                                 P
     *         11,14,                                                   Q
     *          0,14,                                                   R
     *          0, 3,11,14,14,11, 3, 0, 0, 3,11,14,                     S
     *          0,14, 7, 7,                                             T
     *          0, 0, 3,11,14,14,                                       U
     *          0, 7,14,                                                V
     *          0, 7,14, 0, 0,14,14/                                    W
      data ix5/ 0,14,                                                   X
     *          0, 7,14, 7, 7,                                          Y
     *          0,14, 0,14, 4,11, 0,14,                                 Z
     *          9, 0, 0, 9,                                             [
     *          0,                                                      \
     *          0,                                                      ]
     *          0, 7,14,                                                ^
     *         -6,20,                                                   _
     *          0,                                                      `
     *          1, 2, 4,10,12,13,13,11, 4, 2, 1, 1, 2, 4,11,13,13,14,   a
     *          1, 1,13,13,                                             b
     *         13,12,10, 4, 2, 1, 1, 2, 4,10,12,13,                     c
     *         13,13,                                                   d
     *         13,13, 0/                                                e
      data ix6/ 1,13, 7, 7, 8,10,11,11,                                 f
     *          0, 1, 3,10,12,13,13,                                    g
     *          1, 1, 1, 2, 4,10,12,13,13,                              h
     *          5, 7, 7, 3,11, 7, 7,                                    i
     *          8,10,10, 9, 7, 5, 3,10,10,                              j
     *          1, 1, 1,10, 4,12,                                       k
     *          5, 7, 7, 3,11,                                          l
     *          0, 0, 0, 1, 3, 4, 6, 7, 7, 7, 8,10,11,13,14,14,         m
     *          1, 1, 1, 2, 4,10,12,13,13,                              n
     *         13,13,                                                   o
     *          1, 1,                                                   p
     *         13,13,                                                   q
     *          1, 1, 1, 5, 9,14,                                       r
     *          1, 2, 4,10,12,13,12,10, 3, 1, 1, 3,10,12,13/            s
      data ix7/ 6, 6, 7, 8,10, 2,10,                                    t
     *         13,13,13,12,10, 4, 2, 1, 1,                              u
     *          1, 7,13,                                                v
     *          0, 4, 7,10,14,                                          w
     *          1,13, 1,13,                                             x
     *          1, 7,13, 7, 7,                                          y
     *          3, 3,13, 1,13,13,                                       z
     *          6, 4, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 4, 6,      {
     *          7, 7,                                                   |
     *          0,                                                      }
     *          0, 1, 3, 5, 6, 7, 8, 9,11,13,14/                        ~
      data iy1/ 0,                                                      blnk
     *         20, 5, 0, 2, 2, 0, 0,                                    !
     *         15,20,15,20,                                             "
     *          0,20, 0,20, 8, 8,12,12,                                 #
     *         -4,24, 3, 0, 0, 3, 7,10,10,13,17,20,20,17,               $
     *         15,20,20,15,15, 0, 5, 5, 0, 0,                           %
     *          0,12,15,17,19,17,15,13,11, 8, 5, 1, 0, 5,               &
     *         15,20,                                                   '
     *         20,19,18,16,14, 6, 4, 2, 1, 0,                           (
     *          0,                                                      )
     *         16, 4, 4,16,10,10,                                       *
     *          3,17,                                                   +
     *          0, 0, 2, 2,-4,                                          ,
     *         10,10/                                                   -
      data iy2/ 0, 2, 2, 0, 0,                                          .
     *          0,20,                                                   /
     *         15,20,15, 5,15,17,20,20,17, 3, 0, 0, 3, 5,               0
     *          0, 0, 0,20,15,                                          1
     *         17,20,20,17,13,10,10, 0, 0,                              2
     *         17,20,20,17,13,10, 7, 3, 0, 0, 3,                        3
     *         20,10,10, 0,20,                                          4
     *          3, 0, 0, 3, 7,10,10,20,20,                              5
     *          7,10,10, 7, 3, 0, 0, 3,14,20,20,18,                     6
     *         20,20, 0,20,                                             7
     *         10,10,13,17,20,20,17,13,10, 7, 3, 0, 0, 3, 7,10,         8
     *          3, 0, 0, 3,17,20,20,17,13,10,10,                        9
     *         10,12,12,10,10,                                          :
     *          0/                                                      ;
      data iy3/ 3,10,17,                                                <
     *          8, 8,12,12,                                             =
     *          0,                                                      >
     *         17,20,20,17,13,10,10, 4, 2, 0,                           ?
     *          3, 0, 0, 3,17,20,20,17, 7, 7,13,13, 7,                  @
     *         10,10, 0,20, 0,                                          A
     *         10, 7, 3, 0, 0,20,20,10,10,                              B
     *         15,17,20,20,17, 3, 0, 0, 3, 5,                           C
     *         20,20,17, 3, 0, 0,                                       D
     *          0, 0,                                                   E
     *         20,20,10,10,                                             F
     *          6, 6, 5,                                                G
     *         10,10,20, 0,                                             H
     *          0, 0,20,20,20, 0/                                       I
      data iy4/20,20,20, 0, 0, 3,10,                                    J
     *          0,10,20,                                                K
     *         20, 0,                                                   L
     *         20,10,20,20, 0,                                          M
     *         20, 0,20, 0,                                             N
     *         15, 5,                                                   O
     *         20,17,13,10,20,20,10,10,                                 P
     *          3, 0,                                                   Q
     *         10, 0,                                                   R
     *          3, 0, 0, 3, 7,10,10,13,17,20,20,17,                     S
     *         20,20,20, 0,                                             T
     *         20, 3, 0, 0, 3,20,                                       U
     *         20, 0,20,                                                V
     *          0,10, 0,20, 0,20, 0/                                    W
      data iy5/20, 0,                                                   X
     *         20,10,20,10, 0,                                          Y
     *         20,20, 0, 0,10,10, 0,20,                                 Z
     *         20,20, 0, 0,                                             [
     *          0,                                                      \
     *          0,                                                      ]
     *         10,20,10,                                                ^
     *         -1,-1,                                                   _
     *          0,                                                      `
     *          8,10,11,11,10, 9, 2, 0, 0, 1, 3, 4, 6, 7, 7, 5, 2, 0,   a
     *         18, 0, 8, 3,                                             b
     *          3, 1, 0, 0, 1, 3, 8,10,11,11, 9, 8,                     c
     *         18, 0,                                                   d
     *          8, 6, 6/                                                e
      data iy6/10,10, 0,17,18,18,16,14,                                 f
     *         -3,-4,-5,-5,-4,-2, 8,                                    g
     *          0,18, 8,10,11,11,10, 8, 0,                              h
     *         11,11, 0, 0, 0,13,15,                                    i
     *         11,11,-2,-4,-5,-4, 0,13,15,                              j
     *          0,18, 6,12, 8, 0,                                       k
     *         18,18, 0, 0, 0,                                          l
     *          0,11, 8,10,11,11,10, 8, 0, 8,10,11,11,10, 8, 0,         m
     *          0,11, 8,10,11,11,10, 8, 0,                              n
     *          8, 3,                                                   o
     *         -5, 8,                                                   p
     *         -5, 8,                                                   q
     *          0,11, 7,10,11, 8,                                       r
     *          3, 1, 0, 0, 1, 3, 5, 6, 6, 7,10,11,11,10, 8/            s
      data iy7/18, 1, 0, 0, 2,10,10,                                    t
     *          0,11, 3, 1, 0, 0, 1, 3,11,                              u
     *         11, 0,11,                                                v
     *         11, 0, 5, 0,11,                                          w
     *         11, 0, 0,11,                                             x
     *         11, 6,11, 6, 0,                                          y
     *         10,11,11, 0, 0, 1,                                       z
     *         20,19,18,16,15,13,12,11,10, 9, 8, 7, 5, 4, 2, 1, 0,      {
     *         20, 0,                                                   |
     *          0,                                                      }
     *         10,12,13,13,12,10, 8, 7, 7, 8,10/                        ~
      data ip1/ 3,                                                      blnk
     *          3, 2, 3, 2, 2, 2, 2,                                    !
     *          3, 2, 3, 2,                                             "
     *          3, 2, 3, 2, 3, 2, 3, 2,                                 #
     *          3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,               $
     *          3, 2, 2, 2, 2, 3, 2, 2, 2, 2,                           %
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,               &
     *          3, 2,                                                   '
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2,                           (
     *          3,                                                      )
     *          3, 2, 3, 2, 3, 2,                                       *
     *          3, 2,                                                   +
     *          3, 2, 2, 2, 2,                                          ,
     *          3, 2/                                                   -
      data ip2/ 3, 2, 2, 2, 2,                                          .
     *          3, 2,                                                   /
     *          3, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2,               0
     *          3, 2, 3, 2, 2,                                          1
     *          3, 2, 2, 2, 2, 2, 2, 2, 2,                              2
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                        3
     *          3, 2, 2, 3, 2,                                          4
     *          3, 2, 2, 2, 2, 2, 2, 2, 2,                              5
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                     6
     *          3, 2, 3, 2,                                             7
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,         8
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                        9
     *          3, 2, 2, 2, 2,                                          :
     *          3/                                                      ;
      data ip3/ 3, 2, 2,                                                <
     *          3, 2, 3, 2,                                             =
     *          3,                                                      >
     *          3, 2, 2, 2, 2, 2, 2, 2, 3, 2,                           ?
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                  @
     *          3, 2, 3, 2, 2,                                          A
     *          3, 2, 2, 2, 2, 3, 2, 3, 2,                              B
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2,                           C
     *          3, 2, 2, 2, 2, 2,                                       D
     *          3, 2,                                                   E
     *          3, 2, 3, 2,                                             F
     *          3, 2, 2,                                                G
     *          3, 2, 3, 2,                                             H
     *          3, 2, 3, 2, 3, 2/                                       I
      data ip4/ 3, 2, 3, 2, 2, 2, 2,                                    J
     *          3, 2, 2,                                                K
     *          3, 2,                                                   L
     *          3, 2, 2, 3, 2,                                          M
     *          3, 2, 3, 2,                                             N
     *          3, 2,                                                   O
     *          3, 2, 2, 2, 3, 2, 3, 2,                                 P
     *          3, 2,                                                   Q
     *          3, 2,                                                   R
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                     S
     *          3, 2, 3, 2,                                             T
     *          3, 2, 2, 2, 2, 2,                                       U
     *          3, 2, 2,                                                V
     *          3, 2, 2, 3, 2, 3, 2/                                    W
      data ip5/ 3, 2,                                                   X
     *          3, 2, 2, 3, 2,                                          Y
     *          3, 2, 3, 2, 3, 2, 3, 2,                                 Z
     *          3, 2, 2, 2,                                             [
     *          3,                                                      \
     *          3,                                                      ]
     *          3, 2, 2,                                                ^
     *          3, 2,                                                   _
     *          3,                                                      `
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,   a
     *          3, 2, 3, 2,                                             b
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                     c
     *          3, 2,                                                   d
     *          3, 2, 2/                                                e
      data ip6/ 3, 2, 3, 2, 2, 2, 2, 2,                                 f
     *          3, 2, 2, 2, 2, 2, 2,                                    g
     *          3, 2, 3, 2, 2, 2, 2, 2, 2,                              h
     *          3, 2, 2, 2, 2, 3, 2,                                    i
     *          3, 2, 2, 2, 2, 2, 2, 3, 2,                              j
     *          3, 2, 3, 2, 3, 2,                                       k
     *          3, 2, 2, 2, 2,                                          l
     *          3, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2,         m
     *          3, 2, 3, 2, 2, 2, 2, 2, 2,                              n
     *          3, 2,                                                   o
     *          3, 2,                                                   p
     *          3, 2,                                                   q
     *          3, 2, 3, 2, 2, 2,                                       r
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2/            s
      data ip7/ 3, 2, 2, 2, 2, 3, 2,                                    t
     *          3, 2, 3, 2, 2, 2, 2, 2, 2,                              u
     *          3, 2, 2,                                                v
     *          3, 2, 2, 2, 2,                                          w
     *          3, 2, 3, 2,                                             x
     *          3, 2, 2, 3, 2,                                          y
     *          3, 2, 2, 2, 2, 2,                                       z
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,      {
     *          3, 2,                                                   |
     *          3,                                                      }
     *          3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2/                        ~
      data in/   1,   7,   4,   8,  14,  10,  14,   2,  10,   1,   6,
     *           2,   5,   2,   5,   2,  14,   5,   9,  11,   5,   9,
     *          12,   4,  16,  11,   5,   1,   3,   4,   1,  10,  13,
     *           5,   9,  10,   6,   2,   4,   3,   4,   6,   7,   3,
     *           2,   5,   4,   2,   8,   2,   2,  12,   4,   6,   3,
     *           7,   2,   5,   8,   4,   1,   1,   3,   2,   1,  18,
     *           4,  12,   2,   3,   8,   7,   9,   7,   9,   6,   5,
     *          16,   9,   2,   2,   2,   6,  15,   7,   9,   3,   5,
     *           4,   5,   6,  17,   2,   1,  11/
      data io/   0,   1,   8,  12,  20,  34,  44,  58,  60,  70,  71,
     *          77,  79,  84,  86,  91,  93, 107, 112, 121, 132, 137,
     *         146, 158, 162, 178, 189, 194, 195, 198, 202, 203, 213,
     *         226, 231, 240, 250, 256, 258, 262, 265, 269, 275, 282,
     *         285, 287, 292, 296, 298, 306, 308, 310, 322, 326, 332,
     *         335, 342, 344, 349, 357, 361, 362, 363, 366, 368, 369,
     *         387, 391, 403, 405, 408, 416, 423, 432, 439, 448, 454,
     *         459, 475, 484, 486, 488, 490, 496, 511, 518, 527, 530,
     *         535, 539, 544, 550, 567, 569, 570/
      data ic/   0,   0,   0,   0,   0,  16,   0,   0,   0,  -9,   0,
     *          14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     *           0,   0,   0,   0,  15,2713,   0,   0, -29,   0,   0,
     *           0,4549,   0,  45,3945,  45,  36,  45,   0,   0,  45,
     *          38,  45,  45,  36,  45,3648,4549,   0,   0,   0,   0,
     *           0,  16,   0,   0,   0,  57, -60,   0,   0,  -8,   0,
     *          68,   0,  68,  68,   0,  68,   0,   0,   0,   0,   0,
     *           0,   0,  68,6880,  68,   0,   0,   0,   0,   0,   0,
     *           0,   0,   0,   0,   0, -92,   0/
CC
CC********************************************************************-
CC
      as = ang * dtorad
      ac = COS(as)
      as = SIN(as)
      if (nbxpss .lt. 100) then
        xmn = 1.0e6
        xmx = -1.0e6
        ymn = 1.0e6
        ymx = -1.0e6
      end if
      dxx = 20.0 * ac
      dyy = 20.0 * as
      scls = ht * 0.05
      wd = 0.78571429
      do 30 i=1,nch
        xl = xp + FLOAT(i-1) * dxx * scls
        yl = yp + FLOAT(i-1) * dyy * scls
        j = ichar(mlab(i)) - 31
        if (j .gt. 0.and.j .lt. 96) then
          m = 0
          if (ic(j) .ne. 0) then
            m = 1
            if (ic(j) .gt. 100) then
              m = 2
              n1(1) = ic(j) /100
              n1(2) = ic(j) - n1(1) * 100
            else
              n1(1) = ic(j)
            end if
          end if
   10     n = in(iabs(j))
          l = io(iabs(j))
          do 20 k=1,n
            if (j .gt. 0) then
              ixx = ix(k+l)
            else
              ixx = 14 - ix(k+l)
            end if
            xx = xl + ((FLOAT(ixx) * wd + 0.5) * ac - FLOAT(iy(k+l)) *
     *           as) * scls
            yy = yl + ((FLOAT(ixx) * wd + 0.5) * as + FLOAT(iy(k+l)) *
     *           ac) * scls
            ipen = ip(k+l)
            call PLT2Q(xx,yy,ipen)
            if (nbxpss .lt. 100) then
              xmn = AMIN1(xx,xmn)
              xmx = AMAX1(xx,xmx)
              ymn = AMIN1(yy,ymn)
              ymx = AMAX1(yy,ymx)
            end if
   20     continue
          if (m .gt. 0) then
            j = n1(m)
            m = m - 1
            go to 10
          end if
        end if
   30 continue
      call PLT2Q(xx,yy,3)
CC      save points indicating area that should not be plotted over.
      if (nbxpss .lt. 100) then
        nbxpss = nbxpss + 1
        xbxpsl(nbxpss) = xmn
        ybxpsl(nbxpss) = ymn
        xbxpel(nbxpss) = xmx
        ybxpel(nbxpss) = ymx
      end if
      return
      end
