c-----------------------------------------------------------------------
      FUNCTION ERFC(XX)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 4.0       Level: 941228                  ERFC
c                R. Yamartino, SRC
c
c --- PURPOSE:  Computes the complementary error function, 1-erf(x).
c ---           This is the Quick medium accuracy COMP. ERROR FUNCTION
c ---           from NBS 55.  Using an approximation due to Hastings;
c ---           absolute error about 3e-7.  Asymptotic expression added
c ---           for large xx to reduce percent error.
c
c
c --- INPUTS:
c
c                XX - real    - Argument  (no units)
c
c --- OUTPUTS:
c
c              ERFC - real    - complementary error function of x
c
c --- ERFC called by:  ERFDIF
c --- ERFC calls:   no routines
c-----------------------------------------------------------------------
c
      real x, xx ,t, t16, a(6)
      data a/0.0000430638, 0.0002765672, 0.0001520143,
     *       0.0092705272, 0.0422820123, 0.0705230784/
      data xcutl/-3.919206/
      data xcuth/13.306   /
      data rtpii/0.5641896/
c
      if(xx .gt. xcuth) then
         erfc = 0.0
c
      elseif(xx .lt. xcutl) then
         erfc = 2.0
c
      elseif(xx .gt. 2.79) then
         x = abs(xx)
         z = 1.0 / x
         erfc = rtpii * z * exp(-x*x) * ( 1.0 - 0.5*z*z*(1.0-1.5*z*z) )
c
      else
         x = abs(xx)
         t = ((((((((( a(1)*x + a(2) ) * x ) + a(3) ) * x ) + a(4) ) *
     x                    x ) + a(5) ) * x ) + a(6) ) * x
c
         t = 1.0 / (t + 1.0)
c
c        erfc = t**16   for x > 0
         t16 = t * t * t * t
         t16 = t16 * t16 * t16 * t16
c
         if(xx .gt. 0.0) then
            erfc =  t16
         else
            erfc =  2.0 - t16
         endif
c
      endif
c
      return
      end
