C     EMFAC.INC
C
C  ... PARAMETERS ...
C
C      MXTS       MAXIMUM TIME STEPS
C      MXFZ       MAXIMUM NUMBER OF PHASES
C      MXLNE      MAXIMUM NUMBER OF LANES
C      MXBLK      MAXIMUM NUMBER OF BLOCKS
C      MXIA       MAXIMUM NUMBER OF LINKS
C
       INTEGER    MXTS, MXFZ, MXLNE, MXBLK, MXIA
       PARAMETER  (MXTS   = 192)
       PARAMETER  (MXFZ   = 12)
       PARAMETER  (MXLNE  = 7)
       PARAMETER  (MXBLK  = 125)
       PARAMETER  (MXIA   = 10)
C
C     VARIABLES:
C
C      ITOTA      TOTAL LINKS FOR NODE
C      IMXFZ      NUMBER OF PHASES
C      INBLK      NUMBER OF BLOCKS FOR LINK IA
C      IMXLNE     NUMBER OF LANES FOR LINK IA
C      IDIR       DIRECTION (UPSTREAM NODE - DOWNSTREAM NODE)
C
       INTEGER    INBLK, IMXLNE, ITOTA, IMXFZ
       INTEGER    IDIR(MXIA)
C
C      FUEL       LINK EMISSIONS BY BLOCK AND PHASE (G)
C      SPEED      AVERAGE SPEED BY BLOCK AND PHASE
C
       REAL       FUEL(MXIA,MXBLK,MXFZ)
c       REAL       SPEED(MXIA,MXBLK,MXFZ)
C
       COMMON     /TRAF/ INBLK, IMXLNE, ITOTA, IMXFZ, IDIR
       COMMON     /EMS/ FUEL
c       COMMON     /EMS/ FUEL, SPEED
C
ccccccccccccccccccccccc
c  variables related  c
c  to roadway model   c
ccccccccccccccccccccccc

      parameter (MXSEG = 3)

      real emiss(MXBLK,MXIA,MXFZ),speed(MXBLK,MXIA,MXFZ)
      real vhsec(MXBLK,MXIA,MXFZ),tstep
      real seglen(MXSEG,MXIA),xcenter(MXSEG,MXIA),ycenter(MXSEG,MXIA)
      real xmedian(MXSEG,MXIA),deltax(MXIA),deltay(MXIA),phtime(MXFZ)
      integer nseg(MXIA),nlane(MXSEG,MXIA)
      logical lsouth(MXIA)
      integer napp,nphase


c emiss() = emissions by block,approach,phase
c speed() = speed by block,approach,phase
c vhsec() = vehicle-seconds by block,approach,phase

      common /rwblock/ emiss,speed,vhsec,seglen,xcenter,ycenter,
     1                 xmedian,deltax,deltay,phtime,nseg,nlane,
     2                 lsouth,napp,nphase,tstep
