       SUBROUTINE GETEMS (VS,NFZ,EF,QFAC)
C
C      CALCULATES TOTAL AVERAGE EMISSION RATE (RUNNING AND IDLE) TAKING
C      INTO ACCOUNT EXCESS IDLE EMISSIONS
C
C      VARIABLES
C      VS           ARRAY OF VEHICLE SECOND BY PHASE AND SPEED BIN
C      NFZ          NUMBER OF PHASES
C      EF           EMISSION FACTORS FOR THE TIME PERIOD
c      NEFSPD       Number of speeds for emfacs (M5=7,M6=8)
C      QFAC         TOTAL AVERAGE EMISSION RATE (G/MI)
C
       REAL         VS(8,14), EF(8)
       INTEGER      NFZ
       REAL         QFAC
C
       INCLUDE      'weight.inc'
	 include      'emspec.inc'
C
C      S(13)        SPEED ARRAY IN VEHICLE SECONDS
C      W(7)         WEIGHTS CALCULATED FOR DIFFERENT CYCLES (DIMENSIONLESS)
C
C      INTERNAL VARIABLES
C      QRTOT        TOTAL PREDICTED RUNNING EMISSIONS (G)
C      VMTTOT       TOTAL DISTANCE COVERED (MI)
C      TIDLEC       CYCLE IDLE TIME (S)
C      QXSIDL       EXCESS IDLE EMISSIONS (G)
C      TIDLOBS      VEHICLE SECONDS IN IDLE OBSERVED (S)
C      QCYC         EMISSION FACTORS FOR 7 SPEED (G/MI)
C      QIDL         EMISSION FACTOR FOR IDLE (G/S)
C      TIDLE(7)     IDLE TIME FOR 7 DRIVING CYCLES
C      VMTCYC(7)    VMT FOR 7 DRIVING CYCLES
C
       REAL         QRTOT, VMTTOT, TIDLEC, QXSIDL
       REAL         TIDLOBS, QCYC(7), QIDL 
       INTEGER      IFZ, IC, IV
C
C      EXTERNAL SUBROUTINE
C
       EXTERNAL     DOREGR
C

C===============================================================================
C
C      INITIALIZE VARIABLES
C
       QRTOT   = 0.
       VMTTOT  = 0.
       TIDLEC  = 0.
       TIDLOBS = 0.
C
C      LOOP OVER PHASE AND CYCLE TO GET PREDICTED RUNNING EMISSIONS,
C      DISTANCE COVERED, AND CYCLE IDLE TIME
C
       IF (NFZ .GT. 8) STOP 'MXFZ EXCEEDED IN GETEMS'
       DO 200 IFZ = 1, NFZ
C
C      GET CYCLE WEIGHT FOR EACH PHASE
C
       DO 50 IV = 1,13
          S(IV) = VS(IFZ,IV+1)
 50    CONTINUE
       CALL DOREGR
C 
C      CALCULATE PREDICTED RUNNING EMISSIONS, DISTANCE COVERED, AND CYCLE
C      IDLE TIME
C
       DO 100  IC = 1, NEFSPD-1
          QCYC(IC) = EF(IC+1)
          QRTOT = QRTOT + W(IC) * QCYC(IC) * VMTCYC(IC)
          VMTTOT = VMTTOT + W(IC) * VMTCYC(IC)
          TIDLEC = TIDLEC + W(IC) * TIDLE(IC)
 100   CONTINUE
C
C      CALCULATE OBSERVED IDLE TIME
C
       TIDLOBS = TIDLOBS + VS(IFZ,1)
c       WRITE (*,*) 'IFZ,TIDLOBS',IFZ,TIDLOBS
C
 200   CONTINUE
C
C      CALCULATE EXCESS IDLE TIME
C
c       WRITE (*,*) 'TIDLOBS,TIDLEC',TIDOBS,TIDLEC
       QIDL = EF(1)
       QXSIDL = QIDL * (TIDLOBS - TIDLEC)
C
C      CALCULATE TOTAL AVERAGE EMISSION RATE
C
       IF (VMTTOT .EQ. 0) THEN
          QFAC = 0.
       ELSE
          QFAC = (QRTOT + QXSIDL) / VMTTOT
c          IF (QFAC .LT. 0 ) WRITE (*,*) 'WARNING EF LT ZERO'
       ENDIF
C
       RETURN
       END
           
