       SUBROUTINE GETWT
C
C      VARIABLES
C          INPUTS
C      S(13)        SPEED ARRAY IN VEH-SECONDS
C      CYCS(7,13)   SPEED ARRAY IN VEH-SECONDS FOR 7 DRIVING CYCLES
C      LW(7)        LOGICAL-TRUE FOR THOSE CYCLES TO BE ALLOWED IN WEIGHTING
C
C         RETURNED
C      X(7)         WEIGHTS FROM REGRESSION OF ALLOWED CYCLES
C      SS           SUM OF SQUARES FOR THE REGRESSION
C      LTT          LOGICAL, TRUE IF THE SOLUTION FOUND HERE IS FEASIBLE
C
C         INTERNAL
C      KOUNT        NUMBER OF ALLOWED CYCLES
C      TEST (*)  SPEED ARRAY OF ONLY CYCLES TO BE ALLOWED, PASSED TO REGRWT
C                     GENERALLY NOT FILLED TO FULL 7 ROWS
C      OUT (13,1)   OUTPUT FROM REGRESSION ROUTINE
C
       INCLUDE      'weight.inc'
	 include      'emspec.inc'
       INTEGER      KOUNT, I, J
       REAL         TEST(91), OUT(13,1)
       INTEGER      ICYCL(7), WORK(20),INFO
C
C      EXTERNAL SUBROUTINE
C
       EXTERNAL     SGELS, CHKWTS
C
C==============================================================================
C
C      GET NUMBER OF CYCLES ALLOWED, AND FILL SPEED ARRAY FOR TESTING
C
       KOUNT=0
       LTT = .FALSE.
       DO 5 I = 1, NEFSPD-1
         IF (.NOT. LW(I)) GOTO 5
         KOUNT=KOUNT+1
         ICYCL(KOUNT) = I
 5     CONTINUE
       DO 10 J = 1, 13
         DO 10 I = 1, KOUNT
           TEST((J-1)*KOUNT+I)=CYCS(ICYCL(I),J)
 10    CONTINUE
C
       DO 11 I = 1,13
          OUT(I,1) = S(I)
 11    CONTINUE
C      NOW KNOW NUMBER OF CYCLES AND HAVE ARRAY FOR REGRESSION
C
       CALL SGELS('T',KOUNT,13,1,TEST,KOUNT,OUT,13,WORK,20,INFO)
       IF (INFO .NE. 0) STOP 'ERROR EXECUTING REGRESSION ROUTINE'
C
C      SUCCESSFUL - EXTRACT OUTPUT
C
       DO 15 I = 1, KOUNT
          X(I) = OUT(I,1)
 15    CONTINUE
       SS = 0
       DO 20 I = KOUNT+1, 13
          SS = SS + OUT(I,1)*OUT(I,1)
 20    CONTINUE
C
C      CHECK WEIGHT
C
       CALL CHKWTS(KOUNT)
C
       RETURN
C
       END
