       Subroutine Puffer(uroad,vroad,xkx,nxin,nyin,iphin,ihr)

        dimension uroad(nxin,nyin,iphin),vroad(nxin,nyin,iphin)
        dimension xkx(nxin,nyin,iphin)

        include 'puffdata.inc'
        include 'receptor.inc'
        include 'release.inc'
        include 'winds.inc'
        include 'emiss.inc'
        include 'disp.inc'

        real x
        dimension x (:,:)                 
        allocatable :: x
        character*1 a1
        character*8 rdate,rtime
        logical lsave

        common /timer/ rtime

        xhgt = mixhgt(ihr)
        zsource = 1.8
        xmin = 0.0
        xmax = 9999.0
        ymin = 0.0
        ymax = 9999.0
        nrecp = numrec
        npuff = 0
        do 60 i=1,nrecp
           xrecp(i) = recloc(1,i) + 1250.0
           yrecp(i) = recloc(2,i) + 1250.0
           zrecp(i) = recloc(3,i)
   60   continue
        
        nxgrid = 250
        nygrid = 250
        gridlen = 10.0
        istabcl = stabcls(ihr)
        puffmax = 0.0
        intervl = 900
        istep = 1
        itime = 0
        Do 15 i=1,nphase
           if (phtime(i) .lt. istep) then
              itime = itime + 1
           else
              itime = itime + int(phtime(i))/istep
           endif
   15   Continue
        mxpuff = itime * nphase * nblock * 5
        k = 6
        allocate (x(mxpuff,k),STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Puffer dimensions too big'
           write (*,*) mxpuff,k,itime,nphase,nblock
           stop
        endif
        cydist = 0
        do 100 i=1,nphase
           cydist = cydist + phtime(i)
  100   continue

        call Robpuff (mxpuff,x(1,1),
     1             x(1,2),x(1,3),x(1,4),x(1,5),x(1,6),
     2             uroad,vroad,xkx,nxin,nyin,iphin)
        deallocate (x,STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Puffer dimensions too big'
           write (*,*) mxpuff,k,itime,nphase,nblock
           stop
        endif
        return
        end

        subroutine Robpuff (ij,xpuff,ypuff,ydist,zdist,xmass,
     1                      idexpuff,uroad,vroad,xkx,nxin,nyin,iphin)
   
        dimension xpuff(ij),ypuff(ij),
     1            ydist(ij),zdist(ij), 
     2            xmass(ij),idexpuff(ij)
        dimension uroad(nxin,nyin,iphin),vroad(nxin,nyin,iphin)
        dimension xkx(nxin,nyin,iphin)
c
c       Purpose:  Calculate CO concentrations at receptors for low wind speeds.
c                 The reason that the puff parameters are passed is that
c                 the arrays are dynamically allocated and therefore
c                 can not be in a common block.
c
c       Arguments:   ij     = Dimension of dynamic puff array
c                    xpuff  = X coordinate of a puff
c                    ypuff  = Y coordinate of a puff
c                    ydist  = Y time of puff (related to distance traveled)
c                    zdist  = z time of puff (related to distance traveled)
c                    xmass  = mass of CO in a puff
c                    isbpuff = Last stability class of puff
c
c       Locals
c
c                    mpuff = offset to set of puffs for next phase
crgi				   kflag = indicator of whether puff crossed a gridcell in
c							last iteration (<0 means it did, so check ydist etc.)
c
        include 'puffdata.inc'
        include 'receptor.inc'
        include 'release.inc'
        include 'winds.inc'
        include 'emiss.inc'
        include 'disp.inc'

        common /timer/ rtime

        real tr(mxxphase)
        character*8 rdate,rtime
        integer kpuff(mxblock,mxxphase),jpuff(mxblock,mxxphase)
c
c       Loop through 2 cycles to get a cycle starting at each phase
c	The idea is at the end of this, we have puff coords and params
c	for nphase sets of full cycles (e.g., phases 1-2-3-4, phases 
c	2-3-4-1, etc. for a 4 phase signal). The ips-ipe loops done for the
c	second cycle fill in the puffs for the signal phases that weren't 
c	fully handled in the icycle=1 pass.
c
        mpuff = 1
        jtot1 = 0
        jtot2 = 0

        kkpuff = 50

        Do 400 icycle=1,2
c
c       Calculate the time step ratios
c
           Do 350 iphase=1,nphase
           if (icycle .eq. 1) then
             Do 110 i=1,nblock
                kpuff(i,iphase) = 0
                jpuff(i,iphase) = 0
  110        continue
           endif
             if (phtime(iphase) .ge. istep) Then
               tr(iphase) = phtime(iphase) /
     1                    ((int(phtime(iphase))/istep) * istep)
             else
               tr(iphase) = phtime(iphase)/istep 
             endif
             emfact = tr(iphase) * phtime(iphase) / cydist
             itend = int(phtime(iphase))/istep
             if (itend .lt. 1) itend = 1
c             write (*,*) iphase,phtime(iphase),itend
c	Do updates for each second of the current phase
             Do 300 itime=1,itend
c	First, update parameters and move all existing puffs.  There
c	aren't any the first time through.
c	mpuff is the number of the first 'active' existing puff, and
c	npuff is the number of the last puff made.
                Do 200 ipuff=mpuff,npuff
                  kstab = iabs(idexpuff(ipuff))/100
                  kphase = mod(iabs(idexpuff(ipuff)),100)
                  kflag = isign(1,idexpuff(ipuff))
                  ixoff = 1 + int(xpuff(ipuff)/gridlen)
                  iyoff = 1 + int(ypuff(ipuff)/gridlen)
				ixoff = max(1, ixoff)
				ixoff = min (ixoff, nxin)
				iyoff = max(1, iyoff)
				iyoff = min (iyoff, nyin)
                  ustar = uroad(ixoff,iyoff,iphase) * tr(iphase)
                  vstar = vroad(ixoff,iyoff,iphase) * tr(iphase)
                  if (kflag .lt. 0) then
                     ws1 = sqrt(ustar*ustar + vstar*vstar)
                     t1 = ydist(ipuff) / ws1
                     kflag = -kflag
                     call getstab(xkx(ixoff,iyoff,iphase),ws1,t1,istab1)
                     call spread(istab1,kstab,
     1                           ydist(ipuff),zdist(ipuff))
                  endif
                  call movepuff(xpuff(ipuff),ypuff(ipuff),ydist(ipuff),
     1                          zdist(ipuff),ustar,vstar,
     2                          tr(iphase)*istep)

                  ixoff1 = 1 + int(xpuff(ipuff)/gridlen)
                  iyoff1 = 1 + int(ypuff(ipuff)/gridlen)
				ixoff1 = max(1, ixoff1)
				ixoff1 = min (ixoff1, nxin)
				iyoff1 = max(1, iyoff1)
				iyoff1 = min (iyoff1, nyin)
                  if (ixoff .ne. ixoff1 .or. iyoff .ne. iyoff1)
     1                 kflag = -iabs(kflag)
                  idexpuff(ipuff) = kflag * (100*kstab + kphase)
 200           Continue
c
c		On the first cycle, we make a new puff for every block for every
c		second.  These stay active till the end of the phase, and then the
c		first one made for each block (i.e., the oldest puff for the block
c		and phase) is used to generate even 'older' puffs as we do the
c		second cycle loop.
c		The puffs are not really being generated in chronological order
c		after we get through the initial set for each phase.
c               
                if (icycle .eq. 1) then
                Do 250 iblock=1,nblock
c                   if (remiss(iblock,iphase) .le. 0.0) jtot1 = jtot1+1
c                   if (remiss(iblock,iphase) .gt. 0.0) jtot2 = jtot2+1
c                   if (remiss(iblock,iphase) .le. 0.0) go to 250
                   npuff = npuff + 1
                   if (npuff .gt. ij) then
                      write (*,*) 'Too many puffs', npuff
                      stop
                   endif
                   call makepuff(xblock(1,iblock),yblock(1,iblock),
     1                           remiss(iblock,iphase),tr(iphase),
     2                           phtime,cydist,iphase,sigz0(iblock),
     3                           xpuff(npuff),ypuff(npuff),
     4                           ydist(npuff),zdist(npuff),
c     4                           ydist(npuff),
     5                           xmass(npuff),idexpuff(npuff),
     6                           emfact,
     7                           uroad,vroad,xkx,nxin,nyin,iphin)
crgi -- now do puff mass. remiss is g/period for this phase
c		hardwired to 15 minute periods.  Put into g/puff
					xmass(npuff) = remiss(iblock,iphase) /
     1				(900 * phtime(iphase) / cydist)
crgi -- we're also going to do the weighting of concentration 
c	contributions by puffs from each phase by weighting the
c	puff mass by the fraction of the total cycle time contributed by
c	each phase.  (i.e., if a phase is 15% of the cycle time, then
c	the g/puff for that phase is 15% of the actual g/puff, since
c	otherwise, we'll have to keep track of which phase contributed each
c	puff and weight at the end when getconc is called.
c
				xmass(npuff) = xmass(npuff)*phtime(iphase)/cydist
c
                   if (icycle .eq. 1 .and. itime .eq. 1) then
                      kpuff(iblock,iphase) = npuff
                   endif
  250           Continue
                endif
c		The 280/270 loops take the oldest puff of previously handled 
c		phases for each block, and clone them to get locations for
c		puffs of the previous cycle. 
c		When the second cycle starts, phase 1 has already been handled
c		for all phases, but phase 2 is missing its puff trajectories
c		for phase 1 meteorology, phase 3 is missing phases 1 and 2, etc.
                if (icycle .eq. 1) then
                   ips = 1
                   ipe = iphase - 1
                else
                   ips = iphase + 1
                   ipe = nphase
                endif
                   Do 280 jphase = ips, ipe
                      if (jphase .eq. iphase) go to 280
c		Clone the oldest puff so it gets moved at next timestep
                      Do 270 jblock = 1, nblock
                         ipuff = kpuff(jblock,jphase)
                         if (ipuff .eq. 0) go to 280
                         npuff = npuff + 1
                         if (npuff .gt. ij) then
                            write (*,*) 'Too many puffs ', npuff
                            stop
                         endif
                         xpuff(npuff) = xpuff(ipuff)
                         ypuff(npuff) = ypuff(ipuff)
                         ydist(npuff) = ydist(ipuff)
                         zdist(npuff) = zdist(ipuff)
c		Mass of every puff from a block during a phase is the same.
					   xmass(npuff) = xmass(ipuff)
                         idexpuff(npuff) = idexpuff(ipuff)
                         if (itime .eq. 1) then
                            jpuff(jblock,jphase) = npuff
                         endif
  270                 continue
  280              continue
  300        Continue
c		As we're starting a new phase, need to reset which puffs are the
c		'oldest' for each block for each phase that we're still working on.
c
             do 340 jphase=ips,ipe
                do 320 iblock=1, nblock
                   if (jpuff(iblock,jphase) .ne. 0)
     1                 kpuff(iblock,jphase) = jpuff(iblock,jphase)
  320           continue
  340        continue
c		Starting a new phase so keep puff numbering sequential and don't
c		move the 'archived' puffs
             mpuff = npuff + 1
  350     Continue
  400  Continue
       call pmax(ij,ydist,idexpuff)
       call idexcy(ij,xpuff,ypuff,ncycle)
       Do 420 i=1,nrecp
          grecp(i) = 0.0
  420  Continue
       dely = cydist * sqrt(uave*uave + vave*vave)
       deltau = -uave*cydist
       deltav = -vave*cydist
       xxx = 0.0

       Do 600 icycle=1,ncycle
             Do 500 ipuff=1,npuff
                if (xmass(ipuff) .le. 0.0) go to 500
                kstab = iabs(idexpuff(ipuff))/100
                if (.not. lxsprd) kstab = istabcl
                call xtosigy (ydist(ipuff),kstab,sigmay)
                kstab = iabs(idexpuff(ipuff))/100
                if (.not. lzsprd) kstab = istabcl
                call xtosigz (zdist(ipuff),kstab,krough,sigmaz)
                Do 450 irecp=1,nrecp
                   call getconc(xrecp(irecp),yrecp(irecp),sigmay,sigmaz
     1                         ,xpuff(ipuff),ypuff(ipuff),xmass(ipuff),
     2                          zrecp(irecp),zsource,xhgt,conc)
                   grecp(irecp) = grecp(irecp) + conc
  450           Continue
                ydist(ipuff) = ydist(ipuff) + dely
  500        Continue

          Do 570 irecp=1,nrecp
             xrecp(irecp) = xrecp(irecp) + deltau
             yrecp(irecp) = yrecp(irecp) + deltav
  570     Continue
           conc = grecp(1)*conv1
           write(*,*) 'Conc. = ',conc,' ppm',conc-xold
           xold = conc
  600  Continue
       id1 = 49

        call datetm(rdate,rtime,rcpu)

        return
        end
c

        Subroutine spread(istab1,istab2,yt,zt)
c        Subroutine spread(istab1,istab2,yt)
        include 'disp.inc'
        if (istab1 .eq. istab2) return
        if (istab1 .le. 2 .and. istab2 .le. 2) return
        if (istab1 .ge. 5 .and. istab2 .ge. 5) return
        istab2 = istab1
        if (lxsprd) then
           call xtosigy (yt,istab2,sigma)
           call sigytox (sigma,istab2,yt)
        endif
        if (lzsprd) then
           call xtosigz (zt,istab2,3,sigma)
           call sigztox (sigma,istab2,3,zt)
        endif
        return
        end


        Subroutine makepuff(xb,yb,em,tr,pt,ct,ip,sz0,
     1                      xp,yp,yt,zt,xm,idex,emfact,
c     1                      xp,yp,yt,xm,istab,ipp,emfact,
     2                      uroad,vroad,xkx,nxin,nyin,iphin)
c
        dimension xb(4),yb(4)
        dimension uroad(nxin,nyin,iphin),vroad(nxin,nyin,iphin)
        dimension xkx(nxin,nyin,iphin)
c                 This routine is not correct yet
c
        include 'winds.inc'
        include 'puffdata.inc'
           xp = (xb(1) + xb(2) + xb(3) + xb(4)) / 4.0
           yp = (yb(1) + yb(2) + yb(3) + yb(4)) / 4.0
           ix = int(xp/gridlen) + 1
           iy = int(yp/gridlen) + 1
        if (ip .gt. iphin .or. ix .gt. nxin .or. iy .gt. nyin) then
           stop
        endif
           d1 = sqrt((xb(1)-xb(2))*(xb(1)-xb(2)) +
     1               (yb(1)-yb(2))*(yb(1)-yb(2)))
           d2 = sqrt((xb(2)-xb(3))*(xb(2)-xb(3)) +
     1               (yb(2)-yb(3))*(yb(2)-yb(3)))
           d3 = sqrt((xb(3)-xb(4))*(xb(3)-xb(4)) +
     1               (yb(3)-yb(4))*(yb(3)-yb(4)))
           d4 = sqrt((xb(4)-xb(1))*(xb(4)-xb(1)) +
     1               (yb(4)-yb(1))*(yb(4)-yb(1)))
	         sigmay = amax1(d1,d2,d3,d4) / 4.0
           sigmaz = 3.0 / 2.0
           ustar = uroad(ix,iy,ip) * tr
           vstar = vroad(ix,iy,ip) * tr
           u = sqrt(ustar*ustar + vstar*vstar)
           ist = istabcl
  100      call sigytox(sigmay,ist,yt)
           call sigztox(sigmaz,ist,3,zt)
crgi
           t = 1.0
           if (u .gt. 0.0) t = yt / u
           call getstab(xkx(ix,iy,ip),u,t,istab)
           if (ist .eq. istab) go to 900
           ist = istab
           go to 100
  900   idex = ist*100 + ip
        return
        end


        Subroutine getconc(xr,yr,sigy,sigz,xp,yp,xm,zr,zs,xh,conc)
c
c       xr     = X coordinate of receptor
c       yr     = Y coordinate of receptor
c       sigy   = Sigma y for puff
c       sigz   = Sigma z for puff
c       xp     = X coordinate of puff
c       yp     = Y coordinate of puff
c       xm     = grams of CO in puff
c       zr     = source height (meters)
c       zs     = recpetor height (meters)
c       xh     = mixing heigth
c       conc   = returned concentration
c
        include 'winds.inc'
        include 'puffdata.inc'
        xp1 = xp - uave*istep
        yp1 = yp - vave*istep
        x1 = xr - xp
        y1 = yr - yp
        ds = (x1*x1 + y1*y1)
        call pfsamp(xp1,yp1,xp,yp,xr,yr,sigy,ds,xi1,xi2)
        dinv = 1.0 / (6.2831853 * sigy * sigy)
        f1 = vcoup(zr,zs,sigz,xh)
        conc = xm * xi1 * dinv * f1
        return
        end

c----------------------------------------------------------------------
      subroutine datetm(rdate,rtime,rcpu)
c----------------------------------------------------------------------
c
c
c --- PURPOSE:  Get system date and time from system clock
c
c --- INPUTS:  none
c
c --- OUTPUT:  rdate  -  C*8 - Current system date (MM-DD-YY)
c              rtime  -  C*8 - Current system time (HH:MM:SS)
c               rcpu  - real - CPU time (sec) from system utility
c
c --- DATETM called by:  SETUP
c --- DATETM calls:      DATE, TIME (Lahey compiler system utilities
c                        providing date and time)
c                        ETIME (SUN CPU utility program)
c----------------------------------------------------------------------
      character*11 stime
      character*8 rdate,rtime
c
c --- Get system date
      call date(rdate)
c
c --- Get system time -- note: system clock in HH:MM:SS.HH, where
c --- HH = hundredths of seconds
      call time(stime)
c
c --- Get CPU time from SUN system utility
c      call etime(rcpu)
c
c --- Extract HH:MM:SS portion of time
      do 10 i=1,8
      rtime(i:i)=stime(i:i)
10    continue
c
      return
      end
c
c
        Subroutine pmax(ij,ydist,idexpuff)
        dimension ydist(ij),idexpuff(ij)
        include 'puffdata.inc'
        puffmax = 0.0
        do 100 i=1,npuff
           kstab = iabs(idexpuff(i))/100
           call xtosigy(ydist(i),kstab,x)
           if (x .gt. puffmax) puffmax = x
  100   continue
        return
        end

c
c
        Subroutine xtosigy(yt,istab,sigmay)
        include 'winds.inc'
        dimension yfact(6)
        data yfact /0.32,0.32,0.22,0.16,0.11,0.11/
        if (istab .lt. 1 .or. istab .gt. 6) then
           return
        endif
        sigmay =  yfact(istab)*yt / sqrt(1.0 + 0.0004*yt)
        return
        end

c
c
        Subroutine sigytox(sigmay,istab,yt)
        include 'winds.inc'
        dimension yfact(6)
        data yfact /0.2048,0.2048,0.0968,0.0512,0.0242,0.0242/

        stemp = sigmay / yrough
        c = -(stemp * stemp)
        b = 0.0004 * c
        a2 = 2.0*yfact(istab)*yfact(istab)
        yt = (sqrt(b*b - 2.0*yfact(istab)*c) - b) / yfact(istab)

        return
        end


c
c
        Subroutine xtosigz(yt,istab,irough,sigmaz)
        dimension zfact1(6,3),zfact2(6,3)
        data zfact1 /
     1                0.102,0.062,0.043,0.029,0.017,0.009,
     2                0.140,0.080,0.056,0.038,0.023,0.012,
     3                0.190,0.110,0.077,0.050,0.031,0.017/
        data zfact2 /
     1               0.94,0.89,0.85,0.81,0.78,0.72,
     2               0.90,0.85,0.80,0.76,0.73,0.67,
     3               0.83,0.77,0.72,0.68,0.65,0.58/

        sigmaz =  1000.0 * (zfact1(istab,irough)*
     1            ((yt/1000.0) ** zfact2(istab,irough)))
        return
        end

c
c
        Subroutine sigztox(sigmaz,istab,irough,zt)
        dimension zfact1(6,3),zfact2(6,3)
        data zfact1 /
     1                0.102,0.062,0.043,0.029,0.017,0.009,
     2                0.140,0.080,0.056,0.038,0.023,0.012,
     3                0.190,0.110,0.077,0.050,0.031,0.017/
        data zfact2 /
     1               1.06383,1.12360,1.27647,1.23457,1.28205,1.38889,
     2               1.11111,1.27647,1.25000,1.32579,1.36896,1.49254,
     3               1.20482,1.29870,1.38889,1.47059,1.53846,1.72414/
        zt = 1000.0 * (((sigmaz/1000.0) / zfact1(istab,irough))
     1       ** zfact2(istab,irough))
        return
        end
c

        Subroutine getstab(tkx,u,t,istab)
c
c   Purpose:  Calculate stability class from Kx, U and t
c
c   Arguments:  tkx   = Diffusivity (m*m/sec)
c               u     = Wind speed (m/sec)
c               t     = time (seconds)
c               istab = Return value (1=A, 6=F)
c
c          
           include 'winds.inc'
c
c          Calculate sigma theta
c
           if (t .le. 0.0) then
              return
           endif
c           write (*,*) tkx,u,t,istab
           if (tkx .gt. 1.0) then
             xx = 0.0
           endif
crgi           sigmath = (sqrt(2.0*tkx)/u) * (sqrt(1.0/t) + 0.051961524)
crgi  modified per elc 3/00
           sigmath = sqrt(360.*tkx)/(u*t)*(1+0.9*sqrt(t/300.))
c
c  This expression is valid for travel times up to 550 seconds.
c  This assumes that the sigma and stability parameters are based
c  on 3-minute averaging period.  All units are the same as before:
c  tkx  m*m/s, t in seconds, and u in m/s. 
crgi
c
c          Now just a look up
c
           if (sigmath .lt. 0.066323) then
              istab = 6
           else if (sigmath .lt. 0.1309) then
              istab = 5
           else if (sigmath .lt. 0.21817) then
              istab = 4
           else if (sigmath .lt. 0.305433) then
              istab = 3
           else if (sigmath .lt. 0.3927) then
              istab = 2
           else 
              istab = 1
           endif
           if (istab .gt. istabcl) istab = istabcl
        return
        end

        Subroutine movepuff(xloc,yloc,yt,zt,us,vs,dtime)
c
c   Purpose:  Move the center of a puff using the ambient winds us,vs
c
c   Arguments:  xloc  = current X location of puff center (m)
c               yloc  = current Y location of puff center (m)
c               us    = U component of ambient winds  (m/sec)
c               vs    = V component of ambient winds  (m/sec)
c               dtime = length of phase in seconds
c
c          just move it
c
           xmove = us*dtime
           ymove = vs*dtime
           xloc = xloc + xmove
           yloc = yloc + ymove
           d = sqrt(xmove*xmove + ymove*ymove)
           yt = yt + d
           zt = zt + d
        return
        end
