c this routine will read all the information from the user input file
c into the data structures to be used throughout the program

       subroutine rdusrin(jerr)

       include 'disp.inc'
       include 'eparam.inc'
       include 'emiss.inc'
       include 'linkdata.inc'
	 include 'emspec.inc'
	 include 'weight.inc'
c
       character*80 msg,title
       real dumarr(10)
       integer idumarr(10)
       character*20 cdum
       character*40 varname
       character*1 cdumarr(10),cvalue
 

c -------------------------------------------------------------

      jerr = ISUCES
c

c
        open (unit=IUSRIN,file=USRINFL)
        write (*,*) 'HYROAD Version 1.10 Feb 2002 for MOBILE5 or 6'
	  write (*,*) 'Concentrations provided using puff module only'
        write (88,*)'HYROAD Version 1.10 Feb 2002 for MOBILE5 or 6'
	  write (88,*) 'Concentrations provided using puff module only'
c
c Read in the title  
c
       call fndkey(ierr,IUSRIN,'/TITLE/             ')
       if (ierr .eq. ISUCES) then
          read(IUSRIN,8008) title
          write (*,*) title
          write (88,*) title
       endif


c
c next we need to read the files to read for emissions and 
c emission factors
c
       call fndkey(ierr,IUSRIN,'/FILES/             ')
       if (ierr .ne. ISUCES) then
          msg = 'could not find /FILES/ packet in input file'
          goto 9999
       endif
       read(IUSRIN,8008) lu92fl
       read(IUSRIN,8008) efmdl
	 call lftjst (efmdl, 80)
	 call low2up (efmdl, 80)
	 nefspd = 0
	 if (efmdl(1:7) .eq. 'MOBILE6') nefspd = 8
	 if (efmdl(1:7) .eq. 'MOBILE5') nefspd = 7
	 if (nefspd .eq. 0) then
	    msg = 'Unrecognized emission factor model'
	    goto 9999
	 endif
c
c     Fill data arrays as appropriate to the speed cycles from
c     MOBILE5 or MOBILE6
c
c     MOBILE5
       if (nefspd .eq. 7) then
	   do 5 i=1,nefspd-1
	      TIDLE(i) = TIDLM5(i)
	      VMTCYC(i) = VMTCM5(i)
	      do 5 j=1,13
	         CYCS(i,j) = CYCM5(i,j)
    5  continue
       endif
c
c     MOBILE6
       if (nefspd .eq. 8) then
	   do 6 i=1,nefspd-1
	      TIDLE(i) = TIDLM6(i)
	      VMTCYC(i) = VMTCM6(i)
	      do 6 j=1,13
	         CYCS(i,j) = CYCM6(i,j)
    6  continue
       endif

       read(IUSRIN,8008) effl
       write (*,*) 'FILES'
       write (*,*) 'Traffic file: ',lu92fl
	 write (*,*) 'Emission factor model: ',efmdl
       write (*,*) 'Emission factor file: ',effl
       write (88,*) 'FILES'
       write (88,*) 'Traffic file: ',lu92fl
       write (88,*) 'Emission factor model: ',efmdl
       write (88,*) 'Emission factor file: ',effl
       open (IOR92,file=lu92fl, form='unformatted',status='old')

       open(IOREF,file=effl) 
       read(IUSRIN,8000) numtime
	ldoit = .false.
	if (numtime .lt. 0) then
		numtime = - numtime
		ldoit = .true.
	endif
       read(IUSRIN,8000) numotim
       write (*,*) 'Number of time steps: ',numtime
       write (*,*) 'Number of time steps for average: ',numotim
       write (88,*) 'Number of time steps: ',numtime
       write (88,*) 'Number of time steps for average: ',numotim

c
c next we need to read in the receptor information
c
       call fndkey(ierr,IUSRIN,'/RECEPTOR DATA/     ')
       if (ierr .ne. ISUCES) then
          msg = 'could not find /RECEPTOR DATA/ packet in input file'
          goto 9999
       endif
       read(IUSRIN,8000) numrec
       write (*,*) 'RECEPTOR DATA'
       write (*,*) 'Number of receptors: ',numrec
       write (88,*) 'RECEPTOR DATA'
       write (88,*) 'Number of receptors: ',numrec
       if (numrec .gt. MXREC) then
          msg = 'too many receptors numrec > MXREC'
          goto 9999
       endif
       do 8 iloop = 1,numrec
        read(IUSRIN,8004)
     &        recnam(iloop),
     & recloc(1,iloop),recloc(2,iloop),recloc(3,iloop)
       write (*,*) recnam(iloop)
       write (*,*) (recloc(i,iloop),i=1,3)
       write (88,*) recnam(iloop)
       write (88,*) (recloc(i,iloop),i=1,3)
 8     continue


c
c now we need to read in the deposition information 
c
       call fndkey(ierr,IUSRIN,'/DEPOSITION DATA/   ')
       if (ierr .ne. ISUCES) then
        msg = 'could not find /DEPOSITION DATA/ packet in input file'
          goto 9999
       endif
       write (*,*) 'DEPOSITION DATA'
       write (88,*) 'DEPOSITION DATA'
       read(IUSRIN,8005) sfcrgh
       read(IUSRIN,8005) setvel
       read(IUSRIN,8005) depvel
       write (*,*) 'Surface roughness: ',sfcrgh
       write (*,*) 'Settling velocity: ', setvel
       write (*,*) 'Deposition velocity: ', depvel
       write (88,*) 'Surface roughness: ',sfcrgh
       write (88,*) 'Settling velocity: ', setvel
       write (88,*) 'Deposition velocity: ', depvel

c
c check if the user wants to use defaults
c
       if (sfcrgh .lt. 0) sfcrgh = DFSFCRF
       if (setvel .lt. 0) setvel = DFSETVEL
       if (depvel .lt. 0) depvel = DFDEPVEL
       

c
c first we need to read in the link definition stuff
c
c a link is a straight portion of road
c
       call fndkey(ierr,IUSRIN,'/LINK DEFINITION/   ')
       if (ierr .ne. ISUCES) then
        msg = 'could not find /LINK DEFINITION/ packet in input file'
          goto 9999
       endif
       write (*,*) 'LINK DEFINITION'
       write (88,*) 'LINK DEFINITION'

       read(IUSRIN,8009) wslow, wshigh, wsmin
crgi -- hardwire minimum windspeed and set counter
		wsmin = 0.3
		kwsmin = 0
       write (*,*) 'Wind speed cutoffs: ',wslow,wshigh,wsmin
       write (88,*) 'Wind speed cutoffs: ',wslow,wshigh,wsmin
	write (*,*) 'Min wind speed reset to 0.3 m/s.  Counting . . .'
	write (88,*) 'Min wind speed reset to 0.3 m/s.  Counting . . .'

       read(IUSRIN,8011) lxsprd,lzsprd
       write (*,*) 'Difusion flags: ',lxsprd,lzsprd
       write (88,*) 'Difusion flags: ',lxsprd,lzsprd

       read(IUSRIN,8000) numtime
       write (*,*) 'Number of time periods: ',numtime
       write (88,*) 'Number of time periods: ',numtime
       if (numtime .gt. MXTM) then
         msg = 'too many time blocks read in : numtime > MXTM'
         goto 9999
       endif

       read(IUSRIN,8000) istime
       write (*,*) 'Start time: ', istime
       write (88,*) 'Start time: ', istime
       if (istime .lt. 0 .or. istime .gt. 2400) then
         msg = 'Start time out of range'
         goto 9999
       endif

       read(IUSRIN,8000) numlnks
       write (*,*) 'Number of links: ',numlnks
       write (88,*) 'Number of links: ',numlnks
       if (numlnks .gt. MXLNKS) then
         msg = 'number of links exceeds MXLNKS'
         goto 9999
       endif


       do 10 iloop = 1,numlnks
       read(IUSRIN,8001)   idx,rdum1,rdum2,
     &   rdum3,rdum4,idum1,idum2,idum3,
     &   rdum5,rdum6,idum4
         write (*,*) idx,rdum1,rdum2,rdum3,rdum4,idum1,idum2,idum3,
     &   rdum5,rdum6,idum4
         write (88,*) idx,rdum1,rdum2,rdum3,rdum4,idum1,idum2,idum3,
     &   rdum5,rdum6,idum4

         rnod1(1,idx)=rdum1
         rnod1(2,idx)=rdum2
         rnod2(1,idx)=rdum3
         rnod2(2,idx)=rdum4
         numblks(idx) = idum1
         numlans(idx) = idum2
         rlenblk(idx) = idum3
         lnkhgt(idx)= rdum5
         mixznwd(idx)= rdum6
         ivol(idx)= idum4

c         print*, 'idx and numlan ',idx,idum2


c
c do some qa checks
c
         
         if (idx .ne. iloop) then
           msg = 'link index entered out of order'
           varname = 'current link index (idx)'
           value = idx
           idxbad = idx
           goto 9998
         endif

          dfmix = (numlans(idx) * DFLANWID) + 6.0

          if (mixznwd(idx).lt. 0 ) then
            mixznwd(idx) = dfmix
          endif

          if (mixznwd(idx).lt. dfmix) then
           msg = 'mixing width is too small'
           varname = 'mixing width (mixznwd)'
           value = rdum6
           idxbad = idx
           goto 9998
         endif



         dist=((rdum1-rdum3)**2 + (rdum2-rdum4)**2)**0.5
         if (abs(dist-(float(idum1)*float(idum3))).gt.1.0) then
           msg = 'link distance inconsistent with #blks and lenblks'
           varname = 'link index (idx)'
           value = idx   
           idxbad = idx
           goto 9998
         endif

         if (idum2 .le.0 .or. idum2 .gt. MXLANE) then
           msg = 'number of lanes is 0 or exceeds MXLANE parameter'
           varname = 'current link (idx)'
           value = idx   
           idxbad = idx
           goto 9998
         endif

         if (idum1 .le.0 .or. idum1 .gt. MXBLKS) then
           msg = 'number of blocks is 0 or exceeds MXBLKS parameter'
           varname = 'current link (idx)'
           value = idx   
           idxbad = idx
           goto 9998
         endif

         if (rdum6 .lt. MNMIX .or. rdum6 .gt. MXMIX) then
           msg = 'Invalid value for mixing zone width'
           varname = 'mixing zone width'
           value = rdum6
           idxbad = idx
           goto 9998
         endif

         if (idum4 .gt. MXVOL) then
           msg = 'Invalid value for traffic volume'
           varname = 'hourly traffic volume on link'
           value = idum4
           idxbad = idx
           goto 9998
         endif

c

 10    continue


c
c now we need to read in the met information
c

c
c figure out how many of the met records we have to read
c
       if (mod(numtime,10) .eq. 0) then 
         iread = numtime / 10
       else
         iread = (numtime / 10) + 1
       endif

       call fndkey(ierr,IUSRIN,'/MET DATA/          ')
       if (ierr .ne. ISUCES) then
          msg = 'could not find /MET DATA/ packet in input file'
          goto 9999
       endif
       write (*,*) 'MET DATA'
       write (88,*) 'MET DATA'
       read(IUSRIN,8005) tmpht
       write (*,*) 'Height of met instument: ',tmpht


         if (tmpht .lt. MNHT) then
           msg = 'met height is less than minimum MNHT'
           varname = 'height of met reading (tmpht)'
           value = tmpht
           idxbad = -9
           goto 9998
         endif

         if (tmpht .gt. MXHT) then
           msg = 'met height is greater than maximum MXHT'
           varname = 'height of lower met reading (tmpht)'
           value = tmpht
           idxbad = -9
           goto 9998
         endif


c
c take care of the wind speed
c
       do 300 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 301 kloop=1,iget
            if (dumarr(kloop) .lt. wsmin) then
			 dumarr(kloop) = wsmin
			 kwsmin = kwsmin + 1
		  endif
            ws(((jloop-1)*10)+kloop) = dumarr(kloop)

         if (dumarr(kloop).gt. MXWS) then
           msg = 'encountered wind speed exceeding maximum'
           varname = 'value of wind speed encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

 301       continue
 300    continue
        write (*,*) 'Wind speeds: ',(ws(i),i=1,numtime)
        write (88,*) 'Wind speeds: ',(ws(i),i=1,numtime)
	  write (*,*) '*** Min windspeed invoked ', kwsmin, 'times !'
	  write (88,*) '*** Min windspeed invoked ', kwsmin, 'times !'

c
c take care of the wind direction
c
       do 320 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 321 kloop=1,iget
            wd(((jloop-1)*10)+kloop) = dumarr(kloop)

         if (dumarr(kloop).lt. 0. .or. dumarr(kloop).gt.360.) then
           msg = 'invalid wind direction encountered'
           varname = 'value of wind direction encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

 321       continue
 320    continue
        write (*,*) 'Wind directions: ',(wd(i),i=1,numtime)
        write (88,*) 'Wind directions: ',(wd(i),i=1,numtime)

c
c take care of the sigtheta of wind direction
c
       do 340 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 341 kloop=1,iget
            sgth(((jloop-1)*10)+kloop) = dumarr(kloop)

         if ( dumarr(kloop).le.0.) then
            sgth(((jloop-1)*10)+kloop) = 
     &      (0.25/ws(((jloop-1)*10)+kloop))*57.3 
         endif

         if ( dumarr(kloop).gt.360.) then
           msg = 'invalid sigtheta of wind direction '
           varname = 'value of sigtheta encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

 341       continue
 340    continue
        write (*,*) 'Sigma WD: ',(sgth(i),i=1,numtime)
        write (88,*) 'Sigma WD: ',(sgth(i),i=1,numtime)

c
c take care of the stability class
c
       do 360 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8006) (idumarr(i),i=1,iget)
          do 361 kloop=1,iget
           stabcls(((jloop-1)*10)+kloop) = idumarr(kloop)


         if (idumarr(kloop).lt. 1 .and.
     &        idumarr(kloop).gt. 6 ) then
           msg = 'invalid value for stability class'
           varname = 'value of stability class encountered'
           value = float(idumarr(kloop))
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif


 361       continue
 360    continue
        write (*,*) 'Stability class: ',(stabcls(i),i=1,numtime)
        write (88,*) 'Stability classs: ',(stabcls(i),i=1,numtime)


c
c take care of the mixing height 
c
       do 370 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 371 kloop=1,iget
           mixhgt(((jloop-1)*10)+kloop) = dumarr(kloop)

         if ( dumarr(kloop).lt.0.) then
            mixhgt(((jloop-1)*10)+kloop) = DFMIXHT
         endif

         if (dumarr(kloop).lt. MNMXHT) then
           msg = 'mixing height less than minimum'
           varname = 'value of mixing height encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

         if (dumarr(kloop).gt. MXMXHT) then
           msg = 'mixing height greater than maximum'
           varname = 'value of mixing height encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif


 371       continue
 370    continue
        write (*,*) 'Mixing height: ',(mixhgt(i),i=1,numtime)
        write (88,*) 'Mixing height: ',(mixhgt(i),i=1,numtime)

c
c take care of the ambient concentration
c
       do 380 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 381 kloop=1,iget
           ambconc(((jloop-1)*10)+kloop) = dumarr(kloop)

         if ( dumarr(kloop).lt.0.) then
            ambconc(((jloop-1)*10)+kloop) = DFAMBCNC
         endif

         if (dumarr(kloop).gt. MXCONC) then
           msg = 'ambient concentration greater than maximum'
           varname = 'value of ambient concentration encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

 381       continue
 380    continue
        write (*,*) 'Ambient conc.: ',(ambconc(i),i=1,numtime)
        write (88,*) 'Ambient conc.: ',(ambconc(i),i=1,numtime)


c
c take care of the temperature in degrees C
c
       do 400 jloop = 1,iread
          iget = min(10,numtime-((jloop-1)*10))
          read(IUSRIN,8005) (dumarr(i),i=1,iget)
          do 401 kloop=1,iget
           temper(((jloop-1)*10)+kloop) = dumarr(kloop)

         if (dumarr(kloop).lt.MNTEMP.or.dumarr(kloop).gt.MXTEMP) then
           msg = 'invalid ambient upper temperature encountered'
           varname = 'value of ambient temperature encountered'
           value = dumarr(kloop)
           idxbad = (jloop-1)*10 + kloop
           goto 9998
         endif

 401       continue
 400    continue
        write (*,*) 'Temperatures: ',(temper(i),i=1,numtime)
        write (88,*) 'Temperatures: ',(temper(i),i=1,numtime)

c
c now we need to read in the lane information
c

       call fndkey(ierr,IUSRIN,'/LANE DATA/         ')
       if (ierr .ne. ISUCES) then
          msg = 'could not find /LANE DATA/ packet in input file'
          goto 9999
       endif
       write (*,*) 'LANE DATA'
       write (88,*) 'LANE DATA'
       read(IUSRIN,8005) widlane
       write (*,*) 'Lane width: ',widlane
       write (88,*) 'Lane width: ',widlane

       read(IUSRIN,8000) napp
       write (*,*) 'Number of approaches: ',napp
       write (88,*) 'Number of approaches: ',napp


         if (napp .gt. MXIA) then
           msg = 'number of approaches is greater than MXAPP'
           varname = 'number of approaches (NAPP)'
           value = napp
           idxbad = -9
           goto 9998
         endif

       if (mod(napp,10) .eq. 0) then 
         iread = napp / 10
       else
         iread = (napp / 10) + 1
       endif

c
c take care of the approach directions
c
       do 500 jloop = 1,iread
          iget = min(10,napp-((jloop-1)*10))
          read(IUSRIN,8006) (idumarr(i),i=1,iget)
          do 501 kloop=1,iget
             if (idumarr(kloop) .eq. 0) then
                lsouth(((jloop-1)*10)+kloop) = .false.
             else
                lsouth(((jloop-1)*10)+kloop) = .true.
             endif
 501       continue
 500    continue
        write (*,*) 'Approach directions: ',(lsouth(i),i=1,napp)
        write (88,*) 'Approach directions: ',(lsouth(i),i=1,napp)


c
c take care of the number of segments per approach 
c
       do 510 jloop = 1,iread
          iget = min(10,napp-((jloop-1)*10))
          read(IUSRIN,8006) (idumarr(i),i=1,iget)
          do 511 kloop=1,iget
             nseg(((jloop-1)*10)+kloop) = idumarr(kloop)
 511       continue
 510    continue

        write (*,*) 'Segments / Approach: ',(nseg(i),i=1,napp)
        write (88,*) 'Segments / Approach: ',(nseg(i),i=1,napp)

c
c take care of the segment end points  
c
       do 530 jloop = 1,napp
          read(IUSRIN,8009) (seglen(i,jloop),i=1,MXSEG)
        write (*,*) 'Segment #',jloop
        write (88,*) 'Segment #',jloop
        write (*,*) 'Segment end points: ',(seglen(i,jloop),i=1,MXSEG)
        write (88,*) 'Segment end points: ',(seglen(i,jloop),i=1,MXSEG)
 530   continue

c
c take care of the lanes per segment 
c
       do 540 jloop = 1,napp
          read(IUSRIN,8006) (nlane(i,jloop),i=1,MXSEG)
        write (*,*) 'Segment #',jloop
        write (88,*) 'Segment #',jloop
        write (*,*) 'Lanes / Segment: ',(nlane(i,jloop),i=1,MXSEG)
        write (88,*) 'Lanes / Segment: ',(nlane(i,jloop),i=1,MXSEG)
 540   continue

c
c take care of the median width for each segment 
c
       do 550 jloop = 1,napp
          read(IUSRIN,8009) (xmedian(i,jloop),i=1,MXSEG)
        write (*,*) 'Segment #',jloop
        write (88,*) 'Segment #',jloop
        write (*,*) 'Median widths: ',(xmedian(i,jloop),i=1,MXSEG)
        write (88,*) 'Median widths: ',(xmedian(i,jloop),i=1,MXSEG)
 550   continue

c
c take care of the segment centers 
c
       do 560 jloop = 1,napp
          read(IUSRIN,8009)(xcenter(i,jloop),ycenter(i,jloop),i=1,MXSEG)
        write (*,*) 'Segment #',jloop
        write (88,*) 'Segment #',jloop
        write (*,*) 'Coor.: ',
     1   (xcenter(i,jloop),ycenter(i,jloop),i=1,MXSEG)
        write (88,*) 'Coor.: ',
     1   (xcenter(i,jloop),ycenter(i,jloop),i=1,MXSEG)
 560   continue

c
c take care of the segments offset in the X direction
c
       do 570 jloop = 1,iread
          iget = min(10,napp-((jloop-1)*10))
          read(IUSRIN,8009) (dumarr(i),i=1,iget)
          do 571 kloop=1,iget
             deltax(((jloop-1)*10)+kloop) = dumarr(kloop)
 571       continue
 570    continue
        write (*,*) 'X offsets: ',(deltax(i),i=1,napp)
        write (88,*) 'X offsets: ',(deltax(i),i=1,napp)

c
c take care of the segments offset in the Y direction
c
       do 580 jloop = 1,iread
          iget = min(10,napp-((jloop-1)*10))
          read(IUSRIN,8009) (dumarr(i),i=1,iget)
          do 581 kloop=1,iget
             deltay(((jloop-1)*10)+kloop) = dumarr(kloop)
 581       continue
 580    continue
        write (*,*) 'Y offsets: ',(deltay(i),i=1,napp)
        write (88,*) 'Y offsets: ',(deltay(i),i=1,napp)

       read(IUSRIN,8000) nphase
       write (*,*) 'Number of phases: ',nphase
       write (88,*) 'Number of phases: ',nphase

         if (nphase .gt. MXFZ) then
           msg = 'number of phases is greater than MXFZ'
           varname = 'number of phases (NPHASE)'
           value = nphase
           idxbad = -9
           goto 9998
         endif

       if (mod(nphase,10) .eq. 0) then 
         iread = nphase / 10
       else
         iread = (nphase / 10) + 1
       endif

c
c take care of the phase times
c
       do 590 jloop = 1,iread
          iget = min(10,nphase-((jloop-1)*10))
          read(IUSRIN,8010) (idumarr(i),i=1,iget)
          do 591 kloop=1,iget
             phtime(((jloop-1)*10)+kloop) = idumarr(kloop)
 591       continue
 590    continue
        write (*,*) 'Phase times: ',(phtime(i),i=1,nphase)
        write (88,*) 'Phase times: ',(phtime(i),i=1,nphase)

       read(IUSRIN,8009) tstep
       write (*,*) 'Time step: ', tstep
       write (88,*) 'Time step: ', tstep


c -----------------------------------------------------------
c formats

 8000  format(25x,i4)
 8001  format(25x,i4,1x,4f10.0,1x,i4,1x,i4,1x,i4,1x,2f5.0,1x,i5)
 8002  format(25x,i4)
 8003  format(25x,10f7.2)
 8004  format(25x,a20,3f10.0)
 8005  format(25x,10f6.0)
 8006  format(25x,10i2)
 8007  format(25x,f5.0,1x,f5.0,1x,f5.0,1x,f5.0,1x,2i6,1x
     &  f5.0,1x,f5.0,1x,f5.0,1x,f5.0)
 8008  format(25x,a80)
 8009  format(25x,10f7.0)
 8010  format(25x,10i7)
 8011  format(25x,2l7)


 9001  continue
c       write(*,'(a,i4)') 'Number of Time periods read: ',itim-1
       goto 8888

 9998  continue
       jerr=IFAIL
       write(*,*) 'ERROR in routine: rdusrin.f '
       write(*,*) 'problem is: ',msg
       write(*,*) 'offending variable : ',varname
       write(*,*) 'offending value is : ',value
       write(*,*) 'index of  value is : ',idxbad
       goto 8888

 9999  continue
       write(*,*) 'ERROR in routine: rdusrin.f '
       write(*,*) 'problem is: ',msg

 8888  continue
       return
       end
