      Subroutine rwmain (ihr,ctot)
      Parameter (MAXXY = 250)
      include 'winds.inc'
      include 'puffdata.inc'
      include 'disp.inc'
      include 'emiss.inc'
      include 'linkdata.inc'
      include 'receptor.inc'

      real*4 ctot(MXREC)
      DIMENSION DU(28,8), DV(28,8)
      DIMENSION dxp(28,8), dzp(28,8)
      REAL NVEH,NVEH1,MEDN                         
      character*80 oname,cname
      dimension uroad(:,:,:),vroad(:,:,:),xkx(:,:,:),zp(:,:)
      allocatable :: uroad,vroad,xkx,zp

      COMMON /INCOM/
     1               MEDN,NVEH,NVEH1,      
     2               RDANGL,T1,T2,VHGH,VWID,VSPD,VSPD1,WDIR,WIDL,WSPD,  
     3               Z0,Z1,Z2,klane,stab

       character*8 rdate,rtime
       gridlen = 10.0
       nxgrid = 250
       nygrid = 250
       vhgh = 1.4
       vwid = 1.8
       t1 =temper(ihr)
       wdir1 = wd(ihr)
c	Don't trust anybody....
	 wdir1 = mod (wdir1,360.)
	 if (wdir1 .lt. 0.) wdir1 = wdir1 + 360.
       wspd =ws(ihr)
       z0 = sfcrgh
       if (z0 .lt. 0.05) then
          krough = 1
          yrough = 0.40
       else if (z0 .lt. 0.5) then
          krough = 2
          yrough = 0.63
       else
          krough = 3
          yrough = 1.0
       endif
       z1 = tmpht
       stab = stabcls(ihr)
       mxphase = nphase
       istabcl = stab
       wd1 = 270 - wdir1
crgi vehspd is km/hr, not mph       wspdt = wspd * 2.23694 * vspdmin
       wspdt = wspd *  vspdmin *3.6
       if (wd1 .lt. 0.0) wd1 = wd1 + 360
       pifact = 3.14159265 / 180.0
       uave = wspd * cos(wd1*pifact)
       vave = wspd * sin(wd1*pifact)
        allocate (uroad(nxgrid,nygrid,mxphase),STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        allocate (vroad(nxgrid,nygrid,mxphase),STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        allocate (xkx(nxgrid,nygrid,mxphase),STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        allocate (zp(nxgrid,nygrid),STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif

       kkk = 0
       Do 900 iphase=1, mxphase
       Do 200 j=1, nygrid
          Do 100 i=1, nxgrid
             uroad(i,j,iphase) = uave
             vroad(i,j,iphase) = vave
             xkx(i,j,iphase) = 0.0
             zp(i,j) = 0.0
  100     continue
  200  continue
crgi - Identify wind case (easterly or westerly) and get slope for finding
c	feasible impact range in deltaw, which now needs slpw and lwcase.
c	Do not allow infinite slope (0 or 180 wd).
	lwcase = 0
	if(((wdir1.ge.0.).and.(wdir1.le.1.)).or.(wdir1.eq.360.))then
	lwcase = 1
	slpw = 9999.
	endif
	if ((wdir1 .ge. 180.).and.(wdir1 .le. 181.)) then
	lwcase = 2
	slpw = -9999.
	endif
	if (lwcase .eq. 0) then
	slpw = tan ((90. - wdir1) * pifact)
	if (wdir1 .lt. 180.) lwcase = 1
	if (wdir1 .gt. 180.) lwcase = 2
	endif
	if (slpw .gt. 9999.) slpw = 9999.
	if (slpw .lt. -9999.) slpw = -9999
c
c	Here's the loop through all of the blocks with volume for this phase
       Do 800 ilink=1, nlink(iphase)
	 if (ilink .eq. 1) ifirst = 1
       vspd = avspd(ilink,iphase)
       vspd1 = avspd1(ilink,iphase)
       if (vspd .lt. wspdt .and. vspd1 .le. wspdt) go to 800
       xs = axs(ilink,iphase)
       ys = ays(ilink,iphase)
       xe = axe(ilink,iphase)
       ye = aye(ilink,iphase)
       klane = inlane(ilink,iphase)
       widl = awidl(ilink,iphase)
       medn = amedn(ilink,iphase)
       nveh = inveh(ilink,iphase)
       nveh1 = inveh1(ilink,iphase)
       wdir = wdir1
crgi - wdir needs to be reset before going into a new block
c		in case it was bumped 0.01 deg in ROADWAY to
c		avoid zerodivides in slope calculations
	 rmedn = medn/2.
crgi	Up to here nveh is inbound traffic; nveh1 outbound traffic
crgi	From here on, nveh is "southbound" per ROADWAY conventions
c
	 lswap = 0
c	due E-W
	 if (ye .eq. ys) then
		rdangl = -89.9
		if (xe .lt. xs) lswap = 1
		goto 240
	 endif
c	due N-S
	 if (xe .eq. xs) then
		rdangl = 0.
		if (ye .le. ys) lswap = 1
		goto 240
	 endif
c	If here, need to calculate angle and rotate it so NS is zero:
	rdangl = (atan ((ys - ye) / (xs - xe))) / pifact
	rdangl = rdangl - 90.
c	watch numerics and get within acceptable range
	if (rdangl .le. -90.) rdangl = rdangl + 180.
	if (rdangl .gt. 89.9) rdangl = 89.9	
	if (rdangl .lt. -89.9) rdangl = -89.9
crgi
	 if (ye .gt. ys) goto 240
crgi
	 lswap = 1
  240	 if (lswap .eq. 1) then
c	do the swap
		 ntemp = nveh
		 nveh = nveh1
		 nveh1 = ntemp
	 endif
c
       Do 700 j=1, 8
          Do 600 i=1, 28
             du(i,j) = 0.0
             dv(i,j) = 0.0
             dxp(i,j) = 0.0
             dzp(i,j) = 0.0
  600     continue
  700  continue

       call roadway (du,dv,xkx(1,1,iphase),zp,ifirst)
crgi -- the following du/dv adjustments are a kluge pending resolving anomaly in ROADWAY.
c	Near-road-axis winds cause algorithm breakdown in roadway, with induced flow velocity
c	greater than vehicle velocity.  We cap this at 90% of vehicle velocity, using a
c	common scaling factor applied at each roadway gridpoint.
c	Veh spd here is km/hr, and du-dv in m/s. 
c	Deltaw uses only level 2 so that's all we check and tweak.
c
	vtest = 0.9 * vspd/3.6
	vtemp = 0.
	do 701 i=1,28	
		vtemp2 = du(i,2)*du(i,2) + dv(i,2)*dv(i,2)
		if (vtemp2 .gt. vtemp) vtemp = vtemp2
  701 continue
	vtemp = sqrt(vtemp)
	if (vtemp .gt. vtest) then
		vtemp = vtest / vtemp
		do 702 i = 1,28
			du(i,2) = du(i,2) * vtemp
			dv(i,2) = dv(i,2) * vtemp
  702		continue
	endif
crgi
	 ifirst = 0

	mlane = klane/2
      call deltaw (du,dv,xs,ys,xe,ye,mlane,widl,rmedn,nveh,nveh1,
     1              wdir1,slpw,lwcase,nxgrid,
     2              nygrid,gridlen,uroad(1,1,iphase),vroad(1,1,iphase),
     3              xkx(1,1,iphase),zp,rdangl)
  800  continue
crgi
c
c
  900  continue

       write (*,*) 'Calling puffer'

       call puffer(uroad,vroad,xkx,nxgrid,nygrid,mxphase,ihr)
 
        deallocate (uroad,STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        deallocate (vroad,STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        deallocate (xkx,STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
        deallocate (zp,STAT=IERR_ALLOC)
        if (IERR_ALLOC .ne. 0) Then
           write (*,*) 'Dimensions too big'
           stop
        endif
       do 950 i=1,nrecp
          ctot(i) = grecp(i) * conv1
  950  continue
       return
       end

      subroutine deltaw(du,dv,xstart,ystart,xend,yend,mlane,
     1              widl,rmedn,nveh,nveh1,
     2              wd,slpw,lwcase,maxx,maxy,cellwid,u,v,xp,zp,rdangl)
C                                                                       
C        PARAMETER LIST:                                               
C          INPUT:   DU     - Delta winds in the x direction
C                   DV     - Delta winds in the y direction
C                   DXP    - Turbulance in the v direction
C                   DZP    - Turbulance winds in the z direction
C                   XSTART - X grid coordinate of start of link
C                   YSTART - Y grid coordinate of start of link
C                   XEND   - X grid coordinate of end of link
C                   YEND   - Y grid coordinate of end of link
c                   mlane  - # of lanes (this direction)
c                   widl   - lane width
c                   rmedn  - 1/2 of median width (m)
c                   nveh   - NB volume (veh/hr)
c                   nveh1  - SB volume (veh/hr)
c                            Note: only one of nveh/nveh1 .ne. 0
C                   WD     - Wind direction
c				  SLPW   - Noninfinite slope of WD
c                   LWCASE - 1 if easterly or N, 2 if westerly or S
C                   MAXX   - Number of grid cells in the X direction
C                   MAXY   - Number of grid cells in the Y direction
C                   CELLWID- Width of cell in meters
C                   RDANGL - Road angle from north/south
C          OUTPUT:  U      - Gridded U component of winds             
C                   V      - Gridded V component of winds             
C                   XP     - Gridded X component of turbulance             
C                   ZP     - Gridded Z component of turbulance             
C
C        CALLING ROUTINE:
C          MAIN                                                        
C                                                                       
C        DESCRIPTION:                                                   
C          THIS MODULE takes the delta winds for a link and adds them
C          to the grid.
C
      dimension c1(28,8),c3(28,8),kx(8),kz(8),x(28),z(8),kxp(28,8),
     1          kzp(28,8),xx(28),dut(28),dvt(28)
      REAL KX,KXP,KZ,KZP,nveh,nveh1                               
      COMMON /CALCOM/C1,C3,KMAX,KX,KZ,X,Z,TMSTOP,NX,KXP,KZP           
      Parameter (MAXXY = 250)
      DIMENSION DU(28,8), DV(28,8), U(MAXXY,MAXXY), v(MAXXY,MAXXY)
      DIMENSION dxp(28,8), dzp(28,8), xp(MAXXY,MAXXY), zp(MAXXY,MAXXY)                   
       integer lwind,lcell
c
c      Translate the road from north-south to actual angle
c
       angle1 = rdangl * 0.017453292
       do 50 i=1,28
          if (dv(i,2) .ne. 0.0) then
             wst = sqrt(du(i,2)*du(i,2) + dv(i,2)*dv(i,2))
		else
			wst = du(i,2)
		endif
		if (du(i,2) .ne. 0.) then
             wdt = atan2(dv(i,2),du(i,2)) + angle1
          else
             wdt = angle1
          endif
          dut(i) = wst * cos(wdt)
          dvt(i) = wst * sin(wdt)
   50  continue
C
C      Localize mins and maxs for range checking
C
c       write (*,*) 'delave ', kxp(14,2), kxp(15,2)
       if (xstart .lt. xend) then
          xmin = xstart / 10.0
          xmax = xend / 10.0
       else
          xmin = xend / 10.0
          xmax = xstart / 10.0
       endif
       if (ystart .lt. yend) then
          ymin = ystart / 10.0
          ymax = yend / 10.0
       else
          ymin = yend / 10.0
          ymax = ystart / 10.0
       endif
C
crgi - Rewriting and bypassing the following, replacing with finding
c	a "feasible region" using linear programming convex region def'n
c	as derived from wind direction and block endpoints.  If wind
c	direction is within 10 degrees of block axis, then affected
c	"feasible" cells are those whose center fall in the region
c	normal to the block axis (admittedly a kluge, but otherwise,
c	would require merging large groups of upwind blocks to get
c	a single crosswind impact, and probably not bad, as for long
c	enough phase times, the volume and avg speeds on adjacent blocks
c	of a link should be similar).  The more usual case (wind more
c	than 10 degrees from axis) requires projecting wind axis lines
c	using slpw and endpoints of block to capture gridcell centers
c	within the feasible region.  Then necessary to calculate distance
c	to ROADWAY-defined x origin, and determine whether upwind or 
c	downwind.  Sorry, but this gets ugly.
c
c	First, classify wind case w.r.t. roadaxis (lrcase=0 means roadaxis)
c
	lrcase = 1
	slp = slpw
	wdtemp = rdangl + wd
	if (wdtemp .lt. 0.) wdtemp = wdtemp + 360.
	if (wdtemp .gt. 360.) wdtemp = wdtemp - 360.
	if (wdtemp .lt. 10.) lrcase = 0
	if ((wdtemp .ge. 170.).and.(wdtemp .le. 190.)) lrcase = 0
	if (wdtemp .ge. 350.) lrcase = 0
c	
c
	if (lrcase .eq. 1) then
		yints = (ystart - (slp * xstart))
		yinte = (yend - (slp * xend))

		if (yinte .gt. yints) then
			bupr = yinte
			blwr = yints
		else
			bupr = yints
			blwr = yinte
		endif

	endif
c

	if (lrcase .eq. 0) then
		if (rdangl .lt. -89.) slp = 9999.
		if (rdangl .gt. 89.) slp = -9999.
		if (rdangl .gt. 0.) lpcase = 2
		if (rdangl .le. 0.) lpcase = 1
		if (ystart .ne. yend) slp = (xstart - xend) / (yend - ystart)

		yints = (ystart - slp * xstart)
		yinte = (yend - slp * xend)

		if (yinte .gt. yints) then
			bupr = yinte
			blwr = yints
		else
			bupr = yints
			blwr = yinte
		endif
	endif
c

	if (xstart .ne. xend) then
		slpr = (yend - ystart) / (xend - xstart)
		br = yend - slpr * xstart
	endif
	if (ystart .ne. yend) slpp = (xstart - xend) / (yend - ystart)
c

crgi	Number of gridpoints determined by no. of lanes

c	pick the centerline index and shift x axis to an xx axis by 
c	setting xx=0. on the median centerline as calculated from the
c	lane centerline of the closest active lane.
c
      ioff = mlane + 6
	if (x(2) .eq. 25.) ioff = ioff + 1
	if (x(2) .eq. 30.) ioff = ioff + 2
	if (rmedn .ge. widl/2.) then
		xioff = x(ioff)
	else
		if (nveh .gt. 0.) xioff = x(ioff - 2) + (widl/2. + rmedn)
		if (nveh1 .gt. 0.) xioff = x(ioff + 2) - (rmedn + widl/2.)
	endif
c
	do 106 i = 1, nx
		xx(i) = x(i) - xioff
  106 continue
c
	do 600 j=1,maxy
C
C         Get the y center of the cell in meters
C
          if (j .eq. 201) then
              kkk =  j
          endif
          yc = (j - 0.5) * 10.


          do 500 i=1,maxx
             if (i .eq. 122) then
                kkk = i
             endif
C
C            Find the x center of the cell in meters
C
             xc = (i - 0.5) * 10.
C
crgi
c
	yt = slp * xc + blwr
	if (yc .lt. yt) goto 500
	yt = slp * xc + bupr
	if (yc .ge. yt) goto 500
c
c	DIST is the distance from  a line defined by the block axis along
c	a line normal to the axis through a point (x,y).
c
	dist = -1.
	if (xstart .eq. xend) dist = abs (xc - xstart)
	if (ystart .eq. yend) dist = abs (yc - ystart)
	if (dist .ge. 0.) goto 300
c

	bp = yc - slpp * xc
	xstar = (bp - br)/(slpr - slpp)
	ystar = slpr * xstar + br
	dist = sqrt((xc-xstar)*(xc-xstar) + (yc-ystar)*(yc-ystar))	
c

c
  300 lwest = -1

	if (rdangl .lt. 0.) then
		ytest = xc * slpr + br
		if (ytest .lt. yc) lwest = 1

	endif
	if (rdangl .gt. 0.) then
		ytest = xc * slpr + br
		if (ytest .gt. yc) lwest = 1
	endif
	if ((rdangl .eq. 0.) .and. (xc .le. xstart)) lwest = 1
c

	if (lwest .eq. 1) dist = -dist
c

c
	if ((dist .lt. xx(1)) .or. (dist .gt. xx(nx))) goto 500
	do 310 ix=1,nx-1

		if (xx(ix+1) .le. dist) goto 310

		icurr = ix
		goto 315
  310 continue

	fact2 = 1.0
	icurr = nx - 1
	goto 320
  315 fact2 = (xx(icurr+1) - dist) / (xx(icurr+1) - xx(icurr))		
  320 fact1 = 1. - fact2

	u(i,j) = u(i,j) + fact1 * dut(icurr) + fact2 * dut(icurr+1)
      v(i,j) = v(i,j) + fact1 * dvt(icurr) + fact2 * dvt(icurr+1)
      xp(i,j) = xp(i,j) + fact1*kxp(icurr,2) + fact2*kxp(icurr+1,2)
      zp(i,j) = zp(i,j) + fact1*kzp(icurr,2) + fact2*kzp(icurr+1,2)
c	

  500    continue
  600 continue
      RETURN
      END
         SUBROUTINE ROADWAY (DU,DV,xp,zp,ifirst)
C                    ROADWAY - VERSION 2.0 (DATED 86010)                RWY00010
C                                                                       RWY00060
C                                                                       RWY00070
C * * *  PROGRAM ABSTRACT -- ROADWAY - VERSION 2.0 (DATED 86010)        RWY00080
C                                                                       RWY00090
C            ROADWAY IS A FINITE DIFFERENCE MODEL WHICH PREDICTS        RWY00100
C        POLLUTANT CONCENTRATIONS NEAR A ROADWAY.  THIS PROGRAM SHOULD  RWY00110
C        BE USED AS AN ADJUNCT TO THE STANDARD GAUSSIAN HIGHWAY MODELS  RWY00120
C        SINCE IT IS MORE EXPENSIVE TO RUN.                             RWY00130
C                                                                       RWY00140
C            THIS PROGRAM USES SURFACE LAYER SIMILARITY THEORY TO       RWY00150
C        PRODUCE VERTICAL WIND AND TURBULENCE PROFILES.  TEMPERATURES   RWY00160
C        AT TWO HEIGHTS AND WIND VELOCITY ARE REQUIRED.  THESE VALUES   RWY00170
C        ARE USUALLY OBTAINED FROM INSTRUMENTS LOCATED ON A TOWER       RWY00180
C        UPWIND OF THE ROADWAY.                                         RWY00190
C                                                                       RWY00200
C            ROADWAY IS UNIQUE IN THAT IT USES THE VEHICLE WAKE THEORY  RWY00210
C        DEVELOPED BY ESKRIDGE AND HUNT (1979) AND AS MODIFIED AND      RWY00220
C        VERIFIED BY ESKRIDGE AND THOMPSON (1982) USING WIND TUNNEL     RWY00230
C        EXPERIMENTS.  THIS THEORY PREDICTS THE VELOCITY AND TURBULENCE RWY00240
C        ALONG A HIGHWAY.                                               RWY00250
C                                                                       RWY00260
C                                                                       RWY00270
C * * *  REFERENCES                                                     RWY00280
C                                                                       RWY00290
C        ESKRIDGE, R. E. AND J. C. R. HUNT.  1979.  HIGHWAY MODELING.   RWY00300
C           PART I:  PREDICTION OF VELOCITY AND TURBULENCE FIELDS IN THERWY00310
C           WAKES OF VEHICLES.  J. APPL. METEOR. 18:  387.              RWY00320
C                                                                       RWY00330
C        ESKRIDGE, R. E., F. S. BINKOWSKI, J. C. R. HUNT, T. L. CLARK,  RWY00340
C           AND K. L. DEMERJIAN.  1979. HIGHWAY MODELING.  PART II:     RWY00350
C           ADVECTION AND DIFFUSION OF SF6 TRACER GAS.                  RWY00360
C           J. APPL. METEOR. 18: 401-412.                               RWY00370
C                                                                       RWY00380
C        ESKRIDGE, R. E. AND R. S. THOMPSON.  1982.  EXPERIMENTAL AND   RWY00390
C           THEORETICAL STUDY OF THE WAKE OF A BLOCK-SHAPED VEHICLE IN  RWY00400
C           A SHEAR-FREE BOUNDARY FLOW.  ATMOS. ENVIRON. 16:  2821.     RWY00410
C                                                                       RWY00420
C        ESKRIDGE, R. E. AND S. T. RAO.  1983.  MEASUREMENT AND PREDIC- RWY00430
C           TION OF TRAFFIC-INDUCED TURBULENCE FIELDS NEAR ROADWAYS.    RWY00440
C           J. APPL. METEOR. 22:  1431-1443.                            RWY00450
C                                                                       RWY00460
C                                                                       RWY00470
C * * *  PROGRAM WRITTEN AND SUPPORTED BY                               RWY00480
C                                                                       RWY00490
C        BERT ESKRIDGE                                                  RWY00500
C        DIVISION OF METEOROLOGY (MD-80)                                RWY00510
C        U. S. ENVIRONMENTAL PROTECTION AGENCY                          RWY00520
C        RESEARCH TRIANGLE PARK, NC  27711                              RWY00530
C        PHONE:  (919) 541-4551                                         RWY00540
C                                                                       RWY00550
C                                                                       RWY00560
C * * *  STRUCTURE AND MODULE SUMMARY                                   RWY00570
C                                                                       RWY00580
C MAIN - ROADWAY                                                        RWY00590
C        READER -- READ INPUT DATA                                      RWY00600
C        ECHO   -- ECHO INPUT DATA                                      RWY00610
C        ZERO   -- INITIALIZE ARRAYS                                    RWY00620
C        SBLAYR -- SURFACE LAYER MODEL DRIVER                           RWY00630
C                * RIBST  -- INITIALIZE SURFACE LAYER MODEL             RWY00640
C                * RIBTOZ -- ESTIMATE ZETA                              RWY00650
C                * GETSFC -- CALCULATE U*, T*, AND T0                   RWY00660
C                * PROFIL -- DETERMINE PROFILES OF WIND SPEED AND       RWY00670
C                             TEMPERATURE                               RWY00680
C                * TURBC  -- CALCULATE TURBULENT MOMENTS                RWY00690
C        UVCMP  -- CONVERT WIND TO U AND V COMPONENTS                   RWY00700
C        MOVE   -- INITIALIZE GRID IN X DIRECTION                       RWY00710
C        WHEREX -- DETERMINE GRID SPACING IN X DIRECTION.  FILL IN      RWY00720
C                   EMISSION GRID.                                      RWY00730
C                  FILLIT -- FILL GRID POINT ARRAY                      RWY00740
C        CENTER -- DETERMINE CENTER OF TRAFFIC LANES                    RWY00750
C        WAKE   -- ADD VEHICLE WAKE EFFECTS TO WIND TURBULENCE FIELDS   RWY00760
C                # FC     -- 2-DIMENSIONAL FIT (X-Z PLANE) OF TURBULENT RWY00770
C                             KINETIC ENERGY TERMS TO WIND TUNNEL DATA  RWY00780
C                # POLY   -- CURVE FIT OF VELOCITY DEFICIT BEHIND       RWY00790
C                             VEHICLES TO WIND TUNNEL DATA              RWY00800
C                  SIMPSN -- NUMERICAL INTEGRATION USING SIMPSON'S      RWY00810
C                             METHOD                                    RWY00820
C        NONDIV -- REMOVE DIVERGENCE FROM THE WIND FIELD                RWY00830
C                                                                       RWY00990
C                                                                       RWY01000
C        *  ENTRY POINT IN SUBROUTINE RIBULK                            RWY01010
C        #  FUNCTION                                                    RWY01020
C                                                                       RWY01030
C                                                                       RWY01040
C * * *  INPUT/OUTPUT INFORMATION                                       RWY01050
C                                                                       RWY01060
C        FORTRAN      DATA SET          I/O UNIT                        RWY01070
C         UNIT                                                          RWY01080
C           5         CONTROL INPUT     READER OR DISK                  RWY01090
C           6         OUTPUT            PRINTER OR DISK                 RWY01100
C                                                                       RWY01110
C                                                                       RWY01120
      dimension xp(250,250),zp(250,250)
      DIMENSION XV(12),X(28),Z(8),DU(28,8),C1(28,8),C2(28,8),C3(28,8)   RWY01150
      DIMENSION UPRO(8),VPRO(8),DV(28,8),KX(8),KZ(8)                    RWY01160
      DIMENSION SA(28),SB(28),SC(28),KXP(28,8),KZP(28,8)                RWY01170
      DIMENSION A(28,8,2),B(28,8,2),C(28,8,2),D(28,8,2)                 RWY01180
      DIMENSION WDPRO(8),XD1(8),XD2(8),XD3(8),XD(8)                     RWY01190
      DIMENSION KXPAS(28,8),KYPAS(28,8),KYP(28,8)                       RWY01200
      DIMENSION HWAYL(28)                                               RWY01220
      REAL NVEH,NVEH1,MEDN,KX,KXP,KZ,KZP                                RWY01130
      REAL KXPAS,KYPAS,KYP                                              RWY01140
      CHARACTER*4 HWAYL
      COMMON /CALCOM/C1,C3,KMAX,KX,KZ,X,Z,TMSTOP,NX,KXP,KZP             RWY01230
      COMMON /INCOM/ 
     1               MEDN,NVEH,NVEH1,                                   RWY01250
     2               RDANGL,T1,T2,VHGH,VWID,VSPD,VSPD1,WDIR,WIDL,WSPD,  RWY01260
     3               Z0,Z1,Z2,klane,stab                                RWY01270
      DATA XD1/30.,25.,20.,15.,10.,10.,15.,20./                         RWY01280
      DATA XD2/25.,20.,15.,10.,10.,15.,20.,25./                         RWY01290
      DATA XD3/20.,15.,10.,10.,15.,20.,25.,30./                         RWY01300
      DATA IN/5/, IO/6/                                                 RWY01320
C                                                                       RWY01321
C***      CALCULATE MEDIAN HALF WIDTH FOR SUBSEQUENT COMPUTATIONS.      RWY01560
C                                                                       RWY01570
      MEDN = MEDN/2.                                                    RWY01590
C                                                                       RWY01600
C***      INITIALIZE ARRAYS FOR THIS HOUR.                              RWY01610
C                                                                       RWY01620
      CALL ZERO(ICHEM,SA,SB,SC,A,B,C,D)                                 RWY01630
C                                                                       RWY01640
C***      THE COORDINATE SYSTEM USED IN THIS PROGRAM ORIENTATES THE     RWY01650
C***      Y AXIS PARELLEL TO THE ROAD AND THE X AXIS NORMAL TO THE      RWY01660
C***      ROAD.  THE ROAD IS TREATED AS IF IT IS ORIENTATED IN A NORTH- RWY01670
C***      SOUTH DIRECTION.                                              RWY01680
C                                                                       RWY01690
      WDIR = WDIR + RDANGL                                              RWY01700
crgi -- roadway gets unhappy later (zerodivide for slope) if perpindicular
c		u (and maybe v) component, so make sure wdir not within 1 deg
c		of EW or NS (by roadway defn) ....
crgi	atest = amod(wdir, 90.)
crgi	if (atest .lt. 0.) atest=atest+90.
crgi	if (atest .lt. 1.) wdir = wdir - 1.5
crgi	if (atest .gt. 89.) wdir =wdir -1.
C                                                                       RWY01710
C***      DETERMINE VELOCITY AND TURBULENCE PROFILES AND CALCULATE      RWY01720
C***      EDDY DIFFUSION COEFFICIENTS.                                  RWY01730
C                                                                       RWY01740
      CALL SBLAYR(Z0,Z1,T1,WSPD,WDIR,8,Z,KX,KZ,RIB,WDPRO,stab)          RWY01750
c
c
      if (ifirst .eq. 1) then
         Do 12 j=1,250
            do 11 i=1,250
               xp(i,j) = kx(2)
               zp(i,j) = kz(2)
   11       continue
   12    continue
      endif
C                                                                       RWY01760
C***      CONVERT WIND TO U AND V COMPONENTS.                           RWY01770
C                                                                       RWY01780
      DO 40 K = 2,8                                                     RWY01790
         CALL UVCMP(WDIR,WDPRO(K),UPRO(K),VPRO(K))                      RWY01800
   40 CONTINUE                                                          RWY01810
C                                                                       RWY01820
C***      NUMBER OF VERTICAL GRID POINTS IS A FUNCTION OF THE NORMAL    RWY01830
C***      WIND VELOCITY.                                                RWY01840
C                                                                       RWY01850
      U = ABS(UPRO(2))                                                  RWY01860
      KMAX = 6                                                          RWY01870
      IF (U .LT. 0.5) KMAX = 7                                          RWY01880
      IF (U .LT. 0.1) KMAX = 8                                          RWY01890
      TMSTOP = 300.                                                     RWY01900
      IF (KMAX .EQ. 7) TMSTOP = 600.                                    RWY01910
      IF (KMAX .EQ. 8) TMSTOP = 900.                                    RWY01920
C                                                                       RWY01930
C***      CALCULATE THE SOURCE STRENGTH FROM THE EMISSION STRENGTH.     RWY01940
C                                                                       RWY01950
      EA  = VSPD  * EMA/3600.                                           RWY01960
      EA1 = VSPD1 * EMA1/3600.                                          RWY01970
      IF (ICHEM .EQ. 1) GO TO 50                                        RWY01980
         EB  = VSPD  * EMB/3600.                                        RWY01990
         EB1 = VSPD1 * EMB1/3600.                                       RWY02000
         EC  = VSPD  * EMC/3600.                                        RWY02010
         EC1 = VSPD1 * EMC1/3600.                                       RWY02020
   50 CONTINUE                                                          RWY02030
C                                                                       RWY02040
      VSPD  = VSPD/3.6                                                  RWY02050
      VSPD1 = VSPD1/3.6                                                 RWY02060
      DDX = WIDL                                                        RWY02070
      DDZ = Z(2) + 0.5 * (Z(3) - Z(2))                                  RWY02080
      DVOL  = DDX * DDZ * ABS(-VSPD + VPRO(2))                          RWY02090
      DVOL1 = DDX * DDZ * ABS(VSPD1 + VPRO(2))                          RWY02100
C                                                                       RWY02110
      EA  = EA/DVOL                                                     RWY02120
      EA1 = EA1/DVOL1                                                   RWY02130
      IF (ICHEM .EQ. 1) GO TO 60                                        RWY02140
         EB1 = EB1/DVOL1                                                RWY02150
         EB  = EB/DVOL                                                  RWY02160
         EC1 = EC1/DVOL1                                                RWY02170
         EC  = EC/DVOL                                                  RWY02180
   60 CONTINUE                                                          RWY02190
C                                                                       RWY02200
      QVA  = EA  * NVEH/3600.                                           RWY02210
      QVA1 = EA1 * NVEH1/3600.                                          RWY02220
      IF (ICHEM .EQ. 1) GO TO 70                                        RWY02230
         QVB  = EB  * NVEH/3600.                                        RWY02240
         QVB1 = EB1 * NVEH1/3600.                                       RWY02250
         QVC  = EC  * NVEH/3600.                                        RWY02260
         QVC1 = EC1 * NVEH1/3600.                                       RWY02270
   70 CONTINUE                                                          RWY02280
C                                                                       RWY02290
C***      CALCULATE NUMBER AND SPACING OF GRID POINTS IN X DIRECTION.   RWY02300
C                                                                       RWY02310
      NX = 13 + klane
      if (medn .lt. widl/2.0) nx = nx - 2                                                  RWY02320
      IR1 = 4                                                           RWY02330
      IF (WDIR .GT. 10.  .AND. WDIR .LT. 170.) IR1 = 5                  RWY02340
      IF (WDIR .GT. 190. .AND. WDIR .LT. 350.) IR1 = 3                  RWY02350
      IF (IR1 .EQ. 4) CALL MOVE(XD2,XD)                                 RWY02360
      IF (IR1 .EQ. 3) CALL MOVE(XD3,XD)                                 RWY02370
      IF (IR1 .EQ. 5) CALL MOVE(XD1,XD)                                 RWY02380
C                                                                       RWY02390
C***      FILL IN GRID POINT ARRAY ACCORDING TO THE NUMBER OF TRAFFIC   RWY02400
C***      LANES AND FILL IN THE CORRESPONDING EMISSION ARRAYS.          RWY02410
C                                                                       RWY02420
      CALL WHEREX(klane,IR1,WIDL,MEDN,XD,QVA,QVA1,QVB,QVB1,QVC,         RWY02430
     1            QVC1,X,SA,SB,SC)                                      RWY02440
c      write (*,*) 'roadway 2 NX = ',nx
C                                                                       RWY02450
C***      DETERMINE CENTER OF LANES FOR WAKE CALCULATION.               RWY02460
C                                                                       RWY02470
      CALL CENTER(IR1,klane,WIDL,X,NX,XV,HWAYL)                         RWY02480
C                                                                       RWY02490
C***      INITIALLY SET WIND FIELD TO AMBIENT CONDITIONS.               RWY02500
C                                                                       RWY02510
      DO 90 I = 1,NX                                                    RWY02520
         DO 80 K = 1,KMAX                                               RWY02530
            C1(I,K) = UPRO(K)                                           RWY02540
            C2(I,K) = VPRO(K)                                           RWY02550
   80    CONTINUE                                                       RWY02560
   90 CONTINUE                                                          RWY02570
C                                                                       RWY02580
C***      DETERMINE VEHICLE WAKE EFFECTS (DU, DV) AND ADD TO AMBIENT    RWY02590
C***      WIND (C1, C2).                                                RWY02600
C                                                                       RWY02610
      CALL WAKE(UPRO,VPRO,VSPD,VSPD1,VHGH,NVEH,NVEH1,VWID,X,Z,NX,       RWY02620
     1          KMAX,XV,klane,DU,DV,KXP,KZP,KXPAS,KYPAS,KYP,IERR)       RWY02630
c      write (*,*) 'roadway 3 NX = ',nx
      IF (IERR .EQ. 0) GO TO 95                                         RWY02640
c         WRITE(IO,1000)                                                 RWY02650
         GO TO 999                                                      RWY02660
   95 CONTINUE                                                          RWY02670
C                                                                       RWY03010
C***      ADD WAKE TURBULENCE TO EDDY DIFFUSION COEFFICIENTS.           RWY03020
C                                                                       RWY03030
c      write (*,*) 'debug 1 ',kxp(15,2), kxp(14,2)
c      if (ifirst .eq. 1) Then
c      DO 150 K = KMAX,1,-1                                              RWY03040
c         write (*,*) k,kx(k),kz(k)
c         DO 140 I = 1,NX                                                RWY03050
c          if (ifirst .eq. 1) then
c            KXP(I,K) = KXP(I,K) + KX(K)                                 RWY03060
c            KZP(I,K) = KZP(I,K) + KZ(K)                                 RWY03070
c            if ((i .eq. 14 .or. i .eq. 15) .and. k .eq. 2) then
c               write (*,*) kxp(i,k),kx(k)
c            endif
c          endif
c  140    CONTINUE                                                       RWY03080
c  150 CONTINUE                                                          RWY03090
c      endif
C                                                                       RWY02680
C                                                                       RWY03280
  999 RETURN                                                            RWY03290
C                                                                       RWY03300
                                                                        RWY03320
      END                                                               RWY03630
C                                                                       RWY03640
      BLOCK DATA ROADBLK
      DIMENSION X(28),Z(8),KX(8),KZ(8)
      DIMENSION C1(28,8),C3(28,8),KXP(28,8),KZP(28,8)
      REAL NVEH,NVEH1,MEDN,KX,KXP,KZ,KZP
      COMMON /CALCOM/C1,C3,KMAX,KX,KZ,X,Z,TMSTOP,NX,KXP,KZP
      COMMON /INCOM/
     1               MEDN,NVEH,NVEH1,
     2               RDANGL,T1,T2,VHGH,VWID,VSPD,VSPD1,WDIR,WIDL,WSPD,
     3               Z0,Z1,Z2,klane,stab
      DATA Z/-1.,1.,2.,4.5,10.5,20.,50.,70./
      END
C=======================================================================RWY03650
C                                                                       RWY03660
C                                                                       RWY08310
      SUBROUTINE ZERO(ICHEM,SA,SB,SC,A,B,C,D)                           RWY08320
C                                                                       RWY08330
C        PARAMETER LIST:                                                RWY08340
C          INPUT:   ICHEM - CHEMISTRY OPTION                            RWY08350
C          OUTPUT:  SA    - NO  EMISSION GRID (G/M**3/SEC).             RWY08360
C                           IF ICHEM = 1, THEN SA IS THE POLLUTANT      RWY08370
C                           EMISSION GRID AND SB AND SC ARE IRRELEVANT. RWY08380
C                   SB    - CO  EMISSION GRID (G/M**3/SEC)              RWY08390
C                   SC    - NO2 EMISSION GRID (G/M**3/SEC)              RWY08400
C                   A     - NO  CONCENTRATION FIELD (PPM).              RWY08410
C                           IF ICHEM = 1, THEN A IS THE POLLUTANT       RWY08420
C                           CONCENTRATION FIELD AND B, C, AND D ARE     RWY08430
C                           IRRELEVANT.                                 RWY08440
C                   B     - CO  CONCENTRATION FIELD (PPM)               RWY08450
C                   C     - NO2 CONCENTRATION FIELD (PPM)               RWY08460
C                   D     - O3  CONCENTRATION FIELD (PPM)               RWY08470
C                                                                       RWY08480
C        CALLING ROUTINE:                                               RWY08490
C          MAIN                                                         RWY08500
C                                                                       RWY08510
C        DESCRIPTION:                                                   RWY08520
C          THIS MODULE PERFORMS THE NECESSARY INITIALIZATION PRIOR TO   RWY08530
C          CALCULATIONS.                                                RWY08540
C                                                                       RWY08550
      DIMENSION A(28,8,2),B(28,8,2),C(28,8,2),D(28,8,2)                 RWY08560
      DIMENSION SA(28),SB(28),SC(28)                                    RWY08570
C                                                                       RWY08580
      DO 300 I = 1,28                                                   RWY08590
         SA(I) = 0.0                                                    RWY08600
         IF (ICHEM .EQ. 1) GO TO 10                                     RWY08610
            SB(I) = 0.0                                                 RWY08620
            SC(I) = 0.0                                                 RWY08630
   10    CONTINUE                                                       RWY08640
         DO 200 K = 1,8                                                 RWY08650
            DO 100 L = 1,2                                              RWY08660
               A(I,K,L) = 0.0                                           RWY08670
               IF (ICHEM .EQ. 1) GO TO 20                               RWY08680
                  B(I,K,L) = 0.0                                        RWY08690
                  C(I,K,L) = 0.0                                        RWY08700
                  D(I,K,L) = 0.0                                        RWY08710
   20          CONTINUE                                                 RWY08720
  100       CONTINUE                                                    RWY08730
  200    CONTINUE                                                       RWY08740
  300 CONTINUE                                                          RWY08750
C                                                                       RWY08760
      RETURN                                                            RWY08770
      END                                                               RWY08780
C                                                                       RWY08790
C=======================================================================RWY08800
C                                                                       RWY08810
      SUBROUTINE SBLAYR(Z0,H,T1,WSP,WDIR,KMAX,Z,KX,KZ,RIB,WSPD,         RWY08820
     1                  stab)
C                                                                       RWY08830
C        PARAMETER LIST:                                                RWY08840
C          INPUT:   Z0   - SURFACE ROUGHNESS (METERS)                   RWY08850
C                   H    - HEIGHT OF UPPER TEMPERATURE INSTRUMENT AND   RWY08880
C                          ANEMOMETER (METERS)                          RWY08890
C                   T1   - TEMPERATURE AT HEIGHT, H  (KELVIN)           RWY08900
C                   WSP  - HOURLY AVERAGE WIND SPEED (M/SEC)            RWY08920
C                   WDIR - HOURLY AVERAGE WIND DIRECTION (RELATIVE TO   RWY08930
C                          THE HIGHWAY)                                 RWY08940
C                   KMAX - NUMBER OF VERTICAL LEVELS (KMAX = 8)         RWY08950
C                   Z    - ARRAY CONTAINING HEIGHTS OF VERTICAL LEVELS  RWY08960
C                          (METERS)                                     RWY08970
C          OUTPUT:  KX   - HORIZONTAL EDDY DIFFUSION COEFFICIENTS       RWY08980
C                          (M**2/SEC)                                   RWY08990
C                   KZ   - VERTICAL   EDDY DIFFUSION COEFFICIENTS       RWY09000
C                          (M**2/SEC)                                   RWY09010
C                   RIB  - BULK RICHARDSON NUMBER                       RWY09020
C                   WSPD - VELOCITY PROFILE ARRAY (M/SEC)               RWY09030
C                   stab - Stability Class                              RWY09030
C                                                                       RWY09040
C          CALLING ROUTINE:                                             RWY09050
C            MAIN                                                       RWY09060
C                                                                       RWY09070
C          SUBPROGRAMS CALLED:                                          RWY09080
C            RIBST*, RIBTOZ*, GETSFC*, PROFIL*, TURBC*                  RWY09090
C                                                                       RWY09100
C            *  INDICATES ENTRY POINT IN SUBROUTINE RIBULK              RWY09110
C                                                                       RWY09120
C          DESCRIPTION:                                                 RWY09130
C            THIS MODULE IS THE DRIVING ROUTINE FOR THE SURFACE LAYER   RWY09140
C            MODEL WRITTEN BY FRANK BINKOWSKI USING SIMILARITY THEORY.  RWY09150
C            THIS SUBROUTINE FINDS THE VELOCITY PROFILE, TURBULENCE     RWY09160
C            PROFILES, AND CALCULATES EDDY DIFFUSION COEFFICIENTS.      RWY09170
C                                                                       RWY09180
      DIMENSION KX(8),KZ(8),WSPD(8),Z(8)                                RWY09200
      REAL LAMDA,KX,KZ,L                                                RWY09190
      DATA G/9.80616/, GAMD/.00976/                                     RWY09210
C                                                                       RWY09220
C***      INITIALIZE SURFACE LAYER MODEL.                               RWY09230
C                                                                       RWY09240
c-sai-DELZ = H - Z1                                                     RWY09250
c-sai-THETA1 = T1 + GAMD * Z1                                           RWY09260
c-sai-THETA2 = T2 + GAMD * H                                            RWY09270
      THETA = T1 + GAMD * H                                             RWY09270
c-sai-DTEMP = THETA2 - THETA1                                           RWY09280
c-sai-RIB = H * G * DTEMP/(THETA2 * WSP**2)                             RWY09290
c-sai-IF(RIB .GT. 0.20) RIB = 0.20                                      RWY09300
C                                                                       RWY09310
      CALL RIBST(H,Z0,1)                                                RWY09320
C                                                                       RWY09330
C***      GET ESTIMATE OF ZETA.                                         RWY09340
C                                                                       RWY09350
c-sai-CALL RIBTOZ(RIB,ZETA)                                             RWY09360
      call golder (stab,z0,l)
      zeta = h/l
C                                                                       RWY09370
C***      CALCULATE U*, T*, AND T0.                                     RWY09380
C                                                                       RWY09390
      CALL GETSFC(ZETA,WSP,THETA,H,USTAR,TSTAR,T0)                      RWY09400
c-sai-CALL GETSFC(ZETA,WSP,THETA2,DTEMP,USTAR,TSTAR,T0)                 RWY09400
c-sai-L = H/ZETA                                                        RWY09410
C                                                                       RWY09420
C***      CALCULATE VERTICAL WIND PROFILE AND EDDY DIFFUSION            RWY09430
C***      COEFFICIENTS.                                                 RWY09440
C                                                                       RWY09450
      DO 20 K = 2,KMAX                                                  RWY09460
         ZL = Z(K)/L                                                    RWY09470
C                                                                       RWY09480
C***         OBTAIN WIND SPEED, TEMPERATURE, AND GRADIENTS OF THESE     RWY09490
C***         PARAMETERS AT HEIGHT ZL.                                   RWY09500
C                                                                       RWY09510
         CALL PROFIL(Z(K),ZL,USTAR,TSTAR,T0,WSPD(K),TH,DUDZ,DTHDZ)      RWY09520
         ZETA = Z(K)/L                                                  RWY09530
C                                                                       RWY09540
C***         OBTAIN TURBULENT MOMENTS USING BINKOWSKI7S CLOSURE MODEL.  RWY09550
C                                                                       RWY09560
         CALL TURBC(ZETA,SU,SV,SW,ST,UT,SQ,FM)                          RWY09570
C                                                                       RWY09580
         SU = SU * USTAR                                                RWY09590
         SV = SV * USTAR                                                RWY09600
         SW = SW * USTAR                                                RWY09610
         IF (WDIR .LT.  90.) WD1 = 90. - WDIR                           RWY09620
         IF (WDIR .GE.  90. .AND. WDIR .LT. 180.) WD1 = WDIR - 90.      RWY09630
         IF (WDIR .GE. 180. .AND. WDIR .LT. 270.) WD1 = 270. - WDIR     RWY09640
         IF (WDIR .GT. 270.) WD1 = WDIR - 270.                          RWY09650
         WD1 = WD1 * 3.14159265/180.                                    RWY09660
         SU1 =  SU * COS(WD1) + SV * SIN(WD1)                           RWY09670
         SV1 = -SU * SIN(WD1) + SV * COS(WD1)                           RWY09680
         LAMDA = Z(K)/FM                                                RWY09690
         KZ(K) = .125 * SW * LAMDA                                      RWY09700
         IF (ZETA .LT. 0. .AND. K .GT. 2) GO TO 10                      RWY09710
            KX(K) = ABS(SU1) * LAMDA                                    RWY09720
   10    CONTINUE                                                       RWY09730
   20 CONTINUE                                                          RWY09740
C                                                                       RWY09750
      DO 30 K = 3,KMAX                                                  RWY09760
         KX(K) = KX(2)                                                  RWY09770
   30 CONTINUE                                                          RWY09780
      KX(1) = KX(2)                                                     RWY09790
C                                                                       RWY09800
      RETURN                                                            RWY09810
      END                                                               RWY09820
C                                                                       RWY09830
C=======================================================================RWY09840
C                                                                       RWY09850
      SUBROUTINE RIBULK(H,Z1,Z0,NTYPE,ZZ,RIB)                           RWY09860
C                                                                       RWY09870
C     THIS ROUTINE CALCULATES SURFACE QUANTITIES SUCH AS U* AND T* USINGRWY09880
C     USING SIMILARITY THEORY.                                          RWY09890
C     REFERENCES:                                                       RWY09900
C     NICKERSON AND SMILEY JAM(14) 297-300 1975.                        RWY09910
C     BENOIT JAM(16) 859-860 1977                                       RWY09920
C                                                                       RWY09930
C     NOTE: THE STABLE PROFILES ARE INTEGRATED FROM Z0/L TO Z/L ALSO.   RWY09940
C     THIS IS AN EXTENSION OF NICKERSON & SMILEY(1975),BENOIT(1977).    RWY09950
C                                                                       RWY09960
C     THE CALLING SEQUENCES ARE:                                        RWY09970
C     CALL RIBST(H,Z1,Z0,NTYPE)                                         RWY09980
C     WHERE:                                                            RWY09990
C     H IS  ANEMOMETER HEIGHT (METERS)                                  RWY10000
C     Z1 IS THE LOWER THERMOMETER HEIGHT (METERS)                       RWY10010
C     Z0 IS  THE ROUGHNESS HEIGHT (METERS)                              RWY10020
C     NTYPE IS A PROFILE INDICATOR.                                     RWY10030
C        NTYPE=1; DYER PROFILES                                         RWY10040
C        NTYPE=2; BUSINGER PROFILES..                                   RWY10050
C     THIS INITIALIZES THE ROUTINE.                                     RWY10060
C                                                                       RWY10070
C     NOW TO OBTAIN AN ESTIMATE OF ZETA FROM A VALUE OF RIB:            RWY10080
C     CALL RIBTOZ(RIB,ZETA)                                             RWY10090
C                                                                       RWY10100
C     TO OBTAIN U*, T* AND T0:                                          RWY10110
C     CALL GETSFC(ZL,UH,THETA,DT,USTAR,TSTAR,T0)                        RWY10120
C     WHERE:                                                            RWY10130
C     ZL IS A VALUE OR ESTIMATE OF ZETA.                                RWY10140
C     UH IS  THE WIND SPEED AT H (METERS/SECOND)                        RWY10150
C     THETA IS THE POTENTIAL TEMPERATURE AT H (DEGREES KELVIN)          RWY10160
C     DT IS THE TEMPERATURE DIFFERENCE BETWEEN H AND Z1 (DEGREES)       RWY10170
C     USTAR IS U* AT Z0 (METERS/SECOND)                                 RWY10180
C     TSTAR IS T* AT Z0 (DEGREES KELVIN)                                RWY10190
C *** T0 IS THE EXTRAPOLATED TEMPERATURE AT Z0 (DEGREES KELVIN)         RWY10200
C                                                                       RWY10210
C     TO OBTAIN VALUES OF WIND SPEED, TEMPERATURE AND THE GRADIENTS     RWY10220
C     OF THESE QUANTITIES AT VARIOUS HEIGHTS:                           RWY10230
C                                                                       RWY10240
C     CALL PROFIL(HZ,ZL,USTAR,TSTAR,T0,UP,TP,DUDZ,DTHDZ)                RWY10250
C     WHERE:                                                            RWY10260
C     HZ IS THE HEIGHT (METERS) AND MUST BE GREATER THAN Z0.            RWY10270
C     ZL IS THE VALUE OF ZETA AT HZ.                                    RWY10280
C     USTAR,TSTAR,T0 ARE AS ABOVE.                                      RWY10290
C     UP IS THE PREDICTED WIND SPEED AT HZ (METERS/SECOND).             RWY10300
C     TP IS THE PREDICTED POTENTIAL TEMPERATURE AT  HZ (DEGREES KELVIN).RWY10310
C     DUDZ AND DTHDZ ARE THE PREDICTED WIND SHEAR (1/SECONDS) AND       RWY10320
C     POTENTIAL TEMPERATURE GRADIENT (DEGREES/METER) AT HZ.             RWY10330
C                                                                       RWY10340
C      TO OBTAIN TURBULENT MOMENTS USING BINKOWSKI'S CLOSURE MODEL:     RWY10350
C     CALL TURBC(Z,SU,SV,SW,ST,UT,SQ,FM)                                RWY10360
C     WHERE:                                                            RWY10370
C     Z IS Z/L                                                          RWY10380
C     SU,SV,SW ARE THE NORMALIZED RMS TURBULENT VELOCITY COMPONENTS.    RWY10390
C     THEY ARE NORMALIZED BY USTAR AND THUS ARE NON-DIMENSIONAL.        RWY10400
C     ST IS THE NORMALIZED RMS TURBULENT TEMPERATURE FLUCTUATION.       RWY10410
C     IT IS NORMALIZED BY TSTAR AND IS NON-DIMENSIONAL.                 RWY10420
C     UT IS NORMALIZED LONGITUDINAL KINEMATIC HEAT FLUX. IT IS NORMAL-  RWY10430
C     IZED BY USTAR*TSTAR AND IS NONDIMENSIONAL.                        RWY10440
C     SQ IS THE NORMALIZED RMS TURBULENT VELOCITY FLUCTUATION. IT IS    RWY10450
C     NORMALIZED BY USTAR AND IS NON-DIMENSIONAL.                       RWY10460
C     FM IS THE NON-DIMENSIONAL FREQUENCY OF THE PEAK IN THE W SPECTRUM.RWY10470
C     THIS CALL SHOULD ONLY BE USED WHEN  NTYPE =1 ABOVE.               RWY10480
C                                                                       RWY10490
C     CODED BY DR FRANCIS S. BINKOWSKI 1977.                            RWY10500
C                                                                       RWY10510
      DATA GRAV/9.80616/, ONE3/0.333333/                                RWY10520
C                                                                       RWY10530
C * * * * * * * * * * * * STATEMENT FUNCTIONS * * * * * * * * * * * * * RWY10540
C                                                                       RWY10550
      FAC1(X1,X2)=ALOG( (X1*X1+1.0)*(X1+1.0)*(X1+1.0)/(                 RWY10560
     1               (X2*X2+1.0)*(X2+1.0)*(X2+1.0)  )  )                RWY10570
      FAC2(Y1,Y2)=2.0*(ALOG( (Y1+1.0)/(Y2+1.0) ) )                      RWY10580
C                                                                       RWY10590
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * RWY10600
C                                                                       RWY10610
      ENTRY RIBST(H,Z0,NTYPE)                                           RWY10620
COMMENT: INITIALIZE   THE CONSTANTS AND PARAMETERS.                     RWY10630
      Z0P = Z0
      IF(NTYPE .EQ. 2)  GO TO 1                                         RWY10640
C *** DYER PROFILES.                                                    RWY10650
      GAMA1= 16.0                                                       RWY10660
      GAMA2=16.0                                                        RWY10670
      BETA = 5.0                                                        RWY10680
      VK=0.4                                                            RWY10690
      R=1.0                                                             RWY10700
      ARIB2=8.612                                                       RWY10710
      GO TO 3                                                           RWY10720
C *** BUSINGER PROFILES                                                 RWY10730
    1 GAMA1=15.0                                                        RWY10740
      GAMA2=9.0                                                         RWY10750
      BETA=4.7                                                          RWY10760
      VK=0.35                                                           RWY10770
      R=0.74                                                            RWY10780
      ARIB2=6.424                                                       RWY10790
    3 ALNZ=ALOG(H/Z0P)                                                   RWY10800
c-sai-ALNZT=ALOG(H/Z1)                                                  RWY10810
c-sai-ALNZ1=ALOG(Z1/Z0P)                                                 RWY10820
c-sai-F2GN=ALNZ*ALNZ/(R*ALNZT)                                          RWY10830
c-sai-Z1H=Z1/H                                                          RWY10840
      Z0H=Z0/H                                                          RWY10850
c-sai-Z01=Z0/Z1                                                         RWY10860
      GM1HZ0=GAMA1*Z0H                                                  RWY10870
c-sai-GM2HZ1=GAMA2*Z1H                                                  RWY10880
      GM2HZ0=GAMA2*Z0H                                                  RWY10890
      VKGH=VK*GRAV*H                                                    RWY10900
      RETURN                                                            RWY10910
C                                                                       RWY10920
      ENTRY ZTORIB(ZL,RIB)                                              RWY10930
      HL=ZL                                                             RWY10940
      ASSIGN 5 TO ISTAT                                                 RWY10950
      GO TO 109                                                         RWY10960
    5 BB=HL*G/(VK*F*F)                                                  RWY10970
      RIB=BB                                                            RWY10980
      RETURN                                                            RWY10990
C                                                                       RWY11000
      ENTRY RIBTOZ(RIB,ZEST)                                            RWY11010
      ACC=0.0                                                           RWY11020
      ITERM=3                                                           RWY11030
      IF( RIB .LT. 0.04 ) GO TO 65                                      RWY11040
      ITERM=5                                                           RWY11050
      ACC=ARIB2                                                         RWY11060
   65 HL=F2GN*(1.0 + ACC*RIB)*RIB                                       RWY11070
C *** ITERATE TO RECOVER Z/L.                                           RWY11080
      ASSIGN 8 TO ISTAT                                                 RWY11085
      ITER = 0                                                          RWY11090
61    ITER = ITER + 1                                                   RWY11100
      GO TO 109                                                         RWY11110
    8 ZEST=(VK*F*F/G)*RIB                                               RWY11120
      HL=ZEST                                                           RWY11130
      IF (ITER .LT. ITERM) GOTO 61                                      RWY11140
      RETURN                                                            RWY11150
C                                                                       RWY11160
c-sai-ENTRY GETSFC(ZL,UH,THETA,DT,USTAR,TSTAR,T0)                       RWY11170
      ENTRY GETSFC(ZL,UH,THETA,h,USTAR,TSTAR,T0)                        RWY11170
      HL=ZL                                                             RWY11180
      ASSIGN 6 TO ISTAT                                                 RWY11190
      GO TO 109                                                         RWY11200
    6 IF(HL.LT. 0.0 ) GO TO 4                                           RWY11210
c-sai-BYT0=BETA*HL*Z1H*(1.0-Z01)                                        RWY11220
c-sai-G0=(R*ALNZ1 + BYT0)/VK                                            RWY11230
      GO TO 7                                                           RWY11240
    4 ETA0=SQRT(1.0-GM2HZ0*HL)                                          RWY11250
c-sai-G0=R*(ALNZ1 + FAC2(ETA0,ETA1) )/VK                                RWY11260
    7 USTAR=UH/F                                                        RWY11270
c-sai-TSTAR=DT/G                                                        RWY11280
      xl = h / zl
      tstar = (ustar*ustar*theta)/(xl*grav*vk)
c-sai-T0=THETA - DT - TSTAR*G0                                          RWY11290
      t0 = theta*(1 - (uh*uh*g)/(vk*xl*grav*f*f))
      RETURN                                                            RWY11300
C                                                                       RWY11310
  109 IF(HL .LT. 0.0 ) GO TO 101                                        RWY11320
C *** STABLE                                                            RWY11330
c-sai-BYU=BETA*HL*(1.0-Z0H)                                             RWY11340
c-sai-BYT=BETA*HL*(1.0-Z1H)                                             RWY11350
      BYU=BETA*HL                                                       RWY11340
      BYT=BETA*HL                                                       RWY11350
      F=(ALNZ + BYU)/VK                                                 RWY11360
c-sai-G=( R*ALNZT + BYT)/VK                                             RWY11370
      G=( R*ALNZ  + BYT)/VK                                             RWY11370
      GO TO ISTAT                                                       RWY11380
C *** UNSTABLE                                                          RWY11390
  101 ZETA0=SQRT( SQRT( 1.0 - GM1HZ0*HL )  )                            RWY11400
c-sai-ETA1=SQRT(1.0-GM2HZ1*HL)                                          RWY11410
      ETA0=SQRT(1.0-GM2HZ0*HL)                                          RWY11410
      ZETAH=SQRT(SQRT(1.0-GAMA1*HL) )                                   RWY11420
      ETAH=SQRT(1.0-GAMA2*HL )                                          RWY11430
      F=(ALNZ + FAC1(ZETA0,ZETAH)+2.0*(ATAN(ZETAH)-ATAN(ZETA0)))/VK     RWY11440
c-sai-G=R*( ALNZT + FAC2(ETA1,ETAH) )/VK                                RWY11450
      G=R*( ALNZ  + FAC2(ETA0,ETAH) )/VK                                RWY11450
  105 GO TO ISTAT                                                       RWY11460
C                                                                       RWY11470
      ENTRY PROFIL(HZ,ZL,USTAR,TSTAR,T0,UP,TP,DUDZ,DTHDZ)               RWY11480
      HL=ZL                                                             RWY11490
      VKHZ=VK*HZ                                                        RWY11500
      ALNX=ALOG(HZ/Z0P)                                                  RWY11510
      IF( HL .LT. 0.0 ) GO TO 44                                        RWY11520
      BY=BETA*HL*(1.0-Z0P/HZ)                                            RWY11530
      F=(ALNX + BY)/VK                                                  RWY11540
      G=( R*ALNX + BY)/VK                                               RWY11550
      DUDZ=USTAR*(1.0 + BY)/VKHZ                                        RWY11560
      DTHDZ=TSTAR*(R +BY)/VKHZ                                          RWY11570
      GO TO 55                                                          RWY11580
C *** UNSTABLE                                                          RWY11590
   44 GMAHZ0=GAMA1*Z0/HZ                                                RWY11600
      GMBHZ0=GAMA2*Z0/HZ                                                RWY11610
      ZETA0=SQRT( SQRT( 1.0 - GMAHZ0*HL )  )                            RWY11620
      ETA0=SQRT(1.0-GMBHZ0*HL)                                          RWY11630
      ZETAH=SQRT(SQRT(1.0-GAMA1*HL) )                                   RWY11640
      ETAH=SQRT(1.0-GAMA2*HL )                                          RWY11650
      F=(ALNX + FAC1(ZETA0,ZETAH)+2.0*(ATAN(ZETAH)-ATAN(ZETA0)))/VK     RWY11660
      G=R*(ALNX + FAC2(ETA0,ETAH) )/VK                                  RWY11670
      DUDZ=USTAR/(VKHZ*ZETAH)                                           RWY11680
      DTHDZ=R*TSTAR/(VKHZ*ETAH)                                         RWY11690
   55 UP = USTAR*F                                                      RWY11700
      TP=T0 + TSTAR*G                                                   RWY11710
      RETURN                                                            RWY11720
C                                                                       RWY11730
      ENTRY TURBC(Z,SU,SV,SW,ST,UT,SQ,FM)                               RWY11740
      IF( Z .LT. 0.0 ) GO TO 91                                         RWY11750
C *** STABLE                                                            RWY11760
      PHIM = 1.0 + 5.0*Z                                                RWY11770
      GO TO 95                                                          RWY11780
C *** UNSTABLE                                                          RWY11790
   91 PHIM=1.0/SQRT( SQRT( 1.0-16.0*Z  )  )                             RWY11800
   95 RF=Z/PHIM                                                         RWY11810
      GAMMA = RF/(1.0 - RF)                                             RWY11820
      ALFAT=2.63*( (0.30*PHIM-Z)/(0.79*PHIM-Z) )                        RWY11830
      PHIH=PHIM/ALFAT                                                   RWY11840
C *** USE INTERNAL ALFAT TO GET PHIH.                                   RWY11850
      SCALE=1.0                                                         RWY11860
      IF( Z .GT. 0.0 ) SCALE = 1.0 + 3.39*Z - 0.25*Z*Z                  RWY11870
      IF( Z .GE. 2.0 ) SCALE = 6.78 + 2.39*( Z - 2.0 )                  RWY11880
C *** THIS MAKE FM PROPORTIONAL TO Z/L FOR LARGE Z/L.                   RWY11890
      IF( Z .LT. 0.0 ) SCALE = 0.40 + 0.60*EXP(4.0*Z)                   RWY11900
      SCALE2=SCALE*SCALE                                                RWY11910
      FM=0.4*SCALE                                                      RWY11920
      D1=1.0/FM                                                         RWY11930
      SW=((PHIM-Z)/(1.20*FM))**0.333333                                 RWY11940
      SWFM=0.4*SW                                                       RWY11950
      W2=SW*SW                                                          RWY11960
      Q2=W2*(3.0 + 0.75*(1.0 + D1) + 1.80*GAMMA)                        RWY11970
      V2=ONE3*Q2 - W2*(0.08*GAMMA + 0.13*(2.0-D1) )                     RWY11980
      U2=Q2 - ( V2 + W2)                                                RWY11990
      T2=2.5*PHIH/SWFM                                                  RWY12000
      IF( Z .GT. 0.0) T2=T2/SCALE2                                      RWY12010
      SU=SQRT(U2)                                                       RWY12020
      UT=0.53*(PHIH + 1.9*PHIM)/SWFM                                    RWY12030
      IF( Z .GT. 0.0 ) UT=UT/SCALE2                                     RWY12040
      ST=SQRT(T2)                                                       RWY12050
      SV=SQRT(V2)                                                       RWY12060
      SQ=SQRT(Q2)                                                       RWY12070
      RETURN                                                            RWY12080
      END                                                               RWY12090
C                                                                       RWY12100
C=======================================================================RWY12110
C                                                                       RWY12120
      SUBROUTINE UVCMP(DIR,SPD,U,V)                                     RWY12130
C                                                                       RWY12140
C        PARAMETER LIST:                                                RWY12150
C          INPUT:   DIR - WIND DIRECTION (RELATIVE TO HIGHWAY)          RWY12160
C                   SPD - WIND SPEED (M/SEC)                            RWY12170
C          OUTPUT:  U   - EAST-WEST COMPONENT (RELATIVE TO A N-S        RWY12180
C                         HIGHWAY) OF THE WIND (M/SEC)                  RWY12190
C                   V   - NORTH-SOUTH COMPONENT (RELATIVE TO A N-S      RWY12200
C                         HIGHWAY) OF THE WIND (M/SEC)                  RWY12210
C                                                                       RWY12220
C        CALLING ROUTINE:                                               RWY12230
C          MAIN                                                         RWY12240
C                                                                       RWY12250
C        DESCRIPTION:                                                   RWY12260
C          THE SUBROUTINE CONVERTS WIND VELOCITY INTO ITS U AND V       RWY12270
C          COMPONENTS.                                                  RWY12280
C                                                                       RWY12290
      PI = 3.141592654                                                  RWY12300
      U = -SPD * SIN(DIR * PI/180.)                                     RWY12310
      V = -SPD * COS(DIR * PI/180.)                                     RWY12320
C                                                                       RWY12330
      RETURN                                                            RWY12340
      END                                                               RWY12350
C                                                                       RWY12360
C=======================================================================RWY12370
C                                                                       RWY12380
      SUBROUTINE MOVE(XX,YY)                                            RWY12390
C                                                                       RWY12400
C        PARAMETER LIST:                                                RWY12410
C          INPUT:   XX - INITIALIZING ARRAY                             RWY12420
C          OUTPUT:  YY - ARRAY TO BE INITIALIZED                        RWY12430
C                                                                       RWY12440
C        CALLING ROUTINE:                                               RWY12450
C          MAIN                                                         RWY12460
C                                                                       RWY12470
C        DESCRIPTION:                                                   RWY12480
C          THIS MODULE INITIALIZES THE GRID IN THE X DIRECTION.         RWY12490
C                                                                       RWY12500
C                                                                       RWY12510
      DIMENSION XX(8),YY(8)                                             RWY12520
C                                                                       RWY12530
      DO 10 I = 1,8                                                     RWY12540
         YY(I) = XX(I)                                                  RWY12550
   10 CONTINUE                                                          RWY12560
C                                                                       RWY12570
      RETURN                                                            RWY12580
      END                                                               RWY12590
C                                                                       RWY12600
C=======================================================================RWY12610
C                                                                       RWY12620
      SUBROUTINE WHEREX(klane,IR1,WIDL,RMEDN,XD,QVA,QVA1,QVB,QVB1,QVC,  RWY12630
     1                  QVC1,X,SA,SB,SC)                                RWY12640
C                                                                       RWY12650
C        PARAMETER LIST:                                                RWY12660
C          INPUT:   klane - NUMBER OF TRAFFIC LANES                     RWY12670
C                   IR1   - WIND DIRECTION INDICATOR                    RWY12680
C                   WIDL  - WIDTH OF ONE LANE                           RWY12690
C                   RMEDN - HALF WIDTH OF TRAFFIC MEDIAN (METERS)       RWY12700
C                   XD    - GRID SPACING PARAMETERS (METERS)            RWY12710
C                   QVA   - NO SOURCE STRENGTH OF SOUTHBOUND LANES      RWY12720
C                           (G/SEC/M**3)                                RWY12730
C                   QVA1  - NO SOURCE STRENGTH OF NORTHBOUND LANES      RWY12740
C                           (G/SEC/M**3)                                RWY12750
C                   QVB   - CO SOURCE STRENGTH OF SOUTHBOUND LANES      RWY12760
C                           (G/SEC/M**3)                                RWY12770
C                   QVB1  - CO SOURCE STRENGTH OF NORTHBOUND LANES      RWY12780
C                           (G/SEC/M**3)                                RWY12790
C                   QVC   - NO2 SOURCE STRENGTH OF SOUTHBOUND LANES     RWY12800
C                           (G/SEC/M**3)                                RWY12810
C                   QVC1  - NO2 SOURCE STRENGTH OF NORTHBOUND LANES     RWY12820
C                           (G/SEC/M**3)                                RWY12830
C          OUTPUT:  X     - GRID POINTS IN THE X DIRECTION (METERS)     RWY12840
C                   SA    - NO  EMISSION GRID (G/M**3/SEC)              RWY12850
C                   SB    - CO  EMISSION GRID (G/M**3/SEC)              RWY12860
C                   SC    - NO2 EMISSION GRID (G/M**3/SEC)              RWY12870
C                                                                       RWY12880
C        CALLING ROUTINE:                                               RWY12890
C          MAIN                                                         RWY12900
C                                                                       RWY12910
C        SUBPROGRAMS CALLED:                                            RWY12920
C          FILLIT                                                       RWY12930
C                                                                       RWY12940
C        DESCRIPTION:                                                   RWY12950
C          THIS MODULE CALCULATES THE NUMBER AND SPACING OF GRID POINTS RWY12960
C          IN THE X-DIRECTION AND FILLS THE ARRAYS CONTAINING THE       RWY12970
C          EMISSIONS AT EACH LANE LOCATION                              RWY12980
C                                                                       RWY12990
      DIMENSION SA(28),SB(28),SC(28),X(28),XD(8)                        RWY13000
C                                                                       RWY13010
C***      CALCULATE THE NUMBER OF LANES ON EACH SIDE OF THE MEDIAN.     RWY13020
C                                                                       RWY13030
      MLANE = klane/2                                                   RWY13040
C                                                                       RWY13050
C***      FILL IN GRID POINTS TO THE LEFT OF THE HIGHWAY.               RWY13060
C                                                                       RWY13070
      X(1) = 0.0                                                        RWY13080
      DO 10 I = 1,IR1                                                   RWY13090
          X(I+1) = X(I) + XD(I)                                         RWY13100
   10 CONTINUE                                                          RWY13110
C                                                                       RWY13120
C***      FILL IN GRID POINTS THRU LEFT LANES AND LEFT SIDE OF MEDIAN.  RWY13130
C                                                                       RWY13140
      NSTART = IR1 + 2                                                  RWY13150
      NMAX = NSTART + MLANE                                             RWY13160
      CALL FILLIT (WIDL,NSTART,NMAX,X)                                  RWY13170
c
crgi	Recoding -- we'll add width to median if necessary so that it's
c	at least one lanewidth wide.  Doesn't matter for HYROAD, since we
c	only have traffic going one direction.  Just need to keep track
c	of which lanes (NB or SB) have volume, as those will be used as
c	the spatial reference for adjusting the gridded wind and turbulence
c	fields.

	if (rmedn .ge. widl/2.) then
		x(nmax+1) = x(nmax) +(rmedn - widl/2.)
		x(nmax+2) = x(nmax+1) +(rmedn - widl/2.)
	else
c	narrow median, set all on same line 1/2 lanewidth from
c	nearby lane edges (i.e., same as x(nmax)
		x(nmax+1) = x(nmax)
		x(nmax+2) = x(nmax)
	endif
c	continue on starting with NB lane #1 centerline
	nstart = nmax + 3
c

      NMAX = NSTART + MLANE                                             RWY13340
      CALL FILLIT(WIDL,NSTART,NMAX,X)                                   RWY13350
C                                                                       RWY13360
C***      FILL IN EMISSION GRID FOR RIGHT LANES.                        RWY13370
C                                                                       RWY13380
      INDX = IR1 + MLANE + 3                                            RWY13390
c      DO 50 K = 1,MLANE                                                 RWY13400
c         SA(INDX+K+1) = QVA1                                            RWY13410
c         IF (ICHEM .EQ. 1) GO TO 40                                     RWY13420
c            SB(INDX+K+1) = QVB1                                         RWY13430
c            SC(INDX+K+1) = QVC1                                         RWY13440
c   40    CONTINUE                                                       RWY13450
c   50 CONTINUE                                                          RWY13460
C                                                                       RWY13470
C***      FILL IN GRID POINTS TO THE RIGHT OF THE HIGHWAY.              RWY13480
C                                                                       RWY13490
      NSTART = NMAX + 1                                                 RWY13500
      NMAX = NSTART + 8 - IR1 - 1                                       RWY13510
      K = IR1                                                           RWY13520
      DO 60 I = NSTART,NMAX                                             RWY13530
         K = K + 1                                                      RWY13540
         X(I) = X(I-1) + XD(K)                                          RWY13550
   60 CONTINUE                                                          RWY13560
C                                                                       RWY13570
      RETURN                                                            RWY13580
      END                                                               RWY13590
C                                                                       RWY13600
C=======================================================================RWY13610
C                                                                       RWY13620
      SUBROUTINE FILLIT(ADDTV,IBEG,IEND,POINTX)                         RWY13630
C                                                                       RWY13640
C        PARAMETER LIST:                                                RWY13650
C          INPUT:  ADDTV  - THE AMOUNT TO BE ADDED                      RWY13660
C                  IBEG   - BEGINNING INDEX                             RWY13670
C                  IEND   - ENDING INDEX                                RWY13680
C          I/O:    POINTX - ARRAY TO BE FILLED                          RWY13690
C                                                                       RWY13700
C        CALLING ROUTINES:                                              RWY13710
C          WHEREX                                                       RWY13720
C                                                                       RWY13730
C        DESCRIPTION:                                                   RWY13740
C          THIS MODULE FILLS IN THE GRID POINTS USING THE SPECIFIED     RWY13750
C          INDICES AND THE SUPPLIED AMOUNT TO BE ADDED.                 RWY13760
C                                                                       RWY13770
       DIMENSION POINTX(28)                                             RWY13780
C                                                                       RWY13790
      DO 10 K = IBEG,IEND                                               RWY13800
          POINTX(K) = POINTX(K-1) + ADDTV                               RWY13810
   10 CONTINUE                                                          RWY13820
C                                                                       RWY13830
      RETURN                                                            RWY13840
      END                                                               RWY13850
C                                                                       RWY13860
C=======================================================================RWY13870
C                                                                       RWY13880
      SUBROUTINE CENTER(IR1,klane,WIDL,X,NX,XV,HWAYL)                   RWY13890
C                                                                       RWY13900
C        PARAMETER LIST:                                                RWY13910
C          INPUT:   IR1   - WIND DIRECTION INDICATOR                    RWY13950
C                   klane - NUMBER OF TRAFFIC LANES (AT LEAST 4; MAXIMUMRWY13960
C                           OF 10; INCREMENTS OF 2 ONLY)                RWY13970
C                   WIDL  - WIDTH OF ONE LANE (METERS)                  RWY13980
C                   X     - GRID POINTS IN THE X DIRECTION.  CONTAINED  RWY13990
C                           IN THIS ARRAY ARE THE LANE LOCATIONS.       RWY14000
C                   NX    - NUMBER OF GRID POINTS IN THE X DIRECTION    RWY14010
C          OUTPUT:  XV    - ARRAY CONTAINING CENTER OF TRAFFIC LANES    RWY14020
C                           (METERS)                                    RWY14030
C                   HWAYL - OUTPUT ARRAY CONTAINING LANE LOCATIONS      RWY14040
C                                                                       RWY14050
C        CALLING ROUTINE:                                               RWY14060
C          MAIN                                                         RWY14070
C                                                                       RWY14080
C        DESCRIPTION:                                                   RWY14090
C          THIS SUBROUTINE DETERMINES THE CENTER OF EACH TRAFFIC LANE.  RWY14100
C          THE X DIRECTION GRID POINTS AND TRAFFIC LANE LOCATIONS ARE   RWY14110
C          OUTPUT HERE.                                                 RWY14120
C                                                                       RWY14130
      DIMENSION X(28),XV(16),HWAYL(28),HWAYST(28)                       RWY14150
      CHARACTER*4 BLNKL,XLANE,HWAYL
      CHARACTER*1 BLNKST,STAR,HWAYST
      DATA BLNKL/'    '/, BLNKST/' '/, XLANE/'----'/, STAR/'*'/         RWY14160
      DATA IN/5/, IO/6/                                                 RWY14170
C                                                                       RWY14180
C***      INITIALIZE.                                                   RWY14190
C                                                                       RWY14200
      DO 10 I = 1,28                                                    RWY14210
         HWAYL(I)  = BLNKL                                              RWY14220
         HWAYST(I) = BLNKST                                             RWY14230
   10 CONTINUE                                                          RWY14240
C                                                                       RWY14250
C***      DETERMINE THE NUMBER OF LANES ON EITHER SIDE OF MEDIAN.       RWY14260
C                                                                       RWY14270
      MLANE = klane/2                                                   RWY14280
C                                                                       RWY14290
C***      FIND THE CENTER OF THE LEFTMOST LANE.                         RWY14300
C                                                                       RWY14310
      XV(1) =  X(IR1+2)                                                 RWY14320
      HWAYL(IR1+2)  = XLANE                                             RWY14330
      HWAYST(IR1+2) = STAR                                              RWY14340
C                                                                       RWY14350
C***      FIND THE CENTER OF THE REMAINING LEFT LANES.  FLAG THEIR      RWY14360
C***      LOCATIONS.                                                    RWY14370
C                                                                       RWY14380
      I = 0                                                             RWY14390
      DO 20 K = 2,MLANE                                                 RWY14400
         XV(K) = XV(K-1) + WIDL                                         RWY14410
         I = I + 1                                                      RWY14420
         HWAYL(IR1+2+I)  = XLANE                                        RWY14430
         HWAYST(IR1+2+I) = STAR                                         RWY14440
   20 CONTINUE                                                          RWY14450
C                                                                       RWY14460
C***      DETERMINE NEXT ELEMENT TO BE FILLED IN THE LANE CENTER ARRAY  RWY14470
C***      (XV) AND THE CORRESPONDING INDEX IN THE GRID ARRAY (X).       RWY14480
C                                                                       RWY14490
      INDX  = MLANE + 1                                                 RWY14500
      INDX2 = MLANE + IR1 + 5                                           RWY14510
C                                                                       RWY14520
C***      FIND THE CENTER OF THE LANE JUST TO THE RIGHT OF THE MEDIAN.  RWY14530
C                                                                       RWY14540
      XV(INDX) =  X(INDX2)                                              RWY14550
C                                                                       RWY14560
C***      DETERMINE THE BEGINNING AND ENDING INDICES TO COMPLETE        RWY14570
C***      FILLING THE RIGHT LANE CENTERS.  FILL THE LANE CENTER ARRAY.  RWY14580
C                                                                       RWY14590
      IBEG = INDX + 1                                                   RWY14600
      IEND = INDX + MLANE - 1                                           RWY14610
      HWAYL(INDX2)  = XLANE                                             RWY14620
      HWAYST(INDX2) = STAR                                              RWY14630
C                                                                       RWY14640
      I = 0                                                             RWY14650
      if (iend .gt. 10) then
         i = 0
      endif
      DO 30 K = IBEG,IEND                                               RWY14660
         XV(K) = XV(K-1) + WIDL                                         RWY14670
         I = I + 1                                                      RWY14680
         HWAYL(INDX2 + I)  = XLANE                                      RWY14690
         HWAYST(INDX2 + I) = STAR                                       RWY14700
   30 CONTINUE                                                          RWY14710
C                                                                       RWY14720
C                                                                       RWY14780
      RETURN                                                            RWY14790
C                                                                       RWY14820
      END                                                               RWY14890
C                                                                       RWY14900
C=======================================================================RWY14910
C                                                                       RWY14920
      SUBROUTINE WAKE(UB,VB,VSPD,VSPD1,H,NV,NV1,WID,X,Z,NX,             RWY14930
     1                KMAX,XV,klane,DU,DV,KXP,KZP,KXPAS,KYPAS,KYP,IERR) RWY14940
C                                                                       RWY14950
C        PARAMETER LIST:                                                RWY14960
C          INPUT:   UB    - VERTICAL PROFILE OF U COMPONENT OF WIND     RWY14970
C                           (M/SEC)                                     RWY14980
C                   VB    - VERTICAL PROFILE OF V COMPONENT OF WIND     RWY14990
C                           (M/SEC)                                     RWY15000
C                   VSPD  - AVERAGE VEHICLE SPEED IN SOUTHBOUND LANES   RWY15010
C                           (M/SEC)                                     RWY15020
C                   VSPD1 - AVERAGE VEHICLE SPEED IN NORTHBOUND LANES   RWY15030
C                           (M/SEC)                                     RWY15040
C                   H     - AVERAGE HEIGHT OF VEHICLES (METERS)         RWY15050
C                   NV    - SOUTHBOUND TRAFFIC VOLUME (VEH/HR)          RWY15060
C                   NV1   - NORTHBOUND TRAFFIC VOLUME (VEH/HR)          RWY15070
C                   WID   - AVERAGE WIDTH OF VEHICLES (METERS)          RWY15080
C                   X     - GRID POINTS IN THE X DIRECTION (METERS)     RWY15090
C                   Z     - GRID POINTS IN THE Z DIRECTION (METERS)     RWY15100
C                   NX    - NUMBER OF GRID POINTS IN X DIRECTION        RWY15110
C                   KMAX  - NUMBER OF GRID POINTS IN Z DIRECTION        RWY15120
C                   XV    - LANE CENTER ARRAY                           RWY15130
C                   klane - NUMBER OF TRAFFIC LANES                     RWY15140
C                   DU    - VEHICLE WAKE EFFECTS ON THE U FIELD         RWY15150
C                   DV    - VEHICLE WAKE EFFECTS ON THE V FIELD         RWY15160
C                   KXP   - WAKE TURBULENCE IN X DIRECTION (M**2/SEC)   RWY15170
C                   KZP   - WAKE TURBULENCE IN Z DIRECTION (M**2/SEC)   RWY15180
C                   KXPAS - WAKE PASSING EFFECT IN X DIRECTION          RWY15190
C                           (M**2/SEC)                                  RWY15200
C                   KYPAS - WAKE PASSING EFFECT IN Y DIRECTION          RWY15210
C                           (M**2/SEC)                                  RWY15220
C                   KYP   - WAKE TURBULENCE IN Y DIRECTION (M**2/SEC)   RWY15230
C                   IERR  - ERROR INDICATOR (0 = NO ERROR)              RWY15240
C                                                                       RWY15250
C        CALLING ROUTINE:                                               RWY15260
C          MAIN                                                         RWY15270
C                                                                       RWY15280
C        SUBPROGRAMS CALLED:                                            RWY15290
C          FC*, POLY*, SIMPSN                                           RWY15300
C                                                                       RWY15310
C          *  INDICATES FUNCTION CALL                                   RWY15320
C                                                                       RWY15330
C        DESCRIPTION:                                                   RWY15340
C          THIS SUBROUTINE CALCULATES THE CHANGES IN THE WIND AND       RWY15350
C          TURBULENCE FIELDS DUE TO THE VEHICLE WAKES.  IT CAN ALSO     RWY15360
C          CALCULATE THE WAKE PASSING EFFECT (ESKRIDGE AND RAO, 1983),  RWY15370
C          BUT IT DOES NOT DO THESE CALCULATIONS NORMALLY.              RWY15380
C                                                                       RWY15390
C        DEFINITIONS OF IMPORTANT VARIABLES:                            RWY15400
C          ALP    - ANGLE BETWEEN Y-AXIS AND S-AXIS                     RWY15410
C          BETA   - ANGLE BETWEEN X-AXIS AND S-AXIS                     RWY15420
C          RHO    - DENSITY OF AIR                                      RWY15430
C          RX     - ARRAY OF X-AXIS GRID POINTS PROJECTED ON R-AXIS     RWY15440
C                                                                       RWY15450
      DIMENSION KPX(41),KPY(41),UB(8),DV(28,8),VB(8),DU(28,8),XV(12)    RWY15480
      DIMENSION KXP(28,8),KYP(28,8),KZP(28,8),RX(41)                    RWY15490
      DIMENSION KXI(41),KYI(41),KZI(41),X(28),Z(8),YV(41)               RWY15500
      DIMENSION S(41),DQ(41),KXPAS(28,8),KYPAS(28,8)                    RWY15510
      REAL KPX,KPY,NV,NV1,KXP,KZP,KXPAS,KYPAS,OMEGA,KYP                 RWY15460
      REAL KXI,KYI,KZI                                                  RWY15470
      DATA PI/3.141592654/,GAMA/.095/                                   RWY15520
      DATA CD/.45/,A1/.048/,A2/.040/,A3/.030/                           RWY15530
      DATA IN/5/, IO/6/                                                 RWY15540
C                                                                       RWY15550
C***      INITIALIZE.                                                   RWY15560
C                                                                       RWY15570
      IWAKEP = 0                                                        RWY15580
C         WAKE PASSING EFFECT TURNED OFF.                               RWY15590
      DO 20 I = 1,NX                                                    RWY15600
         DO 10 K = 1,KMAX                                               RWY15610
            KXP(I,K)   = 0.0                                            RWY15620
            KZP(I,K)   = 0.0                                            RWY15630
            KYP(I,K)   = 0.0                                            RWY15640
            KXPAS(I,K) = 0.0                                            RWY15650
            KYPAS(I,K) = 0.0                                            RWY15660
            DU(I,K)    = 0.0                                            RWY15670
            DV(I,K)    = 0.0                                            RWY15680
   10    CONTINUE                                                       RWY15690
   20 CONTINUE                                                          RWY15700
      VSP = -VSPD                                                       RWY15710
      FNV = NV                                                          RWY15720
      DO 250 J = 1,klane                                                RWY15730
      IF (J .GT. klane/2) VSP = ABS(VSPD1)                              RWY15740
      IF (J .GT. klane/2) FNV = NV1                                     RWY15750
crgi
	if (abs(ub(2)).lt.0.001) ub(2)= sign(0.001,ub(2))
c
      BETA = ATAN(ABS((VSP + VB(2))/UB(2)))                             RWY15760
      ALP = 0.5 * PI - ABS(BETA)                                        RWY15770
C                                                                       RWY15780
C***      FOR THE GRID POINT X(I) AND A GIVEN WIND SPEED AND VEHICLE    RWY15790
C***      SPEED THE INTERCEPT OF THE CENTERLINE OF THE WAKE ON THE      RWY15800
C***      Y-AXIS AND THRU X(I) IS DETERMINED.  DELY IS DETERMINED SO    RWY15810
C***      THAT DX WILL PROPERLY RESOLVE THE WAKE AS IT PASSES THE       RWY15820
C***      POINT X(I).                                                   RWY15830
C                                                                       RWY15840
C***      AT THE POINT (X,Z) THE INTEGRAL THAT YIELDS THE WAKE          RWY15850
C***      PROPERTIES HAS AN INTEGRATION RANGE OVER WHICH THE FUNCTION   RWY15860
C***      THAT IS BEING INTEGRATED IS MAINLY ZERO.  THEREFORE A MODIFIEDRWY15870
C***      APPROACH IS TAKEN.  AN INTEGRATION RANGE OF (X-2, X+2) AROUND RWY15880
C***      THE X GRID POINT IS CHOSEN.  ASSUMING WHEN WAKE CENTERLINE IS RWY15890
C***      OUT OF THIS RANGE THE WAKE DOES NOT HAVE AN EFFECT AT THE     RWY15900
C***      POINT, AND THEN THE POSITION OF THE VEHICLE IS DETERMINED.    RWY15910
C                                                                       RWY15920
      DO 200 I = 1,NX                                                   RWY15930
      XDST = X(I) - XV(J)                                               RWY15940
      XLRG = 2.                                                         RWY15950
      XDL = XDST - XLRG                                                 RWY15960
      XDR = XDST + 2.                                                   RWY15970
      IF (XDL*XDR .GT. 0.0) GO TO 30                                    RWY15980
C                                                                       RWY15990
C***      CASE WHERE X(I) = XV(J) MUST BE HANDLED SEPARATELY.           RWY16000
C                                                                       RWY16010
      IF (UB(2) .LT. 0.0) XDR = -0.1                                    RWY16020
      IF (UB(2) .LT. 0.0) XLRG = 1.8                                    RWY16030
      IF (UB(2) .GT. 0.0) XLRG = 0.1                                    RWY16040
      IF (UB(2) .GT. 0.0) XDL = 0.1                                     RWY16050
   30 XRNG = ABS(XDR - XDL)                                             RWY16060
      DX = XRNG * 0.025                                                 RWY16070
      DELY = ABS(DX/TAN(ALP))                                           RWY16080
      SLOPE = ((VSP + VB(2))/(-UB(2)))                                  RWY16090
C                                                                       RWY16100
C***      TEST TO SEE IF VEHICLE IS UPWIND OF X-AXIS GRID POINT.        RWY16110
C                                                                       RWY16120
      B2 = -SLOPE * (X(I))                                              RWY16130
      YVEH = SLOPE * XV(J) + B2                                         RWY16140
C
C     CHECK FOR YVEH CLOSE TO ZERO
C
      TEST1 = ABS(SLOPE * XV(J))
      IF (ABS(B2) .GT. TEST1) TEST1 = B2                                
      IF (TEST1/1.0E6 .GT. ABS(YVEH)) YVEH = 0.0
C
      IF ((VSP + VB(2)) * YVEH .LT. 0.0) GO TO 200                      RWY16150
      DO 50 N = 1,41                                                    RWY16160
         XD = (X(I) - XLRG) + (N-1) * DX                                RWY16170
C                                                                       RWY16180
C***         Y = SLOPE * X + B0, SOLVE FOR B0 WHICH IS THE Y-AXIS       RWY16190
C***         INTERCEPT, XD IS THE X-AXIS INTERCEPT, Y0 THE VEHICLE      RWY16200
C***         POSITION.  Y = -1/SLOPE + B1 LINE THRU X(I) NORMAL TO      RWY16210
C***         CENTERLINE OF WAKE.                                        RWY16220
C                                                                       RWY16230
         B0 = -SLOPE * XD                                               RWY16240
         Y0 = SLOPE * XV(J) + B0                                        RWY16250
         B1 = X(I)/SLOPE                                                RWY16260
C                                                                       RWY16270
C***         INTERSECTION OF THE TWO LINES DETERMINES S AND RX          RWY16280
C***         S  = DIST( (XV(J),Y0),(XI,YI) )                            RWY16290
C***         RX = DIST( ( X(I), 0),(XI,YI) )                            RWY16300
C                                                                       RWY16310
         XI = (B1 - B0)/(SLOPE + 1./SLOPE)                              RWY16320
         YI = SLOPE * XI + B0                                           RWY16330
         S(N)  = SQRT((XI - XV(J))**2 + (Y0 - YI)**2)                   RWY16340
         RX(N) = SQRT((X(I) - XI)**2 + YI**2)                           RWY16350
   50 CONTINUE                                                          RWY16360
C                                                                       RWY16370
C***      THE FOLLOWING CODE DOES THE WAKE CALCULATION AND SUMS THE     RWY16380
C***      EFFECTS OF THE WAKES.                                         RWY16390
C                                                                       RWY16400
      QB = SQRT((VSP + VB(2))**2 + UB(2)**2)                            RWY16410
      A = (CD/(32. * PI * EXP(.5) * 1.14 * GAMA**3))**0.25              RWY16420
      DO 150 K = 2,KMAX                                                 RWY16430
         SCALNZ = Z(K)                                                  RWY16440
         IF (Z(K) .GT. 2.45) SCALNZ = 2.45                              RWY16450
         DO 100 M = 1,41                                                RWY16460
            IF (S(M) .LE. 0.0) S(M) = 1.E6                              RWY16470
            FAC = 1.0                                                   RWY16480
            IF (ABS(RX(M)) .LT. WID) FAC = 0.48 + 0.52 * ABS(RX(M))/WID RWY16490
            ZETA = (Z(K)/H)/((S(M)/H)**.25 * GAMA * A)                  RWY16500
            IF (ABS(ZETA) .LT. 1.E-20) ZETA = 0.0                       RWY16510
            ETA = RX(M)/(1.14 * GAMA * WID * A * (S(M)/H)**.25)         RWY16520
            IF (ABS(ETA) .LT. 1.E-20) ETA = 0.0                         RWY16530
            CHI = RX(M)/(WID * (S(M)/H)**.4)                            RWY16540
            IF (ABS(CHI) .LT. 1.E-20) CHI = 0.0                         RWY16550
            OMEGA = Z(K)/(H * (S(M)/H)**.4)                             RWY16560
            IF (ABS(OMEGA) .LT. 1.E-20) OMEGA = 0.0                     RWY16570
            KXI(M) = FAC * ((A * QB)**2 * (S(M)/H)**(-1.2) *            RWY16580
     1               (A1 * FC(CHI,OMEGA) * SIN(ALP) + A2 * FC(CHI,OMEGA)RWY16590
     2               * COS(ALP))) * WID                                 RWY16600
            KYI(M) = FAC * ((A * QB)**2 * (S(M)/H)**(-1.2) *            RWY16610
     1               (A1 * FC(CHI,OMEGA) * COS(ALP) + A2 * FC(CHI,OMEGA)RWY16620
     2               * SIN(ALP))) * WID                                 RWY16630
            KZI(M) = FAC * ((A * QB)**2 * (S(M)/H)**(-1.2) *            RWY16640
     1               A3 * FC(CHI,OMEGA)) * SCALNZ                       RWY16650
            DQ(M) = FAC * QB * A * (H/S(M))**0.75 * POLY(ZETA) *        RWY16660
     1              EXP(-ETA**2/8.)                                     RWY16670
 100     CONTINUE                                                       RWY16680
         CALL SIMPSN(1,41,DELY,KXI,AN1,IERR)                            RWY16690
         IF (IERR .NE. 0) GO TO 999                                     RWY16700
         CALL SIMPSN(1,41,DELY,KYI,AN2,IERR)                            RWY16710
         IF (IERR .NE. 0) GO TO 999                                     RWY16720
         CALL SIMPSN(1,41,DELY,KZI,AN3,IERR)                            RWY16730
         IF (IERR .NE. 0) GO TO 999                                     RWY16740
         CALL SIMPSN(1,41,DELY,DQ,AN4,IERR)                             RWY16750
         IF (IERR .NE. 0) GO TO 999                                     RWY16760
         KXP(I,K) = KXP(I,K) + FNV * AN1/(3600. * ABS(VSP))             RWY16770
         KYP(I,K) = KYP(I,K) + FNV * AN2/(3600. * ABS(VSP))             RWY16780
         KZP(I,K) = KZP(I,K) + FNV * AN3/(3600. * ABS(VSP))             RWY16790
         DU(I,K) = DU(I,K) - SIGN(1.,UB(2)) * FNV * AN4 * COS(BETA)/    RWY16800
     1             (3600. * ABS(VSP))                                   RWY16810
         DV(I,K) = DV(I,K) + SIGN(1.,VSP)   * FNV * AN4 * SIN(BETA)/    RWY16820
     1             (3600. * ABS(VSP))                                   RWY16830
crgi debug
	if (abs(dv(i,k) ) .gt. 10.) then
		continue
		xxxx = sqrt (dv(i,k)*dv(i,k))
	endif

  150  CONTINUE                                                         RWY16840
      DO 170 N = 1,41                                                   RWY16850
         RX(N)  = 0.0                                                   RWY16860
         YV(N)  = 0.0                                                   RWY16870
         KXI(N) = 0.0                                                   RWY16880
         KYI(N) = 0.0                                                   RWY16890
         KZI(N) = 0.0                                                   RWY16900
         S(N)   = 0.0                                                   RWY16910
  170 CONTINUE                                                          RWY16920
  200 CONTINUE                                                          RWY16930
  250 CONTINUE                                                          RWY16940
      IF (IWAKEP .EQ. 0) GO TO 999                                      RWY16950
C                                                                       RWY16960
C***      THE FOLLOWING SECTION OF CODE HAS BEEN IMMOBILIZED VIA IWAKEP.RWY16970
C***      IT CAN BE USED TO CALCULATE THE WAKE PASSING EFFECTS BY       RWY16980
C***      SETTING IWAKEP TO 1 (SEE FIRST EXECUTABLE STATEMENT IN MODULE)RWY16990
C                                                                       RWY17000
      VSP = -VSPD                                                       RWY17010
      FNV = NV                                                          RWY17020
      DO 650 J = 1,klane                                                RWY17030
      IF (J .GT. klane/2) VSP = ABS(VSPD1)                              RWY17040
      IF (J .GT. klane/2) FNV = NV1                                     RWY17050
      BETA = ATAN(ABS((VSP + VB(2))/UB(2)))                             RWY17060
      ALP = 0.5 * PI - ABS(BETA)                                        RWY17070
C                                                                       RWY17080
C***      AT THE POINT (X,Z) THE INTEGRAL THAT YIELDS THE WAKE          RWY17090
C***      PROPERTIES HAS AN INTEGRATION RANGE OVER WHICH THE FUNCTION   RWY17100
C***      THAT IS BEING INTEGRATED IS MAINLY ZERO.  THERFORE A MODIFIED RWY17110
C***      APPROACH IS TAKEN.  AN INTEGRATION RANGE OF (X-2, X+2) AROUND RWY17120
C***      THE X GRID POINT IS CHOSEN, ASSUMING WHEN WAKE CENTERLINE IS  RWY17130
C***      OUT OF THIS RANGE THE WAKE DOES NOT HAVE AN EFFECT AT THE     RWY17140
C***      POINT, AND THEN THE POSITION OF THE VEHICLE IS DETERMINED.    RWY17150
C                                                                       RWY17160
      DO 600 I = 1,NX                                                   RWY17170
      XDST = X(I) - XV(J)                                               RWY17180
      XLRG = 2.0                                                        RWY17190
      XDL = XDST - 2.0                                                  RWY17200
      IF (UB(2) .GT. 0.0) XLRG = 0.1                                    RWY17210
      XDR = XDST + 2.                                                   RWY17220
      IF (XDL*XDR .GT. 0.0) GO TO 350                                   RWY17230
C                                                                       RWY17240
C***      CASE WHERE X(I) = XV(J) MUST BE HANDLED SEPARATELY.           RWY17250
C                                                                       RWY17260
      IF (UB(2) .LT. 0.0) XDR = -0.1                                    RWY17270
      IF (UB(2) .GT. 0.0) XDL =  0.1                                    RWY17280
  350 XRNG = ABS(XDR - XDL)                                             RWY17290
      DX = XRNG * 0.025                                                 RWY17300
      SLOPE = ((VSP + VB(2))/(-UB(2)))                                  RWY17310
C                                                                       RWY17320
C***      TEST TO SEE IF VEHICLE IS UPWIND OF X-AXIS GRID POINT.        RWY17330
C                                                                       RWY17340
      B2 = -SLOPE * X(I)                                                RWY17350
      YVEH = SLOPE * XV(J) + B2                                         RWY17360
      IF ((VSP+VB(2))*YVEH .LT. 0.0) GO TO 600                          RWY17370
      DO 400 N = 1,41                                                   RWY17380
         XD = (X(I) - XLRG) + (N - 1) * DX                              RWY17390
C                                                                       RWY17400
C***         Y = SLOPE * X + B0, SOLVE FOR B0 WHICH IS THE Y-AXIS       RWY17410
C***         INTERCEPT, XD IS THE X-AXIS INTERCEPT.                     RWY17420
C***         Y = -1/SLOPE + B1 LINE THRU XD NORMAL TO CENTERLINE OF WAKERWY17430
C                                                                       RWY17440
         B0 = -SLOPE * XD                                               RWY17450
         Y0 = SLOPE * XV(J) + B0                                        RWY17460
         B1 = XD/SLOPE                                                  RWY17470
C                                                                       RWY17480
C***         INTERSECTION OF THE TWO LINES DETERMINES S AND RX          RWY17490
C***         S  = DIST( (XV(J),Y0),(XI,YI) )                            RWY17500
C***         RX = DIST( ( X(I), 0),(XI,YI) )                            RWY17510
C                                                                       RWY17520
         XI = (B1 - B0)/(SLOPE + 1./SLOPE)                              RWY17530
         YI = SLOPE * XI + B0                                           RWY17540
         S(N)  = SQRT((XI - XV(J))**2 + (Y0 - YI)**2)                   RWY17550
         RX(N) = SQRT((X(I) - XI)**2 + YI**2)                           RWY17560
  400 CONTINUE                                                          RWY17570
C                                                                       RWY17580
C***      THE FOLLOWING CODE DOES THE WAKE PASSING TURBULENCE           RWY17590
C***      CALCULATION.                                                  RWY17600
C                                                                       RWY17610
      DO 500 K = 2,KMAX                                                 RWY17620
         DO 450 M = 1,41                                                RWY17630
            IF (S(M) .LE. 0.0) S(M) = 1.E6                              RWY17640
            FAC = 1.0                                                   RWY17650
            IF (ABS(RX(M)) .LT. WID) FAC = 0.48 + 0.52 * ABS(RX(M))/WID RWY17660
            ZETA = (Z(K)/H)/((S(M)/H)**.25 * GAMA * A)                  RWY17670
            IF (ABS(ZETA) .LT. 1.E-20) ZETA = 0.0                       RWY17680
            ETA = RX(M)/(1.14 * GAMA * WID * A * (S(M)/H)**.25)         RWY17690
            IF (ABS(ETA) .LT. 1.E-20) ETA = 0.0                         RWY17700
            DQ1 = FAC * QB * A * (H/S(M))**0.75 * POLY(ZETA) *          RWY17710
     1            EXP(-ETA**2/8.)                                       RWY17720
            KPX(M) = ((UB(K) - SIGN(1.,UB(2)) * DQ1 * COS(BETA)) -      RWY17730
     1                (UB(K) + DU(I,K)))**2                             RWY17740
            KPY(M) = ((VB(K) + SIGN(1.,VSP)   * DQ1 * SIN(BETA)) -      RWY17750
     1                (VB(K) + DV(I,K)))**2                             RWY17760
  450    CONTINUE                                                       RWY17770
         CALL SIMPSN(1,41,DELY,KPX,AN6,IERR)                            RWY17780
         IF (IERR .NE. 0) GO TO 999                                     RWY17790
         CALL SIMPSN(1,41,DELY,KPY,AN7,IERR)                            RWY17800
         IF (IERR .NE. 0) GO TO 999                                     RWY17810
         KXPAS(I,K) = KXPAS(I,K) + FNV * AN6/(3600. * ABS(VSP))         RWY17820
         KYPAS(I,K) = KYPAS(I,K) + FNV * AN7/(3600. * ABS(VSP))         RWY17830
  500 CONTINUE                                                          RWY17840
      DO 520 N = 1,41                                                   RWY17850
         KPX(N) = 0.0                                                   RWY17860
         KPY(N) = 0.0                                                   RWY17870
  520 CONTINUE                                                          RWY17880
  600 CONTINUE                                                          RWY17890
  650 CONTINUE                                                          RWY17900
C                                                                       RWY17910
  999 RETURN                                                            RWY17920
      END                                                               RWY17930
C                                                                       RWY17940
C=======================================================================RWY17950
C                                                                       RWY17960
      FUNCTION FC(Y,Z)                                                  RWY17970
C                                                                       RWY17980
C        PARAMETER LIST:                                                RWY17990
C          INPUT:   Y  - SIMILARITY COORDINATE IN Y DIRECTION           RWY18000
C                   Z  - SIMILARITY COORDINATE IN Z DIRECTION           RWY18010
C          OUTPUT:  FC - TURBULENT KINETIC ENERGY IN THE Y-Z PLANE      RWY18020
C                                                                       RWY18030
C        CALLING ROUTINE:                                               RWY18040
C          WAKE                                                         RWY18050
C                                                                       RWY18060
C        DESCRIPTION:                                                   RWY18070
C          THIS FUNCTION DOES A 2-DIMENSIONAL FIT TO WIND TUNNEL DATA   RWY18080
C          OF THE TURBULENT KINETIC ENERGY TERMS IN THE Y-Z PLANE (SEE  RWY18090
C          ESKRIDGE AND THOMPSON, 1982)                                 RWY18100
C                                                                       RWY18110
      DATA A00/ .3511237E-1/, A01/ .1255308E+2/, A02/-.4796241E+2/,     RWY18120
     *     A03/ .6732523E+2/, A04/-.3572466E+2/, A20/-.1890581   /,     RWY18130
     1     A21/-.9345507E+1/, A22/-.1821427E+3/, A23/ .5617911E+3/,     RWY18140
     2     A24/-.3995373E+3/, A40/ .2649465   /, A41/-.9434068E+2/,     RWY18150
     3     A42/ .1034830E+4/, A43/-.2348153E+4/, A44/ .1510437E+4/      RWY18160
C                                                                       RWY18170
      FC = A00 + Z * (A01 + Z * (A02 + Z * (A03 + Z * A04))) +          RWY18180
     1         Y*Y * (A20 + Z * (A21 + Z * (A22 + Z * (A23 + Z * A24))))RWY18190
     2      + Y**4 * (A40 + Z * (A41 + Z * (A42 + Z * (A43 + Z * A44))))RWY18200
C                                                                       RWY18210
      IF ((ABS(Y) .GE. 0.55) .OR. (ABS(Z) .GE. 0.64)) FC = 0.0          RWY18220
      IF ((Y .LT. 0.0) .AND. (Z .GT. ( 1.82*Y+1.15))) FC = 0.0          RWY18230
      IF ((Y .GT. 0.0) .AND. (Z .GT. (-1.82*Y+1.15))) FC = 0.0          RWY18240
      IF (FC .GT. 1.0) FC = 1.0                                         RWY18250
C                                                                       RWY18260
      RETURN                                                            RWY18270
      END                                                               RWY18280
C                                                                       RWY18290
C=======================================================================RWY18300
C                                                                       RWY18310
      FUNCTION POLY(Z)                                                  RWY18320
C                                                                       RWY18330
C        PARAMETER LIST:                                                RWY18340
C          INPUT:   Z    - SIMILARITY COORDINATE VALUE IN Z DIRECTION   RWY18350
C          OUTPUT:  POLY - DETERMINES VERTICAL VARIATION OF WAKE        RWY18360
C                          VELOCITY DEFICIT                             RWY18370
C                                                                       RWY18380
C        CALLING ROUTINE:                                               RWY18390
C          WAKE                                                         RWY18400
C                                                                       RWY18410
C        DESCRIPTION:                                                   RWY18420
C          THE MODIFIED THEORY OF ESKRIDGE AND THOMPSON WAS STILL       RWY18430
C          INADEQUATE TO DESCRIBE THE VELOCITY DEFICIT BEHIND THE       RWY18440
C          VEHICLES.  THUS, A CURVE FIT WAS MADE TO WIND TUNNEL DATA.   RWY18450
C          CURVE FIT TO NORMALIZED VELOCITY AT X/H=30 OM CENTERLINE.    RWY18460
C                                                                       RWY18470
      DATA IN/5/, IO/6/                                                 RWY18480
      POLY =  .0179349 + Z * (2.576587  + Z * (-2.3062584 + Z *         RWY18490
     1       (.8951468 + Z * (-.1758604 + Z * (.016997    - Z *         RWY18500
     2        .0006404)))))                                             RWY18510
      IF (Z .GT. 8.2) POLY = 0.0                                        RWY18520
      IF (POLY .GT. 1.1) WRITE(IO,1000) Z,POLY                          RWY18530
C                                                                       RWY18540
      RETURN                                                            RWY18550
 1000 FORMAT(1X,'ZETA=',F10.5,5X,'UNORM=',F10.5)                        RWY18560
      END                                                               RWY18570
C                                                                       RWY18580
C=======================================================================RWY18590
C                                                                       RWY18600
      SUBROUTINE SIMPSN(M,N,DH,F,ANS,IERR)                              RWY18610
C                                                                       RWY18620
C        PARAMETER LIST:                                                RWY18630
C          INPUT:   M    - STARTING INDEX                               RWY18640
C                   N    - STOPPING INDEX.  N - M + 1 MUST BE ODD.      RWY18650
C                   DH   - LENGTH OF EQUAL INTERVALS.                   RWY18660
C                   F    - ARRAY CONTAINING FUNCTIONAL VALUES TO BE     RWY18670
C                          INTEGRATED                                   RWY18680
C          OUTPUT:  ANS  - VALUE OF INTEGRAL                            RWY18690
C                   IERR - ERROR INDICATOR (0 = NO ERROR)               RWY18700
C                                                                       RWY18710
C        CALLING ROUTINE:                                               RWY18720
C          WAKE                                                         RWY18730
C                                                                       RWY18740
C        DESCRIPTION:                                                   RWY18750
C          THIS MODULE PERFORMS NUMERICAL INTEGRATION USING SIMPSON'S   RWY18760
C          METHOD.                                                      RWY18770
C                                                                       RWY18780
      DIMENSION F(N)                                                    RWY18790
      DATA IN/5/, IO/6/                                                 RWY18800
C                                                                       RWY18810
C***      TEST FOR M - N + 1 ODD.                                       RWY18820
C                                                                       RWY18830
      ITST = MOD(N-M+1,2)                                               RWY18840
      IF (ITST .EQ. 1) GO TO 100                                        RWY18850
         IERR = 20                                                      RWY18860
         WRITE(IO,1000) IERR                                            RWY18870
         GO TO 999                                                      RWY18880
  100 CONTINUE                                                          RWY18890
C                                                                       RWY18900
C***      PERFORM NUMERICAL INTEGRATION.                                RWY18910
C                                                                       RWY18920
      SUM = 0.0                                                         RWY18930
      SUM = F(M) + F(N)                                                 RWY18940
      K = 0                                                             RWY18950
      JJ = M + 1                                                        RWY18960
      KK = N - 1                                                        RWY18970
      DO 110 I = JJ,KK,1                                                RWY18980
         IF (K .EQ. 1) GO TO 105                                        RWY18990
            SUM = SUM + 4.0 * F(I)                                      RWY19000
            K = 1                                                       RWY19010
            GO TO 110                                                   RWY19020
  105    CONTINUE                                                       RWY19030
         SUM = SUM + 2.0 * F(I)                                         RWY19040
         K = 0                                                          RWY19050
  110 CONTINUE                                                          RWY19060
      ANS = SUM * DH/3.                                                 RWY19070
C                                                                       RWY19080
  999 RETURN                                                            RWY19090
C                                                                       RWY19100
 1000 FORMAT('0*** ERROR ',I2,':  N - M + 1 IS NOT ODD.')               RWY19110
      END                                                               RWY19120
C                                                                       RWY19130
C=======================================================================RWY19140
C                                                                       RWY19150
      SUBROUTINE NONDIV(U,NX,KMAX,X,Z,W)                                RWY19160
C                                                                       RWY19170
C        PARAMETER LIST:                                                RWY19180
C          INPUT:   U    - U COMPONENT FIELD (M/SEC)                    RWY19190
C                   NX   - NUMBER OF GRID POINTS IN X DIRECTION         RWY19200
C                   KMAX - NUMBER OF GRID POINTS IN Z DIRECTION         RWY19210
C                   X    - GRID POINTS IN THE X DIRECTION (METERS)      RWY19220
C                   Z    - GRID POINTS IN THE Z DIRECTION (METERS)      RWY19230
C          OUTPUT:  W    - VERTICAL VELOCITY FIELD (M/SEC)              RWY19240
C                                                                       RWY19250
C        CALLING ROUTINE:                                               RWY19260
C          MAIN                                                         RWY19270
C                                                                       RWY19280
C        DESCRIPTION:                                                   RWY19290
C          THE VERTICAL VELOCITY IS COMPUTED BY CALCULATING THE INFLOW  RWY19300
C          AND OUTFLOW IN THE X-DIRECTION FROM THE U FIELD AND THE      RWY19310
C          VERTICAL INFLOW IN THE BOTTOM OF A BOX AROUND EACH GRID      RWY19320
C          POINT.  THE VERTICAL VELOCITY AT THE GRID POINT IS A LINEAR  RWY19330
C          INTERPOLATION OF THE VERTICAL VELOCITY AT THE BOTTOM AND TOP RWY19340
C          BOUNDARIES OF THE BOX.  TO THE DEGREE THAT THE WIND FIELD    RWY19350
C          CONTAINS DIVERGENCE, ERROR IS INTRODUCED IN THE COMPUTATIONS.RWY19360
C                                                                       RWY19370
      DIMENSION WTOP(28),WBOT(28),X(28),Z(8),W(28,8),U(28,8)            RWY19380
C                                                                       RWY19390
      NX1 = NX - 1                                                      RWY19400
      KM = KMAX - 1                                                     RWY19410
      DO 20 K = 2,KM                                                    RWY19420
         DO 10 I = 2,NX1                                                RWY19430
            X2 = (X(I+1) + X(I)  )/2.                                   RWY19440
            X1 = (X(I)   + X(I-1))/2.                                   RWY19450
            DELX = X2 - X1                                              RWY19460
            U2 = (U(I+1,K) + U(I,K)  )/2.                               RWY19470
            U1 = (U(I,K)   + U(I-1,K))/2.                               RWY19480
            DELU = U2 - U1                                              RWY19490
            Z2 = (Z(K+1) + Z(K)  )/2.                                   RWY19500
            Z1 = (Z(K)   + Z(K-1))/2.                                   RWY19510
            DELZ = Z2 - Z1                                              RWY19520
            IF (K .GT. 2) WBOT(I) = WTOP(I)                             RWY19530
            IF (K .EQ. 2) WBOT(I) = 0.0                                 RWY19540
            WTOP(I) = WBOT(I) - DELZ * DELU/DELX                        RWY19550
            W(I,K)  = (WTOP(I) + WBOT(I))/2.                            RWY19560
   10    CONTINUE                                                       RWY19570
   20 CONTINUE                                                          RWY19580
C                                                                       RWY19590
      DO 30 K = 1,KMAX                                                  RWY19600
         W(1,K)  = W(2,K)                                               RWY19610
         W(NX,K) = W(NX1,K)                                             RWY19620
   30 CONTINUE                                                          RWY19630
C                                                                       RWY19640
      DO 40 I = 1,NX                                                    RWY19650
         W(I,KMAX) = W(I,KMAX-1)                                        RWY19660
   40 CONTINUE                                                          RWY19670
C                                                                       RWY19680
      RETURN                                                            RWY19690
      END
C                                                                       RWY14900
C=======================================================================
C                                                                      
      subroutine golder (stab,z0,al)
C                                                                       
C        PARAMETER LIST:                                                
C          INPUT:   stab  - stability class
C                   z0    - surface roughness   
C          OUTPUT:  l     - Monicoff Length
C                                                           
C                                                                       
C        CALLING ROUTINE:                                              
C         SBLAYR                                                        
C                                                                      
C        SUBPROGRAMS CALLED:                                            
C          None                                          
C                                                                     
C        DESCRIPTION:                                                  
C          THIS SUBROUTINE CALCULATES THE xxx length       
C          Code came from SLAB     
C                                                                       
C                                                                  
crgi.............................................................
      al1 = .0081/(z0**.3044)
      if (z0 .gt. .0111) then
         al2 = .0385/(z0**.1715)
         al3 = .0875/(z0**.1028)
      else
         al2 = al1 +.0137/(z0**.1715) + .0218
         al3 = al2 +.0557
      endif

      en2 = log(al2/al1)/log(2.)
      en3 = log(al3/al1)/log(3.)
      eni = en3 + en3 - en2
      dln = en2 - eni
      alm = al1*(3.5**(eni+dln/3.25))

      stb = stab -4.0
      astb = abs(stb)
      if (astb .eq. 0.0) then
         aal = 1.0e-20
      else if (astb .lt. 2.0) then
         aal = al1*(astb**en2)
      else if (astb .lt. 3.5) then
         en = eni + dln/(1.+(astb-2.)*(astb-2.))
         aal = al1*(astb**en)
      else
         aal = alm
      endif

      if (stb.ge.0.) then
         ala = aal
      else
         ala = -aal
      endif

      al = 1.0 / ala

      return
      end

