      SUBROUTINE CALCDS (IV, IOV, ICONF2)                               
C                                                                       
C --- CODED    3-16-95 BY S. WALKER                                     
C                                                                       
C --- TITLE - CALCULATE DISTANCE TO CONFLICT WITH OPPOSING VEHICLE      
C                                                                       
C --- FUNCTION - THIS MODULE CALCULATES THE DISTANCE FROM VEHICLE, IV,  
C ---            TO THE CONFLICT WITH ITS OPPOSING VEHICLE, IOV.        
C                                                                       
C --- ARGUMENTS - IV     = VEHICLE BEING DISCHARGED, FROM CALLING       
C ---                      ROUTINE                                      
C ---             IOV    = VEHICLE THAT OPPOSES VEHICLE, IV, FROM       
C ---                      CALLING ROUTINE                              
C ---             ICONF2 = DISTANCE TO CONFLICT WITH OPPOSING VEHICLE,  
C ---                      IN FEET, TO CALLING ROUTINE                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CALCULATES THE DISTANCE WHERE VEHICLE, IV, WILL       
C     CONFLICT WITH ITS OPPOSING VEHICLE, IOV.  THE DISTANCE IS         
C     CALCULATED BASED ON THE ARRANGMENT OF THE OPPOSING LINKS (WHETHER 
C     AN OPPOSER, FAR CROSS LINK OR NEAR CROSS LINK) AND VEHICLE'S,     
C     IV'S, TURN MOVEMENT.                                              
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                               GETGAP                                  
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                               GTNLAN                                  
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     CROSFR  LINK SPECIFIC ARRAY - LINK OF FAR-CROSS APPROACH AT       
C             DOWNSTREAM NODE                                           
C     CROSNR  LINK SPECIFIC ARRAY - LINK OF NEAR-CROSS APPROACH AT      
C             DOWNSTREAM NODE                                           
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK FOR LINK, IL
C     IDIS1   DISTANCE THAT OPPOSING LINK IS WITHIN INTERSECTION        
C     IDIS2   DISTANCE ON RECEIVING LINK, IRL, THAT VEHICLE, IV, WILL BE
C             PLACED AFTER DISCHARGING FROM LINK, IL                    
C     I       COUNTER FOR NUMBER OF LANES TO RIGHT OF LANE              
C     IL      LINK THAT SUBJECT VEHICLE OCCUPIES                        
C     ILLANE  NUMBER OF LANES TO THE LEFT OF LANE ON LINK               
C     ILN     LANE ON LINK, IL, THAT SUBJECT VEHICLE OCCUPIES           
C     IOL     LINK THAT OPPOSING VEHICLE OCCUPIES                       
C     IOLN    LANE ON LINK, IOL, THAT OPPOSING VEHICLE OCCUPIES         
C     IRL     RECIEVING LINK FOR VEHICLE, IV                            
C     IRLANE  NUMBER OF LANES TO THE RIGHT OF LANE ON LINK              
C     IRLN    LANE TO RIGHT OF LANE                                     
C     K       INDEX TO XWIDTH ARRAY FOR LANE                            
C     LEFT    LINK SPECIFIC ARRAY - LEFT RECEIVING LINK FOR LINK, IL    
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                    
C     NVHLNK  VEHICLE SPECIFIC ARRAY - LINK OCCUPIED                    
C     NVHTYP  VEHICLE SPECIFIC ARRAY - VEHICLE TYPE CODE, 1-16          
C     OPPOSE  LINK SPECIFIC ARRAY - LINK THAT OPPOSES LEFT TURN ON LINK 
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE               
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK FOR LINK, IL    
C     VTYPLE  VEHICLE TYPE SPECIFIC ARRAY - LENGTH OF VEHICLE TYPE      
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH, # OF LANES ACROSS INTER
C     XWIDTH  LINK SPECIFIC ARRAY - LANE WIDTHS                         
C                                                                       
C --------------------------------------------------------------------  
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  CALCULATE DISTANCE, IDIS1, WITHIN INTERSECTION TO LANE OF      
C -----  OPPOSER.                                                       
C                                                                       
      ICONF2 = 0                                                        
      IDIS1 = 0                                                         
      IDIS2 = 0                                                         
      IL   = NVHLNK(IV)                                                 
      ILN  = NLANE(IV)                                                  
      IOL  = NVHLNK(IOV)                                                
      IOLN = NLANE(IOV)                                                 
      CALL GTNLAN (IOL,IOLN,ILLANE,IRLANE)                              
      IF (IRLANE .GT. 0) THEN                                           
          DO 10 I = 1, IRLANE                                           
             IRLN = IOLN - I                                            
             IF (IRLN .LE. 0) THEN                                      
                 IRLN = 7 - IRLN                                        
             ENDIF                                                      
             K = (IRLN - 1) * 4                                         
             IDIS1 = IDIS1 + MOD(XWIDTH(IOL)/2**K,2**4)                 
   10     CONTINUE                                                      
      ENDIF                                                             
C                                                                       
C                                                                       
C                                                                       
      IF (IOL .EQ. OPPOSE(IL)) THEN                                     
          K = (IOLN - 1) * 4                                            
          IDIS1 = IDIS1 + MOD(XWIDTH(IOL)/2**K,2**4)                    
C                                                                       
C -----  CALCULATE DISTANCE, IDIS2, AT WHICH VEHICLE, IV, WILL START    
C -----  ON RECEIVING LINK.                                             
C                                                                       
          IDIS2 = 0                                                     
          CALL GTNLAN (IL, ILN, ILLANE, IRLANE)                         
          IDIS2 = VTYPLE(NVHTYP(IV)) + IRLANE * 10                      
C                                                                       
C -----  CALCULATE DISTANCE, ICONF2, ON NEW LINK TO POINT OF CONFLICT   
C -----  WITH OPPOSER.                                                  
C                                                                       
          IRL = LEFT(IL)                                                
          ICONF2 = (XLNGTH(IRL) / 2**12)*10 - IDIS1 - IDIS2             
C                                                                       
C                                                                       
C                                                                       
      ELSEIF (IOL .EQ. CROSFR(IL)) THEN                                 
C                                                                       
         IF (TCODE(IV) .NE. 0 .AND. TCODE(IV) .NE. 2) THEN              
             K = (IOLN - 1) * 4                                         
             IDIS1 = IDIS1 + MOD(XWIDTH(IOL)/2**K,2**4)                 
             IRL = IABS (DIAGNL(IL))                                    
             IF (TCODE(IV) .EQ. 1) IRL = THRU(IL)                       
             ICONF2 = (XLNGTH(IRL) / 2**12)*10 - IDIS1                  
         ENDIF                                                          
C                                                                       
C                                                                       
C                                                                       
      ELSEIF (IOL .EQ. CROSNR(IL)) THEN                                 
C                                                                       
         IF (TCODE(IV) .NE. 2)   ICONF2 = IDIS1                         
C                                                                       
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CALCSP (IV, JSPEED)                                    
C                                                                       
C --- CODED    3-16-95 BY S. WALKER                                     
C                                                                       
C --- TITLE - CALCULATE DISCHARGE SPEED FOR VEHICLE                     
C                                                                       
C --- FUNCTION - THIS MODULE CALCULATES THE SPEED AT WHICH VEHICLE, IV, 
C ---            WILL DISCHARGE FROM LINK, I2.                          
C                                                                       
C --- ARGUMENTS - IV     = VEHICLE BEING DISCHARGED, FROM CALLING       
C ---                      ROUTINE                                      
C ---             JSPEED = VEHICLE SPEED AT STOP-LINE, TO CALLING       
C ---                      ROUTINE                                      
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE MOVES A DISCHARGING VEHICLE TO THE STOP-LINE. THE     
C     VEHICLES SPEED, ACCELERATION AND TIME SPENT REACHING THE STOP-    
C     LINE ARE CALCULATED, FOR A QUEUED VEHICLE, A SUBORDINATE MODULE   
C     IS CALLED TO CALCULATE THE INTER-DISCHARGE HEADWAY SEPARATING     
C     THIS VEHICLE, IV, AND ITS FOLLOWER (IF IT EXISTS).                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GETGAP - MODULE 3                                  
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                               NONE                                    
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ACCEL   VEHICLE SPECIFIC ARRAY - ACCELERATION                     
C     ACCODE  VEHICLE SPECIFIC ARRAY - ACCEL/DECEL (0/1) CODE           
C     ARTESP  RIGHT-TURN SPEED                                          
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE FROM UPSTRIAM NODE      
C     IACC    VEHICLE ACCELERATION AT STOP-LINE                         
C     IAMAX   MAX. ACCEL. (10 * FPSS) AT 0 SPEED FOR A GIVEN VEH. TYPE  
C     ICODE   CODE IDENTIFYING DISCHARGE SPEED OF VEHICLE               
C     IDIS    DISTANCE TO STOP-LINE                                     
C     IFRSPD  DESIRED FREE-FLOW SPEED FOR VEHICLE, IV, ON THIS LINK     
C     IL      LINK NUMBER                                               
C     ISLOPE  SLOPE * 1000 RELATING MAX ACCEL TO ATTAINABLE SPEED       
C     ISPD    VEHICLE SPEED, FT/SEC                                     
C     ISPDF   MAX.DISCHARGE SPEED OF VEHICLE FIRST IN QUEUE             
C     ISPEED  MAX ATTAINABLE SPEED BASED ON LINK AND VEH CHARACTERISTICS
C     ISTATV  STATUS OF SUBJECT VEHICLE                                 
C     ITIME   TIME USED IN TIME-STEP, SEC * 10, TO REACH STOP-LINE      
C     ITURN   TURN MOVEMENT CODE                                        
C     IV      SUBJECT VEHICLE                                           
C     IVTYP   SUBJECT VEHICLE TYPE                                      
C     K       INDEX TO LANEV ARRAY                                      
C     LEFTSP  LEFT-TURN SPEED                                           
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                    
C     NVHLNK  VEHICLE SPECIFIC ARRAY - LINK OCCUPIED                    
C     NVHTYP  VEHICLE TYPE ARRAY - VEHICLE TYPE CODE, 1-16              
C     SPDLN   VEHICLE SPECIFIC ARRAY - VEHICLE SPEED, FT/SEC            
C     STPTHR  STOPPED-DELAY SPEED THRESHOLD                             
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE               
C     TIMDIS  VEHICLE SPECIFIC ARRAY - TIME REMAINING TO DISCHARGE      
C             FROM QUEUE, SEC * 10                                      
C     TTLILK  TOTAL NUMBER OF INTERNAL LINKS IN SUBNETWORK              
C     VFFSPD  VEHICLE SPECIFIC ARRAY - DESIRED FREE-FLOW SPEED          
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE                      
C     VTYPAH  VEHICLE TYPE ARRAY - MAX. ACCEL. AND HDWY FACTOR          
C     VTYPSP  VEHICLE TYPE ARRAY - MAXIMUM SPEED AT 0 ACCELERATION      
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH                         
C                                                                       
C --------------------------------------------------------------------  
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IL = NVHLNK(IV)                                                   
      ISTATV = VSTATE(IV)                                               
      ISPD = SPDLN(IV)                                                  
      IDIS = MOD (XLNGTH(IL), 2**12) - DISTUP(IV)                       
      IFRSPD = ISPD + 10                                                
      IF (IL .LE. TTLILK) IFRSPD = VFFSPD(IV)                           
      K = 7 * (IL-1) + NLANE(IV)                                        
C                                                                       
C -----  IF VEHICLE, IV, IS NOT IN QUEUE. GET VEHICLE ACCELERATION,     
C -----  IACC, AND TIME TO REACH STOP-LINE. TRA FOR VEHICLE WITH        
C -----  ZERO SPEED AT STOP-LINE. ELSE, DO NOT PRRMIT ZERO              
C -----  SPEED. (FAIL SAFE MEASURE)  IACC WAS CALCULATED IN TSIG AND    
C -----  STORED IN ACCEL.                                               
C                                                                       
      IF (ISTATV .EQ. 0) THEN                                           
          ITIME = 0                                                     
          IACC = ACCEL(IV)                                              
          IF (ACCODE(IV) .GT. 0) IACC = -IACC                           
          IF (ISPD .GT. 0 .AND. IDIS .GT. 0) THEN                       
              ISPD = MAX0(ISPD, 2)                                      
              ITIME = (((IDIS * 100) / ISPD) * (100 - (50 * IACC        
     1                  * IDIS) / (ISPD * ISPD)) + 500) / 1000          
              ITIME = MIN0(MAX0(ITIME, 0), 9)                           
          ENDIF                                                         
      ELSE                                                              
C                                                                       
C -----  WHEN VEHICLE, IV, IS IN QUEUE, DEFINE TIME                     
C -----  REMAINING FOR THIS VEHICLE TO DISCHARGE (0-9 SEC * 10).        
C                                                                       
          ITIME = MIN0 (MAX0 (TIMDIS(IV), 0), 9)                        
C                                                                       
C -----  CALCULATE DISCHARGE SPEED AND ACCELERATION OF VEHICLE, IV,     
C -----  WHICH IS NOW FIRST IN QUEUE                                    
C -----  MODIFY DISCHARGE CODE IF VEHICLE IS A TURNER                   
C                                                                       
          ISPDF = ISPD                                                  
          IF (IL .LE. TTLILK) THEN                                      
              ICODE = DSCSPD(K)                                         
              ITURN = TCODE(IV)                                         
              IF (ITURN .EQ. 0) ICODE = MIN0 (MAX0((LEFTSP+2)/5-2,1),   
     1            ICODE)                                                
              IF (ITURN .EQ. 2) ICODE = MIN0 (MAX0((ARTESP+2)/5-2,1),   
     1            ICODE)                                                
              ISPDF = MIN0(5*ICODE+10,IFRSPD)                           
              IF (ICODE .EQ. 0) ISPDF = MIN0(STPTHR*(9-ITIME)/3, ISPDF) 
          ENDIF                                                         
          IACC = MAX0 (((ISPDF - ISPD) * 10) / MAX0 (ITIME, 1), -12)    
C                                                                       
C -----  TRA WHEN ACCELERATION IS LESS THAN 3. ELSE, DETERMINE IF ACCEL 
C -----  IS REALIZABLE BASED UPON CURRENT VEHICLE SPEED, DESIRED SPEED  
C -----  ON THE LINK AND VEHICLE PERFORMANCE CHARACTERISTICS.           
C                                                                       
          IF (IACC .GE. 3) THEN                                         
              IVTYP = NVHTYP(IV)                                        
              IAMAX = MOD (VTYPAH(IVTYP), 2**7)                         
              ISPEED = MIN0 (VFFSPD(IV), VTYPSP(IVTYP))                 
              ISLOPE = (IAMAX * 200 + ISPEED) / (2 * ISPEED)            
              IACC = MIN0 (IACC,                                        
     1               (IAMAX * 100 - ISLOPE * ISPD + 500) / 1000)        
          ENDIF                                                         
C                                                                       
      ENDIF                                                             
C                                                                       
C -----  CALCULATE VEHICLES DISCHARGE SPEED, JSPEED.                    
C                                                                       
      JSPEED = MAX0 (MIN0 (ISPD + (IACC * ITIME + 5) / 10,              
     1         IFRSPD, 127), STPTHR)                                    
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CALLTY                                                 
C                                                                       
C --- CODED    4-03-82 BY C. REDWINE, JFT ASSOCIATES                    
C --- MODIFIED 10-11-85 BY A. HALATI FOR TRAF/NETSIM ACTUATED LOGIC     
C                                                                       
C --- TITLE - SERVICE CALL DETECTOR                                     
C ---         MODULE 3233.2622.2                                        
C                                                                       
C --- FUNCTION - EMULATE Q5 CALLTY                                      
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     IF PHASE IS RED, DETECTOR IS ON AND TIME DELAY EXPIRED, THEN      
C     PLACE A CALL ON THE PHASE.                                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    LOOP1  - MODULE 3233.2622                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    Q5 UTILITIES: JOR                                  
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     CLSTAT       CALL STATUS                                          
C     FAZBIT       DETECTOR PHASE ASSIGNMENT                            
C     GFAZE        GREEN PHASES FLAGS                                   
C     NUCALL       NEW CALLS                                            
C     T3ACT        TYPE 3 FLAGS                                         
C     T3P          TEMPORARY STORAGE                                    
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER  (A-Z)                                           
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      EQUIVALENCE (CLSTAT, LOWRAM(100)),                                
     1            (FAZBIT, LOWRAM(102)),                                
     2            (NUCALL, LOWRAM(103)),                                
     3            (T3P,    LOWRAM(107)),                                
     4            (T3ACT,  LOWRAM(124)),                                
     5            (GFAZE,  LOWRAM(160)),                                
     6            (ACCA,   LOWRAM(41)),                                 
     8            (IXREG,  LOWRAM(43))                                  
C                                                                       
      ACCA = IAND (FAZBIT, T3ACT)                                       
C                                                                       
C           REGISTER THE NEW CALL IF DETECTOR IS NOT ON GREEN PHASE,    
C           AND THE DELAY TIMER IS OUT.                                 
C                                                                       
      IF (IAND (ACCA, GFAZE) .NE. 0)                         RETURN     
C                                                                       
      IF (MOD (CLSTAT, 2).EQ.1 .AND. LOWRAM(IXREG+48).EQ.0) THEN        
         T3P = JOR (ACCA, T3P)                                          
         NUCALL = JOR (ACCA, NUCALL)                                    
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CANLNE (I1, I2, I3, I4, I5, I6, W1, W2, W3, J1, J2,    
     1                   W4)                                            
C                                                                       
C --- CODED    3-4-92 BY J. WERK                                        
C --- REVISED  7-16-94 BY S. WALKER TO CONSIDER INTERSECTION BLOCKAGES  
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK VLANE                     
C                                                                       
C --- TITLE - DETERMINE CANDIDATE LANES FOR LANE CHANGE - MODULE        
C ---         3232.4.6.2                                                
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES CANDIDATE LANES FOR A LANE      
C ---            CHANGE.                                                
C                                                                       
C --- ARGUMENTS - I1     = LINK NUMBER OF CURRENT LINK,                 
C ---                      FROM CALLING ROUTINE                         
C ---             I2     = LANE NUMBER CURRENTLY OCCUPIED BY VEHICLE IV,
C ---                      FROM CALLING ROUTINE                         
C ---             I3     = VEHICLE NUMBER OF CURRENT VEHICLE,           
C ---                      FROM CALLING ROUTINE                         
C ---             I4     = NUMBER OF FULL LANES ON LINK,                
C ---                      FROM CALLING ROUTINE                         
C ---             I5     = VEHICLE CATEGORY, FROM CALLING ROUTINE       
C ---             I6     = VEHICLE'S TURN CODE                          
C ---             W1     = FLAG (T,F) IF VEHICLE IS BLOCKED DIRECTLY    
C ---                      AHEAD, FROM CALLING ROUTINE                  
C ---             W2     = FLAG INDIATING WHETHER A THROUGH VEHICLE IS  
C ---                      A MANDATORY LANE CHANGER,                    
C ---                      FROM CALLING ROUTINE                         
C ---             W3     = FLAG INDICATING WHETHER A VEHICLE IS IN A    
C ---                      LANE CHANNELIZED FOR BUSES AND/OR CAR-POOLS  
C ---                      AND IT DOES NOT BELONG                       
C ---             J1     = CANDIDATE LANE TO THE LEFT (ZERO, IF NONE),  
C ---                      TO CALLING ROUTINE                           
C ---             J2     = CANDIDATE LANE TO THE RIGHT (ZERO, IF NONE), 
C ---                      TO CALLING ROUTINE                           
C ---             W4     = FLAG (T,F) IF CANDIDATE LANE(S) (ARE,AREN'T) 
C ---                      FOR A VEHICLE TRAVELING IN ITS GOAL LANE     
C ---                      WHICH IS BLOCKED AHEAD AND ADJACENT LANES    
C ---                      ARE NOT GOAL LANES, TO CALLING ROUTINE       
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE IS CALLED TO DETERMINE THE CANDIDATE LANES FOR A     
C     LANE CHANGE, EITHER MANDATORY OR DISCRETIONARY.                   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    CHKLC  - MODULE 3232.4.6                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                           ------------------                          
C                                                                       
C                               NONE                                    
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     BLOKL   BLOCKER DISTANCE FROM UPSTREAM NODE, FEET                 
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEH FROM UPSTM NODE  
C     IADJLN  ADJACENT LANE TO ILN BEING EXAMINED FOR CANDIDACY         
C     IBUS    LANE CHANNELIZED FOR BUSES                                
C     ICP     LANE CHANNELIZED FOR CAR-POOLS                            
C     IEVT    INDEX OVER EVENTS                                         
C     IFULLG  FULL LANES WHICH ARE GOAL LANES FOR VEHICLE IV            
C     IGOALN  GOAL LANES FOR VEHICLE IV                                 
C     II      INDEX TO DETERMINE CANDIDATE LANE                         
C     IL      LINK NUMBER OF CURRENT LINK                               
C     ILEFTG  LEFT POCKET LANES WHICH ARE GOAL LANES FOR VEHICLE IV     
C     ILN     LANE NUMBER CURRENTLY OCCUPIED BY VEHICLE IV              
C     ILNGTH  LINK LENGTH                                               
C     ILPLN   NUMBER OF LEFT POCKET LANES                               
C     INUMLN  NUMBER OF FULL LANES ON LINK                              
C     IRGHTG  RIGHT POCKET LANES WHICH ARE GOAL LANES FOR VEHICLE IV    
C     IRPLN   NUMBER OF RIGHT POCKET LANES                              
C     ITC     VEHICLE'S TURN CODE BEFORE IT WAS CHANGED DUE TO A        
C             BLOCKAGE IN INTERSECTION                                  
C     ITLN    VEHICLE'S TARGET LANE IF A BLOCKAGE EXISTS                
C     ITURN   VEHICLE'S TURN CODE                                       
C     IV      VEHICLE NUMBER OF CURRENT VEHICLE                         
C     IVTYP   VEHICLE CATEGORY                                          
C     JCL     CANDIDATE LANE TO THE LEFT (ZERO, IF NONE)                
C     JCR     CANDIDATE LANE TO THE RIGHT (ZERO, IF NONE)               
C     LANEGD  LINK SPECIFIC ARRAY - GRADE,NO. OF FULL AND POCKET LANES  
C     LEVNT1  EVENT SPECIFIC ARRAY - BEGIN TIME OF EVENT                
C     LEVNT2  EVENT SPECIFIC ARRAY - END TIME OF EVENT                  
C     LEVNT4  EVENT SPECIFIC ARRAY - CODE IF BLOCKAGE IN INTERSECTION   
C     LEVNT6  EVENT SPECIFIC ARRAY - LANE, LINK OF INTERSECTION BLOCKAGE
C     LGLPK   LINK SPECIFIC ARRAY - LEFT TURN POCKET LENGTH, FT.        
C     LGRPK   LINK SPECIFIC ARRAY - RIGHT TURN POCKET LENGTH, FT.       
C     PRVGLN  VEHICLE SPECIFIC ARRAY - PREVIOUS GOAL LANES AND TURN CODE
C     TOTEVT  TOTAL NUMBER OF EVENTS                                    
C     TYPLN   LINK SPECIFIC ARRAY - LANE CHANNELIZED FOR BUSES,CARPOOLS 
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF 
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE   
C     WBADLN  FLAG (T,F) IF CANDIDATE LANE(S) (ARE,AREN'T) FOR A VEHICLE
C             TRAVELING IN ITS GOAL LANE WHICH IS BLOCKED AHEAD AND     
C             ADJACENT LANES ARE NOT GOAL LANES                         
C     WBLOCK  FLAG (T,F) IF VEHICLE IS BLOCKED DIRECTLY AHEAD           
C     WBLOKL  FLAG (T,F) IF ADJACENT LANE TO THE LEFT OF CURRENT LANE   
C             (IS, ISN'T) BLOCKED                                       
C     WBLOKR  FLAG (T,F) IF ADJACENT LANE TO THE RIGHT OF CURRENT LANE  
C             (IS, ISN'T) BLOCKED                                       
C     WEVTAJ  FLAG (T,F) IF ADJACENT LANE TO THE CURRENT LANE           
C             (IS, ISN'T) BLOCKED BY AN INTERSECTION BLOCKAGE           
C     WEVTL   FLAG (T,F) IF LANE TO THE LEFT OF CURRENT LANE            
C             (IS, ISN'T) BLOCKED BY AN INTERSECTION BLOCKAGE           
C     WEVTR   FLAG (T,F) IF LANE TO THE RIGHT OF CURRENT LANE           
C             (IS, ISN'T) BLOCKED BY AN INTERSECTION BLOCKAGE           
C     WFIND   FLAG (T,F) IF A CANDIDATE LANE (WAS,WASN'T) FOUND         
C     WGOAL   FLAG (T,F) IF AN ADJACENT LANE (IS NOT, IS) A GOAL LANE   
C     WMAYBE  FLAG (T,F) IF AN ADJACENT LANE (MAY, MAY NOT BE) GOOD     
C     WTHRU   FLAG INDIATING WHETHER A THROUGH VEHICLE IS A MANDATORY   
C             LANE CHANGER                                              
C     WTYPE   FLAG INDICATING WHETHER A VEHICLE IS IN A LANE CHANNELIZED
C             FOR BUSES AND/OR CAR-POOLS AND IT DOES NOT BELONG         
C     XCANDL  LINK SPECIFIC ARRAY - CANDIDATE LANES FOR TURN MOVEMENTS  
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH, FT.                    
C     YINIT   FLAG (T,F) IF (IN,NOT IN) INITIALIZATION PERIOD           
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IL = I1                                                           
      ILN = I2                                                          
      IV = I3                                                           
      INUMLN = I4                                                       
      IVTYP = I5                                                        
      ITURN = I6                                                        
      WBLOCK = W1                                                       
      WTHRU = W2                                                        
      WTYPE = W3                                                        
C                                                                       
C -----  INITIALIZE RETURN ARGUMENTS TO ZERO                            
C                                                                       
      JCL = 0                                                           
      JCR = 0                                                           
      WBADLN = .FALSE.                                                  
C                                                                       
C -----  IF VEHICLE, IV, IS A BUS WHICH SEEKS A LANE CHANGE BECAUSE A   
C -----  BUS IS IN DWELL DOWNSTREAM AND IV DOES NOT SERVICE A STATION   
C -----  ON THIS LINK, THEN SET CANDIDATE LANE JCL = 2 AND TRA.         
C                                                                       
      IF (MOD (VHLANE(IV) / 2**11, 2) .EQ. 1) JCL = 2                   
      IF (JCL .EQ. 2)                                        GO TO 50   
C                                                                       
C -----  IF VEHICLE CURRENTLY IN POCKET THEN ONLY CANDIDATE LANE IS THE 
C -----  OTHER POCKET LANE (IF IT EXISTS) AND VEHICLE'S TURN CODE WASN'T
C -----  SWITCHED DUE TO A BLOCKAGE IN INTERSECTION DOWNSTREAM.         
C                                                                       
      ITC = -1                                                          
      IF (PRVGLN(IV) .GT. 0) ITC = MOD(PRVGLN(IV) / 2**7, 2**3)         
      ILPLN = MOD (LANEGD(IL) / 2**8, 2**2)                             
      IRPLN = MOD (LANEGD(IL) / 2**6, 2**2)                             
      IF (ILN .GT. INUMLN .AND. PRVGLN(IV) .EQ. 0) THEN                 
         IF (ILPLN .LT. 2 .AND. IRPLN .LT. 2)                GO TO 40   
         IF (ILPLN .EQ. 2 .AND. ILN .GT. 5) THEN                        
            IF (ILN .EQ. 7) JCL = 6                                     
            IF (ILN .EQ. 6) JCR = 7                                     
         ELSEIF (IRPLN .EQ. 2 .AND. ILN .GT. 5 - ILPLN .AND.            
     1           ILN .LT. 8 - ILPLN) THEN                               
            IF (ILN .EQ. 7 - ILPLN) JCR = ILN - 1                       
            IF (ILN .EQ. 6 - ILPLN) JCL = ILN + 1                       
         ENDIF                                                          
                                                             GO TO 30   
      ENDIF                                                             
C                                                                       
C -----  UNPACK GOAL LANES ON LINK, IL, FOR VEHICLE, IV.                
C                                                                       
      IGOALN = MOD(VHLANE(IV) / 2**3, 2**7)                             
C                                                                       
C -----  IF GOAL LANES EXIST AND VEHICLE IS CURRENTLY IN A GOAL LANE    
C -----  WHICH IS BLOCKED THEN CHECK ADJACENT LANES FOR CANDIDACY.      
C                                                                       
      WMAYBE = .FALSE.                                                  
      II = 1                                                            
      IF (IGOALN .GT. 0) THEN                                           
         IF (MOD(IGOALN / 2**(ILN-1), 2) .EQ. 1) THEN                   
            IF (WBLOCK) THEN                                            
               WGOAL = .FALSE.                                          
C                                                                       
C -----  CONSIDER LANE TO THE LEFT, THEN TO THE RIGHT.                  
C                                                                       
   10          CONTINUE                                                 
               IADJLN = ILN + II                                        
C                                                                       
C -----  CHECK IF THE LANE IS BLOCKED BY AN INTERSECTION BLOCKAGE OR IF 
C -----  ONE IS SCHELUED WITHIN THE NEXT THREE SECONDS.  IF SO, CONSIDER
C -----  THE LANE BLOCKED TO PREVENT VEHICLES FROM GETTING STUCK AT THE 
C -----  STOPLINE BEHIND A BLOCKAGE.                                    
C                                                                       
               WEVTAJ = .FALSE.                                         
               IF (.NOT. YINIT) THEN                                    
                   DO 9 IEVT = 1, TOTEVT                                
                      IF (MOD(LEVNT4(IEVT),2) .EQ. 1 .AND.              
     1                    LEVNT1(IEVT) - 3 .LE. CLOCK                   
     2                    .AND. LEVNT2(IEVT) .GE. CLOCK) THEN           
                           WEVTAJ = LEVNT6(IEVT)/2**3 .EQ. IL .AND.     
     1                              MOD(LEVNT6(IEVT),2**3) .EQ. IADJLN  
                      ENDIF                                             
    9              CONTINUE                                             
               ENDIF                                                    
               IF (IADJLN .LE. INUMLN .AND. IADJLN .GT. 0 .AND.         
     1                  BLOKL((IL-1)*7 + IADJLN) .LT. DISTUP(IV)        
     2                  .AND. .NOT. WEVTAJ) THEN                        
                  IF (MOD(IGOALN / 2**(IADJLN-1), 2) .EQ. 1) THEN       
                     WGOAL = .TRUE.                                     
                     IF (II .EQ. 1) THEN                                
                        JCL = ILN + 1                                   
                     ELSE                                               
                        JCR = ILN - 1                                   
                     ENDIF                                              
                  ELSE                                                  
C                                                                       
C -----  ADJACENT LANE IS NOT A GOAL LANE.                              
C                                                                       
                     IF (II .EQ. 1) THEN                                
                        WMAYBE = .TRUE.                                 
                     ELSE                                               
                        IF (WMAYBE) THEN                                
                           JCL = ILN + 1                                
                           JCR = ILN - 1                                
C                                                                       
C -----  TEST IF LANE TO THE LEFT OF ILN IS BLOCKED.                    
C                                                                       
                        ELSEIF (JCL .EQ. 0) THEN                        
                           JCR = ILN - 1                                
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
               ELSE                                                     
                  IF (WMAYBE) JCL = ILN + 1                             
               ENDIF                                                    
               II = -II                                                 
               IF (II .EQ. -1)                               GO TO 10   
               WBADLN = JCL + JCR .GT. 0 .AND. .NOT. WGOAL              
C                                                                       
C -----  OTHERWISE, CURRENT LANE IS A GOAL LANE WHICH IS NOT BLOCKED.   
C -----  SET ADJACENT LANES AS CANDIDATE LANES ONLY IF THEY ARE ALSO    
C -----  GOAL LANES WHICH ARE NOT BLOCKED.                              
C                                                                       
            ELSE                                                        
               WEVTL = .FALSE.                                          
               WEVTR = .FALSE.                                          
               IF (.NOT. YINIT) THEN                                    
                   DO 12 IEVT = 1, TOTEVT                               
                      IF (MOD(LEVNT4(IEVT),2) .EQ. 1 .AND.              
     1                    LEVNT1(IEVT) - 3 .LE. CLOCK                   
     2                    .AND. LEVNT2(IEVT) .GE. CLOCK) THEN           
                           IF (LEVNT6(IEVT)/2**3 .EQ. IL .AND.          
     1                         MOD(LEVNT6(IEVT),2**3) .EQ. ILN+1)       
     2                         WEVTL = .TRUE.                           
                           IF (LEVNT6(IEVT)/2**3 .EQ. IL .AND.          
     1                         MOD(LEVNT6(IEVT),2**3) .EQ. ILN-1)       
     2                         WEVTR = .TRUE.                           
                      ENDIF                                             
   12              CONTINUE                                             
               ENDIF                                                    
               IF (ILN .LT. INUMLN .AND. MOD(IGOALN / 2**ILN, 2) .EQ. 1 
     1            .AND. BLOKL((IL-1)*7+ILN+1) .LT. DISTUP(IV) .AND.     
     2            .NOT. WEVTL) JCL=ILN+1                                
               IF (ILN .GT. 1 .AND. MOD(IGOALN / 2**(ILN-2), 2) .EQ. 1  
     1            .AND. BLOKL((IL-1)*7+ILN-1) .LT. DISTUP(IV) .AND.     
     2            .NOT. WEVTR) JCR=ILN-1                                
            ENDIF                                                       
C                                                                       
C -----  VEHICLE IS NOT IN A GOAL LANE, BUT GOAL LANE(S) EXIST ON THIS  
C -----  LINK.  SET CANDIDATE LANES IN THE DIRECTION OF GOAL LANES IF   
C -----  THEY ARE NOT BLOCKED OR ARE OTHER GOAL LANES IN SAME DIRECTION.
C                                                                       
         ELSE                                                           
            IFULLG = MOD (IGOALN, 2**INUMLN)                            
            ILEFTG = IGOALN / 2**(7-ILPLN)                              
            IRGHTG = MOD (IGOALN / 2**(7-ILPLN-IRPLN), 2**IRPLN)        
            ILNGTH = MOD (XLNGTH(IL), 2**12)                            
            IF (ILN .GT. INUMLN .AND. PRVGLN(IV) .GT. 0) THEN           
               IF (ITC .EQ. 0 .AND. ILPLN .GT. 1 .AND. ILN .EQ. 6) THEN 
                  JCR = 7                                               
               ELSEIF (ITC .EQ. 0) THEN                                 
                  IF (ITC .EQ. ITURN .AND. MOD(IGOALN/ 2**5, 2) .EQ. 1) 
     1                                     JCL = 6                      
                  IF (IFULLG .GT. 0) JCR = INUMLN                       
               ELSEIF (ITC .EQ. 2 .AND. IRPLN .GT. 1 .AND.              
     1                                  ILN .LT. 7 - ILPLN) THEN        
                  JCL = ILN + 1                                         
               ELSE                                                     
                  IF (ITC .EQ. ITURN .AND. MOD(IGOALN / 2**(ILN-2), 2)  
     1                    .EQ. 1) JCR = ILN - 1                         
                  IF (IFULLG .GT. 0) JCL = 1                            
               ENDIF                                                    
            ELSEIF (PRVGLN(IV) .GT. 0 .AND. ILEFTG .GT. 0) THEN         
               IF (ILN .LT. INUMLN) THEN                                
                  JCL = ILN + 1                                         
               ELSE                                                     
                  IF (DISTUP(IV) .GT. ILNGTH - MOD (LGLPK(IL), 2**10))  
     1                                         JCL = 7                  
               ENDIF                                                    
               IF (MOD(IGOALN, 2**(ILN-1)) .GT. 0) JCR = ILN - 1        
            ELSEIF (PRVGLN(IV) .GT. 0 .AND. IRGHTG .GT. 0) THEN         
               IF (ILN .GT. 1) THEN                                     
                  JCR = ILN - 1                                         
               ELSE                                                     
                  IF (LGRPK(IL) .GT. 0) THEN                            
                     IF (DISTUP(IV) .GT. ILNGTH - MOD(LGRPK(IL), 2**10))
     1                   JCR = 7 - ILPLN                                
                  ELSE                                                  
                     IF (DISTUP(IV) .GT. ILNGTH + MOD(LGRPK(IL), 2**9)) 
     1                   JCR = 7 - ILPLN                                
                  ENDIF                                                 
               ENDIF                                                    
               IF (IFULLG / (2**ILN) .GT. 0) JCL = ILN + 1              
            ELSE                                                        
               IF (IGOALN / 2**ILN .GT. 0) THEN                         
                   WEVTL = .FALSE.                                      
                   IF (.NOT. YINIT) THEN                                
                       DO 15 IEVT = 1, TOTEVT                           
                          IF (MOD(LEVNT4(IEVT),2) .EQ. 1 .AND.          
     1                        LEVNT1(IEVT) - 3 .LE. CLOCK               
     2                        .AND. LEVNT2(IEVT) .GE. CLOCK) THEN       
                               IF (LEVNT6(IEVT)/2**3 .EQ. IL .AND.      
     1                             MOD(LEVNT6(IEVT),2**3) .EQ. ILN+1)   
     2                             WEVTL = .TRUE.                       
                          ENDIF                                         
   15                  CONTINUE                                         
                   ENDIF                                                
                  IF (BLOKL((IL-1)*7+ILN+1) .LT. DISTUP(IV) .OR. WEVTL  
     1                .OR. IGOALN/2**(ILN+1) .GT. 0) THEN               
                     JCL = ILN + 1                                      
                  ELSE                                                  
                     ITLN = ILN + 1                                     
                  ENDIF                                                 
               ENDIF                                                    
               IF (MOD(IGOALN, 2**(ILN-1)) .GT. 0) THEN                 
                   WEVTR = .FALSE.                                      
                   IF (.NOT. YINIT) THEN                                
                       DO 16 IEVT = 1, TOTEVT                           
                          IF (MOD(LEVNT4(IEVT),2) .EQ. 1 .AND.          
     1                       LEVNT1(IEVT) - 3 .LE. CLOCK                
     2                       .AND. LEVNT2(IEVT) .GE. CLOCK) THEN        
                              IF (LEVNT6(IEVT)/2**3 .EQ. IL .AND.       
     1                            MOD(LEVNT6(IEVT),2**3) .EQ. ILN-1)    
     2                            WEVTR = .TRUE.                        
                         ENDIF                                          
   16                 CONTINUE                                          
                  ENDIF                                                 
                  IF (BLOKL((IL-1)*7+ILN-1) .LT. DISTUP(IV) .OR. WEVTR  
     1               .OR. IGOALN/2**(ILN-1) .GT. 0) THEN                
                     JCR = ILN - 1                                      
                  ELSE                                                  
                     ITLN = ILN - 1                                     
                  ENDIF                                                 
               ENDIF                                                    
               IF (JCL + JCR .EQ. 0 .AND. ITLN .GT. 0)                  
     1             VHLANE(IV) = (VHLANE(IV) / 2**3) * 2**3 + ITLN       
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  VEHICLE HAS NO GOAL LANES ON LINK IL.  SET ADJACENT LANES AS   
C -----  CANDIDATES IF THEY ARE NOT BLOCKED, SERVICE THE VEHICLES THRU  
C -----  MOVEMENT AND DO NOT SERVICE A DIFFERENT VEHICLE TYPE.          
C                                                                       
      ELSE                                                              
         WBLOKL = .FALSE.                                               
         WBLOKR = .FALSE.                                               
         IBUS = MOD(TYPLN(IL), 2**3)                                    
         ICP = MOD(TYPLN(IL) / 2**3, 2**3)                              
   20    CONTINUE                                                       
         IADJLN = ILN + II                                              
         WEVTAJ = .FALSE.                                               
         IF (.NOT. YINIT) THEN                                          
             DO 22 IEVT = 1, TOTEVT                                     
                IF (MOD(LEVNT4(IEVT),2) .EQ. 1 .AND.                    
     1              LEVNT1(IEVT) - 3 .LE. CLOCK                         
     2              .AND. LEVNT2(IEVT) .GE. CLOCK) THEN                 
                     WEVTAJ = LEVNT6(IEVT)/2**3 .EQ. IL .AND.           
     1                        MOD(LEVNT6(IEVT),2**3) .EQ. IADJLN        
                ENDIF                                                   
   22        CONTINUE                                                   
         ENDIF                                                          
         IF (IADJLN .LE. INUMLN .AND. IADJLN .GT. 0 .AND.               
     1       BLOKL((IL-1)*7 + IADJLN) .LT. DISTUP(IV) .AND.             
     2       .NOT. WEVTAJ) THEN                                         
            IF (MOD(XCANDL(IL) / 2**(IADJLN+2), 2) .EQ. 1) THEN         
               IF ((IBUS .NE. IADJLN .OR. IVTYP .EQ. 3) .AND.           
     1                      (ICP .NE. IADJLN .OR. IVTYP .EQ. 2)) THEN   
                  IF (II .EQ. 1) THEN                                   
                     JCL = ILN + 1                                      
                  ELSE                                                  
                     JCR = ILN - 1                                      
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
         ELSEIF (II .EQ. 1) THEN                                        
            WBLOKL = .TRUE.                                             
         ELSE                                                           
            WBLOKR = .TRUE.                                             
         ENDIF                                                          
         II = -II                                                       
         IF (II .EQ. -1)                                     GO TO 20   
         WFIND = JCL + JCR .GT. 0                                       
C                                                                       
C -----  IF VEHICLE IS A MANDATORY LANE CHANGER AND NEITHER ADJACENT    
C -----  LANE SERVICES ITS THRU MOVEMENT, THEN SET ADJACENT LANE AS     
C -----  CANDIDATE IF WTHRU OR WTYPE FLAG IS TRUE (MEANING THAT VEHICLE 
C -----  CANNOT REMAIN IN CURRENT LANE) AND ADJACENT LANE IS CLOSER     
C -----  TO A LANE THAT SERVICES A THRU MOVEMENT (BY INFERENCE).        
C                                                                       
         IF ((WTHRU .OR. WTYPE .OR. WBLOCK) .AND. (.NOT. WBLOKL .OR.    
     1                   .NOT. WBLOKR) .AND. (.NOT. WFIND)) THEN        
            IF (WBLOCK .AND. .NOT. WTHRU) THEN                          
               IF (.NOT. WBLOKL) JCL = ILN + 1                          
               IF (.NOT. WBLOKR) JCR = ILN - 1                          
            ENDIF                                                       
            IF (WTHRU .OR. WTYPE) THEN                                  
               IF (ILN .LE. INUMLN / 2) THEN                            
                  IF (.NOT. WBLOKL) JCL = ILN + 1                       
               ELSEIF (.NOT. WBLOKR) THEN                               
                  JCR = ILN - 1                                         
               ENDIF                                                    
               WFIND = JCL + JCR .GT. 0                                 
C                                                                       
C -----  IF NECESSARY, TAKE EITHER ACCEPTABLE ADJOINING LANE.           
C                                                                       
               IF (.NOT. WFIND) THEN                                    
                  IF (.NOT. WBLOKL) THEN                                
                     JCL = ILN + 1                                      
                  ELSE                                                  
                     JCR = ILN - 1                                      
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
      ENDIF                                                             
   30 CONTINUE                                                          
   40 CONTINUE                                                          
   50 CONTINUE                                                          
      J1 = JCL                                                          
      J2 = JCR                                                          
      W4 = WBADLN                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CHKDIS (IV, IL, WMICRO, ICODE, JALN, WGO)              
C                                                                       
C --- CODED    6-17-79 BY M. KAPTANOGLU                                 
C --- REVISED  9-15-87 BY AJAY K. RATHI FOR IDENTICAL TRAFFIC STREAMS   
C --- REVISED 11-24-87 BY O. SHARAF-ELDIEN FOR ACTUATED-AMBER TESTING   
C --- REVISED  3-21-88 BY O. SHARAF-ELDIEN TO FIX FATAL BRANCHING WHICH 
C ---                               ALTERED VEHICLE SEEDS IMPROPERLY.   
C --- REVISED  3-24-88 BY O. SHARAF-ELDIEN TO DISENGAGE VREM AND CLINK  
C --- REVISED 12-13-88 BY A. KANAAN TO REMOVE SPLIT OF ENTRTM(IV)       
C --- REVISED 12-14-90 BY A. KANAAN TO ADD VEHID TRACING                
C --- REVISED  5-14-92 BY J. WERK TO CHANGE TITLE, NOT LET A VEHICLE    
C ---                               DISCHARGE WHICH HAS GOAL LANES BUT  
C ---                               IS NOT IN ONE, AND CALL CNTRL IF THE
C ---                               VEHICLE WILL EXACTLY REACH THE STOP-
C ---                               LINE THIS TIME-STEP                 
C --- REVISED  3-01-93 BY M. YEDLIN TO PREVENT SIGT FROM GOING OUT OF   
C ---                               BOUNDS                              
C --- REVISED  4-06-93 BY S.E.SMITH FOR CHECK AT FRESIM INTERFACE       
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CODES, SPDLN, TRHDWY,     
C ---                               VSTATE, VTYPE AND VTYPLS            
C                                                                       
C --- TITLE - DETERMINE WHETHER VEHICLE CAN DISCHARGE FROM LANE         
C ---         MODULE 3232.2                                             
C                                                                       
C --- FUNCTION - THIS ROUTINE CALLS SUBORDINATE MODULES TO DETERMINE    
C ---            WHETHER SUBJECT VEHICLE CAN DISCHARGE FROM THE LINK    
C                                                                       
C --- ARGUMENTS - IV     = NUMBER OF FIRST VEHICLE IN LANE, FROM        
C ---                      CALLING ROUTINE                              
C ---             IL     = LINK NUMBER, FROM CALLING ROUTINE            
C ---             WMICRO = FLAG SET TO (T, F) IF ROUTINE (IS, ISN'T)    
C ---                      CALLED FROM MVMINT                           
C ---             ICODE  = TURN MOVEMENT OF SUBJECT VEHICLE ON ITS      
C ---                      RECEIVING LINK, TO CALLING ROUTINE           
C ---             JALN   = LANE WHICH SUBJECT VEHICLE WILL ENTER ON     
C ---                      RECEIVING LINK, TO CALLING ROUTINE           
C ---             WGO    = FLAG SET TO (TRUE, FALSE) IF VEHICLE (CAN,   
C ---                      CANNOT) BE DISCHARGED, TO CALLING ROUTINE    
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE DETERMINES WHETHER OR NOT VEHICLE IS IN QUEUE, THEN  
C     CALLS SUBORDINATE MODULES TO CHECK IF CONTROL CODE WILL SERVICE   
C     THIS TURN MOVEMENT, AND TO TEST SPILLBACK IN RECEIVING LINK AND   
C     CROSS LINKS IN ORDER TO DETERMINE IF VEHICLE MAY BE DISCHARGED.   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    MOVE   - MODULE 3.2.3.2                            
C                    MVMINT - MODULE 3232.1                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    GETCD  - MODULE 3231.2.2.1                         
C                    CNTRL  - MODULE 3232.2.1                           
C                    TSTSAT - MODULE 3232.2.2                           
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     AMBSPC  LINK SPECIFIC ARRAY - CODES (0,1) IF (LT,DG,TH,RT)        
C             MOVEMENTS (ARE, NOT) AMBER                                
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK           
C     CLOCK   ELAPSED TIME SINCE BEGINNING OF SIMULATION, SECS          
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEHICLE FROM UPNODE  
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     ENTRTM  VEHICLE SPECIFIC ARRAY - TIME VEHICLE ENTERED LINK,       
C             SEC * 10                                                  
C     FZPNTR  POINTER TO FIRST INTERVAL IN DURINT ARRAY, NO. OF INTERVLS
C     IACCEL  ACCELERATION FACTOR USED TO DETERMINE IF VEHICLE IS       
C             WITHIN RANGE OF STOP-LINE                                 
C     IAMAX   MAX. ACCEL. (10 * FPSS) AT 0 SPEED FOR VEH. TYPE, ITYPE   
C     IDWN    DOWNSTREAM NODE NUMBER                                    
C     IH      TIME REMAINING UNTIL VEHICLE WILL DISCHARGE FROM QUEUE (SE
C     ILFTSG  LT SIG CODE (0,1,2) = (GO,NOGO,PROT.GO) DURING NEXT INT.  
C     IMIC    INDEX OVER MICRONODES                                     
C     INT     SIGNAL INTERVAL NUMBER FOR NEXT INTERVAL                  
C     IRL     RECEIVING LINK NUMBER                                     
C     ISEED   RANDOM NUMBER SEED                                        
C     ISLOPE  SLOPE * 1000 RELATING MAX. ACCEL TO ATTAINABLE SPEED      
C     ISPEED  MAX ATTAINABLE SPEED BASED ON LINK AND VEH CHARACTERISTICS
C     ISTAT   VEHICLE STATUS CODE                                       
C     ITURN   TURN MOVEMENT ON THE SUBJECT LINK                         
C     ITYPE   VEHICLE TYPE                                              
C     IVPATH  VEHICLE SPECIFIC ARRAY - POINTER TO XIPATH ARRAY AND FIELD
C             WITHIN XIPATH DESCRIBING VEHICLE'S CURRENT TURN MOVEMENT  
C     J       NO. OF BITS TO THE RIGHT OF BITS CONTAINING LT SIG CODE   
C     KSPEED  CURRENT SPEED, FT/SEC                                     
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK            
C     LU6     UNIT NO.6 (OUTPUT PRINTOUT)                               
C     NACT    NODE SPECIFIC ARRAY - TYPE OF CONTROL                     
C     NVHCDE  VEHICLE SPECIFIC ARRAY - VEHICLE PROCESS CODE             
C     NVHTYP  VEHICLE SPECIFIC ARRAY - VEHICLE TYPE CODE, 1-16          
C     OPPOSE  LINK SPECIFIC ARRAY - LINK CARRYING ONCOMING TRAFFIC      
C     SDCODE  LINK SPECIFIC ARRAY - SIGNAL CODES, CODE FOR AMBER INTVL, 
C             POINTER TO DETECTOR ARRAY                                 
C     SIGT    ARRAY CONTAINING CURRENT INTERVAL AND ELAPSED TIME        
C     SPDLN   VEHICLE SPECIFIC ARRAY - SPEED, FT/SEC                    
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE               
C     THRU    LINK SPECIFIC ARRAY - THROUGH RECEIVING LINK              
C     TIMDIS  VEHICLE SPECIFIC ARRAY - TIME REMAINING TO DISCHARGE FROM 
C             HEAD OF QUEUE, SEC * 10                                   
C     TTLILK  TOTAL NUMBER OF INTERNAL LINKS ON THE SUBNETWORK          
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     VCHNG   VEHICLE SPECIFIC ARRAY - REMAIN TIME TO CHK FOR LANE CHNG,
C             INT BET LANE CHNGES, (1,0) IF (IN, NOT IN) GOAL LANE,     
C             POINTER TO VLNCHG ARRAY, FLAG IF VEH MUST SLOW TO ALLOW   
C             LANE CHANGER IN FRONT                                     
C     VEHID   VEHICLE ID TO TRACE WITHIN PROGRAM                        
C     VFFSPD  VEHICLE SPECIFIC ARRAY - DESIRED FREE FLOW SPEED          
C     VPATH   VEHICLE SPECIFIC ARRAY - POINTER TO XIPATH ARRAY AND FIELD
C             WITHIN XIPATH DESCRIBING VEHICLE'S CURRENT TURN MOVEMENT  
C     VSTATE  VEHICLE SPECIFIC ARRAY - STATUS CODE                      
C     VTYPAH  VEHICLE TYPE ARRAY - MAX. ACCEL. AND HDWY FACTOR          
C     VTYPSP  VEHICLE TYPE ARRAY - MAXIMUM SPEED AT 0 ACCELERATION      
C     WLTAMB  FLAG (T,F) IF VEHICLE (IS,NOT) AN UNPROTECTED LEFT-TURNER 
C             SUBJECT TO AN AMBER INDICATION                            
C     WQ      VEHICLE QUEUE FLAG IS (.T.,.F.) IF VEHICLE (IS,IS NOT) IN 
C             QUEUE                                                     
C     XINT1   LINK SPECIFIC ARRAY - CONTROL CODES FOR INT. 1-6          
C     XINT2   LINK SPECIFIC ARRAY - CONTROL CODES FOR INT. 7-12         
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH, FT                     
C     XVSEED  VEHICLE SPECIFIC ARRAY - RANDOM NUMBER SEED               
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  RESET DISCHARGE FLAG (ASSUME VEHICLE CANNOT DISCHARGE),        
C -----  REDEFINE ARGUMENTS, AND TRA IF LEAD VEHICLE HAS BEEN PRO-      
C -----  CESSED THIS TIME-STEP.                                         
C                                                                       
      WGO = .FALSE.                                                     
      ISEED = XVSEED(IV)                                                
      IVPATH = VPATH(IV)                                                
      IF (DWNOD(IL) .LT. 7000) THEN                                     
         IMIC = DWNOD(IL)                                               
         IF (MOD (SIGT(IMIC) / 2**12, 2) .EQ. 1 .AND. .NOT. WMICRO)     
     1                                                       GO TO 12   
      ENDIF                                                             
      IF (NVHCDE(IV) .GT. 0)                                 GO TO 12   
      IH = ENTRTM(IV) / 10                                              
      ITURN = TCODE(IV)                                                 
C                                                                       
C -----  TRA IF LEAD VEHICLE ON ENTRY INTERFACE LINK HAS NOT ACTUALLY   
C -----  ENTERED THE LINK FROM THE VHA.                                 
C                                                                       
      IF (UPNOD(IL)/1000 .EQ. 7 .AND. IH .GT. CLOCK)         GO TO 12   
C                                                                       
C -----  TRA TO EXIT IF VEHICLE IS A MANDATORY LANE CHANGER.  IT CANNOT 
C -----  DISCHARGE FROM CURRENT LANE.                                   
C                                                                       
      IF (MOD (VCHNG(IV) / 2**14, 2) .EQ. 1)                 GO TO 12   
C                                                                       
C -----  TRA IF VEHICLE MUST SLOW TO ALLOW A LANE CHANGER IN FRONT      
C                                                                       
      IF (MOD (VCHNG(IV) / 2**13, 2) .EQ. 1)                 GO TO 12   
C                                                                       
      IH = 10                                                           
      ILFTSG = 0                                                        
C                                                                       
C -----  FIND IF VEHICLE IV IS IN QUEUE. IF SO, SET QUEUE FLAG TO TRUE  
C -----  AND CALL SUBORDINATE MODULE TO CHECK IF CONTROL CODE WILL      
C -----  ALLOW DISCHARGE DURING THIS TIME STEP.                         
C                                                                       
      ISTAT = VSTATE(IV)                                                
      WQ = ISTAT .EQ. 1 .OR. ISTAT.EQ. 2 .OR. ISTAT .GT. 5              
      IF (WQ) IH = TIMDIS(IV)                                           
      IF (IH .LT. 10) THEN                                              
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CHKDIS: CALL CNTRL @1'    
          CALL CNTRL (IV, IL, WQ, WGO)                                  
      ENDIF                                                             
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
C     SIGNAL CONTROL WAS DETERMINED FOR A QUEUED VEHICLE WHOSE HEADWAY  
C     WAS LESS THAN 1 SECOND.  IT IS ALSO NECESSARY TO DETERMINE SIGNAL 
C     CONTROL WHEN                                                      
C         1 -  VEHICLE IS MOVING AND CAN REACH THE STOPLINE THIS STEP   
C         2 -  VEHICLE IS AN UNPROTECTED LEFT-TURNER DURING AMBER       
C     BY CALLING CNTRL FOR THIS 2ND CONDITION, THE HEADWAY FOR THE LEFT 
C     TURNER IS AUTOMATICALLY UPDATED EVERY SECOND TO REFLECT WHETHER   
C     OPPOSING VEHICLES STOP OR DISCHARGE INTO THE INTERSECTION.        
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
C -----  SET FLAG, WLTAMB = .T. IF 2ND CONDITION APPLIES.               
C                                                                       
      IF (ITURN.EQ.0 .AND. MOD(SDCODE(IL)/8,4).EQ.2 .AND.               
     1     OPPOSE(IL).GT.0 .AND. IH.GE.10) THEN                         
         IDWN = DWNOD(IL)                                               
         IF (NACT(IDWN) .GT. 0) THEN                                    
            WLTAMB = MOD (AMBSPC(IL) / 2**3, 2) .EQ. 0                  
         ELSE                                                           
            IF (MOD (SDCODE(IL) / 2**5, 2) .EQ. 1) THEN                 
               INT = MOD (SIGT(IDWN), 2**4) + 1                         
               IF (INT.GT.MOD(FZPNTR(IDWN)/2**11, 2**4)) INT = 1        
               J = MOD ((5*INT - 5), 30) + 3                            
               IF (INT .LE. 6) ILFTSG = MOD (XINT1(IL) / 2**J, 2**2)    
               IF (INT .GT. 6) ILFTSG = MOD (XINT2(IL) / 2**J, 2**2)    
               WLTAMB = ILFTSG .EQ. 1                                   
            ELSE                                                        
               WLTAMB = .FALSE.                                         
            ENDIF                                                       
         ENDIF                                                          
      ELSE                                                              
         WLTAMB = .FALSE.                                               
      ENDIF                                                             
C                                                                       
C -----  TRA IF VEHICLE NOT IN MOTION, OR VEHICLE IS NOT AN UNPROTECTED 
C -----  LEFT TURNER SUBJECT TO AN AMBER INDICATION. ELSE,              
C -----  CHECK CONTROL CODE IF VEHICLE WITHIN RANGE OF STOPLINE         
C                                                                       
      IF (ISTAT .NE. 0 .AND. .NOT. WLTAMB)                   GO TO 10   
C                                                                       
C     IF (VEHID .GT. 0) WRITE(LU6,1010) IV, 'A'                         
C                                                                       
      KSPEED = SPDLN(IV)                                                
      ITYPE = NVHTYP(IV)                                                
C                                                                       
C     IF (VEHID .GT. 0) WRITE(LU6,1010) IV, 'B'                         
C                                                                       
C -----  GET VEHICLE ACCELERATION BASED ON ITS CURRENT SPEED, DESIRED   
C -----  SPEED ON THIS LINK AND VEHICLE PERFORMANCE CHARACTERISTICS.    
C                                                                       
      IAMAX = MOD (VTYPAH(ITYPE), 2**7)                                 
      ISPEED = MIN0 (VFFSPD(IV), VTYPSP(ITYPE))                         
C                                                                       
      IF (VEHID .EQ. IV) WRITE(LU6,1020) IV,IL,VSTATE(IV),ITYPE,        
     1                                   VTYPSP(ITYPE),ISPEED           
C                                                                       
      ISLOPE = 0                                                        
      IF (ISPEED .GT. 0) ISLOPE = (IAMAX * 200 + ISPEED) / (2 * ISPEED) 
      IACCEL = 0                                                        
      IF (KSPEED .LT. ISPEED) IACCEL = MAX0 ((IAMAX * 100 - ISLOPE *    
     1        KSPEED + 500) / 1000, 1)                                  
C                                                                       
C     IF (VEHID .GT. 0) WRITE(LU6,1010) IV, 'C'                         
C                                                                       
      IF (IL .GT. TTLILK) THEN                                          
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CHKDIS: CALL CNTRL @2'    
          CALL CNTRL (IV, IL, WQ, WGO)                                  
      ENDIF                                                             
C                                                                       
C     IF (VEHID .GT. 0) WRITE(LU6,1010) IV, 'D'                         
C                                                                       
      IF (IL .LE. TTLILK .AND.                                          
     1    MOD (XLNGTH(IL), 2**12) .LT.                                  
     2    (DISTUP(IV) + KSPEED + IACCEL/2)) THEN                        
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CHKDIS: CALL CNTRL @3'    
          CALL CNTRL (IV, IL, WQ, WGO)                                  
      ENDIF                                                             
   10 CONTINUE                                                          
C                                                                       
C     IF (VEHID .GT. 0) WRITE(LU6,1010) IV, 'E'                         
C                                                                       
      ICODE = 1                                                         
      IF (.NOT. WGO .OR. DWNOD(IL) / 1000 .GE. 8)            GO TO 12   
C                                                                       
C -----  FIND RECEIVING LINK OR NODE NUMBER                             
C                                                                       
      IRL = THRU(IL)                                                    
      IF (ITURN .EQ. 0) IRL = LEFT(IL)                                  
      IF (ITURN .EQ. 2) IRL = ARIGHT(IL)                                
      IF (ITURN .GT. 2) IRL = IABS (DIAGNL(IL))                         
C                                                                       
C -----  IF NOT DISCHARGING TO AN INTERFACE LINK, GET TURN MOVEMENT,    
C -----  ICODE, AT END OF RECEIVING LINK.  IF DISCHARGING FROM AN       
C -----  INTERNAL LINK, CALL MODULE 3232.2.2 TO DETERMINE IF THERE      
C -----  IS A LANE AVAILABLE FOR THE SUBJECT VEHICLE TO ENTER.  IF      
C -----  DISCHARGING FROM AN INTERFACE LINK, CALL ROUTINE IFCDIS TO     
C -----  DETERMINE IF THERE IS A LANE AVAILABLE FOR THE SUBJECT VEHICLE 
C -----  TO ENTER.  SET LANE ON RECEIVING LINK TO BE EQUAL TO CURRENT   
C -----  LANE SO NO LANE CHANGES WILL OCCUR AT INTERFACE.               
C                                                                       
      IF (IRL .LT. 7000 .AND. IRL .NE. 0)  CALL GETCD (IV, IRL, ICODE)  
      IF (DWNOD(IL)/1000 .LT. 7) THEN                                   
          CALL TSTSAT (IL, IV, WQ, ICODE, IRL, JALN, WGO)               
      ELSE                                                              
          CALL IFCDIS (IV, IL, IACCEL, JALN, WGO)                       
      ENDIF                                                             
      IF (IV .EQ. VEHID) WRITE(LU6,1000) IV,IL,ICODE,IRL,JALN,WQ,WGO    
   12 CONTINUE                                                          
C                                                                       
      IF (.NOT. WGO) THEN                                               
         XVSEED(IV) = ISEED                                             
         VPATH(IV) = IVPATH                                             
      ENDIF                                                             
C                                                                       
      RETURN                                                            
1000  FORMAT('0 CHKDIS:FR TSTSAT:IV,IL,ICODE,IRL,JALN,WQ,WGO',5I4,2L1)  
1010  FORMAT('0 CHKDIS:IV', I4, ' @', A1)                               
1020  FORMAT('0 CHKDIS:IV,IL,VSTATE(IV),ITYPE,VTYPSP(ITYPE),ISPEED',6I9)
      END                                                               
      SUBROUTINE CHKLC (I1, I2, I3, I4, I5, I6, W1, J1)                 
C                                                                       
C --- CODED    8-22-91 BY J. WERK                                       
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK CODES,VLANE,VTYPE & VTYPLS
C --- REVISED  4-18-95 BY S. WALKER TO ALLOW LANE CHANGE AS LEAVING INTE
C                                                                       
C --- TITLE - DETERMINE IF VEHICLE MAKES A LANE CHANGE - MODULE         
C             3232.4.6                                                  
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES WHETHER A VEHICLE WILL MAKE A   
C                LANE CHANGE DURING THE CURRENT TIME STEP.              
C                                                                       
C --- ARGUMENTS - I1     = CURRENT LINK NUMBER, FROM CALLING ROUTINE    
C ---             I2     = SUBJECT VEHICLE NUMBER, FROM CALLING ROUTINE 
C ---             I3     = TURN CODE OF VEHICLE IV, FROM CALLING ROUTINE
C ---             I4     = CURRENT LANE NUMBER, FROM CALLING ROUTINE    
C ---             I5     = VEHICLE CATEGORY, FROM CALLING ROUTINE       
C ---             I6     = NUMBER OF FULL LANES ON LINK IL,             
C ---                      FROM CALLING ROUTINE                         
C ---             W1     = FLAG (T,F) INDICATING WHETHER A LANE CHANGE  
C ---                      (HAS,HASN'T) OCCURED THIS TIME STEP,         
C ---                      TO CALLING ROUTINE                           
C ---             J1     = NUMBER OF REQUIRED LANE CHANGES ON THIS LINK,
C ---                      TO CALLING ROUTINE                           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE IS CALLED EVERY TIME A DRIVER CHECKS TO DETERMINE    
C     IF THE VEHICLE WILL MAKE A LANE CHANGE NOW.                       
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    TRVL   - MODULE 3232.4                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    MOTIV  - MODULE 3232.4.6.1                         
C                    CANLNE - MODULE 3232.4.6.2                         
C                    ADVANT - MODULE 3232.4.6.3                         
C                    LCHDEC - MODULE 3232.4.6.4                         
C                    LCVEH  - MODULE 3232.4.6.5                         
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEH FROM UPSTM NODE  
C     IGOAL   VEHICLE'S PREVIOUS GOAL LANES BEFORE CHANGED DUE TO       
C             BLOCKAGE IN INTERSECTION                                  
C     IL      CURRENT LINK NUMBER                                       
C     ILEN    VEHICLE LENGTH                                            
C     ILN     CURRENT LANE NUMBER                                       
C     INUMLN  NUMBER OF FULL LANES ON LINK IL                           
C     ITURN   TURN CODE OF VEHICLE IV                                   
C     ITURN2  TURN CODE OF VEHICLE IV PACKED IN CODES ARRAY             
C     ITYPE   VEHICLE TYPE                                              
C     IV      SUBJECT VEHICLE NUMBER                                    
C     IVTYP   VEHICLE CATEGORY                                          
C     JCL     CANDIDATE LANE TO THE LEFT                                
C     JCR     CANDIDATE LANE TO THE RIGHT                               
C     JJ      POINTER TO XGOALN ARRAY FOR VEHICLE IV                    
C     JLCMOT  CODE (0,1,2) IF (NO,MANDATORY,DISCRETIONARY) MOTIVATION   
C             FOR LANE CHANGE                                           
C     JNUMLC  NUMBER OF REQUIRED LANE CHANGES ON THIS LINK              
C     JTFLW   FOLLOWER VEHICLE IN NEW LANE                              
C     JTLEAD  LEAD VEHICLE IN NEW LANE AFTER LANE CHANGE                
C     PRVGLN  VEHICLE SPECIFIC ARRAY - PREVIOUS GOAL LANES AND TURN CODE
C     RDAF    DRIVER AGGRESSIVENESS FACTOR                              
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE               
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF 
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE   
C     NVHTYP  VEHICLE TYPE ARRAY - VEHICLE TYPE CODE, 1-16              
C     VTYPLE  VEHICLE TYPE ARRAY - EFFECTIVE VEHICLE LENGTH             
C     WBADLN  FLAG (T, F) IF CANDIDATE LANE(S) (ARE, AREN'T) FOR A      
C             VEHICLE NOW IN ITS GOAL LANE WHICH IS BLOCKED AHEAD FOR   
C             OVER 10 SEC AND ADJACENT LANES DO NOT SERVICE ITS MOVEMENT
C     WBLAHD  FLAG (T, F) IF VEHICLE (IS, ISN'T) BLOCKED AHEAD          
C     WBLOCK  FLAG (T, F) IF VEHICLE (IS, ISN'T) BLOCKED DIRECTLY AHEAD 
C     WGO     FLAG (T,F) INDICATING WHETHER A LANE CHANGE (HAS,HASN'T)  
C             OCCURED THIS TIME STEP                                    
C     WTHRU   FLAG INDICATING WHETHER THROUGH VEHICLE IS A MANDATORY    
C             LANE CHANGER                                              
C     WTYPE   FLAG INDICATING WHETHER A VEHICLE IS IN A LANE CHANNELIZED
C             FOR BUSES AND/OR CAR-POOLS AND IT DOES NOT BELONG         
C     XGOALN  VEHICLE SPECIFIC ARRAY - CURRENT GOAL LANE OF VEHICLE IV  
C             ON ALL LINKS IN PATH                                      
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH AND LINK MINUS STREET   
C                                   LENGTH                              
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IL = I1                                                           
      IV = I2                                                           
      ITURN = I3                                                        
      ILN = I4                                                          
      IVTYP = I5                                                        
      INUMLN = I6                                                       
C                                                                       
C -----  INITIALIZE RETURN ARGUMENTS AND GET CURRENT LANE               
C                                                                       
      JLCMOT = 0                                                        
      JNUMLC = 0                                                        
C                                                                       
C -----  RESET THE TARGET LANE IN VHLANE ARRAY AND CLEAR BIT 12.        
C                                                                       
      VHLANE(IV) = VHLANE(IV) - MOD(VHLANE(IV), 2**3) -                 
     1            MOD(VHLANE(IV) / 2**11, 2) * 2**11                    
C                                                                       
C -----  RETURN IF VEHICLE STILL WITHIN INTERSECTION.                   
C                                                                       
      WGO = .FALSE.                                                     
      ITYPE = NVHTYP(IV)                                                
      ILEN = VTYPLE(ITYPE)                                              
      IF (DISTUP(IV) .LT. XLNGTH(IL) / 2**12 * 10)                      
     1                                                       GO TO 30   
C                                                                       
C -----  CALL SUBROUTINE TO DETERMINE DRIVER MOTIVATION FOR A LANE      
C -----  CHANGE.  IF DRIVER IS MOTIVATED THEN CALL SUBROUTINE TO        
C -----  DETERMINE CANDIDATE LANE(S), JCL AND JCR, FOR LANE CHANGE      
C                                                                       
      CALL MOTIV (IV, IL, ILN, ITURN, IVTYP, INUMLN, JLCMOT,            
     1       WBLOCK, WBLAHD, RDAF, WTYPE, WTHRU)                        
C                                                                       
      IF (JLCMOT .EQ. 0)                                     GO TO 20   
C                                                                       
      CALL CANLNE(IL, ILN, IV, INUMLN, IVTYP, ITURN, WBLOCK, WTHRU,     
     1            WTYPE, JCL, JCR, WBADLN)                              
C                                                                       
C -----  IF AT LEAST ONE CANDIDATE LANE EXISTS THEN CALL A SUBROUTINE   
C -----  TO DETERMINE THE FAVORED LANE FOR LANE CHANGE AND STORE IT IN  
C -----  THE VHLANE ARRAY.  ELSE, ENTRY IN VHLANE IS LEFT AS ZERO.      
C                                                                       
      IF (JCL + JCR .EQ. 0)                                  GO TO 10   
      CALL ADVANT (IV, IL, ILN, JCL, JCR, JLCMOT, ITURN, WBLOCK, WBLAHD,
     1             WBADLN)                                              
C                                                                       
C -----  IF THERE IS AN ADVANTAGE TO THE LANE CHANGE, I.E., TARGET LANE 
C -----  > 0, THEN CALL SUBROUTINE TO DETERMINE WHETHER A LANE CHANGE   
C -----  WILL BE COMPLETED NOW.                                         
C                                                                       
      IF (MOD(VHLANE(IV), 2**3) .GT. 0) CALL LCHDEC(IL, IV, ILN,        
     1    INUMLN, IVTYP, JLCMOT, RDAF, WBLOCK, WTHRU, WTYPE, WGO,       
     2    JNUMLC, JTLEAD, JTFLW)                                        
C                                                                       
C -----  IF LANE CHANGE WILL OCCUR THIS TIME STEP (WGO = .T.), THEN THE 
C -----  UPDATED VALUES OF SPEED, ACCELERATION, POSITION, WERE STORED   
C -----  INTO ARRAYS SPDLN, ACCEL, DISTUP,IN LCHDEC.  THE PROCESS CODE  
C -----  WAS SET IN NVHCDE, AS WELL.  CALL SUBROUTINE TO PROCESS        
C -----  (I.E., MOVE) THE LANE-CHANGER AND UPDATE ALL REMAINING ARRAYS. 
C                                                                       
      IF (WGO) CALL LCVEH (IV, IL, ILN, JTLEAD, JTFLW)                  
      IF (PRVGLN(IV) .GT. 0) THEN                                       
         ITURN = MOD(PRVGLN(IV) / 2**7, 2**3)                           
         IF (.NOT. WGO) THEN                                            
            IGOAL = MOD(PRVGLN(IV), 2**7)                               
            VHLANE(IV) = VHLANE(IV) -                                   
     1                            MOD(VHLANE(IV) / 2**3, 2**7) * 2**3 + 
     2                            IGOAL * 2**3                          
            TCODE(IV) =  ITURN                                          
            PRVGLN(IV) = 0                                              
         ELSE                                                           
            PRVGLN(IV) = 0                                              
            ITURN2 = TCODE(IV)                                          
            IF (ITURN2 .NE. ITURN) THEN                                 
               JJ = 3 * IV - 2                                          
               XGOALN(JJ) = 0                                           
               XGOALN(JJ+1) = 0                                         
               XGOALN(JJ+2) = 0                                         
            ENDIF                                                       
         ENDIF                                                          
      ENDIF                                                             
   10 CONTINUE                                                          
   20 CONTINUE                                                          
   30 CONTINUE                                                          
      W1 = WGO                                                          
      J1 = JNUMLC                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CHKOPP (IN)                                            
C                                                                       
C                                                                       
C --- CODED    6-24-93 BY J. WERK                                       
C                                                                       
C --- TITLE - CHECK OPPOSING RECEIVERS - MODULE 32310.4                 
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE GEOMETRY OF OPPOSING RECEIVERS  
C ---            STRUCTURE FOR MICROINTERSECTIONS.                      
C                                                                       
C --- ARGUMENTS - IN     = NODE NUMBER, FROM CALLING ROUTINE            
C                                                                       
C -------------------------   DESCRIPTION  ---------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED IT IS TIME TO CHECK WHETHER A THROUGH 
C     OR LEFT DIAGONAL RECEIVER OF AN OPPOSING NODE TO A MICRONODE      
C     ACTUALLY CROSSES THE LEFT TURN PATH OF APPROACH TO MICRONODE.     
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    PSMICN - MODULE 3.2.3.10                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    REBCOR - MODULE 32310.1.1                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     IA      INDEX TO DO LOOP - APPROACH  TO MICRONODE LINK NUMBER, IN 
C     IANGAP  ANGLE APPROACH LINK MAKES WITH X-AXIS                     
C     IANGOP  ANGLE OPPOSING LINK MAKES WITH X-AXIS                     
C     IANGTH  ANGLE THROUGH RECIVER OR LEFT DIAGONAL RECEIVER OF        
C             OPPOSING LINK MAKES WITH X-AXIS                           
C     IAP     APPROACH LINK NUMBER                                      
C     IDIFF1  DIFFERENCE IN ANGLE BETWEEN APPROACH AND OPPOSING LINKS   
C     IDIFF2  DIFFERENCE IN ANGLE BETWEEN OPPOSING AND THROUGH OR LEFT  
C             DIAGONAL RECEIVER TO OPPOSING LINKS                       
C     IDN     DOWNSTREAM NODE NUMBER OF THROUGH OR LEFT DIAGONAL        
C             RECEIVER TO OPPOSING LINK                                 
C     IJ      INDEX TO SIGI ARRAY                                       
C     IOP     OPPOSING LINK NUMBER                                      
C     IUPAP   UPSTREAM NODE NUMBER OF APPROACH LINK TO MICRONODE        
C     IUPOP   UPSTREAM NODE NUMBER OF OPPOSING LINK                     
C     IUSEN   USE SPECIFIED NODE NUMBER FOR MICRONODE                   
C     IX      INDEX TO INTERFACE OR ENTRY/EXIT NODE ARRAYS              
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK            
C     NMAP    NODE SPECIFIC ARRAY - USER SPECIFIED NODE NUMBER          
C     OPPOSE  LINK SPECIFIC ARRAY - LINK CARRYING ONCOMING TRAFFIC      
C     RANGL1  ANGLE BETWEEN LINKS IAP AND IOP MEASURED COUNTER-CLOCKWISE
C             FROM LINK IAP                                             
C     RANGL2  ANGLE BETWEEN LINKS IOP AND THROUGH OR LEFT DIAGONAL      
C             RECEIVER TO LINK IOP MEASURED COUNTER-CLOCKWISE FROM      
C             LINK IOP                                                  
C     RCOS    COSINE OF THE ANGLE BETWEEN 2 LINKS                       
C     RCP     CROSS PRODUCT OF 2 LINKS                                  
C     RDAX    DIFFERENCE IN X COORDINATES OF LINK IAP                   
C     RDAY    DIFFERENCE IN Y COORDINATES OF LINK IAP                   
C     RDBX    DIFFERENCE IN X COORDINATES OF LINK IOP                   
C     RDBY    DIFFERENCE IN Y COORDINATES OF LINK IOP                   
C     RDCX    DIFFERENCE IN X COORDINATES OF THROUGH OR LEFT DIAGONAL   
C             RECEIVER TO OPPOSING LINK                                 
C     RDCY    DIFFERENCE IN Y COORDINATES OF THROUGH OR LEFT DIAGONAL   
C             RECEIVER TO OPPOSING LINK                                 
C     RXDN    X COORDINATE OF NODE IDN                                  
C     RXUPA   X COORDINATE OF NODE IAP                                  
C     RXUPO   X COORDINATE OF NODE IOP                                  
C     RXUSEN  X COORDINATE OF NODE IUSEN                                
C     RYDN    Y COORDINATE OF NODE IDN                                  
C     RYUPA   Y COORDINATE OF NODE IAP                                  
C     RYUPO   Y COORDINATE OF NODE IOP                                  
C     RYUSEN  Y COORDINATE OF NODE IUSEN                                
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBERS  
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK                 
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     WANGLE  FLAG (T, F) IF USER (DID, DID NOT) SPECIFY ANGLES         
C     XGCOOR  NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND           
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS),    
C             A TEMPORARY CODE OF 1 IS SET IN BIT 31 OF THE FIRST       
C             WORD FOR THE NODE TO INDICATE COORDINATES FOR IT WERE     
C             INPUT ON A TYPE 195 CARD                                  
C     XWIDT2  ARRAY CONTAINING:  WIDTH OF PARKING LANE                  
C                                DISTANCE FROM STOP-LINE TO CURB        
C                                CURVATURE CODE                         
C                                ELEVATION CODE                         
C                                INTERCHANGE NUMBER, IF APPLICABLE      
C                                ANGLE OF LINK RELATIVE TO DUE NORTH    
C     ZPI     VALUE OF PI                                               
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q,S-V,X), REAL (R,Z), LOGICAL(W,Y)            
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
      COMMON /PRG025/ ZPI                                               
C                                                                       
C -----  DETERMINE USER SPECIFIED NODE NUMBER FOR MICRONODE AND         
C -----  WHETHER ANGLES WERE USED TO DEFINE LINKS.                      
C                                                                       
      IUSEN = IN                                                        
      IF (IUSEN .LT. 7000) IUSEN = NMAP(IN)                             
      WANGLE = .FALSE.                                                  
      IX = (IUSEN - 1) * 2 + 1                                          
      IF (XGCOOR(IX) .LT. 0) THEN                                       
         XGCOOR(IX)   = 8100                                            
         XGCOOR(IX+1) = 8100                                            
         WANGLE = .TRUE.                                                
      ENDIF                                                             
C                                                                       
C -----  LOOP OVER FIVE POSSIBLE APPROACHES TO MICRONODE.               
C                                                                       
         DO 10 IA = 1, 5                                                
            IJ = 5 * (IN - 1) + IA                                      
            IAP = SIGI(IJ)                                              
            IF (IAP .GT. 0) THEN                                        
               IF (LEFT(IAP) .GT. 0 .AND. OPPOSE(IAP) .GT. 0) THEN      
                  IOP = OPPOSE(IAP)                                     
C                                                                       
C -----  IF AN OPPOSING NODE TO THE APPROACH WAS SPECIFIED AND A        
C -----  THROUGH OR LEFT DIAGONAL RECEIVER FROM THAT OPPOSING NODE      
C -----  EXISTS THEN COMPUTE THE DIFFERENCE IN ANGLES BETWEEN           
C -----  THE APPROACH AND OPPOSING LINKS AND THE OPPOSING LINK AND      
C -----  ITS THROUGH OR LEFT DIAGONAL RECEIVER.                         
C                                                                       
                  IF (THRU(IOP) .GT. 0 .OR. DIAGNL(IOP) .LT. 0) THEN    
                     IF (WANGLE) THEN                                   
                        IANGAP = MOD(XWIDT2(IAP) / (2**18), 2**9)       
                        IANGOP = MOD(XWIDT2(IOP) / (2**18), 2**9)       
                        IF (THRU(IOP) .GT. 0) THEN                      
                           IANGTH = MOD(XWIDT2(THRU(IOP))/(2**18), 2**9)
                        ELSE                                            
                           IANGTH = MOD(XWIDT2(ABS(DIAGNL(IOP))) /      
     1                              (2**18), 2**9)                      
                        ENDIF                                           
                        IF (IANGAP .GT. 180) IANGAP = IANGAP - 360      
                        IF (IANGOP .GT. 180) IANGOP = IANGOP - 360      
                        IF (IANGTH .GT. 180) IANGTH = IANGTH - 360      
                        IDIFF1 = IANGAP - IANGOP                        
                        IF (IDIFF1 .GT. 0) IDIFF1 = IDIFF1 - 360        
                        IDIFF2 = IANGAP - IANGTH                        
                        IF (IDIFF2 .GT. 0) IDIFF2 = IDIFF2 - 360        
C                                                                       
C -----  CALL ERGEN IF ANGLE BETWEEN APPROACH AND OPPOSING LINKS IS     
C -----  LESS THAN THE ANGLE BETWEEN THE OPPOSING LINK AND ITS THROUGH  
C -----  OR LEFT DIAGONAL RECEIVER.                                     
C                                                                       
                        IF (IDIFF2 .LT. IDIFF1) THEN                    
                           IUPAP = UPNOD(IAP)                           
                           IUPOP = UPNOD(IOP)                           
                           IF (THRU(IOP) .GT. 0) THEN                   
                              IDN = DWNOD(THRU(IOP))                    
                           ELSE                                         
                              IDN = DWNOD(ABS(DIAGNL(IOP)))             
                           ENDIF                                        
                           IF (IUPAP .LT. 7000) IUPAP = NMAP(IUPAP)     
                           IF (IUPOP .LT. 7000) IUPOP = NMAP(IUPOP)     
                           IF (IDN .LT. 7000) IDN = NMAP(IDN)           
                           CALL ERGEN ('CHKOPP', 711,                   
     1                                  IUSEN, IUPAP, IUPOP, IDN, 4)    
                        ENDIF                                           
                     ELSE                                               
                        IUPAP = UPNOD(IAP)                              
                        IUPOP = UPNOD(IOP)                              
                        IF (THRU(IOP) .GT. 0) THEN                      
                           IDN = DWNOD(THRU(IOP))                       
                        ELSE                                            
                           IDN = DWNOD(ABS(DIAGNL(IOP)))                
                        ENDIF                                           
                        IF (IUPAP .LT. 7000) IUPAP = NMAP(IUPAP)        
                        IF (IUPOP .LT. 7000) IUPOP = NMAP(IUPOP)        
                        IF (IDN .LT. 7000) IDN = NMAP(IDN)              
                        CALL REBCOR (IUSEN, RXUSEN, RYUSEN)             
                        CALL REBCOR (IUPAP, RXUPA, RYUPA)               
                        CALL REBCOR (IUPOP, RXUPO, RYUPO)               
                        CALL REBCOR (IDN, RXDN, RYDN)                   
                        RDAX = RXUSEN - RXUPA                           
                        RDAY = RYUSEN - RYUPA                           
                        RDBX = RXUSEN - RXUPO                           
                        RDBY = RYUSEN - RYUPO                           
                        RDCX = RXDN - RXUSEN                            
                        RDCY = RYDN - RYUSEN                            
C                                                                       
C -----  COMPUTE THE COSINE, RCOS, OF THE ANGLE BETWEEN LINK IAP        
C -----  (VECTOR A) AND LINK IOP (VECTOR B).  ALSO COMPUTE THE CROSS    
C -----  PRODUCT, RCP.                                                  
C                                                                       
                        RCOS = 0.                                       
                        IF (SQRT (RDAX ** 2 + RDAY ** 2) *              
     1                     SQRT (RDBX ** 2 + RDBY ** 2)  .GT. .0001)    
     2                     RCOS = (RDAX * RDBX + RDAY * RDBY) /         
     3                            (SQRT (RDAX ** 2 + RDAY ** 2) *       
     4                             SQRT (RDBX ** 2 + RDBY ** 2))        
                        RCP = RDAX * RDBY - RDAY * RDBX                 
                        IF (RCOS .GE.  1.) RANGL1 = 0.                  
                        IF (RCOS .LE. -1.) RANGL1 = ZPI                 
                        IF (RCOS .GT. -1.  .AND.  RCOS .LT. 1.)         
     1                         RANGL1 = ACOS (RCOS)                     
                        IF (RCP .LE. 0.) RANGL1 = RANGL1 - 2. * ZPI     
                        IF (RANGL1 .GT. 0) RANGL1 = RANGL1 - 2. * ZPI   
C                                                                       
C -----  COMPUTE THE COSINE, RCOS, OF THE ANGLE BETWEEN LINK IAP        
C -----  (VECTOR A) AND THRU OR LEFT DIAGONAL RECEIVER TO LINK IOP      
C -----  (VECTOR C).  ALSO COMPUTE THE CROSS PRODUCT, RCP.              
C                                                                       
                        RCOS = 0.                                       
                        IF (SQRT (RDAX ** 2 + RDAY ** 2) *              
     1                     SQRT (RDCX ** 2 + RDCY ** 2)  .GT. .0001)    
     2                     RCOS = (RDAX * RDCX + RDAY * RDCY) /         
     3                            (SQRT (RDAX ** 2 + RDAY ** 2) *       
     4                             SQRT (RDCX ** 2 + RDCY ** 2))        
                        RCP = RDAX * RDCY - RDAY * RDCX                 
                        IF (RCOS .GE.  1.) RANGL2 = 0.                  
                        IF (RCOS .LE. -1.) RANGL2 = ZPI                 
                        IF (RCOS .GT. -1.  .AND.  RCOS .LT. 1.)         
     1                         RANGL2 = ACOS (RCOS)                     
                        IF (RCP .LE. 0.) RANGL2 = RANGL2 - 2. * ZPI     
                        IF (RANGL2 .GT. 0) RANGL2 = RANGL2 - 2. * ZPI   
C                                                                       
C -----  CALL ERGEN IF ANGLE BETWEEN APPROACH AND OPPOSING LINKS IS     
C -----  LESS THAN THE ANGLE BETWEEN THE OPPOSING LINK AND ITS THROUGH  
C -----  OR LEFT DIAGONAL RECEIVER.                                     
C                                                                       
                        IF (RANGL2 .LT. RANGL1) CALL ERGEN ('CHKOPP',   
     1                      711,  IUSEN, IUPAP, IUPOP, IDN, 4)          
                     ENDIF                                              
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
   10    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CHKTRN                                                 
C                                                                       
C                                                                       
C --- CODED   10-17-91 BY A. KANAAN                                     
C                                                                       
C --- TITLE - CHECKS IF TRANSITION SHOULD BE ACTIVATED                  
C                                                                       
C --- FUNCTION - THIS ROUTINE CHECKS SIGNAL SETUPS AT THE               
C ---            BEGINING OF A TIME STEP. IF TRANSITION LOGIC IS TO     
C ---            BE ACTIAVTED OR ACTIVE, THEN IT SETS NECESSARY ARRAYS  
C ---            ACCORDINGLY.                                           
C ---                                                                   
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE LOOPS OVER ALL NODES, IN, FOR ALL FIXED-TIME          
C     CONTROLLERS, THE TIMER FOR THE ACTIVE INTERVAL IS CHECKED.        
C     IF SIGNAL TRANSITION IS DUE OR ACTIVE, THEN ARRAYS ARE PRIMED     
C     ACCORDINGLY.                                                      
C                                                                       
C --------------------  THIS ROUTINE CALLED BY  ------------------------
C                       ----------------------                          
C                                                                       
C                    MOVE                                               
C                                                                       
C ---------------------   THIS ROUTINE CALLS   -------------------------
C                         ------------------                            
C                                                                       
C                    TRNSTN - MODULE 3233.4                             
C                                                                       
C ------------------   GLOSSARY OF VARIABLE NAMES  -------------------- 
C                      --------------------------                       
C                                                                       
C     CLOCK   ELAPSED SIMULATED TIME (SEC) AT START OF TIME-STEP        
C     DURINT  INTERVAL SPECIFIC ARRAY - INTERVAL DURATION, REF. OFFSET  
C     FZPNTR  NODE SPECIFIC ARRAY - POINTER TO DURINT ARRAY             
C     IN      INTERNAL NODE NUMBER                                      
C     INTRVL  CURRENTLY ACTIVE INTERVAL                                 
C     IP      POINTER TO FIRST INTERVAL, AT NODE IN, IN DURINT ARRAY    
C     IREF    SIGNAL REFERENCE OFFSET                                   
C     J       INDEX TO DURINT ARRAY                                     
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     NACT    ARRAY OF CODE IDENTIFYING CONTROL AT EACH NODE            
C     NMAP    ARRAY OF SPECIFIED NODE NUMBERS                           
C     PDURNT  INTERVAL SPECIFIC ARRAY - INTERVAL DURATION, REF OFFSET   
C             DURING SIGNAL TRANSITION                                  
C     PFZPNT  NODE SPECIFIC ARRY - POINTER TO PDURNT ARRAY              
C     PNACT   NODE SPECIFIC ARRAY - TYPE OF CONTROL AT BEGIN OF SIGNAL  
C             TRANSITION                                                
C     SIGT    ARRAY CONTAINING CURRENT INTERVAL AND ELAPSED TIME        
C     SNPFRQ  TIME BETWEEN UPDATES OF SNAPSHOT FILE (SECS)              
C     TTLND   TOTAL NUMBER OF INTERNAL NODES                            
C     W       FLAG SET .TRUE. IF INTERVAL DURATIONS REMAIN IN XSGTRN    
C     WNEWIN  FLAG (T,F) IF FIRST SECOND OF FIRST INTERVAL              
C     XSGTRN  NODE SPECIFIC ARRAY - COMPUTED MAIN STREET GREEN INTERVAL 
C             DURATIONS DURING TRANSITION                               
C     YINIT   FLAG (T,F) IF INITIALIZATION (IS, IS NOT) UNDERWAY        
C     YTRACE  FLAG (T,F) IF TRACING (IS, IS NOT) REQUIRED               
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL NETWORK NODES ARE SCANNED. WRITE MESSAGE AND COUNT 
C -----  FOR AN ACTUATED CONTROLLER.                                    
C -----  PROCESS IF CONTROL IS A FIXED-TIME SIGNAL.  INCREMENT          
C -----  INTERVAL ACTIVE TIME IN SIGT.  CHECK IF INTERVAL HAS           
C -----  JUST BEGUN. IF SO, SET NEW INTERVAL TO TRUESET SIGT TO NEXT    
C -----  INTERVAL (INTERVAL NUMBER 1 IF START OF CYCLE).                
C                                                                       
      DO 30 IN = 1, TTLND                                               
         INTRVL = 1                                                     
         WNEWIN = .FALSE.                                               
         IF (NACT(IN) .EQ. 0) THEN                                      
             INTRVL = MOD (SIGT(IN), 2**4)                              
             J = MOD (FZPNTR(IN), 2**11) + INTRVL - 1                   
             WNEWIN = (INTRVL.EQ.1 .AND. MOD(SIGT(IN)/2**4,2**8).EQ.0)  
         ENDIF                                                          
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
C     AT BEGINNING OF CYCLE, PROCESS THOSE NODES THAT ARE AT THE START  
C     OF TRANSITION OR IN TRANSITION.  IF AT THE START OF TRANSITION,   
C     CALL ROUTINE TO LOAD SIGNAL ARRAYS FROM TEMPORARY STORAGE AND THE 
C     XSGTRN ARRAY WITH COMPUTED MAIN STREET GREEN INTERVAL DURATIONS   
C     (MAX = 3) FOR USE DURING TRANSITION.                              
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
         IF (WNEWIN  .AND.  (PNACT(IN).NE.-9 .OR. XSGTRN(IN).GT.0)) THEN
             IF (PNACT(IN) .NE. -9) CALL TRNSTN(IN)                     
C                                                                       
             IF (YTRACE) WRITE(LU6,1100) CLOCK,NMAP(IN),PNACT(IN)       
C                                                                       
C -----  IF THERE IS AT LEAST ONE UNUSED MAIN STREET GREEN INTERVAL     
C -----  DURATION IN THE XSGTRN ARRAY, SHIFT AND LOAD INTO DURINT ARRAY,
C -----  BEING SURE TO RETAIN REFERENCE OFFSET STORED IN DURINT.        
C                                                                       
             J = MOD (FZPNTR(IN), 2**11)                                
             W = XSGTRN(IN) .LT. 2**7                                   
             IF (.NOT. W) THEN                                          
                 IREF = 0                                               
                 XSGTRN(IN) = XSGTRN(IN) / 2**7                         
                 IF (DURINT(J).GE.2**7) IREF = MOD(DURINT(J)/2**7, 2**8)
                 DURINT(J) = MOD (XSGTRN(IN), 2**7) + IREF * 2**7       
             ENDIF                                                      
C                                                                       
C -----  WHEN ALL MAIN STREET GREEN INTERVALS HAVE BEEN USED (FOR       
C -----  TRANSITION PERIOD) CLEAR XSGTRN ARRAY AND LOAD DURINT WITH     
C -----  MAIN STREET GREEN INTERVAL DURATION TO BE USED THROUGHOUT      
C -----  REST OF TIME PERIOD.                                           
C                                                                       
             W = W .AND. XSGTRN(IN) .GT. 0                              
             IF (W) THEN                                                
                 XSGTRN(IN) = 0                                         
                 IP = MOD (PFZPNT(IN), 2**11)                           
                 DURINT(J) = PDURNT(IP)                                 
             ENDIF                                                      
         ENDIF                                                          
30    CONTINUE                                                          
C                                                                       
      RETURN                                                            
 1100 FORMAT (' CHKTRN:CLOCK,IN,PNACT(IN)', 3I6)                        
      END                                                               
      SUBROUTINE CKCTRL                                                 
C                                                                       
C                                                                       
C --- CODED    5-17-78 BY B. ANDREWS                                    
C --- REVISED  9-12-79 BY B. ANDREWS (FOR NETSIM)                       
C --- REVISED 11-08-85 BY A. HALATI (FOR NETSIM ACT.LOGIC)              
C --- REVISED 12-08-87 BY K. SHERIDAN FOR SIGNAL TRANSITION             
C --- REVISED  6-23-93 BY B. ANDREWS TO CORRECT CODE SO MESSAGE 2630    
C ---                        IS PRODUCED WHEN NO PHASE SERVICES AN      
C ---                        EXISTING MOVEMENT                          
C                                                                       
C --- TITLE - CHECK THAT ALL TRAFFIC MOVEMENTS CAN BE SERVICED          
C ---         BY CONTROL - MODULE 2261.5.4.1                            
C                                                                       
C --- FUNCTION - THIS MODULE TESTS THAT EVERY MOVEMENT WITH A NON-ZERO  
C ---            TURN PERCENTAGE IS SERVICED BY SOME GO INTERVAL        
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE IS CALLED AFTER ALL LINK, TURN AND SIGNAL CARDS      
C     HAVE BEEN READ.  IT LOOPS OVER ALL LINKS IN THE SUBNETWORK        
C     AND CHECKS THAT EVERY MOVEMENT WITH A NON-ZERO TURN               
C     PERCENTAGE IS SERVICED BY SOME GO INTERVAL                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GCNTFN - MODULE 2261.5.4                           
C                    INPTSN - MODULE 2.2.6.2                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     FZPNTR  NODE SPECIFIC ARRAY - POINTER TO DURINT ARRAY             
C     I       HOLD AREA                                                 
C     IAC     ACTUATED CONTROLLER NUMBER (0, IF NOT UNDER ACT. CTRL)    
C     ICODE   MVMENT CODE FOR MVMENT IMV DURING INTERVAL INT FOR LINK IL
C     IL      DO LOOP INDEX, LINK NUMBER                                
C     IMV     DO LOOP INDEX, MOVEMENT                                   
C     IMVCD   ARRAY OF CODES (CORRESPONDING TO IMV) TO BE OUTPUT        
C             IN ERROR MESSAGE 2630                                     
C     IN      DOWNSTREAM NODE OF LINK IL                                
C     INT     INDEX, INTERVAL NUMBER                                    
C     INTMAX  NUMBER OF INTERVALS DEFINED AT NODE IN                    
C     IOUTCD  MOVEMENT CODE TO BE OUTPUT IN ERROR MESSAGE               
C     IPCT    TURNING PERCENT FOR MOVEMENT IMV DURING INTERVAL INT      
C     IWRK    ARRAY OF PERMITTED MOVEMENT CODES FOR EACH INTERVAL       
C     J       INDEX TO DURINT ARRAY FOR NODE IN                         
C     JJ      DIVISOR FOR UNPACKING MOVEMENT CODE FOR INTERVAL INT      
C     K       DURINT ARRAY OFFSET FOR DOWNSTREAM NODE OF LINK IL        
C     LANEGD  LINK SPECIFIC ARRAY - GRADE,NO. OF FULL AND POCKET LANES  
C     NACT    NODE SPECIFIC ARRAY - TYPE OF CONTROL                     
C     NMAP    NODE SPECIFIC ARRAY - USERS SPECIFIED NODE NUMBER         
C     PCTLR   LINK SPECIFIC ARRAY - PERCENT OF TRAFFIC TURNING LFT,RITE 
C     PFZPNT  NODE SPECIFIC ARRAY - POINTER TO PDURNT ARRAY,NO. OF      
C             SIGNAL INTERVALS                                          
C     PNACT   NODE SPECIFIC ARRAY - 0, FOR SIGNAL DEFINED DURING        
C             SUBSEQUENT TIME PERIOD, ELSE -9                           
C     PTHRU   LINK SPECIFIC ARRAY - PERCENT OF TRAFFIC GOING THRU,DIAG  
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     WMATCH  FLAG (T,F) IF MOVEMENT (IS, ISNT) SERVICED BY A PHASE     
C     XINT1   LINK SPECIFIC ARRAY - PERMITTED MOVEMENTS FOR INTERVAL 1-6
C     XINT2   LINK SPECIFIC ARRAY - PERMITTED MOVEMENTS FOR INT. 7 - 12 
C     XPINT1  LINK SPECIFIC ARRAY - PERMITTED MOVEMENTS FOR INT. 1-6 IN 
C             SUBSEQUENT TIME PERIOD                                    
C     XPINT2  LINK SPECIFIC ARRAY - PERMITTED MOVEMENTS FOR INT. 7-12 IN
C             SUBSEQUENT TIME PERIOD                                    
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION IWRK(12), IMVCD(4)                                      
C                                                                       
      DATA IMVCD /2, 1, 3, 0/                                           
C                                                                       
C -----  TRA IF EXIT-INTERFACE LINK OR IF CONTROLLED BY A SIGN          
C -----  SCAN ALL LINKS IN SUBNETWORK                                   
C                                                                       
         DO 90 IL = 1, TTLNK                                            
            IAC = 0                                                     
            I   = 0                                                     
            IN = DWNOD(IL)                                              
            IF (IN .LT. 7000) THEN                                      
               IF (PNACT(IN) .EQ. -9) THEN                              
                  IAC = NACT(IN)                                        
                  I =   XINT1(IL)                                       
                  INTMAX = MOD (FZPNTR(IN) / 2**11, 2**4)               
                  K = MOD (FZPNTR(IN), 2**11) - 1                       
               ELSE                                                     
                  IAC = PNACT(IN)                                       
                  I   = XPINT1(IL)                                      
                  INTMAX = MOD (PFZPNT(IN) / 2**11, 2**4)               
                  K = MOD (PFZPNT(IN), 2**11) - 1                       
               ENDIF                                                    
            ENDIF                                                       
            IF (IAC .GT. 0)                                  GO TO 80   
            IF (IN .GE. 7000 .OR. I .EQ. 30 .OR. I .EQ. 31              
     1          .OR. I .EQ. 0 .OR. I .EQ. 16)                GO TO 70   
C                                                                       
C -----  UNPACK MOVEMENT CODES FOR EACH INTERVAL                        
C                                                                       
            DO 10 INT = 1, 12                                           
               IF (INT .EQ. 7) THEN                                     
                  IF (PNACT(IN) .EQ. -9) THEN                           
                     I = XINT2(IL)                                      
                  ELSE                                                  
                     I = XPINT2(IL)                                     
                  ENDIF                                                 
               ENDIF                                                    
               IWRK(INT) = MOD (I, 32)                                  
               I = I / 32                                               
   10       CONTINUE                                                    
C                                                                       
C -----  DOUNTIL ALL TURN MOVEMENTS HAVE BEEN EXAMINED                  
C                                                                       
            DO 60 IMV = 1, 4                                            
               IF (IMV .EQ. 1) IPCT = MOD (PCTLR(IL) / 2**7, 2**7)      
               IF (IMV .EQ. 2) IPCT = MOD (PTHRU(IL), 2**7)             
               IF (IMV .EQ. 3) IPCT = MOD (PTHRU(IL) / 2**7, 2**7)      
               IF (IMV .EQ. 4) IPCT = MOD (PCTLR(IL), 2**7)             
               WMATCH = .FALSE.                                         
               INT = 0                                                  
               JJ = 2 ** (IMV-1)                                        
C                                                                       
C -----  DOUNTIL ALL PHASES SCANNED OR MOVEMENT IS SERVICED             
C                                                                       
   20          CONTINUE                                                 
               INT = INT + 1                                            
               J = K + INT                                              
               ICODE = MOD(IWRK(INT) / JJ, IMV / 4 + 2)                 
               IF (IWRK(INT) .NE. 24  .AND.  ICODE - 1 .NE. 0)          
     1             WMATCH = .TRUE.                                      
               IF (.NOT. WMATCH .AND. INT .LT. INTMAX)       GO TO 20   
               IF (WMATCH)                                   GO TO 40   
               I = UPNOD(IL)                                            
               IF (I .LT. 7000) I = NMAP(I)                             
               J = IN                                                   
               IF (J .LT. 7000) J = NMAP(IN)                            
               IOUTCD = IMVCD(IMV)                                      
C                                                                       
C -----  NO PHASE SERVICES THIS MOVEMENT. OUTPUT MESSAGE IF             
C -----  NON-ZERO TURN PERCENTAGE INPUT                                 
C                                                                       
               IF (IPCT .NE. 0)                                         
     2            CALL ERGEN ('CKCTRL', 2630, I, J, IPCT, IOUTCD, 4)    
C                                                                       
C -----  NO PHASE SERVICES THIS MOVEMENT. OUTPUT WARNING IF MOVEMENT    
C -----  IS LEFT OR RIGHT AND A POCKET EXISTS FOR THAT MOVEMENT         
C                                                                       
               IF (IMV .EQ. 1 .AND. MOD(LANEGD(IL) / 2**6, 2**2) .NE. 0)
     1            CALL ERGEN ('CKCTRL', 622, IOUTCD, I, J, 0, 3)        
               IF (IMV .EQ. 4 .AND. MOD(LANEGD(IL) / 2**8, 2**2) .NE. 0)
     1            CALL ERGEN ('CKCTRL', 622, IOUTCD, I, J, 0, 3)        
   40          CONTINUE                                                 
   60       CONTINUE                                                    
   70       CONTINUE                                                    
   80    CONTINUE                                                       
   90    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN11 (JCHAN)                                         
C                                                                       
C                                                                       
C --- CODED    3-22-78 BY B. ANDREWS                                    
C --- REVISED  8-06-79 BY B. ANDREWS (FOR NETSIM)                       
C --- REVISED  7-20-80 BY K. SHERIDAN (FOR NETSIM)                      
C --- REVISED  7-10-91 BY A. KANAAN TO CORRECT T-INTERSECTION CHECKING  
C --- REVISED 12-31-91 BY J. WERK TO REMOVE UNPACKING OF XBUF ARRAY,    
C ---                  RECOGNIZE CHANNELIZATION CODES 7-11, AND CHECK   
C ---                  THE VALIDITY OF ALL CHANNELIZATION CODES.        
C --- REVISED 12-30-92 BY J. WERK TO NOT SERVICE TURN MOVEMENTS FOR AN  
C ---                  UNCHANNELIZED LANE WHEN TURN POCKETS EXIST.      
C --- REVISED  1-19-95 BY S. WALKER TO CONSIDER EXIT INTERFACE LINKS    
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 11 -               
C ---         MODULE 2261.2.2.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 11                                  
C                                                                       
C --- ARGUMENTS - JCHAN  = CONTAINS MOVEMENTS SERVICED BY EACH LANE     
C ---                      FOR CURRENT LINK, TO CALLING ROUTINE         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 11 IS IN THE INPUT        
C     BUFFER. A CHECK WILL BE MADE AS TO THE UNIT TYPE INPUT (ENGLISH   
C     OR METRIC). IF METRIC UNITS INPUT, THE VALUES ARE TEMPORARILY     
C     STORED (FOR LATER PRINTING PURPOSES), A SUBROUTINE IS THEN        
C     CALLED TO CHECK EACH ITEM ON THE CARD. WHEN CONTROL RETURNS, THIS 
C     ROUTINE WILL THEN CHECK FOR INCONSISTENCIES BETWEEN RELATED       
C     ITEMS ON THE CARD.                                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN11 - MODULE 2261.2.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN11 - MODULE 2261.2211                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     I       DO-LOOP INDEX AND HOLD AREA                               
C     IBUSCP  NO. OF BUS AND/OR CARPOOL LANES WHICH SERVICE THRU TRAFFIC
C     ICODE   BITS IN JCHAN CONTAINING SERVICE CODES FOR SUBJECT LANE   
C     IDIAG   CODE (0, 1) IF DIAGONAL MOVEMENT (IS, ISN'T) ALLOWED      
C     IDIAGL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE DIAGONAL TURN MOVEMENT                        
C     IDIAGR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE DIAGONAL TURN MOVEMENT                        
C     IDW     DOWNSTREAM NODE NUMBER                                    
C     II      INDEX TO DO LOOP                                          
C     ILANE   CLOSEST LANE TO THE RIGHT OF SUBJECT LANE THAT HAS A      
C             CHANNNELIZATION CODE OTHER THAN 3 OR 9                    
C     ILEFTR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE LEFT TURN MOVEMENT                            
C     ILN     NUMBER OF FULL LANES                                      
C     IRGHTL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE RIGHT TURN MOVEMENT                           
C     ISHLN   SHARED LANE WHICH COULD SERVICE THE THROUGH MOVEMENT      
C     ITHRU   NUMBER OF LANES WHICH SERVICE THRU TRAFFIC                
C     ITHRUL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE THROUGH MOVEMENT                              
C     ITHRUR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE THROUGH MOVEMENT                              
C     IUP     UPSTREAM NODE NUMBER                                      
C     I0LANE  INTERIOR UNRESTRICTED LANE                                
C     I9CNT   COUNT OF LANES WITH CHANNELIZATION CODE 9                 
C     I9LANE  LANE NUMBER WITH CHANNELIZATION CODE 9                    
C     J       HOLD AREA AND INDEX                                       
C     JLEFT   INDEX OVER XBUF ARRAY                                     
C     K       INDEX                                                     
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT         
C     WCLOSE  FLAG, SET TO .TRUE. IF ALL LANES TO THE LEFT OF LANE 1 ARE
C             CLOSED                                                    
C     WDIAG   FLAG, SET TO .TRUE. IF LINK SERVICES DIAGONAL MOVEMENT    
C     WERR    FLAG, SET TO .TRUE. IF ERROR IN CHANNELIZATION CODE FOUND 
C     WLEFT   FLAG, SET TO .TRUE. IF LINK SERVICES LEFT TURN MOVEMENT   
C     WRGHT   FLAG, SET TO .TRUE. IF LINK SERVICES RIGHT TURN MOVEMENT  
C     WSHARE  FLAG, SET TO .TRUE. IF A CHANNELIZATION CODE OF 7 OR 8    
C             WAS INPUT FOR AT LEAST ONE LANE                           
C     WTHRU   FLAG, SET TO .TRUE. IF LINK SERVICES THROUGH MOVEMENT     
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO   
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)           
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
      IUP = XBUF(1)                                                     
      IDW = XBUF(2)                                                     
C                                                                       
C -----  WHEN GRADE IS NEGATIVE, ABSOLUTE VALUE OF GRADE WAS INCREMENTED
C -----  BY 90 IN ROUTINE PUTCDS SO THAT TYPE 11 CARD COULD BE READ     
C -----  IN 80I4 FORMAT. REPLACE MINUS SIGN.                            
C                                                                       
      IF (XBUF(9) .GT. 90) XBUF(9) = 90 - XBUF(9)                       
C                                                                       
C -----  CLEAR ELEMENTS OF BUFFER ARRAY TO BE USED FOR TEMPORARY        
C -----  STORAGE OF METRIC VALUES                                       
C                                                                       
         DO 20 I = 33, 36                                               
            XBUF(I) = 0                                                 
   20    CONTINUE                                                       
C                                                                       
C -----  TRA IF ENTRY OR INTERFACE LINK. THEN TRA IF ENGLISH UNITS      
C -----  INPUT. ELSE (METRIC UNITS INPUT), STORE METRIC VALUES          
C -----  TEMPORARILY IN BUFFER ARRAY. THEN CALL ROUTINE TO CONVERT      
C -----  METRIC TO ENGLISH                                              
C                                                                       
      IF (IUP .GT. 6999)                                     GO TO 45   
      IF (UNITIN .EQ. 0)                                     GO TO 40   
C                                                                       
C -----  TEMPORARILY STORE LINK LENGTH, LEFT AND RIGHT-TURN POCKET      
C -----  LENGTHS, AND FREE-FLOW SPEED                                   
C                                                                       
      XBUF(33) = XBUF( 3)                                               
      XBUF(34) = XBUF( 4)                                               
      XBUF(35) = XBUF( 5)                                               
      XBUF(36) = XBUF(25)                                               
      IF (XBUF(25) .EQ. 0) XBUF(36) = 48                                
      IF (XBUF(25) .GT. 104) XBUF(36) = 104                             
C                                                                       
C -----  CONVERT METRIC UNITS TO ENGLISH AND PUT BACK IN BUFFER         
C                                                                       
      DO 30 I = 3, 5                                                    
         IF (XBUF(I) .GT. 0)                                            
     1       XBUF(I) = ZCNVRT(4) * FLOAT (XBUF(I)) + 0.5                
   30 CONTINUE                                                          
      XBUF(25) = ZCNVRT(5) * FLOAT (XBUF(25)) + 0.5                     
   40 CONTINUE                                                          
   45 CONTINUE                                                          
C                                                                       
C -----  CHECK BOUNDS OF EACH ITEM                                      
C                                                                       
      CALL TBFN11                                                       
C                                                                       
C -----  CHECK THAT NODES DEFINING SUBJECT LINK ARE NOT BOTH            
C -----  INTERFACE NODES OR ENTRY NODES                                 
C                                                                       
      IF (IUP .GE. 7000  .AND.  IDW .GE. 7000)                          
     1    CALL ERGEN ('CKFN11', 2086, IUP, IDW, 11, 0, 3)               
C                                                                       
C -----  CHECK THAT POCKETS WERE NOT INPUT IF SUBJECT LINK IS AN ENTRY  
C                                                                       
      IF ((XBUF(4) .NE. 0  .OR.  XBUF(5) .NE. 0) .AND.                  
     1     IUP .GE. 8000)                                               
     2     CALL ERGEN ('CKFN11', 2080, IUP, IDW, 0, 0, 2)               
      K = 4                                                             
C                                                                       
C -----  FOR EACH POCKET CHECK THAT BOTH LENGTH AND NUMBER OF LANES     
C -----  WAS INPUT                                                      
C                                                                       
   50 CONTINUE                                                          
      I = XBUF(K) * XBUF(K+3)                                           
      J = XBUF(K) + XBUF(K+3)                                           
      IF (J .NE. 0  .AND.  I .EQ. 0)                                    
     1     CALL ERGEN ('CKFN11', 2081, IUP, IDW, 0, 0, 2)               
      K = K + 1                                                         
      IF (K .EQ. 5)                                          GO TO 50   
C                                                                       
C -----  DETERMINE IF CHANNELIZATION CODES ARE BAD. TRA TO 60 IF SO.    
C -----  (TBFN11 HAS ALREADY IDENTIFIED THE ERROR)                      
C -----  ELSE CHECK CONSISTENCY OF CHANNELIZATION CODES WITH GEOMETRY   
C                                                                       
      I9CNT = 0                                                         
      ILN = XBUF(6)                                                     
      J = 10                                                            
C                                                                       
C -----  DOUNTIL ALL EXISTING THROUGH (FULL) LANES ARE EXAMINED         
C                                                                       
      WLEFT = .FALSE.                                                   
      WTHRU = .FALSE.                                                   
      WRGHT = .FALSE.                                                   
      WDIAG = .FALSE.                                                   
      WSHARE = .FALSE.                                                  
      ISHLN = 0                                                         
      JCHAN = 0                                                         
      I0LANE = 0                                                        
      I9LANE = 0                                                        
      IBUSCP = 0                                                        
   60 CONTINUE                                                          
      WERR = .FALSE.                                                    
      J = J + 1                                                         
      IF (XBUF(J) .LT. 0  .OR.  XBUF(J) .GT. 11)             GO TO 90   
      IF (XBUF(J) .EQ. 9 .AND. XBUF(2) .LT. 7000) I9CNT = I9CNT + 1     
C                                                                       
C -----  CHECK IF LANE 1 CODE ILLOGICAL.  SET ERROR FLAG AND MOVEMENT   
C -----  FLAGS.  PACK JCHAN WITH MOVEMENT CODES.                        
C                                                                       
      IF (J .EQ. 11) THEN                                               
C                                                                       
C -----  IF LINK IS AN EXIT INTERFACE LINK, ALL LANES MUST BE THRU ONLY.
C -----  IF NOT, ISSUE A WARNING MESSAGE AND SET TO THRU ONLY.          
C                                                                       
         IF (XBUF(2) .GE. 7000) THEN                                    
             IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 11 .AND.             
     1           XBUF(J) .NE. 9)                                        
     2           CALL ERGEN ('CKFN11', 208, J-10, IUP, IDW, 0, 3)       
             WTHRU = .TRUE.                                             
             JCHAN = JCHAN + 2                                          
C                                                                       
C -----  IF LANE IS UNRESTRICTED OR CHANNELIZED FOR BUSES AND/OR        
C -----  CARPOOLS THEN IF LINK HAS ONLY ONE LANE OR ALL OTHER LANES ARE 
C -----  CLOSED, SERVICE ALL MOVEMENTS.  OTHERWISE, SERVICE RIGHT +     
C -----  RIGHT DIAGONAL OR THROUGH.  IF TURN POCKETS EXIST, DO NOT      
C -----  SERVICE TURNING TRAFFIC.                                       
C                                                                       
         ELSEIF (XBUF(11) .EQ. 0 .OR. XBUF(11) .EQ. 2 .OR.              
     1      XBUF(11) .EQ. 5 .OR. XBUF(11) .EQ. 6) THEN                  
            IF (XBUF(11) .NE. 0) IBUSCP = IBUSCP + 1                    
            WCLOSE = .TRUE.                                             
            IF (ILN .GT. 1) THEN                                        
                  DO 64 II = 12, ILN + 10                               
                     WCLOSE = WCLOSE .AND. XBUF(II) .EQ. 3              
   64             CONTINUE                                              
            ENDIF                                                       
            IF (ILN .EQ. 1 .OR. WCLOSE) THEN                            
               IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0) THEN           
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 1                                     
               ENDIF                                                    
               IF (XBUF(19) .GT. 0) THEN                                
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ENDIF                                                    
               IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN           
                  WRGHT = .TRUE.                                        
                  JCHAN = JCHAN + 4                                     
               ENDIF                                                    
               IF (XBUF(21) .NE. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
               ENDIF                                                    
            ELSE                                                        
               IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN           
                  JCHAN = JCHAN + 4                                     
                  WRGHT = .TRUE.                                        
               ENDIF                                                    
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
                  IF (IBUSCP .GT. 0) IBUSCP = 0                         
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSEIF (XBUF(20) .EQ. 0 .OR. XBUF(8) .GT. 0) THEN        
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR LEFT TURNERS THEN SET ERROR FLAG IF    
C -----  NO LEFT RECEIVER OR LANE IS FURTHER THAN 3 LANES FROM MEDIAN.  
C                                                                       
         ELSEIF (XBUF(11) .EQ. 1) THEN                                  
            IF (ILN .GT. 3 .OR. XBUF(18) .EQ. 0) THEN                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 1                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR RIGHT TURNERS THEN SET ERROR FLAG IF   
C -----  NO RIGHT RECEIVER SPECIFIED.                                   
C                                                                       
         ELSEIF (XBUF(11) .EQ. 4) THEN                                  
            IF (XBUF(20) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 4                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR RIGHT AND RIGHT DIAGONAL AND/OR     
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF NO RIGHT RECEIVER     
C -----  SPECIFIED.  SET WSHARE IF LANE SERVICES RIGHT AND RIGHT        
C -----  DIAGONAL MOVEMENTS.                                            
C                                                                       
         ELSEIF (XBUF(11) .EQ. 7) THEN                                  
            IF (XBUF(20) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 4                                        
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSE                                                     
                  CALL ERGEN ('CKFN11', 705, 1, IUP, IDW, 0, 3)         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR LEFT AND LEFT DIAGONAL AND/OR       
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF NO LEFT RECEIVER      
C -----  SPECIFIED OR LANE IS NOT WITHIN 3 FROM THE MEDIAN.  SET        
C -----  WSHARE IF LANE SERVICES LEFT AND LEFT DIAGONAL MOVEMENTS.      
C                                                                       
         ELSEIF (XBUF(11) .EQ. 8) THEN                                  
            IF (XBUF(18) .EQ. 0 .OR. ILN .GT. 3) THEN                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 1                                        
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSE                                                     
                  CALL ERGEN ('CKFN11', 706, 1, IUP, IDW, 0, 3)         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
         ELSEIF (XBUF(11) .EQ. 9) THEN                                  
                 I9LANE = 1                                             
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR DIAGONAL MOVEMENT THEN SET ERROR    
C -----  FLAG IF NO DIAGONAL RECEIVER WAS SPECIFIED.                    
C                                                                       
         ELSEIF (XBUF(11) .EQ. 10) THEN                                 
            IF (XBUF(21) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WDIAG = .TRUE.                                           
               JCHAN = JCHAN + 8                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR THROUGH MOVEMENT THEN SET ERROR     
C -----  FLAG IF NO THROUGH RECEIVER WAS SPECIFIED.                     
C                                                                       
         ELSEIF (XBUF(11) .EQ. 11) THEN                                 
            IF (XBUF(19) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WTHRU = .TRUE.                                           
               JCHAN = JCHAN + 2                                        
            ENDIF                                                       
         ENDIF                                                          
         IF (WSHARE) ISHLN = 1                                          
      ENDIF                                                             
C                                                                       
C -----  CHECK IF LANE J'S CHANNELIZATION CODE IS ILLOGICAL.  SET ERROR 
C -----  FLAG AND MOVEMENT FLAGS.  PACK JCHAN WITH MOVEMENT CODES.      
C                                                                       
      IF (J .GT. 11) THEN                                               
C                                                                       
C -----  SET ILANE EQUAL TO THE CLOSEST LANE TO THE RIGHT OF J THAT HAS 
C -----  A CHANNELIZATION CODE OTHER THAN 3 OR 9.                       
C                                                                       
         ILANE = J                                                      
   70    CONTINUE                                                       
         ILANE = ILANE - 1                                              
         IF (XBUF(ILANE) .EQ. 3 .OR. XBUF(ILANE) .EQ. 9) THEN           
            IF (ILANE .GT. 11) THEN                                     
                                                             GO TO 70   
            ELSE                                                        
               ILANE = 0                                                
            ENDIF                                                       
         ENDIF                                                          
         WSHARE = .FALSE.                                               
C                                                                       
C -----  IF LINK IS AN EXIT INTERFACE LINK, ALL LANES MUST BE THRU ONLY.
C -----  IF NOT, ISSUE A WARNING MESSAGE AND SET TO THRU ONLY.          
C                                                                       
         IF (XBUF(2) .GE. 7000) THEN                                    
             IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 11 .AND.             
     1           XBUF(J) .NE. 9)                                        
     2           CALL ERGEN ('CKFN11', 208, J-10, IUP, IDW, 0, 3)       
             WTHRU = .TRUE.                                             
             JCHAN = JCHAN + 2**((4*(J-11))+1)                          
C                                                                       
C -----  IF LANE IS UNRESTRICTED OR CHANNELIZED FOR BUSES AND/OR        
C -----  CARPOOLS THEN SET ERROR FLAG IF ILANE IS CHANNELIZED FOR LEFT  
C -----  OR LEFT AND LEFT DIAGONAL.                                     
C                                                                       
         ELSEIF (XBUF(J) .EQ. 0 .OR. XBUF(J) .EQ. 2 .OR.                
     1      XBUF(J) .EQ. 5 .OR. XBUF(J) .EQ. 6) THEN                    
            IF (XBUF(J) .NE. 0) IBUSCP = IBUSCP + 1                     
            IF (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR. XBUF(ILANE) 
     1          .EQ. 8)) THEN                                           
               WERR = .TRUE.                                            
            ELSEIF (J-10 .LT. ILN) THEN                                 
C                                                                       
C -----  IF LANE IS AN INTERIOR LANE THEN SET ERROR FLAG IF NO THROUGH  
C -----  OR DIAGONAL MOVEMENTS SPECIFIED.                               
C                                                                       
               IF (I0LANE .EQ. 0 .OR. XBUF(19) .EQ. 0 .OR. XBUF(21)     
     1                                         .EQ. 0) THEN             
                  I0LANE = J                                            
                  IF (XBUF(19) .GT. 0 .AND. XBUF(21) .LT. 0 .AND. WDIAG)
     1                                             WERR = .TRUE.        
                  IF (XBUF(19) .GT. 0 .AND. XBUF(21) .GT. 0 .AND. WTHRU)
     1                                             WERR = .TRUE.        
                  IF (XBUF(19) .GT. 0) THEN                             
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ENDIF                                                 
                  IF (XBUF(21) .NE. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ENDIF                                                 
                  IF (XBUF(19) .EQ. 0 .AND. XBUF(21) .EQ. 0)            
     1                                              WERR = .TRUE.       
C                                                                       
C -----  IF ALL LANES TO THE RIGHT ARE CLOSED, THEN IF A RIGHT RECEIVER 
C -----  WAS SPECIFIED, SERVICE THE RIGHT TURN.                         
C                                                                       
                  IF (ILANE .EQ. 0 .AND. I9LANE .EQ. 0) THEN            
                     IF (XBUF(20) .GT. 0) THEN                          
                        WRGHT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4 * (J - 11) + 2)           
                     ENDIF                                              
                  ENDIF                                                 
               ELSE                                                     
                  CALL ERGEN ('CKFN11', 2093, IUP, IDW, 0, 0, 2)        
               ENDIF                                                    
C                                                                       
C -----  IF ALL LANES TO THE LEFT ARE CLOSED, THEN IF A LEFT RECEIVER   
C -----  WAS SPECIFIED, SERVICE THE LEFT TURN.                          
C                                                                       
               IF (XBUF(18) .GT. 0) THEN                                
                  JLEFT = J                                             
   80             CONTINUE                                              
                  JLEFT = JLEFT + 1                                     
                  IF (XBUF(JLEFT) .EQ. 3 .AND. JLEFT .LT. 10 + XBUF(6)) 
     1                                                       GO TO 80   
                  IF (JLEFT .EQ. 10 + XBUF(6) .AND. XBUF(JLEFT) .EQ. 3) 
     1                                                       THEN       
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(J-11))                      
                  ENDIF                                                 
               ENDIF                                                    
            ELSE                                                        
C                                                                       
C -----  IF LANE IS THE MEDIAN LANE THEN SET ERROR FLAG IF NO THROUGH   
C -----  OR DIAGONAL OR LEFT MOVEMENTS SPECIFIED.                       
C                                                                       
               IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0) THEN           
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(J-11))                         
               ENDIF                                                    
C                                                                       
C -----  IF ALL LANES TO THE RIGHT ARE CLOSED, THEN IF A RIGHT OR RIGHT 
C -----  DIAGONAL RECEIVER WAS SPECIFIED, SERVICE THOSE MOVEMENTS.  DO  
C -----  NOT SERVICE A RIGHT IF A RIGHT POCKET EXISTS.                  
C                                                                       
               IF (ILANE .EQ. 0 .AND. I9LANE .EQ. 0) THEN               
                  IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN        
                     WRGHT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4 * (J - 11) + 2)              
                  ENDIF                                                 
                  IF (XBUF(21) .GT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ENDIF                                                 
               ENDIF                                                    
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  WSHARE = .TRUE.                                       
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
                  IF (IBUSCP .GT. 0) IBUSCP = IBUSCP - 1                
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+1)                     
               ELSEIF (XBUF(18) .EQ. 0 .OR. XBUF(7) .GT. 0) THEN        
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR LEFT TURNERS THEN SET ERROR FLAG IF    
C -----  NO LEFT RECEIVER OR LANE IS FURTHER THAN 3 LANES FROM MEDIAN.  
C                                                                       
         ELSEIF (XBUF(J) .EQ. 1) THEN                                   
            IF (XBUF(18) .EQ. 0 .OR. ILN - (J-10) + 1 .GT. 3) THEN      
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 2**(4*(J-11))                            
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR RIGHT OR RIGHT AND RIGHT DIAGONAL   
C -----  AND/OR THROUGH MOVEMENTS THEN SET ERROR FLAG IF LANE IS        
C -----  FURTHER THAN 3 LANES FROM THE CURB OR NO RIGHT RECEIVER WAS    
C -----  SPECIFIED OR ILANE IS NOT CHANNELIZED EXCLUSIVELY FOR RIGHT    
C -----  TURNERS.  SET WSHARE IF LANE SERVICES RIGHT AND RIGHT          
C -----  DIAGONAL MOVEMENTS.                                            
C                                                                       
         ELSEIF (XBUF(J) .EQ. 4 .OR. XBUF(J) .EQ. 7) THEN               
            IF (J-10 .GT. 3 .OR. XBUF(20) .EQ. 0 .OR. (ILANE .GT. 0     
     1                           .AND. XBUF(ILANE) .NE. 4)) THEN        
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 2**((4*(J-11))+2)                        
               IF (XBUF(J) .EQ. 7) THEN                                 
                  IF (XBUF(21) .GT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     WSHARE = .TRUE.                                    
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ELSEIF (XBUF(19) .GT. 0) THEN                         
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ELSE                                                  
                     CALL ERGEN ('CKFN11', 705, J-10, IUP, IDW, 0, 3)   
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR LEFT AND LEFT DIAGONAL AND/OR       
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF LANE IS FURTHER THAN  
C -----  3 LANES FROM THE MEDIAN OR NO LEFT RECEIVER WAS SPECIFIED OR   
C -----  ILANE IS NOT CHANNELIZED EXCLUSIVELY FOR LEFT TURNERS.  SET    
C -----  WSHARE IF LANE SERVICES LEFT AND LEFT DIAGONAL MOVEMENTS.      
C                                                                       
         ELSEIF (XBUF(J) .EQ. 8) THEN                                   
            IF (XBUF(18) .EQ. 0 .OR. ILN - (J-10) + 1 .GT. 3 .OR.       
     1          (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR.            
     2          XBUF(ILANE) .EQ. 8))) THEN                              
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 2**(4*(J-11))                            
               IF (XBUF(J) .EQ. 8) THEN                                 
                  IF (XBUF(21) .LT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     WSHARE = .TRUE.                                    
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ELSEIF (XBUF(19) .GT. 0) THEN                         
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ELSE                                                  
                     CALL ERGEN ('CKFN11', 706, J-10, IUP, IDW, 0, 3)   
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
         ELSEIF (XBUF(J) .EQ. 9) THEN                                   
                 I9LANE = J - 10                                        
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR DIAGONAL MOVEMENT THEN SET ERROR    
C -----  FLAG IF NO DIAGONAL RECEIVER WAS SPECIFIED.                    
C                                                                       
         ELSEIF (XBUF(J) .EQ. 10) THEN                                  
            IF (XBUF(21) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSEIF (XBUF(21) .GT. 0) THEN                               
C                                                                       
C -----  IF RIGHT DIAGONAL SPECIFIED THEN SET ERROR FLAG IF ILANE       
C -----  SERVICES ANY OTHER MOVEMENTS BESIDES RIGHT AND RIGHT DIAGONAL. 
C                                                                       
               IF (ILANE .EQ. 0 .OR. (ILANE .GT. 0 .AND. (XBUF(ILANE)   
     1             .EQ. 4 .OR. XBUF(ILANE) .EQ. 7 .OR. XBUF(ILANE)      
     2             .EQ. 10 .OR. (ILANE .NE. 11 .AND. (XBUF(ILANE) .EQ. 0
     3             .OR. XBUF(ILANE) .EQ. 2 .OR. XBUF(ILANE) .EQ. 5 .OR. 
     4             XBUF(ILANE) .EQ. 6) .AND. XBUF(19) .EQ. 0) .OR.      
     5             (ILANE .EQ. 11 .AND. XBUF(ILANE) .EQ. 0)))) THEN     
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
               ELSE                                                     
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ELSE                                                        
C                                                                       
C -----  IF LEFT DIAGONAL SPECIFIED THEN SET ERROR FLAG IF ILANE        
C -----  SERVICES LEFT TURNERS.                                         
C                                                                       
               IF (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR.          
     1              XBUF(ILANE) .EQ. 8)) THEN                           
                  WERR = .TRUE.                                         
               ELSE                                                     
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR THROUGH MOVEMENT ONLY THEN SET ERROR   
C -----  FLAG IF NO THROUGH MOVEMENT SPECIFIED OR ILANE SERVICES EITHER 
C -----  LEFT, LEFT DIAGONAL.                                           
C                                                                       
         ELSEIF (XBUF(J) .EQ. 11) THEN                                  
            IF (XBUF(19) .EQ. 0 .OR. (ILANE .GT. 0 .AND. (XBUF(ILANE)   
     1         .EQ. 1 .OR. XBUF(ILANE) .EQ. 8 .OR. (XBUF(ILANE) .EQ. 10 
     2         .AND. XBUF(21) .LT. 0) .OR. ((XBUF(ILANE) .EQ. 0 .OR.    
     3         XBUF(ILANE) .EQ. 2 .OR. XBUF(ILANE) .EQ. 5 .OR.          
     4         XBUF(ILANE) .EQ. 6) .AND. ILANE .NE. 11 .AND. XBUF(21)   
     5         .LT. 0)))) THEN                                          
               WERR = .TRUE.                                            
            ELSE                                                        
               WTHRU  = .TRUE.                                          
               JCHAN = JCHAN + 2**((4*(J-11))+1)                        
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  IF A SHARED LANE AND A RIGHT DIAGONAL WERE SPECIFIED THEN      
C -----  STORE SHARED LANE NUMBER IN ISHLN.  OTHERWISE, IF A LEFT       
C -----  DIAGONAL WAS SPECIFIED AND THIS IF THE FIRST SHARED LANE, THEN 
C -----  STORE THE SHARED LANE NUMBER IN ISHLN.                         
C                                                                       
         IF (WSHARE .AND. XBUF(21) .GT. 0) ISHLN = J - 10               
         IF (WSHARE .AND. XBUF(21) .LT. 0 .AND. ISHLN .EQ. 0)           
     1       ISHLN = J - 10                                             
      ENDIF                                                             
   90 CONTINUE                                                          
      IF (WERR) CALL ERGEN ('CKFN11', 2083, J-10, IUP, IDW, 0, 3)       
      IF (J .LT. ILN + 10)                                   GO TO 60   
C                                                                       
C ----   CHECK THAT ONLY ONE LANE CHANNELIZED WITH CODE 9 AND AT LEAST  
C -----  ONE LANE WILL SERVICE ALL SPECIFIED TURN MOVEMENTS.            
C                                                                       
      IF (WERR)                                              GO TO 130  
      IF (I9CNT .GT. 1) THEN                                            
         CALL ERGEN ('CKFN11', 2088, IUP, IDW, 0, 0, 2)                 
      ELSEIF (I9LANE .NE. 0) THEN                                       
         ILEFTR = 0                                                     
         ITHRUL = 0                                                     
         ITHRUR = 0                                                     
         IRGHTL = 0                                                     
         IDIAGL = 0                                                     
         IDIAGR = 0                                                     
C                                                                       
C -----  SET ITHRUL, IRGHTL, IDIAGL EQUAL TO ONE IF LANE TO THE LEFT OF 
C -----  I9LANE SERVICES THAT MOVEMENT.                                 
C                                                                       
         IF (I9LANE .NE. ILN) THEN                                      
            J = I9LANE                                                  
   95       CONTINUE                                                    
            J = J + 1                                                   
            ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                     
            IF (ICODE .EQ. 0 .AND. J .LT. 7) THEN                       
                                                             GO TO 95   
            ELSEIF (ICODE .NE. 0) THEN                                  
               ITHRUL = MOD(ICODE / 2, 2)                               
               IRGHTL = MOD(ICODE / 4, 2)                               
               IDIAGL = MOD(ICODE / 8, 2)                               
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  SET ILEFTR, ITHRUR, IDIAGR EQUAL TO ONE IF LANE TO THE RIGHT OF
C -----  I9LANE SERVICES THAT MOVEMENT.                                 
C                                                                       
         IF (I9LANE .NE. 1) THEN                                        
            J = I9LANE                                                  
  100       CONTINUE                                                    
            J = J - 1                                                   
            ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                     
            IF (ICODE .EQ. 0 .AND. J .GT. 1) THEN                       
                                                             GO TO 100  
            ELSEIF (ICODE .NE. 0) THEN                                  
               ILEFTR = MOD(ICODE, 2)                                   
               ITHRUR = MOD(ICODE / 2, 2)                               
               IDIAGR = MOD(ICODE / 8, 2)                               
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES LEFT TURNERS       
C -----  THEN I9LANE WILL ONLY SERVICE LEFT TURNERS.                    
C                                                                       
         IF (ILEFTR .EQ. 1) THEN                                        
            WLEFT = .TRUE.                                              
            JCHAN = JCHAN + 2**(4*(I9LANE-1))                           
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES LEFT DIAGONAL      
C -----  TURNERS THEN I9LANE WILL SERVICE LEFT DIAGONAL TURNERS.        
C -----  IF THE LANE TO THE LEFT OF I9LANE DOESN'T SERVICE THE LEFT     
C -----  DIAGONAL MOVEMENT THEN IF A LEFT MOVEMENT WAS SPECIFIED AND    
C -----  I9LANE IS WITHIN 3 LANES FROM THE MEDIAN THEN I9LANE WILL      
C -----  ALSO SERVICE LEFT TURNERS.                                     
C                                                                       
         ELSEIF (IDIAGR .EQ. 1 .AND. XBUF(21) .LT. 0) THEN              
            WDIAG = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                       
            IF (IDIAGL .NE. 1) THEN                                     
               IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN      
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES THROUGH TRAFFIC    
C -----  THEN I9LANE WILL ALSO SERVICE THROUGH TRAFFIC.  IF THE LANE    
C -----  TO THE LEFT OF I9LANE DOES NOT SERVICE THROUGH TRAFFIC THEN    
C -----  IF A LEFT DIAGONAL WAS SPECIFIED THEN I9LANE WILL SERVICE      
C -----  THE LEFT DIAGONAL MOVEMENT.  IF THE LANE TO LEFT OF I9LANE     
C -----  DOES NOT SERVICE THE LEFT DIAGONAL MOVEMENT THEN IF A LEFT     
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN     
C -----  IT WILL ALSO SERVICE THE LEFT TURN MOVEMENT.                   
C                                                                       
         ELSEIF (ITHRUR .EQ. 1) THEN                                    
            WTHRU = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                       
            IF (ITHRUL .NE. 1) THEN                                     
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1 .AND. XBUF(18) .GT. 0 .AND.         
     1                        ILN - I9LANE .LT. 3) THEN                 
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(I9LANE-1))                  
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO LEFT DIAGONAL MOVEMENT SO IF A LEFT     
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN     
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES RIGHT DIAGONAL     
C -----  TRAFFIC THEN I9LANE WILL ALSO SERVICE RIGHT DIAGONAL TRAFFIC.  
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE RIGHT       
C -----  DIAGONAL TRAFFIC THEN IF A THROUGH MOVEMENT WAS SPECIFIED THEN 
C -----  I9LANE WILL SERVICE THE THROUGH MOVEMENT.  IF THE LANE TO LEFT 
C -----  OF I9LANE DOES NOT SERVICE THE THROUGH MOVEMENT THEN IF A LEFT 
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN IT  
C -----  WILL ALSO SERVICE THE LEFT TURN MOVEMENT.                      
C                                                                       
         ELSEIF (IDIAGR .EQ. 1 .AND. XBUF(21) .GT. 0) THEN              
            WDIAG = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                       
            IF (IDIAGL .NE. 1) THEN                                     
               IF (XBUF(19) .GT. 0) THEN                                
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                 
                  IF (ITHRUL .NE. 1 .AND. XBUF(18) .GT. 0 .AND.         
     1                        ILN - I9LANE .LT. 3) THEN                 
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(I9LANE-1))                  
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT WAS       
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN         
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  OTHERWISE, THE LANE TO THE RIGHT OF I9LANE SERVICES RIGHT      
C -----  TRAFFIC OR NO TRAFFIC (CLOSED OR DOES NOT EXIST) THEN I9LANE   
C -----  WILL SERVICE RIGHT TRAFFIC IF A RIGHT EXISTS AND I9LANE IS     
C -----  WITHIN 3 LANES FROM THE CURB.  IF THE LANE TO THE LEFT OF      
C -----  I9LANE DOES NOT SERVICE RIGHT TRAFFIC THEN IF RIGHT DIAGONAL   
C -----  TRAFFIC WAS SPECIFIED THEN I9LANE WILL SERVICE THE RIGHT       
C -----  DIAGONAL TRAFFIC. IF THE LANE TO THE LEFT OF I9LANE DOES NOT   
C -----  SERVICE RIGHT DIAGONAL TRAFFIC THEN IF A THROUGH MOVEMENT WAS  
C -----  SPECIFIED THEN I9LANE WILL SERVICE THE THROUGH MOVEMENT.  IF   
C -----  THE LANE TO LEFT OF I9LANE DOES NOT SERVICE THE THROUGH        
C -----  MOVEMENT THEN IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3   
C -----  LANES FROM THE MEDIAN IT WILL ALSO SERVICE THE LEFT TURN       
C -----  MOVEMENT.                                                      
C                                                                       
         ELSE                                                           
            IF (XBUF(20) .GT. 0 .AND. I9LANE .LE. 3) THEN               
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 2**((4*(I9LANE-1))+2)                    
            ENDIF                                                       
            IF (IRGHTL .NE. 1) THEN                                     
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1) THEN                               
                     IF (XBUF(19) .GT. 0) THEN                          
                        WTHRU = .TRUE.                                  
                        JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)           
                        IF (ITHRUL .NE. 1) THEN                         
                           IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE       
     1                                                     .LT. 3) THEN 
                              WLEFT = .TRUE.                            
                              JCHAN = JCHAN + 2**(4*(I9LANE-1))         
                           ENDIF                                        
                        ENDIF                                           
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT WAS       
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN         
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
                     ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE         
     1                                                     .LT. 3) THEN 
                        WLEFT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4*(I9LANE-1))               
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO RIGHT DIAGONAL MOVEMENT SO IF A THROUGH 
C -----  WAS SPECIFIED THEN I9LANE WILL SERVICE THE THROUGH MOVEMENT.   
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE THE THROUGH 
C -----  MOVEMENT THEN IF A LEFT DIAGONAL WAS SPECIFIED I9LANE WILL     
C -----  SERVICE THE LEFT DIAGONAL.  IF THE LANE TO THE LEFT DOES NOT   
C -----  SERVICE THE LEFT DIAGONAL THEN IF A LEFT WAS SPECIFIED AND     
C -----  I9LANE IS WITHIN 3 LANES FROM THE MEDIAN I9LANE WILL SERVICE   
C -----  THE LEFT TURN MOVEMENT.                                        
C                                                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                 
                  IF (ITHRUL .NE. 1) THEN                               
                     IF (XBUF(21) .LT. 0) THEN                          
                        WDIAG = .TRUE.                                  
                        JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)           
                        IF (IDIAGL .NE. 1) THEN                         
                           IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE       
     1                                                     .LT. 3) THEN 
                              WLEFT = .TRUE.                            
                              JCHAN = JCHAN + 2**(4*(I9LANE-1))         
                           ENDIF                                        
                        ENDIF                                           
C                                                                       
C -----  OTHERWISE, THERE IS NO LEFT DIAGONAL MOVEMENT SO IF A LEFT WAS 
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN I9LANE  
C -----  WILL SERVICE THE LEFT TURN MOVEMENT.                           
C                                                                       
                     ELSE                                               
                        IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3)  
     1                                                             THEN 
                           WLEFT = .TRUE.                               
                           JCHAN = JCHAN + 2**(4*(I9LANE-1))            
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT DIAGONAL  
C -----  WAS SPECIFIED THEN I9LANE WILL SERVICE THE DIAGONAL MOVEMENT.  
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE THE DIAGONAL
C -----  MOVEMENT THEN IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3   
C -----  LANES FROM THE MEDIAN I9LANE WILL SERVICE THE LEFT TURN        
C -----  MOVEMENT.                                                      
C                                                                       
               ELSEIF (XBUF(21) .LT. 0) THEN                            
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1) THEN                               
                     IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN
                        WLEFT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4*(I9LANE-1))               
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3      
C -----  LANES FROM THE MEDIAN I9LANE WILL SERVICE THE LEFT TURN        
C -----  MOVEMENT.                                                      
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C -----  CHECK THAT AT LEAST ONE LANE WILL SERVICE ALL MOVEMENTS        
C -----  DEFINED BY RECEIVERS                                           
C                                                                       
      IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0 .AND. (.NOT. WLEFT))     
     1   CALL ERGEN ('CKFN11', 2089, IUP, IDW, 0, 0, 2)                 
      IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0 .AND. (.NOT. WRGHT))     
     1   CALL ERGEN ('CKFN11', 2094, IUP, IDW, 0, 0, 2)                 
      IF (XBUF(21) .NE. 0 .AND. (.NOT. WDIAG)) CALL ERGEN ('CKFN11',    
     1   2091, IUP, IDW, 0, 0, 2)                                       
C                                                                       
C -----  COMPUTE NUMBER OF LANES WHICH SERVICE THE THROUGH MOVEMENT.    
C                                                                       
      ITHRU = 0                                                         
      IF (WTHRU) THEN                                                   
         J = 1                                                          
  105    CONTINUE                                                       
         J = J + 1                                                      
         IF (MOD (JCHAN/2**((J-1)*4+1), 2) .EQ. 1) ITHRU = ITHRU + 1    
         IF (J .LT. ILN)                                     GO TO 105  
      ENDIF                                                             
C                                                                       
C -----  IF A SHARED LANE WAS SPECIFIED THEN IF THE LANE ADJACENT       
C -----  TO THE SHARED LANE SERVICES THE DIAGONAL MOVEMENT CALL         
C -----  ERROR MESSAGE GENERATOR.  OTHERWISE, SHARED LANE WILL ALSO     
C -----  SERVICE THROUGH MOVEMENT.                                      
C                                                                       
      IF (XBUF(19) .NE. 0.AND.(.NOT. WTHRU .OR. IBUSCP .EQ. ITHRU)) THEN
         IF (WSHARE) THEN                                               
            IDIAG = 0                                                   
            IF (XBUF(21) .GT. 0) THEN                                   
               J = ISHLN                                                
  110          CONTINUE                                                 
               J = J + 1                                                
               ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                  
               IF (ICODE .EQ. 0 .AND. J .LT. 7) THEN                    
                                                             GO TO 110  
               ELSEIF (ICODE .NE. 0) THEN                               
                  IDIAG = MOD(ICODE / 8, 2)                             
               ENDIF                                                    
            ELSE                                                        
               J = ISHLN                                                
  120          CONTINUE                                                 
               J = J - 1                                                
               ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                  
               IF (ICODE .EQ. 0 .AND. J .GT. 1) THEN                    
                                                             GO TO 120  
               ELSEIF (ICODE .NE. 0) THEN                               
                  IDIAG = MOD(ICODE / 8, 2)                             
               ENDIF                                                    
            ENDIF                                                       
            IF (IDIAG .EQ. 0) THEN                                      
               JCHAN = JCHAN + 2**((4*(ISHLN-1))+1)                     
            ELSE                                                        
               IF (.NOT. WTHRU) CALL ERGEN ('CKFN11',2092,IUP,IDW,0,0,2)
            ENDIF                                                       
         ELSE                                                           
            IF (.NOT. WTHRU) CALL ERGEN ('CKFN11',2092,IUP,IDW, 0, 0, 2)
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
      IF (ILN .EQ. 7)                                        GO TO 150  
      J = ILN + 11                                                      
C                                                                       
C -----  CHECK WHETHER A CHANNELIZATION CODE WAS SPECIFIED FOR A        
C -----  NON-EXISTING LANE                                              
C                                                                       
  130 CONTINUE                                                          
         DO 140 I = J, 17                                               
            IF (XBUF(I) .NE. 0)                                         
     1     CALL ERGEN ('CKFN11', 2084, XBUF(I), I-10, IUP,              
     2                 IDW, 4)                                          
  140    CONTINUE                                                       
  150 CONTINUE                                                          
C                                                                       
C -----  CHECK THAT BOTH LANES FOR ALIGNMENT WERE SPECIFIED OR          
C -----  THAT BOTH ARE ZERO (A REQUEST FOR THE DEFAULT)                 
C                                                                       
      IF (XBUF(28) * XBUF(29) .EQ. 0  .AND.                             
     1    XBUF(28) + XBUF(29) .NE. 0)                                   
     2    CALL ERGEN ('CKFN11', 4049, IUP, IDW, XBUF(28),               
     3                              XBUF(29), 4)                        
C                                                                       
C -----  ALSO CHECK THAT ALIGNMENT LANE FOR THIS LINK IS A DEFINED LANE 
C -----  (RECEIVING LANE WILL BE CHECKED IN ROUTINE GLNKFN)             
C                                                                       
      IF (XBUF(28) .GT. XBUF(6))                                        
     1    CALL ERGEN ('CKFN11', 4052, IUP, IDW, XBUF(28),               
     2                 XBUF(6), 4)                                      
C                                                                       
C -----  CHECK THAT DIVERSION MOVEMENT WAS NOT SPECIFIED                
C                                                                       
      IF (XBUF(30) .NE. 0  .OR.  XBUF(31) .NE. 0)                       
     1     CALL ERGEN ('CKFN11', 4056, IUP, IDW, 0, 0, 2)               
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN21 (WEX)                                           
C                                                                       
C                                                                       
C --- CODED    3-15-78 BY M. SINGER                                     
C --- REVISED  8-15-79 BY M. MASSUCCI (FOR NETSIM)                      
C --- REVISED  6-15-92 BY J. WERK TO REMOVE CLEARING OF LANEGD ARRAY    
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 21                 
C ---         - MODULE 2261.3.1.1                                       
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 21                                  
C                                                                       
C --- ARGUMENTS - WEX = ARRAY OF LINK EXISTENCE FLAGS, TO CALLING       
C ---                   ROUTINE                                         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     AFTER UNPACKING THE INPUT CARD BUFFER THIS MODULE LOOPS OVER BOTH 
C     LINKS ON THE CARD CALLING A MODULE TO CHECK THE INDIVIDUAL ITEMS  
C     AND THEN CHECKS FOR CONSISTENCY.  IT ALSO RETURNS A FLAG ARRAY    
C     INDICATING WHETHER OR NOT EACH LINK EXISTS                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN21 - MODULE 2261.3.1                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN21 - MODULE 2261.3111                          
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - RECEIVING LINK FOR RIGHT TURNS      
C     DIAGNL  LINK SPECIFIC ARRAY - RECEIVING LINK FOR DIAGONAL TURNS   
C     I       DO INDEX                                                  
C     II      POINTER TO XBUF                                           
C     IL      LINK NUMBER                                               
C     IM      DO INDEX FOR TURN MOVEMENTS                               
C     ISUB    POINTER TO XBUF                                           
C     ISUM    COUNTER FOR TURN PERCENTAGES                              
C     J       UNPACKING SCALAR                                          
C     JJ      POINTER TO XBUF                                           
C     JL      DO INDEX FOR LINKS ON CARD                                
C     K       UNPACKING SCALAR                                          
C     LANEGD  LINK SPECIFIC ARRAY - CODE (0,1) IN BIT 15 IF TYPE 21 CARD
C                                   (WASN'T, WAS) INPUT                 
C     LEFT    LINK SPECIFIC ARRAY - RECEIVING LINK FOR LEFT TURN        
C     THRU    LINK SPECIFIC ARRAY - RECEIVING LINK FOR THROUGH MOVEMENT 
C     TYPERN  (1,2,3) IF (SIM,TA,BOTH) DESIRED (-FOR DIAGNOSTICS ONLY)  
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION WEX(2)                                                  
C                                                                       
C -----  UNPACK THE CONTENTS OF THE INPUT CARD BUFFER AND STORE THE     
C -----  SEPERATE DATA ITEMS BACK INTO THE BUFFER                       
C                                                                       
      XBUF(23) = XBUF(20)                                               
      XBUF(22) = XBUF(18)                                               
      J = XBUF(17)                                                      
      II = 22                                                           
         DO 10 I = 1, 4                                                 
            II = II - 1                                                 
            K = J / 10                                                  
            XBUF(II) = J - 10 * K                                       
            J = K                                                       
   10    CONTINUE                                                       
         DO 20 I = 1, 6                                                 
            JJ = II - I                                                 
            XBUF(JJ) = XBUF(JJ-1)                                       
   20    CONTINUE                                                       
      XBUF(11) = XBUF(8)                                                
      J = XBUF(7)                                                       
      II = 11                                                           
         DO 30 I = 1, 4                                                 
            II = II - 1                                                 
            K = J / 10                                                  
            XBUF(II) = J - 10 * K                                       
            J = K                                                       
   30    CONTINUE                                                       
C                                                                       
C -----  LOOP OVER BOTH LINKS ON CARD AND SET FLAG IF LINK EXISTS       
C                                                                       
         DO 90 JL = 1, 2                                                
            WEX(JL) = .FALSE.                                           
            II = 11 * JL - 10                                           
            IF (XBUF(II) .EQ. 0)                             GO TO 80   
            JJ = II + 1                                                 
C                                                                       
C -----  CHECK INDIVIDUAL ITEMS FOR LINK THEN GET LINK NUMBER           
C -----  OUTPUT ERROR MESSAGE AND TRA IF LINK DOES NOT EXIST            
C                                                                       
            CALL TBFN21(JL)                                             
            CALL NLKNUM(IL, XBUF(II), XBUF(JJ))                         
            IF (IL .EQ. 0) CALL ERGEN ('CKFN21', 2523, XBUF(II),        
     1        XBUF(JJ), 0, 0, 2)                                        
            IF (IL .EQ. 0)                                   GO TO 60   
C                                                                       
C -----  CHECK FOR DUPLICATE TYPE 21 CARD. A 1 WILL BE PACKED IN THE    
C -----  15TH BIT OF LANEGD IF A 21 CARD HAS ALREADY BEEN INPUT (DURING 
C -----  THIS TP)                                                       
C                                                                       
            IF (LANEGD(IL) .GE. 2**14) CALL ERGEN ('CKFN21', 2501,      
     1          XBUF(II), XBUF(JJ), 21, 0, 3)                           
C                                                                       
C -----  LOOP OVER TURN MOVEMENTS, FOR NON ZERO MOVEMENTS CHECK IF      
C -----  RECEIVING LINK EXISTS AND MOVEMENT NOT PROHIBITED              
C                                                                       
            WEX(JL)  = .TRUE.                                           
            ISUM = 0                                                    
            ISUB = 11 * JL - 9                                          
               DO 50 IM = 1, 4                                          
                  ISUB = ISUB + 1                                       
C                                                                       
C -----  TRA IF NO TURN PERCENT INPUT FOR THIS MOVEMENT                 
C                                                                       
                  IF (XBUF(ISUB) .EQ. 0)                     GO TO 40   
C                                                                       
C -----  SUM PERCENTS.  OUTPUT ERROR MESSAGE IF PERCENT INPUT FOR       
C -----  NON-EXISTING RECEIVER                                          
C                                                                       
                  ISUM = ISUM + XBUF (ISUB)                             
                  IF (IM .EQ. 1 .AND. LEFT(IL) .EQ. 0) CALL ERGEN       
     1             ('CKFN21', 2521, XBUF(II), XBUF(JJ), IM, 0, 3)       
                  IF (IM .EQ. 2 .AND. THRU(IL) .EQ. 0 .AND.             
     1                XBUF(JJ) .LT. 7000) CALL ERGEN                    
     2             ('CKFN21', 2521, XBUF(II), XBUF(JJ), IM, 0, 3)       
                  IF (IM .EQ. 3 .AND. ARIGHT(IL) .EQ. 0) CALL ERGEN     
     1             ('CKFN21', 2521, XBUF(II), XBUF(JJ), IM, 0, 3)       
                  IF (IM .EQ. 4 .AND. DIAGNL(IL) .EQ. 0) CALL ERGEN     
     1             ('CKFN21', 2521, XBUF(II), XBUF(JJ), IM, 0, 3)       
                  IF (XBUF(ISUB+4) .NE. 0) CALL ERGEN ('CKFN21',        
     1               2522, XBUF(ISUB), XBUF(II), XBUF(JJ), IM, 4)       
   40             CONTINUE                                              
   50          CONTINUE                                                 
C                                                                       
C -----  OUTPUT MESSAGE IF THIS IS A SIMULATION RUN (NOT T. A.) AND     
C -----  NO TURN PERCENTS SPECIFIED                                     
C                                                                       
            IF (ISUM .EQ. 0  .AND.  (TYPERN .EQ. 1  .OR.                
     1          TYPERN .EQ. -1)) CALL ERGEN ('CKFN21', 2536,            
     2          XBUF(II), XBUF(JJ), 0, 0, 2)                            
C                                                                       
C -----  OUTPUT MESSAGE IF BLOCKAGE FACTOR INPUT. BLOCKAGE FACTOR       
C -----  SHOULD NOT BE INPUT FOR NETSIM                                 
C                                                                       
            IF (XBUF(ISUB+5) .GT. 0)                                    
     1          CALL ERGEN ('CKFN21', 561, XBUF(II),                    
     2                      XBUF(JJ), XBUF(ISUB+5), 0, 3)               
   60       CONTINUE                                                    
   80       CONTINUE                                                    
   90    CONTINUE                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN22 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    8-30-85 BY K. SHERIDAN                                   
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 22                 
C ---         - MODULE 2261.3.3.1                                       
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 22                                  
C                                                                       
C --- ARGUMENTS - WERR   = FLAG, SET TRUE IF DUPLICATE TYPE 22 CARD     
C ---                      ENCOUNTERED, SENT TO CALLING ROUTINE         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE FIRST CALLS A ROUTINE TO CHECK THE INDIVIDUAL         
C     ITEMS ON THE CARD, THEN CHECKS FOR CONSISTENCY.                   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN22 - MODULE 2261.3.3                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    NLKNUM - MODULE 2261.3112                          
C                    TBFN22 - MODULE 2261.3311                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - RECEIVING LINK FOR RIGHT TURNS      
C     CTVECT  LINK SPECIFIC ARRAY - POINTERS TO CTDATA ARRAY FOR        
C             CONDITIONAL TURN MOVEMENT DATA                            
C     DIAGNL  LINK SPECIFIC ARRAY - RECEIVING LINK FOR DIAG. TURNS      
C     I       INDEX TO XBUF ARRAY                                       
C     IL      LINK NUMBER                                               
C     K       COUNTER OVER UPSTREAM ENTERING MOVEMENTS                  
C     LEFT    LINK SPECIFIC ARRAY - RECEIVING LINK FOR LEFT  TURNS      
C     THRU    LINK SPECIFIC ARRAY - RECEIVING LINK FOR THRU MOVEMENT    
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  CALL ROUTINE TO CHECK DATA ITEM BOUNDS, THEN GET LINK          
C -----  NUMBER.  OUTPUT ERROR MESSAGE IF LINK DOES NOT EXIST, ELSE     
C -----  PERFORM DATA CHECKS.                                           
C                                                                       
      WERR = .FALSE.                                                    
      CALL TBFN22                                                       
      CALL NLKNUM (IL, XBUF(1), XBUF(2))                                
      IF (IL .EQ. 0) THEN                                               
         CALL ERGEN ('CKFN22', 2530, XBUF(1), XBUF(2), 0, 0, 2)         
      ELSE                                                              
C                                                                       
C -----  CHECK FOR DUPLICATE TYPE 22 CARD                               
C                                                                       
         IF (CTVECT(IL) .LT. 0) THEN                                    
            CALL ERGEN ('CKFN22', 2501, XBUF(1), XBUF(2), 22, 0, 3)     
            WERR = .TRUE.                                               
         ENDIF                                                          
C                                                                       
C -----  LOOP OVER SET OF FOUR DOWNSTREAM TURN MOVEMENTS (FOR EACH      
C -----  UPSTREAM ENTERING TURN MOVEMENT).  FOR NON-ZERO MOVEMENTS      
C -----  CHECK IF RECEIVING LINK EXISTS                                 
C                                                                       
         I = 0                                                          
         K = 0                                                          
   10    CONTINUE                                                       
         K = K + 1                                                      
         IF (XBUF(I+3) .GT. 0  .AND.  LEFT(IL) .EQ. 0)                  
     1       CALL ERGEN ('CKFN22', 5196, XBUF(1), XBUF(2), 1, K, 4)     
         IF (XBUF(I+4) .GT. 0  .AND.  THRU(IL) .EQ. 0)                  
     1       CALL ERGEN ('CKFN22', 5196, XBUF(1), XBUF(2), 2, K, 4)     
         IF (XBUF(I+5) .GT. 0  .AND.  ARIGHT(IL) .EQ. 0)                
     1       CALL ERGEN ('CKFN22', 5196, XBUF(1), XBUF(2), 3, K, 4)     
         IF (XBUF(I+6) .GT. 0  .AND.  DIAGNL(IL) .EQ. 0)                
     1       CALL ERGEN ('CKFN22', 5196, XBUF(1), XBUF(2), 4, K, 4)     
         I = I + 4                                                      
         IF (K .LT. 4)                                       GO TO 10   
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN35 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    3-15-78 BY M. YEDLIN                                     
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 35 -               
C ---         MODULE 2261.5111                                          
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 35.                                 
C                                                                       
C --- ARGUEMNTS - WERR = FLAG (SET, RESET) IF SUBJECT NODE OR ONE OF    
C ---                    THE NODES DEFINING APPROACH LINKS (IS NOT, IS) 
C ---                    VALID, TO CALLING ROUTINE                      
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CALLS SUBORDINATE ROUTINES TO CHECK THE DATA AND THE  
C     VALIDITY OF THE NODE LISTED ON THE TYPE 35 CARD.                  
C     ALL APPROACHES ARE EXAMINED REPLACING APPROACH NODE               
C     NUMBER WITH THE LINK NUMBER IN THE BUFFER.                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN35 - MODULE 2261.5.1.1                         
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN35 - MODULE 2261.5111.1                        
C                    CKNODN - MODULE 2261.5111.2                        
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     GLOBND  PACKED SUBNETWORK NUMBER AND SUBNETWORK SPECIFIC NODE NO. 
C     IA      LOCATION OF AN APPROACH NUMBER IN XBUF                    
C     ILINK   LINK NUMBER OF APPROACH TO NODE XBUF(1)                   
C     IN      USERS NODE NUMBER IDENTIFYING INTERSECTION                
C     JN      USER SPECIFIED APPROACH NODE NUMBER                       
C     KN      USERS NODE NUMBER CORRESPONDING TO SUBNETWORK NODE, IN    
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     WERR    FLAG IS (SET, RESET) IF NODE (IS NOT, IS) VALID           
C     WEXIST  FLAG IS (SET, RESET) IF NODE (DOES, DOES NOT) EXIST       
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  RESET FLAG, CALL MODULES TO CHECK EACH DATA ITEM AND VALIDITY  
C -----  OF NODE                                                        
C                                                                       
      CALL TBFN35                                                       
      IN = XBUF(1)                                                      
      CALL CKNODN(IN, WEXIST)                                           
C                                                                       
C -----  WHEN NODE EXISTS, LOOP OVER APPROACHES, STORE LINK             
C -----  NUMBERS IN BUFFER, REPLACING UPSTREAM NODE NUMBERS             
C                                                                       
      WERR = .TRUE.                                                     
      IF ( .NOT. WEXIST)                                     GO TO 90   
      WERR = .FALSE.                                                    
         DO 40 IA = 3, 7                                                
            JN = XBUF(IA)                                               
C                                                                       
C -----  TEST FOR OMISSIONS IN INPUT SPECIFICATION                      
C                                                                       
            IF (JN .LE. 0 .AND. XBUF(IA+1) .NE. 0 .AND. IA .NE. 7)      
     1         WERR = .TRUE.                                            
            IF (JN .LE. 0)                                   GO TO 10   
C                                                                       
C -----  GET LINK NUMBER FOR THIS APPROACH AND STORE IN PLACE OF        
C -----  NODE NUMBER                                                    
C                                                                       
            CALL NLKNUM(ILINK, JN, IN)                                  
            XBUF(IA) = ILINK                                            
            IF (ILINK .EQ. 0) CALL ERGEN ('CKFN35', 2600,               
     1          JN, XBUF(1), 0, 0, 2)                                   
            IF (ILINK .EQ. 0) WERR = .TRUE.                             
   10       CONTINUE                                                    
   40    CONTINUE                                                       
      KN = GLOBND(IN) / 16                                              
C                                                                       
C -----  CHECK THAT SPECIFICATION OF APPROACH LINKS IS COMPLETE         
C                                                                       
         DO 80 ILINK = 1, TTLNK                                         
            IF (DWNOD(ILINK) .NE. KN)                        GO TO 70   
C                                                                       
C -----  TRA IF LINK, ILINK WAS SPECIFIED ON THIS CARD                  
C                                                                       
               DO 50 IA = 3, 7                                          
                  IF (XBUF(IA) .EQ. ILINK)                   GO TO 60   
   50          CONTINUE                                                 
            CALL ERGEN ('CKFN35', 2625, IN, 0, 0, 0, 1)                 
   60       CONTINUE                                                    
   70       CONTINUE                                                    
   80    CONTINUE                                                       
   90 CONTINUE                                                          
C                                                                       
C -----  A SIGN CONTROL IMPLIES NO OFFSET INPUT                         
C                                                                       
      IF (XBUF(8) .EQ. 0 .AND. XBUF(2) .GT. 0) CALL ERGEN               
     1   ('CKFN35', 260, IN, 0, 0, 0, 1)                                
C                                                                       
C -----  A SINGLE INTERVAL DURATION CANNOT BE SPECIFIED FOR ANY NODE    
C                                                                       
      IF (XBUF(8) .NE. 0  .AND.  XBUF(9) .EQ. 0)                        
     1    CALL ERGEN ('CKFN35', 2629, IN, 0, 0, 0, 1)                   
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN36 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    3-22-78 BY M. YEDLIN                                     
C --- REVISED  9-05-79 BY B. ANDREWS (FOR NETSIM)                       
C --- REVISED 10-15-87 BY K. SHERIDAN TO CORRECT ERROR MESSAGE 2609     
C --- REVISED 12-13-91 BY J. WERK TO INCLUDE ENTRY 64 - CODE FOR A      
C ---                                MICRONODE                          
C --- REVISED  4-01-92 BY B. ANDREWS TO REMOVE UNPACKING OF NODE        
C ---                  COORDINATE DATA WHEN IT WAS MOVED TO NEW TYPE    
C ---                  195 CARD                                         
C --- REVISED  6-23-94 BY S. WALKER TO RENUMBER ERROR 2620 TO 2634      
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 36 -               
C ---         MODULE 2261.5121                                          
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 36.                                 
C                                                                       
C --- ARGUMENTS - WERR - ERROR FLAG (SET, RESET) IF NODE (IS NOT, IS)   
C ---                    IN NODE MAP, SENT TO CALLING ROUTINE           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     AFTER UNPACKING EACH DATA ITEM FROM XBUF AND STORING THEM BACK    
C     IN XBUF, EACH DATA ITEM IS CHECKED. IF NODE CONTROLLED BY SIGNS   
C     ALL APPROACHES ARE CHECKED FOR O CONTROL CODES. IF FIXED TIME     
C     CONTROL, APPROACHES ARE CHECKED TO INSURE HIGHEST INTERVAL NUMBER 
C     HAS A NON-ZERO DURATION. CHECKS ARE MADE TO INSURE A CONTROL      
C     CODE FOR EACH APPROACH, AND THERE ARE ENOUGH INTERVALS            
C     SPECIFIED FOR EACH APPROACH. THE FINAL TEST CHECKS FOR A          
C     REDUNDANT CARD.                                                   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN36 - MODULE 2261.5.1.2                         
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    CKNODN - MODULE 2261.5111.2                        
C                    TBFN36 - MODULE 2261.5121.1                        
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     FZPNTR  NODE SPECIFIC ARRAY - POINTER TO DURINT ARRAY             
C     GLOBND  PACKED SUBNETWORK NUMBER AND SUBNETWORK SPECIFIC NODE NO. 
C     I       INDEX TO UNIFORM 4 DIGIT FIELD IN XBUF                    
C     IA      APPROACH NUMBER                                           
C     ICOD    VALUE OF SIGNAL CONTROL CODE                              
C     IJ      INDEX TO SIGI FOR NODE IN AND APPROACH IA                 
C     IK      INDEX TO SIGI FOR NODE IN                                 
C     IL      LINK NUMBER OF APPROACH 1                                 
C     ILAST   NUMBER OF INTERVALS SPECIFIED FOR APPROACH IA             
C     ILMAX   MAXIMUM NUMBER OF INTERVALS SPECIFIED FOR ANY APPROACH    
C     IMAXAP  MAXIMUM NUMBER OF APPROACHES FOR WHICH SIGNAL CODES ARE   
C             SPECIFIED                                                 
C     IN      SUBNETWORK NODE NUMBER CORRESPONDING TO NODE KN           
C     INT     INTERVAL NUMBER                                           
C     INTNUM  NUMBER OF INTERVALS (DEFINED ON TYPE 35 CARD)             
C     J       INDEX TO XBUF WHEN XBUF CONTAINS INDIVIDUAL DATA ITEMS    
C     JA      COUNTER OF APPROACHES TO NODE IN                          
C     JNT     LOOPING COUNTER USED TO SCAN INTERVALS IN REVERSE ORDER   
C     K       LOOPING COUNTER FOR LOADING DATA ITEMS SEPARATELY IN XBUF 
C     KN      USER SPECIFIED NODE NUMBER                                
C     NACT    NODE SPECIFIC ARRAY - TYPE OF CONTROL                     
C     SIGI    NODE SPECIFIC ARRAY - LINK ID NUMBER (APPROACH SPECIFIC)  
C     WEXIST  NODE EXISTANCE FLAG (TRUE IF NODE EXISTS)                 
C     WGREEN  FLAG (T,F) IF (ANY, NO) APPROACH HAS A GREEN INDICATION   
C     XBUF    INPUT CARD BUFFER                                         
C     XINT1   LINK SPECIFIC ARRAY - DECILE (USER) SIGNAL CONTROL CODES  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION ILAST(5)                                                
C                                                                       
C -----  STORE EACH OF THE 64 DATA ITEMS IN ITS OWN XBUF LOCATION       
C                                                                       
      KN = XBUF(1)                                                      
      XBUF(64) = XBUF(20) / 1000                                        
      XBUF(63) = MOD (XBUF(18), 100) * 1000 + XBUF(19) / 10             
      XBUF(62) = MOD (XBUF(17), 1000) * 100 + XBUF(18) / 100            
      XBUF(61) = XBUF(17) / 1000                                        
      I = 17                                                            
      J = 61                                                            
   10 CONTINUE                                                          
      I = I - 1                                                         
      IJ = XBUF(I)                                                      
         DO 20 K = 1, 3                                                 
            J = J - 1                                                   
            IK = IJ / 10                                                
            XBUF(J) = IJ - IK * 10                                      
            IJ = IK                                                     
   20    CONTINUE                                                       
      J = J - 1                                                         
      XBUF(J) = IK                                                      
      IF (I .GT. 2)                                          GO TO 10   
      XBUF(J) = KN                                                      
C                                                                       
C -----  SET ERROR FLAG, CHECK EACH DATA ITEM, CHECK IF NODE EXISTS.    
C                                                                       
      WERR = .TRUE.                                                     
      CALL TBFN36                                                       
      CALL CKNODN(XBUF(1), WEXIST)                                      
C                                                                       
C -----  GET SUBNETWORK SPECIFIC NODE NUMBER IF NODE EXISTS IN NODE MAP 
C                                                                       
      IF ( .NOT. WEXIST)                                     GO TO 180  
      WERR = .FALSE.                                                    
      KN = XBUF(1)                                                      
      IN = GLOBND(KN) / 16                                              
      IK = 5 * (IN - 1)                                                 
C                                                                       
C -----  TRA IF NO CARD TYPE 35 INPUT FOR NODE, IN                      
C                                                                       
      IF (NACT(IN) .EQ. -9) CALL ERGEN ('CKFN36', 2623, KN, 0, 0,       
     1        0, 1)                                                     
      IF (NACT(IN) .EQ. -9)                                  GO TO 170  
C                                                                       
C -----  CALCULATE NUMBER OF APPROACHES, JA AND CLEAR ILAST ARRAY       
C                                                                       
      IJ = IK                                                           
      JA = 0                                                            
         DO 30 IA = 1, 5                                                
            IJ = IJ + 1                                                 
            IF (SIGI(IJ) .GT. 0) JA = JA + 1                            
            ILAST(IA) = 0                                               
   30    CONTINUE                                                       
      IMAXAP = JA                                                       
C                                                                       
C -----  TRA IF NODE, IN, HAS A FIXED-TIME CONTROLLER ELSE SIGN CONTROL 
C                                                                       
      IF (NACT(IN) .EQ. 0)                                   GO TO 70   
C                                                                       
C -----  CHECK WHETHER MORE THAN ONE SIGNAL INTERVAL SPECIFIED          
C -----  FOR SIGN CONTROL                                               
C                                                                       
         DO 40 J = 7, 16                                                
            IF (XBUF(J) .GT. 0) CALL ERGEN ('CKFN36', 2611,             
     1         KN, J, 0, 0, 2)                                          
   40    CONTINUE                                                       
C                                                                       
C -----  CHECK THAT VALID CODES WERE SPECIFIED FOR ALL                  
C -----  APPROACHES. TRA IF NO APPROACHES                               
C                                                                       
      IF (JA .EQ. 0)                                         GO TO 60   
         DO 50 J = 1, JA                                                
            ICOD = XBUF(J+1)                                            
            IF (ICOD .GT. 1 .AND. ICOD .NE. 5) CALL ERGEN               
     1         ('CKFN36', 2624, ICOD, KN, J+1, 0, 3)                    
   50    CONTINUE                                                       
C                                                                       
C -----  TRA IF MAXIMUM NUMBER OF ALLOWABLE APPROACHES (5) WERE         
C -----  IDENTIFIED ON CARD TYPE 35. ELSE, LOOP TO DETERMINE IF SIGNAL  
C -----  CODES ARE SPECIFIED FOR MORE APPROACHES THAN WERE IDENTIFIED   
C -----  ON CARD TYPE 35.                                               
C                                                                       
      IF (JA .EQ. 5)                                         GO TO 57   
      IA = JA                                                           
   55 CONTINUE                                                          
      IA = IA + 1                                                       
      IF (XBUF(IA+1) .GT. 0) IMAXAP = MAX0 (IMAXAP, IA)                 
      IF (IA .LT. 5)                                         GO TO 55   
   57 CONTINUE                                                          
   60 CONTINUE                                                          
                                                             GO TO 160  
C                                                                       
C -----  CONTROL IS FIXED TIME, CHECK APPROACHES, TRA IF NO APPROACHES  
C                                                                       
   70 CONTINUE                                                          
      IF (JA .EQ. 0) CALL ERGEN ('CKFN36', 2615, KN, 0, 0, 0, 1)        
      IF (JA .EQ. 0)                                         GO TO 150  
C                                                                       
C -----  LOOP OVER INTERVALS AND APPROACHES AND LOCATE HIGHEST NON-ZERO 
C -----  INTERVAL NUMBER                                                
C                                                                       
      ILMAX = 0                                                         
      INTNUM = MOD (FZPNTR(IN) / 2**11, 2**4)                           
         DO 130 JNT = 1, 12                                             
            INT = 13 - JNT                                              
            J = (INT * 5) - 4                                           
            WGREEN = .FALSE.                                            
               DO 90 IA = 1, JA                                         
                  J = J + 1                                             
                  IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 2)WGREEN=.TRUE. 
                  IF (XBUF(J) .LE. 0)                        GO TO 80   
                  IF (ILAST(IA) .EQ. 0) ILAST(IA) = INT                 
C                                                                       
C -----  OUTPUT MESSAGE IF SIGNAL CODE WAS INPUT FOR AN INTERVAL        
C -----  THAT WAS NOT ASSIGNED A DURATION                               
C                                                                       
                  IF (INT .GT. INTNUM) CALL ERGEN ('CKFN36',            
     1                 2612, INT, KN, 0, 0, 2)                          
                  IF (ILMAX .EQ. 0) ILMAX = INT                         
   80             CONTINUE                                              
   90          CONTINUE                                                 
C                                                                       
C -----  TRA IF MAXIMUM NUMBER OF ALLOWABLE APPROACHES (5) WERE         
C -----  IDENTIFIED ON CARD TYPE 35. ELSE, LOOP TO DETERMINE IF SIGNAL  
C -----  CODES ARE SPECIFIED FOR MORE APPROACHES THAN WERE IDENTIFIED   
C -----  ON CARD TYPE 35.                                               
C                                                                       
            IF (JA .EQ. 5)                                   GO TO 97   
            IA = JA                                                     
   95       CONTINUE                                                    
            IA = IA + 1                                                 
            J = J + 1                                                   
            IF (XBUF(J) .GT. 0) IMAXAP = MAX0 (IMAXAP, IA)              
            IF (IA .LT. 5)                                   GO TO 95   
   97       CONTINUE                                                    
C                                                                       
C-----------------------------------------------------------------------
C                                                                       
C     IF A DURATION WAS SPECIFIED ON CARD TYPE 35 FOR                   
C     INTERVAL INT+1, BUT CONTROL CODES FOR INTERVAL INT+1 WERE ALL     
C     BLANK OR SET TO ZERO, THIS IS EITHER AN ERROR OF OMISSION OR THE  
C     FINAL INTERVAL (INT+1) IS AN ALL AMBER. IF INT+1 IS AN ALL AMBER, 
C     AT LEAST 1 APPROACH SHOULD HAVE A GO INDICATION DURING INTERVAL   
C     INT (I.E. WGREEN = .T.). OTHERWISE AN ERROR HAS OCCURED AND A     
C     MESSAGE IS GENERATED.                                             
C                                                                       
C-----------------------------------------------------------------------
C                                                                       
            IF (ILMAX .LE. INTNUM-1  .AND.  INT .EQ. INTNUM-1           
     1          .AND.  .NOT. WGREEN)                                    
     2          CALL ERGEN ('CKFN36', 2627, INT+1, KN, 0, 0, 2)         
  130    CONTINUE                                                       
C                                                                       
C -----  LOOP OVER APPROACHES AND OUTPUT MESSAGES IF NO SIGNAL CONTROL  
C -----  SPECIFIED OR TOO FEW INTERVALS SPECIFIED                       
C                                                                       
         DO 140 IA = 1, JA                                              
            IF (ILAST(IA) .EQ. 0) CALL ERGEN ('CKFN36', 2613, IA,       
     1         KN, 0, 0, 2)                                             
            IF (ILAST(IA) .LT. (ILMAX - 1)) CALL ERGEN ('CKFN36',       
     1         2614, IA, KN, 0, 0, 2)                                   
  140    CONTINUE                                                       
  150 CONTINUE                                                          
  160 CONTINUE                                                          
C                                                                       
C -----  OUTPUT MESSAGE IF SIGNAL CODES ARE SPECIFIED FOR MORE          
C -----  APPROACHES THAN WERE IDENTIFIED ON CARD TYPE 35.               
C                                                                       
      IF (IMAXAP .GT. JA) CALL ERGEN ('CKFN36', 2609, KN, JA,           
     1                                IMAXAP, 0, 3)                     
C                                                                       
C -----  OUTPUT MESSAGE IF MICRONODE CODE IS GREATER THAN ONE OR LESS   
C -----  THAN ZERO.                                                     
C                                                                       
      IF (XBUF(64) .GT. 1 .OR. XBUF(64) .LT. 0) CALL ERGEN ('CKFN36',   
     1    2634, XBUF(64), KN, 0, 0, 2)                                  
  170 CONTINUE                                                          
C                                                                       
C -----  GET LINK NO. OF APPROACH 1, PRINT MESSAGE IF REDUNDANT 36 CARD 
C                                                                       
      IL = SIGI(IK+1)                                                   
      IF (IL .GT. 0 .AND. XINT1(IL) .GE. 0) CALL ERGEN ('CKFN36',       
     1         2616, KN, 0, 0, 0, 1)                                    
  180 CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN42 (IL, WERR)                                      
C                                                                       
C --- CODED    7-05-79 BY M. MASSUCCI                                   
C --- RECODED 11-10-90 BY H. CHEN FOR NEW INPUT FORMAT                  
C --- REVISED 10-21-91 BY A. KANAAN FOR CORRECT INDEX REFERENCING       
C --- REVISED 10-06-92 BY A. PHLEGAR TO MODIFY CT 42 FORMAT             
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 42 -               
C ---         MODULE 2261.5.3.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 42                             
C                                                                       
C --- ARGUMENTS - IL = LINK NUMBER, TO THE CALLING ROUTINE              
C ---           - WERR = FLAG (.T., .F.) IF AN ERROR (IS NOT, IS)       
C ---                    DETECTED, WHICH PREVENTS STORING DATA,         
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C     WHEN THIS MODULE IS CALLED A TYPE 42 CARD IS IN THE BUFFER.       
C     THIS MODULE UNPACKS THE CONTENTS OF THE CARD BUFFER AND STORES    
C     THEM BACK INTO THE BUFFER. A ROUTINE IS CALLED TO TEST THE        
C     BOUNDS OF DATA ITEMS ON THE CARD. WHEN CONTROL RETURNS TO THIS    
C     ROUTINE, IT CHECKS FOR INCONSISTENCIES AMONG RELATED DATA ITEMS.  
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                    RDFN42 - MODULE 2261.5.3                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                    TBFN42 - MODULE 2261.5311                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C     I        INDEX OF XBUF ENTRY BEING UNPACKED                       
C     IDN      DOWNSTREAM NUMBER                                        
C     IDT      DO LOOP INDEX FOR NUMBER OF DETECTORS                    
C     ILANE    LANE NUMBER                                              
C     ILEFTL   NUMBER OF LANES IN THE LEFT-TURN POCKET FOR THE APPROACH 
C     IMINPL   MINIMUM OF RIGHT AND LEFT TURN POCKET LENGTHS            
C     IRITEL   NUMBER OF LANES IN THE RIGHT-TURN POCKET FOR THE APPROACH
C     IRTEPL   RIGHT-TURN POCKET LENGTH                                 
C     ISTLEN   STREET SEGMENT LENGTH OF THE APPROACH                    
C     ITHRUL   NUMBER OF THROUGH LANES FOR THE APPROACH                 
C     IUP      UPSTREAM NODE NUMBER                                     
C     LANEGD   LINK SPECIFIC ARRAY - NUMBER OF FULL AND POCKET LANES    
C     LEDGE    DISTANCE BETWEEN DET. LEADING EDGE TO DOWNSTREAM STOP-BAR
C     LEFTPL   LEFT-TURN POCKET LENGTH                                  
C     LENTH    APPROACH LENGTH                                          
C     LGLPK    LINK SPECIFIC ARRAY - LENGTH OF LEFT TURN POCKET         
C     LGRPK    LINK SPECIFIC ARRAY - LENGTH OF RITE POCKET              
C     UNITIN   NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT        
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     XLNGTH   LINK SPECIFIC ARRAY - LENGTH OF LINK IN FEET             
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO   
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)           
C---------------------------------------------------------------------- 
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C           CONVERT TO ENGLISH SYSTEM IF NEEDED                         
C                                                                       
      IF (UNITIN .GT. 0) THEN                                           
         XBUF (5) = XBUF (5) * ZCNVRT(4)                                
         XBUF (7) = XBUF (7) * ZCNVRT(4)                                
      ENDIF                                                             
C                                                                       
      CALL TBFN42 (IL, WERR)                                            
      IF (IL.LE.0 .OR. WERR)                                 RETURN     
C                                                                       
C           GET THE NUMBER AND THE LENGTH OF LANES FOR APPROACH         
C                                                                       
      ITHRUL = MOD (LANEGD(IL) / 2**3, 2**3)                            
      ILEFTL = MOD (LANEGD(IL) / 2**8, 2**2)                            
      IRITEL = MOD (LANEGD(IL) / 2**6, 2**2)                            
      LENTH = MOD (XLNGTH(IL), 2**12)                                   
      ISTLEN = LENTH - XLNGTH(IL) / 2**12 * 10                          
      LEFTPL = LGLPK(IL)                                                
      IRTEPL = MOD (LGRPK(IL), 2**10)                                   
C                                                                       
      IUP = XBUF(1)                                                     
      IDN = XBUF(2)                                                     
C                                                                       
C                                                                       
      IF (XBUF(3) .GT. 0  .OR.  XBUF(4) .GT. 0) THEN                    
C                                                                       
C         DETECTOR IS DEFINED. CHECK THAT THE SPECIFIED LANES EXIST.    
C                                                                       
          IF (XBUF(3) .GT. ITHRUL  .AND.                                
     1        XBUF(3) .LT. (8-ILEFTL-IRITEL)) THEN                      
                 WERR = .TRUE.                                          
                 CALL ERGEN ('CKFN42', 2743, IUP, IDN, XBUF(3), 0, 3)   
          ENDIF                                                         
C                                                                       
          IF (XBUF(4) .GT. ITHRUL  .AND.                                
     1        XBUF(4) .LT. (8-ILEFTL-IRITEL)) THEN                      
              WERR = .TRUE.                                             
              CALL ERGEN ('CKFN42', 2743, IUP, IDN, XBUF(4), 0, 3)      
          ENDIF                                                         
C                                                                       
C         ERROR IF THE DISTANCE BETWEEN THE LEADING EDGE OF THE         
C         DETECTOR AND THE DOWNSTREAM STOP-BAR IS LARGER THAN THE       
C         STREET SEGMENT LENGTH OF THE APPROACH                         
C                                                                       
          LEDGE = (XBUF(5) + XBUF(7)) / 10                              
          IF (LEDGE .GT. ISTLEN ) THEN                                  
              WERR = .TRUE.                                             
              CALL ERGEN ('CKFN42', 2744, IUP, IDN, 5, 7, 4)            
          ENDIF                                                         
C                                                                       
C         ERROR IF THE DETECTOR IS SPECIFIED TO BE INSIDE A TURNING     
C         POCKET AND THE DISTANCE BETWEEN THE LEADING EDGE OF THE       
C         DETECTOR AND THE DOWNSTREAM STOP-BAR IS GREATER THAN THE      
C         POCKET LENGTH.                                                
C                                                                       
          DO 10 LANE = 1, 2                                             
              IF (ILEFTL + IRITEL .GT. 0) THEN                          
                  ILANE = XBUF(LANE+2)                                  
                  IMINPL = MIN0 (LEFTPL, IRTEPL)                        
                  IF (IMINPL .EQ. 0) IMINPL = MAX0 (LEFTPL, IRTEPL)     
                  IF (ILANE.EQ.9 .AND. XBUF(5)/10.LE.IMINPL) THEN       
                      IF (LEDGE .GT. IMINPL) THEN                       
                          WERR = .TRUE.                                 
                          CALL ERGEN ('CKFN42',2744,IUP,IDN,5,7,4)      
                      ENDIF                                             
                  ELSEIF (ILANE.GT.ITHRUL .AND.ILANE.LE.(7-ILEFTL)) THEN
                      IF (LEDGE .GT. IRTEPL) THEN                       
                          WERR = .TRUE.                                 
                          CALL ERGEN ('CKFN42',2744,IUP,IDN,5,7,4)      
                      ENDIF                                             
                  ELSEIF (ILEFTL.GT.0 .AND. ILANE.GE.(8-ILEFTL)) THEN   
                      IF (LEDGE .GT. LEFTPL) THEN                       
                          WERR = .TRUE.                                 
                          CALL ERGEN('CKFN42',2744,IUP,IDN,5,7,4)       
                      ENDIF                                             
                  ENDIF                                                 
              ENDIF                                                     
   10     CONTINUE                                                      
      ENDIF                                                             
                                                                        
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN43 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED   10-30-85 BY A. HALATI                                     
C --- REVISED  9-02-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM     
C ---                       AND GLOSSARY, DELETE REFERENCES TO MXCARD   
C ---                       AND IDWN, ADD ARGUMENT WERR IN CALL TO      
C ---                       TBFN43                                      
C --- REVISED  8-23-89 BY J. MEKEMSON TO FIX WRONG NODE INDEX           
C                                                                       
C --- TITLE  -  CHECK DATA ON TYPE 43 CARDS - MODULE 2261.5211          
C                                                                       
C --- FUNCTION   -  THIS MODULE CHECKS FOR INCONSISTENCIES              
C                   AMONG THE DATA ITEMS ON TYPE 43 CARDS.              
C                                                                       
C --- ARGUMENTS  -  WERR = FLAG (.T., .F.) IF AN ERROR (IS NOT, IS)     
C ---                      DETECTED THAT WOULD PREVENT STORING DATA,    
C ---                      TO THE CALLING ROUTINE                       
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C                                                                       
C     THIS MODULE CHECKS FOR INCONSISTENCIES BETWEEN CARD               
C     TYPE 43 DATA ITEMS. IT CALLS SUBORDINATE MODULES TO               
C     TEST VALIDITY OF DATA ITEMS. IF ERRORS IN DATA                    
C     SPECIFICATIONS ARE FOUND ERROR MESSAGES ARE PRINTED               
C     AND THE ERROR FLAG IS SET BEFORE CONTROL IS RETURNED              
C     TO THE CALLING MODULE.                                            
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                                                                       
C                  RDFN43 - MODULE 2261.5.2.1                           
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                                                                       
C                  NLKNUM - MODULE 2261.3112                            
C                  TBFN43 - MODULE 2261.5211.1                          
C                  ERGEN  - MODULE 2.6.1.1                              
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     DWNOD    LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER             
C     GLOBND   GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE    
C     I        DO LOOP INDEX FOR ENTRIES IN XBUF ARRAY                  
C     IDN      DOWNSTREAM NODE NUMBER OF THE LINK SERVING ACTUATED NODE 
C     ILINK    LINK NUMBER OF THE USER SPECIFIED LINK SERVING ACT. NODE 
C     IN       USER SPECIFIED NODE NUMBER                               
C     IUP      UPSTREAM NODE NUMBER OF THE LINK SERVING ACTUATED NODE   
C     J        DO LOOP INDEX FOR ENTRIES IN XBUF ARRAY                  
C     MXACLK   MAXIMUM NUMBER OF LINKS SERVING A CONTROLLER             
C     MXEN     MAXIMUM NUMBER OF DATA ITEMS IN XBUF ARRAY FOR ACT. NODE 
C     NACT     ARRAY OF CODE IDENTIFYING TYPE OF CONTROL AT EACH NODE   
C     NMAP     ARRAY MAPPING USER SPECIFIED NODE NOS. TO INTERNAL NOS.  
C     TTLNK    TOTAL NUMBER OF LINKS IN SUBNETWORK                      
C     UPNOD    LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER               
C     WAPP     FLAG (.T., .F.) IF APPROACH (IS, IS NOT) DEFINED BY INPUT
C     WERR     FLAG (.T., .F.) IF AN ERROR (IS NOT, IS) DETECTED        
C     XBUF     INPUT CARD BUFFER                                        
C                                                                       
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C --- COMPUTE THE MAXIMUM NUMBER OF ENTRIES IN XBUF ARRAY               
C                                                                       
      MXEN = MXACLK * 2 + 1                                             
C                                                                       
C --- CALL SUBORDINATE MODULE TO TEST THE QUANTITATIVE BOUNDS OF DATA   
C --- ITEMS.                                                            
C                                                                       
      CALL TBFN43 (WERR)                                                
C                                                                       
C --- CHECK THAT THE NODE HAS NOT BEEN PREVIOUSLY DEFINED TO BE UNDER   
C --- ANY OTHER TYPE OF CONTROL                                         
C                                                                       
      IN = GLOBND(XBUF(1)) / 16                                         
      IF (NACT(IN) .NE. -9) THEN                                        
         CALL ERGEN ('CKFN43', 2717, XBUF(1), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C --- CHECK THAT THE UPSTREAM AND DOWNSTREAM NODES CORRESPOND TO        
C --- A PREVIOUSLY DEFINED LINK                                         
C                                                                       
      DO 10 I = 2, MXEN, 2                                              
         IUP = XBUF(I)                                                  
         IDN = XBUF(I + 1)                                              
         IF (IUP .GT. 0 .AND. IDN .GT. 0) THEN                          
             CALL NLKNUM(ILINK, IUP, IDN)                               
             IF (ILINK .EQ. 0) THEN                                     
                CALL ERGEN ('CKFN43', 2721, IUP, IDN, XBUF(1), 0, 3)    
                WERR = .TRUE.                                           
             ENDIF                                                      
         ENDIF                                                          
   10 CONTINUE                                                          
C                                                                       
C --- CHECK THAT ALL APPROACHES TO THE ACTUATED CONTROLLED NODE ARE     
C --- SPECIFIED FIRST.                                                  
C                                                                       
      DO 30 I = 3, 11, 2                                                
         IF (XBUF(I) .NE. XBUF(1) .AND. XBUF(I) .NE. 0) THEN            
            DO 20 J = I, MXEN, 2                                        
               IF (XBUF(J) .EQ. XBUF(1)) THEN                           
                  CALL ERGEN ('CKFN43', 2723, XBUF(1), 0, 0, 0, 1)      
                  WERR = .TRUE.                                         
               ENDIF                                                    
   20       CONTINUE                                                    
         ENDIF                                                          
   30 CONTINUE                                                          
C                                                                       
C --- CHECK FOR DUPLICATE LINKS                                         
C                                                                       
      DO 50 I = 2, MXEN, 2                                              
         IUP = XBUF(I)                                                  
         IDN = XBUF(I + 1)                                              
         IF (IUP .NE. 0 .AND. IDN .NE. 0) THEN                          
         DO 40 J = I+2, MXEN, 2                                         
            IF (XBUF(J) .EQ. IUP .AND. XBUF(J + 1) .EQ. IDN) THEN       
               CALL ERGEN ('CKFN43', 2725, XBUF(1), 0, 0, 0, 1)         
               WERR = .TRUE.                                            
            ENDIF                                                       
   40    CONTINUE                                                       
         ENDIF                                                          
   50 CONTINUE                                                          
C                                                                       
C --- CHECK THAT SPECIFICATION OF APPROACHES IS COMPLETE.               
C                                                                       
      DO 80 ILINK = 1, TTLNK                                            
         IDN = DWNOD(ILINK)                                             
         IF (IDN .LT. 7000) THEN                                        
            IF (NMAP(IDN) .EQ. XBUF(1)) THEN                            
               WAPP = .FALSE.                                           
               IUP = UPNOD(ILINK)                                       
               IF (IUP .LT. 7000) IUP = NMAP(IUP)                       
               DO 70 I = 2, 11, 2                                       
                  IF (IUP .EQ. XBUF(I)) WAPP = .TRUE.                   
   70          CONTINUE                                                 
               IF (.NOT. WAPP) THEN                                     
                  CALL ERGEN ('CKFN43', 2722, XBUF(1), 0, 0, 0, 1)      
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
   80 CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN44 (WERR)                                          
C                                                                       
C --- CODED   11-05-86 BY A. HALATI                                     
C --- REVISED  9-03-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM     
C ---                         AND IN-LINE COMMENTARY                    
C --- REVISED 02-01-92 BY K. SHERIDAN FOR ACTUATED CONTROLLER LOGIC     
C                                                                       
C --- TITLE -     CHECK DATA ON TYPE 44 CARDS - MODULE 2261.5221        
C                                                                       
C --- FUNCTION -  THIS MODULE CHECKS FOR INCONSISTENCIES                
C                 AMONG THE DATA ITEMS ON TYPE 44 CARDS.                
C                                                                       
C --- ARGUMENTS - WERR = FLAG (.T., .F.) IF AN ERROR (IS , IS NOT)      
C ---                    DETECTED, WHICH PREVENTS DATA FROM BEING       
C ---                    STORED, TO THE CALLING ROUTINE                 
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C                                                                       
C     THIS MODULE CHECKS FOR INCONSISTENCIES AMONG CARD TYPE 44 DATA    
C     ITEMS. IT CALLS SUBORDINATE MODULES TO CHECK VALIDITY OF DATA     
C     ITEMS. IF ERRORS IN INPUT DATA IS FOUND, THE ERROR FLAG IS SET    
C     BEFORE CONTROL IS RETURNED TO THE CALLING MODULE.                 
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                                                                       
C                 RDFN44 - MODULE 2261.5.2.2                            
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                       ------------------                              
C                                                                       
C                 TBFN44 - MODULE 2261.5221.1                           
C                 ERGEN  - MODULE 2.6.1.1                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ACCYCL   CONTROLLER SPECIFIC ARRAY - CYCLE LENGTH                 
C     GLOBND   GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE    
C     IAC      SUBNETWORK ACTUATED NODE NUMBER                          
C     IE       DATA POSITION INDEX IN XBUF FOR PHASE THAT HAS           
C              FORCE-OFF EXTENSION TIME                                 
C     IENTRY   DATA POSITION INDEX IN XBUF                              
C     IPERM    PERMISSIVE PERIOD NUMBER                                 
C     KN       SUBNETWORK NODE NUMBER                                   
C     NACT     NODE SPECIFIC ARRAY - TYPE OF CONTROL                    
C     NMAX     MAXIMUM NUMBER OF NODES                                  
C     WERR     FLAG (.T., .F.) IF AN ERROR (IS, IS NOT) DETECTED        
C     WF       FLAG (.T., .F.) IF FORCE-OFF TIME AND EXTENSION SPECIFIED
C     XBUF     INPUT CARD BUFFER                                        
C                                                                       
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C --- CALL SUBROUTINE TO TEST QUANTITATIVE BOUNDS ON DATA               
C                                                                       
      CALL TBFN44                                                       
C                                                                       
C --- CHECK THAT NODE NUMBER IS VALID. TRA IF NOT                       
C                                                                       
      WERR = XBUF(1) .LE. 0 .AND. XBUF(1) .GT. NMAX                     
      IF (WERR)                                              GO TO 6    
C                                                                       
C --- CHECK THAT THE CONTROL WAS PREVIOUSLY SPECIFIED AS ACTUATED.      
C --- TRA IF NOT                                                        
C                                                                       
      KN = GLOBND (XBUF (1)) / 16                                       
      IAC = NACT (KN)                                                   
      IF (IAC .LE. 0) THEN                                              
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 3053, XBUF (1), 44, 0, 0, 2)             
      ENDIF                                                             
      IF (WERR)                                              GO TO 5    
C                                                                       
C --- CHECK THAT THE COORDINATION DATA WAS NOT PREVIOUSLY SPECIFIED     
C                                                                       
      IF (ACCYCL (IAC) .GT. 0) THEN                                     
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 2791, XBUF (1), 0, 0, 0, 1)              
      ENDIF                                                             
    5 CONTINUE                                                          
    6 CONTINUE                                                          
C                                                                       
C --- CHECK THAT BEGIN PERMISSIVE TIMES ARE SMALLER THAN END PERMISSIVE 
C --- TIMES                                                             
C                                                                       
      DO 10 IENTRY = 4, 8, 2                                            
         IF (XBUF (IENTRY) .GT. XBUF (IENTRY + 1)) THEN                 
            WERR = .TRUE.                                               
            IPERM = IENTRY/2 - 1                                        
            CALL ERGEN ('CKFN44', 2787, XBUF (1), IPERM, 0, 0, 2)       
         ENDIF                                                          
   10 CONTINUE                                                          
C                                                                       
C --- CHECK THAT THE PHASE NUMBER TO BE EXTENDED AND THE DURATION       
C --- OF THE EXTENSION ARE EITHER BOTH SPECIFIED OR BOTH UNSPECIFIED    
C                                                                       
      IF ((XBUF(11) .NE. 0 .AND. XBUF(12) .EQ. 0) .OR.                  
     1    (XBUF(12) .NE. 0 .AND. XBUF(11) .EQ. 0)) THEN                 
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN44', 5372, XBUF(1), 11, 12, 0, 3)            
      ENDIF                                                             
      IF ((XBUF(16) .NE. 0 .AND. XBUF(17) .EQ. 0) .OR.                  
     1    (XBUF(17) .NE. 0 .AND. XBUF(16) .EQ. 0)) THEN                 
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN44', 5372, XBUF(1), 12, 17, 0, 3)            
      ENDIF                                                             
C                                                                       
C --- CHECK THAT A FORCE-OFF TIME WAS SPECIFIED FOR A PHASE THAT        
C --- FORCE-OFF EXTENSION TIME WAS SPECIFIED                            
C                                                                       
      IE = 6                                                            
   20 CONTINUE                                                          
      IE = IE + 5                                                       
      IF (XBUF(IE) .GT. 0 .AND. XBUF(IE) .NE. 2 .AND.                   
     1    XBUF(IE) .NE. 6) THEN                                         
         WF = .FALSE.                                                   
            DO 30 IENTRY = 10, 19                                       
               IF (IENTRY .NE. 11 .AND. IENTRY .NE. 12 .AND.            
     1             IENTRY .NE. 16 .AND. IENTRY .NE. 17) THEN            
                  IF (XBUF(IENTRY) .GT. 0) THEN                         
                     IPH = IENTRY - 10                                  
                     IF (IENTRY .EQ. 10) IPH = IPH + 1                  
                     IF (IENTRY .GT. 15) IPH = IPH - 1                  
                     IF (XBUF(IE) .EQ. IPH) WF = .TRUE.                 
                  ENDIF                                                 
               ENDIF                                                    
   30       CONTINUE                                                    
         IF (.NOT. WF) THEN                                             
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN44', 5373, XBUF(1), IE, 0, 0, 2)           
         ENDIF                                                          
      ENDIF                                                             
      IF (IE .LT. 16)                                        GO TO 20   
C                                                                       
C --- CHECK THAT PHASE NUMBERS SPECIFIED FOR FORCE-OFF EXTENSION        
C --- TIMES ARE NOT DUPLICATES                                          
C                                                                       
      IF ((XBUF(11) .EQ. XBUF(16)) .AND. (XBUF(11) + XBUF(16)           
     1    .NE. 0)) THEN                                                 
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 5387, XBUF(1), 11, 16, 0, 3)             
      ENDIF                                                             
C                                                                       
C --- CHECK THAT A FORCE-OFF TIME EXTENSION WAS NOT SPECIFIED FOR A     
C --- SYNC PHASE (PHASE 2 AND 6)                                        
C                                                                       
      IF (XBUF(11) .EQ. 2 .OR. XBUF(11) .EQ. 6) THEN                    
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 5374, XBUF(1), 11, 0, 0, 2)              
      ENDIF                                                             
      IF (XBUF(16) .EQ. 2 .OR. XBUF(16) .EQ. 6) THEN                    
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 5374, XBUF(1), 16, 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT PERMISSIVE FLAGS FOR PHASES 2 AND 6 ARE ZERO           
C                                                                       
      IF (XBUF(21) .NE. 0) THEN                                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 2790, XBUF (1), 2, 0, 0, 2)              
      ENDIF                                                             
      IF (XBUF(25) .NE. 0) THEN                                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN44', 2790, XBUF (1), 6, 0, 0, 2)              
      ENDIF                                                             
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN45 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED   10-30-85 BY A. HALATI                                     
C --- REVISED  9-08-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM,    
C ---                         TO REMOVE INCORRECT REFERENCE TO MXACLK   
C                                                                       
C --- TITLE   -   CHECK DATA ON TYPE 45 CARDS - MODULE 2261.5231        
C                                                                       
C --- FUNCTION -  THIS MODULE CHECKS FOR INCONSISTENCIES                
C                 AMONG THE DATA ITEMS ON TYPE 45 CARDS.                
C                                                                       
C --- ARGUMENTS - WERR = FLAG (.T., .F.) IF AN ERROR (IS NOT, IS)       
C ---                    DETECTED WHICH PREVENTS DATA FROM BEING STORED 
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C                                                                       
C     THIS MODULE CHECKS FOR INCONSISTENCIES BETWEEN CARD               
C     TYPE 45 DATA ITEMS. IT CALLS SUBORDINATE MODULES TO               
C     TEST VALIDITY OF DATA ITEMS. IF ERRORS IN DATA                    
C     SPECIFICATIONS ARE FOUND ERROR MESSAGES ARE PRINTED               
C     AND THE ERROR FLAG IS SET BEFORE CONTROL IS RETURNED              
C     TO THE CALLING MODULE.                                            
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                                                                       
C                 RDFN45 - MODULE 2261.5.2.3                            
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                                                                       
C                 TBFN45 - MODULE 2261.5231.1                           
C                 ERGEN  - MODULE 2.6.1.1                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ARIGHT   LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK          
C     DIAGNL   LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK            
C     GLOBND   NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE           
C     I        DO LOOP INDEX FOR DATA IN XBUF                           
C     IAP      DO LOOP INDEX FOR APPROACH NUMBER                        
C     IBEG     BEGINNING POSITION OF UNPACKED DATA IN XBUF FOR APPROACH 
C     IL       LINK IDENTIFICATION NUMBER FOR THE APPROACH              
C     IN       USER SPECIFIED ACTUATED CONTROLLED NODE                  
C     INSIG    INDEX TO DATA POSITION IN SIGI ARRAY FOR ACTUATED NODE IN
C     ITURN    TURN CODE FOR THE ALLOWABLE MOVEMENT. CODES ARE:         
C                                                                       
C                               CODE      TURN MOVEMENT                 
C                               ----      -------------                 
C                                                                       
C                                0            LEFT                      
C                                1            RIGHT                     
C                                3        LEFT DIAGONAL                 
C                                4        RITE DIAGONAL                 
C                                                                       
C     J        DO LOOP INDEX FOR THE FIRST NONZERO ENTRY AFTER A ZERO   
C     KN       SUBNETWORK NODE NUMBER CORRESPONDING TO NODE IN          
C     LEFT     LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK           
C     NACT     NODE SPECIFIC ARRAY - TYPE OF CONTROL                    
C     NAP      NO. OF APPROACHES DEFINED BY THE INPUT DATA              
C     NMAX     MAXIMUM NUMBER OF NODES                                  
C     SIGI     NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBERS 
C     THRU     LINK SPECIFIC ARRAY - THROUGH RECEIVING LINK             
C     WERR     FLAG (T, F) IF ERROR (IS, IS NOT) DETECTED               
C     WTURN    FLAG (T, F) IF MOVEMENT (HAS, HAS NOT) A RECEIVING LINK  
C     XBUF     BUFFER ARRAY USED TO STORE CARD CONTENTS                 
C                                                                       
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C --- CALL THE SUBORDINATE MODULE TO TEST THE QUANTITATIVE BOUNDS       
C --- OF THE INPUT DATA                                                 
C                                                                       
      CALL TBFN45                                                       
C                                                                       
C --- CHECK THAT THE NODE NUMBER IS VALID. TRA IF NOT                   
C                                                                       
      WERR = XBUF(1) .LE. 0 .OR. XBUF(1) .GT. NMAX                      
      IF (WERR)                                              GO TO 70   
C                                                                       
C --- CHECK THAT THE NODE HAS BEEN PREVIOUSLY DECLARED AS AN ACTUATED   
C --- NODE ON CARD TYPE 43                                              
C                                                                       
      IN = XBUF(1)                                                      
      KN = GLOBND(IN) / 16                                              
      IF (NACT(KN) .LE. 0) THEN                                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN45', 2728, IN, XBUF(2), 45, 0, 3)             
      ENDIF                                                             
      IF (WERR)                                              GO TO 60   
C                                                                       
C --- CHECK THE SEQUENCE OF MOVEMENT SPECIFIC CODES. A ZERO MAY NOT     
C --- BE FOLLOWED BY NONZERO VALUE                                      
C                                                                       
      DO 20 I = 3, 7                                                    
         IF (XBUF(I) .EQ. 0) THEN                                       
            DO 10 J = I, 7                                              
               IF (XBUF(J) .NE. 0) THEN                                 
                  WERR = .TRUE.                                         
                  CALL ERGEN ('CKFN45', 2729, I, J, XBUF(1), XBUF(2), 4)
               ENDIF                                                    
   10       CONTINUE                                                    
         ENDIF                                                          
   20 CONTINUE                                                          
C                                                                       
C --- CHECK THAT MOVEMENT SPECIFIC CODES ARE DEFINED FOR ALL APPROACHES 
C                                                                       
      INSIG = (KN - 1) * 5                                              
      NAP = 0                                                           
      DO 30 I = 1, 5                                                    
         IF (SIGI(INSIG + I) .GT. 0) THEN                               
            NAP = NAP + 1                                               
            IF (XBUF(2+NAP) .LE. 0) THEN                                
               WERR = .TRUE.                                            
               CALL ERGEN ('CKFN45', 2730, NAP, XBUF(1), XBUF(2), 0, 3) 
            ENDIF                                                       
         ENDIF                                                          
   30 CONTINUE                                                          
C                                                                       
C --- CHECK THAT EACH SPECIFIED MOVEMENT HAS A RECEIVING LINK           
C                                                                       
      DO 50 IAP = 1, NAP                                                
         IBEG = 10 + (IAP - 1) * 5                                      
C                                                                       
C --- FIRST CHECK THAT THE CODE IS NOT ZERO                             
C                                                                       
      DO 40 I = IBEG, IBEG + 4                                          
         IF (XBUF(I) .EQ. 0) THEN                                       
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN45', 2727, 0, XBUF(1), XBUF(2), 0, 3)      
C                                                                       
C --- CHECK THAT IF MOVEMENT IS ALLOWED A RECEIVING LINK IS PRESENT.    
C                                                                       
            ELSE                                                        
               WTURN = .TRUE.                                           
               IF (XBUF(I) .EQ. 2) THEN                                 
                   INSIG = (KN - 1) * 5 + IAP                           
                   IL = SIGI(INSIG)                                     
                   ITURN = I - IBEG                                     
                   IF (ITURN .EQ. 0) THEN                               
C                                                                       
C --- CHECK FOR LEFT TURN RECEIVING LINK                                
C                                                                       
                     IF (LEFT(IL) .LE. 0) THEN                          
                        WERR = .TRUE.                                   
                        WTURN = .FALSE.                                 
                     ENDIF                                              
                   ELSE                                                 
                     IF (ITURN .EQ. 1) THEN                             
C                                                                       
C --- CHECK FOR THRU RECEIVING LINK                                     
C                                                                       
                         IF (THRU(IL) .LE. 0) THEN                      
                            WERR = .TRUE.                               
                            WTURN = .FALSE.                             
                         ENDIF                                          
                     ELSE                                               
                        IF (ITURN .EQ. 2) THEN                          
C                                                                       
C --- CHECK FOR RIGHT RECEIVING LINK                                    
C                                                                       
                           IF (ARIGHT(IL) .LE. 0) THEN                  
                              WERR = .TRUE.                             
                              WTURN = .FALSE.                           
                           ENDIF                                        
                        ELSE                                            
                           IF (ITURN .EQ. 3) THEN                       
C                                                                       
C --- CHECK FOR LEFT DIAGONAL RECEIVING LINK                            
C                                                                       
                             IF (DIAGNL(IL) .GE. 0) THEN                
                                WERR = .TRUE.                           
                                WTURN = .FALSE.                         
                             ENDIF                                      
                           ELSE                                         
                              IF (ITURN .EQ.4) THEN                     
C                                                                       
C --- CHECK FOR RIGHT DIAGONAL RECEIVING LINK                           
C                                                                       
                                 IF (DIAGNL(IL) .LE. 0) THEN            
                                    WERR = .TRUE.                       
                                    WTURN = .FALSE.                     
                                 ENDIF                                  
                              ENDIF                                     
                           ENDIF                                        
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
            IF (.NOT. WTURN) CALL ERGEN ('CKFN45', 2731, XBUF(1),       
     1                                   XBUF(2), IAP, ITURN, 4)        
   40    CONTINUE                                                       
   50 CONTINUE                                                          
   60 CONTINUE                                                          
   70 CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN46 (WERR)                                          
C                                                                       
C --- CODED   10-30-85 BY A. HALATI                                     
C --- REVISED  4-27-87 BY M. YEDLIN TO FIX MESSAGE 2744                 
C --- REVISED  7-08-87 BY M. YEDLIN TO CONVERT MISSING ITEMS FROM       
C ---                                   METRIC TO ENGLISH UNITS         
C --- REVISED  9-08-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM,    
C ---                  ADD ARGUMENT WERR IN CALL TO TBFN46              
C --- REVISED 12-19-88 BY A. KANAAN TO REMOVE PACKING OF LGLPK          
C --- REVISED  8-08-89 BY H. CHEN TO ENHANCE THE PROGRAMMING STYLE      
C --- REVISED 11-10-90 BY H. CHEN TO ADD NEW LANE CODE 8.               
C --- REVISED  1-25-93 BY S.E.SMITH TO CHANGE FATAL ERR 2741 TO WARN 665
C                                                                       
C --- TITLE   -   CHECK DATA ON TYPE 46 CARDS - MODULE 2261.5241        
C                                                                       
C --- FUNCTION -  THIS MODULE CHECKS FOR INCONSISTENCIES                
C                 AMONG THE DATA ITEMS ON TYPE 46 CARDS.                
C                                                                       
C --- ARGUMENTS - WERR = FLAG (.T., .F.) IF AN ERROR (IS NOT, IS)       
C ---                    DETECTED, WHICH PREVENTS STORING DATA,         
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C     THIS MODULE CHECKS FOR INCONSISTENCIES BETWEEN CARD               
C     TYPE 46 DATA ITEMS. IT CALLS SUBORDINATE MODULES TO               
C     TEST VALIDITY OF DATA ITEMS. IF ERRORS IN DATA                    
C     SPECIFICATIONS ARE FOUND ERROR MESSAGES ARE PRINTED               
C     AND THE ERROR FLAG IS SET BEFORE CONTROL IS RETURNED              
C     TO THE CALLING MODULE.                                            
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                 RDFN46 - MODULE 2261.5.2.4                            
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                       ------------------                              
C                 TBFN46 - MODULE 2261.5241.1                           
C                 ERGEN  - MODULE 2.6.1.1                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C     ACNLNK   APPROACHES SERVED / REFERENCED  BY THE CONTROLLER        
C     AMOVSP   NODE, PHASE AND LINK SPECIFIC ARRAY - MOVEMENT SPEC. CODE
C     DWNOD    LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER             
C     GLOBND   NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE           
C     I        INDEX TO ENTRIES IN XBUF ARRAY                           
C     IAC      SUBNETWORK ACTUATED NODE NUMBER                          
C     IDT      DO LOOP INDEX FOR NUMBER OF DETECTORS                    
C     ILANE    LANE NUMBER                                              
C     ILEFTL   NUMBER OF LANES IN THE LEFT-TURN POCKET FOR THE APPROACH 
C     ILINK    LINK IDENTIFICATION NUMBER OF THE APPROACH               
C     IMINPL   MINIMUM OF RIGHT AND LEFT TURN POCKET LENGTHS            
C     IMOVSP   DATA POSITION INDEX TO AMOVSP ARRAY BY NODE, PHASE, LINK 
C     INDEX    DATA POSITION INDEX TO ACNLNK ARRAY FOR THE ACTUATED NODE
C     IPHASE   PHASE NUMBER                                             
C     IRITEL   NUMBER OF LANES IN THE RIGHT-TURN POCKET FOR THE APPROACH
C     IRTEPL   RIGHT-TURN POCKET LENGTH                                 
C     ISTLEN   STREET SEGMENT LENGTH OF THE APPROACH                    
C     ITHRUL   NUMBER OF THROUGH LANES FOR THE APPROACH                 
C     KN       SUBNETWORK NODE NUMBER CORRESPONDING TO THE ACTUATED NODE
C     LANE     DO LOOP INDEX FOR LANE SPECIFICATIONS IN XBUF ARRAY      
C     LANEGD   LINK SPECIFIC ARRAY - GRADE, NO. OF FULL AND POCKET LANES
C     LEDGE    DISTANCE BETWEEN DET. LEADING EDGE TO DOWNSTREAM STOP-BAR
C     LEFTPL   LEFT-TURN POCKET LENGTH                                  
C     LENTH    APPROACH LENGTH                                          
C     LGLPK    LINK SPECIFIC ARRAY - LENGTH OF LEFT POCKET, BUS         
C     LGRPK    LINK SPECIFIC ARRAY - LENGTH OF RIGHT POCKET             
C     MXACLK   MAXIMUM NUMBER OF LINKS SERVICING A CONTROLLER           
C     NACT     NODE SPECIFIC ARRAY - TYPE OF CONTROL                    
C     UNITIN   CODE (0,1) IF DATA INPUT IN (ENGLISH,METRIC) UNITS       
C     WERR     FLAG (.T., .F.) IF ERROR (IS, IS NOT) DETECTED           
C     XBUF     INPUT CARD BUFFER                                        
C     XLNGTH   LINK SPECIFIC ARRAY - LINK LENGTH                        
C     ZCNVRT   ARRAY OF CONVERSION FACTORS FROM ENGLISH TO METRIC UNITS 
C              AND VICE-VERSA                                           
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C           CONVERT TO ENGLISH SYSTEM IF NEEDED                         
C                                                                       
      IF (UNITIN .GT. 0) THEN                                           
         XBUF (7) = XBUF (7) * ZCNVRT(4)                                
         XBUF(10) = XBUF(10) * ZCNVRT(4)                                
         XBUF(15) = XBUF(15) * ZCNVRT(4)                                
         XBUF(18) = XBUF(18) * ZCNVRT(4)                                
         XBUF(23) = XBUF(23) * ZCNVRT(4)                                
         XBUF(26) = XBUF(26) * ZCNVRT(4)                                
      ENDIF                                                             
C                                                                       
      CALL TBFN46 (WERR)                                                
      IF (WERR)                                              RETURN     
C                                                                       
C           CHECK THAT THE CONTROL WAS PREVIOUSLY SPECIFIED AS ACTUATED.
C                                                                       
      KN = GLOBND(XBUF(1)) / 16                                         
      IAC = NACT(KN)                                                    
      IF (IAC .LE. 0) THEN                                              
         WERR = .TRUE.                                                  
         CALL ERGEN('CKFN46', 2728, XBUF(1), XBUF(2), 46, 0, 3)         
      ELSE                                                              
C                                                                       
C           CHECK THAT THE APPROACH NUMBER IS VALID AND DEFINED         
C                                                                       
         IF (XBUF(4) .LT. 1 .OR. XBUF(4) .GT. MXACLK)        GO TO 30   
         INDEX = MXACLK * (IAC -1) + XBUF(4)                            
         ILINK = ACNLNK (INDEX)                                         
         IF (ILINK .LE. 0) THEN                                         
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN46', 2742, XBUF(4), XBUF(2), XBUF(1),0,3)  
         ELSE                                                           
C                                                                       
C --- TRA IF PHASE NUMBER IS INVALID. IF LINK DIRECTLY APPROACHES       
C --- ACTUATED NODE, TEST TO SEE IF THE PHASE WAS PREVIOUSLY DEFINED    
C --- BY CARD TYPE 45.                                                  
C                                                                       
            IPHASE = XBUF(2)                                            
            IF (IPHASE .LE. 0 .OR. IPHASE .GT. 8)            GO TO 5    
            IMOVSP = 40 * (IAC - 1) + 5 * (IPHASE - 1) + XBUF(4)        
            IF (DWNOD(ILINK) .EQ. IAC .AND. AMOVSP(IMOVSP) .LE. 0) THEN 
               CALL ERGEN ('CKFN46', 665, XBUF(1), XBUF(2), 0, 0, 2)    
            ENDIF                                                       
    5       CONTINUE                                                    
C                                                                       
C --- GET THE NUMBER AND THE LENGTH OF LANES FOR APPROACH               
C                                                                       
            ITHRUL = MOD (LANEGD(ILINK) / 2**3, 2**3)                   
            ILEFTL = MOD (LANEGD(ILINK) / 2**8, 2**2)                   
            IRITEL = MOD (LANEGD(ILINK) / 2**6, 2**2)                   
            LENTH = MOD (XLNGTH(ILINK), 2**12)                          
            ISTLEN = LENTH - XLNGTH(ILINK) / 2**12 * 10                 
            LEFTPL = LGLPK(ILINK)                                       
            IRTEPL = MOD (LGRPK(ILINK), 2**10)                          
C                                                                       
C --- DO UNTIL ALL DETECTORS SPECIFIED ON THE CARD ARE PROCESSED.       
C                                                                       
            DO 20 IDT = 1, 3                                            
            I = 5 + 8 * (IDT-1)                                         
            IF (XBUF(I).GT.0 .OR. XBUF(I+1).GT.0) THEN                  
C                                                                       
C --- DETECTOR IS DEFINED. CHECK THAT THE SPECIFIED LANES EXIST.        
C                                                                       
               IF (XBUF(I).GT.ITHRUL .AND.                              
     +                  XBUF(I).LT.(8-ILEFTL-IRITEL)) THEN              
                   WERR = .TRUE.                                        
                   CALL ERGEN ('CKFN46', 2743, XBUF(1),                 
     1                             XBUF(2), XBUF(I), XBUF(4),4)         
               ENDIF                                                    
C                                                                       
               IF (XBUF(I+1) .GT. ITHRUL .AND. XBUF(I+1)                
     1                   .LT. (8 - ILEFTL - IRITEL)) THEN               
                  WERR = .TRUE.                                         
                  CALL ERGEN ('CKFN46', 2743, XBUF(1),                  
     1                             XBUF(2), XBUF(I+1), XBUF(4),4)       
               ENDIF                                                    
C                                                                       
C --- ERROR IF THE DISTANCE BETWEEN THE LEADING EDGE OF THE DETECTOR    
C --- AND THE DOWNSTREAM STOP-BAR IS LARGER THAN THE STREET SEGMENT     
C --- LENGTH OF THE APPROACH                                            
C                                                                       
               LEDGE = (XBUF(I+2) + XBUF(I+5)) / 10                     
               IF (LEDGE .GT. ISTLEN ) THEN                             
                  WERR = .TRUE.                                         
                  CALL ERGEN ('CKFN46',2744,XBUF(1),XBUF(2),I+2,I+5,4)  
               ENDIF                                                    
C                                                                       
C --- ERROR IF THE DETECTOR IS SPECIFIED TO BE INSIDE A TURNING POCKET  
C --- AND THE DISTANCE BETWEEN THE LEADING EDGE OF THE DETECTOR AND THE 
C --- DOWNSTREAM STOP-BAR IS GREATER THAN THE POCKET LENGTH.            
C                                                                       
               DO 10 LANE = 1, 2                                        
C                                                                       
C --- FIRST CHECK IF THERE IS A TURNING POCKET ON THIS APPROACH.        
C                                                                       
               IF (ILEFTL + IRITEL .GT. 0) THEN                         
C                                                                       
C --- DETECTOR IS INSIDE THE POCKET IF ITS SENSING ZONE COVERS ALL      
C --- LANES (I.E., LANE CODE IS 9) AND THE DISTANCE BETWEEN ITS         
C --- TRAILING EDGE AND THE STOP-BAR IS LESS THAN THE POCKET LENGTH.    
C                                                                       
                  ILANE = XBUF(I+LANE-1)                                
                  IMINPL = MIN0 (LEFTPL, IRTEPL)                        
                  IF (IMINPL .EQ. 0) IMINPL = MAX0 (LEFTPL, IRTEPL)     
                  IF (ILANE.EQ.9 .AND. XBUF(I+2)/10.LE.IMINPL) THEN     
                     IF (LEDGE .GT. IMINPL) THEN                        
                        WERR = .TRUE.                                   
                        CALL ERGEN ('CKFN46',2744,XBUF(1),XBUF(2),      
     1                              I+2,I+5,4)                          
                     ENDIF                                              
C                                                                       
C --- A DETECTOR IS PRESENT ON A POCKET LANE IF EITHER LANE A OR LANE B 
C --- ENTRIES DIRECTLY DEFINE A POCKET LANE NUMBER.                     
C                                                                       
                  ELSE                                                  
C                                                                       
C --- FIRST CHECK FOR A RIGHT TURN POCKET LANE.                         
C                                                                       
                     IF (ILANE.GT.ITHRUL .AND.                          
     1                            ILANE.LE.(7-ILEFTL)) THEN             
                        IF (LEDGE .GT. IRTEPL) THEN                     
                           WERR = .TRUE.                                
                           CALL ERGEN ('CKFN46', 2744, XBUF(1),         
     1                                          XBUF(2), I+2, I+5, 4)   
                        ENDIF                                           
                     ELSE                                               
C                                                                       
C --- CHECK FOR LEFT-TURN POCKET.                                       
C                                                                       
                        IF (ILEFTL.GT.0 .AND. ILANE.GE.(8-ILEFTL)) THEN 
                           IF (LEDGE .GT. LEFTPL) THEN                  
                              WERR = .TRUE.                             
                              CALL ERGEN('CKFN46',2744,XBUF(1),         
     1                                            XBUF(2), I+2, I+5, 4) 
                           ENDIF                                        
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
               ENDIF                                                    
   10          CONTINUE                                                 
            ENDIF                                                       
   20       CONTINUE                                                    
         ENDIF                                                          
   30    CONTINUE                                                       
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN47 (WERR)                                          
C                                                                       
C --- CODED   10-30-85 BY A. HALATI                                     
C --- REVISED  9-08-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM,    
C ---                         TO ADD CHECK ON MIN GREEN, FIX GLOSSARY,  
C ---                         ERROR MESSAGE 3053                        
C --- REVISED  2-01-92 BY K. SHERIDAN FOR ACTUATED CONTROLLER LOGIC     
C                                                                       
C --- TITLE   -   CHECK DATA ON TYPE 47 CARDS - MODULE 2261.5251        
C                                                                       
C --- FUNCTION -  THIS MODULE CHECKS FOR INCONSISTENCIES                
C                 AMONG THE DATA ITEMS ON TYPE 47 CARDS.                
C                                                                       
C --- ARGUMENTS - WERR = FLAG (.T., .F.) IF AN ERROR (IS NOT, IS)       
C ---                    DETECTED, WHICH WOULD PREVENT STORING DATA,    
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C                                                                       
C     THIS MODULE CHECKS FOR INCONSISTENCIES BETWEEN CARD               
C     TYPE 47 DATA ITEMS. IT CALLS SUBORDINATE MODULES TO               
C     TEST VALIDITY OF DATA ITEMS. IF ERRORS IN DATA                    
C     SPECIFICATIONS ARE FOUND ERROR MESSAGES ARE PRINTED               
C     AND THE ERROR FLAG IS SET BEFORE CONTROL IS RETURNED              
C     TO THE CALLING MODULE.                                            
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                                                                       
C                 RDFN47 - MODULE 2261.5.2.5                            
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                                                                       
C                 TBFN47 - MODULE 2261.5251.1                           
C                 ERGEN  - MODULE 2.6.1.1                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                                                                       
C     ACTRAM   EMULATION OF MOTOROLA 6800 RAM MEMORY                    
C     GLOBND   GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE    
C     IAC      SUBNETWORK ACTUATED NODE NUMBER                          
C     IBIT     DO LOOP INDEX INDICATING THE PHASE BIT POSITION          
C     IGR      GAP REDUCTION CODE. CODES ARE:                           
C                                                                       
C                             CODE         GAP REDUCTION TYPE           
C                             ----      --------------------------      
C                                                                       
C                              0        REDUCE BY / REDUCE EVERY        
C                              1        REDUCE BY EVERY SECOND          
C                              2        TIME TO REDUCE TO MIN. GAP      
C                                                                       
C     IIC      INITIAL INTERVAL CODE. CODES ARE:                        
C                                                                       
C                             CODE      INITIAL INTERVAL TYPE           
C                             ----      ---------------------           
C                                                                       
C                              0             EXTENSIBLE                 
C                              1             ADDED                      
C                              2             COMPUTED                   
C                                                                       
C     IN       USER SPECIFIED ACTUATED NODE NUMBER                      
C     INPRMT   INDEX TO PERMITTED PHASES WORD IN ACTRAM ARRAY           
C     IPZBIT   PHASE NUMBER                                             
C     KN       SUBNETWORK NODE NUMBER CORRESPONDING TO NODE IN          
C     NACT     NODE SPECIFIC ARRAY - TYPE OF CONTROL                    
C     PERMIT   PERMITTED PHASES                                         
C     WERR     FLAG (T, F) IF INPUT ERROR (IS, IS NOT) DETECTED         
C     WPRMT    FLAG (.T., .F.F) IF THE PHASE (IS, IS NOT) PERMITTED     
C     XBUF     INPUT CARD BUFFER                                        
C                                                                       
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C --- CALL SUBROUTINE MODULE TO TEST THE QUANTITATIVE BOUNDS OF DATA.   
C                                                                       
      CALL TBFN47 (WERR)                                                
      IF (WERR)                                              GO TO 20   
C                                                                       
C --- CHECK THAT THE NODE HAS BEEN PREVIOUSLY DEFINED AS AN ACTUATED    
C --- NODE                                                              
C                                                                       
      IN = XBUF(1)                                                      
      KN = GLOBND(IN) / 16                                              
      IF (NACT(KN) .LE. 0) THEN                                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 3053, IN, 47, 0, 0, 2)                   
      ENDIF                                                             
      IF (WERR)                                              GO TO 15   
C                                                                       
C --- CHECK THAT THE PHASE WAS PREVIOUSLY DEFINED BY THE TYPE 45 CARDS  
C --- PHASE BIT IN PERMIT WORD OF ACTRAM ARRAY WAS SET IF THE PHASE     
C --- WAS DEFINED PREVIOUSLY. FIRST COMPUTE THE INDEX TO PERMIT IN      
C --- ACTRAM AND THEN CHECK THE BIT SETTING                             
C                                                                       
      IAC = NACT(KN)                                                    
      INPRMT = (IAC - 1) * 751 + 496                                    
      PERMIT = ACTRAM (INPRMT)                                          
      IPZBIT = XBUF(2)                                                  
      WPRMT = .FALSE.                                                   
      IF (IPZBIT .EQ. 1) THEN                                           
         IF (MOD(PERMIT, 2) .EQ. 0) THEN                                
            WERR = .TRUE.                                               
            WPRMT = .TRUE.                                              
         ENDIF                                                          
      ELSE                                                              
         DO 10 IBIT = 1, IPZBIT-1                                       
            PERMIT = PERMIT / 2                                         
   10    CONTINUE                                                       
         IF (MOD(PERMIT, 2) .EQ. 0) THEN                                
             WERR = .TRUE.                                              
             WPRMT = .TRUE.                                             
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C --- ERROR CONDITION IF PHASE WAS NOT PREVIOUSLY DEFINED               
C                                                                       
      IF (WPRMT) CALL ERGEN ('CKFN47', 2751, IN, XBUF(2), 0, 0, 2)      
   15 CONTINUE                                                          
   20 CONTINUE                                                          
C                                                                       
C --- WHEN MAXIMUM GREEN IS SPECIFIED, IT MUST BE GREATER THAN MIN.     
C --- GREEN AND MAX. EXTENSION SHOULD BE ZERO                           
C                                                                       
      IF (XBUF(3) .GT. 0) THEN                                          
         IF (XBUF(3) .LT. XBUF(4)) THEN                                 
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN47', 2753, IN, XBUF(2), 0, 0, 2)           
         ENDIF                                                          
         IF (XBUF(6) .NE. 0) THEN                                       
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN47', 2752, IN, XBUF(2), 0, 0, 2)           
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C --- WHEN INITIAL INTERVAL CODE IS 0, (I.E. EXTENSIBLE OPTION IS       
C --- SPECIFIED) ENTRY 9 MUST BE LEFT BLANK.                            
C                                                                       
      IIC = XBUF(7)                                                     
      IF (IIC .EQ. 0 .AND. XBUF(9) .NE. 0) THEN                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2754, IN , XBUF(2), 0, 0, 2)             
      ENDIF                                                             
C                                                                       
C --- WHEN INITIAL INTERVAL CODE IS 2, (I.E. COMPUTED INITIAL OPTION IS 
C --- SPECIFIED) ENTRY 8 MUST BE LEFT BLANK AND ENTRY 10 MUST BE NONZERO
C                                                                       
      IF (IIC .EQ. 2) THEN                                              
         IF (XBUF(8) .NE. 0) THEN                                       
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN47', 2755, IN, XBUF(2), 0, 0, 2)           
         ENDIF                                                          
         IF (XBUF(10) .EQ. 0 .OR. XBUF(9) .EQ. 0) THEN                  
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN47', 2756, IN, XBUF(2), 0, 0, 2)           
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C --- WHEN MAXIMUM GREEN TIME IS SPECIFIED, IT MUST BE GREATER THAN     
C --- MAXIMUM INITIAL.                                                  
C                                                                       
      IF (XBUF(3) .GT. 0 .AND. XBUF(3) .LT. XBUF(10)) THEN              
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2758, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- WHEN INITIAL INTERVAL CODE IS EITHER 0 OR 2, MINIMUM GREEN TIME   
C --- MUST BE LESS THAN OR EQUAL TO MAXIMUM INITIAL PERIOD              
C                                                                       
      IF (IIC .EQ. 0 .OR. IIC .EQ. 2) THEN                              
         IF (XBUF(4) .GT. XBUF(10)) CALL ERGEN ('CKFN47', 2713, IN,     
     1       IPZBIT, 0, 0, 2)                                           
      ENDIF                                                             
C                                                                       
C --- WHEN THE GAP REDUCTION CODE IS 1, (I.E. REDUCE BY, EVERY SECOND,  
C --- OPTION) ENTRY 13 SHOULD BE LEFT BLANK                             
C                                                                       
      IGR = XBUF(11)                                                    
      IF (IGR .EQ. 1 .AND. XBUF(13) .GT. 0) THEN                        
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2759, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- WHEN GAP REDUCTION CODE IS 2, (I.E. TIME TO REDUCE TO MINIMUM     
C --- GAP OPTION) ENTRY 12 SHOULD BE LEFT BLANK.                        
C                                                                       
      IF (IGR .EQ. 2 .AND. XBUF(12) .GT. 0) THEN                        
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2760, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT MAX GAP IS GREATER OR EQUAL TO MIN GAP                 
C                                                                       
      IF (XBUF(15) .LT. XBUF(14)) THEN                                  
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2761, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT MINIMUM GAP IS LESS THAN OR EQUAL TO UNIT EXTENSION    
C                                                                       
      IF (XBUF(14) .GT. XBUF(5) * 10) THEN                              
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2762, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- IF MINIMUM GAP IS EQUAL TO THE MAXIMUM GAP, (I.E. NOT A VOLUME-   
C --- DENSITY CONTROLLER) THEN UNIT EXTENSION SHOULD BE ALSO EQUAL TO   
C --- THOSE.                                                            
C                                                                       
      IF (XBUF(14) .EQ. XBUF(15) .AND. XBUF(14) .NE. XBUF(5) * 10) THEN 
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2764, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT BOTH YELLOW AND RED LOCKS ARE NOT SET                  
C                                                                       
      IF (XBUF(18) .EQ. 1 .AND. XBUF(19) .EQ. 1) THEN                   
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2765, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT BOTH MAXIMUM AND MINIMUM RECALL FLAGS ARE NOT SET      
C                                                                       
      IF (XBUF(22) .EQ. 1 .AND. XBUF(23) .EQ. 1) THEN                   
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2766, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT BOTH RED-REST AND MAX-MIN RECALLS ARE NOT SET          
C                                                                       
      IF (XBUF(24) .EQ. 1 .AND. XBUF(22) .EQ. 1 .OR. XBUF(24) .EQ. 1    
     1    .AND. XBUF(23) .EQ. 1) THEN                                   
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN47', 2767, IN, XBUF(2), 0, 0, 2)              
      ENDIF                                                             
C                                                                       
C --- CHECK THAT BOTH ENTRIES 30 AND 31 ARE SPECIFIED IF THE            
C --- CONDITIONAL SERVICE FEATURE IS REQUESTED                          
C                                                                       
      IF ((XBUF(30) .EQ. 1 .AND. XBUF(31) .EQ. 0) .OR.                  
     1    (XBUF(30) .EQ. 0 .AND. XBUF(31) .GT. 0)) THEN                 
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN47', 5380, IN, XBUF(2), 30, 31, 4)           
      ENDIF                                                             
C                                                                       
C --- CHECK THAT CONDITIONAL SERVICE FEATURE NOT SELECTED WHEN          
C --- ACTUATED SIGNAL FOR NODE HAS COORDINATED CONTROLLER               
C                                                                       
      IF ((XBUF(30) + XBUF(31) .GT. 0) .AND. ACCYCL(IAC) .GT. 0) THEN   
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN47', 5381, IN, XBUF(2), 30, 31, 4)           
      ENDIF                                                             
C                                                                       
C --- CHECK THAT CONDITIONAL SERVICE FEATURE NOT SELECTED FOR A         
C --- PHASE THAT HAS LOAG CONTROL SPECIFIED                             
C                                                                       
      IF ((XBUF(30) + XBUF(31) .GT. 0) .AND. XBUF(25) .EQ. 1) THEN      
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN47', 5382, IN, XBUF(2), 30, 31, 4)           
      ENDIF                                                             
C                                                                       
C --- CHECK THAT ACTUATED SIGNAL FOR NODE IS COORDINATED IF LAG         
C --- PHASE HOLD FEATURE SELECTED                                       
C                                                                       
      IF (XBUF(28) .EQ. 1 .AND. ACCYCL(IAC) .LE. 0) THEN                
          WERR = .TRUE.                                                 
          CALL ERGEN ('CKFN47', 5383, IN, XBUF(2), 28, 0, 3)            
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN48 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED   10-30-85 BY A. HALATI                                     
C --- REVISED  9-10-87 BY A. RATHI TO FIX UNCONTROLLED EXE. PROBLEM,    
C ---                     GLOSSARY, ERROR MESSAGES                      
C                                                                       
C --- TITLE   -   CHECK DATA ON TYPE 48 CARDS - MODULE 2261.5261        
C                                                                       
C --- FUNCTION -  THIS MODULE CHECKS FOR INCONSISTENCIES                
C                 AMONG THE DATA ITEMS ON TYPE 48 CARDS.                
C                                                                       
C --- ARGUMENTS - WERR = FLAG (.T., .F.) IF AN ERROR (IS, IS NOT)       
C ---                    DETECTED, WHICH WOULD PREVENT STORING DATA,    
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C --------------------   DESCRIPTION   -------------------------------  
C                        -----------                                    
C                                                                       
C     THIS MODULE CHECKS FOR INCONSISTENCIES BETWEEN CARD               
C     TYPE 48 DATA ITEMS. IT CALLS SUBORDINATE MODULES TO               
C     TEST VALIDITY OF DATA ITEMS. IF ERRORS IN DATA                    
C     SPECIFICATIONS ARE FOUND ERROR MESSAGES ARE PRINTED               
C     AND THE ERROR FLAG IS SET BEFORE CONTROL IS RETURNED              
C     TO THE CALLING MODULE.                                            
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -----------------------  
C                     ----------------------                            
C                                                                       
C                 RDFN48 - MODULE 2261.5.2.6                            
C                                                                       
C -------------------   THIS ROUTINE CALLS   -------------------------  
C                                                                       
C                 TBFN48 - MODULE 2261.5261.1                           
C                 ERGEN  - MODULE 2.6.1.1                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------  
C                                                                       
C     ACTRAM   EMULATION OF MOTOROLLA 6800 RAM MEMORY                   
C     GLOBND   GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE    
C     I        DO LOOP INDEX FOR ENTRIES IN XBUF                        
C     IAC      SUBNETWORK ACTUATED NODE NUMBER                          
C     IN       USER SPECIFIED ACTUATED NODE NUMBER                      
C     INRAM    INDEX TO DATA POSITION IN ACTRAM ARRAY                   
C     IPZBIT   PHASE NUMBER                                             
C     J        DO LOOP INDEX FOR ENTRIES IN XBUF                        
C     KN       SUBNETWORK NODE NUMBER CORRESPONDING TO NODE IN          
C     MXPCD    MAX. NO. OF PED. CONSTANT DEMAND PERIODS IN SUBNETWORK   
C     MXPDFZ   MAXIMUM ALLOWED NUMBER OF PED. PHASES IN SUBNETWORK      
C     NACT     NODE SPECIFIC ARRAY - TYPE OF CONTROL                    
C     NPEDCD   TOTAL NO. OF PED. CONSTANT DEMAND PERIODS  IN SUBNETWORK 
C     NPEDFZ   TOTAL NUMBER OF PED. PHASES IN SUBNETWORK                
C     PERIOD   PED. CONSTANT DEMAND PERIOD NUMBER                       
C     PERMIT   PERMITTED PHASES                                         
C     WERR     FLAG (T, F) IF AN ERROR (IS, IS NOT) DETECT              
C     XBUF     INPUT CARD BUFFER                                        
C                                                                       
C -------------------------------------------------------------------   
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C --- CALL SUBORDINATE MODULE TO TEST QUANTITATIVE BOUNDS OF DATA       
C                                                                       
      CALL TBFN48 (WERR)                                                
      IF (WERR)                                              GO TO 15   
C                                                                       
C --- CHECK THAT THE NODE NUMBER CORRESPONDS TO A PREVIOUSLY DEFINED    
C --- ACTUATED NODE. TRA IF NOT SO.                                     
C                                                                       
      IN = XBUF(1)                                                      
      KN = GLOBND(IN) / 16                                              
      IF (NACT(KN) .LE. 0) THEN                                         
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN48', 3053, IN, 49, 0, 0, 2)                   
      ENDIF                                                             
      IF (WERR)                                              GO TO 10   
C                                                                       
C --- CHECK THAT THE PED. PHASE HAS AN ASSOCIATED VEHICULAR PHASE       
C                                                                       
      IAC = NACT(KN)                                                    
      INRAM = (IAC - 1) * 751                                           
      PERMIT = ACTRAM (INRAM + 496)                                     
      IPZBIT = XBUF(2)                                                  
      IF (MOD (PERMIT / 2**(IPZBIT - 1), 2) .EQ. 0) WERR = .TRUE.       
      IF (WERR) CALL ERGEN ('CKFN48', 2772, IN, IPZBIT, 0, 0, 2)        
   10 CONTINUE                                                          
   15 CONTINUE                                                          
C                                                                       
C --- CHECK THAT BOTH PED RECALL AND PED REST FLAGS ARE NOT SET         
C                                                                       
      IF (XBUF(8) .GT. 0 .AND. XBUF(9) .GT. 0) THEN                     
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN48', 2776, XBUF(1), XBUF(2), 0, 0, 2)         
      ENDIF                                                             
C                                                                       
C --- CHECK THE SEQUENCE OF CONTINUOUS DEMAND PERIOD SPECIFICATIONS.    
C --- ZERO BEGIN AND END TIMES FOR A PERIOD MAY NOT BE FOLLOWED BY NON- 
C --- ZERO ENTRIES FOR OTHER PERIODS. ALSO CHECK THAT THE END TIME IS   
C --- GREATER THAN THE BEGIN TIME OF THE SAME PERIOD.                   
C                                                                       
      PERIOD = 0                                                        
      DO 30 I = 10, 18, 2                                               
         PERIOD = PERIOD + 1                                            
         IF (XBUF(I) .NE. 0 .OR. XBUF(I+1) .NE. 0) THEN                 
            IF (XBUF(I+1) .LE. XBUF(I)) THEN                            
               WERR = .TRUE.                                            
               CALL ERGEN ('CKFN48', 2777, XBUF(1), XBUF(2), PERIOD,    
     1                      0, 3)                                       
            ENDIF                                                       
         ELSE                                                           
            IF (I .LT. 18) THEN                                         
               DO 20 J = I+2, 18, 2                                     
                  IF (XBUF(J) .GT. 0) THEN                              
                     WERR = .TRUE.                                      
                     CALL ERGEN ('CKFN48', 2778, XBUF(1), XBUF(2),      
     1                           PERIOD, (J-10)/2 + 1, 4)               
                  ENDIF                                                 
   20          CONTINUE                                                 
            ENDIF                                                       
         ENDIF                                                          
   30 CONTINUE                                                          
C                                                                       
C --- CHECK FOR OVERLAPING CONSTANT DEMAND PERIODS                      
C                                                                       
      PERIOD = 0                                                        
      DO 40 I = 11, 17, 2                                               
         PERIOD = PERIOD + 1                                            
         IF (XBUF(I) .GT. XBUF(I+1) .AND. XBUF(I+1) .NE. 0) THEN        
            WERR = .TRUE.                                               
            CALL ERGEN ('CKFN48', 2779, XBUF(1), XBUF(2), PERIOD, 0, 3) 
         ENDIF                                                          
   40 CONTINUE                                                          
C                                                                       
C --- CHECK THAT BOTH DETERMINISTIC AND STOCHASTIC ARRIVALS ARE NOT     
C --- SPECIFIED                                                         
C                                                                       
      IF (XBUF(5) .NE. 0 .AND. XBUF(6) .NE. 0) THEN                     
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN48', 2774, XBUF(1), XBUF(2), 0, 0, 2)         
      ENDIF                                                             
C                                                                       
C --- CHECK THAT AN INTITIAL PED. ARRIVAL TIME IS ONLY SPECIFIED WHEN   
C --- THE ARRIVALS ARE DETERMINISTIC                                    
C                                                                       
      IF (XBUF(5) .NE. 0 .AND. XBUF(7) .NE. 0) THEN                     
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN48', 2775, XBUF(1), XBUF(2), 0, 0, 2)         
      ENDIF                                                             
C                                                                       
C --- CHECK THAT THE TOTAL NUMBER OF PED. PHASES IN THE SUBNETWORK DOES 
C --- NOT EXCEED THE MAXIMUM ALLOWED.                                   
C                                                                       
      IF (NPEDFZ .GE. MXPDFZ) THEN                                      
         WERR = .TRUE.                                                  
         CALL ERGEN ('CKFN48', 2780, MXPDFZ, 0, 0, 0, 1)                
      ENDIF                                                             
C                                                                       
C --- COUNT THE NUMBER OF CONSTANT DEMAND PERIODS ON THIS DATA CARD AND 
C --- CHECK THAT THE TOTAL NUMBER OF CONSTANT DEMAND PERIODS DOES NOT   
C --- EXCEED THE MAX. ALLOWABLE.                                        
C                                                                       
      PERIOD = 0                                                        
      DO 50 I = 10, 18, 2                                               
         IF (XBUF(I) .NE. 0 .AND. XBUF(I+1) .NE. 0) THEN                
            PERIOD = PERIOD + 1                                         
            IF (NPEDCD + PERIOD .GT. MXPCD) THEN                        
               WERR = .TRUE.                                            
               CALL ERGEN ('CKFN48', 2781, MXPCD, 0, 0, 0, 1)           
            ENDIF                                                       
         ENDIF                                                          
   50 CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN54 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    6-01-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON CARD TYPE 54 -               
C ---         MODULE 2261.6.4.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG           
C ---            THE DATA ITEMS ON CARD TYPE 54.                        
C                                                                       
C --- ARGUMENTS - WERR = ARRAY OF ERROR FLAGS TO THE CALLING ROUTINE    
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 54 IS IN THE BUFFER.      
C     THIS ROUTINE WILL CALL A SUBROUTINE TO TEST THE BOUNDS OF EACH    
C     DATA ITEM ON THE CARD AND UPON RETURNING CHECK FOR                
C     INCONSISTENCIES AMONG THE DATA ITEMS                              
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN54 - MODULE 2261.6.4                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    NLKNUM - MODULE 2261.3112                          
C                    TBFN54 - MODULE 2261.6411                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    -------------------------                          
C                                                                       
C     I       DO LOOP INDEX, LINK ON CARD BEING CHECKED                 
C     IL      LINK NUMBER                                               
C     J       XBUF INDEX TO UPSTREAM NODE OF LINK BEING CHECKED         
C     SHEVNT  LINK SPECIFIC ARRAY - DURATION AND FREQ OF EVENT(IN SEC)  
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION WERR(4)                                                 
C                                                                       
C -----  LOOP OVER ALL LINKS ON CARD TRA IF LINK DOES NOT EXIST         
C                                                                       
      J = -3                                                            
         DO 20 I = 1, 4                                                 
            J = J + 4                                                   
            WERR(I) = .TRUE.                                            
            IF (XBUF(J) .EQ. 0 .AND. XBUF(J+1) .EQ. 0)       GO TO 10   
            WERR(I) = .FALSE.                                           
C                                                                       
C -----  TEST BOUNDS OF DATA ITEMS                                      
C                                                                       
            CALL TBFN54 (J)                                             
C                                                                       
C -----  GET LINK NUMBER AND GENERATE ERROR MESSAGE IF LINK DOES        
C -----  NOT EXIST.                                                     
C                                                                       
            CALL NLKNUM(IL, XBUF(J), XBUF(J+1))                         
            IF (IL .LE. 0) CALL ERGEN ('CKFN54', 4005, XBUF(J),         
     1                                  XBUF(J+1), 54, 0, 3)            
            IF (IL .LE. 0) WERR(I) = .TRUE.                             
            IF (IL .GT. 0 .AND. SHEVNT(IL) .GT. 0)                      
     1          CALL ERGEN ('CKFN54', 4004, XBUF(J), XBUF(J+1),         
     2                      0, 0, 2)                                    
   10       CONTINUE                                                    
   20    CONTINUE                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN55 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    6-06-79 BY M. MASSUCCI                                   
C --- REVISED  1-19-92 BY M. SEELEY TO ACCEPT BLOCKAGE DATA FOR         
C ---                  A MICRO-INTERSECTION                             
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON CARD TYPE 55 -               
C ---         MODULE 2261.6.5.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 55                             
C                                                                       
C --- ARGUMENTS - WERR = ARRAY OF ERROR FLAGS TO THE CALLING ROUTINE    
C                                                                       
C ------------------------    DESCRIPTION   ----------------------------
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A CARD TYPE 55 IS IN THE BUFFER.       
C     FOR EACH LINK INPUT ON A TYPE 55 CARD MODULE TBFN55 IS CALLED     
C     TO TEST BOUNDS OF EACH DATA ITEM AND MODULE LKNUM IS CALLED TO    
C     GET THE LINK NUMBER CORRESPONDING TO THE NODES DEFINING THE LINK. 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   -----------------------
C                       ----------------------                          
C                                                                       
C                    RDFN55 - MODULE 2261.6.5                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   -------------------------
C                         -------------------                           
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                    NLKNUM - MODULE 2261.3112                          
C                    TBFN55 - MODULE 2261.6511                          
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   ----------------------
C                    --------------------------                         
C                                                                       
C     GLOBND  GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE     
C     I       DO LOOP INDEX INDICATING LINK ON CARD                     
C     ICODE   CODE (0, 1) IF EVENT (IS NOT, IS) WITHIN INTERSECTION     
C     IFLANE  NUMBER OF FULL LANES ON LINK IL                           
C     IL      SUBNETWORK LINK NUMBER                                    
C     ILANA   LANE NUMBER OF APPROACH TO INTERSECTION                   
C     IN      SUBNETWORK NODE NUMBER CORRESPONDING TO NODE KN           
C     IPLANE  TOTAL NUMBER OF POCKET LANES ON LINK IL                   
C     JL      INDEX TO XBUF ARRAY OF FIRST DATA ITEM FOR LINK I         
C     LANEGD  LINK SPECIFIC ARRAY - NUMBER OF FULL AND POCKET LANES.    
C     SIGT    NODE SPECIFIC ARRAY - CURRENT SIGNAL STATUS AND WHETHER   
C             NODE IN IS TO BE MODELLED AS A MICRONODE                  
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R,Z), LOGICAL (W, Y)        
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION WERR (3)                                                
C                                                                       
C -----  SET DATA INDICATOR, JL. CHECK ALL LINKS ON CARD. SET           
C -----  ERROR FLAG TO TRUE ASSUMING LINK I NOT SPECIFIED.              
C                                                                       
      JL = -4                                                           
         DO 20 I = 1, 3                                                 
            WERR (I) = .TRUE.                                           
            JL = JL + 5                                                 
            IF (XBUF(JL) .EQ. 0 .AND. XBUF(JL+1) .EQ. 0)     GO TO 10   
            WERR (I) = .FALSE.                                          
C                                                                       
C -----  TEST EACH DATA ITEM ON LINK.                                   
C                                                                       
            CALL TBFN55 (JL)                                            
C                                                                       
C -----  GET LINK NUMBER. IF LINK DOES NOT EXIST PRINT ERROR MESSAGE.   
C -----  RESET ERROR FLAG TRUE.                                         
C                                                                       
            CALL NLKNUM(IL, XBUF(JL), XBUF(JL+1))                       
            IF (IL .LE. 0) CALL ERGEN ('CKFN55', 4005, XBUF(JL),        
     1                                  XBUF(JL+1), 55, 0, 3)           
            IF (IL .LE. 0) WERR (I) = .TRUE.                            
C                                                                       
C -----  IF EVENT IS TO OCCUR IN INTERSECTION (I.E., COLUMN 18 IS 1),   
C -----  THEN DOWNSTREAM NODE OF LINK MUST BE A MICRO-NODE. IF NOT,     
C -----  PRINT ERROR MESSAGE.                                           
C                                                                       
            ICODE = XBUF(JL+4) / 100                                    
            ILANA = MOD(XBUF(JL+4), 10)                                 
            IN = GLOBND(XBUF(JL+1)) / 16                                
            IF (ICODE .EQ. 1 .AND. MOD (SIGT(IN)/2**12, 2) .NE. 1)      
     1      CALL ERGEN ('CKFN55', 2097, XBUF(JL), XBUF(JL+1), 0, 0, 2)  
C                                                                       
C -----  GET NUMBER OF FULL LANES AND TOTAL NUMBER OF POCKET LANES ON   
C -----  LINK AND CHECK THAT EVENT OCCURS ON AN EXISTING LANE, AND THAT 
C -----  EVENTS WITHIN INTERSECTION ARE SPECIFIED BY AN EXISTING LANE   
C -----  ON THE CROSS STREET OR 0.                                      
C                                                                       
            IFLANE = MOD (LANEGD(IL) / 2**3, 2**3)                      
            IPLANE = MOD (LANEGD(IL) / 2**6, 2**2) +                    
     1               MOD (LANEGD(IL) / 2**8, 2**2)                      
            IF (ILANA .GT. IFLANE.AND. ILANA .LT. 8-IPLANE)             
     1      CALL ERGEN ('CKFN55', 4012, XBUF(JL), XBUF(JL+1),           
     2                  ILANA, 0, 3)                                    
   10       CONTINUE                                                    
   20    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN58 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    7-03-80 BY M. YEDLIN                                     
C                                                                       
C --- TITLE - CHECK DATA ON CARD TYPE 58 - MODULE 2261.6.8.1            
C                                                                       
C --- FUNCTION - THIS MODULE PERFORMS ALL CONSISTENCY AND QUANTITATIVE  
C ---            BOUNDS CHECKS ON CARD TYPE 58 DATA.                    
C                                                                       
C --- ARGUMENTS - WERR = ERROR FLAG (T,F) IF VEHICLE TYPE NUMBER        
C ---                    (IS,NOT) IN ERROR                              
C ---                    SENT TO CALLING ROUTINE                        
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CHECKS THE CONSISTENCY AND QUANTITATIVE BOUNDS OF     
C     THE DATA ON CARD TYPE 58.                                         
C                                                                       
C -------------------  THIS ROUTINE CALLED BY   ----------------------- 
C                      ----------------------                           
C                                                                       
C                    RDFN58 - MODULE 2261.6.8                           
C                                                                       
C ----------------------   THIS ROUTINE CALLS   ----------------------- 
C                          ------------------                           
C                                                                       
C                    ERGEN - MODULE 2.6.1.1                             
C                                                                       
C -----------------    GLOSSARY OF VARIABLE NAMES   ------------------- 
C                      --------------------------                       
C                                                                       
C     I       INDEX TO CARD CONTENTS IN BUFFER ARRAY                    
C     ITYP    VEHICLE TYPE                                              
C     UNITIN  NETSIM INPUT CODE (0,1) FOR (ENGLISH,METRIC) UNITS INPUT  
C     VTYPLD  VEHICLE TYPE ARRAY - PERSON OCCUPANCY                     
C     WERR    FLAG (T,F) IF VEH TYPE NO. (IS, ISNT) IN ERROR            
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO   
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)           
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  TRA IF ENGLISH UNITS INPUT. ELSE, CONVERT METRIC UNITS TO      
C -----  ENGLISH AND PUT BACK IN BUFFER                                 
C                                                                       
      IF (UNITIN .EQ. 0)                                     GO TO 5    
      XBUF(2) = ZCNVRT(4) * FLOAT (XBUF(2)) + 0.5                       
      XBUF(3) = ZCNVRT(5) * FLOAT (XBUF(3)) + 0.5                       
      XBUF(4) = ZCNVRT(5) * FLOAT (XBUF(4)) + 0.5                       
    5 CONTINUE                                                          
C                                                                       
C -----  OUTPUT MESSAGE WHEN AN INVALID VEHICLE TYPE WAS SPECIFIED      
C -----  OR A PRIOR TYPE 58 CARD WAS SPECIFIED FOR THE SAME             
C -----  VEHICLE TYPE.                                                  
C                                                                       
      ITYP = XBUF(1)                                                    
      WERR = ITYP .LT. 1 .OR. ITYP .GT. 16                              
      IF (WERR) CALL ERGEN ('CKFN58', 4151, ITYP, 0, 0, 0, 1)           
      IF (.NOT. WERR .AND. VTYPLD(ITYP) .GT. 0) CALL ERGEN              
     1        ('CKFN58', 4152, ITYP, 0, 0, 0, 1)                        
C                                                                       
C -----  OUTPUT MESSAGE WHEN VEHICLE LENGTH OUT OF BOUNDS.              
C                                                                       
      IF (XBUF(2) .LT. 10 .OR. XBUF(2) .GT. 125) CALL ERGEN             
     1        ('CKFN58', 4153, XBUF(2), ITYP, 0, 0, 2)                  
C                                                                       
C -----  OUTPUT MESSAGE WHEN MAXIMUM ACCELERATION * 10 IS OUT OF BOUNDS 
C                                                                       
      IF (XBUF(3) .LT. 20  .OR.  XBUF(3) .GT. 86) CALL ERGEN            
     1        ('CKFN58', 4154, XBUF(3), ITYP, 0, 0, 2)                  
C                                                                       
C -----  OUTPUT MESSAGE WHEN MAXIMUM SPEED IS OUT OF BOUNDS.            
C                                                                       
      IF (XBUF(4) .LT. 25 .OR. XBUF(4) .GT. 125) CALL ERGEN             
     1        ('CKFN58', 4155, XBUF(4), ITYP, 0, 0, 2)                  
C                                                                       
C -----  OUTPUT MESSAGE WHEN QUEUE DISCHARGE FACTOR IS OUT OF BOUNDS.   
C -----  SET DEFAULT VALUE WHEN QUEUE DISCHARGE FACTOR IS OMITTED       
C                                                                       
      IF (XBUF(5) .NE. 0 .AND. (XBUF(5) .LT. 50 .OR. XBUF(5) .GT. 500)) 
     1        CALL ERGEN ('CKFN58', 4156, XBUF(5), ITYP, 0, 0, 2)       
      IF (XBUF(5) .EQ. 0) XBUF(5) = -100                                
C                                                                       
C -----  CHECK ALL FLEET COMPONENT PERCENTAGES. INPUT VALUES            
C -----  MUST BE BETWEEN 0 AND 100 PERCENT.                             
C                                                                       
         DO 20 I = 11, 14                                               
            IF (XBUF(I) .LT. 0 .OR. XBUF(I) .GT. 100) CALL ERGEN        
     1        ('CKFN58', 4157, XBUF(I), I-5, ITYP, 0, 3)                
   20    CONTINUE                                                       
C                                                                       
C -----  OUTPUT MESSAGE WHEN AVG. PERSON OCCUPANCY * 100 IS             
C -----  TOO LOW                                                        
C                                                                       
      IF (XBUF(19) .LT. 100) CALL ERGEN                                 
     1        ('CKFN58', 4158, XBUF(19), ITYP, 0, 0, 2)                 
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN60 (WERR)                                          
C                                                                       
C --- CODED   12-03-79 BY M. MASSUCCI                                   
C --- REVISED  2-28-92 BY J. COTTON FOR CHANGE IN CARD FORMAT           
C                                                                       
C --- TITLE - CHECK VALIDITY OF DATA ON CARD TYPE 60 - MODULE 2261.8.1  
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE VALIDITY OF EACH DATA ITEM      
C ---            ON CARD TYPE 60                                        
C                                                                       
C --- ARGUMENTS - WERR = FLAG SET TRUE IF INFORMATION IS INVALID,       
C ---                    TO THE CALLING ROUTINE                         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CHECKS THE VALIDITY OF EACH DATA ITEM ON CARD TYPE 60.
C     A SUBORDINATE MODULE IS CALLED TO PRINT AN ERROR MESSAGE WHEN     
C     NECESSARY.                                                        
C                                                                       
C -------------------  THIS ROUTINE CALLED BY   ----------------------- 
C                      ----------------------                           
C                                                                       
C                    RDFN60 - MODULE 2261.8                             
C                                                                       
C ----------------------   THIS ROUTINE CALLS   ----------------------- 
C                          ------------------                           
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C -----------------    GLOSSARY OF VARIABLE NAMES   ------------------- 
C                      --------------------------                       
C                                                                       
C     WTABL   FLAG (T,F) IF TABLE CODE (IS,IS NOT) IN ERROR             
C     WTYP    FLAG (T,F) IF TYPE CODE (IS, IS NOT) IN ERROR             
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C --- INITIALIZE ERROR FLAG TO 'NO ERRORS FOUND'                        
C                                                                       
      WERR = .FALSE.                                                    
C                                                                       
C --- CHECK THAT DATA TYPE CODE IS IN RANGE 0 TO 3.                     
C                                                                       
      IF (XBUF(1) .LT. 0 .OR. XBUF(1) .GT. 3) THEN                      
         CALL ERGEN ('CKFN60', 4100, XBUF(1), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C --- CHECK THAT VEHICLE TYPE CODE IS IN RANGE 1 TO 3.                  
C                                                                       
      IF (XBUF(2) .LT. 1 .OR. XBUF(2) .GT. 3) THEN                      
         CALL ERGEN ('CKFN60', 4105, XBUF(2), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C --- CHECK THAT SPEED OF VEHICLE IS IN RANGE 0 TO 70.                  
C                                                                       
      IF (XBUF(3) .LT. 0 .OR. XBUF(3) .GT. 70) THEN                     
         CALL ERGEN ('CKFN60', 4115, XBUF(3), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C --- CHECK ACCELERATION/DECELERATION CODE IS O OR 1                    
C                                                                       
      IF (XBUF(4) .NE. 0 .AND. XBUF(4) .NE. 1) THEN                     
         CALL ERGEN ('CKFN60', 4120, XBUF(4), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C --- TEST EACH ITEM WHICH WILL REPLACE DATA IN APPROPRIATE TABLE.      
C --- ONLY GO TO ENTRY 13 IF ENTRY 4 SET TO 'DECELERATION'              
C --- RESET ERROR FLAG, TRUE, IF DATA IS INVALID (NEGATIVE).            
C                                                                       
      DO 10 ID = 5, 14 - XBUF(4)                                        
         IF (XBUF(ID) .LT. 0) THEN                                      
            CALL ERGEN ('CKFN60', 4110, XBUF(ID), ID, 0, 0, 2)          
            WERR = .TRUE.                                               
         ENDIF                                                          
   10 CONTINUE                                                          
C                                                                       
C --- IF DECELERATION SPECIFIED, ENTRY 14 MUST BE BLANK OR 0            
C                                                                       
      IF (XBUF(4) .EQ. 1 .AND. XBUF(14) .NE. 0) THEN                    
         CALL ERGEN ('CKFN60', 4121, XBUF(14), XBUF(4), 0, 0, 2)        
         WERR = .TRUE.                                                  
      ENDIF                                                             
      RETURN                                                            
      END                                                               
      SUBROUTINE CKFN96 (WCERR)                                         
C                                                                       
C                                                                       
C --- CODED    5-3-91 BY J. WERK                                        
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON TYPE 96 CARDS -              
C ---         MODULE 2261.11.3.1                                        
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 96.                            
C                                                                       
C --- ARGUMENTS - WCERR  = FLAG INDICATING WHETHER ANY ERRORS WERE      
C                          FOUND, FROM AND TO CALLING ROUTINE           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 96 IS ASSUMED IN THE      
C     BUFFER.  A SUBROUTINE IS THEN CALLED TO CHECK EACH ITEM ON THE    
C     CARD.  ANOTHER SUBROUTINE IS CALLED TO GET LINK NUMBER.  WHEN     
C     CONTROL RETURNS, THIS ROUTINE WILL THEN CHECK FOR INCONSISTENCIES 
C     BETWEEN RELATED ITEMS ON THE CARD.                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN96 - MODULE 2261.11.3                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN96 - MODULE 2261.11311                         
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK           
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     ICHG    INTERCHANGE NUMBER                                        
C     II      INDEX TO DO LOOP                                          
C     IL      ENTRY APPROACH TO INTERCHANGE LINK NUMBER                 
C     ILAST   POINTER TO LAST WORD IN XNCGLK ARRAY FOR INTERCHANGE ICHG 
C     ILD     DESTINATION LINK NUMBER                                   
C     IL2     LINK NUMBER                                               
C     INUM    NUMBER OF LINKS IN INTERCHANGE ICHG                       
C     J       POINTER TO FIRST WORD IN XNCGLK ARRAY FOR INTERCHANGE ICHG
C     K       INDEX FOR DO LOOP                                         
C     K2      INDEX FOR DO LOOP                                         
C     K3      INDEX FOR DO LOOP                                         
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK            
C     NCGLNK  POINTER TO FIRST ELEMENT IN XNCGLK PERTAINING TO          
C             INTERCHANGE ICHG                                          
C     NUMLNK  NUMBER OF LINKS IN INTERCHANGE ICHG                       
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK                 
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     WAPPR   FLAG (T, F) IF APPROACH LINK SPECIFIED (IS, ISN'T) AN     
C             APPROACH TO THE INTERCHANGE                               
C     WDEST   FLAG (T, F) IF DESTINATION LINK SPECIFIED (IS, ISN'T) A   
C             DESTINATION LINK TO THE INTERCHANGE                       
C     WERR    FLAG INDICATING WHETHER AN ERROR WAS ENCOUNTERED          
C     WERRD   FLAG INDICATING WHETHER AN ERROR WAS ENCOUNTERED RELATED  
C             TO DESTINATION NODE                                       
C     WERRT   FLAG INDICATING WHETHER AN ERROR WAS ENCOUNTERED RELATED  
C             TO TURN CODE                                              
C     WMATCH  FLAG INDICATING WHETHER LINK WAS DEFINED TO BE IN         
C             INTERCHANGE                                               
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     XNCGLK  CONTAINS UP TO 3 LINK NUMBERS OF LINKS WITHIN AN          
C             INTERCHANGE                                               
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  CALL ROUTINE TO CHECK BOUNDS OF EACH ITEM, CHECK THAT          
C -----  INTERCHANGE WAS PREVIOUSLY DEFINED ON A TYPE 95 CARD AND       
C -----  GET LINK NUMBER.                                               
C                                                                       
      WERR = .FALSE.                                                    
      CALL TBFN96 (WCERR)                                               
      IF (NCGLNK(XBUF(1)) .EQ. 0) THEN                                  
         CALL ERGEN ('CKFN96', 5343, XBUF(1), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
      CALL NLKNUM (IL, XBUF(2), XBUF(3))                                
C                                                                       
C -----  OUTPUT MESSAGE IF LINK WAS NOT ALREADY DEFINED BY A            
C -----  TYPE 11 CARD AND TRA.                                          
C                                                                       
      IF (IL .EQ. 0) THEN                                               
         CALL ERGEN ('CKFN96', 5338, XBUF(2), XBUF(3), XBUF(1), 0, 3)   
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C -----  IF NO ERRORS WERE FOUND, CHECK THAT APPROACH LINK IS WITHIN THE
C -----  INTERCHANGE AS DEFINED ON 95 CARD AND THAT IT IS AN ENTRY LINK 
C -----  TO THE INTERCHANGE.                                            
C                                                                       
      IF (.NOT. WERR) THEN                                              
         ICHG = XBUF(1)                                                 
         J = NCGLNK(ICHG)                                               
         INUM = NUMLNK(ICHG)                                            
         WMATCH = .FALSE.                                               
         IF (MOD(INUM, 3) .NE. 0) THEN                                  
            ILAST = INUM/3 + J                                          
         ELSE                                                           
            ILAST = INUM/3 + J - 1                                      
         ENDIF                                                          
            DO 60 K = J, ILAST                                          
                  DO 50 II = 1, 3                                       
                     IL2 = MOD(XNCGLK(K), 2**(10*II)) / 2**(10*(II-1))  
                     IF (IL .EQ. IL2) THEN                              
                        WMATCH = .TRUE.                                 
                                                             GO TO 70   
                     ENDIF                                              
   50             CONTINUE                                              
   60       CONTINUE                                                    
   70    CONTINUE                                                       
         IF (.NOT. WMATCH) THEN                                         
            CALL ERGEN ('CKFN96', 5345, XBUF(2), XBUF(3), XBUF(1), 0, 3)
            WERR = .TRUE.                                               
         ELSE                                                           
            WAPPR = .FALSE.                                             
               DO 100 K2 = 1, TTLNK                                     
                  IF (LEFT(K2) .EQ. IL) WAPPR = .TRUE.                  
                  IF (THRU(K2) .EQ. IL) WAPPR = .TRUE.                  
                  IF (ARIGHT(K2) .EQ. IL) WAPPR = .TRUE.                
                  IF (DIAGNL(K2) .EQ. IL) WAPPR = .TRUE.                
                  IF (WAPPR) THEN                                       
                     DO 90 K = J, ILAST                                 
                           DO 80 II = 1, 3                              
                              IL2 = MOD(XNCGLK(K),2**(10*II)) /         
     1                                            2**(10*(II-1))        
                              IF (K2 .EQ. IL2) WAPPR = .FALSE.          
   80                      CONTINUE                                     
   90                CONTINUE                                           
                  ENDIF                                                 
                  IF (WAPPR)                        GO TO 110           
  100          CONTINUE                                                 
               CALL ERGEN ('CKFN96', 5346, XBUF(2), XBUF(3), XBUF(1),   
     1                     0, 3)                                        
               WERR = .TRUE.                                            
  110          CONTINUE                                                 
         ENDIF                                                          
      ENDIF                                                             
      IF (WERR) WCERR = .TRUE.                                          
C                                                                       
C -----  CHECK THAT ALL DESTINATION LINKS ARE PART OF THE INTERCHANGE   
C -----  AND NONE OF THEIR RECEIVER LINKS ARE WITHIN THE INTERCHANGE    
C                                                                       
         DO 210 K = 4, 19, 4                                            
            WERRD = .FALSE.                                             
            WERRT = .FALSE.                                             
            IF (XBUF(K) .NE. 0 .AND. XBUF(K+1) .NE. 0) THEN             
               CALL NLKNUM (ILD, XBUF(K), XBUF(K+1))                    
               IF (ILD .EQ. 0) THEN                                     
                  CALL ERGEN('CKFN96',5338, XBUF(K), XBUF(K+1), XBUF(1),
     1                       0, 3)                                      
                  WERRD = .TRUE.                                        
               ENDIF                                                    
               IF (.NOT. WERR .AND. (.NOT. WERRD)) THEN                 
                  WMATCH = .FALSE.                                      
                     DO 150 K2 = J, ILAST                               
                           DO 140 II = 1, 3                             
                              IL2 = MOD(XNCGLK(K2), 2**(10*II)) /       
     1                                  2**(10*(II-1))                  
                              IF (ILD .EQ. IL2) THEN                    
                                 WMATCH = .TRUE.                        
                                                             GO TO 160  
                              ENDIF                                     
  140                      CONTINUE                                     
  150                CONTINUE                                           
  160             CONTINUE                                              
                  IF (.NOT. WMATCH) THEN                                
                     CALL ERGEN ('CKFN96', 5348, XBUF(K), XBUF(K+1),    
     1                            XBUF(1), 0, 3)                        
                     WERRD = .TRUE.                                     
                  ELSE                                                  
                     WDEST = .FALSE.                                    
                        DO 190 K2 = 1, TTLNK                            
                           IF (LEFT(ILD) .EQ. K2 .OR. (LEFT(ILD) .GE.   
     1                         8000 .AND. LEFT(ILD) .LE. 8999))         
     2                         WDEST = .TRUE.                           
                           IF (THRU(ILD) .EQ. K2 .OR. (THRU(ILD) .GE.   
     1                         8000 .AND. THRU(ILD) .LE. 8999))         
     2                         WDEST = .TRUE.                           
                           IF (ARIGHT(ILD) .EQ. K2 .OR. (ARIGHT(ILD).GE.
     1                         8000 .AND. ARIGHT(ILD) .LE. 8999))       
     2                         WDEST = .TRUE.                           
                           IF (DIAGNL(ILD) .EQ. K2 .OR. (DIAGNL(ILD).GE.
     1                         8000 .AND. DIAGNL(ILD) .LE. 8999))       
     2                         WDEST = .TRUE.                           
                           IF (WDEST) THEN                              
                              DO 180 K3 = J, ILAST                      
                                    DO 170 II = 1, 3                    
                                       IL2 = MOD(XNCGLK(K3),            
     1                                      2**(10*II)) / 2**(10*(II-1))
                                       IF (K2 .EQ. IL2) WDEST = .FALSE. 
  170                               CONTINUE                            
  180                         CONTINUE                                  
                           ENDIF                                        
                           IF (WDEST)                        GO TO 200  
  190                   CONTINUE                                        
                     CALL ERGEN ('CKFN96', 5349, XBUF(K), XBUF(K+1),    
     1                            XBUF(1), 0, 3)                        
                     WERRD = .TRUE.                                     
  200                CONTINUE                                           
                  ENDIF                                                 
               ENDIF                                                    
C                                                                       
C -----  CHECK THAT IF DESTINATION LINK WAS ENTERED AND NO ERRORS WERE  
C -----  FOUND, TURN MOVEMENT CODE AND TURNING PERCENTAGE WERE ALSO     
C -----  ENTERED.                                                       
C                                                                       
               IF (.NOT. WERRD) THEN                                    
                  IF (XBUF(K+2) .EQ. 0) THEN                            
                     CALL ERGEN ('CKFN96', 5350, XBUF(K), XBUF(K+1),    
     1                            XBUF(1), 0, 2)                        
                     WERRT = .TRUE.                                     
                  ENDIF                                                 
                  IF (XBUF(K+2) .NE. 0) THEN                            
                     IF (XBUF(K+2) .EQ. 1) THEN                         
                        IF (LEFT(ILD) .EQ. 0) THEN                      
                            CALL ERGEN ('CKFN96', 5352, XBUF(K+2),      
     1                            XBUF(K), XBUF(K+1), XBUF(1), 4)       
                            WERRT = .TRUE.                              
                        ENDIF                                           
                     ELSEIF (XBUF(K+2) .EQ. 2) THEN                     
                        IF (THRU(ILD) .EQ. 0) THEN                      
                           CALL ERGEN ('CKFN96', 5352, XBUF(K+2),       
     1                                  XBUF(K), XBUF(K+1), XBUF(1), 4) 
                           WERRT = .TRUE.                               
                        ENDIF                                           
                     ELSEIF (XBUF(K+2) .EQ. 3) THEN                     
                        IF (ARIGHT(ILD) .EQ. 0) THEN                    
                           CALL ERGEN ('CKFN96', 5352, XBUF(K+2),       
     1                                  XBUF(K), XBUF(K+1), XBUF(1), 4) 
                           WERRT = .TRUE.                               
                        ENDIF                                           
                     ELSEIF (XBUF(K+2) .EQ. 4) THEN                     
                        IF (DIAGNL(ILD) .EQ. 0) THEN                    
                           CALL ERGEN ('CKFN96', 5352, XBUF(K+2),       
     1                                  XBUF(K), XBUF(K+1), XBUF(1), 4) 
                           WERRT = .TRUE.                               
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
               ENDIF                                                    
            ELSE                                                        
               IF (XBUF(K+2) .NE. 0) THEN                               
                  CALL ERGEN ('CKFN96', 5356, K+2, XBUF(1), 0, 0, 2)    
                  WERRT = .TRUE.                                        
               ENDIF                                                    
               IF (XBUF(K+3) .NE. 0) THEN                               
                  CALL ERGEN ('CKFN96', 5357, K+3, XBUF(1), 0, 0, 2)    
                  WERRT = .TRUE.                                        
               ENDIF                                                    
            ENDIF                                                       
            IF (WERRD .OR. WERRT) WCERR = .TRUE.                        
  210    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN50 (WERR)                                           
C                                                                       
C                                                                       
C --- CODED    3-21-78 BY M. SINGER                                     
C --- REVISED  9-12-79 BY B. ANDREWS (FOR NETSIM)                       
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 50 - MODULE        
C ---         2261.6.1.1                                                
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---          ITEMS ON CARD TYPE 50                                    
C                                                                       
C --- ARGUMENTS - WERR = ARRAY OF ERROR AND EXISTENCE FLAGS             
C ---                    TO CALLING ROUTINE                             
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     FOR EACH OF THREE LINKS ON A CARD, MODULE 2261.6111 IS CALLED TO  
C     CHECK EACH DATA ITEM. MODULE 2261.3112 IS CALLED TO GET THE LINK  
C     NUMBER AND CHECK ITS EXISTENCE ON THE SUBNETWORK                  
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN50  - MODULE 2261.6.1                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    NLKNUM - MODULE 2261.3112                          
C                    TBN50  - MODULE 2261.6111                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     IL      LINK NUMBER ON SUBNETWORK                                 
C     ISUB    POINTER TO XBUF                                           
C     JL      LOOP INDEX FOR LINK ON CARD                               
C     LANEGD  LINK SPECIFIC ARRAY - SET NEGATIVE IF TYPE 50 CARD INPUT  
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION WERR(3)                                                 
C                                                                       
C -----  LOOP OVER LINKS ON CARD AND TRA IF LINK DOES NOT EXIST         
C                                                                       
      ISUB = -4                                                         
         DO 30 JL = 1, 3                                                
            ISUB = ISUB + 5                                             
            WERR(JL) = .TRUE.                                           
            IF (XBUF(ISUB) .EQ. 0 .AND. XBUF(ISUB+1) .EQ. 0) GO TO 20   
            WERR(JL) = .FALSE.                                          
C                                                                       
C -----  CHECK EACH DATA ITEM                                           
C                                                                       
            CALL TBN50 (JL)                                             
C                                                                       
C -----  GET AND CHECK LINK NUMBER( PRINT ERROR MESSAGE AND SET ERROR   
C -----  FLAG IF LINK DOES NOT EXIST ON SUBNETWORK)                     
C                                                                       
            CALL NLKNUM(IL, XBUF(ISUB), XBUF(ISUB+1) )                  
            IF (IL .LE. 0) CALL ERGEN ('CKN50 ', 2530, XBUF(ISUB),      
     1               XBUF(ISUB+1), 0, 0, 2)                             
            IF (IL .LE. 0) WERR(JL) = .TRUE.                            
C                                                                       
C -----  OUTPUT MESSAGE IF VOLUME IS ZERO AND PERCENT CARPOOLS          
C -----  OR TRUCKS WAS INPUT                                            
C                                                                       
            IF (XBUF(ISUB+2) .EQ. 0 .AND.                               
     1         (XBUF(ISUB+3) .NE. 0 .OR. XBUF(ISUB+4) .NE. 0) )         
     2         CALL ERGEN ('CKN50 ', 252, XBUF(ISUB),                   
     3         XBUF(ISUB+1), 0, 0, 2)                                   
C                                                                       
C -----  OUTPUT MESSAGE IF SUM OF CARPOOL AND TRUCK PERCENTS            
C -----  EXCEEDS 100                                                    
C                                                                       
            IF (XBUF(ISUB+3) + XBUF(ISUB+4) .GT. 100) CALL ERGEN        
     1          ('CKN50 ', 2570, XBUF(ISUB), XBUF(ISUB+1),              
     2         XBUF(ISUB+3), XBUF(ISUB+4), 4)                           
C                                                                       
C -----  CHECK FOR DUPLICATE TYPE 50 CARD.  LANEGD WILL BE              
C -----  NEGATIVE IF A 50 CARD HAS ALREADY BEEN INPUT (DURING           
C -----  THIS TP)                                                       
C                                                                       
            IF (IL .GT. 0 .AND. LANEGD(IL) .LT. 0)                      
     1          CALL ERGEN ('CKN50 ', 2501, XBUF(ISUB),                 
     2                      XBUF(ISUB+1), 50, 0, 3)                     
   20       CONTINUE                                                    
   30    CONTINUE                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN51 (WEX)                                            
C                                                                       
C                                                                       
C --- CODED    4-28-78 BY M. SINGER                                     
C --- REVISED  9-12-79 BY B.ANDREWS (FOR NETSIM)                        
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 51 - MODULE        
C ---         2261.6.2.1                                                
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG           
C ---            THE DATA ITEMS ON CARD TYPE 51                         
C                                                                       
C --- ARGUMENTS - WEX = ARRAY OF FLAGS SET TRUE IF LINK SPECIFIED       
C ---                   ON CARD - TO CALLING ROUTINE                    
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     SUBORDINATE MODULE 2261.6211 IS CALLED TO CHECK THE ITEMS         
C     ON THE CARD.                                                      
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN51  - MODULE 2261.6.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBN51  - MODULE 2261.6211                          
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     IP      POINTER TO XBUF                                           
C     JL      DO LOOP INDEX FOR LINKS ON CARD                           
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
      DIMENSION WEX(4)                                                  
C                                                                       
C -----  LOOP OVER LINKS ON CARD. IF LINK SPECIFIED ON CARD SET FLAG    
C -----  AND CALL MODULE TO CHECK BOUNDS                                
C                                                                       
      IP = -2                                                           
         DO 10 JL = 1, 4                                                
            IP = IP + 4                                                 
            WEX(JL) = XBUF(IP) .NE. 0 .AND. XBUF(IP+1) .NE. 0           
            IF (WEX(JL)) CALL TBN51 (JL)                                
   10    CONTINUE                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN52                                                  
C                                                                       
C                                                                       
C --- CODED    4-28-78 BY M. SINGER                                     
C --- REVISED  9-12-79 BY B. ANDREWS (FOR NETSIM)                       
C --- REVISED  3-20-92 BY A. KANAAN TO SET BUSES TO I5 FORMAT           
C                                                                       
C --- TITLE - CHECK CONSISTENCY AND BOUNDS OF DATA IN CARD TYPE 52 -    
C ---         MODULE 2261.6.3.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS                                     
C ---            THE DATA ITEMS ON CARD TYPE 52                         
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     FOR EACH ITEM ON CARD TYPE 52 THAT IS OUTSIDE ITS ALLOWED         
C     RANGE, AN ERROR MESSAGE IS PRINTED                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN52  - MODULE 2261.6.3.1                         
C                                                                       
C --------------------    THIS ROUTINE CALLS   -----------------------  
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  CHECK EACH DATA ITEM                                           
C -----  NOTE THAT XBUF(4), I.E. BUSES, IS IN TERMS OF I5 FORMAT        
C                                                                       
      XBUF(4) = XBUF(4) * 10 + XBUF(5) / 1000                           
C                                                                       
      IF ( (XBUF(1) .LT. 100 .OR. XBUF(1) .GT. 600) .AND.               
     1      XBUF(1) .NE. 0) CALL ERGEN ('CKN52 ', 2573, XBUF(1),        
     2      1, 0, 0, 2)                                                 
      IF ( (XBUF(2) .LT. 200 .OR. XBUF(2) .GT. 600) .AND.               
     1      XBUF(2) .NE. 0) CALL ERGEN ('CKN52 ', 2573, XBUF(2),        
     2      2, 0, 0, 2)                                                 
      IF ( (XBUF(3) .LT. 100 .OR. XBUF(3) .GT. 400) .AND.               
     1      XBUF(3) .NE. 0) CALL ERGEN ('CKN52 ', 2573, XBUF(3),        
     2      3, 0, 0, 2)                                                 
      IF (XBUF(4) .LT. 0) CALL ERGEN ('CKN52 ', 2573,                   
     1                                 XBUF(4), 4, 0, 0, 2)             
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN56 (ILINK)                                          
C                                                                       
C                                                                       
C --- CODED    8-15-80 BY M. YEDLIN                                     
C --- REVISED 12-19-88 BY A. KANAAN TO REMOVE PACKING OF LGLPK          
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON CARD TYPE 56 -               
C ---         MODULE 2261.6.7.1                                         
C                                                                       
C --- FUNCTION - THIS MODULE PERFORMS CONSISTENCY CHECKS AMONG THE DATA 
C ---            ITEMS SPECIFIED ON A TYPE 56 CARD.                     
C                                                                       
C --- ARGUMENTS - ILINK  - ARRAY OF NETSIM LINK NUMBERS CORRESPONDING TO
C ---                      THE DATA SPECIFIED ON A TYPE 56 CARD.        
C ---                      TO THE CALLING ROUTINE                       
C                                                                       
C -------------------------   DESCRIPTION  ---------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE PERFORMS A SERIES OF CONSISTENCY CHECKS AMONG THE DATA
C     ITEMS SPECIFIED ON A TYPE 56 CARD. IT CALLS A SUBORDINATE MODULE  
C     TO CHECK THE QUANTITATIVE BOUNDS OF EACH DATA ITEM ON THE CARD.   
C     IT THEN CALLS ANOTHER SUBORDINATE MODULE TO DETERMINE THE LINK    
C     NUMBER CORRESPONDING TO THE NODE NUMBERS SPECIFIED ON THE CARD.   
C     IT ALSO CALLS A SUBORDINATE MODULE TO OUTPUT AN ERROR MESSAGE     
C     WHENEVER AN INCONSISTENCY IS FOUND.                               
C                                                                       
C -------------------   THIS ROUTINE CALLED BY  ----------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN56  - MODULE 2261.6.7                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS  ------------------------- 
C                         ------------------                            
C                                                                       
C                    NLKNUM - MODULE 2261.3112                          
C                    TBN56  - MODULE 2261.6711                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES  ---------------------- 
C                    --------------------------                         
C                                                                       
C     I       INDEX TO DATA FOR 1ST OR 2ND LINK ON TYPE 56 CARD         
C     IDN     DOWNSTREAM NODE NUMBER                                    
C     IL      NETSIM LINK NUMBER CORRESPONDING TO SPECIFIED NODE NOS.   
C     ILEN    MAXIMUM DIST. THAT PARKING ZONE CAN EXTEND FROM STOPLINE  
C     IPKT    LENGTH OF POCKET                                          
C     IUP     UPSTREAM NODE NUMBER                                      
C     JL      1ST OR 2ND LINK SPECIFIED ON THIS TYPE 56 CARD            
C     JLEN    DIST. THAT PARKING ZONE EXTENDS BEYOND ALLOWABLE LIMIT    
C     KL      NO. OF LINK PARALLEL TO IL CARRYING TRAF. IN OPPOSITE DIR.
C     LGLPK   LINK SPECIFIC ARRAY - LENGTH OF LEFT TURN POCKET          
C     LGRPK   LINK SPECIFIC ARRAY - LENGTH OF RIGHT TURN POCKET         
C     PRKDEM  LINK SPECIFIC ARRAY - PARKING DEMAND                      
C     TPCNT   TIME PERIOD COUNTER                                       
C     WEXTND  FLAG, (T,F) IF ZONE (DOES,DOESNT) EXTEND INTO TURN POCKET 
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH, UPSTREAM INT. LENGTH   
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION ILINK(2)                                                
C                                                                       
C -----  DOUNTIL DATA FOR BOTH LINKS ON CARD TYPE 56 IS CHECKED.  CHECK 
C -----  8 DATA ENTRIES FOR EACH LINK.                                  
C                                                                       
      I = -10                                                           
         DO 40 JL = 1, 2                                                
            ILINK(JL) = 0                                               
            I = I + 10                                                  
            IUP = XBUF(I+1)                                             
            IDN = XBUF(I+2)                                             
            IF (IUP .EQ. 0 .AND. IDN .EQ. 0)                 GO TO 40   
C                                                                       
C -----  CHECK QUANTITATIVE BOUNDS OF EACH DATA ITEM FOR 1 LINK. THEN   
C -----  GET LINK NUMBER.  OUTPUT ERROR MESSAGE AND TRA IF LINK DOES    
C -----  NOT EXIST.                                                     
C                                                                       
            CALL TBN56 (JL)                                             
            CALL NLKNUM (IL, IUP, IDN)                                  
            IF (IL .EQ. 0) CALL ERGEN ('CKN56 ', 4165,                  
     1          IUP, IDN, 0, 0, 2)                                      
            IF (IL .EQ. 0)                                   GO TO 40   
C                                                                       
C -----  CHECK IF LINK IL, WAS PREVIOUSLY SPECIFIED ON A TYPE 56        
C -----  CARD.  (THIS CHECK IS DONE DURING THE FIRST TIME PERIOD ONLY). 
C                                                                       
            ILINK(JL) = IL                                              
            IF (PRKDEM(IL) .NE. 0 .AND. TPCNT .EQ. 1)                   
     1          CALL ERGEN ('CKN56 ', 4166, IUP, IDN, 0, 0, 2)          
C                                                                       
C -----  OUTPUT MESSAGE WHEN DISTANCE TO FRONT OF A PARKING ZONE WAS    
C -----  SPECIFIED BUT LENGTH OF THAT PARKING ZONE WAS OMITTED.         
C                                                                       
            IF (XBUF(I+3) .GT. 0 .AND. XBUF(I+4) .EQ. 0)                
     1          CALL ERGEN ('CKN56 ', 4167, IUP, IDN, I+3,              
     2                       I+4, 4)                                    
            IF (XBUF(I+5) .GT. 0 .AND. XBUF(I+6) .EQ. 0)                
     1          CALL ERGEN ('CKN56 ', 4167, IUP, IDN, I+5,              
     2                       I+6, 4)                                    
C                                                                       
C -----  OUTPUT MESSAGE IF THERE IS NOT AT LEAST ONE PARKING ZONE       
C -----  SPECIFIED ON LINK, IL DURING 1ST TIME PERIOD OR DURING A       
C -----  SUBSEQUENT TIME PERIOD WHEN PARKING ACTIVITY IS SPECIFIED      
C                                                                       
            IF ((XBUF(I+4) .EQ. 0 .AND. XBUF(I+6) .EQ. 0) .AND.         
     1          (TPCNT .EQ. 1 .OR. XBUF(I+8) .GT. 0)) CALL ERGEN        
     2          ('CKN56 ', 4168, IUP, IDN, 0, 0, 2)                     
C                                                                       
C -----  OUTPUT MESSAGE DURING SUBSEQUENT TIME PERIOD WHEN EITHER MEAN  
C -----  DURATION OR MEAN NUMBER OF PARKING MANEUVERS IS SPECIFIED AND  
C -----  THE OTHER IS OMITTED.                                          
C                                                                       
            IF (TPCNT .GT. 1 .AND. ((XBUF(I+8) .GT. 0 .AND.             
     1          XBUF(I+7) .EQ. 0) .OR. (XBUF(I+7) .GT. 0 .AND.          
     2          XBUF(I+8) .EQ. 0)))  CALL ERGEN ('CKN56 ',              
     3           4172, XBUF(I+7), XBUF(I+8), IUP, IDN, 4)               
C                                                                       
C -----  OUTPUT WARNING MESSAGE AND CHANGE DISTANCE FROM STOPLINE TO    
C -----  BEGINNING OF PARKING ZONE WHEN ZONE EXTENDS INTO A TURN POCKET 
C                                                                       
            IF (LGRPK(IL) .GE. 0) IPKT = MOD (LGRPK(IL), 2**10)         
            IF (LGRPK(IL) .LT. 0) IPKT = IABS (MOD (LGRPK(IL), 2**9))   
            WEXTND = XBUF(I+3) .GT. 0 .AND. XBUF(I+3) .LT. IPKT         
            IF (WEXTND) XBUF(I+3) = IPKT                                
            IF (WEXTND) CALL ERGEN ('CKN56 ',  616, 1, IUP, IDN,        
     1                                      XBUF(I+3),  4)              
            IPKT = LGLPK(IL)                                            
            WEXTND = XBUF(I+5) .GT. 0 .AND. XBUF(I+5) .LT. IPKT         
            IF (WEXTND) XBUF(I+5) = IPKT                                
            IF (WEXTND) CALL ERGEN ('CKN56 ',  616, 2, IUP, IDN,        
     1                                      XBUF(I+5),  5)              
C                                                                       
C -----  OUTPUT WARNING MESSAGE AND CHANGE PARKING ZONE LENGTH WHEN     
C -----  PARKING ZONE EXTENDS WITHIN 40 FEET OF UPSTREAM INTERSECTION.  
C                                                                       
            ILEN = MOD (XLNGTH(IL), 2**12) - (XLNGTH(IL)/2**12 * 10)-40 
            JLEN = XBUF(I+3) + XBUF(I+4) - ILEN                         
            IF (JLEN .GT. 0) XBUF(I+4) = MAX0 (XBUF(I+4) - JLEN, 20)    
            IF (JLEN .GT. 0) CALL ERGEN ('CKN56 ',  617, 1, IUP,        
     1                                       IDN, XBUF(I+4), 4)         
            JLEN = XBUF(I+5) + XBUF(I+6) - ILEN                         
            IF (JLEN .GT. 0) XBUF(I+6) = MAX0 (XBUF(I+6) - JLEN, 20)    
            IF (JLEN .GT. 0) CALL ERGEN ('CKN56 ',  617, 2, IUP,        
     1                                       IDN, XBUF(I+6), 4)         
C                                                                       
C -----  TRA IF NO PARKING ZONE WAS SPECIFIED ON LEFT SIDE OF LINK.     
C -----  ELSE, DETERMINE IF LEFT SIDE OF LINK IS A CURB.                
C                                                                       
            IF (XBUF(I+6) .EQ. 0)                            GO TO 40   
            CALL NLKNUM (KL, IDN, IUP)                                  
            IF (KL .GT. 0) CALL ERGEN ('CKN56 ', 4171, IUP,             
     1                                   IDN, 0, 0, 2)                  
   40    CONTINUE                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN80                                                  
C                                                                       
C                                                                       
C --- CODED    4-17-91 BY J. WERK                                       
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON TYPE 80 CARDS -              
C ---         MODULE 2261.12.1.1                                        
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 80.                            
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 80 IS ASSUMED IN THE      
C     BUFFER.  A SUBROUTINE IS THEN CALLED TO CHECK EACH ITEM ON THE    
C     CARD.  ANOTHER SUBROUTINE IS CALLED TO GET LINK NUMBER.  WHEN     
C     CONTROL RETURNS, THIS ROUTINE WILL THEN CHECK FOR INCONSISTENCIES 
C     BETWEEN RELATED ITEMS ON THE CARD AND THE TYPE 11 CARD.           
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN80  - MODULE 2261.12.1                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBN80  - MODULE 2261.12111                         
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     IANGLE  ANGLE OF LINK IL2 RELATIVE TO DUE NORTH                   
C     IAP     INDEX OVER APPROACHES                                     
C     IJ      POINTER TO SIGI ARRAY                                     
C     IL      LINK NUMBER OF SUBJECT LINK                               
C     ILNK    LINK NUMBER                                               
C     IL2     LINK NUMBER OF PARALLEL LINK TO IL                        
C     IX      INDEX TO NODE COORDINATE ARRAYS                           
C     K       INDEX FOR DO LOOP                                         
C     LANEGD  ARRAY CONTAINING NUMBER OF LANES OF LINK                  
C     NMAX    MAXIMUM ALLOWABLE INTERNAL NODE NUMBER (USER NODE NUMBER) 
C     PARKL   LINK SPECIFIC ARRAY - LENGTH, STPLNE DIST TO LFT PARK ZONE
C     PARKR   LINK SPECIFIC ARRAY - LENGTH, STPLNE DIST TO RT PARK ZONE 
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBERS  
C     SIGT    COMMON ARRAY BIT 13 INDICATES WHETHER INTERSECTION IS A   
C             MICRONODE                                                 
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT         
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     WCHECK  FLAG .T. IF LINK IS ASSOCIATED WITH A MICRONODE           
C     WCOR    ARRAY SET (T, F) IF NODE COORDINATES FOR UPSTREAM,        
C             WCOR(1), AND DOWNSTREAM, WCOR(2), NODES OF LINK (WERE,    
C             WEREN'T) INPUT                                            
C     WPARKL  FLAG .T. IF PARKING IS PERMITTED ON LEFT CURB UP TO STPLNE
C     WPARKR  FLAG .T. IF PARKING IS PERMITTED ON RGHT CURB UP TO STPLNE
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     XC7000  INTERFACE NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND 
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS),    
C             A TEMPORARY CODE OF 1 IS SET IN BIT 31 OF THE FIRST       
C             WORD FOR THE NODE TO INDICATE COORDINATES FOR IT WERE     
C             INPUT ON A TYPE 195 CARD                                  
C     XGCOOR  NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND           
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS),    
C             A TEMPORARY CODE OF 1 IS SET IN BIT 31 OF THE FIRST       
C             WORD FOR THE NODE TO INDICATE COORDINATES FOR IT WERE     
C             INPUT ON A TYPE 195 CARD                                  
C     XWIDT2  ARRAY CONTAINING:  WIDTH OF PARKING LANE                  
C                                DISTANCE FROM STOP-LINE TO CURB        
C                                CURVATURE CODE                         
C                                ELEVATION CODE                         
C                                INTERCHANGE NUMBER, IF APPLICABLE      
C                                ANGLE OF LINK RELATIVE TO DUE NORTH    
C     YFIRST  FLAG SET .T. DURING FIRST PASS OVER INPUT STREAM, .F.     
C             OTHERWISE                                                 
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO   
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)           
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION WCOR(2)                                                 
C                                                                       
C -----  GET LINK NUMBER.  OUTPUT MESSAGE IF LINK WAS NOT ALREADY       
C -----  DEFINED BY A TYPE 11 CARD AND TRA.                             
C                                                                       
      CALL NLKNUM (IL, XBUF(1), XBUF(2))                                
      IF (IL .EQ. 0) THEN                                               
         CALL ERGEN ('CKN80 ', 5322, XBUF(1), XBUF(2), 0, 0, 2)         
                                                             GO TO 30   
      ENDIF                                                             
C                                                                       
C -----  IF DATA INPUT IN METRIC UNITS, STORE TEMPORARILY (FOR          
C -----  LATER PRINTING) AND CONVERT TO ENGLISH UNITS.                  
C                                                                       
      IF (UNITIN .EQ. 1) THEN                                           
         XBUF(23) = XBUF(3)                                             
         IF (XBUF(3) .GT. 0) XBUF(3) = ZCNVRT(4) * FLOAT (XBUF(3)) + 0.5
            DO 10 K = 4, 10                                             
               XBUF(K+20) = XBUF(K)                                     
               IF (XBUF(K) .GT. 0)                                      
     1         XBUF(K) = ZCNVRT(4) * FLOAT (XBUF(K)) + 0.5              
   10       CONTINUE                                                    
         XBUF(31) = XBUF(11)                                            
         XBUF(32) = XBUF(12)                                            
         IF (XBUF(11) .GT. 0) XBUF(11) = ZCNVRT(4) * FLOAT (XBUF(11))   
     1                        + 0.5                                     
         IF (XBUF(12) .GT. 0) XBUF(12) = ZCNVRT(4) * FLOAT (XBUF(12))   
     1                        + 0.5                                     
      ENDIF                                                             
C                                                                       
C -----  CHECK BOUNDS OF EACH ITEM AND GET LINK NUMBER                  
C                                                                       
      CALL TBN80                                                        
C                                                                       
C -----  CHECK THAT IF A WIDTH FOR PARKING LANE WAS ENTERED THAT        
C -----  PARKING IS ALLOWED ON LINK UP TO THE STOP-LINE                 
C                                                                       
      IF (XBUF(3) .GT. 0) THEN                                          
         IF (PARKR(IL) .EQ. 0 .AND. PARKL(IL) .EQ. 0) THEN              
            CALL ERGEN ('CKN80 ', 5324, XBUF(1), XBUF(2), 0, 0, 2)      
         ELSE                                                           
            WPARKR = MOD(PARKR(IL),2**8) .GT. 0 .AND. PARKR(IL)/(2**8)  
     1               .EQ. 0                                             
            WPARKL =  MOD(PARKL(IL),2**8) .GT. 0 .AND. PARKL(IL)/(2**8) 
     1               .EQ. 0                                             
            IF (.NOT. (WPARKR .OR. WPARKL)) CALL ERGEN('CKN80 ', 5324,  
     1                XBUF(1), XBUF(2), 0, 0, 2)                        
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C -----  CHECK ALL SPECIFIED LANE WIDTHS                                
C                                                                       
         DO 20 K = 4, 10                                                
            IF (XBUF(K) .GT. 0) THEN                                    
               IF (((K-3) .GT. MOD((LANEGD(IL)/(2**3)),2**3)) .AND.     
     1          ((K-3) .LT. 8 - (MOD((LANEGD(IL)/(2**6)),2**2) +        
     2          MOD((LANEGD(IL)/(2**8)),2**2))))                        
     3          CALL ERGEN ('CKN80 ', 5326, K-3, XBUF(1), XBUF(2), 0, 3)
            ENDIF                                                       
  20     CONTINUE                                                       
C                                                                       
C -----  IF LINK IS ASSOCIATED WITH A MICRONODE, CHECK THAT IF ANGLE OF 
C -----  LINK WAS NOT SPECIFIED THAT NODE COORDINATES WERE SPECIFIED    
C                                                                       
      WCHECK = .FALSE.                                                  
         DO 22 IAP = 1, 5                                               
            IJ = 5 * (UPNOD(IL) - 1) + IAP                              
            ILNK = SIGI(IJ)                                             
            IF (MOD(SIGT(UPNOD(ILNK))/(2**12),2) .EQ. 1) WCHECK = .TRUE.
            IJ = 5 * (DWNOD(IL) - 1) + IAP                              
            ILNK = SIGI(IJ)                                             
            IF (MOD(SIGT(UPNOD(ILNK))/(2**12),2) .EQ. 1) WCHECK = .TRUE.
   22    CONTINUE                                                       
      IF (MOD(SIGT(UPNOD(IL)) / (2**12), 2) .EQ. 1 .OR.                 
     1    MOD(SIGT(DWNOD(IL)) / (2**12), 2) .EQ. 1 .OR. WCHECK) THEN    
            DO 25 K = 1, 2                                              
               WCOR(K) = .FALSE.                                        
               KN = XBUF(K)                                             
               IF (KN .LE. NMAX) THEN                                   
                  IX = (KN - 1) * 2 + 1                                 
                  WCOR(K) = XGCOOR(IX) .GT. 0                           
               ELSE IF (KN .LE. 7999) THEN                              
                  IX = (KN - 7000) * 2 + 1                              
                  WCOR(K) = XC7000(IX) .GT. 0                           
               ENDIF                                                    
   25       CONTINUE                                                    
         IF (XBUF(13) .EQ. 0) THEN                                      
            IF (YFIRST  .AND.  (.NOT. WCOR(1) .OR. .NOT. WCOR(2)))      
     1          CALL ERGEN ('CKN80 ', 5327, XBUF(1), XBUF(2), 0, 0, 2)  
         ELSE                                                           
C                                                                       
C -----  ANGLE FOR LINK WAS SPECIFIED.  IF THE PARALLEL LINK EXISTS     
C -----  AND AN ANGLE WAS PACKED IN THE XWIDT2 ARRAY FOR THIS PARALLEL  
C -----  LINK, THEN IF THE ANGLES ARE NOT 180 DEGREES DIFFERENT ISSUE   
C -----  AN ERROR MESSAGE.                                              
C                                                                       
            IF (WCOR(1) .OR. WCOR(2)) THEN                              
               CALL ERGEN ('CKN80 ', 704, XBUF(1), XBUF(2), 0, 0, 2)    
            ELSE                                                        
               CALL NLKNUM (IL2, XBUF(2), XBUF(1))                      
               IF (IL2 .NE. 0) THEN                                     
                  IANGLE = MOD(XWIDT2(IL2) / (2**18), 2**9)             
                  IF (IANGLE .GT. 0) THEN                               
                     IF (ABS(IANGLE - XBUF(13)) .NE. 180) CALL ERGEN    
     1                   ('CKN80 ', 5323, XBUF(1), XBUF(2), 0, 0, 2)    
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
      ENDIF                                                             
  30  CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN81                                                  
C                                                                       
C                                                                       
C --- CODED    7-30-91 BY J. WERK                                       
C --- REVISED  1-07-93 BY J. WERK TO CHANGE RANGE FOR XBUF(15)          
C                                                                       
C --- TITLE - CHECK QUANTITATIVE BOUNDS OF EACH DATA ITEM ON TYPE 81    
C ---         CARD - MODULE 2261.13.1                                   
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE QUANTITATIVE BOUNDS OF EACH     
C ---            DATA ITEM ON CARD TYPE 81.                             
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED CARD TYPE 81 IS ASSUMED IN THE BUFFER.
C     IT CHECKS THE BOUNDS OF EACH ITEM ON THE CARD INDEPENDENTLY.      
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN81  - MODULE 2261.13                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     UNITIN  NETSIM CODE (0,1) IF (ENGLISH,METRIC) UNITS INPUT         
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     ZCNVRT  ARRAY OF ENGLISH AND METRIC CONVERSION FACTORS (1-6) TO   
C             CONVERT (FT-M,MI-KM,GAL-LIT,M-FT,KM-MI,LIT-GAL)           
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  TEMPORARILY STORE DATA, IF IN METRIC UNITS, AND CONVERT        
C -----  TO ENGLISH UNITS.                                              
C                                                                       
      IF (UNITIN .EQ. 1) THEN                                           
         XBUF(30) = XBUF( 4)                                            
         XBUF(31) = XBUF( 5)                                            
         XBUF(32) = XBUF( 6)                                            
         XBUF(33) = XBUF( 7)                                            
         XBUF(34) = XBUF( 8)                                            
         XBUF(35) = XBUF(10)                                            
         XBUF(36) = XBUF(15)                                            
         XBUF( 4) = ZCNVRT(4) * FLOAT (XBUF( 4)) + 0.5                  
         XBUF( 5) = ZCNVRT(4) * FLOAT (XBUF( 5)) + 0.5                  
         XBUF( 6) = ZCNVRT(4) * FLOAT (XBUF( 6)) + 0.5                  
         XBUF( 7) = ZCNVRT(4) * FLOAT (XBUF( 7)) + 0.5                  
         XBUF( 8) = ZCNVRT(4) * FLOAT (XBUF( 8)) + 0.5                  
         XBUF(15) = ZCNVRT(4) * FLOAT (XBUF(15)) + 0.5                  
         XBUF(10) = (1.0/ZCNVRT(4)) * FLOAT (XBUF(10)) + 0.5            
      ENDIF                                                             
C                                                                       
C -----  CHECK BOUNDS OF EACH ITEM.  CALL ERROR GENERATOR IF ITEM IS    
C -----  NOT WITHIN ITS PERMISSIBLE BOUNDS.                             
C                                                                       
      IF (XBUF(1) .NE. 0 .AND. (XBUF(1) .LT. 1 .OR. XBUF(1) .GT. 8))    
     1   CALL ERGEN ('CKN81 ', 5300, XBUF(1), 0, 0, 0, 1)               
      IF (XBUF(2) .NE. 0 .AND. (XBUF(2) .LT. 1 .OR. XBUF(2) .GT. 30))   
     1   CALL ERGEN ('CKN81 ', 5301, XBUF(2), 0, 0, 0, 1)               
      IF (XBUF(3) .NE. 0 .AND. (XBUF(3) .LT. 10 .OR. XBUF(3) .GT. 100)) 
     1   CALL ERGEN ('CKN81 ', 5302, XBUF(3), 0, 0, 0, 1)               
      IF (XBUF(4) .NE. 0 .AND. (XBUF(4) .LT. 1 .OR. XBUF(4) .GT. 10))   
     1   CALL ERGEN ('CKN81 ', 5303, XBUF(4), 0, 0, 0, 1)               
      IF (XBUF(5) .NE. 0 .AND. (XBUF(5) .LT. 5 .OR. XBUF(5) .GT. 15))   
     1   CALL ERGEN ('CKN81 ', 5304, XBUF(5), 0, 0, 0, 1)               
      IF (XBUF(6) .NE. 0 .AND. (XBUF(6) .LT. 5 .OR. XBUF(5) .GT. 15))   
     1   CALL ERGEN ('CKN81 ', 5305, XBUF(6), 0, 0, 0, 1)               
      IF (XBUF(7) .NE. 0 .AND. (XBUF(7) .LT. 10 .OR. XBUF(7) .GT. 15))  
     1   CALL ERGEN ('CKN81 ', 5306, XBUF(7), 0, 0, 0, 1)               
      IF (XBUF(8) .NE. 0 .AND. (XBUF(8) .LT. 10 .OR. XBUF(8) .GT. 15))  
     1   CALL ERGEN ('CKN81 ', 5307, XBUF(8), 0, 0, 0, 1)               
      IF (XBUF(9) .NE. 0 .AND. (XBUF(9) .LT. 15 .OR. XBUF(9) .GT. 50))  
     1   CALL ERGEN ('CKN81 ', 5308, XBUF(9), 0, 0, 0, 1)               
      IF (XBUF(10) .NE. 0 .AND. (XBUF(10) .LT. 0 .OR. XBUF(10) .GT. 5)) 
     1   CALL ERGEN ('CKN81 ', 5309, XBUF(10), 0, 0, 0, 1)              
      IF (XBUF(11) .NE. 0 .AND. (XBUF(11) .LT. 6 .OR. XBUF(11) .GT. 10))
     1   CALL ERGEN ('CKN81 ', 5310, XBUF(11), 0, 0, 0, 1)              
      IF (XBUF(12) .NE. 0 .AND. (XBUF(12) .LT. 10 .OR. XBUF(12).GT.100))
     1   CALL ERGEN ('CKN81 ', 5311, XBUF(12), 0, 0, 0, 1)              
      IF (XBUF(13) .NE. 0 .AND. (XBUF(13) .LT. 1 .OR. XBUF(13) .GT. 30))
     1   CALL ERGEN ('CKN81 ', 5312, XBUF(13), 0, 0, 0, 1)              
      IF (XBUF(14) .NE. 0 .AND. (XBUF(14) .LT. 30 .OR. XBUF(14).GT.100))
     1   CALL ERGEN ('CKN81 ', 5313, XBUF(14), 0, 0, 0, 1)              
      IF (XBUF(15) .NE. 0 .AND. (XBUF(15) .LT. 50 .OR.XBUF(15).GT.2500))
     1   CALL ERGEN ('CKN81 ', 5314, XBUF(15), 0, 0, 0, 1)              
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKN95                                                  
C                                                                       
C                                                                       
C --- CODED    5-1-91 BY J. WERK                                        
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA ON TYPE 95 CARDS -              
C ---         MODULE 2261.11.1.1                                        
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 95.                            
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 95 IS ASSUMED IN THE      
C     BUFFER.  A SUBROUTINE IS THEN CALLED TO CHECK EACH ITEM ON THE    
C     CARD.  ANOTHER SUBROUTINE IS CALLED TO GET LINK NUMBER.  WHEN     
C     CONTROL RETURNS, THIS ROUTINE WILL THEN CHECK FOR INCONSISTENCIES 
C     BETWEEN RELATED ITEMS ON THE CARD.                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDN95  - MODULE 2261.11.1                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBN95  - MODULE 2261.11111                         
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN - MODULE 2.6.1.1                             
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     I       INDEX TO DO LOOP                                          
C     IL      LINK NUMBER OF SUBJECT LINK                               
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  CHECK BOUNDS OF EACH ITEM AND GET LINK NUMBER                  
C                                                                       
      CALL TBN95                                                        
         DO 100 I = 2, 19, 2                                            
            IF (XBUF(I) .GT. 0 .AND. XBUF(I+1) .GT. 0) THEN             
               CALL NLKNUM (IL, XBUF(I), XBUF(I+1))                     
C                                                                       
C -----  OUTPUT MESSAGE IF LINK WAS NOT ALREADY DEFINED BY A            
C -----  TYPE 11 CARD AND TRA.                                          
C                                                                       
               IF (IL .EQ. 0) CALL ERGEN ('CKN95 ',5338, XBUF(I),       
     1                                     XBUF(I+1), XBUF(1), 0, 3)    
            ELSE                                                        
               IF (XBUF(I) .GT. 0 .OR. XBUF(I+1) .GT. 0) CALL ERGEN     
     1              ('CKN95 ', 5338, XBUF(I), XBUF(I+1), 0, 0, 2)       
            ENDIF                                                       
  100    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKNCRD                                                 
C                                                                       
C --- CODED    2-16-93 BY A. PHLEGAR                                    
C --- REVISED 11-03-94 BY S. WALKER TO CHANGE WARNING 658 TO ERROR 3115 
C --- REVISED  1-04-95 BY S. WALKER TO MOVE YGRAPH CHECK TO GETINP      
C --- REVISED  1-05-95 BY S. WALKER TO REMOVE ERROR 3115 & CORRECT COORD
C                                                                       
C --- TITLE - PERFORM COORDINATE CHECKING FOR ALL NODES                 
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS NODE COORDINATES FOR CONSISTENCY    
C ---            WITH LINK LENGTH DATA.                                 
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE LOOPS OVER ALL NODES IN THE SUBNETWORK, CHECKS IF     
C     NODE COORDINATES ARE CONSISTENT WITH LINK LENGTHS WHICH WERE      
C     INPUT                                                             
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                             GETINP                                    
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                              NONE                                     
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - LINK RECEIVING RIGHT TURNERS        
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     ERRCT   INPUT ERROR COUNTER                                       
C     ICLEN   LINK LENGTH (FEET) COMPUTED FROM X AND Y COORDINATES      
C     IDN     DOWNSTREAM NODE NUMBER OF LINK IL                         
C     IDX     X COORDINATE OF NODE IDN, FEET / 10                       
C     IDY     Y COORDINATE OF NODE IDN, FEET / 10                       
C     IL      INDEX OVER LINKS                                          
C     ILEN    LINK LENGTH DEFINED BY USER ON TYPE 11 CARD               
C     IM      INDEX OVER MOVEMENTS                                      
C     IN      NODE IDENTIFICATION NUMBER, LOOPING INDEX                 
C     INTFZ   INTERFACE NODE NUMBER                                     
C     IRL     RECEIVING LINK NUMBER                                     
C     IUP     UPSTREAM NODE NUMBER OF LINK IL                           
C     IUSER   USERS NODE NUMBER FOR NODE IN                             
C     IUX     X COORDINATE OF NODE IUP, FEET / 10                       
C     IUY     Y COORDINATE OF NODE IUP, FEET / 10                       
C     LEFT    LINK SPECIFIC ARRAY - LINK RECEIVING LEFT TURNERS         
C     LNKID   LINK ID TO TRACE                                          
C     LU6     LOGICAL UNIT 6                                            
C     NACT    NODE SPECIFIC ARRAY - TYPE OF CONTROL                     
C     NMAP    NODE SPECIFIC ARRAY - USERS SPECIFIED NODE NUMBER         
C     IX      INDEX TO ARRAYS CONTAINING ENTRY NODE OR INTERFACE NODE   
C             COORDINATES                                               
C     IXOFST  AMOUNT TO COORDINATES WILL BE OFFSET IN THE X DIRECTION TO
C             PREVENT NEGATIVE COORDINATES                              
C     IYOFST  AMOUNT TO COORDINATES WILL BE OFFSET IN THE X DIRECTION TO
C             PREVENT NEGATIVE COORDINATES                              
C     LEVCRV  GLOBAL LINK SPECIFIC ARRAY - CURVATURE CODE (BITS 1-2)    
C             AND LEVEL (BITS 3-16)                                     
C     NGLK    TOTAL NUMBER OF LINKS IN GLOBAL NETWORK                   
C     RANGLE  ANGLE OF LINK IL                                          
C     RANGRC  ANGLE OF LINK IRL                                         
C     RAVLEN  AVERAGE LINK LENGTH                                       
C     RLEN    LINK LENGTH USED FOR ENTRY OR INTERFACE NODE COORDINATE   
C             COMPUTATIONS                                              
C     RPI     VALUE OF PI                                               
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK NUMBER          
C     TTLND   TOTAL NUMBER OF NODES IN SUBNETWORK                       
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     XCOORD  NODE SPECIFIC ARRAY - X COORDINATE (FT / 10) IN BITS 1-15 
C             AND Y COORDINATE (FT / 10) IN BITS 16-30                  
C     XC7000  INTERFACE NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND 
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)     
C     XC8000  ENTRY NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND     
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)     
C     XGCOOR  NODE SPECIFIC ARRAY * 2 - X COORDINATE (FT) AND           
C             Y COORDINATE (FT) FOR NODE (IN TWO CONSECUTIVE WORDS)     
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH (FEET)                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
      COMMON /PRG026/ LEVCRV(1)                                         
C                                                                       
      DATA RPI /3.14159265/                                             
      IXOFST = 0                                                        
      IYOFST = 0                                                        
C                                                                       
C -----  FIRST CHECK IF NODE COORDINATES HAVE BEEN SPECIFIED FOR ALL    
C -----  INTERNAL NODES IN THE NETWORK                                  
C                                                                       
      DO 10 I = 1, TTLND                                                
         IF (NMAP(I) .GT. 0 .AND. XGCOOR((NMAP(I)-1)*2 + 1) .LT. 0)     
     1                CALL ERGEN ('CKNCRD', 3112, NMAP(I),0,0,0,1)      
   10 CONTINUE                                                          
      IF (ERRCT .NE. 0)                                 GO TO 90        
C                                                                       
C -----  ALSO LOOP OVER ALL LINKS TO DETERMINE THE AVERAGE LINK LENGTH  
C -----  TO BE USED IN COMPUTATIONS LATER ON                            
C                                                                       
      RAVLEN = 0                                                        
      DO 20 IL = 1, TTLNK                                               
         IF (UPNOD(IL) .LT. 8000)                                       
     1                  RAVLEN = RAVLEN + MOD (XLNGTH(IL), 2**12)       
20    CONTINUE                                                          
      RAVLEN = RAVLEN / TTLNK                                           
C                                                                       
C -----  LOOP OVER ALL LINKS TO CHECK CONSISTENCY OF NODE COORDINATE    
C -----  DATA, AND COMPUTE NODE COORDINATES FOR ENTRY/EXIT AND INTERFACE
C -----  NODES.  (NODE COORDINATES MUST BE INPUT FOR INTERNAL NODES     
C -----  AND CAN OPTIONALLY BE INPUT FOR INTERFACE AND ENTRY/EXIT       
C -----  NODES)                                                         
C                                                                       
      IF (LNKID .GT. 0)  WRITE(LU6,1000)                                
      DO 70 IL = 1, TTLNK                                               
C                                                                       
C -----  WHEN LINK IS AN INTERNAL LINK OR LINK IS AN INTERFACE LINK     
C -----  AND NODE COORDINATES FOR THE INTERFACE NODE HAVE BEEN INPUT,   
C -----  GET COORDINATES OF UPSTREAM AND DOWNSTREAM NODES OF LINK       
C -----  IN PREPARATION FOR CHECKING THE LINK LENGTH.                   
C                                                                       
            INTFZ = 0                                                   
            IF (UPNOD(IL) / 1000 .EQ. 7) INTFZ = UPNOD(IL)              
            IF (DWNOD(IL) / 1000 .EQ. 7) INTFZ = DWNOD(IL)              
            IX = (INTFZ - 7000) * 2 + 1                                 
            IF (UPNOD(IL) .LT. 7000 .AND. DWNOD(IL) .LT. 7000 .OR.      
     1           (INTFZ .NE. 0 .AND. XC7000(IX) .GE. 0)) THEN           
                IUP = UPNOD(IL)                                         
                IDN = DWNOD(IL)                                         
                IF (IUP .LT. 7000) THEN                                 
                    IUP = NMAP(IUP)                                     
                    IX = (IUP - 1) * 2 + 1                              
                    IUX = XGCOOR(IX)                                    
                    IUY = XGCOOR(IX+1)                                  
                ELSEIF (IUP .LT. 8000) THEN                             
                    IX = (IUP - 7000) * 2 + 1                           
                    IUX = XC7000(IX)                                    
                    IUY = XC7000(IX+1)                                  
                ELSE                                                    
                    IX = (IUP - 8000) * 2 + 1                           
                    IUX = XC8000(IX)                                    
                    IUY = XC8000(IX+1)                                  
                ENDIF                                                   
                IF (IDN .LT. 7000) THEN                                 
                    IDN = NMAP(IDN)                                     
                    IX = (IDN-1) * 2 + 1                                
                    IDX = XGCOOR(IX)                                    
                    IDY = XGCOOR(IX+1)                                  
                ELSEIF (IDN .LT. 8000) THEN                             
                    IX = (IDN - 7000) * 2 + 1                           
                    IDX = XC7000(IX)                                    
                    IDY = XC7000(IX+1)                                  
                ELSE                                                    
                    IX = (IDN - 8000) * 2 + 1                           
                    IDX = XC8000(IX)                                    
                    IDY = XC8000(IX+1)                                  
                ENDIF                                                   
C                                                                       
C -----  COMPUTE THE LENGTH, ICLEN, OF LINK IL FROM THE NODE            
C -----  COORDINATES.  THEN CHECK IF IT DIFFERS SUBSTANTIALLY FROM THE  
C -----  LINK LENGTH INPUT ON CARD TYPE 11.  FOR LINKS LONGER THAN 500  
C -----  FEET, OUTPUT AN ERROR MESSAGE IF THE PERCENT DIFFERENCE BETWEEN
C -----  COMPUTED AND SPECIFIED LINK LENGTH EXCEEDS 20 PERCENT. IF LINK 
C -----  LENGTH IS LESS THAN 500 FEET, OUTPUT ERROR MESSAGE IF DIFF.    
C -----  IN LINK LENGTHS IS GREATER THAN 100 FEET.                      
C                                                                       
                ICLEN = (IUX - IDX) ** 2 + (IUY - IDY) ** 2             
                ICLEN = SQRT (FLOAT(ICLEN))                             
                ILEN = MOD (XLNGTH(IL), 2**12)                          
                IF (MOD (LEVCRV(IL), 4) .NE. 0)              GO TO 30   
                IF ((ILEN .GT. 500  .AND.                               
     1               IABS (ICLEN - ILEN) * 100 / ILEN .GT. 20) .OR.     
     2               (ILEN .LE. 500  .AND.                              
     3               IABS (ICLEN - ILEN) .GT. 100)) THEN                
                    CALL ERGEN ('CKNCRD', 3101, IUP, IDN,               
     1                           ILEN, ICLEN, 4)                        
C                                                                       
C -----  OUTPUT WARNING MESSAGE FOR LINKS OVER 500 FEET IF DIFFERENCE   
C -----  BETWEEN COMPUTED AND SPECIFIED LINK LENGTHS IS BETWEEN 10 AND  
C -----  20 PERCENT. FOR LINKS UNDER 500 FEET, OUTPUT WARNING MESSAGE   
C -----  IF DIFFERENCE IN LINK LENGTHS IS BETWEEN 50 AND 100 FEET.      
C                                                                       
                ELSEIF ((ILEN .GT. 500  .AND.                           
     1                  IABS (ICLEN - ILEN) * 100 / ILEN .GT. 10) .OR.  
     2                  (ILEN .LE. 500  .AND.                           
     3                   IABS (ICLEN - ILEN) .GT. 50)) THEN             
                      CALL ERGEN ('CKNCRD', 400, IUP, IDN,              
     1                                    ILEN, ICLEN, 4)               
                ENDIF                                                   
   30     CONTINUE                                                      
C                                                                       
C -----  WHEN LINK IS CURVED MAKE SURE THAT THE LINK LENGTH             
C -----  GIVEN BY THE USER IS GREATER THAN THE LENGTH COMPUTED          
C -----  FROM THE NODE COORDINATES                                      
C                                                                       
              IF (MOD (LEVCRV(IL), 4) .NE. 0  .AND.                     
     1           ILEN .LE. ICLEN)                                       
     2           CALL ERGEN ('CKNCRD', 3116, IUP, IDN,                  
     3                        ILEN, ICLEN, 4)                           
C                                                                       
C -----  WHEN LINK IS AN ENTRY INTERFACE LINK, I.E., ITS UPSTREAM NODE  
C -----  NUMBER IS IN THE RANGE 7000-7999, COMPUTE THE LOCATION OF THE  
C -----  INTERFACE NODE BASED ON THE TWO INTERNAL NODES ON EITHER SIDE  
C -----  OF THIS INTERFACE NODE.   TO DO THIS, FIRST FIND THE LINK      
C -----  WHOSE  DOWNSTREAM NODE IS THE INTERFACE NODE.                  
C                                                                       
            ELSEIF (UPNOD(IL) / 1000 .EQ. 7) THEN                       
                 I = 0                                                  
40               CONTINUE                                               
                 I = I + 1                                              
                 IF (DWNOD(I).NE.UPNOD(IL) .AND. I.LT.TTLNK) GO TO 40   
                 IUP = UPNOD(I)                                         
                 IDN = DWNOD(IL)                                        
                 IUP = NMAP(IUP)                                        
                 IX = (IUP-1) * 2 + 1                                   
                 IUX = XGCOOR(IX)                                       
                 IUY = XGCOOR(IX+1)                                     
                 IDN = NMAP(IDN)                                        
                 IX = (IDN-1) * 2 + 1                                   
                 IDX = XGCOOR(IX)                                       
                 IDY = XGCOOR(IX+1)                                     
                 IF (IDX .EQ. IUX) RANGLE = RPI / 2.                    
                 IF (IDX .EQ. IUX .AND. IDY .LT. IUY) RANGLE = -RANGLE  
                 IF (IDX .NE. IUX)                                      
     1                    RANGLE = ATAN ((IDY - IUY) / REAL(IDX - IUX)) 
                 IF (IDX .LT. IUX  .AND.  IDY .GE. IUY)                 
     1                  RANGLE = RANGLE + RPI                           
                 IF (IDX .LT. IUX  .AND.  IDY .LT. IUY)                 
     1                  RANGLE = RANGLE - RPI                           
                 RLEN = MOD (XLNGTH(I), 2**12)                          
                 IUX = NINT ( (IUX + RLEN * COS(RANGLE) ) / 10)         
                 IUY = NINT ( (IUY + RLEN * SIN(RANGLE) ) / 10)         
                 IX = (UPNOD(IL) - 7000) * 2 + 1                        
                 IF (XC7000(IX) .LT. 0) THEN                            
                    XC7000(IX)   = IUX                                  
                    XC7000(IX+1) = IUY                                  
                 ENDIF                                                  
C                                                                       
C -----  WHEN LINK IL IS AN ENTRY LINK, I.E., ITS UPSTREAM NODE NUMBER  
C -----  IS IN THE RANGE 8000-8999 AND THE USER HAS NOT INPUT           
C -----  COORDINATES FOR THE ENTRY NODE ON CARD TYPE 195, COMPUTE THE   
C -----  LOCATION OF THE ENTRY NODE BASED ON THE COORDINATES OF THE     
C -----  DOWNSTREAM NODE OF LINK IL, THE LENGTH OF LINK IL, AND ITS     
C -----  ANGLE RELATIVE TO THE X AXIS.  TO DETERMINE THE ANGLE OF THE   
C -----  LINK, LOOP OVER THE THRU, DIAGONAL, RIGHT AND LEFT RECEIVING   
C -----  LINKS TO FIND A RECEIVER WHICH EXISTS AND COMPUTE THE ANGLE,   
C -----  RANGLE, OF LINK IL BASED ON THE ANGLE OF THE RECEIVER.         
C                                                                       
            ELSEIF (UPNOD(IL) .GE. 8000) THEN                           
                  IX = (UPNOD(IL) - 8000) * 2 + 1                       
                  IF (XC8000(IX) .LT. 0) THEN                           
                      IM = 0                                            
50                    CONTINUE                                          
                      IM = IM + 1                                       
                      IRL = THRU(IL)                                    
                      IF (IM .EQ. 2) IRL = IABS (DIAGNL(IL))            
                      IF (IM .EQ. 3) IRL = ARIGHT(IL)                   
                      IF (IM .EQ. 4) IRL = LEFT(IL)                     
                      IF (IRL .NE. 0) THEN                              
                       IUP = UPNOD(IRL)                                 
                       IDN = DWNOD(IRL)                                 
                       IF (IUP .LT. 7000) THEN                          
                           IUP = NMAP(IUP)                              
                           IX = (IUP-1) * 2 + 1                         
                           IUX = XGCOOR(IX)                             
                           IUY = XGCOOR(IX+1)                           
                       ELSEIF (IUP .LT. 8000) THEN                      
                           IX = (IUP - 7000) * 2 + 1                    
                           IUX = XC7000(IX)                             
                           IUY = XC7000(IX+1)                           
                       ELSE                                             
                           IX = (IUP - 8000) * 2 + 1                    
                           IUX = XC8000(IX)                             
                           IUY = XC8000(IX+1)                           
                       ENDIF                                            
                       IF (IDN .LT. 7000) THEN                          
                           IDN = NMAP(IDN)                              
                           IX = (IDN-1) * 2 + 1                         
                           IDX = XGCOOR(IX)                             
                           IDY = XGCOOR(IX+1)                           
                       ELSEIF (IDN .LT. 8000) THEN                      
                           IX = (IDN - 7000) * 2 + 1                    
                           IDX = XC7000(IX)                             
                           IDY = XC7000(IX+1)                           
                       ELSE                                             
                           IX = (IDN - 8000) * 2 + 1                    
                           IDX = XC8000(IX)                             
                           IDY = XC8000(IX+1)                           
                       ENDIF                                            
                       IF (IDX .EQ. IUX) RANGRC = RPI / 2.              
                       IF (IDX .EQ. IUX .AND. IDY .LT. IUY)             
     1                                          RANGRC = -RANGRC        
                       IF (IDX .NE. IUX)                                
     1                    RANGRC = ATAN ((IDY - IUY) / REAL(IDX - IUX)) 
                       IF (IDX .LT. IUX  .AND.  IDY .GE. IUY)           
     1                     RANGRC = RANGRC + RPI                        
                       IF (IDX .LT. IUX  .AND.  IDY .LT. IUY)           
     1                     RANGRC = RANGRC - RPI                        
                       RANGLE = RANGRC                                  
                       IF (IM .EQ. 4) RANGLE = RANGLE + RPI * .5        
                       IF (IM .EQ. 3) RANGLE = RANGLE - RPI * .5        
                       IF (IM .EQ. 2) THEN                              
                          IF (DIAGNL(IRL) .GT. 0) RANGLE =              
     1                        RANGLE - RPI * .25                        
                          IF (DIAGNL(IRL) .LT. 0) RANGLE =              
     2                        RANGLE + RPI * .25                        
                       ENDIF                                            
                    ENDIF                                               
                    IF (IM .LT. 4  .AND. IRL .EQ. 0)        GO TO 50    
C                                                                       
C -----  NOW COMPUTE AND STORE COORDINATES OF ENTRY NODE.  NOTE,        
C -----  NEGATIVE COORDINATES WILL BE CORRECTED AT END OF ROUTINE.      
C                                                                       
                    IUX = NINT (IUX - RAVLEN * COS(RANGLE))             
                    IUY = NINT (IUY - RAVLEN * SIN(RANGLE))             
                    IXOFST = MIN0 (IXOFST, IUX)                         
                    IYOFST = MIN0 (IYOFST, IUY)                         
                    IX = (UPNOD(IL) - 8000) * 2 + 1                     
                    XC8000(IX)   = IUX                                  
                    XC8000(IX+1) = IUY                                  
                 ENDIF                                                  
            ENDIF                                                       
C                                                                       
C -----  LOOP OVER THE 4 RECEIVERS FOR LINK IL AND CHECK THAT           
C -----  COORDINATES HAVE BEEN COMPUTED FOR ANY EXIT NODES (IN THE RANGE
C -----  8000-8999) WHICH ARE FOUND.  THIS MUST BE DONE SINCE SOME NODES
C -----  NUMBERED ABOVE 8000 MAY ONLY APPEAR AS EXIT NODES AND THEREFORE
C -----  THEIR COORDINATES WILL NOT BE COMPUTED ABOVE.                  
C                                                                       
            DO 60 IM = 1, 4                                             
               IRN = THRU(IL)                                           
               IF (IM .EQ. 4) IRN = LEFT(IL)                            
               IF (IM .EQ. 3) IRN = ARIGHT(IL)                          
               IF (IM .EQ. 2) IRN = ABS (DIAGNL(IL))                    
               IF (IRN .GE. 8000) THEN                                  
                   IX = (IRN - 8000) * 2 + 1                            
                   IF (XC8000(IX) .LT. 0) THEN                          
                     IUP = UPNOD(IL)                                    
                     IDN = DWNOD(IL)                                    
                     IF (IUP .LT. 7000) THEN                            
                         IUP = NMAP(IUP)                                
                         IX = (IUP-1) * 2 + 1                           
                         IUX = XGCOOR(IX)                               
                         IUY = XGCOOR(IX+1)                             
                     ELSEIF (IUP .LT. 8000) THEN                        
                         IX = (IUP - 7000) * 2 + 1                      
                         IUX = XC7000(IX)                               
                         IUY = XC7000(IX+1)                             
                     ELSE                                               
                         IX = (IUP - 8000) * 2 + 1                      
                         IUX = XC8000(IX)                               
                         IUY = XC8000(IX+1)                             
                     ENDIF                                              
                     IF (IDN .LT. 7000) THEN                            
                         IDN = NMAP(IDN)                                
                         IX = (IDN-1) * 2 + 1                           
                         IDX = XGCOOR(IX)                               
                         IDY = XGCOOR(IX+1)                             
                     ELSEIF (IUP .LT. 8000) THEN                        
                         IX = (IDN - 7000) * 2 + 1                      
                         IDX = XC7000(IX)                               
                         IDY = XC7000(IX+1)                             
                     ELSE                                               
                         IX = (IDN - 8000) * 2 + 1                      
                         IDX = XC8000(IX)                               
                         IDY = XC8000(IX+1)                             
                     ENDIF                                              
                     IF (IDX .EQ. IUX) RANGLE = RPI / 2.                
                     IF (IDX .EQ. IUX .AND. IDY .LT. IUY)               
     1                                     RANGLE = -RANGLE             
                     IF (IDX .NE. IUX)                                  
     1                  RANGLE = ATAN ((IDY - IUY) / REAL(IDX - IUX))   
                     IF (IDX .LT. IUX .AND. IDY .GE. IUY)               
     1                  RANGLE = RANGLE + RPI                           
                     IF (IDX .LT. IUX .AND. IDY .LT. IUY)               
     1                  RANGLE = RANGLE - RPI                           
                     RANGRC = RANGLE                                    
                     IF (IM .EQ. 4) RANGRC = RANGRC + RPI * .5          
                     IF (IM .EQ. 3) RANGRC = RANGRC - RPI * .5          
                     IF (IM .EQ. 2) THEN                                
                        IF (DIAGNL(IL) .GT. 0) THEN                     
                           RANGRC = RANGRC - RPI * .25                  
                        ELSE                                            
                           RANGRC = RANGRC + RPI * .25                  
                        ENDIF                                           
                     ENDIF                                              
                     IUX = NINT (IDX + RAVLEN * COS(RANGRC))            
                     IUY = NINT (IDY + RAVLEN * SIN(RANGRC))            
                     IXOFST = MIN0 (IXOFST, IUX)                        
                     IYOFST = MIN0 (IYOFST, IUY)                        
                     IX = (IRN - 8000) * 2 + 1                          
                     XC8000(IX)   = IUX                                 
                     XC8000(IX+1) = IUY                                 
                  ENDIF                                                 
               ENDIF                                                    
60          CONTINUE                                                    
      IF (LNKID.GT.0) WRITE(LU6,1010) IL,NMAP(IUP),NMAP(IDN),ILEN,ICLEN 
70    CONTINUE                                                          
C                                                                       
C -----  CORRECT COORDINATES IF COORDINATES FOR ANY EXTERNAL NODES WERE 
C -----  CALCULATED AS NEGATIVE.                                        
C                                                                       
      IXOFST = IABS(IXOFST)                                             
      IYOFST = IABS(IYOFST)                                             
      IF (IXOFST .GT. 0) IXOFST = IXOFST + 100                          
      IF (IYOFST .GT. 0) IYOFST = IYOFST + 100                          
C                                                                       
      IF (IXOFST .GT. 0 .OR. IYOFST .GT. 0) THEN                        
          DO 100 I = 1, TTLND                                           
             IX = (NMAP(I)-1) * 2 + 1                                   
             IF (IXOFST .GT. 0 .AND. XGCOOR(IX) .NE. -9999)             
     1           XGCOOR(IX) = XGCOOR(IX) + IXOFST                       
             IF (IYOFST .GT. 0 .AND. XGCOOR(IX+1) .NE. -9999)           
     1           XGCOOR(IX+1) = XGCOOR(IX+1) + IYOFST                   
  100     CONTINUE                                                      
          DO 110 I = 1, 2000, 2                                         
             IF (XC7000(I) .NE. -9999) THEN                             
                 IF (IXOFST .GT. 0) XC7000(I) = XC7000(I) + IXOFST      
                 IF (IYOFST .GT. 0) XC7000(I+1) = XC7000(I+1) + IYOFST  
             ENDIF                                                      
             IF (XC8000(I) .NE. -9999) THEN                             
                 IF (IXOFST .GT. 0) XC8000(I) = XC8000(I) + IXOFST      
                 IF (IYOFST .GT. 0) XC8000(I+1) = XC8000(I+1) + IYOFST  
             ENDIF                                                      
  110     CONTINUE                                                      
      ENDIF                                                             
   90 CONTINUE                                                          
      RETURN                                                            
 1000 FORMAT ('  IL  UP  DN  USRLEN  CORLEN')                           
 1010 FORMAT (3I4,2I8)                                                  
      END                                                               
      SUBROUTINE CKNODN(I1, WEXIST)                                     
C                                                                       
C                                                                       
C --- CODED    3-21-78 BY M. YEDLIN                                     
C --- REVISED 10-15-87 BY K. SHERIDAN (FOR NETSIM SIGNAL TRANSITION)    
C                                                                       
C --- TITLE - CHECK VALIDITY OF SPECIFIED NODE - MODULE 2261.5111.2     
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES IF A USER SPECIFIED (GLOBAL)    
C ---            NODE NUMBER EXISTS IN THE NODE MAP                     
C                                                                       
C --- ARGUMENTS - I1 = USER SPECIFIED GLOBAL NODE NUMBER,               
C ---                  FROM THE CALLING ROUTINE.                        
C ---             WEXIST = FLAG (SET, RESET) IF NODE (DOES, DOESNT)     
C ---                      EXIST, SENT TO THE CALLING ROUTINE           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     FOR INTERNAL NODES THIS MODULE CHECKS IF THE NODE NUMBER          
C     SPECIFIED ON AN INPUT CARD IS NON-ZERO AND CORRESPONDS TO A NODE  
C     IN THE NODE MAP. IF NODE DOES NOT EXIST, AN ERROR MESSAGE         
C     IS GENERATED.                                                     
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    CKFN35 - MODULE 2261.5111                          
C                    CKFN36 - MODULE 2261.5121                          
C                    CKSN35 - MODULE 2262.3.1.1                         
C                    CKSN36 - MODULE 2262.3.2.1                         
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     GLOBND  GLOBAL NODE SPECIFIC ARRAY - SUBNETWORK NODE AND TYPE     
C     IN      USER SPECIFIED GLOBAL NODE NUMBER                         
C     KN      SUBNETWORK SPECIFIC NODE NUMBER CORRESPONDING TO NODE IN  
C     NMAX    MAXIMUM ALLOWABLE INTERNAL NODE NUMBER (USER NODE NUMBER) 
C     WEXIST  FLAG (SET, RESET) IF NODE (DOES, DOES NOT) EXIST IN MAP   
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
      IN = I1                                                           
      WEXIST = .FALSE.                                                  
      KN = 0                                                            
      IF (IN .GT. 0 .AND. IN .LE. NMAX) KN= GLOBND(IN) / 16             
      IF (KN .GT. 0) WEXIST = .TRUE.                                    
      IF (KN .LE. 0) CALL ERGEN ('CKNODN', 2610, IN, 0, 0, 0, 1)        
      RETURN                                                            
      END                                                               
      SUBROUTINE CKSN11 (KLINK, JCHAN)                                  
C                                                                       
C                                                                       
C --- CODED    7-17-78 BY M. BURNS                                      
C --- REVISED  7-18-91 BY A. KANAAN TO CORRECT T-INTERSECTION CHECKING  
C --- REVISED 12-31-91 BY J. WERK TO REMOVE UNPACKING OF XBUF ARRAY,    
C ---                  RECOGNIZE CHANNELIZATION CODES 7-11, AND CHECK   
C ---                  THE VALIDITY OF ALL CHANNELIZATION CODES.        
C --- REVISED  1-05-93 BY J. WERK TO NOT SERVICE TURN MOVEMENTS FOR AN  
C ---                  UNCHANNELIZED LANE WHEN TURN POCKETS EXIST.      
C --- REVISED  1-20-95 BY S. WALKER TO CONSIDER EXIT INTERFACE LINKS    
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 11 DURING A        
C ---         SUBSEQUENT TIME PERIOD. - MODULE 2262.2.1                 
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS IF DATA INPUT ON CARD TYPE 11       
C ---            (DURING A SUBSEQUENT TIME PERIOD) IS CONSISTENT WITH   
C ---            THE DATA BASE DEFINED DURING THE FIRST TIME PERIOD.    
C                                                                       
C --- ARGUMENTS - KLINK - LINK NUMBER, TO CALLING ROUTINE               
C ---             JCHAN  = CONTAINS MOVEMENTS SERVICED BY EACH LANE     
C                          FOR CURRENT LINK, TO CALLING ROUTINE         
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CHECKS CARD CONTENTS (STORED IN XBUF) TO CHECK        
C     THAT THE CHANNELIZATION AND DIVERSION MOVEMENT CODES ARE          
C     ACCEPTABLE. MODULE 2.6.1.1 IS CALLED TO OUTPUT ERROR MESSAGES.    
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    LINKSN  - MODULE 2262.2                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    NLKNUM  - MODULE 2261.3112                         
C                    TBSN11  - MODULE 2262.2.1.1                        
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     I       DO LOOP INDEX AND HOLD AREA                               
C     IBUSCP  NO. OF BUS AND/OR CARPOOL LANES WHICH SERVICE THRU TRAFFIC
C     ICODE   BITS IN JCHAN CONTAINING SERVICE CODES FOR SUBJECT LANE   
C     IDIAG   CODE (0, 1) IF DIAGONAL MOVEMENT (IS, ISN'T) ALLOWED      
C     IDIAGL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE DIAGONAL TURN MOVEMENT                        
C     IDIAGR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE DIAGONAL TURN MOVEMENT                        
C     IDW     DOWNSTREAM NODE NUMBER                                    
C     II      INDEX TO DO LOOP                                          
C     ILANE   CLOSEST LANE TO THE RIGHT OF SUBJECT LANE THAT HAS A      
C             CHANNNELIZATION CODE OTHER THAN 3 OR 9                    
C     ILEFTR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE LEFT TURN MOVEMENT                            
C     ILINK   LINK NUMBER - FROM UPSTREAM AND DOWNSTREAM NODES          
C     ILN     NUMBER OF FULL LANES                                      
C     IRGHTL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE RIGHT TURN MOVEMENT                           
C     ISHLN   SHARED LANE WHICH COULD SERVICE THE THROUGH MOVEMENT      
C     ITHRU   NUMBER OF LANES WHICH SERVICE THRU TRAFFIC                
C     ITHRUL  (0,1) IF LANE TO THE LEFT OF SUBJECT LANE (DOESN'T, DOES) 
C             SERVICE THE THROUGH MOVEMENT                              
C     ITHRUR  (0,1) IF LANE TO THE RIGHT OF SUBJECT LANE (DOESN'T, DOES)
C             SERVICE THE THROUGH MOVEMENT                              
C     IUP     UPSTREAM NODE NUMBER                                      
C     I0LANE  INTERIOR UNRESTRICTED LANE                                
C     I9CNT   COUNT OF LANES WITH CHANNELIZATION CODE 9                 
C     I9LANE  LANE NUMBER WITH CHANNELIZATION CODE 9                    
C     J       HOLD AREA AND INDEX                                       
C     JLEFT   INDEX OVER XBUF ARRAY                                     
C     LANEGD  LINK SPECIFIC ARRAY - GRADE, NO FULL LANES, POCKET LANES  
C             (SET NEGATIVE IF TYPE 11 CARD INPUT DURING THIS TP)       
C     THRU    LINK SPECIFIC ARRAY - LINK RECEIVING THRU TRAFFIC         
C     WCLOSE  FLAG, SET TO .TRUE. IF ALL LANES TO THE LEFT OF LANE 1 ARE
C             CLOSED                                                    
C     WDIAG   FLAG, SET TO .TRUE. IF LINK SERVICES DIAGONAL MOVEMENT    
C     WERR    FLAG, SET TO .TRUE. IF ERROR IN CHANNELIZATION CODE FOUND 
C     WLEFT   FLAG, SET TO .TRUE. IF LINK SERVICES LEFT TURN MOVEMENT   
C     WRGHT   FLAG, SET TO .TRUE. IF LINK SERVICES RIGHT TURN MOVEMENT  
C     WSHARE  FLAG, SET TO .TRUE. IF A CHANNELIZATION CODE OF 7 OR 8    
C             WAS INPUT FOR AT LEAST ONE LANE                           
C     WTHRU   FLAG, SET TO .TRUE. IF LINK SERVICES THROUGH MOVEMENT     
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IUP = XBUF(1)                                                     
      IDW = XBUF(2)                                                     
C                                                                       
C -----  WHEN GRADE IS NEGATIVE, ABSOLUTE VALUE OF GRADE WAS INCREMENTED
C -----  BY 90 IN ROUTINE PUTCDS SO THAT TYPE 11 CARD COULD BE READ     
C -----  IN 80I4 FORMAT. REPLACE MINUS SIGN.                            
C                                                                       
      IF (XBUF(9) .GT. 90) XBUF(9) = 90 - XBUF(9)                       
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
C     CHECK BOUNDS OF EACH ITEM WHICH WAS ALLOWED TO CHANGE FOR A       
C     SUBSEQUENT TIME PERIOD. DETERMINE LINK NUMBER, ILINK,             
C     DEFINED BY NODES IUP AND IDW. GENERATE ERROR MESSAGE AND TRA IF   
C     LINK NOT FOUND                                                    
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      CALL TBSN11                                                       
      CALL NLKNUM (ILINK, IUP, IDW)                                     
      IF (ILINK .EQ. 0)                                                 
     1    CALL ERGEN ('CKSN11', 2110, IUP, IDW, 0, 0, 2)                
      IF (ILINK .EQ. 0)                                      GO TO 170  
C                                                                       
C -----  IF THIS IS A DUPLICATE TYPE 11 CARD SET ILINK TO 0 SO LINK     
C -----  WILL NOT BE STORED AND OUTPUT ERROR MESSAGE.  LANEGD IS        
C -----  NEGATIVE IF AN 11 CARD HAS ALREADY BEEN INPUT (DURING THIS TP) 
C                                                                       
      IF (LANEGD(ILINK) .LT. 0) ILINK = 0                               
      IF (ILINK .EQ. 0)                                                 
     1    CALL ERGEN ('CKSN11', 2501, IUP, IDW, 11, 0, 3)               
      IF (ILINK .EQ. 0)                                      GO TO 160  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
C     DETERMINE IF CHANNELIZATION CODES ARE ACCEPTABLE, MUST BE .LE. 11.
C     TRA IF NOT. (ERROR HAS ALREADY BEEN IDENTIFIED IN                 
C     MODULE 2262.2.1.1). ELSE, CHECK CONSISTENCY OF CHANNELIZATION     
C     CODES WITH GEOMETRY.                                              
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      I9CNT = 0                                                         
      ILN = MOD (LANEGD(ILINK) / 2**3, 2**3)                            
      J = 10                                                            
C                                                                       
C -----  DOUNTIL CHANNELIZATION CODES FOR ALL EXISTING FULL LANES ARE   
C -----  EXAMINED.                                                      
C                                                                       
      WLEFT = .FALSE.                                                   
      WTHRU = .FALSE.                                                   
      WRGHT = .FALSE.                                                   
      WDIAG = .FALSE.                                                   
      WSHARE = .FALSE.                                                  
      ISHLN = 0                                                         
      JCHAN = 0                                                         
      I0LANE = 0                                                        
      I9LANE = 0                                                        
      IBUSCP = 0                                                        
   30 CONTINUE                                                          
      WERR = .FALSE.                                                    
      J = J + 1                                                         
      IF (XBUF(J) .LT. 0  .OR.  XBUF(J) .GT. 11)             GO TO 90   
      IF (XBUF(J) .EQ. 9 .AND. XBUF(2) .LT. 7000) I9CNT = I9CNT + 1     
C                                                                       
C -----  CHECK IF LANE 1 CODE ILLOGICAL.  SET ERROR FLAG AND MOVEMENT   
C -----  FLAGS.  PACK JCHAN WITH MOVEMENT CODES.                        
C                                                                       
      IF (J .EQ. 11) THEN                                               
C                                                                       
C -----  IF LINK IS AN EXIT INTERFACE LINK, ALL LANES MUST BE THRU ONLY.
C -----  IF NOT, ISSUE A WARNING MESSAGE AND SET TO THRU ONLY.          
C                                                                       
         IF (XBUF(2) .GE. 7000) THEN                                    
             IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 11 .AND.             
     1           XBUF(J) .NE. 9)                                        
     2           CALL ERGEN ('CKFS11', 208, J-10, IUP, IDW, 0, 3)       
             WTHRU = .TRUE.                                             
             JCHAN = JCHAN + 2                                          
C                                                                       
C -----  IF LANE IS UNRESTRICTED OR CHANNELIZED FOR BUSES AND/OR        
C -----  CARPOOLS THEN IF LINK HAS ONLY ONE LANE OR ALL OTHER LANES ARE 
C -----  CLOSED, SERVICE ALL MOVEMENTS.  OTHERWISE, SERVICE RIGHT +     
C -----  RIGHT DIAGONAL OR THROUGH.  IF TURN POCKETS EXIST, DO NOT      
C -----  SERVICE TURNING TRAFFIC.                                       
C                                                                       
         ELSEIF (XBUF(11) .EQ. 0 .OR. XBUF(11) .EQ. 2 .OR.              
     1      XBUF(11) .EQ. 5 .OR. XBUF(11) .EQ. 6) THEN                  
            IF (XBUF(11) .NE. 0) IBUSCP = IBUSCP + 1                    
            WCLOSE = .TRUE.                                             
            IF (ILN .GT. 1) THEN                                        
                  DO 64 II = 12, ILN + 10                               
                     WCLOSE = WCLOSE .AND. XBUF(II) .EQ. 3              
   64             CONTINUE                                              
            ENDIF                                                       
            IF (ILN .EQ. 1 .OR. WCLOSE) THEN                            
               IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0) THEN           
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 1                                     
               ENDIF                                                    
               IF (XBUF(19) .GT. 0) THEN                                
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ENDIF                                                    
               IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN           
                  WRGHT = .TRUE.                                        
                  JCHAN = JCHAN + 4                                     
               ENDIF                                                    
               IF (XBUF(21) .NE. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
               ENDIF                                                    
            ELSE                                                        
               IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN           
                  JCHAN = JCHAN + 4                                     
                  WRGHT = .TRUE.                                        
               ENDIF                                                    
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
                  IF (IBUSCP .GT. 0) IBUSCP = 0                         
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSEIF (XBUF(20) .EQ. 0 .OR. XBUF(8) .GT. 0) THEN        
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR LEFT TURNERS THEN SET ERROR FLAG IF    
C -----  NO LEFT RECEIVER OR LANE IS FURTHER THAN 3 LANES FROM MEDIAN.  
C                                                                       
         ELSEIF (XBUF(11) .EQ. 1) THEN                                  
            IF (ILN .GT. 3 .OR. XBUF(18) .EQ. 0) THEN                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 1                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR RIGHT TURNERS THEN SET ERROR FLAG IF   
C -----  NO RIGHT RECEIVER SPECIFIED.                                   
C                                                                       
         ELSEIF (XBUF(11) .EQ. 4) THEN                                  
            IF (XBUF(20) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 4                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR RIGHT AND RIGHT DIAGONAL AND/OR     
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF NO RIGHT RECEIVER     
C -----  SPECIFIED.  SET WSHARE IF LANE SERVICES RIGHT AND RIGHT        
C -----  DIAGONAL MOVEMENTS.                                            
C                                                                       
         ELSEIF (XBUF(11) .EQ. 7) THEN                                  
            IF (XBUF(20) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 4                                        
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSE                                                     
                  CALL ERGEN ('CKSN11', 705, 1, IUP, IDW, 0, 3)         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR LEFT AND LEFT DIAGONAL AND/OR       
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF NO LEFT RECEIVER      
C -----  SPECIFIED OR LANE IS NOT WITHIN 3 FROM THE MEDIAN.  SET        
C -----  WSHARE IF LANE SERVICES LEFT AND LEFT DIAGONAL MOVEMENTS.      
C                                                                       
         ELSEIF (XBUF(11) .EQ. 8) THEN                                  
            IF (XBUF(18) .EQ. 0 .OR. ILN .GT. 3) THEN                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 1                                        
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 8                                     
                  WSHARE = .TRUE.                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2                                     
               ELSE                                                     
                  CALL ERGEN ('CKSN11', 706, 1, IUP, IDW, 0, 3)         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
         ELSEIF (XBUF(11) .EQ. 9) THEN                                  
            I9LANE = 1                                                  
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR DIAGONAL MOVEMENT THEN SET ERROR    
C -----  FLAG IF NO DIAGONAL RECEIVER WAS SPECIFIED.                    
C                                                                       
         ELSEIF (XBUF(11) .EQ. 10) THEN                                 
            IF (XBUF(21) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WDIAG = .TRUE.                                           
               JCHAN = JCHAN + 8                                        
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR THROUGH MOVEMENT THEN SET ERROR     
C -----  FLAG IF NO THROUGH RECEIVER WAS SPECIFIED.                     
C                                                                       
         ELSEIF (XBUF(11) .EQ. 11) THEN                                 
            IF (XBUF(19) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSE                                                        
               WTHRU = .TRUE.                                           
               JCHAN = JCHAN + 2                                        
            ENDIF                                                       
         ENDIF                                                          
         IF (WSHARE) ISHLN = 1                                          
      ENDIF                                                             
C                                                                       
C -----  CHECK IF LANE J'S CHANNELIZATION CODE IS ILLOGICAL.  SET ERROR 
C -----  FLAG AND MOVEMENT FLAGS.  PACK JCHAN WITH MOVEMENT CODES.      
C                                                                       
      IF (J .GT. 11) THEN                                               
C                                                                       
C -----  SET ILANE EQUAL TO THE CLOSEST LANE TO THE RIGHT OF J THAT HAS 
C -----  A CHANNELIZATION CODE OTHER THAN 3 OR 9.                       
C                                                                       
         ILANE = J                                                      
   70    CONTINUE                                                       
         ILANE = ILANE - 1                                              
         IF (XBUF(ILANE) .EQ. 3 .OR. XBUF(ILANE) .EQ. 9) THEN           
            IF (ILANE .GT. 11) THEN                                     
                                                             GO TO 70   
            ELSE                                                        
               ILANE = 0                                                
            ENDIF                                                       
         ENDIF                                                          
         WSHARE = .FALSE.                                               
C                                                                       
C -----  IF LINK IS AN EXIT INTERFACE LINK, ALL LANES MUST BE THRU ONLY.
C -----  IF NOT, ISSUE A WARNING MESSAGE AND SET TO THRU ONLY.          
C                                                                       
         IF (XBUF(2) .GE. 7000) THEN                                    
             IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 11 .AND.             
     1           XBUF(J) .NE. 9)                                        
     2           CALL ERGEN ('CKFS11', 208, J-10, IUP, IDW, 0, 3)       
             WTHRU = .TRUE.                                             
             JCHAN = JCHAN + 2**((4*(J-11))+1)                          
C                                                                       
C -----  IF LANE IS UNRESTRICTED OR CHANNELIZED FOR BUSES AND/OR        
C -----  CARPOOLS THEN SET ERROR FLAG IF ILANE IS CHANNELIZED FOR LEFT  
C -----  OR LEFT AND LEFT DIAGONAL.                                     
C                                                                       
         ELSEIF (XBUF(J) .EQ. 0 .OR. XBUF(J) .EQ. 2 .OR.                
     1      XBUF(J) .EQ. 5 .OR. XBUF(J) .EQ. 6) THEN                    
            IF (XBUF(J) .NE. 0) IBUSCP = IBUSCP + 1                     
            IF (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR. XBUF(ILANE) 
     1          .EQ. 8)) THEN                                           
               WERR = .TRUE.                                            
            ELSEIF (J-10 .LT. ILN) THEN                                 
C                                                                       
C -----  IF LANE IS AN INTERIOR LANE THEN SET ERROR FLAG IF NO THROUGH  
C -----  OR DIAGONAL MOVEMENTS SPECIFIED.                               
C                                                                       
               IF (I0LANE .EQ. 0 .OR. XBUF(19) .EQ. 0 .OR. XBUF(21)     
     1                                         .EQ. 0) THEN             
                  I0LANE = J                                            
                  IF (XBUF(19) .GT. 0 .AND. XBUF(21) .LT. 0 .AND. WDIAG)
     1                                             WERR = .TRUE.        
                  IF (XBUF(19) .GT. 0 .AND. XBUF(21) .GT. 0 .AND. WTHRU)
     1                                             WERR = .TRUE.        
                  IF (XBUF(19) .GT. 0) THEN                             
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ENDIF                                                 
                  IF (XBUF(21) .NE. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ENDIF                                                 
                  IF (XBUF(19) .EQ. 0 .AND. XBUF(21) .EQ. 0)            
     1                                              WERR = .TRUE.       
C                                                                       
C -----  IF ALL LANES TO THE RIGHT ARE CLOSED, THEN IF A RIGHT RECEIVER 
C -----  WAS SPECIFIED, SERVICE THE RIGHT TURN.                         
C                                                                       
                  IF (ILANE .EQ. 0 .AND. I9LANE .EQ. 0) THEN            
                     IF (XBUF(20) .GT. 0) THEN                          
                        WRGHT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4 * (J - 11) + 2)           
                     ENDIF                                              
                  ENDIF                                                 
               ELSE                                                     
                  CALL ERGEN ('CKSN11', 2093, IUP, IDW, 0, 0, 2)        
               ENDIF                                                    
C                                                                       
C -----  IF ALL LANES TO THE LEFT ARE CLOSED, THEN IF A LEFT RECEIVER   
C -----  WAS SPECIFIED, SERVICE THE LEFT TURN.                          
C                                                                       
               IF (XBUF(18) .GT. 0) THEN                                
                  JLEFT = J                                             
   80             CONTINUE                                              
                  JLEFT = JLEFT + 1                                     
                  IF (XBUF(JLEFT) .EQ. 3 .AND. JLEFT .LT. 10 + XBUF(6)) 
     1                                                       GO TO 80   
                  IF (JLEFT .EQ. 10 + XBUF(6) .AND. XBUF(JLEFT) .EQ. 3) 
     1                                                       THEN       
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(J-11))                      
                  ENDIF                                                 
               ENDIF                                                    
            ELSE                                                        
C                                                                       
C -----  IF LANE IS THE MEDIAN LANE THEN SET ERROR FLAG IF NO THROUGH   
C -----  OR DIAGONAL OR LEFT MOVEMENTS SPECIFIED.                       
C                                                                       
               IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0) THEN           
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(J-11))                         
               ENDIF                                                    
C                                                                       
C -----  IF ALL LANES TO THE RIGHT ARE CLOSED, THEN IF A RIGHT OR RIGHT 
C -----  DIAGONAL RECEIVER WAS SPECIFIED, SERVICE THOSE MOVEMENTS.  DO  
C -----  NOT SERVICE A RIGHT IF A RIGHT POCKET EXISTS.                  
C                                                                       
               IF (ILANE .EQ. 0 .AND. I9LANE .EQ. 0) THEN               
                  IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0) THEN        
                     WRGHT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4 * (J - 11) + 2)              
                  ENDIF                                                 
                  IF (XBUF(21) .GT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ENDIF                                                 
               ENDIF                                                    
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  WSHARE = .TRUE.                                       
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
                  IF (IBUSCP .GT. 0) IBUSCP = IBUSCP - 1                
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+1)                     
               ELSEIF (XBUF(18) .EQ. 0 .OR. XBUF(7) .GT. 0) THEN        
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR LEFT TURNERS THEN SET ERROR FLAG IF    
C -----  NO LEFT RECEIVER OR LANE IS FURTHER THAN 3 LANES FROM MEDIAN.  
C                                                                       
         ELSEIF (XBUF(J) .EQ. 1) THEN                                   
            IF (XBUF(18) .EQ. 0 .OR. ILN - (J-10) + 1 .GT. 3) THEN      
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 2**(4*(J-11))                            
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR RIGHT OR RIGHT AND RIGHT DIAGONAL   
C -----  AND/OR THROUGH MOVEMENTS THEN SET ERROR FLAG IF LANE IS        
C -----  FURTHER THAN 3 LANES FROM THE CURB OR NO RIGHT RECEIVER WAS    
C -----  SPECIFIED OR ILANE IS NOT CHANNELIZED EXCLUSIVELY FOR RIGHT    
C -----  TURNERS.  SET WSHARE IF LANE SERVICES RIGHT AND RIGHT          
C -----  DIAGONAL MOVEMENTS.                                            
C                                                                       
         ELSEIF (XBUF(J) .EQ. 4 .OR. XBUF(J) .EQ. 7) THEN               
            IF (J-10 .GT. 3 .OR. XBUF(20) .EQ. 0 .OR. (ILANE .GT. 0     
     1                           .AND. XBUF(ILANE) .NE. 4)) THEN        
               WERR = .TRUE.                                            
            ELSE                                                        
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 2**((4*(J-11))+2)                        
               IF (XBUF(J) .EQ. 7) THEN                                 
                  IF (XBUF(21) .GT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     WSHARE = .TRUE.                                    
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ELSEIF (XBUF(19) .GT. 0) THEN                         
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ELSE                                                  
                     CALL ERGEN ('CKSN11', 705, J-10, IUP, IDW, 0, 3)   
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR LEFT AND LEFT DIAGONAL AND/OR       
C -----  THROUGH MOVEMENTS THEN SET ERROR FLAG IF LANE IS FURTHER THAN  
C -----  3 LANES FROM THE MEDIAN OR NO LEFT RECEIVER WAS SPECIFIED OR   
C -----  ILANE IS NOT CHANNELIZED EXCLUSIVELY FOR LEFT TURNERS.  SET    
C -----  WSHARE IF LANE SERVICES LEFT AND LEFT DIAGONAL MOVEMENTS.      
C                                                                       
         ELSEIF (XBUF(J) .EQ. 8) THEN                                   
            IF (XBUF(18) .EQ. 0 .OR. ILN - (J-10) + 1 .GT. 3 .OR.       
     1          (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR.            
     2          XBUF(ILANE) .EQ. 8))) THEN                              
               WERR = .TRUE.                                            
            ELSE                                                        
               WLEFT = .TRUE.                                           
               JCHAN = JCHAN + 2**(4*(J-11))                            
               IF (XBUF(J) .EQ. 8) THEN                                 
                  IF (XBUF(21) .LT. 0) THEN                             
                     WDIAG = .TRUE.                                     
                     WSHARE = .TRUE.                                    
                     JCHAN = JCHAN + 2**((4*(J-11))+3)                  
                  ELSEIF (XBUF(19) .GT. 0) THEN                         
                     WTHRU = .TRUE.                                     
                     JCHAN = JCHAN + 2**((4*(J-11))+1)                  
                  ELSE                                                  
                     CALL ERGEN ('CKSN11', 706, J-10, IUP, IDW, 0, 3)   
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
         ELSEIF (XBUF(J) .EQ. 9) THEN                                   
            I9LANE = J - 10                                             
C                                                                       
C -----  IF LANE IS CHANNELIZED FOR DIAGONAL MOVEMENT THEN SET ERROR    
C -----  FLAG IF NO DIAGONAL RECEIVER WAS SPECIFIED.                    
C                                                                       
         ELSEIF (XBUF(J) .EQ. 10) THEN                                  
            IF (XBUF(21) .EQ. 0) THEN                                   
               WERR = .TRUE.                                            
            ELSEIF (XBUF(21) .GT. 0) THEN                               
C                                                                       
C -----  IF RIGHT DIAGONAL SPECIFIED THEN SET ERROR FLAG IF ILANE       
C -----  SERVICES ANY OTHER MOVEMENTS BESIDES RIGHT AND RIGHT DIAGONAL. 
C                                                                       
               IF (ILANE .EQ. 0 .OR. (ILANE .GT. 0 .AND. (XBUF(ILANE)   
     1             .EQ. 4 .OR. XBUF(ILANE) .EQ. 7 .OR. XBUF(ILANE)      
     2             .EQ. 10 .OR. (ILANE .NE. 11 .AND. (XBUF(ILANE) .EQ. 0
     3             .OR. XBUF(ILANE) .EQ. 2 .OR. XBUF(ILANE) .EQ. 5 .OR. 
     4             XBUF(ILANE) .EQ. 6) .AND. XBUF(19) .EQ. 0) .OR.      
     5             (ILANE .EQ. 11 .AND. XBUF(ILANE) .EQ. 0)))) THEN     
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
               ELSE                                                     
                  WERR = .TRUE.                                         
               ENDIF                                                    
            ELSE                                                        
C                                                                       
C -----  IF LEFT DIAGONAL SPECIFIED THEN SET ERROR FLAG IF ILANE        
C -----  SERVICES LEFT TURNERS.                                         
C                                                                       
               IF (ILANE .GT. 0 .AND. (XBUF(ILANE) .EQ. 1 .OR.          
     1              XBUF(ILANE) .EQ. 8)) THEN                           
                  WERR = .TRUE.                                         
               ELSE                                                     
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(J-11))+3)                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF LANE CHANNELIZED FOR THROUGH MOVEMENT ONLY THEN SET ERROR   
C -----  FLAG IF NO THROUGH MOVEMENT SPECIFIED OR ILANE SERVICES EITHER 
C -----  LEFT, LEFT DIAGONAL.                                           
C                                                                       
         ELSEIF (XBUF(J) .EQ. 11) THEN                                  
            IF (XBUF(19) .EQ. 0 .OR. (ILANE .GT. 0 .AND. (XBUF(ILANE)   
     1         .EQ. 1 .OR. XBUF(ILANE) .EQ. 8 .OR. (XBUF(ILANE) .EQ. 10 
     2         .AND. XBUF(21) .LT. 0) .OR. ((XBUF(ILANE) .EQ. 0 .OR.    
     3         XBUF(ILANE) .EQ. 2 .OR. XBUF(ILANE) .EQ. 5 .OR.          
     4         XBUF(ILANE) .EQ. 6) .AND. ILANE .NE. 11 .AND. XBUF(21)   
     5         .LT. 0)))) THEN                                          
               WERR = .TRUE.                                            
            ELSE                                                        
               WTHRU  = .TRUE.                                          
               JCHAN = JCHAN + 2**((4*(J-11))+1)                        
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  IF A SHARED LANE AND A RIGHT DIAGONAL WERE SPECIFIED THEN      
C -----  STORE SHARED LANE NUMBER IN ISHLN.  OTHERWISE, IF A LEFT       
C -----  DIAGONAL WAS SPECIFIED AND THIS IF THE FIRST SHARED LANE, THEN 
C -----  STORE THE SHARED LANE NUMBER IN ISHLN.                         
C                                                                       
         IF (WSHARE .AND. XBUF(21) .GT. 0) ISHLN = J - 10               
         IF (WSHARE .AND. XBUF(21) .LT. 0 .AND. ISHLN .EQ. 0)           
     1       ISHLN = J - 10                                             
      ENDIF                                                             
   90 CONTINUE                                                          
      IF (WERR) CALL ERGEN ('CKSN11', 2083, J-10, IUP, IDW, 0, 3)       
      IF (J .LT. ILN + 10)                                   GO TO 30   
C                                                                       
C ----   CHECK THAT ONLY ONE LANE CHANNELIZED WITH CODE 9 AND AT LEAST  
C -----  ONE LANE WILL SERVICE ALL SPECIFIED TURN MOVEMENTS.            
C                                                                       
      IF (WERR)                                              GO TO 130  
      IF (I9CNT .GT. 1) THEN                                            
         CALL ERGEN ('CKSN11', 2088, IUP, IDW, 0, 0, 2)                 
      ELSEIF (I9LANE .NE. 0) THEN                                       
         ILEFTR = 0                                                     
         ITHRUL = 0                                                     
         ITHRUR = 0                                                     
         IRGHTL = 0                                                     
         IDIAGL = 0                                                     
         IDIAGR = 0                                                     
C                                                                       
C -----  SET ITHRUL, IRGHTL, IDIAGL EQUAL TO ONE IF LANE TO THE LEFT OF 
C -----  I9LANE SERVICES THAT MOVEMENT.                                 
C                                                                       
         IF (I9LANE .NE. ILN) THEN                                      
            J = I9LANE                                                  
   95       CONTINUE                                                    
            J = J + 1                                                   
            ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                     
            IF (ICODE .EQ. 0 .AND. J .LT. 7) THEN                       
                                                             GO TO 95   
            ELSEIF (ICODE .NE. 0) THEN                                  
               ITHRUL = MOD(ICODE / 2, 2)                               
               IRGHTL = MOD(ICODE / 4, 2)                               
               IDIAGL = MOD(ICODE / 8, 2)                               
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  SET ILEFTR, ITHRUR, IDIAGR EQUAL TO ONE IF LANE TO THE RIGHT OF
C -----  I9LANE SERVICES THAT MOVEMENT.                                 
C                                                                       
         IF (I9LANE .NE. 1) THEN                                        
            J = I9LANE                                                  
  100       CONTINUE                                                    
            J = J - 1                                                   
            ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                     
            IF (ICODE .EQ. 0 .AND. J .GT. 1) THEN                       
                                                             GO TO 100  
            ELSEIF (ICODE .NE. 0) THEN                                  
               ILEFTR = MOD(ICODE, 2)                                   
               ITHRUR = MOD(ICODE / 2, 2)                               
               IDIAGR = MOD(ICODE / 8, 2)                               
            ENDIF                                                       
         ENDIF                                                          
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES LEFT TURNERS       
C -----  THEN I9LANE WILL ONLY SERVICE LEFT TURNERS.                    
C                                                                       
         IF (ILEFTR .EQ. 1) THEN                                        
            WLEFT = .TRUE.                                              
            JCHAN = JCHAN + 2**(4*(I9LANE-1))                           
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES LEFT DIAGONAL      
C -----  TURNERS THEN I9LANE WILL SERVICE LEFT DIAGONAL TURNERS.        
C -----  IF THE LANE TO THE LEFT OF I9LANE DOESN'T SERVICE THE LEFT     
C -----  DIAGONAL MOVEMENT THEN IF A LEFT MOVEMENT WAS SPECIFIED AND    
C -----  I9LANE IS WITHIN 3 LANES FROM THE MEDIAN THEN I9LANE WILL      
C -----  ALSO SERVICE LEFT TURNERS.                                     
C                                                                       
         ELSEIF (IDIAGR .EQ. 1 .AND. XBUF(21) .LT. 0) THEN              
            WDIAG = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                       
            IF (IDIAGL .NE. 1) THEN                                     
               IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN      
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES THROUGH TRAFFIC    
C -----  THEN I9LANE WILL ALSO SERVICE THROUGH TRAFFIC.  IF THE LANE    
C -----  TO THE LEFT OF I9LANE DOES NOT SERVICE THROUGH TRAFFIC THEN    
C -----  IF A LEFT DIAGONAL WAS SPECIFIED THEN I9LANE WILL SERVICE      
C -----  THE LEFT DIAGONAL MOVEMENT.  IF THE LANE TO LEFT OF I9LANE     
C -----  DOES NOT SERVICE THE LEFT DIAGONAL MOVEMENT THEN IF A LEFT     
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN     
C -----  IT WILL ALSO SERVICE THE LEFT TURN MOVEMENT.                   
C                                                                       
         ELSEIF (ITHRUR .EQ. 1) THEN                                    
            WTHRU = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                       
            IF (ITHRUL .NE. 1) THEN                                     
               IF (XBUF(21) .LT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1 .AND. XBUF(18) .GT. 0 .AND.         
     1                        ILN - I9LANE .LT. 3) THEN                 
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(I9LANE-1))                  
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO LEFT DIAGONAL MOVEMENT SO IF A LEFT     
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN     
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  IF THE LANE TO THE RIGHT OF I9LANE SERVICES RIGHT DIAGONAL     
C -----  TRAFFIC THEN I9LANE WILL ALSO SERVICE RIGHT DIAGONAL TRAFFIC.  
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE RIGHT       
C -----  DIAGONAL TRAFFIC THEN IF A THROUGH MOVEMENT WAS SPECIFIED THEN 
C -----  I9LANE WILL SERVICE THE THROUGH MOVEMENT.  IF THE LANE TO LEFT 
C -----  OF I9LANE DOES NOT SERVICE THE THROUGH MOVEMENT THEN IF A LEFT 
C -----  WAS SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN IT  
C -----  WILL ALSO SERVICE THE LEFT TURN MOVEMENT.                      
C                                                                       
         ELSEIF (IDIAGR .EQ. 1 .AND. XBUF(21) .GT. 0) THEN              
            WDIAG = .TRUE.                                              
            JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                       
            IF (IDIAGL .NE. 1) THEN                                     
               IF (XBUF(19) .GT. 0) THEN                                
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                 
                  IF (ITHRUL .NE. 1 .AND. XBUF(18) .GT. 0 .AND.         
     1                        ILN - I9LANE .LT. 3) THEN                 
                     WLEFT = .TRUE.                                     
                     JCHAN = JCHAN + 2**(4*(I9LANE-1))                  
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT WAS       
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN         
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  OTHERWISE, THE LANE TO THE RIGHT OF I9LANE SERVICES RIGHT      
C -----  TRAFFIC OR NO TRAFFIC (CLOSED OR DOES NOT EXIST) THEN I9LANE   
C -----  WILL SERVICE RIGHT TRAFFIC IF A RIGHT EXISTS AND I9LANE IS     
C -----  WITHIN 3 LANES FROM THE CURB.  IF THE LANE TO THE LEFT OF      
C -----  I9LANE DOES NOT SERVICE RIGHT TRAFFIC THEN IF RIGHT DIAGONAL   
C -----  TRAFFIC WAS SPECIFIED THEN I9LANE WILL SERVICE THE RIGHT       
C -----  DIAGONAL TRAFFIC. IF THE LANE TO THE LEFT OF I9LANE DOES NOT   
C -----  SERVICE RIGHT DIAGONAL TRAFFIC THEN IF A THROUGH MOVEMENT WAS  
C -----  SPECIFIED THEN I9LANE WILL SERVICE THE THROUGH MOVEMENT.  IF   
C -----  THE LANE TO LEFT OF I9LANE DOES NOT SERVICE THE THROUGH        
C -----  MOVEMENT THEN IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3   
C -----  LANES FROM THE MEDIAN IT WILL ALSO SERVICE THE LEFT TURN       
C -----  MOVEMENT.                                                      
C                                                                       
         ELSE                                                           
            IF (XBUF(20) .GT. 0 .AND. I9LANE .LE. 3) THEN               
               WRGHT = .TRUE.                                           
               JCHAN = JCHAN + 2**((4*(I9LANE-1))+2)                    
            ENDIF                                                       
            IF (IRGHTL .NE. 1) THEN                                     
               IF (XBUF(21) .GT. 0) THEN                                
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1) THEN                               
                     IF (XBUF(19) .GT. 0) THEN                          
                        WTHRU = .TRUE.                                  
                        JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)           
                        IF (ITHRUL .NE. 1) THEN                         
                           IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE       
     1                                                     .LT. 3) THEN 
                              WLEFT = .TRUE.                            
                              JCHAN = JCHAN + 2**(4*(I9LANE-1))         
                           ENDIF                                        
                        ENDIF                                           
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT WAS       
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN         
C -----  I9LANE WILL SERVICE THE LEFT TURN MOVEMENT.                    
C                                                                       
                     ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE         
     1                                                     .LT. 3) THEN 
                        WLEFT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4*(I9LANE-1))               
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO RIGHT DIAGONAL MOVEMENT SO IF A THROUGH 
C -----  WAS SPECIFIED THEN I9LANE WILL SERVICE THE THROUGH MOVEMENT.   
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE THE THROUGH 
C -----  MOVEMENT THEN IF A LEFT DIAGONAL WAS SPECIFIED I9LANE WILL     
C -----  SERVICE THE LEFT DIAGONAL.  IF THE LANE TO THE LEFT DOES NOT   
C -----  SERVICE THE LEFT DIAGONAL THEN IF A LEFT WAS SPECIFIED AND     
C -----  I9LANE IS WITHIN 3 LANES FROM THE MEDIAN I9LANE WILL SERVICE   
C -----  THE LEFT TURN MOVEMENT.                                        
C                                                                       
               ELSEIF (XBUF(19) .GT. 0) THEN                            
                  WTHRU = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+1)                 
                  IF (ITHRUL .NE. 1) THEN                               
                     IF (XBUF(21) .LT. 0) THEN                          
                        WDIAG = .TRUE.                                  
                        JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)           
                        IF (IDIAGL .NE. 1) THEN                         
                           IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE       
     1                                                     .LT. 3) THEN 
                              WLEFT = .TRUE.                            
                              JCHAN = JCHAN + 2**(4*(I9LANE-1))         
                           ENDIF                                        
                        ENDIF                                           
C                                                                       
C -----  OTHERWISE, THERE IS NO LEFT DIAGONAL MOVEMENT SO IF A LEFT WAS 
C -----  SPECIFIED AND I9LANE IS WITHIN 3 LANES FROM THE MEDIAN I9LANE  
C -----  WILL SERVICE THE LEFT TURN MOVEMENT.                           
C                                                                       
                     ELSE                                               
                        IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3)  
     1                                                             THEN 
                           WLEFT = .TRUE.                               
                           JCHAN = JCHAN + 2**(4*(I9LANE-1))            
                        ENDIF                                           
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, THERE IS NO THROUGH MOVEMENT SO IF A LEFT DIAGONAL  
C -----  WAS SPECIFIED THEN I9LANE WILL SERVICE THE DIAGONAL MOVEMENT.  
C -----  IF THE LANE TO THE LEFT OF I9LANE DOES NOT SERVICE THE DIAGONAL
C -----  MOVEMENT THEN IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3   
C -----  LANES FROM THE MEDIAN I9LANE WILL SERVICE THE LEFT TURN        
C -----  MOVEMENT.                                                      
C                                                                       
               ELSEIF (XBUF(21) .LT. 0) THEN                            
                  WDIAG = .TRUE.                                        
                  JCHAN = JCHAN + 2**((4*(I9LANE-1))+3)                 
                  IF (IDIAGL .NE. 1) THEN                               
                     IF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN
                        WLEFT = .TRUE.                                  
                        JCHAN = JCHAN + 2**(4*(I9LANE-1))               
                     ENDIF                                              
                  ENDIF                                                 
C                                                                       
C -----  OTHERWISE, IF A LEFT WAS SPECIFIED AND I9LANE IS WITHIN 3      
C -----  LANES FROM THE MEDIAN I9LANE WILL SERVICE THE LEFT TURN        
C -----  MOVEMENT.                                                      
C                                                                       
               ELSEIF (XBUF(18) .GT. 0 .AND. ILN - I9LANE .LT. 3) THEN  
                  WLEFT = .TRUE.                                        
                  JCHAN = JCHAN + 2**(4*(I9LANE-1))                     
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C -----  CHECK THAT AT LEAST ONE LANE WILL SERVICE ALL MOVEMENTS        
C -----  DEFINED BY RECEIVERS                                           
C                                                                       
      IF (XBUF(18) .GT. 0 .AND. XBUF(7) .EQ. 0 .AND. (.NOT. WLEFT))     
     1   CALL ERGEN ('CKSN11', 2089, IUP, IDW, 0, 0, 2)                 
      IF (XBUF(20) .GT. 0 .AND. XBUF(8) .EQ. 0 .AND. (.NOT. WRGHT))     
     1   CALL ERGEN ('CKSN11', 2094, IUP, IDW, 0, 0, 2)                 
      IF (XBUF(21) .NE. 0 .AND. (.NOT. WDIAG)) CALL ERGEN ('CKSN11',    
     1   2091, IUP, IDW, 0, 0, 2)                                       
C                                                                       
C -----  COMPUTE NUMBER OF LANES WHICH SERVICE THE THROUGH MOVEMENT.    
C                                                                       
      ITHRU = 0                                                         
      IF (WTHRU) THEN                                                   
         J = 1                                                          
  105    CONTINUE                                                       
         J = J + 1                                                      
         IF (MOD (JCHAN/2**((J-1)*4+1), 2) .EQ. 1) ITHRU = ITHRU + 1    
         IF (J .LT. ILN)                                     GO TO 105  
      ENDIF                                                             
C                                                                       
C -----  IF A SHARED LANE WAS SPECIFIED THEN IF THE LANE ADJACENT       
C -----  TO THE SHARED LANE SERVICES THE DIAGONAL MOVEMENT CALL         
C -----  ERROR MESSAGE GENERATOR.  OTHERWISE, SHARED LANE WILL ALSO     
C -----  SERVICE THROUGH MOVEMENT.                                      
C                                                                       
      IF (XBUF(19) .NE. 0.AND.(.NOT. WTHRU .OR. IBUSCP .EQ. ITHRU)) THEN
         IF (WSHARE) THEN                                               
            IDIAG = 0                                                   
            IF (XBUF(21) .GT. 0) THEN                                   
               J = ISHLN                                                
  110          CONTINUE                                                 
               J = J + 1                                                
               ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                  
               IF (ICODE .EQ. 0 .AND. J .LT. 7) THEN                    
                                                             GO TO 110  
               ELSEIF (ICODE .NE. 0) THEN                               
                  IDIAG = MOD(ICODE / 8, 2)                             
               ENDIF                                                    
            ELSE                                                        
               J = ISHLN                                                
  120          CONTINUE                                                 
               J = J - 1                                                
               ICODE = MOD(JCHAN / 2**((J-1)*4), 2**4)                  
               IF (ICODE .EQ. 0 .AND. J .GT. 1) THEN                    
                                                             GO TO 120  
               ELSEIF (ICODE .NE. 0) THEN                               
                  IDIAG = MOD(ICODE / 8, 2)                             
               ENDIF                                                    
            ENDIF                                                       
            IF (IDIAG .EQ. 0) THEN                                      
               JCHAN = JCHAN + 2**((4*(ISHLN-1))+1)                     
            ELSE                                                        
               CALL ERGEN ('CKSN11', 2092, IUP, IDW, 0, 0, 2)           
            ENDIF                                                       
         ELSE                                                           
            CALL ERGEN ('CKSN11', 2092, IUP, IDW, 0, 0, 2)              
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
      IF (ILN .EQ. 7)                                        GO TO 150  
      J = ILN + 11                                                      
C                                                                       
C -----  CHECK WHETHER A CHANNELIZATION CODE WAS SPECIFIED FOR A        
C -----  NON-EXISTING LANE                                              
C                                                                       
  130 CONTINUE                                                          
         DO 140 I = J, 17                                               
            IF (XBUF(I) .NE. 0)                                         
     1     CALL ERGEN ('CKSN11', 2084, XBUF(I), I-10, IUP,              
     2                 IDW, 4)                                          
  140    CONTINUE                                                       
  150 CONTINUE                                                          
  160 CONTINUE                                                          
  170 CONTINUE                                                          
      KLINK = ILINK                                                     
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKSN35 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    2-20-87 BY K. SHERIDAN                                   
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 35 FOR             
C ---         SUBSEQUENT TIME PERIOD - MODULE 2262.3.1.1                
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 35 FOR A SUBSEQUENT TIME PERIOD     
C                                                                       
C --- ARGUMENTS - WERR = FLAG (SET, RESET) IF SUBJECT NODE OR ONE OF    
C ---                    THE NODES DEFINING APPROACH LINKS (IS NOT, IS) 
C ---                    VALID, TO CALLING ROUTINE                      
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CALLS SUBORDINATE ROUTINES TO CHECK THE DATA AND THE  
C     VALIDITY OF THE NODE LISTED ON THE TYPE 35 CARD. ALL APPROACHES   
C     ARE CHECKED TO BE SURE THEIR ORDER IS THE SAME AS THE ORDER       
C     INPUT FOR THE FIRST TIME PERIOD.                                  
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDSN35 - MODULE 2262.3.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN35 - MODULE 2261.5111.1                        
C                    CKNODN - MODULE 2261.5111.2                        
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     GLOBND  PACKED SUBNETWORK NUMBER AND SUBNETWORK SPECIFIC NODE NO. 
C     I       DO-LOOP INDEX OVER APPROACHES TO NODE XBUF(1)             
C     IA      LOCATION OF AN APPROACH NUMBER IN XBUF                    
C     ILINK   LINK NUMBER OF APPROACH TO NODE XBUF(1)                   
C     IN      USERS NODE NUMBER IDENTIFYING INTERSECTION                
C     JK      INDEX TO LINKS IN SIGI ARRAY FOR NODE, IN                 
C     JN      USER SPECIFIED APPROACH NODE NUMBER                       
C     KN      SUBNETWORK NODE NUMBER CORRESPONDING TO NODE, IN          
C     SIGI    NODE SPECIFIC ARRAY - LINK ID NUMBER (APPROACH SPECIFIC)  
C     WERR    FLAG IS (SET, RESET) IF NODE (IS NOT, IS) VALID           
C     WEXIST  FLAG IS (SET, RESET) IF NODE (DOES, DOES NOT) EXIST       
C     XBUF    INPUT CARD BUFFER                                         
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  RESET FLAG, CALL MODULES TO CHECK EACH DATA ITEM AND VALIDITY  
C -----  OF NODE                                                        
C                                                                       
      WERR = .TRUE.                                                     
      CALL TBFN35                                                       
      IN = XBUF(1)                                                      
      CALL CKNODN (IN, WEXIST)                                          
C                                                                       
C -----  WHEN NODE EXISTS, LOOP OVER APPROACHES AND GET LINK NUMBER.    
C -----  COMPARE WITH LINK NUMBERS STORED IN SIGI ARRAY TO BE SURE      
C -----  THAT ORDER OF APPROACHES IS SAME AS FOR FIRST TIME PERIOD.     
C                                                                       
      IF (WEXIST) THEN                                                  
         WERR = .FALSE.                                                 
         KN = GLOBND(IN) / 16                                           
         JK = 5 * (KN - 1)                                              
         DO 10 I = 1, 5                                                 
            IA = I + 2                                                  
            JK = JK + 1                                                 
            JN = XBUF(IA)                                               
            IF (JN .GT. 0) THEN                                         
                CALL NLKNUM (ILINK, JN, IN)                             
                IF (ILINK .NE. SIGI(JK))                                
     1              CALL ERGEN ('CKSN35', 5205, JN, I, XBUF(1), IA, 4)  
            ELSE                                                        
                IF (SIGI(JK) .GT. 0)                                    
     1              CALL ERGEN ('CKSN35', 5206, XBUF(1), I, IA, 0, 3)   
            ENDIF                                                       
   10    CONTINUE                                                       
C                                                                       
C -----  A SIGN CONTROL IMPLIES NO OFFSET INPUT                         
C                                                                       
         IF (XBUF(8) .EQ. 0 .AND. XBUF(2) .GT. 0) CALL ERGEN            
     1      ('CKSN35', 260, IN, 0, 0, 0, 1)                             
C                                                                       
C -----  A SINGLE INTERVAL DURATION CANNOT BE SPECIFIED FOR ANY NODE    
C                                                                       
         IF (XBUF(8) .NE. 0  .AND.  XBUF(9) .EQ. 0)                     
     1       CALL ERGEN ('CKSN35', 2629, IN, 0, 0, 0, 1)                
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKSN36 (WERR)                                          
C                                                                       
C                                                                       
C --- CODED    2-20-87 BY K. SHERIDAN                                   
C                                                                       
C --- TITLE - CHECK CONSISTENCY OF DATA IN CARD TYPE 36 FOR             
C ---         SUBSEQUENT TIME PERIOD - MODULE 2262.3.2.1                
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE DATA  
C ---            ITEMS ON CARD TYPE 36 FOR A SUBSEQUENT TIME PERIOD     
C                                                                       
C --- ARGUMENTS - WERR - ERROR FLAG (SET, RESET) IF NODE (IS NOT, IS)   
C ---                    IN NODE MAP, SENT TO CALLING ROUTINE           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     AFTER UNPACKING EACH DATA ITEM FROM XBUF AND STORING THEM BACK    
C     IN XBUF, EACH DATA ITEM IS CHECKED. IF NODE CONTROLLED BY SIGNS   
C     ALL APPROACHES ARE CHECKED FOR O CONTROL CODES. IF FIXED TIME     
C     CONTROL, APPROACHES ARE CHECKED TO INSURE HIGHEST INTERVAL NUMBER 
C     HAS A NON-ZERO DURATION. CHECKS ARE MADE TO INSURE A CONTROL CODE 
C     FOR EACH APPROACH, AND THERE ARE ENOUGH INTERVALS SPECIFIED FOR   
C     EACH APPROACH. THE FINAL TEST CHECKS FOR A REDUNDANT CARD.        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDSN36 - MODULE 2262.3.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    CKNODN - MODULE 2261.5111.2                        
C                    TBFN36 - MODULE 2261.5121.1                        
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     GLOBND  PACKED SUBNETWORK NUMBER AND SUBNETWORK SPECIFIC NODE NO. 
C     I       INDEX TO UNIFORM 4 DIGIT FIELD IN XBUF                    
C     IA      APPROACH NUMBER                                           
C     ICOD    VALUE OF SIGNAL CONTROL CODE                              
C     IJ      INDEX TO SIGI FOR NODE IN AND APPROACH IA                 
C     IK      INDEX TO SIGI FOR NODE IN                                 
C     IL      LINK NUMBER OF APPROACH 1                                 
C     ILAST   NUMBER OF INTERVALS SPECIFIED FOR APPROACH IA             
C     ILMAX   MAXIMUM NUMBER OF INTERVALS SPECIFIED FOR ANY APPROACH    
C     IMAXAP  MAXIMUM NUMBER OF APPROACHES FOR WHICH SIGNAL CODES ARE   
C             SPECIFIED                                                 
C     IN      SUBNETWORK NODE NUMBER CORRESPONDING TO NODE KN           
C     INT     INTERVAL NUMBER                                           
C     INTNUM  NUMBER OF INTERVALS (DEFINED ON TYPE 35 CARD)             
C     J       INDEX TO XBUF WHEN XBUF CONTAINS INDIVIDUAL DATA ITEMS    
C     JA      COUNTER OF APPROACHES TO NODE IN                          
C     JNT     LOOPING COUNTER USED TO SCAN INTERVALS IN REVERSE ORDER   
C     K       LOOPING COUNTER FOR LOADING DATA ITEMS SEPARATELY IN XBUF 
C     KN      USER SPECIFIED NODE NUMBER                                
C     PFZPNT  NODE SPECIFIC ARRAY - POINTER TO PDURNT ARRAY             
C     PNACT   NODE SPECIFIC ARRAY - TYPE OF CONTROL AT BEGIN OF SIGNAL  
C             TRANSITION                                                
C     SIGI    NODE SPECIFIC ARRAY - LINK ID NUMBER (APPROACH SPECIFIC)  
C     WERR    ERROR FLAG (FALSE IF NO ERRORS)                           
C     WEXIST  NODE EXISTANCE FLAG (TRUE IF NODE EXISTS)                 
C     WGREEN  FLAG (T,F) IF (ANY,NO) APPROACH HAS A GREEN INDICATION    
C     XBUF    INPUT CARD BUFFER                                         
C     XPINT1  LINK SPECIFIC ARRAY - CONTROL CODES FOR INTERVALS 1 - 6   
C             DURING AND AFTER SIGNAL TRANSITION                        
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION ILAST(5)                                                
C                                                                       
C -----  STORE EACH OF THE 61 DATA ITEMS IN ITS OWN XBUF LOCATION       
C                                                                       
      KN = XBUF(1)                                                      
      XBUF(63) = MOD (XBUF(18), 100) * 1000 + XBUF(19) / 10             
      XBUF(62) = MOD (XBUF(17), 1000) * 100 + XBUF(18) / 100            
      XBUF(61) = XBUF(17) / 1000                                        
      I = 17                                                            
      J = 61                                                            
   10 CONTINUE                                                          
      I = I - 1                                                         
      IJ = XBUF(I)                                                      
      DO 20 K = 1, 3                                                    
         J = J - 1                                                      
         IK = IJ / 10                                                   
         XBUF(J) = IJ - IK * 10                                         
         IJ = IK                                                        
20    CONTINUE                                                          
      J = J - 1                                                         
      XBUF(J) = IK                                                      
      IF (I .GT. 2)                                          GO TO 10   
      XBUF(J) = KN                                                      
C                                                                       
C -----  SET ERROR FLAG, CHECK EACH DATA ITEM, CHECK IF NODE EXISTS.    
C                                                                       
      WERR = .TRUE.                                                     
      CALL TBFN36                                                       
      CALL CKNODN (XBUF(1), WEXIST)                                     
C                                                                       
C -----  GET SUBNETWORK SPECIFIC NODE NUMBER IF NODE EXISTS IN NODE MAP.
C                                                                       
      IF (WEXIST) THEN                                                  
         WERR = .FALSE.                                                 
         IN = GLOBND(KN) / 16                                           
         IK = 5 * (IN - 1)                                              
C                                                                       
C -----  PRINT ERROR MESSAGE IF NO CARD TYPE 35 INPUT FOR NODE, IN.     
C -----  ELSE, CALCULATE NUMBER OF APPROACHES, JA, AND CLEAR ILAST      
C -----  ARRAY.                                                         
C                                                                       
         IF (PNACT(IN) .EQ. -9) THEN                                    
            CALL ERGEN ('CKSN36', 2623, KN, 0, 0, 0, 1)                 
         ELSE                                                           
            IJ = IK                                                     
            JA = 0                                                      
            DO 30 IA = 1, 5                                             
               IJ = IJ + 1                                              
               IF (SIGI(IJ) .GT. 0) JA = JA + 1                         
               ILAST(IA) = 0                                            
30          CONTINUE                                                    
            IMAXAP = JA                                                 
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
C     MAKE CHECKS IF NODE, IN, HAS SIGN CONTROL. FIRST CHECK IF         
C     MORE THAN ONE SIGNAL INTERVAL SPECIFIED.                          
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
            IF (PNACT(IN) .NE. 0) THEN                                  
                DO 40 J = 7, 16                                         
                   IF (XBUF(J) .GT. 0) CALL ERGEN ('CKSN36', 2611,      
     1                                             KN, J, 0, 0, 2)      
   40           CONTINUE                                                
C                                                                       
C -----  IF THERE ARE APPROACHES, CHECK THAT VALID CODES WERE           
C -----  SPECIFIED.                                                     
C                                                                       
               IF (JA .GT. 0) THEN                                      
                  DO 50 J = 1, JA                                       
                     ICOD = XBUF(J+1)                                   
                     IF (ICOD .GT. 1 .AND. ICOD .NE. 5) CALL ERGEN      
     1                        ('CKSN36', 2624, ICOD, KN, J+1, 0, 3)     
   50             CONTINUE                                              
               ENDIF                                                    
C                                                                       
C -----  DETERMINE IF SIGNAL CODES ARE SPECIFIED FOR MORE APPROACHES    
C -----  THAN WERE IDENTIFIED ON CARD TYPE 35.                          
C                                                                       
               IF (JA .GT. 0 .AND. JA .LT. 5) THEN                      
                  IA = JA                                               
   55             CONTINUE                                              
                  IA = IA + 1                                           
                  IF (XBUF(IA+1) .GT. 0) IMAXAP = MAX0 (IMAXAP, IA)     
                  IF (IA .LT. 5)                             GO TO 55   
               ENDIF                                                    
            ELSE                                                        
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
C     CONTROL IS FIXED TIME. PRINT MESSAGE IF NO APPROACHES SPECIFIED.  
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
               IF (JA .EQ. 0) THEN                                      
                  CALL ERGEN ('CKSN36', 2615, KN, 0, 0, 0, 1)           
               ELSE                                                     
C                                                                       
C -----  LOOP OVER INTERVALS AND APPROACHES AND LOCATE HIGHEST NON-ZERO 
C -----  INTERVAL NUMBER. OUTPUT MESSAGE IF SIGNAL CODE WAS INPUT FOR   
C -----  AN INTERVAL THAT WAS NOT ASSIGNED A DURATION.                  
C                                                                       
                  ILMAX = 0                                             
                  INTNUM = MOD (PFZPNT(IN) / 2**11, 2**4)               
                  DO 70 JNT = 1, 12                                     
                     INT = 13 - JNT                                     
                     J = (INT * 5) - 4                                  
                     WGREEN = .FALSE.                                   
                     DO 60 IA = 1, JA                                   
                        J = J + 1                                       
                        IF (XBUF(J) .NE. 0 .AND. XBUF(J) .NE. 2)        
     1                                           WGREEN = .TRUE.        
                        IF (XBUF(J) .GT. 0) THEN                        
                            IF (ILAST(IA) .EQ. 0) ILAST(IA) = INT       
                            IF (ILMAX .EQ. 0) ILMAX = INT               
                            IF (INT .GT. INTNUM) CALL ERGEN ('CKSN36',  
     1                                         2612, INT, KN, 0, 0, 2)  
                        ENDIF                                           
60                   CONTINUE                                           
C                                                                       
C -----  LOOP TO DETERMINE IF SIGNAL CODES ARE SPECIFIED FOR MORE       
C -----  APPROACHES THAN WERE IDENTIFIED ON CARD TYPE 35.               
C                                                                       
                     IF (JA .LT. 5) THEN                                
                         IA = JA                                        
   65                    CONTINUE                                       
                         IA = IA + 1                                    
                         J = J + 1                                      
                         IF (XBUF(J) .GT. 0) IMAXAP = MAX0 (IMAXAP,IA)  
                         IF (IA .LT. 5)                    GO TO 65     
                     ENDIF                                              
C                                                                       
C-----------------------------------------------------------------------
C                                                                       
C     IF A DURATION WAS SPECIFIED ON CARD TYPE 35 FOR INTERVAL INT+1,   
C     BUT CONTROL CODES FOR INTERVAL INT+1 WERE ALL BLANK OR SET TO     
C     ZERO, THIS IS EITHER AN ERROR OF OMISSION OR THE FINAL INTERVAL   
C     (INT+1) IS AN ALL AMBER. IF INT+1 IS AN ALL AMBER, AT LEAST 1     
C     APPROACH SHOULD HAVE A GO INDICATION DURING INTERVAL, INT, (I.E.  
C     WGREEN = .T.). OTHERWISE AN ERROR HAS OCCURED AND A MESSAGE IS    
C     GENERATED.                                                        
C                                                                       
C-----------------------------------------------------------------------
C                                                                       
                     IF (ILMAX .LE. INTNUM-1 .AND.                      
     1                   INT .EQ. INTNUM-1 .AND. .NOT. WGREEN)          
     2                   CALL ERGEN ('CKSN36', 2627, INT+1, KN, 0, 0, 2)
   70                CONTINUE                                           
C                                                                       
C -----  LOOP OVER APPROACHES AND OUTPUT MESSAGES IF NO SIGNAL CONTROL  
C -----  SPECIFIED OR TOO FEW INTERVALS SPECIFIED                       
C                                                                       
                     DO 80 IA = 1, JA                                   
                        IF (ILAST(IA) .EQ. 0) CALL ERGEN                
     1                      ('CKSN36', 2613, IA, KN, 0, 0, 2)           
                        IF (ILAST(IA) .LT. ILMAX-1) CALL ERGEN          
     1                      ('CKSN36', 2614, IA, KN, 0, 0, 2)           
   80                CONTINUE                                           
               ENDIF                                                    
            ENDIF                                                       
C                                                                       
C -----  OUTPUT MESSAGE IF SIGNAL CODES ARE SPECIFIED FOR MORE          
C -----  APPROACHES THAN WERE IDENTIFIED ON CARD TYPE 35.               
C                                                                       
            IF (IMAXAP .GT. JA) CALL ERGEN ('CKSN36', 2609, KN, JA,     
     1                                      IMAXAP, 0, 3)               
         ENDIF                                                          
C                                                                       
C -----  GET LINK NUMBER OF APPROACH 1, PRINT MESSAGE IF REDUNDANT      
C -----  TYPE 36 CARD.                                                  
C                                                                       
         IL = SIGI(IK+1)                                                
         IF (IL .GT. 0 .AND. XPINT1(IL) .GT. 0) CALL ERGEN ('CKSN36',   
     1                                          2616, KN, 0, 0, 0, 1)   
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CKSN96                                                 
C                                                                       
C                                                                       
C --- CODED    8-13-92 BY J. WERK AND M. SEELEY                         
C                                                                       
C --- TITLE - CHECK CONSISTENCY AND STORE DATA ON TYPE 96 CARDS         
C ---         (SUBSEQUENT TIME PERIOD) - MODULE 2262.4.1.1              
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS FOR INCONSISTENCIES AMONG THE       
C ---            DATA ITEMS ON CARD TYPE 96 AND STORES DATA IF NONE     
C ---            ARE FOUND. (SUBSEQUENT TIME PERIOD)                    
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS ROUTINE IS CALLED A CARD TYPE 96 IS ASSUMED IN THE      
C     BUFFER.  A SUBROUTINE IS THEN CALLED TO CHECK EACH ITEM ON THE    
C     CARD.  ANOTHER SUBROUTINE IS CALLED TO GET LINK NUMBER.  WHEN     
C     CONTROL RETURNS, THIS ROUTINE WILL THEN CHECK FOR INCONSISTENCIES 
C     BETWEEN RELATED ITEMS ON THE CARD.                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDSN96 - MODULE 2262.4.1                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    TBFN96 - MODULE 2261.11311                         
C                    NLKNUM - MODULE 2261.3112                          
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ICHG    INTERCHANGE NUMBER                                        
C     IK      INDEX TO DO LOOP                                          
C     IL      ENTRY APPROACH TO INTERCHANGE LINK NUMBER                 
C     ILD     DESTINATION LINK NUMBER                                   
C     ILDT    DESTINATION LINK FROM PREVIOUS TIME PERIOD                
C     ILOT    ORIGIN LINK FROM PREVIOUS TIME PERIOD                     
C     ITCT    TURN CODE FROM PREVIOUS TIME PERIOD                       
C     IND     INDEX TO XTRPTB ARRAY CONTAINING DATA FOR INTERCHANGE ICHG
C     ITC     TURN CODE FOR ORIGIN - DESTINATION PAIR                   
C     NCGLNK  POINTER TO FIRST ELEMENT IN XNCGLK PERTAINING TO          
C             INTERCHANGE ICHG                                          
C     NTCHG   POINTER TO 1ST ELEMENT IN XTRPTB PERTAINING TO AN INTCHG  
C     NUM96C  INTERCHANGE SPECIFIC ARRAY - NUMBER OF ELEMENTS IN        
C             XTRPTB ARRAY                                              
C     WERR    FLAG INDICATING WHETHER AN ERROR WAS ENCOUNTERED          
C     WCERR   FLAG INDICATING WHETHER A BOUNDS ERROR WAS ENCOUNTERED    
C     WERRD   FLAG INDICATING WHETHER AN ERROR WAS ENCOUNTERED RELATED  
C             TO DESTINATION NODE                                       
C     WFOUND  FLAG INDICATING IF ORIGIN-DESTINATION-TURN CODE           
C             COMBINATION OCCURRED IN PREVIOUS TIME PERIOD              
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     XTRPTB  ARRAY CONTAINING - ORIGIN LINK, DESTINATION LINK, TURN    
C                             CODE ON DESTINATION LINK, AND PERCENTAGE  
C                             OF TRAFFIC ON ORIGIN LINK THAT TRAVELS TO 
C                             DESTINATION LINK AND EXECUTES THAT TURN   
C                             MOVEMENT.                                 
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  CALL ROUTINE TO CHECK BOUNDS OF EACH ITEM, CHECK THAT          
C -----  INTERCHANGE WAS PREVIOUSLY DEFINED ON A TYPE 95 CARD AND       
C -----  GET LINK NUMBER.                                               
C                                                                       
      WERR = .FALSE.                                                    
      CALL TBFN96 (WCERR)                                               
      IF (NCGLNK(XBUF(1)) .EQ. 0) THEN                                  
         CALL ERGEN ('CKSN96', 5343, XBUF(1), 0, 0, 0, 1)               
         WERR = .TRUE.                                                  
      ENDIF                                                             
      CALL NLKNUM (IL, XBUF(2), XBUF(3))                                
C                                                                       
C -----  OUTPUT MESSAGE IF LINK WAS NOT ALREADY DEFINED BY A            
C -----  TYPE 11 CARD AND TRA.                                          
C                                                                       
      IF (IL .EQ. 0) THEN                                               
         CALL ERGEN ('CKSN96', 5338, XBUF(2), XBUF(3), XBUF(1), 0, 3)   
         WERR = .TRUE.                                                  
      ENDIF                                                             
C                                                                       
C -----  IF NO ERRORS ARE FOUND, CHECK THAT EACH ORIGIN - DESTINATION - 
C -----  TURN CODE COMBINATION SPECIFIED WAS STORED IN PREVIOUS TIME    
C -----  PERIOD.  IF SO, UPDATE THE TURN PERCENTAGE.  OTHERWISE, ISSUE  
C -----  AN ERROR MESSAGE.                                              
C                                                                       
      ICHG = XBUF(1)                                                    
         DO 100 IK = 4, 19, 4                                           
          WERRD = .FALSE.                                               
          IF (XBUF(IK) .NE. 0 .AND. XBUF(IK+1) .NE. 0) THEN             
            CALL NLKNUM(ILD, XBUF(IK), XBUF(IK + 1))                    
            IF (ILD .EQ. 0) THEN                                        
               CALL ERGEN ('CKSN96', 5338, XBUF(IK), XBUF(IK + 1),      
     1                     XBUF(1), 0, 3)                               
               WERRD = .TRUE.                                           
            ENDIF                                                       
            IF (.NOT. WERRD .AND. .NOT. WERR) THEN                      
               ITC = XBUF(IK+2)                                         
               IF (ITC .EQ. 0) THEN                                     
                  CALL ERGEN ('CKSN96', 5350, XBUF(IK), XBUF(IK + 1),   
     1                        XBUF(IK + 2), XBUF(1), 4)                 
                  WERRD = .TRUE.                                        
               ENDIF                                                    
               IF (.NOT. WERRD) THEN                                    
                  WFOUND = .FALSE.                                      
                  IND = NTCHG(ICHG) - 1                                 
   80             CONTINUE                                              
                  IND = IND + 1                                         
                  ILOT = MOD (XTRPTB(IND), 2 ** 10)                     
                  ILDT = MOD (XTRPTB(IND) / 2 ** 10, 2 ** 10)           
                  ITCT = MOD (XTRPTB(IND) / 2 ** 20, 2 ** 3)            
                  IF (IL .EQ. ILOT .AND. ILD .EQ. ILDT .AND.            
     1                ITC .EQ. ITCT) WFOUND = .TRUE.                    
                  IF (.NOT. WFOUND .AND. IND .LT.                       
     1                     NTCHG(ICHG) + NUM96C(ICHG) - 1)   GO TO 80   
                  IF (WFOUND) THEN                                      
                     XTRPTB(IND) = MOD(XTRPTB(IND), 2**23) + ITC * 2**24
                  ELSE                                                  
                     CALL ERGEN ('CKSN96', 5351, XBUF(2), XBUF(3),      
     1                           XBUF(4), XBUF(5), 4)                   
                     WERRD = .TRUE.                                     
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
          ENDIF                                                         
  100    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CLRBLK (I1, I2)                                        
C                                                                       
C --- CODED    9-09-80 BY M. YEDLIN                                     
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK VTYPE                     
C                                                                       
C --- TITLE - CLEAR BLOCKAGE IN AFFECTED LANE - MODULE 3234.3.4         
C                                                                       
C --- FUNCTION - THIS MODULE CLEARS THE BLOCKAGE CODE FOR ALL VEHICLES  
C ---            IN A LANE IN WHICH A PARKER/EVENT HAS JUST LEFT.       
C                                                                       
C --- ARGUMENTS -     I1 - SUBJECT LINK IDENTIFICATION NUMBER           
C ---                      FROM THE CALLING ROUTINE                     
C ---                 I2 - NUMBER OF LANE AFFECTED BY BLOCKAGE          
C ---                      FROM THE CALLING ROUTINE                     
C                                                                       
C -------------------------   DESCRIPTION  ---------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE LOOPS OVER ALL VEHICLES IN A LANE IN WHICH A PARKER/  
C     EVENT HAS JUST TERMINATED. THE BLOCKAGE CODE FOR EACH VEHICLE     
C     IS RESET TO 0 IN THE BLQUE ARRAY.                                 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY  ----------------------- 
C                       ----------------------                          
C                                                                       
C                    EVENTS - MODULE 3234.3                             
C                    LTEVNT - MODULE 3234.3.1                           
C                    STEVNT - MODULE 3234.3.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS  ------------------------- 
C                         ------------------                            
C                                                                       
C                               NONE                                    
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES  ---------------------- 
C                    --------------------------                         
C                                                                       
C     BLQUE   VEHICLE SPECIFIC ARRAY - CODE IF VEH IN QUEUE BEHIND BLKG 
C     FOLOWR  VEHICLE SPECIFIC ARRAY - NO. OF FOLLOWING VEHICLE         
C     IL      LINK NUMBER                                               
C     ILN     LANE NUMBER                                               
C     IV      VEHICLE NUMBER                                            
C     K       INDEX TO LANEF ARRAY FOR LINK, IL, AND LANE, ILN          
C     LANEF   ARRAY OF 1ST VEHICLES ON EACH LANE IN SUBNETWORK          
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IL = I1                                                           
      ILN = I2                                                          
C                                                                       
C -----  CLEAR BLOCKAGE CODE FROM ALL VEHICLES IN LANE WHICH            
C -----  CONTAINED PARKER/EVENT WHICH HAS JUST LEFT.                    
C                                                                       
      K = 7 * (IL - 1) + ILN                                            
      IV = LANEF(K)                                                     
      IF (IV .EQ. 0)                                         GO TO 20   
   10 CONTINUE                                                          
      BLQUE(IV) = 0                                                     
      IV = FOLOWR(IV)                                                   
      IF (IV .GT. 0)                                         GO TO 10   
   20 CONTINUE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE CNLEAD (I1, I2, J1, J2, J3)                            
C                                                                       
C --- CODED    10-1-91 BY J. WERK                                       
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK VLANE                     
C                                                                       
C --- TITLE - DETERMINE LEADER AND FOLLOWER VEHICLES IN TARGET LANE -   
C ---         MODULE 3232.4644                                          
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES THE LEAD AND FOLLOWER VEHICLES  
C ---            IN CANDIDATE LANE WITH RESPECT TO VEHICLE IV.          
C                                                                       
C --- ARGUMENTS - I1     = SUBJECT VEHICLE NUMBER, FROM CALLING ROUTINE 
C ---             I2     = LINK NUMBER OF CURRENT LINK,                 
C ---                      FROM CALLING ROUTINE                         
C ---             J1     = LEAD VEHICLE IN TARGET LANE,                 
C ---                      TO CALLING ROUTINE                           
C ---             J2     = FOLLOWER VEHICLE IN TARGET LANE,             
C ---                      TO CALLING ROUTINE                           
C ---             J3     = DISTANCE FROM STOPLINE ON RECEIVING LINK TO  
C ---                      TAIL OF LAST VEHICLE WHICH DISCHARGED FROM   
C ---                      LINK I2 AND TARGET LANE OF VEHICLE I1,       
C ---                      (NEGATIVE IF VEHICLE HAS NOT YET FULLY       
C ---                      CLEARED THE STOPLINE OF I2),                 
C ---                      TO CALLING ROUTINE                           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE IS CALLED IN ORDER TO DETERMINE THE LEAD AND FOLLOWER
C     VEHICLES IN CANDIDATE LANE AND WHETHER A BLOCKAGE/PARKER EXISTS   
C     DIRECTLY AHEAD OF VEHICLE IV IN CANDIDATE LANE.                   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    LCHDEC - MODULE 3232.4.6.4                         
C                    UPSADS - MODULE 3232.4412                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    GETAIL - MODULE 3232.2114.1                        
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE OF VEH FROM UPSTM NODE  
C     FOLOWR  VEHICLE SPECIFIC ARRAY - NUMBER OF FOLLOWER VEH           
C     ICDST1 DISTANCE OF CURRENT LEAD VEHICLE IN CANDIDATE LANE FROM    
C             UPSTREAM NODE                                             
C     ICDST2 DISTANCE OF CURRENT FOLLOWER VEHICLE IN CANDIDATE LANE     
C             FROM UPSTREAM NODE                                        
C     IFLN    VEHICLE IV'S TARGET LANE                                  
C     IL      LINK NUMBER OF CURRENT LINK                               
C     ILL     INDEX TO LANEF ARRAY FOR CANDIDATE LANE IFLN ON LINK IL   
C     ISDIST  DISTANCE OF SUBJECT VEHICLE FROM UPSTREAM NODE            
C     ITEMP1  TEMPORARY VEHICLE BEING EXAMINED AS A LEADER TO VEHICLE IV
C     ITEMP2  TEMPORARY VEHICLE BEING EXAMINED AS FOLLOWER TO VEHICLE IV
C     IV      SUBJECT VEHICLE NUMBER                                    
C     JLEDIS  DISTANCE FROM STOPLINE ON RECEIVING LINK TO TAIL OF LAST  
C             VEHICLE WHICH DISCHARGED FROM LINK IL AND TARGET LANE OF  
C             VEHICLE IV, (NEGATIVE IF VEHICLE HAS NOT YET FULLY        
C             CLEARED THE STOPLINE OF IL),                              
C     JTFLW   FOLLOWER VEHICLE IN TARGET LANE                           
C     JTLEAD  LEAD VEHICLE IN TARGET LANE                               
C     LANEF   LINK AND LANE SPECIFIC ARRAY - FIRST VEHICLE IN LANE      
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF 
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE   
C     WLEAD   FLAG (T, F) IF LEAD AND FOLLOWER VEHICLES IN CANDIDATE    
C             LANE (HAVE, HAVE NOT) BEEN FOUND                          
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IV = I1                                                           
      IL = I2                                                           
C                                                                       
C -----  RESET DISTANCE OF LEAD VEHICLE FROM UPSTREAM NODE.             
C                                                                       
      ICDST1 = 0                                                        
C                                                                       
C -----  UNPACK VEHICLE'S TARGET LANE AND FIRST VEHICLE IN TARGET       
C -----  LANE AND ITS DISTANCE FROM UPSTREAM NODE.                      
C                                                                       
      IFLN = MOD(VHLANE(IV), 2**3)                                      
      ISDIST = DISTUP(IV)                                               
      ILL = (IL - 1) * 7 + IFLN                                         
      ITEMP1 = LANEF(ILL)                                               
      IF (ITEMP1 .GT. 0) ICDST1 = DISTUP(ITEMP1)                        
C                                                                       
C -----  IF THE FIRST VEHICLE IN TARGET LANE IS UPSTREAM OF VEHICLE     
C -----  IV, THEN SET THE LEAD VEHICLE AND ITS DISTANCE FROM UPSTREAM   
C -----  NODE TO ZERO AND THE FOLLOWER VEHICLE TO THE FIRST VEHICLE IN  
C -----  TARGET LANE.  SET DISTANCE OF FOLLOWER VEHICLE EQUAL TO THE    
C -----  DISTANCE OF FIRST VEHICLE IN TARGET LANE.                      
C                                                                       
      IF (ICDST1 .LE. ISDIST) THEN                                      
         JTLEAD = 0                                                     
         JTFLW = ITEMP1                                                 
C                                                                       
C -----  THE LEAD VEHICLE IS DOWNSTREAM OF VEHICLE IV.  LOOP OVER ALL   
C -----  VEHICLES IN TARGET LANE TO FIND THE SUBJECT VEHICLE'S LEAD AND 
C -----  FOLLOWER VEHICLES.                                             
C                                                                       
      ELSE                                                              
         WLEAD = .FALSE.                                                
   10    CONTINUE                                                       
         ITEMP2 = FOLOWR(ITEMP1)                                        
         ICDST2 = 0                                                     
         IF (ITEMP2 .GT. 0) ICDST2 = DISTUP(ITEMP2)                     
         IF (ICDST2 .LT. ISDIST) THEN                                   
            JTLEAD = ITEMP1                                             
            JTFLW = ITEMP2                                              
            WLEAD = .TRUE.                                              
         ELSE                                                           
            ITEMP1 = ITEMP2                                             
         ENDIF                                                          
         IF (.NOT. WLEAD)                                    GO TO 10   
      ENDIF                                                             
      JLEDIS = 0                                                        
      IF (JTLEAD .EQ. 0) THEN                                           
         CALL GETAIL (IL, IFLN, JTLEAD, JLEDIS)                         
         IF (JLEDIS .GE. 0) JTLEAD = 0                                  
      ENDIF                                                             
      J1 = JTLEAD                                                       
      J2 = JTFLW                                                        
      J3 = JLEDIS                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CNTRL (I1, I2, W1, W2)                                 
C                                                                       
C                                                                       
C --- CODED   10-03-79 BY M. KAPTANOGLU                                 
C --- REVISED 11-12-87 BY M. YEDLIN TO CORRECT INDEX OUT OF RANGE       
C --- REVISED  4-09-90 BY A. KANAAN TO ADD VEHID TRACING                
C --- REVISED  5-15-92 BY J. WERK TO REMOVE CODE WHICH UPDATES STASHN   
C ---                        ARRAY                                      
C --- REVISED  3-08-94 BY S. WALKER TO UNPACK BUS ARRAYS                
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK SPDLN AND CODES           
C                                                                       
C --- TITLE - TEST WHETHER CONTROL WILL PERMIT DISCHARGE                
C ---         MODULE 3232.2.1                                           
C                                                                       
C --- FUNCTION - THIS ROUTINE CALLS A SUBORDINATE MODULE ACCORDING TO   
C ---            THE TURN MOVEMENT OF THE VEHICLE TO DETERMINE WHETHER  
C ---            CONTROL CODE WILL PERMIT DISCHARGE.                    
C                                                                       
C --- ARGUMENTS - I1     = VEHICLE NUMBER, FROM CALLING ROUTINE         
C ---             I2     = LINK NUMBER, FROM CALLING ROUTINE            
C ---             W1     = FLAG = (.T., .F.) IF VEHICLE (IS, IS NOT)    
C ---                      IN QUEUE, FROM CALLING ROUTINE               
C ---             W2     = FLAG = (.T., .F.) IF VEHICLE (CAN, CANNOT)   
C ---                      DISCHARGE DURING THIS TIME STEP, TO CALLING  
C ---                      ROUTINE                                      
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE DETERMINES WHETHER THE SUBJECT VEHICLE IS CONTROLLED 
C     BY A SIGNAL OR A SIGN. IF A SIGNAL, A SUBORDINATE MODULE IS       
C     CALLED ACCORDING TO THE TURN MOVEMENT OF THE VEHICLE TO DETERMINE 
C     IF THE VEHICLE MAY DISCHARGE. A SEPARATE MODULE IS CALLED FOR     
C     VEHICLES OF ALL TURN MOVEMENTS CONTROLLED BY A SIGN TO DETERMINE  
C     IF THE VEHICLE MAY DISCHARGE.                                     
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    CHKDIS - MODULE 3232.2                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    LTRNC  - MODULE 3232.2.1.1                         
C                    RTRNC  - MODULE 3232.2.1.2                         
C                    THRUC  - MODULE 3232.2.1.3                         
C                    SIGNS  - MODULE 3232.2.1.4                         
C                    BSTOP  - MODULE 3232.4.1                           
C                    BUSTA  - MODULE 3232.4.3                           
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     IB      BUS VEHICLE NUMBER                                        
C     IBLN    LANE BLOCKED WHEN BUS IS AT THE STATION                   
C     ICNTRL  SIGNAL CODE                                               
C     IL      LINK NUMBER                                               
C     ILN     LANE CURRENTLY OCCUPIED                                   
C     ITRN    TURN MOVEMENT CODE                                        
C     ITYP    TYPE OF VEHICLE, IV                                       
C     IV      SUBJECT VEHICLE NUMBER                                    
C     JBS     BUS STATION NUMBER                                        
C     JDIS    DISTANCE FROM VEHICLE TO LAST BUS IN STATION, JBS         
C     JV      BUS VEHICLE NUMBER                                        
C     K       INDEX TO STASHN ARRAY                                     
C     KK      INDEX TO STASHN ARRAY                                     
C     LGRPK   LINK SPECIFIC ARRAY OF RIGHT TURN POCKET DATA             
C             (NEGATIVE IF POCKET IS A PROTECTED STATION)               
C     LU6     UNIT NO.6 (OUTPUT PRINTOUT)                               
C     MANUVR  ARRAY CONTAING NEXT STATION AND/OR TURN MOVEMENT          
C     NBUSIV  VEHICLE SPECIFIC ARRAY - BUS NUMBER                       
C     NFLEET  VEHICLE SPECIFIC ARRAY - FLEET COMPONENT CODE             
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                    
C     PNTER   ARRAY OF POINTERS TO MANUVR ARRAY                         
C     SDCODE  LINK SPECIFIC ARRAY - SIGNAL CODE FACING LINK             
C     STASHN  ARRAY OF STATION SPECIFIC DATA                            
C     TCODE   VEHICLE SPECIFIC ARRAY - TURN MOVEMENT CODE               
C     TTLILK  TOTAL NUMBER OF INTERNAL LINKS                            
C     VEHID   VEHICLE ID TO TRACE WITHIN PROGRAM                        
C     WGO     FLAG = (.T., .F.) IF VEHICLE (CAN, CANNOT) DISCHARGE      
C     WPOKT   FLAG - .T. IF PROTECTED STATION IS USED AS A POCKET       
C     WQ      FLAG = (.T., .F.) IF VEHICLE (IS, IS NOT) IN QUEUE        
C     WSIGN   FLAG = (.T., .F.) IF LINK (IS, IS NOT) CONTROLLED BY A    
C             SIGN                                                      
C     WSTOP   FLAG - .T. IF BUS WILL STOP AT STATION THIS TIME-STEP     
C     WSTOR   FLAG - .T. IF THERE IS ADEQUATE STORAGE IN BUS STATION    
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IV = I1                                                           
      IL = I2                                                           
      WQ = W1                                                           
C                                                                       
C -----  GET TURN CODE AND CONTROL CODE AND IF VEHICLE HAS SIGN CONTROL 
C -----  CALL MODULE 3232.2.1.4 TO DETERMINE WHETHER VEHICLE CAN        
C -----  DISCHARGE, THEN TRA.                                           
C                                                                       
      ITRN = TCODE(IV)                                                  
      ITYP = NFLEET(IV)                                                 
      ICNTRL = MOD (SDCODE(IL), 2**5)                                   
      WSIGN = ICNTRL / 2 .EQ. 15                                        
      IF (WSIGN) THEN                                                   
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CNTRL : CALLING SIGNS'    
          CALL SIGNS (IV, IL, ITRN, ICNTRL, WQ, WGO)                    
                                                             GO TO 10   
      ENDIF                                                             
C                                                                       
C -----  MODULE 3232.2.1.1 IS CALLED TO DETERMINE IF LEFT-TURNING OR    
C -----  LEFT-DIAGONAL VEHICLES CAN DISCHARGE, MODULE 3232.2.1.2 IS     
C -----  CALLED FOR RIGHT-TURNING VEHICLES, AND MODULE 3232.2.1.3 IS    
C -----  CALLED FOR THRU OR RIGHT-DIAGONAL VEHICLES.                    
C                                                                       
      IF (ITRN.EQ.0 .OR. ITRN.EQ.3) THEN                                
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CNTRL : CALL LTRNC'       
          CALL LTRNC (IV, IL, ITRN, WQ, WGO)                            
      ENDIF                                                             
      IF (ITRN .EQ. 2) THEN                                             
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CNTRL : CALL RTRNC'       
          CALL RTRNC (IV, IL, WQ, WGO)                                  
      ENDIF                                                             
      IF (ITRN.EQ.1 .OR. ITRN.EQ.4) THEN                                
          IF (IV .EQ. VEHID) WRITE(LU6,*) '   CNTRL : CALL THRUC'       
          CALL THRUC (IV, IL, ITRN, WQ, WGO)                            
      ENDIF                                                             
   10 CONTINUE                                                          
      IF (.NOT. WGO .OR. IL .GT. TTLILK .OR. ITYP .NE. 3)    GO TO 40   
C                                                                       
C -----  SPECIAL CASE OF A BUS WHO CAN DISCHARGE NOW. CALL              
C -----  SUBROUTINE TO DETERMINE IF BUS WILL STOP AT STATION. IF        
C -----  SO, STOP BUS AT STOP-LINE. BUS WILL BE MOVED INTO              
C -----  STATION THIS TIME STEP. (TRA IF ENTRY LINK)                    
C                                                                       
      CALL BSTOP (IV, 0, JBS, JDIS, WSTOP, WSTOR, WPOKT)                
      WGO = .NOT. WSTOP                                                 
      IF (WSTOP) THEN                                                   
         IF (IV .EQ. VEHID) WRITE(LU6,1000) IV, JBS                     
1000     FORMAT('   CNTRL : VEHICLE', I4, ' IS A BUS STOPPING AT ',     
     1          'STATION', I6)                                          
         ILN = NLANE(IV)                                                
         CALL BUSTA (IV, IL, ILN, JBS, JDIS, WSTOR, WPOKT)              
      ENDIF                                                             
C                                                                       
C -----  REMOVE THIS BUS FROM THE STATION AND CHANGE POSITION           
C -----  OF OTHER BUSES IN THIS STATION (IF PROTECTED STATION)          
C                                                                       
C KLD      IF (WGO) THEN                                                
C KLD         IB = NBUSIV(IV)                                           
C KLD         J = PNTER(IB)                                             
C KLD         IF (J .GT. 0) J = J - 1                                   
C KLD         IF (J .LT. 0) J = IABS(J)                                 
C KLD         JBS = MOD (IABS (MANUVR(J)), 2**12)                       
C KLD         IF (JBS .EQ. 0)                                     GO TO 
C KLD         K = 10 * (JBS - 1)                                        
C KLD         IBLN = MOD (STASHN(K+1), 2**3)                            
C KLD         WPOKT = IBLN .EQ. 0 .AND. LGRPK(IL) .LT. 0 .AND.          
C KLD     1           -LGRPK(IL)/ 512 .EQ. JBS                          
C KLD         K = K + 2                                                 
C KLD         IF (WPOKT) THEN                                           
C KLD            DO 30 I = 1, 5                                         
C KLD               KK = K + I                                          
C KLD               STASHN(KK) = STASHN(KK+1)                           
C KLD   30       CONTINUE                                               
C KLD            STASHN(K+6) = 0                                        
C KLD         ENDIF                                                     
C KLD   35    CONTINUE                                                  
C KLD      ENDIF                                                        
C                                                                       
   40 CONTINUE                                                          
      W2 = WGO                                                          
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE COLOUT                                                 
C                                                                       
C --- CODED   2-03-93 BY M. SEELEY                                      
C                                                                       
C --- TITLE - OUTPUT COLLISION MOE - MODULE 4.3.10                      
C                                                                       
C --- FUNCTION - THIS MODULE PRINTS MICRO-NODE SPECIFIC COLLISIONS      
C                STATISTICS                                             
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE DETERMINES THE PERCENTAGE OF INTERSECTION TRIPS      
C     THAT EXPERIENCE CONFLICTS. THEN THE NUMBER OF CONFLICTS AND       
C     PERCENTS ARE PRINTED.                                             
C                                                                       
C -------------------  THIS ROUTINE CALLED BY   ----------------------- 
C                      ----------------------                           
C                                                                       
C                    OUTNET - MODULE 4.3                                
C                                                                       
C ----------------------   THIS ROUTINE CALLS   ----------------------- 
C                          ------------------                           
C                                                                       
C                                NONE                                   
C                                                                       
C -----------------    GLOSSARY OF VARIABLE NAMES   ------------------- 
C                      --------------------------                       
C                                                                       
C     COLCNT  ARRAY CONTAINING COUNTER OF COLLISIONS BY MOVMENTS.       
C             INDEX K = (IMIC-1)*40 + (IAP-1)*8 + (IMV-1)*2 + IMV2,     
C             WHERE IMIC IS MICRO-NODE INDEX, IAP IS APPROACH NUMBER    
C             IN SIGI ARRAY, IMV IS PRIMARY MOVEMENT AND IMV2 IS        
C             CONFLICTING MOVEMENT                                      
C     CUMICM  ARRAY CONTAINING CUMULATIVE VEHICLE TRIPS THROUGH         
C             INTERSECTION BY MOVEMENT                                  
C             INDEX K = (IMIC-1)*20 + (IAP-1)*4 + IMV                   
C             WHERE IMIC IS MICRO-NODE INDEX, IAP IS APPROACH NUMBER    
C             IN SIGI ARRAY, IMV IS PRIMARY MOVEMENT                    
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     IA      APPROACH NUMBER AS IT APPEARS IN SIGI ARRAY               
C     ICUMC   TOTAL # OF COLLISIONS ON APROACH TO MICRO-INTERSECTION    
C     ICUMT   TOTAL # OF TRIP THROUGH MICRO-INTERSECTION FROM APPROACH  
C     IDWN    DOWNSTREAM NODE OF APPROACH TO MICRO-INTERSECTION         
C     II      DO LOOP INDEX                                             
C     IK      INDEX TO COLCNT ARRAY                                     
C     IK1     INDEX TO COLCNT ARRAY FOR T/D SECONDARY MOVEMENT          
C     IK2     INDEX TO COLCNT ARRAY FOR L/R SECONDARY MOVEMENT          
C     IL      LINK NUMBER OF APPROACH TO MICRO-NODE                     
C     ILINE   LINE COUNTER                                              
C     IMIC    MICRO-NODE INDEX                                          
C     IMV     INDEX OVER PRIMARY MOVMENT (0=L, 1=T, 2=R, 4=D)           
C     IN      SUB-NETWORK NODE NUMBER FOR MICRO-NODE                    
C     ITOTC   TOTAL NUMBER OF COLLISIONS IN MICRO-INTERSECTION          
C     ITOTT   TOTAL NUMBER OF TRIP THROUGH MICRO-INTERSECTION           
C     IUP     UPSTREAM NODE OF APPROACH TO MICRO-INTERSECTION           
C     IUSEN   GLOBAL NODE NUMBER FOR MICRO-NODE                         
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     MCNOD   MICRONODE SPECIFIC ARRAY - NODE NUMBER                    
C     NMAP    NODE SPECIFIC ARRAY - USER SPECIFIED NODE NUMBERS         
C     RPCAPP  PERCENT OF MANUEVERS THAT HAVE CONFLICTS FOR APPROACH     
C     RPCT    PRIMARY MOVEMENT SPECIFIC ARRAY - PERCENT OF MANUEVERS    
C             THAT HAVE CONFLICTS                                       
C     RPCTOT  PERCENT OF MANUEVERS THAT HAVE CONFLICTS FOR MICRO-NODE   
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBERS  
C     TTLMIC  TOTAL NUMBER OF MICRO NODES IN SUBNETWORK                 
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION RPCT(4)                                                 
C                                                                       
      ILINE = 0                                                         
C                                                                       
C -----  LOOP OVER ALL MICRO-NODES TO DETERMINE PERCENTAGES AND         
C -----  PRINT STATS                                                    
C                                                                       
         DO 100 IMIC = 1, TTLMIC                                        
            ITOTT = 0                                                   
            ITOTC = 0                                                   
C                                                                       
C -----  FOR EACH MICRO-NODE, LOOP OVER ALL APPROACHES                  
C                                                                       
               DO 80 IA = 1, 5                                          
                  ICUMC = 0                                             
                  ICUMT = 0                                             
C                                                                       
C -----  DETERMINE THE SUB-NETWORK AND GLOBAL NODE NUMBER CORRESPONDING 
C -----  TO THE MICRO-NODE.  DETERMINE THE LINK NUMBER OF THE CURRENT   
C -----  APPROACH TO THE MICRO-NODE.                                    
C                                                                       
                  IN = MCNOD(IMIC)                                      
                  IUSEN = IN                                            
                  IF (IN .LT. 7000) IUSEN = NMAP(IUSEN)                 
                  IL = SIGI((IN - 1) * 5 + IA)                          
C                                                                       
                  IF (IL .GT. 0) THEN                                   
                     ILINE = ILINE + 1                                  
                     IF (ILINE .GT. 47 .AND. IA .EQ. 1) ILINE = 1       
                     IUP = UPNOD(IL)                                    
                     IF (IUP .LT. 7000) IUP = NMAP(IUP)                 
                     IDWN = DWNOD(IL)                                   
                     IF (IDWN .LT. 7000) IDWN = NMAP(IDWN)              
C                                                                       
C -----  LOOP OVER PRIMARY MOVEMENTS                                    
C                                                                       
                        DO 60 IMV = 1, 4                                
                           IK1= (IMIC-1) * 20 + (IA-1) * 4 + IMV        
                           IK2= (IMIC-1) * 40 + (IA-1) * 8 + (IMV-1) * 2
C                                                                       
C -----  DETERMINE AND STORE THE PERCENT OF MANUEVERS WITH CURRENT      
C -----  PRIMARY TURN MOVEMENT AND EITHER TYPE OF SECONDARY TURN        
C -----  MOVEMENT (I.E., T/D OR L/R) THAT HAVE CONFLICT.                
C                                                                       
                           RPCT(IMV) = 0.                               
                           IF (CUMICM(IK1) .NE. 0) RPCT(IMV) =          
     1                         REAL(COLCNT(IK2+1)+COLCNT(IK2+2))        
     2                                 / REAL(CUMICM(IK1))              
C                                                                       
C -----  ACCUMULATE THE NUMBER OF CONFLICTS AND TRIPS FOR THE           
C -----  APPROACH                                                       
                           ICUMC = ICUMC + COLCNT(IK2+1) + COLCNT(IK2+2)
                           ICUMT = ICUMT + CUMICM(IK1)                  
   60                   CONTINUE                                        
C                                                                       
C -----  DETERMINE THE PERCENT OF MANUEVERS ON APPROACH THAT            
C -----  HAVE CONFLICT                                                  
C                                                                       
                      RPCAPP = 0.                                       
                      IF (ICUMT .NE. 0) RPCAPP = REAL(ICUMC) /          
     1                                           REAL(ICUMT)            
C                                                                       
C -----  FOR EACH PRIMARY MOVEMENT, PRINT THE NUMBER OF CONFLICTS WITH  
C -----  EACH TYPE OF SECONDARY MOVEMENT, THE PERCENT OF MANUEVERS THAT 
C -----  HAVE CONFLICTS WITH EITHER TYPE.  PRINT THE PERCENT OF         
C -----  MANUEVERS THAT HAVE CONFLICTS WITH EITHER TYPE FOR THE         
C -----  APPROACH.                                                      
C                                                                       
                      IF (ILINE .EQ. 1) WRITE (LU6, 1000)               
                      IF (IA .EQ. 1) WRITE (LU6, 1005) IUSEN            
                      IK = (IMIC - 1) * 40 + (IA - 1) * 8               
                      WRITE (LU6, 1010) IUP, IDWN,                      
     1                  (COLCNT(IK+2*II-1), COLCNT(IK+2*II),            
     2                  RPCT(II), II = 1, 4), RPCAPP                    
                  ENDIF                                                 
C                                                                       
C -----  ACCUMULATE THE NUMBER OF CONFLICTS AND TRIPS FOR THE MICRO-NODE
C                                                                       
                  ITOTC = ITOTC + ICUMC                                 
                  ITOTT = ITOTT + ICUMT                                 
   80          CONTINUE                                                 
C                                                                       
C -----  PRINT THE TOTAL NUMBER OF CONFLICTS AND TRIPS FOR THE          
C -----  MICRO-NODE AND THE PERCENT OF MANUEVERS THAT HAVE CONFLICTS    
C -----  MICRO-NODE.                                                    
C                                                                       
            RPCTOT = 0.                                                 
            IF (ITOTT .NE. 0) RPCTOT = REAL(ITOTC) / REAL(ITOTT)        
            WRITE (LU6, 1015) ITOTC, ITOTT, RPCTOT                      
C                                                                       
  100    CONTINUE                                                       
C                                                                       
      RETURN                                                            
 1000 FORMAT('1', 32X, 'CUMULATIVE VALUES OF CONFLICTS FOR MICRO-',     
     1            'INTERSECTIONS', //, 29X, 4(12X, 'AVG. NO.'), 5X,     
     2            'AVG. NO.', /, 26x, 4(18X, 'OF'), 11x, 'OF', /,       
     3            29X, 4(11X, 'CONFLICTS'), 4X, 'CONFLICTS'             
     3             /, 10X, 'PRIMARY MVMNT:', 8X, 'L', 4X,               
     3            'L', 4X, 'PER L ', 5X, 'T', 4X, 'T', 4X, 'PER T', 5X, 
     4            'R', 4X, 'R', 4X, 'PER R', 5X, 'D', 4X, 'D', 4X,      
     5            'PER D', 9X, 'PER', /, 10X,                           
     6            'CONFLICTING MVMNT:', 3X, 4('T/D  L/R  MANEUVER  '),  
     7            3X, 'APPROACH', /, 31X, 4('---  ---  --------  '), 3X,
     8            '--------')                                           
 1005 FORMAT (/, 10X, 'MICRO-NODE: ', I4, /, 15X, 'APPROACH LINK', /,   
     1                                       15X, '-------------')      
 1010 FORMAT (15X, '(', I4, ',', I4, ')', 4X,                           
     1             4(I3, 2X, I3, 3X, '( ', F4.2, ')', 2X),              
     2             4X, '( ', F4.2, ')')                                 
 1015 FORMAT (//, 20X, 'THERE ARE A TOTAL OF ', I4,                     
     1           ' CONFLICTS OUT OF ', I4,                              
     2           ' TRIPS THROUGH INTERSECTION, OR AN AVERAGE OF ', F4.2,
     3           ' CONFLICTS PER TRIP')                                 
C                                                                       
      END                                                               
      SUBROUTINE COMPQN                                                 
C                                                                       
C                                                                       
C --- CODED   11-08-89 BY M. KAPTANOGLU                                 
C --- REVISED  4-04-90 BY A. KANAAN TO ADD DISTANCE FROM STOP LINE TO VI
C --- REVISED  5-13-93 BY S.E.SMITH TO ADD TAIL OF QUEUE IN FT          
C                                                                       
C --- TITLE - COMPUTES AVERAGE AND MAXIMUM QUEUE ON EACH LANE OF EACH LI
C                                                                       
C --- FUNCTION - COMPUTES AVERAGE AND MAXIMUM QUEUE ON EACH LANE OF     
C                EACH LINK                                              
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE SCANS ALL LANES OF ALL LINKS, CALLS SUBROUTINE GETNQ1
C     TO COMPUTE CUMULATIVE AVERAGE QUEUES AND MAXIMUM QUEUES.          
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    NETSIM - MODULE - 3.2.3                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    GETNQ1                                             
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     IL      LINK ID                                                   
C     JL      USERS LINK NUMBER                                         
C     JLANE   ARRAY OF NO. OF VEHICLES IN EACH LANE                     
C     JTRN    ARRAY OF NO. OF VEHICLES EXECUTING EACH TURN MOVEMENT     
C     LINK    ARRAY OF SUBNETWORK SPECIFIC INDICES FOR LINK MAPPING     
C     QAVG    LINK SPECIFIC ARRAY - AVERAGE QUEUE LENGTH ON LINK IL, LAN
C     QFREQ   FREQUENCY AVERAGE AND MAXIMUM QUEUES ARE COLLECTED (SEC.) 
C     QMAX    LINK SPECIFIC ARRAY - MAXIMUM QUEUE LENGTH ON LINK IL, LAN
C     TTLNK   TOTAL NUMBER OF LINKS IN THE NETWORK                      
C     VCT     INDEX FOR DEBUGGING  (NOT USED IN THIS ROUTINE)           
C     VID     VEHICLE ID FOR DEBUGGING (NOT USED IN THIS ROUTINE)       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION JTRN(5), JLANE(7), BACKQ(7)                             
C                                                                       
      CHARACTER VID*19                                                  
      DIMENSION VID(100)                                                
C                                                                       
C -----  SCAN ALL LINKS                                                 
C                                                                       
      DO 100 JL = 1, TTLNK                                              
         VCT = 0                                                        
         IL = LINK(JL)                                                  
         KLN = 7 * (IL - 1)                                             
         CALL GETNQ1(IL, JLANE, JTRN, BACKQ, VCT, VID)                  
         DO 50 ILN = 1, 7                                               
            KLN = KLN + 1                                               
            QMAX(KLN) = MAX0 (QMAX(KLN) , JLANE(ILN))                   
            QAVG(KLN) = QAVG(KLN) + (JLANE(ILN) * QFREQ)                
50       CONTINUE                                                       
100   CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CONPTH (IFL, ILN1, IL, ILN2, INUM, R0X, R0Y, R1X,      
     1       R1Y, R2X, R2Y, R3X, R3Y, RLEN, ICODEP, RFACT, RJ)          
C                                                                       
C --- CODED    8-09-92 BY M. SEELEY                                     
C                                                                       
C --- TITLE -  DETERMINE CHARACTERISTICS OF PATH THROUGH INTERSECTION   
C ---          - MODULE 32310.2.2.1                                     
C                                                                       
C --- FUNCTION - DETERMINE CHARACTERISTICS OF PATH THROUGH INTERSECTION 
C ---            SUCH AS THE NUMBER OF SEGMENTS, THE LENGTH OF EACH AND 
C ---            THE POINTS THAT DEFINE THEM                            
C                                                                       
C --- ARGUMENTS - IFL    = FEEDER LINK NUMBER, FROM CALLING ROUTINE     
C ---             ILN1   = FEEDER LANE NUMBER, FROM CALLING ROUTINE     
C ---             IL     = LINK NUMBER, FROM CALLING ROUTINE            
C ---             ILN2   = LANE NUMBER, FROM CALLING ROUTINE            
C ---             INUM   = NUMBER OF SEGMENTS, TO CALLING ROUTINE       
C ---             R0X    = X COORDINATE OF FIRST POINT IN PATH, TO      
C ---                      CALLING ROUTINE                              
C ---             R0Y    = Y COORDINATE OF FIRST POINT IN PATH, TO      
C ---                      CALLING ROUTINE                              
C ---             R1X    = X COORDINATE OF SECOND POINT IN PATH, TO     
C ---                      CALLING ROUTINE                              
C ---             R1Y    = Y COORDINATE OF SECOND POINT IN PATH, TO     
C ---                      CALLING ROUTINE                              
C ---             R2X    = X COORDINATE OF THIRD POINT IN PATH, TO      
C ---                      CALLING ROUTINE                              
C ---             R2Y    = Y COORDINATE OF THIRD POINT IN PATH, TO      
C ---                      CALLING ROUTINE                              
C ---             R3X    = X COORDINATE OF FOURTH POINT IN PATH, TO     
C ---                      CALLING ROUTINE                              
C ---             R3Y    = Y COORDINATE OF FOURTH POINT IN PATH, TO     
C ---                      CALLING ROUTINE                              
C --              RLEN   = SEGMENT SPECIFIC ARRAY - LENGTH OF SEGMENT,  
C ---                      TO CALLING ROUTINE                           
C ---             ICODEP = CURVATURE CODE OF MIDDLE SEGMENT, TO CALLING 
C ---                      ROUTINE                                      
C ---             RFACT  = PROPORTION OF COMPUTED LINK LENGTH TO USER   
C ---                      SPECIFIED LINK LENGTH, TO CALLING ROUTINE    
C ---             RJ     = TURNING RADIUS, TO CALLING ROUTINE           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C       THIS ROUTINE IS BASED ON THE LOGIC IN THE COMCOR ROUTINE OF     
C     GTRAF.  IT IS ASSUMED THAT NO ENTRY LINKS CAN APPROACH A          
C     MICRONODE AND THAT THE VEHICLE TYPE CODE IS 0.                    
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    REBSEQ - MODULE 32310.2.2                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    LANMAP - MODULE 32310.2211                         
C                    REBLNW - MODULE 32310.1.3.4                        
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARBAPR  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             LINK NUMBER                                               
C     ARBDIS  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - THE      
C             SMALLER OF THE DISTANCE FROM THE STOPLINE TO POINT AT     
C             UPSTREAM END OF LINK WHERE CURB OR MEDIAN TERMINATES      
C     ARBFED  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             FEEDER LINK                                               
C     ICODE   CODE (1, -1) IF ARC OF LINK IL IS                         
C              (CLOCKWISE, COUNTER-CLOCKWISE)                           
C     ICODEF  CODE (1, -1) IF ARC OF LINK IFL IS                        
C              (CLOCKWISE, COUNTER-CLOCKWISE)                           
C     IJ      INDEX OVER APPROACHES AND RECEIVERS TO MICRONODE IN       
C     ILANE   RECEIVER LANE NUMBER AS IT IS USED IN DRAWING             
C     ILANEF  FEEDER LANE NUMBER AS IT IS USED IN DRAWING               
C     ILN     INDEX OVER LANES                                          
C     IND     INDEX TO MICRONODE APPROACH & RECEIVER ARRAYS FOR LINK IL 
C     INDF    INDEX TO MICRONODE APPROACH & RECEIVER ARRAYS FOR LINK IFL
C     INDPF   INDEX TO MICRONODE APPROACH & RECEIVER ARRAYS FOR         
C             LINK ITFL                                                 
C     ITFL    FEEDER LINK TO LINK IL                                    
C     LEVCRV  GLOBAL LINK SPECIFIC ARRAY - CURVATURE CODE (BITS 1-2)    
C             AND DRAWING LEVEL (BITS 3-16)                             
C     NMAPRC  MAXIMUM NUMBER OF APPROACHES AND RECEIVERS TO MICRONODE   
C     RA      ANGLE OF ARC, LATER ANGLE OF SECTOR WITH X-AXIS           
C     RANGFF  ANGLE OF FEEDER LINK WITH X-AXIS                          
C     RANGF2  ANGLE LINE FROM POINT (RXO, RYO) TO POINT (RXB, RYB) MAKES
C             WITH THE X-AXIS                                           
C     RANGII  ANGLE OF SUBJECT LINK WITH X-AXIS                         
C     RANGI2  ANGLE LINE FROM POINT (RXB, RYB) TO POINT (RX1, RY1) MAKES
C             WITH THE X-AXIS                                           
C     RDOT    DOT PRODUCT OF TWO SEGMENTS IN PARALLEL LINK CASE         
C     RD1     DIFFERENCE BETWEEN ANGLE OF THE FEEDER LINK AND ANGLE OF  
C             LINE FORM POINT (RXO,RYO) TO RXB,RYB).                    
C     RD2     DIFFERENCE BETWEEN ANGLE OF THE SUBJECT LINK AND ANGLE OF 
C             LINE FORM POINT (RXB,RYB) TO RXO,RYO).                    
C     RF      DISTANCE FROM POINT (RXB,RYB) TO POINT (RX1,RY1)          
C     RG      DISTANCE FROM POINT (RXO,RYO) TO POINT (RXB,RYB)          
C     RINPL   INPUT LINK LENGTH, I.E., LINK LENGTH USED BY NETSIM       
C     RK      DISTANCE WHICH VEHICLE WILL MOVE STRAIGHT BEFORE          
C             BEGINNING TURN                                            
C     RL      LENGTH OF TURNING VEHICLE PATH PRIOR TO ENTERING ITS      
C             TARGET LANE ON LINK IL                                    
C     RLKLEN  LINK LENGTH USED FOR VEHICLE LOCATION COMPUTATIONS        
C     RLWIL   DRAWING LANE SPECIFIC ARRAY - LANE WIDTHS FOR LINK IL     
C     RMAGB   MAGNITUDE OF FIRST SEGMENT IN PARALLEL LINK CASE          
C     RPROJ   PROJECTION OF ONE LINE SEGMENT ONTO ANOTHER               
C     RTANA2  TANGENT OF ANGLE RA/2                                     
C     RTF     TANGENT OF RANGFF                                         
C     RTI     TANGENT OF RANGII                                         
C     RW      INTERSECTION WIDTH                                        
C     RWIL    WIDTH OF LEFT MOST LEFT POCKET OF PARALLEL                
C             LINK TO LINK IL IF IT EXISTS                              
C     RW2     DISTANCE OF EACH SEGMENT OF INTERSECTION PATH FOR         
C             PARALLEL LINK CASE                                        
C     RXB     X COORDINATE OF POINT WHERE THE LINE PARALLEL TO LINK IFL 
C             THROUGH POINT (RXO, RYO) INTERSECTS THE LINE PARALLEL     
C             TO LINK IL THROUGH POINT (RX1, RY1)                       
C     RXO     X COORDINATE OF POINT ON STOPLINE AT CENTER OF LANE ILN1  
C             ON LINK IFL                                               
C     RX1     X COORDINATE OF CENTER-POINT AT UPSTREAM END OF LANE ILN2 
C             ON LINK IL                                                
C     RYB     Y COORDINATE OF POINT WHERE THE LINE PARALLEL TO LINK IFL 
C             THROUGH POINT (RXO, RYO) INTERSECTS THE LINE PARALLEL     
C             TO LINK IL THROUGH POINT (RX1, RY1)                       
C     RYO     Y COORDINATE OF POINT ON STOPLINE AT CENTER OF LANE ILN1  
C             ON LINK IFL                                               
C     RY1     Y COORDINATE OF CENTER-POINT AT UPSTREAM END OF LANE ILN2 
C             ON LINK IL                                                
C     R1      DISTANCE FROM CURB TO CENTER OF VEHICLE ON LINK IL        
C     R2      DISTANCE FROM CURB TO CENTER OF VEHICLE ON LINK IFL       
C     WSTRIN  FLAG (T, F) IF INTERSECTION PATH (IS, IS NOT) A STRAIGHT  
C             LINE FROM (RXO,RYO) TO (RX1,RY1)                          
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH (BITS 1-12)             
C     ZPI     VALUE OF PI                                               
C     ZRBACM  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - THE      
C             ANGLE THE LINE FROM THE CENTER OF THE BASIC ARC TO THE    
C             (CURBSIDE, MEDIANSIDE) UPSTREAM POINT, IF (RDISC, RDISM)  
C             IS THE MINIMUM DISTANCE FROM THE STOPLINE WITH RESPECT    
C             TO THE CENTER LINE, 0 IF STRAIGHT LINK                    
C     ZRBACS  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - THE      
C             ANGLE THE RADIAL TO CURBSIDE STOPLINE POINT MAKES WITH    
C             X-AXIS, 0 IF STRAIGHT LINK                                
C     ZRBANG  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             ANGLE LINK MAKES WITH X AXIS                              
C     ZRBCNX  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             X COORDINATE OF CENTRAL POINT, 0 IF STRAIGHT LINK         
C     ZRBCNY  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             Y COORDINATE OF CENTRAL POINT, 0 IF STRAIGHT LINK         
C     ZRBNOD  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - DISTANCE 
C             FROM STOP-LINE OF LINK TO DOWNSTREAM NODE                 
C     ZRBRCC  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - RADIUS   
C             FROM CENTER TO CURB ON DOWNSTREAM END, 0 IF STRAIGHT LINK 
C     ZRBSLX  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             THE X COORDINATE OF THE POINT WHERE THE STOPLINE          
C             INTERSECTS THE CURB, 0 IF STRAIGHT LINK                   
C     ZRBSLY  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY -          
C             THE Y COORDINATE OF THE POINT WHERE THE STOPLINE          
C             INTERSECTS THE CURB, 0 IF STRAIGHT LINK                   
C     ZRBSTP  MICRONODE APPROACH AND RECEIVER SPECIFIC ARRAY - DISTANCE 
C             FROM STOP-LINE OF LINK TO UPSTREAM NODE                   
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q,S-V,X), REAL (R,Z), LOGICAL(W,Y)            
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
      COMMON /PRG026/ LEVCRV(1)                                         
      COMMON /PRG025/ ZPI                                               
C                                                                       
      DIMENSION RLEN(3), RLWIL(7)                                       
C                                                                       
      ICODEP = 0                                                        
      CALL LANMAP (ILN1, IFL, ILANEF)                                   
      CALL LANMAP (ILN2, IL, ILANE)                                     
C                                                                       
C -----  DETERMINE INDEX IN MICRONODE APRROACH AND RECEIVER SPECIFIC    
C -----  ARRAYS FOR LINKS IL AND IFL                                    
C                                                                       
         DO 5 IJ = 1, NMAPRC                                            
            IF (ARBAPR(IJ) .EQ. IL) IND = IJ                            
            IF (ARBAPR(IJ) .EQ. IFL) INDF = IJ                          
    5    CONTINUE                                                       
C                                                                       
C -----  DETERMINE DISTANCE FROM CURB TO CENTER OF VEHICLE ON LINK IL   
C -----  AND THE ANGLE OF THE LINK                                      
C                                                                       
      CALL REBLNW (IL, RWIL, RLWIL)                                     
      R1 = 0.                                                           
      IF (ILANE .GT. 1) THEN                                            
         DO 6 ILN = 1, ILANE - 1                                        
            R1 = R1 + RLWIL(ILN)                                        
    6    CONTINUE                                                       
      ENDIF                                                             
      R1 = R1 + RLWIL(ILANE) * .5                                       
      RANGII = ZRBANG(IND)                                              
C                                                                       
C -----  IF LINK IL IS CURVED, THE ANGLE OF LINK IL AS IT EXITS THE     
C -----  INTERSECTION IS PERPENDICULAR TO THE RADIAL FROM THE CENTER OF 
C -----  THE BASIC ARC TO THE UPSTREAM CURB POINT OR MEDIAN POINT       
C -----  DEPENDING OF WHICH IS CLOSER TO THE STOPLINE OF LINK IL        
C                                                                       
      ICODE = 0                                                         
      IF (MOD(LEVCRV(IL), 4) .NE. 0) THEN                               
         ICODE = 1                                                      
         IF (MOD(LEVCRV(IL), 4) .EQ. 2) ICODE = -1                      
         RANGII = -REAL(ICODE) * ZPI * .5 + ZRBACM(IND)                 
         IF (RANGII .GT. ZPI) RANGII = RANGII - 2. * ZPI                
         IF (RANGII .LT. -ZPI) RANGII = RANGII + 2. * ZPI               
      ENDIF                                                             
C                                                                       
C -----  DETERMINE LENGTH OF LINK AS SPECIFIED BY USER AND THE DISTANCE 
C -----  THE VEHICLE HAS TRAVELLED ON THIS LINK RELATIVE TO THIS        
C -----  LENGTH                                                         
C                                                                       
      RINPL = MOD (XLNGTH(IL), 4096)                                    
      RLKLEN= RINPL                                                     
C                                                                       
C -----  IF LINK IL HAS A PRIMARY FEEDER, COMPUTE THE LENGTH OF THE LINK
C -----  FROM STOPLINE OF PRIMARY FEEDER TO STOPLINE OF LINK IL         
C                                                                       
      RLKLEN = ZRBSTP(IND)                                              
      IF (ARBFED(IND) .NE. 0) THEN                                      
         ITFL = ARBFED(IND)                                             
            DO 7 IJ = 1, NMAPRC                                         
               IF (ARBAPR(IJ) .EQ. ITFL) INDPF = IJ                     
    7       CONTINUE                                                    
         RLKLEN = ZRBNOD(INDPF) + RLKLEN                                
         RFACT = RINPL / RLKLEN                                         
      ENDIF                                                             
C                                                                       
C -----  DETERMINE THE WIDTH OF THE INTERSECTION AT THE UPSTREAM        
C -----  END OF LINK IL                                                 
C                                                                       
      RW  = RLKLEN - ARBDIS(IND)                                        
C                                                                       
C -----  DETERMINE THE POINT ON SUBJECT LINK WHERE VEHICLE EXITS THE    
C -----  INTERSECTION                                                   
C                                                                       
      RX1 = ZRBSLX(IND) - R1*SIN(RANGII) - ARBDIS(IND)*COS(RANGII)      
      RY1 = ZRBSLY(IND) + R1*COS(RANGII) - ARBDIS(IND)*SIN(RANGII)      
C                                                                       
C -----  IF THE LINK IS CURVED, THIS POINT IS COMPUTED BASED ON THE     
C -----  ANGLE THE RADIAL FROM THE CENTER OF THE BASIC ARC TO THE       
C -----  UPSTREAM CURB OR MEDIAN POINT DEPENDING ON WHICH IS THE        
C -----  CLOSEST TO THE STOPLINE WHEN PROJECTED ONTO THE BASIC CENTRAL  
C -----  ARC                                                            
C                                                                       
      IF (ICODE .NE. 0) THEN                                            
         RX1 = ZRBCNX(IND) + (ZRBRCC(IND) + REAL(ICODE) * R1)           
     1       * COS(ZRBACM(IND))                                         
         RY1 = ZRBCNY(IND) + (ZRBRCC(IND) + REAL(ICODE) * R1)           
     1       * SIN(ZRBACM(IND))                                         
      ENDIF                                                             
C                                                                       
C -----  DETERMINE CHARACTERISTICS OF FEEDER LINK                       
C                                                                       
      RANGFF = ZRBANG(INDF)                                             
      CALL REBLNW (IFL, RWIL, RLWIL)                                    
      R2 = 0.                                                           
      IF (ILANEF .GT. 1) THEN                                           
         DO 8 ILN = 1, ILANEF - 1                                       
            R2 = R2 + RLWIL(ILN)                                        
    8    CONTINUE                                                       
      ENDIF                                                             
      R2 = R2 + RLWIL(ILANEF) * .5                                      
      RXO = ZRBSLX(INDF) - R2 * SIN(RANGFF)                             
      RYO = ZRBSLY(INDF) + R2 * COS(RANGFF)                             
C                                                                       
C -----  IF THE FEEDER LINK IS CURVED, THEN THE ANGLE OF THE FEEDER LINK
C -----  AS IT APPROACHES THE INETERSECTION IS PERPENDICULAR TO THE     
C -----  RADIAL FROM THE CENTER OF THE BASIC ARC TO THE STOP LINE       
C -----  CURB POINT OF THE FEEDER AND THE POINT (RXO, RYO) IS COMPUTED  
C -----  BASED ON STOP LINE RADIAL OF THE FEEDER LINK                   
C                                                                       
      ICODEF = 0                                                        
      IF (MOD(LEVCRV(IFL), 4) .NE. 0) THEN                              
         ICODEF = 1                                                     
         IF (MOD(LEVCRV(IFL), 4) .EQ. 2) ICODEF = -1                    
         RANGFF = -REAL(ICODEF) * ZPI * .5 + ZRBACS(INDF)               
         IF (RANGFF .GT. ZPI) RANGFF = RANGFF - 2. * ZPI                
         IF (RANGFF .LT. -ZPI) RANGFF = RANGFF + 2. * ZPI               
         RXO = ZRBCNX(INDF) + (ZRBRCC(INDF) + REAL(ICODEF)*R2)          
     1         * COS(ZRBACS(INDF))                                      
         RYO = ZRBCNY(INDF) + (ZRBRCC(INDF) + REAL(ICODEF)*R2)          
     1         * SIN(ZRBACS(INDF))                                      
      ENDIF                                                             
C                                                                       
C -----  IF THE ANGLE BETWEEN THE FEEDER AND SUBJECT LINEAR INTERSECTION
C -----  PATHS IS GREATER THAT 10 DEGREES, COMPUTE THE INTERSECTION     
C -----  POINT (RXB, RYB), DETERMINE THE CURVED PORTION OF THE PATH     
C -----  CONNECTING THE LINEAR PATHS, DETERMINE WHICH PORTION OF THE    
C -----  INTERSECTION PATH THE VEHICLE IS ON AND ITS EXACT LOCATION.    
C -----  IF THE ANGLE IS LESS THAN 10 DEGREES, THEN SKIP TO LOGIC FOR   
C -----  PARALLEL LINKS.                                                
C                                                                       
      IF (IABS(INT(100 * (RANGII + ZPI)) - INT(100 * (RANGFF + ZPI)))   
     1                                               .GE. 17) THEN      
         IF (NINT (ABS (RANGFF) * 100.) .EQ. 157) THEN                  
            RXB = RXO                                                   
            RYB = RY1 + (RXB - RX1) * SIN(RANGII)/COS(RANGII)           
         ELSE IF (NINT (ABS (RANGII) * 100.) .EQ. 157) THEN             
            RXB = RX1                                                   
            RYB = RYO + (RXB - RXO) * SIN(RANGFF)/COS(RANGFF)           
         ELSE                                                           
            RTI = SIN(RANGII)/COS(RANGII)                               
            RTF = SIN(RANGFF)/COS(RANGFF)                               
            RXB = (RX1*RTI - RXO*RTF + RYO - RY1) / (RTI - RTF)         
            RYB = RY1 + (RXB - RX1) * RTI                               
         ENDIF                                                          
C                                                                       
C -----  IF THE INTERSECTION OF THE LANE CENTERLINES IS UPSTREAM OF THE 
C -----  STOP-LINE ON THE DISCHARGING LINK, OR DOWNSTREAM OF THE        
C -----  RECEIVING LINK, MOVE THE VEHICLE IN A STRAIGHT LINE FROM       
C -----  POINT (RXO, RYO) TO (RX1, RY1) UNTIL THE VEHICLE ENTERS THE    
C -----  RECEIVING LINK                                                 
C                                                                       
         IF (ANINT(RXB * 100.) .NE. ANINT(RXO * 100.)) THEN             
            RANGF2 = ATAN (ABS((RYB - RYO) / (RXB - RXO)))              
         ELSE                                                           
            RANGF2 = ZPI * .5                                           
         ENDIF                                                          
         IF (RXB .LT. RXO) RANGF2 = -RANGF2 + ZPI                       
         IF (RYB .LT. RYO) RANGF2 = -RANGF2                             
         IF (ANINT(RX1 * 100.) .NE. ANINT(RXB * 100.)) THEN             
            RANGI2 = ATAN (ABS((RY1 - RYB) / (RX1 - RXB)))              
         ELSE                                                           
            RANGI2 = ZPI * .5                                           
         ENDIF                                                          
         IF (RX1 .LT. RXB) RANGI2 = -RANGI2 + ZPI                       
         IF (RY1 .LT. RYB) RANGI2 = -RANGI2                             
C                                                                       
C -----  COMPARE THE ANGLE OF THE FEEDER LINK TO THE ANGLE FROM         
C -----  POINT (RXO,RYO) TO POINT (RXB, RYB).  IF THE ANGLE IS          
C -----  DIFFERENT, THEN IT IS ASSUMED TO BE DIFFERENT BY ZPI           
C -----  RADIANS, I.E., THE INTERSECTION POINT IS UPSTREAM OF THE       
C -----  STOP-LINE FOR THE FEEDER LINK.  SIMILARLY, COMPARE ANGLE       
C -----  OF THE SUBJECT LINK TO THE ANGLE FROM POINT (RXB, RYB)         
C -----  TO POINT (RX1, RY1)                                            
C                                                                       
         WSTRIN = .FALSE.                                               
         RD1 = ABS(RANGFF - RANGF2)                                     
         RD2 = ABS(RANGII - RANGI2)                                     
         IF (RD1 .GT. 6.28) RD1 = 0.                                    
         IF (RD2 .GT. 6.28) RD2 = 0.                                    
         IF (RD1 .GT. .2 .OR. RD2 .GT. .2) THEN                         
            WSTRIN = .TRUE.                                             
            RL = SQRT ((RY1 - RYO)**2 + (RX1-RXO)**2)                   
            RFACT = RFACT * RW / RL                                     
            RLEN(1) = RL                                                
            RLEN(2) = 0.                                                
            RLEN(3) = 0.                                                
            INUM = 1                                                    
            R0X = RXO                                                   
            R0Y = RYO                                                   
            R1X = RX1                                                   
            R1Y = RY1                                                   
         ENDIF                                                          
         IF (WSTRIN)                                         GO TO 10   
C                                                                       
C --- COMPUTE: DISTANCE, RG, BETWEEN POINTS (RXO,RYO) AND (RXB,RYB);    
C ---          DISTANCE, RF, BETWEEN POINTS (RXB,RYB) AND (RX1,RY1);    
C ---          ANGLE, RA, OF SECTOR;                                    
C ---          TURNING RADIUS, RJ;                                      
C ---          DISTANCE, RK, VEHICLE MOVES STRAIGHT BEFORE TURNING;     
C ---          TOTAL LENGTH, RL, OF INTERSECTION PATH                   
C                                                                       
         RG = SQRT ((RXB - RXO) ** 2 + (RYB - RYO) ** 2)                
         RF = SQRT ((RXB - RX1) ** 2 + (RYB - RY1) ** 2)                
         RA = RANGII - RANGFF                                           
         IF (RA .GT.  ZPI) RA = RA - ZPI * 2.                           
         IF (RA .LT. -ZPI) RA = RA + ZPI * 2.                           
         RJ = 30.                                                       
         RTANA2 = TAN (ABS (RA) / 2.)                                   
         RJ = MIN (RF / RTANA2, RJ)                                     
C                                                                       
C -----  IF ENOUGH DISTANCE TO INTERSECTION POINT WHERE VEHICLE CAN     
C -----  BE MOVED IN A STRAIGHT LINE FIRST, ADJUST RADIUS.  THE         
C -----  STRAIGHT DISTANCE MOVED WOULD BE 15' SO 30' IS REQUIRED.       
C -----  (SSW)                                                          
C                                                                       
         IF (RG  .GT. 30.) RJ = MIN (RJ, (RG-15.) / RTANA2)             
         RK = MAX (RG - RJ * RTANA2, 0.)                                
C                                                                       
C -----  COMPUTE THE DISTANCE TRAVELLED TO TRAVERSE THE ENTIRE          
C -----  INTERSECTION                                                   
C                                                                       
         RL = RK + RJ * ABS (RA) + RF - RJ * RTANA2                     
         RFACT = RFACT * RW / RL                                        
         R1X = RXO + RK * COS (RANGFF)                                  
         R1Y = RYO + RK * SIN (RANGFF)                                  
         R2X = RX1 - (RF - RJ * RTANA2) * COS (RANGII)                  
         R2Y = RY1 - (RF - RJ * RTANA2) * SIN (RANGII)                  
         RLEN(1) = RK                                                   
         RLEN(2) = ABS(RA) * RJ                                         
         RLEN(3) = RF - RJ * RTANA2                                     
         ICODEP = 1                                                     
         IF ((R1X-R0X)*(R2Y-R1Y)-(R1Y-R0Y)*(R2X-R1X).GE.0) ICODEP = 2   
         R0X = RXO                                                      
         R0Y = RYO                                                      
         R3X = RX1                                                      
         R3Y = RY1                                                      
         INUM = -3                                                      
         IF (INT(RLEN(3)*10) .EQ. 0) INUM = -2                          
C                                                                       
   10 CONTINUE                                                          
C                                                                       
C --- SPECIAL CASE FOR PARALLEL LINKS (WITHIN 10 DEGREES)               
C                                                                       
      ELSE                                                              
         R1X = RXO + COS(RANGFF) * RW / 2.                              
         R1Y = RYO + SIN(RANGFF) * RW / 2.                              
         R0X = RXO                                                      
         R0Y = RYO                                                      
         R3X = RX1                                                      
         R3Y = RY1                                                      
         RLEN(1) = RW / 2.                                              
         IF (IFL .EQ. ITFL) THEN                                        
            R2X = RX1 - COS(RANGII) * RW / 2.                           
            R2Y = RY1 - SIN(RANGII) * RW / 2.                           
            RLEN(2) = RW / 2.                                           
         ELSE                                                           
            RMAGB = SQRT ((R1X - R0X) ** 2 + (R1Y - R0Y) ** 2)          
            RW2 = RW / 2                                                
            IF (RMAGB .GT. 0) THEN                                      
               RDOT = (R3X-R0X)*(R1X-R0X) + (R3Y-R0Y)*(R1Y-R0Y)         
               RPROJ = RDOT / RMAGB                                     
               RW2 = MAX (RPROJ - RW / 2., 0.)                          
            ENDIF                                                       
            R2X = RX1 - COS(RANGII) * RW2                               
            R2Y = RY1 - SIN(RANGII) * RW2                               
         ENDIF                                                          
         INUM = 2                                                       
         RLEN(3) = 0                                                    
      ENDIF                                                             
      IF(YTRACE) WRITE(LU6,*)' CONPTH: R0(X,Y) R1(X,Y) R2(X,Y) R3(X,Y)',
     1  R0X,R0Y,R1X,R1Y,R2X,R2Y,R3X,R3Y                                 
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CORDNT (I1)                                            
C                                                                       
C                                                                       
C --- CODED   05-08-86 BY A. HALATI                                     
C --- REVISED  3-04-88 BY O. SHARAF-ELDIEN FOR PROPER COORDINATION      
C                                                                       
C --- TITLE - DETERMINE IF IT IS COORDINATION TIME - MODU;E 3233.2.4    
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES IF IT IS THE BEGINNING OF A     
C                NEW COORDINATION CYCLE.                                
C                                                                       
C --- ARGUMENTS - I1 : SUBNETWORK ACTUATED NODE NUMBER                  
C                                                                       
C -------------------   DESCRIPTION   ----------------------------------
C                       -----------                                     
C                                                                       
C     THIS ROUITNE FIRST DETERMINES IF THE SPECIFIED CONTROLLER IS      
C     COORDINATED. FOR A COORDINATED CONTROLLER IT CHECKS IF IT IS THE  
C     BEGINNING TIME OF A NEW COORDINATION CYCLE. IF IT IS, THEN A FLAG 
C     IN ACTRAM ARRAY IS SET.                                           
C                                                                       
C -----------------   THIS ROUTINE CALLED BY   -------------------------
C                     ----------------------                            
C                                                                       
C                  UPACT - MODULE - 3233.2                              
C                                                                       
C -------------------   THIS ROUTINE CALLS   ---------------------------
C                       ------------------                              
C                                                                       
C                            NONE                                       
C                                                                       
C -----------------   GLOSSARY OF VARIABLE NAMES   ---------------------
C                     --------------------------                        
C                                                                       
C     ACCORT   COORDINATION TIMER, SECONDS                              
C     ACCYCL   COORDINATED CONTROLLER CYCLE LENGTH                      
C     ACTRAM   EMULATION OF MOTOROLLA 6800 RAM MEMORY                   
C     IAC      SUBNETWORK ACTUATED NODE NUMBER                          
C     INRAM    INDEX TO DATA POSITION IN ACTRAM ARRAY FOR ACTUATED NODE 
C                                                                       
C ----------------------------------------------------------------------
C                                                                       
      IMPLICIT INTEGER (A-B, D-Q, S-V, X), REAL (R,Z), LOGICAL (W,Y)    
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IAC = I1                                                          
C                                                                       
C --- DETERMINE IF THE CONTROLLER IS COORDINATED.                       
C                                                                       
      IF (ACCYCL (IAC) .GT. 0) THEN                                     
C                                                                       
C --- COORDINATED. CHECK IF IT IS TIME FOR COORDINATION. IF IT IS, SET  
C --- THE FLAG. IF NOT, DECREMENT THE TIMER.  NOTE: THE TIMER SHOULD BE 
C --- 1 SEC LESS THAN THE CYCLE LENGTH TO PROVIDE PROPER COORDINATION.  
C                                                                       
        INRAM = (IAC - 1) * 751                                         
        IF (ACCORT (IAC) .LE. 0) THEN                                   
           ACCORT (IAC) = ACCYCL (IAC) - 1                              
           ACTRAM (INRAM + 114) = 1                                     
        ELSE                                                            
           ACCORT (IAC) = ACCORT (IAC) - 1                              
           ACTRAM (INRAM + 114) = 0                                     
        ENDIF                                                           
      ELSE                                                              
         INRAM = (IAC -1) * 751                                         
         ACTRAM (INRAM +19) = 14                                        
      ENDIF                                                             
      RETURN                                                            
      END                                                               
      SUBROUTINE COUNTR                                                 
C                                                                       
C --- CODED    4-03-82 BY C. REDWINE, JFT ASSOCIATES                    
C --- MODIFIED 10-11-85 BY A. HALATI FOR TRAF/NETSIM ACTUATED LOGIC     
C                                                                       
C --- TITLE - COUNT DETECTOR ACTUATIONS                                 
C ---         MODULE 3233.2622.4                                        
C                                                                       
C --- FUNCTION - EMULATE Q5 COUNTR                                      
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     RESET DETECTOR COUNTERS WHENEVER A NEW YELLOW IS OUTPUT AND KEEP  
C     TRACK OF COUNTS ON EACH DETECTOR.                                 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    LOOP1  - MODULE 3233.2622                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    NONE                                               
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     CLSTAT       CALL STATUS                                          
C     FAZBIT       DETECTOR PHASE ASSIGNMENT                            
C     OLGFZ        PREVIOUS GREENS 0.1 SEC AGO                          
C     YFAZE        YELLOW PHASES FLAGS                                  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER  (A-Z)                                           
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      EQUIVALENCE (CLSTAT, LOWRAM(100)),                                
     1            (FAZBIT, LOWRAM(102)),                                
     2            (OLGFZ,  LOWRAM(108)),                                
     4            (YFAZE,  LOWRAM(163)),                                
     7            (IXREG,  LOWRAM(43))                                  
C                                                                       
C           CLEAR COUNTER IF PHASE JUST TURNED YELLOW                   
C                                                                       
      IF (IAND(IAND(FAZBIT, OLGFZ), YFAZE).NE.0) LOWRAM(IXREG+192) = 0  
C                                                                       
C           INCREMENT COUNTER IF DETECTOR IS JUST OFF                   
C                                                                       
      IF (MOD(CLSTAT,2).EQ.0 .AND. MOD(CLSTAT/2,2).EQ.1)                
     1                    LOWRAM(IXREG+192) = LOWRAM(IXREG+192) + 1     
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CPFN96                                                 
C                                                                       
C --- CODED    5-7-91 BY J. WERK                                        
C                                                                       
C --- TITLE - COMPUTE PATH FROM ORIGIN LINK TO DESTINATION LINK -       
C ---         MODULE 2261.11.3.3                                        
C                                                                       
C --- FUNCTION - THIS MODULE COMPUTES THE PATHS FROM ALL ORIGIN LINKS   
C ---            TO ALL DESTINATION LINKS FOR ALL INTERCHANGES.         
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     IF NO ERRORS WERE ENCOUNTERED DURING THE PROCESSING OF THE TYPE   
C     96 CARDS THEN THIS ROUTINE IS CALLED TO COMPUTE ALL THE PATHS     
C     FROM ALL ORIGIN LINKS TO ALL DESTINATION LINKS FOR EACH           
C     INTERCHANGE.  A ROUTINE IS THEN CALLED TO STORE THESE PATHS IN    
C     THE XIPATH ARRAY.                                                 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    RDFN96 - MODULE 2261.11.3                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                    SPFN96 - MODULE 2261.11331                         
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK           
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     I       INDEX TO DO LOOP                                          
C     IBEG    POINTER TO FIRST DESTINATION LINK IN IDESTN FOR APPROACH  
C             IORIG                                                     
C     ICHG    INTERCHANGE NUMBER                                        
C     ICNTD   COUNTER OF TOTAL NUMBER OF DESTINATION LINKS FOR EACH     
C             UNIQUE APPROACH FOR A PARTICULAR INTERCHANGE              
C     ICNTO   COUNTER OF TOTAL NUMBER OF UNIQUE APPROACHES TO A         
C             PARTICULAR INTERCHANGE                                    
C     IDEST   LINK NUMBER OF DESTINATION LINK                           
C     IDESTN  ARRAY CONTAINING LIST OF ALL UNIQUE DESTINATION LINKS FOR 
C             INTERCHANGE ICHG                                          
C     IEND    POINTER TO LAST DESTINATION LINK IN IDESTN FOR APPROACH   
C             IORIG                                                     
C     II      INDEX TO DO LOOP                                          
C     III     INDEX TO DO LOOP                                          
C     IL      LINK NUMBER OF CURRENT LINK ALONG A PATH                  
C     ILAST   LAST ELEMENT IN XNCGLK ARRAY FOR INTERCHANGE ICHG         
C     IL2     LINK WITHIN INTERCHANGE                                   
C     IND     INDEX TO LOCATION IN XTRPTB ARRAY FOR INTERCHANGE ICHG    
C     IND2    INDEX TO LOCATION IN XTRPTB ARRAY FOR INTERCHANGE ICHG    
C     INUM    NUMBER OF TURN MOVEMENTS POSSIBLE FROM A LINK             
C     IORIG   LINK NUMBER OF ENTRY APPROACH TO INTERCHANGE              
C     IORIGN  ARRAY CONTAINING LIST OF ALL UNIQUE APPROACH LINKS, IORIG 
C             FOR INTERCHANGE ICHG                                      
C     IP      INDEX OF LINK ALONG A PARTICULAR PATH                     
C     IPNT    POINTER ARRAY TO FIRST AND LAST ELEMENT IN IDESTN         
C             PERTAINING TO IORIG                                       
C     ISPATH  TEMPORARY PATH ARRAY CONTAINING A LINK NUMBER AND THE TURN
C             CODE FROM THAT LINK                                       
C     IV      INDEX TO DO LOOP                                          
C     J       INDEX TO DO LOOP, FIRST ELEMENT IN XNCGLK ARRAY FOR       
C             INTERCHANGE ICHG                                          
C     K       INDEX OF DO LOOP                                          
C     KT      TURN MOVEMENT CODE FROM PTURN ARRAY                       
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK            
C     MAXICH  MAXIMUM INTERCHANGE NUMBER                                
C     NCGLNK  POINTER ARRAY TO FIRST ELEMENT IN XNCGLK PERTAINING TO    
C             INTERCHANGE ICHG                                          
C     NTCHG   POINTER ARRAY TO FIRST ELEMENT IN XTRPTB PERTAINING TO    
C             INTERCHANGE ICHG                                          
C     NUM96C  INTERCHANGE SPECIFIC ARRAY - NUMBER OF ELEMENTS IN        
C             XTRPTB ARRAY                                              
C     NUMLNK  NUMBER OF LINKS IN INTERCHANGE ICHG                       
C     PTURN   ARRAY CONTAINING TURN MOVEMENT CODES FOR ALL POSSIBLE TURN
C             MOVEMENTS FROM A PARTICULAR LINK                          
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK                 
C     WDUPL   FLAG INDICATING WHETHER DESTINATION LINK FOR A PARTICULAR 
C             APPROACH WAS ALREADY STORED IN THE IDESTN ARRAY           
C     WINLST  FLAG INDICATING WHETHER APPROACH LINK WAS ALREADY STORED  
C             IN IORIGN ARRAY                                           
C     WMATCH  FLAG INDICATING WHETHER LINK WAS DEFINED TO BE IN         
C             INTERCHANGE                                               
C     XIPATH  ARRAY CONTAINING TURN MOVEMENT CODES DEFINING THE PATH    
C             FROM AN ORIGIN TO A DESTINATION LINK                      
C     XNCGLK  PACKED LINK NUMBERS OF THREE LINKS WITHIN INTERCHANGE ICHG
C     XTRPTB  ARRAY CONTAINING - IORIG, IDEST, TURN CODE ON DESTINATION 
C             LINK, AND PERCENTAGE OF TRAFFIC ON ORIGIN LINK THAT       
C             TRAVELS TO DESTINATION LINK AND EXECUTES THAT TURN        
C             MOVEMENT.                                                 
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      DIMENSION IORIGN (50)                                             
      DIMENSION IDESTN (2501)                                           
      DIMENSION IPNT (50)                                               
      DIMENSION PTURN (11)                                              
      DIMENSION ISPATH (11)                                             
C                                                                       
C -----  INITIALIZE LOCAL VARIABLES TO ZERO.                            
C                                                                       
         DO 20 J = 1, 50                                                
            IORIGN (J) = 0                                              
   20    CONTINUE                                                       
         DO 30 J = 1, 2501                                              
            IDESTN (J) = 0                                              
   30    CONTINUE                                                       
         DO 40 J = 1, 50                                                
            IPNT (J) = 0                                                
   40    CONTINUE                                                       
C                                                                       
C -----  FOR EACH INTERCHANGE, INITIALIZE ORIGIN AND DESTINATION        
C -----  COUNTERS TO ZERO.  LOOP OVER ALL 96 CARDS FOR THE INTERCHANGE  
C -----  AND STORE ALL UNIQUE APPROACH LINKS IN IORIGN.  FOR EACH       
C -----  UNIQUE APPROACH, LOOP OVER ALL 96 CARDS FOR INTERCHANGE AND    
C -----  STORE ALL UNIQUE DESTINATION LINKS IN IDESTN AND THE POINTER   
C -----  TO FIRST ELEMENT IN IDESTN FOR AN ORIGIN IN IPNT ARRAY.        
C                                                                       
         DO 200 ICHG = 1, MAXICH                                        
            IF (NUM96C(ICHG) .EQ. 0)                         GO TO 190  
            ICNTO = 0                                                   
            ICNTD = 0                                                   
               DO 80 I = 1, NUM96C(ICHG)                                
                  IND = NTCHG(ICHG) + I - 1                             
                  IORIG = MOD (XTRPTB(IND), 2**10)                      
                  WINLST = .FALSE.                                      
                     DO 50 II = 1, 50                                   
                        IF (IORIGN (II) .EQ. IORIG) WINLST = .TRUE.     
   50                CONTINUE                                           
                  IF (.NOT. WINLST) THEN                                
                     ICNTO = ICNTO + 1                                  
                     IORIGN (ICNTO) = IORIG                             
                     IPNT (ICNTO) = ICNTD + 1                           
                        DO 70 III = 1, NUM96C(ICHG)                     
                           IND2 = NTCHG (ICHG) + III - 1                
                           IF (IORIG .EQ. MOD(XTRPTB(IND2), 2**10)) THEN
                              IDEST = MOD (XTRPTB(IND2), 2**20)/(2**10) 
                              WDUPL = .FALSE.                           
                                 DO 60 IV =  IPNT(ICNTO), ICNTD + 1     
                                    IF (IDESTN(IV) .EQ. IDEST)          
     1                                              WDUPL = .TRUE.      
   60                            CONTINUE                               
                              IF (.NOT. WDUPL) THEN                     
                                 ICNTD = ICNTD + 1                      
                                 IDESTN (ICNTD) = IDEST                 
                              ENDIF                                     
                           ENDIF                                        
   70                   CONTINUE                                        
                     IPNT (ICNTO) = IPNT (ICNTO) + ICNTD * (2**15)      
                  ENDIF                                                 
   80          CONTINUE                                                 
C                                                                       
C -----  DOUNTIL ALL ORIGINS FOR INTERCHANGE ARE SCANNED.  FOR EACH     
C -----  ORIGIN COMPUTE PATH TO EACH DESTINATION AND CALL ROUTINE TO    
C -----  STORE PATH IN XIPATH ARRAY.                                    
C                                                                       
               DO 150 I = 1, ICNTO                                      
                  IORIG = IORIGN (I)                                    
                  IL = IORIG                                            
                  IP = 1                                                
                  ISPATH (1) = IL                                       
                  INUM = 0                                              
                  PTURN (1) = 0                                         
                  IF (THRU(IL) .NE. 0) THEN                             
                     INUM = INUM + 1                                    
                     PTURN (1) = 2                                      
                  ENDIF                                                 
                  IF (LEFT(IL) .NE. 0) THEN                             
                     INUM = INUM + 1                                    
                     PTURN (1) = PTURN(1) + 2 ** (3 * (INUM - 1))       
                  ENDIF                                                 
                  IF (ARIGHT(IL) .NE. 0) THEN                           
                     INUM = INUM + 1                                    
                     PTURN (1) = PTURN(1) + 3 * (2 ** (3 * (INUM - 1))) 
                  ENDIF                                                 
                  IF (DIAGNL(IL) .NE. 0) THEN                           
                     INUM = INUM + 1                                    
                     PTURN (1) = PTURN(1) + 4 * (2 ** (3 * (INUM - 1))) 
                  ENDIF                                                 
                  PTURN (1) = PTURN (1) + 5 * (2 ** (3 * INUM))         
C                                                                       
   90             CONTINUE                                              
   95             CONTINUE                                              
                  KT = MOD (PTURN (IP), 2 ** 3)                         
                  PTURN (IP) = PTURN (IP) / (2 ** 3)                    
                  IF (KT .EQ. 5) THEN                                   
                     IF (IP .EQ. 1) THEN                                
                                                             GO TO 140  
                     ELSE                                               
                        IP = IP - 1                                     
                        IL = MOD (ISPATH(IP), 2**10)                    
                                                             GO TO 90   
                     ENDIF                                              
                  ENDIF                                                 
                  IBEG = MOD (IPNT (I), 2 ** 15)                        
                  IEND = IPNT (I) / (2 ** 15)                           
                  WMATCH = .FALSE.                                      
                     DO 100 II = IBEG, IEND                             
                        IF (IL .EQ. IDESTN (II)) THEN                   
                           WMATCH = .TRUE.                              
                           IDEST = IDESTN(II)                           
                        ENDIF                                           
  100                CONTINUE                                           
                  IF (WMATCH) THEN                                      
                     CALL SPFN96 (ISPATH, IP, ICHG, IORIG, IDEST)       
                     IP = IP - 1                                        
                     IL = MOD (ISPATH(IP), 2**10)                       
                  ELSE                                                  
                     IF (KT .EQ. 1) IL = LEFT (IL)                      
                     IF (KT .EQ. 2) IL = THRU (IL)                      
                     IF (KT .EQ. 3) IL = ARIGHT (IL)                    
                     IF (KT .EQ. 4) IL = IABS(DIAGNL(IL))               
                     J = NCGLNK(ICHG)                                   
                     INUM = NUMLNK(ICHG)                                
                     IF (MOD(INUM, 3) .NE. 0) THEN                      
                        ILAST = INUM/3 + J                              
                     ELSE                                               
                        ILAST = INUM/3 + J - 1                          
                     ENDIF                                              
                     II = J - 1                                         
  110                CONTINUE                                           
                     II = II + 1                                        
                     III = 0                                            
  120                CONTINUE                                           
                     III = III + 1                                      
                     IL2 = MOD(XNCGLK(II),2**(10*III)) / 2**(10*(III-1))
                     IF (IL .EQ. IL2) THEN                              
                        WMATCH = .TRUE.                                 
                                                             GO TO 130  
                     ENDIF                                              
                     IF (III .LT. 3)                         GO TO 120  
                     IF (II .LT. ILAST)                      GO TO 110  
  130                CONTINUE                                           
                     IF (WMATCH) THEN                                   
                        IP = IP + 1                                     
                        IF (IP .LE. 11 .AND. IP .LE. NUMLNK(ICHG)) THEN 
                           ISPATH (IP) = IL                             
                           INUM = 0                                     
                           PTURN (IP) = 0                               
                           IF (THRU(IL) .NE. 0) THEN                    
                              INUM = INUM + 1                           
                              PTURN (IP) = 2                            
                           ENDIF                                        
                           IF (LEFT(IL) .NE. 0) THEN                    
                              INUM = INUM + 1                           
                              PTURN (IP) = PTURN(IP) +                  
     1                                     2 ** (3 * (INUM - 1))        
                           ENDIF                                        
                           IF (ARIGHT(IL) .NE. 0) THEN                  
                              INUM = INUM + 1                           
                              PTURN (IP) = PTURN(IP) +                  
     1                                     3 * (2 ** (3 * (INUM - 1)))  
                           ENDIF                                        
                           IF (DIAGNL(IL) .NE. 0) THEN                  
                              INUM = INUM + 1                           
                              PTURN (IP) = PTURN(IP) +                  
     1                                     4 * (2 ** (3 * (INUM - 1)))  
                           ENDIF                                        
                           PTURN (IP) = PTURN (IP) + 5 * (2**(3 * INUM))
                           ISPATH (IP-1) = MOD (ISPATH (IP-1), 2**10) + 
     1                                    KT * (2**10)                  
                        ELSE                                            
                           IP = IP - 1                                  
                        ENDIF                                           
                     ELSE                                               
                        IL = MOD (ISPATH(IP), 2**10)                    
                     ENDIF                                              
                  ENDIF                                                 
                                                             GO TO 95   
  140             CONTINUE                                              
  150          CONTINUE                                                 
C                                                                       
C -----  LOOP OVER ALL 96 CARDS AND IF A PATH WAS NOT DEFINED FOR AN O-D
C -----  PAIR, CALL ERROR MESSAGE GENERATOR.                            
C                                                                       
                  DO 160 K = 1, NUM96C(ICHG)                            
                     IND = NTCHG(ICHG) + K - 1                          
                     IF (XIPATH (IND) .EQ. 0) CALL ERGEN ('CPFN96',     
     1                                    5367, ICHG, K, 0, 0, 2)       
  160             CONTINUE                                              
  190       CONTINUE                                                    
  200    CONTINUE                                                       
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CRFLW (WC)                                             
C                                                                       
C --- CODED   10-17-79 BY M. KAPTANOGLU                                 
C --- REVISED  5-28-88 BY O. SHARAF-ELDIEN TO FIX TRAVELLED DISTANCE    
C --- REVISED  3-12-92 BY J. WERK TO EDIT CAR-FOLLOWING LAW             
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK VLANE,VSTATE AND VTYPLS   
C                                                                       
C --- TITLE - CALCULATE DISTANCE TRAVELLED, SPEED AND ACCELERATION OF   
C ---         VEHICLE - MODULE 3232.2111.1                              
C                                                                       
C --- FUNCTION - THIS ROUTINE CALCULATES THE SUBJECT VEHICLE ACCELER-   
C ---            ATION, DISTANCE TRAVELLED, AND SPEED AT THE END OF THIS
C ---            TIME STEP.                                             
C                                                                       
C --- ARGUMENTS - WC     = FLAG .T. IF COLLISION UNAVOIDABLE,           
C ---                      TO CALLING ROUTINE                           
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE CALCULATES THE ACCELERATION OF THE SUBJECT VEHICLE   
C     USING THE CAR-FOLLOWING MODE IF THERE IS A LEAD VEHICLE, OTHERWISE
C     THE ACCELERATION IS DETERMINED USING THE VEHICLE SPEED. THIS      
C     ROUTINE ALSO RETURNS THE DISTANCE TRAVELLED BY THE SUBJECT VEHICLE
C     DURING THIS TIME STEP AND THE SPEED OF THE SUBJECT VEHICLE AT     
C     THE END OF THE TIME-STEP.                                         
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    TSIG   - MODULE 3232.2111                          
C                    NGSIG  - MODULE 3232.2111.4                        
C                    BLKTRJ - MODULE 3232.2111.5                        
C                    QFOLOW - MODULE 3232.4.4.1                         
C                    MFOLOW - MODULE 3232.4.4.2                         
C                    LCRFLW - MODULE 3232.4645                          
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                               NONE                                    
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ACCEL   VEHICLE SPECIFIC ARRAY - ACCELERATION                     
C     ACCODE  VEHICLE SPECIFIC ARRAY - ACCEL/DECEL (0/1) CODE           
C     DECFOL  DECELERATION RATE OF FOLLOWER VEHICLE                     
C     DECLED  DECELERATION RATE OF LEAD VEHICLE                         
C     IACC    ACCELERATION OF SUBJECT VEHICLE DURING THIS TIME-STEP     
C     IACCEL  MAX ATTAIN ACC. FROM CURRENT,DESIRED SPEEDS AND           
C             VEHICLE PERFORMANCE CAPABILITIES                          
C     IAMAX   MAX. ACCEL. (10 * FPSS) AT 0 SPEED FOR VEH. TYPE, ITYPE   
C     IDELT   MAXIMUM OF TIME REMAINING TO CHANGE LANES AND 1 SECOND    
C     IDRTYP  DRIVER TYPE CODE                                          
C     ILEAD   LEAD VEHICLE OF VEHICLE IV                                
C     IRP1    REACTION TIME OF DRIVER TYPE IDRTYP                       
C     ISLOPE  SLOPE * 1000 RELATING MAX ACCEL TO ATTAINABLE SPEED       
C     ISPD    MAX ATTAINABLE SPEED BASED ON LINK AND VEH CHARACTERISTICS
C     ISPDLV  SUBJECT VEHICLE SPEED SQUARED - LEADER SPEED SQUARED      
C     ISPEED  CURRENT SPEED OF SUBJECT VEHICLE                          
C     ITAU    CODE GREATER THAN ONE IF VEHICLE IS CURRENTLY IN A LANE   
C             CHANGE MANEUVER                                           
C     ITYPE   VEHICLE TYPE                                              
C     IV      VEHICLE ID NUMBER                                         
C     J       FRONT TO REAR SEPARATION DISTANCE AT END OF CURRENT TIME  
C             STEP ASSUMING CURRENT SPEED OF FOLLOWER VEHICLE OVER      
C             THE CURRENT TIME STEP                                     
C     LEADER  VEHICLE SPECIFIC ARRAY - NUMBER OF LEADER VEH             
C     NDRVRC  VEHICLE SPECIFIC ARRAY - DRIVER TYPE, 1-10                
C     R       REACTION TIME OF DRIVER TYPE IDRTYP                       
C     RACC    ACCELERATION COMPUTED BY CAR-FOLLOWING RELATION           
C     RDCFOL  DECELERATION RATE OF FOLLOWER VEHICLE                     
C     RDCLED  DECELERATION RATE OF LEAD VEHICLE                         
C     RDELTA  CODE (0, 1) IF FOLLOWER VEHICLE IS                        
C             (ACCELERATING, DECELERATING)                              
C     RDELV   LEAD VEHICLE ACCELERATION                                 
C     RDEN    DENOMINATOR OF CAR-FOLLOWING ACCEL. RELATION              
C     RF1     FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RF1T1   FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RF2     FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RF2T2   FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RTAU    CODE GREATER THAN ONE IF VEHICLE IS CURRENTLY IN A LANE   
C             CHANGE MANEUVER                                           
C     RTSQ    FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RT1     FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     RT2     FACTOR USED IN COMPUTING VEHICLE ACCELERATION             
C     TMREAC  REACTION TIME BY DRIVER TYPE                              
C     VHLANE  VEHICLE SPECIFIC ARRAY - TARGET LANE, GOAL LANES, FLAG IF 
C             DRIVER IS COOP. TO A LANE CHANGER, REMAIN TIME TO CHNGE   
C     VTYPAH  VEHICLE TYPE ARRAY - MAX. ACCEL. AND HDWY FACTOR          
C     VTYPSP  VEHICLE TYPE ARRAY - MAXIMUM SPEED AT 0 ACCELERATION      
C     W       FLAG IS .T. IF NO LEADER OR IF NO INTERACTION WITH LEADER 
C     XDATA   ARRAY CONTAINING ALL DATA REQUIRED BY THIS ROUTINE. ALSO  
C             CONTAINS ALL DATA NEEDED BY CALLING ROUTINE               
C             (1)  FRONT-TO-REAR SEPARATION DISTANCE                    
C             (2)  LEAD VEHICLE SPEED AT END OF TIME-STEP               
C             (3)  LEAD VEHICLE LENGTH                                  
C             (4)  SUBJECT VEHICLE SPEED AT BEGINNING OF TIME-STEP      
C             (5)  SUBJECT VEHICLE TYPE                                 
C             (6)  SUBJECT VEHICLE FREE-FLOW SPEED                      
C             (7)  SUBJECT VEHICLE ACCELERATION DURING CURRENT TIME-STEP
C             (8)  SUBJECT VEHICLE SPEED AT END OF TIME-STEP            
C             (9)  DISTANCE TRAVELLED BY SUBJECT VEHICLE DURING         
C                  TIME-STEP                                            
C             (10) SUBJECT VEHICLE NUMBER                               
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IV = XDATA(10)                                                    
      ILEAD = LEADER(IV)                                                
      XDATA(7) = - 15                                                   
      XDATA(8) = 0                                                      
      XDATA(9) = MAX0 (MIN0 (XDATA(4) / 2, XDATA(1)), 0)                
C                                                                       
C -----  TRA FOR PANIC STOP BEHIND LEAD VEHICLE.  ELSE, CHECK WHETHER   
C -----  SUBJECT VEHCILE IS INFLUENCED BY LEADER.                       
C                                                                       
      WC = XDATA(1) .LT. MAX0 (XDATA(4) - DECFOL / 2, 0) .AND.          
     1     XDATA(3) .GT. 0                                              
      IF (WC)                                                GO TO 20   
      ISPEED = XDATA(4)                                                 
      J = XDATA(1) - ISPEED - 4                                         
      W = XDATA(3) .LE. 0 .OR. J .GE. ISPEED**2 / 8 .OR. (J .GT.        
     1          2 * XDATA(2) .AND. ISPEED .LE. XDATA(2))                
      IF (W) IACC = MAX0 (XDATA(6) - ISPEED, -4)                        
C                                                                       
C -----  TRA IF NO LEAD VEHICLE (I.E., LEAD VEHICLE LENGTH = 0),        
C -----  OR IF SEPARATION DISTANCE / SPEED DIFFERENTIAL IMPLIES NO      
C -----  INTERACTION. ELSE, CALCULATE VEHICLE ACCELERATION ACCORDING TO 
C -----  CAR-FOLLOWING MODEL.                                           
C                                                                       
      IF (W)                                                 GO TO 10   
      RDELTA = 0.0                                                      
      RT1 = 0.0                                                         
      RT2 = 0.0                                                         
C                                                                       
C -----  GET DRIVER REACTION TIME, R.                                   
C                                                                       
      IDRTYP = NDRVRC(IV)                                               
      IRP1 = (TMREAC(IDRTYP) + 5) / 10                                  
      R = REAL(IRP1) / 100.                                             
      IRP1 = IRP1 + 100                                                 
      IDELT = MAX0 (MOD (VHLANE(IV) / 2**12, 2**3), 1)                  
      ITAU = IDELT - 1                                                  
C                                                                       
C -----  CHECK FOR CAR-FOLLOWING MANEUVER AND ADJUCT TIME-FRAME         
C -----  ACCORDINGLY.                                                   
C                                                                       
      IF (ITAU .GT. 0) THEN                                             
         RTAU = REAL(ITAU)                                              
         RDELV = 0.                                                     
         IF (ILEAD .GT. 0) RDELV = ACCEL(ILEAD)                         
         IF (ACCODE(ILEAD) .GT. 0) RDELV = - RDELV                      
         RT1 = 2. * RDCFOL * RTAU * (1 + RDELV/RDCLED) * (REAL(XDATA(2))
     1         + (RDELV * RTAU / 2.) - REAL(XDATA(4)))                  
         RT2 = RTAU * (RDCFOL * (2.* R + 2.+ RTAU) + 2.* REAL(XDATA(4)))
      ENDIF                                                             
C                                                                       
C -----  EXECUTE CAR-FOLLOWING EQUATION.                                
C                                                                       
      ISPDLV = ((XDATA(2)**2) * DECFOL + DECLED/2) / DECLED - ISPEED**2 
      RF1 = 2 * DECFOL * (XDATA(1) - (IRP1 * ISPEED + 50)/100) + ISPDLV 
      IF ((RF1 + RT1) .LT. 0.) RDELTA = 1.                              
      RF2 = RDCFOL * (1. + R * (2. + RDELTA * R)) + 2.0 * REAL (ISPEED) 
      RF1T1 = RF1 + RT1                                                 
      RF2T2 = RF2 + RT2                                                 
      RTSQ = IDELT ** 2                                                 
      RDEN = RF2T2 ** 2 + RF1T1 * RTSQ                                  
      RACC = 0.                                                         
      IF (RDEN .NE. 0.) RACC = AMAX1(RF1T1 * RF2T2 / RDEN, -RDCFOL)     
      IF (RACC .GE. -RDCFOL) THEN                                       
C                                                                       
C -----  ITERATE TO IMPROVE ACCURACY.                                   
C                                                                       
         RDEN = RF2T2 + RACC * RTSQ                                     
         IF (RDEN .NE. 0.) RACC = RF1T1/ RDEN                           
      ENDIF                                                             
      IACC = RACC + SIGN (0.5, RACC)                                    
C                                                                       
C -----  PROTECT AGAINST NEW SPEED EXCEEDING FREE-FLOW VALUE AND AGAINST
C -----  DECELERATION EXCEEDING MAX. VALUE OR CURRENT SPEED.            
C                                                                       
      IACC = MAX0 (MIN0 (IACC, XDATA(6) - ISPEED), - DECFOL, - ISPEED)  
   10 CONTINUE                                                          
C                                                                       
C -----  IF ACCELERATION EXCEEDS 2 FPSS, GET MAXIMUM ACCELERATION       
C -----  POSSIBLE BASED UPON CURRENT SPEED, DESIRED SPEED ON THIS LINK  
C -----  AND VEHICLE PERFORMANCE CHARACTERISTICS.  SELECT ACCELERATION  
C -----  AS MINIMUM OF CAR-FOLLOWING VALUE AND MAXIMUM POSSIBLE.        
C                                                                       
      IF (IACC .GT. 2) THEN                                             
         ITYPE = XDATA(5)                                               
         IAMAX = MOD (VTYPAH(ITYPE), 2**7)                              
         ISPD = MAX0 (XDATA(6), VTYPSP(ITYPE), 60)                      
         ISLOPE = IAMAX * 100 / ISPD                                    
         IACCEL = MAX0 ((IAMAX * 100 - ISLOPE * ISPEED + 500) / 1000, 1)
         IACC = MIN0 (IACC, IACCEL)                                     
      ENDIF                                                             
C                                                                       
C -----  GET SPEED AT END OF TIME STEP AND DISTANCE TRAVELLED BY SUBJECT
C -----  VEHICLE.                                                       
C                                                                       
      XDATA(9) = MAX0 (ISPEED + IACC / 2, 0)                            
      IF (XDATA(3) .GT. 0 .AND. XDATA(9) .GT. XDATA(1)) THEN            
         XDATA(9) = MAX0 (XDATA(1), 0)                                  
         IACC = MIN0 (MAX0 ((XDATA(9) - ISPEED) * 2, -DECFOL), 4)       
      ENDIF                                                             
      XDATA(8) = MAX0 (MIN0 (XDATA(9) + IACC / 2, 127), 0)              
      XDATA(7) = IACC                                                   
C                                                                       
C -----  SUBJECT VEHICLE MUST MOVE IF LEADER IS MOVING                  
C                                                                       
   20 CONTINUE                                                          
      IF (XDATA(2) .GT. 0) THEN                                         
         XDATA(8) = MAX0 (XDATA(8), 1)                                  
C                                                                       
C  THIS LINE WAS ADDED BY KLD IN VERSION 5.0 BUT WAS COMMENTED OUT BY   
C  SSW ON 2/16/94 BECAUSE IT CAUSES CHAIN BREAKS.  THE CAR FOLLOWING    
C  LOGIC IS GOING TO BE INVESTIGATED TO SEE IF THE SPEED REALLY NEEDS   
C  TO BE SET TO A MIN OF 1.                                             
C                                                                       
C        XDATA(9) = MAX0 (XDATA(9), 1)                                  
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CROSLK                                                 
C                                                                       
C                                                                       
C --- CODED   10-15-79 BY B. ANDREWS                                    
C --- REVISED  4-09-90 BY A. KANAAN TO CHECK EFFECTIVE LINK LENGTH      
C --- REVISED 11-01-91 BY A. KANAAN TO ASSURE POCKETS GREATER > EFF. LEN
C --- REVISED  9-11-92 BY S.E.SMITH TO CORRECT CALCULATION OF INTER. WID
C --- REVISED 11-14-94 BY A. PHLEGAR TO CONSIDER UPNODES LT 7000 INSTEAD
C                                    OF 8000                            
C                                                                       
C --- TITLE - PRIME CROSS STREET APPROACH LINK ARRAYS-                  
C ---         MODULE 2261.5.2.9                                         
C                                                                       
C --- FUNCTION - THIS MODULE DETERMINES THE NEAR AND FAR CROSS          
C ---            APPROACH LINKS TO THE DOWNSTREAM NODE OF EACH          
C ---            LINK IN THE SUBNETWORK                                 
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE LOOPS OVER SUBNETWORK LINKS.  FOR EACH LINK,          
C     THE CROSS APPROACH LINKS AT THE DOWNSTREAM NODE ARE               
C     DETERMINED FROM THE APPROACH LINKS TO THE DOWNSTREAM NODE         
C     AND THE RECEIVING LINKS OF THE SUBJECT LINK.                      
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    ACTSFN - MODULE 2261.5.2                           
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ARIGHT  LINK SPECIFIC ARRAY - RIGHT TURN RECEIVING LINK           
C     CROSFR  LINK SPECIFIC ARRAY - FAR CROSS LINK APPRCH TO DWNST NODE 
C     CROSNR  LINK SPECIFIC ARRAY - NEAR CROSS LNK APPRCH TO DWNST NODE 
C     DIAGNL  LINK SPECIFIC ARRAY - DIAGONAL RECEIVING LINK             
C     DNLNK   DOWNSTREAM NODE OF LINK IT                                
C     DWNOD   LINK SPECIFIC ARRAY - DOWNSTREAM NODE NUMBER              
C     IA      LOCATION IN SIGI ARRAY OF APPROACH II TO NODE IN          
C     ICL     APPROACH LINK II TO NODE IN                               
C     ID      LINK RECEIVING DIAGONAL TRAFFIC FROM LINK, IL             
C     IDIAG   NO. OF LINK WHICH ACTS AS A DIAGONAL CROSS LINK TO LINK IL
C     II      APPROACH NUMBER                                           
C     IKN     OFFSET TO SIGI ARRAY FOR NODE IN                          
C     IL      SUBJECT LINK NUMBER                                       
C     ILANE   LANE WIDTH OF INTERSECTION AT UPSTRM END OF LINK THRU(IL) 
C     IN      DOWNSTREAM NODE OF LINK IL                                
C     IT      THRU RECEIVING LINK OF LINK IL                            
C     JL      NEAR CROSS LINK APPROACH TO LINK IL                       
C     KL      FAR CROSS LINK APPROACH TO LINK IL                        
C     LANEGD  LINK SPECIFIC ARRAY - NUMBER OF FULL AND POCKET LANES     
C     LEFT    LINK SPECIFIC ARRAY - LEFT TURN RECEIVING LINK            
C     LEFTL   LENGTH OF LEFT TURN POCKET                                
C     LEFTPK  NUMBER OF ADDITIONAL LT POCKETS FROM OPPOSITE APPROACH    
C     LENG    LENGTH OF LINK IT                                         
C     LGLPK   LINK SPECIFIC ARRAY - LENGTH OF LEFT TURN POCKET (FEET)   
C     LGRPK   LINK SPECIFIC ARRAY - LENGTH OF RIGHT TURN POCKET (FEET)  
C     NMAP    ARRAY MAPPING USER SPECIFIED NODE NOS. TO INTERNAL NOS.   
C     IRGTL   LENGTH OF RIGHT TURN POCKET                               
C     SIGI    NODE AND APPROACH SPECIFIC ARRAY - APPROACH LINK NUMBER   
C     STREET  EFFECTIVE STREET LENGTH EXCLUDING INTERSECTION WIDTH      
C     THRU    LINK SPECIFIC ARRAY - THRU RECEIVING LINK NUMBER          
C     TTLNK   TOTAL NUMBER OF LINKS IN SUBNETWORK                       
C     UPLNK   UPSTREAM NODE OF LINK IT                                  
C     UPNOD   LINK SPECIFIC ARRAY - UPSTREAM NODE NUMBER                
C     W       FLAG (T,F) IF (NO,ANY) NEAR SIDE CROSS LINK FOUND         
C     WELGBL  FLAG (T, F) IF ICL (IS, NOT) ELIGIBLE AS A CROSS-LINK     
C     XLNGTH  LINK SPECIFIC ARRAY - LINK LENGTH AND CROSS STREET WIDTH  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  LOOP OVER LINKS TO PRIME CROSFR, CROSNR AND LENGTH ARRAYS      
C                                                                       
      IL = 0                                                            
   10 CONTINUE                                                          
      IL = IL + 1                                                       
C                                                                       
C -----  GET DOWNSTREAM NODE OF SUBJECT LINK.  TRA IF AN EXITING        
C -----  INTERFACE LINK, ELSE CALCULATE ENTRY POINT TO SIGI ARRAY       
C                                                                       
      IN = DWNOD(IL)                                                    
      IF (IN .GE. 7000)                                      GO TO 70   
      IKN = 5*IN - 5                                                    
      II = 0                                                            
      JL = 0                                                            
      KL = 0                                                            
      IT = THRU(IL)                                                     
      ID = DIAGNL(IL)                                                   
      ID = IABS (ID)                                                    
      IDIAG = 0                                                         
C                                                                       
C -----  TRA IF SUBJECT LINK HAS NO THRU RECEIVER ELSE,                 
C -----  DOUNTIL CROSS LINKS ARE IDENTIFIED OR SEARCH COMPLETE          
C                                                                       
      IF (IT .EQ. 0)                                         GO TO 30   
   20 CONTINUE                                                          
      II = II + 1                                                       
      IA = IKN + II                                                     
      ICL = SIGI(IA)                                                    
C                                                                       
C -----  ICL IS A CROSS LINK IF A TURN MOVEMENT FEEDS LINK THRU(IL)     
C -----  OR IF ITS THRU MOVEMENT, THRU(ICL), SERVICES A TURN MOVEMENT   
C -----  OF LINK IL                                                     
C                                                                       
      IF (ICL .GT. 0  .AND.  ICL .NE. IL) THEN                          
          IF (LEFT(ICL) .EQ. IT) JL = ICL                               
         IF (JL .EQ. 0 .AND. THRU(ICL) .NE. 0 .AND.                     
     1       THRU(ICL) .EQ. ARIGHT(IL)) JL = ICL                        
         IF (ARIGHT(ICL) .EQ. IT) KL = ICL                              
         IF (KL .EQ. 0 .AND. THRU(ICL) .NE. 0 .AND.                     
     1       THRU(ICL) .EQ. LEFT(IL)) KL = ICL                          
          IF (DIAGNL(ICL) .EQ. IT  .OR.  THRU(ICL) .EQ. IT) IDIAG = ICL 
          IF (DIAGNL(ICL) .EQ. -IT) IDIAG = ICL                         
      ENDIF                                                             
      IF ((JL.EQ.0 .OR. KL.EQ.0) .AND. ICL.GT.0 .AND. II.LT.5)  GO TO 20
                                                             GO TO 50   
C                                                                       
   30 CONTINUE                                                          
   40 CONTINUE                                                          
      II = II + 1                                                       
      IA = IKN + II                                                     
      ICL = SIGI(IA)                                                    
C                                                                       
C -----  ICL IS A CROSS LINK IF ITS THRU OR DIAGONAL MOVEMENT FEEDS     
C -----  ARIGHT(IL), LEFT(IL) OR DIAGNL(IL)                             
C                                                                       
      WELGBL = ICL .GT. 0 .AND. ICL .NE. IL .AND. THRU(ICL) .GT. 0      
      IF (WELGBL  .AND.  THRU(ICL) .EQ. ARIGHT(IL)) JL = ICL            
      IF (WELGBL  .AND.  THRU(ICL) .EQ. LEFT(IL)) KL = ICL              
      WELGBL = ICL .GT. 0 .AND. ICL .NE. IL .AND. ID .NE. 0             
      IF (WELGBL  .AND.  (THRU(ICL) .EQ. ID  .OR.  DIAGNL(ICL) .EQ. ID  
     1    .OR.  DIAGNL(ICL) .EQ. -ID)) IDIAG = ICL                      
      IF ((JL .EQ. 0  .OR.  KL .EQ. 0)  .AND.  ICL .GT. 0  .AND.        
     1     II .LT. 5)                                        GO TO 40   
   50 CONTINUE                                                          
C                                                                       
C -----  WHEN LESS THAN 2 CROSS LINKS HAVE BEEN IDENTIFIED AND A        
C -----  DIAGONAL LINK FEEDS THE INTERSECTION, THE DIAGONAL LINK        
C -----  IS MADE A CROSS LINK                                           
C                                                                       
      W = JL .EQ. 0                                                     
      IF (IDIAG .GT. 0  .AND.  W) JL = IDIAG                            
      IF (IDIAG .GT. 0  .AND.  .NOT. W  .AND.  KL .EQ. 0) KL = IDIAG    
C                                                                       
      CROSNR(IL) = JL                                                   
      CROSFR(IL) = KL                                                   
C                                                                       
C -----  COMPUTE INTERSECTION WIDTH (NO. OF LANES AND POCKETS ON        
C -----  FAR-SIDE, LEFT, APPROACH + LANES AND ANY ADDITIONAL POCKETS    
C -----  (SINCE POCKETS WILL ALIGN WITH ONE ANOTHER) ON NEAR-SIDE,      
C -----  RIGHT, APPROACH) AND STORE IN BITS 13 THRU 15 OF LENGTH ARRAY  
C -----  ISSUE AN ERROR MESSAGE IF ACTUAL STREET LENGTH IS LESS THAN    
C -----  AT LEAST 20 FT.                                                
C                                                                       
      IN = UPNOD(IL)                                                    
      IF (IN .LT. 7000) THEN                                            
          IKN = 5*IN - 5                                                
          II = 0                                                        
          JL = 0                                                        
          KL = 0                                                        
          ITH = 0                                                       
          IDIAG = 0                                                     
          ILANE = 0                                                     
   60 CONTINUE                                                          
      II = II + 1                                                       
      IA = IKN + II                                                     
      ICL = SIGI(IA)                                                    
C                                                                       
      IF (ICL .GT. 0) THEN                                              
          IF (LEFT(ICL) .EQ. IL) JL = ICL                               
          IF (JL .EQ. 0 .AND. THRU(ICL) .NE. 0 .AND.                    
     1       THRU(ICL) .EQ. ARIGHT(IL)) JL = ICL                        
          IF (ARIGHT(ICL) .EQ. IL) KL = ICL                             
          IF (KL .EQ. 0 .AND. THRU(ICL) .NE. 0 .AND.                    
     1       THRU(ICL) .EQ. LEFT(IL)) KL = ICL                          
          IF (DIAGNL(ICL) .EQ. IL) IDIAG = ICL                          
          IF (DIAGNL(ICL) .EQ. -IL) IDIAG = ICL                         
          IF (THRU(ICL) .EQ. IL) ITH = ICL                              
      ENDIF                                                             
      IF ((JL.EQ.0 .OR. KL.EQ.0) .AND. ICL.GT.0 .AND. II.LT.5)  GO TO 60
C                                                                       
      IF (JL .EQ. 0 .AND. ITH .GT. 0) JL = ARIGHT(ITH)                  
      IF (KL .EQ. 0 .AND. ITH .GT. 0) KL = LEFT(ITH)                    
C                                                                       
          IF (KL .GT. 0) THEN                                           
              ILANE = ILANE + MOD(LANEGD(KL)/2**3, 2**3)                
     1                      + MOD(LANEGD(KL)/2**6, 2**2)                
     2                      + MOD(LANEGD(KL)/2**8, 2**2)                
          ENDIF                                                         
          IF (JL .GT. 0) THEN                                           
              ILANE = ILANE + MOD(LANEGD(JL)/2**3, 2**3)                
     1                      + MOD(LANEGD(JL)/2**6, 2**2)                
              LEFTPK = 0                                                
              IF (KL .GT. 0)  LEFTPK = MIN0 (MOD(LANEGD(KL)/2**8,2**2), 
     1                                       MOD(LANEGD(JL)/2**8,2**2)) 
              ILANE = ILANE + MOD(LANEGD(JL)/2**8,2**2) - LEFTPK        
          ENDIF                                                         
C                                                                       
C --- CHECK THAT EFFECTIVE LINK LENGTH (LENGTH - INTERSECTION) SHOULD   
C --- BE AT LEAST 20 FT LONG.                                           
C --- CHECK THAT POCKET LENGTH IS AT LEAST EQUAL TO THE EFFECTIVE       
C --- LINK LENGTH                                                       
C                                                                       
          IF (IL .EQ. LNKID) WRITE (LU6,1000) 'A', IL, XLNGTH(IL), ILANE
C                                                                       
          XLNGTH (IL) = MOD (XLNGTH(IL), 2**12) + MIN0(ILANE,14) * 2**12
C                                                                       
          STREET = MOD (XLNGTH(IL), 2**12) -  XLNGTH(IL) / 2**12 * 10   
          LEFTL = MOD (LGLPK(IL) , 2**10)                               
          IRGTL = MOD (LGRPK(IL) , 2**10)                               
          UPLNK = UPNOD(IL)                                             
          IF (UPLNK .LT. 7000) UPLNK = NMAP(UPLNK)                      
          DNLNK = DWNOD(IL)                                             
          IF (DNLNK .LT. 7000) DNLNK = NMAP(DNLNK)                      
          IF (STREET .LT. 20) THEN                                      
              LENG  = MOD (XLNGTH(IL), 2**12)                           
              CALL ERGEN('CROSLK', 2099, UPLNK, DNLNK, LENG, STREET, 4) 
              IF (YTRACE) WRITE (LU6,1000) 'B', IL, XLNGTH(IL), ILANE,  
     1                                      THRU(IL), KL, LEFTPK        
          ELSE                                                          
              IF (LEFTL .GT. 0  .AND.  LEFTL .GT. STREET)               
     1            CALL ERGEN ('CROSLK', 2062, UPLNK, DNLNK,             
     2                                        LEFTL, STREET, 4)         
              IF (IRGTL .GT. 0  .AND.  IRGTL .GT. STREET)               
     1            CALL ERGEN ('CROSLK', 2062, UPLNK, DNLNK,             
     2                                        IRGTL, STREET, 4)         
          ENDIF                                                         
      ENDIF                                                             
   70 CONTINUE                                                          
      IF (IL .LT. TTLNK)                                     GO TO 10   
      RETURN                                                            
 1000 FORMAT(' CROSLK: IL, XLNGTH(IL), ILANE, THRU ', A1, 6I8)          
      END                                                               
      SUBROUTINE CS140                                                  
C                                                                       
C                                                                       
C --- CODED    7-12-79 BY M. MASSUCCI                                   
C --- REVISED  8-17-87 BY A. RATHI FOR METRIC UNITS I/O                 
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 140 CARD -               
C ---         MODULE 2261.7.1                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS AND STORES THE DATA FROM            
C ---            CARD TYPE 140                                          
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS ROUTINE CHECKS THE DATA CHANGES FOR LEFT TURN JUMPERS,       
C     LEFT AND RIGHT TURNING SPEEDS AND LANE SWITCHING LAG SPECIFIED    
C     ON CARD TYPE 140, CALLING A ROUTINE TO GENERATE AN ERROR          
C     MESSAGE IF NECESSARY. THE INFORMATION IS STORED IN THE DATA BASE. 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ------------------   GLOSSARY OF VARIABLE NAMES  -------------------- 
C                      --------------------------                       
C                                                                       
C     ARTESP  RIGHT TURNING SPEED                                       
C     IDX     INDEX TO XBUF ARRAY                                       
C     INDEX   INDEX TO LTJGAP ARRAY                                     
C     LEFTSP  LEFT TURNING SPEED                                        
C     LSALAG  ACCEPTABLE LANE SWITCHING LAG                             
C     LTJGAP  ARRAY CONTAINING PROB. OF LFT TURN VEH JUMPING GRN PHASE  
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     UNITIN  CODE (0,1) IF INPUT IS IN (ENGLISH,METRIC) UNITS          
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C     ZCNVRT  ARRAY OF CONVERSION FACTORS FROM ENGLISH TO METRIC UNIS   
C             AND VICE-VERSA                                            
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  LOOP OVER LEFT TURN JUMPER CHANGES. CHECK THAT INDEX IS        
C -----  VALID %1,7! AND THAT CALIBRATION VALUE IS VALID (0,100),       
C -----  STORE NEW DATA.                                                
C                                                                       
         DO 20 IDX = 1, 13, 2                                           
            IF (XBUF(IDX) .EQ. 0)                            GO TO 10   
            IF (XBUF(IDX) .LT. 1 .OR. XBUF(IDX) .GT. 7)                 
     1          CALL ERGEN ('CS140 ', 4025, IDX, XBUF(IDX), 0, 0,2)     
            IF (XBUF(IDX+1) .LT. 0 .OR. XBUF(IDX+1) .GT. 100)           
     1          CALL ERGEN ('CS140 ', 4026, XBUF(IDX),                  
     2                      XBUF(IDX+1), 0, 0, 2)                       
            IF (XBUF(IDX) .LT. 1 .OR. XBUF(IDX) .GT. 7)      GO TO 5    
            INDEX = XBUF(IDX)                                           
            LTJGAP(INDEX) = XBUF(IDX+1)                                 
    5       CONTINUE                                                    
   10       CONTINUE                                                    
   20    CONTINUE                                                       
      IF (YPRINT .AND. XBUF(1) .NE. 0)                                  
     1     WRITE (LU6, 1000) (LTJGAP(INDEX), INDEX = 1, 7), XBUF(20)    
C                                                                       
C -----  CHECK THAT LEFT TURN SPEED IS VALID (0,44) AND STORE.          
C -----  SAVE INPUT VALUE OF LEFT TURN SPEED IN XBUF(18) FOR OUTPUT     
C -----  PURPOSES.  IF INPUT IS IN METRIC UNITS, CONVERT TO ENGLISH     
C -----  UNITS BEFORE TESTING BOUNDS.                                   
C                                                                       
      IF (XBUF(15) .NE. 0) XBUF(18) = XBUF(15)                          
      IF (UNITIN .EQ. 1) XBUF(15) = ZCNVRT(4) * FLOAT (XBUF(15)) + 0.5  
      IF (XBUF(15) .LT. 0 .OR. XBUF(15) .GT. 44)                        
     1    CALL ERGEN ('CS140 ', 608, XBUF(18), 0, 0, 0, 1)              
      IF (UNITIN .EQ. 0) XBUF(18) = ZCNVRT(1) * FLOAT(XBUF(18)) + 0.5   
      IF (XBUF(15) .NE. 0) LEFTSP = XBUF(15)                            
      IF (YPRINT .AND. XBUF(15) .NE. 0) WRITE (LU6, 1001) XBUF(15),     
     1                                        XBUF(18), XBUF(20)        
C                                                                       
C -----  CHECK THAT RIGHT TURN SPEED IS VALID (0,26) AND STORE.         
C -----  SAVE INPUT VALUE OF RIGHT TURN SPEED IN XBUF(18) FOR OUTPUT    
C -----  PURPOSES.  IF INPUT IS IN METRIC UNITS, CONVERT TO ENGLISH     
C -----  UNITS BEFORE TESTING BOUNDS.                                   
C                                                                       
      IF (XBUF(16) .NE. 0) XBUF(18) = XBUF(16)                          
      IF (UNITIN .EQ. 1) XBUF(16) = ZCNVRT(4) * FLOAT (XBUF(16)) + 0.5  
      IF (XBUF(16) .LT. 0 .OR. XBUF(16) .GT. 26)                        
     1    CALL ERGEN ('CS140 ', 609, XBUF(18), 0, 0, 0, 1)              
      IF (UNITIN .EQ. 0) XBUF(18) = ZCNVRT(1) * FLOAT(XBUF(18)) + 0.5   
      IF (XBUF(16) .NE. 0) ARTESP = XBUF(16)                            
      IF (YPRINT .AND. XBUF(16) .NE. 0) WRITE (LU6, 1002) XBUF(16),     
     1                                        XBUF(18), XBUF(20)        
C                                                                       
C -----  CHECK THAT LANE SWITCHING LAG IS VALID (0,90) AND STORE        
C                                                                       
      IF (XBUF(17) .LT. 0 .OR. XBUF(17) .GT. 90)                        
     1    CALL ERGEN ('CS140 ', 607, XBUF(17), 0, 0, 0, 1)              
      IF (XBUF(17) .NE. 0) LSALAG = XBUF(17)                            
      IF (YPRINT .AND. XBUF(17) .NE. 0) WRITE (LU6, 1003) LSALAG,       
     1                                                    XBUF(20)      
C                                                                       
 1000 FORMAT (1H0, 17X, 6HLTJGAP, 5X, 7I8, 31X, I3)                     
 1001 FORMAT (1H0, 17X, 6HLEFTSP, 5X,  I8, ' FPS (', I2, ' MPS)',       
     1        66X, I3)                                                  
 1002 FORMAT (1H0, 17X, 6HARTESP, 5X,  I8, ' FPS (', I2, ' MPS)',       
     1        66X, I3)                                                  
 1003 FORMAT (1H0, 17X, 6HLSALAG, 5X,  I8, 79X, I3)                     
      RETURN                                                            
      END                                                               
      SUBROUTINE CS141                                                  
C                                                                       
C                                                                       
C --- CODED    7-13-79 BY M. MASSUCCI                                   
C --- REVISED  8-17-87 BY A. RATHI FOR METRIC UNITS I/O                 
C --- REVISED  2-13-88 BY O. SHARAF-ELDIEN TO FIX WRITE STATMENT        
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 141 CARD -               
C ---         MODULE 2261.7.2                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE CONTENTS OF A TYPE 141          
C ---            CARD AND STORES IT IN THE DATA BASE                    
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 141 CARD IS IN THE BUFFER.      
C     THIS ROUTINE CHECKS EACH ELEMENT ON THE CARD, CALLING A           
C     ROUTINE TO GENERATE AN ERROR MESSAGE WHEN NECESSARY. INFORMATION  
C     INPUT ON THIS CARD IS STORED IN THE SPLPCT AND VEHLNG ARRAYS.     
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     IDX     INDEX FOR ARRAYS                                          
C     LTLAGP  LEFT TURN LAGGER TURN PROBABILITY                         
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     SPLPCT  ARRAY CONTAINING PROB. OF A VEH JOINING SPILLBACK         
C     UNITIN  CODE (0,1) IF INPUT IS IN (ENGLISH,METRIC) UNITS          
C     VEHLNG  ARRAY OF MEAN EFFECTIVE VEHICLE LENGTHS                   
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C     ZCNVRT  ARRAY OF CONVERSION FACTORS FROM ENGLISH TO METRIC UNITS  
C             AND VICE-VERSA                                            
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL CHANGES TO SPLPCT ARRAY ARE CHECKED AND STORED.    
C                                                                       
         DO 10 IDX = 1, 4                                               
            IF (XBUF(IDX) .LT. 0 .OR. XBUF(IDX) .GT. 100)               
     1          CALL ERGEN ('CS141 ', 4027, IDX, XBUF(IDX), 0, 0,2)     
            SPLPCT(IDX) = XBUF(IDX)                                     
   10    CONTINUE                                                       
C                                                                       
C -----  DOUNTIL ALL CHANGES TO LTLAGP ARRAY ARE CHECKED AND STORED     
C                                                                       
         DO 15 IDX = 5, 7                                               
            IF (XBUF(IDX) .LT. 0  .OR.  XBUF(IDX) .GT. 100)             
     1          CALL ERGEN ('CS141 ', 4038, IDX, XBUF(IDX),             
     2                       0, 0, 2)                                   
            LTLAGP(IDX-4) = XBUF(IDX)                                   
   15    CONTINUE                                                       
C                                                                       
C -----  DOUNTIL ALL CHANGES TO VEHLNG ARRAY ARE CHECKED AND STORED.    
C -----  SAVE INPUT VALUES OF VEHICLE LENGTHS IN XBUF(12) THROUGH       
C -----  XBUF(15) FOR OUTPUT PURPOSES.  IF INPUT IS IN METRIC UNITS,    
C -----  CONVERT TO ENGLISH UNITS BEFORE TESTING QUANTITATIVE BOUNDS.   
C                                                                       
         DO 20 IDX = 8, 11                                              
            XBUF(IDX+4) = XBUF(IDX)                                     
            IF (UNITIN .EQ. 1) XBUF(IDX) = ZCNVRT(4) *                  
     1                                     FLOAT (XBUF(IDX)) + 0.5      
            IF (XBUF(IDX) .LT. 20 .OR. XBUF(IDX) .GT. 75)               
     1          CALL ERGEN ('CS141 ', 4029, IDX, XBUF(IDX+4), 0, 0, 2)  
            IF (UNITIN .EQ. 0) XBUF(IDX+4) = ZCNVRT(1) *                
     1                                       FLOAT (XBUF(IDX+4)) + 0.5  
            VEHLNG(IDX-7) = XBUF(IDX)                                   
   20    CONTINUE                                                       
      IF (YPRINT) WRITE (LU6, 1000) (SPLPCT(IDX), IDX = 1, 4), XBUF(20),
     1                  (LTLAGP(IDX), IDX = 1, 3), XBUF(20), (XBUF(IDX),
     2                  XBUF(IDX+4), IDX = 8, 11), XBUF(20)             
C                                                                       
 1000 FORMAT (1H0, 17X, 6HSPLPCT, 5X, 4I8, 55X, I3, /                   
     1        1H0, 17X, 6HLTLAGP, 5X, 3I8, 63X, I3, /                   
     2        1H0, 17X, 6HVEHLNG, 11X, 4(I2, ' FT. (', I2, ' M   )'),   
     3                            17X, I3)                              
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CS142                                                  
C                                                                       
C                                                                       
C --- CODED    7-13-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 142 CARD -               
C ---         MODULE 2261.7.3                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE CONTENTS OF A CARD TYPE 142     
C ---            AND STORES IT IN THE DATA BASE.                        
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 142 CARD IS IN THE BUFFER.      
C     THIS ROUTINE CHECKS EACH DATA ITEM ON THE CARD, CALLING A         
C     ROUTINE TO GENERATE AN ERROR MESSAGE IF NECESSARY. DATA ITEMS     
C     WILL BE STORED IN THE NSGAP ARRAY.                                
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     IDX     INDEX FOR ARRAYS                                          
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     NSGAP   ARRAY CONTAINING ACCEPTABLE GAP FOR NEAR SIDE TRAFFIC     
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL ENTRIES ARE CHECKED AND STORED.                    
C                                                                       
         DO 10 IDX = 1, 10                                              
            IF (XBUF(IDX) .LT. 15 .OR. XBUF(IDX) .GT. 75)               
     1          CALL ERGEN ('CS142 ', 4030, IDX, XBUF(IDX), 0, 0,2)     
            NSGAP(IDX) = XBUF(IDX)                                      
   10    CONTINUE                                                       
      IF (YPRINT) WRITE (LU6, 1000) (NSGAP(IDX), IDX = 1, 10), XBUF(20) 
C                                                                       
 1000 FORMAT (1H0, 17X, 5HNSGAP, 6X, 10I8, 7X, I3)                      
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CS143                                                  
C                                                                       
C                                                                       
C --- CODED    7-16-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 143 CARD -               
C ---         MODULE 2261.7.4                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE CONTENTS OF A 143 CARD AND      
C ---            STORES THE CONTENTS IN THE DATA BASE                   
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 143 CARD IS IN THE BUFFER.      
C     THIS ROUTINE CHECKS THE DATA CHANGES GIVEN ON THE CARD AND        
C     CALLS A ROUTINE TO OUTPUT AN ERROR MESSAGE IF THE DATA IS OUT     
C     OF BOUNDS. DATA WILL BE STORED IN THE FSGAP ARRAY                 
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     FSGAP   ARRAY CONTAINING ADD. FACTOR FOR FAR-SIDE CROSS TRAFFIC GP
C     IDX     INDEX TO ARRAYS                                           
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL DATA CHANGES TO FSGAP ARRAY ARE CHECKED            
C -----  AND STORED                                                     
C                                                                       
         DO 10 IDX = 1, 10                                              
            IF (XBUF(IDX) .LT. 10 .OR. XBUF(IDX) .GT. 75)               
     1          CALL ERGEN ('CS143 ', 4031, IDX, XBUF(IDX), 0, 0,2)     
            FSGAP(IDX) = XBUF(IDX)                                      
   10    CONTINUE                                                       
      IF (YPRINT) WRITE (LU6, 1000) (FSGAP(IDX), IDX = 1, 10), XBUF(20) 
C                                                                       
 1000 FORMAT (1H0, 17X, 5HFSGAP, 6X, 10I8, 7X, I3)                      
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CS144                                                  
C                                                                       
C                                                                       
C --- CODED    7-16-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 144 CARD -               
C ---         MODULE 2261.7.5                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE CONTENTS OF A TYPE 144 CARD     
C ---            AND STORES IT IN THE DATA BASE                         
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 144 CARD IS IN THE BUFFER.      
C     THIS ROUTINE CHECKS THE INFORMATION ON THE CARD, CALLING A        
C     ROUTINE TO PRINT AN ERROR MESSAGE WHERE NECESSARY. THE            
C     INFORMATION WILL BE STORED IN THE AMBER ARRAY                     
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     AMBER   ARRAY CONTAINING AMBER PHASE RESPONSE IN FT PER SEC       
C     IDX     INDEX TO ARRAYS                                           
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL ENTRIES ON CARD ARE CHECKED AND STORED.            
C                                                                       
         DO 10 IDX = 1, 10                                              
            IF (XBUF(IDX) .LT. 2 .OR. XBUF(IDX) .GT. 30)                
     1           CALL ERGEN ('CS144 ', 4032, IDX, XBUF(IDX), 0, 0,2)    
            AMBER(IDX) = XBUF(IDX)                                      
   10    CONTINUE                                                       
      IF (YPRINT) WRITE (LU6, 1000) (AMBER(IDX), IDX= 1, 10), XBUF(20)  
C                                                                       
 1000 FORMAT (1H0, 17X, 5HAMBER, 6X, 10I8, 7X, I3)                      
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CS145                                                  
C                                                                       
C                                                                       
C --- CODED    7-16-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 145 CARD -               
C ---         MODULE 2261.7.6                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS AND STORES THE CONTENTS OF ALL TYPE 
C ---            145 CARDS                                              
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A CARD TYPE 145 IS IN THE BUFFER.      
C     THIS ROUTINE EXAMINES THE VALIDITY OF THE BOUNDS AND CALLS        
C     A ROUTINE TO GENERATE AN ERROR MESSAGE IF INFORMATION IS          
C     INVALID. THE DATA IS STORED IN THE TRNGAP ARRAY.                  
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    RDNUM  - MODULE 2222.1.1.1                         
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     IDX     INDEX TO XBUF ARRAY                                       
C     INDEX   INDEX TO TRNGAP ARRAY                                     
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     LU7     PERIPHERAL UNIT NUMBER 7                                  
C     TRNGAP  ARRAY CONTAINING LEFT TURN GAP IN TENTHS OF A SEC         
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL 145 CARDS PROCESSED (UP TO 2 ARE PERMITTED)        
C                                                                       
    5 CONTINUE                                                          
C                                                                       
C -----  OUTPUT MESSAGE AND TRA IF CODE IS INVALID                      
C                                                                       
      IF (XBUF(1) .NE. 0  .AND.  XBUF(1) .NE. 1)                        
     1     CALL ERGEN ('CS145 ', 4039, XBUF(1), 0, 0, 0, 1)             
      IF (XBUF(1) .NE. 0  .AND.  XBUF(1) .NE. 1)             GO TO 15   
C                                                                       
C -----  DOUNTIL ALL ENTRIES ARE EXAMINED AND STORED.                   
C                                                                       
      INDEX = XBUF(1)*10 + 1                                            
         DO 10 IDX = 2, 11                                              
            IF (XBUF(IDX) .LT. 10 .OR. XBUF(IDX) .GT. 100)              
     1          CALL ERGEN ('CS145 ', 4033, IDX, XBUF(IDX), 0, 0,2)     
            TRNGAP(INDEX) = XBUF(IDX)                                   
            INDEX = INDEX + 1                                           
   10    CONTINUE                                                       
   15 CONTINUE                                                          
C                                                                       
C -----  GET NEXT CARD.  TRA BACK IF ANOTHER TYPE 145 CARD ELSE         
C -----  REPOSITION UNIT AND PRINT REVISED TRNGAP ARRAY                 
C                                                                       
      CALL RDNUM                                                        
      IF (XBUF(20) .EQ. 145)                                 GO TO 5    
      BACKSPACE LU7                                                     
      IF (YPRINT) WRITE (LU6, 1000) (TRNGAP(INDEX), INDEX = 1, 20)      
C                                                                       
 1000 FORMAT (1H0, 17X, 6HTRNGAP, 5X, 10I8, 7X, 3H145, / 29X, 10I8)     
      RETURN                                                            
      END                                                               
      SUBROUTINE CS146                                                  
C                                                                       
C                                                                       
C --- CODED    7-17-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 146 CARD -               
C ---         MODULE 2261.7.7                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS AND STORES THE CONTENTS OF ALL TYPE 
C ---            146 CARDS                                              
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 146 CARD IS IN THE BUFFER.      
C     THIS ROUTINE TESTS THE VALIDITY OF ALL THE INFORMATION ON         
C     THE CARD, CALLING A ROUTINE TO OUTPUT AN ERROR MESSAGE IF AN      
C     INVALID VALUE IS FOUND. THE CONTENT OF THIS CARD IS STORED IN THE 
C     PDLY AND PPER ARRAYS                                              
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                    RDNUM  - MODULE 2222.1.1.1                         
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     IDX     INDEX TO XBUF ARRAY                                       
C     INDEX   POINTER TO DATA IN PDLY ARRAY                             
C     JNDEX   INDEX TO PDLY AND PPER ARRAYS                             
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     LU7     PERIPHERAL UNIT NUMBER 7                                  
C     PDLY    ARRAY CONTAINING DELAY DUE TO PEDESTRIAN CONFLICT         
C     PPER    ARRAY CONTAINING DURATION OF PEDESTRIAN FLOW IN SEC       
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  DOUNTIL ALL TYPE 146 CARDS ARE PROCESSED                       
C                                                                       
   10 CONTINUE                                                          
C                                                                       
C -----  TEST THAT CODE IS VALID. TRA IF CODE IS INVALID, ELSE,         
C -----  SET INDEX FOR PDLY.                                            
C                                                                       
      IF (XBUF(1) .NE. 0 .AND. XBUF(1) .NE. 1)                          
     1    CALL ERGEN ('CS146 ', 4034, XBUF(1), 0, 0, 0, 1)              
      IF (XBUF(1) .NE. 0 .AND. XBUF(1) .NE. 1)               GO TO 30   
      INDEX = XBUF(1) * 10 - 1                                          
C                                                                       
C ----- DOUNTIL ALL ENTRIES FOR PDLY ARRAY ARE CHECKED (VALUE MUST BE   
C -----  BETWEEN ZERO AND FIFTY) AND STORED.                            
C                                                                       
         DO 20 IDX = 2, 11                                              
            IF (XBUF(IDX) .LT. 0 .OR. XBUF(IDX) .GT. 50)                
     1          CALL ERGEN ('CS146 ', 4035, IDX, XBUF(IDX),             
     2                                          XBUF(1), 0, 3)          
            JNDEX = INDEX + IDX                                         
            PDLY(JNDEX) = XBUF(IDX)                                     
   20    CONTINUE                                                       
   30 CONTINUE                                                          
C                                                                       
C -----  DOUNTIL ALL ENTRIES FOR THE PPER ARRAY ARE CHECKED (ENTRIES    
C -----  MUST BE POSITIVE) AND STORED.                                  
C                                                                       
         DO 40 IDX = 12, 16, 2                                          
            IF (XBUF(IDX) .LT. 0  .OR.  XBUF(IDX) .GT. 3)               
     1          CALL ERGEN ('CS146 ', 4072, XBUF(IDX),                  
     2                       IDX, 0, 0, 2)                              
            IF (XBUF(IDX) .LE. 0  .OR.  XBUF(IDX) .GT. 3)    GO TO 35   
            IF (XBUF(IDX+1) .LT. 0) CALL ERGEN ('CS146 ',               
     1                       4036, IDX, XBUF(IDX+1), 0, 0, 2)           
            JNDEX = XBUF(IDX)                                           
            PPER(JNDEX) = XBUF(IDX+1)                                   
   35       CONTINUE                                                    
   40    CONTINUE                                                       
C                                                                       
C -----  GET NEXT CARD. TRA BACK IF ANOTHER TYPE 146 CARD ELSE          
C -----  REPOSITION UNIT AND PRINT REVISED ARRAYS                       
C                                                                       
      CALL RDNUM                                                        
      IF (XBUF(20) .EQ. 146)                                 GO TO 10   
      BACKSPACE LU7                                                     
      IF (YPRINT) WRITE (LU6, 1000) (PDLY(JNDEX), JNDEX = 1, 20),       
     1                            (PPER(JNDEX), JNDEX = 1, 3)           
C                                                                       
 1000 FORMAT (1H0, 17X, 4HPDLY, 7X, 10I8, 7X, 3H146, / 29X, 10I8,/      
     1        1H0, 17X, 4HPPER, 7X, 3I8, 63X, 3H146)                    
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CS147                                                  
C                                                                       
C                                                                       
C --- CODED    7-17-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 147 CARD -               
C ---         MODULE 2261.7.8                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE DATA ON A TYPE 147 CARD         
C ---            AND STORES IT IN THE DATA BASE.                        
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 147 CARD IS IN THE BUFFER.      
C     THIS ROUTINE TESTS THE BOUNDS OF EACH DATA ITEM. A ROUTINE        
C     IS CALLED TO PRINT AN ERROR MESSAGE WHEN NEEDED. THE DATA IS      
C     STORED IN THE UFPCT ARRAY                                         
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C --------------     GLOSSARY OF VARIABLE NAMES   --------------------  
C                    --------------------------                         
C                                                                       
C     ICOUNT  SUM OF DATA IN UFPCT ARRAY                                
C     IDX     INDEX TO ARRAYS                                           
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     UFPCT   ARRAY OF PERCENTAGES FOR CALCULATING FREE FLOW SPEED      
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  INITIALIZE SUMMATION COUNTER. DOUNTIL ALL ENTRIES ARE TESTED   
C -----  (DATA MUST BE POSITIVE) AND STORED.                            
C                                                                       
      ICOUNT = 0                                                        
         DO 10 IDX = 1, 10                                              
            IF (XBUF(IDX) .LT. 0) CALL ERGEN ('CS147 ', 4037, IDX,      
     1                                        XBUF(IDX), 0, 0, 2)       
            UFPCT(IDX) = XBUF(IDX)                                      
            ICOUNT = ICOUNT + XBUF(IDX)                                 
   10    CONTINUE                                                       
C                                                                       
C -----  CHECK THAT SUM IS EQUAL TO 1000.                               
C                                                                       
      IF (ICOUNT .NE. 1000) CALL ERGEN ('CS147 ', 4040, ICOUNT,         
     1                                  147, 0, 0, 2)                   
C                                                                       
      IF (YPRINT) WRITE (LU6, 1000) (UFPCT(IDX), IDX = 1, 10), XBUF(20) 
C                                                                       
 1000 FORMAT (1H0, 17X, 5HUFPCT, 6X, 10I8, 7X, I3)                      
      RETURN                                                            
      END                                                               
      SUBROUTINE CS148                                                  
C                                                                       
C                                                                       
C --- CODED    7-18-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF A TYPE 148 CARD -             
C ---         MODULE 2261.7.9                                           
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS THE DATA ON A TYPE 148 CARD         
C ---            AND STORES IT IN THE DATA BASE                         
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 148 CARD IS IN THE BUFFER.      
C     THIS ROUTINE TESTS THE VALIDITY OF THE CHANGES TO THE SHORT       
C     TERM EVENT DURATIONS, CALLING A ROUTINE TO GENERATE AN ERROR      
C     MESSAGE IF NECESSARY. INFORMATION IS STORED IN THE STEPCT ARRAY   
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     ICOUNT  SUMMATION OF VALUES IN STEPCT ARRAY                       
C     IDX     INDEX TO ARRAYS                                           
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     STEPCT  ARRAY OF DURATION PERCENTAGE OF SHORT TERM EVENTS         
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
C -----  INITIALIZE SUMMATION COUNTER. DOUNTIL ALL DATA CHANGES         
C -----  ARE TESTED AND STORED. (DATA MUST BE POSITIVE)                 
C                                                                       
      ICOUNT = 0                                                        
         DO 10 IDX = 1, 10                                              
            IF (XBUF(IDX) .LT. 0) CALL ERGEN ('CS148 ', 4041,           
     1                                        IDX, XBUF(IDX), 0, 0, 2)  
            STEPCT(IDX) = XBUF(IDX)                                     
            ICOUNT = ICOUNT + XBUF(IDX)                                 
   10    CONTINUE                                                       
C                                                                       
C -----  CHECK THAT SUMMATION COUNTER IS 1000.                          
C                                                                       
      IF (ICOUNT .NE. 1000) CALL ERGEN ('CS148 ', 4040,                 
     1                                  ICOUNT, 148, 0, 0, 2)           
C                                                                       
      IF (YPRINT) WRITE (LU6, 1000) (STEPCT(IDX), IDX = 1, 10), XBUF(20)
C                                                                       
 1000 FORMAT (1H0, 17X, 6HSTEPCT, 5X, 10I8, 7X, I3)                     
      RETURN                                                            
      END                                                               
      SUBROUTINE CS149                                                  
C                                                                       
C                                                                       
C --- CODED    7-18-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 149 CARDS -              
C ---         MODULE 2261.7.10                                          
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS AND STORES THE CONTENTS OF ALL TYPE 
C ---            149 CARDS                                              
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 149 CARD IS IN THE BUFFER.      
C     THIS ROUNTINE CHECKS THE VALIDITY OF CHANGES INPUT ON CARD        
C     TYPE 149 FOR HDWPCT OR LSTME ARRAYS, CALLING A ROUTINE            
C     TO PRINT A WARNING MESSAGE WHEN NECESSARY. THE NEW DATA IS        
C     STORED IN EITHER THE LSTME OR HDWPCT ARRAY                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   -----------------------
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    ERGEN  - MODULE 2.6.1.1                            
C                    RDNUM - MODULE 2222.1.1.1                          
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     HDWPCT  ARRAY OF VEHICLE QUEUE DISCHARGE HEADWAY PERCENTAGES      
C     ICOUNT  SUM OF VALUES IN NEW DISTRUBUTION                         
C     IDX     INDEX TO XBUF ARRAY                                       
C     INDEX   INDEX TO LSTME OR HDWPCT ARRAY                            
C     IP      OFFSET TO DATA IN LSTME OR HDWPCT ARRAYS                  
C     LSTME   ARRAY OF START UP LOST TIME FACTORS                       
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     LU7     PERIPHERAL UNIT NUMBER 7                                  
C     XBUF    BUFFER ARRAY TO STORE CARD CONTENTS                       
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  DOUNTIL ALL TYPE 149 CARDS PROCESSED                           
C                                                                       
   10 CONTINUE                                                          
C                                                                       
C -----  CHECK THAT LINK TYPE CODE AND ARRAY CODE                       
C -----  IS IN RANGE. TRA IF INVALID.                                   
C                                                                       
      IF (XBUF(1) .LT. 1 .OR. XBUF(1) .GT. 4)                           
     1    CALL ERGEN ('CS149 ', 4042, XBUF(1), 0, 0, 0, 1)              
      IF (XBUF(1) .LT. 1 .OR. XBUF(1) .GT. 4)                GO TO 40   
      IF (XBUF(2) .NE. 0 .AND. XBUF(2) .NE. 1)                          
     1    CALL ERGEN ('CS149 ', 4043, XBUF(2), 0, 0, 0, 1)              
      IF (XBUF(2) .NE. 0 .AND. XBUF(2) .NE. 1)               GO TO 30   
C                                                                       
C -----  INITIALIZE SUMMATION COUNTER AND SET POINTER. DOUNTIL          
C -----  ELEMENTS 3-12 IN XBUF ARRAY ARE CHECKED AND STORED             
C -----  IN EITHER THE LSTME OR HDWPCT ARRAY                            
C                                                                       
      ICOUNT = 0                                                        
      IP = (XBUF(1) - 1) * 10                                           
         DO 20 IDX = 3, 12                                              
            IF (XBUF(IDX) .LT. 0) CALL ERGEN ('CS149 ', 4044,           
     1             IDX, XBUF(IDX), XBUF(1), 0, 3)                       
C                                                                       
C -----  CALCULATE INDEX FOR ARRAY AND STORE NEW DATA.                  
C -----  INCREMENT SUMMATION COUNTER.                                   
C                                                                       
            INDEX = IP + IDX - 2                                        
            IF (XBUF(2) .EQ. 0) LSTME(INDEX) = XBUF(IDX)                
            IF (XBUF(2) .EQ. 1) HDWPCT(INDEX) = XBUF(IDX)               
            ICOUNT = ICOUNT + XBUF(IDX)                                 
   20    CONTINUE                                                       
C                                                                       
C -----  TEST THAT NEW ELEMENTS SUM TO 1000.                            
C                                                                       
      IF (ICOUNT .NE. 1000)                                             
     1     CALL ERGEN ('CS149 ', 4040, ICOUNT, 149, 0, 0, 2)            
   30 CONTINUE                                                          
   40 CONTINUE                                                          
C                                                                       
C -----  GET NEXT CARD. TRA BACK IF ANOTHER TYPE 149 CARD ELSE          
C -----  REPOSITION UNIT AND PRINT REVISED ARRAYS                       
C                                                                       
      CALL RDNUM                                                        
      IF (XBUF(20) .EQ. 149)                                 GO TO 10   
      BACKSPACE LU7                                                     
      IF (YPRINT) WRITE (LU6, 1000) (LSTME (INDEX), INDEX = 1, 40),     
     1                            (HDWPCT(INDEX), INDEX = 1, 40)        
C                                                                       
 1000 FORMAT (1H0, 17X, 5HLSTME, 6X, 10I8, 7X, 3H149, 3(/29X, 10I8)/    
     1        1H0, 17X, 6HHDWPCT, 5X, 10I8, 7X, 3H149, 3(/29X, 10I8))   
      RETURN                                                            
      END                                                               
      SUBROUTINE CS150                                                  
C                                                                       
C                                                                       
C --- CODED    7-19-79 BY M. MASSUCCI                                   
C                                                                       
C --- TITLE - CHECK AND STORE CONTENTS OF TYPE 150 CARDS -              
C ---         MODULE 2261.7.11                                          
C                                                                       
C --- FUNCTION - THIS MODULE CHECKS AND STORES THE CONTENTS OF ALL TYPE 
C ---            150 CARDS                                              
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     WHEN THIS MODULE IS CALLED A TYPE 150 CARD IS IN THE BUFFER.      
C     THIS ROUTINE TESTS THE VALIDITY OF THE LIMITS OF THE DATA         
C     CHANGES TO THE ARRAY CONTAINING BUS DWELL TIMES. A ROUTINE IS     
C     CALLED TO OUTPUT AN ERROR MESSAGE WHERE NEEDED. INFORMATION IS    
C     STORED IN THE DWLD ARRAY                                          
C                                                                       
C -------------------   THIS ROUTINE IS CALLED BY   ------------------- 
C                       ----------------------                          
C                                                                       
C                    GEMDAT - MODULE 2261.7                             
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    RDNUM  - MODULE 2222.1.1.1                         
C                    ERGEN  - MODULE 2.6.1.1                            
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DWLPCT  ARRAY CONTAINING BUS DWELL TIMES                          
C     ICOUNT  SUM OF VALUES IN THE DWLPCT ARRAY                         
C     IDX     INDEX TO XBUF ARRAY                                       
C     INDEX   POINTER TO DATA IN DWLPCT ARRAY                           
C     JNDEX   INDEX TO DWLPCT ARRAY                                     
C     LU6     PERIPHERAL UNIT NUMBER 6                                  
C     LU7     PERIPHERAL UNIT NUMBER 7                                  
C     XBUF    BUFFER ARRAY USED TO STORE CARD CONTENTS                  
C     YPRINT  PRINT FLAG (.T. IF TABLES OF INPUT DATA NOT PRINTED YET)  
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
C -----  DOUNTIL ALL TYPE 150 CARDS PROCESSED                           
C                                                                       
   10 CONTINUE                                                          
C                                                                       
C -----  CHECK THAT INDEX OF DISTRIBUTION IS IN RANGE. TRA IF INVALID.  
C -----  CALCULATE DWLPCT POINTER. INITIALIZE SUMMATION COUNTER         
C                                                                       
      IF (XBUF(1) .LT. 1 .OR. XBUF(1) .GT. 6)                           
     1    CALL ERGEN ('CS150 ', 4047, XBUF(1) , 0, 0, 0, 1)             
      IF (XBUF(1) .LT. 1 .OR. XBUF(1) .GT. 6)                GO TO 30   
      INDEX = 10 * (XBUF(1) - 1)                                        
      ICOUNT = 0                                                        
C                                                                       
C -----  DOUNTIL ALL DATA CHANGES ARE CHECKED. TRA IF INVALID.          
C                                                                       
         DO 20 IDX = 2, 11                                              
            IF (XBUF(IDX) .LT. 0) CALL ERGEN ('CS150 ', 4048, IDX,      
     1                                        XBUF(IDX), XBUF(1), 0, 3) 
C                                                                       
C -----  CALCULATE INDEX TO DWLPCT ARRAY AND STORE NEW DATA. ADD NEW    
C -----  VALUE TO SUMMATION COUNTER.                                    
C                                                                       
            JNDEX = INDEX + IDX - 1                                     
            DWLPCT(JNDEX) = XBUF(IDX)                                   
            ICOUNT = ICOUNT + XBUF(IDX)                                 
   20    CONTINUE                                                       
C                                                                       
C -----  TEST THAT SUMMATION OF DATA IS 1000.                           
C                                                                       
      IF (ICOUNT .NE. 1000) CALL ERGEN ('CS150 ', 4040, ICOUNT,         
     1                                 150, 0, 0, 2)                    
   30 CONTINUE                                                          
C                                                                       
C -----  GET NEXT CARD.  TRA BACK IF ANOTHER TYPE 150 CARD ELSE         
C -----  REPOSITION UNIT AND PRINT REVISED ARRAY CONTENTS               
C                                                                       
      CALL RDNUM                                                        
      IF (XBUF(20) .EQ. 150)                                 GO TO 10   
      BACKSPACE LU7                                                     
      IF (YPRINT) WRITE (LU6, 1000) (DWLPCT(JNDEX), JNDEX = 1, 60)      
C                                                                       
 1000 FORMAT (1H0, 17X, 6HDWLPCT, 5X, 10I8, 7X, 3H150, 5(/29X, 10I8))   
      RETURN                                                            
      END                                                               
      SUBROUTINE CTRLFN                                                 
C                                                                       
C                                                                       
C --- CODED    3-13-78 BY M. YEDLIN                                     
C --- REVISED  8-15-79 BY M. MASSUCCI (FOR NETSIM)                      
C --- REVISED 10-28-85 BY A. HALATI (FOR NETSIM ACTUATED LOGIC)         
C --- REVISED  6-21-94 BY S. WALKER TO SKIP ROUTINE CALLS IF ERROR      
C                                                                       
C --- TITLE - GET TRAFFIC CONTROL AND SURVEILLANCE DATA - MODULE 2261.5 
C                                                                       
C --- FUNCTION - THIS MODULE ACTS AS EXECUTIVE TO CONTROL READING AND   
C ---            PROCESSING OF TRAFFIC CONTROL AND SURVEILLANCE INPUT   
C ---            CARDS                                                  
C                                                                       
C --- ARGUMENTS - NONE                                                  
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE CALLS SUBORDINATE MODULES TO DIRECT THE PROCESSING    
C     OF CARD TYPES 35 36 39 40 41 AND 42 IT THEN CALLS A SUBORDINATE   
C     MODULE TO PERFORM GROUP DIAGNOSTICS FOR CONTROL AND SURVEILLANCE  
C     DATA.                                                             
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    INPTFN - MODULE 2.2.6.1                            
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                    SGNLFN - MODULE 2261.5.1                           
C                    ACTSFN - MODULE 2261.5.2                           
C                    RDFN42 - MODULE 2261.5.3                           
C                    GCNTFN - MODULE 2261.5.4                           
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C                               NONE                                    
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'GLOBAL.INC'                                              
C                                                                       
      CALL SGNLFN                                                       
      CALL RDFN42                                                       
      CALL ACTSFN                                                       
      IF (ERRCT .EQ. 0) CALL GCNTFN                                     
C                                                                       
      RETURN                                                            
      END                                                               
      SUBROUTINE CUBIC (I1, IL, I2, IMOV, ILEN, JACC, J1, J2)           
C                                                                       
C --- CODED   10-24-79 BY M. BURNS                                      
C --- REVISED  6-30-92 BY J. WERK TO SLOW A VEHICLE TAGGED TO ALLOW A   
C ---                                     LANE CHANGER IN FRONT         
C --- REVISED  8-18-94 BY S. WALKER TO UNPACK SPDLN AND VSTATE          
C                                                                       
C --- TITLE - CALCULATE TRAJECTORY OF MOVING VEHICLE OVER ONE TIME-STEP 
C ---          - MODULE 3232.4511                                       
C                                                                       
C --- FUNCTION - THIS MODULE MOVES A QUEUED LEADER TOWARD THE STOP-LINE 
C ---            WHICH WILL NOT STOP AT THE STOP-LINE.                  
C                                                                       
C --- ARGUMENTS - I1     = VEHICLE NUMBER, FROM CALLING ROUTINE         
C ---             IL     = LINK NUMBER, FROM CALLING ROUTINE            
C ---             I2     = TIME REMAINING TO DISCHARGE FROM QUEUE       
C ---                      FROM CALLING ROUTINE                         
C ---             IMOV   = MOVEMENT CODE (IF 1, NO-GO. ELSE GO),        
C ---                      FROM CALLING ROUTINE                         
C ---             ILEN   = LINK LENGTH, FROM CALLING ROUTINE            
C ---             JACC   = VEHICLE ACCELERATION, TO CALLING ROUTINE     
C ---             J1     = VEHICLE SPEED AT END OF TIME-STEP, TO        
C ---                      CALLING ROUTINE                              
C ---             J2     = DISTANCE TRAVELLED , TO CALLING ROUTINE      
C                                                                       
C -------------------------   DESCRIPTION   --------------------------- 
C                             -----------                               
C                                                                       
C     THIS MODULE IS CALLED WHEN THE LEAD VEHICLE IN QUEUE IS MOVING    
C     TOWARD THE STOP-LINE AND WILL NOT DISCHARGE THIS TIME-STEP BUT    
C     THE SIGNAL IS EITHER GO OR AMBER. THE VEHICLE WILL NOT BE         
C     STOPPING AT THE STOP-LINE.                                        
C                                                                       
C -------------------   THIS ROUTINE CALLED BY   ---------------------- 
C                       ----------------------                          
C                                                                       
C                    QLEADR - MODULE 3232.4.5.1                         
C                                                                       
C ---------------------   THIS ROUTINE CALLS   ------------------------ 
C                         ------------------                            
C                                                                       
C                               NONE                                    
C                                                                       
C ----------------   GLOSSARY OF VARIABLE NAMES   --------------------- 
C                    --------------------------                         
C                                                                       
C     DECFOL  DECELERATION RATE OF FOLLOWER VEHICLE                     
C     DISTUP  VEHICLE SPECIFIC ARRAY - DISTANCE FROM UPSTREAM NODE      
C     DSCSPD  LANE SPECIFIC ARRAY - DISCHARGE SPEED CODE OF FIRST       
C             VEHICLE IN QUEUE                                          
C     ICODE   CODE IDENTIFYING DISCHARGE SPEED OF VEHICLE CURRENTLY     
C             FIRST IN QUEUE                                            
C     IDIS    DISTANCE TO STOP-LINE, FT.                                
C     IFRSPD  FREE-FLOW SPEED ON LINK, SUBJECT TO MAXIMUM OF 15         
C     IHDWY   TIME REMAINING TO DISCHARGE FROM HEAD OF QUEUE            
C     ISPD    CURRENT SPEED ON LINK                                     
C     IV      SUBJECT VEHICLE                                           
C     JDIS    DISTANCE TRAVELLED OVER ONE TIME-STEP                     
C     JSPD    VEHICLE SPEED AT END OF TIME-STEP                         
C     K       INDEX TO LANEV ARRAY                                      
C     KDIS    DISTANCE TO STOP-LINE AT END OF TIME-STEP                 
C     KSPD    DISCHARGE SPEED OF FIRST VEHICLE IN QUEUE                 
C     NLANE   VEHICLE SPECIFIC ARRAY - LANE OCCUPIED                    
C     RDIS    DISTANCE TO STOP-LINE, FT.                                
C     RH      TIME REMAINING TO DISCHARGE FROM HEAD OF QUEUE            
C     RIS     CURRENT SPEED ON LINK                                     
C     RKS     DISCHARGE SPEED OF FIRST VEHICLE IN QUEUE                 
C     SPDLN   VEHICLE SPECIFIC ARRAY - CURRENT SPEED, FT/SEC            
C     VCHNG   VEHICLE SPECIFIC ARRAY - REMAIN TIME TO CHK FOR LANE CHNG,
C             INT BET LANE CHNGES, (1,0) IF (IN, NOT IN) GOAL LANE,     
C             POINTER TO VLNCHG ARRAY, FLAG IF VEH MUST SLOW TO ALLOW   
C             LANE CHANGER IN FRONT                                     
C     VFFSPD  VEHICLE SPECIFIC ARRAY - DESIRED FREE-FLOW SPEED          
C                                                                       
C --------------------------------------------------------------------- 
C                                                                       
      IMPLICIT INTEGER (A-Q, S-V, X), REAL (R, Z), LOGICAL (W, Y)       
C                                                                       
      INCLUDE 'NETSIM.INC'                                              
C                                                                       
      IV = I1                                                           
      IHDWY = I2                                                        
C                                                                       
C -----  IDENTIFY DISCHARGE SPEED, CURRENT SPEED, AND DISTANCE          
C -----  TO THE STOP-LINE.                                              
C                                                                       
      K = 7 * (IL - 1) + NLANE(IV)                                      
      ICODE = DSCSPD(K)                                                 
      IFRSPD = MAX0 (VFFSPD(IV), 15)                                    
      KSPD = MIN0(5 * ICODE + 10, IFRSPD)                               
      IF (IMOV .EQ. 1) KSPD = 0                                         
      ISPD = SPDLN(IV)                                                  
      IDIS = ILEN - DISTUP(IV)                                          
      JDIS = IDIS                                                       
      JSPD = KSPD                                                       
C                                                                       
C -----  TRA IF VEHICLE WILL REACH STOP-LINE THIS TIME-STEP             
C                                                                       
      IF (IHDWY .LE. 10)                                     GO TO 20   
      RDIS = IDIS                                                       
      RH = IHDWY                                                        
      RH = RH / 10.0                                                    
      RIS = ISPD                                                        
      RKS = KSPD                                                        
C                                                                       
C -----  CALCULATE DISTANCE TRAVELLED, JDIS, NEW SPEED, JSPD.           
C                                                                       
      JDIS = ((-2.0 * RDIS / RH + RKS + RIS + 3.0 * RDIS) / RH          
     1        - 2.0 * RIS - RKS) / RH + RIS + 0.5                       
      JSPD = ((-6.0 * RDIS / RH + 3.0 * (RIS + RKS + 2.0 * RDIS)) / RH  
     1        - 4.0 * RIS - 2.0 * RKS) / RH + RIS + 0.5                 
      JDIS = MAX0(JDIS, 0)                                              
      JSPD = MAX0 (JSPD, 0)                                             
C                                                                       
C -----  TRA IF VEHICLE DID NOT REACH STOP-LINE. ELSE MOVE              
C -----  VEHICLE JUST SHORT OF STOP-LINE AND SET SPEED AND              
C -----  ACCELERATION.                                                  
C                                                                       
      IF (JDIS .LT. IDIS)                                    GO TO 10   
      KDIS = (KSPD * MAX0(IHDWY - 10, 0) + 5) / 10                      
      JDIS = MAX0(IDIS - KDIS, 1)                                       
      JSPD = MAX0 (2 * JDIS - KSPD, 1)                                  
   10 CONTINUE                                                          
   20 CONTINUE                                                          
      JACC = MIN0(MAX0(JSPD-ISPD, -12), 12)                             
      JSPD = MAX0 (MIN0 (ISPD + JACC, IFRSPD), 0)                       
C                                                                       
C -----  IF VEHCILE IS TAGGED TO SLOW FOR A LANE CHANGER IN FRONT, IT   
C -----  MAY BE NECESSARY TO REDUCE ITS DECELERATION, SPEED AND DISTANCE
C -----  TRAVELLED.                                                     
C                                                                       
      IF (MOD(VCHNG(IV) / 2**13, 2) .EQ. 1) THEN                        
         JACC = MAX0 (MIN0 (JACC, -DECFOL), -ISPD)                      
         JSPD = MIN0(JSPD, ISPD + JACC)                                 
         JDIS = MIN0(JDIS, ISPD + JACC / 2)                             
      ENDIF                                                             
      J1 = JSPD                                                         
      J2 = JDIS                                                         
C                                                                       
      RETURN                                                            
      END                                                               
