      SUBROUTINE COCARD
C***********************************************************************
C                 COCARD Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To process COntrol Pathway card images
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To change 'DEPLETE' parameter to 'DRYDPLT' for
C                    consistency with ISC Short Term model.
C                    Roger Brode, PES, Inc. - 11/18/94
C
C        MODIFIED:   To add DEPLETE parameter for plume depletion option
C                    and to allow flagpole receptors with DEPOS option.
C                    D. Strimaitis, SRC - 2/15/93
C
C        INPUTS:  Pathway (CO) and Keyword
C
C        OUTPUTS: Processing Option Switches
C                 Option Setup Status Switches
C
C        CALLED FROM:   SETUP
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'COCARD'

      IF (KEYWRD .EQ. 'STARTING') THEN
C        Set Status Switch
         ISTART = .TRUE.
         ICSTAT(1) = ICSTAT(1) + 1
         IF (ICSTAT(1) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
         END IF
      ELSE IF (KEYWRD .EQ. 'TITLEONE') THEN
C        Set Status Switch
         ICSTAT(2) = ICSTAT(2) + 1
         IF (ICSTAT(2) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
         ELSE
C           Process Titles                                  ---   CALL TITLES
            CALL TITLES
         END IF
      ELSE IF (KEYWRD .EQ. 'TITLETWO') THEN
C        Set Status Switch
         ICSTAT(3) = ICSTAT(3) + 1
         IF (ICSTAT(3) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
         ELSE
C           Process Titles                                  ---   CALL TITLES
            CALL TITLES
         END IF
      ELSE IF (KEYWRD .EQ. 'MODELOPT') THEN
C        Set Status Switch
         ICSTAT(4) = ICSTAT(4) + 1
         IF (ICSTAT(4) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Modeling Options                        ---   CALL MODOPT
            CALL MODOPT
         END IF
      ELSE IF (KEYWRD .EQ. 'AVERTIME') THEN
C        Set Status Switch
         ICSTAT(5) = ICSTAT(5) + 1
         IF (ICSTAT(5) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Averaging Time Options                  ---   CALL AVETIM
            CALL AVETIM
         END IF
      ELSE IF (KEYWRD .EQ. 'POLLUTID') THEN
C        Set Status Switch
         ICSTAT(6) = ICSTAT(6) + 1
         IF (ICSTAT(6) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE IF (ICSTAT(4) .NE. 1) THEN
C           WRITE Error Message: Keyword Out of Order (Must Follow MODELOPT)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         ELSE
C           Process Pollutant ID Option                     ---   CALL POLLID
            CALL POLLID
         END IF
      ELSE IF (KEYWRD .EQ. 'HALFLIFE' .OR.
     &         KEYWRD .EQ. 'DCAYCOEF') THEN
         IF (KEYWRD .EQ. 'HALFLIFE') THEN
C           Check for Previous DCAYCOEF Keyword in Runstream File
            IF (ICSTAT(8) .NE. 0) THEN
               CALL ERRHDL(PATH,MODNAM,'W','155',KEYWRD)
               GO TO 999
            ELSE
C              Set Status Switch and Check for Duplicate Keyword
               ICSTAT(7) = ICSTAT(7) + 1
               IF (ICSTAT(7) .NE. 1) THEN
C                 WRITE Error Message: Repeat Non-repeatable Keyword
                  CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
                  GO TO 999
               END IF
            END IF
         ELSE IF (KEYWRD .EQ. 'DCAYCOEF') THEN
C           Check for Previous HALFLIFE Keyword in Runstream File
            IF (ICSTAT(7) .NE. 0) THEN
               CALL ERRHDL(PATH,MODNAM,'W','155',KEYWRD)
               GO TO 999
            ELSE
C              Set Status Switch and Check for Duplicate Keyword
               ICSTAT(8) = ICSTAT(8) + 1
               IF (ICSTAT(8) .NE. 1) THEN
C                 WRITE Error Message: Repeat Non-repeatable Keyword
                  CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
                  GO TO 999
               END IF
            END IF
         END IF
C        Check for Keyword Out of Order
         IF (ICSTAT(4) .NE. 1) THEN
C           WRITE Error Message: Keyword Out of Order (Must Follow MODELOPT)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         ELSE IF (ICSTAT(6) .NE. 1) THEN
C           WRITE Error Message: Keyword Out of Order (Must Follow POLLUTID)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         END IF
C        Process Exponential Decay Option                   ---   CALL EDECAY
         CALL EDECAY
      ELSE IF (KEYWRD .EQ. 'TERRHGTS') THEN
C        Set Status Switch
         ICSTAT(9) = ICSTAT(9) + 1
         IF (ICSTAT(9) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Terrain Heights Option                  ---   CALL TERRHT
            CALL TERRHT
         END IF
      ELSE IF (KEYWRD .EQ. 'ELEVUNIT') THEN
C        Set Status Switch
         ICSTAT(10) = ICSTAT(10) + 1
         IF (ICSTAT(10) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Elevation Units Option                  ---   CALL ELUNIT
            CALL ELUNIT
C           WRITE Warning Message: CO ELEVUNIT is obsolete, should place
C           ELEVUNIT on SO, RE and/or TG pathway
            CALL ERRHDL(PATH,MODNAM,'W','151','instead ')
         END IF
      ELSE IF (KEYWRD .EQ. 'FLAGPOLE') THEN
C        Set Status Switch
         ICSTAT(11) = ICSTAT(11) + 1
         IF (ICSTAT(11) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Flagpole Receptor Height Option         ---   CALL FLAGDF
            CALL FLAGDF
         END IF
      ELSE IF (KEYWRD .EQ. 'RUNORNOT') THEN
C        Set Status Switch
         ICSTAT(12) = ICSTAT(12) + 1
         IF (ICSTAT(12) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Option to Run Model or Not              ---   CALL RUNNOT
            CALL RUNNOT
         END IF
      ELSE IF (KEYWRD .EQ. 'ERRORFIL') THEN
C        Set Status Switch
         ICSTAT(17) = ICSTAT(17) + 1
         IF (ICSTAT(17) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Error File Option                       ---   CALL ERRFIL
            CALL ERRFIL
         END IF
      ELSE IF (KEYWRD .EQ. 'FINISHED') THEN
C        Set Status Switch
         IFINIS = .TRUE.
C        Set Status Switch
         ICSTAT(20) = ICSTAT(20) + 1
         IF (ICSTAT(20) .NE. 1) THEN
C           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            GO TO 999
         END IF

C        Check for Missing Mandatory Keywords
         IF (ICSTAT(1) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         END IF
         IF (ICSTAT(2) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','TITLEONE')
         END IF
         IF (ICSTAT(4) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','MODELOPT')
         END IF
         IF (ICSTAT(5) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','AVERTIME')
         END IF
         IF (ICSTAT(6) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','POLLUTID')
         END IF
         IF (ICSTAT(12) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','RUNORNOT')
         END IF

C *** Elevated terrain option is allowed in ISCLT3 -- remove check
C         IF (DEPOS .AND. ELEV) THEN
C           WRITE Warning Message for Use of ELEV Terrain with DEPOS,
C           Reset to FLAT Terrain
C            CALL ERRHDL(PATH,MODNAM,'W','213',' DEPOS ')
C            ELEV = .FALSE.
C            FLAT = .TRUE.
C         END IF
C *** Flagpole option is OK with new deposition algorithm --remove check
C        IF (DEPOS .AND. FLGPOL) THEN
C           WRITE Warning Message for Use of FLGPOL Option with DEPOS,
C           Reset FLGPOL Option to FALSE
C           CALL ERRHDL(PATH,MODNAM,'W','215',' DEPOS ')
C           FLGPOL = .FALSE.
C        END IF

C        Generate MODOPS Character Array to Summarize Modeling Options
         IF (CONC) THEN
            MODOPS(1) = 'CONC '
         ELSE
            MODOPS(1) = 'DEPOS'
         END IF
         IF (RURAL) THEN
            MODOPS(2) = 'RURAL'
         ELSE
            MODOPS(2) = 'URBAN'
         END IF
         IF (FLAT) THEN
            MODOPS(3) = 'FLAT'
         ELSE
            MODOPS(3) = 'ELEV'
         END IF
         IF (FLGPOL) MODOPS(4) = 'FLGPOL'
         IF (DFAULT) MODOPS(5) = 'DFAULT'
         IF (GRDRIS) MODOPS(6) = 'GRDRIS'
         IF (NOSTD)  MODOPS(7) = 'NOSTD'
         IF (NOBID)  MODOPS(8) = 'NOBID'
         IF (DDPLETE) MODOPS(12) = 'DRYDPL'

      ELSE
C        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      END IF

 999  RETURN
      END

      SUBROUTINE TITLES
C***********************************************************************
C                 TITLES Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Title Information From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Title Strings for Model Outputs
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'TITLES'

      IF (KEYWRD .EQ. 'TITLEONE') THEN
         TITLE1 = RUNST1(LOCE(2)+2:80)
         IF (RUNST1(LOCE(2)+2:80) .EQ. ' ') THEN
C           Write Error Message: Missing Parameter Title
            CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         END IF
      ELSE IF (KEYWRD .EQ. 'TITLETWO') THEN
         TITLE2 = RUNST1(LOCE(2)+2:80)
         IF (RUNST1(LOCE(2)+2:80) .EQ. ' ') THEN
C           Write Warning Message
            CALL ERRHDL(PATH,MODNAM,'W','200',KEYWRD)
         END IF
      END IF

 999  RETURN
      END

      SUBROUTINE MODOPT
C***********************************************************************
C                 MODOPT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Modeling Options From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To Output Warning Message '206' For Overriding
C                    Non-DEFAULT Option - 9/29/92
C
C        MODIFIED:   To add DEPLETE parameter for plume depletion option
C                    D. Strimaitis, SRC - 2/15/93
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Modeling Option Logical Switch Settings
C
C        ERROR HANDLING:   Checks for Too Few or Too Many Option Keywords;
C                          Checks for Invalid Option Keywords;
C                          Checks for Conflicting or Missing Option Keywords
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER KOPT*8

C     Variable Initializations - Initialize All Logical Switches to FALSE
      MODNAM = 'MODOPT'

C     Check for Too Few or Too Many Parameters
      IF (IFC .LT. 3) THEN
C        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ELSE IF (IFC .LT. 4) THEN
C        WRITE Warning Message   ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'W','201',KEYWRD)
      ELSE IF (IFC .GT. 11) THEN
C        WRITE Warning Message   ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'W','202',KEYWRD)
      END IF

C     First Check for Presence of DFAULT Switch
      DO 10 I = 3, IFC
         KOPT = FIELD(I)
         IF (KOPT .EQ. 'DFAULT' .OR. KOPT .EQ. 'DEFAULT') THEN
            DFAULT = .TRUE.
         END IF
 10   CONTINUE

C     Loop Through Fields Again Setting All Swithes
      DO 20 I = 3, IFC
         KOPT = FIELD(I)
         IF (KOPT .EQ. 'DFAULT') THEN
            DFAULT = .TRUE.
         ELSE IF (KOPT .EQ. 'CONC') THEN
            CONC = .TRUE.
            EMIFAC = 1.0E06
            EMILBL = 'GRAMS/SEC'
            OUTLBL = 'MICROGRAMS/M**3'
            CHIDEP(1) = 'AVER'
            CHIDEP(2) = 'AGE '
            CHIDEP(3) = 'CONC'
            CHIDEP(4) = 'ENTR'
            CHIDEP(5) = 'ATIO'
            CHIDEP(6) = 'N   '
         ELSE IF (KOPT .EQ. 'DEPOS' .OR. KOPT .EQ. 'DDEP') THEN
            DEPOS = .TRUE.
            EMIFAC = 3600.
            EMILBL = 'GRAMS/SEC'
            OUTLBL = 'GRAMS/M**2'
            CHIDEP(1) = '  TO'
            CHIDEP(2) = 'TAL '
            CHIDEP(3) = 'DEPO'
            CHIDEP(4) = 'SITI'
            CHIDEP(5) = 'ON  '
            CHIDEP(6) = '    '
         ELSE IF (KOPT .EQ. 'RURAL') THEN
            RURAL = .TRUE.
         ELSE IF (KOPT .EQ. 'URBAN') THEN
            URBAN = .TRUE.
         ELSE IF (KOPT .EQ. 'DRYDPLT') THEN
            DDPLETE = .TRUE.
         ELSE IF (KOPT .EQ. 'GRDRIS') THEN
            IF (.NOT. DFAULT) THEN
               GRDRIS = .TRUE.
            ELSE
C              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            END IF
         ELSE IF (KOPT .EQ. 'NOSTD') THEN
            IF (.NOT. DFAULT) THEN
               NOSTD = .TRUE.
            ELSE
C              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            END IF
         ELSE IF (KOPT .EQ. 'NOBID') THEN
            IF (.NOT. DFAULT) THEN
               NOBID = .TRUE.
            ELSE
C              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            END IF
CLT         ELSE IF (KOPT .EQ. 'NOCALM') THEN
CLT            IF (.NOT. DFAULT) THEN
CLT               NOCALM = .TRUE.
CLT               CLMPRO = .FALSE.
CLT            ELSE
CLTC              WRITE Warning Message     ! Non-DEFAULT Option Overridden
CLT               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
CLT            END IF
CLT         ELSE IF (KOPT .EQ. 'MSGPRO') THEN
CLT            IF (.NOT. DFAULT) THEN
CLT               MSGPRO = .TRUE.
CLT            ELSE
CLTC              WRITE Warning Message     ! Non-DEFAULT Option Overridden
CLT               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
CLT            END IF
         ELSE
C           WRITE Error Message     ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KOPT)
         END IF
 20   CONTINUE

C     Check for Conflicting or Missing Options
      IF (CONC .AND. DEPOS) THEN
C        WRITE Warning Message: Conflict, Set To CONC
         CALL ERRHDL(PATH,MODNAM,'W','204','CONC')
         DEPOS  = .FALSE.
         EMIFAC = 1.0E06
         OUTLBL = 'MICROGRAMS/M**3'
         CHIDEP(1) = 'AVER'
         CHIDEP(2) = 'AGE '
         CHIDEP(3) = 'CONC'
         CHIDEP(4) = 'ENTR'
         CHIDEP(5) = 'ATIO'
         CHIDEP(6) = 'N   '
      ELSE IF (.NOT.CONC .AND. .NOT.DEPOS) THEN
C        WRITE Warning Message   ! Use CONC as Default
         CALL ERRHDL(PATH,MODNAM,'W','205','CONC')
         CONC   = .TRUE.
         EMIFAC = 1.0E06
         OUTLBL = 'MICROGRAMS/M**3'
         CHIDEP(1) = 'AVER'
         CHIDEP(2) = 'AGE '
         CHIDEP(3) = 'CONC'
         CHIDEP(4) = 'ENTR'
         CHIDEP(5) = 'ATIO'
         CHIDEP(6) = 'N   '
      END IF

      IF (RURAL .AND. URBAN) THEN
C        WRITE Warning Message:  Using RURAL Setting
         CALL ERRHDL(PATH,MODNAM,'W','204','RURAL')
         URBAN = .FALSE.
      ELSE IF (.NOT.RURAL .AND. .NOT.URBAN) THEN
C        WRITE Warning Message   ! Use RURAL as Default
         CALL ERRHDL(PATH,MODNAM,'W','205','RURAL')
         RURAL = .TRUE.
      END IF

 999  RETURN
      END

      SUBROUTINE AVETIM
C***********************************************************************
C                 AVETIM Module of ISC Model
C
C        PURPOSE: Process Averaging Time Options From Runstream Input Image
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Averaging Period Array and PERIOD Logical Switch
C
C        ERROR HANDLING:   Checks for Too Many Long Term Averages (>4);
C                          Checks for Invalid Averaging Periods, MOD(24,X) NE 0;
C                          Checks for Duplicate Long Term Averaging Periods
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER*8 KOPT

C     Variable Initializations
      MODNAM = 'AVETIM'
      NUMAVE = 0

C     Check for No Parameters
      IF (IFC .LT. 3) THEN
C        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      END IF

C     Loop Through Fields Setting Logical Switches and Filling KAVE Array
      DO 50 I = 3, IFC
         KOPT = FIELD(I)
         IF (KOPT .EQ. 'PERIOD')  THEN
            PERIOD = .TRUE.
         ELSE IF (KOPT .EQ. 'MONTH') THEN
            MONTH = .TRUE.
            DO 20 J = 1, 12
               KAVE(J) = 1
 20         CONTINUE
            NUMAVE = NUMAVE + 12
         ELSE IF (KOPT .EQ. 'SEASON') THEN
            SEASON = .TRUE.
            DO 30 J = 13, 16
               KAVE(J) = 1
 30         CONTINUE
            NUMAVE = NUMAVE + 4
         ELSE IF (KOPT .EQ. 'ANNUAL') THEN
            ANNUAL = .TRUE.
            KAVE(17) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'QUARTR') THEN
            QUARTR = .TRUE.
            DO 40 J = 13, 16
               KAVE(J) = 1
 40         CONTINUE
            NUMAVE = NUMAVE + 4
         ELSE IF (KOPT .EQ. 'JAN') THEN
            MONTH = .TRUE.
            KAVE(1) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'FEB') THEN
            MONTH = .TRUE.
            KAVE(2) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'MAR') THEN
            MONTH = .TRUE.
            KAVE(3) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'APR') THEN
            MONTH = .TRUE.
            KAVE(4) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'MAY') THEN
            MONTH = .TRUE.
            KAVE(5) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'JUN') THEN
            MONTH = .TRUE.
            KAVE(6) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'JUL') THEN
            MONTH = .TRUE.
            KAVE(7) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'AUG') THEN
            MONTH = .TRUE.
            KAVE(8) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'SEP') THEN
            MONTH = .TRUE.
            KAVE(9) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'OCT') THEN
            MONTH = .TRUE.
            KAVE(10) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'NOV') THEN
            MONTH = .TRUE.
            KAVE(11) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'DEC') THEN
            MONTH = .TRUE.
            KAVE(12) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'WINTER') THEN
            SEASON = .TRUE.
            KAVE(13) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'SPRING') THEN
            SEASON = .TRUE.
            KAVE(14) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'SUMMER') THEN
            SEASON = .TRUE.
            KAVE(15) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'FALL') THEN
            SEASON = .TRUE.
            KAVE(16) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'QUART1') THEN
            QUARTR = .TRUE.
            KAVE(13) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'QUART2') THEN
            QUARTR = .TRUE.
            KAVE(14) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'QUART3') THEN
            QUARTR = .TRUE.
            KAVE(15) = 1
            NUMAVE = NUMAVE + 1
         ELSE IF (KOPT .EQ. 'QUART4') THEN
            QUARTR = .TRUE.
            KAVE(16) = 1
            NUMAVE = NUMAVE + 1
         ELSE
C           WRITE Error Message      ! Invalid Averaging Period
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         END IF
 50   CONTINUE

C     Check for Too Many Averaging Periods
      IF (NUMAVE .GT. NAVE) THEN
C        WRITE Error Message:  Too Many Averaging Periods Selected
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      END IF

C     Check for Inconsistent Use of SEASON and QUARTR
      IF (SEASON .AND. QUARTR) THEN
C        WRITE Error Message:  Can't Process Both Seasons and Quarters
         CALL ERRHDL(PATH,MODNAM,'E','369',KEYWRD)
      END IF

C     Check for Possible Inconsistent Use of PERIOD Average
      IF (PERIOD) THEN
         IF (ANNUAL) THEN
C           WRITE Error Message: PERIOD Average With ANNUAL
            CALL ERRHDL(PATH,MODNAM,'E','362',' ')
         END IF
         IF (MONTH .AND. (SEASON .OR. QUARTR)) THEN
C           WRITE Error Message: Too Many Period Or Time Fields
            CALL ERRHDL(PATH,MODNAM,'E','364',' ')
         END IF
         IF (.NOT.MONTH .AND. .NOT.SEASON .AND. .NOT.QUARTR) THEN
C           WRITE Warning Message: Period Average Only
            CALL ERRHDL(PATH,MODNAM,'W','366',' ')
         END IF
      END IF

C     Reinitialize AVEPER Array for Quarters Instead of Seasons
      IF (QUARTR .AND. .NOT.SEASON) THEN
         AVEPER(13) = 'QUART1'
         AVEPER(14) = 'QUART2'
         AVEPER(15) = 'QUART3'
         AVEPER(16) = 'QUART4'
      END IF

 999  RETURN
      END

      SUBROUTINE POLLID
C***********************************************************************
C                 POLLID Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Processes Pollutant Identification Option
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Pollutant Identification Option
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'POLLID'

C     Check The Number Of The Fields
      IF (IFC .LE. 2) THEN
C        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 3) THEN
C        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

      POLLUT = FIELD(3)

C     Check for Urban Regulatory Default for SO2
      IF (DFAULT .AND. URBAN .AND. POLLUT.EQ.'SO2') THEN
C        Set Default Decay Coefficient Corresponding to 4-Hour Half Life
         DECOEF = 4.81E-5
      END IF

 999  RETURN
      END

      SUBROUTINE EDECAY
C***********************************************************************
C                 EDECAY Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Processes Exponential Decay Options
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Exponental Decay Options
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'EDECAY'

C     Check The Number Of The Fields
      IF (IFC .LE. 2) THEN
C        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 3) THEN
C        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     Start To Get Decay Coef.
      CALL STONUM(FIELD(3),40,FNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .NE. 1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GO TO 999
      END IF

      IF (KEYWRD .EQ. 'HALFLIFE') THEN
         HAFLIF = FNUM
C        Calculate Decay Coef. by Halflife
         DECOEF = 0.693/HAFLIF
      ELSE IF (KEYWRD .EQ. 'DCAYCOEF') THEN
         DECOEF = FNUM
      END IF

C     Check for Urban Regulatory Default for SO2
      IF (DFAULT .AND. URBAN .AND. POLLUT.EQ.'SO2') THEN
         IF (DECOEF .NE. 4.81E-5) THEN
C           WRITE Warning Message: Attempt to Override Regulatory Default
            CALL ERRHDL(PATH,MODNAM,'W','206',KEYWRD)
         END IF
         DECOEF = 4.81E-5
      ELSE IF (DFAULT) THEN
         IF (DECOEF .NE. 0.0) THEN
C           WRITE Warning Message: Attempt to Override Regulatory Default
            CALL ERRHDL(PATH,MODNAM,'W','206',KEYWRD)
         END IF
         DECOEF = 0.0
      END IF

 999  RETURN
      END

      SUBROUTINE ELUNIT
C***********************************************************************
C                 ELUNIT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Terrain Elevation Units Option
C                 From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Terrain Elevation Units Switch
C
C        ERROR HANDLING:   Checks for Invalid Parameters;
C                          Checks for No Parameters;
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'ELUNIT'

      IF (IFC .EQ. 3) THEN
         IF (FIELD(3) .EQ. 'METERS') THEN
            ELTYPE = 'METERS'
         ELSE IF (FIELD(3) .EQ. 'FEET') THEN
            ELTYPE = 'FEET'
         ELSE
C           WRITE Error Message  ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203','ELTYPE')
         END IF
      ELSE IF (IFC .GT. 3) THEN
C        WRITE Error Message     ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
C        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200','ElevUnit')
      END IF

 999  RETURN
      END

      SUBROUTINE TERRHT
C***********************************************************************
C                 TERRHT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Terrain Height Option From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Terrain Height Option Logical Switch
C
C        ERROR HANDLING:   Checks for Invalid Parameters;
C                          Checks for No Parameters;
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'TERRHT'

      IF (IFC .EQ. 3) THEN
         IF (FIELD(3) .EQ. 'FLAT') THEN
            FLAT = .TRUE.
            ELEV = .FALSE.
         ELSE IF (FIELD(3) .EQ. 'ELEV') THEN
            ELEV = .TRUE.
            FLAT = .FALSE.
         ELSE
C           WRITE Error Message  ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         END IF
      ELSE IF (IFC .GT. 3) THEN
C        WRITE Error Message     ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
C        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      END IF

 999  RETURN
      END

      SUBROUTINE RUNNOT
C***********************************************************************
C                 RUNNOT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Option To RUN Or NOT From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Model RUN Logical Switch
C
C        ERROR HANDLING:   Checks for Invalid Parameters;
C                          Checks for No Parameters;
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'RUNNOT'

      IF (IFC .EQ. 3) THEN
         IF (FIELD(3) .EQ. 'RUN') THEN
            RUN = .TRUE.
         ELSE IF (FIELD(3) .EQ. 'NOT') THEN
            RUN = .FALSE.
         ELSE
C           WRITE Error Message  ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         END IF
      ELSE IF (IFC .GT. 3) THEN
C        WRITE Error Message     ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
C        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      END IF

 999  RETURN
      END

      SUBROUTINE FLAGDF
C***********************************************************************
C                 FLAGDF Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Default Flagpole Receptor Height Option
C                 From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Default Flagpole Receptor Heights
C
C        ERROR HANDLING:   Checks for Invalid Parameters;
C                          Checks for No Parameters;
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   COCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'FLAGDF'
      FLGPOL = .TRUE.

      IF (IFC .EQ. 3) THEN
         CALL STONUM(FIELD(3),40,ZFLG,IDUM)
         IF (IDUM .EQ. -1) THEN
C           Write Error Message:Invalid Numerical Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         END IF
         IF (ZFLG .GE. 0.0 .AND. IDUM .EQ. 1) THEN
            DO 10 I = 1, NREC
               AZFLAG(I) = ZFLG
 10         CONTINUE
         ELSE IF (ZFLG .LT. 0.0) THEN
C            WRITE Error Message: Invalid Data. Positive Value Turns Negative
             CALL ERRHDL(PATH,MODNAM,'E','209','ZFLAG')
         ELSE IF (IDUM .NE. 1) THEN
C            WRITE Error Message: Field Number Not Meet Requirement
             CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
C            WRITE Error Message: Invalid Parameter
             CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         END IF
      ELSE IF (IFC .GT. 3) THEN
C        WRITE Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
C        WRITE Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'W','205','ZFLAG=0.')
      END IF

 999  RETURN
      END

      SUBROUTINE ERRFIL
C***********************************************************************
C                 ERRFIL Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Error Message File Option
C                 From Runstream Input Image
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Error Message File Logical Switch and ERRMSG Filename
C
C        ERROR HANDLING:   Checks for No Parametes (uses default name);
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   COCARD
C***********************************************************************
C
C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'ERRFIL'

      IF (IFC .EQ. 3) THEN
         ERRLST = .TRUE.
         MSGFIL = RUNST1(LOCB(3):LOCE(3))
      ELSE IF (IFC .EQ. 4) THEN
         IF (FIELD(4) .EQ. 'DEBUG') THEN
C           DEBUG Option Selected
            ERRLST = .TRUE.
            MSGFIL = RUNST1(LOCB(3):LOCE(3))
            DEBUG  = .TRUE.
         END IF
      ELSE IF (IFC .GT. 4) THEN
C        WRITE Error Message                      ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
C        WRITE Warning Message              ! No Parameters - Use Default Name
         CALL ERRHDL(PATH,MODNAM,'W','207',KEYWRD)
         ERRLST = .TRUE.
         MSGFIL = 'ERRORS.LST'
      END IF

 999  RETURN
      END

