      PROGRAM ISCLT3
C***********************************************************************
C                    ISC3 Long Term Model - ISCLT3
C                         (Version Dated 96113)
C
C               *** SEE ISCLT3 MODEL CHANGE BULLETIN MCB#2 ***
C
C       ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS BULLETIN BOARD
C
C                               919-541-5742
C
C       This version includes a correction to SUB. DEPCOR in DEPFLUX.FOR.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       April 22, 1996
C
C
C       MODIFIED FROM:    (Version Dated 95250)
C
C       This version of ISCLT3 contains a revised AREA SOURCE algorithm
C       and revised DEPOSITION algorithm.  These Supplement C revisions had
C       been implemented independently, but are now merged in this version.
C       This version also includes an open pit source algorithm.
C
C        PROGRAMMED BY: Roger W. Brode, Jayant A. Hardikar,
C                       and James O. Paumier
C                       Pacific Environmental Services, Inc.
C                       5001 S. Miami Blvd., Suite 300
C                       P.O. Box 12077
C                       Research Triangle Park, North Carolina  27709
C
C                       Deposition portions by:
C
C                       Yicheng Zhuang and David G. Strimaitis
C                       Sigma Research Corperation
C                       196 Baker Ave
C                       Concord, MA 01742
C
C        DATE:    September 7, 1995
C
C***********************************************************************
C        Version History of ISCLT3
C
C          Date     Version    Alias      Developed From
C        --------   -------   -------    ---------------------
C        08-28-95   95250     ISCLT3     DEPLT   (dated 94067),
C                                        AREA-LT (dated 93188), and
C                                        ISCLT2  (dated 93109)
C        03-08-94   94067     DEPLT      DEPLT   (dated 94006)
C        01-06-94   94006     DEPLT      ISCLT2D (dated 93046)
C        02-15-93   93046     ISCLT2D    ISCLT2  (dated 92273)
C        09-29-92   92273     ISCLT2     ISCLT2  (dated 92062)
C        03-02-92   92062     ISCLT2
C
C***********************************************************************
C
C       MAIN Module of the ISC3 Long Term Model - ISCLT3
C                     (Version Dated 95250)
C
C        DATE:    September 7, 1995
C
C        PURPOSE:   Controls Overall Flow and Processing
C
C        DEVELOPED FROM:    ISCLT2  (Version Dated 93109)
C
C        PROGRAMMED BY: Roger W. Brode, Jayant Hardikar,
C                       and James Paumier
C                       Pacific Environmental Services, Inc.
C                       P.O. Box 12077
C                       Research Triangle Park, North Carolina  27709
C
C        INPUTS:  Command Line Options
C
C        OUTPUTS: Model Results
C
C        The ISC3 models have been developed for the U.S. Environmental
C        Protection Agency under Contract No. 68D30032.  The PES Project
C        Manager is Roger W. Brode.  For instructions on running the model,
C        refer to the User's Guide for the Industrial Source Complex (ISC3)
C        Dispersion Models, Volume I - User Instructions (EPA-454/B-95-003a).
C
C*****************************************************************************
C
C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations                              ---   CALL VARINI
      CALL VARINI
      MODNAM = 'MAIN'

C     Open the Temporary File for Error Messages Generated from the Program
      OPEN(UNIT=IERUNT,FILE='ERRMSG.TMP',STATUS='UNKNOWN')

C     Close and Delete The Error Message Temporary Files To Avoid Re-reading
C     Messages if File Already Exists and READ Precedes WRITE.
      CLOSE(IERUNT,STATUS='DELETE')

C     Re-Open the Temporary File for Error Messages Generated from the Program
      OPEN(UNIT=IERUNT,FILE='ERRMSG.TMP',STATUS='UNKNOWN')

C     Retrieve Input and Output File Names From Command Line
C     ---   CALL GETCOM
      CALL GETCOM (' ISCLT3 ',INPFIL,OUTFIL)

C     Open Input and Output Files                           ---   CALL FILOPN
      CALL FILOPN

C     Process The Model Setup Information                   ---   CALL SETUP
      CALL SETUP

C     Determine Number of Setup Messages by Message Type    ---   CALL TERRST
      CALL TERRST

      IF (.NOT.RUN .OR. FATAL .OR. IWRN .GT. 0) THEN
C        Write Out Summary Of Setup Error/Message Stats     ---   CALL SUMTBL
         WRITE(IOUNIT,9111)
 9111    FORMAT(//2X,'*** Message Summary For ISC3 Model Setup ***'/)
         CALL SUMTBL
      END IF

      IF (FATAL) THEN
         WRITE(IOUNIT,9112)
 9112    FORMAT(/4X,'**************************************',
     &          /4X,'*** SETUP Finishes UN-successfully ***',
     &          /4X,'**************************************'/)
      ELSE
         WRITE(IOUNIT,9113)
 9113    FORMAT(/1X,'***********************************',
     &          /1X,'*** SETUP Finishes Successfully ***',
     &          /1X,'***********************************'/)
      END IF

C     Print Summary of the Input Data                       ---   CALL INPSUM
      CALL INPSUM

      IF (.NOT.FATAL .AND. RUN) THEN
         IF (.NOT.RUNERR .AND. (MONTH.OR.SEASON.OR.QUARTR.OR.
     &                                             ANNUAL)) THEN
C           Process Monthly/Seasonal/Quarterly/Annual Values---   CALL LTMSA
            CALL LTMSA
         END IF
         IF (.NOT.RUNERR .AND. PERIOD) THEN
C           Process Period Values                           ---   CALL LTPER
            CALL LTPER
         END IF
      END IF

      CALL HEADER
      WRITE(IOUNIT,9114)
 9114 FORMAT(/1X,'*** Message Summary : ISCLT3 Model Execution ***'/)
C     Determine Number of Errors/Messages by Message Type   ---   CALL TERRST
      CALL TERRST
C     Write Summary of Message Stats for Model Execution    ---   CALL SUMTBL
      CALL SUMTBL

      IF (FATAL .OR. RUNERR) THEN
         WRITE(IOUNIT,9115)
 9115    FORMAT(/4X,'***************************************',
     &          /4X,'*** ISCLT3 Finishes UN-successfully ***',
     &          /4X,'***************************************'/)
      ELSE
         WRITE(IOUNIT,9116)
 9116    FORMAT(/4X,'************************************',
     &          /4X,'*** ISCLT3 Finishes Successfully ***',
     &          /4X,'************************************'/)
      END IF

      IF (ERRLST) THEN
C        OPEN and Write Out Permanent Error Message File    ---   CALL MSGWRT
         OPEN(UNIT=IERWRT,FILE=MSGFIL,STATUS='UNKNOWN',
     &        FORM='FORMATTED')
         CALL MSGWRT
         CLOSE(IERWRT)
      END IF

C     Close and Delete The Error Message Temporary File
      CLOSE(IERUNT,STATUS='DELETE')

      STOP
      END

      SUBROUTINE LTMSA
C***********************************************************************
C                 LTMSA Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Controls Processing of Monthly/Seasonal/Quarterly/Annual
C                 STAR Values in the ISC2 Long Term Model
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To remove check for FREQ = 0.0 because of numerical
C                    integration algorithm for AREA sources.  Check is
C                    now made in SUB. LTCALC. - 7/7/93
C
C        MODIFIED:   To add call to TOXXFL for processing TOXXFILE
C                    option - 9/29/92
C
C        INPUTS:  Meteorology STAR Array
C                 Processing Options
C                 Source Arrays
C                 Receptor Arrays
C
C        OUTPUTS: Results for Individual STAR Periods
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER SEACHR*6

C     Variable Initializations
      MODNAM = 'LTMSA'

C     Begin Averaging Period LOOP
      DO 50 IAVE = 1, NAVE

         IF (KAVE(IAVE) .EQ. 1) THEN
            SEACHR = AVEPER(IAVE)

C           Write Out Update to the Screen for the PC Version
            WRITE(*,909) SEACHR
 909        FORMAT('+','Now Processing STAR Data For ',A6)

            IF (KSTAR(IAVE) .EQ. 1) THEN
C              Extract Joint FREQ Dist. for This AvePer     ---   CALL METEXT
               CALL METEXT
            ELSE
C              WRITE Error Message:  STAR Data Not Available for This IAVE
               CALL ERRHDL(PATH,MODNAM,'E','398',AVEPER(IAVE))
               RUNERR = .TRUE.
               GO TO 50
            END IF

            IF (RUNERR) THEN
C              Run-time Error Has Been Encountered - Skip Calculations
               GO TO 50
            END IF

C           Begin Stability LOOP
            DO 40 IKST = 1, NKST
C              Write Out The Meteorology Data               ---   CALL METDAT
               CALL METDAT(SEACHR,IKST)
C              Begin Wind Sector LOOP
               DO 30 ISEC = 1, NSEC
C                 Begin Wind Speed LOOP
                  DO 20 IWS = 1, NWS
C                    Set Meteorological Variables           ---   CALL METSET
                     CALL METSET
C                    Calculate CONC or DEPOS                ---   CALL LTCALC
                     CALL LTCALC
 20               CONTINUE
C                 End Wind Speed LOOP
 30            CONTINUE
C              End Wind Sector LOOP
 40         CONTINUE
C           End Stability LOOP

C           Accumulate Group Value Array                    ---   CALL SUMGRP
            CALL SUMGRP
            IF (SORT) THEN
C              Sort Results to Determine High Values        ---   CALL LTSORT
               CALL LTSORT
            END IF
C           Output Results for Current AvePer               ---   CALL LTOUT
            CALL LTOUT(SEACHR)
            IF (PLFILE) THEN
C              Write Values to Plot File(s)                 ---   CALL PLOTFL
               CALL PLOTFL
            END IF
            IF (TXFILE) THEN
C              Write Values to TOXXFILE File (9/29/92)      ---   CALL TOXXFL
               CALL TOXXFL
            END IF
C           Flush Result Arrays                             ---   CALL FLUSH
            CALL FLUSH
         ELSE IF (KSTAR(IAVE) .EQ. 1) THEN
C           STAR Data Available But No Calculations Requested for This IAVE
C           Read Joint FREQ Distribution Data               ---   CALL METEXT
            CALL METEXT
         END IF

 50   CONTINUE
C     End Averaging Period LOOP

      RETURN
      END

      SUBROUTINE LTPER
C***********************************************************************
C                 LTPER Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Controls Processing of PERIOD Average Values in the
C                 ISC2 Long Term Model
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To remove check for FREQ = 0.0 because of numerical
C                    integration algorithm for AREA sources.  Check is
C                    now made in SUB. LTCALC. - 7/7/93
C
C        MODIFIED:   To add call to TOXANN for processing TOXXFILE
C                    option - 9/29/92
C
C        INPUTS:  Meteorology STAR Arrays
C                 Processing Options
C                 Source Arrays
C                 Receptor Arrays
C
C        OUTPUTS: PERIOD Average Results
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER SEACHR*6

C     Variable Initializations
      MODNAM = 'LTPER'
      EOF = .FALSE.

C     Rewind Meteorology Data File
      REWIND (UNIT=MFUNIT)

C     Begin Averaging Period LOOP
      DO 50 IAVE = 1, NAVE

C        Select Appropriate Averaging Period
         IF (MONTH .OR. SEASON .OR. QUARTR) THEN
C           Select Only the Averaging Periods Selected on AVERTIME Card
            IF (KAVE(IAVE) .EQ. 1) THEN
               SEACHR = AVEPER(IAVE)

C              Write Out Update to the Screen for the PC Version
               WRITE(*,909) SEACHR
 909           FORMAT('+','Now Processing ',A6,' Data For PERIOD ',
     &                    'Average.')

C              Extract Joint FREQ Dist. for This AvePer     ---   CALL METEXT
               CALL METEXT
C              Note That Met Data Are Not Printed Out Here Since They
C              Were Printed Within the LTMSA Loop.
            ELSE IF (KSTAR(IAVE) .EQ. 1) THEN
C              STAR Data Available But No Calculations Requested for This IAVE
C              Read Joint FREQ Distribution Data            ---   CALL METEXT
               CALL METEXT
C              Skip FREQ Loop
               GO TO 50
            ELSE
C              No Processing To Be Done For This IAVE.  Loop to Next IAVE.
               GO TO 50
            END IF
         ELSE IF (MONDAT .OR. SEADAT .OR. QUADAT) THEN
C           PERIOD Average Only - Select Only the Averaging Periods Specified
C           On the STARDATA Card.  Set NUMAVE = NUMSTR for Calculating Average
            NUMAVE = NUMSTR
            IF (KSTAR(IAVE) .EQ. 1) THEN
               SEACHR = AVEPER(IAVE)
C              Extract Joint FREQ Dist. for This AvePer     ---   CALL METEXT
               CALL METEXT

C              Write Out Update to the Screen for the PC Version
               WRITE(*,909) SEACHR

               IF (.NOT. RUNERR) THEN
C                 Write Out The Meteorology Data            ---   CALL METDAT
                  DO 10 K = 1, NKST
                     CALL METDAT(SEACHR,K)
 10               CONTINUE
               END IF
            ELSE
C              No Processing To Be Done For This IAVE.  Loop to Next IAVE.
               GO TO 50
            END IF
         END IF

         IF (RUNERR) THEN
C           Run-time Error Has Been Encountered - Skip Calculations
            GO TO 50
         END IF

C        Begin Stability LOOP
         DO 40 IKST = 1, NKST
C           Begin Wind Sector LOOP
            DO 30 ISEC = 1, NSEC
C              Begin Wind Speed LOOP
               DO 20 IWS = 1, NWS
C                 Set Meteorological Variables              ---   CALL METSET
                  CALL METSET
C                 Calculate CONC or DEPOS                   ---   CALL LTCALC
                  CALL LTCALC
 20            CONTINUE
C              End Wind Speed LOOP
 30         CONTINUE
C           End Wind Sector LOOP
 40      CONTINUE
C        End Stability LOOP

 50   CONTINUE
C     End Averaging Period LOOP

      IF (RUNERR) THEN
C        Run-time Error Has Been Encountered - Skip Outputs
         GO TO 999
      END IF

C     Calculate PERIOD Averages                             ---   CALL LTAVE
      CALL LTAVE
C     Accumulate Group Value Array                          ---   CALL SUMGRP
      CALL SUMGRP
      IF (SORT) THEN
C        Sort Results to Determine High Values              ---   CALL LTSORT
         CALL LTSORT
      END IF
C     Output Results for PERIOD Average                     ---   CALL LTOUT
      SEACHR = 'PERIOD'
      CALL LTOUT(SEACHR)
      IF (ANPLOT) THEN
C        Write Values to Plot File                          ---   CALL PLTANN
         CALL PLTANN
      END IF
      IF (ANTOXX) THEN
C        Write Values to TOXXFILE - 9/29/92                 ---   CALL TOXANN
         CALL TOXANN
      END IF

 999  RETURN
      END

      SUBROUTINE ERRHDL(PATHWY,MODNAM,INERTP,INERCD,INPMSG)
C***********************************************************************
C                 ERRHDL Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: A General Error Handling Procedure
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Code, Occur Locations
C
C        OUTPUTS: Error Message, Error Statistics..etc.
C
C        CALLED FROM:  (This Is An Utility Programm)
C***********************************************************************
C
C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER ERRMG1*50, PATHWY*2, INERTP*1, INERCD*3, ICODE*3,
     &          INPMSG*(*)
      LOGICAL FIND

C     Variable Initializations
      IERROR = IERROR + 1
      FIND = .FALSE.
      I = 1

C     Check for Occurrence of 'E' Error Type, and Set FATAL Switch
      IF (INERTP .EQ. 'E') THEN
         FATAL = .TRUE.
         NFATAL = NFATAL + 1
         IF (NFATAL .EQ. 999) THEN
C           Number Of Fatal Errors Has Reached Limit of 999
            ERRMG1 = 'Number of Fatal Errors Has Reached Limit of 999'
            MODNAM = 'ERRHDL'
            ICODE = '999'
            INPMSG = ' '
            WRITE(IERUNT,1111) PATHWY,INERTP,ICODE,ILINE,MODNAM,ERRMG1,
     &                         INPMSG
            GO TO 999
         ELSE IF (NFATAL .GT. 999) THEN
C           Skip Any More Error WRITEs
            GO TO 999
         END IF
      END IF

C     Go To Match The Error Massage
      DO WHILE (.NOT.FIND .AND. I.LE.IERRN)
         IF (INERCD .EQ. ERRCOD(I)) THEN
            IERRDX = I
            ERRMG1 = ERRMSG(I)
            FIND = .TRUE.
         END IF
         I = I + 1
      END DO

      IF (.NOT. FIND) THEN
         WRITE(ERRMG1,1001)
 1001    FORMAT('SYSTEM ERROR: MESSAGE NOT FOUND FOR THIS NUMBER!')
      END IF

C     Write Out The Error Message
      WRITE(IERUNT,1111) PATHWY,INERTP,INERCD,ILINE,MODNAM,ERRMG1,INPMSG
 1111 FORMAT(A2,1X,A1,A3,1X,I4,1X,A6,': ',A50,1X,A8)

 999  RETURN
      END

      SUBROUTINE TERRST
C***********************************************************************
C                  TERRST Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To Determine Total Error/Message Statistics
C
C        PROGRAMMER:  Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Message Temporary File
C
C        OUTPUTS: Total Number of Messages by Message Type
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8, INPFLD*3

C     Variable Initialization
      MODNAM = 'TERRST'
      IFTL = 0
      IWRN = 0
      INFO = 0
      ICLM = 0
      EOF = .FALSE.

C     Rewind the Temporary Error/Message File
      REWIND IERUNT

      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                     MODNAM,ERRMG1,ERRMG2

C        Sort Error Group And Find The Index
         INPFLD = ERRCD
         CALL STONUM(INPFLD,3,FNUM,IMIT)

         IF (ERRTP .EQ. 'E') THEN
            IFTL = IFTL + 1
         ELSE IF (ERRTP .EQ. 'W') THEN
            IWRN = IWRN + 1
         ELSE IF (ERRTP .EQ. 'I') THEN
            INFO = INFO + 1
            IF (INT(FNUM) .EQ. 440) THEN
C              Message for Calm Hour, Increment Calm Counter
               ICLM = ICLM + 1
            END IF
         END IF

         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

 1116 FORMAT(A2,1X,A1,A3,1X,I4,1X,A6,2X,A50,1X,A8)

C     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
C     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

      SUBROUTINE SUMTBL
C***********************************************************************
C                  SUMTBL Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To Print Out The Error Summary Table
C
C        PROGRAMMER:  Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Message Temporary File
C
C        OUTPUTS: Summary Of Errors
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8

C     Variable Initialization
      MODNAM = 'SUMTBL'
      EOF = .FALSE.

C     Write Out The Total Error Statistics
      WRITE(IOUNIT,*) ' --------- Summary of Total Messages --------'
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,*) 'A Total of ',IFTL,' Fatal Error Message(s)'
      WRITE(IOUNIT,*) 'A Total of ',IWRN,' Warning Message(s)'
      WRITE(IOUNIT,*) 'A Total of ',INFO,' Informational Message(s)'
      IF (ICLM .GT. 0) THEN
         WRITE(IOUNIT,*) ' '
         WRITE(IOUNIT,*) 'A Total of ',ICLM,' Calm Hours Identified'
      END IF
      WRITE(IOUNIT,*) ' '

C     Write Out All The Fatal Error Messages
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,*) '   ******** FATAL ERROR MESSAGES ******** '
      REWIND IERUNT
      J = 0
      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                     MODNAM,ERRMG1,ERRMG2
         IF (ERRTP .EQ. 'E') THEN
            J = J + 1
            WRITE(IOUNIT,1117) PATH,ERRTP,ERRCD,IERRLN,MODNAM,
     &                         ERRMG1,ERRMG2
         END IF
         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

C     If No Fatal Error Messages, Then Write 'NONE'
      IF (J .EQ. 0) THEN
         WRITE(IOUNIT,*) '              ***  NONE  ***         '
         WRITE(IOUNIT,*) ' '
      END IF

C     Write Out All The Warning Messages
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,*) '   ********   WARNING MESSAGES   ******** '
      REWIND IERUNT
      EOF = .FALSE.
      J = 0
      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=999,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                      MODNAM,ERRMG1,ERRMG2
         IF (ERRTP .EQ. 'W') THEN
            J = J + 1
            WRITE(IOUNIT,1117) PATH,ERRTP,ERRCD,IERRLN,MODNAM,
     &                         ERRMG1,ERRMG2
         END IF
         GO TO 111
 999     EOF = .TRUE.
 111     CONTINUE
      END DO

C     If No Warning Messages, Then Write 'NONE'
      IF (J .EQ. 0) THEN
         WRITE(IOUNIT,*) '              ***  NONE  ***        '
         WRITE(IOUNIT,*) ' '
      END IF

 1116 FORMAT(A2,1X,A1,A3,1X,I4,1X,A6,2X,A50,1X,A8)
 1117 FORMAT(1X,A2,1X,A1,A3,1X,I4,1X,A6,': ',A50,1X,A8)

C     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
C     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

      SUBROUTINE MSGWRT
C***********************************************************************
C                 MSGWRT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To Print Out The Error Summary Table
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Error Message File
C
C        OUTPUTS: The Error Message File
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8

C     Variable Initialization
      MODNAM = 'MSGWRT'

C     Write Out The Header Of The Message File
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,*) '     *********** Error Message List ********* '
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,*) '   PW     --- Pathway                           '
      WRITE(IERWRT,*) '   Code   --- Error Type + Error Code           '
      WRITE(IERWRT,*) '   L#     --- The Line Number Where Error Occurs'
      WRITE(IERWRT,*) '   ModNam --- Module Name In Which Error Occurs '
      WRITE(IERWRT,*) '   Hints  --- Hints For The Possible Solution   '
      WRITE(IERWRT,*) '     ***************************************** '
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,1114)
      WRITE(IERWRT,1115)
 1114 FORMAT('PW CODE  L#  MODNAM  ',18X,'ERROR MESSAGES',20X,'HINTS')
 1115 FORMAT('-- ---- ---- ------  ',50('-'),' --------')
      WRITE(IERWRT,*) ' '

      REWIND IERUNT
      EOF = .FALSE.

      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=999) PATH,ERRTP,ERRCD,IERRLN,
     &                                    MODNAM,ERRMG1,ERRMG2
         WRITE(IERWRT,1117) PATH,ERRTP,ERRCD,IERRLN,MODNAM,
     &                      ERRMG1,ERRMG2
         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

 1116 FORMAT(A2,1X,A1,A3,1X,I4,1X,A6,2X,A50,1X,A8)
 1117 FORMAT(A2,1X,A1,A3,1X,I4,1X,A6,': ',A50,1X,A8)

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 999  CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

C----------------------------------------------------------------------
C     Courtesy: Jay Sandhu
C               email: jsandhu@esri.com
C
C
C Please cite David H. Douglas, COLLECTED ALGORITHMS, Cambridge MA:
C Harvard Laboratory for Computer Graphics, 1974
C
C This is my reinvention buster.
C 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974
C
C>>>PNPY
C     .................................................................
C
C        SUBROUTINE PNPOLY
C
C        PURPOSE
C           TO DETERMINE WHETHER A POINT IS INSIDE A POLYGON
C
C        USAGE
C           CALL PNPOLY (PX, PY, X, Y, N, INOUT )
C
C        DESCRIPTION OF THE PARAMETERS
C           PX      - X-COORDINATE OF POINT IN QUESTION.
C           PY      - Y-COORDINATE OF POINT IN QUESTION.
C           X       - N LONG VECTOR CONTAINING X-COORDINATES OF
C                     VERTICES OF POLYGON.
C           Y       - N LONG VECTOR CONTAINING Y-COORDINATES OF
C                     VERTICES OF POLYGON.
C           N       - NUMBER OF VERTICES IN THE POLYGON.
C           INOUT   - THE SIGNAL RETURNED:
C                     -1 IF THE POINT IS OUTSIDE OF THE POLYGON,
C                      0 IF THE POINT IS ON AN EDGE OR AT A VERTEX,
C                      1 IF THE POINT IS INSIDE OF THE POLYGON.
C
C        REMARKS
C           THE VERTICES MAY BE LISTED IN CLOCKWISE OR ANTICLOCKWISE
C           ORDER.  FOR THIS SUBROUTINE A POINT IS CONSIDERED INSIDE
C           THE POLYGON IF IT IS LOCATED IN THE ENCLOSED AREA DEFINED
C           BY THE LINE FORMING THE POLYGON.
C           THE INPUT POLYGON MAY BE A COMPOUND POLYGON CONSISTING
C           OF SEVERAL SEPARATE SUBPOLYGONS. IF SO, THE FIRST VERTEX
C           OF EACH SUBPOLYGON MUST BE REPEATED, AND WHEN CALCULATING
C           N, THESE FIRST VERTICES MUST BE COUNTED TWICE.
C           INOUT IS THE ONLY PARAMETER WHOSE VALUE IS CHANGED.
C           PNPOLY CAN HANDLE ANY NUMBER OF VERTICES IN THE POLYGON.
C           WRITTEN BY RANDOLPH FRANKLIN, UNIVERSITY OF OTTAWA, 6/72.
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           A VERTICAL SEMI-INFINITE LINE IS DRAWN UP FROM THE POINT
C           IN QUESTION. IF IT CROSSES THE POLYGON AN ODD NUMBER OF
C           TIMES, THE POINT IS INSIDE THE POLYGON.
C
C     .................................................................
C
      SUBROUTINE PNPOLY (PX,PY,X,Y,N,INOUT)

      REAL X(N),Y(N)
      LOGICAL IX,IY,JX,JY,EOR

C     EXCLUSIVE OR FUNCTION.
      EOR(IX,IY)=(IX.OR.IY).AND..NOT.(IX.AND.IY)

      INOUT=-1
      DO 4 I=1,N
         XI=X(I)-PX
         YI=Y(I)-PY
C        CHECK WHETHER THE POINT IN QUESTION IS AT THIS VERTEX.
         IF (XI.EQ.0.0.AND.YI.EQ.0.0) GO TO 2
C        J IS NEXT VERTEX NUMBER OF POLYGON.
         J=1+MOD(I,N)
         XJ=X(J)-PX
         YJ=Y(J)-PY
C        IS THIS LINE OF 0 LENGTH ?
         IF (XI.EQ.XJ.AND.YI.EQ.YJ) GO TO 4
         IX=XI.GE.0.0
         IY=YI.GE.0.0
         JX=XJ.GE.0.0
         JY=YJ.GE.0.0
C        CHECK WHETHER (PX,PY) IS ON VERTICAL SIDE OF POLYGON.
         IF (XI.EQ.0.0.AND.XJ.EQ.0.0.AND.EOR(IY,JY)) GO TO 2
C        CHECK WHETHER (PX,PY) IS ON HORIZONTAL SIDE OF POLYGON.
         IF (YI.EQ.0.0.AND.YJ.EQ.0.0.AND.EOR(IX,JX)) GO TO 2
C        CHECK WHETHER BOTH ENDS OF THIS SIDE ARE COMPLETELY 1) TO RIGHT
C        OF, 2) TO LEFT OF, OR 3) BELOW (PX,PY).
         IF (.NOT.((IY.OR.JY).AND.EOR(IX,JX))) GO TO 4
C        DOES THIS SIDE OBVIOUSLY CROSS LINE RISING VERTICALLY FROM (PX,PY
         IF (.NOT.(IY.AND.JY.AND.EOR(IX,JX))) GO TO 1
         INOUT=-INOUT
         GO TO 4

1        IF ((YI*XJ-XI*YJ)/(XJ-XI)) 4,2,3
2        INOUT=0
         RETURN
3        INOUT=-INOUT
4     CONTINUE

      RETURN
      END

      BLOCK DATA INIT
C***********************************************************************
C
C     BLOCK DATA SUBPROGRAM OF THE ISC - Long Term MODEL
C
C     PURPOSE: Initialize Data in COMMON Blocks
C
C     MODIFIED:  To Include New Area Source Arrays - 7/7/93
C
C     MODIFIED:  To Include TOXXFILE Option - 9/29/92
C     MODIFIED:  For revised DRY DEPOSITION code - 2/15/93
C
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN3LT.INC'


C***********************************************************************
C     Initialize Model Version Number, VERSN (Year, Julian Day), as a
C     Character Variable
C***********************************************************************

      DATA VERSN /'96113'/                                              DTB94068


C***********************************************************************
C     Input/Output File Units and Input/Output File Names
C***********************************************************************

      DATA INUNIT/ 5/, IOUNIT/ 6/, MFUNIT/19/, IERUNT/10/,
     &     IERWRT/11/, IZUNIT/13/
      DATA INPFIL/' '/,OUTFIL/' '/


C***********************************************************************
C     Initialize Keyword Array
C***********************************************************************

      DATA (KEYWD(I),I=1,IKN) /'STARTING','FINISHED','TITLEONE',
     &   'TITLETWO','MODELOPT','AVERTIME','POLLUTID','HALFLIFE',
     &   'DCAYCOEF','TERRHGTS','ELEVUNIT','FLAGPOLE','RUNORNOT',
     &   'ERRORFIL','LOCATION','SRCPARAM','BUILDHGT','BUILDWID',
     &   'LOWBOUND','EMISFACT','EMISUNIT','PARTDIAM','MASSFRAX',
     &   'PARTDENS','SRCGROUP','GRIDCART','GRIDPOLR','DISCCART',
     &   'DISCPOLR','BOUNDARY','BOUNDELV','INPUTFIL','ANEMHGHT',
     &   'SURFDATA','UAIRDATA','STARDATA','WDROTATE','WINDPROF',
     &   'DTHETADZ','AVESPEED','AVETEMPS','AVEMIXHT',
     &   'AVEROUGH','RECTABLE','MAXTABLE','PLOTFILE',
     &   'TOXXFILE'/


C***********************************************************************
C     Initialize Miscellaneous Variables
C***********************************************************************

      DATA EXPLIM /-50.0/
      DATA MODOPS /12*'      '/


C***********************************************************************
C     Initialize Default Wind Profile Exponents and DTHETADZ
C***********************************************************************

C     STAB. CLASS  A    B     C     D      E      F
C                 ***  ***   ***   ***    ***    ***
      DATA DTURB  /0.,  0.,   0.,   0.,   0.02, 0.035/,
     &     DTRUR  /0.,  0.,   0.,   0.,   0.02, 0.035/,
     &     PURB  /0.15, 0.15, 0.20, 0.25, 0.30, 0.30/,
     &     PRUR  /0.07, 0.07, 0.10, 0.15, 0.35, 0.55/

      DATA AVESP /1.50, 2.50, 4.30, 6.80, 9.50, 12.50/


C***********************************************************************
C     Initialize Receptor Arrays
C***********************************************************************

      DATA AXR/NREC*0.0/, AYR/NREC*0.0/, AZELEV/NREC*0.0/,
     &     AZFLAG/NREC*0.0/


C***********************************************************************
C     Initialize Source Arrays  (Multi-dimensional Arrays Initialized in
C                                SUBROUTINE VARINI)
C***********************************************************************

      DATA AXS/NSRC*0.0/, AYS/NSRC*0.0/, AZS/NSRC*0.0/, AQS/NSRC*0.0/,
     &     AHS/NSRC*0.0/, ADS/NSRC*0.0/, AVS/NSRC*0.0/, ATS/NSRC*0.0/,
     &     ASYINI/NSRC*0.0/, ASZINI/NSRC*0.0/, AXINIT/NSRC*0.0/,
     &     AYINIT/NSRC*0.0/, AANGLE/NSRC*0.0/,
     &     SOPCRD/NSRC*'N'/


C***********************************************************************
C     Initialize Setup Status Arrays
C***********************************************************************

      DATA ICSTAT/20*0/, ISSTAT/20*0/, IRSTAT/20*0/, IMSTAT/20*0/,
     &     IOSTAT/20*0/


C***********************************************************************
C     Initialize Error Code and Message Arrays
C***********************************************************************

      DATA ERRCOD(1)/'100'/,
     &  ERRMSG(1)/'Invalid Pathway Specified. The Troubled Pathway is'/
      DATA ERRCOD(2)/'105'/,
     &  ERRMSG(2)/'Invalid Keyword Specified. The Troubled Keyword is'/
      DATA ERRCOD(3)/'110'/,
     &  ERRMSG(3)/'Keyword is Not Valid for This Pathway.  Keyword is'/
      DATA ERRCOD(4)/'115'/,
     &  ERRMSG(4)/'STARTING or FINISHED Out of Sequence:  Pathway =  '/
      DATA ERRCOD(5)/'120'/,
     &  ERRMSG(5)/'Pathway is Out of Sequence:  Pathway =            '/
      DATA ERRCOD(6)/'125'/,
     &  ERRMSG(6)/'Missing FINISHED-Runstream File Incomplete: ISTAT='/
      DATA ERRCOD(7)/'130'/,
     &  ERRMSG(7)/'Missing Mandatory Keyword.  The Missing Keyword is'/
      DATA ERRCOD(8)/'135'/,
     &  ERRMSG(8)/'Duplicate Nonrepeatable Keyword Specified:Keyword='/
      DATA ERRCOD(9)/'140'/,
     &  ERRMSG(9)/'Invalid Order of Keyword.  The Troubled Keyword is'/
      DATA ERRCOD(10)/'142'/,
     &  ERRMSG(10)/'Missing AVETEMPS Keyword for Specified AVEPER     '/
      DATA ERRCOD(11)/'144'/,
     &  ERRMSG(11)/'Missing AVEMIXHT Keyword for Specified AVEPER     '/
C     Add message for missing AVEROUGH Keyword - Array sequence adjusted
      DATA ERRCOD(12)/'146'/,
     &  ERRMSG(12)/'Missing AVEROUGH Keyword for Specified AVEPER     '/
      DATA ERRCOD(13)/'155'/,
     &  ERRMSG(13)/'Conflicting Decay Keyword. Inputs Ignored for     '/
      DATA ERRCOD(14)/'160'/,
     &  ERRMSG(14)/'Duplicate ORIG Secondary Keyword for GRIDPOLR:    '/
      DATA ERRCOD(15)/'170'/,
     &  ERRMSG(15)/'Invalid Secondary Keyword for Receptor Grid:      '/
      DATA ERRCOD(16)/'175'/,
     &  ERRMSG(16)/'Missing Secondary Keyword END for Receptor Grid:  '/
      DATA ERRCOD(17)/'180'/,
     &  ERRMSG(17)/'Conflicting Secondary Keywords for Receptor Grid: '/
      DATA ERRCOD(18)/'185'/,
     &  ERRMSG(18)/'Missing Receptor Keywords. No Receptors Specified.'/
      DATA ERRCOD(19)/'190'/,
     &  ERRMSG(19)/'No Keywords for OU Pathway and No PERIOD Averages.'/
      DATA ERRCOD(20)/'200'/,
     &  ERRMSG(20)/'Missing Parameter(s). No Options Specified For    '/
      DATA ERRCOD(21)/'201'/,
     &  ERRMSG(21)/'Not Enough Parameters Specified For the Keyword of'/
      DATA ERRCOD(22)/'202'/,
     &  ERRMSG(22)/'Too Many Parameters Specified For the Keyword of  '/
      DATA ERRCOD(23)/'203'/,
     &  ERRMSG(23)/'Invalid Parameter Specified.  Troubled Parameter: '/
      DATA ERRCOD(24)/'204'/,
     &  ERRMSG(24)/'Option Parameters Conflict.  Forced by Default to '/
      DATA ERRCOD(25)/'205'/,
     &  ERRMSG(25)/'No Option Parameter Setting.  Forced by Default to'/
      DATA ERRCOD(26)/'206'/,
     &  ERRMSG(26)/'Regulatory DFAULT Specified With Non-DFAULT Option'/
      DATA ERRCOD(27)/'207'/,
     &  ERRMSG(27)/'No Parameters Specified. Default Values Used For  '/
      DATA ERRCOD(28)/'208'/,
     &  ERRMSG(28)/'Illegal Numerical Field Encountered in            '/
      DATA ERRCOD(29)/'209'/,
     &  ERRMSG(29)/'Negative Value Appears For Non-negative Variable. '/
      DATA ERRCOD(30)/'210'/,
     &  ERRMSG(30)/'Number of Short Term Averages Exceeds Max:  NAVE= '/
      DATA ERRCOD(31)/'211'/,
     &  ERRMSG(31)/'Duplicate Averaging Period Specified for Keyword  '/
      DATA ERRCOD(32)/'212'/,
     &  ERRMSG(32)/'END Encountered Without (X,Y) Points Properly Set '/
      DATA ERRCOD(33)/'213'/,
     &  ERRMSG(33)/'ELEV Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(34)/'214'/,
     &  ERRMSG(34)/'ELEV Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(35)/'215'/,
     &  ERRMSG(35)/'FLAG Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(36)/'216'/,
     &  ERRMSG(36)/'FLAG Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(37)/'217'/,
     &  ERRMSG(37)/'More Than One Delimiter In A Field for Keyword    '/
      DATA ERRCOD(38)/'218'/,
     &  ERRMSG(38)/'Number of (X,Y) Points Not Match With Number Of   '/
      DATA ERRCOD(39)/'219'/,
     &  ERRMSG(39)/'Number Of Receptors Specified Exceeds Max:  NREC= '/
      DATA ERRCOD(40)/'220'/,
     &  ERRMSG(40)/'Missing Origin (Use Default = 0,0) In GRIDPOLR    '/
      DATA ERRCOD(41)/'221'/,
     &  ERRMSG(41)/'Missing Distance Setting In Polar Network         '/
      DATA ERRCOD(42)/'222'/,
     &  ERRMSG(42)/'Missing Degree Or Dist Setting In Polar Network   '/
      DATA ERRCOD(43)/'223'/,
     &  ERRMSG(43)/'Missing Distance or Degree Field in               '/
      DATA ERRCOD(44)/'224'/,
     &  ERRMSG(44)/'Number of Receptor Networks Exceeds Max:  NNET=   '/
      DATA ERRCOD(45)/'225'/,
     &  ERRMSG(45)/'Number of X-Coords Specified Exceeds Max:  IXM=   '/
      DATA ERRCOD(46)/'226'/,
     &  ERRMSG(46)/'Number of Y-Coords Specified Exceeds Max:  IYM=   '/
      DATA ERRCOD(47)/'227'/,
     &  ERRMSG(47)/'No Receptors Were Defined on the RE Pathway.      '/
      DATA ERRCOD(48)/'228'/,
     &  ERRMSG(48)/'Default(s) Used for Missing Parameters on Keyword '/
      DATA ERRCOD(49)/'229'/,
     &  ERRMSG(49)/'Too Many Parameters - Inputs Ignored on Keyword   '/
      DATA ERRCOD(50)/'230'/,
     &  ERRMSG(50)/'Not Enough Numerical Values Specified for         '/
      DATA ERRCOD(51)/'231'/,
     &  ERRMSG(51)/'Too Many Numerical Values Specified for           '/
      DATA ERRCOD(52)/'232'/,
     &  ERRMSG(52)/'Number Of Specified Sources Exceeds Maximum: NSRC='/
      DATA ERRCOD(53)/'233'/,
     &  ERRMSG(53)/'Building Dimensions Specified for Non-POINT Source'/
      DATA ERRCOD(54)/'234'/,
     &  ERRMSG(54)/'Too Many Sectors Input for                        '/
      DATA ERRCOD(55)/'235'/,
     &  ERRMSG(55)/'Number of Source Groups Exceeds Maximum:  NGRP=   '/
      DATA ERRCOD(56)/'236'/,
     &  ERRMSG(56)/'Not Enough BUILDHGTs Specified for SourceID       '/
      DATA ERRCOD(57)/'237'/,
     &  ERRMSG(57)/'Not Enough BUILDWIDs Specified for SourceID       '/
      DATA ERRCOD(58)/'238'/,
     &  ERRMSG(58)/'Not Enough LOWBOUNDs Specified for SourceID       '/
      DATA ERRCOD(59)/'239'/,
     &  ERRMSG(59)/'Not Enough QFACTs Specified for SourceID          '/
      DATA ERRCOD(60)/'240'/,
     &  ERRMSG(60)/'Inconsistent Number of Settling/Removal Cats for  '/
      DATA ERRCOD(61)/'242'/,
     &  ERRMSG(61)/'No Settling/Removal Categories Specified for SRCID'/
      DATA ERRCOD(62)/'244'/,
     &  ERRMSG(62)/'Too Many Parameters (>NPDMAX) Specified for       '/
      DATA ERRCOD(63)/'245'/,
     &  ERRMSG(63)/'No. of Settling/Removal Cats Exceeds Max:  NPDMAX='/
      DATA ERRCOD(64)/'248'/,
     &  ERRMSG(64)/'No Sources Were Define on the SO Pathway.         '/
      DATA ERRCOD(65)/'250'/,
     &  ERRMSG(65)/'Duplicate XPNT/DIST or YPNT/DIR Specified for GRID'/
      DATA ERRCOD(66)/'252'/,
     &  ERRMSG(66)/'Duplicate Receptor Network ID Specified.  NETID = '/
      DATA ERRCOD(67)/'255'/,
     &  ERRMSG(67)/'Boundary Receptor Distances Not Defined Yet for   '/
      DATA ERRCOD(68)/'260'/,
     &  ERRMSG(68)/'Number of Emission Factors Exceeds Max:      NQF= '/
      DATA ERRCOD(69)/'270'/,
     &  ERRMSG(69)/'Number of High Values Specified Exceeds Max: NVAL='/
      DATA ERRCOD(70)/'280'/,
     &  ERRMSG(70)/'Number of Max Values Specified Exceeds Max:  NMAX='/
      DATA ERRCOD(71)/'300'/,
     &  ERRMSG(71)/'Specified SRCID Has Not Been Defined Yet: KEYWORD='/
      DATA ERRCOD(72)/'310'/,
     &  ERRMSG(72)/'Attempt to Define Duplicate LOCATION Card for SRC:'/
      DATA ERRCOD(73)/'315'/,
     &  ERRMSG(73)/'Attempt to Define Duplicate SRCPARAM Card for SRC:'/
      DATA ERRCOD(74)/'320'/,
     &  ERRMSG(74)/'Source Parameter May Be Out-of-Range for Parameter'/
      DATA ERRCOD(75)/'325'/,
     &  ERRMSG(75)/'Negative Exit Velocity (Set=1.0E-5) for SRCID:    '/
      DATA ERRCOD(76)/'330'/,
     &  ERRMSG(76)/'Mass Fraction Parameters Do Not Sum to 1. for Src '/
      DATA ERRCOD(77)/'332'/,
     &  ERRMSG(77)/'Mass Fraction Parameter Out-of-Range for Source   '/
      DATA ERRCOD(78)/'334'/,
     &  ERRMSG(78)/'Particle Density Out-of-Range for Source          '/
      DATA ERRCOD(79)/'340'/,
     &  ERRMSG(79)/'Possible Error In ANHT of ANEMHGHT. The Value is  '/
      DATA ERRCOD(80)/'355'/,
     &  ERRMSG(80)/'Specified Averaging Period Not Being Calculated:  '/
      DATA ERRCOD(81)/'362'/,
     &  ERRMSG(81)/'Averaging Time Conflict: PERIOD With ANNUAL Data  '/
      DATA ERRCOD(82)/'364'/,
     &  ERRMSG(82)/'Aver Time Conflict: PERIOD w/ MONTH & SEAS/QUART  '/
      DATA ERRCOD(83)/'366'/,
     &  ERRMSG(83)/'Possible Averaging Time Conflict: PERIOD Ave Only '/
      DATA ERRCOD(84)/'368'/,
     &  ERRMSG(84)/'Averaging Time Conflict: PERIOD Average Only & No '/
      DATA ERRCOD(85)/'369'/,
     &  ERRMSG(85)/'Averaging Time Conflict: Both SEASON and QUARTR   '/
      DATA ERRCOD(86)/'380'/,
     &  ERRMSG(86)/'This Input Variable is Out-of-Range:              '/
      DATA ERRCOD(87)/'391'/,
     &  ERRMSG(87)/'Aspect ratio (L/W) of area source greater than 10 '/
      DATA ERRCOD(105)/'392'/,
     & ERRMSG(105)/'Aspect ratio (L/W) of open pit is greater than 10 '/
      DATA ERRCOD(88)/'395'/,
     &  ERRMSG(88)/'Monthly QFACT Specified With No Monthly Averages  '/
      DATA ERRCOD(89)/'398'/,
     &  ERRMSG(89)/'STAR Data Not Available for the Specified Average '/
      DATA ERRCOD(90)/'400'/,
     &  ERRMSG(90)/'No Convergence Reached in SUB. CUBIC.             '/
      DATA ERRCOD(91)/'410'/,
     &  ERRMSG(91)/'Flow Vector Out-of-Range.   KURDAT=               '/
      DATA ERRCOD(92)/'480'/,
     &  ERRMSG(92)/'STAR Frequency Does Not Sum to 1.0 (within 2 %)   '/
      DATA ERRCOD(93)/'500'/,
     &  ERRMSG(93)/'Fatal Error Occurs Opening the Data File of       '/
      DATA ERRCOD(94)/'510'/,
     &  ERRMSG(94)/'Fatal Error Occurs During Reading of the File of  '/
      DATA ERRCOD(95)/'520'/,
     &  ERRMSG(95)/'Fatal Error Occurs During Writing to the File of  '/
      DATA ERRCOD(96)/'530'/,
     &  ERRMSG(96)/'Error Occurs Reading Met Station or Year:File Says'/
      DATA ERRCOD(97)/'540'/,
     &  ERRMSG(97)/'No RECTABLE/MAXTABLE/DAYTABLE for Average Period  '/
      DATA ERRCOD(98)/'550'/,
     &  ERRMSG(98)/'File Unit/Name Conflict for the Output Option:    '/
      DATA ERRCOD(99)/'560'/,
     &  ERRMSG(99)/'User Specified File Unit < 20 for OU Keyword:     '/
      DATA ERRCOD(100)/'565'/,
     & ERRMSG(100)/'Possible Conflict With Dynamically Allocated FUNIT'/
      DATA ERRCOD(101)/'575'/,
     & ERRMSG(101)/'End-of-File Reached Trying to Read STAR Data for  '/
      DATA ERRCOD(102)/'305'/,
     & ERRMSG(102)/'Terrain Grid Does Not Cover Modeling Area, Change:'/
      DATA ERRCOD(103)/'151'/,
     & ERRMSG(103)/'CO ELEVUNIT card obsolescent: use RE ELEVUNIT card'/
      DATA ERRCOD(104)/'152'/,
     & ERRMSG(104)/'ELEVUNIT card must be first for this Pathway:     '/
C     Note ERRCOD(105) is used for message number '392'.
      DATA ERRCOD(106)/'153'/,
     & ERRMSG(106)/'Cannot use CO ELEVUNIT card with ELEVUNIT card for'/
      DATA ERRCOD(107)/'393'/,
     & ERRMSG(107)/'Terrain Grid Value Differs >50% From Source Elev. '/
      DATA ERRCOD(108)/'394'/,
     & ERRMSG(108)/'Terrain Grid Value Differs >50% From Receptor Elev'/
      DATA ERRCOD(109)/'322'/,
     & ERRMSG(109)/'Release Height Exceeds Effective Depth for OPENPIT'/
      DATA ERRCOD(110)/'323'/,
     & ERRMSG(110)/'No Particle Categories Specified for OPENPIT Src. '/

      END
