      SUBROUTINE AVEREV
C***********************************************************************
C                 AVEREV Module of ISC2 Model - EVENT
C
C        PURPOSE: Sums Values and Calculates Averages
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Averaging Time Option Switches
C                 Array of CONC or DEPOS Values for One Hour, HRVALS
C
C        OUTPUTS: Updated Array of Cumulative Values and Averages, AVEVAL
C
C        CALLED FROM:   EVLOOP
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      REAL :: SNUM

C     Variable Initializations
      MODNAM = 'AVEREV'

C     Calculate Average CONCentrations If Hour is Right
      IF (CONC) THEN
         IF (EVAPER(IEVENT) .NE. 1) THEN
C           Calculate Denominator Considering Calms and Missing,
C           Skipping Averaging if Averaging Period is 1-Hour
            SNUM = AMAX0((EV_NUMHRS - EV_NUMCLM - EV_NUMMSG),
     &                    NINT(EV_NUMHRS*0.75+0.4))
C           Begin Source Group LOOP
            DO ISRC = 1, NUMSRC
               IF (IGROUP(ISRC,IDXEV(IEVENT)) .EQ. 1) THEN
                  EV_AVEVAL(ISRC) = (1./SNUM) * EV_AVEVAL(ISRC)
               ENDIF
            END DO
C           End Source Group LOOP
         END IF
      END IF

C     Calculate The Group Value
      GRPAVE = 0.
C     Begin Source Group LOOP
      DO ISRC = 1, NUMSRC
         IF (IGROUP(ISRC,IDXEV(IEVENT)) .EQ. 1) THEN
            GRPAVE = GRPAVE + EV_AVEVAL(ISRC)
         ENDIF
      END DO
C     End Source Group LOOP

      RETURN
      END

      SUBROUTINE EV_OUTPUT
C***********************************************************************
C                 EV_OUTPUT Module of ISC2 Model - EVENT
C
C        PURPOSE: Controls Output of Printed Model Results
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'EV_OUTPUT'

      IF (SOCONT) THEN
C        Print Out Source Contribution To the Event         ---   CALL PRTSOC
         CALL PRTSOC
      ELSE IF (DETAIL) THEN
C        Print Out Detal Summary of The Event               ---   CALL PRTDET
         CALL PRTDET
      END IF

      RETURN
      END

      SUBROUTINE PRTSOC
C***********************************************************************
C                 PRTSOC Module of ISC2 Model - EVENT
C
C        PURPOSE: Print Out The Source Contribution Data
C                 To The Event
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To correct overflow on format statement 9068, and
C                    to use separate array for source IDs in the header
C                    (HEADID) - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, N, NROW, NPAGE, INGRP, IOGRP
      REAL    :: WAVEV(NSRC)
      CHARACTER*8 HEADID(NSRC)

C     Variable Initializations
      MODNAM = 'PRTSOC'

C     Set Up The Print Array
      INGRP = 0
      DO ISRC = 1, NUMSRC
         IF (IGROUP(ISRC,IDXEV(IEVENT)) .EQ. 1) THEN
            INGRP = INGRP + 1
            WORKID(INGRP) = SRCID(ISRC)
            HEADID(INGRP) = SRCID(ISRC)
            WAVEV(INGRP)  = EV_AVEVAL(ISRC)
         END IF
      END DO
C     Check for More Than 34 Sources Per Group
      IF (INGRP .GT. 34) THEN
         HEADID(34) = ' . . . '
         IOGRP = 34
      ELSE
         IOGRP = INGRP
      END IF

C     Determine Number of Rows, NROW, @ 3 Values Per Row
      NROW = 1 + INT((INGRP-1)/3)
C     Determine Number of Pages, NPAGE, @ 40 Rows Per Page
      NPAGE = 1 + INT((NROW-1)/40)

C     Loop Through Pages For This Event
      DO N = 1, NPAGE

C        Print The Source Contributions
         CALL HEADER
         WRITE(IOUNIT,9058) EVNAME(IEVENT), EVAPER(IEVENT),
     &             EVDATE(IEVENT), AXR(IEVENT), AYR(IEVENT),
     &             AZELEV(IEVENT), AZFLAG(IEVENT)

         WRITE(IOUNIT,9068) EVGRP(IEVENT), (HEADID(I),I=1,IOGRP)
         WRITE(IOUNIT,9070) GRPAVE
         WRITE(IOUNIT,9062)

C        Print Out The Source Contributions
         IF (N .EQ. NPAGE) THEN
            WRITE(IOUNIT,9066) (WORKID(I), WAVEV(I),I=1+120*(N-1),INGRP)
         ELSE
            WRITE(IOUNIT,9066) (WORKID(I), WAVEV(I),I=1+120*(N-1),120*N)
         END IF

      END DO

 9058 FORMAT(43X,'*** SOURCE CONTRIBUTIONS FOR EVENT: ',
     &       A8,' ***'//1X,'---> AVE. PER.: ',I3,' HRS;',
     &       '  END DATE:  ',I8.8,';  LOCATION (XR,YR,ZELEV,ZFLAG):',
     &       4F11.2,' (M)'/)
 9068 FORMAT(1X,'GROUP ID: ',A8,1X,'OF SOURCES: ',10(A8,', ')/
     &       12x,12(A8,', ')/12x,12(A8,', '))
 9070 FORMAT(/3X,'*** GROUP VALUE = ',F14.5,' ***'/)
 9062 FORMAT(3(' SOURCE ID     CONTRIBUTION ',8X)/
     &       3(' ---------     ------------ ',8X))
 9066 FORMAT(3(2X,A8,4X,F13.5,9X:))

      RETURN
      END

      SUBROUTINE PRTDET
C***********************************************************************
C                 PRTDET Module of ISC2 Model - EVENT
C
C        PURPOSE: Print Out The Source Contribution Data
C                 To The Event
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, N, NSPP, NPAGE, IHR, INGRP
      REAL    :: WAVEV(NSRC), WHRVAL(24,NSRC)

C     Variable Initializations
      MODNAM = 'PRTDET'

C     Set Up The Printing Work Array
      INGRP = 0
      DO ISRC = 1, NUMSRC
         IF (IGROUP(ISRC,IDXEV(IEVENT)) .EQ. 1) THEN
            INGRP = INGRP + 1
            WORKID(INGRP) = SRCID(ISRC)
            WAVEV(INGRP) = EV_AVEVAL(ISRC)
            DO IHR = ISTAHR, IENDHR
               WHRVAL(IHR,INGRP) = HRVALS(IHR,ISRC)
            END DO
         END IF
      END DO

C     Set Number of Sources Per Page, NSPP
      NSPP = 8
C     Calculate Number of Pages for This Event (NSPP Sources per Page)
      NPAGE = 1 + INT((INGRP-1)/NSPP)
      DO N = 1, NPAGE
         CALL HEADER
         WRITE(IOUNIT,9058) EVNAME(IEVENT),EVAPER(IEVENT),
     &             EVDATE(IEVENT),AXR(IEVENT),AYR(IEVENT),
     &             AZELEV(IEVENT),AZFLAG(IEVENT)

         IF (N .EQ. NPAGE) THEN
C           Print Out The Values for the Last Page
            WRITE(IOUNIT,9068) EVGRP(IEVENT), (WORKID(I),
     &                                         I=1+NSPP*(N-1),INGRP)
            WRITE(IOUNIT,9066)

C           Print Out The Source Contributions for the Last Page
            DO I = ISTAHR, IENDHR
               WRITE(IOUNIT,9062) I,GRPVAL(I),(WHRVAL(I,J),
     &                                         J=1+NSPP*(N-1),INGRP)
            END DO
            WRITE(IOUNIT,9064) GRPAVE,(WAVEV(I),I=1+NSPP*(N-1),INGRP)
         ELSE
C           Print Out The Values for the Current Page
            WRITE(IOUNIT,9068) EVGRP(IEVENT), (WORKID(I),
     &                                         I=1+NSPP*(N-1),NSPP*N)
            WRITE(IOUNIT,9066)

C           Print Out The Source Contributions for the Current Page
            DO I = ISTAHR, IENDHR
               WRITE(IOUNIT,9062) I,GRPVAL(I),(WHRVAL(I,J),
     &                                         J=1+NSPP*(N-1),NSPP*N)
            END DO
            WRITE(IOUNIT,9064) GRPAVE,(WAVEV(I),I=1+NSPP*(N-1),NSPP*N)
         END IF

         IF (N .EQ. 1) THEN
C           Write Out the Meteorology Data
            NEWMET = .TRUE.
            DO IHOUR = ISTAHR, IENDHR
               AFV   = AAFVR(IHOUR)
               UREF  = AUREF(IHOUR)
               TA    = ATA(IHOUR)
               KST   = IKST(IHOUR)
               ZIRUR = AZI(1,IHOUR)
               ZIURB = AZI(2,IHOUR)
C              Retrieve Appropriate Mixing Height
               IF (RURAL) THEN
                  ZI = ZIRUR
               ELSE IF (URBAN) THEN
                  ZI = ZIURB
               END IF
               IF (METFRM .EQ. 'CARD') THEN
                  P    = APROF(IHOUR)
                  DTDZ = ADTDZ(IHOUR)
               END IF
C              Write Out The Meteorology Data
               CALL METDET
            END DO
         END IF
      END DO

 9058 FORMAT(43X,'*** SOURCE CONTRIBUTIONS FOR EVENT: ',
     &       A8,' ***'/1X,'---> AVE. PER.: ',I3,' HRS;',
     &       '  END DATE:  ',I8.8,';  LOCATION (XR,YR,ZELEV,ZFLAG):',
     &       4F11.2,' (M)')
 9068 FORMAT(1X,'HOUR GROUP:',A8,' OF',3X,A8,7(6X,A8:))
 9066 FORMAT(65('- '))
 9062 FORMAT(1X,I3,2X,9(1X,F13.5:))
 9064 FORMAT(65('- ')/1X,'AVER:',9(1X,F13.5:))

      RETURN
      END

      SUBROUTINE METDET
C***********************************************************************
C                 METDET Module of ISC2 Model - EVENT
C
C        PURPOSE: Print Out The Details Of The Meteorology Data
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Meteorology Input Data
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   PRTDET
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'METDET'

C     Meteorology Data Summary
      IF (NEWMET) THEN
         NEWMET = .FALSE.
         IF (METFRM .EQ. 'CARD') THEN
            WRITE(IOUNIT,9024)
         ELSE
            WRITE(IOUNIT,9025)
         END IF
      END IF
      IF (METFRM .EQ. 'CARD') THEN
         WRITE(IOUNIT,9031) IYEAR,IMONTH,IDAY,IHOUR,AFV,
     &         UREF,TA,KST,ZI,P,DTDZ
      ELSE
         WRITE(IOUNIT,9032) IYEAR,IMONTH,IDAY,IHOUR,AFV,
     &         UREF,TA,KST,ZI
      END IF

 9024 FORMAT(1X,'** METEOROLOGICAL DATA FOR THE EVENT **-->',1X,
     &       'YEAR',2X,'MONTH',2X,'DAY',2X,'HOUR',5X,'AFV',
     &       4X,'UREF',3X,'TEMP',4X,'KST',2X,'   ZI ',2X,
     &       'PROF ',2X,'DTDZ')
 9025 FORMAT(1X,'** METEOROLOGICAL DATA FOR THE EVENT **-->',1X,
     &       'YEAR',2X,'MONTH',2X,'DAY',2X,'HOUR',5X,'AFV',
     &       4X,'UREF',3X,'TEMP',4X,'KST',2X,'   ZI ')
 9031 FORMAT(45X,4(I2.2,4X),F6.1,1X,F6.2,1X,F6.1,1X,4X,I1,4X,F6.1,
     &       2(1X,F6.3))
 9032 FORMAT(45X,4(I2.2,4X),F6.1,1X,F6.2,1X,F6.1,1X,4X,I1,4X,F6.1)

      RETURN
      END

      SUBROUTINE EV_FLUSH
C***********************************************************************
C                 Module EV_FLUSH of ISC2 Model - EVENT
C
C        PURPOSE: To Flush AVEVAL and HRVALS Array
C
C        PROGRAMMER: Todd Hawes, Roger Brode and Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  AVEVAL, HRVALS
C
C        OUTPUTS: Flushed AVEVAL and HRVALS
C
C        CALLED FROM:  MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I

C     Variable Initializations
      MODNAM = 'EV_FLUSH'

C     Flush the Hourly Value
      DO I = 1, NUMTYP
         HRVAL(I) = 0.0
      END DO

C     Flush the Group Values
      GRPAVE = 0.0
      DO IHOUR = 1, NHR
         GRPVAL(IHOUR) = 0.0
      END DO

C     Flush the Block Average Calculations
      DO ISRC = 1, NUMSRC
         EV_AVEVAL(ISRC) = 0.0
         DO IHOUR = 1, NHR
            HRVALS(IHOUR,ISRC) = 0.0
         END DO
      END DO

      RETURN
      END
