      PROGRAM ISCST3
C***********************************************************************
C                    ISC3 Short Term Model - ISCST3
C                         (Version Dated 02035)
C
C               *** SEE ISCST3 MODEL CHANGE BULLETIN MCB#9 ***
C
C       ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS (SCRAM) WEBSITE
C
C                     http://www.epa.gov/scram001/
C
C========================================================================
C
C       This version (dated 02035) includes corrections for the following:
C       1) problem with allocating data storage for SHRDOW emission factor
C       option when all SHRDOW input records are in INCLUDED files;
C       2) potential problem with concatenated meteorological data files
C       when the header record has been removed between the individual
C       years; 3) adjustment to the area source optimizations under
C       the TOXICS option to address potential problems with the distance
C       at which the algorithm switches to a point source approximation
C       for very elongated area sources; and 4) addition of a non-default
C       option (HE>ZI) to address a potential problem that may occur for
C       cases when the receptor elevation is below the stack base elevation
C       and the mixing height (ZI), which is terrain-following, drops
C       below the plume centerline height (HE), which is horizontal.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       February 4, 2002
C
C       MODIFIED FROM:           ISCST3
C                         (Version Dated 00101)
C
C========================================================================
C
C       This version (dated 00101) includes modifications to explicitly
C       remove support of unformatted meteorological data files (the UNFORM
C       option on the ME INPUTFIL card).  This includes removal of obsolete
C       code and the implementation of proper error handling.  Users with
C       unformatted data are directed to the BINTOASC utility program
C       available from SCRAM to convert the unformatted data to an ASCII
C       format.  An new option for specifying variable emission rate
C       factors has also been added to allow for emissions that vary
C       by season, hour-of-day, and day-of-week.  This allows for the
C       user to specify different emission factors for Weekdays [M-F],
C       Saturdays, and Sundays, through use of the SHRDOW option on the
C       SO EMISFACT card.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       April 10, 2000
C
C       MODIFIED FROM:           ISCST3
C                         (Version Dated 99155)
C
C========================================================================
C
C       This version (99155) includes modifications to optimize the ISCST3
C       model for air toxics applications.  These include incorporation
C       of the Sampled Chronological Input Model (SCIM) option,
C       optimizations for the area source and dry depletion algorithms,
C       inclusion of gas dry deposition algorithms based on the draft
C       GDISCDFT model, and the option to output results by season and
C       hour of day (SEASONHR).  Several bugs have also been corrected,
C       including a potential problem with very small area sources (about
C       1 meter wide), a problem with the EVENTFIL output file when the
C       RECTABLE card is not specified, a potential problem with processing
C       of receptor elevations and flagpole heights for gridded networks
C       (GRIDCART or GRIDPOLR) if an input error occurs while setting up
C       the X-Y or Dist-Dir grid, an error in setting the minimum plume
C       touchdown distance in SUBROUTINE DEPCOR, deletion of an erroneous
C       statement in EVSET.FOR, a potential problem with the re-start
C       option (SAVEFILE/INITFILE keywords) for ANNUAL averages and
C       post-1997 PM10 processing, and declaration of MODNAM*12 as a
C       local character variable rather than in MODULE MAIN2.
C
C       This version (99155) also includes modifications to date
C       processing for Y2K compliance, including the use of date window
C       variables (ISTRT_WIND and ISTRT_CENT) and calculation of a
C       10-digit date variable (FULLDATE) with 4-digit year for date
C       comparisons.  These modifications make use of the year input on
C       the ME SURFDATA card to identify the starting century and the
C       starting 2-digit year for windowing.  All subsequent 2-digit years
C       are converted to 4-digit years internally based on the SURFDATA
C       input.  These modifications allow the ISCST3 model to be applied
C       for all dates up through the year 2147 without modifying the
C       format of the input meteorological data records (the limit of 2147
C       is due to the limit on the 10-digit full date as a 4-byte integer
C       variable).  The output formats for the 8-digit variable, KURDAT,
C       have also been changed to I8.8 to include leading zeros.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       June 4, 1999
C
C       MODIFIED FROM:           ISCST3
C                         (Version Dated 98356)
C
C========================================================================
C
C       This version (98356) includes a correction to an error with the
C       new post-1997 PM10 routines.  The error occured when only 24-hour
C       averages were calculated (no ANNUAL averages) for a multiple year
C       period.  The multi-year average of the H4H 24-Hour values was not
C       computed correctly in those cases.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       December 22, 1998
C
C       MODIFIED FROM:           ISCST3
C                         (Version Dated 98348)
C
C========================================================================
C
C       This version (98348) includes corrections to errors with the new
C       post-1997 PM10 routines involving leap years and the PLOTFILE
C       option, a correction to the 'NO ECHO' option, a correction to the
C       MAXTABLE option when MaxNum = 1, and other general code clean-up.
C       The user may now model either 24-HR or ANNUAL averages separately
C       for post-1997 PM10 analyses.  A coding error in SUBROUTINE DEPCOR
C       was investigated, but was not corrected at this time due to
C       additional anomalous behavior.  The PCALC2, VCALC2, ACALC2 and
C       OCALC2 subroutines used for EVENT processing have been removed,
C       and PCALC, VCALC, ACALC, and OCALC have been modified to perform
C       both "normal" and EVENT processing.  The SOINCL, REINCL, and EVINCL
C       routines have also been removed, and INCLUD has been modified to
C       call SOCARD, RECARD, and EVCARD instead.  The status message written
C       to the screen has been modified to include the year of data being
C       processed.  The file unit for the runstream input file (INUNIT) has
C       been changed from 5 to 7, and the file unit for the main printed
C       output file (IOUNIT) has been changed from 6 to 8.  This change in
C       file units, and much of the code clean-up, is to improve portability
C       of the model to the Lahey LF95 Fortran 95 Compiler (Version 5.0).
C       A new PARAMETER called ILEN_FLD has been added to MAIN1, which is
C       initially assigned a value of 80.  This PARAMETER is now used to
C       specify the maximum length of individual fields on the input
C       runstream image, and also to declare the length of all filename
C       and format variables.  The user may therefore specify file/pathnames
C       of up to 80 charaters for all input and output files.  The
C       integration routine for the area source integral has been replaced
C       by the same integration routine used for depletion.  Other
C       optimizations have also been made to the area source integration.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       December 14, 1998
C
C       MODIFIED FROM:           ISCST3
C                         (Version Dated 98226)
C
C========================================================================
C
C       This version (98226) includes modifications to the averaging of
C       short-term (24-hr) and annual averages for PM10 to meet the
C       requirements of the new National Ambient Air Quality Standards
C       (NAAQS) for PM10, promulgated by EPA in June 1997.  The new
C       method computes the average of the high-fourth-high 24-hour
C       averages over a multiple-year period.  Multiple-year annual
C       averages are determined by first computing the annual average for
C       each individual year, and then averaging over the multiple year
C       period.  This approach is now used for computing ANNUAL
C       concentrations for all cases.  As a result, the PERIOD and ANNUAL
C       average options are no longer equivalent for concentrations when
C       when multiple-year data files are used.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       August 14, 1998
C
C       MODIFIED FROM:          ISCST390
C                         (Version Dated 98093)
C
C========================================================================
C
C       This version (98093) includes a correction to a problem that occurred
C       with version dated 97365 when PERIOD or ANNUAL averages only
C       were calculated (i.e., no short term averages).  Under these
C       circumstances, the arrays to store the highest PERIOD/ANNUAL
C       averages were not properly allocated, resulting in a compiler
C       runtime error.  The modified version allocates the arrays using
C       a new PARAMETER called NHIANN, which is declared in MODULES.FOR
C       with a value of 10.  The summary table of PERIOD/ANNUAL averages
C       will therefore include the top 10 values for each source group.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       April 3, 1998
C
C       MODIFIED FROM:    (Version Dated 97365)
C
C========================================================================
C
C       This draft version of ISCST3 (dated 97365) has been converted to
C       Fortran 90.  It uses allocatable arrays for data storage;
C       incorporates the EVENT processing from the ISCEV3 model; incorporates
C       an INCLUDED keyword for the source, receptor and event pathways; and
C       incorporates an AREAPOLY and AREACIRC option for specifying
C       area sources.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       December 31, 1997
C
C       MODIFIED FROM:    (Version Dated 97363)
C
C========================================================================
C
C       This version (97363) includes a correction to the vertical virtual
C       distance calculation for rural conditions, a correction for area
C       sources when CONC, DDEP, and WDEP are calculated, a correction to SUB.
C       RSINIT, a correction to the output units label for ANNUAL average
C       deposition fluxes, a correction for cases when the flagpole receptor
C       height is above the mixing height, a correction to SUB. DEPCOR to
C       ensure unlimited mixing for stable conditions, a change of the
C       deposition reference height, ZRDEP, to 1.0m instead of 20.*Z0M,
C       a correction to the interpolation routine used in SUB. TGQA, and
C       minor cosmetic changes including corrections to format statements.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       December 29, 1997
C
C       MODIFIED FROM:    (Version Dated 96113)
C
C========================================================================
C
C       This version (96113) includes a correction to SUB. DEPCOR in
C       DEPFLUX.FOR, modifications to SETUP.FOR and OUTPUT.FOR for
C       compatibility with the ISCEV3 (EVENT) model, and a modification to
C       SUB. HRLOOP for a potential problem with the use of the STARTEND
C       keyword with non-sequential meteorological data sets.
C
C       MODIFIED BY:    Roger W. Brode
C                       PES, Inc.
C                       April 22, 1996
C
C       MODIFIED FROM:    (Version Dated 95250)
C
C========================================================================
C
C       This version of ISCST3 contains a revised AREA SOURCE algorithm
C       and revised DEPOSITION algorithm.  These Supplement C revisions had
C       been implemented independently, but are now merged in this version.
C       This version also includes a wet deposition algorithm, an open
C       pit source algorithm, and incorporates the COMPLEX1 algorithms for
C       receptor elevations above the release height.
C
C        PROGRAMMED BY: Roger W. Brode, Jayant A. Hardikar,
C                       and James O. Paumier
C                       Pacific Environmental Services, Inc.
C                       5001 S. Miami Blvd., Suite 300
C                       P.O. Box 12077
C                       Research Triangle Park, North Carolina  27709
C
C                       Deposition portions by:
C
C                       Yicheng Zhuang and David G. Strimaitis
C                       Sigma Research Corperation
C                       196 Baker Ave
C                       Concord, MA 01742
C
C        DATE:    September 7, 1995
C
C***********************************************************************
C
C        Version History of ISCST3
C
C          Date     Version    Alias      Developed From
C        --------   -------   -------    ---------------------
C        02-04-02   02035     ISCST3     ISCST3   (dated 00101)
C        04-10-00   00101     ISCST3     ISCST3   (dated 99155)
C        06-04-99   99155     ISCST3     ISCST3   (dated 99050)
C                                        Version 99050 was an internal draft
C        02-19-99   99050     ISCST3     ISCST3   (dated 98356)
C        12-22-98   98356     ISCST3     ISCST3   (dated 98348)
C        12-14-98   98348     ISCST3     ISCST3   (dated 98226)
C        08-14-98   98226     ISCST3     ISCST390 (dated 98093)
C        04-03-98   98093     ISCST390   ISCST390 (dated 97365)
C        12-31-97   97365     ISCST390   ISCST3   (dated 97363)
C        12-29-97   97363     ISCST3     ISCST3   (dated 96113)
C        04-22-96   96113     ISCST3     ISCST3   (dated 95250)
C        09-07-95   95250     ISCST3     ISCSTDFT (dated 94340)
C        12-06-94   94340     ISCSTDFT   DEPST    (dated 94067)
C                                        AREA-ST  (dated 93188), and
C                                        ISCST2   (dated 93109)
C        03-08-94   94067     DEPST      DEPST    (dated 94006)
C        01-06-94   94006     DEPST      ISCST2D  (dated 93046)
C        04-19-93   93109     ISCST2     ISCST2   (dated 92273)
C        02-15-93   93046     ISCST2D    ISCST2   (dated 92273)
C        09-29-92   92273     ISCST2     ISCST2   (dated 92062)
C        03-02-92   92062     ISCST2
C
C        ISCSTDFT was formerly known as ISC-COMPDEP.
C
C***********************************************************************
C
C                 MAIN Module of the ISC3 Short Term Model - ISCST3
C
C        PURPOSE: Controls Overall Flow and Processing of ISCST3 Model
C
C        PROGRAMMED BY: Roger W. Brode
C                       Pacific Environmental Services, Inc.
C                       5001 S. Miami Blvd., Suite 300
C                       P.O. Box 12077
C                       Research Triangle Park, North Carolina  27709
C
C        DATE: September 7, 1995
C
C        INPUTS:  Command Line Options
C
C        OUTPUTS: Model Results
C
C        The ISC3 models have been developed for the U.S. Environmental
C        Protection Agency under Contract No. 68D30032.  The PES Project
C        Manager is Roger W. Brode.  For instructions on running the model,
C        refer to the User's Guide for the Industrial Source Complex (ISC3)
C        Dispersion Models, Volume I - User Instructions (EPA-454/B-95-003a).
C
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      INTEGER :: IDSTAT
      SAVE

C     Variable Initializations
      MODNAM = 'MAIN'
      FATAL  = .FALSE.
      RUNERR = .FALSE.

C     Open the Temporary File for Error Messages Generated from the Program
      OPEN(UNIT=IERUNT,FILE='ERRMSG.TMP',STATUS='UNKNOWN')

C     Close and Delete The Error Message Temporary Files To Avoid Re-reading
C     Messages if File Already Exists and READ Precedes WRITE.
      CLOSE(IERUNT,STATUS='DELETE')

C     Re-Open the Temporary File for Error Messages Generated from the Program
      OPEN(UNIT=IERUNT,FILE='ERRMSG.TMP',STATUS='UNKNOWN')

C     Retrieve Input and Output File Names From Command Line,
C     ---   CALL GETCOM
      CALL GETCOM (' ISCST3 ',ILEN_FLD,INPFIL,OUTFIL)

C     Open Input and Output Files                           ---   CALL FILOPN
      CALL FILOPN

C     Preprocess Setup Information to Determine Data Storage Needs
      CALL PRESET

      IF (.NOT. EVONLY) THEN
C        OPEN The Temporary File to Store Events for EVENT File;
         OPEN(UNIT=ITEVUT,FILE='EVENT.TMP',STATUS='UNKNOWN')
C        Initialize the Event Counter
         IEVENT = 0
      END IF

C     Allocate SETUP Array Storage
      CALL ALLSETUP

C     Variable Initializations                              ---   CALL VARINI
      CALL VARINI

C     Process The Model Setup Information                   ---   CALL SETUP
      IF (EVONLY) THEN
         CALL EV_SETUP
      ELSE
         CALL SETUP
      END IF

C     Deallocate Temporary Storage
      DEALLOCATE  (IWRK2, STAT=IDSTAT)
      IF (IDSTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IDSTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF
      IF (.NOT. EVONLY) THEN
         DEALLOCATE  (ZETMP1,ZETMP2,ZFTMP1,ZFTMP2, STAT=IDSTAT)
         IF (IDSTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IDSTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         END IF
      END IF

C     Allocate Array Storage for Results
      CALL ALLRESULT

C     Determine Number of Setup Messages by Message Type    ---   CALL TERRST
      CALL TERRST

      IF (.NOT.RUN .OR. FATAL .OR. IWRN .GT. 0) THEN
C        Write Out Summary Of Setup Error/Message Stats     ---   CALL SUMTBL
         WRITE(IOUNIT,9111)
 9111    FORMAT(//2X,'*** Message Summary For ISC3 Model Setup ***'/)
         CALL SUMTBL
      END IF

      IF (FATAL) THEN
         WRITE(IOUNIT,9112)
 9112    FORMAT(/4X,'**************************************',
     &          /4X,'*** SETUP Finishes UN-successfully ***',
     &          /4X,'**************************************'/)
      ELSE
         WRITE(IOUNIT,9113)
 9113    FORMAT(/1X,'***********************************',
     &          /1X,'*** SETUP Finishes Successfully ***',
     &          /1X,'***********************************'/)
      END IF

C     Print Summary of the Input Data                       ---   CALL INPSUM
      CALL INPSUM

      IF (.NOT.FATAL .AND. RUN .AND. EVONLY) THEN
C        No Fatal Errors in Setup and RUN Option Selected
         NUMTYP = 1

C        Process The Data For Each Event                    ---   CALL EVLOOP
         CALL EVLOOP

      ELSE IF (.NOT.FATAL .AND. RUN .AND. .NOT.EVONLY) THEN

C        Reinitialize Results Arrays With Zeroes            ---   CALL RESINI
         CALL RESINI

         IF (RSTINP) THEN
C           Initialize Results Arrays from Re-start File    ---   CALL RSINIT
            CALL RSINIT
         END IF

C        Process The Hourly Meteorological Data             ---   CALL HRLOOP
         CALL HRLOOP

         IF ( (ANNUAL .OR. PM10AVE) .AND. .NOT.RUNERR) THEN
C           Compute averages of the high-fourth-high 24-hr and annual values
            IF (NUMYRS .GT. 0) THEN
               DO IGRP = 1, NUMGRP
                  DO IREC = 1, NUMREC
                     IF (PM10AVE) THEN
                        SUMH4H(IREC,IGRP) = SUMH4H(IREC,IGRP) / NUMYRS
                     END IF
                     IF (ANNUAL) THEN
                        DO ITYP = 1, NUMTYP
                           ANNVAL(IREC,IGRP,ITYP) =
     &                                 SUMANN(IREC,IGRP,ITYP) / NUMYRS
                        END DO
                     END IF
                  END DO
               END DO
            ELSE
C              Write Error Message: Number of Years = 0.
               CALL ERRHDL(PATH,MODNAM,'E','480','NUMYRS=0')
               RUNERR = .TRUE.
            END IF
            IF (NREMAIN .NE. 0) THEN
C              Write Warning Message: Met Data Remains After End of Last Year
               WRITE(DUMMY,'(I8)') NREMAIN
               CALL ERRHDL(PATH,MODNAM,'W','485',DUMMY)
            END IF
         END IF

         IF ((PERIOD.OR.ANNUAL) .AND. (.NOT. RUNERR)) THEN
C           PERIOD Average Selected and No Runtime/Meteorology Errors
            IF (CONC .AND. PERIOD) THEN
C              Calculate Period Average Concentrations      ---   CALL PERAVE
               CALL PERAVE
            END IF
            DO ITYP = 1, NUMTYP
C              Select Highest PERIOD Values by Source Group ---   CALL HIPER
               CALL HIPER
            END DO
            IF (ANPOST) THEN
C              Write PERIOD/ANNUAL Results to Post File     ---   CALL PSTANN
               CALL PSTANN
            END IF
            IF (ANPLOT) THEN
C              Write PERIOD/ANNUAL Results to Plot File     ---   CALL PLTANN
               CALL PLTANN
            END IF
         END IF

         IF (SEASONHR .AND. .NOT.RUNERR) THEN
            IF (CONC) THEN
               CALL SHAVE
            END IF
         END IF

         IF (PLFILE .AND. (.NOT. RUNERR)) THEN
C           Write Short Term High Values to Plot File       ---   CALL PLOTFL
            CALL PLOTFL
         END IF

         IF (.NOT. RUNERR) THEN
C           Print Out Model Results                         ---   CALL OUTPUT
            CALL OUTPUT
         END IF

      END IF

      CALL HEADER
      WRITE(IOUNIT,9114)
 9114 FORMAT(/1X,'*** Message Summary : ISCST3 Model Execution ***'/)
C     Determine Number of Errors/Messages by Message Type   ---   CALL TERRST
      CALL TERRST
C     Write Summary of Message Stats for Model Execution    ---   CALL SUMTBL
      CALL SUMTBL

      IF (FATAL .OR. RUNERR) THEN
         WRITE(IOUNIT,9115)
 9115    FORMAT(/4X,'***************************************',
     &          /4X,'*** ISCST3 Finishes UN-successfully ***',
     &          /4X,'***************************************'/)
      ELSE
         WRITE(IOUNIT,9116)
 9116    FORMAT(/4X,'************************************',
     &          /4X,'*** ISCST3 Finishes Successfully ***',
     &          /4X,'************************************'/)
      END IF

      IF (ERRLST) THEN
C        OPEN and Write Out Permanent Error Message File    ---   CALL MSGWRT
         OPEN(UNIT=IERWRT,FILE=MSGFIL,STATUS='UNKNOWN',
     &        FORM='FORMATTED')
         CALL MSGWRT
         CLOSE(IERWRT)
      END IF

C     Close and Delete The Error Message And EVENT Temporary Files
      CLOSE(IERUNT,STATUS='DELETE')
      CLOSE(ITEVUT,STATUS='DELETE')

      STOP
      END

      SUBROUTINE HRLOOP
C***********************************************************************
C                 HRLOOP Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Controls Main Calculation Loop Through
C                 Hourly Meteorological Data
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:  To incorporate modifications to date processing
C                   for Y2K compliance, including use of date window
C                   variables (ISTRT_WIND and ISTRT_CENT) and calculation
C                   of 10-digit date variable (FULLDATE) with 4-digit
C                   year for date comparisons.
C                   Also modified to include SCIM option.
C                   R.W. Brode, PES, Inc., 5/12/99
C
C        MODIFIED:  To correct problems with the post-1997 PM10
C                   calculations involving leap years, and to
C                   add the year to the status message.
C                   R.W. Brode, PES, Inc. - 12/2/98
C
C        MODIFIED:  Changes to accommodate the post-1997 PM10
C                   calculations for average H4H 24-hour averages
C                   and ANNUAL averages.
C                   R.W. Brode, PES, Inc. - 8/14/98
C
C        MODIFIED:  Minor change to logic of IF block to correct
C                   potential problem with STARTEND keyword for
C                   non-sequential meteorological data sets.
C                   R.W. Brode, PES, Inc. - 4/22/96
C
C        MODIFIED:  To Include TOXXFILE Option - 9/29/92
C
C        INPUTS:  Source, Receptor and Setup Options
C
C        OUTPUTS: Update Hourly Results
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      INTEGER :: IEND_DAY, I, J, K, L, M
      REAL    :: RDUM
      SAVE

C     Variable Initializations
      MODNAM = 'HRLOOP'
      EOF = .FALSE.
      KURDAT   = 0
      FULLDATE = 0

C     Begin Hourly LOOP
      DO WHILE (FULLDATE.LT.IEDATE .AND. .NOT.EOF)
C        Retrieve One Hour of Meteorology                   ---   CALL METEXT
         CALL METEXT
         
C*----   ISCSTM Modification: allow for hourly emissions - jah 11/3/94                           
C*       Process Hourly Emissions from File
C*       Begin Source Loop
         DO ISRC = 1, NUMSRC
            IF (QFLAG(ISRC) .EQ. 'HOURLY') THEN
C*             Retrieve Source Parameters for This Hour     ---   CALL HRQEXT
               CALL HRQEXT(ISRC)
            END IF
         END DO
C*       End Source Loop
C*----
C*----   ISCSTM Modification: allow for NOCHKD option - jah 11/2/94                           
C*       Check for IHOUR = 1 and Write Update to the Screen For PC Version
         IF (IHOUR .EQ. 1 .AND. .NOT.NOCHKD) THEN
C*          Write Out Update to the Screen by Julian Day
            WRITE(*,909) JDAY, IYR
 909        FORMAT('+','Now Processing Data For Day No. ',I4,' of ',I4)
         ELSE IF (NOCHKD) THEN
C*          Write Out Update to the Screen by Hour
            WRITE(*,910) KURDAT
 910        FORMAT('+','Now Processing Data For     ',I8.8)
         END IF
C*----
C*#
         IF (SCIM .AND. .NOT.EOF) THEN
            SCIMHR = .FALSE.
            WETHR  = .FALSE.

C           User has specified SCIM option.  Check for whether current
C           hour is to be sampled, and whether to write sampled met
C           data to output file.

C           Keep track of total no. of hours.
C           Also, keep track of dry & wet, and calm & missing hours
C           Note:  Under SCIM option, IANHRS/IANCLM/IANMSG (see below) pertain
C                  to no. of hours sampled.
            NSKIPTOT = NSKIPTOT + 1
            IF (PRATE.GT.0.0) THEN
               NSKIPWET = NSKIPWET + 1
            ELSE
               NSKIPDRY = NSKIPDRY + 1
            ENDIF

            IF (CLMHR .AND. CLMPRO) THEN
C              Check for Calm Hr & Processing and Increment Counters
               IF (PRATE.GT.0.0) THEN
                  NSWETCLM = NSWETCLM + 1
               ELSE
                  NSDRYCLM = NSDRYCLM + 1
               ENDIF
            ELSE IF (MSGHR .AND. MSGPRO) THEN
C              Check for Missing Hour & Processing and Increment Counters
               IF (PRATE.GT.0.0) THEN
                  NSWETMSG = NSWETMSG + 1
               ELSE
                  NSDRYMSG = NSDRYMSG + 1
               ENDIF
            END IF

            IF( ILINE .LE. 24 .AND. IHOUR .EQ. NREGSTART )THEN
C              Current hour is to be sampled - first SCIM'd hour.
               IFIRSTHR = ILINE
               SCIMHR   = .TRUE.
               IF (WETSCIM .AND. PRATE.GT.0.0) THEN
                  NWETHR = NWETHR + 1
                  IF (FIRSTWET .AND. NWETHR.EQ.NWETSTART) THEN
                     FIRSTWET = .FALSE.
                     WETHR    = .TRUE.
                     NWETHR   = 0
                  ELSEIF (NWETHR .EQ. NWETINT) THEN
                     WETHR    = .TRUE.
                     NWETHR   = 0
                  ENDIF
               ENDIF
            ELSE IF( ILINE .GT. NREGSTART .AND.
     &               MOD( ILINE-IFIRSTHR, NREGINT ) .EQ. 0 )THEN
C              Current hour is to be sampled - SCIM'd hour
               SCIMHR   = .TRUE.
               IF (WETSCIM .AND. PRATE.GT.0.0) THEN
                  NWETHR = NWETHR + 1
                  IF (FIRSTWET .AND. NWETHR.EQ.NWETSTART) THEN
                     FIRSTWET = .FALSE.
                     WETHR    = .TRUE.
                     NWETHR   = 0
                  ELSEIF (NWETHR .EQ. NWETINT) THEN
                     WETHR    = .TRUE.
                     NWETHR   = 0
                  ENDIF
               ENDIF
            ELSEIF (WETSCIM .AND. PRATE.GT.0.0 .AND.
     &                            (DEPOS.OR.WDEP.OR.WDPLETE)) THEN
               NWETHR = NWETHR + 1
               IF (FIRSTWET .AND. NWETHR.EQ.NWETSTART) THEN
C                 Current hour is to be sampled
                  FIRSTWET = .FALSE.
                  WETHR    = .TRUE.
                  NWETHR   = 0
               ELSEIF (NWETHR .EQ. NWETINT) THEN
C                 Current hour is to be sampled
                  WETHR    = .TRUE.
                  NWETHR   = 0
               ELSE
C                 Current hour is NOT to be sampled. Check for end of year first.
                  CALL CHK_ENDYR
                  CYCLE
               ENDIF
            ELSE
C              Current hour is NOT to be sampled. Check for end of year first.
               CALL CHK_ENDYR
               CYCLE
            END IF

            IF (SCIMOUT) THEN
C              Write sampled meteorology to SCIM'd met data file
               CALL METSUM
            END IF
         END IF

         IF (FULLDATE.GT.ISDATE .AND. FULLDATE.LE.IEDATE .AND.
     &       IPROC(JDAY).EQ.1 .AND.
     &               .NOT.EOF .AND. .NOT.RUNERR) THEN

            IF (CLMHR .AND. CLMPRO) THEN
C              Check for Calm Hr & Processing and Increment Counters
               DO IAVE = 1, NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
                  NUMCLM(IAVE) = NUMCLM(IAVE) + 1
               END DO
               IF (PERIOD .OR. ANNUAL) THEN
                  IF (.NOT.SCIM .OR. (SCIM.AND.SCIMHR)) THEN
                     IANHRS = IANHRS + 1
                     IANCLM = IANCLM + 1
                  ENDIF
                  IF (SCIM .AND. WETHR) THEN
                     IANWET  = IANWET  + 1
                     IWETCLM = IWETCLM + 1
                  ENDIF
               END IF
               IF (SEASONHR) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
                  NSEACM(ISEAS,IHOUR) = NSEACM(ISEAS,IHOUR) + 1
               END IF
            ELSE IF (MSGHR .AND. MSGPRO) THEN
C              Check for Missing Hour & Processing and Increment Counters
               DO IAVE = 1, NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
                  NUMMSG(IAVE) = NUMMSG(IAVE) + 1
               END DO
               IF (PERIOD .OR. ANNUAL) THEN
                  IF (.NOT.SCIM .OR. (SCIM.AND.SCIMHR)) THEN
                     IANHRS = IANHRS + 1
                     IANMSG = IANMSG + 1
                  ENDIF
                  IF (SCIM .AND. WETHR) THEN
                     IANWET  = IANWET  + 1
                     IWETMSG = IWETMSG + 1
                  ENDIF
               END IF
               IF (SEASONHR) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
                  NSEACM(ISEAS,IHOUR) = NSEACM(ISEAS,IHOUR) + 1
               END IF
            ELSE IF (ZI .LE. 0) THEN
C              Write Out The Informational Message & Increment Counters
               WRITE(DUMMY,'(I8.8)') KURDAT
               CALL ERRHDL(PATH,MODNAM,'I','470',DUMMY)
               DO IAVE = 1, NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
               END DO
               IF (PERIOD .OR. ANNUAL) THEN
                  IF (.NOT.SCIM .OR. (SCIM.AND.SCIMHR)) THEN
                     IANHRS = IANHRS + 1
                  ENDIF
                  IF (SCIM .AND. WETHR) THEN
                     IANWET  = IANWET  + 1
                  ENDIF
               END IF
               IF (SEASONHR) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
               END IF
            ELSE
C              Set CALCS Flag, Increment Counters & Calculate HRVAL
               CALCS = .TRUE.
               DO IAVE = 1, NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
               END DO
               IF (PERIOD .OR. ANNUAL) THEN
                  IF (.NOT.SCIM .OR. (SCIM.AND.SCIMHR)) THEN
                     IANHRS = IANHRS + 1
                  ENDIF
                  IF (SCIM .AND. WETHR) THEN
                     IANWET  = IANWET  + 1
                  ENDIF
               END IF
               IF (SEASONHR) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
               END IF

C              Time/Date Marker for DEBUG Output
               IF (DEBUG) THEN
                  WRITE(IOUNIT,*)
                  WRITE(IOUNIT,*) '--------------------------------',
     &                            '--------------------'
                  WRITE(IOUNIT,*) '---  JDAY, IHOUR =  ',JDAY,IHOUR
                  WRITE(IOUNIT,*) '--------------------------------',
     &                            '--------------------'
               END IF

C              Calculate CONC or DEPOS Values               ---   CALL CALC
               CALL CALC
            END IF

C           Beging Averaging Period LOOP
            DO IAVE = 1, NUMAVE
C              Check for End of Averaging Period
               IF (MOD(IHOUR,KAVE(IAVE)).EQ.0 .OR.
     &            (KAVE(IAVE).EQ.720 .AND. ENDMON)) THEN
                  IF (CONC) THEN
C                    Calculate Applicable Averages          ---   CALL AVER
                     CALL AVER
                  END IF
C                 Update High Value Arrays                  ---   CALL HIVALS
                  CALL HIVALS
                  IF (DAYTAB .AND. IDYTAB(IAVE).EQ.1) THEN
                     DO ITYP = 1, NUMTYP
C                       Print Out Daily Value Tables        ---   CALL PRTDAY
                        CALL PRTDAY
                     END DO
                  END IF
                  IF (MXFILE) THEN
C                    Write Max Values (>Thresh) to File     ---   CALL MAXFIL
                     CALL MAXFIL
                  END IF
                  IF (PPFILE) THEN
C                    Write Values to Postprocessor File     ---   CALL POSTFL
                     CALL POSTFL
                  END IF
                  IF (TXFILE) THEN
C                    Write Values to TOXXFILE File (9/29/92) ---  CALL TOXXFL
                     CALL TOXXFL
                  END IF
C                 Flush Block Average Values in AVEVAL Array for This IAVE
                  DO ITYP = 1, NUMTYP
                     DO IGRP = 1, NUMGRP
                        DO IREC = 1, NUMREC
                           AVEVAL(IREC,IGRP,IAVE,ITYP) = 0.0
                        END DO
                     END DO
                  END DO
               END IF
            END  DO
C           End Averaging Period LOOP

            IF (RSTSAV .AND. IHOUR.EQ.24) THEN
               NDAYS = NDAYS + 1
               IF (NDAYS .EQ. INCRST) THEN
C                 Save Results to File for Later Re-start   ---   CALL RSDUMP
                  CALL RSDUMP
                  NDAYS = 0
               END IF
            END IF

C           Flush HRVAL Variable
            DO ITYP = 1, NUMTYP
               HRVAL(ITYP)  = 0.0
               HRVALD(ITYP) = 0.0
            END DO

         END IF

C        Check for end of year of data for post-1997 PM10 processing
         IF ((PM10AVE .OR. ANNUAL) .AND. FULLDATE.GT.ISDATE .AND.
     &                                               .NOT. EOF) THEN

            CALL CHK_ENDYR

         END IF

C        Reset CALCS and ENDMON Flags
         CALCS  = .FALSE.
         ENDMON = .FALSE.

      END DO
C     End Hourly LOOP

C     Check for TOXXFILE Option, Fill Buffer and Dump to File - 9/29/92
      IF (TXFILE) THEN
         IDUM = 0
         RDUM = 0.0
         DO IAVE = 1, NUMAVE
            IF (ITOXFL(IAVE) .EQ. 1) THEN
C              Fill Rest of Buffer With Zeroes and Write to TOXXFILE
               DO I = IPAIR+1, NPAIR
                  IDCONC(IAVE,I) = IDUM
                  TXCONC(IAVE,I) = RDUM
               END DO
               WRITE(ITXUNT(IAVE)) (IDCONC(IAVE,I),I=1,NPAIR)
               WRITE(ITXUNT(IAVE)) (TXCONC(IAVE,I),I=1,NPAIR)
               CLOSE(ITXUNT(IAVE))
            END IF
         END DO
      END IF

C     Write Out Update to the Screen for PC Version
      WRITE(*,919)
 919  FORMAT('+','Now Processing Output Options               ')

      RETURN
      END

      SUBROUTINE JULIAN(INYR,INMN,INDY,JDY)
C***********************************************************************
C                 JULIAN Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE:    CONVERT YR/MN/DY DATE TO JULIAN DAY (1-366),
C                    INCLUDES TEST FOR 100 AND 400 YEAR CORRECTIONS TO
C                    HANDLE 4 DIGIT YEARS BEYOND 2099 AND BEFORE 1901
C                    (WILL WORK WITH 2 DIGIT YR FOR PERIOD 1901-2099)
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:     YEAR,  INYR (2 OR 4 DIGIT)
C                    MONTH, INMN
C                    DAY,   INDY
C
C        OUTPUT:     JULIAN DAY,  JDY (1-366)
C
C        CALLED FROM:   DAYRNG
C
C        ERROR HANDLING:   Checks for Invalid Month or Day
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: NDAY(12), IDYMAX(12)
      INTEGER :: INYR, INMN, INDY, JDY

C     Variable Initializations
      DATA NDAY/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA IDYMAX/31,29,31,30,31,30,31,31,30,31,30,31/
      MODNAM = 'JULIAN'
      JDY = 0

C     Check for 2-digit Year Input and WRITE Warning Message
      IF (INYR .LT. 100) THEN
C        WRITE Warning Message  ! Routine Will Work for Years 1901-2099
         CALL ERRHDL(PATH,MODNAM,'W','360',KEYWRD)
      END IF

C     Check for Invalid Month or Day
      IF (INMN.LT.1 .OR. INMN.GT.12) THEN
C        WRITE Error Message    ! Invalid Month
         CALL ERRHDL(PATH,MODNAM,'E','203','MONTH')
         RUNERR = .TRUE.
         GO TO 999
      ELSE IF (INDY .GT. IDYMAX(INMN)) THEN
C        WRITE Error Message    ! Invalid Day
         CALL ERRHDL(PATH,MODNAM,'E','203','DAY')
         RUNERR = .TRUE.
         GO TO 999
      END IF

C     Determine JULIAN Day Number; For Non-Leap Year First
      IF ((MOD(INYR,4) .NE. 0) .OR.
     &    (MOD(INYR,100) .EQ. 0 .AND. MOD(INYR,400) .NE. 0)) THEN
C        Not a Leap Year
         IF (INMN.NE.2 .OR. (INMN.EQ.2 .AND. INDY.LE.28)) THEN
            JDY = INDY + NDAY(INMN)
         ELSE
C           WRITE Error Message    ! Invalid Date; 2/29 in a Non-Leap Year
            WRITE(DUMMY,'("YR= ",I4)') INYR
            CALL ERRHDL(PATH,MODNAM,'E','370',DUMMY)
            JDY = 60
            RUNERR = .TRUE.
         END IF
      ELSE
C        Leap Year
         JDY = INDY + NDAY(INMN)
         IF (INMN .GT. 2)  JDY = JDY + 1
      END IF

 999  CONTINUE

      RETURN
      END

      SUBROUTINE GREGOR(INYR,INMN,JDY,IDY)
C***********************************************************************
C                 GREGOR Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE:    CONVERT JULIAN DAY (1-366) TO DAY OF MONTH,
C                    INCLUDES TEST FOR 100 AND 400 YEAR CORRECTIONS TO
C                    HANDLE 4 DIGIT YEARS BEYOND 2099 AND BEFORE 1901
C                    (WILL WORK WITH 2 DIGIT YR FOR PERIOD 1901-2099)
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:     YEAR,       INYR (2 OR 4 DIGIT)
C                    MONTH,      INMN
C                    JULIAN DAY, JDY (1-366)
C
C        OUTPUT:     DAY OF MONTH, IDY
C
C        CALLED FROM:   METEXT
C
C        ERROR HANDLING:   Checks for Invalid Month or Day
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: NDAY(12)
      INTEGER :: INYR, INMN, IDY, JDY

C     Variable Initializations
      DATA NDAY/0,31,59,90,120,151,181,212,243,273,304,334/
      MODNAM = 'GREGOR'

C     Check for Invalid Month or Julian Day
      IF (INMN.LT.1 .OR. INMN.GT.12) THEN
C        WRITE Error Message    ! Invalid Month
         CALL ERRHDL(PATH,MODNAM,'E','203','MONTH')
         GO TO 999
      ELSE IF (JDY.LT.1 .OR. JDY.GT.366) THEN
C        WRITE Error Message    ! Invalid Julian Day
         CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
         GO TO 999
      END IF

C     Determine Day-of-Month Number; For Non-Leap Year First
      IF ((MOD(INYR,4) .NE. 0) .OR.
     &    (MOD(INYR,100).EQ.0 .AND. MOD(INYR,400).NE.0)) THEN
C        Not a Leap Year
         IDY = JDY - NDAY(INMN)
      ELSE
C        Leap Year
         IDY = JDY - NDAY(INMN)
         IF (INMN .GT. 2)  IDY = IDY - 1
      END IF

 999  CONTINUE

      RETURN
      END
      
      SUBROUTINE HRQEXT (IS)
C***********************************************************************
C*                  HRQEXT Module of AERMOD
C* 
C*         PURPOSE: To Assign Hourly Source Parameters
C* 
C*         PROGRAMMER:  Jayant Hardikar, Roger Brode
C* 
C*         DATE:    September 15, 1993
C* 
C*         INPUTS:  Variable QFLAG and Current Source Number Being Processed
C* 
C*         OUTPUTS: Source Arrays
C*          
C*         MODIFIED:  REMOVED THE 'POINT' SOURCE CONDITION, SO IT APPLIES 
C*                    TO ALL SOURCE TYPES, EXCEPT SAVING THE TEMP & VEL
C* 
C*         CALLED FROM:  HRLOOP
C************************************************************************
C*
C*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, IS, IHYEAR, IHMON, IHDAY, IHHOUR
      CHARACTER RDFRM*20

      CHARACTER*8 HRSOID

C*    Variable Initializations
      MODNAM = 'HRQEXT'
C*
C*    READ Record to Buffers, A80 and 80A1
C*    Length of ISTRG is Set in PARAMETER Statement in MAIN1
C     Setup READ format and ECHO format for runstream record,
C     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE(RDFRM,9100) ISTRG, ISTRG
 9100 FORMAT('(A',I3.3,',T1,',I3.3,'A1)')
      READ (IHREMI,RDFRM,ERR=99,END=999) RUNST1, (RUNST(I), I=1, ISTRG)
C*
C*    Convert Lower Case to Upper Case Letters              ---   CALL LWRUPR
      CALL LWRUPR
C*      
C*    Define Fields on Card                                 ---   CALL DEFINE
      CALL DEFINE
C*
C*    Get the Contents of the Fields                        ---   CALL GETFLD
      CALL GETFLD
C*
C*    Check for number of fields - error if less than 7.
      IF (IFC .LT. 7) THEN
         CALL ERRHDL(PATH,MODNAM,'E','201','HOUREMIS')
         RUNERR = .TRUE.
         GO TO 999
      END IF
C*         
C*    Assign the Feilds to Local Varables and Check The Numerical Field
C*
      CALL STONUM(FIELD(3), ILEN_FLD, FNUM, IMIT)
      IHYEAR = NINT(FNUM)
      IF (IMIT .NE. 1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      END IF

      CALL STONUM(FIELD(4), ILEN_FLD, FNUM, IMIT)
      IHMON = NINT(FNUM)
      IF (IMIT .NE. 1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      END IF

      CALL STONUM(FIELD(5), ILEN_FLD, FNUM, IMIT)
      IHDAY = NINT(FNUM)
      IF (IMIT .NE. 1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      END IF

      CALL STONUM(FIELD(6), ILEN_FLD, FNUM, IMIT)
      IHHOUR = NINT(FNUM)
      IF (IMIT .NE. 1) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      END IF

      HRSOID = FIELD(7)

      IF (IFC .GE. 8) THEN
         CALL STONUM(FIELD(8), ILEN_FLD, HRQS, IMIT)
         IF (IMIT .NE. 1) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         END IF
      ELSE
C*       Emission rate is missing - set to zero
         HRQS = 0.0
      END IF

      IF (IFC.EQ.10) THEN
C*       Also Assign Exit Temperature and Exit Velocity
         CALL STONUM(FIELD(9), ILEN_FLD, HRTS, IMIT)
         IF (IMIT .NE. 1) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         END IF

         CALL STONUM(FIELD(10), ILEN_FLD, HRVS, IMIT)
         IF (IMIT .NE. 1) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         END IF
      ELSE
C*       Some missing parameters - assign zeros to all
         HRTS = 0.0
         HRVS = 0.0
      ENDIF

C*    Check for Date and Time Consistency ; If Failed - Abort Program
      KURHRQ = IHYEAR*1000000 + IHMON*10000 + IHDAY*100 + IHHOUR
      IF (KURDAT .NE. KURHRQ) THEN
C*       WRITE Error Message - Date mismatch
         WRITE(DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'E','455',DUMMY)
         RUNERR = .TRUE.
      END IF


C*    Check for Source ID Consistency ; If Failed - Abort Program
      IF ( HRSOID .NE. SRCID(IS) ) THEN
         WRITE(DUMMY,'(A8)') SRCID(IS)
         CALL ERRHDL(PATH,MODNAM,'E','342',SRCID(IS))
         RUNERR = .TRUE.
      ENDIF

C*    Assign the Hourly Emission Parameters to the Stack Variables
      AQS(IS) = HRQS

      IF (SRCTYP(IS) .EQ. 'POINT') THEN
         ATS(IS) = HRTS
         AVS(IS) = HRVS
      ENDIF


C*    Perform QA Error Checking on Source Parameters
C*

      IF (SRCTYP(IS) .EQ. 'POINT') THEN
         IF (ATS(IS) .EQ. 0.0) THEN
C*          Set Temperature to Small Negative Value for Ambient Releases
            ATS(IS) = -1.0E-5
         ELSE IF (ATS(IS) .GT. 2000.0) THEN
C*          WRITE Informational Message:  Exit Temp. > 2000K
            CALL ERRHDL(PATH,MODNAM,'I','320','HRTS')
         END IF

         IF (AVS(IS) .LT. 0.0) THEN
C*          WRITE Informational Message:  Negative or Zero Exit Velocity
            CALL ERRHDL(PATH,MODNAM,'I','325','HRVS')
C*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSE IF (AVS(IS) .LT. 1.0E-5) THEN
C*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSE IF (AVS(IS) .GT. 50.0) THEN
C*          WRITE Informational Message:  Exit Velocity > 50.0 m/s
            CALL ERRHDL(PATH,MODNAM,'I','320','HRVS')
         END IF
      ENDIF

      GO TO 999

C*    Write Error Message for Error Reading Hourly Emissions File
 99   CALL ERRHDL(PATH,MODNAM,'E','510','HOUREMIS')
      RUNERR = .TRUE.

999   RETURN
      END


      SUBROUTINE ERRHDL(PATHWY,MODNAM,INERTP,INERCD,INPMSG)
C***********************************************************************
C                 ERRHDL Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: A General Error Handling Procedure
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Code, Occur Locations
C
C        OUTPUTS: Error Message, Error Statistics..etc.
C
C        CALLED FROM:  (This Is An Utility Programm)
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE

      SAVE
      INTEGER :: I
      CHARACTER ERRMG1*50, PATHWY*2, INERTP*1, INERCD*3, ICODE*3,
     &          INPMSG*(*), MODNAM*(*), TMPMOD*6, TMPMSG*8
      LOGICAL FIND

C     Variable Initializations
      IERROR = IERROR + 1
      FIND = .FALSE.
      I = 1

C     Check for Occurrence of 'E' Error Type, and Set FATAL Switch
      IF (INERTP .EQ. 'E') THEN
         FATAL = .TRUE.
         NFATAL = NFATAL + 1
         IF (NFATAL .EQ. 999) THEN
C           Number Of Fatal Errors Has Reached Limit of 999
            ERRMG1 = 'Number of Fatal Errors Has Reached Limit of 999'
            TMPMOD = 'ERRHDL'
            ICODE  = '999'
            TMPMSG = ' '
            WRITE(IERUNT,1111) PATHWY,INERTP,ICODE,ILINE,TMPMOD,
     &                         ERRMG1,TMPMSG
            GO TO 999
         ELSE IF (NFATAL .GT. 999) THEN
C           Skip Any More Error WRITEs
            GO TO 999
         END IF
      END IF

C     Go To Match The Error Massage
      DO WHILE (.NOT.FIND .AND. I.LE.IERRN)
         IF (INERCD .EQ. ERRCOD(I)) THEN
            ERRMG1 = ERRMSG(I)
            FIND = .TRUE.
         END IF
         I = I + 1
      END DO

      IF (.NOT. FIND) THEN
         WRITE(ERRMG1,1001)
 1001    FORMAT('SYSTEM ERROR: MESSAGE NOT FOUND FOR THIS NUMBER!')
      END IF

C     Write Out The Error Message
      WRITE(IERUNT,1111) PATHWY,INERTP,INERCD,ILINE,MODNAM(1:6),ERRMG1,
     &                   INPMSG
 1111 FORMAT(A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)

 999  RETURN
      END

      SUBROUTINE TERRST
C***********************************************************************
C                 TERRST Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: To Determine Total Error/Message Statistics
C
C        PROGRAMMER:  Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Message Temporary File
C
C        OUTPUTS: Total Number of Messages by Message Type
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IERRLN
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8, INPFLD*3

C     Variable Initialization
      MODNAM = 'TERRST'
      IFTL = 0
      IWRN = 0
      INFO = 0
      ICLM = 0
      IMSG = 0
      IHEZ = 0
      EOF = .FALSE.

C     Rewind the Temporary Error/Message File
      REWIND IERUNT

      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                     MODNAM,ERRMG1,ERRMG2

C        Sort Error Group And Find The Index
         INPFLD = ERRCD
         CALL STONUM(INPFLD,3,FNUM,IMIT)

         IF (ERRTP .EQ. 'E') THEN
            IFTL = IFTL + 1
         ELSE IF (ERRTP .EQ. 'W') THEN
            IWRN = IWRN + 1
         ELSE IF (ERRTP .EQ. 'I') THEN
            INFO = INFO + 1
            IF (NINT(FNUM) .EQ. 440) THEN
C              Message for Calm Hour, Increment Calm Counter
               ICLM = ICLM + 1
            END IF
            IF (NINT(FNUM) .EQ. 460) THEN
C              Message for Missing Hour, Increment Missing Hour Counter
               IMSG = IMSG + 1
            END IF
            IF (NINT(FNUM) .EQ. 283) THEN
C              Message for HE > ZI, Increment Counter
               IHEZ = IHEZ + 1
            END IF
         END IF

         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

 1116 FORMAT(A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)

C     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
C     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

      SUBROUTINE SUMTBL
C***********************************************************************
C                 SUMTBL Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: To Print Out The Error Summary Table
C
C        PROGRAMMER:  Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Error Message Temporary File
C
C        OUTPUTS: Summary Of Errors
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: J, IERRLN
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8

C     Variable Initialization
      MODNAM = 'SUMTBL'

C     Write Out The Total Error Statistics
      WRITE(IOUNIT,*) ' --------- Summary of Total Messages --------'
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,9014) IFTL
 9014 FORMAT(' A Total of   ',I10,' Fatal Error Message(s)')
      WRITE(IOUNIT,9015) IWRN
 9015 FORMAT(' A Total of   ',I10,' Warning Message(s)')
      WRITE(IOUNIT,9016) INFO
 9016 FORMAT(' A Total of   ',I10,' Informational Message(s)')
      IF (ICLM .GT. 0) THEN
         WRITE(IOUNIT,9017) ICLM
 9017    FORMAT(/,' A Total of   ',I10,' Calm Hours Identified')
      END IF
      IF (IMSG .GT. 0) THEN
         WRITE(IOUNIT,9018) IMSG
 9018    FORMAT(/,' A Total of   ',I10,' Missing Hours Identified')
      END IF
      IF (IHEZ .GT. 0) THEN
         WRITE(IOUNIT,9019) IHEZ
 9019    FORMAT(/,' A Total of   ',I10,' Cases Identified with HE > ZI')
      END IF
      WRITE(IOUNIT,*) ' '

C     Write Out All The Fatal Error Messages
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,*) '   ******** FATAL ERROR MESSAGES ******** '
      REWIND IERUNT
      EOF = .FALSE.
      J = 0
      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                     MODNAM,ERRMG1,ERRMG2
         IF (ERRTP .EQ. 'E') THEN
            J = J + 1
            WRITE(IOUNIT,1117) PATH,ERRTP,ERRCD,IERRLN,MODNAM(1:6),
     &                         ERRMG1,ERRMG2
         END IF
         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

C     If No Fatal Error Messages, Then Write 'NONE'
      IF (J .EQ. 0) THEN
         WRITE(IOUNIT,*) '              ***  NONE  ***         '
         WRITE(IOUNIT,*) ' '
      END IF

C     Write Out All The Warning Messages
      WRITE(IOUNIT,*) ' '
      WRITE(IOUNIT,*) '   ********   WARNING MESSAGES   ******** '
      REWIND IERUNT
      EOF = .FALSE.
      J = 0
      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=999,ERR=9999) PATH,ERRTP,ERRCD,IERRLN,
     &                                      MODNAM,ERRMG1,ERRMG2
         IF (ERRTP .EQ. 'W') THEN
            J = J + 1
            IF (J .LE. 999) THEN
               WRITE(IOUNIT,1117) PATH,ERRTP,ERRCD,IERRLN,MODNAM(1:6),
     &                            ERRMG1,ERRMG2
            ELSE
               WRITE(IOUNIT,*) 'More Than 999 Warning Messages Found. ',
     &                         ' See ERRORFIL Output for the Remainder.'
               EOF = .TRUE.
            END IF
         END IF
         GO TO 111
 999     EOF = .TRUE.
 111     CONTINUE
      END DO

C     If No Warning Messages, Then Write 'NONE'
      IF (J .EQ. 0) THEN
         WRITE(IOUNIT,*) '              ***  NONE  ***        '
         WRITE(IOUNIT,*) ' '
      END IF

 1116 FORMAT(A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)
 1117 FORMAT(1X,A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)

C     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
C     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

      SUBROUTINE MSGWRT
C***********************************************************************
C                 MSGWRT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: To Print Out The Error Summary Table
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Error Message File
C
C        OUTPUTS: The Error Message File
C
C        CALLED FROM:  This is A Utility Program
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IERRLN
      CHARACTER ERRTP*1, ERRCD*3, ERRMG1*50, ERRMG2*8

C     Variable Initialization
      MODNAM = 'MSGWRT'

C     Write Out The Header Of The Message File
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,*) '   ************ Error Message List *************'
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,*) '   PW     --- Pathway                           '
      WRITE(IERWRT,*) '   Code   --- Error Type + Error Code           '
      WRITE(IERWRT,*) '   L#     --- The Line Number Where Error Occurs'
      WRITE(IERWRT,*) '   ModNam --- Module Name In Which Error Occurs '
      WRITE(IERWRT,*) '   Hints  --- Hints For The Possible Solution   '
      WRITE(IERWRT,*) '   *********************************************'
      WRITE(IERWRT,*) ' '
      WRITE(IERWRT,1114)
      WRITE(IERWRT,1115)
 1114 FORMAT('PW CODE   L#  MODNAM ',18X,'ERROR MESSAGES',20X,'HINTS')
 1115 FORMAT('-- ---- ----- ------ ',50('-'),' --------')
      WRITE(IERWRT,*) ' '
      REWIND IERUNT
      EOF = .FALSE.

      DO WHILE (.NOT. EOF)
         READ(IERUNT,1116,END=99,ERR=999) PATH,ERRTP,ERRCD,IERRLN,
     &                                    MODNAM,ERRMG1,ERRMG2
         WRITE(IERWRT,1117) PATH,ERRTP,ERRCD,IERRLN,
     &                      MODNAM(1:6),ERRMG1,ERRMG2
         GO TO 11
 99      EOF = .TRUE.
 11      CONTINUE
      END DO

 1116 FORMAT(A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)
 1117 FORMAT(A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)

      GO TO 1000

C     WRITE Error Message: Error Reading Temp Error Message File
 999  CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')

 1000 RETURN
      END

C----------------------------------------------------------------------
C     Courtesy: Jay Sandhu
C               email: jsandhu@esri.com
C
C
C Please cite David H. Douglas, COLLECTED ALGORITHMS, Cambridge MA:
C Harvard Laboratory for Computer Graphics, 1974
C
C This is my reinvention buster.
C 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974
C
C>>>PNPY
C     .................................................................
C
C        SUBROUTINE PNPOLY
C
C        PURPOSE
C           TO DETERMINE WHETHER A POINT IS INSIDE A POLYGON
C
C        USAGE
C           CALL PNPOLY (PX, PY, X, Y, N, INOUT )
C
C        DESCRIPTION OF THE PARAMETERS
C           PX      - X-COORDINATE OF POINT IN QUESTION.
C           PY      - Y-COORDINATE OF POINT IN QUESTION.
C           X       - N LONG VECTOR CONTAINING X-COORDINATES OF
C                     VERTICES OF POLYGON.
C           Y       - N LONG VECTOR CONTAINING Y-COORDINATES OF
C                     VERTICES OF POLYGON.
C           N       - NUMBER OF VERTICES IN THE POLYGON.
C           INOUT   - THE SIGNAL RETURNED:
C                     -1 IF THE POINT IS OUTSIDE OF THE POLYGON,
C                      0 IF THE POINT IS ON AN EDGE OR AT A VERTEX,
C                      1 IF THE POINT IS INSIDE OF THE POLYGON.
C
C        REMARKS
C           THE VERTICES MAY BE LISTED IN CLOCKWISE OR ANTICLOCKWISE
C           ORDER.  FOR THIS SUBROUTINE A POINT IS CONSIDERED INSIDE
C           THE POLYGON IF IT IS LOCATED IN THE ENCLOSED AREA DEFINED
C           BY THE LINE FORMING THE POLYGON.
C           THE INPUT POLYGON MAY BE A COMPOUND POLYGON CONSISTING
C           OF SEVERAL SEPARATE SUBPOLYGONS. IF SO, THE FIRST VERTEX
C           OF EACH SUBPOLYGON MUST BE REPEATED, AND WHEN CALCULATING
C           N, THESE FIRST VERTICES MUST BE COUNTED TWICE.
C           INOUT IS THE ONLY PARAMETER WHOSE VALUE IS CHANGED.
C           PNPOLY CAN HANDLE ANY NUMBER OF VERTICES IN THE POLYGON.
C           WRITTEN BY RANDOLPH FRANKLIN, UNIVERSITY OF OTTAWA, 6/72.
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           A VERTICAL SEMI-INFINITE LINE IS DRAWN UP FROM THE POINT
C           IN QUESTION. IF IT CROSSES THE POLYGON AN ODD NUMBER OF
C           TIMES, THE POINT IS INSIDE THE POLYGON.
C
C     .................................................................
C
      SUBROUTINE PNPOLY (PX,PY,X,Y,N,INOUT)

      IMPLICIT NONE

      INTEGER I, J, N, INOUT
      REAL X(N), Y(N), XI, YI, XJ, YJ, PX, PY
      LOGICAL IX, IY, JX, JY, EOR

C     EXCLUSIVE OR STATEMENT FUNCTION.
      EOR(IX,IY)=(IX.OR.IY).AND..NOT.(IX.AND.IY)

      INOUT=-1

      DO I=1,N
         XI=X(I)-PX
         YI=Y(I)-PY
C        CHECK WHETHER THE POINT IN QUESTION IS AT THIS VERTEX.
         IF (XI.EQ.0.0.AND.YI.EQ.0.0) THEN
            INOUT=0
            RETURN
         END IF
C        J IS NEXT VERTEX NUMBER OF POLYGON.
         J=1+MOD(I,N)
         XJ=X(J)-PX
         YJ=Y(J)-PY
C        IS THIS LINE OF 0 LENGTH ?
         IF (XI.EQ.XJ.AND.YI.EQ.YJ) CYCLE
         IX=XI.GE.0.0
         IY=YI.GE.0.0
         JX=XJ.GE.0.0
         JY=YJ.GE.0.0
C        CHECK WHETHER (PX,PY) IS ON VERTICAL SIDE OF POLYGON.
         IF (XI.EQ.0.0.AND.XJ.EQ.0.0.AND.EOR(IY,JY)) THEN
            INOUT=0
            RETURN
         END IF
C        CHECK WHETHER (PX,PY) IS ON HORIZONTAL SIDE OF POLYGON.
         IF (YI.EQ.0.0.AND.YJ.EQ.0.0.AND.EOR(IX,JX)) THEN
            INOUT=0
            RETURN
         END IF
C        CHECK WHETHER BOTH ENDS OF THIS SIDE ARE COMPLETELY 1) TO RIGHT
C        OF, 2) TO LEFT OF, OR 3) BELOW (PX,PY).
         IF (.NOT.((IY.OR.JY).AND.EOR(IX,JX))) CYCLE
C        DOES THIS SIDE OBVIOUSLY CROSS LINE RISING VERTICALLY FROM (PX,PY)
         IF (.NOT.(IY.AND.JY.AND.EOR(IX,JX))) THEN
            IF ((YI*XJ-XI*YJ)/(XJ-XI) .LT. 0.0) THEN
               CYCLE
            ELSE IF ((YI*XJ-XI*YJ)/(XJ-XI) .EQ. 0.0) THEN
               INOUT=0
               RETURN
            ELSE
               INOUT=-INOUT
            END IF
         ELSE
            INOUT=-INOUT
         END IF

      END DO

      RETURN
      END

      SUBROUTINE ALLSETUP
C***********************************************************************
C                 ALLSETUP Module
C
C        PURPOSE: Allocate Array Storage for SETUP
C
C        PROGRAMMER: Roger Brode, PES, Inc.
C
C        DATE:    September 21, 1996
C
C        INPUTS:
C
C
C        OUTPUTS:
C
C        CALLED FROM:  MAIN
C
C        ERROR HANDLING:   Checks for error allocating arrays
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      INTEGER :: IASTAT
      SAVE

C     Variable Initializations
      MODNAM = 'ALLSET'

      ALLOCATE  (KAVE(NAVE), CHRAVE(NAVE), CHIDEP(6,NTYP), V(NTYP),
     &           VDRY(NTYP),
     &           OUTTYP(NTYP),STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (AXS(NSRC), AYS(NSRC), AZS(NSRC), AQS(NSRC),
     &           AHS(NSRC), ATS(NSRC), AVS(NSRC), ADS(NSRC),
     &           ASYINI(NSRC), ASZINI(NSRC),
     &           ADSBH(NSEC,NSRC), ADSBW(NSEC,NSRC),
     &           IDSWAK(NSEC,NSRC), INPD(NSRC),
     &           QFACT(NQF,NSRC), EMIFAC(NTYP), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (APDIAM(NPDMAX,NSRC), APHI(NPDMAX,NSRC),
     &           APDENS(NPDMAX,NSRC), ASC(NPDMAX,NSRC),
     &           AVGRAV(NPDMAX,NSRC), ATSTOP(NPDMAX,NSRC),
     &           APSLIQ(NPDMAX,NSRC), APSICE(NPDMAX,NSRC),
     &           AGSCAV(NWET,NSRC), EFRAC(NPDMAX), QPART(NPDMAX),
     &           STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (PDIAM(NPDMAX), PHI(NPDMAX), PDENS(NPDMAX),
     &           SC(NPDMAX), VGRAV(NPDMAX), TSTOP(NPDMAX),
     &           VDEP(NPDMAX),
     &           WQCOR(NPDMAX), WQCORC(NPDMAX),
     &           SZCOR(NPDMAX), SZCORC(NPDMAX), SZMIN(NPDMAX),
     &           DQCOR(NPDMAX), PCORZR(NPDMAX), PCORZD(NPDMAX),
     &           DQCORC(NPDMAX), PCORZRC(NPDMAX), PCORZDC(NPDMAX),
     &           PSCAV(NPDMAX,NWET), GSCAV(NWET),
     &           PSCVRT(NPDMAX), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (IGROUP(NSRC,NGRP), SRCID(NSRC), SRCTYP(NSRC),
     &           SOPCRD(NSRC), SOGAS(NSRC),
     &           GRPID(NGRP), QFLAG(NSRC), EMILBL(NTYP),
     &           OUTLBL(NTYP), PERLBL(NTYP),
     &           AXINIT(NSRC), AYINIT(NSRC), AANGLE(NSRC),
     &           AXVERT(NVMAX,NSRC), AYVERT(NVMAX,NSRC),
     &           AALPHA(NSRC), APDEFF(NSRC), AVOLUM(NSRC),
     &           RADIUS(NSRC), NVERTS(NSRC), AXCNTR(NSRC),
     &           AYCNTR(NSRC),
     &           pdiff(NSRC), alphas(NSRC), react(NSRC),
     &           rm(NSRC), henry(NSRC), rgg(NSRC), rgw1(NSRC),
     &           rcut(NSRC), rd1(NSRC), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      IF (EVONLY) THEN
         ALLOCATE  (EV_HRQS(NSRC,NHR), EV_HRTS(NSRC,NHR),
     &              EV_HRVS(NSRC,NHR), STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         END IF
      END IF

      IF (.NOT. EVONLY) THEN
         ALLOCATE  (AXR(NREC), AYR(NREC), AZELEV(NREC),
     &              AZFLAG(NREC), IREF(NREC),
     &              NETID(NREC), RECTYP(NREC), NTID(NNET),
     &              NTTYP(NNET),
     &              XCOORD(IXM,NNET), YCOORD(IYM,NNET),
     &              XORIG(NNET), YORIG(NNET),
     &              NETSTA(NNET), NETEND(NNET),
     &              NUMXPT(NNET), NUMYPT(NNET), STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         END IF
      END IF

      IF (EVONLY) THEN
         ALLOCATE  (EVAPER(NEVE), EVDATE(NEVE), EVJDAY(NEVE),
     &              IDXEV(NEVE), AXR(NEVE), AYR(NEVE), AZELEV(NEVE),
     &              AZFLAG(NEVE), EVNAME(NEVE), EVGRP(NEVE),
     &              STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         END IF
      END IF

      ALLOCATE  (NHIAVE(NVAL,NAVE), MAXAVE(NAVE), IMXVAL(NAVE),
     &           IDYTAB(NAVE), MAXFLE(NGRP,NAVE),
     &           IPSTFL(NGRP,NAVE), IPLTFL(NVAL,NGRP,NAVE),
     &           IANPST(NGRP), IANPLT(NGRP), INHI(NAVE),
     &           ITOXFL(NAVE),
     &           THRESH(NGRP,NAVE), TOXTHR(NAVE),
     &           IMXUNT(NGRP,NAVE), IPSUNT(NGRP,NAVE),
     &           IPSFRM(NGRP,NAVE), IPLUNT(NVAL,NGRP,NAVE),
     &           IAPUNT(NGRP), IANFRM(NGRP), IPPUNT(NGRP),
     &           ITXUNT(NAVE),
     &           THRFIL(NGRP,NAVE), PSTFIL(NGRP,NAVE),
     &           PLTFIL(NVAL,NGRP,NAVE), ANNPST(NGRP),
     &           ANNPLT(NGRP), TOXFIL(NAVE),
     &           ISEAHR(NGRP), SEAHRS(NGRP), ISHUNT(NGRP), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (IDCONC(NAVE,NPAIR), TXCONC(NAVE,NPAIR), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      ALLOCATE  (WORKID(NSRC), IWRK2(NSRC,10), STAT=IASTAT)
      IF (IASTAT .NE. 0) THEN
         WRITE(DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      END IF

      IF (.NOT. EVONLY) THEN
         ALLOCATE  (ZETMP1(NREC), ZETMP2(NREC),
     &              ZFTMP1(NREC), ZFTMP2(NREC), STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         END IF
      END IF

      RETURN
      END

      SUBROUTINE ALLRESULT
C***********************************************************************
C                 ALLRESULT Module
C
C        PURPOSE: Allocate Array Storage for Results
C
C        PROGRAMMER: Roger Brode, PES, Inc.
C
C        DATE:    September 21, 1996
C
C        MODIFIED:   Changed parameter for allocating the number of
C                    high annual/period averages from NHIVAL to NHIANN.
C                    R.W. Brode, PES, Inc.,  4/3/98
C
C        INPUTS:
C
C
C        OUTPUTS:
C
C        CALLED FROM:  MAIN
C
C        ERROR HANDLING:   Checks for error allocating arrays
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      INTEGER :: IASTAT
      SAVE

C     Variable Initializations
      MODNAM = 'ALLRESULT'

      ALLOCATE  (HRVAL(NUMTYP), SIMPL(NUMTYP), COMPL(NUMTYP),
     &           HRVALD(NUMTYP), SIMPLD(NUMTYP), COMPLD(NUMTYP),
     &           HRVALJD(NUMTYP,NPDMAX),
     &           SIMPLJD(NUMTYP,NPDMAX),
     &           COMPLJD(NUMTYP,NPDMAX),
     &           STAT=IASTAT)

      IF (.NOT. EVONLY) THEN
         ALLOCATE  (AVEVAL(NUMREC,NUMGRP,NUMAVE,NUMTYP),
     &              HIVALU(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              HMAX(NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              HMLOC(NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              HMDATE(NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              NHIDAT(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         END IF

         ALLOCATE  (ANNVAL(NUMREC,NUMGRP,NUMTYP),
     &              ANNVALD(NUMREC,NUMGRP,NUMTYP),
     &              ANNVALW(NUMREC,NUMGRP,NUMTYP),
     &              AMXVAL(NHIANN,NUMGRP,NUMTYP),
     &              IMXLOC(NHIANN,NUMGRP,NUMTYP),
     &              ANNVALJD(NUMREC,NUMGRP,NUMTYP,NPDMAX),
     &              ANNVALJW(NUMREC,NUMGRP,NUMTYP,NPDMAX),
     &              RMXVAL(NMXVAL,NUMGRP,NUMAVE,NUMTYP),
     &              MXDATE(NMXVAL,NUMGRP,NUMAVE,NUMTYP),
     &              MXLOCA(NMXVAL,NUMGRP,NUMAVE,NUMTYP),
     &              NUMHRS(NUMAVE), NUMCLM(NUMAVE), NUMMSG(NUMAVE),
     &              SHVALS(NUMREC,NUMGRP,4,24,NUMTYP),
     &              STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         END IF

         ALLOCATE  (HCLMSG(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),
     &              MCLMSG(NMXVAL,NUMGRP,NUMAVE,NUMTYP),
     &              HMCLM(NHIVAL,NUMGRP,NUMAVE,NUMTYP),STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         END IF

         ALLOCATE  (SUMANN(NUMREC,NUMGRP,NUMTYP), SUMH4H(NUMREC,NUMGRP),
     &              MXPMVAL(NMXPM,NUMGRP), MXPMLOC(NMXPM,NUMGRP),
     &              STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         END IF
      END IF

      IF (EVONLY) THEN
         ALLOCATE  (EV_AVEVAL(NSRC), HRVALS(NHR,NSRC), GRPVAL(NHR),
     &              STAT=IASTAT)
         IF (IASTAT .NE. 0) THEN
            WRITE(DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         END IF
      END IF


      RETURN
      END

      SUBROUTINE GETCOM (MODEL,LENGTH,INPFIL,OUTFIL)
C***********************************************************************
C     
C        ADAPTED FROM PCCODE Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Controls Retrieving Input and Output File Names From
C                 the Command Line for PCs
C
C        PROGRAMMER: Roger Brode
C        
C        DATE:    March 2, 1992
C
C        MODIFIED:   To use ILEN_FLD (passed in as LENGTH) to define
C                    the length of the INPFIL and OUTFIL variables,
C                    and to specify length of the command line as
C                    a PARAMETER, initially set to 150.  Also set up
C                    conditional compilation statements (commented out)
C                    to facilitate compilation by DEC Visual Fortran.
C                    R.W. Brode, PES, Inc. - 12/2/98
C
C        MODIFIED:   Jayant Hardikar, PES, Inc.
C                    - Length of command line for Lahey version changed
C                      from 80 to 120 characters - 4/19/93
C                    - Adapted for DEPMET/PMERGE - 7/29/94
C
C        INPUTS:  Command Line
C
C        OUTPUTS: Input Runstream File Name
C                 Output Print File Name
C
C        CALLED FROM:   MAIN
C***********************************************************************
C
C     Variable Declarations
CDVFC     For compilation with DEC Visual Fortran Compiler, delete the string
CDVFC     'CDVF' from columns 1-4 in this subroutine (using a null replacement).
CDVFC     This will allow the DEC compiler to conditionally compile the
CDVFC     appropriate code for retrieving the command line arguments.
CDVF!DEC$ DEFINE DVF
CDVF!DEC$ IF DEFINED (DVF)
CDVF      USE DFLIB
CDVF!DEC$ ENDIF
      IMPLICIT NONE

      INTEGER LENGTH
      CHARACTER (LEN=LENGTH) :: INPFIL, OUTFIL
      CHARACTER (LEN=8)      :: MODEL
CDVF!DEC$ IF DEFINED (DVF)
CDVFC     Declare 2-Byte Integer for Field Number of Command Line Argument
CDVF      INTEGER*2 IARG, IFCNT, ISTAT
CDVF!DEC$ ELSEIF DEFINED (LAHEY)
C     Declare the COMLIN Variable to Hold Contents of Command Line for Lahey
      INTEGER , PARAMETER :: LENCL = 150
      CHARACTER (LEN=LENCL) :: COMLIN
      INTEGER LOCB(LENCL), LOCE(LENCL), I, IFCNT
      LOGICAL INFLD

      COMLIN = ' '
CDVF!DEC$ ENDIF
CDVF
CDVF!DEC$ IF DEFINED (DVF)
CDVFC************************************************************DVF START
CDVFC     Use Microsoft/DEC Functions NARGS and GETARG To Retrieve
CDVFC     Contents of Command Line
CDVF      IFCNT = NARGS()
CDVFC     IFCNT Is The Number Of Arguments on Command Line Including Program
CDVF      IF (IFCNT .NE. 3) THEN
CDVFC        Error on Command Line.  Write Error Message and STOP
CDVF         WRITE(*,660) MODEL
CDVF         STOP
CDVF      ELSE
CDVFC        Retrieve First Argument as Input File Name
CDVF         IARG = 1
CDVF         CALL GETARG(IARG,INPFIL,ISTAT)
CDVFC        Retrieve Second Argument as Output File Name
CDVF         IARG = 2
CDVF         CALL GETARG(IARG,OUTFIL,ISTAT)
CDVF      END IF
CDVFC************************************************************DVF STOP
CDVF
CDVF!DEC$ ELSEIF DEFINED (LAHEY)
C************************************************************LAHEY START
C     Use Lahey Function GETCL To Retrieve Contents of Command Line.
C     Retrieve Input and Output File Names From the COMLIN Variable.
      CALL GETCL(COMLIN)
      INFLD = .FALSE.
      IFCNT = 0
      DO I = 1, LENCL
         IF (.NOT.INFLD .AND. COMLIN(I:I) .NE. ' ') THEN
            INFLD = .TRUE.
            IFCNT = IFCNT + 1
            LOCB(IFCNT) = I
         ELSE IF (INFLD .AND. COMLIN(I:I) .EQ. ' ') THEN
            INFLD = .FALSE.
            LOCE(IFCNT) = I - 1
         END IF
      END DO
      IF (IFCNT .NE. 2) THEN
C        Error on Command Line.  Write Error Message and STOP
         WRITE(*,660) MODEL
         STOP
      END IF
      INPFIL = COMLIN(LOCB(1):LOCE(1))
      OUTFIL = COMLIN(LOCB(2):LOCE(2))
C************************************************************LAHEY STOP

CDVF!DEC$ ENDIF

  660 FORMAT (' COMMAND LINE ERROR: ',A8,' input_file output_file')

      RETURN
      END


      SUBROUTINE DATIME ( DCALL, TCALL )
C***********************************************************************
C                 DATIME Module
C
C        PURPOSE: Obtain the system date and time
C
C        PROGRAMMER: Jim Paumier, PES, Inc.
C
C        DATE:    April 15, 1994
C
C        MODIFIED:   Uses Fortran 90 DATE_AND_TIME routine.
C                    R.W. Brode, PES, 8/14/98
C
C        INPUTS:  none
C
C        OUTPUTS: Date and time in character format
C
C        CALLED FROM:  RUNTIME
C***********************************************************************
C
C     Variable Declarations
      IMPLICIT NONE

      CHARACTER DCALL*8, TCALL*8
      CHARACTER CDATE*8, CTIME*10, CZONE*5
      INTEGER  :: IDATETIME(8)
      INTEGER  :: IPTYR, IPTMON, IPTDAY, IPTHR, IPTMIN, IPTSEC

      DCALL = ' '
      TCALL = ' '

C     Call date and time routine
      CALL DATE_AND_TIME (CDATE, CTIME, CZONE, IDATETIME)

C     Convert year to two digits and store array variables
      IPTYR  = IDATETIME(1) - 100 * INT(IDATETIME(1)/100)
      IPTMON = IDATETIME(2)
      IPTDAY = IDATETIME(3)
      IPTHR  = IDATETIME(5)
      IPTMIN = IDATETIME(6)
      IPTSEC = IDATETIME(7)

C     Write Date and Time to Character Variables, DCALL & TCALL
      WRITE(DCALL, '(2(I2.2,"/"),I2.2)' ) IPTMON, IPTDAY, IPTYR
      WRITE(TCALL, '(2(I2.2,":"),I2.2)' ) IPTHR, IPTMIN, IPTSEC

      RETURN
      END

      SUBROUTINE FILOPN
C***********************************************************************
C                 FILOPN Module
C
C        PURPOSE: Obtain the system date and time
C
C        PROGRAMMER: Roger Brode, PES, Inc.
C
C        DATE:    December 6, 1994
C
C        INPUTS:  Input filename, INPFIL
C                 Output filename, OUTFIL
C
C        OUTPUTS: Openned files
C
C        CALLED FROM:  HEADER
C
C        ERROR HANDLING:   Checks errors openning files
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     OPEN Input Runstream File, Unit INUNIT=7
      DUMMY = 'RUN-STRM'
      OPEN (UNIT=INUNIT,FILE=INPFIL,ERR=99,STATUS='OLD')

C     OPEN Print Output File, Unit IOUNIT=8
      DUMMY = 'OUTPUT'
CLF90 The CARRIAGECONTROL specifier in the following statement is a
CLF90 non-standard Lahey language extension (also supported by DEC VF),
CLF90 and may need to be removed for portability of the code.
      OPEN (UNIT=IOUNIT,FILE=OUTFIL,CARRIAGECONTROL='FORTRAN',
     &      ERR=99,STATUS='UNKNOWN')

C     Write Out Update to the Screen
      WRITE(*,909)
 909  FORMAT('+','Now Processing SETUP Information')

      GO TO 1000

C     WRITE Error Message:  Error Opening File
 99   CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)

C     Check for Error Opening Runstream File and STOP
      IF (DUMMY .EQ. 'RUN-STRM') THEN
         WRITE(*,919)
 919     FORMAT('+','Error Opening Runstream Input File!  Aborting.')
         STOP
      END IF

 1000 CONTINUE

      RETURN
      END

      SUBROUTINE HEADER
C***********************************************************************
C                 HEADER Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Control Page Feed and Header Information for
C                 Printed File Output
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    September 28, 1993
C
C        MODIFIED:   Replace DEPLETE parameter for plume depletion option
C                    with DDPLETE and WDPLETE in the list of model options
C                    for Wet & Dry depletion.
C                    D. Strimaitis, SRC - 11/8/93
C
C        MODIFIED:   Header modified for draft version of model with new
C                    area source and deposition algorithms - 9/28/93
C
C        MODIFIED:   To add DEPLETE parameter for plume depletion option
C                    to the list of model options
C                    D. Strimaitis, SRC - 2/15/93
C
C        INPUTS:  Page Number from COMMON
C
C        OUTPUTS: Page Feed and Header
C
C        CALLED FROM:  (This Is An Utility Program)
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I
      CHARACTER RUNDAT*8, RUNTIM*8

C     Variable Initializations
      MODNAM = 'HEADER'

C     Increment Page Number Counter
      IPAGE = IPAGE + 1

C     Retrieve Date and Time Variables for First Call
      IF (IPAGE .EQ. 1) THEN
         RUNDAT = ' '
         RUNTIM = ' '

C        Get Date and Time using system-specific functions  ---   CALL DATIME
         CALL DATIME (RUNDAT, RUNTIM)

      END IF

C     Write Header to Printed Output File
      WRITE(IOUNIT,9028) VERSN, TITLE1, RUNDAT
      WRITE(IOUNIT,9029) TITLE2, RUNTIM
      WRITE(IOUNIT,9030) IPAGE
      WRITE(IOUNIT,9040) (MODOPS(I),I=1,19)

 9028 FORMAT('1',' *** ISCST3 - VERSION ',A5,' ***',4X,'*** ',A68,
     &       ' ***',8X,A8)
 9029 FORMAT(36X,'*** ',A68,' ***',8X,A8)
 9030 FORMAT(1X,'**MODELOPTs:',107X,'PAGE',I4)
 9040 FORMAT(6(1X,A5),13(1X,A6)/)

      RETURN
      END

      SUBROUTINE PRESET
C***********************************************************************
C                 PRESET Module of ISC Short Term Model - ISCST
C
C        PURPOSE: Preprocesses SETUP Information to Determine Data
C                 Storage Requirements
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        MODIFIED:   To check for NO ECHO in the input file.
C                    R.W. Brode, PES, Inc. - 12/2/98
C
C        INPUTS:  Input Runstream File
C
C        OUTPUTS: Array Sizes
C
C        CALLED FROM:   MAIN
C***********************************************************************
C
C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, ISPRD, IEPRD
      LOGICAL NOPATH, NOKEY
      CHARACTER RDFRM*20
      CHARACTER LPRD*8, HPRD*8, NCHR1(10)*8, NCHR2(10)*4
      LOGICAL RMARK
      CHARACTER INPFLD*2, PATHWY(8)*2
      INTERFACE
         SUBROUTINE EXPATH(INPFLD,PATHWY,IPN,NOPATH)
            CHARACTER (LEN=2), INTENT(IN) :: INPFLD
            CHARACTER (LEN=2), INTENT(IN), DIMENSION(:) :: PATHWY
            INTEGER, INTENT(IN) :: IPN
            LOGICAL, INTENT(OUT) :: NOPATH
         END SUBROUTINE EXPATH
      END INTERFACE

C     Variable Initializations
      DATA (NCHR1(I),I=1,10) /'FIRST','SECOND','THIRD','FOURTH',
     &                        'FIFTH','SIXTH','SEVENTH','EIGHTH',
     &                        'NINTH','TENTH'/
      DATA (NCHR2(I),I=1,10) /'1ST','2ND','3RD','4TH','5TH','6TH',
     &                        '7TH','8TH','9TH','10TH'/

C     Variable Initializations
      MODNAM = 'PRESET'
      PREVGRPID = '        '
      EOF = .FALSE.
      NPDMAX = 1
      NQF    = 1
      ILINE  = 0

      IPNUM  = 0
      IPPNUM = 0
C     Counters for the Receptor Groups
      IREC = 0
      ISTA = .FALSE.
      IEND = .FALSE.
      IBND =  36
      IBELEV = 36
      NEWID = .TRUE.

C     Setup READ format and ECHO format for runstream record,
C     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE(RDFRM,9100) ISTRG, ISTRG
 9100 FORMAT('(A',I3.3,',T1,',I3.3,'A1)')

C     LOOP Through Input Runstream Records
      DO WHILE (.NOT. EOF)

C        Increment the Line Counter
         ILINE = ILINE + 1

C        READ Record to Buffers, as A80 and 80A1 for ISTRG = 80.
C        Length of ISTRG is Set in PARAMETER Statement in MAIN1
         READ (INUNIT,RDFRM,END=999) RUNST1, (RUNST(I), I = 1, ISTRG)

C        Convert Lower Case to Upper Case Letters           ---   CALL LWRUPR
         CALL LWRUPR

C        Define Fields on Card                              ---   CALL DEFINE
         CALL DEFINE

C        Get the Contents of the Fields                     ---   CALL GETFLD
         CALL GETFLD

C        If Blank Line, Then CYCLE to Next Card
         IF (BLINE) GO TO 11

C        Check for 'NO ECHO' In First Two Fields
         IF (FIELD(1) .EQ. 'NO' .AND. FIELD(2) .EQ. 'ECHO') THEN
C           Skip record with NO ECHO during PRESET stage of processing
            GO TO 11
         END IF

C        Extract Pathway ID From Field 1                    ---   CALL EXPATH
         PATHWY(1) = 'CO'
         PATHWY(2) = 'SO'
         PATHWY(3) = 'RE'
         PATHWY(4) = 'ME'
         PATHWY(5) = 'TG'
         PATHWY(6) = 'OU'
         PATHWY(7) = '**'
         PATHWY(8) = 'EV'
         CALL EXPATH(FIELD(1),PATHWY,8,NOPATH)

C        For Invalid Pathway and Comment Lines Skip to Next Record
         IF (NOPATH) THEN
C           Skip Error Message for PRESET stage of processing
            PATH = PPATH
            GO TO 11
         ELSE IF (PATH .EQ. '**') THEN
            GO TO 11
         END IF

C        Extract Keyword From Field 2                       ---   CALL EXKEY
         CALL EXKEY(FIELD(2),NOKEY)

         IF (NOKEY) THEN
C           Invalid Keyword - Skip Error Message for PRESET stage
            PKEYWD = KEYWRD
            GO TO 11
         END IF

C        Save Current Path and Path Number as Previous Path and Number
         PPATH = PATH
         IPPNUM = IPNUM

C        Process Cards to Determine Storage Requirements
         IF (PATH .EQ. 'CO' .AND. KEYWRD .EQ. 'MODELOPT') THEN
            DO I = 3, IFC
               IF (FIELD(I) .EQ. 'CONC'  .OR.
     &             FIELD(I) .EQ. 'DEPOS' .OR.
     &             FIELD(I) .EQ. 'DDEP'  .OR.
     &             FIELD(I) .EQ. 'WDEP') THEN
                  NTYP = NTYP + 1
               END IF
            END DO
         END IF

         IF (PATH .EQ. 'CO' .AND. KEYWRD .EQ. 'AVERTIME') THEN
            DO I = 3, IFC
               IF (FIELD(I).NE.'PERIOD' .AND. FIELD(I).NE.'ANNUAL') THEN
                  NAVE = NAVE + 1
               END IF
            END DO
         END IF

         IF (PATH .EQ. 'SO') THEN
            CALL SRCSIZ
         END IF

         IF (PATH .EQ. 'RE') THEN
            EVONLY = .FALSE.
            CALL RECSIZ
         END IF

         IF (PATH .EQ. 'EV') THEN
            EVONLY = .TRUE.
            IF (KEYWRD .EQ. 'EVENTPER') THEN
               NEVE = NEVE + 1
            ELSE IF (KEYWRD .EQ. 'INCLUDED') THEN
               CALL PREINCLUD
            END IF
         END IF

         IF (PATH .EQ. 'ME' .AND. KEYWRD .EQ. 'SURFDATA') THEN
C           Read start year from SURFDATA card to establish date window
            CALL SET_WINDOW
         END IF

         IF (PATH .EQ. 'OU' .AND. KEYWRD .EQ. 'RECTABLE') THEN
C           Begin LOOP Through Fields
            DO I = 4, IFC
C              Retrieve The High Value
               CALL FSPLIT(PATH,KEYWRD,FIELD(I),ILEN_FLD,'-',RMARK,
     &                     LPRD,HPRD)
               ISPRD = 0
               IEPRD = 0
               DO J = 1, 10
                  IF (LPRD.EQ.NCHR1(J) .OR.
     &                LPRD.EQ.NCHR2(J)) ISPRD = J
                  IF (HPRD.EQ.NCHR1(J) .OR.
     &                HPRD.EQ.NCHR2(J)) IEPRD = J
               END DO
               IF (ISPRD .GT. NVAL) THEN
                  NVAL = ISPRD
               END IF
               IF (IEPRD .GT. NVAL) THEN
                  NVAL = IEPRD
               END IF
C           End LOOP Through Fields
            END DO
         END IF

         IF (PATH .EQ. 'OU' .AND. KEYWRD .EQ. 'MAXTABLE') THEN
C           Set Number of Maximum Values to Sort
            CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
            IF (IMIT .NE. 1) THEN
C              Invalid Numerical Field
               GO TO 999
            END IF
            INUM = NINT(FNUM)
            IF (INUM .GT. NMAX) THEN
               NMAX = INUM
            END IF
         END IF

C        Store the Current Keyword as the Previous Keyword
         PKEYWD = KEYWRD

C        Check for 'OU FINISHED' Card.  Exit DO WHILE Loop By Branching
C        to Statement 999 in Order to Avoid Reading a ^Z "End of File"
C        Marker That May Be Present For Some Editors.
         IF (PATH .EQ. 'OU' .AND. KEYWRD .EQ. 'FINISHED') THEN
            GO TO 999
         END IF

         GO TO 11
 999     EOF = .TRUE.
 11      CONTINUE
      END DO

C     Rewind File and Reinitialize Line Number Counter for SETUP
      REWIND INUNIT
      ILINE = 0
      PNETID = '        '

C     Ensure that array limits are not < 1.
      NSRC = MAX( NSRC, 1)
      NREC = MAX( NREC, 1)
      NAVE = MAX( NAVE, 1)
      NVAL = MAX( NVAL, 1)
      NTYP = MAX( NTYP, 1)
      NMAX = MAX( NMAX, 1)
      NNET = MAX( NNET, 1)
      IXM  = MAX( IXM , 1)
      IYM  = MAX( IYM , 1)
      NEVE = MAX( NEVE, 1)

      RETURN
      END

      SUBROUTINE PREINCLUD
C***********************************************************************
C*                PREINCLUD Module of ISCST3 Model
C*
C*       PURPOSE: To read an external receptor/source file using the
C*                INCLUDED keyword.
C*
C*       PROGRAMMER: Roger Brode
C*
C*       DATE:    September 24, 1996
C*
C*       MODIFIED:   
C*                   
C*       INPUTS: 
C*
C*       OUTPUTS:
C*               
C*
C*       CALLED FROM:   PRESET, SRCSIZ, RECSIZ
C***********************************************************************
        
C*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, ILREAL
      LOGICAL NOPATH, NOKEY      
      CHARACTER RDFRM*20, ECFRM*20
      CHARACTER INPFLD*2, PATHWY(8)*2
      INTERFACE
         SUBROUTINE EXPATH(INPFLD,PATHWY,IPN,NOPATH)
            CHARACTER (LEN=2), INTENT(IN) :: INPFLD
            CHARACTER (LEN=2), INTENT(IN), DIMENSION(:) :: PATHWY
            INTEGER, INTENT(IN) :: IPN
            LOGICAL, INTENT(OUT) :: NOPATH
         END SUBROUTINE EXPATH
      END INTERFACE

C*    Variable Initializations
      MODNAM = 'PREINCLUD'
      EOF = .FALSE.
      ILINE = 1

C     Setup READ format and ECHO format for runstream record,
C     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE(RDFRM,9100) ISTRG, ISTRG
 9100 FORMAT('(A',I3.3,',T1,',I3.3,'A1)')
      WRITE(ECFRM,9250) ISTRG
 9250 FORMAT('(1X,A',I3.3,')')
      

      IF (IFC .EQ. 3) THEN
C        Retrieve Included Filename as Character Substring to Maintain Case
         INCFIL = RUNST1(LOCB(3):LOCE(3))
         OPEN (INCUNT,FILE=INCFIL,STATUS='OLD',ERR=1002)

      ELSE IF (IFC .GT. 4) THEN
C        Too Many Parameters
         GO TO 1002
      ELSE
C        No Parameters Specified
         GO TO 1002
      END IF

C     LOOP Through Input Runstream Records
      DO WHILE (.NOT. EOF)

C        Increment the Line Counter.  It was Initially Set to 1, to Handle
C        the Code in Subroutine DEFINE
         ILINE = ILINE + 1
         ILREAL = ILREAL + 1

C        READ Record to Buffers, as A80 and 80A1 for ISTRG = 80.
C        Length of ISTRG is Set in PARAMETER Statement in MAIN1
         READ (INCUNT,RDFRM,END=999) RUNST1, (RUNST(I), I = 1, ISTRG)

C        Convert Lower Case to Upper Case Letters           ---   CALL LWRUPR
         CALL LWRUPR

C        Define Fields on Card                              ---   CALL DEFINE
         CALL DEFINE

         IF (ILREAL .EQ. 1) ILINE = ILINE - 1

C        Get the Contents of the Fields                     ---   CALL GETFLD
         CALL GETFLD

C        If Blank Line, Then CYCLE to Next Card
         IF (BLINE) GO TO 11

C        Check for 'NO ECHO' In First Two Fields
         IF (FIELD(1) .EQ. 'NO' .AND. FIELD(2) .EQ. 'ECHO') THEN
C           Skip record with NO ECHO during PREINCLUD stage of processing
            GO TO 11
         END IF

C        Extract Pathway ID From Field 1                    ---   CALL EXPATH
         PATHWY(1) = 'CO'
         PATHWY(2) = 'SO'
         PATHWY(3) = 'RE'
         PATHWY(4) = 'ME'
         PATHWY(5) = 'TG'
         PATHWY(6) = 'OU'
         PATHWY(7) = '**'
         PATHWY(8) = 'EV'
         CALL EXPATH(FIELD(1),PATHWY,8,NOPATH)

C        For Invalid Pathway and Comment Lines Skip to Next Record
         IF (NOPATH) THEN
C           Skip Error Message for PREINCLUD stage of processing
            PATH = PPATH
            GO TO 11
         ELSE IF (PATH .EQ. '**') THEN
            GO TO 11
         END IF

C        Extract Keyword From Field 2                       ---   CALL EXKEY
         CALL EXKEY(FIELD(2),NOKEY)

         IF (NOKEY) THEN
C           Invalid Keyword - Skip Error Message for PREINCLUD stage
            PKEYWD = KEYWRD
            GO TO 11
         END IF

C        Save Current Path and Path Number as Previous Path and Number
         PPATH = PATH
         IPPNUM = IPNUM

C        Process Input Card Based on Pathway
         IF (PATH .EQ. 'SO') THEN
C           Process SOurce Pathway Cards                    ---   CALL SOINCL
            CALL PRESOINC
         ELSE IF (PATH .EQ. 'RE') THEN
C           Process REceptor Pathway Cards                  ---   CALL REINCL
            CALL PREREINC
         ELSE IF (PATH .EQ. 'EV') THEN
            IF (KEYWRD .EQ. 'EVENTPER') THEN
               NEVE = NEVE + 1
            END IF
         END IF

C        Store the Current Keyword as the Previous Keyword
         PKEYWD = KEYWRD

         GO TO 11
 999     EOF = .TRUE.
 11      CONTINUE

      END DO
      EOF = .FALSE.

C     Close the INCLUDED File
      CLOSE (INCUNT)
      
1002  RETURN
      END

  
      SUBROUTINE SRCSIZ
C***********************************************************************
C                 SRCSIZ Module of ISCST Model
C
C        PURPOSE: To preprocess receptor inputs to determine
C                 storage requirements
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        MODIFIED:   To include an option to vary emissions by season,
C                    hour-of-day, and day-of-week (SHRDOW).
C                    R.W. Brode, PES, 4/10/2000
C
C        INPUTS:  Pathway (RE) and Keyword
C
C        OUTPUTS: Receptor Arrays
C                 Receptor Setup Status Switches
C
C        CALLED FROM:   PRESET
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'SRCSIZ'


      IF (KEYWRD .EQ. 'STARTING') THEN
C        Initialize Counters and Set Status Switch
         NSRC = 0
         NGRP = 0
         PREVGRPID = '        '

      ELSE IF (KEYWRD .EQ. 'LOCATION') THEN
         NSRC = NSRC + 1

      ELSE IF ((KEYWRD.EQ.'PARTDIAM' .OR.
     &          KEYWRD.EQ.'MASSFRAX' .OR.
     &          KEYWRD.EQ.'PARTDENS')) THEN
         NPDMAX = 20

      ELSE IF (KEYWRD .EQ. 'EMISFACT') THEN
         IF (FIELD(4) .EQ. 'SEASON') THEN
            NQF = MAX( NQF, 4)
         ELSE IF (FIELD(4) .EQ. 'MONTH') THEN
            NQF = MAX( NQF, 12)
         ELSE IF (FIELD(4) .EQ. 'HROFDY') THEN
            NQF = MAX( NQF, 24)
         ELSE IF (FIELD(4) .EQ. 'STAR') THEN
            NQF = MAX( NQF, 36)
         ELSE IF (FIELD(4) .EQ. 'SEASHR') THEN
            NQF = MAX( NQF, 96)
         ELSE IF (FIELD(4) .EQ. 'SHRDOW') THEN
            NQF = MAX( NQF, 288)
         END IF

      ELSE IF (KEYWRD .EQ. 'SRCGROUP') THEN
         IF (FIELD(3) .NE. PREVGRPID) THEN
            NGRP = NGRP + 1
            PREVGRPID = FIELD(3)
         END IF

      ELSE IF (KEYWRD .EQ. 'INCLUDED') THEN
         CALL PREINCLUD
      END IF

 999  RETURN
      END

      SUBROUTINE PRESOINC
C***********************************************************************
C                 PRESOINC Module of ISCST Model
C
C        PURPOSE: To preprocess receptor inputs to determine
C                 storage requirements
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        MODIFIED:   To include allocation for SHRDOW emission factor
C                    option.  R.W. Brode, PES, Inc., 02/04/2002
C
C        INPUTS:  Pathway (RE) and Keyword
C
C        OUTPUTS: Receptor Arrays
C                 Receptor Setup Status Switches
C
C        CALLED FROM:   PREINCLUD
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'PRESOINC'

      IF (KEYWRD .EQ. 'LOCATION') THEN
         NSRC = NSRC + 1

      ELSE IF ((KEYWRD.EQ.'PARTDIAM' .OR.
     &                          KEYWRD.EQ.'MASSFRAX' .OR.
     &                          KEYWRD.EQ.'PARTDENS')) THEN
         NPDMAX = 20

      ELSE IF (KEYWRD .EQ. 'EMISFACT') THEN
         IF (FIELD(4) .EQ. 'SEASON') THEN
            NQF = MAX( NQF, 4)
         ELSE IF (FIELD(4) .EQ. 'MONTH') THEN
            NQF = MAX( NQF, 12)
         ELSE IF (FIELD(4) .EQ. 'HROFDY') THEN
            NQF = MAX( NQF, 24)
         ELSE IF (FIELD(4) .EQ. 'STAR') THEN
            NQF = MAX( NQF, 36)
         ELSE IF (FIELD(4) .EQ. 'SEASHR') THEN
            NQF = MAX( NQF, 96)
         ELSE IF (FIELD(4) .EQ. 'SHRDOW') THEN
            NQF = MAX( NQF, 288)
         END IF

      ELSE IF (KEYWRD .EQ. 'SRCGROUP') THEN
         IF (FIELD(3) .NE. PREVGRPID) THEN
            NGRP = NGRP + 1
            PREVGRPID = FIELD(3)
         END IF
      END IF

 999  RETURN
      END

      SUBROUTINE RECSIZ
C***********************************************************************
C                 RECSIZ Module of ISCST Model
C
C        PURPOSE: To preprocess receptor inputs to determine
C                 storage requirements
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Pathway (RE) and Keyword
C
C        OUTPUTS: Receptor Arrays
C                 Receptor Setup Status Switches
C
C        CALLED FROM:   PRESET
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'RECSIZ'

      IF (KEYWRD .EQ. 'STARTING') THEN
C        Initialize Counters and Set Status Switch
         NREC = 0
         NNET = 0
         IXM  = 0
         IYM  = 0
         PXSOID = ' '
         ISTA = .FALSE.
      ELSE IF (KEYWRD .EQ. 'GRIDCART') THEN
C        Process Cartesian Grid Receptor Network            ---   CALL PRECART
         CALL PRECART
      ELSE IF (KEYWRD .EQ. 'GRIDPOLR') THEN
C        Process Polar Receptor Network                     ---   CALL PREPOLR
         CALL PREPOLR
      ELSE IF (KEYWRD .EQ. 'DISCCART') THEN
         NREC = NREC + 1
      ELSE IF (KEYWRD .EQ. 'DISCPOLR') THEN
         NREC = NREC + 1
      ELSE IF (KEYWRD .EQ. 'BOUNDARY') THEN
C        Process Plant Boundary Receptor Locations          ---   CALL PREBOUND
         CALL PREBOUND
      ELSE IF (KEYWRD .EQ. 'INCLUDED') THEN
         CALL PREINCLUD
      END IF

 999  RETURN
      END

      SUBROUTINE PREREINC
C***********************************************************************
C                 PREREINC Module of ISCST Model
C
C        PURPOSE: To preprocess receptor inputs to determine
C                 storage requirements
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Pathway (RE) and Keyword
C
C        OUTPUTS: Receptor Arrays
C                 Receptor Setup Status Switches
C
C        CALLED FROM:   PREINCLUD
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'PREREINC'

      IF (KEYWRD .EQ. 'GRIDCART') THEN
C        Process Cartesian Grid Receptor Network            ---   CALL PRECART
         CALL PRECART
      ELSE IF (KEYWRD .EQ. 'GRIDPOLR') THEN
C        Process Polar Receptor Network                     ---   CALL PREPOLR
         CALL PREPOLR
      ELSE IF (KEYWRD .EQ. 'DISCCART') THEN
         NREC = NREC + 1
      ELSE IF (KEYWRD .EQ. 'DISCPOLR') THEN
         NREC = NREC + 1
      ELSE IF (KEYWRD .EQ. 'BOUNDARY') THEN
C        Process Plant Boundary Receptor Locations          ---   CALL PREBOUND
         CALL PREBOUND
      END IF

 999  RETURN
      END

      SUBROUTINE PRECART
C***********************************************************************
C                 PRECART Module of ISC2 Model
C
C        PURPOSE: Processes Cartesian Grid Receptor Network Inputs
C
C        PROGRAMMER:  Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Cartesian Grid Receptor Network Inputs
C
C        CALLED FROM:   RECSIZ, PREREINC
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'PRECART'

C     READ in the Netid and Nettype
      IF (IFC .LT. 3) THEN
C        Missing Data Field
         GO TO 999
      END IF
      NETIDT = FIELD(3)
      IF (.NOT.NEWID .AND. (NETIDT.EQ.'    ' .OR.
     &    NETIDT.EQ.'XYINC' .OR. NETIDT.EQ.'XPNTS' .OR.
     &    NETIDT.EQ.'YPNTS' .OR. NETIDT.EQ.'ELEV' .OR.
     &    NETIDT.EQ.'FLAG'  .OR. NETIDT.EQ.'END')) THEN
         NETIDT = PNETID
         KTYPE = FIELD(3)
      ELSE IF (.NOT.NEWID .AND. NETIDT.EQ.PNETID) THEN
         KTYPE = FIELD(4)
      ELSE IF (NEWID .AND. NETIDT.NE.' ') THEN
         NEWID = .FALSE.
         KTYPE = FIELD(4)
C        The Keyword Counter
         NNET = NNET + 1
      ELSE
C        Invalid Secondary Keyword
         GO TO 999
      END IF

C     Start to Set Up the Network
      IF (KTYPE .EQ. 'STA') THEN
C        Initialize Logical Control Variables
         ISTA = .TRUE.
         IEND = .FALSE.
         NEWID = .FALSE.
         RECERR = .FALSE.
C        Set Counters of Calculation Field
         ICOUNT = 0
         JCOUNT = 0
      ELSE IF (KTYPE .EQ. 'XYINC') THEN
C        Set the Uniform Spacing Receptor Network           ---   CALL PREGENCAR
         CALL PREGENCAR
      ELSE IF (KTYPE.EQ.'XPNTS' .OR. KTYPE.EQ.'YPNTS') THEN
C        Set the Non-uniform Spacing Receptor Network       ---   CALL PREXYPNTS
         CALL PREXYPNTS
      ELSE IF (KTYPE .EQ. 'END') THEN
         IEND = .TRUE.
         IF (.NOT. RECERR) THEN
            NREC = NREC + ICOUNT*JCOUNT
         END IF
         ISTA = .FALSE.
         NEWID = .TRUE.

      ELSE IF (KTYPE.NE.'ELEV' .AND. KTYPE.NE.'FLAG') THEN
C        Invalid Secondary Keyword
         RECERR = .TRUE.
         GO TO 999

      END IF

      PNETID = NETIDT

 999  RETURN
      END

      SUBROUTINE PREGENCAR
C***********************************************************************
C                 PREGENCAR Module of ISC2 Model
C
C        PURPOSE: Generates Cartesian Grid Receptor Network With
C                 Uniform Spacing
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Cartesian Grid Receptor Network With Uniform
C                 Spacing
C
C        CALLED FROM:   PRECART
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, K
      REAL    :: TEMPP(6), XDELTA, YDELTA
      LOGICAL ERROR

C     Variable Initializations
      MODNAM = 'PREGENCAR'
      ERROR = .FALSE.

C     Check for Location of Secondary Keyword, XYINC
      DO I = 1, IFC
         IF (FIELD(I) .EQ. 'XYINC') THEN
            ISC = I + 1
         END IF
      END DO

C     Determine Whether There Are Enough Parameter Fields
      IF (IFC .EQ. ISC-1) THEN
C        Missing Parameter
         RECERR = .TRUE.
         GO TO 999
      ELSE IF (IFC .GT. ISC+5) THEN
C        Too Many Parameters
         RECERR = .TRUE.
         GO TO 999
      ELSE IF (IFC .LT. ISC+5) THEN
C        Too Few Parameters
         RECERR = .TRUE.
         GO TO 999
      END IF

C     Input The Numerical Values
      DO K = 1,6
         CALL STONUM(FIELD(ISC + K-1),ILEN_FLD,TEMPP(K),IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            ERROR = .TRUE.
            RECERR = .TRUE.
         END IF
      END DO

      IF (ERROR) THEN
         ERROR = .FALSE.
         GO TO 999
      END IF

C     Assign Values to Appropriate Variables for Generated Network
      XINT   = TEMPP(1)
      ICOUNT = NINT(TEMPP(2))
      XDELTA = TEMPP(3)
      YINT   = TEMPP(4)
      JCOUNT = NINT(TEMPP(5))
      YDELTA = TEMPP(6)

C     Assign Them to the Coordinate Arrays
      IF (ICOUNT .GT. IXM) THEN
         IXM = ICOUNT
      END IF
      IF (JCOUNT .GT. IYM) THEN
         IYM = JCOUNT
      END IF

 999  RETURN
      END

      SUBROUTINE PREXYPNTS
C***********************************************************************
C                 PREXYPNTS Module of ISC2 Model
C
C        PURPOSE: Processes Cartesian Grid x,y Input Value
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Cartesian Grid x,y Input Value
C
C        CALLED FROM:   PRECART
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, JSET

C     Variable Initializations
      MODNAM = 'PREXYPNTS'

      IF (KTYPE .EQ. 'XPNTS') THEN
C        Check for Location of Secondary Keyword, XPNTS
         DO I = 1, IFC
            IF (FIELD(I) .EQ. 'XPNTS') THEN
               ISC = I + 1
            END IF
         END DO

C        Determine Whether There Are Enough Parameter Fields
         IF (IFC .EQ. ISC-1) THEN
C           Missing Parameter
            RECERR = .TRUE.
            GO TO 999
         END IF

         ISET = ICOUNT
         DO I = ISC, IFC
            CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
C           Check The Numerical Field
            IF (IMIT .EQ. -1) THEN
               RECERR = .TRUE.
            END IF
            ISET = ISET + 1
            IF (ISET .GT. IXM) THEN
               IXM = ISET
            END IF
         END DO
         ICOUNT = ISET

      ELSE IF (KTYPE .EQ. 'YPNTS') THEN
C        Check for Location of Secondary Keyword, YPNTS
         DO I = 1, IFC
            IF (FIELD(I) .EQ. 'YPNTS') THEN
               ISC = I + 1
            END IF
         END DO

C        Determine Whether There Are Enough Parameter Fields
         IF (IFC .EQ. ISC-1) THEN
C           Missing Parameter
            RECERR = .TRUE.
            GO TO 999
         END IF

         JSET = JCOUNT
         DO I = ISC, IFC
            CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
C           Check The Numerical Field
            IF (IMIT .EQ. -1) THEN
               RECERR = .TRUE.
            END IF
            JSET = JSET + 1
            IF (JSET .GT. IYM) THEN
               IYM = JSET
            END IF
         END DO
         JCOUNT = JSET

      END IF

 999  RETURN
      END

      SUBROUTINE PREPOLR
C***********************************************************************
C                 PREPOLR Module of ISC2 Model
C
C        PURPOSE: Processes Polar Grid Receptor Network Inputs
C
C        PROGRAMMER:  Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Polar Receptor Network Inputs
C
C        CALLED FROM:   RECSIZ, PREREINC
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'PREPOLR'

      IF (IFC .LT. 3) THEN
C        Missing Data Field
         GO TO 999
      END IF

C     READ in the Netid and Nettype
      NETIDT = FIELD(3)
      IF (.NOT.NEWID .AND. (NETIDT.EQ.'    ' .OR.
     &    NETIDT.EQ.'ORIG' .OR. NETIDT.EQ.'DIST' .OR.
     &    NETIDT.EQ.'DDIR' .OR. NETIDT.EQ.'ELEV' .OR.
     &    NETIDT.EQ.'FLAG' .OR. NETIDT.EQ.'GDIR' .OR.
     &    NETIDT.EQ.'END')) THEN
         NETIDT = PNETID
         KTYPE = FIELD(3)
      ELSE IF (.NOT.NEWID .AND. NETIDT.EQ.PNETID) THEN
         KTYPE = FIELD(4)
      ELSE IF (NEWID .AND. NETIDT.NE.'    ') THEN
         NEWID = .FALSE.
         KTYPE = FIELD(4)
C        The Keyword Counter
         NNET = NNET + 1
      ELSE
C        Invalid Secondary Keyword
         RECERR = .TRUE.
         GO TO 999
      END IF

C     Start to Set Up the Network
      IF (KTYPE .EQ. 'STA') THEN
         ISTA = .TRUE.
         IEND = .FALSE.
         NEWID = .FALSE.
         RECERR = .FALSE.
         ICOUNT = 0
         JCOUNT = 0
      ELSE IF (KTYPE .EQ. 'DIST') THEN
C        Read in the Distance Set                           ---   CALL PREPOLDST
         CALL PREPOLDST
      ELSE IF (KTYPE .EQ. 'GDIR') THEN
         CALL PREGENPOL
      ELSE IF (KTYPE .EQ. 'DDIR') THEN
         CALL PRERADRNG
      ELSE IF (KTYPE .EQ. 'END') THEN
         IEND = .TRUE.
C        Get the Final Result
         IF (.NOT. RECERR) THEN
            NREC = NREC + ICOUNT*JCOUNT
         END IF
         ISTA = .FALSE.
         NEWID = .TRUE.

      ELSE IF (KTYPE.NE.'ELEV' .AND. KTYPE.NE.'FLAG' .AND.
     &         KTYPE.NE.'ORIG') THEN
C        Invalid Secondary Keyword
         RECERR = .TRUE.
         GO TO 999

      END IF

      PNETID = NETIDT

 999  RETURN
      END

      SUBROUTINE PREPOLDST
C***********************************************************************
C                 PREPOLDST Module of ISC2 Model
C
C        PURPOSE: Gets Distances for the Polar Network
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Polar Network Distance Input Value
C
C        CALLED FROM:   PREPOLR
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I

C     Variable Initializations
      MODNAM = 'PREPOLDST'

C     Skip the Unrelated Fields
      DO I = 1, IFC
         IF (FIELD(I) .EQ. 'DIST') THEN
            ISC = I + 1
         END IF
      END DO

C     Determine Whether There Are Enough Parameter Fields
      IF (IFC .EQ. ISC-1) THEN
C        Missing Parameter
         RECERR = .TRUE.
         GO TO 999
      END IF

      ISET = ICOUNT

      DO I = ISC, IFC
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            RECERR = .TRUE.
         END IF
         ISET = ISET + 1
         IF (ISET .GT. IXM) THEN
            IXM = ISET
         END IF
      END DO

      ICOUNT = ISET

 999  RETURN
      END

      SUBROUTINE PREGENPOL
C***********************************************************************
C                 PREGENPOL Module of ISC2 Model
C
C        PURPOSE: Generates Polar Receptor Network With
C                 Uniform Spacing
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Polar Receptor Network With Uniform Direction Spacing
C
C        CALLED FROM:   PREPOLR
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, K
      REAL    :: TEMPP(3), DIRINI, DIRINC
      LOGICAL ERROR

C     Variable Initializations
      MODNAM = 'PREGENPOL'
      ERROR = .FALSE.

C     Check for the Location of the Secondary Keyword, GDIR
      DO I = 1, IFC
         IF (FIELD(I) .EQ. 'GDIR') THEN
            ISC = I + 1
         END IF
      END DO

C     Determine Whether There Are Enough Parameter Fields
      IF (IFC .EQ. ISC-1) THEN
C        Missing Parameter
         RECERR = .TRUE.
         GO TO 999
      ELSE IF (IFC .LT. ISC+2) THEN
C        Not Enough Parameters
         RECERR = .TRUE.
         GO TO 999
      ELSE IF (IFC .GT. ISC+2) THEN
C        Too Many Parameters
         RECERR = .TRUE.
         GO TO 999
      END IF

C     Input Numerical Values
      DO K = 1, 3
         CALL STONUM(FIELD(ISC + K-1),ILEN_FLD,TEMPP(K),IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            RECERR = .TRUE.
            ERROR = .TRUE.
         END IF
      END DO

      IF (ERROR) THEN
         ERROR = .FALSE.
         GO TO 999
      END IF

      JCOUNT = NINT(TEMPP(1))
      DIRINI = TEMPP(2)
      DIRINC = TEMPP(3)

C     Assign Them to the Coordinate Arrays
      IF (JCOUNT .GT. IYM) THEN
         IYM = JCOUNT
      END IF

 999  RETURN
      END

      SUBROUTINE PRERADRNG
C***********************************************************************
C                 PRERADRNG Module of ISC2 Model
C
C        PURPOSE: Processes Non-Uniform Polar Network Value
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Polar Network Directions in Non-Uniform Spacing
C
C        CALLED FROM:   PREPOLR
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I

C     Variable Initializations
      MODNAM = 'PRERADRNG'

C     Skip the non-useful Fields
      DO I = 1, IFC
         IF (FIELD(I) .EQ. 'DDIR') THEN
            ISC = I + 1
         END IF
      END DO

C     Determine Whether There Are Enough Parameter Fields
      IF (IFC .EQ. ISC-1) THEN
C        Error Message: Missing Parameter
         RECERR = .TRUE.
         GO TO 999
      END IF

      ISET = JCOUNT

      DO I = ISC, IFC
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
C        Check The Numerical Field
         IF (IMIT .EQ. -1) THEN
            RECERR = .TRUE.
         END IF
         ISET = ISET + 1
         IF (ISET .GT. IYM) THEN
            IYM = ISET
         END IF
      END DO

      JCOUNT = ISET

 999  RETURN
      END

      SUBROUTINE PREBOUND
C***********************************************************************
C                 PREBOUND Module of ISC2 Model
C
C        PURPOSE: Processes Plant Boundary Receptor Location Inputs
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 24, 1996
C
C        MODIFIED:   To Include TOXXFILE Option - 9/29/92
C                    To Correct Index Counter for BOUNDELV, and
C                    To Include Conversion of Elevations From
C                    Feet to Meters - 9/29/92
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Plant Boundary Receptor Location Inputs
C
C        CALLED FROM:   RECSIZ, PREREINC
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      CHARACTER SOID*8

C     Variable Initializations
      MODNAM = 'PREBOUND'

C     Determine Whether There Are Enough Parameter Fields
      IF (IFC .EQ. 2) THEN
C        Missing Parameter
         GO TO 999
      ELSE IF (IFC .EQ. 3) THEN
C        Missing Numerical Field
         GO TO 999
      END IF

      SOID = FIELD(3)

C     Update The Counter
      IF (SOID .NE. PXSOID) THEN
         NREC = NREC + 36
         PXSOID = SOID
      END IF

 999  RETURN
      END


      SUBROUTINE SET_WINDOW
C***********************************************************************
C                 SET_WINDOW Module of ISC3 Short Term Model - ISCST3
C
C        PURPOSE: Preprocess Meteorology Surface Data Card (SURFDATE)
C                 to Set Date Window for Y2K Fixes
C
C        PROGRAMMER: Roger Brode, PES, Inc.
C
C        DATE:    April 29, 1999
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Starting Century, ISTRT_CENT                    [I4]
C                 Starting Year for 2-digit Window, ISTRT_WIND    [I4]
C
C        ERROR HANDLING:   Checks for Too Few Parameters;
C                          Checks for Invalid Numeric Fields;
C                          Checks for Too Many Parameters
C
C        CALLED FROM:   PRESET
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'SET_WINDOW'

      IF (IFC .LT. 4) THEN
         GO TO 999
      ELSE IF (IFC .GT. 7) THEN
         GO TO 999
      END IF

      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
C     Check The Numerical Field
      IF (IMIT .NE. 1) THEN
         GO TO 999
      END IF
      ISYEAR = NINT(FNUM)
      IF (ISYEAR .LT. 100) THEN
C        Write warning message for 2-digit year, and set default "windowing"
C        variables, ISTRT_CENT (=19) and ISTRT_WIND (=50).
         CALL ERRHDL(PATH,MODNAM,'W','360',KEYWRD)
         ISTRT_CENT = 19
         ISTRT_WIND = 50
      ELSE
C        Determine starting century (ISTRT_CENT) and starting year for
C        window (ISTRT_WIND) from 4-digit input
         ISTRT_CENT = ISYEAR/100
         ISTRT_WIND = ISYEAR - ISTRT_CENT*100
C        Check for year .ge. 2148 to avoid integer overflow on FULLDATE
         IF (ISTRT_CENT .GE. 21 .AND. ISTRT_WIND .GE. 48) THEN
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            ISTRT_CENT = 21
            ISTRT_WIND = 47
         END IF
      END IF

      GO TO 1000

 999  CONTINUE
C     For error in processing assume 1900 for start century and 50 for window
      ISTRT_CENT = 19
      ISTRT_WIND = 50

 1000 RETURN
      END

      SUBROUTINE CHK_ENDYR
C***********************************************************************
C                 CHK_ENDYR Module of ISC3 Model
C
C        PURPOSE: Checks date for "end-of-year" for use in ANNUAL
C                 averages and post-1997 PM10 processing.
C
C        PROGRAMMER: Roger Brode
C
C        DATE:
C
C        MODIFIED:   To Include TOXXFILE Option - 9/29/92
C                    To Correct Index Counter for BOUNDELV, and
C                    To Include Conversion of Elevations From
C                    Feet to Meters - 9/29/92
C
C        INPUTS:  Input Runstream Image Parameters
C
C        OUTPUTS: Plant Boundary Receptor Location Inputs
C
C        CALLED FROM:   HRLOOP
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IEND_DAY, I, J, K, L, M
      CHARACTER SOID*8

C     Variable Initializations
      MODNAM = 'CHK_ENDYR'

      IF( (IENDMN.EQ.2.AND.IENDDY.EQ.29.AND.IMONTH.EQ.2) .AND.
     &    (MOD(IYR,4).NE.0) .OR.
     &    (MOD(IYR,100).EQ.0 .AND. MOD(IYR,400).NE.0)) THEN
C        Set End Day to 28 for non-leap year February
         IEND_DAY = 28
      ELSE
         IEND_DAY = IENDDY
      END IF

      IF (IMONTH.EQ.IENDMN .AND. IDAY.EQ.IEND_DAY .AND.
     &    IHOUR.EQ.IENDHOUR) THEN
C        End of year reached, increment counter and store H4H values
         NUMYRS = NUMYRS + 1
         IF (ANNUAL) THEN
            CALL PERAVE
         END IF
         DO IGRP = 1, NUMGRP
            DO IREC = 1, NUMREC
               IF (PM10AVE .AND. NUMAVE.EQ.1) THEN
                  SUMH4H(IREC,IGRP) = SUMH4H(IREC,IGRP) +
     &                                HIVALU(IREC,4,IGRP,1,1)
               END IF
               IF (ANNUAL) THEN
                  DO ITYP = 1, NUMTYP
                     SUMANN(IREC,IGRP,ITYP) = SUMANN(IREC,IGRP,ITYP) +
     &                                        ANNVAL(IREC,IGRP,ITYP)
                  END DO
               END IF
            END DO
         END DO
         NREMAIN = 0
         IF (ANNUAL) THEN
C           Re-initialize the annual counters and array
            IANHRS  = 0
            IANCLM  = 0
            IANMSG  = 0
            IANWET  = 0
            IWETCLM = 0
            IWETMSG = 0
            NSKIPTOT = 0
            NSKIPDRY = 0
            NSDRYCLM = 0
            NSDRYMSG = 0
            NSKIPWET = 0
            NSWETCLM = 0
            NSWETMSG = 0
            DO L = 1, NUMTYP
               DO K = 1, NUMGRP
                  DO J = 1, NUMREC
                     ANNVAL(J,K,L)  = 0.0
                     ANNVALD(J,K,L) = 0.0
                     ANNVALW(J,K,L) = 0.0
                  END DO
               END DO
            END DO
         END IF
         IF (PM10AVE .AND. NUMAVE.EQ.1) THEN
C           Re-initialize the High Value Arrays for post-1997 PM10
            DO M = 1, NUMTYP
               DO L = 1, NUMAVE
                  DO K = 1, NUMGRP
                     DO J = 1, NUMREC
                        DO I = 1, NHIVAL
                           HIVALU(J,I,K,L,M) = 0.0
                           NHIDAT(J,I,K,L,M) = 0
                           HCLMSG(J,I,K,L,M) = ' '
                        END DO
                     END DO
                  END DO
               END DO
            END DO
         END IF
      ELSE
C        Increment counter for number of hours remaining after
C        the end of the last year
         NREMAIN = NREMAIN + 1
      END IF

      RETURN
      END
