      SUBROUTINE PERAVE
C***********************************************************************
C                 PERAVE Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Calculates PERIOD Averages
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Removed 75 percent limit on calculation of the
C                    denominator, SNUM - 4/19/93
C
C        INPUTS:  Array of Period Sums and Counters
C
C        OUTPUTS: Array of Period Averages
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      REAL :: SNUM, SNUMSCM, SNUMWET, STOTDRY, STOTWET, STOTHRS

C     Variable Initializations
      MODNAM = 'PERAVE'

C     Calculate Denominator Considering Calms and Missing
      SNUM = IANHRS - IANCLM - IANMSG
      IF (.NOT. SCIM) THEN
         STOTHRS = IANHRS
      ELSE IF (SCIM) THEN
         STOTHRS = NSKIPTOT                             ! Total no. of hours
         SNUMSCM = IANHRS   - IANCLM   - IANMSG         ! Sampled SCIM'd hours
         SNUMWET = IANWET   - IWETCLM  - IWETMSG        ! Sampled wet hours
         STOTDRY = NSKIPDRY - NSDRYCLM - NSDRYMSG       ! Total dry hours
         STOTWET = NSKIPWET - NSWETCLM - NSWETMSG       ! Total wet hours
      ENDIF

C     Calculate Period Average Concentrations for Each Source Group and Receptor

C     Begin LOOP Over Output Types
      DO ITYP = 1, NUMTYP
C        Begin Source Group LOOP
         DO IGRP = 1, NUMGRP
C           Begin Receptor LOOP
            DO IREC = 1, NUMREC

               IF (OUTTYP(ITYP) .EQ. 'CONC') THEN

                  IF (.NOT.SCIM .OR. (SCIM.AND..NOT.WETSCIM)) THEN
                     ANNVAL(IREC,IGRP,1) = ANNVAL(IREC,IGRP,1)/SNUM
                  ELSEIF (SCIM .AND. WETSCIM) THEN
                     ANNVALD(IREC,IGRP,1) = ANNVALD(IREC,IGRP,1)/SNUMSCM
                     ANNVALW(IREC,IGRP,1) = ANNVALW(IREC,IGRP,1)/SNUMWET

                     ANNVAL(IREC,IGRP,1)=(ANNVALD(IREC,IGRP,1)*STOTDRY +
     &                                    ANNVALW(IREC,IGRP,1)*STOTWET)/
     &                                   (STOTDRY+STOTWET)

                  END IF

               ELSE

                  IF (SCIM .AND. .NOT.WETSCIM) THEN
                     ANNVAL(IREC,IGRP,ITYP) = ANNVAL(IREC,IGRP,ITYP)*
     &                                        (STOTHRS/SNUMSCM)
                  ELSEIF (SCIM .AND. OUTTYP(ITYP).EQ.'WDEP') THEN
                     ANNVAL(IREC,IGRP,ITYP) = ANNVALW(IREC,IGRP,ITYP)*
     &                                        (STOTWET/SNUMWET)
                  ELSEIF (SCIM .AND. WETSCIM) THEN
                     ANNVALD(IREC,IGRP,ITYP) = ANNVALD(IREC,IGRP,ITYP)/
     &                                         SNUMSCM
                     ANNVALW(IREC,IGRP,ITYP) = ANNVALW(IREC,IGRP,ITYP)/
     &                                         SNUMWET

                     ANNVAL(IREC,IGRP,ITYP)  =
     &                               (ANNVALD(IREC,IGRP,ITYP)*STOTDRY +
     &                                ANNVALW(IREC,IGRP,ITYP)*STOTWET)

                  ENDIF

               END IF

            END DO
C           End Receptor LOOP
         END DO
C        End Source Group LOOP
      END DO
C     End LOOP Over Output Types

      RETURN
      END

      SUBROUTINE SHAVE
C***********************************************************************
C                 SHAVE Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Calculates Season/Hour Averages
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    June 5, 1997
C
C        INPUTS:  Array of Season/Hour Sums and Counters
C
C        OUTPUTS: Season/Hour Output Files
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      REAL :: SNUM

C     Variable Initializations
      MODNAM = 'SHAVE'

C     Calculate Period Average Concentrations for Each Source Group and Receptor

      DO ISEAS = 1, 4
         DO IHOUR = 1, 24

C           Calculate Denominator Considering Calms and Missing
            SNUM = NSEAHR(ISEAS,IHOUR) - NSEACM(ISEAS,IHOUR)

C           Begin Source Group LOOP
            DO IGRP = 1, NUMGRP
C              Begin Receptor LOOP
               DO IREC = 1, NUMREC

                  SHVALS(IREC,IGRP,ISEAS,IHOUR,1) = (1./SNUM) *
     &            SHVALS(IREC,IGRP,ISEAS,IHOUR,1)

               END DO
C              End Receptor LOOP
            END DO
C           End Source Group LOOP

         END DO
      END DO

      RETURN
      END

      SUBROUTINE HIPER
C***********************************************************************
C                 HIPER Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Selects Highest PERIOD Average Values
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Changed parameter for specifying the number of
C                    high annual/period averages from NVAL to NHIANN.
C                    R.W. Brode, PES, Inc.,  4/3/98
C
C        INPUTS:  Array of Period Averages
C
C        OUTPUTS: Array of Highest Period Averages By Source Group
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: J

C     Variable Initializations
      MODNAM = 'HIPER'

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP
C        Begin Receptor LOOP
         DO IREC = 1, NUMREC
            IF (NHIANN .GT. 1) THEN
               IF (ANNVAL(IREC,IGRP,ITYP) .GT.
     &             AMXVAL(NHIANN,IGRP,ITYP)) THEN
                  DO J = NHIANN-1, 1, -1
                     IF (ANNVAL(IREC,IGRP,ITYP) .LE.
     &                      AMXVAL(J,IGRP,ITYP))THEN
                        AMXVAL(J+1,IGRP,ITYP) = ANNVAL(IREC,IGRP,ITYP)
                        IMXLOC(J+1,IGRP,ITYP) = IREC
C                       Exit Block
                        GO TO 200
                     ELSE
                        AMXVAL(J+1,IGRP,ITYP) = AMXVAL(J,IGRP,ITYP)
                        IMXLOC(J+1,IGRP,ITYP) = IMXLOC(J,IGRP,ITYP)
                        IF (J .EQ. 1) THEN
                           AMXVAL(1,IGRP,ITYP) = ANNVAL(IREC,IGRP,ITYP)
                           IMXLOC(1,IGRP,ITYP) = IREC
                        END IF
                     END IF
                  END DO
               END IF
            ELSE IF (NHIANN .EQ. 1) THEN
               IF (ANNVAL(IREC,IGRP,ITYP) .GT. AMXVAL(1,IGRP,ITYP)) THEN
                  AMXVAL(1,IGRP,ITYP) = ANNVAL(IREC,IGRP,ITYP)
                  IMXLOC(1,IGRP,ITYP) = IREC
               END IF
            END IF
 200        CONTINUE
         END DO
C        End Receptor LOOP
      END DO
C     End Source Group LOOP

      IF (MULTYR) THEN
C        Dump Results Arrays to SAVFIL                      ---   CALL RSDUMP
         CALL RSDUMP
      END IF

      RETURN
      END

      SUBROUTINE PSTANN
C***********************************************************************
C                 PSTANN Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Process Postprocessor Files for PERIOD Results
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION) - 11/8/93
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Postprocessing
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I
      CHARACTER PERCHR*6, HDRFRM*256

C     Variable Initializations
      MODNAM = 'PSTANN'

C     Set Averaging Label and Create Header Format for Columns
      IF (PERIOD) THEN
         PERCHR = 'PERIOD'
         WRITE(HDRFRM,9020) NUMTYP, NUMTYP+2
      ELSE IF (ANNUAL) THEN
         PERCHR = 'ANNUAL'
         WRITE(HDRFRM,9021) NUMTYP, NUMTYP+2
      END IF

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP
C        Check for Selection of PERIOD POSTFILE for This Group
         IF (IANPST(IGRP) .EQ. 1) THEN
            IF (IANFRM(IGRP) .EQ. 0) THEN
C              WRITE Results to Unformatted POSTFILE
               IF (PERIOD) THEN
                  WRITE(IAPUNT(IGRP),ERR=99) KURDAT, IANHRS,
     &            GRPID(IGRP), ((ANNVAL(IREC,IGRP,ITYP),IREC=1,NUMREC),
     &                           ITYP=1,NUMTYP)
               ELSE IF (ANNUAL) THEN
                  WRITE(IAPUNT(IGRP),ERR=99) KURDAT, NUMYRS,
     &            GRPID(IGRP), ((ANNVAL(IREC,IGRP,ITYP),IREC=1,NUMREC),
     &                           ITYP=1,NUMTYP)
               END IF
            ELSE
C              WRITE Results to Formatted Plot File
C              Write Header Information
               WRITE(IAPUNT(IGRP),9005) VERSN, TITLE1
               WRITE(IAPUNT(IGRP),9007) (MODOPS(I),I=1,19)
               WRITE(IAPUNT(IGRP),9010) PERCHR,GRPID(IGRP),NUMREC,PSTFRM
               WRITE(IAPUNT(IGRP),HDRFRM)(CHIDEP(1,ITYP),CHIDEP(2,ITYP),
     &                                   CHIDEP(3,ITYP),ITYP=1,NUMTYP)
C              Begin Receptor LOOP
               DO IREC = 1, NUMREC
                  IF (PERIOD) THEN
                     WRITE(IAPUNT(IGRP),PSTFRM,ERR=99)
     &                  AXR(IREC), AYR(IREC), (ANNVAL(IREC,IGRP,ITYP),
     &                                         ITYP=1,NUMTYP),
     &                  AZELEV(IREC), PERCHR, GRPID(IGRP), IANHRS,
     &                  NETID(IREC)
                  ELSE IF (ANNUAL) THEN
                     WRITE(IAPUNT(IGRP),PSTFRM,ERR=99)
     &                  AXR(IREC), AYR(IREC), (ANNVAL(IREC,IGRP,ITYP),
     &                                         ITYP=1,NUMTYP),
     &                  AZELEV(IREC), PERCHR, GRPID(IGRP), NUMYRS,
     &                  NETID(IREC)
                  END IF
               END DO
C              End Receptor LOOP
            END IF
         END IF
      END DO
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Postprocessor File
 99   WRITE(DUMMY,'("PSTFL",I3.3)') IAPUNT(IGRP)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCST3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',6(1X,A5),13(1X,A6))
 9010 FORMAT('*',9X,'POST/PLOT FILE OF ',A6,' VALUES FOR ',
     &       'SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ', I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''AVE'',5X,''GRP'',6X,''NUM HRS'',3X,''NET ID'',/,''*'',2X,'
     & ,I1,'(''___________'',3X),''______  ______  ________  ________'',
     &  ''  ________'')')
 9021 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''AVE'',5X,''GRP'',6X,''NUM YRS'',3X,''NET ID'',/,''*'',2X,'
     & ,I1,'(''___________'',3X),''______  ______  ________  ________'',
     &  ''  ________'')')

 999  RETURN
      END

      SUBROUTINE PLTANN
C***********************************************************************
C                 PLTANN Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Process Files To Plot Annual (i.e. PERIOD) Results
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION) - 11/8/93
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I
      CHARACTER PERCHR*6, HDRFRM*256

C     Variable Initializations
      MODNAM = 'PLTANN'

C     Set Averaging Label and Create Header Format for Columns
      IF (PERIOD) THEN
         PERCHR = 'PERIOD'
         WRITE(HDRFRM,9020) NUMTYP, NUMTYP+2
      ELSE IF (ANNUAL) THEN
         PERCHR = 'ANNUAL'
         WRITE(HDRFRM,9021) NUMTYP, NUMTYP+2
      END IF

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP
C        Check for Selection of PERIOD PLOTFILE for This Group
         IF (IANPLT(IGRP) .EQ. 1) THEN
C           Write Header Information
            WRITE(IPPUNT(IGRP),9005) VERSN, TITLE1
            WRITE(IPPUNT(IGRP),9007) (MODOPS(I),I=1,19)
            WRITE(IPPUNT(IGRP),9010) PERCHR, GRPID(IGRP), NUMREC, PSTFRM
            WRITE(IPPUNT(IGRP),HDRFRM) (CHIDEP(1,ITYP),CHIDEP(2,ITYP),
     &                                CHIDEP(3,ITYP),ITYP=1,NUMTYP)
C           Begin Receptor LOOP
            DO IREC = 1, NUMREC
               IF (PERIOD) THEN
                  WRITE(IPPUNT(IGRP),PSTFRM,ERR=99)
     &            AXR(IREC), AYR(IREC), (ANNVAL(IREC,IGRP,ITYP),
     &            ITYP=1,NUMTYP),AZELEV(IREC),PERCHR,GRPID(IGRP),IANHRS,
     &            NETID(IREC)
               ELSE IF (ANNUAL) THEN
                  WRITE(IPPUNT(IGRP),PSTFRM,ERR=99)
     &            AXR(IREC), AYR(IREC), (ANNVAL(IREC,IGRP,ITYP),
     &            ITYP=1,NUMTYP),AZELEV(IREC),PERCHR,GRPID(IGRP),NUMYRS,
     &            NETID(IREC)
               END IF
            END DO
C           End Receptor LOOP
         END IF
      END DO
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Plot File
 99   WRITE(DUMMY,'("PLTFL",I3.3)') IPPUNT(IGRP)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCST3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',6(1X,A5),13(1X,A6))
 9010 FORMAT('*',9X,'PLOT FILE OF ',A6,' VALUES FOR ',
     &       'SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ', I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''AVE'',5X,''GRP'',6X,''NUM HRS'',3X,''NET ID'',/,''*'',2X,'
     & ,I1,'(''___________'',3X),''______  ______  ________  ________'',
     &  ''  ________'')')
 9021 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''AVE'',5X,''GRP'',6X,''NUM YRS'',3X,''NET ID'',/,''*'',2X,'
     & ,I1,'(''___________'',3X),''______  ______  ________  ________'',
     &  ''  ________'')')

 999  RETURN
      END

      SUBROUTINE PLOTFL
C***********************************************************************
C                 PLOTFL Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Process Files To Plot
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Corrected to output SUMH4H array for post-1997
C                    PM10 processing.
C                    R.W. Brode, PES, Inc.,  12/2/98
C
C        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION) - 11/8/93
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, IVAL
      CHARACTER NCHR2(10)*4, HDRFRM*256

C     Variable Initializations
      DATA (NCHR2(I),I=1,10) /'1ST','2ND','3RD','4TH','5TH','6TH',
     &                        '7TH','8TH','9TH','10TH'/
      MODNAM = 'PLOTFL'

C     Create Header Format for Columns
      WRITE(HDRFRM,9020) NUMTYP, NUMTYP+2

C     Begin Averaging Period LOOP
      DO IAVE = 1, NUMAVE
C        Begin Source Group LOOP
         DO IGRP = 1, NUMGRP
C           Begin High Value LOOP
            DO IVAL = 1, NHIVAL
C              Decide if we should go through the processing
               IF (IPLTFL(IVAL,IGRP,IAVE) .EQ. 1) THEN
C                 Write Header Information
                  WRITE(IPLUNT(IVAL,IGRP,IAVE),9005) VERSN, TITLE1
                  WRITE(IPLUNT(IVAL,IGRP,IAVE),9007) (MODOPS(I),I=1,19)
                  IF (PM10AVE) THEN
                     WRITE(IPLUNT(IVAL,IGRP,IAVE),9009) NCHR2(IVAL),
     &                       CHRAVE(IAVE), GRPID(IGRP), NUMREC, PLTFRM
                  ELSE
                     WRITE(IPLUNT(IVAL,IGRP,IAVE),9010) NCHR2(IVAL),
     &                       CHRAVE(IAVE), GRPID(IGRP), NUMREC, PLTFRM
                  END IF
                  WRITE(IPLUNT(IVAL,IGRP,IAVE),HDRFRM) (CHIDEP(1,ITYP),
     &                      CHIDEP(2,ITYP),CHIDEP(3,ITYP),ITYP=1,NUMTYP)
C                 Begin Receptor LOOP
                  DO IREC = 1, NUMREC
                     IF (PM10AVE) THEN
                        WRITE(IPLUNT(IVAL,IGRP,IAVE),PLTFRM,ERR=99)
     &                   AXR(IREC), AYR(IREC), SUMH4H(IREC,IGRP),
     &                   AZELEV(IREC),CHRAVE(IAVE),GRPID(IGRP),
     &                   NCHR2(IVAL),NETID(IREC)
                     ELSE
                        WRITE(IPLUNT(IVAL,IGRP,IAVE),PLTFRM,ERR=99)
     &                   AXR(IREC), AYR(IREC), (HIVALU(IREC,IVAL,IGRP,
     &                   IAVE,ITYP),ITYP=1,NUMTYP),
     &                   AZELEV(IREC),CHRAVE(IAVE),GRPID(IGRP),
     &                   NCHR2(IVAL),NETID(IREC)
                     END IF
                  END DO
C                 End Receptor LOOP
               END IF
            END DO
C           End High Value LOOP
         END DO
C        End Source Group LOOP
      END DO
C     End Averaging Period LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Plot File
 99   WRITE(DUMMY,'("PLTFL",I3.3)') IPLUNT(IVAL,IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCST3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',6(1X,A5),13(1X,A6))
 9009 FORMAT('*',9X,'PLOT FILE OF AVERAGE  HIGH ',A4,' HIGH ',A5,
     &       ' VALUES FOR SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ',I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9010 FORMAT('*',9X,'PLOT FILE OF  HIGH ',A4,' HIGH ',A5,
     &       ' VALUES FOR SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ',I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''AVE'',5X,''GRP'',7X,''HIVAL'',4X,''NET ID'',/,''*'',2X,',
     &  I1,'(''___________'',3X),''______  ______  ________  ________'',
     &  ''  ________'')')

 999  RETURN
      END

      SUBROUTINE OUTPUT
C***********************************************************************
C                 OUTPUT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Controls Output of Printed Model Results
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To write out "EV STARTING" and "EV FINSISHED" to
C                    temporary event file if no RECTABLE card is used.
C                    R. Brode, PES, Inc. - 02/19/99
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE

C     Variable Initializations
      MODNAM = 'OUTPUT'
      PATH = 'OU'

      IF (PERIOD .OR. ANNUAL) THEN
         DO ITYP = 1, NUMTYP
C           Print Out Summary of Period Averages            ---   CALL PRTANN
            CALL PRTANN
         END DO
      END IF

      IF (PM10AVE .AND. NUMAVE.EQ.1) THEN
C        Print Out Table of Average H4H Values
         DO ITYP = 1, NUMTYP
            CALL PRTPM10
         END DO
         CALL MAXPM10
      ELSE IF (NHIVAL .GT. 0) THEN
         DO ITYP = 1, NUMTYP
C           Print Out Summary of High Values by Receptor    ---   CALL PRTNHI
            CALL PRTNHI
         END DO
      ELSE IF (EVENTS) THEN
C        Write the 'EV STARTING' and 'EV FINISHED' Cards to the Temp-EVent File
         WRITE(ITEVUT,9000)
         WRITE(ITEVUT,9001)
 9000    FORMAT('EV STARTING')
 9001    FORMAT('EV FINISHED')
      END IF

      IF (NMXVAL .GT. 0) THEN
         DO ITYP = 1, NUMTYP
C           Print Out Summary of Overall Maximum Values     ---   CALL PRTMAX
            CALL PRTMAX
         END DO
      END IF

      IF (PM10AVE) THEN
         DO ITYP = 1, NUMTYP
            CALL PRTPM10SUM
         END DO
      ELSE IF (PERIOD .OR. ANNUAL .OR. NHIVAL .GT. 0) THEN
         DO ITYP = 1, NUMTYP
C           Generate The Summary Result                     ---   CALL PRTSUM
            CALL PRTSUM
         END DO
      END IF

      IF (SEASONHR) THEN
         CALL SHOUT
      END IF

C     Generate The EVENT Input File                         ---   CALL EVEFIL
      IF (EVENTS) THEN
         CALL EVEFIL
      END IF

      RETURN
      END

      SUBROUTINE PRTANN
C***********************************************************************
C                 PRTANN Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Annual Average Data
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To adjust format statement 9082 for BOUNDARY receptors
C                    to better accommodate UTM coordinates - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, II, NX, NY, INDZ, INDC, ISRF
      REAL    :: YCOVAL, XRMS, YRMS, DIST, DIR
      CHARACTER PERCHR*6, BUF132*132

C     Variable Initializations
      MODNAM = 'PRTANN'
      IF (PERIOD) THEN
         PERCHR = 'PERIOD'
      ELSE IF (ANNUAL) THEN
         PERCHR = 'ANNUAL'
      END IF

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP

C        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            END IF
         END DO
C        Check for More Than 31 Sources Per Group
         IF (INDGRP .GT. 31) THEN
            WORKID(31) = ' . . . '
            INDGRP = 31
         END IF

C        Print Receptor Network Coordinates:
C        Set Number of Columns Per Page, NCPP
         NCPP = 9
C        Set Number of Rows Per Page, NRPP
         NRPP = 40
C        Begin LOOP Through Networks
         DO I = 1, INNET
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1, NPPX
               DO NY = 1, NPPY
                  CALL HEADER
                  IF (PERIOD) THEN
                     WRITE(IOUNIT,9032) PERCHR, IANHRS,
     &     (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                  ELSE IF (ANNUAL) THEN
                     WRITE(IOUNIT,9033) PERCHR, NUMYRS,
     &     (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                  END IF
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
C                 Print The Values By Source Group
                  WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,PERLBL(ITYP)
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &            (ANNVAL(INDZ+J-1,IGRP,ITYP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &              (ANNVAL(INDZ+J-1,IGRP,ITYP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  ELSE
                     DO K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &            (ANNVAL(INDZ+J-1,IGRP,ITYP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &              (ANNVAL(INDZ+J-1,IGRP,ITYP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  END IF
               END DO
            END DO
         END DO
C        End LOOP Through Networks

         IF (IRSTAT(4) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DC') THEN
                  INDC = INDC + 1
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     IF (PERIOD) THEN
                      WRITE(IOUNIT,9032) PERCHR,IANHRS,(CHIDEP(II,ITYP),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     ELSE IF (ANNUAL) THEN
                      WRITE(IOUNIT,9033) PERCHR,NUMYRS,(CHIDEP(II,ITYP),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     END IF
                     WRITE(IOUNIT,9043)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                     WRITE(IOUNIT,9048) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:60),9045) AXR(IREC), AYR(IREC),
     &                     ANNVAL(IREC,IGRP,ITYP)
                  ELSE
                     WRITE(BUF132(61:120),9045) AXR(IREC), AYR(IREC),
     &                     ANNVAL(IREC,IGRP,ITYP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(5) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DP') THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS + YRMS*YRMS)
                  DIR  = ATAN2(XRMS, YRMS) * RTODEG
                  IF (DIR .LE. 0.0) DIR = DIR + 360.
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     IF (PERIOD) THEN
                      WRITE(IOUNIT,9032) PERCHR,IANHRS,(CHIDEP(II,ITYP),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     ELSE IF (ANNUAL) THEN
                      WRITE(IOUNIT,9033) PERCHR,NUMYRS,(CHIDEP(II,ITYP),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     END IF
                     WRITE(IOUNIT,9044)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                     WRITE(IOUNIT,9049) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:65),9047) SRCID(IREF(IREC)), DIST,
     &                                       DIR, ANNVAL(IREC,IGRP,ITYP)
                  ELSE
                     WRITE(BUF132(66:130),9047) SRCID(IREF(IREC)), DIST,
     &                                       DIR, ANNVAL(IREC,IGRP,ITYP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

C        Write Out The Boundary Receptors For The Sources
         IF (IRSTAT(6) .NE. 0) THEN
            INDC = 0
            IREC = 1
            DO WHILE (IREC .LE. NUMREC)
               IF (RECTYP(IREC) .EQ. 'BD') THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF (MOD(INDC-1,3) .EQ. 0) THEN
                     CALL HEADER
                     IF (PERIOD) THEN
                      WRITE(IOUNIT,9032) PERCHR,IANHRS,(CHIDEP(II,ITYP),
     &                II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     ELSE IF (ANNUAL) THEN
                      WRITE(IOUNIT,9033) PERCHR,NUMYRS,(CHIDEP(II,ITYP),
     &                II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     END IF
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                  END IF
                  WRITE(IOUNIT,9082) SRCID(ISRF), SRCTYP(ISRF),
     &                AXS(ISRF), AYS(ISRF), AZS(ISRF), CHIDEP(3,ITYP),
     &                CHIDEP(3,ITYP), CHIDEP(3,ITYP), (J, AXR(IREC+J-1),
     &                AYR(IREC+J-1), ANNVAL(IREC+J-1,IGRP,ITYP),J=1,36)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               END IF
            END DO
         END IF

C     End Source Group Loop
      END DO

 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9010 FORMAT(66(' -')/)
 9013 FORMAT(2X,F10.2,1X,'|',1X,9(F13.5))
 9016 FORMAT(3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT(3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT(3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT(3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9032 FORMAT(30X,'*** THE ',A6,' (',I6,' HRS) ',6A4,
     &       'VALUES FOR SOURCE GROUP:',1X,A8,' ***',
     &       /34X,'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /10X,12(A8,', ',:)/10X,12(A8,', ',:))
 9033 FORMAT(30X,'*** THE ',A6,' (',I4,' YRS) ',6A4,
     &       'VALUES FOR SOURCE GROUP:',1X,A8,' ***',
     &       /34X,'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /10X,12(A8,', ',:)/10X,12(A8,', ',:))
 9037 FORMAT(/35X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTOR POINTS ***')
 9044 FORMAT(/47X,'*** DISCRETE POLAR RECEPTOR POINTS ***')
 9045 FORMAT(6X,2(F12.2,2X),F13.5)
 9047 FORMAT(4X,A8,': ',2(F12.2,2X),F13.5)
 9048 FORMAT(6X,' X-COORD (M)   Y-COORD (M)        ',A4,
     &      22X,' X-COORD (M)   Y-COORD (M)        ',A4,/65(' -'))
 9049 FORMAT(5X,'ORIGIN',59X,'ORIGIN',
     &      /5X,' SRCID       DIST (M)     DIR (DEG)        ',A4,
     &      18X,' SRCID       DIST (M)     DIR (DEG)        ',A4,
     &      /65(' -'))
 9082 FORMAT(' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &       F10.2,')'/3(' (SEC.)  X-COORD    Y-COORD       ',A4,6X),/,
     &       12(3(1X,I4,2X,F9.1,',',F10.1,',',F13.5,' ',2X),/),/)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE PRTNHI
C***********************************************************************
C                 PRTNHI Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Specified Highest Value
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To store high short term values in global arrays
C                    rather than local arrays for later summary table
C                    output.
C                    R.W. Brode, PES, Inc. - August 15, 1995.
C
C        MODIFIED:   To add one more decimal place to receptor elevations
C                    and flagpole heights for the temporary event file.
C                    R.W. Brode, PES, Inc. - November 15, 1995.
C
C        INPUTS:  Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs for Short Term Values
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IWHP(NVAL), IHST, IVAL, K, IT1, KWRT
      REAL    :: XR2, YR2, ZE2, ZF2
      CHARACTER NAMEEV*8

C     Variable Initialization
      MODNAM = 'PRTNHI'

C     Write Out the 'EV STARTING' Card to the Temp-EVent File for
C     First Output Type Only (i.e., ITYP = 1)
      IF (ITYP .EQ. 1) THEN
         WRITE(ITEVUT,9000)
      END IF

      DO IAVE = 1, NUMAVE
C        Decide if Print The Period
         IHST = 0
         DO IVAL = 1, NVAL
            IF (NHIAVE(IVAL,IAVE) .EQ. 1) THEN
               IHST = IHST + 1
               IWHP(IHST) = IVAL
            END IF
         END DO
         IF (IHST .EQ. 0) THEN
C           No High Values for This IAVE; Cycle to Next Averaging Period
            CYCLE
         END IF
C        Print The Data
         DO IVAL = 1, NVAL
            IF (NHIAVE(IVAL,IAVE) .EQ. 1) THEN
C              Print Out High Value By Receptor Table       ---   CALL SPRTHT
               CALL SPRTHT(IVAL)
            END IF
         END DO
C        Print Out The Temporary File
         DO IGRP = 1, NUMGRP
C           Print Out the High Values
            DO IREC = 1, NUMREC
C               Get The Maximum in Nth Highest
                DO K = 1, IHST
                   IF (HIVALU(IREC,IWHP(K),IGRP,IAVE,ITYP) .GT.
     &                  HMAX(K,IGRP,IAVE,ITYP)) THEN
          HMAX(K,IGRP,IAVE,ITYP)   = HIVALU(IREC,IWHP(K),IGRP,IAVE,ITYP)
          HMDATE(K,IGRP,IAVE,ITYP) = NHIDAT(IREC,IWHP(K),IGRP,IAVE,ITYP)
          HMCLM(K,IGRP,IAVE,ITYP)  = HCLMSG(IREC,IWHP(K),IGRP,IAVE,ITYP)
          HMLOC(K,IGRP,IAVE,ITYP)  = IREC
                   END IF
               END DO
            END DO
C
C           Output The Max-Upto-IHST to the TempEVent File for the
C           First Output Type Only (i.e., ITYP = 1)
            IF (ITYP .EQ. 1) THEN
               DO K = 1, IHST
                  IT1 = MOD(IWHP(K),10)
                  IF (HMLOC(K,IGRP,IAVE,ITYP) .EQ. 0) THEN
                     XR2 = 0.0
                     YR2 = 0.0
                     ZE2 = 0.0
                     ZF2 = 0.0
                  ELSE
                     XR2 = AXR(HMLOC(K,IGRP,IAVE,ITYP))
                     YR2 = AYR(HMLOC(K,IGRP,IAVE,ITYP))
                     ZE2 = AZELEV(HMLOC(K,IGRP,IAVE,ITYP))
                     ZF2 = AZFLAG(HMLOC(K,IGRP,IAVE,ITYP))
                  END IF
                  IF (KAVE(IAVE) .LE. 24) THEN
                     WRITE(NAMEEV,'(A1,I1,A1,I2.2,I3.3)')
     &                       'H',IT1,'H',KAVE(IAVE),IGRP
                  ELSE
C                    KAVE > 24 Means MONTH Average; Write Out as 72 (=720/10)
                     KWRT = KAVE(IAVE)/10
                     WRITE(NAMEEV,'(A1,I1,A1,I2.2,I3.3)')
     &                       'H',IT1,'H',KWRT,IGRP
                  END IF
                  WRITE(ITEVUT,9001) NAMEEV, KAVE(IAVE),
     &                  GRPID(IGRP), HMDATE(K,IGRP,IAVE,ITYP),
     &                  HMAX(K,IGRP,IAVE,ITYP), HMCLM(K,IGRP,IAVE,ITYP),
     &                  HMLOC(K,IGRP,IAVE,ITYP)
                  WRITE(ITEVUT,9002) NAMEEV, XR2, YR2, ZE2, ZF2
               END DO
            END IF

         END DO

      END DO

C     Write Out the 'EV FINISHED' Card to the Temp-EVent File for
C     First Output Type Only (i.e., ITYP = 1)
      IF (ITYP .EQ. 1) THEN
         WRITE(ITEVUT,9009)
      END IF

 9000 FORMAT('EV STARTING')
 9001 FORMAT(3X,'EVENTPER',1X,A8,1X,I3,2X,A8,3X,I8.8,3X,F14.5,1X,A1,
     &       1X,I5)
 9002 FORMAT(3X,'EVENTLOC',1X,A8,1X,'XR= ',F14.5,' YR= ',F14.5,
     &       2(1X,F10.4))
 9009 FORMAT('EV FINISHED')

      RETURN
      END

      SUBROUTINE SPRTHT(IHNUM)
C***********************************************************************
C                 SPRTHT Module of ISC Short Term Model
C
C        PURPOSE: Print Out The Highest Result Values by Receptor Net
C
C        PROGRAMMER: ROGER BRODE, JEFF WANG
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To adjust format statement 9082 for BOUNDARY receptors
C                    to better accommodate UTM coordinates - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IHNUM, I, J, K, II, INDZ, INDC, NX, NY, ISRF
      REAL    :: YCOVAL, XRMS, YRMS, DIST, DIR
      CHARACTER BUF132*132, CHRVAL(10)*4

C     Variable Initializations
      DATA (CHRVAL(I),I=1,10)/' 1ST',' 2ND',' 3RD',' 4TH',' 5TH',
     &                        ' 6TH',' 7TH',' 8TH',' 9TH','10TH'/
      MODNAM = 'SPRTHT'

      DO IGRP = 1, NUMGRP

C        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            END IF
         END DO
C        Check for More Than 31 Sources Per Group
         IF (INDGRP .GT. 31) THEN
            WORKID(31) = ' . . . '
            INDGRP = 31
         END IF

C        Print Receptor Network Coordinates:
C        Set Number of Columns Per Page, NCPP
         NCPP = 5
C        Set Number of Rows Per Page, NRPP
         NRPP = 40
C        Begin LOOP Through Networks
         DO I = 1, INNET
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1, NPPX
               DO NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9032) CHRVAL(IHNUM),CHRAVE(IAVE),
     &       (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(J),J=1,INDGRP)
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
C                 Print The Values By Source Group
                  WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                               OUTLBL(ITYP)
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                       (HIVALU(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        HCLMSG(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        NHIDAT(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                       (HIVALU(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        HCLMSG(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        NHIDAT(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  ELSE
                     DO K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                       (HIVALU(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        HCLMSG(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        NHIDAT(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                       (HIVALU(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        HCLMSG(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        NHIDAT(INDZ+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                        J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  END IF
               END DO
            END DO
         END DO
C        End LOOP Through Networks

         IF (IRSTAT(4) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DC') THEN
                  INDC = INDC + 1
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) CHRVAL(IHNUM), CHRAVE(IAVE),
     &       (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(J),J=1,INDGRP)
                     WRITE(IOUNIT,9043)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  OUTLBL(ITYP)
                     WRITE(IOUNIT,9048) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:65),9045) AXR(IREC), AYR(IREC),
     &                     HIVALU(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                     HCLMSG(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                     NHIDAT(IREC,IHNUM,IGRP,IAVE,ITYP)
                  ELSE
                     WRITE(BUF132(66:130),9045) AXR(IREC), AYR(IREC),
     &                     HIVALU(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                     HCLMSG(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                     NHIDAT(IREC,IHNUM,IGRP,IAVE,ITYP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(5) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DP') THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS + YRMS*YRMS)
                  DIR  = ATAN2(XRMS, YRMS) * RTODEG
                  IF (DIR .LE. 0.0) DIR = DIR + 360.
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) CHRVAL(IHNUM), CHRAVE(IAVE),
     &       (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(J),J=1,INDGRP)
                     WRITE(IOUNIT,9044)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  OUTLBL(ITYP)
                     WRITE(IOUNIT,9049) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:66),9047) SRCID(IREF(IREC)), DIST,
     &                       DIR, HIVALU(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                            HCLMSG(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                            NHIDAT(IREC,IHNUM,IGRP,IAVE,ITYP)
                  ELSE
                     WRITE(BUF132(67:132),9047) SRCID(IREF(IREC)), DIST,
     &                       DIR, HIVALU(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                            HCLMSG(IREC,IHNUM,IGRP,IAVE,ITYP),
     &                            NHIDAT(IREC,IHNUM,IGRP,IAVE,ITYP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

C        Write Out The Boundary Receptors For The Sources
         IF (IRSTAT(6) .NE. 0) THEN
            INDC = 0
            IREC = 1
            DO WHILE (IREC .LE. NUMREC)
               IF (RECTYP(IREC) .EQ. 'BD') THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF (MOD(INDC-1,2) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) CHRVAL(IHNUM), CHRAVE(IAVE),
     &       (CHIDEP(II,ITYP),II=1,6),GRPID(IGRP),(WORKID(J),J=1,INDGRP)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  OUTLBL(ITYP)
                  END IF
                  WRITE(IOUNIT,9082) SRCID(ISRF),SRCTYP(ISRF),AXS(ISRF),
     &             AYS(ISRF), AZS(ISRF), CHIDEP(3,ITYP), CHIDEP(3,ITYP),
     &                (J,AXR(IREC+J-1),AYR(IREC+J-1),
     &                HIVALU(IREC+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                HCLMSG(IREC+J-1,IHNUM,IGRP,IAVE,ITYP),
     &                NHIDAT(IREC+J-1,IHNUM,IGRP,IAVE,ITYP),J=1,36)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               END IF
            END DO
         END IF

      END DO

 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9010 FORMAT(66(' -')/)
 9016 FORMAT(1X,' Y-COORD  |',50X,'X-COORD (METERS)')
 9017 FORMAT(1X,' (METERS) |',3X,F13.2,4(11X,F13.2,:))
 9018 FORMAT(1X,'DIRECTION |',50X,'DISTANCE (METERS)')
 9019 FORMAT(1X,'(DEGREES) |',3X,F13.2,4(11X,F13.2,:))
 9013 FORMAT(1X,F9.1,1X,'|',5(F13.5,A1,'(',I8.8,')',:))
 9032 FORMAT(30X,'*** THE  ',A4,' HIGHEST ',A5,1X,6A4,
     &       'VALUES FOR SOURCE GROUP:',2X,A8,' ***',
     &       /34X,'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /10X,12(A8,', ':)/10X,12(A8,', ':))
 9037 FORMAT(/35X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTOR POINTS ***')
 9044 FORMAT(/47X,'*** DISCRETE POLAR RECEPTOR POINTS ***')
 9045 FORMAT(6X,2(F11.2,2X),F13.5,A1,1X,'(',I8.8,')')
 9047 FORMAT(4X,A8,': ',2(F11.2,2X),F13.5,A1,1X,'(',I8.8,')')
 9048 FORMAT(6X,'X-COORD (M)  Y-COORD (M)        ',A4,5X,'(YYMMDDHH)',
     &      14X,'X-COORD (M)  Y-COORD (M)        ',A4,5X,'(YYMMDDHH)',
     &      /66(' -'))
 9049 FORMAT(5X,'ORIGIN',60X,'ORIGIN',
     &      /5X,' SRCID      DIST (M)    DIR (DEG)        ',A4,
     &       5X,'(YYMMDDHH)',
     &       6X,' SRCID      DIST (M)    DIR (DEG)        ',A4,
     &       5X,'(YYMMDDHH)',
     &      /66(' -'))
 9082 FORMAT(' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &       F10.2,')'/2(' (SEC.)    X-COORD     Y-COORD       ',A4,
     &       '    (YYMMDDHH)',7X),/,
     &       18(2(1X,I4,3X,F10.2,', ',F10.2,',',F13.5,A1,'(',I8.8,')',
     &       7X),/),/)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE PRTMAX
C***********************************************************************
C                 PRTMAX Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out The Overall Maximum Value Tables
C
C        PROGRAMMER: Jeff Wang, Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To correct potential error when IMXVAL = 1 and
C                    MXLOCA = 0.  R.W. Brode, PES, Inc. - 12/2/98
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: J, K, L, NPG, NROWS, JSTRT, II, J1, KMAX1, KMAX2
      REAL    :: XR1, YR1, XR2, YR2
      CHARACTER NTY1*2, NTY2*2

C     Variable Initializations
      MODNAM = 'PRTMAX'

      DO IAVE = 1, NUMAVE
C        Check Array to See IF Maximum Values Are Needed For This AVEPER
         IF (MAXAVE(IAVE) .NE. 1) CYCLE

         DO IGRP = 1, NUMGRP
            INDGRP = 0

C           Assign The Group ID
            DO ISRC = 1, NUMSRC
               IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
                  INDGRP = INDGRP + 1
                  WORKID(INDGRP) = SRCID(ISRC)
               END IF
            END DO
C           Check for More Than 31 Sources Per Group
            IF (INDGRP .GT. 31) THEN
               WORKID(31) = ' . . . '
               INDGRP = 31
            END IF

            IF (IMXVAL(IAVE) .GE. 2) THEN
C              Determine Number of Pages @ 80 Per Page, NPG
               NPG = 1 + INT((IMXVAL(IAVE)-1)/80)
               DO L = 1, NPG
C                 Determine Number of Rows for This Page, NROWS
                  IF (L .EQ. NPG) THEN
                     NROWS = (IMXVAL(IAVE)-80*(L-1))/2
                  ELSE
                     NROWS = 40
                  END IF
C                 Write Out Header Information for This Page
                  CALL HEADER
                  WRITE(IOUNIT,9032) IMXVAL(IAVE), CHRAVE(IAVE),
     &              (CHIDEP(II,ITYP),II=1,6), GRPID(IGRP), (WORKID(K),
     &                                              K = 1,INDGRP)
                  WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                               OUTLBL(ITYP)
                  WRITE(IOUNIT,1) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
C                 Set Start Row of Loop for This Page, JSTRT
                  JSTRT = 1 + 80*(L-1)
                  DO J = JSTRT, JSTRT+NROWS-1
                     J1 = J + NROWS
                     IF (L.EQ.NPG .AND. MOD(IMXVAL(IAVE),2).NE.0) THEN
                        J1 = J1 + 1
                     END IF
                     KMAX1 = MXLOCA(J,IGRP,IAVE,ITYP)
                     KMAX2 = MXLOCA(J1,IGRP,IAVE,ITYP)
                     IF (KMAX1 .EQ. 0) THEN
                        XR1 = 0.
                        YR1 = 0.
                        NTY1 = ' '
                     ELSE
                        XR1 = AXR(KMAX1)
                        YR1 = AYR(KMAX1)
                        NTY1 = RECTYP(KMAX1)
                     END IF
                     IF (KMAX2 .EQ. 0) THEN
                        XR2 = 0.
                        YR2 = 0.
                        NTY2 = ' '
                     ELSE
                        XR2 = AXR(KMAX2)
                        YR2 = AYR(KMAX2)
                        NTY2 = RECTYP(KMAX2)
                     END IF
                     WRITE(IOUNIT,2) J, RMXVAL(J,IGRP,IAVE,ITYP),
     &               MCLMSG(J,IGRP,IAVE,ITYP), MXDATE(J,IGRP,IAVE,ITYP),
     &                XR1, YR1, NTY1, J1,
     &             RMXVAL(J1,IGRP,IAVE,ITYP), MCLMSG(J1,IGRP,IAVE,ITYP),
     &                 MXDATE(J1,IGRP,IAVE,ITYP), XR2, YR2, NTY2
                  END DO
               END DO
               IF (MOD(IMXVAL(IAVE),2) .NE. 0) THEN
C                 Odd Number of Max Values - Print Out Last Value
                  J = INT(IMXVAL(IAVE)/2) + 1 + 40*(NPG-1)
                  KMAX1 = MXLOCA(J,IGRP,IAVE,ITYP)
                  IF (KMAX1 .EQ. 0) THEN
                     XR1 = 0.
                     YR1 = 0.
                     NTY1 = ' '
                  ELSE
                     XR1 = AXR(KMAX1)
                     YR1 = AYR(KMAX1)
                     NTY1 = RECTYP(KMAX1)
                  END IF
                  WRITE(IOUNIT,3) J, RMXVAL(J,IGRP,IAVE,ITYP),
     &               MCLMSG(J,IGRP,IAVE,ITYP), MXDATE(J,IGRP,IAVE,ITYP),
     &                  XR1, YR1, NTY1
               END IF
            ELSE
               J = 1
               KMAX1 = MXLOCA(J,IGRP,IAVE,ITYP)
               IF (KMAX1 .EQ. 0) THEN
                  XR1 = 0.0
                  YR1 = 0.0
                  NTY1 = '  '
               ELSE
                  XR1 = AXR(KMAX1)
                  YR1 = AYR(KMAX1)
                  NTY1 = RECTYP(KMAX1)
               END IF
               CALL HEADER
               WRITE(IOUNIT,9032) IMXVAL(IAVE), CHRAVE(IAVE),
     &           (CHIDEP(II,ITYP),II=1,6), GRPID(IGRP), (WORKID(K),
     &                                              K = 1,INDGRP)
               WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT, OUTLBL(ITYP)
               WRITE(IOUNIT,1) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
               WRITE(IOUNIT,3) J, RMXVAL(J,IGRP,IAVE,ITYP),
     &               MCLMSG(J,IGRP,IAVE,ITYP), MXDATE(J,IGRP,IAVE,ITYP),
     &               XR1, YR1, NTY1
            END IF

C           WRITE Out Explanation of Receptor Types
            WRITE(IOUNIT,9050)

         END DO
      END DO

 1    FORMAT(1X,'RANK',8X,A4,4X,'(YYMMDDHH) AT',6X,
     &           'RECEPTOR (XR,YR) OF TYPE ',3X,
     &           'RANK',8X,A4,4X,'(YYMMDDHH) AT',6X,
     &           'RECEPTOR (XR,YR) OF TYPE ',
     &           /66(' -'))
 2    FORMAT(1X,I4,'.',1X,F13.5,A1,'(',I8.8,') AT',1X,
     &          '(',F10.2,', ',F10.2,')  ',A2,5X,
     &          I4,'.',1X,F13.5,A1,'(',I8.8,') AT',1X,
     &          '(',F10.2,', ',F10.2,')  ',A2)
 3    FORMAT(1X,I4,'.',1X,F13.5,A1,'(',I8.8,') AT',1X,
     &          '(',F10.2,', ',F10.2,')  ',A2)
 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9032 FORMAT(32X,'*** THE MAXIMUM ',I4,2X,A5,1X,6A4,
     &       'VALUES FOR SOURCE GROUP:',2X,A8,' ***'
     &       /36X,'INCLUDING SOURCE(S):    ',
     &       7(A8,', ',:),/10x,12(A8,', ',:)/10x,12(A8,', ',:))
 9050 FORMAT(/1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                            /23X,'GP = GRIDPOLR',
     &                            /23X,'DC = DISCCART',
     &                            /23X,'DP = DISCPOLR',
     &                            /23X,'BD = BOUNDARY')

      RETURN
      END

      SUBROUTINE PRTSUM
C***********************************************************************
C                 PRTSUM Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Print Out the Result Summary Tables
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   Changed parameter for specifying the number of
C                    high annual/period averages from NVAL to NHIANN.
C                    R.W. Brode, PES, Inc.,  4/3/98
C
C        MODIFIED:   To use arrays for high short term values, rather
C                    than reading from temporary event file.
C                    R.W. Brode, PES, Inc. - August 15, 1995.
C
C        INPUTS:  EVENT.TMP File Which Contains Maximum Values
C
C        OUTPUTS: Result Summary Table By Average Period
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IWHP(NVAL), I, IVAL, INDMX, IHST, INDLOC
      REAL    :: AXR1, AYR1, AZELV1, AZFLG1, XR2, YR2, ZE2, ZF2
      CHARACTER PERCHR*6, RANK(10)*4

C     Variable Initializations
      DATA (RANK(I),I=1,10) /' 1ST',' 2ND',' 3RD',' 4TH',' 5TH',
     &                       ' 6TH',' 7TH',' 8TH',' 9TH','10TH'/
      MODNAM = 'PRTSUM'
      IF (PERIOD) THEN
         PERCHR = 'PERIOD'
      ELSE IF (ANNUAL) THEN
         PERCHR = 'ANNUAL'
      END IF

C     Print Maximum PERIOD Averages, If Appropriate
      IF (PERIOD .OR. ANNUAL) THEN
C        Calculate Number of Groups Per Page, NGPP
         NGPP = INT(40/(NHIANN+1))
         DO IGRP = 1, NUMGRP
            IF (MOD(IGRP-1, NGPP) .EQ. 0) THEN
               CALL HEADER
               IF (PERIOD) THEN
                  WRITE(IOUNIT,9021) PERCHR, IANHRS
               ELSE IF (ANNUAL) THEN
                  WRITE(IOUNIT,9023) PERCHR, NUMYRS
               END IF
               WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT, PERLBL(ITYP)
               WRITE(IOUNIT,9022) CHIDEP(1,ITYP), CHIDEP(2,ITYP),
     &                            CHIDEP(3,ITYP)
            END IF
            DO IVAL = 1, NHIANN
               INDMX = IMXLOC(IVAL,IGRP,ITYP)
               IF (IVAL .EQ. 1 .AND. INDMX .NE. 0) THEN
                  WRITE(IOUNIT,1012) GRPID(IGRP), RANK(IVAL),
     &                  AMXVAL(IVAL,IGRP,ITYP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               ELSE IF (IVAL .EQ. 1 .AND. INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1014) GRPID(IGRP), RANK(IVAL),
     &                AMXVAL(IVAL,IGRP,ITYP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE IF (INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1015) RANK(IVAL),
     &                AMXVAL(IVAL,IGRP,ITYP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE
                  WRITE(IOUNIT,1013) RANK(IVAL),
     &                  AMXVAL(IVAL,IGRP,ITYP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               END IF
            END DO
         END DO
C        WRITE Out Explanation of Receptor Types
         WRITE(IOUNIT,9050)
      END IF

C     Begin LOOP Through Averaging Periods
      DO IAVE = 1, NUMAVE
         IHST = 0
         DO IVAL = 1, NVAL
            IF (NHIAVE(IVAL,IAVE) .EQ. 1) THEN
               IHST = IHST + 1
               IWHP(IHST) = IVAL
            END IF
         END DO
         IF (IHST .EQ. 0) THEN
C           No High Values for This IAVE; Cycle to Next Averaging Period
            CYCLE
         END IF
C        Calculate Number of Groups Per Page, NGPP
         NGPP = INT(40/(IHST+1))

C        Begin Source Group LOOP
         DO IGRP = 1, NUMGRP
C           Begin LOOP Through High Values
            DO I = 1, IHST
               INDLOC = HMLOC(I,IGRP,IAVE,ITYP)
               IF (I .EQ. 1) THEN
                  IF (MOD(IGRP-1,NGPP) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9031) CHRAVE(IAVE)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP),POLLUT,
     &                                  OUTLBL(ITYP)
                     WRITE(IOUNIT,9032) CHIDEP(1,ITYP),
     &                                  CHIDEP(2,ITYP),CHIDEP(3,ITYP)
                  END IF
                  WRITE(IOUNIT,*) ' '
                  IF (INDLOC .EQ. 0) THEN
                     XR2 = 0.0
                     YR2 = 0.0
                     ZE2 = 0.0
                     ZF2 = 0.0
                     WRITE(IOUNIT,1004) GRPID(IGRP), RANK(IWHP(I)),
     &                  HMAX(I,IGRP,IAVE,ITYP),
     &                  HMCLM(I,IGRP,IAVE,ITYP),
     &                  HMDATE(I,IGRP,IAVE,ITYP),
     &                  XR2, YR2, ZE2, ZF2
                  ELSE
                     XR2 = AXR(INDLOC)
                     YR2 = AYR(INDLOC)
                     ZE2 = AZELEV(INDLOC)
                     ZF2 = AZFLAG(INDLOC)
                     WRITE(IOUNIT,1002) GRPID(IGRP), RANK(IWHP(I)),
     &                  HMAX(I,IGRP,IAVE,ITYP),
     &                  HMCLM(I,IGRP,IAVE,ITYP),
     &                  HMDATE(I,IGRP,IAVE,ITYP),
     &                  XR2, YR2, ZE2, ZF2, RECTYP(INDLOC),NETID(INDLOC)
                  END IF
               ELSE
                  IF (INDLOC .EQ. 0) THEN
                     XR2 = 0.0
                     YR2 = 0.0
                     ZE2 = 0.0
                     ZF2 = 0.0
                     WRITE(IOUNIT,1005) RANK(IWHP(I)),
     &                  HMAX(I,IGRP,IAVE,ITYP),
     &                  HMCLM(I,IGRP,IAVE,ITYP),
     &                  HMDATE(I,IGRP,IAVE,ITYP),
     &                  XR2, YR2, ZE2, ZF2
                  ELSE
                     XR2 = AXR(INDLOC)
                     YR2 = AYR(INDLOC)
                     ZE2 = AZELEV(INDLOC)
                     ZF2 = AZFLAG(INDLOC)
                     WRITE(IOUNIT,1003) RANK(IWHP(I)),
     &                  HMAX(I,IGRP,IAVE,ITYP),
     &                  HMCLM(I,IGRP,IAVE,ITYP),
     &                  HMDATE(I,IGRP,IAVE,ITYP),
     &                  XR2, YR2, ZE2, ZF2, RECTYP(INDLOC),NETID(INDLOC)
                  END IF
               END IF
            END DO
         END DO

C        WRITE Out Explanation of Receptor Types
         WRITE(IOUNIT,9050)

C     End loop through averaging periods
      END DO

 1001 FORMAT(A80)
 1002 FORMAT(1X,A8,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')',
     &       2X,A2,3X,A8)
 1003 FORMAT(9X,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')',
     &       2X,A2,3X,A8)
 1004 FORMAT(1X,A8,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1005 FORMAT(9X,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1012 FORMAT(/1X,A8,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')',2X,A2,3X,A8)
 1013 FORMAT(9X,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')',2X,A2,3X,A8)
 1014 FORMAT(/1X,A8,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1015 FORMAT(9X,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')')
 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9021 FORMAT(44X,'*** THE SUMMARY OF MAXIMUM ',A6,' (',I6,
     &       ' HRS) RESULTS ***'/)
 9023 FORMAT(44X,'*** THE SUMMARY OF MAXIMUM ',A6,' (',I4,
     &       ' YRS) RESULTS ***'/)
 9022 FORMAT(103X,'NETWORK',/1X,'GROUP ID',22X,3A4,
     &       16X,'RECEPTOR  (XR, YR, ZELEV, ZFLAG)',3X,'OF TYPE',
     &       2X,'GRID-ID',/60(' -'))
 9031 FORMAT(48X,'*** THE SUMMARY OF HIGHEST ',A5,' RESULTS ***'/)
 9032 FORMAT(54X,'DATE',62X,'NETWORK',/1X,'GROUP ID',25X,3A4,5X,
     &       '(YYMMDDHH)',13X,'RECEPTOR  (XR, YR, ZELEV, ZFLAG)',
     &       5X,'OF TYPE',2X,'GRID-ID',/65(' -'))
 9050 FORMAT(//1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                             /23X,'GP = GRIDPOLR',
     &                             /23X,'DC = DISCCART',
     &                             /23X,'DP = DISCPOLR',
     &                             /23X,'BD = BOUNDARY')

 1000 RETURN
      END

      SUBROUTINE EVEFIL
C***********************************************************************
C                 EVEFIL Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Generate EVENT Input File
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To allow for changes in the ISTRG PARAMETER, currently
C                    set to 132.  Also moved the code to insert a blank line
C                    after each pathway to SUB. SETUP.
C                    R.W. Brode, PES, Inc. - November 15, 1995.
C
C        INPUTS:  EVENT.TMP File Which Contains Maximum 10 Values
C
C        OUTPUTS: EVENT Input Runstream Image File
C
C        CALLED FROM: MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IAVEP
      REAL    :: CONC1
      CHARACTER EVFRM*20, EVFRM1*20, EVFRM2*20, EVFRM3*20
      LOGICAL HITIN

C     Variable Initializations
      MODNAM = 'EVEFIL'
      HITIN  = .FALSE.
      EOF    = .FALSE.

C     Setup WRITE format for runstream record,
C     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE(EVFRM,9300) ISTRG
 9300 FORMAT('(A',I3.3,')')
      WRITE(EVFRM1,9301) ISTRG
 9301 FORMAT('(1X,A',I3.3,')')
      WRITE(EVFRM2,9302) ISTRG
 9302 FORMAT('(2X,A',I3.3,')')
      WRITE(EVFRM3,9303) ISTRG
 9303 FORMAT('(3X,A',I3.3,')')

C     Rewind Temporary Event File
      REWIND ITEVUT

C     Read Records From The Temporary Event File
      DO WHILE (.NOT. EOF)
         IF (.NOT. HITIN) THEN
C           Not in the Event Pathway - Echo Input to EVENT File
            READ(ITEVUT,EVFRM,END=999) RUNST1
            IF (RUNST1(1:11) .EQ. 'EV STARTING') THEN
C              Event Pathway Starts - Set Logical Switch
               HITIN = .TRUE.
               IF (LOCB(1) .EQ. 1) THEN
                  WRITE(IEVUNT,EVFRM) RUNST1
               ELSE IF (LOCB(1) .EQ. 2) THEN
                  WRITE(IEVUNT,EVFRM1) RUNST1
               ELSE IF (LOCB(1) .EQ. 3) THEN
                  WRITE(IEVUNT,EVFRM2) RUNST1
               ELSE IF (LOCB(1) .EQ. 4) THEN
                  WRITE(IEVUNT,EVFRM3) RUNST1
               END IF
            ELSE
               WRITE(IEVUNT,EVFRM) RUNST1
            END IF
         ELSE
            READ(ITEVUT,EVFRM,END=999) RUNST1
            IF (RUNST1(1:11) .EQ. 'EV FINISHED') THEN
               IF (MXFILE) THEN
C                 Add Events From Max Value (>Thresh) Files ---   CALL MXEVNT
                  CALL MXEVNT
               END IF
               IF (LOCB(1) .EQ. 1) THEN
                  WRITE(IEVUNT,EVFRM) RUNST1
               ELSE IF (LOCB(1) .EQ. 2) THEN
                  WRITE(IEVUNT,EVFRM1) RUNST1
               ELSE IF (LOCB(1) .EQ. 3) THEN
                  WRITE(IEVUNT,EVFRM2) RUNST1
               ELSE IF (LOCB(1) .EQ. 4) THEN
                  WRITE(IEVUNT,EVFRM3) RUNST1
               END IF
               HITIN = .FALSE.
            END IF
            IF (HITIN .AND. RUNST1(1:11).EQ.'   EVENTPER') THEN
               READ(RUNST1(22:),'(I3)') IAVEP
               READ(RUNST1(38:),'(F14.5)',ERR=99) CONC1
            END IF

            GO TO 100

C           Write Out Warning Message:  Error Reading CONC From TmpEvent File
 99         CALL ERRHDL(PATH,MODNAM,'W','570',RUNST1(13:20))
C           Set CONC1 To Large Value for Event File
            CONC1 = 1.0E9

 100        CONTINUE
            IF (HITIN. AND. IAVEP.NE.720 .AND. CONC1.NE.0.0) THEN
C              Write Out EVENTPER & EVENTLOC Cards, Allowing for Column Shift
               IF (RUNST1(1:11) .EQ. '   EVENTPER') THEN
                  IF (LOCB(1) .EQ. 1) THEN
                     WRITE(IEVUNT,1061) RUNST1(1:63)
                  ELSE IF (LOCB(1) .EQ. 2) THEN
                     WRITE(IEVUNT,1062) RUNST1(1:63)
                  ELSE IF (LOCB(1) .EQ. 3) THEN
                     WRITE(IEVUNT,1063) RUNST1(1:63)
                  ELSE IF (LOCB(1) .EQ. 4) THEN
                     WRITE(IEVUNT,1064) RUNST1(1:63)
                  END IF
               ELSE
                  IF (LOCB(1) .EQ. 1) THEN
                     WRITE(IEVUNT,EVFRM) RUNST1
                  ELSE IF (LOCB(1) .EQ. 2) THEN
                     WRITE(IEVUNT,EVFRM1) RUNST1
                  ELSE IF (LOCB(1) .EQ. 3) THEN
                     WRITE(IEVUNT,EVFRM2) RUNST1
                  ELSE IF (LOCB(1) .EQ. 4) THEN
                     WRITE(IEVUNT,EVFRM3) RUNST1
                  END IF
               END IF
            END IF
         END IF

         GO TO 11

 999     EOF = .TRUE.
 11      CONTINUE
      END DO

C     Write OU Pathway Images to EVENT File, Allowing For Column Shift
      IF (LOCB(1) .EQ. 1) THEN
         WRITE(IEVUNT,1011) EVPARM
      ELSE IF (LOCB(1) .EQ. 2) THEN
         WRITE(IEVUNT,1012) EVPARM
      ELSE IF (LOCB(1) .EQ. 3) THEN
         WRITE(IEVUNT,1013) EVPARM
      ELSE IF (LOCB(1) .EQ. 4) THEN
         WRITE(IEVUNT,1014) EVPARM
      END IF

      CLOSE(UNIT=IEVUNT)

 1061 FORMAT(A63)
 1062 FORMAT(1X,A63)
 1063 FORMAT(2X,A63)
 1064 FORMAT(3X,A63)
 1011 FORMAT(/'OU STARTING',
     &       /'   EVENTOUT  ',A6,
     &       /'OU FINISHED')
 1012 FORMAT(/' OU STARTING',
     &       /'    EVENTOUT  ',A6,
     &       /' OU FINISHED')
 1013 FORMAT(/'  OU STARTING',
     &       /'     EVENTOUT  ',A6,
     &       /'  OU FINISHED')
 1014 FORMAT(/'   OU STARTING',
     &       /'      EVENTOUT  ',A6,
     &       /'   OU FINISHED')

      RETURN
      END

      SUBROUTINE MXEVNT
C***********************************************************************
C                 MXEVNT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Generate EVENT File Inputs From
C                 Maximum Value (>Threshold) Files
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To add one more decimal place to receptor elevations
C                    and flagpole heights for the event file.
C                    R.W. Brode, PES, Inc. - November 15, 1995.
C
C        INPUTS:  Maximum Value Files
C
C        OUTPUTS: Events for EVENT Input Runstream File
C
C        CALLED FROM: EVEFIL
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: IAVEP, KDATE
      REAL    :: CONC1, XR2, YR2, ZE2, ZF2
      CHARACTER NAMEEV*8, GID*8, BUFIN*80

C     Variable Initializations
      MODNAM = 'MXEVNT'

C     Begin Averaging Period LOOP
      DO IAVE = 1, NUMAVE
C        Initialize Event Counter for This IAVE
         NUMEVE = 0
C        Begin Source Group LOOP
         DO IGRP = 1, NUMGRP
            IF (MAXFLE(IGRP,IAVE) .EQ. 1) THEN
C              Maximum Value File Exists for This Group and AvePer
C              Rewind File
               REWIND IMXUNT(IGRP,IAVE)
               EOF = .FALSE.

C              Loop Through Threshold File and Write Out Events to EVENT File
               DO WHILE (.NOT. EOF)
                  READ(IMXUNT(IGRP,IAVE),100,ERR=99,END=999) BUFIN
 100              FORMAT(A80)
C                 Skip Record if Part of Header, '*' in Column 1
                  IF (BUFIN(1:1) .EQ. '*') GO TO 11
                  READ(BUFIN,THRFRM,ERR=99) IAVEP,
     &                 GID, KDATE, XR2, YR2, ZE2, ZF2, CONC1
                  IF (IAVEP.NE.720 .AND. IAVEP.EQ.KAVE(IAVE) .AND.
     &                                     GID.EQ.GRPID(IGRP)) THEN
C                    Increment Event Counter and Generate Event Name
                     NUMEVE = NUMEVE + 1
                     IF (NUMEVE .GT. 9999) THEN
C                       Number of Events Exceeds Limit of Field,
C                       Write Warning Message and Reset to 1
                        WRITE(DUMMY,'(3X,I2.2,3X)') IAVEP
                        CALL ERRHDL(PATH,MODNAM,'W','413',DUMMY)
                        NUMEVE = 1
                     END IF
                     WRITE(NAMEEV,'("TH",I2.2,I4.4)') IAVEP, NUMEVE
C                    Write EVENTPER & EVENTLOC Cards, Allowing for Col. Shift
                     IF (LOCB(1) .EQ. 1) THEN
                        WRITE(IEVUNT,1901) NAMEEV,IAVEP,GID,KDATE,CONC1
                        WRITE(IEVUNT,1911) NAMEEV, XR2, YR2, ZE2, ZF2
                     ELSE IF (LOCB(1) .EQ. 2) THEN
                        WRITE(IEVUNT,1902) NAMEEV,IAVEP,GID,KDATE,CONC1
                        WRITE(IEVUNT,1912) NAMEEV, XR2, YR2, ZE2, ZF2
                     ELSE IF (LOCB(1) .EQ. 3) THEN
                        WRITE(IEVUNT,1903) NAMEEV,IAVEP,GID,KDATE,CONC1
                        WRITE(IEVUNT,1913) NAMEEV, XR2, YR2, ZE2, ZF2
                     ELSE IF (LOCB(1) .EQ. 4) THEN
                        WRITE(IEVUNT,1904) NAMEEV,IAVEP,GID,KDATE,CONC1
                        WRITE(IEVUNT,1914) NAMEEV, XR2, YR2, ZE2, ZF2
                     END IF
                     GO TO 11
                  ELSE
                     GO TO 11
                  END IF

 999              EOF = .TRUE.
 11               CONTINUE
               END DO

            END IF
         END DO
C        End Source Group LOOP
      END DO
C     End Averaging Period LOOP

      GO TO 1000

C     WRITE Error Message for Error Reading Threshold File
 99   WRITE(DUMMY,'("MAXFL",I3.3)') IMXUNT(IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','510',DUMMY)

 1901 FORMAT(3X,'EVENTPER',1X,A8,1X,I3,2X,A8,3X,I8.8,3X,F14.5)
 1902 FORMAT(4X,'EVENTPER',1X,A8,1X,I3,2X,A8,3X,I8.8,3X,F14.5)
 1903 FORMAT(5X,'EVENTPER',1X,A8,1X,I3,2X,A8,3X,I8.8,3X,F14.5)
 1904 FORMAT(6X,'EVENTPER',1X,A8,1X,I3,2X,A8,3X,I8.8,3X,F14.5)
 1911 FORMAT(3X,'EVENTLOC',1X,A8,1X,'XR= ',F14.5,' YR= ',F14.5,
     &       2(1X,F10.4))
 1912 FORMAT(4X,'EVENTLOC',1X,A8,1X,'XR= ',F14.5,' YR= ',F14.5,
     &       2(1X,F10.4))
 1913 FORMAT(5X,'EVENTLOC',1X,A8,1X,'XR= ',F14.5,' YR= ',F14.5,
     &       2(1X,F10.4))
 1914 FORMAT(6X,'EVENTLOC',1X,A8,1X,'XR= ',F14.5,' YR= ',F14.5,
     &       2(1X,F10.4))

 1000 RETURN
      END

      SUBROUTINE PRTPM10
C***********************************************************************
C                 PRTPM10 Module of ISC3 Short Term Model - ISCST3
C
C        PURPOSE: Print Out The Average H4H Values for PM10
C
C        PROGRAMMER: Roger Brode
C
C        DATE:       June 19, 1998
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, J, K, II, INDZ, INDC, NX, NY, ISRF
      REAL    :: YCOVAL, XRMS, YRMS, DIST, DIR
      CHARACTER BUF132*132

C     Variable Initializations
      MODNAM = 'PRTPM10'

C     Write Out the 'EV STARTING' Card to the Temp-EVent File for
C     First Output Type Only (i.e., ITYP = 1)
      IF (ITYP .EQ. 1) THEN
         WRITE(ITEVUT,9000)
      END IF

      DO IGRP = 1, NUMGRP

C        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            END IF
         END DO
C        Check for More Than 31 Sources Per Group
         IF (INDGRP .GT. 31) THEN
            WORKID(31) = ' . . . '
            INDGRP = 31
         END IF

C        Print Receptor Network Coordinates:
C        Set Number of Columns Per Page, NCPP
         NCPP = 9
C        Set Number of Rows Per Page, NRPP
         NRPP = 40
C        Begin LOOP Through Networks
         DO I = 1, INNET
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1, NPPX
               DO NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9032) (CHIDEP(II,ITYP),II=1,6),
     &                     NUMYRS,GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
C                 Print The Values By Source Group
                  WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,PERLBL(ITYP)
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &            (SUMH4H(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &              (SUMH4H(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  ELSE
                     DO K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &            (SUMH4H(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &              (SUMH4H(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
                     END DO
                  END IF
               END DO
            END DO
         END DO
C        End LOOP Through Networks

         IF (IRSTAT(4) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DC') THEN
                  INDC = INDC + 1
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) (CHIDEP(II,ITYP),II=1,6),
     &                 NUMYRS,GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9043)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                     WRITE(IOUNIT,9048) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:60),9045) AXR(IREC), AYR(IREC),
     &                     SUMH4H(IREC,IGRP)
                  ELSE
                     WRITE(BUF132(61:120),9045) AXR(IREC), AYR(IREC),
     &                     SUMH4H(IREC,IGRP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(5) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DP') THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS + YRMS*YRMS)
                  DIR  = ATAN2(XRMS, YRMS) * RTODEG
                  IF (DIR .LE. 0.0) DIR = DIR + 360.
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) (CHIDEP(II,ITYP),II=1,6),
     &                 NUMYRS,GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9044)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                     WRITE(IOUNIT,9049) CHIDEP(3,ITYP), CHIDEP(3,ITYP)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:65),9047) SRCID(IREF(IREC)), DIST,
     &                                       DIR, SUMH4H(IREC,IGRP)
                  ELSE
                     WRITE(BUF132(66:130),9047) SRCID(IREF(IREC)), DIST,
     &                                       DIR, SUMH4H(IREC,IGRP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
            END DO
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

C        Write Out The Boundary Receptors For The Sources
         IF (IRSTAT(6) .NE. 0) THEN
            INDC = 0
            IREC = 1
            DO WHILE (IREC .LE. NUMREC)
               IF (RECTYP(IREC) .EQ. 'BD') THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF (MOD(INDC-1,3) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) (CHIDEP(II,ITYP),II=1,6),
     &                NUMYRS,GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT,
     &                                  PERLBL(ITYP)
                  END IF
                  WRITE(IOUNIT,9082) SRCID(ISRF), SRCTYP(ISRF),
     &                AXS(ISRF), AYS(ISRF), AZS(ISRF), CHIDEP(3,ITYP),
     &                CHIDEP(3,ITYP), CHIDEP(3,ITYP), (J, AXR(IREC+J-1),
     &                AYR(IREC+J-1), SUMH4H(IREC+J-1,IGRP),J=1,36)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               END IF
            END DO
         END IF

      END DO

C     Write Out the 'EV FINISHED' Card to the Temp-EVent File for
C     First Output Type Only (i.e., ITYP = 1)
      IF (ITYP .EQ. 1) THEN
         WRITE(ITEVUT,9009)
      END IF

 9000 FORMAT('EV STARTING')
 9009 FORMAT('EV FINISHED')
 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9010 FORMAT(66(' -')/)
 9013 FORMAT(2X,F10.2,1X,'|',1X,9(F13.5))
 9016 FORMAT(3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT(3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT(3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT(3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9032 FORMAT(18X,'*** THE AVERAGE HIGH-4TH-HIGH 24-HR ',6A4,' VALUES ',
     &       'OVER',1X,I2,' YEARS FOR SOURCE GROUP:',1X,A8,' ***',
     &       /34X,'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /10X,12(A8,', ',:)/10X,12(A8,', ',:))
 9037 FORMAT(/35X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTOR POINTS ***')
 9044 FORMAT(/47X,'*** DISCRETE POLAR RECEPTOR POINTS ***')
 9045 FORMAT(6X,2(F12.2,2X),F13.5)
 9047 FORMAT(4X,A8,': ',2(F12.2,2X),F13.5)
 9048 FORMAT(6X,' X-COORD (M)   Y-COORD (M)        ',A4,
     &      22X,' X-COORD (M)   Y-COORD (M)        ',A4,/65(' -'))
 9049 FORMAT(5X,'ORIGIN',59X,'ORIGIN',
     &      /5X,' SRCID       DIST (M)     DIR (DEG)        ',A4,
     &      18X,' SRCID       DIST (M)     DIR (DEG)        ',A4,
     &      /65(' -'))
 9082 FORMAT(' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &       F10.2,')'/3(' (SEC.)  X-COORD    Y-COORD       ',A4,6X),/,
     &       12(3(1X,I4,2X,F9.1,',',F10.1,',',F13.5,' ',2X),/),/)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE MAXPM10
C***********************************************************************
C                 MAXPM10 Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Update Overall Maximum Value Arrays
C                 NMXPM = 10 Assigned in PARAMETER Statement in MAIN1
C                 Note: For duplicate values, the earlier occurrence keeps
C                       its rank within the array
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    June 19, 1998
C
C        INPUTS:  Maximum Value Table Options
C                 Array of CONC or DEPOS Averages
C                 Averaging Period
C
C        OUTPUTS: Updated Maximum Value Array
C                 Updated Maximum Date Array
C                 Updated Maximum Receptor Array
C
C        CALLED FROM:   HIVALS
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: J

C     Variable Initializations
      MODNAM = 'MAXPM10'

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP
C        Begin Receptor LOOP
         DO IREC = 1, NUMREC
            IF (NMXPM .GT. 1) THEN
               IF (SUMH4H(IREC,IGRP) .GT. MXPMVAL(NMXPM,IGRP)) THEN
                  DO J = NMXPM-1, 1, -1
                     IF(SUMH4H(IREC,IGRP) .LE. MXPMVAL(J,IGRP)) THEN
                        MXPMVAL(J+1,IGRP) = SUMH4H(IREC,IGRP)
                        MXPMLOC(J+1,IGRP) = IREC
C                       Exit Block
                        GO TO 200
                     ELSE
                        MXPMVAL(J+1,IGRP) = MXPMVAL(J,IGRP)
                        MXPMLOC(J+1,IGRP) = MXPMLOC(J,IGRP)
                        IF (J .EQ. 1) THEN
                           MXPMVAL(1,IGRP) = SUMH4H(IREC,IGRP)
                           MXPMLOC(1,IGRP) = IREC
                        END IF
                     END IF
                  END DO
               END IF
            ELSE IF (NMXPM .EQ. 1) THEN
               IF (SUMH4H(IREC,IGRP) .GT. MXPMVAL(1,IGRP)) THEN
                  MXPMVAL(1,IGRP) = SUMH4H(IREC,IGRP)
                  MXPMLOC(1,IGRP) = IREC
               END IF
            END IF
 200        CONTINUE
         END DO
C        End Receptor LOOP
      END DO
C     End Source Group LOOP

      RETURN
      END

      SUBROUTINE PRTPM10SUM
C***********************************************************************
C                 PRTPM10SUM Module of ISC3 Short Term Model - ISCST3
C
C        PURPOSE: Print Out the Result Summary Tables for PM10
C
C        PROGRAMMER: Roger Brode
C
C        DATE:       June 19, 1998
C
C        INPUTS:  Arrays Containing Maximum Values
C
C        OUTPUTS: Result Summary Table By Average Period
C
C        CALLED FROM:   MAIN
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I, IVAL, INDMX
      REAL    :: AXR1, AYR1, AZELV1, AZFLG1
      CHARACTER PERCHR*6, RANK(10)*4

C     Variable Initializations
      DATA (RANK(I),I=1,10) /' 1ST',' 2ND',' 3RD',' 4TH',' 5TH',
     &                       ' 6TH',' 7TH',' 8TH',' 9TH','10TH'/
      MODNAM = 'PRTSUM'
      IF (PERIOD) THEN
         PERCHR = 'PERIOD'
      ELSE IF (ANNUAL) THEN
         PERCHR = 'ANNUAL'
      END IF

C     Print Maximum PERIOD Averages, If Appropriate
      IF (PERIOD .OR. ANNUAL) THEN
C        Calculate Number of Groups Per Page, NGPP
         NGPP = INT(40/(NHIANN+1))
         DO IGRP = 1, NUMGRP
            IF (MOD(IGRP-1, NGPP) .EQ. 0) THEN
               CALL HEADER
               IF (PERIOD) THEN
                  WRITE(IOUNIT,9021) PERCHR, IANHRS
               ELSE IF (ANNUAL) THEN
                  WRITE(IOUNIT,9023) PERCHR, NUMYRS
               END IF
               WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT, PERLBL(ITYP)
               WRITE(IOUNIT,9022) CHIDEP(1,ITYP), CHIDEP(2,ITYP),
     &                            CHIDEP(3,ITYP)
            END IF
            DO IVAL = 1, NHIANN
               INDMX = IMXLOC(IVAL,IGRP,ITYP)
               IF (IVAL .EQ. 1 .AND. INDMX .NE. 0) THEN
                  WRITE(IOUNIT,1012) GRPID(IGRP), RANK(IVAL),
     &                  AMXVAL(IVAL,IGRP,ITYP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               ELSE IF (IVAL .EQ. 1 .AND. INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1014) GRPID(IGRP), RANK(IVAL),
     &                AMXVAL(IVAL,IGRP,ITYP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE IF (INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1015) RANK(IVAL),
     &                AMXVAL(IVAL,IGRP,ITYP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE
                  WRITE(IOUNIT,1013) RANK(IVAL),
     &                  AMXVAL(IVAL,IGRP,ITYP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               END IF
            END DO
         END DO
C        WRITE Out Explanation of Receptor Types
         WRITE(IOUNIT,9050)
      END IF

      IF (NUMAVE .EQ. 1) THEN
C        Calculate Number of Groups Per Page, NGPP
         NGPP = INT(40/(NMXPM+1))
         DO IGRP = 1, NUMGRP
            IF (MOD(IGRP-1, NGPP) .EQ. 0) THEN
               CALL HEADER
               WRITE(IOUNIT,9091) NUMYRS
               WRITE(IOUNIT,9011) CHIDEP(3,ITYP), POLLUT, OUTLBL(ITYP)
               WRITE(IOUNIT,9022) CHIDEP(1,ITYP), CHIDEP(2,ITYP),
     &                            CHIDEP(3,ITYP)
            END IF
            DO IVAL = 1, NMXPM
               INDMX = MXPMLOC(IVAL,IGRP)
               IF (IVAL .EQ. 1 .AND. INDMX .NE. 0) THEN
                  WRITE(IOUNIT,1012) GRPID(IGRP), RANK(IVAL),
     &                  MXPMVAL(IVAL,IGRP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               ELSE IF (IVAL .EQ. 1 .AND. INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1014) GRPID(IGRP), RANK(IVAL),
     &                MXPMVAL(IVAL,IGRP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE IF (INDMX .EQ. 0) THEN
                  AXR1 = 0.0
                  AYR1 = 0.0
                  AZELV1 = 0.0
                  AZFLG1 = 0.0
                  WRITE(IOUNIT,1015) RANK(IVAL),
     &                MXPMVAL(IVAL,IGRP), AXR1, AYR1, AZELV1, AZFLG1
               ELSE
                  WRITE(IOUNIT,1013) RANK(IVAL),
     &                  MXPMVAL(IVAL,IGRP), AXR(INDMX), AYR(INDMX),
     &                  AZELEV(INDMX), AZFLAG(INDMX), RECTYP(INDMX),
     &                  NETID(INDMX)
               END IF
            END DO
         END DO
C        WRITE Out Explanation of Receptor Types
         WRITE(IOUNIT,9050)
      END IF


 1001 FORMAT(A80)
 1002 FORMAT(1X,A8,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')',
     &       2X,A2,3X,A8)
 1003 FORMAT(9X,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')',
     &       2X,A2,3X,A8)
 1004 FORMAT(1X,A8,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1005 FORMAT(9X,' HIGH ',A4,' HIGH VALUE IS',F14.5,A1,' ON ',
     &       I8.8,': AT ','(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1012 FORMAT(/1X,A8,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')',2X,A2,3X,A8)
 1013 FORMAT(9X,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')',2X,A2,3X,A8)
 1014 FORMAT(/1X,A8,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')')
 1015 FORMAT(9X,A4,' HIGHEST VALUE IS',F14.5,' AT ',
     &       '(',2(F11.2,', '),F9.2,', ',F9.2,')')
 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9021 FORMAT(44X,'*** THE SUMMARY OF MAXIMUM ',A6,' (',I6,
     &       ' HRS) RESULTS ***'/)
 9023 FORMAT(44X,'*** THE SUMMARY OF MAXIMUM ',A6,' (',I4,
     &       ' YRS) RESULTS ***'/)
 9091 FORMAT(30X,'*** THE SUMMARY OF MAXIMUM AVERAGE HIGH-4TH-HIGH',
     &       ' 24-HR RESULTS OVER ',1X,I2,' YEARS ***'/)
 9022 FORMAT(103X,'NETWORK',/1X,'GROUP ID',22X,3A4,
     &       16X,'RECEPTOR  (XR, YR, ZELEV, ZFLAG)',3X,'OF TYPE',
     &       2X,'GRID-ID',/60(' -'))
 9031 FORMAT(48X,'*** THE SUMMARY OF HIGHEST ',A5,' RESULTS ***'/)
 9032 FORMAT(54X,'DATE',62X,'NETWORK',/1X,'GROUP ID',25X,3A4,5X,
     &       '(YYMMDDHH)',13X,'RECEPTOR  (XR, YR, ZELEV, ZFLAG)',
     &       5X,'OF TYPE',2X,'GRID-ID',/65(' -'))
 9050 FORMAT(//1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                             /23X,'GP = GRIDPOLR',
     &                             /23X,'DC = DISCCART',
     &                             /23X,'DP = DISCPOLR',
     &                             /23X,'BD = BOUNDARY')

 1000 RETURN
      END

      SUBROUTINE SHOUT
C***********************************************************************
C                 SHOUT Module of ISC2 Short Term Model - ISCST2
C
C        PURPOSE: Process Files of Season/Hour Results
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    June 5, 1997
C
C        INPUTS:  Array of Season/Hour Values
C
C        OUTPUTS: File of Season/Hour Values
C
C        CALLED FROM:   OUTPUT
C***********************************************************************

C     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12

      SAVE
      INTEGER :: I
      CHARACTER HDRFRM*256, SEAFRM*60

C     Variable Initializations
      MODNAM = 'SHOUT'

C     Create Header Format for Columns Based on Number of Output Types
      WRITE(HDRFRM,9020) NUMTYP, NUMTYP+2

      SEAFRM='(2(1X,F13.5),1X,F13.8,F8.2,2X,A8,2X,I4,2X,I4,2X,I4,2X,A8)'
      IF (NUMTYP .GT. 1) THEN
      WRITE(SEAFRM,1009) NUMTYP+2
 1009 FORMAT('(',I1,'(1X,F13.5),1X,F8.2,2X,A8,2X,I4,2X,I4,2X,I4,2X,A8)')
      END IF

C     Begin Source Group LOOP
      DO IGRP = 1, NUMGRP
C        Check for Selection of PERIOD PLOTFILE for This Group
         IF (ISEAHR(IGRP) .EQ. 1) THEN
C           Write Header Information
            WRITE(ISHUNT(IGRP),9005) VERSN, TITLE1
            WRITE(ISHUNT(IGRP),9007) (MODOPS(I),I=1,19)
            WRITE(ISHUNT(IGRP),9010) GRPID(IGRP), NUMREC, SEAFRM
            WRITE(ISHUNT(IGRP),HDRFRM) (CHIDEP(1,ITYP),CHIDEP(2,ITYP),
     &                                CHIDEP(3,ITYP),ITYP=1,NUMTYP)
            DO ISEAS = 1, 4
               DO IHOUR = 1, 24
C                 Begin Receptor LOOP
                  DO IREC = 1, NUMREC
                     INUM = NSEAHR(ISEAS,IHOUR) - NSEACM(ISEAS,IHOUR)
                     WRITE(ISHUNT(IGRP),SEAFRM,ERR=99)
     &                  AXR(IREC), AYR(IREC),
     &               (SHVALS(IREC,IGRP,ISEAS,IHOUR,ITYP),ITYP=1,NUMTYP),
     &                  AZELEV(IREC), GRPID(IGRP),
     &                  INUM, ISEAS, IHOUR, NETID(IREC)
                  END DO
C                 End Receptor LOOP
               END DO
            END DO
         END IF
      END DO
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Plot File
 99   WRITE(DUMMY,'("SHFIL",I3.3)') ISHUNT(IGRP)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCST3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',6(1X,A5),13(1X,A6))
 9010 FORMAT('*',9X,'FILE OF SEASON/HOUR VALUES FOR ',
     &       'SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ', I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('(''*'',8X,''X'',13X,''Y'',4X,',I1,'(2X,3A4),3X,''ZELEV'',
     &  5X,''GRP'',5X,''NHRS'',2X,''SEAS'',2X,''HOUR'',3X,''NET ID'',
     & /,''*'',2X,'
     & ,I1,'(''___________'',3X),''______  ________  ____  ____  ____'',
     &  ''  ________'')')
C 9020 FORMAT(23H('*',8X,'X',13X,'Y',4X,,I1,23H(2X,3A4),3X,'ZELEV',5X,
C     &,36H'AVE',5X,'GRP',6X,'NUM HRS',/'*',2X,,I1,19H('___________',3X),
C     &     ,37H'______  ______  ________  ________'))

 999  RETURN
      END
