      PROGRAM BINTOASC
C***********************************************************************
C
C     PROGRAM BINTOASC  (Version 92062)
C
C     PURPOSE:  Converts Unformatted (Binary) Meteorological Data Files
C               Generated by the RAMMET Preprocessor Program to a
C               Standard ASCII Format Used by the ISCST2 Model.
C               ASCII Data are Output as Sequential Hourly Records.
C
C     PROGRAMMED BY:  Roger W. Brode and JieFu Wang
C                     Pacific Environmental Services, Inc.
C                     3708 Mayfair Street, Suite 202
C                     Durham, North Carolina  27707
C
C     DATE:  March 2, 1992
C
C     The ISCST2 model has been developed for the U.S. Environmental
C     Protection Agency under Contract No. 68D00124.  The Project
C     Manager is Roger W. Brode, PES.  The EPA Work Assignment Manager
C     is Russell F. Lee, who also contributed to the development of this
C     program.  For instructions on running this program, refer to Appendix C
C     of the User's Guide for the Industrial Source Complex (ISC2)
C     Dispersion Models, Volume I - User Instructions.
C
C***********************************************************************

C     Variable Declarations
      INTEGER*1 ITYPE,IDUM1
      INTEGER*2 IDUM2
      INTEGER ISTAB(24), IDUM4
      REAL AWS(24), TEMP(24), AFV(24), AFVR(24), HLH(2,24)
      INTEGER NLEAP(12), LEAP(12)
      CHARACTER BINFIL*40, ASCFIL*40, PROMPT*1
      LOGICAL MSFORT, LHFORT, RMFORT, DONE

C     Variable Initializations
      DATA NLEAP/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA  LEAP/0,31,60,91,121,152,182,213,244,274,305,335/
      MSFORT = .FALSE.
      LHFORT = .FALSE.
      RMFORT = .FALSE.
      PROMPT = ' '
C     Initialize the Input and Output Units
      INUNIT = 11
      IOUNIT = 12

      WRITE(*,*) 'ENTER NAME OF BINARY MET FILE:'
      READ(*,110) BINFIL
      WRITE(*,*) 'ENTER NAME OF ASCII MET FILE:'
      READ(*,110) ASCFIL
 110  FORMAT(A40)

C     Open the Binary Input File and the Formatted Output File
      OPEN(UNIT=INUNIT,FILE=BINFIL,STATUS='UNKNOWN',FORM='BINARY')
      OPEN(UNIT=IOUNIT,FILE=ASCFIL,STATUS='UNKNOWN',FORM='FORMATTED')

C     Determine Type of Unformatted Data File
      READ(INUNIT,ERR=999) ITYPE
      IF (ITYPE .EQ. 75) THEN
C        Check for 16#4B in first byte (= 75 decimal)
         MSFORT = .TRUE.
         WRITE(*,*) 'FILE IS ASSUMED TO BE MICROSOFT TYPE'
      ELSE IF (ITYPE .EQ. -3) THEN
C        Check for 16#FD in first byte (= -3 decimal)
         LHFORT = .TRUE.
         WRITE(*,*) 'FILE IS ASSUMED TO BE LAHEY TYPE'
      ELSE
         RMFORT = .TRUE.
         WRITE(*,*) 'FILE IS ASSUMED TO BE RYAN-MCFARLAND TYPE'
      END IF

      CLOSE (INUNIT)

      IF (MSFORT) THEN
         OPEN(UNIT=INUNIT,FILE=BINFIL,STATUS='UNKNOWN',
     &        FORM='UNFORMATTED')
      ELSE
         OPEN(UNIT=INUNIT,FILE=BINFIL,STATUS='UNKNOWN',FORM='BINARY')
      END IF

C     Read the Station IDs and Years
      IF (MSFORT) THEN
         READ(INUNIT,ERR=999) ISSI,ISYI,IUSI,IUYI
      ELSE IF (LHFORT) THEN
         READ(INUNIT,ERR=999) IDUM1,IDUM1,ISSI,ISYI,IUSI,IUYI,IDUM1
      ELSE
         READ(INUNIT,ERR=999) IDUM4,ISSI,ISYI,IUSI,IUYI,IDUM4
      END IF

C     If No Error Then Write Station IDs and Years to Formatted File
      WRITE(IOUNIT,120) ISSI,ISYI,IUSI,IUYI
 120  FORMAT(4(I6,1X))

C     Retrieve Start and End Dates for Conversion
      WRITE(*,*) 'Do You Want to Convert the Entire Data File? (Y or N)'
      READ(*,130) PROMPT
 130  FORMAT(A1)

      IF (PROMPT .EQ. 'Y' .OR. PROMPT .EQ. 'y') THEN
         ISTRT = 1
         IEND  = 366
      ELSE
         DONE = .FALSE.
         DO WHILE (.NOT. DONE)
            WRITE(*,*) 'Enter the Start Date and End Date (e.g. 1,365):'
            READ(*,*,ERR=98) ISTRT, IEND
            IF (ISTRT .LT. 1) THEN
              WRITE(*,*)'Start date must be greater than or equal to 1!'
            ELSE IF (IEND .GT. 366) THEN
               WRITE(*,*) 'End date must be less than or equal to 366!'
            ELSE IF (IEND .LT. ISTRT) THEN
               WRITE(*,*) 'Start date must be less than End date!'
            ELSE
               DONE = .TRUE.
            END IF
 98         CONTINUE
         END DO
      END IF
 
      DO 10 I = 1, 366
         IF (MSFORT) THEN
            READ(INUNIT,END=99,ERR=999) IYR,IMO,DAY,ISTAB,AWS,TEMP,
     &                                   AFV,AFVR,HLH
         ELSE IF (LHFORT) THEN
            READ(INUNIT,END=99,ERR=999) IDUM2,IYR,IMO,DAY,ISTAB,AWS,
     &                                   TEMP,AFV,AFVR,HLH,IDUM2
         ELSE IF (RMFORT) THEN
            READ(INUNIT,END=99,ERR=999) IDUM4,IYR,IMO,DAY,ISTAB,AWS,
     &                                   TEMP,AFV,AFVR,HLH,IDUM4
         END IF

         IF (I .GE. (ISTRT-1) .AND. I .LE. IEND) THEN
C           Check Data for ISTRT-1 To Properly Handle a Calm in Hour 1
            IF (MOD(IYR,4) .EQ. 0) THEN
               IDY = INT(DAY) - LEAP(IMO)
            ELSE
               IDY = INT(DAY) - NLEAP(IMO)
            END IF
            DO 20 IHR = 1, 24
               IF (IHR .EQ. 1 .AND. I .EQ. 1) THEN
                  AFVLST = 360.
               ELSE IF (IHR .EQ. 1) THEN
                  AFVLST = AFV24
               ELSE IF (IHR .LT. 24) THEN
                  AFVLST = AFV(IHR-1)
               ELSE IF (IHR .EQ. 24) THEN
                  AFVLST = AFV(IHR-1)
                  AFV24  = AFV(IHR)
               END IF
               IF (AFV(IHR) .EQ. AFVLST .AND. AWS(IHR) .EQ. 1.0) THEN
C                 Calm Hour Identified - Set Wind Speed (AWS) to 0.0
                  AWS(IHR)  = 0.0
               END IF
               IF (I .GE. ISTRT .AND. I .LE. IEND) THEN
                  WRITE(IOUNIT,900) IYR,IMO,IDY,IHR,AFVR(IHR),AWS(IHR),
     &                   TEMP(IHR),ISTAB(IHR),HLH(1,IHR),HLH(2,IHR)
 900              FORMAT(4I2,2F9.4,F6.1,I2,2F7.1)
               END IF
  20        CONTINUE
         END IF
  10  CONTINUE

  99  CLOSE(IOUNIT)
      CLOSE(INUNIT)

      GO TO 1000

C     If Error Reading File, Write Message
 999  WRITE(*,*) 'ERROR: Unformatted Data File Cannot Be Read!!!'
      WRITE(*,*)
      WRITE(*,*) 'BINTOASC Accepts Data Files Generated by Programs'
      WRITE(*,*) 'Compiled With Microsoft, Lahey, and Ryan-McFarland.'
      WRITE(*,*) 'NOTE: All Data Values Are Assumed To Be 4 Bytes Long.'
      WRITE(*,*) 'Any Other Form of Data File Cannot Be Read.'

 1000 STOP
      END
