      SUBROUTINE CHOUR(Y,M,D,H,IHRT,IFLAG)                              CHR00010
C***CALCULATES THE HOUR TOTAL SINCE 00/01/01:01                         CHR00020
C***                                                                    CHR00030
C***                                                                    CHR00040
C   GLOSSARY OF TERMS                                                   CHR00050
C***                                                                    CHR00060
C***                                                                    CHR00070
C   D=TWO DIGIT INTEGER SPECIFYING THE DAY(01-31)                       CHR00080
C   H=TWO DIGIT INTEGER SPECIFYING THE HOUR(01-24)                      CHR00090
C   IDMON(IM)=NUMBER OF DAYS IN MONTH IM IN A NON LEAP YEAR             CHR00100
C   IDMONL(IM)=NUMBER OF DAYS IN MONTH IM IN A LEAP YEAR                CHR00110
C   IFLAG=COMPLETION FLAG FOR SUBROUTINE CHOUR                          CHR00120
C        =0(DAY-MONTH ASSIGNMENT WITHIN RANGE)                          CHR00130
C        =1(DAY-MONTHE ASSIGNMENT OUT OF RANGE)                         CHR00140
C   IHRT=HOUR COUNT WITH RESPECT TO 00/01/01:01                         CHR00150
C   M=TWO DIGIT INTEGER SPECIFYING THE MONTH(01-12)                     CHR00160
C   Y=TWO DIGIT INTEGER SPECIFYING THE YEAR(00-99)                      CHR00170
C***                                                                    CHR00180
C***                                                                    CHR00190
      INTEGER Y,D,H                                                     CHR00200
      DIMENSION IDMON(12),IDMONL(12)                                    CHR00210
      DATA IDMON/31,28,31,30,31,30,31,31,30,31,30,31/                   CHR00220
      DATA IDMONL/31,29,31,30,31,30,31,31,30,31,30,31/                  CHR00230
      IFLAG=0                                                           CHR00240
      IHRT=0                                                            CHR00250
C***TOTAL HOURS UP TO ALL YEARS UP TO THE CURRENT YEAR.                 CHR00260
      DO 100 IY=0,Y-1                                                   CHR00270
      IF(MOD(IY,4).EQ.0.AND.MOD(IY,100).NE.0) GO TO 10                  CHR00280
      IHRT=IHRT+8760                                                    CHR00290
      GO TO 100                                                         CHR00300
   10 IHRT=IHRT+8784                                                    CHR00310
  100 CONTINUE                                                          CHR00320
C***TOTAL HOURS FOR ALL MONTHS UP TO THE CURRENT MONTH.                 CHR00330
      DO 200 IM=1,M-1                                                   CHR00340
      IF(MOD(IY,4).EQ.0.AND.MOD(IY,100).NE.0) GO TO 110                 CHR00350
      IHRT=IHRT+IDMON(IM)*24                                            CHR00360
      GO TO 200                                                         CHR00370
  110 IHRT=IHRT+IDMONL(IM)*24                                           CHR00380
  200 CONTINUE                                                          CHR00390
C***CHECK WHETHER THE DAY-MONTH ASSIGNMENT IS CONSISTENT.               CHR00400
      IF(MOD(Y,4).EQ.0.AND.MOD(IY,100).NE.0) GO TO 210                  CHR00410
      IF(D.GT.IDMON(M)) GO TO 400                                       CHR00420
      GO TO 300                                                         CHR00430
  210 IF(D.GT.IDMONL(M)) GO TO 400                                      CHR00440
  300 CONTINUE                                                          CHR00450
C***TOTAL HOURS FOR ALL DAYS UP TO THE CURRENT DAY.                     CHR00460
      IHRT=IHRT+(D-1)*24                                                CHR00470
C***ADD IN THE HOUR OF THE CURRENT DAY.                                 CHR00480
      IHRT=IHRT+H                                                       CHR00490
      RETURN                                                            CHR00500
  400 IFLAG=1                                                           CHR00510
      RETURN                                                            CHR00520
      END                                                               CHR00530
