C-----------------------------------------------------------------------DEF00010
C SUBROUTINE: DEFAUL                                                    DEF00020
C                                                                       DEF00030
C PURPOSE: CHECK FOR MISSING DATA                                       DEF00040
C                                                                       DEF00050
C METHOD: SUBSTITUTE NWS DATA FROM SURF2 IF ON-SITE DATA FROM SURF1 IS  DEF00060
C         MISSING. FLAG OR PERSIST WHERE NWS DATA IS CALM.              DEF00070
C                                                                       DEF00080
C ARGUMENTS PASSED: MODE      INTEGER     EXECUTION MODE (0, 1, 2, OR 3)DEF00090
C                   M         INTEGER     MONTH                         DEF00100
C                   D         INTEGER     DAY                           DEF00110
C                   Y         INTEGER     YEAR                          DEF00120
C                   IHR       INTEGER     HOUR                          DEF00130
C                   ALBEDO    REAL        ALBEDO FOR THIS HOUR          DEF00140
C                                                                       DEF00150
C  I/O:  UNIT  IOUT   OUTPUT FOR WARNING OF MISSING CLOUD COVER DATA    DEF00160
C                                                                       DEF00170
C COMMON: TEMP  WIND    INIT    NCC     RNET    CVR   IO                DEF00180
C                                                                       DEF00190
C CALLING ROUTINES:  MAIN PROGRAM                                       DEF00200
C                                                                       DEF00210
C EXTERNAL ROUTINES: HVNET      TOTAL                                   DEF00220
C-----------------------------------------------------------------------DEF00230
      SUBROUTINE DEFAUL(MODE,M,D,Y,IHR,ALBEDO)                          DEF00240
C                                                                       DEF00250
      CHARACTER*1 NWSCC                                                 DEF00260
      INTEGER IHR,M,D,Y,CC,MODE                                         DEF00270
C                                                                       DEF00280
      COMMON/TEMP/T(24)                                                 DEF00290
      COMMON/WIND/WSL(24),A(24)                                         DEF00300
      COMMON/INIT/QR(24)                                                DEF00310
      COMMON/NCC/NWSCC(24)                                              DEF00320
      COMMON/RNET/RN(24),QS(24)                                         DEF00330
      COMMON/CVR/CC(24)                                                 DEF00340
      COMMON/IO/IOPT,IOUT,ISURF,IRAWIN,ISURF1,ISURF2                    DEF00350
C                                                                       DEF00360
C     CHECK FOR NWS CLOUD COVER DATA IF MODE = 2 OR 3                   DEF00370
C     IF MODE = 0 OR 1, CLOUD COVER IS PROVIDED IN "SURF1"              DEF00380
C                                                                       DEF00390
      IF(MODE.LE.1) GO TO 100                                           DEF00400
      IF(CC(IHR).LT.0) THEN                                             DEF00410
C        CHECK FOR MISSING NWS CLOUD COVER                              DEF00420
         IF(NWSCC(IHR).EQ.' ') THEN                                     DEF00430
            WRITE(IOUT,7000) M,D,Y,IHR                                  DEF00440
            CC(IHR) = 0                                                 DEF00450
         END IF                                                         DEF00460
         IF(NWSCC(IHR).EQ.'-') THEN                                     DEF00470
            CC(IHR) = 10                                                DEF00480
         ELSE                                                           DEF00490
            READ(NWSCC(IHR),7010) CC(IHR)                               DEF00500
         END IF                                                         DEF00510
      ENDIF                                                             DEF00520
C                                                                       DEF00530
C     IF NET RADIATION IS MISSING, BUT TOTAL INCOMING SOLAR RADIATION ISDEF00540
C     NOT MISSING, USE TOTAL INCOMING RADIATION TO COMPUTE THE NET.     DEF00550
C     IF BOTH NET AND TOTAL INCOMING SOLAR RADIATION ARE MISSING,       DEF00560
C     CALCULATE FROM THE CLOUD COVER AND SOLAR ELEVATION ANGLE          DEF00570
C     USING THE HOLTSLAG METHOD.                                        DEF00580
C     IF INCOMING SOLAR RADIATION IS MISSING, CALCULATE FROM THE CLOUD  DEF00590
C     COVER AND SOLAR ELEVATION ANGLE USING THE HOLTSLAG METHOD.        DEF00600
C                                                                       DEF00610
100   IF(QR(IHR).LT.-900.) CALL TOTAL(IHR)                              DEF00620
      IF(RN(IHR).LT.-900.) CALL HVNET(IHR,ALBEDO)                       DEF00630
      RETURN                                                            DEF00640
C                                                                       DEF00650
 7000 FORMAT(/,10X,'MISSING NWS CLOUD COVER ON (MM DD YY HH):',4(1X,I2),DEF00660
     1 //,10X,'**CLOUD COVER SET TO 0 IN ORDER TO CONTINUE EXECUTION**',DEF00670
     2 //,10X,'IF NECESSARY, PLEASE EDIT SURF2 MANUALLY AND RERUN',/)   DEF00680
 7010 FORMAT(I1)                                                        DEF00690
C                                                                       DEF00700
      END                                                               DEF00710
