C-----------------------------------------------------------------------HDY00010
C SUBROUTINE: HDAYUS                                                    HDY00020
C                                                                       HDY00030
C PURPOSE: THIS ROUTINE CALCULATES USTAR AND L FOR THE UNSTABLE CASES   HDY00040
C          (L < 0) USING THE HOLTSLAG-VAN ULDEN TECHNIQUE               HDY00050
C                                                                       HDY00060
C METHODS: ITERATE OVER USTAR AND L                                     HDY00070
C                                                                       HDY00080
C ASSUMPTIONS: CONVERGENCE IS REACHED WHEN TWO CONSECUTIVE ESTIMATES OF HDY00090
C              L ARE WITHIN 1%                                          HDY00100
C                                                                       HDY00110
C ARGUMENTS PASSED: I      INTEGER     HOUR                             HDY00120
C                   RHO    REAL        RHO                              HDY00130
C                   ANEM   REAL        ANEMOMETER HEIGHT                HDY00140
C                   Z0     REAL        ROUGHNESS LENGTH                 HDY00150
C                                                                       HDY00160
C COMMON: SUMV  US      RNET    WIND    THS     TEMP                    HDY00170
C                                                                       HDY00180
C INTRINSIC FUNCTIONS: ABS  ALOG  ATAN                                  HDY00190
C-----------------------------------------------------------------------HDY00200
        SUBROUTINE HDAYUS(I,RHO,ANEM,Z0)                                HDY00210
C                                                                       HDY00220
        INTEGER I,ITER                                                  HDY00230
        REAL PSIZL,PSIZ0L,RHO,EPS,VONK,ANEM,Z0,L,X,X0,LASTL,CP          HDY00240
        COMMON/US/USTAR(24)                                             HDY00250
        COMMON/RNET/RN(24),QS(24)                                       HDY00260
        COMMON/MONIN/L(24)                                              HDY00270
        COMMON/TEMP/T(24)                                               HDY00280
        COMMON/WIND/WSL(24),A(24)                                       HDY00290
        COMMON/THS/THSTAR(24)                                           HDY00300
C                                                                       HDY00310
C       INITIALIZE VARIABLES AND PSI VALUES                             HDY00320
C                                                                       HDY00330
        DATA CP/1004./,PI/3.14159/,G/9.80655/,EPS/0.01/,VONK/0.4/       HDY00340
        PSIZL=0.0                                                       HDY00350
        PSIZ0L=0.0                                                      HDY00360
        ITER=1                                                          HDY00370
C                                                                       HDY00380
C       BEGIN ITERATION LOOP OVER MONIN-OBUKHOV LENGTH AND USTAR        HDY00390
C                                                                       HDY00400
C       USTAR IS USED IN EQN 14 OF USER'S GUIDE                         HDY00410
C       L     IS USED IN EQN  1 OF USER'S GUIDE                         HDY00420
C                                                                       HDY00430
100     USTAR(I)=VONK*WSL(I)/(ALOG(ANEM/Z0)-PSIZL+PSIZ0L)               HDY00440
        L(I)=(-RHO*CP*T(I)*USTAR(I)**3)/(VONK*G*QS(I))                  HDY00450
C                                                                       HDY00460
C       ITERATION LOOP CHECK: STOP WHEN WITHIN 1% OF PRECEDING VALUE    HDY00470
C                                                                       HDY00480
        IF(ITER.NE.1) THEN                                              HDY00490
            IF(ABS(L(I)-LASTL).LT.ABS(EPS*L(I))) GO TO 110              HDY00500
        END IF                                                          HDY00510
C                                                                       HDY00520
C       EQN 18 OF USER'S GUIDE:                                         HDY00530
C                                                                       HDY00540
        X=(1.-15.*(ANEM/L(I)))**0.25                                    HDY00550
        X0=(1.-15.*(Z0/L(I)))**0.25                                     HDY00560
C                                                                       HDY00570
C       EQN 16 OF USER'S GUIDE                                          HDY00580
C                                                                       HDY00590
        PSIZL=2.*ALOG((1.+X)/2.)+ALOG((1.+X*X)/2.)-2.*ATAN(X)+PI/2.     HDY00600
        PSIZ0L=2.*ALOG((1.+X0)/2.)+ALOG((1.+X0*X0)/2.)-2.*ATAN(X0)+PI/2.HDY00610
        LASTL=L(I)                                                      HDY00620
        ITER=ITER+1                                                     HDY00630
        GO TO 100                                                       HDY00640
110     CONTINUE                                                        HDY00650
C                                                                       HDY00660
C       EQN 24 OF USER'S GUIDE                                          HDY00670
C                                                                       HDY00680
        THSTAR(I)=QS(I)/(-RHO*CP*USTAR(I))                              HDY00690
        RETURN                                                          HDY00700
        END                                                             HDY00710
