C-----------------------------------------------------------------------JUL00010
C SUBROUTINE: JULIAN                                                    JUL00020
C                                                                       JUL00030
C PURPOSE: COMPUTES JULIAN DAY FROM THE DATE                            JUL00040
C                                                                       JUL00050
C ARGUMENTS PASSED: YEAR     INTEGER     YEAR                           JUL00060
C                   MONTH    INTEGER     MONTH                          JUL00070
C                   DAY      INTEGER     DAY                            JUL00080
C                   JUL      INTEGER     JULIAN DAY                     JUL00090
C                                                                       JUL00100
C INTRINSIC FUNCTIONS: MOD                                              JUL00110
C-----------------------------------------------------------------------JUL00120
        SUBROUTINE JULIAN(YEAR,MONTH,DAY,JUL)                           JUL00130
C                                                                       JUL00140
        INTEGER YEAR,MONTH,DAY,JUL                                      JUL00150
        DIMENSION NDAY(12)                                              JUL00160
        DATA NDAY/0,31,59,90,120,151,181,212,243,273,304,334/           JUL00170
C                                                                       JUL00180
        JUL = NDAY(MONTH) + DAY                                         JUL00190
        IF(MONTH.LE.2) RETURN                                           JUL00200
        IF(MOD (YEAR, 4).EQ.0) JUL = JUL + 1                            JUL00210
        RETURN                                                          JUL00220
        END                                                             JUL00230

