C-----------------------------------------------------------------------SMH00010
C SUBROUTINE: SUMHH                                                     SMH00020
C                                                                       SMH00030
C PURPOSE: INTERPOLATE INTEGRATED SENSIBLE HEAT FLUX                    SMH00040
C                                                                       SMH00050
C ASSUMPTIONS: INTEGRATED HEAT FLUX NOT ALLOWED TO DECREASE             SMH00060
C                                                                       SMH00070
C ARGUMENTS PASSED: IT     INTEGER     TIME IN MINUTES                  SMH00080
C                   H      REAL        INTEGRATED SENSIBLE HEAT FLUX    SMH00090
C                   OLDH   REAL        LAST INTEGRATED SENSIBLE HEAT    SMH00100
C                                      FLUX                             SMH00110
C                                                                       SMH00120
C COMMON: SUMH                                                          SMH00130
C                                                                       SMH00140
C INTRINSIC FUNCTIONS: FLOAT                                            SMH00150
C-----------------------------------------------------------------------SMH00160
      SUBROUTINE SUMHH(IT,H,OLDH)                                       SMH00170
C                                                                       SMH00180
      COMMON/SUMH/SQR(24)                                               SMH00190
C                                                                       SMH00200
C     INTERPOLATE INTEGRATED SENSIBLE HEAT FLUX, H (LY)                 SMH00210
C                                                                       SMH00220
      IT1=IT/60                                                         SMH00230
      IT2=IT1+1                                                         SMH00240
      IF(IT1.EQ.0) IT1 = 1                                              SMH00250
      H=SQR(IT1)+(SQR(IT2)-SQR(IT1))/60.0*(FLOAT(IT)-IT1*60.)           SMH00260
C                                                                       SMH00270
C     INTEGRATED SENSIBLE HEAT FLUX NOT ALLOWED TO DECREASE             SMH00280
C                                                                       SMH00290
      IF(H.LE.OLDH) H=OLDH                                              SMH00300
      OLDH=H                                                            SMH00310
      RETURN                                                            SMH00320
      END                                                               SMH00330
