C-----------------------------------------------------------------------SMI00010
C SUBROUTINE:SUMI                                                       SMI00020
C                                                                       SMI00030
C PURPOSE: COMPUTES POTENTIAL TEMPERATURE INTEGRALS                     SMI00040
C                                                                       SMI00050
C ASSUMPTIONS: POTENTIAL TEMPERATURE DOES NOT DECREASE WITH HEIGHT      SMI00060
C                                                                       SMI00070
C ARGUMENTS PASSED: ILVLS     INTEGER     RAWINSONDE LEVEL              SMI00080
C                   PTMPM     REAL        POTENTIAL TEMPERATURE         SMI00090
C                                                                       SMI00100
C COMMON: PTEMP XSUMI                                                   SMI00110
C-----------------------------------------------------------------------SMI00120
      SUBROUTINE SUMI(ILVLS,PTMPM)                                      SMI00130
C                                                                       SMI00140
      COMMON/PTEMP/PRS(80),TMP(80),PTMP(80)                             SMI00150
      COMMON/XSUMI/HT(80),AI(80),AI2(80)                                SMI00160
C                                                                       SMI00170
C     ASSUME POT TEMP INCREASES (OR STAYS CONSTANT) WITH Z.             SMI00180
C     COMPUTE AREA UNDER POT TEMP PROFILE FOR THE INTERVAL              SMI00190
C     ILVLS-1 TO ILVLS USING TRAPEZOIDS.                                SMI00200
C                                                                       SMI00210
      IF(PTMP(ILVLS).LT.PTMPM) GO TO 100                                SMI00220
C                                                                       SMI00230
C     INTEGRAL OF Z WRT THETA (K-M) (LEFT SIDE OF EQN 27 IN USER'S GUIDESMI00240
C                                                                       SMI00250
      AI(ILVLS)=0.5*(PTMP(ILVLS)-PTMP(ILVLS-1)) *                       SMI00260
     1    (HT(ILVLS)+HT(ILVLS-1))                                       SMI00270
C                                                                       SMI00280
C     INTEGRAL OF Z**2 WRT THETA (K-M**2) (LEFT SIDE OF EQN 28)         SMI00290
C                                                                       SMI00300
      AI2(ILVLS)=0.5*(PTMP(ILVLS)-PTMP(ILVLS-1)) *                      SMI00310
     1    (HT(ILVLS)**2+HT(ILVLS-1)**2)                                 SMI00320
C                                                                       SMI00330
C     KEEP TRACK OF LOCAL POT TEMP MAX                                  SMI00340
C                                                                       SMI00350
      PTMPM=AMAX1(PTMP(ILVLS),PTMPM)                                    SMI00360
      GO TO 110                                                         SMI00370
C                                                                       SMI00380
C     IF POT TEMP DOES NOT INCREASE WITH HEIGHT, SET AREA               SMI00390
C     UNDER CURVE EQUAL TO ZERO FOR THAT INTERVAL AND SET POT TEMP      SMI00400
C     EQUAL TO LAST MAX POT TEMP                                        SMI00410
C                                                                       SMI00420
 100  AI(ILVLS)=0.0                                                     SMI00430
      AI2(ILVLS)=0.0                                                    SMI00440
      PTMP(ILVLS)=PTMPM                                                 SMI00450
 110  CONTINUE                                                          SMI00460
      RETURN                                                            SMI00470
      END                                                               SMI00480
