C-----------------------------------------------------------------------TOT00010
C SUBROUTINE: TOTAL                                                     TOT00020
C                                                                       TOT00030
C PURPOSE: THIS ROUTINE CALCULATES TOTAL INCOMING SOLAR RADIATION FROM  TOT00040
C          CLOUD COVER AND SOLAR ELEVATION ANGLE USING THE HOLTSLAG-    TOT00050
C          VAN ULDEN TECHNIQUE                                          TOT00060
C                                                                       TOT00070
C METHODS: HOLTSLAG - VAN ULDEN TECHNIQUE                               TOT00080
C                                                                       TOT00090
C ARGUMENTS PASSED: H     INTEGER   HOUR ENDING                         TOT00100
C                                                                       TOT00110
C COMMON: CVR   INIT   SOLANG                                           TOT00120
C                                                                       TOT00130
C INTRINSIC FUNCTIONS: MOD                                              TOT00140
C-----------------------------------------------------------------------TOT00150
        SUBROUTINE TOTAL(H)                                             TOT00160
C                                                                       TOT00170
        INTEGER H,CC                                                    TOT00180
        REAL AVGANG                                                     TOT00190
        COMMON/INIT/QR(24)                                              TOT00200
        COMMON/CVR/CC(24)                                               TOT00210
        COMMON/SOLANG/ANGLE(24)                                         TOT00220
C                                                                       TOT00230
C       COMPUTE AVERAGE OF THE SOLAR ELEVATION ANGLES AT THE BEGINNING  TOT00240
C       AND END OF THE HOUR                                             TOT00250
C                                                                       TOT00260
        IF(H.LE.23) THEN                                                TOT00270
            AVGANG = (ANGLE(H)+ANGLE(H+1))/2.0                          TOT00280
          ELSE                                                          TOT00290
            AVGANG = (ANGLE(24)+ANGLE(1))/2.0                           TOT00300
        ENDIF                                                           TOT00310
C                                                                       TOT00320
C       FOR DAYTIME HOURS, COMPUTE THE INCOMING SOLAR RADIATION         TOT00330
C       (EQN 4 IN USER'S GUIDE)                                         TOT00340
C                                                                       TOT00350
        IF(AVGANG .GT. 0.) QR(H)=(990.*SIN(AVGANG))-30.                 TOT00360
C                                                                       TOT00370
C       USE INTERPOLATION FORMULA FOR SOLAR ELEVATION ANGLES LESS THAN  TOT00380
C       10 DEGREES TO AVOID NEGATIVE VALUES.                            TOT00390
C       NOTE: 141.91 WATTS/M**2 = RADIATION FOR 10-DEG ELEVATION ANGLE  TOT00400
C                                                                       TOT00410
        IF(AVGANG .LT. 0.1745329) QR(H)=141.91 * AVGANG*5.729578        TOT00420
C                                                                       TOT00430
C       HOLTSLAG CORRECTION FOR CLOUDS (EQN 5 IN USER'S GUIDE)          TOT00440
C                                                                       TOT00450
        IF(CC(H).GT.0) QR(H)=QR(H)*(1.0-0.75*((CC(H)/10.)**3.4))        TOT00460
        RETURN                                                          TOT00470
        END                                                             TOT00480

