      SUBROUTINE CONCOMP(XCON,YCON,NPC,NPCMAX,XHTOP,YHTOP,AFIL,NFIL,
     &DOUT)
C***THIS SUBROUTINE COMPLETES A CONTOUR WHICH HAS BEEN INPUT FROM THE
C***CONTOUR MASTER FILE AS AN INCOMPLETE CONTOUR. THE FIRST STEP IN THIS
C***COMPLETION PROCESS IS THE ELIMINATION OF THOSE POINTS WHICH LIE IN
C***THE SAME SECTOR AS (1)AN ACTUAL CONTOUR POINT WHICH IS CLOSER TO
C***THE HILL CENTER OR (2)A SEGMENT OF A LINE CONNECTING ADJACENT POINTS
C***WHICH IS CONTAINED WITHIN THE SECTOR AND WHOSE APPROXIMATE MIDPOINT
C***IS CLOSER TO THE HILL CENTER THAN THE POINT IN QUESTION.
C***
C***
C   GLOSSARY OF TERMS
C***
C***
C   AFIL=ANGULAR WIDTH OF EACH OF THE NFIL SECTORS
C   COUNT=COUNTER USED IN THE INTERPOLATION OF DISTANCES FOR "PSEUDO-
C         POINTS"
C   DIF=NUMBER OF ANGULAR SECTORS COVERED IN MOVING FROM THE PREVIOUS
C       TO THE CURRENT CONTOUR POINT
C   DIST=DISTANCE FROM THE HILL CENTER TO THE CURRENT CONTOUR POINT
C   DISTM(ISEC)=CURRENT MINIMUM DISTANCE FROM THE HILL CENTER TO THE
C               CLOSEST CONTOUR POINT OR SEGMENT FOR THE SECTOR ISEC
C   DOLD=DISTANCE FROM THE HILL CENTER TO THE PREVIOUS CONTOUR POINT
C   DTEST=VARIABLE USED IN THE TEST FOR MINIMUM DISTANCE FOR PSEUDO-
C         POINTS
C   IR(ISEC)=CONTOUR POINT, WITHIN SECTOR ISEC, WHICH LIES CLOSEST TO
C            THE HILL CENTER
C           =0 IF NO CONTOUR POINT HAS YET BEEN JUDGED TO LIE CLOSEST
C              TO THE CENTER
C           =9999 IF A CONTOUR SEGMENT LIES CLOSER
C   IROLD=PREVIOUS VALUE FOR IR(ISEC)
C   ISEC=NUMBER OF THE ANGULAR SECTOR FOR THE CURRENT POINT
C   ISOLD=SECTOR OCCUPIED BY THE PREVIOUS CONTOUR POINT
C   ITEST=VARIABLE USED IN DETERMINING WHETHER MORE THAN ONE SECTOR
C         HAS BEEN CROSSED IN MOVING FROM THE PREVIOUS TO THE CURRENT
C         CONTOUR POINT
C   METH=CONTOUR POINT REFLECTION FLAG
C       =0(HILL CENTER USED FOR REFLECTION)
C       =1(CONTOUR CENTROID USED FOR REFLECTION)
C   NCOUNT=RUNNING TOTAL OF THE SET OF CONTOUR POINTS AFTER MODIFICATION
C          BY ANGULAR FILTRATION
C   NFIL=NUMBER OF SECTORS OF EQUAL WIDTH USED IN THE ANGULAR FILTRATION
C        PROCESS
C   NFILM=HALF THE NUMBER OF TOTAL ANGULAR SECTORS ROUNDED UP TO THE
C         NEAREST SECTOR NUMBER. USED TO DETERMINE WHICH SECTORS ARE
C         CROSSED BY A LINE CONNECTING TWO ADJACENT POINTS
C   NPC=INITIAL AND THEN THE FINAL NUMBER OF CONTOUR POINTS
C   NPCO=INITIAL NUMBER OF CONTOUR POINTS
C   XCONS,YCONS=TEMPORARY CONTOUR POINT STORAGE ARRAYS USED IN THE
C               ELIMINATION OF POINTS BY ANGULAR FILTERING
C   XHTOP,YHTOP=X-Y COORDINATES OF THE HILL CENTER(INPUT BY THE USER
C               IN PROGRAM FITCON)
C   XREF,YREF=X-Y COORDINATES OF THE POINT TO BE USED FOR CONTOUR POINT
C             REFLECTION. THIS POINT IS THE HILL CENTER FOR METH=0 AND
C             THE CONTOUR CENTROID FOR METH=1.
C***
C***
      INTEGER DOUT
      DIMENSION XCON(1),YCON(1),XCONS(1000),YCONS(1000),DISTM(360),
     &IR(360)
C***BEFORE CARRYING OUT THE CONTOUR COMPLETION PROCESS, ELIMINATE
C***THROUGH ANGULAR FILTERING, THOSE POINTS WHICH MAY CAUSE THE CLOSED
C***CONTOUR TO BE UNREALISTIC FROM A PHYSICAL STANDPOINT.
C***ZERO OUT THE FILTERING ARRAYS.
C***FIRST, DETERMINE WHETHER ANGULAR FILTERING WILL BE REQUIRED.
      IF(NFIL.EQ.0) GO TO 45
      DO 1 ISEC=1,NFIL
      DISTM(ISEC)=0.
      IR(ISEC)=0
    1 CONTINUE
      NCOUNT=0
      NFILM=FLOAT(NFIL)/2.+0.500001
      XP=XCON(1)
      YP=YCON(1)
C***CALCULATE THE SECTOR AND DISTANCE FROM THE HILL CENTER FOR THE FIRST
C***CONTOUR POINT.
      CALL VECTOR(XHTOP,YHTOP,XP,YP,ANGLE,DX,DY)
      ISOLD=ANGLE/AFIL
      IF(ISOLD.LT.1) ISOLD=1
      IF(ISOLD.GT.NFIL) ISOLD=NFIL
      DOLD=SQRT((XP-XHTOP)**2+(YP-YHTOP)**2)
C***CHOOSE THE CLOSEST POINT TO THE HILL CENTER LOCATION FOR EACH
C***SECTOR OF ANGULAR WIDTH AFIL.
      DO 3 K=1,NPC
      XP=XCON(K)
      YP=YCON(K)
      DIST=SQRT((XP-XHTOP)**2+(YP-YHTOP)**2)
      CALL VECTOR(XHTOP,YHTOP,XP,YP,ANGLE,DX,DY)
      ISEC=ANGLE/AFIL
      IF(ISEC.LT.1) ISEC=1
      IF(ISEC.GT.NFIL) ISEC=NFIL
C***DETERMINE WHETHER A CONTOUR POINT OR SEGMENT HAS ALREADY APPEARED IN
C***THIS ANGULAR SECTOR.
      IF(IR(ISEC).NE.0) GO TO 2
      NCOUNT=NCOUNT+1
C***ACCEPT THE POINT(XCON(K),YCON(K)) AND INITIALIZE THE ARRAYS IR AND
C***DISTM.
      XCONS(NCOUNT)=XP
      YCONS(NCOUNT)=YP
      IR(ISEC)=NCOUNT
      DISTM(ISEC)=SQRT((XP-XHTOP)**2+(YP-YHTOP)**2)
      GO TO 1000
C***DETERMINE WHETHER THE DISTANCE FROM THE HILL CENTER TO THE POINT IS
C***LESS THAN THE CURRENT MINIMUM DISTANCE FOR THIS SECTOR.
    2 CONTINUE
      IF(DIST.GE.DISTM(ISEC)) GO TO 1000
C***REINITIALIZE DISTM(ISEC) TO CORRESPOND TO THE DISTANCE FROM THE
C***HILL CENTER FOR THE CONTOUR POINT IN QUESTION.
      DISTM(ISEC)=DIST
C***TEMPORARILY SAVE THE PREVIOUS VALUE OF IR(SEC).
      IROLD=IR(ISEC)
      IF(IROLD.EQ.9999) GO TO 201
C***FLAG THE X-COORDINATE OF THE PREVIOUSLY CLOSEST CONTOUR POINT
C***(IROLD) FOR LATER ELIMINATION OF THE POINT.
      XCONS(IROLD)=1.0E+15
  201 NCOUNT=NCOUNT+1
C***REINITIALIZE THE IR ARRAY TO CORRESPOND TO THE NUMBER OF THE CONTOUR
C***POINT IN QUESTION.
      IR(ISEC)=NCOUNT
C***ACCEPT THE CONTOUR POINT NCOUNT.
      XCONS(NCOUNT)=XP
      YCONS(NCOUNT)=YP
C***HANDLE SECTORS BETWEEN THOSE SECTORS OCCUPIED BY THE CURRENT AND
C***PREVIOUS CONTOUR POINTS.
C***DETERMINE HOW MANY SECTORS HAVE BEEN CROSSED. IF MORE THAN ONE HAS
C***BEEN CROSSED, THEN DEAL WITH "PSEUDOPOINTS" WHICH OCCUPY SECTORS
C***BETWEEN THE CURRENT AND PREVIOUS CONTOUR POINTS.
 1000 ITEST=IABS(ISEC-ISOLD)
C***DETERMINE WHETHER MORE THAN ONE SECTOR HAS BEEN CROSSED.
      IF(ITEST.LE.1.OR.ITEST.EQ.NFIL-1) GO TO 1400
C***FOUR CASES:
C***(1) ISEC>ISOLD; ISEC-ISOLD>=NFILM
C***(2) ISEC>ISOLD; ISEC-ISOLD<NFILM
C***(3) ISOLD>ISEC; ISOLD-ISEC>=NFILM
C***(4) ISOLD>ISEC; ISOLD-ISEC<NFILM
      IF(ISEC.GT.ISOLD) GO TO 1200
      IF((ISOLD-ISEC).GE.NFILM) GO TO 1100
      DIF=FLOAT(ISOLD-ISEC)
      COUNT=1.
C***CASE #4
      DO 1010 I=ISOLD-1,ISEC+1,-1
C***ESTIMATE THE DISTANCE, DTEST, TO THE PSEUDOPOINT BY SIMPLE INTER-
C***POLATION WITH RESPECT TO THE SECTOR NUMBER.
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1010
      IF(IR(I).EQ.0) GO TO 1001
C***IF THE PREVIOUSLY CLOSEST POINT WAS AN ACTUAL CONTOUR POINT RATHER
C***THAN A "PSEUDOPOINT", THEN FLAG THE PREVIOUSLY CLOSEST POINT FOR
C***LATER REMOVAL.
      IF(IR(I).EQ.9999) GO TO 1002
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
C***THE VALUE "9999" FOR IR(I) INDICATES THAT THE CLOSEST CONTOUR POINT
C***FOR SECTOR I IS A "PSEUDOPOINT".
 1001 IR(I)=9999
C***ESTIMATE THE DISTANCE, DISTM(I), TO THE PSEUDOPOINT BY SIMPLE INTER-
C***POLATION WITH RESPECT TO THE SECTOR NUMBER.
 1002 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1010 CONTINUE
      GO TO 1400
C***CASE #3
 1100 DIF=FLOAT(NFIL-(ISOLD-ISEC))
      COUNT=1.
C***LOOP MUST BE BROKEN INTO 2 PARTS.
C***PART ONE
      DO 1150 I=ISOLD+1,NFIL,1
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1150
      IF(IR(I).EQ.0) GO TO 1111
      IF(IR(I).EQ.9999) GO TO 1112
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
 1111 IR(I)=9999
 1112 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1150 CONTINUE
C***PART TWO
      DO 1160 I=1,ISEC-1,1
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1160
      IF(IR(I).EQ.0) GO TO 1151
      IF(IR(I).EQ.9999) GO TO 1152
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
 1151 IR(I)=9999
 1152 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1160 CONTINUE
      GO TO 1400
 1200 IF((ISEC-ISOLD).GE.NFILM) GO TO 1300
C***CASE #2
      DIF=FLOAT(ISEC-ISOLD)
      COUNT=1.
      DO 1210 I=ISOLD+1,ISEC-1,1
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1210
      IF(IR(I).EQ.0) GO TO 1201
      IF(IR(I).EQ.9999) GO TO 1202
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
 1201 IR(I)=9999
 1202 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1210 CONTINUE
      GO TO 1400
C***CASE #1
 1300 DIF=FLOAT(NFIL-(ISEC-ISOLD))
      COUNT=1.
C***LOOP MUST BE BROKEN INTO 2 PARTS.
C***PART ONE
      DO 1350 I=ISOLD-1,1,-1
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1350
      IF(IR(I).EQ.0) GO TO 1311
      IF(IR(I).EQ.9999) GO TO 1312
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
 1311 IR(I)=9999
 1312 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1350 CONTINUE
C***PART TWO
      DO 1360 I=NFIL,ISEC+1,-1
      DTEST=DOLD+(COUNT/DIF)*(DIST-DOLD)
      IF(DTEST.GT.DISTM(I).AND.IR(I).NE.0) GO TO 1360
      IF(IR(I).EQ.0) GO TO 1351
      IF(IR(I).EQ.9999) GO TO 1352
      IROLD=IR(I)
      XCONS(IROLD)=1.0E+15
 1351 IR(I)=9999
 1352 DISTM(I)=DTEST
      COUNT=COUNT+1.
 1360 CONTINUE
C***SAVE THE SECTOR NUMBER AND DISTANCE FOR COMPARISON WITH THE NEXT
C***POINT.
 1400 ISOLD=ISEC
      DOLD=DIST
    3 CONTINUE
      NPC=1
      DO 4 K=1,NCOUNT
      IF(XCONS(K).GT.1.0E+14) GO TO 4
      XCON(NPC)=XCONS(K)
      YCON(NPC)=YCONS(K)
      NPC=NPC+1
    4 CONTINUE
      NPC=NPC-1
   45 CONTINUE
C***CALL SUBROUTINE ARCM TO DETERMINE THE AREA OF THE INCOMPLETE
C***CONTOUR. IF THE AREA IS NEGATIVE, THEN THE CONTOUR POINTS HAVE
C***BEEN INPUT IN A COUNTERCLOCKWISE SENSE. IF THE AREA IS POSITIVE,
C***THEN THE CONTOUR POINTS HAVE BEEN INPUT IN A CLOCKWISE SENSE.
C***THIS INFORMATION IS REQUIRED BY THE CONTOUR COMPLETION ALGORITHM.
C***THE X AND Y COORDINATES OF THE INCOMPLETE CONTOUR CENTER OF
C***MASS(XCM,YCM) ARE NOT USED BY THE CONTOUR COMPLETION ALGORITHM.
C***FIRST ADD THE POINT (XHTOP,YHTOP) TO THE CONTOUR ONLY FOR THE
C***PURPOSE OF THIS DIRECTION DETERMINATION.
      METH=0
      XREF=XHTOP
      YREF=YHTOP
      NPCP1=NPC+1
C***CHECK WHETHER CONTOUR COMPLETION WILL CAUSE THE NUMBER OF CONTOUR
C***POINTS TO EXCEED THE MAXIMUM. IF SO, SET THE COORDINATES OF THE
C***FINAL POINT EQUAL TO THOSE OF THE INITIAL POINT AND PRINT A WARNING
C***MESSAGE.
      IF(NPCP1.LT.NPCMAX) GO TO 5
      XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      WRITE(DOUT,20) NPCMAX
      RETURN
    5 XCON(NPCP1)=XHTOP
      YCON(NPCP1)=YHTOP
      CALL ARCM(XCON,YCON,AREA,XCM,YCM,NPCP1)
    6 XP=XCON(1)
      YP=YCON(1)
C***FIND THE HEADING AND X,Y COMPONENTS OF THE VECTOR FROM THE HILL
C***TOP X,Y POINT TO THE FIRST CONTOUR POINT.
      CALL VECTOR(XREF,YREF,XP,YP,ANGLE,DX,DY)
      IF(AREA.LT.0.) ANG2=ANGLE
      IF(AREA.GE.0.) ANG1=ANGLE
      XP=XCON(NPC)
      YP=YCON(NPC)
C***FIND THE HEADING AND X,Y COMPONENTS OF THE VECTOR FROM THE HILL
C***TOP X,Y POINT TO THE LAST CONTOUR POINT.
      CALL VECTOR(XREF,YREF,XP,YP,ANGLE,DX,DY)
      IF(AREA.LT.0.) ANG1=ANGLE
      IF(AREA.GE.0.) ANG2=ANGLE
      IF(METH.EQ.1) GO TO 7
      ADIF=ANG2-ANG1
      IF(ADIF.LT.0.) ADIF=360.+ADIF
C***IF THE ANGULAR DIFFERENCE BETWEEN THE VECTORS IS LESS THAN
C***90 DEGREES, USE THE CENTROID OF THE CONTOUR FOR THE REFLECTION
C***POINT INSTEAD OF THE HILL CENTER.
      IF(ADIF.GT.90.) GO TO 7
      CALL ARCM(XCON,YCON,AREA,XCM,YCM,NPC)
      XREF=XCM
      YREF=YCM
      METH=1
      GO TO 6
    7 CONTINUE
C***SAVE THE NUMBER OF ORIGINAL CONTOUR POINTS.
      NPCO=NPC
C***IN THE CASE OF POSITIVE(NEGATIVE) CONTOUR AREA, DETERMINE, FOR EACH
C***CONTOUR POINT, WHETHER THE HEADING OF THE VECTOR FROM THE CONTOUR
C***POINT TO THE HILL TOP X,Y POINT LIES BETWEEN THE HEADINGS OF THE
C***VECTORS FROM THE HILL TOP X,Y POINT TO THE FIRST(LAST) CONTOUR POINT
C***AND FROM THE HILL TOP X,Y POINT TO THE LAST(FIRST) CONTOUR POINT.
C***IF THIS IS SO, THEN ASSIGN AN ADDITIONAL CONTOUR POINT AT THE
C***TERMINATION OF THE VECTOR HAVING A HEADING EQUAL TO THAT OF THE
C***VECTOR FROM THE ORIGINAL CONTOUR POINT TO THE HILL TOP X,Y POINT
C***AND HAVING A LENGTH EQUAL TO TWICE THE LENGTH OF THIS VECTOR. IF
C***THE ADDITION OF A CONTOUR POINT WOULD CAUSE THE MAXIMUM NUMBER OF
C***CONTOUR POINTS TO BE EQUALED, THEN THE COORDINATES OF THIS CONTOUR
C***POINT ARE SET EQUAL TO THE COORDINATES OF THE FIRST CONTOUR POINT
C***AND THE CONTOUR COMPLETION PROCESS IS HALTED.
      DO 100 K=1,NPCO
      XP=XCON(K)
      YP=YCON(K)
      CALL VECTOR(XP,YP,XREF,YREF,ANGLE,DX,DY)
      IF(ANG1.GT.ANG2) GO TO 40
      IF(ANGLE.GT.ANG1.AND.ANGLE.LT.ANG2) GO TO 10
      GO TO 100
   10 NPC=NPC+1
      IF(NPC.LT.NPCMAX) GO TO 30
      XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      WRITE(DOUT,20) NPCMAX
   20 FORMAT(/,1X,'***WARNING***CONTOUR COMPLETION HALTED DUE TO EXCEEDA
     &NCE OF',/,1X,'MAXIMUM NUMBER(',I3,1X,') OF CONTOUR POINTS',/,
     &1X,'THE FINAL CONTOUR POINT WILL HAVE COORDINATES EQUAL TO THOSE O
     &F THE INITIAL POINT')
      RETURN
   30 XCON(NPC)=XREF+DX
      YCON(NPC)=YREF+DY
      GO TO 100
   40 IF(ANGLE.LT.ANG1.AND.ANGLE.GT.ANG2) GO TO 100
      NPC=NPC+1
      IF(NPC.LT.NPCMAX) GO TO 50
      XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      WRITE(DOUT,20) NPCMAX
      RETURN
   50 XCON(NPC)=XREF+DX
      YCON(NPC)=YREF+DY
  100 CONTINUE
C***CLOSE OUT THE CONTOUR BY ADDING A FINAL POINT WITH COORDINATES
C***EQUAL TO THOSE OF THE INITIAL POINT.
      NPC=NPC+1
      XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      RETURN
      END
