      PROGRAM FITCON
C***PROGRAM TO FIT DIGITIZED CONTOURS TO ELLIPTICAL SHAPES. PROGRAM
C***GENERATES A FILE OF ELLIPTICAL CONTOUR PARAMETERS TO BE USED BY
C***PROGRAM HCRIT TO PERFORM THE CRITICAL HEIGHT ANALYSIS FOR THE
C***HILL IN QUESTION. A PLOT FILE IS ALSO GENERATED FOR SUBSEQUENT
C***DISPLAY OF DIGITIZED AND FITTED CONTOURS.
C***
C***
C   GLOSSARY OF TERMS
C***
C***
C   A(J)=CALCULATED SEMI-MAJOR AXIS LENGTH(USER COORDINATES) FOR THE
C        ELLIPTICAL REPRESENTATION OF CONTOUR J
C   AFIL=ANGULAR FILTER SIZE(1 TO 22.5 DEGREES) INPUT BY THE USER
C        FOR THE CONTOUR COMPLETION ANALYSIS. MODIFIED AFTER INPUT
C        SO THAT IT DIVIDES EVENLY INTO 360 DEGREES.
C   ANGLE(M)=(M-1)*10.0 WHERE M=1,18
C   ANS=CHARACTER*1 VARIABLE HOLDING THE ANSWER TO A YES(Y) OR NO(N)
C       QUESTION
C   AR=VALUE OF THE AREA RETURNED BY A CALL TO SUBROUTINE ARCM.
C      AR WILL BE POSITIVE IF THE CONTOUR POINTS ARE GIVEN IN A
C      CLOCKWISE FASHION AND NEGATIVE IF THE CONTOUR POINTS ARE GIVEN
C      IN A COUNTER-CLOCKWISE FASHION
C   ARCM=SUBROUTINE TO CALCULATE THE CONTOUR AREA AND CENTROID
C        COORDINATES
C   AREA=AREA OF A GIVEN CONTOUR(=ABS(AR))
C   B(J)=CALCULATED SEMI-MINOR AXIS LENGTH(USER COORDINATES) FOR THE
C        ELLIPTICAL REPRESENTATION OF CONTOUR J
C   CFLAG=CONTOUR CLOSURE INDICATOR
C        =0(CONTOUR OPEN)
C        =1(CONTOUR CLOSED)
C   CN(M)=COS(PI*(M-1)*10.0/180.) WHERE M=1,18
C   CONIN=UNIT NUMBER FOR FILE CONTAINING CONTOUR IDs FOR THE HILL
C         IN QUESTION
C   CONFILE=CHARACTER*15 VARIABLE GIVING THE NAME OF THE FILE
C           CONTAINING CONTOUR IDs FOR THE HILL IN QUESTION
C   CONCOMP=SUBROUTINE WHICH ADDS POINTS TO COMPLETE A CONTOUR
C   COUT=UNIT NUMBER FOR OUTPUT FILE COUTFILE WHICH WILL BE INPUT TO
C        THE CRITICAL HEIGHT ANALYSIS PROGRAM
C   COUTFILE=CHARACTER*15 VARIABLE GIVING THE NAME OF THE OUTPUT FILE
C            CONTAINING THE FITTED HILL PARAMETERS WHICH WILL BE INPUT
C            TO THE CRITICAL HEIGHT ANALYSIS PROGRAM(HCRIT)
C   DFTOL=DISTANCE FROM FIRST TO LAST CONTOUR POINT(USER COORDINATES)
C   DOUT=UNIT NUMBER FOR FILE CONTAINING DIAGNOSTIC OUTPUT
C   DOUTFILE=CHARACTER*15 VARIABLE GIVING THE NAME OF THE FILE
C            CONTAINING DIAGNOSTIC OUTPUT FOR THE HILL IN QUESTION
C   ECC(J)=ECCENTRICITY OF THE ELLIPSE REPRESENTING CONTOUR J
C         =SQRT(A(J)**2-B(J)**2)/A(J)
C   HCON(J)=ELEVATION OF HILL CONTOUR J(USER COORDINATES)
C   HCONT=VALUE OF HCON(J) FOR A PARTICULAR CONTOUR J
C   HNAME=CHARACTER*15 VARIABLE GIVING THE HILL NAME
C   HTOP=HILL TOP ELEVATION(USER COORDINATES)
C   ICL=SMALLEST ID(1-9999) NUMBER FOR THE CONTOUR GROUP(INPUT ONLY FOR
C       ICMODE=2)
C   ICMODE=CONTOUR INPUT MODE FOR THE HILL IN QUESTION
C	  =1(ALL CONTOURS IN THE MASTER FILE SELECTED FOR INPUT)        FIT005
C         =2(CONTOUR ID RANGE SPECIFIED FOR INPUT)
C         =3(INPUT FILE WITH CONTOUR IDs SPECIFIED)
C   ICU=LARGEST ID NUMBER(1-9999) FOR THE CONTOUR GROUP(INPUT ONLY FOR
C       ICMODE=2)
C   IDC(J)=ID NUMBER FOR CONTOUR J WHICH HAS BEEN SELECTED FROM THE
C          CONTOUR MASTER FILE
C   IDCPK(I)=ID NUMBER FOR THE Ith CONTOUR SPECIFIED IN FILE CONFILE
C   IDHILL=HILL ID NUMBER(1-999) SPECIFIED BY THE USER
C   IN=UNIT NUMBER FOR CONTOUR MASTER FILE
C   ISMFLG=COMPLETION CODE RETURNED BY SUBROUTINE SMOMNT
C         =0(RADIUS OF GYRATION WAS CALCULATED)
C         =1(RADIUS OF GYRATION COULD NOT BE CALCULATED)
C   J=CURRENT NUMBER OF CONTOURS INPUT FROM THE MASTER FILE FOR THE
C     HILL IN QUESTION(AFTER QUALIFICATION AND EDITING)
C   LTPR=WORKING ARRAY USED BY SUBROUTINE ISORT
C   MASTER=CHARACTER*15 VARIABLE GIVING THE NAME OF THE MASTER FILE
C          CONTAINING THE CONTOUR ELEVATIONS AND POINT COORDINATES
C   MCFLAG=MULTIPLE CONTOUR SUBROUTINE COMPLETION CODE RETURNED FROM
C          SUBROUTINE MULTC
C         =0(MAXIMUM NUMBER OF POINTS EXCEEDED IN THE CONTOUR POINT
C            REASSIGNMENT PROCESS--CONTOUR REJECTED)
C         =1(THE LAST IN A SERIES OF MULTIPLE CONTOURS WAS FOUND NOT
C            TO BE CLOSED--CONTOUR REJECTED)
C         =2(CONTOUR WAS FOUND TO BE A SINGLE CONTOUR(I.E. NO CONTOUR
C            CLOSURE WAS FOUND BEFORE THE FINAL CONTOUR POINT))
C         =3(POINT REASSIGNMENT FOR THE MULTIPLE CONTOUR WAS
C            SUCCESSFULLY COMPLETED)
C   NC=TOTAL NUMBER OF CONTOURS SELECTED FROM THE MASTER FILE FOR THE
C      HILL IN QUESTION
C   NCID=NUMBER OF REQUESTED CONTOUR IDs CONTAINED IN CONFILE
C   NCMAX=MAXIMUM NUMBER OF CONTOURS ALLOWED
C   NCT2=2*NC
C   NFIL=INT(360./AFIL)
C   NPC=NUMBER OF POINTS ON A CONTOUR
C   NPCMAX=MAXIMUM NUMBER OF POINTS PER CONTOUR ALLOWED
C   NPCSV=NUMBER OF POINTS ON A CONTOUR PRIOR TO CONTOUR COMPLETION
C   NSLOPE=NUMBER OF LINES USED IN THE DETERMINATION OF THE LINE,
C          PASSING THROUGH THE CONTOUR CENTROID, WHICH GIVES THE
C          MAXIMUM RADIUS OF GYRATION FOR THE DIGITIZED CONTOUR
C   OREN(J)=ANGLE CORRESPONDING TO THE ORIENTATION OF THE SEMI-
C           MINOR AXIS OF CONTOUR J. THE POSSIBLE ORIENTATIONS REPRESENT
C           THE FOLLOWING DIRECTIONS WITH RESPECT TO THE POSITIVE
C           X-AXIS:0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,
C           160,AND 170 DEGREES
C   ORENT=CONTOUR MINOR AXIS ORIENTATION CORRESPONDING TO THE MAXIMUM
C         RADIUS OF GYRATION RETURNED BY SUBROUTINE SMOMNT. ORENT IS
C         SIMPLY A TEMPORARY HOLDING VARIABLE FOR OREN(J)
C   PI=3.14159265
C   PFILE=CHARACTER*15 VARIABLE GIVING THE NAME OF THE PLOT FILE
C   PFLAG=PLOT GENERATON INDICATOR
C        =0(NO PLOT GENERATED)
C        =1(PLOT GENERATED)
C   RAD=RADIUS OF THE EQUIVALENT CIRCULAR CONTOUR(USER COORDINATES)
C   RG=MAXIMUM RADIUS OF GYRATION CONSIDERING THE 18 ORIENTATIONS OF
C      AXES PASSING THROUGH THE CONTOUR CENTROID IN THE PLANE OF
C      THE CONTOUR(USER COORDINATES)
C   RGRAT=THE RATIO OF THE DIFFERENCE BETWEEN THE MAXIMUM AND MINIMUM
C         RADII OF GYRATION(CONSIDERING THE 18 ORIENTATIONS OF AXES
C         PASSING THROUGH THE CONTOUR CENTROID) TO THE MAXIMUM RADIUS
C         OF GYRATION. USED TO DETERMINE WHETHER AN INPUT CONTOUR SHOULD
C         BE REPRESENTED BY A CIRCLE
C   SKIPCN=SUBROUTINE TO SKIP OVER CONTOUR POINTS FOR CONTOURS WHICH ARE
C          NOT PROCESSED
C   SMOMNT=SUBROUTINE WHICH CALCULATES THE MAXIMUM RADIUS OF GYRATION
C          FOR AN INPUT CONTOUR BY CONSIDERING THE CALCULATED RADII OF
C          GYRATION FOR 18 LINES OF EQUAL ANGULAR SPACING WHICH PASS
C          THROUGH THE CONTOUR CENTROID IN THE PLANE OF THE CONTOUR
C   SN(M)=SIN(PI*(M-1)*10.0/180.) WHERE M=1,18
C   ISORT=SUBROUTINE TO CARRY OUT A SIMPLE PARAMETER SORT
C   UPL=UNIT NUMBER FOR THE FILE PFILE
C   UPSCR=UNIT NUMBER FOR THE SCRATCH FILE "PSCRAT"
C   XC=CONTOUR CENTROID X-COORDINATE RETURNED BY A CALL TO ARCM.
C      XC IS SIMPLY A TEMPORARY HOLDING VARIABLE FOR XCM(J)
C   XCM(J)=CALCULATED X-COORDINATE(USER COORDINATES) OF THE CENTER OF
C          MASS OF CONTOUR J
C   XCON(K)=X-COORDINATE(USER COORDINATES) OF A POINT K ON A CONTOUR
C   XCONSV(K)=HOLDING ARRAY FOR THE VALUE OF XCON(K) PRIOR TO CONTOUR
C             COMPLETION
C   XHTOP=INPUT VALUE FOR THE HILL CENTER X-COORDINATE(USER COORDINATES)
C   XMAX1=VARIABLE CONTAINING THE CURRENT MAXIMUM CONTOUR X-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE UNEDITED CONTOURS
C   XMAX2=VARIABLE CONTAINING THE CURRENT MAXIMUM CONTOUR X-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE EDITED CONTOURS
C   XMIN1=VARIABLE CONTAINING THE CURRENT MINIMUM CONTOUR X-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE UNEDITED CONTOURS
C   XMIN2=VARIABLE CONTAINING THE CURRENT MINIMUM CONTOUR X-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE EDITED CONTOURS
C   YC=CONTOUR CENTROID Y-COORDINATE RETURNED BY A CALL TO ARCM.
C      YC IS SIMPLY A TEMPORARY HOLDING VARIABLE FOR YCM(J)
C   YCM(J)=CALCULATED Y-COORDINATE(USER COORDINATES) OF THE CENTER OF
C          MASS OF CONTOUR J
C   YCON(K)=Y-COORDINATE(USER COORDINATES) OF A POINT K ON A CONTOUR
C   YCONSV(K)=HOLDING ARRAY FOR THE VALUE OF YCON(K) PRIOR TO CONTOUR
C             COMPLETION
C   YHTOP=INPUT VALUE FOR THE HILL CENTER Y-COORDINATE(USER COORDINATES)
C   YMAX1=VARIABLE CONTAINING THE CURRENT MAXIMUM CONTOUR Y-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE UNEDITED CONTOURS
C   YMAX2=VARIABLE CONTAINING THE CURRENT MAXIMUM CONTOUR Y-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE EDITED CONTOURS
C   YMIN1=VARIABLE CONTAINING THE CURRENT MINIMUM CONTOUR Y-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE UNEDITED CONTOURS
C   YMIN2=VARIABLE CONTAINING THE CURRENT MINIMUM CONTOUR Y-COORDINATE
C        FOR ALL INPUT CONTOURS. USED IN THE DETERMINATION OF PLOT
C        BOUNDARIES FOR THE EDITED CONTOURS
C***
C***
      INTEGER CFLAG,CONIN,DOUT,PFLAG,UPL,UPSCR,COUT
      CHARACTER*1 ANS
      CHARACTER*15 CONFILE,DOUTFILE,MASTER,COUTFILE,HNAME,PFILE
      DIMENSION XCON(1000),YCON(1000),HCON(200),A(200),B(200),
     &XCM(200),YCM(200),ECC(200),OREN(200),IDC(200),IDCPK(200),
     &LPTR(200),NPTR(200),XCONSV(1000),YCONSV(1000)
      DIMENSION SN(18),CN(18),ANGLE(18)
C***
C***
C   INITIALIZATION OF VARIABLES
C***
C***
C***INITIALIZE THE ANGLE ARRAY TO BE USED FOR THE CONTOUR
C***ORIENTATION ANALYSIS.
      DATA ANGLE/0.,10.,20.,30.,40.,50.,60.,70.,80.,90.,100.,110.,
     &120.,130.,140.,150.,160.,170./
C***INITIALIZE SINE AND COSINE ARRAYS TO BE USED FOR THE CONTOUR
C***ORIENTATION ANALYSIS.
      DATA SN/0.,0.1736,0.3420,0.5,0.6428,0.7660,0.8660,0.9397,
     &0.9848,1.0,0.9848,0.9397,0.8660,0.7660,0.6428,0.5,0.3420,0.1736/
      DATA CN/1.0,0.9848,0.9397,0.8660,0.7660,0.6428,0.5,0.3420,0.1736,
     &0.0,-0.1736,-0.3420,-0.5,-0.6428,-0.7660,-0.8660,-0.9397,-0.9848/
C***SPECIFY FILE UNIT NUMBERS.
      IOPT=20
      CONIN=14
      IN=15
      DOUT=16
      COUT=17
      UPL=18
      UPSCR=19
C***SPECIFY CONSTANTS.
      PI=3.14159265
      NCMAX=200
      NPCMAX=1000
      NSLOPE=18
C***
C***
C   INPUT FILE NAMES(MASTER FILE AND DIAGNOSTIC OUTPUT FILE) AND
C   HILL IDENTIFICATION INFORMATION.
C***
C***
C
C   NOTE : CODE MODIFIED BY CSC 7/7/88 SO THAT FILE NAMES, ETC ARE READ FROM
C   AN OPTIONS FILE (FOPTIONS) INSTEAD OF INTERACTIVELY - DJB
C
      OPEN(IOPT,FILE='FOPTIONS',STATUS='OLD')
C
C***INPUT NAMES FOR THE CONTOUR MASTER FILE AND THE DIAGNOSTIC
C***OUTPUT FILE.
C   5 WRITE(*,10)
C  10 FORMAT(/,1X,'ENTER CONTOUR MASTER FILE NAME -> '\)
      READ(20,'(A)') MASTER
C     IF(MASTER.EQ.' ') GO TO 5
C  15 WRITE(*,20)
C  20 FORMAT(/,1X,'ENTER DIAGNOSTIC OUTPUT FILE NAME -> '\)
      READ(20,'(A)') DOUTFILE
C     IF(DOUTFILE.EQ.' ') GO TO 15
C***OPEN THE CONTOUR MASTER FILE AND THE DIAGNOSTIC OUTPUT FILE.
      OPEN(IN,FILE=MASTER,STATUS='OLD')
      OPEN(DOUT,FILE=DOUTFILE,STATUS='NEW')
C***INPUT HILL IDENTIFIER NUMBER AND HILL NAME.
C  25 WRITE(*,30)
C  30 FORMAT(/,1X,'ENTER HILL ID NUMBER(1-99) -> '\)
      READ(20,31) IDHILL
   31 FORMAT(I2)
C     IF(IDHILL.EQ.0) GO TO 25
C  35 WRITE(*,40)
C  40 FORMAT(/,1X,'ENTER HILL NAME(1-15CHAR.) -> '\)
      READ(20,'(A)') HNAME
C     IF(HNAME.EQ.' ') GO TO 35
      WRITE(DOUT,50) IDHILL,HNAME
   50 FORMAT(/,1X,'HILL NUMBER',I4,1X,'IS',1X,A15)
C***
C***
C   INPUT THE HILL TOP ELEVATION AND THE COORDINATES OF THE
C   HILL CENTER.
C***
C***
C***INPUT THE HILL TOP ELEVATION.
   60 CONTINUE
C     WRITE(*,70)
C  70 FORMAT(/,1X,'INPUT HILL TOP ELEVATION -> '\)
      READ(20,'(BN,F10.0)') HTOP
C***INPUT THE HILL CENTER X AND Y COORDINATES.
C  80 WRITE(*,110)
C 110 FORMAT(/,1X,'INPUT HILL CENTER X-COORDINATE -> '\)
      READ(20,'(BN,F10.0)') XHTOP
C 115 WRITE(*,120)
C 120 FORMAT(/,1X,'INPUT HILL CENTER Y-COORDINATE -> '\)
      READ(20,'(BN,F10.0)') YHTOP
C***DETERMINE WHETHER ANGULAR FILTERING IS TO BE USED.
C     WRITE(*,1201)
C1201 FORMAT(/,1X,'ANGULAR FILTERING?(Y/N) -> '\)
      READ(20,'(A)') ANS
      IF(ANS.EQ.'Y'.OR.ANS.EQ.'y') GO TO 1202
      NFIL=0
      GO TO 1261
 1202 CONTINUE
C***INPUT ANGULAR FILTER SIZE FOR USE IN THE CONTOUR COMPLETION ANALYSIS
C 121 WRITE(*,122)
C 122 FORMAT(/,1X,'INPUT ANGULAR FILTER SIZE FOR CONTOUR COMPLETION(1-22
C    &.5 DEG.) -> '\)
      READ(20,'(BN,F10.0)') AFIL
      IF(AFIL.GE.1.0.AND.AFIL.LE.22.5) GO TO 124
C     WRITE(*,123)
C 123 FORMAT(/,1X,'***ERROR*** SPECIFIED FILTER SIZE OUT OF RANGE--TRY A
C    &GAIN')
C     GO TO 121
C***WRITE SPECIFIED ANGULAR FILTER SIZE TO THE DIAGNOSTIC OUTPUT FILE.
  124 WRITE(DOUT,125) AFIL
  125 FORMAT(/,1X,'SPECIFIED ANGULAR FILTER SIZE FOR CONTOUR COMPLETION=
     &',F10.3,1X,'DEGREES')
C***MODIFY FILTER SIZE SO THAT IT DIVIDES EVENLY INTO 360 DEGREES.
      NFIL=INT(360./AFIL)
C***WRITE MODIFIED ANGULAR FILTER SIZE TO THE DIAGNOSTIC OUTPUT FILE.
      WRITE(DOUT,126) AFIL
  126 FORMAT(/,1X,'MODIFIED ANGULAR FILTER SIZE=',F10.3,1X,'DEGREES')
 1261 CONTINUE
C***MAKE SURE THAT MAP BOUNDARIES INCLUDE HILL CENTER COORDINATES.
      XMIN1=XHTOP
      YMIN1=YHTOP
      XMAX1=XHTOP
      YMAX1=YHTOP
      XMIN2=XHTOP
      YMIN2=YHTOP
      XMAX2=XHTOP
      YMAX2=YHTOP
C***WRITE THE HILL TOP ELEVATION AND HILL CENTER COORDINATES TO THE
C***DIAGNOSTIC OUTPUT FILE.
      WRITE(DOUT,130) HTOP,XHTOP,YHTOP
  130 FORMAT(/,1X,'HILL TOP ELEVATION=',E12.4,/,
     &1X,'HILL CENTER X-COORDINATE=',E12.4,/,
     &1X,'HILL CENTER Y-COORDINATE=',E12.4)
C***
C***
C   SPECIFICATION OF CONTOURS TO BE INPUT FROM THE MASTER FILE USING
C   ONE OF 3 METHODS
C***
C***
C***ASK THE USER TO SPECIFY THE MODE OF CONTOUR SELECTION FROM
C***THE CONTOUR MASTER FILE.
C 135 WRITE(*,140)
C     WRITE(*,142)
C 140 FORMAT(//,22X,'SPECIFY CONTOUR SELECTION MODE',/,
C    &22X,'1.) ALL CONTOURS SELECTED',/,
C    &22X,'2.) SELECT RANGE OF CONTOUR IDs',/,
C    &22X,'3.) INPUT FILE WITH CONTOUR IDs')
C 142 FORMAT(/,26X,'CHOICE?(1,2,OR 3) -> '\)
      READ(20,143) ICMODE
  143 FORMAT(I3)
      IF(ICMODE.EQ.1) GO TO 150
      IF(ICMODE.EQ.2) GO TO 170
      IF(ICMODE.EQ.3) GO TO 210
C     WRITE(*,146)
C 146 FORMAT(/,1X,'***ERROR***  MODE SELECTION OUT OF RANGE--TRY AGAIN')
C     GO TO 135
C***USE ALL CONTOURS IN THE MASTER FILE(CONTOUR SELECTION MODE 1).
  150 WRITE(DOUT,160) MASTER
  160 FORMAT(/,1X,'ALL CONTOURS IN FILE  ',A15,1X,'SELECTED FOR INPUT')
      GO TO 300
C***INPUT THE SMALLEST AND LARGEST ID NUMBERS FOR THE GROUP OF
C***CONTOURS(CONTOUR SELECTION MODE NUMBER 2).
C     WRITE(*,180)
C 180 FORMAT(/,1X,'INPUT SMALLEST ID NUMBER(1-9999) FOR CONTOUR GROUP ->
C    & '\)
  170 READ(20,'(BN,I4)') ICL
C     IF(ICL.EQ.0) GO TO 170
C 185 WRITE(*,190)
C 190 FORMAT(/,1X,'INPUT LARGEST ID NUMBER(1-9999) FOR CONTOUR GROUP ->
C    &'\)
      READ(20,'(BN,I4)') ICU
C     IF(ICU.EQ.0) GO TO 185
C     IF(ICU.GE.ICL) GO TO 195
C     WRITE(*,191)
C 191 FORMAT(/,1X,'***ERROR***  LOWER SERIAL NUMBER GREATER THAN UPPER--
C    &TRY AGAIN')
C     GO TO 170
  195 CONTINUE
C***WRITE ID RANGE FOR CONTOUR SELECTION TO THE DIAGNOSTIC OUTPUT FILE.
      WRITE(DOUT,200) MASTER,ICL,ICU
  200 FORMAT(/,1X,'CONTOURS SELECTED FROM MASTER FILE ',A15,/,
     &1X,'HAVE ID NUMBERS BETWEEN',I5,1X,'AND',I5)
      GO TO 300
C***INPUT THE NAME OF THE FILE CONTAINING THE CONTOUR ID NUMBERS FOR
C***THE HILL IN QUESTION(CONTOUR SELECTION MODE NUMBER 3).
C     WRITE(*,220)
C 220 FORMAT(/,1X,'ENTER CONTOUR ID FILE NAME -> '\)
  210 READ(20,'(A)') CONFILE
C     IF(CONFILE.EQ.' ') GO TO 210
C***OPEN CONTOUR ID FILE.
      OPEN(CONIN,FILE=CONFILE,STATUS='OLD')
C***INPUT ID NUMBERS FROM THE CONTOUR ID FILE.
C***SET COUNTER FOR CONTOUR IDs.
      NCID=1
  230 CONTINUE
C***READ THE NEXT ID NUMBER.
      READ(CONIN,*,END=270) IDCPK(NCID)
      NCID=NCID+1
C***CHECK TO SEE IF THE NUMBER OF CONTOURS IS GREATER THAN THE MAXIMUM
C***AMOUNT.
      IF(NCID.GT.NCMAX) GO TO 250
      GO TO 230
  250 WRITE(DOUT,260) NCMAX
  260 FORMAT(/,1X,'***WARNING***MAXIMUM NUMBER OF CONTOURS(',I4,') REAC
     &HED')
C***DETERMINE WHETHER ANY CONTOURS HAVE BEEN REQUESTED. IF NOT, WRITE
C***AN ERROR MESSAGE TO BOTH THE DIAGNOSTIC OUTPUT FILE AND THE SCREEN
C***AND THEN EXIT THE PROGRAM.
  270 NCID=NCID-1
      IF(NCID.EQ.0) GO TO 1000
      WRITE(DOUT,280) NCID,MASTER,IDHILL,HNAME
  280 FORMAT(/,1X,I4,1X,'CONTOURS TO BE SELECTED FROM MASTER FILE ',
     &A15,/,1X,'FOR HILL',I4,'(',A15,')',//,1X,'IDs REQUESTED:')
C***SORT LIST OF CONTOUR IDs IN ASCENDING ORDER.
      CALL ISORT(IDCPK,NCID,LPTR)
      WRITE(DOUT,290) (IDCPK(I),I=1,NCID)
  290 FORMAT(1X,I5)
C***CLOSE THE CONTOUR ID FILE.
      CLOSE(CONIN,STATUS='KEEP')
  300 CONTINUE
C***
C***
C   DETERMINE WHETHER A PLOT IS TO BE GENERATED, INPUT PLOT FILE NAME,
C   AND OPEN THE PLOT FILE. IF PLOT IS REQUESTED, ALSO OPEN A SCRATCH
C   FILE "PSCRAT".
C***
C***
C***ASK WHETHER A PLOT IS TO BE GENERATED. FIRST, INITIALIZE THE PLOT
C***FLAG INDICATOR TO CORRESPOND TO A "NO" ANSWER.
      PFLAG=0
C     WRITE(*,310)
C 310 FORMAT(/,1X,'PLOT REQUESTED?(Y/N) -> '\)
      READ(20,'(A)') ANS
      IF(ANS.EQ.'Y'.OR.ANS.EQ.'y') PFLAG=1
      IF(PFLAG.EQ.0) GO TO 315
C***ASK USER TO INPUT THE NAME OF THE PLOT FILE.
C3101 WRITE(*,311)
C 311 FORMAT(/,1X,'ENTER PLOT FILE NAME -> '\)
      READ(20,'(A)') PFILE
C     IF(PFILE.EQ.' ') GO TO 3101
C***OPEN THE PLOT FILE AND THE SCRATCH FILE.
      OPEN(UPL,FILE=PFILE,STATUS='NEW')
      OPEN(UPSCR,FILE='PSCRAT',STATUS='NEW')
      IF(PFLAG.NE.1) GO TO 315
C***WRITE "FITCON" TO THE FIRST RECORD OF THIS PLOT FILE TO INDICATE
C***THAT THE PLOT FILE IS BEING GENERATED BY PROGRAM FITCON.
      WRITE(UPL,3111)
 3111 FORMAT('FITCON')
C***WRITE THE HILL ID NUMBER AND NAME TO THE PLOT FILE.
      WRITE(UPL,312) IDHILL,HNAME
  312 FORMAT(I2,1X,A15)
C***WRITE THE HILL CENTER COORDINATES TO THE PLOT FILE.
      WRITE(UPL,313) XHTOP,YHTOP
  313 FORMAT(2E15.4)
  315 CONTINUE
      WRITE(*,316)
  316 FORMAT(/,1X,'Please wait...Contour data being processed',/)
C***
C***
C   INPUT AND EDIT CONTOUR DATA.
C***
C***
C***SET CONTOUR COUNTER.
      J=1
  320 CONTINUE
C***CHECK WHETHER THE MAXIMUM NUMBER OF CONTOURS HAVE BEEN INPUT.
      IF(J.GT.NCMAX) GO TO 670
C***INPUT THE ID NUMBER, ELEVATION, NUMBER OF POINTS, AND CONTOUR
C***CLOSURE INDICATOR FOR THE NEXT CONTOUR.
      READ(IN,*,END=700) IDC(J),HCON(J),NPC,CFLAG
      IF(ICMODE.NE.2) GO TO 340
C***CONTOUR SELECTION MODE 2
C***DETERMINE WHETHER THE CONTOUR ID NUMBER FALLS WITHIN THE BOUNDS
C***SPECIFIED BY THE USER. IF NOT, READ DATA FOR ANOTHER CONTOUR FROM
C***THE MASTER FILE.
      IF(IDC(J).LT.ICL.OR.IDC(J).GT.ICU) GO TO 355
      GO TO 360
  340 IF(ICMODE.NE.3) GO TO 360
C***CONTOUR SELECTION MODE 3
C***DETERMINE WHETHER THE ID NUMBER FOR THE CONTOUR INPUT FROM THE
C***MASTER FILE MATCHES ONE OF THE SORTED ID NUMBERS INPUT FROM CONFILE.
C***IF NOT, READ DATA FOR ANOTHER CONTOUR FROM THE MASTER FILE.
      DO 350 I=1,NCID
C***SINCE IDCPK ARRAY VALUES HAVE BEEN SORTED IN ASCENDING ORDER, THE
C***CURRENT ID NUMBER FROM THE MASTER FILE CAN SOMETIMES BE ELIMINATED
C***WITHOUT HAVING TO GO THROUGH THE ENTIRE LIST OF IDCPK ARRAY VALUES.
      IF(IDC(J).LT.IDCPK(I)) GO TO 355
      IF(IDC(J).EQ.IDCPK(I)) GO TO 360
  350 CONTINUE
  355 CALL SKIPCN(IN,NPC)
      GO TO 320
  360 CONTINUE
C***CHECK WHETHER THE CONTOUR ELEVATION IS GREATER THAN THE HILL TOP
C***ELEVATION. IF SO, WRITE AN ERROR MESSAGE AND DISCONTINUE PROCESSING
C***THE CONTOUR.
      IF(HCON(J).LT.HTOP) GO TO 375
      WRITE(*,365) IDC(J)
  365 FORMAT(/,1X,'Contour ID ',I4,1X,'has been rejected',/,1X,
     &'--See diagnostic output file after program completion')
      WRITE(DOUT,370) IDC(J),HCON(J),HTOP
  370 FORMAT(/,1X,'***ERROR***  CONTOUR ID',I5 ,1X,'DOES NOT HAVE AN ELE
     &VATION LESS THEN THE HILL TOP',/,1X,'CONTOUR ELEVATION=',E12.4,
     &/,1X,'HILL TOP ELEVATION=',E12.4,/,1X,'CONTOUR WILL NOT BE PROCESS
     &ED',/)
      CALL SKIPCN(IN,NPC)
      GO TO 320
C***FIND WHETHER THE CONTOUR HAS AN ELEVATION WHICH IS THE SAME AS A
C***CONTOUR WHICH HAS BEEN PREVIOUSLY ACCEPTED. IF SO, WRITE AN ERROR
C***MESSAGE AND DISCONTINUE PROCESSING THE CONTOUR. MULTIPLE CONTOURS
C***AT THE SAME ELEVATION MUST BE INPUT AS A SINGLE CONTOUR.
  375 IF(J.EQ.1) GO TO 380
      JM1=J-1
      DO 376 JJ=1,JM1
      JJK=JJ
      IF(ABS(HCON(J)-HCON(JJ)).LE.1.0E-15) GO TO 377
  376 CONTINUE
      GO TO 380
  377 WRITE(DOUT,378) IDC(JJK),HCON(J)
  378 FORMAT(/,1X,'***ERROR***  PREVIOUSLY ACCEPTED CONTOUR ID',I5,1X,
     &'ALSO HAS',/,1X,'AN ELEVATION OF',E15.4,1X,'--CONTOUR REJECTED',
     &/,1X,'MULTIPLE CONTOURS AT THE SAME ELEVATION MUST BE INPUT AS A S
     &INGLE CONTOUR')
      WRITE(*,365) IDC(J)
      CALL SKIPCN(IN,NPC)
      GO TO 320
C***CHECK WHETHER THE CONTOUR HAS FEWER THAN 3 POINTS. IF SO, WRITE AN
C***ERROR MESSAGE AND DISCONTINUE PROCESSING THE CONTOUR.
  380 IF(NPC.GT.2) GO TO 400
      WRITE(*,365) IDC(J)
      WRITE(DOUT,390) IDC(J),NPC
  390 FORMAT(/,1X,'***ERROR***  CONTOUR ID', I5,1X,'HAS FEWER THAN 3 POI
     &NTS.',/,14X,'CONTOUR WILL NOT BE PROCESSED',/)
      CALL SKIPCN(IN,NPC)
      GO TO 320
C***CHECK WHETHER THE MAXIMUM NUMBER OF CONTOUR POINTS HAS BEEN EXCEEDED
C***IF SO, WRITE AN ERROR MESSAGE AND DISCONTINUE PROCESSING THE CONTOUR
  400 IF(NPC.LT.NPCMAX) GO TO 420
      WRITE(*,365) IDC(J)
      WRITE(DOUT,410) IDC(J),NPC,NPCMAX
  410 FORMAT(/,1X,'***ERROR***  CONTOUR ID',I5,1X,'HAS',I5,1X,'POINTS.',
     &/,14X,'MAXIMUM ALLOWED IS',I5,'. CONTOUR WILL NOT BE PROCESSED.')
      CALL SKIPCN(IN,NPC)
      GO TO 320
C***WRITE THE CONTOUR ELEVATION TO THE DIAGNOSTIC OUTPUT FILE.
  420 WRITE(DOUT,425) IDC(J),HCON(J)
  425 FORMAT(/,1X,'CONTOUR ELEVATION FOR CONTOUR ID', I5,1X,'=',E12.4)
C***INPUT X,Y COORDINATES OF CONTOUR POINTS.
      READ(IN,*) (XCON(K),YCON(K),K=1,NPC)
C***WRITE THE CONTOUR POINT COORDINATES TO THE DIAGNOSTIC OUTPUT FILE.
      WRITE(DOUT,440) IDC(J)
  440 FORMAT(/,1X,'X-Y COORDINATES INPUT FOR CONTOUR ID',I5,/)
      WRITE(DOUT,450) (XCON(K),YCON(K),K=1,NPC)
  450 FORMAT(1X,2E12.4)
C***DETERMINE WHETHER THIS CONTOUR IS ACTUALLY A SET OF MULTIPLE
C***CONTOURS AT THE SAME ELEVATION.
      CALL MULTC(XCON,YCON,NPC,NPCMAX,MCFLAG)
      IF(MCFLAG.EQ.0) WRITE(DOUT,451)
  451 FORMAT(/,1X,'MAXIMUM NUMBER OF POINTS EXCEEDED IN THE CONTOUR',
     &1X,'POINT REASSIGNMENT PROCESS.',/,1X,'--CONTOUR REJECTED')
      IF(MCFLAG.EQ.1) WRITE(DOUT,452)
  452 FORMAT(/,1X,'THE LAST IN A SERIES OF MULTIPLE CONTOURS WAS FOUND',
     &1X,'NOT TO BE CLOSED.',/,1X,'--CONTOUR REJECTED')
      IF(MCFLAG.EQ.2) WRITE(DOUT,453)
  453 FORMAT(/,1X,'CONTOUR WAS FOUND TO BE A SINGLE CONTOUR.',/,1X,'(I.E
     &. NO CONTOUR CLOSURE WAS FOUND BEFORE THE FINAL CONTOUR POINT.)')
      IF(MCFLAG.EQ.3) WRITE(DOUT,454)
  454 FORMAT(/,1X,'POINT REASSIGNMENT FOR THE MULTIPLE CONTOUR WAS',
     &1X,'SUCCESSFULLY COMPLETED')
      IF(MCFLAG.EQ.4) WRITE(DOUT,455)
  455 FORMAT(/,1X,'POINT REASSIGNMENT FOR THE MULTIPLE CONTOUR WAS SUCCE
     &SSFULLY COMPLETED',/,1X,'AFTER THE POINT INPUT ORDER OF ONE OR MOR
     &E COMPONENT CONTOURS WAS',/,1X,'REVERSED TO MAKE THE ORDER OF EACH
     & COMPONENT CONTOUR THE SAME AS THE',/,1X,'FIRST COMPONENT CONTOUR'
     &)
      IF(MCFLAG.LT.2) WRITE(*,365) IDC(J)
      IF(MCFLAG.LT.2) GO TO 320
C***BEFORE ANY ADDITIONAL EDITING, SAVE THE CONTOUR POINT COORDINATES
C***FOR LATER WRITING TO THE PLOT FILE
      NPCSV=NPC
      DO 460 K=1,NPCSV
      XCONSV(K)=XCON(K)
      YCONSV(K)=YCON(K)
  460 CONTINUE
      IF(MCFLAG.GE.3) GO TO 530
C***PERFORM EDIT CHECKING FOR A SINGLE CONTOUR.
C***FIND THE DISTANCE(DFTOL) FROM THE FIRST TO THE LAST CONTOUR.
      DFTOL=SQRT((XCON(NPC)-XCON(1))**2+(YCON(NPC)-YCON(1))**2)
C***IF THIS DISTANCE IS EFFECTIVELY ZERO AND THE CONTOUR HAS BEEN
C***SPECIFIED AS CLOSED, THEN CONTINUE PROCESSING THE CONTOUR.
      IF(DFTOL.LT.1.0E-15.AND.CFLAG.EQ.1) GO TO 530
C***IF THIS DISTANCE IS EFFECTIVELY ZERO AND THE CONTOUR HAS BEEN
C***SPECIFIED AS OPEN, THEN WRITE A WARNING TO THE DIAGNOSTIC OUTPUT
C***FILE AND CONTINUE PROCESSING THE CONTOUR AS IF IT WERE CLOSED.
      IF(DFTOL.LT.1.0E-15.AND.CFLAG.NE.1) GO TO 510
C***IF THIS DISTANCE IS SIGNIFICANTLY GREATER THAN ZERO AND THE CONTOUR
C***HAS BEEN SPECIFIED AS CLOSED, THEN ADD TO THE CONTOUR A FINAL POINT
C***WHICH HAS THE SAME COORDINATES AS THE FIRST POINT. IF THE ADDITION
C***OF THIS POINT CAUSES THE NUMBER OF CONTOUR POINTS TO EXCEED THE
C***MAXIMUM ALLOWABLE, THEN SUBSTITUTE THE FIRST CONTOUR POINT FOR THE
C***LAST CONTOUR POINT AND CONTINUE PROCESSING THE CONTOUR AS IF IT WERE
C***CLOSED. THE APPROPRIATE WARNINGS ARE WRITTEN TO THE DIAGNOSTIC
C***OUTPUT FILE.
      IF(DFTOL.GE.1.0E-15.AND.CFLAG.EQ.1) GO TO 470
C***IF THIS DISTANCE IS SIGNIFICANTLY GREATER THAN ZERO AND THE CONTOUR
C***HAS BEEN SPECIFIED AS OPEN, THEN CALL SUBROUTINE CONCOMP TO ADD
C***POINTS TO COMPLETE THE CONTOUR.
      CALL CONCOMP(XCON,YCON,NPC,NPCMAX,XHTOP,YHTOP,AFIL,NFIL,DOUT)
      GO TO 530
  470 IF(NPC.EQ.NPCMAX) GO TO 490
      NPC=NPC+1
      XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      WRITE(DOUT,480)
  480 FORMAT(/,1X,'***WARNING***CONTOUR SPECIFIED AS CLOSED WAS FOUND TO
     & BE OPEN.',/,14X,'ADDED FINAL POINT IS ASSUMED TO BE THE SAME AS T
     &HE INITIAL POINT.')
      GO TO 530
  490 XCON(NPC)=XCON(1)
      YCON(NPC)=YCON(1)
      WRITE(DOUT,500)
  500 FORMAT(/,1X,'***WARNING***CONTOUR SPECIFIED AS CLOSED WAS FOUND TO
     & BE OPEN.',/,14X,'ADDED FINAL POINT IS ASSUMED TO BE THE SAME AS T
     &HE INITIAL POINT',//,1X,'***WARNING***MAXIMUM NUMBER OF CONTOUR PO
     &INTS EXCEEDED IN THE CLOSING OPERATION.',/,14X,'FINAL POINT IS REP
     &LACED BY THE INITIAL POINT.')
      GO TO 530
  510 WRITE(DOUT,520)
  520 FORMAT(/,1X,'***WARNING***CONTOUR SPECIFIED AS OPEN WAS FOUND TO B
     &E CLOSED')
  530 CONTINUE
C***WRITE THE EDITED NUMBER OF CONTOUR POINTS TO THE DIAGNOSTIC OUTPUT
C***FILE.
      WRITE(DOUT,531) IDC(J),NPC
  531 FORMAT(/,1X,'MODIFIED NUMBER OF POINTS FOR CONTOUR ID',I5,1X,'=',
     &I5)
C***WRITE THE EDITED CONTOUR POINT COORDINATES TO THE DIAGNOSTIC OUTPUT
C***FILE.
      WRITE(DOUT,532) IDC(J)
  532 FORMAT(/,1X,'X-Y COORDINATES(EDITED) FOR CONTOUR ID',I5,/)
      WRITE(DOUT,450) (XCON(K),YCON(K),K=1,NPC)
C***
C***
C   CALCULATE THE AREA AND CENTER OF MASS FOR THE INPUT CONTOUR.
C***
C***
      CALL ARCM(XCON,YCON,AR,XC,YC,NPC)
      AREA=ABS(AR)
C***DETERMINE WHETHER THE CALCULATED AREA OF THE CONTOUR IS EFFECTIVELY
C***ZERO. IF SO, WRITE AN ERROR MESSAGE AND DISCONTINUE PROCESSING THE
C***CONTOUR.
      IF(AREA.GT.1.0E-15) GO TO 550
      WRITE(*,365) IDC(J)
      WRITE(DOUT,540)
  540 FORMAT(/,1X,'AREA FOUND TO BE EFFECTIVELY ZERO--CONTOUR REJECTED')
      GO TO 320
  550 CONTINUE
C***CALCULATE THE MAXIMUM RADIUS OF GYRATION AND THE ASSOCIATED MINOR
C***AXIS ORIENTATION FOR THE CONTOUR.
      CALL SMOMNT(XCON,YCON,AR,NSLOPE,SN,CN,ANGLE,NPC,
     &XC,YC,RG,RGRAT,ORENT,ISMFLG)
C***DETERMINE WHETHER A REAL VALUE FOR THE RADIUS OF GYRATION HAS BEEN
C***CALCULATED FOR THE CONTOUR. IF NOT, WRITE AN ERROR MESSAGE AND
C***DISCONTINUE PROCESSING THE CONTOUR.
      IF(ISMFLG.EQ.0) GO TO 555
      WRITE(*,365) IDC(J)
      WRITE(DOUT,551)
  551 FORMAT(/,1X,'CONTOUR REJECTED--A REAL VALUE FOR THE RADIUS OF GYRA
     &TION COULD NOT BE',/,1X,'COMPUTED. THIS CAN OCCUR IF THE CONTOUR I
     &S VERY TORTUOUS AND TOO FEW POINTS WERE',/,1X,' USED IN ITS DIGITI
     &ZATION OR IF A VERY TORTUOUS CONTOUR HAS BEEN INPUT AS',/,1X,'INCO
     &MPLETE EVEN IF A SUFFICIENT NUMBER OF POINTS HAVE BEEN USED IN THE
     &',/,1X,'DIGITIZATION PROCESS.',//,1X,'SOLUTION--MANUALLY COMPLETE
     &AND/OR REDIGITIZE THE CONTOUR')
      GO TO 320
  555 CONTINUE
      XCM(J)=XC
      YCM(J)=YC
C***WRITE THE CALCULATED CONTOUR AREA AND CENTROID COORDINATES TO THE
C***DIAGNOSTIC OUTPUT FILE.
      WRITE(DOUT,560) AREA,XCM(J),YCM(J)
  560 FORMAT(/,1X,'CONTOUR AREA=',E12.4,/,
     &1X,'X-COORDINATE OF CONTOUR CENTROID=',E12.4,/,
     &1X,'Y-COORDINATE OF CONTOUR CENTROID=',E12.4)
C***EDIT CHECKS HAVE BEEN COMPLETED. CONTOUR HAS BEEN ACCEPTED FOR
C***PROCESSING.
C***
C***
C     IF A PLOT HAS BEEN REQUESTED, WRITE THE CONTOUR COORDINATES(BOTH
C     UNEDITED AND EDITED) TO THE SCRATCH FILE "PSCRAT" AND UPDATE THE
C     PLOT BOUNDARIES TO REFLECT THE BOUNDARIES OF THE NEWLY INPUT
C     CONTOUR.
C***
C***
      IF(PFLAG.EQ.0) GO TO 575
      WRITE(UPSCR,570) NPCSV,HCON(J)
  570 FORMAT(I10,E15.4)
      DO 572 K=1,NPCSV
      WRITE(UPSCR,571) XCONSV(K),YCONSV(K)
  571 FORMAT(2E15.4)
      IF(XCONSV(K).GT.XMAX1) XMAX1=XCONSV(K)
      IF(XCONSV(K).LT.XMIN1) XMIN1=XCONSV(K)
      IF(YCONSV(K).GT.YMAX1) YMAX1=YCONSV(K)
      IF(YCONSV(K).LT.YMIN1) YMIN1=YCONSV(K)
  572 CONTINUE
      WRITE(UPSCR,570) NPC,HCON(J)
      DO 574 K=1,NPC
      WRITE(UPSCR,571) XCON(K),YCON(K)
      IF(XCON(K).GT.XMAX2) XMAX2=XCON(K)
      IF(XCON(K).LT.XMIN2) XMIN2=XCON(K)
      IF(YCON(K).GT.YMAX2) YMAX2=YCON(K)
      IF(YCON(K).LT.YMIN2) YMIN2=YCON(K)
  574 CONTINUE
  575 CONTINUE
C***
C***
C   COMPUTE THE PARAMETERS FOR THE ELLIPTICAL REPRESENTATION OF THE
C   CONTOUR.
C***
C***
      OREN(J)=ORENT
C***CALCULATE THE SEMI-MAJOR AXIS LENGTH FOR THE EQUIVALENT ELLIPSE
C***USING THE RELATIONSHIP, FOR AN ACTUAL ELLIPSE, BETWEEN THE
C***SEMI-MAJOR AXIS LENGTH AND THE RADIUS OF GYRATION ABOUT AN AXIS
C***WHICH COINCIDES WITH THE SEMI-MINOR AXIS OF THE ELLIPSE.
      A(J)=2.*RG
C***CALCULATE THE SEMI-MINOR AXIS LENGTH FOR THE EQUIVALENT ELLIPSE
C***USING THE FORMULA FOR THE AREA OF AN ELLIPSE AND THE PREVIOUSLY
C***DETERMINED VALUE FOR THE SEMI-MAJOR AXIS LENGTH.
      B(J)=AREA/(PI*A(J))
C***DETERMINE WHETHER THE CONTOUR SHOULD BE CONSIDERED CIRCULAR
C***FIRST TEST FOR CIRCULAR CONTOUR--CALCULATED SEMI-MINOR AXIS
C***LENGTH GREATER THAN OR EQUAL TO SEMI-MAJOR AXIS LENGTH.
      IF(A(J).GT.B(J)) GO TO 590
      WRITE(DOUT,580)
  580 FORMAT(/,1X,'CALCULATED ELLIPSE SEMI-MINOR AXIS LENGTH WAS FOUND',
     &' TO BE GREATER THAN',/,1X,'OR EQUAL TO THE CALCULATED SEMI-MAJOR'
     &,' AXIS LENGTH--CONTOUR ASSUMED TO BE CIRCULAR')
      GO TO 610
C***SECOND TEST FOR CIRCULAR CONTOUR--DETERMINE WHETHER THE RELATIVE
C***DIFFERENCE BETWEEN THE MAXIMUM AND MINIMUM RADII OF GYRATION FOR
C***THE CONTOUR IS LESS THAN 1 PERCENT.
  590 IF(RGRAT.GT.0.01) GO TO 620
      WRITE(DOUT,600)
  600 FORMAT(/,1X,'THE RELATIVE DIFFERENCE BETWEEN THE MAXIMUM AND',
     &' MINIMUM RADII OF GYRATION',/,1X,'FOR THE CONTOUR IS LESS THAN',
     &' 1 PERCENT--CONTOUR ASSUMED TO BE CIRCULAR')
C***SET BOTH THE SEMI-MAJOR AND SEMI-MINOR AXIS LENGTHS EQUAL TO THE
C***RADIUS OF A CIRCLE WITH AREA EQUAL TO AREA.
  610 RAD=SQRT(AREA/PI)
C***THE ECCENTRICITY OF A CIRCLE IS ZERO.
      ECC(J)=0.
      A(J)=RAD
      B(J)=RAD
      GO TO 630
C***CALCULATE THE ECCENTRICITY OF THE ELLIPSE REPRESENTING THE CONTOUR.
  620 ECC(J)=SQRT(A(J)**2-B(J)**2)/A(J)
C***WRITE ELLIPSE FIT PARAMETERS TO THE DIAGNOSTIC OUTPUT FILE.
  630 WRITE(DOUT,640) IDC(J)
  640 FORMAT(/,1X,'ELLIPSE PARAMETERS FOR CONTOUR ID',I5,/)
      WRITE(DOUT,650) A(J),B(J),ECC(J),OREN(J)
  650 FORMAT(1X,'SEMI-MAJOR AXIS LENGTH=',E12.4,/,
     &1X,'SEMI-MINOR AXIS LENGTH=',E12.4,/,
     &1X,'ELLIPSE ECCENTRICITY=',E12.4,/,
     &1X,'ORIENTATION OF SEMI-MINOR AXIS WITH RESPECT TO THE',
     &/,1X,'POSITIVE X-AXIS=',F6.2,1X,'DEGREES')
C***UPDATE THE CONTOUR COUNTER AND READ DATA FOR A NEW CONTOUR FROM THE
C***MASTER FILE.
      WRITE(*,660) IDC(J)
  660 FORMAT(/,1X,'Contour ID ',I4,1X,'has been accepted')
      J=J+1
      GO TO 320
  670 WRITE(DOUT,260)
C***END OF CONTOUR MASTER FILE REACHED
  700 NC=J-1
C***CLOSE THE MASTER FILE.
      CLOSE(IN,STATUS='KEEP')
C***IF THE CONTOUR ID NUMBERS(FOR CONTOUR SELECTION FROM THE MASTER
C***FILE) WERE INPUT FROM CONFILE, CHECK WHETHER THE NUMBER OF CONTOURS
C***REQUESTED MATCHES THE NUMBER ACTUALLY SELECTED FROM THE MASTER FILE.
C***IF NOT, WRITE A WARNING MESSAGE TO THE DIAGNOSTIC OUTPUT FILE.
      IF(ICMODE.EQ.3.AND.NC.NE.NCID) WRITE(DOUT,710)
  710 FORMAT(/,1X,'***WARNING***NUMBER OF CONTOURS SELECTED FROM THE',
     &' MASTER FILE DOES NOT',/,14X,'MATCH THE NUMBER REQUESTED')
C***CHECK WHETHER ANY CONTOURS HAVE BEEN SELECTED FROM THE MASTER FILE.
C***IF NOT, WRITE AN ERROR MESSAGE BOTH TO THE DIAGNOSTIC OUTPUT FILE
C***AND THE SCREEN AND THEN EXIT THE PROGRAM.
      IF(NC.EQ.0) GO TO 1010
C***
C***
C***WRITE THE OUTPUT FILES FOR SUBSEQUENT PROCESSING BY THE PLOT PROGRAM
C***AND THE CRITICAL HEIGHT ANALYSIS PROGRAM(HCRIT).
C***
C***
C***SORT THE ID NUMBERS FOR THE CONTOURS WHICH WERE FINALLY SELECTED.
      CALL ISORT(IDC,NC,LPTR)
C***CHECK WHETHER PLOT HAS BEEN REQUESTED. IF SO, WRITE TO THE PLOT
C***FILE THE INFORMATION NECESSARY TO SUBSEQUENTLY PLOT THE INPUT
C***DIGITIZED CONTOURS.
      IF(PFLAG.EQ.0) GO TO 770
C***REWIND THE SCRATCH FILE.
      REWIND UPSCR
C***WRITE THE NUMBER OF CONTOURS TO THE PLOT FILE.
      WRITE(UPL,720) NC
  720 FORMAT(I10)
C***WRITE THE SORTED CONTOUR ID NUMBERS TO THE PLOT FILE.
C***NOTE: THE CONTOUR IDs ARE SORTED ONLY FOR SUBSEQUENT ID CHECKS IN
C***THE PLOT PROGRAM. THE DIGITIZED CONTOURS INPUT TO THE PLOT PROGRAM
C***DO NOT HAVE TO BE SORTED.
      WRITE(UPL,730) (IDC(J),J=1,NC)
  730 FORMAT(I10)
C***WRITE THE PLOT BOUNDARY LIMITS FOR BOTH UNEDITED AND EDITED
C***CONTOURS TO THE PLOT FILE.
      WRITE(UPL,740) XMIN1,XMAX1,YMIN1,YMAX1
  740 FORMAT(4E15.4)
      WRITE(UPL,740) XMIN2,XMAX2,YMIN2,YMAX2
C***TRANSFER THE DIGITIZED CONTOUR COORDINATES FROM THE SCRATCH FILE
C***TO THE PLOT FILE.
      NCT2=2*NC
      DO 760 J=1,NCT2
      READ(UPSCR,570) NPC,HCONT
      WRITE(UPL,570) NPC,HCONT
      DO 750 K=1,NPC
      READ(UPSCR,571) XCON(K),YCON(K)
      WRITE(UPL,571) XCON(K),YCON(K)
  750 CONTINUE
  760 CONTINUE
C***CLOSE AND DELETE THE SCRATCH FILE.
      CLOSE(UPSCR,STATUS='DELETE')
C***OPEN THE OUTPUT FILE FOR THE CRITICAL HEIGHT ANALYSIS PROGRAM.
  770 CONTINUE
C 775 WRITE(*,780)
C 780 FORMAT(/,1X,'ENTER FILE NAME FOR FITTED CONTOUR OUTPUT -> '\)
      READ(20,'(A)') COUTFILE
C     IF(COUTFILE.EQ.' ') GO TO 775
      OPEN(COUT,FILE=COUTFILE,STATUS='NEW')
C***WRITE THE HILL ID NUMBER AND NAME TO THE FITTED CONTOUR OUTPUT
C***FILE.
      WRITE(COUT,312) IDHILL,HNAME
C***WRITE THE ACTUAL HILL TOP ELEVATION TO THE FITTED CONTOUR OUTPUT
C***FILE.
      WRITE(COUT,790) HTOP
  790 FORMAT(E15.4)
C***WRITE THE NUMBER OF CONTOURS TO THE FITTED CONTOUR OUTPUT FILE.
      WRITE(COUT,720) NC
C***WRITE THE SORTED CONTOUR IDs TO THE FITTED CONTOUR OUTPUT FILE.
C***NOTE: CONTOUR IDs ARE SORTED ONLY FOR SUBSEQUENT ID CHECKS IN
C***THE PLOT PROGRAM. FITTED CONTOUR PARAMETERS DO NOT HAVE TO BE
C***SORTED FOR INPUT TO THE CRITICAL HEIGHT ANALYSIS PROGRAM.
      WRITE(COUT,730) (IDC(J),J=1,NC)
C***WRITE THE CONTOUR FIT PARAMETERS TO THE FITTED CONTOUR OUTPUT
C***FILE.
      DO 810 J=1,NC
      WRITE(COUT,800) HCON(J),XCM(J),YCM(J),A(J),B(J),ECC(J),OREN(J)
  800 FORMAT(7E15.4)
  810 CONTINUE
      IF(PFLAG.EQ.0) GO TO 840
C***WRITE THE CONTOUR FIT PARAMETERS TO THE PLOT FILE.
      DO 830 J=1,NC
      WRITE(UPL,820) XCM(J),YCM(J),A(J),B(J),OREN(J)
  820 FORMAT(5E15.4)
  830 CONTINUE
  840 CONTINUE
C***ANALYSIS COMPLETED--EXIT PROGRAM.
      GO TO 2000
 1000 WRITE(DOUT,1005)
 1005 FORMAT(/,1X,'***ERROR***  NO CONTOURS WERE REQUESTED--EXIT PROGRAM
     &')
      WRITE(*,1005)
      GO TO 2000
 1010 WRITE(DOUT,1015)
 1015 FORMAT(/,1X,'***ERROR***  NO CONTOURS SELECTED FROM MASTER FILE--E
     &XIT PROGRAM')
      WRITE(*,1015)
C***DELETE SCRATCH FILE AND PLOT FILE.
      CLOSE(UPSCR,STATUS='DELETE')
      CLOSE(UPL,STATUS='DELETE')
 2000 CONTINUE
      STOP
      END
