      PROGRAM HCRIT
C***PROGRAM TO FIT ELLIPTICAL CONTOURS TO AN INVERSE POLYNOMIAL HILL
C***SHAPE FOR A RANGE OF USER SPECIFIED CRITICAL CUTOFF ELEVATIONS.
C***THE PROGRAM PROVIDES CRITICAL ELEVATION HILL PARAMETERS FOR
C***INPUT TO THE COMPLEX TERRAIN DISPERSION MODEL(CTDM).
C***
C***
C   GLOSSARY OF TERMS
C***
C***
C   A(J)=SEMI-MAJOR AXIS LENGTH FOR CONTOUR J(USER COORDINATES)
C   AI=INTERPOLATED VALUE OF A(J) TO A GIVEN CRITICAL ELEVATION
C   AS(J)=TEMPORARY A(J) STORAGE ARRAY USED IN SORTING
C   ANS=CHARACTER*1 VARIABLE HOLDING THE ANSWER TO A YES(Y) OR NO(N)
C       QUESTION
C   B(J)=SEMI-MINOR AXIS LENGTH FOR CONTOUR J(USER COORDINATES)
C   BI=INTERPOLATED VALUE OF B(J) TO A GIVEN CRITICAL ELEVATION
C   BS(J)=TEMPORARY B(J) STORAGE ARRAY USED IN SORTING
C   ECC(J)=ECCENTRICITY OF CONTOUR J
C   ECCS(J)=TEMPORARY ECC(J) STORAGE ARRAY USED IN SORTING
C   FCONFILE=CHARACTER*15 VARIABLE CONTAINING THE INPUT FILE NAME FOR
C            THE FITTED CONTOUR PARAMETERS GENERATED BY PROGRAM FITCON
C   FEXT=EXTRAPOLATION FACTOR USED TO ASSIGN THE SEMI-MAJOR AND
C        SEMI-MINOR AXIS LENGTHS FOR THE CASE OF ONE CONTOUR AND
C        A CRITICAL ELEVATION BELOW THAT SINGLE CONTOUR
C   FRACT=FRACTIONAL DIFFERENCE OF THE CRITICAL ELEVATION BETWEEN
C         ADJACENT CONTOUR ELEVATIONS
C   HC(I)=ARRAY OF CRITICAL ELEVATIONS
C   HCLOW=THE LOWEST CRITICAL ELEVATION(INPUT FOR CRITICAL ELEVATION
C         SELECTION MODE 2)
C   HCON(J)=ELEVATION OF CONTOUR J(USER COORDINATES)
C   HCONM1=HCON(NC)-1.
C   HCONS(J)=TEMPORARY HCON(J) STORAGE ARRAY USED IN SORTING
C   HHILL=HEIGHT OF THE HILL TOP ABOVE A GIVEN CRITICAL ELEVATION
C   HNAME=CHARACTER*15 VARIABLE GIVING THE HILL NAME
C   HTOP=HILL TOP ELEVATION(USER COORDINATES)
C   ICHMOD=CRITICAL ELEVATION INPUT MODE FOR THE HILL IN QUESTION
C         =1(CRITICAL ELEVATIONS WILL BE AT CONTOUR ELEVATIONS WITH
C            THE EXCEPTION OF THE UPPERMOST CONTOUR)
C         =2(CRITICAL ELEVATIONS EVENLY SPACED BETWEEN A USER SUPPLIED
C            LOWER ELEVATION AND THE ELEVATION OF THE UPPERMOST CONTOUR)
C   IDC(J)=ID NUMBER FOR CONTOUR J
C   IDHILL=HILL ID NUMBER(1-999)
C   IN=UNIT NUMBER FOR THE FITTED HILL INPUT FILE FROM PROGRAM FITCON
C   LA=LENGTH PARAMETER FOR AN INVERSE POLYNOMIAL FIT ALONG THE HILL
C      MAJOR AXIS(USER COORDINATES)
C   LB=LENGTH PARAMETER FOR AN INVERSE POLYNOMIAL FIT ALONG THE HILL
C      MINOR AXIS(USER COORDINATES)
C   LPTR=WORKING ARRAY USED IN THE POINTER SORT(PSORTR)
C   MOUT=UNIT NUMBER FOR THE FILE(MOUTFILE) CONTAINING TERRAIN
C        PARAMETERS WHICH ARE PASSED TO CTDM
C   MOUTFILE=CHARACTER*15 VARIABLE CONTAINING THE OUTPUT FILE NAME FOR
C            THE PARAMETERS TO BE PASSED TO CTDM
C   NC=NUMBER OF FITTED CONTOURS INPUT FROM FCONFILE
C   NCHMAX=MAXIMUM NUMBER OF CRITICAL ELEVATIONS WHICH CAN BE ANALYZED
C   NCON=NUMBER OF CONTOURS USED IN FITTING A HILL FOR A GIVEN CRITICAL
C        ELEVATION
C   NCR=NUMBER OF CRITICAL ELEVATIONS USED
C   NPTR=ARRAY CONTAINING THE SORTED POINTERS RETURNED FROM SUBROUTINE
C        PSORTR
C   ONOR=MAJOR AXIS ORIENTATION IN DEGREES CLOCKWISE FROM NORTH(FOR A
C        CONTOUR OR A FITTED HILL)(BETWEEN 0 AND 180 DEGREES)
C   OREN(J)=ORIENTATION ANGLE OF THE CONTOUR J SEMI-MINOR AXIS WITH
C           RESPECT TO THE POSITIVE X-AXIS
C   ORENF=ORIENTATON OF THE MINOR AXIS OF A FITTED HILL AS MEASURED
C         COUNTER CLOCKWISE FROM THE POSITIVE X-AXIS(EAST)
C   ORENI=INTERPOLATED VALUE OF OREN(J) TO A GIVEN CRITICAL ELEVATION
C   ORENS(J)=TEMPORARY OREN(J) STORAGE ARRAY USED IN SORTING
C   PA=EXPONENT FOR AN INVERSE POLYNOMIAL FIT ALONG THE HILL MAJOR AXIS
C   PB=EXPONENT FOR AN INVERSE POLYNOMIAL FIT ALONG THE HILL MINOR AXIS
C   PFILE=CHARACTER*15 VARIABLE GIVING THE NAME OF THE CRITICAL
C         ELEVATION PLOT FILE. THIS NAME MUST BE DIFFERENT THAN THE NAME
C         OF THE PLOT FILE GENERATED BY PROGRAM FITCON. BOTH PLOT FILES
C         ARE EVENTUALLY BE INPUT TO THE PLOT PROGRAM.
C   PFLAG=PLOT GENERATION INDICATOR
C        =0(NO PLOT GENERATED)
C        =1(PLOT GENERATED)
C   PSORTR=SUBROUTINE FOR SORTING POINTERS(CALLED TO SORT CONTOUR
C          FIT PARAMETERS BY CONTOUR ELEVATION(ASCENDING ORDER))
C   SUM1,SUM2A,SUM2B,SUM3,SUM4A,SUM4B=SUMMATION VARIABLES USED IN THE
C            CALCULATION OF BEST FIT INVERSE POLYNOMIAL HILL PROFILES
C   SUMX,SUMY=INTERMEDIATE VARIABLES USED IN THE DETERMINATION OF THE
C             ORIENTATIONS OF INTERPOLATED CONTOURS AND FITTED HILLS
C   UPL=UNIT NUMBER FOR THE CRITICAL ELEVATION PLOT FILE
C   XCM(J)=X-COORDINATE OF THE CONTOUR J CENTROID(USER COORDINATES)
C   XCMI=INTERPOLATED VALUE OF XCM(J) TO A GIVEN CRITICAL ELEVATION
C   XCMS(J)=TEMPORARY XCM(J) STORAGE ARRAY USED IN SORTING
C   XHTOPF=AVERAGE OF THE X-COORDINATES OF CONTOUR CENTROIDS ABOVE
C          A GIVEN CRITICAL ELEVATION
C   YCM(J)=Y-COORDINATE OF THE CONTOUR J CENTROID(USER COORDINATES)
C   YCMI=INTERPOLATED VALUE OF YCM(J) TO A GIVEN CRITICAL ELEVATION
C   YCMS(J)=TEMPORARY YCM(J) STORAGE ARRAY USED IN SORTING
C   YHTOPF=AVERAGE OF THE Y-COORDINATES OF CONTOUR CENTROIDS ABOVE
C          A GIVEN CRITICAL ELEVATION
C***
C***
      DIMENSION A(200),AS(200),B(200),BS(200),ECC(200),ECCS(200),
     &HCON(200),HCONS(200),IDC(200),OREN(200),ORENS(200),XCM(200),
     &XCMS(200),YCM(200),YCMS(200),LPTR(200),NPTR(200),HC(200)
      REAL*4 LA,LB
      INTEGER UPL
      CHARACTER*1 ANS
      CHARACTER*15 FCONFILE,MOUTFILE,PFILE,HNAME
C***
C***
C   INITIALIZATION OF VARIABLES
C***
C***
C***SPECIFY FILE UNIT NUMBERS.
      IOPT=13
      IN=14
      MOUT=15
      UPL=16
C***SPECIFY CONSTANTS.
      PI=3.14159265
      NCHMAX=200
C***
C***
C   INPUT FILE NAMES.
C
C*** CODE MODIFIED 7/11/88 BY CSC TO READ INFORMATION FROM AN OPTIONS FILE
C*** NAMED HOPTIONS.
C***
      OPEN(IOPT,fILE='HOPTIONS',STATUS='OLD')
C***
C***ENTER THE NAME OF THE INPUT FILE CONTAINING THE CONTOUR FIT
C***PARAMETERS GENERATED BY PROGRAM FITCON.
C   5 WRITE(*,10)
C  10 FORMAT(/,1X,'ENTER INPUT FILE NAME(FROM FITCON) -> '\)
      READ(13,'(A)') FCONFILE
C     IF(FCONFILE.EQ.' ') GO TO 5
C***OPEN THE INPUT FILE.
      OPEN(IN,FILE=FCONFILE,STATUS='OLD')
C***ENTER THE NAME OF THE OUTPUT FILE WHICH WILL BE PASSED DIRECTLY
C***TO CTDM.
C  15 WRITE(*,20)
C  20 FORMAT(/,1X,'ENTER OUTPUT FILE NAME(FOR CTDM) ->'\)
      READ(13,'(A)') MOUTFILE
C     IF(MOUTFILE.EQ.' ') GO TO 15
C***OPEN THE OUTPUT FILE.
      OPEN(MOUT,FILE=MOUTFILE,STATUS='NEW')
C***
C***
C   DETERMINE WHETHER A PLOT IS TO BE GENERATED.
C***
C***
C***FIRST, INITIALIZE THE PLOT FLAG INDICATOR TO CORRESPOND TO A
C***"NO" ANSWER.
      PFLAG=0
C     WRITE(*,30)
C  30 FORMAT(/,1X,'PLOT REQUESTED?(Y/N) -> '\)
      READ(13,'(A)') ANS
      IF(ANS.EQ.'Y'.OR.ANS.EQ.'y') PFLAG=1
      IF(PFLAG.EQ.0) GO TO 50
C***INPUT THE NAME OF THE PLOT FILE.
C  35 WRITE(*,40)
C  40 FORMAT(/,1X,'ENTER PLOT FILE NAME -> '\)
      READ(13,'(A)') PFILE
C     IF(PFILE.EQ.' ') GO TO 35
C***OPEN THE PLOT FILE.
      OPEN(UPL,FILE=PFILE,STATUS='NEW')
C***WRITE "HCRIT" TO THE FIRST RECORD OF THIS PLOT FILE TO INDICATE
C***THAT THIS PLOT FILE IS GENERATED BY PROGRAM HCRIT.
      WRITE(UPL,45)
   45 FORMAT('HCRIT')
   50 CONTINUE
C***
C***
C   READ DATA FROM THE FITTED CONTOUR FILE.
C***
C***
C***INPUT THE HILL ID NUMBER AND NAME.
      READ(IN,60) IDHILL,HNAME
   60 FORMAT(I2,1X,A15)
C***INPUT THE HILL TOP ELEVATION.
      READ(IN,70) HTOP
   70 FORMAT(E15.4)
C***INPUT THE NUMBER OF FITTED CONTOURS.
      READ(IN,80) NC
   80 FORMAT(I10)
C***INPUT THE SORTED CONTOUR IDs. THESE IDs ARE WRITTEN TO THE
C***PLOT FILE AND COMPARED WITH THE SORTED IDs WRITTEN TO THE
C***PLOT FILE WRITTEN BY FITCON. THIS CHECK PREVENTS THE COMPARISON
C***OF AN ACTUAL AND A FITTED CONTOUR WHICH IN FACT REPRESENT DIFFERENT
C***CONTOURS.
      READ(IN,80) (IDC(J),J=1,NC)
      IF(PFLAG.EQ.0) GO TO 85
C***WRITE TO THE PLOT FILE THE HILL ID NUMBER, HILL NAME, NUMBER
C***OF FITTED CONTOURS, THE SORTED CONTOUR IDs, AND THE HILL TOP
C***ELEVATION.
      WRITE(UPL,60) IDHILL,HNAME
      WRITE(UPL,80) NC
      WRITE(UPL,80) (IDC(J),J=1,NC)
      WRITE(UPL,70) HTOP
   85 CONTINUE
C***INPUT THE CONTOUR FIT PARAMETERS FOR THE HILL IN QUESTION.
      DO 100 J=1,NC
      READ(IN,90) HCON(J),XCM(J),YCM(J),A(J),B(J),ECC(J),OREN(J)
   90 FORMAT(7E15.4)
  100 CONTINUE
C***CLOSE THE FITTED CONTOUR INPUT FILE.
      CLOSE(IN,STATUS='KEEP')
C***
C***
C   SORT THE CONTOUR PARAMETERS BY CONTOUR ELEVATION(IN ASCENDING ORDER)
C   BY USE OF A POINTER SORT.
C***
C***
      CALL PSORTR(HCON,NC,NPTR,LPTR)
C***REORDER THE CONTOUR FIT PARAMETERS BASED UPON THE RESULTS OF THE
C***POINTER SORT.
      DO 110 J=1,NC
      HCONS(J)=HCON(NPTR(J))
      AS(J)=A(NPTR(J))
      BS(J)=B(NPTR(J))
      ECCS(J)=ECC(NPTR(J))
      ORENS(J)=OREN(NPTR(J))
      XCMS(J)=XCM(NPTR(J))
      YCMS(J)=YCM(NPTR(J))
  110 CONTINUE
      DO 120 J=1,NC
      HCON(J)=HCONS(J)
      A(J)=AS(J)
      B(J)=BS(J)
      ECC(J)=ECCS(J)
      OREN(J)=ORENS(J)
      XCM(J)=XCMS(J)
      YCM(J)=YCMS(J)
  120 CONTINUE
      IF(PFLAG.EQ.0) GO TO 123
C***WRITE THE SORTED CONTOUR ELEVATIONS TO THE PLOT FILE.
      DO 122 J=1,NC
      WRITE(UPL,121) HCON(J)
  121 FORMAT(E15.4)
  122 CONTINUE
  123 CONTINUE
C***
C***
C   DETERMINE CRITICAL ELEVATIONS TO BE USED FOR FITTING CUTOFF
C   HILLS.
C***
C***
C***TWO MODES ARE AVAILABLE FOR THE INPUT OF CRITICAL ELEVATIONS.
C***THE USER MAY SPECIFY THAT EACH CONTOUR LEVEL(WITH THE EXCEPTION
C***OF THE UPPERMOST CONTOUR) IS TO BE SPECIFIED AS A CRITICAL
C***ELEVATION, OR THE USER MAY ASK FOR UP TO A MAXIMUM OF NHCMAX
C***CRITICAL ELEVATIONS EVENLY SPACED BETWEEN A USER SPECIFIED LOWER
C***ELEVATION AND THE UPPER MOST CONTOUR OF THE HILL.
C 125 WRITE(*,130)
C 130 FORMAT(//,22X,'SPECIFY CRITICAL HEIGHT SELECTION MODE',/,
C    &22X,'1.) AT ALL CONTOUR ELEVATIONS EXCEPT UPPERMOST',/,
C    &22X,'2.) EVENLY SPACED BETWEEN A USER SUPPLIED ELEVATION',/,
C    &26X,'AND THE UPPERMOST CONTOUR ELEVATION',/,
C    &26X,'CHOICE?(1 OR 2) -> '\)
      READ(13,'(BN,I1)') ICHMOD
      IF(ICHMOD.EQ.1) GO TO 150
      IF(ICHMOD.EQ.2) GO TO 170
C     WRITE(*,140)
C 140 FORMAT(/,1X,'***ERROR***  SELECTION MODE OUT OF RANGE--TRY AGAIN')
C     GO TO 125
C***CRITICAL ELEVATION SELECTION MODE 1
C***THE NUMBER OF CRITICAL ELEVATIONS WILL BE ONE LESS THAN THE NUMBER
C***OF CONTOURS.
  150 NCR=NC-1
      IF(NCR.GT.0) GO TO 155
      WRITE(*,151)
  151 FORMAT(/,1X,'SINCE THERE IS ONLY ONE CONTOUR, THE CONTOUR SELECTIO
     &N MODE 1 CANNOT BE USED.',/,1X,'MODE 2 WILL BE USED INSTEAD.')
C***RESET THE CRITICAL ELEVATION SELECTION MODE.
      ICHMOD=2
      GO TO 170
  155 DO 160 I=1,NCR
      HC(I)=HCON(I)
  160 CONTINUE
      GO TO 250
C***CRITICAL ELEVATION SELECTION MODE 2
C***READ IN NUMBER OF CRITICAL ELEVATIONS.
C 170 WRITE(*,180)
C 180 FORMAT(/,1X,'INPUT THE NUMBER OF CRITICAL ELEVATIONS(1-200) -> '\)
  170 READ(13,181) NCR
  181 FORMAT(I3)
C     IF(NCR.LE.NCHMAX.AND.NCR.NE.0) GO TO 200
C     WRITE(*,190)
C 190 FORMAT(/,1X,'***ERROR***  NUMBER OF CRITICAL ELEVATIONS OUT OF RAN
C    &E--TRY AGAIN')
C     GO TO 170
C***INPUT THE LOWEST CRITICAL ELEVATION.
C 200 WRITE(*,210)
C 210 FORMAT(/,1X,'INPUT THE LOWEST CRITICAL ELEVATION -> '\)
  215 READ(13,216) HCLOW
  216 FORMAT(F10.0)
C***CHECK WHETHER THE LOWEST CRITICAL ELEVATION IS OVER 1 ELEVATION UNIT
C***ABOVE THE HIGHEST CONTOUR ELEVATION. IF SO, ASK THE USER TO INPUT
C***ANOTHER VALUE FOR THE LOWEST CRITICAL ELEVATON.
      HCONM1=HCON(NC)-1.
      IF(HCLOW.LT.HCONM1) GO TO 230
      WRITE(*,220) HCONM1
  220 FORMAT(/,1X,'LOWEST CRITICAL ELEVATION MUST BE LESS THAN',E15.4
     &,/)
      STOP
C***ASSIGN THE CRITICAL ELEVATIONS.
C***HCLOW WILL BE THE FIRST ELEVATION. THERE WILL BE NCR-1 ADDITIONAL
C***CRITICAL ELEVATIONS ABOVE HCLOW HAVING A SPACING EQUAL TO DELC,
C***WHERE DELC=(HCON(NC)-HLOW)/NCR. THE HIGHEST CRITICAL ELEVATION
C***WILL BE A DISTANCE OF DELC BELOW THE UPPERMOST CONTOUR LEVEL.
  230 DELC=(HCON(NC)-HCLOW)/FLOAT(NCR)
      DO 240 I=1,NCR
      HC(I)=HCLOW+(I-1)*DELC
  240 CONTINUE
  250 CONTINUE
      IF(PFLAG.EQ.0) GO TO 251
C***WRITE THE NUMBER OF CRITICAL ELEVATIONS TO THE PLOT FILE.
      WRITE(UPL,80) NCR
  251 CONTINUE
C***ASSIGNMENT OF CRITICAL ELEVATIONS COMPLETED.
C***
C***
C   WRITE THE HILL ID, THE NUMBER OF CRITICAL ELEVATIONS, THE HILL
C   TOP ELEVATION, AND THE HILL NAME TO THE CTDM INPUT FILE.
C***
C***
      WRITE(MOUT,260) IDHILL,NCR,HTOP,HNAME
  260 FORMAT(5X,I2,1X,I2,10X,E10.4,10X,A15)
C***
C***
C   FOR EACH CRITICAL ELEVATION, DETERMINE THE PARAMETERS WHICH BEST
C   DESCRIBE THE ELLIPTICAL TERRAIN CONTOUR AT THAT ELEVATION. THESE
C   PARAMETERS ARE WRITTEN TO THE CTDM INPUT FILE FOR USE IN THE "WRAP"
C   PLUME CALCULATION IN CTDM. IF THE CRITICAL ELEVATION DOES NOT CO-
C   INCIDE WITH AN INPUT CONTOUR(I.E. ICHMOD=2), THEN THE PARAMETERS
C   MUST BE DETERMINED BY A SIMPLE INTERPOLATION OF FITTED CONTOUR
C   PARAMETERS BASED ON ELEVATION. THE INTERPOLATION OF THE OREN-
C   TATION VALUES IS A VECTOR INTERPOLATION WITH THE VECTORS WEIGHTED
C   WITH THE ECCENTRICITY OF THE CONTOUR.
C***
C***
      IF(ICHMOD.EQ.2) GO TO 290
C***CASE 1--CRITICAL ELEVATIONS COINCIDE WITH CONTOUR ELEVATIONS.
      DO 280 J=1,NCR
C***FIND THE ORIENTATION OF THE MAJOR AXIS MEASURED CLOCKWISE FROM
C***NORTH(BETWEEN 0 AND 180 DEGREES).
      ONOR=180.-OREN(J)
      IF(ONOR.LT.0.) ONOR=360.+ONOR
      IF(ONOR.GT.180.) ONOR=ONOR-180.
      WRITE(MOUT,270) HC(J),XCM(J),YCM(J),ONOR,A(J),B(J)
  270 FORMAT(F10.3,2E10.4,3F10.3)
  280 CONTINUE
      GO TO 360
C***CASE 2--CRITICAL ELEVATIONS EVENLY SPACED BETWEEN HCLOW AND THE
C***UPPERMOST CONTOUR
  290 DO 350 I=1,NCR
      DO 300 J=1,NC
      JK=J
      IF(HCON(J).GT.HC(I)) GO TO 310
  300 CONTINUE
  310 IF(JK.GT.1) GO TO 320
C***IF THE CRITICAL ELEVATION IS BELOW THE LOWEST CONTOUR, THEN
C***EXTRAPOLATE THE VALUES FOR THE CONTOUR ORIENTATION, CENTROID
C***COORDINATES, AND SEMI-MAJOR AND SEMI-MINOR AXIS LENGTHS USING THE
C***VALUES OF THESE PARAMETERS FOR THE LOWEST TWO CONTOURS. IF THERE
C***IS ONLY ONE CONTOUR, THEN THE VALUES FOR THE ORIENTATION AND
C***CENTROID COORDINATES OF THE CRITICAL ELEVATION CONTOUR ARE SET
C***EQUAL TO THE CORRESPONDING VALUES FOR THE SINGLE CONTOUR. THE
C***SEMI-MAJOR AND SEMI-MINOR AXIS LENGTHS FOR THE CRITICAL ELEVATION
C***CONTOUR ARE EXTRAPOLATED BY ASSUMING A ZERO AREA CONTOUR AT THE
C***HILL TOP ELEVATION.
      IF(NC.EQ.1) GO TO 315
      JK=2
      GO TO 320
  315 XCMI=XCM(1)
      YCMI=YCM(1)
      ORENI=OREN(1)
      FEXT=(HTOP-HC(I))/(HTOP-HCON(1))
      AI=A(1)*FEXT
      BI=B(1)*FEXT
      GO TO 340
C***INTERPOLATE TO FIND CONTOUR PARAMETERS AT THE Ith CRITICAL
C***ELEVATION.
  320 FRACT=(HC(I)-HCON(JK-1))/(HCON(JK)-HCON(JK-1))
      XCMI=XCM(JK-1)+FRACT*(XCM(JK)-XCM(JK-1))
      YCMI=YCM(JK-1)+FRACT*(YCM(JK)-YCM(JK-1))
      AI=A(JK-1)+FRACT*(A(JK)-A(JK-1))
      BI=B(JK-1)+FRACT*(B(JK)-B(JK-1))
C***DO NOT ALLOW AI AND BI TO DECREASE WITH ELEVATION.
      IF(AI.LT.A(JK-1)) AI=A(JK-1)
      IF(BI.LT.B(JK-1)) BI=B(JK-1)
C***INTERPOLATE THE ORIENTATION VECTORIALLY WITH THE ELLIPSE
C***ECCENTRICITY USED AS A WEIGHTING FACTOR.
      SUMX=ECC(JK-1)*COS(PI*OREN(JK-1)/180.)+FRACT*(ECC(JK)*
     &COS(PI*OREN(JK)/180.)-ECC(JK-1)*COS(PI*OREN(JK-1)/180.))
      SUMY=ECC(JK-1)*SIN(PI*OREN(JK-1)/180.)+FRACT*(ECC(JK)*
     &SIN(PI*OREN(JK)/180.)-ECC(JK-1)*SIN(PI*OREN(JK-1)/180.))
C***AVOID CALLING THE ATAN2 FUNCTION WITH BOTH ARGUMENTS BEING
C***EFFECTIVELY ZERO.
      IF(ABS(SUMX).LT.1.0E-8.AND.ABS(SUMY).LT.1.0E-8) GO TO 330
      ORENI=(180./PI)*ATAN2(SUMY,SUMX)
      GO TO 340
  330 ORENI=0.
C***IF THE EXTRAPOLATION PROCESS GIVES AN ELLIPSE WITH A MINOR AXIS
C***GREATER THAN A MAJOR AXIS, THEN ASSUME THAT THE AXES ARE EQUAL
C***AND THAT THE ELLIPSE HAS THE SAME AREA.
  340 IF(AI.GE.BI) GO TO 345
      AI=SQRT(AI*BI)
      BI=AI
  345 CONTINUE
C***FIND THE ORIENTATION OF THE INTERPOLATED CONTOUR MAJOR AXIS AS
C***MEASURED CLOCKWISE FROM NORTH(BETWEEN 0 AND 180 DEGREES).
      ONOR=180.-ORENI
      IF(ONOR.LT.0.) ONOR=360.+ONOR
      IF(ONOR.GT.180.) ONOR=ONOR-180.
      WRITE(MOUT,270) HC(I),XCMI,YCMI,ONOR,AI,BI
  350 CONTINUE
  360 CONTINUE
C***THE WRITING OF BEST FIT CONTOUR ELLIPSE PARAMETERS FOR CUTOFF
C***ELEVATIONS TO THE CTDM INPUT FILE HAS BEEN COMPLETED.
C***
C***
C   DETERMINE THE FITTED HILL PARAMETERS FOR EACH CRITICAL CUTOFF
C   ELEVATION AND WRITE THESE PARAMETERS TO BOTH THE PLOT FILE AND
C   THE CTDM INPUT FILE.
C***
C***
      DO 500 I=1,NCR
C***ZERO OUT SUMMATION VARIABLES.
      SUM1=0.
      SUM2A=0.
      SUM2B=0.
      SUM3=0.
      SUM4A=0.
      SUM4B=0.
      SUMX=0.
      SUMY=0.
      XHTOPF=0.
      YHTOPF=0.
      NCON=0
C***CALCULATE THE HILL HEIGHT ABOVE THE CRITICAL HEIGHT.
      HHILL=HTOP-HC(I)
      DO 400 J=1,NC
C***CONTOUR ELEVATIONS USED IN FITTING THE PORTION OF THE HILL ABOVE
C***THE CRITICAL ELEVATION MUST BE AT LEAST ONE UNIT ABOVE THE CRITICAL
C***ELEVATION.
      IF(HCON(J).LE.HC(I)+1.) GO TO 400
      NCON=NCON+1
      FJ=ALOG(HHILL/(HCON(J)-HC(I))-1.)
      SUM1=SUM1+FJ
      SUM3=SUM3+FJ**2
      SUM2A=SUM2A+ALOG(A(J))
      SUM2B=SUM2B+ALOG(B(J))
      SUM4A=SUM4A+ALOG(A(J))*FJ
      SUM4B=SUM4B+ALOG(B(J))*FJ
      SUMX=SUMX+ECC(J)*COS(PI*OREN(J)/180.)
      SUMY=SUMY+ECC(J)*SIN(PI*OREN(J)/180.)
      XHTOPF=XHTOPF+XCM(J)
      YHTOPF=YHTOPF+YCM(J)
  400 CONTINUE
      IF(NCON.EQ.1) GO TO 410
      LA=EXP((SUM2A*SUM3-SUM4A*SUM1)/(NCON*SUM3-SUM1**2))
      LB=EXP((SUM2B*SUM3-SUM4B*SUM1)/(NCON*SUM3-SUM1**2))
      PA=(NCON*SUM3-SUM1**2)/(NCON*SUM4A-SUM1*SUM2A)
      PB=(NCON*SUM3-SUM1**2)/(NCON*SUM4B-SUM1*SUM2B)
C***NEGATIVE EXPONENTS NOT ALLOWED
      PA=ABS(PA)
      PB=ABS(PB)
      GO TO 420
C***IF ONLY ONE CONTOUR IS USED IN THE HILL FIT, ONE MUST ASSUME
C***THAT THE EXPONENTS IN THE INVERSE POLYNOMIAL FIT ARE BOTH 2.
  410 CONTINUE
      PA=2.
      PB=2.
      LA=A(NC)/(HHILL/(HCON(NC)-HC(I))-1.)**(1./PA)
      LB=B(NC)/(HHILL/(HCON(NC)-HC(I))-1.)**(1./PB)
C***AVOID CALLING THE ATAN2 FUNCTION WITH BOTH ARGUMENTS BEING
C***EFFECTIVELY ZERO.
  420 IF(ABS(SUMX).LT.1.0E-8.AND.ABS(SUMY).LT.1.0E-8) GO TO 430
      ORENF=(180./PI)*ATAN2(SUMY,SUMX)
      GO TO 440
  430 ORENF=0.
C***FIND THE ORIENTATION OF THE MAJOR AXIS AS MEASURED CLOCKWISE FROM
C***NORTH(BETWEEN O AND 180 DEGREES).
  440 ONOR=180.-ORENF
      IF(ONOR.LT.0.) ONOR=360.+ONOR
      IF(ONOR.GT.180.) ONOR=ONOR-180.
      XHTOPF=XHTOPF/FLOAT(NCON)
      YHTOPF=YHTOPF/FLOAT(NCON)
      IF(PFLAG.EQ.0) GO TO 455
C***WRITE THE FITTED HILL PARAMETERS TO THE PLOT FILE.
      WRITE(UPL,450) HC(I),XHTOPF,YHTOPF,ORENF,PA,PB,LA,LB
  450 FORMAT(8E15.4)
  455 CONTINUE
C***WRITE THE FITTED HILL PARAMETERS TO THE CTDM INPUT FILE.
      WRITE(MOUT,460) HC(I),XHTOPF,YHTOPF,ONOR,PA,PB,LA,LB
  460 FORMAT(F10.3,2E10.4,5F10.3)
  500 CONTINUE
      STOP
      END
