      SUBROUTINE MULTC(XCON,YCON,NPC,NPCMAX,MCFLAG)
C***THIS SUBROUTINE DETERMINES WHETHER A CONTOUR IS REALLY A SERIES
C***OF MULTIPLE CONTOURS. IF THIS IS FOUND TO BE THE CASE, THEN THE
C***CONTOUR POINT NUMBERING SCHEME IS MODIFIED TO SHOW A SERIES OF
C***CONTOURS CONNECTED TO THE FIRST CONTOUR IN THE SERIES BY INFINITELY
C***THIN STRIPS FOR THE PURPOSE OF CALCULATING THE AREA, CONTROID
C***COORDINATES, AND SECOND MOMENTS OF THE COMPONENT CONTOURS TAKEN
C***AS A GROUP.
C***
C***
C   GLOSSARY OF TERMS
C***
C***
C   IS0=SIGN(+ OR -) OF THE AREA OF THE FIRST COMPONENT CONTOUR
C   ISN=SIGN(+ OR -) OF THE AREA OF THE Nth COMPONENT CONTOUR(NOT
C       INCLUDING THE FIRST COMPONENT CONTOUR)
C   K=COUNTER FOR THE INPUT SET OF CONTOUR POINTS
C   KCOUNT=COUNTER FOR THE FINAL SET OF CONTOUR POINTS
C   KFIN(N)=ENDING VALUE OF KCOUNT FOR THE Nth COMPONENT CONTOUR
C           (NOT COUNTING THE FIRST COMPONENT CONTOUR)
C   KSTART(N)=STARTING VALUE OF KCOUNT FOR THE Nth COMPONENT CONTOUR
C             (NOT COUNTING THE FIRST COMPONENT CONTOUR)
C   MCFLAG=SUBROUTINE COMPLETION CODE
C         =0(MAXIMUM NUMBER OF POINTS EXCEEDED IN THE CONTOUR POINT
C            REASSIGNMENT PROCESS--CONTOUR REJECTED)
C         =1(THE LAST IN A SERIES OF MULTIPLE CONTOURS WAS FOUND
C            NOT TO BE CLOSED--CONTOUR REJECTED)
C	  =2(CONTOUR WAS FOUND TO BE A SINGLE CONTOUR(I.E. NO CONTOUR   MTC002
C            CLOSURE WAS FOUND BEFORE THE FINAL CONTOUR POINT))
C         =3(POINT REASSIGNMENT FOR THE MULTIPLE CONTOUR WAS
C            SUCCESSFULLY COMPLETED)
C         =4(ALL COMPONENT CONTOURS NOT INPUT WITH POINTS IN THE SAME
C            ORDER. THE ORDER OF POINT INPUT FOR THE COMPONENT CONTOURS
C            HAS BEEN MADE THE SAME AS THE FIRST COMPONENT CONTOUR.
C            FOLLOWING THIS ACTION, THE POINT REASSIGNMENT FOR THE
C            MULTIPLE CONTOUR WAS SUCCESSFULLY COMPLETED.)
C   NCON=NUMBER OF COMPONENT CONTOURS NOT INCLUDING THE FIRST
C        (INCREMENTED DURING THE COURSE OF THE ANALYSIS)
C   NN=POINT COUNTER(1 TO (KFIN(N)-KSTART(N))+1) WITHIN COMPONENT
C      CONTOUR N
C   XCON=ARRAY CONTAINING X COORDINATES OF THE INITIAL AND FINAL SET
C        OF CONTOUR POINTS
C   YCON=ARRAY CONTAINING Y COORDINATES OF THE INITIAL AND FINAL SET
C        OF CONTOUR POINTS
C   XCONS,YCONS=WORKING ARRAYS FOR CONTOUR POINT REASSIGNMENT
C***
C***
      DIMENSION XCON(1000),YCON(1000),XCONS(1000),YCONS(1000)
      DIMENSION KSTART(500),KFIN(500)
      NCON=1
      XCONS(1)=XCON(1)
      YCONS(1)=YCON(1)
      DO 100 K=2,NPC
      KSAVE=K
      XCONS(K)=XCON(K)
      YCONS(K)=YCON(K)
C***DETERMINE WHETHER THE CONTOUR CLOSES BEFORE THE LAST CONTOUR POINT
C***HAS BEEN REACHED. IF SO, ASSUME THE CONTOUR IS COMPOSED OF MULTIPLE
C***CONTOURS AT THE SAME ELEVATION. CONTINUE WITH THE ANALYSIS. IF NOT,
C***THEN RETURN TO THE MAIN PROGRAM WITH A COMPLETION CODE OF 2.
      IF(ABS(XCON(K)-XCON(1)).LT.1.0E-15.AND.ABS(YCON(K)-YCON(1)).LT.
     &1.0E-15.AND.K.NE.NPC) GO TO 110
  100 CONTINUE
      MCFLAG=2
      GO TO 400
  110 CONTINUE
C***DETERMINE THE AREA OF THE FIRST COMPONENT CONTOUR AND ITS SIGN FOR
C***LATER USE.
      CALL ARCM(XCON,YCON,AREA,XCM,YCM,KSAVE)
      IS0=1
      IF(AREA.LT.0.) IS0=-1
      KSP1=KSAVE+1
      KSTART(1)=KSP1
C***STORE THE COORDINATES OF THE FIRST POINT OF THE SECOND COMPONENT
C***CONTOUR IN THE TEMPORARY STORAGE ARRAYS.
      XCONS(KSP1)=XCON(KSP1)
      YCONS(KSP1)=YCON(KSP1)
      KSP2=KSAVE+2
C***IF ONLY ONE ADDITIONAL POINT HAS BEEN SPECIFIED AFTER THE FIRST
C***CONTOUR CLOSURE, THEN RETURN TO THE MAIN PROGRAM WITH A COMPLETION
C***CODE OF 1.
      IF(KSP2.LE.NPC) GO TO 150
      MCFLAG=1
      GO TO 400
  150 CONTINUE
C***SPECIFY THE BEGINNING POINT OF THE SECOND COMPONENT CONTOUR AS
C***(XCOMP,YCOMP).
      XCOMP=XCON(KSP1)
      YCOMP=YCON(KSP1)
      KCOUNT=KSP2
      K=KCOUNT
C***UP TO THIS POINT THE NUMBER OF THE INPUT AND MODIFIED CONTOUR POINTS
C***IS STILL THE SAME. NOW ENTER THE LOOP WHICH CARRIES OUT THE POINT
C***REASSIGNMENT PROCESS.
  200 CONTINUE
      XCONS(KCOUNT)=XCON(K)
      YCONS(KCOUNT)=YCON(K)
C***HAS THE NEXT CLOSURE BEEN REACHED? IF SO, RETURN TO THE POINT
C***OF FIRST CLOSURE(XCON(1),YCON(1)) BEFORE CONTINUING.
      IF(ABS(XCON(K)-XCOMP).GT.1.0E-15.OR.ABS(YCON(K)-YCOMP).GT.1.0E-15)
     &GO TO 210
C***SPECIFY THE END POINT FOR COMPONENT CONTOUR NCON.
      KFIN(NCON)=KCOUNT
C***INCREMENT COUNTER FOR THE SET OF MODIFIED CONTOUR POINTS.
      KCOUNT=KCOUNT+1
C***CHECK WHETHER THE MAXIMUM NUMBER OF CONTOUR POINTS HAS BEEN EXCEEDED
      IF(KCOUNT.LE.NPCMAX) GO TO 205
      MCFLAG=0
      GO TO 400
  205 CONTINUE
C***RETURN TO CLOSURE POINT FOR FIRST COMPONENT CONTOUR.
      XCONS(KCOUNT)=XCON(1)
      YCONS(KCOUNT)=YCON(1)
C***INCREMENT COUNTER FOR THE ORIGINAL SET OF POINTS.
      K=K+1
C***DETERMINE WHETHER THE NUMBER OF INPUT CONTOUR POINTS HAS BEEN
C***EXHAUSTED.
      IF(K.GT.NPC) GO TO 300
      KCOUNT=KCOUNT+1
C***CHECK WHETHER THE MAXIMUM NUMBER OF CONTOUR POINTS HAS BEEN EXCEEDED
      IF(KCOUNT.LE.NPCMAX) GO TO 206
      MCFLAG=0
      GO TO 400
  206 CONTINUE
C***INCREMENT THE NUMBER OF COMPONENT CONTOURS(EXCLUDING THE FIRST) BY 1
      NCON=NCON+1
C***SPECIFY THE STARTING POINT FOR COMPONENT CONTOUR N.
      KSTART(NCON)=KCOUNT
      XCONS(KCOUNT)=XCON(K)
      YCONS(KCOUNT)=YCON(K)
C***SPECIFY THE BEGINNING POINT OF THE NEW COMPONENT CONTOUR AS
C***(XCOMP,YCOMP) FOR USE IN THE DETERMINATION OF COMPONENT CONTOUR
C***CLOSURE.
      XCOMP=XCON(K)
      YCOMP=YCON(K)
C***INCREMENT THE COUNTER FOR THE INPUT SET OF CONTOUR POINTS.
  210 K=K+1
C***DETERMINE WHETHER THE NUMBER OF INPUT CONTOUR POINTS HAS BEEN
C***EXHAUSTED.
      IF(K.LE.NPC) GO TO 250
      MCFLAG=1
      GO TO 400
  250 CONTINUE
C***INCREMENT THE COUNTER FOR THE MODIFIED SET OF CONTOUR POINTS.
      KCOUNT=KCOUNT+1
C***CHECK WHETHER THE NUMBER OF CONTOUR POINTS HAS BEEN EXCEEDED.
      IF(KCOUNT.LE.NPCMAX) GO TO 200
      MCFLAG=0
      GO TO 400
  300 CONTINUE
      NPC=KCOUNT
C***TRANSFER THE POINT COORDINATES FROM THE TEMPORARY HOLDING ARRAYS
C***TO THE INITIAL POINT COORDINATE ARRAYS.
      DO 350 K=1,KCOUNT
      XCON(K)=XCONS(K)
      YCON(K)=YCONS(K)
  350 CONTINUE
      MCFLAG=3
C***DETERMINE WHETHER ALL COMPONENT CONTOURS HAVE THEIR POINTS INPUT
C***IN THE SAME SENSE(CLOCKWISE OR COUNTER-CLOCKWISE). IF NOT, MODIFY
C***THE INPUT SEQUENCES TO REFLECT THE SEQUENCE USED FOR THE FIRST
C***COMPONENT CONTOUR.
      DO 390 N=1,NCON
      NN=0
      DO 370 K=KSTART(N),KFIN(N),1
      NN=NN+1
      XCONS(NN)=XCON(K)
      YCONS(NN)=YCON(K)
  370 CONTINUE
C***FIND THE AREA OF THE COMPONENT CONTOUR AND ITS SIGN. IF THE SIGN
C***OF THE AREA IS DIFFERENT FROM THE SIGN OF THE AREA OF THE INITIAL
C***COMPONENT CONTOUR, THEN REVERSE THE INPUT ORDER OF THE COMPONENT
C***CONTOUR POINTS.
      CALL ARCM(XCONS,YCONS,AREA,XCM,YCM,NN)
      ISN=1
      IF(AREA.LT.0.) ISN=-1
      IF(ISN.EQ.IS0) GO TO 390
      MCFLAG=4
      DO 380 K=KSTART(N),KFIN(N),1
      XCON(K)=XCONS(NN)
      YCON(K)=YCONS(NN)
      NN=NN-1
  380 CONTINUE
  390 CONTINUE
  400 CONTINUE
      RETURN
      END
