C-----------------------------------------------------------------------GOO00010
C INTEGER FUNCTION GOOD(IQUAL)                                          GOO00020
C                                                                       GOO00030
C PURPOSE: CHECKS QUALITY INDICATOR TO DETERMINE WHETHER OR NOT TO      GOO00040
C           ACCEPT THE UPPER AIR OBSERVATION AS VALID                   GOO00050
C                                                                       GOO00060
C ASSUMPTIONS: TDF6201 FORMAT                                           GOO00070
C                                                                       GOO00080
C LIMITATIONS: NMC INDICATORS A-Z ARE NOT TESTED FOR BAD DATA           GOO00090
C                                                                       GOO00100
C ARGUMENTS                                                             GOO00110
C  PASSED:                                                              GOO00120
C       IQUAL   CHAR    QUALITY INDICATOR: 0-9 OR A-Z                   GOO00130
C                                                                       GOO00140
C  RETURNED:                                                            GOO00150
C       FUNCTION GOOD: 0 IF BAD DATA; 1 IF GOOD DATA                    GOO00160
C                                                                       GOO00170
C  MEANING OF QUALITY INDICATORS FOR TDF6201 DATA:                      GOO00180
C                                                                       GOO00190
C      0       ORIGINAL VALUES ARE CORRECT                              GOO00200
C      1       ORIGINAL VALUES ARE MISSING                              GOO00210
C      2       ORIGINAL VALUES ARE DOUBTFUL, A CORRECTED LEVEL FOLLOWS  GOO00220
C      3       ORIGINAL VALUES ARE DOUBTFUL, UNCORRECTED                GOO00230
C      4       ORIGINAL VALUES ARE IN ERROR, A CORRECTED LEVEL FOLLOWS  GOO00240
C      5       ORIGINAL VALUES ARE IN ERROR, UNCORRECTED                GOO00250
C      6       CORRRECTED LEVEL                                         GOO00260
C      9       LEVEL NOT CHECKED                                        GOO00270
C     A-Z      SUPPLIED BY NMC, HAVE CHANGED MANY TIMES OVER THE YEARS  GOO00280
C                                                                       GOO00290
C       GOOD RETURNS 0 IF CODE IS 1, 2, 3, 4, OR 5; 1 OTHERWISE         GOO00300
C                                                                       GOO00310
C                                                                       GOO00320
C CALLING ROUTINES: READ62                                              GOO00330
C                                                                       GOO00340
C-----------------------------------------------------------------------GOO00350
C                                                                       GOO00360
        INTEGER FUNCTION GOOD(IQUAL)                                    GOO00370
        CHARACTER*1 IQUAL                                               GOO00380
C                                                                       GOO00390
        GOOD = 1                                                        GOO00400
        IF(IQUAL.EQ.'1' .OR. IQUAL.EQ.'2' .OR. IQUAL.EQ.'3' .OR.        GOO00410
     1   IQUAL.EQ.'4' .OR. IQUAL.EQ.'5') GOOD = 0                       GOO00420
        RETURN                                                          GOO00430
        END                                                             GOO00440
