{$R-}    {Range checking on}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking on}
{$I+}    {I/O checking on}
{$N+}    {Uses 8087 coprocessor}
{$V-}    {String checking relaxed }

Program ChiDis;
{
    CHIDIS is a program to show,for a given hour, the locations of receptors
    on a map of unedited contours with the receptors being displayed in the
    order of decreasing concentration.  The user presses the space bar to
    display the receptor having the next lowest concentration. At this point,
    the user can press the key "C" and have the time, concentration rank,
    receptor number, and concentration for the current receptor displayed on
    the screen.  At any time the user may press the key "N" and have the
    concentrations for the next hour displayed.  Once the list of receptors
    has been exhausted, pressing the space bar will cause the display of
    concentrations for the hour to begin repeating.  At any time during the
    course of the display, the user can press the escape key to terminate
    execution of the program.


   Written for the USEPA/ASRL by:

       Donna Burns  - Computer Sciences Corporation.

   Last Mod:
      5/10/88 - 2109  First converted from the BASICA version. [NZK]
}

Uses
  Dos,
  Crt,
  Graph;

Const
  LineSize = 80;
  Bell     = ^G;

  MaxReceptors = 1000;

  CIns = 1;   CDel = 2;    CEnd = 3;   CDown = 4;  CPgDn = 5;
  CLeft = 6;  CRight = 7;  CHome = 8;  CUp = 9;    CPgUp = 10;

  F1 = 11;  F2 = 12;  F3 = 13;  F4 = 14;  F5 = 15;
  F6 = 16;  F7 = 17;  F8 = 18;  F9 = 19;  F10 = 20;  Esc = 21;


Type
  Name      = String[30];
  Str10     = String[10];
  Str12     = String[12];
  Str19     = String[19];
  Str30     = String[30];
  Str80     = String[80];
  Str160    = String[160];
  TheLine   = Array [1..LineSize] of Char;
  FileNames = Array[1..100] of Str12;

Var
  MarkPtr,
  IAR,IAR1,IAR2,
  SS,SS1,SS2,
  KeyMenuPtr   : Pointer;

  IARSize,
  KeyMenuSize  : Word;

  Getting,
  Looping,
  Trying,
  GotIARMem,
  GotKeyMenuMem,
  DoneInitGraph  : Boolean;

  PLTFile,
  CHIFile    : Text;

  PLTNames,
  CHINames  : FileNames;

  PLTBuf    : Array[1..1024] of Char;
  CHIBuf    : Array[1..1024] of Char;

  NRec      : Array[1..MaxReceptors] of Integer;
  XRec      : Array[1..MaxReceptors] of Real;
  YRec      : Array[1..MaxReceptors] of Real;
  Conc      : Array[1..MaxReceptors] of Real;

  ThePLTFile,
  TheCHIFile,
  CheckName, HillName   : Str12;

  Path,
  ZMask,
  MsgStr,
  PlotHillName,
  ConcHillName  : Str30;

  Delim,
  Ch          : Char;

  ModeIsText  : Boolean;      { TRUE if the current screen mode is TEXT }

  Code,FKey,
  I,J,K,
  IEnd,IYear,IMonth,IDay,IHour,
  IR,IRad,
  PLTFiles,
  CHIFiles,
  NR,PlotHillID,
  ConcHillID,
  MaxColor,
  DupFlg,
  IFR,NC,NC1,NPC,Ptr,
  GraphDriver,
  GraphMode,
  ErrorCode,
  MyIdx        : Integer;

  HCon,
  XHTop,
  YHTop,
  XMin1,YMin1,XMax1,YMax1,
  XMin2,YMin2,XMax2,YMax2,
  XMin, YMin, XMax, YMax,
  SCRCX, DSCRX,
  SCRCY, DSCRY, Ratio,
  XSHC, YSHC,
  XUL, YUL, XLR, YLR,
  XC, YC, DX, DY, DD,
  DSCRXDDD, DSCRYDDD,
  X, Y,
  X1, Y1,
  XP, YP,
  XS, YS,
  XS1, YS1,
  XOld, YOld        : Real;

  F,
  FileA,
  FileB,
  HeadLine,
  WrkStr,
  S,
  BlankLine,
  BigLine     : Str80;

  Found       : Integer;

  {$I Spaces.INC}
  {$I Print.INC }
  {$I Input.INC }
  {$I Common.INC}


PROCEDURE GetAPLTFile;
Var
  ZR, ZC, I  :Integer;
Begin
  MsgStr := 'FITCON plot file';
  GetAFile(PLTFiles,PLTNames,HillName,MsgStr,MyIdx,0);
  If (FKey = Esc) or (FKey = F10) then EXIT;
  Assign(PLTFile,'\CTDM\TERRAIN\'+PLTNames[MyIdx+1]);

  SetTextBuf(PLTFile,PLTBuf);
  Reset(PLTFile);
  Readln(PLTFile,WrkStr);
  If WrkStr <> 'FITCON' then begin
    ErrorMsg(' That file was not created by program FITCON.  Press RETURN to try again. ');
    Close(PLTFile);
  end
  else begin
    ThePLTFile := PLTNames[MyIdx+1];         { PLT File selected from dir }
    Read(PLTFile,PlotHillID);
    Readln(PLTFile,PlotHillName);
    Readln(PLTFile,BigLine);
    Ptr := 1;
    Delim := ' ';
    ParseToFloat(XHTop);
    ParseToFloat(YHTop);
    Readln(PLTFile,NC);
    For I := 1 to NC do
      Readln(PLTFile,BigLine);
  end;
End;    { GetAPLTFile }


PROCEDURE GetACHIFile;                          { Produced by program CHIRET }
Var
  ZR, ZC, I : Integer;
  PlotName,
  ConcName  : Str12;
Begin
  MsgStr := 'CHIRET output file';
  GetAFile(CHIFiles,CHINames,HillName,MsgStr,MyIdx,0);
  If (FKey = Esc) or (FKey = F10) then EXIT;
  Assign(CHIFile,'\CTDM\FILES\'+CHINames[MyIdx+1]);
  SetTextBuf(CHIFile,CHIBuf);
  Reset(CHIFile);
  Read(CHIFile,ConcHillID);
  ReadLn(CHIFile,NR);
  If ConcHillID <> PlotHillID then begin
    ErrorMsg(' The Hill IDs of the files do not match.  Press RETURN to try again. ');
    Close(CHIFile);
  end
  else begin
    If NR > MaxReceptors then begin
      ErrorMsg(' The Conc File receptor count is > Max allowed.  Press RETURN to try again. ');
      Close(CHIFile);
    end
    else begin
      TheCHIFile := CHINames[I+1];
      WrkStr := ' ';
    end;
  end;
End;    { GetACHIFile }


PROCEDURE LoadEodAndTable;
Begin
  Readln(CHIFile,BigLine);           { Load EOD flag and date from .CHI file }
  Ptr := 1;
  ParseToInt(IEnd);
  ParseToInt(IYear);
  ParseToInt(IMonth);
  ParseToInt(IDay);
  ParseToInt(IHour);

  If IEnd <> 1 then begin
    For IR := 1 to NR do begin      { Load all concentrations }
      Readln(CHIFile,BigLine);                 { Load Receptor Nbr, X, Y, Conc }
      Ptr := 1;
      ParseToInt(NRec[IR]);
      ParseToFloat(XRec[IR]);
      ParseToFloat(YRec[IR]);
      ParseToFloat(Conc[IR]);
     end;
   end;
End;    { LoadEodAndTable }


PROCEDURE DisplayReceptor(I : Integer);
Begin
  X := XRec[I];  Y := YRec[I];
  XP := SCRCX + (X - XC) * DSCRXDDD;
  YP := SCRCY - (Y - YC) * DSCRYDDD;
  SetColor(GetMaxColor);
  Circle(Trunc(XP),Trunc(YP),IRad);

  If GraphDriver = HercMono then
    For I := Trunc(XP)-1 to Trunc(XP)+1 do
      For J := Trunc(YP)-1 to Trunc(YP)+1 do
        PutPixel(I,J,0)
   else PutPixel(Trunc(XP),Trunc(YP),0);

  FloodFill(Trunc(XP),Trunc(YP),GetMaxColor);
End;    { DisplayReceptor }


PROCEDURE DisplayTitle;
Var
  Middle, TitleWidth : Integer;
Begin
  LTrim(PlotHillName);
  Trim(PlotHillName);
  TitleWidth := TextWidth(PlotHillName);
  SetTextJustify(CenterText,TopText);
  Middle := GetMaxX div 2;
  OutTextXY(Middle,1,PlotHillName);
  MoveTo(Middle - TitleWidth div 2 - 4,1);
  LineTo(GetX,9);
  LineTo(GetX + TitleWidth + 8,GetY);
  LineTo(GetX,1);
End;    { DisplayTitle }


PROCEDURE DisplayKeyMenu;
Var
  Vert, Delta,
  Row, Right : Integer;
  KeyMenu : Array[1..5] of Str19;
Begin
  KeyMenu[1] := 'Spc - Next Receptor';
  KeyMenu[2] := ' C  - Current Conc ';
  KeyMenu[3] := ' N  - Next Hour    ';
  KeyMenu[4] := 'F10 - Exit to Dos  ';
  KeyMenu[5] := 'Esc - Back         ';

  SetTextJustify(LeftText,TopText);

  If GraphDriver in [EGA,EGAMono,EGA64,VGA] then begin
    Vert := 50;  Delta := 10;
    SetTextStyle(SmallFont,HorizDir,5);
   end
   else begin
    Vert := 38;  Delta := 8;
    SetTextStyle(SmallFont,HorizDir,4);
   end;

  Right := TextWidth(KeyMenu[1])+6;

  If not GotKeyMenuMem then begin
                   {   Save the current Corner on the stack  }
    KeyMenuSize := ImageSize(0,0,Right,Vert+7);
    GetMem(KeyMenuPtr,KeyMenuSize);
    If (KeyMenuPtr = nil) then ABORT(KeyMenuSize)
     else
      GotKeyMenuMem := True;
   end;

  GetImage(0,0,Right+1,Vert+7,KeyMenuPtr^);

  SetViewPort(0,0,Right+1,Vert+7,ClipOff);
  ClearViewPort;
  SetLineStyle(SolidLn,0,ThickWidth);
  Rectangle(0,0,Right,Vert+6);
  For Row := 1 to 5 do
    OutTextXY(4,(Row-1)*Delta+1,KeyMenu[Row]);
  FKey := Input(0,0,1,0,WrkStr,False);
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipON);
  PutImage(0,0,KeyMenuPtr^,NormalPut);
  SetLineStyle(SolidLn,0,NormWidth);
End;    { DisplayKeyMenu }


Begin
  HeapError := @HeapFunc;

  Delim    := ' ';
  F        := ' CHIDIS ';
  HillName := '';
  Path     := '\CTDM\TERRAIN\';

  HeadLine := '';

  For I := 1 to LineSize do
    BlankLine[I] := ' ';

  If ParamCount > 0 then
    HillName := ParamStr(1)
   else
    HillName := '';

  If RegisterBGIdriver(@HercDriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@CGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@EVGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIFont(@LittFont) < 0 then Writeln(GraphErrorMsg(GraphResult));

  GraphDriver := Detect;

  DoneInitGraph := False;
  GotIARMem     := False;
  GotKeyMenuMem := False;

  Looping := True;

  While Looping do begin
    If DoneInitGraph then begin
      CloseGraph;
      DoneInitGraph := False;
     end;

    ModeIsText  := True;

    FKey := 0;
    Getting := True;
    While Getting do begin
      LoadNames('\CTDM\TERRAIN\','*.PLT',PLTFiles,PLTNames);

      ThePLTFile := '';
      While ThePLTFile = '' do begin
        MenuHeading(False);
        WrkStr := '';
        GetAPLTFile;
        If FKey = F10 then ExittoDos;
        If FKey = Esc then begin
          Color(LightGray,Black);
          ClrScr;
          Exit;
        end;
      end;

      If ThePLTFile <> '' then begin
        LoadNames('\CTDM\FILES\','*.CHI',CHIFiles,CHINames);
        MenuHeading(False);
        TheCHIFile := '';
        GetACHIFile;
        If TheCHIFile <> '' then
          Getting := False;
       end;
     end;

                { Now we have matched PLOT and CONC files }

    Readln(PLTFile,BigLine);          { Load X and Y boundaries from PLOT file }
    Ptr := 1;
    ParseToFloat(XMin1);
    ParseToFloat(XMax1);
    ParseToFloat(YMin1);
    ParseToFloat(YMax1);

    Readln(PLTFile,BigLine);          { Load but skip edited boundaries }
  {
    Ptr := 1;
    Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,XMinD,Code);
    Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,XMaxD,Code);
    Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,YMinD,Code);
    Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,YMaxD,Code);
  }

    Readln(CHIFile,BigLine);          { Load X and Y boundaries from CONC file }
    Ptr := 1;
    ParseToFloat(XMin2);
    ParseToFloat(XMax2);
    ParseToFloat(YMin2);
    ParseToFloat(YMax2);

    XMin := Min(XMin1,XMin2);  { Using both sets of boundaries, determine }
    YMin := Min(YMin1,YMin2);  { the min and max boundary coordinates.    }
    XMax := Max(XMax1,XMax2);
    YMax := Max(YMax1,YMax2);

  {
    Now determine the type of display we are using.  If CGA, ask the user
    if we are to use Low Res (in color) or Hi-Res (B&W).
  }

    DetectGraph(GraphDriver,GraphMode);

    If GraphDriver = CGA then begin
      DisplayResMenu;
      WrkStr := '';
      While (WrkStr <> '1') and (WrkStr <> '2') and
            (FKey <> Esc)   and (FKey <> F10) do
        FKey := Input(23,16,1,0,WrkStr,True);
      If FKey = F10 then ExittoDos;
      If FKey = Esc then
        EXIT;
      If WrkStr = '1' then GraphMode := 0
       else GraphMode := 4;
     end;

  {
    Set up the plot boundaries, scale factors and colors based
    on GraphDriver and GraphMode.
  }
    DetermineBoundaries;

    XC := (XMin + XMax) / 2;
    YC := (YMin + YMax) / 2;
    DX := XMax - XMin;
    DY := YMax - YMin;
    If (DX / DY) < Ratio then DD := DY
     else DD := DX / Ratio;
    DSCRXDDD := DSCRX / DD;
    DSCRYDDD := DSCRY / DD;

    InitGraph(GraphDriver,GraphMode,'');

    MaxColor   := GetMaxColor;
    ModeIsText := False;                          { Needed for INPUT }
    If GraphDriver = CGA then
      If GraphMode = CGAC0 then                   { Color Box }
        SetColor(3)
       else
        SetColor(1);
    If GraphDriver in [EGA,EGA64,VGA] then
      SetColor(White);

    Rectangle(0,0,GetMaxX,GetMaxY);             { Put a box around everything }

    DoneInitGraph := True;

    DisplayTitle;                                         { At the top center }
    SetLineStyle(DottedLn,0,NormWidth);    { Select dotted lines for contours }

    If GraphDriver = CGA then
      If GraphMode = CGAC0 then      { Color Contours }
        SetColor(3)
       else
        SetColor(GetMaxColor);
    If GraphDriver in [EGA,EGA64,VGA] then
      SetColor(Yellow);

    For J := 1 to NC do begin                         { Loop through contours }
      Readln(PLTFile,BigLine);           { Load contour points and elevation }
      Ptr := 1;
      ParseToInt(NPC);
      ParseToFloat(HCon);

      Readln(PLTFile,BigLine);            { Load initial contour coordinates }
      Ptr := 1;
      ParseToFloat(X1);
      ParseToFloat(Y1);

      XOld   := X1;
      YOld   := Y1;
      DupFlg := 0;
      XS1 := SCRCX + (X1 - XC) * DSCRXDDD;
      YS1 := SCRCY - (Y1 - YC) * DSCRYDDD;
      MoveTo(Trunc(XS1), Trunc(YS1));
      PutPixel(Trunc(XS1), Trunc(YS1), MaxColor);
      IFR := 0;
      For K := 2 to NPC do begin
        Readln(PLTFile,BigLine);                    { Load contour coordinates }
        Ptr := 1;
        ParseToFloat(X);
        ParseToFloat(Y);

        If (IFR < 2) or (Abs(X - X1) > 1.0E-15) or (Abs(Y - Y1) > 1.0E-15) then begin
          XS := SCRCX + (X - XC) * DSCRXDDD;
          YS := SCRCY - (Y - YC) * DSCRYDDD;
          If DupFlg <> 0 then begin
            XOld := X;
            YOld := Y;
            DupFlg := 0;
            MoveTo(Trunc(XS), Trunc(YS));
            PutPixel(Trunc(XS), Trunc(YS), MaxColor);
           end
           else begin
            If (Abs(X - XOld) < 1.0E-15) and (Abs(Y - YOld) < 1.0E-15) then begin
              DupFlg := 1;
              Inc(IFR);
             end;
             LineTo(Trunc(XS),Trunc(YS));
           end;
         end;
       end;
      Readln(PLTFile,BigLine);                    { Load contour coordinates }
      Ptr := 1;
      ParseToInt(NPC);
      For K := 1 to NPC do
        Readln(PLTFile,BigLine);                   { Bypass edited contours }
     end;


                {  All contours are written    }
    XSHC := SCRCX + (XHTOP - XC) * DSCRXDDD;
    YSHC := SCRCY - (YHTOP - YC) * DSCRYDDD;

    XUL := XSHC - 1;  XLR := XSHC + 1;
    YUL := YSHC - 1;  YLR := YSHC + 1;

    If (GraphDriver in [HercMono,EGA,EGA64,EGAMono,VGA]) or
       ((GraphDriver = CGA) and (GraphMode = 4)) then  { Slightly larger }
      XUL := XUL - 1;

    If GraphDriver in [EGA,EGAMono,EGA64,VGA] then
      YUL := YUL - 1;
  {   Put a little box at the hill center  }

    Rectangle(Trunc(XUL), Trunc(YUL), Trunc(XLR), Trunc(YLR));
               {   Save the current screen on the stack  }

    If Not GotIARMem then begin                     { Only get memory ONCE }
      If GraphDriver in [EGA,EGAMono,EGA64] then begin
        IARSize := ImageSize(0,0,GetMaxX,199);
        GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
        GetMem(SS,IARSize);   If SS = Nil then ABORT(IARsize);
        IARSize := ImageSize(0,200,GetMaxX,349);
        GetMem(IAR1,IARSize); If IAR = Nil then ABORT(IARSize);
        GetMem(SS1,IARSize);  If SS = Nil then ABORT(IARSize);
       end
       else If (GraphDriver=VGA) then begin
        IARSize := ImageSize(0,0,GetMaxX,159);
        GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
        GetMem(SS,IARSize);   If SS = Nil then ABORT(IARSize);
        IARSize := ImageSize(0,160,GetMaxX,319);
        GetMem(IAR1,IARSize); If IAR1 = Nil then ABORT(IARSize);
        GetMem(SS1,IARSize);  If SS1 = Nil then ABORT(IARSize);
        IARSize := ImageSize(0,320,GetMaxX,479);
        GetMem(IAR2,IARSize); If IAR2 = Nil then ABORT(IARSize);
        GetMem(SS2,IARSize);  If SS2 = Nil then ABORT(IARSize);
       end
       else begin
        IARSize := ImageSize(0,0,GetMaxX,GetMaxY);
        GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
        GetMem(SS,IARSize);   If SS = Nil then ABORT(IARSize);
       end;
      GotIARMem := True;
     end;

    If GraphDriver = VGA then begin
      GetImage(0,0,GetMaxX,159,IAR^);
      GetImage(0,160,GetMaxX,319,IAR1^);
      GetImage(0,320,GetMaxX,479,IAR2^);
     end
     else If GraphDriver in [EGA,EGAMono,EGA64] then begin
      GetImage(0,0,GetMaxX,199,IAR^);
      GetImage(0,200,GetMaxX,349,IAR1^);
     end
     else begin
      GetImage(0,0,GetMaxX,GetMaxY,IAR^);
     end;

    LoadEodAndTable;                     { Get the first CONC data }
    DisplayReceptor(1);                  { Display the highest receptor }

    IR := 1;
    Getting := True;
    While Getting do begin
      WrkStr := '';

      Trying := True;
      While Trying do begin
        FKey := 0;
        FKey := Input(0,0,1,0,WrkStr,False);
        If FKey = F10 then ExittoDos;
        If WrkStr <> '' then
          WrkStr[1] := UpCase(WrkStr[1]);
        If (WrkStr <> '') and (WrkStr[1] in [' ','C','N']) then
          Trying := False
         else If FKey = Esc then
          Trying := False
         else DisplayKeyMenu;
      end;

      If FKey = Esc then begin
        RestoreCrtMode;
        ModeIsText := True;
        Getting := False;
        Looping := False;
        Close(PLTFile);
        Close(CHIFile);
       end
       else begin
        If WrkStr = ' ' then begin
          Inc(IR);
          If IR > NR then begin
            PutImage(0,0,IAR^,NormalPut);
            If GraphDriver = VGA then begin
              PutImage(0,160,IAR1^,NormalPut);
              PutImage(0,320,IAR2^,NormalPut);
             end
             else If GraphDriver in [EGA,EGA64,EGAMono] then
              PutImage(0,200,IAR1^,NormalPut);
            IR := 1;
           end;
          DisplayReceptor(IR);
         end
         else If WrkStr = 'C' then begin          { Show concentration values }
          If GraphDriver = VGA then begin
            GetImage(0,0,GetMaxX,159,SS^);
            GetImage(0,160,GetMaxX,319,SS1^);
            GetImage(0,320,GetMaxX,479,SS2^);
           end
           else If GraphDriver in [EGA,EGA64,EGAMono] then begin
            GetImage(0,0,GetMaxX,199,SS^);
            GetImage(0,200,GetMaxX,349,SS1^);
           end
           else begin
            GetImage(0,0,GetMaxX,GetMaxY,SS^);
           end;

          SetTextJustify(LeftText,TopText);
          SetTextStyle(SmallFont,HorizDir,4);
          WrkStr := StrFun(IYear,2) + '/' + StrFun(IMonth,2) + '/' + StrFun(IDay,2);
          WrkStr := WrkStr + ':' + StrFun(IHour,2) + '  Rank' + StrFun(IR,3);
          WrkStr := WrkStr + '  RNum' + StrFun(NRec[IR],3) + '  C=';
          Str(Conc[IR]:6:4,S);
          WrkStr := WrkStr + S;
          SetViewPort(1,1,TextWidth(WrkStr)+8,16,ClipOff); { Build a view     }
          ClearViewPort;                                   { Clear the view   }
          SetViewPort(0,0,GetMaxX,GetMaxY,ClipON);         { Back to Normal   }
          SetLineStyle(SolidLn,0,ThickWidth);
          Rectangle(0,0,TextWidth(WrkStr)+7,15);           { Outline the view }
          SetLineStyle(SolidLn,0,NormWidth);
          MoveTo(4,3);                                     { Move to start    }
          OutText(WrkStr);                                 { Display the text }
          MoveTo(GetX+5,GetY+14);                          { Start the line   }
          PutPixel(4,3,MaxColor);
          LineTo(Trunc(XP),Trunc(YP));                     { Line to receptor }
          WrkStr := '';  FKey := 0;
          FKey := Input(0,0,1,0,WrkStr,False);             { Wait for user    }

          PutImage(0,0,SS^,NormalPut);                    { Restore Screen   }
          If GraphDriver = VGA then begin
            PutImage(0,160,SS1^,NormalPut);
            PutImage(0,320,SS2^,NormalPut);
           end
           else If GraphDriver in [EGA,EGA64,EGAMono] then
            PutImage(0,200,SS1^,NormalPut);
         end
         else If WrkStr = 'N' then begin
          LoadEodAndTable;                     { Get the next CONC data }
          If IEnd = 1 then begin
            RestoreCRTMode;
            ModeIsText := True;
            ClrScr;
            MenuHeading(False);
            WriteStr(22,10,'All hourly data has been displayed.');
            WriteStr(22,12,'Press ENTER to continue.  ');
            WrkStr := '';
            FKey := Input(WhereX,WhereY,1,0,WrkStr,True);
            Getting := False;
            Close(PLTFile);
            Close(CHIFile);
            Looping := False;
            RestoreCRTMode;
           end
           else begin
            PutImage(0,0,IAR^,NormalPut);                  { Restore Screen   }
            If GraphDriver = VGA then begin
              PutImage(0,160,IAR1^,NormalPut);
              PutImage(0,320,IAR2^,NormalPut);
             end
             else If GraphDriver in [EGA,EGA64,EGAMono] then
              PutImage(0,200,IAR1^,NormalPut);
            DisplayReceptor(1);                  { Display the highest receptor }
            IR := 1;
           end;
         end;
       end;
     end;
   end;
end.