PROCEDURE HercDriver; External;
{$L Herc.OBJ }

PROCEDURE CGADriver; External;
{$L CGA.OBJ }

PROCEDURE EVGADriver; External;
{$L EVGA.OBJ }

PROCEDURE LittFont; External;
{$L Litt.OBJ }


PROCEDURE Color(F,B : Integer);
Begin
  TextColor(F);
  TextBackGround(B);
End;


PROCEDURE DoEscOrF10;
Begin
  GoToXY(23,24);  Color(White,Cyan);  Write(' Esc ');
  Color(LightGray,Black); Write(' - Back     ');
  Color(White,Cyan); Write(' F10 ');
  Color(LightGray,Black); Write(' - Exit to Dos');
End;    { DoEscOrF10 }



PROCEDURE ExittoDos;
Begin
  If not ModeIsText then RestoreCrtMode;
  Color(LightGray,Black);
  Clrscr;
  Halt;
end;


PROCEDURE UpCaseStr(Var Str : Str80);
Var
  I : Integer;
Begin
  For I := 1 to Length(Str) do
    Str[I] := UpCase(Str[I]);
End;    { UpCaseStr }


{$F+} FUNCTION HeapFunc(size: word) :integer; {$F-}
begin
  HeapFunc :=1;
end;       {HeapFunc}


PROCEDURE WriteStr(X,Y : Integer;
                   Msg : Str80);
Begin
  GoToXY(X,Y);  Write(Msg);
end;


PROCEDURE ABORT(Needs : Word);
Begin
  RestoreCRTMode;
  Color(LightGray,Black);
  ClrScr;Sound(256);Delay(256);NoSound;
  WriteStr(17,12,'Sorry, there is not enough memory to run this program.');
  WriteStr(17,14,'Unload any memory resident programs, then try again.');
  WriteStr(17,16,'Please press ENTER to continue');
  Readln;
  Halt(1);
end;    { ABORT }


FUNCTION StrFun(I,Len : Integer) : Str10;
Var
  MyStr : Str10;
Begin
  Str(I:Len,MyStr);
  StrFun := MyStr;
End;    { StrFun }


FUNCTION Min(X,Y : Real) : Real;
Begin
  If X < Y then Min := X
   else Min := Y;
End;    { Min }


FUNCTION Max(X,Y : Real) : Real;
Begin
  If X > Y then Max := X
   else Max := Y;
End;    { Max }


PROCEDURE GGoToXY(X,Y : Integer);
Begin
  MoveTo(X*8,Y*8);
End;    { GGoToXY }


PROCEDURE LTrim(Var S : Str80);
Begin
  If S[0] > Chr(0) then begin
    While S[1] = ' ' do
      S := Copy(S,2,Length(S));
   end;
End;    {  LTrim  }


PROCEDURE Trim(Var S : Str80);
Begin
  While S[Length(S)] = ' ' do
    Dec(S[0]);
End;    {  Trim  }


PROCEDURE EraseMsg;
Begin
  Color(Black,Black);
  GoToXY(1,24);  ClrEol;
End;    { EraseMsg }


PROCEDURE ErrorMsg(S : Str80);
Begin
  EraseMsg;
  Color(LightRed,White);
  WriteStr((80-Length(S)) div 2,24,S);
  WrkStr := '';
  FKey := Input(WhereX,WhereY,1,0,WrkStr,True);
  If FKey = F10 then ExittoDos;
  Color(LightGray,Black);
  If FKey <> Esc then begin
    EraseMsg;
    DoEscOrF10;
    WrkStr := '';
   end;
End;    { ErrorMsg }


PROCEDURE MenuHeading(MenuON : Boolean);    { Display the menu heading line 1 }
Var
  X         : Integer;
  Year,
  Month,
  Day,
  DayOfWeek : Word;
  TwoBytes  : String[2];
  FourBytes : String[4];
  HeadLine  : Str80;
Begin
  HeadLine := '';
  If MenuOn then X := 32
   else X := 40;
  Color(LightGray,Black);
  ClrScr;

  GetDate(Year,Month,Day,DayOfWeek);
  Str(Month:2,TwoBytes);
  If TwoBytes[1] = ' ' then TwoBytes[1] := '0';
  WrkStr := TwoBytes;
  Str(Day:2,TwoBytes);
  If TwoBytes[1] = ' ' then TwoBytes[1] := '0';
  WrkStr := WrkStr + '/' + TwoBytes;
  Str(Year:4,FourBytes);
  WrkStr := WrkStr + '/' + FourBytes;
  WriteStr(1,1,Headline);
  WriteStr(3,1,' '+WrkStr+' ');
  Color(LightGreen,Black); WriteStr(X-Length(F) div 2,1,F);
  Color(LightGray,Black);
End;    { MenuHeading }


PROCEDURE MenuLine(X,Y : Integer;
                   Key,Title : Str80);
Begin
  GoToXY(X,Y);  Color(White,Cyan);  Write(Key);
  Color(White,Black);  Write(Title);
End;


PROCEDURE DisplayResMenu;
Begin
  MenuHeading(False);
  GoToXY(13,9);   Color(Yellow,Black);
  Write('Please press a number to select the type of display to use.');
  MenuLine(23,12,' 1 ',' - Low resolution with color');
  MenuLine(23,14,' 2 ',' - High resolution black & white');
  DoEscOrF10;
End;    { DisplayResMenu }


PROCEDURE Parse(Var Ptr   : Integer;
                    Delim : Char;
                Var InString : Str160; Var WrkStr : Str80);
Begin
  WrkStr := '';
  While (Ptr<=Length(InString)) and (InString[Ptr] = ' ') do
    Inc(Ptr);
  While (Ptr<=Length(InString)) and (InString[Ptr] <> Delim) do begin
    WrkStr := WrkStr+InString[Ptr];
    Inc(Ptr);
   end;
  {Inc(Ptr)};                         { Get to start of next field }
End;    { Parse }


PROCEDURE DrawBox(X1,Y1,X2,Y2,C : Integer);
Var
  Color : Word;
Begin
  Color := GetColor;
  SetColor(C);
  Rectangle(X1,Y1,X2,Y2);
  SetColor(Color);
End;    { DrawBox }


PROCEDURE LoadNames(PathName    :  Str30;
                    ExtName     :  Str30;
               Var  FileCount   :  Integer;
               Var  NameArray   :  FileNames);
Var
  DirInfo : SearchRec;
Begin
  FileCount := 0;
  For I := 1 to 100 do                                    { Clear names Table }
    NameArray [I] := '';
  FindFirst(Pathname+ExtName, AnyFile, DirInfo);
  While DosError = 0 do begin
    Inc(Filecount);
    NameArray[FileCount] := DirInfo.Name;
    FindNext(DirInfo);
   end;
End;    { LoadNames }


PROCEDURE GetAFile(FileCount     :  Integer;
               Var NameArray     :  FileNames;
                   StartingName  :  Str12;
                   MsgStr        :  Str30;
               Var ArrayIdx      :  Integer;
                   FootFlag      :  Integer);
Var
  ZR, ZC,
   I, Pt     :  Integer;
  CheckName  : Str12;
Begin
  ZR := 10;  ZC := 10;
  I := 0;
  Pt := 40 - ((43 + Length(MsgStr)) div 2);
  Color(Yellow, Black);
  WriteStr(Pt,8,'Please highlight a '+MsgStr+' file, then press ENTER:');
  If FootFlag = 0 then DoEscOrF10;
  If FootFlag = 1 then begin
    GoToXY(15,24);  Color(White,Cyan);  Write('F8');
    Color(LightGray,Black); Write(' - End Selection   ');
    Color(White,Cyan);  Write('Esc');
    Color(LightGray,Black); Write(' - Back   ');
    Color(White,Cyan); Write('F10');
    Color(LightGray,Black); Write(' - Exit to Dos');
   end;

  Color (LightGray,Black);
  While I <  FileCount do begin                 { First display all files }
    Inc(I);
    WriteStr(ZC,ZR,NameArray[I]);
    Inc(ZR);                                    { Bump the row and check for  }
    If ZR > 21 then begin                       { column wraparound           }
      ZR :=10;
      ZC := ZC + 14;
     end;
   end;

  ArrayIdx := 1;
  CheckName := '';
  While (StartingName <> CheckName) and (ArrayIdx < FileCount) do begin
    CheckName := '';
    J := 1;
    While NameArray[ArrayIdx,J] <> '.' do begin
      CheckName := CheckName + NameArray[ArrayIdx,J];
      Inc(J);
     end;
    If CheckName <> StartingName then Inc(ArrayIdx);
   end;

  If ArrayIdx > FileCount then ArrayIdx := 0
    else ArrayIdx := ArrayIdx - 1;

  WrkStr := '';
  While WrkStr = '' do begin
    ZR := (ArrayIdx Mod 12) + 10;                   { Move around the files }
    ZC := (ArrayIdx div 12) * 14 +10;
    GoToXY(ZC,ZR);
    Print(4,NameArray[ArrayIdx+1]);
    FKey :=0;
    WrkStr :='';
    FKey := Input(ZC-1,ZR,1,0,WrkStr,True);
    If FKey > 0 then begin
      Case FKey of
        CLeft  : If ArrayIdx >= 12 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := ArrayIdx - 12;
                  end;
        CRight : If (ArrayIdx+12) < FileCount then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := ArrayIdx + 12
                  end;
        CUp    : If ArrayIdx > 0 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   Dec(ArrayIdx);
                  end;
        CDown  : If ArrayIdx < FileCount-1 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   Inc(ArrayIdx);
                  end;
        CHome  : Begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := 0;
                  end;
        CEnd   : Begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := FileCount - 1;
                  end;
        F8     : If FootFlag = 1 then Exit;
        F10    : EXIT;
        Esc    : EXIT;
       end;
     end
     else WrkStr := NameArray[ArrayIdx+1];
   end;
End;    { GetAFile }


PROCEDURE DetermineBoundaries;
Begin
  Case GraphDriver of
    CGA      :  Begin
                  If GraphMode = 4 then begin
                    SCRCX := 320; DSCRX := 480;
                    SCRCY := 100; DSCRY := 186;
                    Ratio := 1.3574;
                   end
                   else begin
                    SCRCX := 160; DSCRX := 270;
                    SCRCY := 100; DSCRY := 186;
                    Ratio := 1.5437;
                   end;
                 end;
    HercMono :  Begin
                  SCRCX := 360; DSCRX := 490;
                  SCRCY := 182; DSCRY := 320;
                  Ratio := 1.4653;
                  IRad  := 4;
                 end;
    EGA,EGA64,
    EGAMono  :  Begin
                  SCRCX := 320; DSCRX := 480;
                  SCRCY := 175; DSCRY := 300;
                  Ratio := 1.46;
                  IRad  := 4;
                 end;
    VGA      :  Begin
                  SCRCX := 320; DSCRX := 480;
                  SCRCY := 240; DSCRY := 420;
                  Ratio := 1.474;
                  IRad  := 4;
                 end;
   end;
End;    { DetermineBoundaries }

PROCEDURE ParseToInt(Var TheInt : Integer);
Begin
  Parse(Ptr,Delim,BigLine,WrkStr);
  Val(WrkStr,TheInt,Code);
end;


PROCEDURE ParseToFloat(Var TheFloat : Real);
Begin
  Parse(Ptr,Delim,BigLine,WrkStr);
  Val(WrkStr,TheFloat,Code);
end;
