PROCEDURE Color(F,B : Integer);        { Set Foreground and Background colors }
Begin
  TextColor(F);
  TextBackGround(B);
End;    { Color }


PROCEDURE ExittoDos;                    { Abort the program and return to DOS }
Begin
  If not ModeIsText then RestoreCrtMode;
  Color(LightGray,Black);
  Clrscr;
  Halt;
End;    { ExittoDos }

PROCEDURE MyExec(Prg,CmdLine : Str30);
Begin
  AbEnd := False;
  SwapVectors;
  Exec(Prg,CmdLine);
  Result := DosExitCode;
  SwapVectors;
  If (Result > 0) or (DosError > 0) then begin
    AbEnd := True;
    If DosError = 8 then
      Msg := 'Not enough memory to run program'
    else
      Msg := 'WARNING! Program ended abnormally';
    Color(Yellow,Black);
    GoToXY(23,12); Writeln(Msg);
    GoToXY(23,14); Writeln('Press ENTER to continue.');
    Readln;
    Color(LightGray,Black);
    Exec(Comm,'/C CD \CTDM\EXE');
    Exit;
  end;
End;  { MyExec }


PROCEDURE UpCaseStr(Var Str : Str80);    { Convert entire string to uppercase }
Var
  I : Integer;
Begin
  For I := 1 to Length(Str) do Str[I] := UpCase(Str[I]);
End;    { UpCaseStr }


PROCEDURE Beep;
Begin
  Sound(Hz);
  Delay(Hz);
  NoSound;
End;    { Beep }


FUNCTION StrFun(I,Len : Integer) : Str10;       { Coerce STR to be a function }
Var
  MyStr : Str10;
Begin
  Str(I:Len,MyStr);
  StrFun := MyStr;
End;    { StrFun }


PROCEDURE LeftTrim(Var S : Str80);      { Remove Leading SPACES from a string }
Begin
  While S[1] = ' ' do begin
    S := Copy(S,2,Length(S));
    If Length(S) = 0 then Exit;
  end;
End;    {LeftTrim}


PROCEDURE Trim(Var S : Str80);         { Remove trailing SPACES from a string }
Begin
  While S[Length(S)] = ' ' do Dec(S[0]);
End;    { Trim }


FUNCTION Exist(FName: Name) : Boolean;                 { See if a file exists }
Var
  Fil   : File;
  Found : Boolean;
Begin
  {$I-}
  Assign(Fil,FName);
  Reset(Fil);
  Close(Fil);
  {$I+}
  Exist := (IOResult = 0);
End;    {Exist}


PROCEDURE EraseMsg;                               { Erase the message line 24 }
Begin
  Color(Black,Black);
  GoToXY(1,24);  ClrEol;
End;    { EraseMsg }


PROCEDURE WriteStr(X,Y : Integer;
                   Msg : Str80);
Begin
  GoToXY(X,Y);  Write(Msg);
End;


PROCEDURE MenuHeading(MenuON : Boolean);    { Display the menu heading line 1 }
Var
  X         : Integer;
  Year,
  Month,
  Day,
  DayOfWeek : Word;
  TwoBytes  : String[2];
  FourBytes : String[4];
  HeadLine  : Str80;
Begin
  HeadLine := '';
  If MenuOn then X := 32
   else X := 40;
  Color(LightGray,Black);
  ClrScr;

  GetDate(Year,Month,Day,DayOfWeek);
  Str(Month:2,TwoBytes);
  If TwoBytes[1] = ' ' then TwoBytes[1] := '0';
  WrkStr := TwoBytes;
  Str(Day:2,TwoBytes);
  If TwoBytes[1] = ' ' then TwoBytes[1] := '0';
  WrkStr := WrkStr + '/' + TwoBytes;
  Str(Year:4,FourBytes);
  WrkStr := WrkStr + '/' + FourBytes;
  WriteStr(1,1,Headline);
  WriteStr(3,1,' '+WrkStr+' ');
  Color(LightGreen,Black); WriteStr(X-Length(F) div 2,1,F);
  Color(LightGray,Black);
End;    { MenuHeading }


PROCEDURE MenuLine(X,Y : Integer;
                   Key,Title : Str80);
Begin
  GoToXY(X,Y);  Color(White,Cyan);  Write(Key);
  Color(White,Black);  Write(Title);
End;


PROCEDURE Parse(Var Ptr   : Integer;
                    Delim : Char;
                Var Instring,WrkStr : Str80);
Begin
  WrkStr := '';
  While (Ptr<=Length(InString)) and (Instring[Ptr] = ' ') do
    Inc(Ptr);
  While (Ptr<=Length(InString)) and (InString[Ptr] <> Delim) do begin
    Wrkstr := WrkStr + InString[Ptr];
    Inc(Ptr);
   end;
  Inc(Ptr);
end;  {Parse}

PROCEDURE LoadNames(PathName   :  Str30;
                    ExtName    :  Str30;
               Var  FileCount  :  Integer;
               Var  NameArray  :  FileNames);
Var
  DirInfo  :  SearchRec;
Begin
  FileCount := 0;
  For I := 1 to 100 do
    NameArray [I] := '';                     {Clear Names Table}
  FindFirst(PathName+ExtName, AnyFile, DirInfo);
  While DosError = 0 do begin
    Inc(FileCount);
    NameArray[FileCount]:= DirInfo.Name;
    FindNext(DirInfo);
   end;
End;    { LoadNames }


PROCEDURE DoEscOrF10;
Begin
  GoToXY(23,24); Color(White,Cyan); Write(' Esc ');
  Color(LightGray,Black); Write(' - Back     ');
  Color(White,Cyan); Write(' F10 ');
  Color(LightGray,Black); Write(' - Exit to Dos');
End;    { DoEscOrF10 }


PROCEDURE DoF9Line;
Begin
  GoToXY(6,24); Color(White,Cyan);  Write('F9');
  Color(LightGray,Black); Write(' - Run Program   ');
  Color(White,Cyan); Write(Chr(25));
  Color(LightGray,Black); Write(' DOWN    ');
  Color(White,Cyan); Write(Chr(24));
  Color(LightGray,Black); Write(' UP    ');
  Color(White,Cyan); Write('Esc');
  Color(LightGray,Black); Write(' - Back   ');
  Color(White,Cyan); Write('F10');
  Color(LightGray,Black); Write(' - Exit to Dos');
End;  {DoF9Line}


PROCEDURE GetAFile(FileCount     :  Integer;
               Var NameArray     :  FileNames;
                   StartingName  :  Str12;
                   MsgStr        :  Str30;
               Var ArrayIdx      :  Integer;
                   FootFlag      :  Integer);
Var
  ZR, ZC,
   I, Pt     :  Integer;
  CheckName  : Str12;
Begin
  ZR := 10;  ZC := 10;
  I := 0;
  Pt := 40 - ((43 + Length(MsgStr)) div 2);
  Color(Yellow, Black);
  WriteStr(Pt,8,'Please highlight a '+MsgStr+' file, then press ENTER:');
  If FootFlag = 0 then DoEscOrF10;
  If FootFlag = 1 then begin
    GoToXY(15,24);  Color(White,Cyan);  Write('F8');
    Color(LightGray,Black); Write(' - End Selection   ');
    Color(White,Cyan);  Write('Esc');
    Color(LightGray,Black); Write(' - Back   ');
    Color(White,Cyan); Write('F10');
    Color(LightGray,Black); Write(' - Exit to Dos');
   end;

  Color (LightGray,Black);
  While I <  FileCount do begin                 { First display all files }
    Inc(I);
    WriteStr(ZC,ZR,NameArray[I]);
    Inc(ZR);                                    { Bump the row and check for  }
    If ZR > 21 then begin                       { column wraparound           }
      ZR :=10;
      ZC := ZC + 14;
     end;
   end;

  ArrayIdx := 1;
  CheckName := '';
  While (StartingName <> CheckName) and (ArrayIdx < FileCount) do begin
    CheckName := '';
    J := 1;
    While NameArray[ArrayIdx,J] <> '.' do begin
      CheckName := CheckName + NameArray[ArrayIdx,J];
      Inc(J);
     end;
    If CheckName <> StartingName then Inc(ArrayIdx);
   end;

  If ArrayIdx > FileCount then ArrayIdx := 0
    else ArrayIdx := ArrayIdx - 1;

  WrkStr := '';
  While WrkStr = '' do begin
    ZR := (ArrayIdx Mod 12) + 10;                            { Move around the fiels }
    ZC := (ArrayIdx div 12) * 14 +10;
    GoToXY(ZC,ZR);
    Print(4,NameArray[ArrayIdx+1]);
    FKey :=0;
    WrkStr :='';
    FKey := Input(ZC-1,ZR,1,0,WrkStr,True);
    If FKey > 0 then begin
      Case FKey of
        CLeft  : If ArrayIdx >= 12 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := ArrayIdx - 12;
                  end;
        CRight : If (ArrayIdx+12) < FileCount then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := ArrayIdx + 12
                  end;
        CUp    : If ArrayIdx > 0 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   Dec(ArrayIdx);
                  end;
        CDown  : If ArrayIdx < FileCount-1 then begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   Inc(ArrayIdx);
                  end;
        CHome  : Begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := 0;
                  end;
        CEnd   : Begin
                   GoToXY(ZC,ZR);  Print(1,NameArray[ArrayIdx+1]);
                   ArrayIdx := FileCount - 1;
                  end;
        F8     : If FootFlag = 1 then Exit;
        F10    : EXIT;
        Esc    : EXIT;
       end;
     end
     else WrkStr := NameArray[ArrayIdx+1];
   end;
End;    { GetAFile }

PROCEDURE TypeFile(FileToType: String);    {create a batch file to use the type |more command}
Var
  TypeBatFile  : Text;
Begin
  Assign(TypeBatFile,'\CTDM\EXE\TYPEFILE.BAT');
  Rewrite(TypeBatFile);
  WrkStr := 'Type '+FileToType+'|MORE';
  Write(TypeBatfile,WrkStr);
  Close(TypeBatFile);
  ClrScr;
  Exec(Comm,'/C \CTDM\EXE\TYPEFILE.BAT');
End;   { TypeFile }
