{$I Switches.INC }

{$F+}    {Force Far Calls for overlays}
{$O+}    {Generate Overlay code}
{$M 16384,0,8000}

Program DRIVEIT;

Uses
  Overlay, DrInit, Dos, Crt, Graph, Drive2,
  Drive3, Drive4, Drive5, Drive6, MyDefs;

 {$O Dos}
 {$O Drive2}
 {$O Drive3}
 {$O Drive4}
 {$O Drive5}
 {$O Drive6}
 {$O MyDefs}

Const
  EscOrF10 = 'Esc - Back    F10 - Exit to Dos';
  LineSize = 80;
  Bell     = ^G;
  PressEnter = 'Press  ENTER  to continue.';
  One      = ' 1 ';
  Two      = ' 2 ';
  Three    = ' 3 ';
  Four     = ' 4 ';
  Five     = ' 5 ';

  CIns = 1;   CDel = 2;    CEnd = 3;   CDown = 4;  CPgDn = 5;
  CLeft = 6;  CRight = 7;  CHome = 8;  CUp = 9;    CPgUp = 10;

  F1 = 11;  F2 = 12;  F3 = 13;  F4 = 14;  F5 = 15;
  F6 = 16;  F7 = 17;  F8 = 18;  F9 = 19;  F10 = 20;
  Esc = 21;

  Hz  = 256;     { middle C }

Type
  Name     = String[30];
  Str10    = String[10];
  Str11    = String[11];
  Str12    = String[12];
  Str19    = String[19];
  Str30    = String[30];
  Str80    = String[80];
  TheLine  = Array [1..LineSize] of Char;
  FileNames = Array[1..100] of Str12;


Var

  Looping,Getting,
  Displaying,TerrLoop,
  ChiLoop,ChiLoop2,MetLoop,
  Collecting,ModeIsText,
  Checking,DummyVar,
  FirstTime,PlotIt,CLooping      : Boolean;

  Ext                   : String[4];

  DumName,HName         : String[16];

  ZMask,
  Path,MsgStr           : Str30;

  S,Ch,Delim           : Char;
  I,J,K,FKey           : Integer;

  F,
  WrkStr,
  BlankLine,
  BigLine,
  Msg                       : Str80;

  {$I Spaces.INC}
  {$I Print.INC}
  {$I Input.INC}
  {$I Drive1.INC}

Const
  PressToExecute = 'Press a number to execute the required program.';


PROCEDURE MainMenu;
Const
  X = 26;
Begin
  F := ' CTDMPLUS - MAIN MENU ';
  MenuHeading(False);
  Color(Yellow,Black);
  GoToXY(23,5); Write('Press a number to make a selection.');
  MenuLine(X,9, One,  ' - Terrain Preprocessor');
  MenuLine(X,11,Two,  ' - Meteorological Preprocessor');
  MenuLine(X,13,Three,' - CTDMPLUS');
  MenuLine(X,15,Four, ' - Concentration Postprocessors');
  MenuLine(X,17,Five, ' - CTSCREEN');
  DoEscOrF10;
  WrkStr := '';
  FKey := Input(X+1,19,1,0,WrkStr,True);
End;    { MainMenu }


PROCEDURE TerrMenu;
Const
  X = 34;
Begin
  TerrLoop := True;
  FKey := 0;
  Path :='\CTDM\EXE\';

  While TerrLoop do begin
    If FKey = 0 then begin
      F := ' TERRAIN PREPROCESSOR SELECTION MENU ';
      MenuHeading(False);
      Color(Yellow,Black);
      GoToXY(17,5); Write(PressToExecute);
      MenuLine(X,9, One,  ' - FITCON');
      MenuLine(X,11,Two,  ' - HCRIT');
      MenuLine(X,13,Three,' - PLOTCON');
      MenuLine(X,15,Four, ' - RECGEN');
      DoEscOrF10;
      WrkStr := '';
      FKey := Input(X+1,17,1,0,WrkStr,True);
      If FKey = F10 then ExittoDos;
      If FKey = Esc then begin
        TerrLoop :=False;
        ClrScr;
        EXIT;
       end;
     end
     else begin
      Case WrkStr[1] of
        '1' : DoFitcon;
        '2' : DoHcrit;
        '3' : begin
                MyExec('\CTDM\EXE\PLOTCON.EXE',HillName);
                If DosExitCode = 1 then ExittoDos;
              end;
        '4' : begin
                MyExec('\CTDM\EXE\RECGEN.EXE',HillName);
                If DosExitCode = 1 then ExittoDos;
             end;
      end;   {case}
      FKey := 0;
    end;
  end; {while}
End;    { TerrMenu }


PROCEDURE ChiMenu1;
Const
  X = 34;
Begin
  Path := '\CTDM\EXE\';
  ChiLoop := True;
  While ChiLoop do begin
    F := ' CONCENTRATION POSTPROCESSOR MENU ';
    MenuHeading(False);
    Color(Yellow,Black);
    GotoXY(17,5); Write(PressToExecute);
    MenuLine(X,9, One,  ' - CHIRET');
    MenuLine(X,11,Two,  ' - CHIDIS');
{    MenuLine(X,13,Three,' - CONDIS');}
    DoEscorF10;
    WrkStr:= '';
    FKey := Input(X+1,15,1,0,WrkStr,True);
    If FKey = F10 then begin
      ChiLoop := False;
      ExittoDos;
     end;
    If FKey = Esc then begin
      ChiLoop := False;
      ClrScr;
      Exit;
     end
     else begin
      Case WrkStr[1] of
        '1'  : DoMakChf;
        '2'  : MyExec('\CTDM\EXE\CHIDIS.EXE',HillName);
{        '3'  : begin
                 Exec('\CTDM\EXE\CONDIS.EXE',HillName);
                 If DosExitCode = 1 then ExittoDos;
               end;}
       end;
     end;
   end;   {while}
end;  {ChiMenu1}


PROCEDURE MetMenu;
Const
  X = 27;
Begin
  Path :='\CTDM\EXE\';
  MetLoop := True;
  While MetLoop do begin
    F := ' METEOROLOGICAL PREPROCESSOR MENU ';
    MenuHeading(False);
    Color(Yellow,Black);
    GoToXY(17,5); Write(PressToExecute);
    MenuLine(X,9, One,' - Run METPRO');
    MenuLine(X,11,Two,' - Create a RAWIN File');
    DoEscOrF10;
    WrkStr := '';
    FKey := Input(X+1,13,1,0,WrkStr,True);
    If FKey = F10 then begin
      MetLoop := False;
      ExittoDos;
     end;
    If FKey = Esc then begin
      MetLoop :=False;
      ClrScr;
      Exit
     end
     else begin
      Case WrkStr[1] of
        '1' :  DoMetpro;
        '2' :  DoR62;
       end;     {case}
     end;
   end;    {while}
End;     {MetMenu}


{ ***************    Main Program   *****************}

Begin
  ModeIsText := True;

  For I := 1 to 80 do                     {make sure WrkStr starts out as blank}
    WrkStr[I] := ' ';

  For I := 1 to 80 do
    BlankLine[I] := ' ';

  Path     :='\CTDM\EXE\';
  Comm     := GetEnv('COMSPEC');
  WrkStr   := '';
  HillName := '';
                                                            {Headline blank, too}
  FKey     := 0;
  IScrn    := 0;

  Looping := True;
  While Looping do begin
    MainMenu;
    If FKey = F10 then ExittoDos;
    If FKey = Esc then begin
      ClrScr;
      Exit;
     end;
    Case WrkStr[1] of
      '1' : TerrMenu;
      '2' : MetMenu;
      '3' : begin
              IScrn := 0;
              DoCtdm;
            end;
      '4' : ChiMenu1;
      '5' : begin
              IScrn := 1;
              If not (Exist('\CTDM\EXE\CTSCREEN.EXE')) then begin
                ClrScr; Beep;
                GoToXY(15,10); Write('CTSCREEN.EXE not found. ' + PressEnter);
                Readln;
              end
              else DoCtdm;
            end;
     end;   {case}
   end;
END.
