{$I Switches.INC }

Program PLOTCON;
{
   Program to plot contours for actual and fitted hills on a CGA
   (either low or high resolution), Hercules Graphics, EGA, or VGA terminal.

   Written for the USEPA/ASRL by:

       Donna Burns  - Computer Sciences Corporation.

   Last Mod:
      5/16/88 - 2109  First converted to Pascal from the BASICA version. [NZK]
}


Uses
  Dos,
  Crt,
  Graph;

Label
  GetEllipseMenu,
  Loading;

Const
  LineSize = 80;

  MaxPoints = 300;

  CIns = 1;   CDel = 2;    CEnd = 3;   CDown = 4;  CPgDn = 5;
  CLeft = 6;  CRight = 7;  CHome = 8;  CUp = 9;    CPgUp = 10;

  F1 = 11;  F2 = 12;  F3 = 13;  F4 = 14;  F5 = 15;
  F6 = 16;  F7 = 17;  F8 = 18;  F9 = 19;  F10 = 20;  Esc = 21;

Type
  Name     = String[30];
  Str10    = String[10];
  Str12    = String[12];
  Str19    = String[19];
  Str30    = String[30];
  Str80    = String[80];
  Str160   = String[160];
  TheLine  = Array [1..LineSize] of Char;
  FileNames = Array[1..100] of Str12;

Var
  IAR,IAR1,IAR2 : Pointer;

  IARSize : Word;

  StillOK,
  DoingHCrit,
  Getting,
  Looping,
  Trying,
  GotIARMem,
  DoneInitGraph  : Boolean;

  PLTFile,
  HPTFile    : Text;

  PLTBuf    : Array[1..8192] of Char;
  HCRBuf    : Array[1..4096] of Char;

  HCon      : Array[1..MaxPoints] of Real;
  IDC1      : Array[1..MaxPoints] of Integer;
  IDC2      : Array[1..MaxPoints] of Integer;

  HC        : Array[1..MaxPoints] of Real;
  XHTopF    : Array[1..MaxPoints] of Real;
  YHTopF    : Array[1..MaxPoints] of Real;
  OrenF     : Array[1..MaxPoints] of Real;
  PA        : Array[1..MaxPoints] of Real;
  PB        : Array[1..MaxPoints] of Real;
  RLA       : Array[1..MaxPoints] of Real;
  RLB       : Array[1..MaxPoints] of Real;

  ThePLTFile,
  TheHPTFile,
  HillName,
  CheckName      : Str12;

  PLTNames,
  HPTNames       : FileNames;

  Path,
  ZMask,
  MsgStr,
  PlotHillName,
  HCritHillName  : Str30;

  Delim,
  DFlag,
  Ch          : Char;

  ModeIsText  : Boolean;      { TRUE if the current screen mode is TEXT }

  Code,
  FKey,
  IR,
  IRad,
  DupFlg,
  IFR,
  Ptr,
  I,J,K,L,
  ZR, ZC,
  NC1, NC2, NPC, NCR, NR,
  PLTFiles,   HPTFiles,
  PlotHillID,  HCritHillID,
  GraphDriver, GraphMode,
  ErrorCode,MyIdx            : Integer;

  Brightest : Word;

  Dummy,
  FLog,
  HTop,                  { Elevation }
  XHTop, YHTop,
  XPol, YPol,
  XMin1,YMin1,XMax1,YMax1,
  XMin2,YMin2,XMax2,YMax2,
  XMin, YMin, XMax, YMax,
  SCRCX, DSCRX,
  SCRCY, DSCRY, Ratio,
  XSHC, YSHC,
  XSHCF, YSHCF,
  XUL, YUL, XLR, YLR,
  XC, YC, DX, DY, DD,
  XCM, YCM, Oren, OrenF2,
  A2, B2,
  DSCRXDDD, DSCRYDDD,
  CSE, SNE, THC,
  A, B, R, X, Y,
  ZPA, ZPB,
  X1, Y1,
  XP, YP,
  XS, YS,
  XS1, YS1,
  XOld, YOld,
  XFit, YFit,
  AFit, BFit        : Real;

  F, S,
  HeadLine,
  WrkStr : Str80;

  BigLine     : Str160;

  Found       : Integer;

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Common.INC }


FUNCTION Power(X,P : Real) : Real;
Begin
  If X > 0.0 then Power := Exp(P*Ln(X))
   else Power := 0.0;
End;    { Power }


PROCEDURE GetAPLTFile;
Var
  ZR, ZC, I  :Integer;
Begin
  MsgStr := 'FITCON plot file';
  GetAFile(PLTFiles,PLTNames,HillName,MsgStr,MyIdx,0);
  If (FKey = F10) or (FKey = Esc) then EXIT;
  Assign(PLTFile,'\CTDM\TERRAIN\'+PLTNames[MyIdx+1]);
  SetTextBuf(PLTFile,PLTBuf);                    { User a BIG I/O buffer }
  Reset(PLTFile);
  Readln(PLTFile,WrkStr);
  If WrkStr <> 'FITCON' then begin           { File MUST come from FITCON }
    ErrorMsg(' That file was not created by program FITCON.  Press RETURN to try again. ');
    Close(PLTFile);
  end
  else begin
    ThePLTFile := PLTNames[MyIdx+1];         { PLT File selected from dir }
    Read(PLTFile,PlotHillID);
    Readln(PLTFile,PlotHillName);
    LTrim(PlotHillName);  Trim(PlotHillName);
    Readln(PLTFile,BigLine);
    Ptr := 1;
    Delim := ' ';
    ParseToFloat(XHTop);
    ParseToFloat(YHTop);
    Readln(PLTFile,NC1);
    For I := 1 to NC1 do
       Readln(PLTFile,IDC1[I]);
  end;
End;    { GetAPLTFile }


PROCEDURE RotateAndPlot;
Var
  X,Y : Integer;
Begin
  XFit := XHTopF[I] + XP * CSE - YP * SNE;
  YFit := YHTopF[I] + XP * SNE + YP * CSE;
  X := Trunc(SCRCX + (XFit - XC) * DSCRXDDD);
  Y := Trunc(SCRCY - (YFit - YC) * DSCRYDDD);
  PutPixel(X, Y, Brightest);
  If GraphDriver in [HercMono,EGA,EGA64,EGAMono,VGA] then
    PutPixel(X, Y-1, Brightest);
End;    { RotateAndPlot }


PROCEDURE GetAHPTFile;                        { Produced by program HCRIT }
Var
  ZR, ZC, I  :Integer;
Begin
  MsgStr := 'HCRIT plot file';
  GetAFile(HPTFiles,HPTNames,HillName,MsgStr,MyIdx,0);
  If (FKey = F10) or (FKey = Esc) then EXIT;
  Assign(HPTFile,'\CTDM\TERRAIN\'+HPTNames[MyIdx+1]);
  SetTextBuf(HPTFile,HCRBuf);
  Reset(HPTFile);
  Readln(HPTFile,WrkStr);
  If WrkStr <> 'HCRIT' then begin
    ErrorMsg(' That file was not created by program HCRIT.  Press ENTER to try again. ');
    Close(HPTFile);
  end
  else begin
    Read(HPTFile,HCritHillID);
    Readln(HPTFile,HCritHillName);
    LTrim(HcritHillName);  Trim(HCritHillName);
    If PlotHillID <> HCritHillID then begin
      ErrorMsg(' The hill ids of the two files do not match.  Press ENTER to try again. ');
      Close(HPTFile);
    end
    else begin
      UpCaseStr(PlotHillName);
      UpCaseStr(HCritHillName);
      If PlotHillName <> HCritHillName then begin
        ErrorMsg(' The hill names of the two files do not match.  Press ENTER to try again. ');
        Close(HPTFile);
      end
      else begin
        Readln(HPTFile,NC2);
        If NC1 <> NC2 then begin
          ErrorMsg('The nbr of contours of the two files don''t match.  Press RETURN to try again. ');
          Close(HPTFile);
        end
        else begin
          TheHPTFile := HPTNames[MyIdx+1];      { FO File selected from dir }
          For J := 1 to NC2 do
            Readln(HPTFile,IDC2[J]);
        end;
      end;
    end;
  end;
End;    { GetAHPTFile }



PROCEDURE DisplayTitle;
Var
  Middle, TitleWidth : Integer;
Begin
  LTrim(PlotHillName);
  Trim(PlotHillName);
  If DFlag = '1' then S := PlotHillName + ' - Unedited'
   else S := PlotHillName + ' - Edited';
  TitleWidth := TextWidth(S);
  SetTextJustify(CenterText,TopText);
  Middle := GetMaxX div 2;
  OutTextXY(Middle,1,S);
  MoveTo(Middle - TitleWidth div 2 - 4,1);
  LineTo(GetX,9);
  LineTo(GetX + TitleWidth + 8,GetY);
  LineTo(GetX,1);
End;    { DisplayTitle }


PROCEDURE DisplayContoursMenu;
Begin
  MenuHeading(False);
  Color(Yellow,Black);
  WriteStr(8,8,'Please press a number to select the type of contours to display.');
  MenuLine(29,11,' 1 ',' - Unedited contours');
  MenuLine(29,13,' 2 ',' - Edited contours');
  DoEscOrF10;
End;    { DisplayContoursMenu }


PROCEDURE DisplayEllipseMenu;
Begin
  MenuHeading(False);
  Color(Yellow,Black);
  WriteStr(16,8,'Please press a number to select the next display');
  MenuLine(26,11,' 1 ',' - Fitted Ellipses');
  MenuLine(26,13,' 2 ',' - Fitted cutoff hill contours');
  DoEscOrF10;
End;    { DisplayEllipseMenu }


PROCEDURE LoadHCritData;
Begin
  Readln(HPTFile,BigLine);                         { Load Hilltop elevation }
  Ptr := 1;
  Delim := ' ';
  ParseToFloat(HTop);

  For I := 1 to NC2 do begin
    Readln(HPTFile,BigLine);                      { Load contour elevations }
    Ptr := 1;
    ParseToFloat(HCon[I]);
   end;

  Readln(HPTFile,NCR);                    { Load nbr of critical elevations }
  For I := 1 to NCR do begin                        { Now load the elevations }
    Readln(HPTFile,BigLine);                       { Load Hilltop elevation }
    Ptr := 1;
    ParseToFloat(HC[I]);
    ParseToFloat(XHTopF[I]);
    ParseToFloat(YHTopF[I]);
    ParseToFloat(OrenF[I]);
    ParseToFloat(PA[I]);
    ParseToFloat(PB[I]);
    ParseToFloat(RLA[I]);
    ParseToFloat(RLB[I]);
   end;

  Close(HPTFile);

End;    { LoadHCritData }


BEGIN

  HeapError := @HeapFunc;

  Delim    := ' ';
  F        := ' PLOTCON ';
  HeadLine := '';
  HillName := '';

  If ParamCount > 0 then
    HillName := ParamStr(1)
   else
    HillName := '';

  If RegisterBGIdriver(@HercDriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@CGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@EVGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIFont(@LittFont) < 0 then Writeln(GraphErrorMsg(GraphResult));

  GraphDriver   := Detect;

  Path          := '\CTDM\TERRAIN\';

  DoneInitGraph := False;
  GotIARMem     := False;

  Looping := True;
  While Looping do begin
    If DoneInitGraph then begin
      CloseGraph;
      DoneInitGraph := False;
     end;

    ModeIsText  := True;

    FKey := 0;
    LoadNames('\CTDM\TERRAIN\','*.PLT',PLTFiles,PLTNames);

    ThePLTFile := '';
    While ThePLTFile = '' do begin
      MenuHeading(False);
      WrkStr := '';
      GetAPLTFile;
      If FKey = F10 then ExittoDos;
      If FKey = Esc then begin
        Color(LightGray,Black);
        ClrScr;
        Exit;
      end;
    end;

    If FKey = Esc then  Exit;

                     { Now we have a PLOT file }

    Readln(PLTFile,BigLine);          { Load X and Y boundaries - unedited }
    Ptr := 1;
    ParseToFloat(XMin1);
    ParseToFloat(XMax1);
    ParseToFloat(YMin1);
    ParseToFloat(YMax1);

    Readln(PLTFile,BigLine);          { Load skip edited boundaries }
    Ptr := 1;
    ParseToFloat(XMin2);
    ParseToFloat(XMax2);
    ParseToFloat(YMin2);
    ParseToFloat(YMax2);

  {
    Now determine the type of display we are using.  If CGA, ask the user
    if we are to use Low Res (in color) or Hi-Res (B&W).
  }

    DetectGraph(GraphDriver,GraphMode);

{    GraphDriver := HercMono;
    GraphMode   := HercMonoHi; }

{    GraphDriver := CGA; }

{    GraphDriver := EGA64;
    GraphMode   := EGAHi; }

{    GraphDriver := EGAMono;
    GraphMode   := EGALo; }

    If GraphDriver = CGA then begin
      DisplayResMenu;
      WrkStr := '';
      While (WrkStr <> '1') and (WrkStr <> '2') and (FKey <> Esc) do
        FKey := Input(24,16,1,0,WrkStr,True);
      If FKEy = F10 then ExittoDos;
      If FKey = Esc then begin
        FKey := 0;
        EXIT;
       end;
      If WrkStr = '1' then GraphMode := CGAC0
       else GraphMode := CGAHI
     end;

  {
    Set up the plot boundaries, scale factors and colors based
    on GraphDriver and GraphMode.
  }
    DetermineBoundaries;

    DisplayContoursMenu;

    WrkStr := '';
    While (WrkStr <> '1') and (WrkStr <> '2') and (FKey <> Esc) and (FKey <> F10) do
      FKey := Input(30,16,1,0,WrkStr,True);
    Color(LightGray,Black);
    If FKey = F10 then ExittoDos;
    If FKey = Esc then begin
      FKey := 0;
      Getting := False;
      StillOK := False;
     end
     else StillOK := True;

    If StillOK then begin
      InitGraph(GraphDriver,GraphMode,'');
      DFlag := WrkStr[1];

      Brightest := GetMaxColor;

      If Dflag = '1' then begin
        XC := (XMin1 + XMax1) / 2;
        YC := (YMin1 + YMax1) / 2;
        DX := XMax1 - XMin1;
        DY := YMax1 - YMin1;
       end
       else begin
        XC := (XMin2 + XMax2) / 2;
        YC := (YMin2 + YMax2) / 2;
        DX := XMax2 - XMin2;
        DY := YMax2 - YMin2;
       end;

      If (DX / DY) < Ratio then DD := DY
       else DD := DX / Ratio;
      DSCRXDDD := DSCRX / DD;
      DSCRYDDD := DSCRY / DD;

      SetBkColor(Black);
      SetColor(GetMaxColor);

      Rectangle(0,0,GetMaxX,GetMaxY);           { Put a box around everything }
      DoneInitGraph := True;

      DisplayTitle;                                       { At the top center }
      SetLineStyle(DottedLn,0,NormWidth);    { Select dotted lines for contours }
      If (GraphDriver = CGA) and (GraphMode = CGAC0) then
        SetColor(3)                              { Select Yellow for contours }
       else
        If GraphDriver in [EGA64,VGA] then
          SetColor(14)
         else
          SetColor(GetMaxColor);

      For J := 1 to NC1 do begin                      { Loop through contours }
        Readln(PLTFile,BigLine);         { Load contour points and elevation }
        Ptr := 1;
        ParseToInt(NPC);
        ParseToFloat(Dummy);

        If DFlag = '2' then begin                      { Skip Unedited Contours }
          For K := 1 to NPC do
            Readln(PLTFile,BigLine);
          Readln(PLTFile,BigLine);         { Load contour points and elevation }
          Ptr := 1;
          ParseToInt(NPC);
         end;

        Readln(PLTFile,BigLine);              { Load initial contour coordinates }
        Ptr := 1;
        ParseToFloat(X1);
        ParseToFloat(Y1);

        XOld   := X1;
        YOld   := Y1;
        DupFlg := 0;
        XS1 := SCRCX + (X1 - XC) * DSCRXDDD;
        YS1 := SCRCY - (Y1 - YC) * DSCRYDDD;

        MoveTo(Trunc(XS1), Trunc(YS1));
        PutPixel(Trunc(XS1), Trunc(YS1), Brightest);
        IFR := 0;
        For K := 2 to NPC do begin
          Readln(PLTFile,BigLine);                    { Load contour coordinates }
          Ptr := 1;
          ParseToFloat(X);
          ParseToFloat(Y);

          If (IFR < 2) or (Abs(X - X1) > 1.0E-15) or (Abs(Y - Y1) > 1.0E-15) then begin
            XS := SCRCX + (X - XC) * DSCRXDDD;
            YS := SCRCY - (Y - YC) * DSCRYDDD;
            If DupFlg <> 0 then begin
              XOld := X;
              YOld := Y;
              DupFlg := 0;
              MoveTo(Trunc(XS), Trunc(YS));
              PutPixel(Trunc(XS), Trunc(YS), Brightest);
             end
             else begin
              If (Abs(X - XOld) < 1.0E-15) and (Abs(Y - YOld) < 1.0E-15) then begin
                DupFlg := 1;
                Inc(IFR);
              end;
               LineTo(Trunc(XS),Trunc(YS));
            end;
          end;
        end;

        If DFlag = '1' then begin
          Readln(PLTFile,BigLine);                  { Load contour coordinates }
          Ptr := 1;
          ParseToInt(NPC);
          For K := 1 to NPC do
            Readln(PLTFile,BigLine);                 { Bypass edited contours }
        end;
      end;
                {  All contours are written    }
      XSHC := SCRCX + (XHTOP - XC) * DSCRXDDD;
      YSHC := SCRCY - (YHTOP - YC) * DSCRYDDD;

      XUL := XSHC - 1;  XLR := XSHC + 1;
      YUL := YSHC - 1;  YLR := YSHC + 1;

      If (GraphDriver in [HercMono,EGA,EGA64,EGAMono,VGA]) or
         ((GraphDriver = CGA) and (GraphMode = 4)) then  { Slightly larger }
        XUL := XUL - 1;

      If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
        YUL := YUL - 1;

               {   Put a little box at the hill center  }
      SetLineStyle(SolidLn,0,ThickWidth);                { Back to solid lines }
      Rectangle(Trunc(XUL), Trunc(YUL), Trunc(XLR), Trunc(YLR));

               {   Save the current screen on the stack  }

      If Not GotIARMem then begin                     { Only get memory ONCE }
        If GraphDriver in [EGA,EGA64,EGAMono] then begin
          IARSize := ImageSize(0,0,GetMaxX,199);
          GetMem(IAR,IARSize);  If IAR = nil then ABORT(IARSize);
          IARSize := ImageSize(0,200,GetMaxX,349);
          GetMem(IAR1,IARSize); If IAR1 = nil then ABORT(IARSize);
         end
         else If (GraphDriver=VGA) then begin
          IARSize := ImageSize(0,0,GetMaxX,159);
          GetMem(IAR,IARSize);  If IAR = nil then ABORT(IARSize);
          IARSize := ImageSize(0,160,GetMaxX,319);
          GetMem(IAR1,IARSize); If IAR1 = nil then ABORT(IARSize);
          IARSize := ImageSize(0,320,GetMaxX,479);
          GetMem(IAR2,IARSize); If IAR2 = nil then ABORT(IARSize);
         end
         else begin
          IARSize := ImageSize(0,0,GetMaxX,GetMaxY);
          GetMem(IAR,IARSize);  If IAR = nil then ABORT(IARSize);
         end;
        GotIARMem := True;
       end;

      If GraphDriver = VGA then begin
        GetImage(0,0,GetMaxX,159,IAR^);
        GetImage(0,160,GetMaxX,319,IAR1^);
        GetImage(0,320,GetMaxX,479,IAR2^);
       end
       else If GraphDriver in [EGA,EGA64,EGAMono] then begin
        GetImage(0,0,GetMaxX,199,IAR^);
        GetImage(0,200,GetMaxX,349,IAR1^);
       end
       else begin
        GetImage(0,0,GetMaxX,GetMaxY,IAR^);
       end;

      SetTextJustify(LeftText,TopText);
      If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
        SetTextStyle(SmallFont,HorizDir,5)
       else
        SetTextStyle(SmallFont,HorizDir,4);
      WrkStr := 'Press ENTER (or Esc-Quit)';
      SetViewPort(1,1,TextWidth(WrkStr)+6,TextHeight(WrkStr)+10,ClipON);
      ClearViewPort;
      If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
        SetTextStyle(SmallFont,HorizDir,5)
       else
        SetTextStyle(SmallFont,HorizDir,4);
      SetColor(White);
      OutTextXY(2,1,WrkStr);
      WrkStr := '';                                          { Pause for user }
      FKey := Input(0,0,1,0,WrkStr,False);
      If FKey = F10 then ExittoDos;
      If FKey = Esc then begin
        FKey := 0;
        RestoreCRTMode;
        Close(PLTFile);
        Getting := False;
       end
       else Getting := True;
     end; {StillOK}

GetEllipseMenu:
    WrkStr := 'X';
    If Getting then begin
      RestoreCRTMode;
      DisplayEllipseMenu;

      WrkStr := '';
      While (WrkStr <> '1') and (WrkStr <> '2') and (FKey <> Esc) and (FKey <> F10) do
        FKey := Input(27,16,1,0,WrkStr,True);
      If FKey = F10 then ExittoDos;
      If FKey = Esc then begin
        Getting := False;
        FKey := 0;
        WrkStr := 'X';      { Force exit by testing NO on following questions }
       end;

      If WrkStr = '1' then begin                            { Display ellipses }
        SetGraphMode(GraphMode);                           { Back to graphics }
        If (GraphDriver = CGA) and (GraphMode = CGAC0) then begin
          SetColor(2);                               { Select HiRed for Ellipses }
          Brightest := 1;
         end;
        If GraphDriver in [EGA,EGA64,VGA] then begin
          SetColor(LightRed);                               { Select HiRed for Ellipses }
          Brightest := 15;
         end;
        If GraphDriver = EGAMono then begin
          SetColor(GetMaxColor);
          Brightest := GetMaxColor;
         end;

        PutImage(0,0,IAR^,NormalPut);
        If GraphDriver = VGA then begin
          PutImage(0,160,IAR1^,NormalPut);
          PutImage(0,320,IAR2^,NormalPut);
         end
         else If GraphDriver in [EGA,EGA64,EGAMono] then
          PutImage(0,200,IAR1^,NormalPut);

        For J := 1 to NC1 do begin
          Readln(PLTFile,BigLine);                { Load contour coordinates }
          Ptr := 1;
          ParseToFloat(XCM);
          ParseToFloat(YCM);
          ParseToFloat(A);
          ParseToFloat(B);
          ParseToFloat(Oren);

          Oren := Oren - 90;
          CSE := Cos(0.017453 * Oren);
          SNE := Sin(0.017453 * Oren);
          XP := A;
          XFit := XCM + XP * CSE;
          YFit := YCM + XP * SNE;
          XS := SCRCX + (XFit - XC) * DSCRXDDD;
          YS := SCRCY - (YFit - YC) * DSCRYDDD;

          MoveTo(Trunc(XS), Trunc(YS));
          A2 := Sqr(A);
          B2 := Sqr(B);
          SetLineStyle(SolidLn,0,ThickWidth);           { Back to solid lines }
          For L := 1 to 120 do begin
            THC := -L * 0.05276;
            R := Sqrt(1.0 / (Sqr(Cos(THC)) / A2 + Sqr(Sin(THC)) / B2));
            XP := R * Cos(THC);
            YP := R * Sin(THC);
            XFit := XCM + (XP * CSE) - (YP * SNE);
            YFit := YCM + (XP * SNE) + (YP * CSE);
            XS := SCRCX + (XFit - XC) * DSCRXDDD;
            YS := SCRCY - (YFit - YC) * DSCRYDDD;
            LineTo(Trunc(XS), Trunc(YS));
           end;
         end;

        If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
          SetTextStyle(SmallFont,HorizDir,5)
         else
          SetTextStyle(SmallFont,HorizDir,4);
        SetTextJustify(LeftText,TopText);
        SetColor(GetMaxColor);
        WrkStr := 'Finished ellipses.  Press ENTER';
        SetViewPort(1,1,TextWidth(WrkStr)+6,11,ClipON);
        ClearViewPort;
        SetViewPort(0,0,GetMaxX,GetMaxY,True);
        If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
          SetTextStyle(SmallFont,HorizDir,5)
         else
          SetTextStyle(SmallFont,HorizDir,4);
        OutTextXY(2,1,WrkStr);

        Close(PLTFile);

        WrkStr := '';
        FKey := Input(0,0,1,0,WrkStr,False);

        RestoreCRTMode;
        MenuHeading(False);       { Ask if we need the Fitted cutoff contours }
        Color(Yellow,Black);
        WriteStr(9,10,'Would you like to see the fitted cutoff hill contours?  (Y/N) ');
        WrkStr := '';
        While (WrkStr <> 'Y') and (WrkStr <> 'N') and (FKey <> Esc) do begin
          FKey := Input(WhereX,WhereY,1,0,WrkStr,True);
          If FKey = F10 then ExittoDos;
          If Length(WrkStr) > 0 then
            WrkStr[1] := UpCase(WrkStr[1]);
         end;
        If (FKey = Esc) or (WrkStr = 'N') then begin
          WrkStr := 'X';                { Retain the original state of WrkStr }
          Exit;
         end
         else WrkStr := '2';             { Force continuing with cutoff hills }
       end; {WrkStr := 1}

 Loading:
      If WrkStr = '2' then begin       { Requested to do cutoff Hill Contours }
        LoadNames('\CTDM\TERRAIN\','*.HPT',HPTFiles,HPTNames);

        TheHPTFile := '';
        While TheHPTFile = '' do begin
          MenuHeading(False);
          WrkStr := '';
          GetAHPTFile;
          If FKey = F10 then ExittoDos;
          If FKey = Esc then begin
            FKey := 0;
            Getting := False;
            GoTo GetEllipseMenu;
          end;
        end;

                       { Now we have an HCRIT file }

        LoadHCritData;                         { Put ALL HCRIT data in tables }

        DoingHCrit := True;
        While DoingHCrit do begin
          RestoreCRTMode;
          MenuHeading(False);              { Determine the starting elevation }
          Color (Yellow,Black);
          WriteStr(16,5,'To continue, type the number of the starting elevation');
          WriteStr(20,7,'and press ENTER or hit F8 to end PLOTCON.');
          DoEscOrF10;
          I := 0;  ZR := 10;  ZC := 10;
          While I < NCR do begin
            Inc(I);
            GoToXY(ZC,ZR); Write(I:3, ': ', HC[I]:7:2);
            Inc(ZR);
            If ZR > 21 then begin
              ZR := 10;
              ZC := ZC + 14;
            end;
          end;

          I := 0;
          While ((I < 1) or (I > NCR)) and (FKey <> Esc) and (FKey <> F10) and (FKey <> F8) do begin
            WrkStr := '';
            FKey := Input(39,23,1,3,WrkStr,True);
            If FKey <> Esc then
              Val(WrkStr,I,Code);
           end;

          If FKey = F10 then ExittoDos;
          If FKey in [Esc,F8] then begin
            Trying := False;                   { Dont even start the contours }
            DoingHCrit := False;               { and exit from HCrit loop     }
            If FKey = Esc then begin           { display file names again }
              WrkStr := '2';
              GoTo Loading;
            end;
            WrkStr := 'X';
            Getting := False;
            Looping := False;                 { quit program }
           end
           else begin
            Trying := True;                    { Start if we got a number     }
            SetGraphMode(GraphMode);                       { Back to graphics }
            If GraphDriver in [EGA,EGA64,VGA] then begin
              SetColor(LightRed);                  { Select HiRed for Ellipses }
              Brightest := 15;
              SetBkColor(Black);
             end;
            If (GraphDriver = CGA) and (GraphMode = CGAC0) then begin
              SetColor(2);                         { Select HiRes for Ellipses }
              Brightest := 1;
              SetBkColor(Black);
             end;
            If GraphDriver = EGAMono then begin
              SetColor(GetMaxColor);
              Brightest := GetMaxColor;
              SetBkColor(Black);
             end;
           end;

          While Trying do begin
            PutImage(0,0,IAR^,NormalPut);
            If GraphDriver = VGA then begin
              PutImage(0,160,IAR1^,NormalPut);
              PutImage(0,320,IAR2^,NormalPut);
             end
             else If GraphDriver in [EGA,EGA64,EGAMono] then begin
              PutImage(0,200,IAR1^,NormalPut);
             end;

            If (GraphDriver = CGA) and (GraphMode = CGAC0) then begin
              Brightest := 1;
             end
             else Brightest := GetMaxColor;

            Str(HC[I]:7:2,WrkStr);
            WrkStr := 'Crit. elev. = ' + WrkStr;
            If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
              SetTextStyle(SmallFont,HorizDir,5)
             else
              SetTextStyle(SmallFont,HorizDir,4);
            SetTextJustify(LeftText,TopText);
            SetViewPort(1,1,TextWidth(WrkStr)+6,11,ClipON);
            ClearViewPort;
            SetViewPort(0,0,GetMaxX,GetMaxY,True);
            If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
              SetTextStyle(SmallFont,HorizDir,5)
             else
              SetTextStyle(SmallFont,HorizDir,4);
            SetColor(GetMaxColor);
            OutTextXY(2,1,WrkStr);

            If (GraphDriver = CGA) and (GraphMode = CGAC0) then begin
              SetBkColor(Black);
              SetColor(2);                       { Select HiRed for contours }
              Brightest := 2;
             end;
            If GraphDriver in [EGA,EGA64,VGA] then begin
              SetColor(LightRed);                    { Select HiRed for Ellipses }
              Brightest := LightRed;
              SetBkColor(Black);
             end;
            If GraphDriver = EGAMono then begin
              SetColor(GetMaxColor);
              Brightest := GetMaxColor;
              SetBkColor(Black);
             end;

            OrenF2 := OrenF[I] - 90;  { Get orient of Maj Axis w/r pos X-axis }
            CSE := Cos(0.017453 * OrenF2);
            SNE := Sin(0.017453 * OrenF2);

            For J := 1 to NC2 do begin                   { Loop thru contours }
              If HCon[J] > (HC[I] + 1) then begin
                FLog := Ln((HTop - HC[I]) / (HCon[J] - HC[I]) - 1);
                ZPA := PA[I];  ZPB := PB[I];
                AFit := RLA[I] * Exp((1 / ZPA) * FLog);
                BFit := RLB[I] * Exp((1 / ZPB) * FLog);
                For L := 1 to 130 do begin
                  If L < 100 then begin
                    XPol := L * 0.01 * AFit;
                    YPol := BFit * Power((1-Power((XPol / AFit),ZPA)), (1 / ZPB));
                   end
                   else begin
                    YPol := (L - 100) * 0.01 * BFit;
                    XPol := AFit * Power((1-Power((YPol / BFit),ZPB)), (1 / ZPA));
                   end;
                  XP := XPol;  YP := YPol;  RotateAndPlot;   { First quadrant }
                { XP := XPol;} YP := -YPol; RotateAndPlot;   { Second quadrant }
                  XP := -XPol;{YP := -YPol;}RotateAndPlot;   { Third quadrant }
                { XP := -XPol;}YP := YPol;  RotateAndPlot;   { Fourth quadrant }
                 end;
               end;
             end;

            XSHCF := SCRCX + (XHTopF[I] - XC) * DSCRXDDD;
            YSHCF := SCRCY - (YHTopF[I] - YC) * DSCRYDDD;
            XUL := XSHCF - 1;  XLR := XSHCF + 1;
            YUL := YSHCF - 1;  YLR := YSHCF + 1;

            If GraphDriver in [HercMono,EGA,VGA] then begin { Slightly bigger if Herc }
              XUL := XUL - 1;  XLR := XLR + 1;
              YUL := YUL - 1;  YLR := YLR + 1;
             end;

                  {   Put a little box at the hill center  }
            SetLineStyle(SolidLn,0,ThickWidth);           { Back to solid lines }
            Rectangle(Trunc(XUL),Trunc(YUL),Trunc(XLR),Trunc(YLR));

            SetLineStyle(SolidLn,0,NormWidth);            { Back to solid lines }
            If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
              SetTextStyle(SmallFont,HorizDir,5)
             else
              SetTextStyle(SmallFont,HorizDir,4);
            SetTextJustify(LeftText,TopText);
            WrkStr := 'ENTER - next elev.  Esc-Quit ';
            SetViewPort(GetMaxX-TextWidth(WrkStr)-6,1,GetMaxX-1,11,ClipON);
            ClearViewPort;
            SetViewPort(0,0,GetMaxX,GetMaxY,True);
            If GraphDriver in [EGA,EGA64,EGAMono,VGA] then
              SetTextStyle(SmallFont,HorizDir,5)
             else
              SetTextStyle(SmallFont,HorizDir,4);
            SetColor(GetMaxColor);
            OutTextXY(GetMaxX-TextWidth(WrkStr)-3,1,WrkStr);

            WrkStr := '';
            FKey := Input(0,0,1,0,WrkStr,False);
            If FKey = F10 then ExittoDos;
            If FKey = Esc then begin
              FKey := 0;
              WrkStr := 'X';
              Trying := False;
             end
             else begin
              Inc(I);
              If I > NCR then begin
                Trying := False;
                WrkStr := 'X';
               end;
             end;
           end; {Trying}
         end;
       end; {WrkStr := 2}
     end;  {Getting}

    If WrkStr <> 'X' then begin
      WrkStr := '';
      FKey := Input(0,0,1,0,WrkStr,False);
      RestoreCRTMode;
      Color(LightGray,Black);
      ClrScr;
     end;
   end;    { Looping }
  Color(LightGray,Black);
  ClrScr;
end.