{$I Switches.INC }

Program Recgen;
{
    RECGEN

   Written for the USEPA/AREAL by:

       Donna Burns  - Computer Sciences Corporation.

}

Uses
  Dos,
  Crt,
  Graph;

Label
  MainEntry,
  GetModifiedName,
  PlotFileEntry,
  RCTFileEntry;

Const
  Zero     = 0.0;
  LineSize = 80;
  Bell     = ^G;

  NRMax = 400;

  CIns = 1;   CDel = 2;    CEnd = 3;   CDown = 4;  CPgDn = 5;
  CLeft = 6;  CRight = 7;  CHome = 8;  CUp = 9;    CPgUp = 10;

  F1  = 11;  F2 = 12;  F3 = 13;  F4 = 14;  F5 = 15;
  F6  = 16;  F7 = 17;  F8 = 18;  F9 = 19;  F10 = 20;
  Esc = 21;

  CtrlLeft = 22;   CtrlRight = 23;
  CtrlHome = 24;   CtrlEnd   = 25;
  CtrlPgUp = 26;   CtrlPgDn  = 27;

Type
  Name     = String[30];
  Str10    = String[10];
  Str12    = String[12];
  Str19    = String[19];
  Str30    = String[30];
  Str80    = String[80];
  Str160   = String[160];
  TheLine  = Array [1..LineSize] of Char;
  FileNames = Array [1..100] of Str12;

  ReceptorRec = Record
     X     : Real;
     Y     : Real;
     Z  : Real;
  end;

  ContourSegRec = Record     { contains the generated X & Y coordinates }
     X     : Integer;        { contour line segment endpoint }
     Y     : Integer;
  end;

Var
  IAR,IAR1,IAR2,
  MenuPtr,Cross,
  ElevPtr,DispElevPtr   : Pointer;

  IARSize,
  MenuSize,
  ElevSize,
  DispElevSize,
  Size,
  ContourHigh,
  ContourLow      : Word;

  Getting,
  Looping,
  Trying,
  GotIARMem,
  DoneInitGraph,
  DeleteInProgress,
  Loading,
  Modified,
  NewRecfile,
  NeedSpacing,
  Satisfied,
  GettingFiles       : Boolean;

  PLTFile,
  PDFFile,
  RCTFile        : Text;

  PLTBuf    : Array[1..8192] of Char;
  RCTBuf    : Array[1..8192] of Char;
  PDFBuf    : Array[1..8192] of Char;

  Receptors        : Array[1..400] of ReceptorRec;
  ContourSegments  : Array[1..5000] of ContourSegRec;
  Contours         : Array[1..50] of Integer;  { # of line segs for each contour }
  HConStr          : Array[1..200] of Str10;  { contour elevations }

  RCTNames,
  PLTNames   : FileNames;

  IDC,
  ThePLTFile,
  TheRCTFile,
  ThePDFFile,
  CheckName,
  HillName    : Str12;

  Path,
  ZMask,
  PlotHillName,
  RCTHillName,
  MsgStr        : Str30;

  Delim,
  Ch          : Char;

  ModeIsText,                       { TRUE if the current screen mode is TEXT }
  GotReceptorMenuMem,
  GotElevMem,
  GotDisplayElevMem : Boolean;

  Code,
  CrossXOff,CrossYOff,
  CrossXLen,CrossYLen,
  FKey,
  I,J,K,L,
  IFR,
  IntXS, IntYS,
  IRad,                           { Radius -in pixels- of the receptor circle }
  LineX,LineY,
  NC1,                                { Number of contours in the .PLT hill }
  NPC,                                    { Number of points on the contour }
  PerFlg,                      { 0 if we need a new Perimeter Distance File }
  PLTFiles,                               { Number of available .PLT files }
  RCTFiles,                                { Number of available .RCT files }
  PlotHillID,                                  { ID number of the .PLT hill }
  DupFlg,
  PosX,PosY,
  Ptr,
  CHRad,                                   { Radius of the current receptor }
  ContourSeg,                    { Current cursor postion at segment number }
  CSIndex,                                          { Contour Segment Index }
  CSStart,                               { Index of a contour's first point }
  NumRT,NPTS,
  NumR,NRec,
  GraphDriver,
  GraphMode,
  ErrorCode,
  Found,
  MyIdx       : Integer;

  MaxColor,
  xasp,yasp    : Word;

  Fact,
  HCon,                           { Contour elevation }
  XHTop,
  YHTop,
  TPDis,                          { Total distance traveled along the contour }
  XMin1,YMin1,XMax1,YMax1,                      { Unedited contour boundaries }
  XMin2,YMin2,XMax2,YMax2,                        { Edited contour boundaries }
  SCRCX, DSCRX,
  SCRCY, DSCRY, Ratio,
  XSHC, YSHC,
  XUL, YUL, XLR, YLR,
  XR, YR, ZR,
  XB, YB,
  XC, YC, DX, DY, DD,
  DSCRXDDD, DSCRYDDD,
  DistR,
  DL1,DL,
  PD,                                                 { Perimeter Distance    }
  X, Y, Z,
  XLast, YLast, PDLast,
  X1, Y1,
  XP, YP,
  XS, YS,
  XS1, YS1,
  XOld, YOld        : Real;

  F,S,
  HeadLine,
  WrkStr,
  BlankLine,
  BigLine     : Str80;

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Common.INC }


FUNCTION FileExists(Var TheFile : Str80): Boolean;
Var
  F : File of Byte;
Begin
  Assign(F, TheFile);
  {$I-}
  Reset(F);
  {$I+}
  If IOResult = 0 then
    FileExists := True
   else
    FileExists := False;
End;    { FileExists }


PROCEDURE GetAPLTFile;
Begin
  MsgStr := 'Plot';
  GetAFile(PLTFiles,PLTNames,HillName,MsgStr,MyIdx,0);
  If (FKey = Esc) or (FKey = F10) then EXIT;
  Assign(PLTFile,Path+PLTNames[MyIdx+1]);
  SetTextBuf(PLTFile,PLTBuf);
  Reset(PLtFile);
  Readln(PLTFile,WrkStr);
  If WrkStr <> 'FITCON' then begin
    ErrorMsg(' That file was not created by program FITCON.  Press RETURN to try again. ');
    Close(PLTFile);
  end
  else begin
    ThePLTFIle := PLTNames[MyIdx+1];
    Read(PLTFile,PlotHillID);
    Readln(PLTFile,PlotHillName);
    Readln(PLTFile,BigLine);
    Ptr := 1;
    Delim := ' ';
    ParseToFloat(XHTop);
    ParseToFloat(YHTop);
    Readln(PLTFile,NC1);
    For I := 1 to NC1 do
      Readln(PLTFile,IDC);
    Readln(PLTFile,BigLine);          { Load X and Y boundaries from PLOT file }
    Ptr := 1;
    ParseToFloat(XMin1);
    ParseToFloat(XMax1);
    ParseToFloat(YMin1);
    ParseToFloat(YMax1);

    Readln(PLTFile,BigLine);          { Load edited contour boundaries }
    Ptr := 1;
    ParseToFloat(XMin2);
    ParseToFloat(XMax2);
    ParseToFloat(YMin2);
    ParseToFloat(YMax2);
  end;
End;    { GetAPLTFile }


PROCEDURE DisplayRec(X,Y : Real);
Var
  I,J,K : Integer;
Begin
  XP := SCRCX + (X - XC) * DSCRXDDD;
  YP := SCRCY - (Y - YC) * DSCRYDDD;

  Setcolor(GetMaxColor);
  Circle(Trunc(XP),Trunc(YP),IRad);

  If GraphDriver <> CGA then begin
    For I := Trunc(XP)-1 to Trunc(XP)+1 do
      For J := Trunc(YP)-1 to Trunc(YP)+1 do
        PutPixel(I,J,0)
   end
   else PutPixel(Trunc(XP),Trunc(YP),0);

  FloodFill(Trunc(XP),Trunc(YP),GetMaxColor);
End;    { DisplayRec }


PROCEDURE DisplayTitle;
Var
  Middle, TitleWidth : Integer;
Begin
  LTrim(PlotHillName);
  Trim(PlotHillName);
  S := PlotHillName;
  TitleWidth := TextWidth(S);
  SetTextJustify(CenterText,TopText);
  Middle := GetMaxX div 2;
  OutTextXY(Middle,1,S);
  MoveTo(Middle - TitleWidth div 2 - 4,1);
  LineTo(GetX,9);
  LineTo(GetX + TitleWidth + 8,GetY);
  LineTo(GetX,1);
End;    { DisplayTitle }


PROCEDURE PressEnter(Show : Boolean);
Var
  Middle, TitleWidth,TitleHeight : Integer;
Begin
  S := 'ENTER - Continue  ESC - Back  F10 - DOS';
  If Show then
   SetColor(LightGray)
  else
    SetColor(Black);
  SetTextStyle(0,0,0);
  SetTextJustify(CenterText,TopText);
  TitleWidth := TextWidth(S);
  TitleHeight:= TextHeight(S);
  Middle := GetMaxX div 2;
  OutTextXY(Middle,GetMaxY - TitleHeight - 2,S);
End;    { PressEnter }


PROCEDURE NewOrOldMenu;
Begin
  MenuHeading(False);
  GoToXY(19,9);  Color(Yellow,Black);
  Write('Please press a number to make a selection.');
  MenuLine(22,12,' 1 ',' - Create a new receptor file');
  MenuLine(22,14,' 2 ',' - Edit an existing receptor file');
  DoEscOrF10;
End;

PROCEDURE SaveTheScreen;
Begin
               {   Save the current screen on the stack  }

  If Not GotIARMem then begin                     { Only get memory ONCE }
    If GraphDriver in [EGA,EGA64,EGAMono] then begin
      IARSize := ImageSize(0,0,GetMaxX,199);
      GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
      IARSize := ImageSize(0,200,GetMaxX,349);
      GetMem(IAR1,IARSize); If IAR1 = Nil then ABORT(IARSize);
     end
     else If (GraphDriver=VGA) then begin
      IARSize := ImageSize(0,0,GetMaxX,159);
      GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
      IARSize := ImageSize(0,160,GetMaxX,319);
      GetMem(IAR1,IARSize); If IAR1 = Nil then ABORT(IARSize);
      IARSize := ImageSize(0,320,GetMaxX,479);
      GetMem(IAR2,IARSize); If IAR2 = Nil then ABORT(IARSize);
     end
     else begin
      IARSize := ImageSize(0,0,GetMaxX,GetMaxY);
      GetMem(IAR,IARSize);  If IAR = Nil then ABORT(IARSize);
     end;
    GotIARMem := True;
   end;

  If GraphDriver = VGA then begin
    GetImage(0,0,GetMaxX,159,IAR^);
    GetImage(0,160,GetMaxX,319,IAR1^);
    GetImage(0,320,GetMaxX,479,IAR2^);
   end
   else If GraphDriver in [EGA,EGA64,EGAMono] then begin
    GetImage(0,0,GetMaxX,199,IAR^);
    GetImage(0,200,GetMaxX,349,IAR1^);
   end
   else begin
    GetImage(0,0,GetMaxX,GetMaxY,IAR^);
   end;
End;    { SaveTheScreen }


PROCEDURE RestoreTheScreen;
Begin
  PutImage(0,0,IAR^,NormalPut);
  If GraphDriver = VGA then begin
    PutImage(0,160,IAR1^,NormalPut);
    PutImage(0,320,IAR2^,NormalPut);
   end
   else If GraphDriver in [EGA,EGA64,EGAMono] then
    PutImage(0,200,IAR1^,NormalPut);
End;    { RestoreTheScreen }


PROCEDURE GetReceptorSpacing;
Var
  S : Array [1..7] of Str30;
  MiddleX,
  MiddleY, TitleWidth,TitleHeight,
  TLX,TLY,
  BRX,BRY,
  MidX,MidY,
  Delta,
  Row,
  I    : Integer;

  Getting : Boolean;

Begin
  PressEnter(False);
  If (GraphDriver = CGA) and (GraphMode = CGAC0) then
    SetColor(3)
  else If GraphDriver = VGA then
    SetColor(Yellow)
  else
    SetColor(GetMaxColor);

  S[1] := 'Contour Elevation '+HConStr[J];
  S[2] := '';
  S[3] := 'Receptor spacing method?';
  S[4] := '  1 - Distance Increment';
  S[5] := '  2 - Nbr of Receptors  ';
  S[6] := 'Esc - Back              ';
  S[7] := 'F10 - Exit to Dos       ';

  If GraphDriver in [EGA,EGA64,EGAMono,VGA] then begin
    Delta := 12;
    SetTextStyle(SmallFont,HorizDir,5);
   end
   else begin
    Delta := 8;
    SetTextStyle(SmallFont,HorizDir,4);
   end;

  TitleWidth := TextWidth(S[3]);
  TitleHeight:= TextHeight(S[3]);
  SetTextJustify(CenterText,TopText);
  MiddleX := GetMaxX div 2;
  MiddleY := GetMaxY div 2;

  TLX := MiddleX - (TitleWidth div 2) - Delta;
  TLY := MiddleY - (6 * TitleHeight + Delta);
  BRX := MiddleX + (TitleWidth div 2) + Delta;
  BRY := MiddleY + (8 * TitleHeight + Delta);

  If not GotReceptorMenuMem then begin
                   {   Save the window on the heap  }
    MenuSize := ImageSize(TLX,TLY,BRX,BRY);
    GetMem(MenuPtr,MenuSize);
    If (MenuPtr = nil) then begin
      RestoreCRTmode;
      Write('Insufficient memory.');
      Readln;
      EraseMsg;
      GotReceptorMenuMem := False;
    end
    else GotReceptorMenuMem := True;
  end;

  GetImage(TLX,TLY,BRX,BRY,MenuPtr^);

  SetViewPort(TLX,TLY,BRX,BRY,ClipOff);
  ClearViewPort;

  SetLineStyle(0,0,1);
  DrawBox(0,0,TitleWidth+(2*Delta-1),(13*TitleHeight)+(2*Delta),GetMaxColor);

  MidX := TitleWidth div 2;
  MidY := (BRY - TLY) div 2;
  SetTextJustify(CenterText,TopText);
  For Row := 1 to 5 do
    OutTextXY(MidX+Delta, (Row-1) * (TitleHeight + Delta) + Delta, S[Row]);

  Getting := True;                                   { Get the spacing method }
  While Getting do begin
    WrkStr := '';
    MoveTo((BRX-TLX) div 2,BRY-TLY-Delta);
    FKey := Input(0,0,1,0,WrkStr,False);

    If ((FKey = Esc) or (Fkey = F10)) or
       ((Length(WrkStr) > 0) and
        (WrkStr[1] in ['1','2'])) then
      Getting := False;
  end;
  If FKey = F10 then
    EXIT;

  If FKey <> Esc then begin
    ClearViewPort;

    SetLineStyle(0,0,1);
    DrawBox(0,0,TitleWidth+(2*Delta-1),(13*TitleHeight)+(2*Delta),GetMaxColor);

    SetTextJustify(LeftText,TopText);
    MoveTo(8,TitleHeight + Delta);
    If WrkStr[1] = '1' then begin
      OutText('Distance Increment?  ');
      {MoveTo(8,BRY-TLY - Delta-3);}
      MoveTo(8,BRY-TLY - 2*Delta);
      Str(TPDis:5:0,WrkStr);
      WrkStr := 'Total Distance = ' + WrkStr;
      OutText(WrkStr);
      MoveTo((BRX-TLX) div 2,(BRY-TLY) div 2);
      WrkStr := '';
      FKey := Input(0,0,1,4,WrkStr,False);
      If ((FKey = Esc) or (Fkey = F10)) then
        Exit;
      Val(WrkStr,DL,Code);
      If DL > 0 then begin
        NRec := Trunc(TPDis / DL);
        If NRec > NRMax then
          NRec := NRMax;
      end;
    end
    else If WrkStr[1] = '2' then begin
      OutText('Number of Receptors? ');
      MoveTo((BRX-TLX) div 2,(BRY-TLY) div 2);
      WrkStr := '';
      FKey := Input(0,0,1,3,WrkStr,False);
      If ((FKey = Esc) or (Fkey = F10)) then
        Exit;
      Val(WrkStr,NRec,Code);
      If NRec > NRMax then
        NRec := NRMax;
      If NRec = 0 then
        DL := 0
      else
        DL := TPDis / NRec;
    end;
  end;
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipON);
  PutImage(TLX,TLY,MenuPtr^,NormalPut);
End;    { GetReceptorSpacing }


PROCEDURE DisplayElevations;
Var
  S        : Array [1..4] of Str30;
  MiddleX,
  MiddleY, TitleWidth,TitleHeight,
  TLX,TLY,
  BRX,BRY,
  MidX,MidY,
  Delta,
  Row,
  I    : Integer;

Begin
  S[1] := '    Contour Elevations    ';
  S[2] := ' (in user vertical units) ';
  S[3] := '';
  S[4] := ' Press ENTER to continue. ';

  If GraphDriver in [EGA,EGA64,EGAMono,VGA] then begin
    Delta := 12;
    SetTextStyle(SmallFont,HorizDir,5);
   end
   else begin
    Delta := 8;
    SetTextStyle(SmallFont,HorizDir,4);
   end;

  TitleWidth := TextWidth(S[1]);
  TitleHeight:= TextHeight(S[1]);
  SetTextJustify(CenterText,TopText);

  TLX := GetMaxX - TitleWidth + 2;
  TLY := 2;
  BRX := GetMaxX - 2;
  BRY := (NC1+8)*TitleHeight+2;

  If not GotDisplayElevMem then begin
                   {   Save the window on the heap  }
    DispElevSize := ImageSize(TLX,TLY,BRX,BRY);
    GetMem(DispElevPtr,DispElevSize);
    If (DispElevPtr = nil) then begin
      RestoreCRTmode;
      Write('Insufficient memory.');
      Readln;
      EraseMsg;
      GotDisplayElevMem := False;
     end
     else GotDisplayElevMem := True;
   end;

  GetImage(TLX,TLY,BRX,BRY,DispElevPtr^);

  SetViewPort(TLX,TLY,BRX,BRY,ClipOff);
  ClearViewPort;

  SetLineStyle(0,0,1);
  DrawBox(0,0,GetMaxX,(NC1+8)*TitleHeight,GetMaxColor);

  MidX := TitleWidth div 2;
  MidY := (BRY - TLY) div 2;
  SetTextJustify(CenterText,TopText);
  For Row := 1 to 4 do
    OutTextXY(MidX, Row * TitleHeight, S[Row]);
  For Row := 1 to NC1 do
    OutTextXY(MidX, (Row * TitleHeight) + (6*TitleHeight),HConStr[Row]);
  Readln;
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipON);
  PutImage(TLX,TLY,DispElevPtr^,NormalPut);

End;    { DisplayElevations }


PROCEDURE GetReceptorElevation;
Var
  S        : Array [1..3] of String[50];
  MiddleX,
  MiddleY, TitleWidth,TitleHeight,
  TLX,TLY,
  BRX,BRY,
  MidX,MidY,
  Delta,
  Row,
  I    : Integer;

Begin
  S[1] := '     Enter ground elevation of receptor      ';
  S[2] := '          (in user vertical units)           ';
  S[3] := ' F3 - List Elevations  Esc - Back  F10 - DOS ';

  If GraphDriver in [EGA,EGA64,EGAMono,VGA] then begin
    Delta := 12;
    SetTextStyle(SmallFont,HorizDir,5);
   end
   else begin
    Delta := 8;
    SetTextStyle(SmallFont,HorizDir,4);
   end;

  TitleWidth := TextWidth(S[1]);
  TitleHeight:= TextHeight(S[1]);
  SetTextJustify(CenterText,TopText);
  MiddleX := GetMaxX div 2;
  MiddleY := GetMaxY div 2;

  TLX := MiddleX - (TitleWidth div 2) - Delta;
  TLY := MiddleY - (8 * TitleHeight + Delta);
  BRX := MiddleX + (TitleWidth div 2) + Delta;
  BRY := MiddleY + (8 * TitleHeight + Delta);

  If not GotElevMem then begin
                   {   Save the window on the heap  }
    ElevSize := ImageSize(TLX,TLY,BRX,BRY);
    GetMem(ElevPtr,ElevSize);
    If (ElevPtr = nil) then begin
      RestoreCRTmode;
      Write('Insufficient memory.');
      Readln;
      EraseMsg;
      GotElevMem := False;
     end
     else GotElevMem := True;
   end;

  GetImage(TLX,TLY,BRX,BRY,ElevPtr^);

  SetViewPort(TLX,TLY,BRX,BRY,ClipOff);
  ClearViewPort;

  SetLineStyle(0,0,1);
  DrawBox(0,0,TitleWidth+(2*Delta-1),(16*TitleHeight)+(2*Delta),GetMaxColor);

  MidX := TitleWidth div 2;
  MidY := (BRY - TLY) div 2;
  SetTextJustify(CenterText,TopText);
  SetColor(Yellow);
  For Row := 1 to 3 do
    OutTextXY(MidX+Delta, (Row-1) * (TitleHeight + Delta) + Delta, S[Row]);

  SetTextJustify(LeftText,TopText);
  MoveTo((BRX-TLX) div 2,BRY-TLY-Delta);
  WrkStr := '';
  While WrkStr = '' do begin
    FKey := Input(0,0,1,8,WrkStr,False);
    Case FKey of
      F10  :  begin
                RestoreCRTMode;
                ExitToDos;
              end;
      F3   :  begin
                SetViewPort(0,0,GetMaxX,GetMaxY,ClipOn);
                DisplayElevations;
                SetTextJustify(LeftText,TopText);
                SetViewPort(TLX,TLY,BRX,BRY,ClipOff);
              end;
      Esc  :  WrkStr := 'X';
      else
        Val(WrkStr,Z,Code);
    end;
  end;
  SetColor(LightGray);
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipON);
  PutImage(TLX,TLY,ElevPtr^,NormalPut);
End;    { GetReceptorElevation }


PROCEDURE Center(Msg : Str80; LC : Integer; FHue,BHue : Word);
Var
  I : Integer;
Begin
  Color(FHue,BHue);
  GoToXY((80-Length(Msg)) Div 2,LC);
  Write(Msg);
End;    { Center }




PROCEDURE DisplayHelp;
Begin
  SaveTheScreen;
  RestoreCRTMode;
  ModeIsText := True;

  MenuHeading(False);
  Center('Help Screen',2,Yellow,Black);
  Color(LightGray,Black);
  Writeln;
  Writeln;
  Writeln(' Moves: Left,Right,Up,Down  -  Move marker one point Horiz or Vert.');
  Writeln('        Home,End,PgUp,PgDn  -  Move diagonally one point.');
  Writeln('        CtrlLeft,CtrlRight  -  Move Left or Right six points.');
  Writeln('        CtrlHome,CtrlEnd    -  Move Marker Diagonally six points.');
  Writeln('        CtrlPgUp,CtrlPgDn');
  Writeln;
  Writeln(' Others:   Esc   -  Back to start of program');
  Writeln('           F1    -  This HELP screen');
  Writeln('           F2    -  Repaint the Graphic screen');
  Writeln('           F3    -  Display a list of the contour elevations');
  Writeln('           F8    -  End edit session and save modifications to file');
  Writeln('           F10   -  Exit to DOS');
  Writeln('           Ins   -  INSERT a receptor at the current marker position');
  Writeln('           Del   -  Press ONCE to highlight the CLOSEST receptor to the');
  Writeln('                    marker.  (Message appears at bottom of screen.) The');
  Writeln('                    receptor number and user coordinates of the highlighted');
  Writeln('                    receptor appear in a window at the bottom-left corner');
  Writeln('                    of the screen.  Press AGAIN to DELETE the highlighted');
  Writeln('                    receptor. Any other key cancels the delete process.');
  Writeln;
  Center('Press ENTER to continue.',24,Yellow,Black);
  Color(LightGray,Black);
  FKey := Input(0,0,1,0,WrkStr,True);

  SetGraphMode(GraphMode);            { Let's get to back to graphics }
  ModeIsText    := False;
  RestoreTheScreen;
End;    { DisplayHelp }


PROCEDURE GetARCTFile;
Begin
  MsgStr := 'Receptor';
  If HillName = '' then begin
    I := 1;
    While ThePLTFile[I] <> '.' do begin               { Parse off the hill name }
      HillName := HillName + ThePLTFile[I];
      Inc(I);
    end;
  end;
  GetAFile(RCTFiles,RCTNames,HillName,MsgStr,MyIdx,0);
  If (FKey = Esc) or (FKey = F10) then EXIT;
  Assign(RCTFile,'\CTDM\FILES\'+RCTNames[MyIdx+1]);
  TheRCTFile := RCTNames[MyIDx+1];
  SetTextBuf(RCTFile,RCTBuf);
  Reset(RCTFile);
  WrkStr := '';
  Delim := ' ';
  NumRT := 0;
  While (not EOF(RCTFile)) do begin
    Readln(RCTFile,BigLine);
    Ptr := 21;                   { Bypass the Hill Name & NumRT }
    Inc(NumRT);

    Parse(Ptr,Delim,BigLine,WrkStr);       { X coord }
    If WrkStr[Length(WrkStr)] = '.' then
    WrkStr := WrkStr + '0';
    Val(WrkStr,Receptors[NumRT].X,Code);

    Parse(Ptr,Delim,BigLine,WrkStr);       { Y coord }
    If WrkStr[Length(WrkStr)] = '.' then
      WrkStr := WrkStr + '0';
    Val(WrkStr,Receptors[NumRT].Y,Code);

    Ptr := 51;                             { Bypass the Z coord }
    Parse(Ptr,Delim,BigLine,WrkStr);       { Ground Elev }
    If WrkStr[Length(WrkStr)] = '.' then
      WrkStr := WrkStr + '0';
    Val(WrkStr,Receptors[NumRT].Z,Code);
  end;
  Close(RCTFile);
End;    { GetARCTFile }


PROCEDURE Deleting(Toggle : Boolean);    { Display/blank the DELETING message }
Var
  I,J,K,L,
  Middle, TitleWidth,TitleHeight : Integer;
Begin
  S := 'Deleting';
  SetTextStyle(DefaultFont,0,0);
  TitleWidth := TextWidth(S);
  TitleHeight:= TextHeight(S);
  SetTextJustify(CenterText,TopText);
  Middle := GetMaxX div 2;
  If Toggle then                                  { If TRUE, Show the message }
    OutTextXY(Middle,GetMaxY - TitleHeight - 2,S)
   else begin                                   { If FALSE, blank the message }
    SetFillStyle(SolidFill,Black);
    SetTextStyle(DefaultFont,0,0);
    TitleHeight := TextHeight('M');
    TitleWidth  := TextWidth(S);
    I := Middle - TitleWidth Div 2;
    J := GetMaxY - TitleHeight - 2;
    K := Middle + TitleWidth Div 2;
    L := GetMaxY - 2;
    Bar(I,J,K,L);
   end;
End;    { Deleting }


PROCEDURE SetAddSettings;
Begin
  Case GraphDriver of
    CGA      :  Begin
                  If GraphMode = 4 then begin        { High Res }
                    IRad  := 4;
                    ContourHigh := White;
                    ContourLow  := White;
                    CHRad       := IRad + 3;    { Radius for current receptor }
                    CrossXOff   := 11;
                    CrossYOff   := 6;
                    CrossXLen   := 21;
                    CrossYLen   := 11;
                   end
                   else begin                        { Low Res }
                    IRad  := 3;
                    ContourHigh := 2;
                    ContourLow  := 3;
                    CHRad       := IRad + 1;    { Radius for current receptor }
                    CrossXOff   := 6;
                    CrossYOff   := 6;
                    CrossXLen   := 11;
                    CrossYLen   := 11;
                   end;
                 end;
    HercMono :  Begin
                  IRad  := 4;
                  ContourHigh := White;
                  ContourLow  := White;
                  CHRad       := IRad + 3;      { Radius for current receptor }
                  CrossXOff   := 11;
                  CrossYOff   := 9;
                  CrossXLen   := 21;
                  CrossYLen   := 17;
                 end;
    EGA,EGA64,
    EGAMono  :  Begin
                  IRad  := 4;
                  ContourHigh := LightRed;
                  ContourLow  := Yellow;
                  CHRad       := IRad + 3;    { Radius for current receptor }
                  CrossXOff   := 10;
                  CrossYOff   := 9;
                  CrossXLen   := 19;
                  CrossYLen   := 17;
                 end;
    VGA      :  Begin
                  IRad  := 3;
                  ContourHigh := LightRed;
                  ContourLow  := Yellow;
                  CHRad       := IRad + 2;    { Radius for current receptor }
                  CrossXOff   := 11;
                  CrossYOff   := 10;
                  CrossXLen   := 21;
                  CrossYLen   := 19;
                 end;
   end;
End;    { SetAddSettings }


PROCEDURE DisplayCursor(X,Y : Integer);
Begin
  PutImage(X-CrossXOff+1,Y-CrossYOff+1,Cross^,XORPut);
End;    { DisplayCursor }


PROCEDURE DrawContour(ContourNbr,Hue,Style : Integer);
Var
  I : Integer;
Begin
  If Style = DottedLn then
    SetLineStyle(UserBitLn,$1111,Normwidth)
   else
    SetLineStyle(Style,0,NormWidth);       { Select dotted lines for contours }
  SetColor(Hue);
  NPC := Contours[ContourNbr];           { Find # of points in THIS contour }
  CSIndex := 0;
  For I := 1 to ContourNbr-1 do
    CSIndex := CSIndex + Contours[I];
  Inc(CSIndex);
  If ContourSeg > NPC-1 then
    ContourSeg := NPC-1;             { Stay inside the current contour        }
  CSStart := CSIndex;                { Save the starting point for the cursor }
  LineX := ContourSegments[CSIndex].X;
  LineY := ContourSegments[CSIndex].Y;
  MoveTo(LineX,LineY);                           { Go to the starting point }
  PutPixel(LineX,LineY,MaxColor);
  X1 := LineX;
  Y1 := LineY;
  XOld := LineX;
  YOld := LineY;
  DupFlg := 0;
  IFR := 0;
  For I := CSIndex+1 to (CSIndex+NPC-1) do begin
    If (IFR < 2) or (Abs(LineX - X1) > 1.0E-15) or
                    (Abs(LineY - Y1) > 1.0E-15) then begin
      LineX := ContourSegments[I].X;
      LineY := ContourSegments[I].Y;
      If DupFlg <> 0 then begin
        XOld := LineX;
        YOld := LineY;
        DupFlg := 0;
        MoveTo(LineX,LineY);
        PutPixel(LineX,LineY,MaxColor);
      end
      else begin
        If (Abs(LineX - XOld) < 1.0E-15) and
           (Abs(LineY - YOld) < 1.0E-15) then begin
          DupFlg := 1;
          Inc(IFR);
        end;
        LineTo(LineX,LineY);
      end;
    end;
   end;
End;    { DrawContour }


PROCEDURE RecInfo(Display : Boolean);
Var
  ZI,ZJ,
  ZK,ZL,
  TitleWidth,
  TitleHeight   :  Integer;
Begin
  If Display then
    SetColor(GetMaxColor)
  else
    SetColor(Black);
  SetLineStyle(0,0,1);
  SetFillStyle(SolidFill,Black);
  SetTextStyle(2,0,0);
  TitleHeight := TextHeight('M');
  TitleWidth  := TextWidth('X = ZZZZZZ.00');
  SetTextJustify(LeftText,TopText);
  Rectangle(2,GetMaxY-4*TextHeight('M')-6,TextWidth('X = 000000.00')+6,GetMaxY+2);
  ZI := 2;
  ZJ := GetMaxY - 4*(TitleHeight) - 2;
  ZK := TitleWidth + 2;
  ZL := GetMaxY - 2;
  Bar(ZI,ZJ,ZK,ZL);
  Str(K:4,BigLine);                      { K is the current receptor number }
  WrkStr := 'R = ' + BigLine;
  OutTextXY(4,GetMaxY - 4*(TitleHeight) - 2,WrkStr);
  Str(Receptors[K].X:9:2,BigLine);
  WrkStr := 'X = ' + BigLine;
  OutTextXY(4,GetMaxY - 3*(TitleHeight) - 2,WrkStr);
  Str(Receptors[K].Y:9:2,BigLine);
  WrkStr := 'Y = ' + BigLine;
  OutTextXY(4,GetMaxY - 2*(TitleHeight) - 2,WrkStr);
  Str(Receptors[K].Z:9:2,BigLine);
  WrkStr := 'Z = ' + BigLine;
  OutTextXY(4,GetMaxY - TitleHeight - 2,WrkStr);
  SetColor(GetMaxColor);
end;     { RecInfo }


PROCEDURE DisplayReceptor(X,Y : Real;
                          Rad : Integer;
                          Hue : Word);
Var
  LeadWidth,
  IntXP,IntYP : Integer;
Begin
  IntXP := Trunc(SCRCX + (X - XC) * DSCRXDDD);
  IntYP := Trunc(SCRCY - (Y - YC) * DSCRYDDD);

  SetColor(GetMaxColor);
  SetFillStyle(SolidFill,GetMaxColor);
  Circle(IntXP,IntYP,Rad);
  FloodFill(IntXP,IntYP,GetMaxColor);

  SetColor(Hue);
  Circle(IntXP,IntYP,Rad);

{     If Hue is NOT = to the background color, we have been asked to draw a
      receptor in some color.  In order to insure that the FLOODFILL command
      will completely fill the new circle (we might be drawing a receptor
      with a larger radius than the existing receptor) we first draw a black
      cross through the existing receptor then draw the new circle.  The
      cross allows the fill color to leak through to all points inside the
      new circle.
}
  If Hue <> GetBKColor then begin
    If not Loading then begin
      SetColor(GetBKColor);
      SetLineStyle(SolidLn,0,1);
      Line(IntXP-Rad,IntYP,IntXP+Rad,IntYP);      { Draw the cross horizontal }
      Line(IntXP,IntYP-Rad,IntXP,IntYP+Rad);      { Fraw the cross vertical }
      SetColor(Hue);                              { Set the circle's color  }
      Circle(IntXP,IntYP,Rad);                    { and draw the new circle }
     end;
{    If GraphDriver <> CGA then begin
      For ZI := IntXP-1 to IntXP+1 do
        For ZJ := IntYP-1 to IntYP+1 do
          PutPixel(ZI,ZJ,0)
     end
     else}
     PutPixel(IntXP,IntYP,0);
   end;

  SetFillStyle(SolidFill,Hue);
  FloodFill(IntXP,IntYP,Hue);
  SetColor(GetMaxColor);
End;    { DisplayReceptor }


PROCEDURE DeleteReceptor(ReceptorNbr : Integer);
Var
  I : Integer;
Begin
  If NumRT > 1 then begin
    DisplayReceptor(Receptors[ReceptorNbr].X,Receptors[ReceptorNbr].Y,CHRad,GetBkColor);
    For I := ReceptorNbr to NumRT do
      Receptors[I] := Receptors[I + 1];
    Dec(NumRT);
   end;
  Deleting(False);                         { Blank out the message       }
  Modified := True;                        { Force write of new RCT file }
End;    { DeleteReceptor }


PROCEDURE GoToClosestReceptor;
Var
  I,
  HReceptor : Integer;

  X,Y,
  HDistance,
  Distance   : Real;
Begin
  HDistance := 99999.9;                       { Initialize the saved distance }
  HReceptor := 9999;                          { And the saved receptor number }

  X := XC + (PosX-SCRCX) / DSCRXDDD;      { Convert the absolute X,Y to Reals }
  Y := YC - (PosY-SCRCY) / DSCRYDDD;

  For I := 1 to NumRT do begin                { Loop through all receptors    }
    Distance := Sqrt(Sqr(Receptors[I].X - X) + Sqr(Receptors[I].Y - Y));
    If Distance < HDistance then begin
      HDistance := Distance;                 { Save the new lowest distance   }
      HReceptor := I;                        { and the corresponding receptor }
     end;
   end;
  K := HReceptor;                            { Reset current receptor pointer }
  DisplayReceptor(Receptors[K].X,Receptors[K].Y,CHRad,ContourHigh); { Highlight suspect receptor     }
  RecInfo(True);                             { Display coordinates }
  Deleting(True);                            { Display message                }
End;    { GoToClosestReceptor }


PROCEDURE InsertReceptor(ReceptorNbr : Integer);
Var
  I : Integer;
  X,Y : Real;

Begin

  X := XC + (PosX-SCRCX) / DSCRXDDD;      { Convert the absolute X,Y to Reals }
  Y := YC - (PosY-SCRCY) / DSCRYDDD;

  GetReceptorElevation;
  If FKey <> Esc then begin
    Inc(NumRT);                              { Total number of receptors   }
    Receptors[NumRT].X := X;
    Receptors[NumRT].Y := Y;
    Receptors[NumRT].Z := Z;
    DisplayReceptor(X,Y,IRad,GetMaxColor);

    Modified := True;                        { Force write of new RCT file }
  end;
  FKey := 0;
End;    { InsertReceptor }


PROCEDURE RepaintGraphicScreen;
Begin
  ClearViewport;
  SetColor(GetMaxColor);
  If GraphDriver = CGA then
    SetLineStyle(Solidln,0,NormWidth)
  else
    SetLineStyle(Solidln,0,ThickWidth);
  Rectangle(0,0,GetMaxX,GetMaxY);               { Put a box around everything }
  SetLineStyle(Solidln,0,NormWidth);
  SetTextStyle(2,0,0);

  DisplayTitle;                                       { At the top center }

  SetColor(ContourHigh);
  For I := 1 to NC1 do                                  { Redraw the contours }
    DrawContour(I,ContourLow,DottedLn);
                                        {  Now we must draw all the receptors }
  Loading := True;                      { Turn off display of receptor loc }
  For I := 1 to NumRT do
    DisplayReceptor(Receptors[I].X,Receptors[I].Y,IRad,GetMaxColor);
  Loading := False;
                               {   Put a little box at the hill center  }
  SetLineStyle(Solidln,0,NormWidth);
  Rectangle(Trunc(XUL), Trunc(YUL), Trunc(XLR), Trunc(YLR));
End;    { Repaint GraphicScreen }

{ ================================================================ }

Begin
  HeapError := @HeapFunc;

  Path := '\CTDM\TERRAIN\';
  HeadLine := '';

  For I := 1 to LineSize do
    BlankLine[I] := ' ';

  Delim  := ' ';

  F      := ' RECGEN ';

  GotReceptorMenuMem := False;
  GotElevMem         := False;
  GotDisplayElevMem  := False;

  If ParamCount > 0 then
    HillName := ParamStr(1)
  else
    HillName := '';

  If RegisterBGIdriver(@HercDriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@CGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIdriver(@EVGADriver) < 0 then Writeln(GraphErrorMsg(GraphResult));

  If RegisterBGIFont(@LittFont) < 0 then Writeln(GraphErrorMsg(GraphResult));

  GraphDriver := Detect;

  DoneInitGraph := False;
  GotIARMem     := False;

  Looping := True;
  While Looping do begin

MainEntry:
    If DoneInitGraph then begin
      CloseGraph;
      DoneInitGraph := False;
    end;

    ModeIsText  := True;

    NewOrOldMenu;                 { start a new file or edit an existing one }
    WrkStr := '';
    FKey := 0;
    While (WrkStr <> '1') and (WrkStr <> '2') and
          (FKey <> Esc) and (FKey <> F10) do
      FKey := Input(24,16,1,0,WrkStr,True);
    If FKey = F10 then ExittoDos;
    If FKey = Esc then begin
      Looping := False;
      Exit;
    end;
    If WrkStr = '1' then
      NewRecFile := True
    else
      NewRecFile := False;

PlotFileEntry:
    FKey := 0;
    LoadNames('\CTDM\TERRAIN\','*.PLT',PLTFiles,PLTNames);

    ThePLTFile := '';
    While ThePLTFile = '' do begin
      MenuHeading(False);
      WrkStr := '';
      GetAPLTFile;
      If FKey = F10 then
        ExitToDos;
      If FKey = Esc then
        GoTo MainEntry;
    end;

    If not NewRecFile then begin
      LoadNames('\CTDM\FILES\','*.RCT',RCTFiles,RCTNames);

      TheRCTFile := '';
      While TheRCTFile = '' do begin
        MenuHeading(False);
        WrkStr := '';
        GetARCTFile;
        If FKey = F10 then
          ExitToDos;
        If FKey = Esc then begin
          HillName := '';
          GoTo PlotfileEntry;
        end;
      end;
    end
    else begin
RCTFileEntry:
      Color(LightGray,Black);
      ClrScr;
      MenuHeading(False);
      DoEscOrF10;
      WriteStr(9,10,'Please enter the name of the Receptor Output File-> ');
      WrkStr := '';
      FKey := Input(WhereX,WhereY,1,8,WrkStr,True);
      If FKey = F10 then                     { Test Return code after getting }
        ExitToDos;
      If FKey = Esc then GoTo PlotFileEntry;
      Trim(WrkStr);
      TheRCTFile := WrkStr + '.RCT';                  { Assume a RCT }
      BigLine := '\CTDM\FILES\'+TheRCTFile;
      If FileExists(BigLine) then begin
        Color(Yellow,Black);
        WriteStr(9,12,'That receptor file already exists!  Do you want to overwrite it?');
        Color(LightGray,Black);
        WrkStr := '';
        FKey := Input(0,0,1,0,WrkStr,True);
        If FKey = F10 then
          ExitToDos;
        If FKey = Esc then GoTo RCTFileEntry;
        If UpCase(WrkStr[1]) = 'Y' then begin
          Assign(RCTFile,BigLine);
          SetTextBuf(RCTFile,RCTBuf);
          Rewrite(RCTFile);
        end
        else GoTo RCTFileEntry;
      end
      else begin
        Assign(RCTFile,BigLine);
        Rewrite(RCTFile);
      end;
    end;  { If not NewRec }
  {
    Now determine the type of display we are using.  If CGA, ask the user
    if we are to use Low Res (in color) or Hi-Res (B&W).
  }

    DetectGraph(GraphDriver,GraphMode);

    If GraphDriver = CGA then begin
      DisplayResMenu;
      WrkStr := '';
      While (WrkStr <> '1') and (WrkStr <> '2') and
            (FKey <> Esc) and (FKey <> F10) do
        FKey := Input(24,16,1,0,WrkStr,True);
      If FKEy = F10 then ExittoDos;
      If FKey = Esc then begin
        FKey := 0;
        GoTo MainEntry;
      end;
      If WrkStr = '1' then GraphMode := CGAC0
       else GraphMode := CGAHI
    end;

  {
    Set up the plot boundaries, scale factors and colors based
    on GraphDriver and GraphMode.
  }
    DetermineBoundaries;
    SetAddSettings;

    XC := (XMin1 + XMax1) / 2;
    YC := (YMin1 + YMax1) / 2;
    DX := XMax1 - XMin1;
    DY := YMax1 - YMin1;
    If (DX / DY) < Ratio then DD := DY
      else DD := DX / Ratio;
    DSCRXDDD := DSCRX / DD;
    DSCRYDDD := DSCRY / DD;

    If NewRecFile then begin
      ThePDFFile := 'DUMMY.PDF';                      {create a dummy PDF file}
      Assign(PDFFile,Path + ThePDFFile);
      SetTextBuf(PDFFile,PDFBuf);

      InitGraph(GraphDriver,GraphMode,'');            { Let's get to graphics }
      MaxColor := GetMaxColor;

      DoneInitGraph := True;
      ModeIsText    := False;

      SetColor(GetMaxColor);

      If (GraphDriver = CGA) and (GraphMode = CGAC0) then begin
        SetColor(1);
      end;
      If GraphDriver in [EGA,EGA64,VGA] then begin
        SetColor(15);
      end;
      If GraphDriver <> CGA then
        SetLineStyle(Solidln,0,ThickWidth);

      Rectangle(0,0,GetMaxX,GetMaxY);           { Put a box around everything }

      DisplayTitle;                                       { At the top center }

      XSHC := SCRCX + (XHTOP - XC) * DSCRXDDD;
      YSHC := SCRCY - (YHTOP - YC) * DSCRYDDD;

      XUL := XSHC - 1;  XLR := XSHC + 1;
      YUL := YSHC - 1;  YLR := YSHC + 1;

      If GraphDriver <> CGA then begin             { Slightly bigger }
        XUL := XUL - 1;  XLR := XLR + 1;
        YUL := YUL - 1;  YLR := YLR + 1;
      end;

  {   Put a little box at the hill center  }
      Rectangle(Trunc(XUL), Trunc(YUL), Trunc(XLR), Trunc(YLR));
      PressEnter(True);

      NumRT := 0;                                     { Set Receptor total to 0 }
      For J := 1 to NC1 do begin                        { Loop through contours }
        Rewrite(PDFFile);
        SetLineStyle(DottedLn,0,NormWidth);    { Select dotted lines for contours }
        If (GraphDriver = CGA) and (GraphMode = CGAC0) then
          SetColor(3)                              { Select Yellow for contours }
         else
          If GraphDriver = VGA then
            SetColor(Yellow)
           else
            SetColor(GetMaxColor);
        TPDis := 0.0;                         { Zap the total distance traveled }
        Readln(PLTFile,BigLine);           { Load contour points and elevation }

                  {  Initialize the string pointer and parse off NPC and HCon }
        Ptr := 1;
        ParseToInt(NPC);
        ParseToFloat(HCon);
        Str(Hcon:10:1,HConStr[J]);
        Trim(HConStr[J]); LTrim(HConStr[J]);

        Readln(PLTFile,BigLine);              { Load initial contour coordinates }
        Ptr := 1;
        ParseToFloat(X1);
        ParseToFloat(Y1);
        Writeln(PDFFile,X1:20:5,Y1:20:5,TPDis:20:5);
        XB := X1;
        YB := Y1;

        XOld   := X1;
        YOld   := Y1;
        DupFlg := 0;
        XS1 := SCRCX + (X1 - XC) * DSCRXDDD;
        YS1 := SCRCY - (Y1 - YC) * DSCRYDDD;
        MoveTo(Trunc(XS1), Trunc(YS1));              { Go to the starting point }
        PutPixel(Trunc(XS1), Trunc(YS1), MaxColor);
        IFR := 0;

        For K := 2 to NPC do begin
          Readln(PLTFile,BigLine);                  { Load contour coordinates }
          Ptr := 1;
          ParseToFloat(X);
          ParseToFloat(Y);

          If (IFR < 2) or (Abs(X - X1) > 1.0E-15) or
                        (Abs(Y - Y1) > 1.0E-15) then begin
            XS := SCRCX + (X - XC) * DSCRXDDD;
            YS := SCRCY - (Y - YC) * DSCRYDDD;
            If DupFlg <> 0 then begin
              XOld := X;
              YOld := Y;
              DupFlg := 0;
              MoveTo(Trunc(XS), Trunc(YS));
              PutPixel(Trunc(XS), Trunc(YS), MaxColor);
              Writeln(PDFFile,X:20:5,Y:20:5,TPDis:20:5);
              XB := X;
              YB := Y;
            end
            else begin
              If (Abs(X - XOld) < 1.0E-15) and
                 (Abs(Y - YOld) < 1.0E-15) then begin
                DupFlg := 1;
                Inc(IFR);
              end;
              LineTo(Trunc(XS),Trunc(YS));
              DL1 := Sqrt(Sqr(X-XB) + Sqr(Y-YB) + 1.0E-15);
              XB := X;
              YB := Y;
              TPDis := TPDis + DL1;
              Writeln(PDFFile,X:20:5,Y:20:5,TPDis:20:5);
            end;
          end
          else begin
            Writeln(PDFFile,X:20:5,Y:20:5,TPDis:20:5);
            XB := X;
            YB := Y;
          end;
        end;         { end of looping through contour points via K }

        Readln(PLTFile,BigLine);                    { Load contour coordinates }
        Ptr := 1;
        ParseToInt(NPC);
        For K := 1 to NPC do
          Readln(PLTFile,BigLine);                    { Bypass edited contours }

        FKey := Input(0,0,1,0,WrkStr,False);
        If FKey = F10 then
          ExitToDos;
        If FKey = Esc then begin
          RestoreCRTMode;
          GoTo MainEntry;
        end;

        SavetheScreen;         { Save the screen in case we have to back up }
        Satisfied := False;

        While not Satisfied do begin
          NeedSpacing := True;
          While NeedSpacing do begin
            GetReceptorSpacing;
            PressEnter(True);
            If FKey = F10 then
              ExitToDos;
            If FKey = Esc then begin
              FKey := Input(0,0,1,0,WrkStr,False);
              If FKey = F10 then begin
                RestoreCRTMode;
                ExitToDos;
              end;
              If FKey = Esc then begin
                RestoreCRTMode;
                GoTo MainEntry;
              end;
            end
            else
              NeedSpacing := False;
          end;
                                      {  Now we must draw all the receptors }
          Reset(PDFFile);                { Back to the beginning of the file }
          NPTS := 0 ;                      { Zap nbr of digitized contour points  }
          NumR := 1;                       { Nbr Receptors for this contour to 1       }
          If NRec > 0 then begin
            Readln(PDFFile,BigLine);        { Load contour points and elevation }
            Ptr := 1;
            ParseToFloat(X);
            ParseToFloat(Y);
            ParseToFloat(PD);
            Inc(NPTS);                     { Increment number of points read      }
            XLast  := X;                   { Save the previous point's parms      }
            YLast  := Y;
            PDLast := PD;
            DisplayRec(X,Y);          { Display the first receptor           }
            Inc(NumRT);
            Receptors[NumRT].X := X;
            Receptors[NumRT].Y := Y;
            Receptors[NumRT].Z := HCon;
            Inc(NumR);
            While NumR <= NRec do begin
              DistR := (NumR - 1) * DL;
              While DistR > PD do begin
                XLast  := X;
                YLast  := Y;
                PDLast := PD;
                Readln(PDFFile,BigLine);    { Load contour points and Perimeter }
                Ptr := 1;
                ParseToFloat(X);
                ParseToFloat(Y);
                ParseToFloat(PD);
                Inc(NPTS);                    { Increment number of points read   }
              end;

              If (PD - PDLast) > 0 then
                Fact := (DistR - PDLast) / (PD - PDLast)
              else
                Fact := 0.0;

              XR := Fact * (X - XLast) + XLast;
              YR := Fact * (Y - YLast) + YLast;
              DisplayRec(XR,YR);
              Inc(NumRt);
              Receptors[NumRT].X := XR;
              Receptors[NumRT].Y := YR;
              Receptors[NumRT].Z := HCon;
              Inc(NumR);
            end;
            For K := NPTS + 1 to NPC do                 { Bypass remaining points }
              Readln(PDFFile,BigLine);
          end
          else begin
            For K := NPTS + 1 to NPC do                 { Bypass remaining points }
              Readln(PDFFile,BigLine);
          end;  { If NRec }

          FKey := 0;
          WrkStr := '';

          FKey := Input(0,0,1,0,WrkStr,False);
          If FKey = F10 then begin
             RestoreCRTMode;
             ExitToDos;
          end
          else
           If Fkey = Esc then begin
             RestoretheScreen;
             NumRT := NumRT - NumR +1;
           end
          else
           Satisfied := True;
        end;      { While not satisfied }
      end;       { For J - loop over contours }

              { Write receptors to file }
      WrkStr := PlotHillName + Spaces(12-Length(PlotHillName));
      For J := 1 to NumRT do begin
        X := Receptors[J].X;
        Y := Receptors[J].Y;
        Z := Receptors[J].Z;
        Writeln(RCTFile,WrkStr,J:4,'    ',X:10:2,Y:10:2,Zero:10:2,Z:10:2,PlotHillID:5);
      end;
      Close(PDFFile);
      Close(RCTFile);
      RestoreCRTMode;
    end   { NewRecFile}
    else begin
      InitGraph(GraphDriver,GraphMode,'');            { Let's get to graphics }
      MaxColor := GetMaxColor;
      DoneInitGraph := True;
      ModeIsText    := False;
      Modified := False;

      SetColor(GetMaxColor);
      Line(1,CrossYOff,CrossXLen,CrossYOff);
      Line(CrossXOff,1,CrossXOff,CrossYLen);

      Size := ImageSize(1,1,CrossXLen,CrossYLen);
      GetMem(Cross,Size);
      GetImage(1,1,CrossXLen,CrossYLen,Cross^);
      PutImage(1,1,Cross^,XORPut);

      If (GraphDriver = CGA) and (GraphMode = CGAC0) then
        SetColor(1);
      If GraphDriver in [EGA,EGA64,VGA] then
        SetColor(15);
      If GraphDriver <> CGA then
        SetLineStyle(Solidln,0,ThickWidth);

      Rectangle(0,0,GetMaxX,GetMaxY);           { Put a box around everything }
      SetLineStyle(Solidln,0,NormWidth);
      SetTextStyle(2,0,0);

      DisplayTitle;                                       { At the top center }

      XSHC := SCRCX + (XHTOP - XC) * DSCRXDDD;
      YSHC := SCRCY - (YHTOP - YC) * DSCRYDDD;

      XUL := XSHC - 1;  XLR := XSHC + 1;
      YUL := YSHC - 1;  YLR := YSHC + 1;

      If GraphDriver <> CGA then begin             { Slightly bigger }
        XUL := XUL - 1;  XLR := XLR + 1;
        YUL := YUL - 1;  YLR := YLR + 1;
      end;

                                   {   Put a little box at the hill center  }
      Rectangle(Trunc(XUL), Trunc(YUL), Trunc(XLR), Trunc(YLR));

      CSIndex := 0;                         { Init the Contour Segment Index }

      SetLineStyle(4,$1111,NormWidth);       { Select dotted lines for contours }
      SetColor(ContourLow);
      For J := 1 to NC1 do begin                        { Loop through contours }
        Readln(PLTFile,BigLine);         { Load contour points and elevation   }

                  {  Initialize the string pointer and parse off NPC and HCon }
        Ptr := 1;
        Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,NPC,Code);
        Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,HCon,Code);
        Str(Hcon:10:1,HConStr[J]);
        Trim(HConStr[J]); LTrim(HConStr[J]);

        Contours[J] := NPC;               { Save the contours # of points       }

        Readln(PLTFile,BigLine);         { Load initial contour coordinates    }
        Ptr := 1;
        Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,X1,Code);
        Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,Y1,Code);

        XOld   := X1;
        YOld   := Y1;
        DupFlg := 0;
        XS1 := SCRCX + (X1 - XC) * DSCRXDDD;
        YS1 := SCRCY - (Y1 - YC) * DSCRYDDD;

        Inc(CSIndex);
        ContourSegments[CSIndex].X := Trunc(XS1);
        ContourSegments[CSIndex].Y := Trunc(YS1);

        MoveTo(Trunc(XS1), Trunc(YS1));              { Go to the starting point }
        PutPixel(Trunc(XS1), Trunc(YS1), MaxColor);
        IFR := 0;

        For K := 2 to NPC do begin
          Readln(PLTFile,BigLine);                  { Load contour coordinates }
          Ptr := 1;
          Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,X,Code);
          Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,Y,Code);

          If (IFR < 2) or (Abs(X - X1) > 1.0E-15) or
                          (Abs(Y - Y1) > 1.0E-15) then begin
            IntXS := Trunc(SCRCX + (X - XC) * DSCRXDDD);
            IntYS := Trunc(SCRCY - (Y - YC) * DSCRYDDD);
            If DupFlg <> 0 then begin
              XOld := X;
              YOld := Y;
              DupFlg := 0;
              MoveTo(IntXS, IntYS);
              PutPixel(IntXS, IntYS, MaxColor);
              Inc(CSIndex);
              ContourSegments[CSIndex].X := IntXS;
              ContourSegments[CSIndex].Y := IntYS;
            end
            else begin
              If (Abs(X - XOld) < 1.0E-15) and
                 (Abs(Y - YOld) < 1.0E-15) then begin
                DupFlg := 1;
                Inc(IFR);
              end;

              LineTo(IntXS,IntYS);         { Draw the line     }
              Inc(CSIndex);
              ContourSegments[CSIndex].X := IntXS;
              ContourSegments[CSIndex].Y := IntYS;

            end;
          end;
          If (IFR >= 2) then Contours[J] := NPC-1;
        end;         { end of looping through contours via K }

        Readln(PLTFile,BigLine);                    { Load contour coordinates }
        Ptr := 1;
        Parse(Ptr,Delim,BigLine,WrkStr);  Val(WrkStr,NPC,Code);
        For K := 1 to NPC do
          Readln(PLTFile,BigLine);                    { Bypass edited contours }

      end;      { Major loop through contours via J }

                       {  Now we must draw all the receptors }
      Loading := True;
      For I := 1 to NumRT do
        DisplayReceptor(Receptors[I].X,Receptors[I].Y,IRad,GetMaxColor);
      Loading := False;

      WrkStr := '';
      K := 1;                                { K Points to the current receptor }

      PosX := GetMaxX Div 2;                      { Initial Position for cursor }
      PosY := GetMaxY Div 2;
      ContourSeg := 0;

      FKey := 0;
      DeleteInProgress := False;
      While (FKey <> F8) do begin
        DisplayCursor(PosX,PosY);                  { Redraw the cursor in white }
        FKey := Input(0,0,1,0,WrkStr,False);
        DisplayCursor(PosX,PosY);                  { Redraw cursor in XOR Black }
        If FKey <> F8 then begin
          If DeleteInProgress and (FKey <> CDel) then begin
            DisplayReceptor(Receptors[K].X,Receptors[K].Y,CHRad,GetBkColor);
            DisplayReceptor(Receptors[K].X,Receptors[K].Y,IRad,GetMaxColor);  { Normalize the current receptor }
            DeleteInProgress := False;
            Deleting(False);                           { Erase the Delete Msg }
            RecInfo(False);                            { Erase the Rec Info }
          end
          else begin
            Case FKey of
              Esc    : begin
                         RestoreCRTMode;
                         GoTo MainEntry;
                       end;
              F1     : DisplayHelp;
              F2     : RepaintGraphicScreen;
              F3     : begin
                         DisplayCursor(PosX,PosY);
                         DisplayElevations;
                         DisplayCursor(PosX,PosY);
                       end;
              F10    : begin
                         RestoreCRTMode;
                         ExitToDos;
                       end;
              CUp    : If PosY > 2 then
                        Dec(PosY);
              CDown  : If PosY < (GetMaxY - 2) then
                        Inc(PosY);
              CLeft  : If PosX > 2 then
                        Dec(PosX);
              CRight : If PosX < (GetMaxX - 2) then
                        Inc(PosX);
              CHome  : Begin
                        If PosY > 2 then
                          Dec(PosY);
                        If PosX > 2 then
                          Dec(PosX);
                       end;
              CEnd   : Begin
                        If PosY < (GetMaxY - 2) then
                          Inc(PosY);
                        If PosX > 2 then
                          Dec(PosX);
                       end;
              CPgUp  : Begin
                         If PosY > 2 then
                           Dec(PosY);
                         If PosX < (GetMaxX - 2) then
                           Inc(PosX);
                       end;
              CPgDn  : Begin
                         If PosY < (GetMaxY - 2) then
                           Inc(PosY);
                         If PosX < (GetMaxX - 2) then
                           Inc(PosX);
                       end;
            CtrlLeft : If PosX > 8 then
                         PosX := PosX - 6;
           CtrlRight : If PosX < (GetMaxX - 8) then
                         PosX := PosX + 6;
            CtrlHome : Begin
                         If PosY > 8 then
                           PosY := PosY - 6;
                         If PosX > 8 then
                           PosX := PosX - 6;
                       end;
           CtrlEnd  : Begin
                        If PosY < (GetMaxY - 8) then
                          PosY := PosY + 6;
                        If PosX > 8 then
                          PosX := PosX - 6;
                      end;
           CtrlPgUp : Begin
                        If PosY > 8 then
                          PosY := PosY - 6;
                        If PosX < (GetMaxX - 8) then
                          PosX := PosX + 6;
                      end;
           CtrlPgDn : Begin
                        If PosY < (GetMaxY - 8) then
                          PosY := PosY + 6;
                        If PosX < (GetMaxX - 8) then
                          PosX := PosX + 6;
                      end;
              CDel  : Begin                         { Delete the current receptor }
                        If DeleteInProgress then begin
                          DeleteReceptor(K);
                          DeleteInProgress := False;
                          RecInfo(False);
                         end
                         else begin
                          GoToClosestReceptor;
                          DeleteInProgress := True;
                         end;
                       end;
              CIns  : begin
                        DisplayCursor(PosX,PosY);
                        InsertReceptor(K);
                        DisplayCursor(PosX,PosY);
                      end;
            end;  { Case }
          end;    { If Delete }
        end;      { If FKey }
      end;        { While }

      RestoreCRTMode;
      ModeIsText := True;

GetModifiedName:
      If Modified then begin
        MenuHeading(False);
        GoToXY(14,9);   Color(Yellow,Black);
        Write('Please enter the name of the modified receptor file.');
        DoEscOrF10;
        BigLine := TheRCTFile;
        Ptr := 1;
        Delim := '.';
        Parse(Ptr,Delim,BigLine,WrkStr);
        FKey := Input(34,11,4,8,WrkStr,True);
        If FKey = F10 then
          ExitToDos;
        If FKey = Esc then begin
          Color(LightGray,Black);
          ClrScr;
          Exit;
        end;
        Color(LightGray,Black);
        Trim(WrkStr);
        BigLine := '\CTDM\FILES\'+WrkStr+'.RCT';
        If FileExists(BigLine) then begin
          MenuHeading(False);
          DoEscOrF10;
          Color(Yellow,Black);
          WriteStr(14,9,'That File already exists.  Overwrite it?  (Y/N)  ');
          WrkStr := '';
          FKey := Input(0,0,1,0,WrkStr,True);
          If FKey = F10 then
            ExitToDos;
          If FKey = Esc then begin
            Color(LightGray,Black);
            ClrScr;
            GoTo MainEntry;
          end;
          If UpCase(WrkStr[1]) <> 'Y' then
            GoTo GetModifiedName;
        end;
        Assign(RCTFile,BigLine);
        SetTextBuf(RCTFile,RCTBuf);
        Rewrite(RCTFile);

      WrkStr := PlotHillName + Spaces(12-Length(PlotHillName));
      For J := 1 to NumRT do begin
        X := Receptors[J].X;
        Y := Receptors[J].Y;
        Z := Receptors[J].Z;
        Writeln(RCTFile,WrkStr,J:4,'    ',X:10:2,Y:10:2,Zero:10:2,Z:10:2,PlotHillID:5);
      end;
        Close(RCTFile);
      end;
    end;  { If NewRecFile }
  end;
end.
