C*****************************************************************************
C                                                                            *
C                          CTDMPLUS (Dated 93228)                            *
C                                                                            *
C             *** SEE CTDMPLUS MODEL CHANGE BULLETIN MCB#5 ***               *
C                                                                            *
C     ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS BULLETIN BOARD         *
C                                                                            *
C                               919-541-5742                                 *
C                                                                            *
C*****************************************************************************
C
        PROGRAM CTDMPLUS
C
C********************************************************************
C
C       THE COMPLEX TERRAIN DISPERSION MODEL PLUS ALGORITHMS
C       FOR UNSTABLE SITUATIONS (CTDMPLUS)
C
C********************************************************************
C
C   PURPOSE:
C      THIS IS THE MAIN PROGRAM OF THE COMPLEX TERRAIN DISPERSION MODEL
C      PLUS ALGORITHMS FOR UNSTABLE SITUATIONS (CTDMPLUS).
C      THIS ROUTINE OPENS INPUT AND OUTPUT FILES AND CALLS SUBROUTINES
C      THAT HANDLE PROGRAM OPTIONS, SOURCE, RECEPTOR, AND TERRAIN
C      DESCRIPTIONS; A MAP OF SOURCES, RECEPTORS, AND TERRAIN;
C      AND INITIATION OF SEQUENTIAL MODELING.
C
C   LIMITATIONS:
C      TITLE FOR THIS RUN IS LIMITED TO 80 CHARACTERS.
C      PROGRAM OPTIONS INPUT FILE IS OPENED TO UNIT 5.
C      OUTPUT LISTING FILE IS OPENED TO UNIT 6.
C      NOTE: DEFAULT I/O UNIT NUMBERS ARE ASSIGNED IN THE MAIN
C      PROGRAM AND CAN BE CHANGED HERE.
C
C   COMMON BLOCKS USED: HEAD,IO,PARAMS
C
C   INPUT FROM UNIT 5: (CTDM.IN)
C       TITLE FOR THIS RUN
C
C   OUTPUT: NONE
C
C   EXTERNAL ROUTINES CALLED:
C       PAGE - STARTS A NEW PRINTED PAGE
C       INPAR - READS AND PRINTS PROGRAM PARAMETERS AND SWITCHES
C       INPSOR - READS AND PRINTS STACK INFORMATION
C       INPREC - READS AND PRINTS RECEPTOR INFORMATION
C       INPTOW - READS METEOROLOGICAL TOWER COORDINATES
C       INPTER - READS TERRAIN DATA
C       MAP - PRINTS A MAP LOCATING STACKS, RECEPTORS, AND TERRAIN
C       SEQMOD - INITIATES SEQENTIAL MODELING CALCULATIONS
C
C********************************************************************
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
      INCLUDE   'HEAD.CMN'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'RECEPT.CMN'
C
C       DEFINE LOCAL VARIABLES
        INTEGER  YES
        DATA    YES/1/
C
C       DEFAULT UNIT NUMBERS (IO.CMN)
C
        INTERR = 2
        INEMIS = 3
        INREC = 4
        IN = 5
        IOUT = 6
        INSFC = 7
        IOCONC = 9
        INPROF = 11
        INRAW = 14
        IOSRC = 17
C
        NPAGE = 0
C
C  CHANGE "FILE=" TO "NAME=" FOR VAX RUNS.  CHANGE STATUS FROM "UNKNOWN"
C  TO "NEW".  TAKE PERIODS OUT OF FILE NAMES, E.G. "CTDM.IN" BECOMES 
C  "CTDMIN"
C
        OPEN(IN, FILE='CTDM.IN',STATUS='OLD')
        OPEN(IOUT, FILE='CTDM.OUT', STATUS='UNKNOWN' )
C-*-*1    CARRIAGECONTROL='FORTRAN')
C       READ LINE 1 OF "CTDM.IN"
        READ( IN, 5010) TITLE
C
        CALL PAGE(YES)
C       READ LINES 2, 3 OF "CTDM.IN"
        CALL INPAR
C       READ LINE 4 OF "CTDM.IN"
        CALL INPTOW
C       READ LINE 5 OF "CTDM.IN"
        CALL INPSOR
C
        IF(IEMIS .EQ. YES) OPEN(INEMIS, FILE='EMISSION',STATUS='OLD')
C
        OPEN(INREC, FILE='RECEPTOR', STATUS='OLD')
        CALL INPREC
        CLOSE(INREC)
C
        OPEN(INTERR, FILE='TERRAIN', STATUS='OLD')
        CALL INPTER
        CLOSE(INTERR)
C
        OPEN(INSFC, FILE='SURFACE', STATUS='OLD')
C
        OPEN(INPROF, FILE='PROFILE', STATUS='OLD')

        IF (ISOR .EQ. 1) THEN 
          OPEN(IOSRC, FILE='SOURCES')
          WRITE(IOSRC,5010) TITLE
        ELSE IF (ISOR .EQ. 2) THEN
          OPEN(IOSRC, FILE='SOURCES', FORM='UNFORMATTED')
        ENDIF

        IF(ICONC .EQ. 1) THEN
                OPEN(IOCONC, FILE='CONC',FORM='UNFORMATTED')
C
        ELSE IF(IABS(ICONC) .GT. 1 ) THEN
                OPEN(IOCONC, FILE='CONC')
        ENDIF

        IF (IUNSTA.GT.0) THEN
           OPEN(INRAW, FILE='RAWIN',STATUS='OLD')
        END IF 
C
        CALL MAP
C
        CALL SEQMOD
C
        STOP
C
 5010   FORMAT(20A4)
C
        END
