         SUBROUTINE DAYCALC(NS,OLDAY,DELH,QS)
C ********************************************************************
C     THIS SUBROUTINE CALCULATES THE CONCENTRATION AT RECEPTORS DURING 
C     DAYTIME CONDITIONS (HS < XMH AND L < 0).  THE SUBROUTINE IS 
C     CALLED FROM THE SOURCE LOOP
C *******************************************************************

        INCLUDE  'PARAMS.INC'
        INCLUDE  'CONST.CMN'
C        INCLUDE  'FLVAR.CMN'
        INCLUDE  'HEAD.CMN'
        INCLUDE  'HILL.CMN'
        INCLUDE  'IO.CMN'
        INCLUDE  'PARAMS.CMN'
        INCLUDE  'PASL.CMN'
        INCLUDE  'PASVAL.CMN'
        INCLUDE  'PASW.CMN'
C        INCLUDE  'PROFIL.CMN'
        INCLUDE  'RECEPT.CMN'
        INCLUDE  'SFCMET.CMN'
        INCLUDE  'STACK.CMN'
C        INCLUDE  'STACKS.CMN'
        INCLUDE  'TIME.CMN'
        INCLUDE  'TOWER.CMN'
        INCLUDE  'VARS.CMN'

C  DEFINE ARGUMENTS
        REAL QS
        INTEGER NS

C  DEFINE LOCAL VARIABLES
        REAL ADJFB, ADJXMH, ARG, BASEHW, BETASQ, BIGX, BOUNCE(6), 
     X       COSFLO, COSELW, CSD, CWIC, DELH, 
     X       DTHETA, DX, DY, DZI, EFFSH(6), FRACT, GM, HDF, 
     X       HILL, HTOPS, HTWRAP, OLDQS, PEN, PLBOT, PLTOP, 
     X       PLR, PTZI, PW(6), PWTOT, RISE, ROTELW, ROTFLO, RSHW, 
     X       SIGMAW, SIGY, SINELW, SINFLO, SMUW, SNUW, SND, 
     X       SWBAR, SWMINUS, SWPLUS, TMUW, 
     X       TNUW, TRISE, U, UVSAVE, VDTHDZ, WBETA, WHAT, 
     X       WP(6), WPMWH, WY(6), X, XF, XHILLW, XP,  
     X       XHILLL, XSEW, XSMAJW, XTEW, XTMAJW,
     X       Y, YCROSS, YHILLL, YHILLW, YPDF, YSEW, 
     X       YSMAJW, YTEW, YTMAJW
        INTEGER DFLAG, I, IBLOCK, INDEX, IREC, IUPW(MAXREC), IZZ, 
     X          KHILL(MAXREC), KLOW, NH, NHL, OLDAY
        CHARACTER*1 GSGS(2)
        DATA GSGS/'G', 'S'/ 
        DATA WBETA/0.7/

C  BOUNCE DEPENDS ON LAST REFLECTION. IF OFF GROUND, BOUNCE = -1
        DATA BOUNCE/1.0,-1.0,1.0,-1.0,1.0,-1.0/


C       CORRECT PLUME RISE TO BE .9 * MIXING HEIGHT AND
C       ADJUST DELH IF PLUME HT WAS ADJUSTED  
          IF (HPL .GT. 0.9*XMH) THEN
            HPL = 0.9 * XMH
            DELH = AMAX1(HPL - HS,0.1)
          ENDIF


C  CONVERT MEAN WIND DIRECTION FROM DEG CW FROM N TO DEG CCW FROM N
C          AND CHANGE TO FLOW DIR IN RADIANS AND
C  ROTATE COORD. SYS. TO ALIGN ORIGINAL X-AXIS WITH THE MEAN FLOW DIR.

        THTA = GETWD(HS + 0.5*DELH)
        SND = SIN(THTA*DTOR)  
        CSD = COS(THTA*DTOR)

        PHIM = (180.0 - THTA)*DTOR
        IF(PHIM .LT. 0.0) PHIM = TWOPI + PHIM
        ROTFLO = PIBY2 + PHIM
        SINFLO = SIN(ROTFLO)
        COSFLO = COS(ROTFLO)

C    COMPUTE WIND SPEED AT ONE-HALF PLUME RISE HEIGHT (U)        
        U =  GETWS(HS + 0.5*DELH)

C    SET WSTAR/U TO A MIN OF 0.167 (REDO DUE TO NEW WIND SPEED)
        WSTAR = AMAX1(0.167*U,WSTAR0)

C    CALCULATE PARTIAL PENETRATION FACTOR

C    NEW PENETRATION FACTOR, FROM BRIGGS (1984)
C    CHECK TO SEE IF IT IS A NEW DAY, IF IT IS, THE PROGRAM NEEDS TO 
C    READ A NEW LINE FROM RAWIN. THE COMPARISON IS BETWEEN THE DAY SET 
C    DURING LAST RUN OF THE HOUR LOOP, AND THE DAY (JDY) FROM PROFILE

      DFLAG = 0
      IF (KDY.NE.OLDAY) DFLAG = 1
      OLDAY = KDY
    
      CALL DTHDZ(DFLAG,PTZI,VDTHDZ,XMH)

C    PTHS,VDTHDZ ARE RETURNED

       PEN = PENFCT(U,PTZI,VDTHDZ,XMH)

       OLDQS = QS
       QS = QS*(1.0 - PEN)

C CALCULATE FSTAR FROM REVISED FB, BUT DON'T ADJUST THE ACTUAL FB
        ADJFB = FB * (1.0 - PEN)
        FSTAR = ADJFB/(U*WSTAR**2*XMH)

C  CALCULATE OTHER SOURCE DEPENDENT VARIABLES FOR PDF DETERMINATION
        BETASQ = WBETA * WBETA
        SIGMAW = 0.5 * WSTAR
        SIGW = SIGMAW
        SWBAR = SIGMAW/(1.0 + (3.0 - 8.0/PI) * BETASQ)**0.5
        SWPLUS = SWBAR * (1.0 + WBETA)
        SWMINUS = SWBAR * (1.0 - WBETA)
        GM = 1.0/(SWBAR*SQR2PI)
        WHAT = -SWBAR * WBETA * (8.0/PI)**0.5


C  FILL EFFECTIVE STACK HEIGHT ARRAY FOR PDF DETERMINATION

        EFFSH(1) = HPL
        EFFSH(2) = HPL
        EFFSH(3) = 2.0*XMH - HPL
        EFFSH(4) = 2.0*XMH - HPL
        EFFSH(5) = 2.0*XMH + HPL
        EFFSH(6) = 2.0*XMH + HPL

C   THIS IS USED FOR TRANSITIONAL PLUME RISE
        XF = XFIN   

       IF(ICASE .GT. 1 .AND. NLINES .GE. MAXLIN-3) THEN
         CALL PAGE(YES)
         WRITE(IOUT,335) GSGS(ICHIQ+1)
         NLINES = NLINES + 5
       ENDIF

C  WRITE OUT SOURCE INFORMATION
        IF (ICASE .GT. 1) THEN
          WRITE(IOUT,333)
          WRITE(IOUT,334) NS,OLDQS,TS,VS,FB,FM,PEN
        ENDIF

C  WRITE OUT SOURCE INFO ADJUSTED BY PEN
       IF (ICASE .GT. 1) WRITE(IOUT,337) NS,QS,ADJFB

C  WRITE OUT PLUME HEIGHT METEOROLOGY
       IF (ICASE .GT. 1) THEN
         WRITE(IOUT,329)
         PLR= 0.5*DELH+HS
         WRITE(IOUT,330) PLR, THTA,U
       ENDIF

C  WRITE OUT CONVECTIVE SCALING PARAMETERS
       IF (ICASE .GT. 1) THEN
         WRITE(IOUT,331)
         WRITE(IOUT,332) USTAR0,WSTAR,FSTAR
       ENDIF

C IF PEN = 1 THEN QS = 0. SET CONTRIBUTION FROM THIS SOURCE TO 0 AND
C GO ON TO NEXT SOURCE. JUST DON'T ADD ANYTHING TO TOTAL CONC AT
C INDIVIDUAL RECEPTORS.

       IF (PEN .GE. 1.0) THEN
         IF (ICASE .GT. 1) WRITE(IOUT,340) NS,KYR,KMO,KDY,KHR 
         DO 219 NR = 1,NRECPT
           SCONC(NR,NS) = 0.0
219      CONTINUE
         GO TO 280
       ENDIF

C  ZERO THE HILL DOWNWIND FLAG
        DO 220 NH = 1,NHILLS
220          KHILL(NH) = NO

C  IF ANY RECEPTOR ON A HILL IS DOWNWIND OF THE SOURCE, THEN THE 
C  ENTIRE HILL IS CONSIDERED TO BE DOWNWIND OF THE SOURCE
        DO 230 NR = 1,NRECPT
          INDEX = NRHILL(NR)
          IF (INDEX .GT. 0) THEN
            IF (KHILL(INDEX) .EQ. YES) GO TO 230
          ENDIF
          XR = RECPT(1,NR)
          YR = RECPT(2,NR)
          CALL PSRCE(SND,CSD,IUPW(NR),Y,X,XS,YS,XR,YR)
          IF (IUPW(NR) .EQ. NO .AND. INDEX .GT. 0) KHILL(INDEX) = YES
230     CONTINUE


C ----------------START HILL LOOP----------------------------
      DO 270  NHL = 0,NHILLS

        IBLOCK = 0

C  IF ALL RECEPTORS ON HILL ARE UPWIND THEN SKIP ENTIRE LOOP
        IF (NHL .NE. 0 .AND. KHILL(NHL) .EQ. NO) THEN
          IF (ICASE .GT. 1) WRITE(IOUT,232) NHL,KYR,KMO,KDY,KHR
232         FORMAT(1X,'HILL #',I2,' IS UPWIND OF SOURCE ON ',
     *                    I2,'/',I2,'/',I2,'/',' HR ',I2)
          GO TO 270
        ENDIF

C  GET HILL AND SOURCE COORDINATES CONVERTED TO HILLTOP-
C  CENTERED SYSTEM.  VARIABLES GO TO VARIOUS COMMON BLOCKS
         IF (NHL .GT. 0) THEN
           CALL GETHILL(NHL,XHILLL,YHILLL,SINFLO,COSFLO,XS,YS)

C  IF SOURCE IS ON THE LEE SIDE OF THE HILL, DON'T MODEL IT. GO
C  ON TO NEXT HILL INSTEAD.
           IF (XSEPL .GT. 0.0) THEN
             IF (ICASE .GT.1) WRITE(IOUT,6171) 
     &                           NHL,NS,KYR,KMO,KDY,KHR
             GO TO 270
           ENDIF


C  GET THE FROUDE NUMBER AND CALCULATE SOME VARIABLES FOR MIXING 
C  HEIGHT ADJUSTMENT AND WPDF CALL. DZI IS ZI DEFLECTION.

           CALL GETFR(VDTHDZ,PTZI,DZI,IBLOCK)


C    IF MIXING HEIGHT DOESN'T MAKE IT OVER THE HILL, 
C    SKIP THIS SECTION AND GO ON TO INDIVIDUAL RECEPTORS.
           IF (IBLOCK.EQ.1) THEN

C    TIME TO DO BLOCKAGE CALCULATIONS - ADAPTED FROM SEQMOD CODE
             
              HC = XMH + DZI
              HTOPS = THS(NHL)
              Z0HILL = Z0H(NHL)

C  SECTION FOR DEFINING GEOMETRY FOR BLOCKAGE COMPUTATIONS ---------
C     CRITICAL HEIGHT (HC) FOR WRAP IS THE DEFLECTION-ADJUSTED
C     MIXING HEIGHT.  THIS CODE GETS WRAP GEOMETRY FOR UNSTABLE 
C     SITUATIONS. THE CODE IS DERIVED FROM WRAP CODE IN SEQMOD.  IN
C     ORDER TO MAKE THE BEST OF THE EXISTING CODE, THIS CODE USES MOST 
C     OF THE SAME VARIABLE NAMES, EVEN THOUGH THEY DO NOT STAND FOR 
C     EXACTLY THE SAME THING.
C              HTWRAP = AMIN1( HPL, HC )
               HTWRAP = HPL
C
C     GET HILL COORDS, ANGLE AND MAJOR, MINOR AXIS FOR THE WRAP HILL
C     W AT END OF VARIABLE INDICATE WRAP HILL
C     KLOW IS THE ARRAY INDEX TO THE HEIGHT CLOSEST TO (BUT LESS
C     THAN) HTWRAP
              KLOW = KLOSE( ZHS(1,NHL), NZH(NHL), HTWRAP )
              IF( KLOW .EQ. 0 ) KLOW = 1
              BASEHW = ZHS(KLOW,NHL)
              IF( KLOW .EQ. NZH(NHL) ) THEN
C         THE CRITICAL HT IS ABOVE LAST CONTOUR VALUE
C         DO NOT INTERPOLATE, BUT USE INVERSE POLYNOMIAL FORMULA
C         GET X, Y, ORIENTATION OF THE ELLIPSE FOR WRAP FROM THE
C         LOOK-UP TABLE.
C
                  XHILLW = XHW(KLOW,NHL)
                  YHILLW = YHW(KLOW,NHL)
                  THTAH = MAJORW(KLOW,NHL)
C             DISTANCE SOURCE TO  HILL CENTER
                  DX = XS - XHILLW
                  DY = YS - YHILLW
                  RSHW = SQRT( DX*DX + DY*DY )
C
C             COMPUTE MAJOR & MINOR AXIS LENGTHS: INTERPOLATE BETWEEN
C             MAJAXW, MINAXW AND 0.0 IF ABOVE THE LAST CONTOUR
C
                  FRACT =  1.0 - (HTWRAP - BASEHW)/(HTOPS - BASEHW)
                  AAXW = MAJAXW(KLOW,NHL) * FRACT
                  BAXW = MINAXW(KLOW,NHL) * FRACT
               ELSE
C             LINEARLY INTERPOLATE BETWEEN TWO VALUES
                  XHILLW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  
     *                     HTWRAP, XHW(KLOW,NHL), XHW(KLOW+1,NHL))
                  YHILLW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  
     *                     HTWRAP, YHW(KLOW,NHL), YHW(KLOW+1,NHL))
                  AAXW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  
     *                   HTWRAP, MAJAXW(KLOW,NHL), MAJAXW(KLOW+1,NHL))
                  BAXW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  
     *                   HTWRAP, MINAXW(KLOW,NHL), MINAXW(KLOW+1,NHL))
                  THTAH = ANGINT( MAJAXW(KLOW,NHL),MINAXW(KLOW,NHL),
     *                        MAJORW(KLOW,NHL), ZHS(KLOW,NHL),
     *                        MAJAXW(KLOW+1,NHL),MINAXW(KLOW+1,NHL),
     *                        MAJORW(KLOW+1,NHL), ZHS(KLOW+1,NHL),
     *                        HTWRAP )
C
C               CHECK THAT ELLIPSE AXES ARE LESS THAN DIST FROM SOURCE
C               TO HILL CENTER   AAX <= BAX < DIST SOURCE/HILL CENTER
                    DX = XS - XHILLW
                    DY = YS - YHILLW
                    RSHW = SQRT( DX*DX + DY*DY )
C                    IF( AAXW .GT. RSHW ) AAXW = 0.99 * RSHW
C                    IF( BAXW .GT. AAXW ) BAXW = AAXW
              ENDIF
C
C         SHIFT ORIGIN TO CENTER OF WRAP HILL (E DENOTES ELLIPSE)
              XSEW = XS - XHILLW
              YSEW = YS - YHILLW
              XTEW = XT - XHILLW
              YTEW = YT - YHILLW
C
C         FIND TOWER AND SOURCE LOCATIONS RELATIVE TO MAJOR AXIS OF
C         WRAP HILL ELLIPSE. NOTE: X-AXIS LIES ALONG MAJOR AXIS
              ROTELW = (90.0 - THTAH) * DTOR
              COSELW = COS(ROTELW)
              SINELW = SIN(ROTELW)
              XTMAJW =  XTEW*COSELW + YTEW*SINELW
              YTMAJW = -XTEW*SINELW + YTEW*COSELW
              XSMAJW =  XSEW*COSELW + YSEW*SINELW
              YSMAJW = -XSEW*SINELW + YSEW*COSELW
C
C         COMPUTE ELLIPTICAL COORDS OF SOURCE AND TOWER
              CALL MUNU( XSMAJW, YSMAJW, AAXW, BAXW, SMUW, SNUW )
              CALL MUNU( XTMAJW, YTMAJW, AAXW, BAXW, TMUW, TNUW )
C
C   SET UP DATA FOR CALCULATIONS WHEN ZI IS TRAPPED. THE  "D" IS 
C   CALCULATED IN WRAPIN. APPROXIMATE UV = U, BUT SAVE OLD VALUE
C   FOR NEXT SOURCE.
              UVSAVE = UV
              UV = U
              CALL WRAPIN(TMUW,TNUW,SMUW,SNUW,XSMAJW,YSMAJW)
              UV = UVSAVE
            ENDIF
         ENDIF

C  WRITE OUT HILL AND RECEPTOR HEADERS

         IF (ICASE .GT. 1) THEN
           CALL PAGE(YES)
           IF (NHL .EQ. 0) THEN
             WRITE(IOUT,342)
           ELSE 
             WRITE(IOUT,341) NHL
           ENDIF
           WRITE(IOUT,335) GSGS(ICHIQ+1)
           NLINES = NLINES + 5
         ENDIF

C INITIALIZE THE IREC FLAG USED FOR CHECKING IF ANY RECEPTORS ON 
C THIS HILL WERE MODELED
         IREC = 0

C ------------- START RECEPTOR LOOP ----------------------
        DO  260 NR = 1, NRECPT

C  CHECK IF THIS RECEPTOR IS ON CURRENT HILL
        IF (NRHILL(NR) .NE. NHL) GO TO 260

C   RECEPTOR ON CURRENT HILL IS MODELED
        IREC = 1

C  SET UP RECEPTOR VARIABLES
        XR = RECPT(1,NR)
        YR = RECPT(2,NR)

C  INITIALIZE CONCENTRATION
        C = 0.0

C  IF OPTION SELECTED, CONC = 0 FOR RECEPTORS BELOW STACK TOP
        IF (ISTKTP .EQ. 1 .AND. RECPT(4,NR) .LT. HS) GO TO 260

C  YCROSS AND XP ARE RETURNED CROSSWIND AND DOWNWIND DISTANCES
        CALL PSRCE(SND,CSD,IZZ,YCROSS,XP,XS,YS,XR,YR)
        IF (IZZ .EQ. 1) THEN 
          IF (ICASE .GT. 1) WRITE(IOUT,234) NR
234         FORMAT(1X,'RECEPTOR #',I3,' IS UPWIND')
          GO TO 260
        ENDIF
                       

C   IF RECEPTOR IS PART OF FLAT TERRIAN SECTION, IT IS TREATED DIFFERENTLY
C   SINCE IT CANNOT BE PUT INTO A HILL-CENTERED COORDINATE SYSTEM.

        IF (NHL .EQ. 0) THEN
C   SET SOURCE AT ORIGIN
           XSEPL = 0.0
           YSEPL = 0.0
C   TRANSLATE RECEPTOR TO SOURCE-CENTERED COORDINATES
           XEL = XR - XS
           YEL = YR - YS
         

C  XR AND YR CONVERTED TO HILLTOP COORDINATES HERE

        ELSE

C  SHIFT ORIGIN TO CENTER OF HILL
           XEL= XR - XHILLL
           YEL= YR - YHILLL
        END IF       

C  ALIGN X-AXIS WITH MEAN FLOW, ROTATE RECEPTOR COORDINATES
        XEPL =  XEL* COSFLO + YEL* SINFLO
        YEPL = -XEL* SINFLO + YEL* COSFLO
        ZELEV = RECPT(3,NR) 

C  CALCULATE TRANSITIONAL PLUME RISE IF THE DOWNWIND DISTANCE TO THE
C  RECEPTOR IS LESS THAN XF.  XF IS THE LARGEST DOWNWIND DISTANCE FOR 
C  WHICH TRANS RISE WAS LESS THAN RISE FROM OTHER PLUME RISE EQUATIONS.
C  IF TRANS RISE IS USED, RESET THE STACK HEIGHT ARRAY FOR PDF USING THE
C  TRANS PLUME HEIGHT. IF MOMENTUM FLUX IS TOTALLY AT WORK (I.E. IF 
C  BUOY FLUX = 0) THEN SET RISE TO MOMENTUM RISE.

C  ADDED FLAG ITRANPR - A 1 MEANS THAT TRANPR WAS CALLED.  THIS IS 
C  NECESSARY BECAUSE IF WE RESET THE EFFECTIVE STACK HEIGHT ARRAY,
C  WE NEED TO RESET IT AFTER OUR CALCULATIONS FOR THIS RECEPTOR ARE
C  COMPLETED -DJB 4/16/91

C  RISE, XFIN ARE RETURNED

       IF (XP .GE. XF .OR. FB .EQ. 0.0) THEN
         ITRANPR = 0
         TRISE = -999.0
         RISE = DELH
         HPL = HS + DELH
       ELSE 
         ITRANPR = 1
         CALL TRANPR(XP,TRISE)
         RISE = AMIN1(TRISE,DELH)
         IF (RISE .NE. TRISE) XF = XP
         HPLTR = HS + RISE
         EFFSH(1) = HPLTR
         EFFSH(2) = HPLTR
         EFFSH(3) = 2.0*XMH - HPLTR
         EFFSH(4) = 2.0*XMH - HPLTR
         EFFSH(5) = 2.0*XMH + HPLTR
         EFFSH(6) = 2.0*XMH + HPLTR
       ENDIF            


C      DTHETA IS THE WIND DIRECTION CHANGE OVER THE PLUME DEPTH, WHICH
C      IS ASSUMED TO BE APPROXIMATELY THE SAME AS THE PLUME RISE

       PLTOP = HS + RISE*1.5 
       PLBOT = HS + RISE*0.5 
C       DTHETA = (GETWD(PLTOP) - GETWD(PLBOT))/RISE 
C      MAKE SURE WD IS MOD360 - DJB 2/1/91
       DTHETA = GETWD(PLTOP) - GETWD(PLBOT)
       IF (DTHETA .GT.  180.) DTHETA = DTHETA - 360.
       IF (DTHETA .LT. -180.) DTHETA = DTHETA + 360.
       DTHETA = DTHETA/RISE


C  CALCULATE HEIGHT OF RECEPTOR ON GAUSSIAN HILL
       IF (NHL .GT. 0) THEN
          HILL = HILHGT(XEPL,YEPL)*HH
          Z = ZELEV + HILL
       ENDIF


C   CALCULATE BIGX, THE NON-DIMENSIONAL DOWNWIND DISTANCE.  IF BIGX > 4
C   THEN WE ARE IN THE REGION WHER CY = 1 AND WE DON'T NEED TO USE 
C   THE PDF APPROACH. CALL WPDF FOR DIRECT CASE TO GET Y FOR SIGMAY

        BIGX = (XP/U)*(WSTAR/XMH)
        IF (BIGX .GT. 4.0) THEN
          IF (NHL .GT. 0)
     $      CALL WPDF(EFFSH(1),BOUNCE(1),WP(1),WY(1),ZELEV,U)
          CWIC = QS/(U * XMH)
          GO TO 269 
        ENDIF
        
C DECISION FOR FLAT VS. HILLY TERRAIN. EVERYTHING IS TREATED AS 
C NON-BOUYANT. COORDINATE ROTATION TO X = FLOW DIRECTION HAS ALREADY 
C BEEN DONE.  WFLAT CALCULATES THE DIRECT, GROUND BOUNCE, Zi BOUNCE,
C AND TWO DOUBLE BOUNCE WP's, THEN THE PW VALUES.  PWTOTAL IS RETURNED
C FOR THE CALCULATION OF CWIC.

        IF (NHL .EQ. 0) THEN
            CALL WFLAT(EFFSH,WP,PW,PWTOT,WHAT,GM,
     X                 SWPLUS,SWMINUS,U,ZELEV,BOUNCE)
            GO TO 268
        ELSE

C  CALCULATE ADJUSTED MIXING HEIGHT FOR PARTICULAR RECEPTOR.  IF THE
C  RECEPTOR IS ABOVE THE DEFLECTED ZI, THE CONC IS 0.0.

          ADJXMH = XMH + DZI*HILHGT(XEPL,YEPL)

          IF (Z .GT. ADJXMH) THEN
            C = 0.0
            GO TO 250
          ENDIF

          IF (IBLOCK.EQ.1) THEN

C  CALCULATE THE PROBABILITY FOR BLOCKAGE SITUATION USING THE 
C  FLAT CALC TO GET PROBABILITY TO USE IN CWIC
            CALL WFLAT(EFFSH,WP,PW,PWTOT,WHAT,GM,
     X                  SWPLUS,SWMINUS,U,ZELEV,BOUNCE)
            GO TO 268
          ENDIF

C  INITIALIZE THE PROBABILITY AND WP ARRAYS
          DO 261 I = 1,6
            WP(I) = -999.0
            PW(I) = 0.0
261       CONTINUE
                       
C  CALCULATE THE WP VALUES AND CHECK TO SEE IF WE ARE STILL UNDER THE 
C  CURVE.  ONCE WE FIND A VALUE OUTSIDE THE CURVE, WE DON'T NEED TO
C  CALCULATE ANY MORE WP'S IN THAT DIRECTION. GET WY FOR USE WITH HDF.
C  REVERSE THE SIGNS FOR PATHS 3 AND 4. IF ZELEV = 0 (RECEPTOR ON THE
C  GROUND (NOT ON POLE) SKIP GROUND BOUNCE CALCULATION AND JUST SET
C  WP = TO EQUIVALENT DIRECT PATH.


         DO 262 I = 1,6
           IF ((I .EQ. 2 .OR. I .EQ. 4 .OR. I .EQ. 6) .AND.
     $       ZELEV .EQ. 0.0) THEN
              WP(I) = WP(I-1)
           ELSE
             CALL WPDF(EFFSH(I),BOUNCE(I),WP(I),WY(I),ZELEV,U)
           ENDIF
262      CONTINUE
         WP(3) = -WP(3)
         WP(4) = -WP(4)
       
C  CALCULATE PROBABILITY FOR EACH PATH
        DO 264 I = 1,6
          IF (WP(I) .EQ. -999)  THEN 
            PW(I) = 0.0
          ELSE
            WPMWH = WP(I) - WHAT
            IF (WPMWH .GE. 0.0) THEN
              ARG = WPMWH**2/(2.0*SWPLUS**2)
            ELSE
              ARG = WPMWH**2/(2.0*SWMINUS**2)
            ENDIF

            IF (ARG .GT. 30.0) THEN
              PW(I) = 0.0
            ELSE
              PW(I) = GM * EXP(-ARG)
            ENDIF
          ENDIF
264     CONTINUE


          PWTOT = 0.0
          DO 267 I = 1,6 
267         PWTOT = PWTOT + PW(I)      

        ENDIF

268     CONTINUE                             

C CALCULATE CWIC FOR CASES WHERE BIGX < 4
        CWIC = QS * PWTOT/XP


C THIS DECISION ALLOWS USE OF PDF CALCULATION OF Y OR D TO BE USED IN HDF

269     IF (NHL .EQ. 0) THEN
          CALL SIGMAY(DTHETA,XP,YCROSS,RISE,SIGY,HDF,BIGX)
        ELSE IF (IBLOCK .EQ. 1) THEN
          CALL SIGMAY(DTHETA,XP,D,RISE,SIGY,HDF,BIGX)
        ELSE 
          YPDF = YSEPL - WY(1)
          CALL SIGMAY(DTHETA,XP,YPDF,RISE,SIGY,HDF,BIGX)
        END IF


        C = 1000000.0 * CWIC * HDF   


       IF(ICASE .GT. 1) THEN
         WRITE(IOUT,336) NR,XP,YCROSS,TRISE,SIGY,HDF,CWIC,C
         NLINES=NLINES+2
       ENDIF    


250    CONC(NR) = CONC(NR) + C
       SCONC(NR,NS) = SCONC(NR,NS) + C
                       

       IF(ICASE .GT. 1 .AND. NLINES .GE. MAXLIN-3) THEN
         CALL PAGE(YES)
         WRITE(IOUT,335) GSGS(ICHIQ+1)
         NLINES = NLINES + 5
       ENDIF

C IF WE CALLED TRANPR (ITRANPR = 1) THE RESET THE EFFSH ARRAY USING
C FINAL PLUME HEIGHT (HPL) FOR NXT RECEPTOR 
        IF (ITRANPR .GT. 0) THEN
          EFFSH(1) = HPL
          EFFSH(2) = HPL
          EFFSH(3) = 2.0*XMH - HPL
          EFFSH(4) = 2.0*XMH - HPL
          EFFSH(5) = 2.0*XMH + HPL
          EFFSH(6) = 2.0*XMH + HPL
        ENDIF

260    CONTINUE

       IF (IREC .EQ. 0) THEN
         IF (NHL .EQ. 0) THEN
           IF (ICASE .GT. 1) WRITE (IOUT,344)
         ELSE
           IF (ICASE .GT. 1) WRITE(IOUT,343) NHL
         ENDIF
       ENDIF

270    CONTINUE

280    RETURN

329    FORMAT(/,/,' PLUME LAYER AVERAGE VARIABLES:',/,
     X         '     HT        WD        WS')
330    FORMAT(2X,F7.1,5X,F5.1,4X,F5.2)
331    FORMAT(/,/,' CONVECTIVE SCALING PARAMETERS:',/,
     X   '  USTAR     WSTAR     FSTAR')
332    FORMAT(1X,F6.4,4X,F6.4,4X,F6.4,/,/)

333    FORMAT(/,/,15X,'<------------ SOURCE INFORMATION ----------->',
     X  /,' SOURCE     QS       TS      VS      BUOY FLUX    ',
     X  '   MOM FLUX      PENETR',
     X  /,'   #       (G/S)    (K)    (M/S)    (M**4/S**3)   ',
     x  '  (M**4/S**3)    FACTOR')
334    FORMAT(I4,2X,F9.1,2X,F7.1,2X,F6.2,2X,F9.1,7X,F9.1,4X,F10.4)
335    FORMAT(/,' REC  DWN-WND  CRS-WND  TRANS    SIGMA',
     X            '      HDF          CWIC           CONC',
     X        /,'  #    DIST     DIST    RISE       Y  ',
     X        /,'       (M)       (M)     (M)      (M) ',
     X            '     (1/M)        (G/M**3)    (U',A1,'/M**3)') 
336    FORMAT(/,I4,F8.1,1X,F8.1,2X,F6.1,3X,F6.1,3X,1PE10.4,4X,
     X    1PE10.4,4X,1PE10.4)

337    FORMAT(/,'  SOURCE INFORMATION ADJUSTED FOR PENETRATION:',/,
     X          '    SOURCE     QS        BUOY FLUX',/,
     X          '      #       (G/S)     (M**4/S**3)',/,
     X           4X,I4,2X,F9.1,5X,F9.1)
338    FORMAT(/,1X,I4,'  RECEPTOR ABOVE ADJUSTED MIXING HEIGHT, ',
     X         '= ',F6.2,'CONCENTRATION = ',F3.1)
340    FORMAT(/,1X,'TOTAL PENETRATION WAS DETERMINED FOR STACK ',
     X    I2,' DURING YR/MO/DY/HR ',I2,'/',I2,'/',I2,'/',I2,/,1X,
     X    'CONTRIBUTION FROM THIS SOURCE IS SET TO 0',/)
341    FORMAT(/,1X,'RESULTS FOR HILL # ',I4)
342    FORMAT(/,1X,'RESULTS FOR RECEPTORS IN FLAT TERRAIN')
343    FORMAT(/,1X,'NO RECEPTORS MODELED ON HILL ',I3,' THIS HOUR.')
344    FORMAT(/,1X,'NO RECEPTORS MODELED IN FLAT TERRAIN THIS HOUR.')
6171    FORMAT(/,2X,'POSITION OF HILL ',I2,' IS UPWIND OF SOURCE ',
     1  I2,' FOR DAY ',I2,'/',I2,'/',I2,'/',' HR ',I2,' .',/,2X,
     2  'CONCENTRATIONS SET TO ZERO FOR ALL RECEPTORS ON ',
     3  'THIS HILL.')

       END
