      SUBROUTINE DEFLECT(ZIH,HFR,DZIH)
C ***************************************************************
C THIS SUBROUTINE INTERPOLATES TO FIND THE Zi DEFLECTION BASED 
C ON THE FMF STUDY BY PERRY AND SNYDER (1989).
C VALUES IN FROUDES1, ZIHVALS1, AND ZFRMAT1 ARE FOR THE ELONGATED
C HILL. VALUES IN FROUDES2, ZIHVALS2, AND ZFRMAT2 ARE FOR THE
C AXISYMMWTRIC HILL. 
C ***************************************************************
       INCLUDE 'PARAMS.INC'
       INCLUDE 'PASL.CMN'

       INTEGER FR1,FR3,ZIH1,ZIH3

       REAL ZFRMAT1(8,6),ZFRMAT2(8,7),FROUDES1(8),FROUDES2(8),
     $    ZIHVALS1(6),ZIHVALS2(7),NEW1,NEW2,NEWHFR,NEWZIH, ZIH,
     $    HFR, DZIH, VAL1, VAL2, VAL3, VAL4, DZIH1, DZIH2, HRATIO

       DATA FROUDES1/0.1,0.2,0.3,0.4,0.91,1.55,1.88,2.24/
       DATA FROUDES2/0.1,0.2,0.3,0.4,0.9,1.54,1.86,2.21/
       DATA ZIHVALS1/0.1,0.3,0.5,1.01,1.49,1.79/
       DATA ZIHVALS2/0.1,0.3,0.54,1.03,1.20,1.47,1.84/
       DATA ZFRMAT1/0.10,0.20,0.30,0.55,0.90,1.10,1.16,1.18,
     $              0.10,0.20,0.30,0.55,0.75,0.94,1.00,1.04,
     $              0.10,0.20,0.30,0.55,0.58,0.79,0.85,0.87,
     $              0.10,0.20,0.30,0.32,0.49,0.54,0.68,0.72,
     $              0.10,0.20,0.21,0.21,0.39,0.41,0.62,0.70,
     $              0.10,0.18,0.18,0.18,0.30,0.31,0.58,0.58/
       DATA ZFRMAT2/0.10,0.20,0.30,0.51,0.90,1.04,1.08,1.16,
     $              0.10,0.20,0.30,0.51,0.75,0.88,0.94,1.04,
     $              0.10,0.20,0.30,0.51,0.61,0.74,0.79,0.88,
     $              0.10,0.20,0.23,0.23,0.43,0.51,0.61,0.68,
     $              0.10,0.18,0.18,0.18,0.36,0.41,0.55,0.60,
     $              0.10,0.10,0.10,0.10,0.30,0.32,0.52,0.56,
     $              0.09,0.09,0.09,0.09,0.23,0.25,0.47,0.48/


C  DO THE INTERPOLATION USING THE VALUES FOR THE ASYMMETRIC HILL
C  USE KLOSE TO FIND POSITION IN FROUDES ARRAY AND ZIHVALS ARRAY
C  OF VALUES CALCULATED IN GETFR. IF HFR OR ZIH OUT OF DATA RANGE,
C  SET EQUAL TO CLOSEST DATA VALUE
        
       FR1 = KLOSE(FROUDES1,8,HFR)
       IF (FR1 .EQ. 0) THEN
         FR1 = 1
         NEWHFR = 0.1
         FR3 = FR1
       ELSEIF (FR1 .EQ. 8) THEN
         NEWHFR = 2.24
         FR3 = FR1
       ELSE
         FR3 = FR1 + 1
         NEWHFR = HFR
       ENDIF         
       

       ZIH1 = KLOSE(ZIHVALS1,6,ZIH)
       IF (ZIH1 .EQ. 0) THEN
         ZIH1 = 1
         NEWZIH = 0.1
         ZIH3 = ZIH1
       ELSEIF (ZIH1 .EQ. 6) THEN
         NEWZIH = 1.79
         ZIH3 = ZIH1
       ELSE
         ZIH3 = ZIH1 + 1
         NEWZIH = ZIH
       ENDIF
 
       VAL1 = ZFRMAT1(FR1,ZIH1)
       VAL2 = ZFRMAT1(FR3,ZIH1)
       VAL3 = ZFRMAT1(FR1,ZIH3)
       VAL4 = ZFRMAT1(FR3,ZIH3)


C INTERPOLATE BETWEEN THESE VALUES TO GET THE NEW VALUES
       NEW1 = XINTRP(FROUDES1(FR1),FROUDES1(FR3),NEWHFR,VAL1,VAL2)
       NEW2 = XINTRP(FROUDES1(FR1),FROUDES1(FR3),NEWHFR,VAL3,VAL4)

C INTERPOLATE BETWEEN THESE VALUES TO FIND THE DEFLECTION/h
       DZIH1 = XINTRP(ZIHVALS1(ZIH1),ZIHVALS1(ZIH3),NEWZIH,NEW1,NEW2)

C  DO THE INTERPOLATION USING THE DATA FROM THE AXISYMMETRIC HILL
C  USE KLOSE TO FIND POSITION IN FROUDES ARRAY AND ZIHVALS ARRAY
C  OF VALUES CALCULATED IN GETFR. IF HFR OR ZIH OUT OF DATA RANGE,
C  SET EQUAL TO CLOSEST DATA VALUE
        
       FR1 = KLOSE(FROUDES2,8,HFR)
       IF (FR1 .EQ. 0) THEN
         FR1 = 1
         NEWHFR = 0.1
         FR3 = FR1
       ELSEIF (FR1 .EQ. 8) THEN
         NEWHFR = 2.21
         FR3 = FR1
       ELSE
         FR3 = FR1 + 1
         NEWHFR = HFR
       ENDIF         

       ZIH1 = KLOSE(ZIHVALS2,7,ZIH)
       IF (ZIH1 .EQ. 0) THEN
         ZIH1 = 1
         NEWZIH = 0.1
         ZIH3 = ZIH1
       ELSEIF (ZIH1 .EQ. 7) THEN
         NEWZIH = 1.84
         ZIH3 = ZIH1
       ELSE
         NEWZIH = ZIH
         ZIH3 = ZIH1 + 1
       ENDIF
 
       VAL1 = ZFRMAT2(FR1,ZIH1)
       VAL2 = ZFRMAT2(FR3,ZIH1)
       VAL3 = ZFRMAT2(FR1,ZIH3)
       VAL4 = ZFRMAT2(FR3,ZIH3)


C INTERPOLATE BETWEEN THESE VALUES TO GET THE NEW VALUES
       NEW1 = XINTRP(FROUDES2(FR1),FROUDES2(FR3),NEWHFR,VAL1,VAL2)
       NEW2 = XINTRP(FROUDES2(FR1),FROUDES2(FR3),NEWHFR,VAL3,VAL4)

C INTERPOLATE BETWEEN THESE VALUES TO FIND THE DEFLECTION/h
       DZIH2 = XINTRP(ZIHVALS2(ZIH1),ZIHVALS2(ZIH3),NEWZIH,NEW1,NEW2)

C  NOW INTERPOLATE BETWEEN DZIH1 AND DZIH2 BASED ON THE LENGTH SCALES
C  OF THE HILL IN THE ALONG FLOW AND CROSS FLOW DIRECTIONS ,LX AND LY.
C  IF LY/LX <= 1 THEN DZIH = DZIH2 , IF LY/LX >=2 THEN DZIH = DZIH1
       HRATIO = LY/LX
       IF (HRATIO .LE. 1.0) THEN 
         DZIH = DZIH2
       ELSEIF (HRATIO .GE. 2.0) THEN
         DZIH = DZIH1
       ELSE
         DZIH = XINTRP(1.0,2.0,HRATIO,DZIH2,DZIH1)
       ENDIF 

       RETURN
       END

