      SUBROUTINE DTHDZ(DFLAG,PTZI,VDTHDZ,XMH)
C *******************************************************************
C THIS PROGRAM READS THE RAWIN FILE (WHICH READ62 CREATES FOR METPRO)
C TO GET THE TEMPERATURE PROFILE.  THE TEMPERATURES ARE CONVERTED 
C TO POTENTIAL TEMPERATURES. DTHETA/DZ IS FOUND FOR THE LAYER
C Zi TO Zi+500M AND THE POT TEMP IS FOUND AT STACK HEIGHT.
C
C ARGUMENTS:
C   PASSED   : DFLAG     INT    FLAG FOR NEQ OR OLD DAY
C   RETURNED : PTZI      REAL   POTENTIAL TEMPERATURE AT Zi
C              VDTHDZ    REAL   DTHETA/DZ FROM Zi TO Zi+500M (DEG/M)
C ******************************************************************

C      INCLUDE  'SFCMET.CMN'
      INCLUDE  'TIME.CMN'
      INCLUDE  'IO.CMN'

      INTEGER YEAR,MONTH,DAY,I,ITIME,NLEV,ILEV,LEV,DFLAG,
     X     YEAR2,MONTH2,DAY2
      REAL PRES,ZFIRST,ZHT,ZTEMP,POTEMP,PT1,PT3,Z1,Z3
      REAL DX,DZ,PTZI,PTZI500,VDTHDZ,XMH
      DIMENSION ZHT(80),ZTEMP(80),POTEMP(80),PRES(80)

C SAVE THE VARIABLES FOR NEXT HOUR (SOME COMPILERS WILL RESET THEM)
      SAVE PRES,ZHT,ZTEMP,YEAR,MONTH,DAY,ITIME,NLEV

C    DECIDE TO READ NEW SECTION OF FILE, BASED ON WHETHER DFLAG=0
C    (OLD DAY) OR DFLAG=1 (NEW DAY)
      IF (DFLAG.EQ.1) THEN 
            GO TO 100
      ELSE 
            GO TO 125
      END IF 

C READ THE VALUES FROM THE FILE; ONLY KEEP 12Z
100   READ(INRAW,1000) YEAR,MONTH,DAY,ITIME,NLEV
1000  FORMAT(22X,4(I2),38X,I2)
      READ(INRAW,1100) (PRES(I),ZHT(I),ZTEMP(I),
     X           I=1,NLEV)
1100  FORMAT(4(3X,F6.1,1X,F5.0,1X,F5.1,8X))

C  CHECK FOR DATE INCONSISTANCIES BETWN RAWIN AND SURFACE
      IF(YEAR.NE.KYR .OR. MONTH.NE.KMO .OR. DAY.NE.KDY) THEN
           YEAR2 = YEAR +1
           MONTH2 = MONTH -11
           DAY2 = DAY-31
           IF (YEAR.NE.KYR) THEN
              IF ((YEAR2.EQ.KYR) .AND. ((MONTH2).LE.KMO) 
     X            .AND. ((DAY2).LE.KDY)) THEN
                GO TO 100
              ELSE
                GO TO 105
              END IF
           END IF
           IF (MONTH.NE.KMO) THEN
              MONTH2 = MONTH + 1
              IF ((MONTH2).LE.KMO .AND.(DAY2).LT.KDY) THEN
                 GO TO 100
              ELSE
                 GO TO 105
              END IF
           END IF
           IF (DAY.LT.KDY) THEN 
              GO TO 100
           ELSE 
              GO TO 105
           END IF  

105       WRITE(IOUT,1200)YEAR,MONTH,DAY,ITIME,KYR,KMO,KDY,KHR 
1200    FORMAT(/,1X,'DISAGREEMENT IN RAWIN VS. SURFACE DATA: ',
     X  /,10X,'RAWIN DATA DATE IS ',4(I2),/,10X,'SURFACE DATA
     X DATE IS ',4(I2))
           STOP
      ENDIF

      IF(ITIME.NE.12) GO TO 100
                           
C COMPUTE THE POTENTIAL TEMPERATURES AND HEIGHTS

125   ZFIRST=ZHT(1)
      DO 150 ILEV = 1,NLEV
        POTEMP(ILEV) = ZTEMP(ILEV)*(1000./PRES(ILEV))**0.285714
        ZHT(ILEV) = ZHT(ILEV) - ZFIRST
150   CONTINUE 

      LEV = KLOSE(ZHT,NLEV,XMH)
      IF (LEV.EQ.0) THEN
        Z1 = ZHT(1)
        PT1 = POTEMP(1)
      ELSE
        Z1 = ZHT(LEV)
        PT1 = POTEMP(LEV)
      ENDIF

C INTERPOLATE TO GET POT. TEMP AT Zi - PTZI 
      IF (LEV.GE.1 .AND. LEV.LT.NLEV) THEN
        PT3 = POTEMP(LEV+1)
        Z3  = ZHT(LEV+1)
        DX  = PT3 - PT1
        DZ = Z3 - Z1
        PTZI = PT1 + (XMH-Z1)*(DX/DZ)
      ELSE
        PTZI = PT1
      ENDIF


C GET POT. ZTEMP AT Zi + 500M - PTZI500
      LEV = KLOSE(ZHT,NLEV,XMH+500)             
      IF (LEV.EQ.0) THEN
        Z1 = ZHT(1)
        PT1 = POTEMP(1)
      ELSE                  
        Z1 = ZHT(LEV)
        PT1 = POTEMP(LEV)
      ENDIF

      IF (LEV.GE.1 .AND. LEV.LT.NLEV) THEN
        PT3 = POTEMP(LEV+1)
        Z3  = ZHT(LEV+1)
        DX = PT3 - PT1
        DZ = Z3 - Z1
        PTZI500 = PT1 + (XMH+500-Z1)*(DX/DZ)
      ELSE
        PTZI500 = PT1
      ENDIF

C GET DTH/DZ FOR Zi TO Zi+500M
      VDTHDZ = (PTZI500 - PTZI)/500.

      RETURN
      END
